/* GNOME DB library
 * Copyright (C) 1999-2001 The Free Software Foundation
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#if !defined(__gnome_db_grid_h__)
#  define __gnome_db_grid_h__

#include <gtk/gtkvbox.h>
#include <libgda/gda-data-model.h>

G_BEGIN_DECLS

#define GNOME_DB_TYPE_GRID            (gnome_db_grid_get_type())
#define GNOME_DB_GRID(obj)            (G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_DB_TYPE_GRID, GnomeDbGrid))
#define GNOME_DB_GRID_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST (klass, GNOME_DB_TYPE_GRID, GnomeDbGridClass))
#define GNOME_DB_IS_GRID(obj)         (G_TYPE_CHECK_INSTANCE_TYPE (obj, GNOME_DB_TYPE_GRID))
#define GNOME_DB_IS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_DB_TYPE_GRID))

typedef struct _GnomeDbGrid        GnomeDbGrid;
typedef struct _GnomeDbGridClass   GnomeDbGridClass;
typedef struct _GnomeDbGridPrivate GnomeDbGridPrivate;

struct _GnomeDbGrid {
	GtkVBox parent;
	GnomeDbGridPrivate *priv;
};

struct _GnomeDbGridClass {
	GtkVBoxClass parent_class;

	void (* row_selected) (GnomeDbGrid *grid, gint row);
	void (* row_unselected) (GnomeDbGrid *grid);
};

GType         gnome_db_grid_get_type (void);
GtkWidget    *gnome_db_grid_new (void);
GtkWidget    *gnome_db_grid_new_with_model (GdaDataModel *model);

GdaDataModel *gnome_db_grid_get_model (GnomeDbGrid *grid);
void          gnome_db_grid_set_model (GnomeDbGrid *grid, GdaDataModel *model);

void          gnome_db_grid_hide_column_titles (GnomeDbGrid *grid);
void          gnome_db_grid_show_column_titles (GnomeDbGrid *grid);

G_END_DECLS

#endif
