/* GNOME DB VFS access module
 * Copyright (C) 1999-2002 The GNOME Foundation.
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <libgda/libgda.h>
#include <bonobo/bonobo-i18n.h>
#include "dbclient.h"
#include "dbvfs.h"

GnomeVFSMethod *vfs_module_init (void);
void vfs_module_shutdown (GnomeVFSMethod *method);

/*
 * GNOME VFS public interface
 */

static GnomeVFSMethod db_method = {
	sizeof (GnomeVFSMethod),
        dbvfs_do_open,
        dbvfs_do_create,
        dbvfs_do_close,
        dbvfs_do_read,
        dbvfs_do_write,
        dbvfs_do_seek,
        dbvfs_do_tell,
        dbvfs_do_truncate_handle,
        dbvfs_do_open_directory,
        dbvfs_do_close_directory,
        dbvfs_do_read_directory,
        dbvfs_do_get_file_info,
        dbvfs_do_get_file_info_from_handle,
        dbvfs_do_is_local,
        dbvfs_do_make_directory,
        dbvfs_do_remove_directory,
        dbvfs_do_move,
        dbvfs_do_unlink,
        dbvfs_do_check_same_fs,
        dbvfs_do_set_file_info,
        dbvfs_do_truncate,
        dbvfs_do_find_directory,
        dbvfs_do_create_symbolic_link
};

GnomeVFSMethod *vfs_module_init (void)
{
	static gboolean initialized = FALSE;

	if (!initialized) {
		bindtextdomain(GETTEXT_PACKAGE, LIBGNOMEDB_LOCALEDIR);
		bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	}
	
	gda_init (_("GNOME VFS database: module"), VERSION, 0, NULL);
	dbclient_init ();
	initialized = TRUE;

	return &db_method;
}

void vfs_module_shutdown (GnomeVFSMethod *method)
{
	dbclient_shutdown ();
}
