// -*- C++ -*-

/* 
 * gfont.h 
 *
 * Copyright (C) 1998 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@emccta.com>.
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef GUPPI_GFONT_H
#define GUPPI_GFONT_H

#include "gnome-util.h"
#include "vfont.h"

class GFontInternal;

class GFont : public VFont {
public:
  GFont();
  virtual ~GFont();

  // Return the width of string str, unscaled.
  virtual double string_width(const gchar* str);

  // Return the height of the font, unscaled.
  virtual double font_height();

  // Return an X font that's nice for displaying at the given scale.
  // Scale is 1.0 for 1:1 ratio
  // If you're going to keep the GdkFont around, you should gdk_font_ref() it
  //  probably.
  GdkFont* gdk_font(double scale);
  
private:
  GFontInternal* internal_;

  const GFont& operator=(const GFont&);
  GFont(const GFont &);
};

#endif
