// -*- C++ -*-

/* 
 * data.cc
 *
 * Copyright (C) 1998 EMC Capital Management, Inc.
 *
 * Developed by Jon Trowbridge <trow@emccta.com> and
 * Havoc Pennington <hp@emccta.com>.
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#include "data.h"

Data::Data()
  : type_(DataTypeEnd)
{

}

Data::Data(DataType type) 
  : type_(type)
{

}

Data::~Data()
{
#ifdef DEBUG_RC
  g_debug("Destroying data %p refcount %u", this, rc_.count());
#endif
}

ScalarData* 
Data::cast_to_scalar()
{
  if (type_ != Scalar) return 0;
  return reinterpret_cast<ScalarData*>(this);
}

CategoricalData* 
Data::cast_to_categorical()
{
  if (type_ != Categorical) return 0;
  return reinterpret_cast<CategoricalData*>(this);
}

DateData* 
Data::cast_to_date()
{
  if (type_ != Date) return 0;
  return reinterpret_cast<DateData*>(this);
}

LabelData* 
Data::cast_to_label()
{
  if (type_ != Label) return 0;
  return reinterpret_cast<LabelData*>(this);
}

guint
Data::ref()
{
#ifdef DEBUG_RC
  g_debug("Referencing data %p oldcount %u", this, rc_.count());
#endif
  return rc_.ref();
}

guint
Data::unref()
{

#ifdef DEBUG_RC
  g_debug("Unreferencing data %p oldcount %u", this, rc_.count());
#endif

  return rc_.unref();
}
