#include <stdlib.h>
#include <stdint.h>
#include "wayland-util.h"

extern const struct wl_interface gtk_surface_interface;
extern const struct wl_interface wl_surface_interface;

static const struct wl_interface *types[] = {
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	&gtk_surface_interface,
	&wl_surface_interface,
};

static const struct wl_message gtk_shell_requests[] = {
	{ "get_gtk_surface", "no", types + 6 },
};

static const struct wl_message gtk_shell_events[] = {
	{ "capabilities", "u", types + 0 },
};

const struct wl_interface gtk_shell_interface = {
	"gtk_shell", 1,
	1, gtk_shell_requests,
	1, gtk_shell_events,
};

static const struct wl_message gtk_surface_requests[] = {
	{ "set_dbus_properties", "?s?s?s?s?s?s", types + 0 },
};

const struct wl_interface gtk_surface_interface = {
	"gtk_surface", 1,
	1, gtk_surface_requests,
	0, NULL,
};

