/* GnoRPM - A GNOME front end for the Redhat Package Manager (RPM)
 * Copyright (C) 1998-1999  James Henstridge
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef __RPM_INSTALL_DLG_H__
#define __RPM_INSTALL_DLG_H__

#include <gnome.h>
#include <rpmlib.h>
#include "dbhandle.h"

#define RPM_INSTALL_DIALOG(obj) GTK_CHECK_CAST(obj, rpm_install_dialog_get_type(), RpmInstallDialog)
#define RPM_Install_DIALOG_CLASS(class) GTK_CHECK_CAST_CLASS(class, rpm_install_dialog_get_type(), RpmInstallDialogClass)
#define RPM_IS_INSTALL_DIALOG(obj) GTK_CHECK_TYPE(obj, rpm_install_dialog_get_type())

typedef struct _RpmInstallDialog RpmInstallDialog;
typedef struct _RpmInstallDialogClass RpmInstallDialogClass;

struct _RpmInstallDialog {
  GtkDialog parent;
  GtkWidget *list;  /* the list of packages to install */
  GtkWidget *filesel;  /* the file selection dialog */
  DBHandle *hdl;  /* this is needed so that we can shut down the database
		   * before doing an install */
};

struct _RpmInstallDialogClass {
  GtkDialogClass parent_class;

  /* the argument is a GList of strings representing the file names */
  void (*    query)(RpmInstallDialog *dlg, GList *files);
  void (*  install)(RpmInstallDialog *dlg, GList *files);
  void (* checksig)(RpmInstallDialog *dlg, GList *files);
};

guint rpm_install_dialog_get_type(void);
GtkWidget *rpm_install_dialog_new(DBHandle *hdl);
void rpm_install_dialog_add_file(RpmInstallDialog *self, gchar *file);

#endif

