/***************************************
 Various server communication functions
 (c) 1999 Jeremy Wise
 GnomeICU
****************************************/

/*** GnomeICU header files ***/
#include "common.h"

/*** Toplevel header files ***/
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#ifdef HAVE_SOCKS5
#define SOCKS
#include <socks.h>
#endif
              
/*
 * Connect to 'hostname' on port 'port'
 * 'hostname' can be DNS or n.n.n.n
 */
 
int Connect_Remote( char *hostname, int port, FD_T aux )
{
	int conct, length;
	int sok;

	/* Used for inet address */
	struct sockaddr_in sin;

	/* Used for DNS lookup */
	struct hostent *host_struct;
   
	/* Check for n.n.n.n notation */
	sin.sin_addr.s_addr = inet_addr( hostname );

#ifdef TRACE_FUNCTION
	g_print( "Connect_Remote\n" );
#endif

	/* If name isn't n.n.n.n, it must be DNS */
	host_struct = gethostbyname( hostname );

		if ( host_struct == NULL )
		{
			icq_set_status_offline( NULL, NULL );
			return 0;
		}

	sin.sin_addr = *( ( struct in_addr * )host_struct->h_addr );

	/* Use inet, not AppleTalk */
	sin.sin_family = AF_INET;
	
	/* Port */
	sin.sin_port = g_htons( port );

	/* Create unconnected socket */
	sok = socket( AF_INET, SOCK_DGRAM, 0 );

	if ( sok == -1 )
	  g_error( _("Could not create socket\n") );

	conct = connect( sok, ( struct sockaddr * ) &sin, sizeof( sin ) );

	/* Connection Failure */
	if ( conct == -1 )
		g_error( _("Could not connect to socket\n") );
	
	length = sizeof( sin ) ;
	getsockname( sok, ( struct sockaddr * ) &sin, &length );
	our_ip   = g_ntohl (sin.sin_addr.s_addr);
/*
	if( !our_port )
		our_port = g_htons( sin.sin_port );
*/
	if( been_thru_init == FALSE )
		init();

	/* Connected */
	return sok;
}

/* Handle packets from Server */
void Multi_Packet( BYTE *pdata )
{
	int num_pack, i;
	int len;
	BYTE *j;
	srv_net_icq_pak pak;
	num_pack = (unsigned char) pdata[ 0 ];
	j = pdata;
	j++;

#ifdef TRACE_FUNCTION
	g_print( "Multi_Packet(%d)\n", num_pack );
#endif

	for( i = 0; i < num_pack; i ++ )
	{
		len = Chars_2_Word( j );
		memcpy( &pak, j, sizeof( pak ) );
		j += 2;
		Server_Response( pak, (len+2) - sizeof( pak.head ), Chars_2_Word( pak.head.cmd ),
		                 Chars_2_Word( pak.head.ver ), Chars_2_Word( pak.head.seq ),
		                 Chars_2_DW( pak.head.UIN ), len );
		j += len;
	}
}

void Server_Response( srv_net_icq_pak pak, DWORD len, WORD cmd, WORD ver, WORD seq, UIN_T uin, DWORD s )
{
	SIMPLE_MESSAGE_PTR s_mesg;
	int old_status;

#ifdef TRACE_FUNCTION
	g_print( "Server_Response(%08x)\n", cmd );
#endif
   
	switch ( cmd )
	{
		case SRV_META_USER:
			packet_print( pak.head.ver, s,
	  		            PACKET_TYPE_UDP | PACKET_DIRECTION_RECEIVE, "SRV_META_USER" );
			Meta_User( pak.data, len, Chars_2_Word( pak.head.seq2 ) );
			ack_srv( Chars_2_Word( pak.head.seq ) );
			break;
		case SRV_MULTI_PACKET:
			packet_print( pak.head.ver, s,
	  		            PACKET_TYPE_UDP | PACKET_DIRECTION_RECEIVE, "SRV_MULTI_PACKET" );
			Multi_Packet( pak.data );
			ack_srv( Chars_2_Word( pak.head.seq ) );
			break;
		case SRV_ACK:
			packet_print( pak.head.ver, s,
	  		            PACKET_TYPE_UDP | PACKET_DIRECTION_RECEIVE, "SRV_ACK" );
			Check_Queue( seq );
			break;
		case SRV_NEW_UIN:
			packet_print( pak.head.ver, s,
	  		            PACKET_TYPE_UDP | PACKET_DIRECTION_RECEIVE, "SRV_NEW_UIN" );
			ack_srv( Chars_2_Word( pak.head.seq ) );
			our_info->uin = Chars_2_DW( pak.head.UIN );
			seq_num = 1;
			if( MainData->sok )
				close( MainData->sok );
			MainData->sok = Connect_Remote( server, remote_port, STDERR );
			Login( passwd, our_ip, our_port );
			break;
		case SRV_LOGIN_REPLY:
			packet_print( pak.head.ver, s,
	  		            PACKET_TYPE_UDP | PACKET_DIRECTION_RECEIVE, "SRV_LOGIN_REPLY" );
			our_ip = IP_2_DW( &pak.data[0] );
			log_window_add( _("Connected to ICQ Server"), our_info->uin );
			Current_Status = preset_status | (toggles->webpresence*0x10000);
			applet_update( Current_Status, NULL );
			ready_set();

			ack_srv( Chars_2_Word( pak.head.seq ) );
			snd_login_1();
			snd_contact_list();
			snd_invis_list();
			snd_vis_list();
			break;
		case SRV_RECV_MESSAGE:
			packet_print( pak.head.ver, s,
	  		            PACKET_TYPE_UDP | PACKET_DIRECTION_RECEIVE, "SRV_RECV_MESSAGE" );
			Recv_Message( pak );
			ack_srv( Chars_2_Word( pak.head.seq ) );
			break;
		case SRV_X1:
			packet_print( pak.head.ver, s,
	  		            PACKET_TYPE_UDP | PACKET_DIRECTION_RECEIVE, "SRV_X1(Done Contact List)" );
			ack_srv( Chars_2_Word( pak.head.seq ) );
			applet_update( Current_Status, NULL );
			ready_set();
			enable_online_events = TRUE;
			if( toggles->webpresence )
				icq_sendwebpresence();
			ack_srv( Chars_2_Word( pak.head.seq ) );
			break;
		case SRV_X2:
			packet_print( pak.head.ver, s,
	  		            PACKET_TYPE_UDP | PACKET_DIRECTION_RECEIVE, "SRV_X2(Done Old Messages)" );
			Show_Quick_Status();
			Done_Login = TRUE;
			ack_srv( Chars_2_Word( pak.head.seq ) );
			snd_got_messages();
			is_new_user = FALSE;
			break;
		case SRV_INFO_REPLY:
			packet_print( pak.head.ver, s,
	  		            PACKET_TYPE_UDP | PACKET_DIRECTION_RECEIVE, "SRV_INFO_REPLY" );
			Display_Info_Reply( pak );
			ack_srv( Chars_2_Word( pak.head.seq ) );
			break;
		case SRV_EXT_INFO_REPLY:
			packet_print( pak.head.ver, s,
	  		            PACKET_TYPE_UDP | PACKET_DIRECTION_RECEIVE, "SRV_EXT_INFO_REPLY" );
			Display_Ext_Info_Reply( pak );
			ack_srv( Chars_2_Word( pak.head.seq ) );
			break;
		case SRV_USER_OFFLINE:
			packet_print( pak.head.ver, s,
	  		            PACKET_TYPE_UDP | PACKET_DIRECTION_RECEIVE, "SRV_USER_OFFLINE" );
			User_Offline( pak );
			ack_srv( Chars_2_Word( pak.head.seq ) );
			break;
		case SRV_USER_ONLINE:
			packet_print( pak.head.ver, s,
	  		            PACKET_TYPE_UDP | PACKET_DIRECTION_RECEIVE, "SRV_USER_ONLINE" );
			User_Online( pak );
			ack_srv( Chars_2_Word( pak.head.seq ) );
			break;
		case SRV_STATUS_UPDATE:
			packet_print( pak.head.ver, s,
	  		            PACKET_TYPE_UDP | PACKET_DIRECTION_RECEIVE, "SRV_STATUS_UPDATE" );
			Status_Update( pak );
			ack_srv( Chars_2_Word( pak.head.seq ) );
			break;
		case SRV_TRY_AGAIN:
			packet_print( pak.head.ver, s,
	  		            PACKET_TYPE_UDP | PACKET_DIRECTION_RECEIVE, "SRV_TRY_AGAIN" );
			seq_num = 1;
			Login( passwd, our_ip, our_port );
			break;
		case SRV_FORCE_DISCONNECT:
			packet_print( pak.head.ver, s,
	  		            PACKET_TYPE_UDP | PACKET_DIRECTION_RECEIVE, "SRV_FORCE_DISCONNECT" );
		case SRV_GO_AWAY:
			if( cmd == SRV_GO_AWAY )
				packet_print( pak.head.ver, s,
		  		            PACKET_TYPE_UDP | PACKET_DIRECTION_RECEIVE, "SRV_GO_AWAY" );
			log_window_add( _("Server forced disconnect"), our_info->uin );
			old_status = Current_Status != STATUS_OFFLINE ? Current_Status : preset_status;
			icq_set_status_offline( NULL, NULL );
			switch( old_status & 0xffff )
			{
				case STATUS_ONLINE:
					icq_set_status_online( NULL, NULL ); break;
				case STATUS_AWAY:
					icq_set_status_away( NULL, NULL ); break;
				case STATUS_NA:
					icq_set_status_na( NULL, NULL ); break;
				case STATUS_FREE_CHAT:
					icq_set_status_ffc( NULL, NULL ); break;
				case STATUS_OCCUPIED:
					icq_set_status_occ( NULL, NULL ); break;
				case STATUS_DND:
					icq_set_status_dnd( NULL, NULL ); break;
				case STATUS_INVISIBLE:
					icq_set_status_invisible( NULL, NULL ); break;
			}
			break;

		case SRV_END_OF_SEARCH:
			packet_print( pak.head.ver, s,
	  		            PACKET_TYPE_UDP | PACKET_DIRECTION_RECEIVE, "SRV_END_OF_SEARCH" );
			ack_srv( Chars_2_Word( pak.head.seq ) );
			break;
		case SRV_USER_FOUND:
			packet_print( pak.head.ver, s,
	  		            PACKET_TYPE_UDP | PACKET_DIRECTION_RECEIVE, "SRV_USER_FOUND" );
			Display_Search_Reply( pak );
			ack_srv( Chars_2_Word( pak.head.seq ) );
			break;
		case SRV_SYS_DELIVERED_MESS:
			packet_print( pak.head.ver, s,
	  		            PACKET_TYPE_UDP | PACKET_DIRECTION_RECEIVE, "SRV_SYS_DELIVERED_MESS" );
			s_mesg = ( SIMPLE_MESSAGE_PTR ) pak.data;
			last_recv_uin = Chars_2_DW( s_mesg->uin );
			Do_Msg( time( NULL ), Chars_2_Word( s_mesg->type ), ( s_mesg->len + 2 ),
			        last_recv_uin, MESSAGE_TEXT );
			ack_srv( Chars_2_Word( pak.head.seq ) );

			if ( 0xfe != *( ((unsigned char *) s_mesg ) + sizeof( s_mesg ) ) )
			{
			}
			break;
		case SRV_BAD_PASSWORD:
			packet_print( pak.head.ver, s,
	  		            PACKET_TYPE_UDP | PACKET_DIRECTION_RECEIVE, "SRV_BAD_PASSWORD" );
			gnome_error_dialog( _("Bad password:\nThe password you've provided is incorrect.") );
			icq_set_status_offline( NULL, NULL );
			break;
		case SRV_UPDATE:
			packet_print( pak.head.ver, s,
	  		            PACKET_TYPE_UDP | PACKET_DIRECTION_RECEIVE, "SRV_UPDATE" );
			ack_srv( Chars_2_Word( pak.head.seq ) );
			break;
		case SRV_UPDATE_EXT:
			packet_print( pak.head.ver, s,
	  		            PACKET_TYPE_UDP | PACKET_DIRECTION_RECEIVE, "SRV_UPDATE_EXT" );
			ack_srv( Chars_2_Word( pak.head.seq ) );
			break;
		case SRV_AUTH_UPDATE:
			packet_print( pak.head.ver, s,
	  		            PACKET_TYPE_UDP | PACKET_DIRECTION_RECEIVE, "SRV_AUTH_UPDATE" );

			ack_srv( Chars_2_Word( pak.head.seq ) );
			break;
		default:
			/* Unhandled Commands */
			if( Chars_2_Word( pak.head.cmd ) == 0x001e )
				break;
			g_print( "\nThe response was %04X\t", Chars_2_Word( pak.head.cmd ) );
			g_print( "The version was %X\t", Chars_2_Word( pak.head.ver ) );
			g_print( "\nThe SEQ was %04X\t", Chars_2_Word( pak.head.seq ) );

			g_print( "The sizea was %u\n", len );
			packet_print( pak.head.ver, s,
			              PACKET_TYPE_UDP | PACKET_DIRECTION_RECEIVE, "UNKNOWN" );

			/* Fake */
			ack_srv( Chars_2_Word( pak.head.seq ) );
	}
}

void Handle_Server_Response( void )
{
   srv_net_icq_pak pak;
	static DWORD last_seq = -1;
   int s;

#ifdef TRACE_FUNCTION
	g_print( "Handle_Server_Response\n" );
#endif

   s = SOCKREAD( &pak.head.ver, sizeof( pak ) - 2  );

   if ( s < 0 )
      return;

	if( ( last_seq == Chars_2_Word( pak.head.seq ) ) &&
	    ( Chars_2_Word( pak.head.cmd ) != SRV_NEW_UIN ) )
   {
      if ( Chars_2_Word( pak.head.cmd ) != SRV_ACK ) /* ACKs don't matter */
      {
/*         ack_srv( Chars_2_Word( pak.head.seq ) );*/
         return;
      }
   }

   if ( Chars_2_Word( pak.head.cmd ) != SRV_ACK )
   {
		last_seq = Chars_2_Word( pak.head.seq );
/*      ack_srv( Chars_2_Word( pak.head.seq ) );*/
   }

	if( Chars_2_Word( pak.head.ver ) == 0x0003 )
		memcpy( &pak.head.cmd, &pak.head.zero, sizeof( WORD ) );

   Server_Response( pak, s - ( sizeof( pak.head ) - 2 ),
      Chars_2_Word( pak.head.cmd ), Chars_2_Word( pak.head.ver ),
      Chars_2_Word( pak.head.seq ), Chars_2_DW( pak.head.UIN ), s );
}
