/*******************************
 Logging functions
 (c) 1999 Jeremy Wise
 GnomeICU
********************************/

/*** GnomeICU header files ***/
#include "common.h"

/*** Toplevel header files ***/
#include <time.h>

/*** Global functions ***/
void log_window_add( const gchar *statement, UIN_T uin )
{
	char *strings[4];
	char who[32];
	time_t timedate;
	struct tm *my_tm;
	char ptime[16];
	char pdate[16];
	char *halves[] = { "AM", "PM" };
	int half = 0;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "log_window_add\n" );
#endif

	strings[ 0 ] = ptime;
	strings[ 1 ] = pdate;
	strings[ 2 ] = who;
	strings[ 3 ] = (gchar*)statement;

	time( &timedate );
	my_tm = localtime( &timedate );

	if( my_tm->tm_hour > 12 )
	{
		my_tm->tm_hour -= 12 ;
		half ++;
	}

	sprintf( ptime, "%02d:%02d:%02d %s", my_tm->tm_hour, my_tm->tm_min,
	         my_tm->tm_sec, halves[ half ] );
	sprintf( pdate, "%02d/%02d/%d", my_tm->tm_mon + 1, my_tm->tm_mday,
	         my_tm->tm_year + 1900 );
	
	contact = Find_User( uin );
	if( contact == NULL )
		sprintf( who, "%d", uin );
	else
		sprintf( who, "%s", kontakt->nick );

	gtk_clist_insert( GTK_CLIST( log_list ), 0, strings );
}
