/*****************************
 Drag & Drop support
 (c) 1999 Jeremy Wise
 GnomeICU
*****************************/

/* GnomeICU header files ***/
#include "common.h"

/*** Toplevel header files ***/
#include <ctype.h>
#include <libgnome/libgnome.h>
#include <string.h>
#include <gtk/gtk.h>

enum
{
  TARGET_URL
};

static GtkTargetEntry contact_list_drop_types[]=
{
  { "STRING", 0, TARGET_URL },
  { "text/plain", 0, TARGET_URL }
  /* ??  For some reason Netscape wants to send me stuff as text/plain */
};

static gint n_contact_list_drop_types=
  sizeof(contact_list_drop_types)/sizeof(contact_list_drop_types[0]);

/*** Local function declarations ***/
static void contact_list_dnd_drop(GtkWidget *widget, GdkDragContext *context,
                                  gint x, gint y, GtkSelectionData *selection_data,
                                  guint info, guint time, gpointer data);

/*** Global functions ***/
void init_contact_list_drag_drop(GtkWidget *list)
{
  gtk_signal_connect(GTK_OBJECT(list),
		     "drag_data_received",
		     GTK_SIGNAL_FUNC(contact_list_dnd_drop),
		     NULL);
  gtk_drag_dest_set(GTK_WIDGET(list),
		    GTK_DEST_DEFAULT_MOTION |
		    GTK_DEST_DEFAULT_HIGHLIGHT |
		    GTK_DEST_DEFAULT_DROP,
		    contact_list_drop_types,
		    n_contact_list_drop_types,
		    GDK_ACTION_COPY);
}

/*** Local functions ***/
static void contact_list_dnd_drop(GtkWidget *widget,
				  GdkDragContext *context,
				  gint x,
				  gint y,
				  GtkSelectionData *selection_data,
				  guint info,
				  guint time,
				  gpointer data)
{
  GtkCList *list;
  int row;
  int column;
  CONTACT_PTR contact;

  g_return_if_fail(widget);
  contact = gtk_object_get_data( GTK_OBJECT( widget ), "contact" );
  
  if( GTK_IS_CLIST( widget ) ) 
  {
      list=GTK_CLIST(widget);
      
      gtk_clist_get_selection_info(list, x, y, &row, &column);
      
      gtk_clist_select_row(list, row, column);
  }
  else if ( contact != NULL ) 
  {
      select_clist_row_from_contact( contact );
  }
  else
  {
      return;
  }
  
  switch(info)
    {
    case TARGET_URL:
      /* We got a bunch of URIs */
      {
          char *copy = g_malloc ( selection_data->length+1 );
          GList *uris;

          strncpy ( copy, selection_data->data, selection_data->length );
          copy [ selection_data->length ] = 0;

          /* Lets see if its a file list, or a URL */
          if ( (strncmp(copy, "file:", 5) == 0) &&
               ( MainData->lb_userwin == MainData->lb_userwin_online )) 
          {
              uris = gnome_uri_list_extract_uris (copy);
              
              request_file(widget, uris);
              g_free (copy);    
              gnome_uri_list_free_strings(uris);
          } else if ( (strncmp(copy, "http", 4) == 0) ||
                      (strncmp(copy, "ftp", 3) == 0) ) 
          {
              send_url_window( widget, copy ); 
          }
      }
      break;
    }
}
