typedef struct {

     gboolean play_sound;
     gboolean send_focus;
     guint away_time;		/* ?? */

     GdkFont *font;
     BYTE fg_red, fg_green, fg_blue;
     BYTE bg_red, bg_green, bg_blue;
     gboolean have_chat_focus;
     gboolean reported_chat_focus;	/* Focus reported to other user. */
     GtkWidget *should_send_focus;	/* GtkCheckMenuItem */
     WORD randomnumber;
     GSList *history;
     int listen_socket;
     GtkWidget *chatwindow;
     GtkWidget *ircicuchat;
     GtkWidget *sendicuchat;
     GtkWidget *vbox;
     GtkWidget *list;
     GtkWidget *filesel;
     gint gdk_input;
     int listen_port;
     void *initiator;
     GString *lineout;

     GSList *members;

} ChatSession, *CHATSESSION_PTR;


typedef struct {

     ChatSession *chatsession;
     
     Contact_Member *contact;
     GtkWidget *spliticuchat;
     GtkWidget *irclistitem;
     int socket;
     guint away;
     GdkFont *font;
     gint gdk_input;
     DWORD seq;
     int port;
     int listen_port;
     gboolean mpartynew;
     BYTE fg_red, fg_green, fg_blue;
     BYTE bg_red, bg_green, bg_blue;
     GString *linein;

} ChatContact, *CHATCONTACT_PTR;

extern GSList *Sessions;


int TCPAcceptChat(int sock, ChatContact *ccontact);
int TCPRefuseChat(int sock, ChatContact *ccontact);
int TCPSendChatRequest(UIN_T uin, gchar * msg, ChatSession *csession);
int TCPChatSend(GtkWidget * widget, GdkEventKey * ev, ChatSession *csession);
int TCPChatSendSel(GtkWidget * widget, GtkSelectionData * data, guint time,
		   ChatSession *csession);
void TCPTerminateChatSession(GtkWidget * widget, ChatSession *csession);

int TCPConnectChat(DWORD port, UIN_T uin, ChatSession *csession);
void TCPChatWriteAll(ChatSession *csession, gpointer data, size_t len);

void chat_save( GtkWidget *widget, ChatSession *csession );

