/*********************************
 Change away message
 (c) 1999 Jeremy Wise
 GnomeICU
**********************************/

/*** GnomeICU header files ***/
#include "common.h"

/*** Toplevel header files ***/
#include <string.h>

/*** Global functions ***/
void change_away( GtkWidget *widget, gpointer data )
{
	GtkWidget *text;

#ifdef TRACE_FUNCTION
	g_print( "change_away\n" );
#endif

	text = GTK_WIDGET( data );

	g_free( Away_Message );
	Away_Message = g_strdup( gtk_editable_get_chars( GTK_EDITABLE( text ),
	                         0, -1 ) );
}

void change_away_window( GtkWidget *widget, gpointer data )
{
	GtkWidget *window;
	GtkWidget *dialog_vbox1;
	GtkWidget *frame1;
	GtkWidget *scrolledwindow1;
	GtkWidget *text;
	GtkWidget *dialog_action_area1;
	GtkWidget *button1;
	GtkWidget *button3;
	GtkWidget *msg_list;	/* Need the msg list deal */
	gint cx;

#ifdef TRACE_FUNCTION
	g_print( "change_away_window\n" );
#endif

	window = gnome_dialog_new (_("GnomeICU: Away Message"), NULL);
	gtk_window_set_wmclass (GTK_WINDOW (window), "Away_Message", "GnomeICU");
	gtk_object_set_data (GTK_OBJECT (window), "window", window);
	gtk_window_set_policy (GTK_WINDOW (window), TRUE, TRUE, FALSE);

	dialog_vbox1 = GNOME_DIALOG (window)->vbox;
	gtk_object_set_data (GTK_OBJECT (window), "dialog_vbox1", dialog_vbox1);
	gtk_widget_show (dialog_vbox1);

	frame1 = gtk_frame_new (_("Set Away Message:"));
	gtk_widget_ref (frame1);
	gtk_object_set_data_full (GTK_OBJECT (window), "frame1", frame1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (frame1);
	gtk_box_pack_start (GTK_BOX (dialog_vbox1), frame1, TRUE, TRUE, 0);

	scrolledwindow1 = gtk_scrolled_window_new (NULL, NULL);
	gtk_widget_ref (scrolledwindow1);
	gtk_object_set_data_full (GTK_OBJECT (window), "scrolledwindow1", scrolledwindow1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (scrolledwindow1);
	gtk_container_add (GTK_CONTAINER (frame1), scrolledwindow1);
	gtk_container_set_border_width (GTK_CONTAINER (scrolledwindow1), 4);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow1), GTK_POLICY_NEVER, GTK_POLICY_ALWAYS);

	text = gtk_text_new (NULL, NULL);
	gtk_widget_ref (text);
	gtk_object_set_data_full (GTK_OBJECT (window), "text", text,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (text);
	gtk_container_add (GTK_CONTAINER (scrolledwindow1), text);
	gtk_text_set_editable (GTK_TEXT (text), TRUE);

	/* Following is to add a popup list of popular away messages */
	msg_list = gtk_button_new_with_label(_("Away Messages"));
	gtk_widget_ref(msg_list);
	gtk_object_set_data(GTK_OBJECT (msg_list), "text", text);
	gtk_object_set_data_full (GTK_OBJECT (window), "msg_list", msg_list,
				  (GtkDestroyNotify)
				  gtk_widget_unref);
	
	gtk_widget_show(msg_list);
	gtk_signal_connect(GTK_OBJECT(msg_list), "button_press_event",
			   GTK_SIGNAL_FUNC(popup_away_msgs),
			   NULL );

	gtk_widget_set_sensitive( msg_list, FALSE );
	for( cx = 0; cx < AWAY_MSGS_NUM; cx++ )
	{
		if( away_msgs[cx] != NULL && strlen( away_msgs[cx] ) )
			gtk_widget_set_sensitive( msg_list, TRUE );
	}
	
	gtk_box_pack_start(GTK_BOX(dialog_vbox1), msg_list, TRUE,
			   TRUE, 0);
	/* End of the popup list away messages stuff */
	
	dialog_action_area1 = GNOME_DIALOG (window)->action_area;
	gtk_object_set_data (GTK_OBJECT (window), "dialog_action_area1", dialog_action_area1);
	gtk_widget_show (dialog_action_area1);
	gtk_button_box_set_spacing (GTK_BUTTON_BOX (dialog_action_area1), 8);

	gnome_dialog_append_button (GNOME_DIALOG (window), GNOME_STOCK_BUTTON_OK);
	button1 = g_list_last (GNOME_DIALOG (window)->buttons)->data;
	gtk_widget_ref (button1);
	gtk_object_set_data_full (GTK_OBJECT (window), "button1", button1,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (button1);
	GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);

	gtk_object_set_data( GTK_OBJECT( text ), "button", button1 );

	gnome_dialog_append_button (GNOME_DIALOG (window), GNOME_STOCK_BUTTON_CLOSE);
	button3 = g_list_last (GNOME_DIALOG (window)->buttons)->data;
	gtk_widget_ref (button3);
	gtk_object_set_data_full (GTK_OBJECT (window), "button3", button3,
	                          (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (button3);
	GTK_WIDGET_SET_FLAGS (button3, GTK_CAN_DEFAULT);

	gtk_object_set_data( GTK_OBJECT( text ), "cancel", button3 );

	gtk_text_insert( GTK_TEXT( text ), NULL, NULL, NULL, Away_Message, -1 );

	gtk_signal_connect_after (GTK_OBJECT (text), "key_press_event",
	                    GTK_SIGNAL_FUNC (ctrl_enter_cb),
	                    NULL);

	gtk_signal_connect (GTK_OBJECT (button1), "clicked",
	                    GTK_SIGNAL_FUNC (change_away),
	                    GTK_OBJECT( text ));

	gtk_signal_connect_object (GTK_OBJECT (button1), "clicked",
	                           GTK_SIGNAL_FUNC (gtk_widget_destroy),
	                           GTK_OBJECT( window ));

	gtk_signal_connect_object (GTK_OBJECT (button3), "clicked",
	                           GTK_SIGNAL_FUNC (gtk_widget_destroy),
	                           GTK_OBJECT( window ));

	gtk_widget_grab_focus( text );

	gtk_widget_show_all( window );
}
