/* number-picker.c generated by valac 0.32.0.57-69c938, the Vala compiler
 * generated from number-picker.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "libsudoku.h"
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define TYPE_NUMBER_PICKER (number_picker_get_type ())
#define NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER_PICKER, NumberPicker))
#define NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER_PICKER, NumberPickerClass))
#define IS_NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER_PICKER))
#define IS_NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER_PICKER))
#define NUMBER_PICKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER_PICKER, NumberPickerClass))

typedef struct _NumberPicker NumberPicker;
typedef struct _NumberPickerClass NumberPickerClass;
typedef struct _NumberPickerPrivate NumberPickerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block7Data Block7Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block8Data Block8Data;

struct _NumberPicker {
	GtkGrid parent_instance;
	NumberPickerPrivate * priv;
};

struct _NumberPickerClass {
	GtkGridClass parent_class;
};

struct _NumberPickerPrivate {
	SudokuBoard* board;
	GtkButton* clear_button;
	gint earmarks_active;
};

struct _Block7Data {
	int _ref_count_;
	NumberPicker* self;
	gint n;
};

struct _Block8Data {
	int _ref_count_;
	Block7Data * _data7_;
	GtkToggleButton* toggle_button;
};


static gpointer number_picker_parent_class = NULL;

GType number_picker_get_type (void) G_GNUC_CONST;
#define NUMBER_PICKER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_NUMBER_PICKER, NumberPickerPrivate))
enum  {
	NUMBER_PICKER_DUMMY_PROPERTY
};
#define NUMBER_PICKER_EARMARKS_MAX_ALLOWED 5
NumberPicker* number_picker_new (SudokuBoard** board, gboolean earmark);
NumberPicker* number_picker_construct (GType object_type, SudokuBoard** board, gboolean earmark);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void _________lambda4_ (Block7Data* _data7_);
static void __________lambda4__gtk_button_clicked (GtkButton* _sender, gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void _________lambda5_ (Block8Data* _data8_);
static void number_picker_set_toggle_sensitive (NumberPicker* self, gboolean state);
static void __________lambda5__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void ___lambda6_ (NumberPicker* self);
static void ____lambda6__gtk_button_clicked (GtkButton* _sender, gpointer self);
void number_picker_set_clear_button_visibility (NumberPicker* self, gboolean visible);
void number_picker_set_earmarks (NumberPicker* self, gint row, gint col);
gboolean number_picker_set_earmark (NumberPicker* self, gint row, gint col, gint index, gboolean state);
static void g_cclosure_user_marshal_VOID__INT_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void number_picker_finalize (GObject* obj);


static gpointer _g_object_ref0 (gpointer self) {
#line 38 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	return self ? g_object_ref (self) : NULL;
#line 109 "number-picker.c"
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	return _data7_;
#line 118 "number-picker.c"
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 127 "number-picker.c"
		NumberPicker* self;
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		self = _data7_->self;
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		_g_object_unref0 (self);
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		g_slice_free (Block7Data, _data7_);
#line 135 "number-picker.c"
	}
}


static void _________lambda4_ (Block7Data* _data7_) {
	NumberPicker* self;
	gint _tmp0_ = 0;
#line 60 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	self = _data7_->self;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_tmp0_ = _data7_->n;
#line 61 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	g_signal_emit_by_name (self, "number-picked", _tmp0_);
#line 149 "number-picker.c"
}


static void __________lambda4__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 60 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_________lambda4_ (self);
#line 156 "number-picker.c"
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	g_atomic_int_inc (&_data8_->_ref_count_);
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	return _data8_;
#line 165 "number-picker.c"
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
#line 174 "number-picker.c"
		NumberPicker* self;
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		self = _data8_->_data7_->self;
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		_g_object_unref0 (_data8_->toggle_button);
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		block7_data_unref (_data8_->_data7_);
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		_data8_->_data7_ = NULL;
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		g_slice_free (Block8Data, _data8_);
#line 186 "number-picker.c"
	}
}


static void _________lambda5_ (Block8Data* _data8_) {
	Block7Data* _data7_;
	NumberPicker* self;
	gboolean toggle_active = FALSE;
	GtkToggleButton* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
	gint _tmp8_ = 0;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_data7_ = _data8_->_data7_;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	self = _data7_->self;
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_tmp0_ = _data8_->toggle_button;
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_tmp1_ = gtk_toggle_button_get_active (_tmp0_);
#line 67 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	toggle_active = _tmp1_;
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_tmp2_ = _data7_->n;
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_tmp3_ = toggle_active;
#line 68 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	g_signal_emit_by_name (self, "earmark-state-changed", _tmp2_, _tmp3_);
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_tmp5_ = toggle_active;
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	if (_tmp5_) {
#line 222 "number-picker.c"
		gint _tmp6_ = 0;
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		_tmp6_ = self->priv->earmarks_active;
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		_tmp4_ = _tmp6_ + 1;
#line 228 "number-picker.c"
	} else {
		gint _tmp7_ = 0;
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		_tmp7_ = self->priv->earmarks_active;
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		_tmp4_ = _tmp7_ - 1;
#line 235 "number-picker.c"
	}
#line 69 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	self->priv->earmarks_active = _tmp4_;
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_tmp8_ = self->priv->earmarks_active;
#line 70 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	if (_tmp8_ < NUMBER_PICKER_EARMARKS_MAX_ALLOWED) {
#line 71 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		number_picker_set_toggle_sensitive (self, TRUE);
#line 245 "number-picker.c"
	} else {
#line 73 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		number_picker_set_toggle_sensitive (self, FALSE);
#line 249 "number-picker.c"
	}
}


static void __________lambda5__gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_________lambda5_ (self);
#line 257 "number-picker.c"
}


static void ___lambda6_ (NumberPicker* self) {
#line 96 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	g_signal_emit_by_name (self, "number-picked", 0);
#line 264 "number-picker.c"
}


static void ____lambda6__gtk_button_clicked (GtkButton* _sender, gpointer self) {
#line 95 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	___lambda6_ ((NumberPicker*) self);
#line 271 "number-picker.c"
}


NumberPicker* number_picker_construct (GType object_type, SudokuBoard** board, gboolean earmark) {
	NumberPicker * self = NULL;
	SudokuBoard* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	gboolean _tmp48_ = FALSE;
#line 36 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	g_return_val_if_fail (*board != NULL, NULL);
#line 36 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	self = (NumberPicker*) g_object_new (object_type, NULL);
#line 38 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_tmp0_ = *board;
#line 38 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 38 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_g_object_unref0 (self->priv->board);
#line 38 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	self->priv->board = _tmp1_;
#line 39 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	self->priv->earmarks_active = 0;
#line 294 "number-picker.c"
	{
		gint col = 0;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		col = 0;
#line 299 "number-picker.c"
		{
			gboolean _tmp2_ = FALSE;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
			_tmp2_ = TRUE;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
			while (TRUE) {
#line 306 "number-picker.c"
				gint _tmp4_ = 0;
				SudokuBoard* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
				if (!_tmp2_) {
#line 313 "number-picker.c"
					gint _tmp3_ = 0;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp3_ = col;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					col = _tmp3_ + 1;
#line 319 "number-picker.c"
				}
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
				_tmp2_ = FALSE;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
				_tmp4_ = col;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
				_tmp5_ = *board;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
				_tmp6_ = sudoku_board_get_block_cols (_tmp5_);
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
				_tmp7_ = _tmp6_;
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
				if (!(_tmp4_ < _tmp7_)) {
#line 41 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					break;
#line 335 "number-picker.c"
				}
				{
					gint row = 0;
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					row = 0;
#line 341 "number-picker.c"
					{
						gboolean _tmp8_ = FALSE;
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
						_tmp8_ = TRUE;
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
						while (TRUE) {
#line 348 "number-picker.c"
							Block7Data* _data7_;
							gint _tmp10_ = 0;
							SudokuBoard* _tmp11_ = NULL;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							SudokuBoard* _tmp16_ = NULL;
							gint _tmp17_ = 0;
							gint _tmp18_ = 0;
							GtkButton* _tmp19_ = NULL;
							gboolean _tmp20_ = FALSE;
							GtkButton* button = NULL;
							GtkButton* _tmp23_ = NULL;
							GtkButton* _tmp24_ = NULL;
							GtkButton* _tmp25_ = NULL;
							gint _tmp26_ = 0;
							gint _tmp27_ = 0;
							GtkLabel* label = NULL;
							gint _tmp28_ = 0;
							gchar* _tmp29_ = NULL;
							gchar* _tmp30_ = NULL;
							GtkLabel* _tmp31_ = NULL;
							GtkLabel* _tmp32_ = NULL;
							GtkLabel* _tmp33_ = NULL;
							GtkLabel* _tmp34_ = NULL;
							GtkLabel* _tmp35_ = NULL;
							GtkLabel* _tmp36_ = NULL;
							GtkButton* _tmp37_ = NULL;
							GtkLabel* _tmp38_ = NULL;
							GtkLabel* _tmp39_ = NULL;
							gboolean _tmp40_ = FALSE;
							gint _tmp45_ = 0;
							GtkButton* _tmp47_ = NULL;
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_data7_ = g_slice_new0 (Block7Data);
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_data7_->_ref_count_ = 1;
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_data7_->self = g_object_ref (self);
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							if (!_tmp8_) {
#line 391 "number-picker.c"
								gint _tmp9_ = 0;
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
								_tmp9_ = row;
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
								row = _tmp9_ + 1;
#line 397 "number-picker.c"
							}
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp8_ = FALSE;
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp10_ = row;
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp11_ = *board;
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp12_ = sudoku_board_get_block_rows (_tmp11_);
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp13_ = _tmp12_;
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							if (!(_tmp10_ < _tmp13_)) {
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
								block7_data_unref (_data7_);
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
								_data7_ = NULL;
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
								break;
#line 417 "number-picker.c"
							}
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp14_ = col;
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp15_ = row;
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp16_ = *board;
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp17_ = sudoku_board_get_block_cols (_tmp16_);
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp18_ = _tmp17_;
#line 45 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_data7_->n = (_tmp14_ + (_tmp15_ * _tmp18_)) + 1;
#line 47 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp20_ = earmark;
#line 47 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							if (_tmp20_) {
#line 435 "number-picker.c"
								GtkToggleButton* _tmp21_ = NULL;
#line 47 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
								_tmp21_ = (GtkToggleButton*) gtk_toggle_button_new ();
#line 47 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
								g_object_ref_sink (_tmp21_);
#line 47 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
								_g_object_unref0 (_tmp19_);
#line 47 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
								_tmp19_ = (GtkButton*) _tmp21_;
#line 445 "number-picker.c"
							} else {
								GtkButton* _tmp22_ = NULL;
#line 47 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
								_tmp22_ = (GtkButton*) gtk_button_new ();
#line 47 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
								g_object_ref_sink (_tmp22_);
#line 47 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
								_g_object_unref0 (_tmp19_);
#line 47 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
								_tmp19_ = _tmp22_;
#line 456 "number-picker.c"
							}
#line 47 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp23_ = _g_object_ref0 (_tmp19_);
#line 47 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							button = _tmp23_;
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp24_ = button;
#line 48 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							gtk_widget_set_focus_on_click ((GtkWidget*) _tmp24_, FALSE);
#line 49 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp25_ = button;
#line 49 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp26_ = col;
#line 49 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp27_ = row;
#line 49 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp25_, _tmp26_, _tmp27_, 1, 1);
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp28_ = _data7_->n;
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp29_ = g_strdup_printf ("<big>%d</big>", _tmp28_);
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp30_ = _tmp29_;
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp31_ = (GtkLabel*) gtk_label_new (_tmp30_);
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							g_object_ref_sink (_tmp31_);
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp32_ = _tmp31_;
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_g_free0 (_tmp30_);
#line 51 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							label = _tmp32_;
#line 52 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp33_ = label;
#line 52 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							gtk_label_set_use_markup (_tmp33_, TRUE);
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp34_ = label;
#line 53 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							g_object_set ((GtkWidget*) _tmp34_, "margin", 4, NULL);
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp35_ = label;
#line 54 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							gtk_widget_set_margin_start ((GtkWidget*) _tmp35_, 8);
#line 55 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp36_ = label;
#line 55 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							gtk_widget_set_margin_end ((GtkWidget*) _tmp36_, 8);
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp37_ = button;
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp38_ = label;
#line 56 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							gtk_container_add ((GtkContainer*) _tmp37_, (GtkWidget*) _tmp38_);
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp39_ = label;
#line 57 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							gtk_widget_show ((GtkWidget*) _tmp39_);
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp40_ = earmark;
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							if (!_tmp40_) {
#line 520 "number-picker.c"
								GtkButton* _tmp41_ = NULL;
#line 60 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
								_tmp41_ = button;
#line 60 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
								g_signal_connect_data (_tmp41_, "clicked", (GCallback) __________lambda4__gtk_button_clicked, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
#line 526 "number-picker.c"
							} else {
								Block8Data* _data8_;
								GtkButton* _tmp42_ = NULL;
								GtkToggleButton* _tmp43_ = NULL;
								GtkToggleButton* _tmp44_ = NULL;
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
								_data8_ = g_slice_new0 (Block8Data);
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
								_data8_->_ref_count_ = 1;
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
								_data8_->_data7_ = block7_data_ref (_data7_);
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
								_tmp42_ = button;
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
								_tmp43_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 65 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
								_data8_->toggle_button = _tmp43_;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
								_tmp44_ = _data8_->toggle_button;
#line 66 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
								g_signal_connect_data (_tmp44_, "toggled", (GCallback) __________lambda5__gtk_toggle_button_toggled, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
								block8_data_unref (_data8_);
#line 59 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
								_data8_ = NULL;
#line 552 "number-picker.c"
							}
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp45_ = _data7_->n;
#line 77 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							if (_tmp45_ == 5) {
#line 558 "number-picker.c"
								GtkButton* _tmp46_ = NULL;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
								_tmp46_ = button;
#line 78 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
								gtk_widget_grab_focus ((GtkWidget*) _tmp46_);
#line 564 "number-picker.c"
							}
#line 80 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_tmp47_ = button;
#line 80 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							gtk_widget_show ((GtkWidget*) _tmp47_);
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_g_object_unref0 (label);
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_g_object_unref0 (button);
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_g_object_unref0 (_tmp19_);
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							block7_data_unref (_data7_);
#line 43 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
							_data7_ = NULL;
#line 580 "number-picker.c"
						}
					}
				}
			}
		}
	}
#line 84 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_tmp48_ = earmark;
#line 84 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	if (!_tmp48_) {
#line 591 "number-picker.c"
		GtkButton* _tmp49_ = NULL;
		GtkButton* _tmp50_ = NULL;
		GtkButton* _tmp51_ = NULL;
		GtkLabel* label = NULL;
		const gchar* _tmp52_ = NULL;
		gchar* _tmp53_ = NULL;
		gchar* _tmp54_ = NULL;
		GtkLabel* _tmp55_ = NULL;
		GtkLabel* _tmp56_ = NULL;
		GtkLabel* _tmp57_ = NULL;
		GtkButton* _tmp58_ = NULL;
		GtkLabel* _tmp59_ = NULL;
		GtkLabel* _tmp60_ = NULL;
		GtkButton* _tmp61_ = NULL;
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		_tmp49_ = (GtkButton*) gtk_button_new ();
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		g_object_ref_sink (_tmp49_);
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		_g_object_unref0 (self->priv->clear_button);
#line 86 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		self->priv->clear_button = _tmp49_;
#line 87 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		_tmp50_ = self->priv->clear_button;
#line 87 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		gtk_widget_set_focus_on_click ((GtkWidget*) _tmp50_, FALSE);
#line 88 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		_tmp51_ = self->priv->clear_button;
#line 88 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		gtk_grid_attach ((GtkGrid*) self, (GtkWidget*) _tmp51_, 0, 4, 3, 1);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		_tmp52_ = _ ("Clear");
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		_tmp53_ = g_strdup_printf ("<big>%s</big>", _tmp52_);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		_tmp54_ = _tmp53_;
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		_tmp55_ = (GtkLabel*) gtk_label_new (_tmp54_);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		g_object_ref_sink (_tmp55_);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		_tmp56_ = _tmp55_;
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		_g_free0 (_tmp54_);
#line 90 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		label = _tmp56_;
#line 91 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		_tmp57_ = label;
#line 91 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		gtk_label_set_use_markup (_tmp57_, TRUE);
#line 92 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		_tmp58_ = self->priv->clear_button;
#line 92 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		_tmp59_ = label;
#line 92 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		gtk_container_add ((GtkContainer*) _tmp58_, (GtkWidget*) _tmp59_);
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		_tmp60_ = label;
#line 93 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		gtk_widget_show ((GtkWidget*) _tmp60_);
#line 95 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		_tmp61_ = self->priv->clear_button;
#line 95 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		g_signal_connect_object (_tmp61_, "clicked", (GCallback) ____lambda6__gtk_button_clicked, self, 0);
#line 84 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		_g_object_unref0 (label);
#line 658 "number-picker.c"
	}
#line 100 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	gtk_widget_set_valign ((GtkWidget*) self, GTK_ALIGN_CENTER);
#line 101 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	gtk_widget_set_halign ((GtkWidget*) self, GTK_ALIGN_CENTER);
#line 102 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	g_object_set ((GtkWidget*) self, "margin", 2, NULL);
#line 103 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	gtk_grid_set_row_spacing ((GtkGrid*) self, 3);
#line 104 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	gtk_grid_set_column_spacing ((GtkGrid*) self, 3);
#line 105 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	gtk_widget_show ((GtkWidget*) self);
#line 36 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	return self;
#line 674 "number-picker.c"
}


NumberPicker* number_picker_new (SudokuBoard** board, gboolean earmark) {
#line 36 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	return number_picker_construct (TYPE_NUMBER_PICKER, board, earmark);
#line 681 "number-picker.c"
}


void number_picker_set_clear_button_visibility (NumberPicker* self, gboolean visible) {
	gboolean _tmp0_ = FALSE;
#line 108 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	g_return_if_fail (self != NULL);
#line 110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_tmp0_ = visible;
#line 110 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	if (_tmp0_) {
#line 693 "number-picker.c"
		GtkButton* _tmp1_ = NULL;
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		_tmp1_ = self->priv->clear_button;
#line 111 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		gtk_widget_show ((GtkWidget*) _tmp1_);
#line 699 "number-picker.c"
	} else {
		GtkButton* _tmp2_ = NULL;
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		_tmp2_ = self->priv->clear_button;
#line 113 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		gtk_widget_hide ((GtkWidget*) _tmp2_);
#line 706 "number-picker.c"
	}
}


void number_picker_set_earmarks (NumberPicker* self, gint row, gint col) {
#line 116 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	g_return_if_fail (self != NULL);
#line 714 "number-picker.c"
	{
		gint i = 0;
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		i = 0;
#line 719 "number-picker.c"
		{
			gboolean _tmp0_ = FALSE;
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
			_tmp0_ = TRUE;
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
			while (TRUE) {
#line 726 "number-picker.c"
				gint _tmp2_ = 0;
				SudokuBoard* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				SudokuBoard* _tmp9_ = NULL;
				gint _tmp10_ = 0;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gboolean _tmp13_ = FALSE;
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
				if (!_tmp0_) {
#line 741 "number-picker.c"
					gint _tmp1_ = 0;
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp1_ = i;
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					i = _tmp1_ + 1;
#line 747 "number-picker.c"
				}
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
				_tmp0_ = FALSE;
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
				_tmp2_ = i;
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
				_tmp3_ = self->priv->board;
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
				_tmp4_ = sudoku_board_get_max_val (_tmp3_);
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
				_tmp5_ = _tmp4_;
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
				if (!(_tmp2_ < _tmp5_)) {
#line 118 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					break;
#line 763 "number-picker.c"
				}
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
				_tmp6_ = row;
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
				_tmp7_ = col;
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
				_tmp8_ = i;
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
				_tmp9_ = self->priv->board;
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
				_tmp10_ = row;
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
				_tmp11_ = col;
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
				_tmp12_ = i;
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
				_tmp13_ = sudoku_board_is_earmark_enabled (_tmp9_, _tmp10_, _tmp11_, _tmp12_ + 1);
#line 119 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
				number_picker_set_earmark (self, _tmp6_, _tmp7_, _tmp8_, _tmp13_);
#line 783 "number-picker.c"
			}
		}
	}
}


gboolean number_picker_set_earmark (NumberPicker* self, gint row, gint col, gint index, gboolean state) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkToggleButton* button = NULL;
	gint _tmp3_ = 0;
	SudokuBoard* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	SudokuBoard* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	GtkWidget* _tmp11_ = NULL;
	GtkToggleButton* _tmp12_ = NULL;
	GtkToggleButton* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
#line 122 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_tmp1_ = state;
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	if (_tmp1_) {
#line 813 "number-picker.c"
		gint _tmp2_ = 0;
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		_tmp2_ = self->priv->earmarks_active;
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		_tmp0_ = _tmp2_ >= NUMBER_PICKER_EARMARKS_MAX_ALLOWED;
#line 819 "number-picker.c"
	} else {
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		_tmp0_ = FALSE;
#line 823 "number-picker.c"
	}
#line 124 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	if (_tmp0_) {
#line 125 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		result = FALSE;
#line 125 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		return result;
#line 831 "number-picker.c"
	}
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_tmp3_ = index;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_tmp4_ = self->priv->board;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_tmp5_ = sudoku_board_get_block_cols (_tmp4_);
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_tmp6_ = _tmp5_;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_tmp7_ = index;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_tmp8_ = self->priv->board;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_tmp9_ = sudoku_board_get_block_rows (_tmp8_);
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_tmp10_ = _tmp9_;
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_tmp11_ = gtk_grid_get_child_at ((GtkGrid*) self, _tmp3_ % _tmp6_, _tmp7_ / _tmp10_);
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 126 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	button = _tmp12_;
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_tmp13_ = button;
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_tmp14_ = state;
#line 127 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	gtk_toggle_button_set_active (_tmp13_, _tmp14_);
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	result = TRUE;
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_g_object_unref0 (button);
#line 128 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	return result;
#line 867 "number-picker.c"
}


static void number_picker_set_toggle_sensitive (NumberPicker* self, gboolean state) {
	gboolean _tmp0_ = FALSE;
#line 131 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	g_return_if_fail (self != NULL);
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_tmp0_ = state;
#line 133 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	if (_tmp0_) {
#line 879 "number-picker.c"
		{
			gint i = 0;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
			i = 0;
#line 884 "number-picker.c"
			{
				gboolean _tmp1_ = FALSE;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
				_tmp1_ = TRUE;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
				while (TRUE) {
#line 891 "number-picker.c"
					gint _tmp3_ = 0;
					SudokuBoard* _tmp4_ = NULL;
					gint _tmp5_ = 0;
					gint _tmp6_ = 0;
					gint _tmp7_ = 0;
					SudokuBoard* _tmp8_ = NULL;
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
					gint _tmp11_ = 0;
					SudokuBoard* _tmp12_ = NULL;
					gint _tmp13_ = 0;
					gint _tmp14_ = 0;
					GtkWidget* _tmp15_ = NULL;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					if (!_tmp1_) {
#line 907 "number-picker.c"
						gint _tmp2_ = 0;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
						_tmp2_ = i;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
						i = _tmp2_ + 1;
#line 913 "number-picker.c"
					}
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp1_ = FALSE;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp3_ = i;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp4_ = self->priv->board;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp5_ = sudoku_board_get_max_val (_tmp4_);
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp6_ = _tmp5_;
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					if (!(_tmp3_ < _tmp6_)) {
#line 134 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
						break;
#line 929 "number-picker.c"
					}
#line 135 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp7_ = i;
#line 135 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp8_ = self->priv->board;
#line 135 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp9_ = sudoku_board_get_block_cols (_tmp8_);
#line 135 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp10_ = _tmp9_;
#line 135 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp11_ = i;
#line 135 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp12_ = self->priv->board;
#line 135 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp13_ = sudoku_board_get_block_rows (_tmp12_);
#line 135 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp14_ = _tmp13_;
#line 135 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp15_ = gtk_grid_get_child_at ((GtkGrid*) self, _tmp7_ % _tmp10_, _tmp11_ / _tmp14_);
#line 135 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					gtk_widget_set_sensitive (_tmp15_, TRUE);
#line 951 "number-picker.c"
				}
			}
		}
	} else {
		{
			gint i = 0;
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
			i = 0;
#line 960 "number-picker.c"
			{
				gboolean _tmp16_ = FALSE;
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
				_tmp16_ = TRUE;
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
				while (TRUE) {
#line 967 "number-picker.c"
					gint _tmp18_ = 0;
					SudokuBoard* _tmp19_ = NULL;
					gint _tmp20_ = 0;
					gint _tmp21_ = 0;
					GtkToggleButton* button = NULL;
					gint _tmp22_ = 0;
					SudokuBoard* _tmp23_ = NULL;
					gint _tmp24_ = 0;
					gint _tmp25_ = 0;
					gint _tmp26_ = 0;
					SudokuBoard* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
					GtkWidget* _tmp30_ = NULL;
					GtkToggleButton* _tmp31_ = NULL;
					GtkToggleButton* _tmp32_ = NULL;
					gboolean _tmp33_ = FALSE;
					gboolean _tmp34_ = FALSE;
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					if (!_tmp16_) {
#line 988 "number-picker.c"
						gint _tmp17_ = 0;
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
						_tmp17_ = i;
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
						i = _tmp17_ + 1;
#line 994 "number-picker.c"
					}
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp16_ = FALSE;
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp18_ = i;
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp19_ = self->priv->board;
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp20_ = sudoku_board_get_max_val (_tmp19_);
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp21_ = _tmp20_;
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					if (!(_tmp18_ < _tmp21_)) {
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
						break;
#line 1010 "number-picker.c"
					}
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp22_ = i;
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp23_ = self->priv->board;
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp24_ = sudoku_board_get_block_cols (_tmp23_);
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp25_ = _tmp24_;
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp26_ = i;
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp27_ = self->priv->board;
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp28_ = sudoku_board_get_block_rows (_tmp27_);
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp29_ = _tmp28_;
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp30_ = gtk_grid_get_child_at ((GtkGrid*) self, _tmp22_ % _tmp25_, _tmp26_ / _tmp29_);
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp31_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, gtk_toggle_button_get_type (), GtkToggleButton));
#line 139 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					button = _tmp31_;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp32_ = button;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp33_ = gtk_toggle_button_get_active (_tmp32_);
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_tmp34_ = _tmp33_;
#line 140 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					if (!_tmp34_) {
#line 1042 "number-picker.c"
						GtkToggleButton* _tmp35_ = NULL;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
						_tmp35_ = button;
#line 141 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
						gtk_widget_set_sensitive ((GtkWidget*) _tmp35_, FALSE);
#line 1048 "number-picker.c"
					}
#line 137 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
					_g_object_unref0 (button);
#line 1052 "number-picker.c"
				}
			}
		}
	}
}


static void g_cclosure_user_marshal_VOID__INT_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__INT_BOOLEAN) (gpointer data1, gint arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	g_return_if_fail (n_param_values == 3);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		data1 = closure->data;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		data2 = param_values->data[0].v_pointer;
#line 1075 "number-picker.c"
	} else {
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		data1 = param_values->data[0].v_pointer;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
		data2 = closure->data;
#line 1081 "number-picker.c"
	}
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	callback = (GMarshalFunc_VOID__INT_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	callback (data1, g_value_get_int (param_values + 1), g_value_get_boolean (param_values + 2), data2);
#line 1087 "number-picker.c"
}


static void number_picker_class_init (NumberPickerClass * klass) {
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	number_picker_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	g_type_class_add_private (klass, sizeof (NumberPickerPrivate));
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	G_OBJECT_CLASS (klass)->finalize = number_picker_finalize;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	g_signal_new ("number_picked", TYPE_NUMBER_PICKER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	g_signal_new ("earmark_state_changed", TYPE_NUMBER_PICKER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_BOOLEAN, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_BOOLEAN);
#line 1102 "number-picker.c"
}


static void number_picker_instance_init (NumberPicker * self) {
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	self->priv = NUMBER_PICKER_GET_PRIVATE (self);
#line 1109 "number-picker.c"
}


static void number_picker_finalize (GObject* obj) {
	NumberPicker * self;
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NUMBER_PICKER, NumberPicker);
#line 26 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_g_object_unref0 (self->priv->board);
#line 31 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	_g_object_unref0 (self->priv->clear_button);
#line 24 "/home/mcatanzaro/src/jhbuild/checkout/gnome-sudoku/src/number-picker.vala"
	G_OBJECT_CLASS (number_picker_parent_class)->finalize (obj);
#line 1123 "number-picker.c"
}


GType number_picker_get_type (void) {
	static volatile gsize number_picker_type_id__volatile = 0;
	if (g_once_init_enter (&number_picker_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (NumberPickerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) number_picker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NumberPicker), 0, (GInstanceInitFunc) number_picker_instance_init, NULL };
		GType number_picker_type_id;
		number_picker_type_id = g_type_register_static (gtk_grid_get_type (), "NumberPicker", &g_define_type_info, 0);
		g_once_init_leave (&number_picker_type_id__volatile, number_picker_type_id);
	}
	return number_picker_type_id__volatile;
}



