/* sudoku-view.c generated by valac 0.27.1.7-1a9de, the Vala compiler
 * generated from sudoku-view.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include "libsudoku.h"
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <cairo.h>
#include <gee.h>
#include <pango/pangocairo.h>


#define TYPE_SUDOKU_CELL_VIEW (sudoku_cell_view_get_type ())
#define SUDOKU_CELL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_CELL_VIEW, SudokuCellView))
#define SUDOKU_CELL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_CELL_VIEW, SudokuCellViewClass))
#define IS_SUDOKU_CELL_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_CELL_VIEW))
#define IS_SUDOKU_CELL_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_CELL_VIEW))
#define SUDOKU_CELL_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_CELL_VIEW, SudokuCellViewClass))

typedef struct _SudokuCellView SudokuCellView;
typedef struct _SudokuCellViewClass SudokuCellViewClass;
typedef struct _SudokuCellViewPrivate SudokuCellViewPrivate;

#define TYPE_NUMBER_PICKER (number_picker_get_type ())
#define NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NUMBER_PICKER, NumberPicker))
#define NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NUMBER_PICKER, NumberPickerClass))
#define IS_NUMBER_PICKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NUMBER_PICKER))
#define IS_NUMBER_PICKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NUMBER_PICKER))
#define NUMBER_PICKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NUMBER_PICKER, NumberPickerClass))

typedef struct _NumberPicker NumberPicker;
typedef struct _NumberPickerClass NumberPickerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_SUDOKU_VIEW (sudoku_view_get_type ())
#define SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_VIEW, SudokuView))
#define SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_VIEW, SudokuViewClass))
#define IS_SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_VIEW))
#define IS_SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_VIEW))
#define SUDOKU_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_VIEW, SudokuViewClass))

typedef struct _SudokuView SudokuView;
typedef struct _SudokuViewClass SudokuViewClass;
typedef struct _SudokuViewPrivate SudokuViewPrivate;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;

struct _SudokuCellView {
	GtkDrawingArea parent_instance;
	SudokuCellViewPrivate * priv;
};

struct _SudokuCellViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _SudokuCellViewPrivate {
	PangoLayout* layout;
	gdouble size_ratio;
	GtkPopover* popover;
	GtkPopover* earmark_popover;
	SudokuGame* game;
	gint row;
	gint col;
	gboolean _show_possibilities;
	gboolean _show_warnings;
	gboolean _selected;
	GdkRGBA _background_color;
	NumberPicker* number_picker;
	NumberPicker* earmark_picker;
};

struct _Block5Data {
	int _ref_count_;
	SudokuCellView* self;
	gint row;
	gint col;
};

struct _SudokuView {
	GtkAspectFrame parent_instance;
	SudokuViewPrivate * priv;
	SudokuGame* game;
};

struct _SudokuViewClass {
	GtkAspectFrameClass parent_class;
};

struct _SudokuViewPrivate {
	SudokuCellView** cells;
	gint cells_length1;
	gint cells_length2;
	gboolean previous_board_broken_state;
	GtkOverlay* overlay;
	GtkDrawingArea* drawing;
	GtkGrid* grid;
	gint selected_row;
	gint selected_col;
	gboolean _show_warnings;
	gboolean _show_possibilities;
	gboolean _highlighter;
};

struct _Block6Data {
	int _ref_count_;
	SudokuView* self;
	SudokuGame* game;
};

struct _Block7Data {
	int _ref_count_;
	Block6Data * _data6_;
	gint cell_row;
	gint cell_col;
};


static gpointer sudoku_cell_view_parent_class = NULL;
static gpointer sudoku_view_parent_class = NULL;

GType sudoku_cell_view_get_type (void) G_GNUC_CONST;
GType number_picker_get_type (void) G_GNUC_CONST;
#define SUDOKU_CELL_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_CELL_VIEW, SudokuCellViewPrivate))
enum  {
	SUDOKU_CELL_VIEW_DUMMY_PROPERTY,
	SUDOKU_CELL_VIEW_VALUE,
	SUDOKU_CELL_VIEW_IS_FIXED,
	SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES,
	SUDOKU_CELL_VIEW_SHOW_WARNINGS,
	SUDOKU_CELL_VIEW_SELECTED,
	SUDOKU_CELL_VIEW_BACKGROUND_COLOR
};
SudokuCellView* sudoku_cell_view_new (gint row, gint col, SudokuGame** game);
SudokuCellView* sudoku_cell_view_construct (GType object_type, gint row, gint col, SudokuGame** game);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
void sudoku_cell_view_set_value (SudokuCellView* self, gint value);
gboolean sudoku_cell_view_get_is_fixed (SudokuCellView* self);
NumberPicker* number_picker_new (SudokuBoard** board, gboolean earmark);
NumberPicker* number_picker_construct (GType object_type, SudokuBoard** board, gboolean earmark);
static void __lambda7_ (SudokuCellView* self, NumberPicker* o, gint number);
static void ___lambda7__number_picker_number_picked (NumberPicker* _sender, gint number, gpointer self);
static gboolean __lambda8_ (SudokuCellView* self);
static gboolean ___lambda8__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void __lambda9_ (Block5Data* _data5_, gint number, gboolean state);
gint sudoku_cell_view_get_value (SudokuCellView* self);
static void ___lambda9__number_picker_earmark_state_changed (NumberPicker* _sender, gint number, gboolean active, gpointer self);
void number_picker_set_earmarks (NumberPicker* self, gint row, gint col);
static gboolean __lambda10_ (SudokuCellView* self);
static gboolean ___lambda10__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static gboolean sudoku_cell_view_focus_out_cb (SudokuCellView* self, GtkWidget* widget, GdkEventFocus* event);
static gboolean _sudoku_cell_view_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
void sudoku_cell_view_cell_changed_cb (SudokuCellView* self, gint row, gint col, gint old_val, gint new_val);
static void _sudoku_cell_view_cell_changed_cb_sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self);
static gboolean sudoku_cell_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
static void sudoku_cell_view_hide_both_popovers (SudokuCellView* self);
static void sudoku_cell_view_show_earmark_picker (SudokuCellView* self);
static void sudoku_cell_view_show_number_picker (SudokuCellView* self);
void number_picker_set_clear_button_visibility (NumberPicker* self, gboolean visible);
static gint sudoku_cell_view_key_map_keypad (SudokuCellView* self, const gchar* key_name);
static gboolean sudoku_cell_view_real_key_press_event (GtkWidget* base, GdkEventKey* event);
gboolean number_picker_set_earmark (NumberPicker* self, gint row, gint col, gint index, gboolean state);
static gboolean sudoku_cell_view_real_draw (GtkWidget* base, cairo_t* c);
void sudoku_cell_view_clear (SudokuCellView* self);
gboolean sudoku_cell_view_get_show_possibilities (SudokuCellView* self);
void sudoku_cell_view_set_show_possibilities (SudokuCellView* self, gboolean value);
gboolean sudoku_cell_view_get_show_warnings (SudokuCellView* self);
void sudoku_cell_view_set_show_warnings (SudokuCellView* self, gboolean value);
gboolean sudoku_cell_view_get_selected (SudokuCellView* self);
void sudoku_cell_view_set_selected (SudokuCellView* self, gboolean value);
void sudoku_cell_view_get_background_color (SudokuCellView* self, GdkRGBA* result);
void sudoku_cell_view_set_background_color (SudokuCellView* self, GdkRGBA* value);
static void sudoku_cell_view_finalize (GObject* obj);
static void _vala_sudoku_cell_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sudoku_cell_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType sudoku_view_get_type (void) G_GNUC_CONST;
#define SUDOKU_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_VIEW, SudokuViewPrivate))
enum  {
	SUDOKU_VIEW_DUMMY_PROPERTY,
	SUDOKU_VIEW_SHOW_WARNINGS,
	SUDOKU_VIEW_SHOW_POSSIBILITIES,
	SUDOKU_VIEW_HIGHLIGHTER
};
static void sudoku_view_set_selected (SudokuView* self, gint cell_row, gint cell_col);
SudokuView* sudoku_view_new (SudokuGame* game);
SudokuView* sudoku_view_construct (GType object_type, SudokuGame* game);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static gboolean sudoku_view_draw_board (SudokuView* self, cairo_t* c);
static gboolean _sudoku_view_draw_board_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static gboolean ________lambda11_ (Block7Data* _data7_);
static gboolean _________lambda11__gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self);
static void ________lambda12_ (Block7Data* _data7_, GObject* s, GParamSpec* p);
static void _________lambda12__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void sudoku_view_clear (SudokuView* self);
gboolean sudoku_view_get_show_warnings (SudokuView* self);
void sudoku_view_set_show_warnings (SudokuView* self, gboolean value);
gboolean sudoku_view_get_show_possibilities (SudokuView* self);
void sudoku_view_set_show_possibilities (SudokuView* self, gboolean value);
gboolean sudoku_view_get_highlighter (SudokuView* self);
void sudoku_view_set_highlighter (SudokuView* self, gboolean value);
static void sudoku_view_finalize (GObject* obj);
static void _vala_sudoku_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_sudoku_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GdkRGBA SUDOKU_VIEW_fixed_cell_color = {0.8, 0.8, 0.8, (gdouble) 0};
static const GdkRGBA SUDOKU_VIEW_free_cell_color = {1.0, 1.0, 1.0, 1.0};
static const GdkRGBA SUDOKU_VIEW_highlight_color = {0.93, 0.93, 0.93, (gdouble) 0};
static const GdkRGBA SUDOKU_VIEW_selected_bg_color = {0.7, 0.8, 0.9};

static Block5Data* block5_data_ref (Block5Data* _data5_) {
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return _data5_;
#line 251 "sudoku-view.c"
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 260 "sudoku-view.c"
		SudokuCellView* self;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		self = _data5_->self;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (self);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_slice_free (Block5Data, _data5_);
#line 268 "sudoku-view.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return self ? g_object_ref (self) : NULL;
#line 276 "sudoku-view.c"
}


static void __lambda7_ (SudokuCellView* self, NumberPicker* o, gint number) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	GtkPopover* _tmp2_ = NULL;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (o != NULL);
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = number;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_set_value (self, _tmp0_);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = number;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp1_ == 0) {
#line 125 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_object_notify ((GObject*) self, "value");
#line 296 "sudoku-view.c"
	}
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = self->priv->popover;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp2_);
#line 302 "sudoku-view.c"
}


static void ___lambda7__number_picker_number_picked (NumberPicker* _sender, gint number, gpointer self) {
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	__lambda7_ ((SudokuCellView*) self, _sender, number);
#line 309 "sudoku-view.c"
}


static gboolean __lambda8_ (SudokuCellView* self) {
	gboolean result = FALSE;
	GtkPopover* _tmp0_ = NULL;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->popover;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = TRUE;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 324 "sudoku-view.c"
}


static gboolean ___lambda8__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = __lambda8_ ((SudokuCellView*) self);
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 333 "sudoku-view.c"
}


static void __lambda9_ (Block5Data* _data5_, gint number, gboolean state) {
	SudokuCellView* self;
	gboolean _tmp0_ = FALSE;
	SudokuGame* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = _data5_->self;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = state;
#line 138 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_) {
#line 353 "sudoku-view.c"
		SudokuGame* _tmp1_ = NULL;
		SudokuBoard* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp1_ = self->priv->game;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp2_ = _tmp1_->board;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = _data5_->row;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp4_ = _data5_->col;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp5_ = number;
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_board_enable_earmark (_tmp2_, _tmp3_, _tmp4_, _tmp5_);
#line 371 "sudoku-view.c"
	} else {
		SudokuGame* _tmp6_ = NULL;
		SudokuBoard* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp6_ = self->priv->game;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = _tmp6_->board;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = _data5_->row;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = _data5_->col;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp10_ = number;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_board_disable_earmark (_tmp7_, _tmp8_, _tmp9_, _tmp10_);
#line 390 "sudoku-view.c"
	}
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = self->priv->game;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp12_ = _data5_->row;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp13_ = _data5_->col;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp14_ = sudoku_cell_view_get_value (self);
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp15_ = _tmp14_;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp16_ = sudoku_cell_view_get_value (self);
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp17_ = _tmp16_;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_emit_by_name (_tmp11_, "cell-changed", _tmp12_, _tmp13_, _tmp15_, _tmp17_);
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 410 "sudoku-view.c"
}


static void ___lambda9__number_picker_earmark_state_changed (NumberPicker* _sender, gint number, gboolean active, gpointer self) {
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	__lambda9_ (self, number, active);
#line 417 "sudoku-view.c"
}


static gboolean __lambda10_ (SudokuCellView* self) {
	gboolean result = FALSE;
	GtkPopover* _tmp0_ = NULL;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->earmark_popover;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = TRUE;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 432 "sudoku-view.c"
}


static gboolean ___lambda10__gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = __lambda10_ ((SudokuCellView*) self);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 441 "sudoku-view.c"
}


static gboolean _sudoku_cell_view_focus_out_cb_gtk_widget_focus_out_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = sudoku_cell_view_focus_out_cb ((SudokuCellView*) self, _sender, event);
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 450 "sudoku-view.c"
}


static void _sudoku_cell_view_cell_changed_cb_sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self) {
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_cell_changed_cb ((SudokuCellView*) self, row, col, old_val, new_val);
#line 457 "sudoku-view.c"
}


SudokuCellView* sudoku_cell_view_construct (GType object_type, gint row, gint col, SudokuGame** game) {
	SudokuCellView * self = NULL;
	Block5Data* _data5_;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	SudokuGame* _tmp2_ = NULL;
	SudokuGame* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GtkStyle* _tmp6_ = NULL;
	GtkStyle* _tmp7_ = NULL;
	PangoFontDescription* _tmp8_ = NULL;
	SudokuGame* _tmp9_ = NULL;
	SudokuBoard* _tmp10_ = NULL;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	SudokuGame* _tmp16_ = NULL;
	NumberPicker* _tmp17_ = NULL;
	NumberPicker* _tmp18_ = NULL;
	GtkPopover* _tmp19_ = NULL;
	GtkPopover* _tmp20_ = NULL;
	NumberPicker* _tmp21_ = NULL;
	GtkPopover* _tmp22_ = NULL;
	GtkPopover* _tmp23_ = NULL;
	GtkPopover* _tmp24_ = NULL;
	SudokuGame* _tmp25_ = NULL;
	NumberPicker* _tmp26_ = NULL;
	NumberPicker* _tmp27_ = NULL;
	NumberPicker* _tmp28_ = NULL;
	gint _tmp29_ = 0;
	gint _tmp30_ = 0;
	GtkPopover* _tmp31_ = NULL;
	GtkPopover* _tmp32_ = NULL;
	NumberPicker* _tmp33_ = NULL;
	GtkPopover* _tmp34_ = NULL;
	GtkPopover* _tmp35_ = NULL;
	GtkPopover* _tmp36_ = NULL;
	SudokuGame* _tmp37_ = NULL;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (*game != NULL, NULL);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data5_->_ref_count_ = 1;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = row;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data5_->row = _tmp0_;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = col;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data5_->col = _tmp1_;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = (SudokuCellView*) g_object_new (object_type, NULL);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data5_->self = g_object_ref (self);
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = *game;
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->game);
#line 106 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->game = _tmp3_;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = _data5_->row;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->row = _tmp4_;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = _data5_->col;
#line 108 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->col = _tmp5_;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = gtk_widget_get_style ((GtkWidget*) self);
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = _tmp6_;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp8_ = _tmp7_->font_desc;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	pango_font_description_set_size (_tmp8_, PANGO_SCALE * 13);
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = *game;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10_ = _tmp9_->board;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = _data5_->row;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp12_ = _data5_->col;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp13_ = sudoku_board_get (_tmp10_, _tmp11_, _tmp12_);
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_set_value (self, _tmp13_);
#line 115 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_set ((GtkWidget*) self, "can-focus", TRUE, NULL);
#line 116 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_set_events ((GtkWidget*) self, (GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_KEY_PRESS_MASK);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp14_ = sudoku_cell_view_get_is_fixed (self);
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp15_ = _tmp14_;
#line 118 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp15_) {
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		block5_data_unref (_data5_);
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_data5_ = NULL;
#line 119 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return self;
#line 572 "sudoku-view.c"
	}
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp16_ = *game;
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp17_ = number_picker_new (&_tmp16_->board, FALSE);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp17_);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->number_picker);
#line 121 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->number_picker = _tmp17_;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp18_ = self->priv->number_picker;
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object (_tmp18_, "number-picked", (GCallback) ___lambda7__number_picker_number_picked, self, 0);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp19_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) self);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp19_);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->popover);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->popover = _tmp19_;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp20_ = self->priv->popover;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp21_ = self->priv->number_picker;
#line 131 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_container_add ((GtkContainer*) _tmp20_, (GtkWidget*) _tmp21_);
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp22_ = self->priv->popover;
#line 132 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_popover_set_modal (_tmp22_, FALSE);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp23_ = self->priv->popover;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_popover_set_position (_tmp23_, GTK_POS_BOTTOM);
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp24_ = self->priv->popover;
#line 134 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object ((GtkWidget*) _tmp24_, "focus-out-event", (GCallback) ___lambda8__gtk_widget_focus_out_event, self, 0);
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp25_ = *game;
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp26_ = number_picker_new (&_tmp25_->board, TRUE);
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp26_);
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->earmark_picker);
#line 136 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->earmark_picker = _tmp26_;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp27_ = self->priv->earmark_picker;
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_data (_tmp27_, "earmark-state-changed", (GCallback) ___lambda9__number_picker_earmark_state_changed, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp28_ = self->priv->earmark_picker;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp29_ = _data5_->row;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp30_ = _data5_->col;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	number_picker_set_earmarks (_tmp28_, _tmp29_, _tmp30_);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp31_ = (GtkPopover*) gtk_popover_new ((GtkWidget*) self);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp31_);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->earmark_popover);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->earmark_popover = _tmp31_;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp32_ = self->priv->earmark_popover;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp33_ = self->priv->earmark_picker;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_container_add ((GtkContainer*) _tmp32_, (GtkWidget*) _tmp33_);
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp34_ = self->priv->earmark_popover;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_popover_set_modal (_tmp34_, FALSE);
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp35_ = self->priv->earmark_popover;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_popover_set_position (_tmp35_, GTK_POS_BOTTOM);
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp36_ = self->priv->earmark_popover;
#line 151 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object ((GtkWidget*) _tmp36_, "focus-out-event", (GCallback) ___lambda10__gtk_widget_focus_out_event, self, 0);
#line 153 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object ((GtkWidget*) self, "focus-out-event", (GCallback) _sudoku_cell_view_focus_out_cb_gtk_widget_focus_out_event, self, 0);
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp37_ = *game;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object (_tmp37_, "cell-changed", (GCallback) _sudoku_cell_view_cell_changed_cb_sudoku_game_cell_changed, self, 0);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	block5_data_unref (_data5_);
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data5_ = NULL;
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return self;
#line 674 "sudoku-view.c"
}


SudokuCellView* sudoku_cell_view_new (gint row, gint col, SudokuGame** game) {
#line 104 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return sudoku_cell_view_construct (TYPE_SUDOKU_CELL_VIEW, row, col, game);
#line 681 "sudoku-view.c"
}


static gboolean sudoku_cell_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	SudokuCellView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventButton* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	GtkPopover* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	GdkEventButton* _tmp16_ = NULL;
	guint _tmp17_ = 0U;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = (SudokuCellView*) base;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = event;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = _tmp1_->button;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp2_ != ((guint) 1)) {
#line 711 "sudoku-view.c"
		GdkEventButton* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = event;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp4_ = _tmp3_->button;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = _tmp4_ != ((guint) 3);
#line 720 "sudoku-view.c"
	} else {
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = FALSE;
#line 724 "sudoku-view.c"
	}
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_) {
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 732 "sudoku-view.c"
	}
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_get ((GtkWidget*) self, "is-focus", &_tmp5_, NULL);
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = _tmp5_;
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (!_tmp6_) {
#line 163 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		gtk_widget_grab_focus ((GtkWidget*) self);
#line 742 "sudoku-view.c"
	}
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = sudoku_cell_view_get_is_fixed (self);
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp8_ = _tmp7_;
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp8_) {
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 754 "sudoku-view.c"
	}
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10_ = self->priv->popover;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = gtk_widget_get_visible ((GtkWidget*) _tmp10_);
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp12_ = _tmp11_;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp12_) {
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = TRUE;
#line 766 "sudoku-view.c"
	} else {
		GtkPopover* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp13_ = self->priv->earmark_popover;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp14_ = gtk_widget_get_visible ((GtkWidget*) _tmp13_);
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp15_ = _tmp14_;
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = _tmp15_;
#line 779 "sudoku-view.c"
	}
#line 167 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp9_) {
#line 169 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_hide_both_popovers (self);
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 789 "sudoku-view.c"
	}
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp16_ = event;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp17_ = _tmp16_->button;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp17_ == ((guint) 1)) {
#line 797 "sudoku-view.c"
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp19_ = self->priv->_show_possibilities;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (!_tmp19_) {
#line 804 "sudoku-view.c"
			GdkEventButton* _tmp20_ = NULL;
			GdkModifierType _tmp21_ = 0;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp20_ = event;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp21_ = _tmp20_->state;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp18_ = (_tmp21_ & GDK_CONTROL_MASK) > 0;
#line 813 "sudoku-view.c"
		} else {
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp18_ = FALSE;
#line 817 "sudoku-view.c"
		}
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp18_) {
#line 176 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			sudoku_cell_view_show_earmark_picker (self);
#line 823 "sudoku-view.c"
		} else {
#line 178 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			sudoku_cell_view_show_number_picker (self);
#line 827 "sudoku-view.c"
		}
	} else {
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_ = FALSE;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp23_ = self->priv->_show_possibilities;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (!_tmp23_) {
#line 836 "sudoku-view.c"
			GdkEventButton* _tmp24_ = NULL;
			guint _tmp25_ = 0U;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp24_ = event;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp25_ = _tmp24_->button;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp22_ = _tmp25_ == ((guint) 3);
#line 845 "sudoku-view.c"
		} else {
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp22_ = FALSE;
#line 849 "sudoku-view.c"
		}
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp22_) {
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			sudoku_cell_view_show_earmark_picker (self);
#line 855 "sudoku-view.c"
		}
	}
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 862 "sudoku-view.c"
}


static void sudoku_cell_view_show_number_picker (SudokuCellView* self) {
	NumberPicker* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GtkPopover* _tmp3_ = NULL;
	GtkPopover* _tmp4_ = NULL;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->number_picker;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = sudoku_cell_view_get_value (self);
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = _tmp1_;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	number_picker_set_clear_button_visibility (_tmp0_, _tmp2_ != 0);
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->earmark_popover;
#line 189 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp3_);
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = self->priv->popover;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp4_);
#line 890 "sudoku-view.c"
}


static void sudoku_cell_view_show_earmark_picker (SudokuCellView* self) {
	GtkPopover* _tmp0_ = NULL;
	GtkPopover* _tmp1_ = NULL;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->popover;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = self->priv->earmark_popover;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp1_);
#line 907 "sudoku-view.c"
}


static void sudoku_cell_view_hide_both_popovers (SudokuCellView* self) {
	GtkPopover* _tmp0_ = NULL;
	GtkPopover* _tmp1_ = NULL;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->popover;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = self->priv->earmark_popover;
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_hide ((GtkWidget*) _tmp1_);
#line 924 "sudoku-view.c"
}


static gboolean sudoku_cell_view_focus_out_cb (SudokuCellView* self, GtkWidget* widget, GdkEventFocus* event) {
	gboolean result = FALSE;
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (widget != NULL, FALSE);
#line 205 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_hide_both_popovers (self);
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 208 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 942 "sudoku-view.c"
}


static gint sudoku_cell_view_key_map_keypad (SudokuCellView* self, const gchar* key_name) {
	gint result = 0;
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (key_name != NULL, 0);
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = key_name;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp1_, "KP_0") == 0) {
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = TRUE;
#line 969 "sudoku-view.c"
	} else {
		const gchar* _tmp2_ = NULL;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp2_ = key_name;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = g_strcmp0 (_tmp2_, "0") == 0;
#line 976 "sudoku-view.c"
	}
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_) {
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 0;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 984 "sudoku-view.c"
	}
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = key_name;
#line 217 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp3_, "KP_1") == 0) {
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 1;
#line 218 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 994 "sudoku-view.c"
	}
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = key_name;
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp4_, "KP_2") == 0) {
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 2;
#line 220 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1004 "sudoku-view.c"
	}
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = key_name;
#line 221 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp5_, "KP_3") == 0) {
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 3;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1014 "sudoku-view.c"
	}
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = key_name;
#line 223 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp6_, "KP_4") == 0) {
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 4;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1024 "sudoku-view.c"
	}
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = key_name;
#line 225 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp7_, "KP_5") == 0) {
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 5;
#line 226 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1034 "sudoku-view.c"
	}
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp8_ = key_name;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp8_, "KP_6") == 0) {
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 6;
#line 228 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1044 "sudoku-view.c"
	}
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = key_name;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp9_, "KP_7") == 0) {
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 7;
#line 230 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1054 "sudoku-view.c"
	}
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10_ = key_name;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp10_, "KP_8") == 0) {
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 8;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1064 "sudoku-view.c"
	}
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = key_name;
#line 233 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp11_, "KP_9") == 0) {
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = 9;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1074 "sudoku-view.c"
	}
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = -1;
#line 235 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 1080 "sudoku-view.c"
}


static gboolean sudoku_cell_view_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	SudokuCellView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar* k_name = NULL;
	GdkEventKey* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint k_no = 0;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gboolean _tmp11_ = FALSE;
	gint _tmp12_ = 0;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_ = FALSE;
	gint _tmp42_ = 0;
	gboolean _tmp45_ = FALSE;
	gboolean _tmp46_ = FALSE;
	const gchar* _tmp47_ = NULL;
	const gchar* _tmp50_ = NULL;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = (SudokuCellView*) base;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = sudoku_cell_view_get_is_fixed (self);
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = _tmp0_;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp1_) {
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 241 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1121 "sudoku-view.c"
	}
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = event;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = _tmp2_->keyval;
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = gdk_keyval_name (_tmp3_);
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 242 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	k_name = _tmp5_;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = k_name;
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = atoi (_tmp6_);
#line 243 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	k_no = _tmp7_;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp8_ = k_no;
#line 245 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp8_ == 0) {
#line 1143 "sudoku-view.c"
		const gchar* _tmp9_ = NULL;
		gint _tmp10_ = 0;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = k_name;
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp10_ = sudoku_cell_view_key_map_keypad (self, _tmp9_);
#line 246 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		k_no = _tmp10_;
#line 1152 "sudoku-view.c"
	}
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp12_ = k_no;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp12_ >= 1) {
#line 1158 "sudoku-view.c"
		gint _tmp13_ = 0;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp13_ = k_no;
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp11_ = _tmp13_ <= 9;
#line 1164 "sudoku-view.c"
	} else {
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp11_ = FALSE;
#line 1168 "sudoku-view.c"
	}
#line 247 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp11_) {
#line 1172 "sudoku-view.c"
		GdkEventKey* _tmp14_ = NULL;
		GdkModifierType _tmp15_ = 0;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp14_ = event;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp15_ = _tmp14_->state;
#line 249 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if ((_tmp15_ & GDK_CONTROL_MASK) > 0) {
#line 1181 "sudoku-view.c"
			gboolean new_state = FALSE;
			SudokuGame* _tmp16_ = NULL;
			SudokuBoard* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			gint _tmp20_ = 0;
			gboolean _tmp21_ = FALSE;
			NumberPicker* _tmp22_ = NULL;
			gint _tmp23_ = 0;
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			gboolean _tmp26_ = FALSE;
			gboolean _tmp27_ = FALSE;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp16_ = self->priv->game;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp17_ = _tmp16_->board;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp18_ = self->priv->row;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp19_ = self->priv->col;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp20_ = k_no;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp21_ = sudoku_board_is_earmark_enabled (_tmp17_, _tmp18_, _tmp19_, _tmp20_);
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			new_state = !_tmp21_;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp22_ = self->priv->earmark_picker;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp23_ = self->priv->row;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp24_ = self->priv->col;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp25_ = k_no;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp26_ = new_state;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp27_ = number_picker_set_earmark (_tmp22_, _tmp23_, _tmp24_, _tmp25_ - 1, _tmp26_);
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			if (_tmp27_) {
#line 1223 "sudoku-view.c"
				gboolean _tmp28_ = FALSE;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp28_ = new_state;
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (_tmp28_) {
#line 1229 "sudoku-view.c"
					SudokuGame* _tmp29_ = NULL;
					SudokuBoard* _tmp30_ = NULL;
					gint _tmp31_ = 0;
					gint _tmp32_ = 0;
					gint _tmp33_ = 0;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp29_ = self->priv->game;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp30_ = _tmp29_->board;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp31_ = self->priv->row;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp32_ = self->priv->col;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp33_ = k_no;
#line 255 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					sudoku_board_enable_earmark (_tmp30_, _tmp31_, _tmp32_, _tmp33_);
#line 1247 "sudoku-view.c"
				} else {
					SudokuGame* _tmp34_ = NULL;
					SudokuBoard* _tmp35_ = NULL;
					gint _tmp36_ = 0;
					gint _tmp37_ = 0;
					gint _tmp38_ = 0;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp34_ = self->priv->game;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp35_ = _tmp34_->board;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp36_ = self->priv->row;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp37_ = self->priv->col;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp38_ = k_no;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					sudoku_board_disable_earmark (_tmp35_, _tmp36_, _tmp37_, _tmp38_);
#line 1266 "sudoku-view.c"
				}
#line 258 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				gtk_widget_queue_draw ((GtkWidget*) self);
#line 1270 "sudoku-view.c"
			}
		} else {
			gint _tmp39_ = 0;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp39_ = k_no;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			sudoku_cell_view_set_value (self, _tmp39_);
#line 1278 "sudoku-view.c"
		}
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = TRUE;
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (k_name);
#line 263 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1286 "sudoku-view.c"
	}
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp42_ = k_no;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp42_ == 0) {
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp41_ = TRUE;
#line 1294 "sudoku-view.c"
	} else {
		const gchar* _tmp43_ = NULL;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp43_ = k_name;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp41_ = g_strcmp0 (_tmp43_, "BackSpace") == 0;
#line 1301 "sudoku-view.c"
	}
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp41_) {
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp40_ = TRUE;
#line 1307 "sudoku-view.c"
	} else {
		const gchar* _tmp44_ = NULL;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp44_ = k_name;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp40_ = g_strcmp0 (_tmp44_, "Delete") == 0;
#line 1314 "sudoku-view.c"
	}
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp40_) {
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_value (self, 0);
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_object_notify ((GObject*) self, "value");
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = TRUE;
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (k_name);
#line 269 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1328 "sudoku-view.c"
	}
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp47_ = k_name;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp47_, "space") == 0) {
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp46_ = TRUE;
#line 1336 "sudoku-view.c"
	} else {
		const gchar* _tmp48_ = NULL;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp48_ = k_name;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp46_ = g_strcmp0 (_tmp48_, "Return") == 0;
#line 1343 "sudoku-view.c"
	}
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp46_) {
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp45_ = TRUE;
#line 1349 "sudoku-view.c"
	} else {
		const gchar* _tmp49_ = NULL;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp49_ = k_name;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp45_ = g_strcmp0 (_tmp49_, "KP_Enter") == 0;
#line 1356 "sudoku-view.c"
	}
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp45_) {
#line 274 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_show_number_picker (self);
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = TRUE;
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (k_name);
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1368 "sudoku-view.c"
	}
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp50_ = k_name;
#line 278 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_strcmp0 (_tmp50_, "Escape") == 0) {
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_hide_both_popovers (self);
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = TRUE;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (k_name);
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1382 "sudoku-view.c"
	}
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_free0 (k_name);
#line 284 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 1390 "sudoku-view.c"
}


static gboolean sudoku_cell_view_real_draw (GtkWidget* base, cairo_t* c) {
	SudokuCellView * self;
	gboolean result = FALSE;
	gint glyph_width = 0;
	gint glyph_height = 0;
	PangoLayout* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	gboolean _tmp39_ = FALSE;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_ = FALSE;
	gboolean _tmp107_ = FALSE;
	gboolean _tmp108_ = FALSE;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = (SudokuCellView*) base;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->layout;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	pango_layout_get_pixel_size (_tmp0_, &_tmp1_, &_tmp2_);
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	glyph_width = _tmp1_;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	glyph_height = _tmp2_;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = self->priv->_show_warnings;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp4_) {
#line 1427 "sudoku-view.c"
		SudokuGame* _tmp5_ = NULL;
		SudokuBoard* _tmp6_ = NULL;
		GeeSet* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		Coord _tmp10_ = {0};
		gboolean _tmp11_ = FALSE;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp5_ = self->priv->game;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp6_ = _tmp5_->board;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = _tmp6_->broken_coords;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = self->priv->row;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = self->priv->col;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		coord_init (&_tmp10_, _tmp8_, _tmp9_);
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp11_ = gee_collection_contains ((GeeCollection*) _tmp7_, &_tmp10_);
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = _tmp11_;
#line 1451 "sudoku-view.c"
	} else {
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = FALSE;
#line 1455 "sudoku-view.c"
	}
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp3_) {
#line 1459 "sudoku-view.c"
		cairo_t* _tmp12_ = NULL;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp12_ = c;
#line 292 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_source_rgb (_tmp12_, 1.0, 0.0, 0.0);
#line 1465 "sudoku-view.c"
	} else {
		gboolean _tmp13_ = FALSE;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp13_ = self->priv->_selected;
#line 293 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp13_) {
#line 1472 "sudoku-view.c"
			cairo_t* _tmp14_ = NULL;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp14_ = c;
#line 294 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			cairo_set_source_rgb (_tmp14_, 0.2, 0.2, 0.2);
#line 1478 "sudoku-view.c"
		} else {
			cairo_t* _tmp15_ = NULL;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp15_ = c;
#line 296 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			cairo_set_source_rgb (_tmp15_, 0.0, 0.0, 0.0);
#line 1485 "sudoku-view.c"
		}
	}
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp16_ = sudoku_cell_view_get_value (self);
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp17_ = _tmp16_;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp17_ != 0) {
#line 1494 "sudoku-view.c"
		gint width = 0;
		gint height = 0;
		PangoLayout* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		gdouble scale = 0.0;
		gint _tmp22_ = 0;
		gdouble _tmp23_ = 0.0;
		gint _tmp24_ = 0;
		cairo_t* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gdouble _tmp28_ = 0.0;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		gdouble _tmp31_ = 0.0;
		cairo_t* _tmp32_ = NULL;
		cairo_t* _tmp33_ = NULL;
		gdouble _tmp34_ = 0.0;
		gdouble _tmp35_ = 0.0;
		cairo_t* _tmp36_ = NULL;
		PangoLayout* _tmp37_ = NULL;
		cairo_t* _tmp38_ = NULL;
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp18_ = self->priv->layout;
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		pango_layout_get_size (_tmp18_, &_tmp19_, &_tmp20_);
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		width = _tmp19_;
#line 301 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		height = _tmp20_;
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp21_ = height;
#line 302 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		height = _tmp21_ / PANGO_SCALE;
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp22_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp23_ = self->priv->size_ratio;
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp24_ = height;
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		scale = (((gdouble) _tmp22_) / _tmp23_) / _tmp24_;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp25_ = c;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp26_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp27_ = glyph_width;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp28_ = scale;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp29_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp30_ = glyph_height;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp31_ = scale;
#line 305 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_move_to (_tmp25_, (_tmp26_ - (_tmp27_ * _tmp28_)) / 2, (_tmp29_ - (_tmp30_ * _tmp31_)) / 2);
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp32_ = c;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_save (_tmp32_);
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp33_ = c;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp34_ = scale;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp35_ = scale;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_scale (_tmp33_, _tmp34_, _tmp35_);
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp36_ = c;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp37_ = self->priv->layout;
#line 308 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		pango_cairo_show_layout (_tmp36_, _tmp37_);
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp38_ = c;
#line 309 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_restore (_tmp38_);
#line 1577 "sudoku-view.c"
	}
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp39_ = sudoku_cell_view_get_is_fixed (self);
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp40_ = _tmp39_;
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp40_) {
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		result = FALSE;
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return result;
#line 1589 "sudoku-view.c"
	}
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp41_ = self->priv->_show_possibilities;
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (!_tmp41_) {
#line 1595 "sudoku-view.c"
		gdouble earmark_size = 0.0;
		gint _tmp42_ = 0;
		gdouble _tmp43_ = 0.0;
		cairo_t* _tmp44_ = NULL;
		gdouble _tmp45_ = 0.0;
		cairo_t* _tmp46_ = NULL;
		gdouble _tmp47_ = 0.0;
		cairo_t* _tmp48_ = NULL;
		cairo_t* _tmp49_ = NULL;
		SudokuGame* _tmp50_ = NULL;
		SudokuBoard* _tmp51_ = NULL;
		gint _tmp52_ = 0;
		gint _tmp53_ = 0;
		gchar* _tmp54_ = NULL;
		gchar* _tmp55_ = NULL;
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp42_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp43_ = self->priv->size_ratio;
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		earmark_size = _tmp42_ / (_tmp43_ * 2);
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp44_ = c;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp45_ = earmark_size;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_font_size (_tmp44_, _tmp45_);
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp46_ = c;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp47_ = earmark_size;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_move_to (_tmp46_, (gdouble) 0, _tmp47_);
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp48_ = c;
#line 323 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_source_rgb (_tmp48_, 0.0, 0.0, 0.0);
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp49_ = c;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp50_ = self->priv->game;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp51_ = _tmp50_->board;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp52_ = self->priv->row;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp53_ = self->priv->col;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp54_ = sudoku_board_get_earmarks_string (_tmp51_, _tmp52_, _tmp53_);
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp55_ = _tmp54_;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_show_text (_tmp49_, _tmp55_);
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (_tmp55_);
#line 1651 "sudoku-view.c"
	} else {
		gint _tmp56_ = 0;
		gint _tmp57_ = 0;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp56_ = sudoku_cell_view_get_value (self);
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp57_ = _tmp56_;
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp57_ == 0) {
#line 1661 "sudoku-view.c"
			gdouble possibility_size = 0.0;
			gint _tmp58_ = 0;
			gdouble _tmp59_ = 0.0;
			cairo_t* _tmp60_ = NULL;
			gdouble _tmp61_ = 0.0;
			cairo_t* _tmp62_ = NULL;
			gboolean* possibilities = NULL;
			SudokuGame* _tmp63_ = NULL;
			SudokuBoard* _tmp64_ = NULL;
			gint _tmp65_ = 0;
			gint _tmp66_ = 0;
			gint _tmp67_ = 0;
			gboolean* _tmp68_ = NULL;
			gint possibilities_length1 = 0;
			gint _possibilities_size_ = 0;
			gint height = 0;
			gint _tmp69_ = 0;
			SudokuGame* _tmp70_ = NULL;
			SudokuBoard* _tmp71_ = NULL;
			gint _tmp72_ = 0;
			gint _tmp73_ = 0;
			gint width = 0;
			gint _tmp74_ = 0;
			SudokuGame* _tmp75_ = NULL;
			SudokuBoard* _tmp76_ = NULL;
			gint _tmp77_ = 0;
			gint _tmp78_ = 0;
			gint num = 0;
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp58_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp59_ = self->priv->size_ratio;
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			possibility_size = _tmp58_ / (_tmp59_ * 2);
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp60_ = c;
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp61_ = possibility_size;
#line 329 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			cairo_set_font_size (_tmp60_, _tmp61_);
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp62_ = c;
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			cairo_set_source_rgb (_tmp62_, 0.0, 0.0, 0.0);
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp63_ = self->priv->game;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp64_ = _tmp63_->board;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp65_ = self->priv->row;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp66_ = self->priv->col;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp68_ = sudoku_board_get_possibilities_as_bool_array (_tmp64_, _tmp65_, _tmp66_, &_tmp67_);
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			possibilities = _tmp68_;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			possibilities_length1 = _tmp67_;
#line 332 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_possibilities_size_ = possibilities_length1;
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp69_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp70_ = self->priv->game;
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp71_ = _tmp70_->board;
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp72_ = sudoku_board_get_block_cols (_tmp71_);
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp73_ = _tmp72_;
#line 334 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			height = _tmp69_ / _tmp73_;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp74_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp75_ = self->priv->game;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp76_ = _tmp75_->board;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp77_ = sudoku_board_get_block_rows (_tmp76_);
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp78_ = _tmp77_;
#line 335 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			width = _tmp74_ / _tmp78_;
#line 337 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			num = 0;
#line 1748 "sudoku-view.c"
			{
				gint row_tmp = 0;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				row_tmp = 0;
#line 1753 "sudoku-view.c"
				{
					gboolean _tmp79_ = FALSE;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp79_ = TRUE;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					while (TRUE) {
#line 1760 "sudoku-view.c"
						gint _tmp81_ = 0;
						SudokuGame* _tmp82_ = NULL;
						SudokuBoard* _tmp83_ = NULL;
						gint _tmp84_ = 0;
						gint _tmp85_ = 0;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						if (!_tmp79_) {
#line 1768 "sudoku-view.c"
							gint _tmp80_ = 0;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp80_ = row_tmp;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							row_tmp = _tmp80_ + 1;
#line 1774 "sudoku-view.c"
						}
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp79_ = FALSE;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp81_ = row_tmp;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp82_ = self->priv->game;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp83_ = _tmp82_->board;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp84_ = sudoku_board_get_block_rows (_tmp83_);
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp85_ = _tmp84_;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						if (!(_tmp81_ < _tmp85_)) {
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							break;
#line 1792 "sudoku-view.c"
						}
						{
							gint col_tmp = 0;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							col_tmp = 0;
#line 1798 "sudoku-view.c"
							{
								gboolean _tmp86_ = FALSE;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp86_ = TRUE;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								while (TRUE) {
#line 1805 "sudoku-view.c"
									gint _tmp88_ = 0;
									SudokuGame* _tmp89_ = NULL;
									SudokuBoard* _tmp90_ = NULL;
									gint _tmp91_ = 0;
									gint _tmp92_ = 0;
									gint _tmp93_ = 0;
									gboolean* _tmp94_ = NULL;
									gint _tmp94__length1 = 0;
									gint _tmp95_ = 0;
									gboolean _tmp96_ = FALSE;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									if (!_tmp86_) {
#line 1818 "sudoku-view.c"
										gint _tmp87_ = 0;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp87_ = col_tmp;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										col_tmp = _tmp87_ + 1;
#line 1824 "sudoku-view.c"
									}
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp86_ = FALSE;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp88_ = col_tmp;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp89_ = self->priv->game;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp90_ = _tmp89_->board;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp91_ = sudoku_board_get_block_cols (_tmp90_);
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp92_ = _tmp91_;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									if (!(_tmp88_ < _tmp92_)) {
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										break;
#line 1842 "sudoku-view.c"
									}
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp93_ = num;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									num = _tmp93_ + 1;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp94_ = possibilities;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp94__length1 = possibilities_length1;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp95_ = num;
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									_tmp96_ = _tmp94_[_tmp95_ - 1];
#line 344 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
									if (_tmp96_) {
#line 1858 "sudoku-view.c"
										cairo_t* _tmp97_ = NULL;
										gint _tmp98_ = 0;
										gint _tmp99_ = 0;
										gint _tmp100_ = 0;
										gint _tmp101_ = 0;
										gdouble _tmp102_ = 0.0;
										cairo_t* _tmp103_ = NULL;
										gint _tmp104_ = 0;
										gchar* _tmp105_ = NULL;
										gchar* _tmp106_ = NULL;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp97_ = c;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp98_ = col_tmp;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp99_ = width;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp100_ = row_tmp;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp101_ = height;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp102_ = possibility_size;
#line 346 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										cairo_move_to (_tmp97_, (gdouble) (_tmp98_ * _tmp99_), (_tmp100_ * _tmp101_) + _tmp102_);
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp103_ = c;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp104_ = num;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp105_ = g_strdup_printf ("%d", _tmp104_);
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_tmp106_ = _tmp105_;
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										cairo_show_text (_tmp103_, _tmp106_);
#line 347 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
										_g_free0 (_tmp106_);
#line 1895 "sudoku-view.c"
									}
								}
							}
						}
					}
				}
			}
#line 326 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			possibilities = (g_free (possibilities), NULL);
#line 1905 "sudoku-view.c"
		}
	}
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp108_ = self->priv->_show_warnings;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp108_) {
#line 1912 "sudoku-view.c"
		gboolean _tmp109_ = FALSE;
		gint _tmp110_ = 0;
		gint _tmp111_ = 0;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp110_ = sudoku_cell_view_get_value (self);
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp111_ = _tmp110_;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp111_ == 0) {
#line 1922 "sudoku-view.c"
			SudokuGame* _tmp112_ = NULL;
			SudokuBoard* _tmp113_ = NULL;
			gint _tmp114_ = 0;
			gint _tmp115_ = 0;
			gint _tmp116_ = 0;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp112_ = self->priv->game;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp113_ = _tmp112_->board;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp114_ = self->priv->row;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp115_ = self->priv->col;
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp116_ = sudoku_board_count_possibilities (_tmp113_, _tmp114_, _tmp115_);
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp109_ = _tmp116_ == 0;
#line 1940 "sudoku-view.c"
		} else {
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp109_ = FALSE;
#line 1944 "sudoku-view.c"
		}
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp107_ = _tmp109_;
#line 1948 "sudoku-view.c"
	} else {
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp107_ = FALSE;
#line 1952 "sudoku-view.c"
	}
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp107_) {
#line 1956 "sudoku-view.c"
		gchar* warning = NULL;
		gchar* _tmp117_ = NULL;
		cairo_text_extents_t extents = {0};
		cairo_t* _tmp118_ = NULL;
		gint _tmp119_ = 0;
		cairo_t* _tmp120_ = NULL;
		const gchar* _tmp121_ = NULL;
		cairo_text_extents_t _tmp122_ = {0};
		cairo_t* _tmp123_ = NULL;
		gint _tmp124_ = 0;
		cairo_text_extents_t _tmp125_ = {0};
		gdouble _tmp126_ = 0.0;
		gint _tmp127_ = 0;
		cairo_text_extents_t _tmp128_ = {0};
		gdouble _tmp129_ = 0.0;
		cairo_t* _tmp130_ = NULL;
		cairo_t* _tmp131_ = NULL;
		const gchar* _tmp132_ = NULL;
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp117_ = g_strdup ("X");
#line 355 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		warning = _tmp117_;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp118_ = c;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp119_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_font_size (_tmp118_, (gdouble) (_tmp119_ / 2));
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp120_ = c;
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp121_ = warning;
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_text_extents (_tmp120_, _tmp121_, &_tmp122_);
#line 358 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		extents = _tmp122_;
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp123_ = c;
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp124_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp125_ = extents;
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp126_ = _tmp125_.width;
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp127_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp128_ = extents;
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp129_ = _tmp128_.height;
#line 359 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_move_to (_tmp123_, ((_tmp124_ - _tmp126_) / 2) - 1, ((_tmp127_ + _tmp129_) / 2) + 1);
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp130_ = c;
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_set_source_rgb (_tmp130_, 1.0, 0.0, 0.0);
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp131_ = c;
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp132_ = warning;
#line 361 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_show_text (_tmp131_, _tmp132_);
#line 353 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (warning);
#line 2021 "sudoku-view.c"
	}
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2027 "sudoku-view.c"
}


void sudoku_cell_view_cell_changed_cb (SudokuCellView* self, gint row, gint col, gint old_val, gint new_val) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = row;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = self->priv->row;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp1_ == _tmp2_) {
#line 2043 "sudoku-view.c"
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = col;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp4_ = self->priv->col;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = _tmp3_ == _tmp4_;
#line 2052 "sudoku-view.c"
	} else {
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = FALSE;
#line 2056 "sudoku-view.c"
	}
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_) {
#line 2060 "sudoku-view.c"
		gint _tmp5_ = 0;
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp5_ = new_val;
#line 371 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_value (self, _tmp5_);
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_object_notify ((GObject*) self, "value");
#line 2068 "sudoku-view.c"
	}
}


void sudoku_cell_view_clear (SudokuCellView* self) {
	NumberPicker* _tmp0_ = NULL;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 378 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->earmark_picker;
#line 378 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_ != NULL) {
#line 2081 "sudoku-view.c"
		{
			gint i = 0;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			i = 0;
#line 2086 "sudoku-view.c"
			{
				gboolean _tmp1_ = FALSE;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp1_ = TRUE;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				while (TRUE) {
#line 2093 "sudoku-view.c"
					gint _tmp3_ = 0;
					SudokuGame* _tmp4_ = NULL;
					SudokuBoard* _tmp5_ = NULL;
					gint _tmp6_ = 0;
					gint _tmp7_ = 0;
					NumberPicker* _tmp8_ = NULL;
					gint _tmp9_ = 0;
					gint _tmp10_ = 0;
					gint _tmp11_ = 0;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					if (!_tmp1_) {
#line 2105 "sudoku-view.c"
						gint _tmp2_ = 0;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp2_ = i;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						i = _tmp2_ + 1;
#line 2111 "sudoku-view.c"
					}
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp1_ = FALSE;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp3_ = i;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp4_ = self->priv->game;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp5_ = _tmp4_->board;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp6_ = sudoku_board_get_max_val (_tmp5_);
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp7_ = _tmp6_;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					if (!(_tmp3_ < _tmp7_)) {
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						break;
#line 2129 "sudoku-view.c"
					}
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp8_ = self->priv->earmark_picker;
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp9_ = self->priv->row;
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp10_ = self->priv->col;
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp11_ = i;
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					number_picker_set_earmark (_tmp8_, _tmp9_, _tmp10_, _tmp11_, FALSE);
#line 2141 "sudoku-view.c"
				}
			}
		}
	}
}


gint sudoku_cell_view_get_value (SudokuCellView* self) {
	gint result;
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->game;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = _tmp0_->board;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = self->priv->row;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->col;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = sudoku_board_get (_tmp1_, _tmp2_, _tmp3_);
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp4_;
#line 41 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2172 "sudoku-view.c"
}


void sudoku_cell_view_set_value (SudokuCellView* self, gint value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp14_ = 0;
	gint _tmp30_ = 0;
	SudokuGame* _tmp31_ = NULL;
	SudokuBoard* _tmp32_ = NULL;
	gint _tmp33_ = 0;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	SudokuGame* _tmp44_ = NULL;
	gint _tmp45_ = 0;
	gint _tmp46_ = 0;
	gint _tmp47_ = 0;
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = sudoku_cell_view_get_is_fixed (self);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = _tmp0_;
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp1_) {
#line 2198 "sudoku-view.c"
		gchar* text = NULL;
		SudokuGame* _tmp2_ = NULL;
		SudokuBoard* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		PangoLayout* _tmp9_ = NULL;
		PangoLayout* _tmp10_ = NULL;
		GtkStyle* _tmp11_ = NULL;
		GtkStyle* _tmp12_ = NULL;
		PangoFontDescription* _tmp13_ = NULL;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp2_ = self->priv->game;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp3_ = _tmp2_->board;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp4_ = self->priv->row;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp5_ = self->priv->col;
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp6_ = sudoku_board_get (_tmp3_, _tmp4_, _tmp5_);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = g_strdup_printf ("%d", _tmp6_);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		text = _tmp7_;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = text;
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp8_);
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (self->priv->layout);
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		self->priv->layout = _tmp9_;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp10_ = self->priv->layout;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp11_ = gtk_widget_get_style ((GtkWidget*) self);
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp12_ = _tmp11_;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp13_ = _tmp12_->font_desc;
#line 48 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		pango_layout_set_font_description (_tmp10_, _tmp13_);
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (text);
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return;
#line 2248 "sudoku-view.c"
	}
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp14_ = value;
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp14_ == 0) {
#line 2254 "sudoku-view.c"
		gchar* text = NULL;
		gchar* _tmp15_ = NULL;
		const gchar* _tmp16_ = NULL;
		PangoLayout* _tmp17_ = NULL;
		PangoLayout* _tmp18_ = NULL;
		GtkStyle* _tmp19_ = NULL;
		GtkStyle* _tmp20_ = NULL;
		PangoFontDescription* _tmp21_ = NULL;
		SudokuGame* _tmp22_ = NULL;
		SudokuBoard* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		gint _tmp26_ = 0;
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp15_ = g_strdup ("");
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		text = _tmp15_;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp16_ = text;
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp17_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp16_);
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (self->priv->layout);
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		self->priv->layout = _tmp17_;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp18_ = self->priv->layout;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp19_ = gtk_widget_get_style ((GtkWidget*) self);
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp20_ = _tmp19_;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp21_ = _tmp20_->font_desc;
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		pango_layout_set_font_description (_tmp18_, _tmp21_);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp22_ = self->priv->game;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp23_ = _tmp22_->board;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp24_ = self->priv->row;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp25_ = self->priv->col;
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp26_ = sudoku_board_get (_tmp23_, _tmp24_, _tmp25_);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		if (_tmp26_ != 0) {
#line 2302 "sudoku-view.c"
			SudokuGame* _tmp27_ = NULL;
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp27_ = self->priv->game;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp28_ = self->priv->row;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp29_ = self->priv->col;
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			sudoku_game_remove (_tmp27_, _tmp28_, _tmp29_);
#line 2314 "sudoku-view.c"
		}
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (text);
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return;
#line 2320 "sudoku-view.c"
	}
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp30_ = value;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp31_ = self->priv->game;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp32_ = _tmp31_->board;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp33_ = self->priv->row;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp34_ = self->priv->col;
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp35_ = sudoku_board_get (_tmp32_, _tmp33_, _tmp34_);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp30_ == _tmp35_) {
#line 2336 "sudoku-view.c"
		gchar* text = NULL;
		gint _tmp36_ = 0;
		gchar* _tmp37_ = NULL;
		const gchar* _tmp38_ = NULL;
		PangoLayout* _tmp39_ = NULL;
		PangoLayout* _tmp40_ = NULL;
		GtkStyle* _tmp41_ = NULL;
		GtkStyle* _tmp42_ = NULL;
		PangoFontDescription* _tmp43_ = NULL;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp36_ = value;
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp37_ = g_strdup_printf ("%d", _tmp36_);
#line 62 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		text = _tmp37_;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp38_ = text;
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp39_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp38_);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (self->priv->layout);
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		self->priv->layout = _tmp39_;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp40_ = self->priv->layout;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp41_ = gtk_widget_get_style ((GtkWidget*) self);
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp42_ = _tmp41_;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp43_ = _tmp42_->font_desc;
#line 64 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		pango_layout_set_font_description (_tmp40_, _tmp43_);
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_free0 (text);
#line 65 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		return;
#line 2374 "sudoku-view.c"
	}
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp44_ = self->priv->game;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp45_ = self->priv->row;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp46_ = self->priv->col;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp47_ = value;
#line 67 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_game_insert (_tmp44_, _tmp45_, _tmp46_, _tmp47_);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "value");
#line 2388 "sudoku-view.c"
}


gboolean sudoku_cell_view_get_is_fixed (SudokuCellView* self) {
	gboolean result;
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	gboolean* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp2__length2 = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gboolean _tmp5_ = FALSE;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->game;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = _tmp0_->board;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = _tmp1_->is_fixed;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2__length1 = _tmp1_->is_fixed_length1;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2__length2 = _tmp1_->is_fixed_length2;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->row;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = self->priv->col;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = _tmp2_[(_tmp3_ * _tmp2__length2) + _tmp4_];
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp5_;
#line 73 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2424 "sudoku-view.c"
}


gboolean sudoku_cell_view_get_show_possibilities (SudokuCellView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_show_possibilities;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 79 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2439 "sudoku-view.c"
}


void sudoku_cell_view_set_show_possibilities (SudokuCellView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = value;
#line 82 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_possibilities = _tmp0_;
#line 83 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 80 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "show-possibilities");
#line 2455 "sudoku-view.c"
}


gboolean sudoku_cell_view_get_show_warnings (SudokuCellView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_show_warnings;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 90 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2470 "sudoku-view.c"
}


void sudoku_cell_view_set_show_warnings (SudokuCellView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = value;
#line 93 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_warnings = _tmp0_;
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 91 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "show-warnings");
#line 2486 "sudoku-view.c"
}


gboolean sudoku_cell_view_get_selected (SudokuCellView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_selected;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2501 "sudoku-view.c"
}


void sudoku_cell_view_set_selected (SudokuCellView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = value;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_selected = _tmp0_;
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "selected");
#line 2515 "sudoku-view.c"
}


void sudoku_cell_view_get_background_color (SudokuCellView* self, GdkRGBA* result) {
	GdkRGBA _tmp0_ = {0};
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_background_color;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	*result = _tmp0_;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return;
#line 2529 "sudoku-view.c"
}


void sudoku_cell_view_set_background_color (SudokuCellView* self, GdkRGBA* value) {
	GdkRGBA _tmp0_ = {0};
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = *value;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_background_color = _tmp0_;
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "background-color");
#line 2543 "sudoku-view.c"
}


static void sudoku_cell_view_class_init (SudokuCellViewClass * klass) {
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_parent_class = g_type_class_peek_parent (klass);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_type_class_add_private (klass, sizeof (SudokuCellViewPrivate));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	((GtkWidgetClass *) klass)->button_press_event = sudoku_cell_view_real_button_press_event;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	((GtkWidgetClass *) klass)->key_press_event = sudoku_cell_view_real_key_press_event;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	((GtkWidgetClass *) klass)->draw = sudoku_cell_view_real_draw;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_cell_view_get_property;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_cell_view_set_property;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_cell_view_finalize;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_VALUE, g_param_spec_int ("value", "value", "value", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_IS_FIXED, g_param_spec_boolean ("is-fixed", "is-fixed", "is-fixed", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES, g_param_spec_boolean ("show-possibilities", "show-possibilities", "show-possibilities", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_SHOW_WARNINGS, g_param_spec_boolean ("show-warnings", "show-warnings", "show-warnings", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_SELECTED, g_param_spec_boolean ("selected", "selected", "selected", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_CELL_VIEW_BACKGROUND_COLOR, g_param_spec_boxed ("background-color", "background-color", "background-color", gdk_rgba_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 2576 "sudoku-view.c"
}


static void sudoku_cell_view_instance_init (SudokuCellView * self) {
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv = SUDOKU_CELL_VIEW_GET_PRIVATE (self);
#line 29 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->size_ratio = (gdouble) 2;
#line 87 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_warnings = TRUE;
#line 2587 "sudoku-view.c"
}


static void sudoku_cell_view_finalize (GObject* obj) {
	SudokuCellView * self;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_CELL_VIEW, SudokuCellView);
#line 27 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->layout);
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->popover);
#line 32 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->earmark_popover);
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->game);
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->number_picker);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->earmark_picker);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (sudoku_cell_view_parent_class)->finalize (obj);
#line 2609 "sudoku-view.c"
}


GType sudoku_cell_view_get_type (void) {
	static volatile gsize sudoku_cell_view_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_cell_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuCellViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_cell_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuCellView), 0, (GInstanceInitFunc) sudoku_cell_view_instance_init, NULL };
		GType sudoku_cell_view_type_id;
		sudoku_cell_view_type_id = g_type_register_static (gtk_drawing_area_get_type (), "SudokuCellView", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_cell_view_type_id__volatile, sudoku_cell_view_type_id);
	}
	return sudoku_cell_view_type_id__volatile;
}


static void _vala_sudoku_cell_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SudokuCellView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_CELL_VIEW, SudokuCellView);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	switch (property_id) {
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_VALUE:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_int (value, sudoku_cell_view_get_value (self));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_IS_FIXED:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_cell_view_get_is_fixed (self));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_cell_view_get_show_possibilities (self));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SHOW_WARNINGS:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_cell_view_get_show_warnings (self));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SELECTED:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_cell_view_get_selected (self));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_BACKGROUND_COLOR:
#line 2662 "sudoku-view.c"
		{
			GdkRGBA boxed;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			sudoku_cell_view_get_background_color (self, &boxed);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			g_value_set_boxed (value, &boxed);
#line 2669 "sudoku-view.c"
		}
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 2673 "sudoku-view.c"
		default:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 2679 "sudoku-view.c"
	}
}


static void _vala_sudoku_cell_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SudokuCellView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_CELL_VIEW, SudokuCellView);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	switch (property_id) {
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_VALUE:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_value (self, g_value_get_int (value));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SHOW_POSSIBILITIES:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_show_possibilities (self, g_value_get_boolean (value));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SHOW_WARNINGS:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_show_warnings (self, g_value_get_boolean (value));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_SELECTED:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_selected (self, g_value_get_boolean (value));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_CELL_VIEW_BACKGROUND_COLOR:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_cell_view_set_background_color (self, g_value_get_boxed (value));
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 2719 "sudoku-view.c"
		default:
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 25 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 2725 "sudoku-view.c"
	}
}


static void sudoku_view_set_selected (SudokuView* self, gint cell_row, gint cell_col) {
	SudokuCellView** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	gint _tmp0__length2 = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	SudokuCellView* _tmp3_ = NULL;
	SudokuCellView** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp4__length2 = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	SudokuCellView* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	SudokuCellView** _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	gint _tmp10__length2 = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	SudokuCellView* _tmp13_ = NULL;
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->cells;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0__length1 = self->priv->cells_length1;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0__length2 = self->priv->cells_length2;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = self->priv->selected_row;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = self->priv->selected_col;
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = _tmp0_[(_tmp1_ * _tmp0__length2) + _tmp2_];
#line 404 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_set_selected (_tmp3_, FALSE);
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = self->priv->cells;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4__length1 = self->priv->cells_length1;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4__length2 = self->priv->cells_length2;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = self->priv->selected_row;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = self->priv->selected_col;
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = _tmp4_[(_tmp5_ * _tmp4__length2) + _tmp6_];
#line 405 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp7_);
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp8_ = cell_row;
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->selected_row = _tmp8_;
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = cell_col;
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->selected_col = _tmp9_;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10_ = self->priv->cells;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10__length1 = self->priv->cells_length1;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10__length2 = self->priv->cells_length2;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = self->priv->selected_row;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp12_ = self->priv->selected_col;
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp13_ = _tmp10_[(_tmp11_ * _tmp10__length2) + _tmp12_];
#line 408 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_set_selected (_tmp13_, TRUE);
#line 2803 "sudoku-view.c"
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return _data6_;
#line 2812 "sudoku-view.c"
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 2821 "sudoku-view.c"
		SudokuView* self;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		self = _data6_->self;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (_data6_->game);
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (self);
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_slice_free (Block6Data, _data6_);
#line 2831 "sudoku-view.c"
	}
}


static gboolean _sudoku_view_draw_board_gtk_widget_draw (GtkWidget* _sender, cairo_t* cr, gpointer self) {
	gboolean result;
	result = sudoku_view_draw_board ((SudokuView*) self, cr);
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 2841 "sudoku-view.c"
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return _data7_;
#line 2850 "sudoku-view.c"
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 2859 "sudoku-view.c"
		SudokuView* self;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		self = _data7_->_data6_->self;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		block6_data_unref (_data7_->_data6_);
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_data7_->_data6_ = NULL;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_slice_free (Block7Data, _data7_);
#line 2869 "sudoku-view.c"
	}
}


static gboolean ________lambda11_ (Block7Data* _data7_) {
	Block6Data* _data6_;
	SudokuView* self;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	SudokuCellView** _tmp110_ = NULL;
	gint _tmp110__length1 = 0;
	gint _tmp110__length2 = 0;
	gint _tmp111_ = 0;
	gint _tmp112_ = 0;
	SudokuCellView* _tmp113_ = NULL;
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data6_ = _data7_->_data6_;
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = _data6_->self;
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = _data7_->cell_row;
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = _data7_->cell_col;
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_view_set_selected (self, _tmp0_, _tmp1_);
#line 2896 "sudoku-view.c"
	{
		gint col_tmp = 0;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		col_tmp = 0;
#line 2901 "sudoku-view.c"
		{
			gboolean _tmp2_ = FALSE;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp2_ = TRUE;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 2908 "sudoku-view.c"
				gint _tmp4_ = 0;
				SudokuGame* _tmp5_ = NULL;
				SudokuBoard* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				GdkRGBA _tmp9_ = {0};
				gboolean _tmp10_ = FALSE;
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				GdkRGBA color = {0};
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp2_) {
#line 2921 "sudoku-view.c"
					gint _tmp3_ = 0;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp3_ = col_tmp;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					col_tmp = _tmp3_ + 1;
#line 2927 "sudoku-view.c"
				}
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp2_ = FALSE;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp4_ = col_tmp;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp5_ = _data6_->game;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp6_ = _tmp5_->board;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp7_ = sudoku_board_get_cols (_tmp6_);
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp8_ = _tmp7_;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp4_ < _tmp8_)) {
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 2945 "sudoku-view.c"
				}
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp11_ = col_tmp;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp12_ = _data7_->cell_col;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (_tmp11_ == _tmp12_) {
#line 2953 "sudoku-view.c"
					gboolean _tmp13_ = FALSE;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp13_ = self->priv->_highlighter;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp10_ = _tmp13_;
#line 2959 "sudoku-view.c"
				} else {
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp10_ = FALSE;
#line 2963 "sudoku-view.c"
				}
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (_tmp10_) {
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp9_ = SUDOKU_VIEW_highlight_color;
#line 2969 "sudoku-view.c"
				} else {
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp9_ = SUDOKU_VIEW_free_cell_color;
#line 2973 "sudoku-view.c"
				}
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				color = _tmp9_;
#line 2977 "sudoku-view.c"
				{
					gint row_tmp = 0;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					row_tmp = 0;
#line 2982 "sudoku-view.c"
					{
						gboolean _tmp14_ = FALSE;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp14_ = TRUE;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 2989 "sudoku-view.c"
							gint _tmp16_ = 0;
							SudokuGame* _tmp17_ = NULL;
							SudokuBoard* _tmp18_ = NULL;
							gint _tmp19_ = 0;
							gint _tmp20_ = 0;
							GdkRGBA _tmp21_ = {0};
							SudokuCellView** _tmp22_ = NULL;
							gint _tmp22__length1 = 0;
							gint _tmp22__length2 = 0;
							gint _tmp23_ = 0;
							gint _tmp24_ = 0;
							SudokuCellView* _tmp25_ = NULL;
							gboolean _tmp26_ = FALSE;
							gboolean _tmp27_ = FALSE;
							SudokuCellView** _tmp29_ = NULL;
							gint _tmp29__length1 = 0;
							gint _tmp29__length2 = 0;
							gint _tmp30_ = 0;
							gint _tmp31_ = 0;
							SudokuCellView* _tmp32_ = NULL;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp14_) {
#line 3012 "sudoku-view.c"
								gint _tmp15_ = 0;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp15_ = row_tmp;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								row_tmp = _tmp15_ + 1;
#line 3018 "sudoku-view.c"
							}
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp14_ = FALSE;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp16_ = row_tmp;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp17_ = _data6_->game;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp18_ = _tmp17_->board;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp19_ = sudoku_board_get_rows (_tmp18_);
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp20_ = _tmp19_;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp16_ < _tmp20_)) {
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 3036 "sudoku-view.c"
							}
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp22_ = self->priv->cells;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp22__length1 = self->priv->cells_length1;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp22__length2 = self->priv->cells_length2;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp23_ = row_tmp;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp24_ = col_tmp;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp25_ = _tmp22_[(_tmp23_ * _tmp22__length2) + _tmp24_];
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp26_ = sudoku_cell_view_get_is_fixed (_tmp25_);
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp27_ = _tmp26_;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (_tmp27_) {
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp21_ = SUDOKU_VIEW_fixed_cell_color;
#line 3058 "sudoku-view.c"
							} else {
								GdkRGBA _tmp28_ = {0};
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp28_ = color;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp21_ = _tmp28_;
#line 3065 "sudoku-view.c"
							}
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp29_ = self->priv->cells;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp29__length1 = self->priv->cells_length1;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp29__length2 = self->priv->cells_length2;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp30_ = row_tmp;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp31_ = col_tmp;
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp32_ = _tmp29_[(_tmp30_ * _tmp29__length2) + _tmp31_];
#line 452 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_set_background_color (_tmp32_, &_tmp21_);
#line 3081 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
	{
		gint col_tmp = 0;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		col_tmp = 0;
#line 3092 "sudoku-view.c"
		{
			gboolean _tmp33_ = FALSE;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp33_ = TRUE;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 3099 "sudoku-view.c"
				gint _tmp35_ = 0;
				SudokuGame* _tmp36_ = NULL;
				SudokuBoard* _tmp37_ = NULL;
				gint _tmp38_ = 0;
				gint _tmp39_ = 0;
				SudokuCellView** _tmp40_ = NULL;
				gint _tmp40__length1 = 0;
				gint _tmp40__length2 = 0;
				gint _tmp41_ = 0;
				gint _tmp42_ = 0;
				SudokuCellView* _tmp43_ = NULL;
				gboolean _tmp44_ = FALSE;
				gboolean _tmp45_ = FALSE;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp33_) {
#line 3115 "sudoku-view.c"
					gint _tmp34_ = 0;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp34_ = col_tmp;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					col_tmp = _tmp34_ + 1;
#line 3121 "sudoku-view.c"
				}
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp33_ = FALSE;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp35_ = col_tmp;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp36_ = _data6_->game;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp37_ = _tmp36_->board;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp38_ = sudoku_board_get_cols (_tmp37_);
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp39_ = _tmp38_;
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp35_ < _tmp39_)) {
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 3139 "sudoku-view.c"
				}
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp40_ = self->priv->cells;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp40__length1 = self->priv->cells_length1;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp40__length2 = self->priv->cells_length2;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp41_ = _data7_->cell_row;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp42_ = col_tmp;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp43_ = _tmp40_[(_tmp41_ * _tmp40__length2) + _tmp42_];
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp44_ = sudoku_cell_view_get_is_fixed (_tmp43_);
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp45_ = _tmp44_;
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (_tmp45_) {
#line 3159 "sudoku-view.c"
					SudokuCellView** _tmp46_ = NULL;
					gint _tmp46__length1 = 0;
					gint _tmp46__length2 = 0;
					gint _tmp47_ = 0;
					gint _tmp48_ = 0;
					SudokuCellView* _tmp49_ = NULL;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp46_ = self->priv->cells;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp46__length1 = self->priv->cells_length1;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp46__length2 = self->priv->cells_length2;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp47_ = _data7_->cell_row;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp48_ = col_tmp;
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp49_ = _tmp46_[(_tmp47_ * _tmp46__length2) + _tmp48_];
#line 457 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					sudoku_cell_view_set_background_color (_tmp49_, &SUDOKU_VIEW_fixed_cell_color);
#line 3180 "sudoku-view.c"
				} else {
					gboolean _tmp50_ = FALSE;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp50_ = self->priv->_highlighter;
#line 458 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					if (_tmp50_) {
#line 3187 "sudoku-view.c"
						SudokuCellView** _tmp51_ = NULL;
						gint _tmp51__length1 = 0;
						gint _tmp51__length2 = 0;
						gint _tmp52_ = 0;
						gint _tmp53_ = 0;
						SudokuCellView* _tmp54_ = NULL;
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp51_ = self->priv->cells;
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp51__length1 = self->priv->cells_length1;
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp51__length2 = self->priv->cells_length2;
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp52_ = _data7_->cell_row;
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp53_ = col_tmp;
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp54_ = _tmp51_[(_tmp52_ * _tmp51__length2) + _tmp53_];
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						sudoku_cell_view_set_background_color (_tmp54_, &SUDOKU_VIEW_highlight_color);
#line 3208 "sudoku-view.c"
					} else {
						SudokuCellView** _tmp55_ = NULL;
						gint _tmp55__length1 = 0;
						gint _tmp55__length2 = 0;
						gint _tmp56_ = 0;
						gint _tmp57_ = 0;
						SudokuCellView* _tmp58_ = NULL;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp55_ = self->priv->cells;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp55__length1 = self->priv->cells_length1;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp55__length2 = self->priv->cells_length2;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp56_ = _data7_->cell_row;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp57_ = col_tmp;
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp58_ = _tmp55_[(_tmp56_ * _tmp55__length2) + _tmp57_];
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						sudoku_cell_view_set_background_color (_tmp58_, &SUDOKU_VIEW_free_cell_color);
#line 3230 "sudoku-view.c"
					}
				}
			}
		}
	}
	{
		GeeList* _coord_list = NULL;
		SudokuGame* _tmp59_ = NULL;
		SudokuBoard* _tmp60_ = NULL;
		GeeMap* _tmp61_ = NULL;
		gint _tmp62_ = 0;
		SudokuGame* _tmp63_ = NULL;
		SudokuBoard* _tmp64_ = NULL;
		gint _tmp65_ = 0;
		gint _tmp66_ = 0;
		gint _tmp67_ = 0;
		SudokuGame* _tmp68_ = NULL;
		SudokuBoard* _tmp69_ = NULL;
		gint _tmp70_ = 0;
		gint _tmp71_ = 0;
		Coord _tmp72_ = {0};
		gpointer _tmp73_ = NULL;
		gint _coord_size = 0;
		GeeList* _tmp74_ = NULL;
		gint _tmp75_ = 0;
		gint _tmp76_ = 0;
		gint _coord_index = 0;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp59_ = _data6_->game;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp60_ = _tmp59_->board;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp61_ = _tmp60_->coords_for_block;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp62_ = _data7_->cell_row;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp63_ = _data6_->game;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp64_ = _tmp63_->board;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp65_ = sudoku_board_get_block_rows (_tmp64_);
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp66_ = _tmp65_;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp67_ = _data7_->cell_col;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp68_ = _data6_->game;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp69_ = _tmp68_->board;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp70_ = sudoku_board_get_block_cols (_tmp69_);
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp71_ = _tmp70_;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		coord_init (&_tmp72_, _tmp62_ / _tmp66_, _tmp67_ / _tmp71_);
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp73_ = gee_map_get (_tmp61_, &_tmp72_);
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_coord_list = (GeeList*) _tmp73_;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp74_ = _coord_list;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp75_ = gee_collection_get_size ((GeeCollection*) _tmp74_);
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp76_ = _tmp75_;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_coord_size = _tmp76_;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_coord_index = -1;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		while (TRUE) {
#line 3302 "sudoku-view.c"
			gint _tmp77_ = 0;
			gint _tmp78_ = 0;
			gint _tmp79_ = 0;
			Coord* coord = NULL;
			GeeList* _tmp80_ = NULL;
			gint _tmp81_ = 0;
			gpointer _tmp82_ = NULL;
			SudokuCellView** _tmp83_ = NULL;
			gint _tmp83__length1 = 0;
			gint _tmp83__length2 = 0;
			Coord* _tmp84_ = NULL;
			gint _tmp85_ = 0;
			Coord* _tmp86_ = NULL;
			gint _tmp87_ = 0;
			SudokuCellView* _tmp88_ = NULL;
			gboolean _tmp89_ = FALSE;
			gboolean _tmp90_ = FALSE;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp77_ = _coord_index;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_coord_index = _tmp77_ + 1;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp78_ = _coord_index;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp79_ = _coord_size;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			if (!(_tmp78_ < _tmp79_)) {
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				break;
#line 3332 "sudoku-view.c"
			}
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp80_ = _coord_list;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp81_ = _coord_index;
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp82_ = gee_list_get (_tmp80_, _tmp81_);
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			coord = (Coord*) _tmp82_;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp83_ = self->priv->cells;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp83__length1 = self->priv->cells_length1;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp83__length2 = self->priv->cells_length2;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp84_ = coord;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp85_ = (*_tmp84_).row;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp86_ = coord;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp87_ = (*_tmp86_).col;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp88_ = _tmp83_[(_tmp85_ * _tmp83__length2) + _tmp87_];
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp89_ = sudoku_cell_view_get_is_fixed (_tmp88_);
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp90_ = _tmp89_;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			if (_tmp90_) {
#line 3364 "sudoku-view.c"
				SudokuCellView** _tmp91_ = NULL;
				gint _tmp91__length1 = 0;
				gint _tmp91__length2 = 0;
				Coord* _tmp92_ = NULL;
				gint _tmp93_ = 0;
				Coord* _tmp94_ = NULL;
				gint _tmp95_ = 0;
				SudokuCellView* _tmp96_ = NULL;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp91_ = self->priv->cells;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp91__length1 = self->priv->cells_length1;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp91__length2 = self->priv->cells_length2;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp92_ = coord;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp93_ = (*_tmp92_).row;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp94_ = coord;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp95_ = (*_tmp94_).col;
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp96_ = _tmp91_[(_tmp93_ * _tmp91__length2) + _tmp95_];
#line 467 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				sudoku_cell_view_set_background_color (_tmp96_, &SUDOKU_VIEW_fixed_cell_color);
#line 3391 "sudoku-view.c"
			} else {
				gboolean _tmp97_ = FALSE;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp97_ = self->priv->_highlighter;
#line 468 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (_tmp97_) {
#line 3398 "sudoku-view.c"
					SudokuCellView** _tmp98_ = NULL;
					gint _tmp98__length1 = 0;
					gint _tmp98__length2 = 0;
					Coord* _tmp99_ = NULL;
					gint _tmp100_ = 0;
					Coord* _tmp101_ = NULL;
					gint _tmp102_ = 0;
					SudokuCellView* _tmp103_ = NULL;
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp98_ = self->priv->cells;
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp98__length1 = self->priv->cells_length1;
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp98__length2 = self->priv->cells_length2;
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp99_ = coord;
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp100_ = (*_tmp99_).row;
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp101_ = coord;
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp102_ = (*_tmp101_).col;
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp103_ = _tmp98_[(_tmp100_ * _tmp98__length2) + _tmp102_];
#line 469 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					sudoku_cell_view_set_background_color (_tmp103_, &SUDOKU_VIEW_highlight_color);
#line 3425 "sudoku-view.c"
				} else {
					SudokuCellView** _tmp104_ = NULL;
					gint _tmp104__length1 = 0;
					gint _tmp104__length2 = 0;
					Coord* _tmp105_ = NULL;
					gint _tmp106_ = 0;
					Coord* _tmp107_ = NULL;
					gint _tmp108_ = 0;
					SudokuCellView* _tmp109_ = NULL;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp104_ = self->priv->cells;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp104__length1 = self->priv->cells_length1;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp104__length2 = self->priv->cells_length2;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp105_ = coord;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp106_ = (*_tmp105_).row;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp107_ = coord;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp108_ = (*_tmp107_).col;
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp109_ = _tmp104_[(_tmp106_ * _tmp104__length2) + _tmp108_];
#line 471 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					sudoku_cell_view_set_background_color (_tmp109_, &SUDOKU_VIEW_free_cell_color);
#line 3453 "sudoku-view.c"
				}
			}
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_g_free0 (coord);
#line 3458 "sudoku-view.c"
		}
#line 464 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_g_object_unref0 (_coord_list);
#line 3462 "sudoku-view.c"
	}
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp110_ = self->priv->cells;
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp110__length1 = self->priv->cells_length1;
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp110__length2 = self->priv->cells_length2;
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp111_ = _data7_->cell_row;
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp112_ = _data7_->cell_col;
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp113_ = _tmp110_[(_tmp111_ * _tmp110__length2) + _tmp112_];
#line 474 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_cell_view_set_background_color (_tmp113_, &SUDOKU_VIEW_selected_bg_color);
#line 476 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 478 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 3484 "sudoku-view.c"
}


static gboolean _________lambda11__gtk_widget_focus_in_event (GtkWidget* _sender, GdkEventFocus* event, gpointer self) {
	gboolean result;
	result = ________lambda11_ (self);
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 3493 "sudoku-view.c"
}


static void ________lambda12_ (Block7Data* _data7_, GObject* s, GParamSpec* p) {
	Block6Data* _data6_;
	SudokuView* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data6_ = _data7_->_data6_;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = _data6_->self;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (s != NULL);
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (p != NULL);
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->_show_possibilities;
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp3_) {
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp2_ = TRUE;
#line 3518 "sudoku-view.c"
	} else {
		gboolean _tmp4_ = FALSE;
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp4_ = self->priv->_show_warnings;
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp2_ = _tmp4_;
#line 3525 "sudoku-view.c"
	}
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp2_) {
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp1_ = TRUE;
#line 3531 "sudoku-view.c"
	} else {
		SudokuGame* _tmp5_ = NULL;
		SudokuBoard* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp5_ = _data6_->game;
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp6_ = _tmp5_->board;
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = sudoku_board_get_broken (_tmp6_);
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = _tmp7_;
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp1_ = _tmp8_;
#line 3547 "sudoku-view.c"
	}
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp1_) {
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = TRUE;
#line 3553 "sudoku-view.c"
	} else {
		gboolean _tmp9_ = FALSE;
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = self->priv->previous_board_broken_state;
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp0_ = _tmp9_;
#line 3560 "sudoku-view.c"
	}
#line 482 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp0_) {
#line 3564 "sudoku-view.c"
		SudokuGame* _tmp10_ = NULL;
		SudokuBoard* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp10_ = _data6_->game;
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp11_ = _tmp10_->board;
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp12_ = sudoku_board_get_broken (_tmp11_);
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp13_ = _tmp12_;
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		self->priv->previous_board_broken_state = _tmp13_;
#line 3579 "sudoku-view.c"
	}
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_queue_draw ((GtkWidget*) self);
#line 3583 "sudoku-view.c"
}


static void _________lambda12__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	________lambda12_ (self, _sender, pspec);
#line 3590 "sudoku-view.c"
}


SudokuView* sudoku_view_construct (GType object_type, SudokuGame* game) {
	SudokuView * self = NULL;
	Block6Data* _data6_;
	SudokuGame* _tmp0_ = NULL;
	SudokuGame* _tmp1_ = NULL;
	GtkOverlay* _tmp2_ = NULL;
	GtkOverlay* _tmp3_ = NULL;
	GtkDrawingArea* _tmp4_ = NULL;
	GtkDrawingArea* _tmp5_ = NULL;
	GtkGrid* _tmp6_ = NULL;
	SudokuGame* _tmp9_ = NULL;
	SudokuGame* _tmp10_ = NULL;
	GtkGrid* _tmp11_ = NULL;
	GtkGrid* _tmp12_ = NULL;
	GtkGrid* _tmp13_ = NULL;
	GtkGrid* _tmp14_ = NULL;
	GtkGrid* _tmp15_ = NULL;
	SudokuGame* _tmp16_ = NULL;
	SudokuBoard* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	gint _tmp19_ = 0;
	SudokuGame* _tmp20_ = NULL;
	SudokuBoard* _tmp21_ = NULL;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	SudokuCellView** _tmp24_ = NULL;
	GtkOverlay* _tmp61_ = NULL;
	GtkDrawingArea* _tmp62_ = NULL;
	GtkOverlay* _tmp63_ = NULL;
	GtkGrid* _tmp64_ = NULL;
	GtkDrawingArea* _tmp65_ = NULL;
	GtkGrid* _tmp66_ = NULL;
	GtkOverlay* _tmp67_ = NULL;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (game != NULL, NULL);
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data6_ = g_slice_new0 (Block6Data);
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data6_->_ref_count_ = 1;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = game;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (_data6_->game);
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data6_->game = _tmp1_;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = (SudokuView*) g_object_new (object_type, NULL);
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data6_->self = g_object_ref (self);
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_frame_set_shadow_type ((GtkFrame*) self, GTK_SHADOW_NONE);
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_set ((GtkAspectFrame*) self, "obey-child", FALSE, NULL);
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_set ((GtkAspectFrame*) self, "ratio", (gfloat) 1, NULL);
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = (GtkOverlay*) gtk_overlay_new ();
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp2_);
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->overlay);
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->overlay = _tmp2_;
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->priv->overlay;
#line 418 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp3_);
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = (GtkDrawingArea*) gtk_drawing_area_new ();
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp4_);
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->drawing);
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->drawing = _tmp4_;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = self->priv->drawing;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_signal_connect_object ((GtkWidget*) _tmp5_, "draw", (GCallback) _sudoku_view_draw_board_gtk_widget_draw, self, 0);
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = self->priv->grid;
#line 423 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp6_ != NULL) {
#line 3679 "sudoku-view.c"
		GtkOverlay* _tmp7_ = NULL;
		GtkGrid* _tmp8_ = NULL;
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp7_ = self->priv->overlay;
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = self->priv->grid;
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		gtk_container_remove ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp8_);
#line 3688 "sudoku-view.c"
	}
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp9_ = _data6_->game;
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->game);
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->game = _tmp10_;
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp11_ = (GtkGrid*) gtk_grid_new ();
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_ref_sink (_tmp11_);
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->grid);
#line 428 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->grid = _tmp11_;
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp12_ = self->priv->grid;
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_grid_set_row_spacing (_tmp12_, 1);
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp13_ = self->priv->grid;
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_grid_set_column_spacing (_tmp13_, 1);
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp14_ = self->priv->grid;
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_grid_set_column_homogeneous (_tmp14_, TRUE);
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp15_ = self->priv->grid;
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_grid_set_row_homogeneous (_tmp15_, TRUE);
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp16_ = _data6_->game;
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp17_ = _tmp16_->board;
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp18_ = sudoku_board_get_rows (_tmp17_);
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp19_ = _tmp18_;
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp20_ = _data6_->game;
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp21_ = _tmp20_->board;
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp22_ = sudoku_board_get_cols (_tmp21_);
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp23_ = _tmp22_;
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp24_ = g_new0 (SudokuCellView*, (_tmp19_ * _tmp23_) + 1);
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->cells = (_vala_array_free (self->priv->cells, self->priv->cells_length1 * self->priv->cells_length2, (GDestroyNotify) g_object_unref), NULL);
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->cells = _tmp24_;
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->cells_length1 = _tmp19_;
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->cells_length2 = _tmp23_;
#line 3748 "sudoku-view.c"
	{
		gint row = 0;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		row = 0;
#line 3753 "sudoku-view.c"
		{
			gboolean _tmp25_ = FALSE;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp25_ = TRUE;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 3760 "sudoku-view.c"
				gint _tmp27_ = 0;
				SudokuGame* _tmp28_ = NULL;
				SudokuBoard* _tmp29_ = NULL;
				gint _tmp30_ = 0;
				gint _tmp31_ = 0;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp25_) {
#line 3768 "sudoku-view.c"
					gint _tmp26_ = 0;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp26_ = row;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					row = _tmp26_ + 1;
#line 3774 "sudoku-view.c"
				}
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp25_ = FALSE;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp27_ = row;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp28_ = _data6_->game;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp29_ = _tmp28_->board;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp30_ = sudoku_board_get_rows (_tmp29_);
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp31_ = _tmp30_;
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp27_ < _tmp31_)) {
#line 435 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 3792 "sudoku-view.c"
				}
				{
					gint col = 0;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					col = 0;
#line 3798 "sudoku-view.c"
					{
						gboolean _tmp32_ = FALSE;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp32_ = TRUE;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 3805 "sudoku-view.c"
							Block7Data* _data7_;
							gint _tmp34_ = 0;
							SudokuGame* _tmp35_ = NULL;
							SudokuBoard* _tmp36_ = NULL;
							gint _tmp37_ = 0;
							gint _tmp38_ = 0;
							SudokuCellView* cell = NULL;
							gint _tmp39_ = 0;
							gint _tmp40_ = 0;
							SudokuCellView* _tmp41_ = NULL;
							gint _tmp42_ = 0;
							gint _tmp43_ = 0;
							GdkRGBA _tmp44_ = {0};
							SudokuCellView* _tmp45_ = NULL;
							gboolean _tmp46_ = FALSE;
							gboolean _tmp47_ = FALSE;
							SudokuCellView* _tmp48_ = NULL;
							SudokuCellView* _tmp49_ = NULL;
							SudokuCellView* _tmp50_ = NULL;
							SudokuCellView** _tmp51_ = NULL;
							gint _tmp51__length1 = 0;
							gint _tmp51__length2 = 0;
							gint _tmp52_ = 0;
							gint _tmp53_ = 0;
							SudokuCellView* _tmp54_ = NULL;
							SudokuCellView* _tmp55_ = NULL;
							SudokuCellView* _tmp56_ = NULL;
							GtkGrid* _tmp57_ = NULL;
							SudokuCellView* _tmp58_ = NULL;
							gint _tmp59_ = 0;
							gint _tmp60_ = 0;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_data7_ = g_slice_new0 (Block7Data);
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_data7_->_ref_count_ = 1;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_data7_->_data6_ = block6_data_ref (_data6_);
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp32_) {
#line 3845 "sudoku-view.c"
								gint _tmp33_ = 0;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp33_ = col;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								col = _tmp33_ + 1;
#line 3851 "sudoku-view.c"
							}
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp32_ = FALSE;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp34_ = col;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp35_ = _data6_->game;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp36_ = _tmp35_->board;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp37_ = sudoku_board_get_cols (_tmp36_);
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp38_ = _tmp37_;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp34_ < _tmp38_)) {
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								block7_data_unref (_data7_);
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_data7_ = NULL;
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 3873 "sudoku-view.c"
							}
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp39_ = row;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp40_ = col;
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp41_ = sudoku_cell_view_new (_tmp39_, _tmp40_, &self->game);
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							g_object_ref_sink (_tmp41_);
#line 439 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							cell = _tmp41_;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp42_ = row;
#line 440 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_data7_->cell_row = _tmp42_;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp43_ = col;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_data7_->cell_col = _tmp43_;
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp45_ = cell;
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp46_ = sudoku_cell_view_get_is_fixed (_tmp45_);
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp47_ = _tmp46_;
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (_tmp47_) {
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp44_ = SUDOKU_VIEW_fixed_cell_color;
#line 3903 "sudoku-view.c"
							} else {
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp44_ = SUDOKU_VIEW_free_cell_color;
#line 3907 "sudoku-view.c"
							}
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp48_ = cell;
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_set_background_color (_tmp48_, &_tmp44_);
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp49_ = cell;
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							g_signal_connect_data ((GtkWidget*) _tmp49_, "focus-in-event", (GCallback) _________lambda11__gtk_widget_focus_in_event, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp50_ = cell;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							g_signal_connect_data ((GObject*) _tmp50_, "notify::value", (GCallback) _________lambda12__g_object_notify, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp51_ = self->priv->cells;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp51__length1 = self->priv->cells_length1;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp51__length2 = self->priv->cells_length2;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp52_ = row;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp53_ = col;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp54_ = cell;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp55_ = _g_object_ref0 (_tmp54_);
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_g_object_unref0 (_tmp51_[(_tmp52_ * _tmp51__length2) + _tmp53_]);
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp51_[(_tmp52_ * _tmp51__length2) + _tmp53_] = _tmp55_;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp56_ = _tmp51_[(_tmp52_ * _tmp51__length2) + _tmp53_];
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp57_ = self->priv->grid;
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp58_ = cell;
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp59_ = col;
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp60_ = row;
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							gtk_grid_attach (_tmp57_, (GtkWidget*) _tmp58_, _tmp59_, _tmp60_, 1, 1);
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_g_object_unref0 (cell);
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							block7_data_unref (_data7_);
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_data7_ = NULL;
#line 3957 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp61_ = self->priv->overlay;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp62_ = self->priv->drawing;
#line 494 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_container_add ((GtkContainer*) _tmp61_, (GtkWidget*) _tmp62_);
#line 495 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp63_ = self->priv->overlay;
#line 495 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp64_ = self->priv->grid;
#line 495 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_overlay_add_overlay (_tmp63_, (GtkWidget*) _tmp64_);
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp65_ = self->priv->drawing;
#line 496 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp65_);
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp66_ = self->priv->grid;
#line 497 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp66_);
#line 498 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp67_ = self->priv->overlay;
#line 498 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	gtk_widget_show ((GtkWidget*) _tmp67_);
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	block6_data_unref (_data6_);
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_data6_ = NULL;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return self;
#line 3994 "sudoku-view.c"
}


SudokuView* sudoku_view_new (SudokuGame* game) {
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return sudoku_view_construct (TYPE_SUDOKU_VIEW, game);
#line 4001 "sudoku-view.c"
}


static gboolean sudoku_view_draw_board (SudokuView* self, cairo_t* c) {
	gboolean result = FALSE;
	gint board_length = 0;
	GtkGrid* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gdouble tile_length = 0.0;
	gint _tmp2_ = 0;
	SudokuGame* _tmp3_ = NULL;
	SudokuBoard* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	GtkTextDirection _tmp7_ = 0;
	cairo_t* _tmp48_ = NULL;
	cairo_t* _tmp49_ = NULL;
	cairo_t* _tmp88_ = NULL;
	cairo_t* _tmp89_ = NULL;
	cairo_t* _tmp126_ = NULL;
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 501 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (c != NULL, FALSE);
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->grid;
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp1_ = gtk_widget_get_allocated_width ((GtkWidget*) _tmp0_);
#line 503 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	board_length = _tmp1_;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp2_ = board_length;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp3_ = self->game;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp4_ = _tmp3_->board;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp5_ = sudoku_board_get_cols (_tmp4_);
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp6_ = _tmp5_;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	tile_length = ((gdouble) (_tmp2_ - 1)) / _tmp6_;
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp7_ = gtk_widget_get_default_direction ();
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	if (_tmp7_ == GTK_TEXT_DIR_RTL) {
#line 4048 "sudoku-view.c"
		cairo_t* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		cairo_t* _tmp10_ = NULL;
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp8_ = c;
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp9_ = board_length;
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_translate (_tmp8_, (gdouble) _tmp9_, (gdouble) 0);
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		_tmp10_ = c;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		cairo_scale (_tmp10_, (gdouble) (-1), (gdouble) 1);
#line 4062 "sudoku-view.c"
	}
	{
		gint i = 0;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 4068 "sudoku-view.c"
		{
			gboolean _tmp11_ = FALSE;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp11_ = TRUE;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4075 "sudoku-view.c"
				gint _tmp13_ = 0;
				SudokuGame* _tmp14_ = NULL;
				SudokuBoard* _tmp15_ = NULL;
				gint _tmp16_ = 0;
				gint _tmp17_ = 0;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp11_) {
#line 4083 "sudoku-view.c"
					gint _tmp12_ = 0;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp12_ = i;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp12_ + 1;
#line 4089 "sudoku-view.c"
				}
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp11_ = FALSE;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp13_ = i;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp14_ = self->game;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp15_ = _tmp14_->board;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp16_ = sudoku_board_get_cols (_tmp15_);
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp17_ = _tmp16_;
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp13_ < _tmp17_)) {
#line 514 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4107 "sudoku-view.c"
				}
				{
					gint j = 0;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					j = 0;
#line 4113 "sudoku-view.c"
					{
						gboolean _tmp18_ = FALSE;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp18_ = TRUE;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 4120 "sudoku-view.c"
							gint _tmp20_ = 0;
							SudokuGame* _tmp21_ = NULL;
							SudokuBoard* _tmp22_ = NULL;
							gint _tmp23_ = 0;
							gint _tmp24_ = 0;
							GdkRGBA background_color = {0};
							SudokuCellView** _tmp25_ = NULL;
							gint _tmp25__length1 = 0;
							gint _tmp25__length2 = 0;
							gint _tmp26_ = 0;
							gint _tmp27_ = 0;
							SudokuCellView* _tmp28_ = NULL;
							GdkRGBA _tmp29_ = {0};
							GdkRGBA _tmp30_ = {0};
							cairo_t* _tmp31_ = NULL;
							GdkRGBA _tmp32_ = {0};
							gdouble _tmp33_ = 0.0;
							GdkRGBA _tmp34_ = {0};
							gdouble _tmp35_ = 0.0;
							GdkRGBA _tmp36_ = {0};
							gdouble _tmp37_ = 0.0;
							cairo_t* _tmp38_ = NULL;
							gint _tmp39_ = 0;
							gdouble _tmp40_ = 0.0;
							gint _tmp41_ = 0;
							gdouble _tmp42_ = 0.0;
							gint _tmp43_ = 0;
							gdouble _tmp44_ = 0.0;
							gint _tmp45_ = 0;
							gdouble _tmp46_ = 0.0;
							cairo_t* _tmp47_ = NULL;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp18_) {
#line 4154 "sudoku-view.c"
								gint _tmp19_ = 0;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp19_ = j;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								j = _tmp19_ + 1;
#line 4160 "sudoku-view.c"
							}
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp18_ = FALSE;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp20_ = j;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp21_ = self->game;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp22_ = _tmp21_->board;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp23_ = sudoku_board_get_cols (_tmp22_);
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp24_ = _tmp23_;
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp20_ < _tmp24_)) {
#line 516 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 4178 "sudoku-view.c"
							}
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp25_ = self->priv->cells;
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp25__length1 = self->priv->cells_length1;
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp25__length2 = self->priv->cells_length2;
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp26_ = i;
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp27_ = j;
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp28_ = _tmp25_[(_tmp26_ * _tmp25__length2) + _tmp27_];
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_get_background_color (_tmp28_, &_tmp29_);
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp30_ = _tmp29_;
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							background_color = _tmp30_;
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp31_ = c;
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp32_ = background_color;
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp33_ = _tmp32_.red;
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp34_ = background_color;
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp35_ = _tmp34_.green;
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp36_ = background_color;
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp37_ = _tmp36_.blue;
#line 519 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							cairo_set_source_rgb (_tmp31_, _tmp33_, _tmp35_, _tmp37_);
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp38_ = c;
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp39_ = j;
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp40_ = tile_length;
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp41_ = i;
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp42_ = tile_length;
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp43_ = j;
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp44_ = tile_length;
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp45_ = i;
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp46_ = tile_length;
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							cairo_rectangle (_tmp38_, ((gint) (_tmp39_ * _tmp40_)) + 0.5, ((gint) (_tmp41_ * _tmp42_)) + 0.5, ((gint) ((_tmp43_ + 1) * _tmp44_)) + 0.5, ((gint) ((_tmp45_ + 1) * _tmp46_)) + 0.5);
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp47_ = c;
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							cairo_fill (_tmp47_);
#line 4238 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp48_ = c;
#line 526 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	cairo_set_line_width (_tmp48_, (gdouble) 1);
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp49_ = c;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	cairo_set_source_rgb (_tmp49_, 0.6, 0.6, 0.6);
#line 4253 "sudoku-view.c"
	{
		gint i = 0;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 1;
#line 4258 "sudoku-view.c"
		{
			gboolean _tmp50_ = FALSE;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp50_ = TRUE;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4265 "sudoku-view.c"
				gint _tmp52_ = 0;
				SudokuGame* _tmp53_ = NULL;
				SudokuBoard* _tmp54_ = NULL;
				gint _tmp55_ = 0;
				gint _tmp56_ = 0;
				gint _tmp57_ = 0;
				SudokuGame* _tmp58_ = NULL;
				SudokuBoard* _tmp59_ = NULL;
				gint _tmp60_ = 0;
				gint _tmp61_ = 0;
				cairo_t* _tmp62_ = NULL;
				gint _tmp63_ = 0;
				gdouble _tmp64_ = 0.0;
				cairo_t* _tmp65_ = NULL;
				gint _tmp66_ = 0;
				gdouble _tmp67_ = 0.0;
				gint _tmp68_ = 0;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp50_) {
#line 4285 "sudoku-view.c"
					gint _tmp51_ = 0;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp51_ = i;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp51_ + 1;
#line 4291 "sudoku-view.c"
				}
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp50_ = FALSE;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp52_ = i;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp53_ = self->game;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp54_ = _tmp53_->board;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp55_ = sudoku_board_get_cols (_tmp54_);
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp56_ = _tmp55_;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp52_ < _tmp56_)) {
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4309 "sudoku-view.c"
				}
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp57_ = i;
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp58_ = self->game;
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp59_ = _tmp58_->board;
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp60_ = sudoku_board_get_block_cols (_tmp59_);
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp61_ = _tmp60_;
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if ((_tmp57_ % _tmp61_) == 0) {
#line 531 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					continue;
#line 4325 "sudoku-view.c"
				}
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp62_ = c;
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp63_ = i;
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp64_ = tile_length;
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_move_to (_tmp62_, ((gint) (_tmp63_ * _tmp64_)) + 0.5, (gdouble) 1);
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp65_ = c;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp66_ = i;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp67_ = tile_length;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp68_ = board_length;
#line 534 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_line_to (_tmp65_, ((gint) (_tmp66_ * _tmp67_)) + 0.5, (gdouble) _tmp68_);
#line 4345 "sudoku-view.c"
			}
		}
	}
	{
		gint i = 0;
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 1;
#line 4353 "sudoku-view.c"
		{
			gboolean _tmp69_ = FALSE;
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp69_ = TRUE;
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4360 "sudoku-view.c"
				gint _tmp71_ = 0;
				SudokuGame* _tmp72_ = NULL;
				SudokuBoard* _tmp73_ = NULL;
				gint _tmp74_ = 0;
				gint _tmp75_ = 0;
				gint _tmp76_ = 0;
				SudokuGame* _tmp77_ = NULL;
				SudokuBoard* _tmp78_ = NULL;
				gint _tmp79_ = 0;
				gint _tmp80_ = 0;
				cairo_t* _tmp81_ = NULL;
				gint _tmp82_ = 0;
				gdouble _tmp83_ = 0.0;
				cairo_t* _tmp84_ = NULL;
				gint _tmp85_ = 0;
				gint _tmp86_ = 0;
				gdouble _tmp87_ = 0.0;
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp69_) {
#line 4380 "sudoku-view.c"
					gint _tmp70_ = 0;
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp70_ = i;
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp70_ + 1;
#line 4386 "sudoku-view.c"
				}
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp69_ = FALSE;
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp71_ = i;
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp72_ = self->game;
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp73_ = _tmp72_->board;
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp74_ = sudoku_board_get_cols (_tmp73_);
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp75_ = _tmp74_;
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp71_ < _tmp75_)) {
#line 536 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4404 "sudoku-view.c"
				}
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp76_ = i;
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp77_ = self->game;
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp78_ = _tmp77_->board;
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp79_ = sudoku_board_get_block_rows (_tmp78_);
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp80_ = _tmp79_;
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if ((_tmp76_ % _tmp80_) == 0) {
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					continue;
#line 4420 "sudoku-view.c"
				}
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp81_ = c;
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp82_ = i;
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp83_ = tile_length;
#line 541 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_move_to (_tmp81_, (gdouble) 1, ((gint) (_tmp82_ * _tmp83_)) + 0.5);
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp84_ = c;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp85_ = board_length;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp86_ = i;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp87_ = tile_length;
#line 542 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_line_to (_tmp84_, (gdouble) _tmp85_, ((gint) (_tmp86_ * _tmp87_)) + 0.5);
#line 4440 "sudoku-view.c"
			}
		}
	}
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp88_ = c;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	cairo_stroke (_tmp88_);
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp89_ = c;
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	cairo_set_source_rgb (_tmp89_, 0.0, 0.0, 0.0);
#line 4452 "sudoku-view.c"
	{
		gint i = 0;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 4457 "sudoku-view.c"
		{
			gboolean _tmp90_ = FALSE;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp90_ = TRUE;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4464 "sudoku-view.c"
				gint _tmp96_ = 0;
				SudokuGame* _tmp97_ = NULL;
				SudokuBoard* _tmp98_ = NULL;
				gint _tmp99_ = 0;
				gint _tmp100_ = 0;
				cairo_t* _tmp101_ = NULL;
				gint _tmp102_ = 0;
				gdouble _tmp103_ = 0.0;
				cairo_t* _tmp104_ = NULL;
				gint _tmp105_ = 0;
				gdouble _tmp106_ = 0.0;
				gint _tmp107_ = 0;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp90_) {
#line 4479 "sudoku-view.c"
					gint _tmp91_ = 0;
					SudokuGame* _tmp92_ = NULL;
					SudokuBoard* _tmp93_ = NULL;
					gint _tmp94_ = 0;
					gint _tmp95_ = 0;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp91_ = i;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp92_ = self->game;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp93_ = _tmp92_->board;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp94_ = sudoku_board_get_block_cols (_tmp93_);
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp95_ = _tmp94_;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp91_ + _tmp95_;
#line 4497 "sudoku-view.c"
				}
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp90_ = FALSE;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp96_ = i;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp97_ = self->game;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp98_ = _tmp97_->board;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp99_ = sudoku_board_get_cols (_tmp98_);
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp100_ = _tmp99_;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp96_ <= _tmp100_)) {
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4515 "sudoku-view.c"
				}
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp101_ = c;
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp102_ = i;
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp103_ = tile_length;
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_move_to (_tmp101_, ((gint) (_tmp102_ * _tmp103_)) + 0.5, (gdouble) 0);
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp104_ = c;
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp105_ = i;
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp106_ = tile_length;
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp107_ = board_length;
#line 550 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_line_to (_tmp104_, ((gint) (_tmp105_ * _tmp106_)) + 0.5, (gdouble) _tmp107_);
#line 4535 "sudoku-view.c"
			}
		}
	}
	{
		gint i = 0;
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 4543 "sudoku-view.c"
		{
			gboolean _tmp108_ = FALSE;
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp108_ = TRUE;
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4550 "sudoku-view.c"
				gint _tmp114_ = 0;
				SudokuGame* _tmp115_ = NULL;
				SudokuBoard* _tmp116_ = NULL;
				gint _tmp117_ = 0;
				gint _tmp118_ = 0;
				cairo_t* _tmp119_ = NULL;
				gint _tmp120_ = 0;
				gdouble _tmp121_ = 0.0;
				cairo_t* _tmp122_ = NULL;
				gint _tmp123_ = 0;
				gint _tmp124_ = 0;
				gdouble _tmp125_ = 0.0;
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp108_) {
#line 4565 "sudoku-view.c"
					gint _tmp109_ = 0;
					SudokuGame* _tmp110_ = NULL;
					SudokuBoard* _tmp111_ = NULL;
					gint _tmp112_ = 0;
					gint _tmp113_ = 0;
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp109_ = i;
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp110_ = self->game;
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp111_ = _tmp110_->board;
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp112_ = sudoku_board_get_block_rows (_tmp111_);
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp113_ = _tmp112_;
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp109_ + _tmp113_;
#line 4583 "sudoku-view.c"
				}
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp108_ = FALSE;
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp114_ = i;
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp115_ = self->game;
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp116_ = _tmp115_->board;
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp117_ = sudoku_board_get_cols (_tmp116_);
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp118_ = _tmp117_;
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp114_ <= _tmp118_)) {
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4601 "sudoku-view.c"
				}
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp119_ = c;
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp120_ = i;
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp121_ = tile_length;
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_move_to (_tmp119_, (gdouble) 0, ((gint) (_tmp120_ * _tmp121_)) + 0.5);
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp122_ = c;
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp123_ = board_length;
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp124_ = i;
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp125_ = tile_length;
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				cairo_line_to (_tmp122_, (gdouble) _tmp123_, ((gint) (_tmp124_ * _tmp125_)) + 0.5);
#line 4621 "sudoku-view.c"
			}
		}
	}
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp126_ = c;
#line 557 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	cairo_stroke (_tmp126_);
#line 559 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = FALSE;
#line 559 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 4633 "sudoku-view.c"
}


void sudoku_view_clear (SudokuView* self) {
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 4640 "sudoku-view.c"
	{
		gint i = 0;
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 4645 "sudoku-view.c"
		{
			gboolean _tmp0_ = FALSE;
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp0_ = TRUE;
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4652 "sudoku-view.c"
				gint _tmp2_ = 0;
				SudokuGame* _tmp3_ = NULL;
				SudokuBoard* _tmp4_ = NULL;
				gint _tmp5_ = 0;
				gint _tmp6_ = 0;
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp0_) {
#line 4660 "sudoku-view.c"
					gint _tmp1_ = 0;
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp1_ = i;
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp1_ + 1;
#line 4666 "sudoku-view.c"
				}
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp0_ = FALSE;
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp2_ = i;
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp3_ = self->game;
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp4_ = _tmp3_->board;
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp5_ = sudoku_board_get_rows (_tmp4_);
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp6_ = _tmp5_;
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp2_ < _tmp6_)) {
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4684 "sudoku-view.c"
				}
				{
					gint j = 0;
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					j = 0;
#line 4690 "sudoku-view.c"
					{
						gboolean _tmp7_ = FALSE;
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp7_ = TRUE;
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 4697 "sudoku-view.c"
							gint _tmp9_ = 0;
							SudokuGame* _tmp10_ = NULL;
							SudokuBoard* _tmp11_ = NULL;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							SudokuCellView** _tmp14_ = NULL;
							gint _tmp14__length1 = 0;
							gint _tmp14__length2 = 0;
							gint _tmp15_ = 0;
							gint _tmp16_ = 0;
							SudokuCellView* _tmp17_ = NULL;
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp7_) {
#line 4711 "sudoku-view.c"
								gint _tmp8_ = 0;
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp8_ = j;
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								j = _tmp8_ + 1;
#line 4717 "sudoku-view.c"
							}
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp7_ = FALSE;
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp9_ = j;
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp10_ = self->game;
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp11_ = _tmp10_->board;
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp12_ = sudoku_board_get_cols (_tmp11_);
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp13_ = _tmp12_;
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp9_ < _tmp13_)) {
#line 565 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 4735 "sudoku-view.c"
							}
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp14_ = self->priv->cells;
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp14__length1 = self->priv->cells_length1;
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp14__length2 = self->priv->cells_length2;
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15_ = i;
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp16_ = j;
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp17_ = _tmp14_[(_tmp15_ * _tmp14__length2) + _tmp16_];
#line 566 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_clear (_tmp17_);
#line 4751 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
}


gboolean sudoku_view_get_show_warnings (SudokuView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_show_warnings;
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 4772 "sudoku-view.c"
}


void sudoku_view_set_show_warnings (SudokuView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = value;
#line 574 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_warnings = _tmp0_;
#line 4784 "sudoku-view.c"
	{
		gint i = 0;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 4789 "sudoku-view.c"
		{
			gboolean _tmp1_ = FALSE;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp1_ = TRUE;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4796 "sudoku-view.c"
				gint _tmp3_ = 0;
				SudokuGame* _tmp4_ = NULL;
				SudokuBoard* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp1_) {
#line 4804 "sudoku-view.c"
					gint _tmp2_ = 0;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp2_ = i;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp2_ + 1;
#line 4810 "sudoku-view.c"
				}
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp1_ = FALSE;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp3_ = i;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp4_ = self->game;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp5_ = _tmp4_->board;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp6_ = sudoku_board_get_rows (_tmp5_);
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp7_ = _tmp6_;
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp3_ < _tmp7_)) {
#line 575 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4828 "sudoku-view.c"
				}
				{
					gint j = 0;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					j = 0;
#line 4834 "sudoku-view.c"
					{
						gboolean _tmp8_ = FALSE;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp8_ = TRUE;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 4841 "sudoku-view.c"
							gint _tmp10_ = 0;
							SudokuGame* _tmp11_ = NULL;
							SudokuBoard* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							SudokuCellView** _tmp15_ = NULL;
							gint _tmp15__length1 = 0;
							gint _tmp15__length2 = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							SudokuCellView* _tmp18_ = NULL;
							gboolean _tmp19_ = FALSE;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp8_) {
#line 4856 "sudoku-view.c"
								gint _tmp9_ = 0;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp9_ = j;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								j = _tmp9_ + 1;
#line 4862 "sudoku-view.c"
							}
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp8_ = FALSE;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp10_ = j;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp11_ = self->game;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp12_ = _tmp11_->board;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp13_ = sudoku_board_get_cols (_tmp12_);
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp14_ = _tmp13_;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp10_ < _tmp14_)) {
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 4880 "sudoku-view.c"
							}
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15_ = self->priv->cells;
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15__length1 = self->priv->cells_length1;
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15__length2 = self->priv->cells_length2;
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp16_ = i;
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp17_ = j;
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp18_ = _tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_];
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp19_ = self->priv->_show_warnings;
#line 577 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_set_show_warnings (_tmp18_, _tmp19_);
#line 4898 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "show-warnings");
#line 4907 "sudoku-view.c"
}


gboolean sudoku_view_get_show_possibilities (SudokuView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_show_possibilities;
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 4922 "sudoku-view.c"
}


void sudoku_view_set_show_possibilities (SudokuView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 586 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = value;
#line 586 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_possibilities = _tmp0_;
#line 4934 "sudoku-view.c"
	{
		gint i = 0;
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		i = 0;
#line 4939 "sudoku-view.c"
		{
			gboolean _tmp1_ = FALSE;
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			_tmp1_ = TRUE;
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
			while (TRUE) {
#line 4946 "sudoku-view.c"
				gint _tmp3_ = 0;
				SudokuGame* _tmp4_ = NULL;
				SudokuBoard* _tmp5_ = NULL;
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!_tmp1_) {
#line 4954 "sudoku-view.c"
					gint _tmp2_ = 0;
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					_tmp2_ = i;
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					i = _tmp2_ + 1;
#line 4960 "sudoku-view.c"
				}
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp1_ = FALSE;
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp3_ = i;
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp4_ = self->game;
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp5_ = _tmp4_->board;
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp6_ = sudoku_board_get_rows (_tmp5_);
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				_tmp7_ = _tmp6_;
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
				if (!(_tmp3_ < _tmp7_)) {
#line 587 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					break;
#line 4978 "sudoku-view.c"
				}
				{
					gint j = 0;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
					j = 0;
#line 4984 "sudoku-view.c"
					{
						gboolean _tmp8_ = FALSE;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						_tmp8_ = TRUE;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
						while (TRUE) {
#line 4991 "sudoku-view.c"
							gint _tmp10_ = 0;
							SudokuGame* _tmp11_ = NULL;
							SudokuBoard* _tmp12_ = NULL;
							gint _tmp13_ = 0;
							gint _tmp14_ = 0;
							SudokuCellView** _tmp15_ = NULL;
							gint _tmp15__length1 = 0;
							gint _tmp15__length2 = 0;
							gint _tmp16_ = 0;
							gint _tmp17_ = 0;
							SudokuCellView* _tmp18_ = NULL;
							gboolean _tmp19_ = FALSE;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!_tmp8_) {
#line 5006 "sudoku-view.c"
								gint _tmp9_ = 0;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								_tmp9_ = j;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								j = _tmp9_ + 1;
#line 5012 "sudoku-view.c"
							}
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp8_ = FALSE;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp10_ = j;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp11_ = self->game;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp12_ = _tmp11_->board;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp13_ = sudoku_board_get_cols (_tmp12_);
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp14_ = _tmp13_;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							if (!(_tmp10_ < _tmp14_)) {
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
								break;
#line 5030 "sudoku-view.c"
							}
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15_ = self->priv->cells;
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15__length1 = self->priv->cells_length1;
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp15__length2 = self->priv->cells_length2;
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp16_ = i;
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp17_ = j;
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp18_ = _tmp15_[(_tmp16_ * _tmp15__length2) + _tmp17_];
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							_tmp19_ = value;
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
							sudoku_cell_view_set_show_possibilities (_tmp18_, _tmp19_);
#line 5048 "sudoku-view.c"
						}
					}
				}
			}
		}
	}
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "show-possibilities");
#line 5057 "sudoku-view.c"
}


gboolean sudoku_view_get_highlighter (SudokuView* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = self->priv->_highlighter;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	result = _tmp0_;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	return result;
#line 5072 "sudoku-view.c"
}


void sudoku_view_set_highlighter (SudokuView* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_return_if_fail (self != NULL);
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_tmp0_ = value;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_highlighter = _tmp0_;
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_notify ((GObject *) self, "highlighter");
#line 5086 "sudoku-view.c"
}


static void sudoku_view_class_init (SudokuViewClass * klass) {
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	sudoku_view_parent_class = g_type_class_peek_parent (klass);
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_type_class_add_private (klass, sizeof (SudokuViewPrivate));
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_sudoku_view_get_property;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_sudoku_view_set_property;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_view_finalize;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_SHOW_WARNINGS, g_param_spec_boolean ("show-warnings", "show-warnings", "show-warnings", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_SHOW_POSSIBILITIES, g_param_spec_boolean ("show-possibilities", "show-possibilities", "show-possibilities", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), SUDOKU_VIEW_HIGHLIGHTER, g_param_spec_boolean ("highlighter", "highlighter", "highlighter", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 5107 "sudoku-view.c"
}


static void sudoku_view_instance_init (SudokuView * self) {
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv = SUDOKU_VIEW_GET_PRIVATE (self);
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->previous_board_broken_state = FALSE;
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->selected_row = 0;
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->selected_col = 0;
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_warnings = FALSE;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_show_possibilities = FALSE;
#line 593 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->_highlighter = FALSE;
#line 5126 "sudoku-view.c"
}


static void sudoku_view_finalize (GObject* obj) {
	SudokuView * self;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_VIEW, SudokuView);
#line 386 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->game);
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	self->priv->cells = (_vala_array_free (self->priv->cells, self->priv->cells_length1 * self->priv->cells_length2, (GDestroyNotify) g_object_unref), NULL);
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->overlay);
#line 392 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->drawing);
#line 393 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	_g_object_unref0 (self->priv->grid);
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	G_OBJECT_CLASS (sudoku_view_parent_class)->finalize (obj);
#line 5146 "sudoku-view.c"
}


GType sudoku_view_get_type (void) {
	static volatile gsize sudoku_view_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuView), 0, (GInstanceInitFunc) sudoku_view_instance_init, NULL };
		GType sudoku_view_type_id;
		sudoku_view_type_id = g_type_register_static (gtk_aspect_frame_get_type (), "SudokuView", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_view_type_id__volatile, sudoku_view_type_id);
	}
	return sudoku_view_type_id__volatile;
}


static void _vala_sudoku_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	SudokuView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_VIEW, SudokuView);
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	switch (property_id) {
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_VIEW_SHOW_WARNINGS:
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_view_get_show_warnings (self));
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_VIEW_SHOW_POSSIBILITIES:
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_view_get_show_possibilities (self));
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_VIEW_HIGHLIGHTER:
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		g_value_set_boolean (value, sudoku_view_get_highlighter (self));
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 5185 "sudoku-view.c"
		default:
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 5191 "sudoku-view.c"
	}
}


static void _vala_sudoku_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	SudokuView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_SUDOKU_VIEW, SudokuView);
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
	switch (property_id) {
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_VIEW_SHOW_WARNINGS:
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_view_set_show_warnings (self, g_value_get_boolean (value));
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_VIEW_SHOW_POSSIBILITIES:
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_view_set_show_possibilities (self, g_value_get_boolean (value));
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		case SUDOKU_VIEW_HIGHLIGHTER:
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		sudoku_view_set_highlighter (self, g_value_get_boolean (value));
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 5219 "sudoku-view.c"
		default:
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/sudoku-view.vala"
		break;
#line 5225 "sudoku-view.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



