/* sudoku-printer.c generated by valac 0.23.3.24-5b8db, the Vala compiler
 * generated from sudoku-printer.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#include <glib.h>
#include <glib-object.h>
#include "libsudoku.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>


#define TYPE_SUDOKU_PRINTER (sudoku_printer_get_type ())
#define SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinter))
#define SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))
#define IS_SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_PRINTER))
#define IS_SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_PRINTER))
#define SUDOKU_PRINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))

typedef struct _SudokuPrinter SudokuPrinter;
typedef struct _SudokuPrinterClass SudokuPrinterClass;
typedef struct _SudokuPrinterPrivate SudokuPrinterPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

#define TYPE_GAME_PRINTER (game_printer_get_type ())
#define GAME_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_PRINTER, GamePrinter))
#define GAME_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_PRINTER, GamePrinterClass))
#define IS_GAME_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_PRINTER))
#define IS_GAME_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_PRINTER))
#define GAME_PRINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_PRINTER, GamePrinterClass))

typedef struct _GamePrinter GamePrinter;
typedef struct _GamePrinterClass GamePrinterClass;
typedef struct _GamePrinterPrivate GamePrinterPrivate;
#define __g_slist_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_slist_free__g_object_unref0_ (var), NULL)))
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;

struct _SudokuPrinter {
	GObject parent_instance;
	SudokuPrinterPrivate * priv;
};

struct _SudokuPrinterClass {
	GObjectClass parent_class;
};

struct _SudokuPrinterPrivate {
	SudokuBoard** boards;
	gint boards_length1;
	gint _boards_size_;
	GtkApplicationWindow* window;
	gint margin;
	gint n_sudokus;
	GtkPrintOperation* print_op;
};

struct _GamePrinter {
	GObject parent_instance;
	GamePrinterPrivate * priv;
};

struct _GamePrinterClass {
	GObjectClass parent_class;
};

struct _GamePrinterPrivate {
	SudokuSaver* saver;
	GtkApplicationWindow* window;
	GSettings* settings;
	GtkDialog* dialog;
	GtkSpinButton* nsudokus_button;
	GtkRadioButton* easy_button;
	GtkRadioButton* medium_button;
	GtkRadioButton* hard_button;
	GtkRadioButton* very_hard_button;
	GtkSpinner* spinner;
};

struct _Block9Data {
	int _ref_count_;
	GamePrinter* self;
	gchar* key_name;
	GtkAdjustment* action;
};

struct _Block10Data {
	int _ref_count_;
	GamePrinter* self;
	GtkDialog* dialog;
};


static gpointer sudoku_printer_parent_class = NULL;
static gpointer game_printer_parent_class = NULL;

GType sudoku_printer_get_type (void) G_GNUC_CONST;
#define SUDOKU_PRINTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_PRINTER, SudokuPrinterPrivate))
enum  {
	SUDOKU_PRINTER_DUMMY_PROPERTY
};
#define SUDOKU_PRINTER_SUDOKUS_PER_PAGE 2
GtkPrintOperationResult sudoku_printer_print_sudoku (SudokuPrinter* self);
SudokuPrinter* sudoku_printer_new (SudokuBoard** boards, int boards_length1, GtkApplicationWindow** window);
SudokuPrinter* sudoku_printer_construct (GType object_type, SudokuBoard** boards, int boards_length1, GtkApplicationWindow** window);
static SudokuBoard** _vala_array_dup1 (SudokuBoard** self, int length);
static void sudoku_printer_begin_print_cb (SudokuPrinter* self, GtkPrintOperation* operation, GtkPrintContext* context);
static void _sudoku_printer_begin_print_cb_gtk_print_operation_begin_print (GtkPrintOperation* _sender, GtkPrintContext* context, gpointer self);
static void sudoku_printer_draw_page_cb (SudokuPrinter* self, GtkPrintOperation* operation, GtkPrintContext* context, gint page_nr);
static void _sudoku_printer_draw_page_cb_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self);
static gdouble sudoku_printer_fit_squares_in_rectangle (SudokuPrinter* self, gdouble width, gdouble height, gint margin);
static SudokuBoard** _vala_array_dup2 (SudokuBoard** self, int length);
static void sudoku_printer_draw_sudoku (SudokuPrinter* self, cairo_t* cr, SudokuBoard* sudoku_board, gdouble size, gdouble offset_x, gdouble offset_y);
static void sudoku_printer_finalize (GObject* obj);
GType game_printer_get_type (void) G_GNUC_CONST;
#define GAME_PRINTER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME_PRINTER, GamePrinterPrivate))
enum  {
	GAME_PRINTER_DUMMY_PROPERTY
};
#define GAME_PRINTER_DIFFICULTY_KEY_NAME "print-multiple-sudoku-difficulty"
GamePrinter* game_printer_new (SudokuSaver* saver, GtkApplicationWindow** window);
GamePrinter* game_printer_construct (GType object_type, SudokuSaver* saver, GtkApplicationWindow** window);
static void game_printer_response_cb (GamePrinter* self, GtkDialog* dialog, gint response);
static void _game_printer_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void game_printer_wrap_adjustment (GamePrinter* self, const gchar* key_name, GtkAdjustment* action);
static void _g_object_unref0_ (gpointer var);
static void _g_slist_free__g_object_unref0_ (GSList* self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda19_ (Block9Data* _data9_);
static void ___lambda19__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda18_ (Block10Data* _data10_, GObject* obj, GAsyncResult* res);
static void ___lambda18__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void game_printer_run_dialog (GamePrinter* self);
static void game_printer_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GtkPrintOperationResult sudoku_printer_print_sudoku (SudokuPrinter* self) {
	GtkPrintOperationResult result = 0;
	GError * _inner_error_ = NULL;
#line 18 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 157 "sudoku-printer.c"
	{
		GtkPrintOperationResult _result_ = 0;
		GtkPrintOperation* _tmp0_ = NULL;
		GtkApplicationWindow* _tmp1_ = NULL;
		GtkPrintOperationResult _tmp2_ = 0;
#line 22 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp0_ = self->priv->print_op;
#line 22 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp1_ = self->priv->window;
#line 22 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp2_ = gtk_print_operation_run (_tmp0_, GTK_PRINT_OPERATION_ACTION_PRINT_DIALOG, (GtkWindow*) _tmp1_, &_inner_error_);
#line 22 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_result_ = _tmp2_;
#line 22 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		if (_inner_error_ != NULL) {
#line 173 "sudoku-printer.c"
			goto __catch4_g_error;
		}
#line 23 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		result = _result_;
#line 23 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		return result;
#line 180 "sudoku-printer.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GtkApplicationWindow* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		GtkMessageDialog* _tmp9_ = NULL;
		GtkMessageDialog* _tmp10_ = NULL;
#line 20 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		e = _inner_error_;
#line 20 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_inner_error_ = NULL;
#line 27 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp3_ = self->priv->window;
#line 27 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp4_ = _ ("Error printing file:");
#line 27 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp5_ = e;
#line 27 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp6_ = _tmp5_->message;
#line 27 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp7_ = g_strdup_printf ("%s\n%s", _tmp4_, _tmp6_);
#line 27 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp8_ = _tmp7_;
#line 27 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp9_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp3_, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_CLOSE, _tmp8_);
#line 27 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		g_object_ref_sink (_tmp9_);
#line 27 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp10_ = _tmp9_;
#line 27 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		gtk_dialog_run ((GtkDialog*) _tmp10_);
#line 27 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_g_object_unref0 (_tmp10_);
#line 27 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_g_free0 (_tmp8_);
#line 20 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_g_error_free0 (e);
#line 224 "sudoku-printer.c"
	}
	__finally4:
#line 20 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	if (_inner_error_ != NULL) {
#line 20 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 20 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		g_clear_error (&_inner_error_);
#line 20 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		return 0;
#line 235 "sudoku-printer.c"
	}
#line 33 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	result = GTK_PRINT_OPERATION_RESULT_ERROR;
#line 33 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	return result;
#line 241 "sudoku-printer.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 38 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	return self ? g_object_ref (self) : NULL;
#line 248 "sudoku-printer.c"
}


static SudokuBoard** _vala_array_dup1 (SudokuBoard** self, int length) {
	SudokuBoard** result;
	int i;
#line 38 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	result = g_new0 (SudokuBoard*, length + 1);
#line 38 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	for (i = 0; i < length; i++) {
#line 259 "sudoku-printer.c"
		SudokuBoard* _tmp0_ = NULL;
#line 38 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp0_ = _g_object_ref0 (self[i]);
#line 38 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		result[i] = _tmp0_;
#line 265 "sudoku-printer.c"
	}
#line 38 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	return result;
#line 269 "sudoku-printer.c"
}


static void _sudoku_printer_begin_print_cb_gtk_print_operation_begin_print (GtkPrintOperation* _sender, GtkPrintContext* context, gpointer self) {
#line 44 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	sudoku_printer_begin_print_cb ((SudokuPrinter*) self, _sender, context);
#line 276 "sudoku-printer.c"
}


static void _sudoku_printer_draw_page_cb_gtk_print_operation_draw_page (GtkPrintOperation* _sender, GtkPrintContext* context, gint page_nr, gpointer self) {
#line 45 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	sudoku_printer_draw_page_cb ((SudokuPrinter*) self, _sender, context, page_nr);
#line 283 "sudoku-printer.c"
}


SudokuPrinter* sudoku_printer_construct (GType object_type, SudokuBoard** boards, int boards_length1, GtkApplicationWindow** window) {
	SudokuPrinter * self = NULL;
	SudokuBoard** _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	SudokuBoard** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	GtkApplicationWindow* _tmp2_ = NULL;
	GtkApplicationWindow* _tmp3_ = NULL;
	SudokuBoard** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	GtkPrintOperation* _tmp5_ = NULL;
	GtkPrintOperation* _tmp6_ = NULL;
	GtkPrintOperation* _tmp7_ = NULL;
#line 36 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_return_val_if_fail (*window != NULL, NULL);
#line 36 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	self = (SudokuPrinter*) g_object_new (object_type, NULL);
#line 38 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp0_ = boards;
#line 38 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp0__length1 = boards_length1;
#line 38 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup1 (_tmp0_, _tmp0__length1) : ((gpointer) _tmp0_);
#line 38 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp1__length1 = _tmp0__length1;
#line 38 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	self->priv->boards = (_vala_array_free (self->priv->boards, self->priv->boards_length1, (GDestroyNotify) g_object_unref), NULL);
#line 38 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	self->priv->boards = _tmp1_;
#line 38 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	self->priv->boards_length1 = _tmp1__length1;
#line 38 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	self->priv->_boards_size_ = self->priv->boards_length1;
#line 39 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp2_ = *window;
#line 39 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 39 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->window);
#line 39 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	self->priv->window = _tmp3_;
#line 40 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	self->priv->margin = 25;
#line 41 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp4_ = boards;
#line 41 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp4__length1 = boards_length1;
#line 41 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	self->priv->n_sudokus = _tmp4__length1;
#line 43 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp5_ = gtk_print_operation_new ();
#line 43 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->print_op);
#line 43 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	self->priv->print_op = _tmp5_;
#line 44 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp6_ = self->priv->print_op;
#line 44 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_signal_connect_object (_tmp6_, "begin-print", (GCallback) _sudoku_printer_begin_print_cb_gtk_print_operation_begin_print, self, 0);
#line 45 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp7_ = self->priv->print_op;
#line 45 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_signal_connect_object (_tmp7_, "draw-page", (GCallback) _sudoku_printer_draw_page_cb_gtk_print_operation_draw_page, self, 0);
#line 36 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	return self;
#line 352 "sudoku-printer.c"
}


SudokuPrinter* sudoku_printer_new (SudokuBoard** boards, int boards_length1, GtkApplicationWindow** window) {
#line 36 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	return sudoku_printer_construct (TYPE_SUDOKU_PRINTER, boards, boards_length1, window);
#line 359 "sudoku-printer.c"
}


static void sudoku_printer_begin_print_cb (SudokuPrinter* self, GtkPrintOperation* operation, GtkPrintContext* context) {
	gint pages = 0;
	gint _tmp0_ = 0;
	GtkPrintOperation* _tmp4_ = NULL;
	gint _tmp5_ = 0;
#line 48 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_return_if_fail (self != NULL);
#line 48 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_return_if_fail (operation != NULL);
#line 48 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_return_if_fail (context != NULL);
#line 50 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp0_ = self->priv->n_sudokus;
#line 50 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	pages = _tmp0_ / SUDOKU_PRINTER_SUDOKUS_PER_PAGE;
#line 51 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	while (TRUE) {
#line 380 "sudoku-printer.c"
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
#line 51 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp1_ = pages;
#line 51 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp2_ = self->priv->n_sudokus;
#line 51 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		if (!((_tmp1_ * SUDOKU_PRINTER_SUDOKUS_PER_PAGE) < _tmp2_)) {
#line 51 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
			break;
#line 392 "sudoku-printer.c"
		}
#line 52 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp3_ = pages;
#line 52 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		pages = _tmp3_ + 1;
#line 398 "sudoku-printer.c"
	}
#line 54 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp4_ = operation;
#line 54 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp5_ = pages;
#line 54 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	gtk_print_operation_set_n_pages (_tmp4_, _tmp5_);
#line 406 "sudoku-printer.c"
}


static gpointer _cairo_reference0 (gpointer self) {
#line 59 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	return self ? cairo_reference (self) : NULL;
#line 413 "sudoku-printer.c"
}


static SudokuBoard** _vala_array_dup2 (SudokuBoard** self, int length) {
	SudokuBoard** result;
	int i;
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	result = g_new0 (SudokuBoard*, length + 1);
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	for (i = 0; i < length; i++) {
#line 424 "sudoku-printer.c"
		SudokuBoard* _tmp0_ = NULL;
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp0_ = _g_object_ref0 (self[i]);
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		result[i] = _tmp0_;
#line 430 "sudoku-printer.c"
	}
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	return result;
#line 434 "sudoku-printer.c"
}


static void sudoku_printer_draw_page_cb (SudokuPrinter* self, GtkPrintOperation* operation, GtkPrintContext* context, gint page_nr) {
	cairo_t* cr = NULL;
	GtkPrintContext* _tmp0_ = NULL;
	cairo_t* _tmp1_ = NULL;
	cairo_t* _tmp2_ = NULL;
	gdouble width = 0.0;
	GtkPrintContext* _tmp3_ = NULL;
	gdouble _tmp4_ = 0.0;
	gdouble height = 0.0;
	GtkPrintContext* _tmp5_ = NULL;
	gdouble _tmp6_ = 0.0;
	gdouble best_square_size = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble _tmp8_ = 0.0;
	gint _tmp9_ = 0;
	gdouble _tmp10_ = 0.0;
	gint start = 0;
	gint _tmp11_ = 0;
	gint end = 0;
	gint _tmp12_ = 0;
	SudokuBoard** _tmp13_ = NULL;
	gint _tmp13__length1 = 0;
	gint _tmp14_ = 0;
	SudokuBoard** sudokus_on_page = NULL;
	SudokuBoard** _tmp15_ = NULL;
	gint _tmp15__length1 = 0;
	gint _tmp16_ = 0;
	gint _tmp17_ = 0;
	SudokuBoard** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	gint sudokus_on_page_length1 = 0;
	gint _sudokus_on_page_size_ = 0;
	gdouble left = 0.0;
	gdouble _tmp19_ = 0.0;
	gdouble _tmp20_ = 0.0;
	gdouble top = 0.0;
	gint _tmp21_ = 0;
	SudokuBoard** _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
#line 57 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_return_if_fail (self != NULL);
#line 57 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_return_if_fail (operation != NULL);
#line 57 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_return_if_fail (context != NULL);
#line 59 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp0_ = context;
#line 59 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp1_ = gtk_print_context_get_cairo_context (_tmp0_);
#line 59 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp2_ = _cairo_reference0 (_tmp1_);
#line 59 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	cr = _tmp2_;
#line 60 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp3_ = context;
#line 60 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp4_ = gtk_print_context_get_width (_tmp3_);
#line 60 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	width = _tmp4_;
#line 61 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp5_ = context;
#line 61 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp6_ = gtk_print_context_get_height (_tmp5_);
#line 61 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	height = _tmp6_;
#line 63 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp7_ = width;
#line 63 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp8_ = height;
#line 63 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp9_ = self->priv->margin;
#line 63 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp10_ = sudoku_printer_fit_squares_in_rectangle (self, _tmp7_, _tmp8_, _tmp9_);
#line 63 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	best_square_size = _tmp10_;
#line 65 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp11_ = page_nr;
#line 65 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	start = _tmp11_ * SUDOKU_PRINTER_SUDOKUS_PER_PAGE;
#line 66 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp12_ = start;
#line 66 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp13_ = self->priv->boards;
#line 66 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp13__length1 = self->priv->boards_length1;
#line 66 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp14_ = MIN (_tmp12_ + SUDOKU_PRINTER_SUDOKUS_PER_PAGE, _tmp13__length1);
#line 66 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	end = _tmp14_;
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp15_ = self->priv->boards;
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp15__length1 = self->priv->boards_length1;
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp16_ = start;
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp17_ = end;
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp18_ = ((_tmp15_ + _tmp16_) != NULL) ? _vala_array_dup2 (_tmp15_ + _tmp16_, _tmp17_ - _tmp16_) : ((gpointer) (_tmp15_ + _tmp16_));
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp18__length1 = _tmp17_ - _tmp16_;
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	sudokus_on_page = _tmp18_;
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	sudokus_on_page_length1 = _tmp18__length1;
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_sudokus_on_page_size_ = sudokus_on_page_length1;
#line 69 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp19_ = width;
#line 69 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp20_ = best_square_size;
#line 69 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	left = (_tmp19_ - _tmp20_) / 2;
#line 70 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp21_ = self->priv->margin;
#line 70 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	top = (gdouble) _tmp21_;
#line 72 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp22_ = sudokus_on_page;
#line 72 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp22__length1 = sudokus_on_page_length1;
#line 559 "sudoku-printer.c"
	{
		SudokuBoard** sudoku_collection = NULL;
		gint sudoku_collection_length1 = 0;
		gint _sudoku_collection_size_ = 0;
		gint sudoku_it = 0;
#line 72 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		sudoku_collection = _tmp22_;
#line 72 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		sudoku_collection_length1 = _tmp22__length1;
#line 72 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		for (sudoku_it = 0; sudoku_it < _tmp22__length1; sudoku_it = sudoku_it + 1) {
#line 571 "sudoku-printer.c"
			SudokuBoard* _tmp23_ = NULL;
			SudokuBoard* sudoku = NULL;
#line 72 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
			_tmp23_ = _g_object_ref0 (sudoku_collection[sudoku_it]);
#line 72 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
			sudoku = _tmp23_;
#line 578 "sudoku-printer.c"
			{
				gchar* label = NULL;
				SudokuBoard* _tmp24_ = NULL;
				DifficultyCategory _tmp25_ = 0;
				DifficultyCategory _tmp26_ = 0;
				gchar* _tmp27_ = NULL;
				cairo_t* _tmp28_ = NULL;
				cairo_t* _tmp29_ = NULL;
				cairo_t* _tmp30_ = NULL;
				cairo_text_extents_t extents = {0};
				cairo_t* _tmp31_ = NULL;
				const gchar* _tmp32_ = NULL;
				cairo_text_extents_t _tmp33_ = {0};
				cairo_t* _tmp34_ = NULL;
				gdouble _tmp35_ = 0.0;
				cairo_text_extents_t _tmp36_ = {0};
				gdouble _tmp37_ = 0.0;
				gdouble _tmp38_ = 0.0;
				cairo_text_extents_t _tmp39_ = {0};
				gdouble _tmp40_ = 0.0;
				cairo_t* _tmp41_ = NULL;
				const gchar* _tmp42_ = NULL;
				cairo_t* _tmp43_ = NULL;
				SudokuBoard* _tmp44_ = NULL;
				gdouble _tmp45_ = 0.0;
				gdouble _tmp46_ = 0.0;
				gdouble _tmp47_ = 0.0;
				gdouble _tmp48_ = 0.0;
				gdouble _tmp49_ = 0.0;
				gint _tmp50_ = 0;
#line 74 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp24_ = sudoku;
#line 74 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp25_ = sudoku_board_get_difficulty_category (_tmp24_);
#line 74 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp26_ = _tmp25_;
#line 74 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp27_ = difficulty_category_to_string (_tmp26_);
#line 74 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				label = _tmp27_;
#line 75 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp28_ = cr;
#line 75 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				cairo_set_font_size (_tmp28_, (gdouble) 12);
#line 76 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp29_ = cr;
#line 76 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				cairo_select_font_face (_tmp29_, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
#line 77 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp30_ = cr;
#line 77 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				cairo_set_source_rgb (_tmp30_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
#line 79 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp31_ = cr;
#line 79 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp32_ = label;
#line 79 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				cairo_text_extents (_tmp31_, _tmp32_, &_tmp33_);
#line 79 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				extents = _tmp33_;
#line 80 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp34_ = cr;
#line 80 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp35_ = width;
#line 80 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp36_ = extents;
#line 80 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp37_ = _tmp36_.width;
#line 80 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp38_ = top;
#line 80 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp39_ = extents;
#line 80 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp40_ = _tmp39_.height;
#line 80 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				cairo_move_to (_tmp34_, (_tmp35_ - _tmp37_) / 2, _tmp38_ - (_tmp40_ / 2));
#line 81 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp41_ = cr;
#line 81 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp42_ = label;
#line 81 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				cairo_show_text (_tmp41_, _tmp42_);
#line 83 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp43_ = cr;
#line 83 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp44_ = sudoku;
#line 83 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp45_ = best_square_size;
#line 83 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp46_ = left;
#line 83 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp47_ = top;
#line 83 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				sudoku_printer_draw_sudoku (self, _tmp43_, _tmp44_, _tmp45_, _tmp46_, _tmp47_);
#line 85 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp48_ = top;
#line 85 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp49_ = best_square_size;
#line 85 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp50_ = self->priv->margin;
#line 85 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				top = _tmp48_ + (_tmp49_ + (2 * _tmp50_));
#line 72 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_g_free0 (label);
#line 72 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_g_object_unref0 (sudoku);
#line 685 "sudoku-printer.c"
			}
		}
	}
#line 57 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	sudokus_on_page = (_vala_array_free (sudokus_on_page, sudokus_on_page_length1, (GDestroyNotify) g_object_unref), NULL);
#line 57 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_cairo_destroy0 (cr);
#line 693 "sudoku-printer.c"
}


static gdouble sudoku_printer_fit_squares_in_rectangle (SudokuPrinter* self, gdouble width, gdouble height, gint margin) {
	gdouble result = 0.0;
	gint n = 0;
	gdouble best_square_size = 0.0;
	gdouble square_size = 0.0;
#line 89 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_return_val_if_fail (self != NULL, 0.0);
#line 91 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	n = SUDOKU_PRINTER_SUDOKUS_PER_PAGE;
#line 92 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	best_square_size = 0.0;
#line 93 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	square_size = 0.0;
#line 710 "sudoku-printer.c"
	{
		gint n_across = 0;
#line 95 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		n_across = 1;
#line 715 "sudoku-printer.c"
		{
			gboolean _tmp0_ = FALSE;
#line 95 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
			_tmp0_ = TRUE;
#line 95 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
			while (TRUE) {
#line 722 "sudoku-printer.c"
				gint _tmp2_ = 0;
				gint _tmp3_ = 0;
				gdouble n_down = 0.0;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				gdouble across_size = 0.0;
				gdouble _tmp6_ = 0.0;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
				gdouble _tmp9_ = 0.0;
				gint _tmp10_ = 0;
				gdouble down_size = 0.0;
				gdouble _tmp11_ = 0.0;
				gdouble _tmp12_ = 0.0;
				gint _tmp13_ = 0;
				gdouble _tmp14_ = 0.0;
				gdouble _tmp15_ = 0.0;
				gdouble _tmp16_ = 0.0;
				gdouble _tmp17_ = 0.0;
				gdouble _tmp18_ = 0.0;
				gdouble _tmp19_ = 0.0;
				gdouble _tmp20_ = 0.0;
#line 95 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				if (!_tmp0_) {
#line 747 "sudoku-printer.c"
					gint _tmp1_ = 0;
#line 95 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					_tmp1_ = n_across;
#line 95 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					n_across = _tmp1_ + 1;
#line 753 "sudoku-printer.c"
				}
#line 95 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp0_ = FALSE;
#line 95 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp2_ = n_across;
#line 95 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp3_ = n;
#line 95 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				if (!(_tmp2_ <= _tmp3_)) {
#line 95 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					break;
#line 765 "sudoku-printer.c"
				}
#line 97 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp4_ = n;
#line 97 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp5_ = n_across;
#line 97 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				n_down = (gdouble) (_tmp4_ / _tmp5_);
#line 98 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp6_ = width;
#line 98 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp7_ = n_across;
#line 98 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp8_ = margin;
#line 98 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				across_size = _tmp6_ - ((_tmp7_ + 1) * _tmp8_);
#line 99 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp9_ = across_size;
#line 99 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp10_ = n_across;
#line 99 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				across_size = _tmp9_ / _tmp10_;
#line 100 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp11_ = height;
#line 100 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp12_ = n_down;
#line 100 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp13_ = margin;
#line 100 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				down_size = _tmp11_ - ((_tmp12_ + 1) * _tmp13_);
#line 101 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp14_ = down_size;
#line 101 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp15_ = n_down;
#line 101 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				down_size = _tmp14_ / _tmp15_;
#line 103 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp16_ = across_size;
#line 103 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp17_ = down_size;
#line 103 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp18_ = MIN (_tmp16_, _tmp17_);
#line 103 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				square_size = _tmp18_;
#line 104 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp19_ = square_size;
#line 104 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp20_ = best_square_size;
#line 104 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				if (_tmp19_ > _tmp20_) {
#line 815 "sudoku-printer.c"
					gdouble _tmp21_ = 0.0;
#line 105 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					_tmp21_ = square_size;
#line 105 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					best_square_size = _tmp21_;
#line 821 "sudoku-printer.c"
				}
			}
		}
	}
#line 108 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	result = best_square_size;
#line 108 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	return result;
#line 830 "sudoku-printer.c"
}


static void sudoku_printer_draw_sudoku (SudokuPrinter* self, cairo_t* cr, SudokuBoard* sudoku_board, gdouble size, gdouble offset_x, gdouble offset_y) {
#line 113 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	static const gint SUDOKU_SIZE = 9;
#line 114 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	static const gint N_BOXES = 3;
#line 115 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	static const gdouble PENCIL_GREY[] = {0.3, 0.3, 0.3};
#line 116 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	static const gdouble BACKGROUND_COLOR[] = {1.0, 1.0, 1.0};
#line 118 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	static const gdouble BORDER_COLOR[] = {1.0, 1.0, 1.0};
#line 119 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	static const gdouble LINE_COLOR[] = {0.0, 0.0, 0.0};
#line 847 "sudoku-printer.c"
	gdouble THIN = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble THICK = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble BORDER = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble WHITE_SPACE = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gdouble _tmp7_ = 0.0;
	gdouble SQUARE_SIZE = 0.0;
	gdouble _tmp8_ = 0.0;
	gint FONT_SIZE = 0;
	gdouble _tmp9_ = 0.0;
#line 128 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	static const cairo_font_weight_t FONT_WEIGHT = CAIRO_FONT_WEIGHT_NORMAL;
#line 866 "sudoku-printer.c"
	gdouble* outer = NULL;
	gdouble _tmp10_ = 0.0;
	gdouble _tmp11_ = 0.0;
	gdouble _tmp12_ = 0.0;
	gdouble _tmp13_ = 0.0;
	gdouble _tmp14_ = 0.0;
	gdouble _tmp15_ = 0.0;
	gdouble* _tmp16_ = NULL;
	gint outer_length1 = 0;
	gint _outer_size_ = 0;
	cairo_t* _tmp17_ = NULL;
	cairo_t* _tmp18_ = NULL;
	gdouble* _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	gdouble _tmp20_ = 0.0;
	gdouble* _tmp21_ = NULL;
	gint _tmp21__length1 = 0;
	gdouble _tmp22_ = 0.0;
	gdouble _tmp23_ = 0.0;
	gdouble _tmp24_ = 0.0;
	cairo_t* _tmp25_ = NULL;
	cairo_t* _tmp26_ = NULL;
	cairo_t* _tmp27_ = NULL;
	gdouble _tmp28_ = 0.0;
	cairo_t* _tmp29_ = NULL;
	gdouble* _tmp30_ = NULL;
	gint _tmp30__length1 = 0;
	gdouble _tmp31_ = 0.0;
	gdouble _tmp32_ = 0.0;
	gdouble* _tmp33_ = NULL;
	gint _tmp33__length1 = 0;
	gdouble _tmp34_ = 0.0;
	gdouble _tmp35_ = 0.0;
	gdouble _tmp36_ = 0.0;
	gdouble _tmp37_ = 0.0;
	gdouble _tmp38_ = 0.0;
	gdouble _tmp39_ = 0.0;
	cairo_t* _tmp40_ = NULL;
	gdouble _tmp41_ = 0.0;
	gdouble _tmp42_ = 0.0;
	gdouble _tmp43_ = 0.0;
	cairo_t* _tmp44_ = NULL;
	cairo_t* _tmp45_ = NULL;
	gdouble _tmp46_ = 0.0;
	gdouble _tmp47_ = 0.0;
	gdouble _tmp48_ = 0.0;
	cairo_t* _tmp49_ = NULL;
	cairo_t* _tmp50_ = NULL;
	cairo_t* _tmp51_ = NULL;
	gdouble _tmp52_ = 0.0;
	cairo_t* _tmp53_ = NULL;
	gdouble* _tmp54_ = NULL;
	gint _tmp54__length1 = 0;
	gdouble _tmp55_ = 0.0;
	gdouble _tmp56_ = 0.0;
	gdouble _tmp57_ = 0.0;
	gdouble* _tmp58_ = NULL;
	gint _tmp58__length1 = 0;
	gdouble _tmp59_ = 0.0;
	gdouble _tmp60_ = 0.0;
	gdouble _tmp61_ = 0.0;
	gdouble _tmp62_ = 0.0;
	gdouble _tmp63_ = 0.0;
	gdouble _tmp64_ = 0.0;
	gdouble _tmp65_ = 0.0;
	gdouble _tmp66_ = 0.0;
	gdouble _tmp67_ = 0.0;
	cairo_t* _tmp68_ = NULL;
	gdouble _tmp69_ = 0.0;
	gdouble _tmp70_ = 0.0;
	gdouble _tmp71_ = 0.0;
	cairo_t* _tmp72_ = NULL;
	gdouble* pos = NULL;
	gdouble* _tmp73_ = NULL;
	gint pos_length1 = 0;
	gint _pos_size_ = 0;
	gdouble position = 0.0;
	gdouble _tmp74_ = 0.0;
	gdouble _tmp75_ = 0.0;
	gdouble* _tmp76_ = NULL;
	gint _tmp76__length1 = 0;
	gdouble _tmp77_ = 0.0;
	gdouble _tmp78_ = 0.0;
	gdouble _tmp79_ = 0.0;
	gdouble last_line = 0.0;
	cairo_t* _tmp131_ = NULL;
	gint _tmp132_ = 0;
	gchar* letter = NULL;
	gchar* _tmp133_ = NULL;
	cairo_text_extents_t extents = {0};
	gint* sudoku = NULL;
	SudokuBoard* _tmp134_ = NULL;
	gint _tmp135_ = 0;
	gint _tmp136_ = 0;
	gint* _tmp137_ = NULL;
	gint sudoku_length1 = 0;
	gint sudoku_length2 = 0;
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_return_if_fail (self != NULL);
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_return_if_fail (cr != NULL);
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_return_if_fail (sudoku_board != NULL);
#line 121 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp0_ = size;
#line 121 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	THIN = _tmp0_ / 500.0;
#line 122 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp1_ = THIN;
#line 122 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	THICK = _tmp1_ * 5;
#line 123 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp2_ = THICK;
#line 123 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	BORDER = _tmp2_;
#line 124 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp3_ = size;
#line 124 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp4_ = BORDER;
#line 124 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp5_ = THICK;
#line 124 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp6_ = THICK;
#line 124 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp7_ = THIN;
#line 124 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	WHITE_SPACE = (((_tmp3_ - (2 * _tmp4_)) - (2 * _tmp5_)) - ((N_BOXES - 1) * _tmp6_)) - ((N_BOXES * 2) * _tmp7_);
#line 125 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp8_ = WHITE_SPACE;
#line 125 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	SQUARE_SIZE = _tmp8_ / SUDOKU_SIZE;
#line 127 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp9_ = SQUARE_SIZE;
#line 127 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	FONT_SIZE = ((gint) _tmp9_) / 2;
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp10_ = offset_x;
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp11_ = offset_x;
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp12_ = size;
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp13_ = offset_y;
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp14_ = offset_y;
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp15_ = size;
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp16_ = g_new0 (gdouble, 4);
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp16_[0] = _tmp10_;
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp16_[1] = _tmp11_ + _tmp12_;
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp16_[2] = _tmp13_;
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp16_[3] = _tmp14_ + _tmp15_;
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	outer = _tmp16_;
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	outer_length1 = 4;
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_outer_size_ = outer_length1;
#line 133 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp17_ = cr;
#line 133 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	cairo_set_source_rgb (_tmp17_, 1.0, 1.0, 1.0);
#line 134 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp18_ = cr;
#line 134 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp19_ = outer;
#line 134 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp19__length1 = outer_length1;
#line 134 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp20_ = _tmp19_[0];
#line 134 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp21_ = outer;
#line 134 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp21__length1 = outer_length1;
#line 134 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp22_ = _tmp21_[2];
#line 134 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp23_ = size;
#line 134 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp24_ = size;
#line 134 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	cairo_rectangle (_tmp18_, _tmp20_, _tmp22_, _tmp23_, _tmp24_);
#line 135 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp25_ = cr;
#line 135 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	cairo_fill (_tmp25_);
#line 138 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp26_ = cr;
#line 138 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	cairo_set_line_join (_tmp26_, CAIRO_LINE_JOIN_ROUND);
#line 139 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp27_ = cr;
#line 139 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp28_ = BORDER;
#line 139 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	cairo_set_line_width (_tmp27_, _tmp28_);
#line 140 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp29_ = cr;
#line 140 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp30_ = outer;
#line 140 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp30__length1 = outer_length1;
#line 140 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp31_ = _tmp30_[0];
#line 140 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp32_ = BORDER;
#line 140 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp33_ = outer;
#line 140 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp33__length1 = outer_length1;
#line 140 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp34_ = _tmp33_[2];
#line 140 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp35_ = BORDER;
#line 140 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp36_ = size;
#line 140 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp37_ = BORDER;
#line 140 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp38_ = size;
#line 140 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp39_ = BORDER;
#line 140 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	cairo_rectangle (_tmp29_, _tmp31_ + (_tmp32_ / 2.0), _tmp34_ + (_tmp35_ / 2.0), _tmp36_ - _tmp37_, _tmp38_ - _tmp39_);
#line 143 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp40_ = cr;
#line 143 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp41_ = BACKGROUND_COLOR[0];
#line 143 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp42_ = BACKGROUND_COLOR[1];
#line 143 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp43_ = BACKGROUND_COLOR[2];
#line 143 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	cairo_set_source_rgb (_tmp40_, _tmp41_, _tmp42_, _tmp43_);
#line 144 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp44_ = cr;
#line 144 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	cairo_fill_preserve (_tmp44_);
#line 146 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp45_ = cr;
#line 146 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp46_ = BORDER_COLOR[0];
#line 146 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp47_ = BORDER_COLOR[1];
#line 146 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp48_ = BORDER_COLOR[2];
#line 146 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	cairo_set_source_rgb (_tmp45_, _tmp46_, _tmp47_, _tmp48_);
#line 147 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp49_ = cr;
#line 147 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	cairo_stroke (_tmp49_);
#line 150 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp50_ = cr;
#line 150 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	cairo_set_line_join (_tmp50_, CAIRO_LINE_JOIN_MITER);
#line 151 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp51_ = cr;
#line 151 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp52_ = THICK;
#line 151 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	cairo_set_line_width (_tmp51_, _tmp52_);
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp53_ = cr;
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp54_ = outer;
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp54__length1 = outer_length1;
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp55_ = _tmp54_[0];
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp56_ = BORDER;
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp57_ = THICK;
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp58_ = outer;
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp58__length1 = outer_length1;
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp59_ = _tmp58_[2];
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp60_ = BORDER;
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp61_ = THICK;
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp62_ = size;
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp63_ = BORDER;
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp64_ = THICK;
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp65_ = size;
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp66_ = BORDER;
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp67_ = THICK;
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	cairo_rectangle (_tmp53_, (_tmp55_ + _tmp56_) + (_tmp57_ / 2.0), (_tmp59_ + _tmp60_) + (_tmp61_ / 2.0), (_tmp62_ - (_tmp63_ * 2)) - _tmp64_, (_tmp65_ - (_tmp66_ * 2)) - _tmp67_);
#line 153 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp68_ = cr;
#line 153 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp69_ = LINE_COLOR[0];
#line 153 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp70_ = LINE_COLOR[1];
#line 153 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp71_ = LINE_COLOR[2];
#line 153 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	cairo_set_source_rgb (_tmp68_, _tmp69_, _tmp70_, _tmp71_);
#line 154 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp72_ = cr;
#line 154 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	cairo_stroke (_tmp72_);
#line 156 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp73_ = g_new0 (gdouble, SUDOKU_SIZE + 1);
#line 156 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	pos = _tmp73_;
#line 156 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	pos_length1 = SUDOKU_SIZE + 1;
#line 156 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_pos_size_ = pos_length1;
#line 157 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp74_ = BORDER;
#line 157 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp75_ = THICK;
#line 157 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	position = _tmp74_ + _tmp75_;
#line 158 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp76_ = pos;
#line 158 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp76__length1 = pos_length1;
#line 158 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp77_ = position;
#line 158 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp78_ = SQUARE_SIZE;
#line 158 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp76_[0] = _tmp77_ + (_tmp78_ / 2.0);
#line 158 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp79_ = _tmp76_[0];
#line 159 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	last_line = 0.0;
#line 1212 "sudoku-printer.c"
	{
		gint n = 0;
#line 161 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		n = 1;
#line 1217 "sudoku-printer.c"
		{
			gboolean _tmp80_ = FALSE;
#line 161 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
			_tmp80_ = TRUE;
#line 161 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
			while (TRUE) {
#line 1224 "sudoku-printer.c"
				gint _tmp82_ = 0;
				gint _tmp83_ = 0;
				gdouble* _tmp98_ = NULL;
				gint _tmp98__length1 = 0;
				gint _tmp99_ = 0;
				gdouble _tmp100_ = 0.0;
				gdouble _tmp101_ = 0.0;
				gdouble _tmp102_ = 0.0;
				gdouble _tmp103_ = 0.0;
				cairo_t* _tmp104_ = NULL;
				gdouble _tmp105_ = 0.0;
				gdouble _tmp106_ = 0.0;
				gdouble _tmp107_ = 0.0;
				gdouble _tmp108_ = 0.0;
				gdouble _tmp109_ = 0.0;
				cairo_t* _tmp110_ = NULL;
				gdouble _tmp111_ = 0.0;
				gdouble _tmp112_ = 0.0;
				gdouble _tmp113_ = 0.0;
				gdouble _tmp114_ = 0.0;
				gdouble _tmp115_ = 0.0;
				gdouble _tmp116_ = 0.0;
				cairo_t* _tmp117_ = NULL;
				gdouble _tmp118_ = 0.0;
				gdouble _tmp119_ = 0.0;
				gdouble _tmp120_ = 0.0;
				gdouble _tmp121_ = 0.0;
				gdouble _tmp122_ = 0.0;
				cairo_t* _tmp123_ = NULL;
				gdouble _tmp124_ = 0.0;
				gdouble _tmp125_ = 0.0;
				gdouble _tmp126_ = 0.0;
				gdouble _tmp127_ = 0.0;
				gdouble _tmp128_ = 0.0;
				gdouble _tmp129_ = 0.0;
				cairo_t* _tmp130_ = NULL;
#line 161 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				if (!_tmp80_) {
#line 1263 "sudoku-printer.c"
					gint _tmp81_ = 0;
#line 161 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					_tmp81_ = n;
#line 161 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					n = _tmp81_ + 1;
#line 1269 "sudoku-printer.c"
				}
#line 161 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp80_ = FALSE;
#line 161 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp82_ = n;
#line 161 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				if (!(_tmp82_ <= SUDOKU_SIZE)) {
#line 161 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					break;
#line 1279 "sudoku-printer.c"
				}
#line 163 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp83_ = n;
#line 163 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				if ((_tmp83_ % N_BOXES) == 0) {
#line 1285 "sudoku-printer.c"
					cairo_t* _tmp84_ = NULL;
					gdouble _tmp85_ = 0.0;
					gdouble _tmp86_ = 0.0;
					gdouble _tmp87_ = 0.0;
					gdouble _tmp88_ = 0.0;
					gdouble _tmp89_ = 0.0;
					gdouble _tmp90_ = 0.0;
#line 165 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					_tmp84_ = cr;
#line 165 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					_tmp85_ = THICK;
#line 165 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					cairo_set_line_width (_tmp84_, _tmp85_);
#line 166 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					_tmp86_ = position;
#line 166 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					_tmp87_ = SQUARE_SIZE;
#line 166 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					_tmp88_ = last_line;
#line 166 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					_tmp89_ = THICK;
#line 166 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					position = _tmp86_ + ((_tmp87_ + (_tmp88_ / 2.0)) + (_tmp89_ / 2.0));
#line 167 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					_tmp90_ = THICK;
#line 167 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					last_line = _tmp90_;
#line 1313 "sudoku-printer.c"
				} else {
					cairo_t* _tmp91_ = NULL;
					gdouble _tmp92_ = 0.0;
					gdouble _tmp93_ = 0.0;
					gdouble _tmp94_ = 0.0;
					gdouble _tmp95_ = 0.0;
					gdouble _tmp96_ = 0.0;
					gdouble _tmp97_ = 0.0;
#line 171 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					_tmp91_ = cr;
#line 171 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					_tmp92_ = THIN;
#line 171 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					cairo_set_line_width (_tmp91_, _tmp92_);
#line 172 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					_tmp93_ = position;
#line 172 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					_tmp94_ = SQUARE_SIZE;
#line 172 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					_tmp95_ = last_line;
#line 172 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					_tmp96_ = THIN;
#line 172 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					position = _tmp93_ + ((_tmp94_ + (_tmp95_ / 2.0)) + (_tmp96_ / 2.0));
#line 173 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					_tmp97_ = THIN;
#line 173 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					last_line = _tmp97_;
#line 1342 "sudoku-printer.c"
				}
#line 176 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp98_ = pos;
#line 176 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp98__length1 = pos_length1;
#line 176 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp99_ = n;
#line 176 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp100_ = position;
#line 176 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp101_ = last_line;
#line 176 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp102_ = SQUARE_SIZE;
#line 176 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp98_[_tmp99_] = (_tmp100_ + (_tmp101_ / 2.0)) + (_tmp102_ / 2.0);
#line 176 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp103_ = _tmp98_[_tmp99_];
#line 177 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp104_ = cr;
#line 177 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp105_ = BORDER;
#line 177 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp106_ = THICK;
#line 177 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp107_ = offset_x;
#line 177 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp108_ = position;
#line 177 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp109_ = offset_y;
#line 177 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				cairo_move_to (_tmp104_, (_tmp105_ + (_tmp106_ / 2.0)) + _tmp107_, _tmp108_ + _tmp109_);
#line 178 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp110_ = cr;
#line 178 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp111_ = size;
#line 178 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp112_ = BORDER;
#line 178 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp113_ = THICK;
#line 178 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp114_ = offset_x;
#line 178 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp115_ = position;
#line 178 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp116_ = offset_y;
#line 178 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				cairo_line_to (_tmp110_, ((_tmp111_ - _tmp112_) - (_tmp113_ / 2.0)) + _tmp114_, _tmp115_ + _tmp116_);
#line 179 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp117_ = cr;
#line 179 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp118_ = position;
#line 179 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp119_ = offset_x;
#line 179 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp120_ = BORDER;
#line 179 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp121_ = THICK;
#line 179 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp122_ = offset_y;
#line 179 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				cairo_move_to (_tmp117_, _tmp118_ + _tmp119_, (_tmp120_ + (_tmp121_ / 2.0)) + _tmp122_);
#line 180 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp123_ = cr;
#line 180 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp124_ = position;
#line 180 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp125_ = offset_x;
#line 180 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp126_ = size;
#line 180 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp127_ = BORDER;
#line 180 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp128_ = THICK;
#line 180 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp129_ = offset_y;
#line 180 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				cairo_line_to (_tmp123_, _tmp124_ + _tmp125_, ((_tmp126_ - _tmp127_) - (_tmp128_ / 2.0)) + _tmp129_);
#line 181 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp130_ = cr;
#line 181 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				cairo_stroke (_tmp130_);
#line 1424 "sudoku-printer.c"
			}
		}
	}
#line 184 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp131_ = cr;
#line 184 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp132_ = FONT_SIZE;
#line 184 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	cairo_set_font_size (_tmp131_, (gdouble) _tmp132_);
#line 185 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp133_ = g_strdup ("");
#line 185 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	letter = _tmp133_;
#line 187 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp134_ = sudoku_board;
#line 187 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp137_ = sudoku_board_get_cells (_tmp134_, &_tmp135_, &_tmp136_);
#line 187 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	sudoku = _tmp137_;
#line 187 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	sudoku_length1 = _tmp135_;
#line 187 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	sudoku_length2 = _tmp136_;
#line 1448 "sudoku-printer.c"
	{
		gint x = 0;
#line 189 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		x = 0;
#line 1453 "sudoku-printer.c"
		{
			gboolean _tmp138_ = FALSE;
#line 189 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
			_tmp138_ = TRUE;
#line 189 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
			while (TRUE) {
#line 1460 "sudoku-printer.c"
				gint _tmp140_ = 0;
#line 189 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				if (!_tmp138_) {
#line 1464 "sudoku-printer.c"
					gint _tmp139_ = 0;
#line 189 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					_tmp139_ = x;
#line 189 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					x = _tmp139_ + 1;
#line 1470 "sudoku-printer.c"
				}
#line 189 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp138_ = FALSE;
#line 189 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp140_ = x;
#line 189 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				if (!(_tmp140_ < SUDOKU_SIZE)) {
#line 189 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					break;
#line 1480 "sudoku-printer.c"
				}
				{
					gint y = 0;
#line 191 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					y = 0;
#line 1486 "sudoku-printer.c"
					{
						gboolean _tmp141_ = FALSE;
#line 191 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
						_tmp141_ = TRUE;
#line 191 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
						while (TRUE) {
#line 1493 "sudoku-printer.c"
							gint _tmp143_ = 0;
							cairo_t* _tmp144_ = NULL;
							gdouble* _tmp145_ = NULL;
							gint _tmp145__length1 = 0;
							gint _tmp146_ = 0;
							gdouble _tmp147_ = 0.0;
							gdouble _tmp148_ = 0.0;
							gdouble* _tmp149_ = NULL;
							gint _tmp149__length1 = 0;
							gint _tmp150_ = 0;
							gdouble _tmp151_ = 0.0;
							gdouble _tmp152_ = 0.0;
							gchar* _tmp153_ = NULL;
							gint* _tmp154_ = NULL;
							gint _tmp154__length1 = 0;
							gint _tmp154__length2 = 0;
							gint _tmp155_ = 0;
							gint _tmp156_ = 0;
							gint _tmp157_ = 0;
#line 191 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
							if (!_tmp141_) {
#line 1515 "sudoku-printer.c"
								gint _tmp142_ = 0;
#line 191 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp142_ = y;
#line 191 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								y = _tmp142_ + 1;
#line 1521 "sudoku-printer.c"
							}
#line 191 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
							_tmp141_ = FALSE;
#line 191 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
							_tmp143_ = y;
#line 191 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
							if (!(_tmp143_ < SUDOKU_SIZE)) {
#line 191 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								break;
#line 1531 "sudoku-printer.c"
							}
#line 193 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
							_tmp144_ = cr;
#line 193 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
							_tmp145_ = pos;
#line 193 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
							_tmp145__length1 = pos_length1;
#line 193 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
							_tmp146_ = x;
#line 193 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
							_tmp147_ = _tmp145_[_tmp146_];
#line 193 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
							_tmp148_ = offset_x;
#line 193 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
							_tmp149_ = pos;
#line 193 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
							_tmp149__length1 = pos_length1;
#line 193 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
							_tmp150_ = y;
#line 193 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
							_tmp151_ = _tmp149_[_tmp150_];
#line 193 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
							_tmp152_ = offset_y;
#line 193 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
							cairo_move_to (_tmp144_, _tmp147_ + _tmp148_, _tmp151_ + _tmp152_);
#line 194 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
							_tmp153_ = g_strdup ("");
#line 194 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
							_g_free0 (letter);
#line 194 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
							letter = _tmp153_;
#line 196 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
							_tmp154_ = sudoku;
#line 196 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
							_tmp154__length1 = sudoku_length1;
#line 196 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
							_tmp154__length2 = sudoku_length2;
#line 196 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
							_tmp155_ = y;
#line 196 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
							_tmp156_ = x;
#line 196 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
							_tmp157_ = _tmp154_[(_tmp155_ * _tmp154__length2) + _tmp156_];
#line 196 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
							if (_tmp157_ != 0) {
#line 1577 "sudoku-printer.c"
								gint* _tmp158_ = NULL;
								gint _tmp158__length1 = 0;
								gint _tmp158__length2 = 0;
								gint _tmp159_ = 0;
								gint _tmp160_ = 0;
								gint _tmp161_ = 0;
								gchar* _tmp162_ = NULL;
								SudokuBoard* _tmp163_ = NULL;
								gboolean* _tmp164_ = NULL;
								gint _tmp164__length1 = 0;
								gint _tmp164__length2 = 0;
								gint _tmp165_ = 0;
								gint _tmp166_ = 0;
								gboolean _tmp167_ = FALSE;
								cairo_t* _tmp175_ = NULL;
								const gchar* _tmp176_ = NULL;
								cairo_text_extents_t _tmp177_ = {0};
								cairo_t* _tmp178_ = NULL;
								gdouble* _tmp179_ = NULL;
								gint _tmp179__length1 = 0;
								gint _tmp180_ = 0;
								gdouble _tmp181_ = 0.0;
								gdouble _tmp182_ = 0.0;
								cairo_text_extents_t _tmp183_ = {0};
								gdouble _tmp184_ = 0.0;
								gdouble* _tmp185_ = NULL;
								gint _tmp185__length1 = 0;
								gint _tmp186_ = 0;
								gdouble _tmp187_ = 0.0;
								gdouble _tmp188_ = 0.0;
								cairo_text_extents_t _tmp189_ = {0};
								gdouble _tmp190_ = 0.0;
								cairo_t* _tmp191_ = NULL;
								const gchar* _tmp192_ = NULL;
#line 198 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp158_ = sudoku;
#line 198 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp158__length1 = sudoku_length1;
#line 198 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp158__length2 = sudoku_length2;
#line 198 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp159_ = y;
#line 198 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp160_ = x;
#line 198 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp161_ = _tmp158_[(_tmp159_ * _tmp158__length2) + _tmp160_];
#line 198 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp162_ = g_strdup_printf ("%i", _tmp161_);
#line 198 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_g_free0 (letter);
#line 198 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								letter = _tmp162_;
#line 200 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp163_ = sudoku_board;
#line 200 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp164_ = _tmp163_->is_fixed;
#line 200 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp164__length1 = _tmp163_->is_fixed_length1;
#line 200 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp164__length2 = _tmp163_->is_fixed_length2;
#line 200 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp165_ = y;
#line 200 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp166_ = x;
#line 200 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp167_ = _tmp164_[(_tmp165_ * _tmp164__length2) + _tmp166_];
#line 200 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								if (_tmp167_) {
#line 1646 "sudoku-printer.c"
									cairo_t* _tmp168_ = NULL;
									cairo_t* _tmp169_ = NULL;
#line 202 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
									_tmp168_ = cr;
#line 202 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
									cairo_select_font_face (_tmp168_, "Sans", CAIRO_FONT_SLANT_NORMAL, FONT_WEIGHT);
#line 203 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
									_tmp169_ = cr;
#line 203 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
									cairo_set_source_rgb (_tmp169_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
#line 1657 "sudoku-printer.c"
								} else {
									cairo_t* _tmp170_ = NULL;
									cairo_t* _tmp171_ = NULL;
									gdouble _tmp172_ = 0.0;
									gdouble _tmp173_ = 0.0;
									gdouble _tmp174_ = 0.0;
#line 207 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
									_tmp170_ = cr;
#line 207 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
									cairo_select_font_face (_tmp170_, "Times", CAIRO_FONT_SLANT_ITALIC, FONT_WEIGHT);
#line 208 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
									_tmp171_ = cr;
#line 208 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
									_tmp172_ = PENCIL_GREY[0];
#line 208 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
									_tmp173_ = PENCIL_GREY[1];
#line 208 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
									_tmp174_ = PENCIL_GREY[2];
#line 208 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
									cairo_set_source_rgb (_tmp171_, _tmp172_, _tmp173_, _tmp174_);
#line 1678 "sudoku-printer.c"
								}
#line 210 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp175_ = cr;
#line 210 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp176_ = letter;
#line 210 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								cairo_text_extents (_tmp175_, _tmp176_, &_tmp177_);
#line 210 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								extents = _tmp177_;
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp178_ = cr;
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp179_ = pos;
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp179__length1 = pos_length1;
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp180_ = x;
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp181_ = _tmp179_[_tmp180_];
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp182_ = offset_x;
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp183_ = extents;
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp184_ = _tmp183_.x_advance;
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp185_ = pos;
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp185__length1 = pos_length1;
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp186_ = y;
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp187_ = _tmp185_[_tmp186_];
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp188_ = offset_y;
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp189_ = extents;
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp190_ = _tmp189_.height;
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								cairo_move_to (_tmp178_, (_tmp181_ + _tmp182_) - (_tmp184_ / 2.0), (_tmp187_ + _tmp188_) + (_tmp190_ / 2.0));
#line 212 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp191_ = cr;
#line 212 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								_tmp192_ = letter;
#line 212 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
								cairo_show_text (_tmp191_, _tmp192_);
#line 1726 "sudoku-printer.c"
							}
						}
					}
				}
			}
		}
	}
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	sudoku = (g_free (sudoku), NULL);
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_free0 (letter);
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	pos = (g_free (pos), NULL);
#line 111 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	outer = (g_free (outer), NULL);
#line 1742 "sudoku-printer.c"
}


static void sudoku_printer_class_init (SudokuPrinterClass * klass) {
#line 7 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	sudoku_printer_parent_class = g_type_class_peek_parent (klass);
#line 7 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_type_class_add_private (klass, sizeof (SudokuPrinterPrivate));
#line 7 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_printer_finalize;
#line 1753 "sudoku-printer.c"
}


static void sudoku_printer_instance_init (SudokuPrinter * self) {
#line 7 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	self->priv = SUDOKU_PRINTER_GET_PRIVATE (self);
#line 1760 "sudoku-printer.c"
}


static void sudoku_printer_finalize (GObject* obj) {
	SudokuPrinter * self;
#line 7 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_PRINTER, SudokuPrinter);
#line 9 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	self->priv->boards = (_vala_array_free (self->priv->boards, self->priv->boards_length1, (GDestroyNotify) g_object_unref), NULL);
#line 10 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->window);
#line 16 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->print_op);
#line 7 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	G_OBJECT_CLASS (sudoku_printer_parent_class)->finalize (obj);
#line 1776 "sudoku-printer.c"
}


GType sudoku_printer_get_type (void) {
	static volatile gsize sudoku_printer_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_printer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuPrinterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_printer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuPrinter), 0, (GInstanceInitFunc) sudoku_printer_instance_init, NULL };
		GType sudoku_printer_type_id;
		sudoku_printer_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuPrinter", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_printer_type_id__volatile, sudoku_printer_type_id);
	}
	return sudoku_printer_type_id__volatile;
}


static void _game_printer_response_cb_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 255 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	game_printer_response_cb ((GamePrinter*) self, _sender, response_id);
#line 1795 "sudoku-printer.c"
}


static void _g_object_unref0_ (gpointer var) {
#line 236 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 1802 "sudoku-printer.c"
}


static void _g_slist_free__g_object_unref0_ (GSList* self) {
#line 236 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_slist_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 236 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_slist_free (self);
#line 1811 "sudoku-printer.c"
}


GamePrinter* game_printer_construct (GType object_type, SudokuSaver* saver, GtkApplicationWindow** window) {
	GamePrinter * self = NULL;
	SudokuSaver* _tmp0_ = NULL;
	SudokuSaver* _tmp1_ = NULL;
	GtkApplicationWindow* _tmp2_ = NULL;
	GtkApplicationWindow* _tmp3_ = NULL;
	GSettings* _tmp4_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp5_ = NULL;
	GObject* _tmp8_ = NULL;
	GtkDialog* _tmp9_ = NULL;
	GtkDialog* _tmp10_ = NULL;
	GtkApplicationWindow* _tmp11_ = NULL;
	GtkDialog* _tmp12_ = NULL;
	GtkDialog* _tmp13_ = NULL;
	GSList* radio_group = NULL;
	GObject* _tmp14_ = NULL;
	GtkRadioButton* _tmp15_ = NULL;
	GtkRadioButton* _tmp16_ = NULL;
	GSList* _tmp17_ = NULL;
	GObject* _tmp18_ = NULL;
	GtkRadioButton* _tmp19_ = NULL;
	GtkRadioButton* _tmp20_ = NULL;
	GtkRadioButton* _tmp21_ = NULL;
	GObject* _tmp22_ = NULL;
	GtkRadioButton* _tmp23_ = NULL;
	GtkRadioButton* _tmp24_ = NULL;
	GtkRadioButton* _tmp25_ = NULL;
	GObject* _tmp26_ = NULL;
	GtkRadioButton* _tmp27_ = NULL;
	GtkRadioButton* _tmp28_ = NULL;
	GtkRadioButton* _tmp29_ = NULL;
	DifficultyCategory saved_difficulty = 0;
	GSettings* _tmp30_ = NULL;
	gint _tmp31_ = 0;
	DifficultyCategory _tmp32_ = 0;
	GObject* _tmp40_ = NULL;
	GtkSpinButton* _tmp41_ = NULL;
	GtkSpinButton* _tmp42_ = NULL;
	GtkAdjustment* _tmp43_ = NULL;
	GObject* _tmp44_ = NULL;
	GtkSpinner* _tmp45_ = NULL;
	GError * _inner_error_ = NULL;
#line 236 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_return_val_if_fail (saver != NULL, NULL);
#line 236 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_return_val_if_fail (*window != NULL, NULL);
#line 236 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	self = (GamePrinter*) g_object_new (object_type, NULL);
#line 238 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp0_ = saver;
#line 238 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 238 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->saver);
#line 238 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	self->priv->saver = _tmp1_;
#line 239 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp2_ = *window;
#line 239 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 239 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->window);
#line 239 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	self->priv->window = _tmp3_;
#line 240 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp4_ = g_settings_new ("org.gnome.sudoku");
#line 240 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->settings);
#line 240 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	self->priv->settings = _tmp4_;
#line 242 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp5_ = gtk_builder_new ();
#line 242 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	builder = _tmp5_;
#line 1890 "sudoku-printer.c"
	{
#line 245 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		gtk_builder_add_from_resource (builder, "/org/gnome/gnome-sudoku/ui/print-games.ui", &_inner_error_);
#line 245 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		if (_inner_error_ != NULL) {
#line 1896 "sudoku-printer.c"
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
#line 243 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		e = _inner_error_;
#line 243 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_inner_error_ = NULL;
#line 249 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp6_ = e;
#line 249 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp7_ = _tmp6_->message;
#line 249 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		g_warning ("sudoku-printer.vala:249: Could not load UI: %s", _tmp7_);
#line 243 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_g_error_free0 (e);
#line 1918 "sudoku-printer.c"
	}
	__finally5:
#line 243 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	if (_inner_error_ != NULL) {
#line 243 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_g_object_unref0 (builder);
#line 243 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 243 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		g_clear_error (&_inner_error_);
#line 243 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		return NULL;
#line 1931 "sudoku-printer.c"
	}
#line 251 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	gtk_builder_connect_signals (builder, NULL);
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp8_ = gtk_builder_get_object (builder, "dialog");
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, GTK_TYPE_DIALOG) ? ((GtkDialog*) _tmp8_) : NULL);
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->dialog);
#line 252 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	self->priv->dialog = _tmp9_;
#line 253 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp10_ = self->priv->dialog;
#line 253 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp11_ = *window;
#line 253 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	gtk_window_set_transient_for ((GtkWindow*) _tmp10_, (GtkWindow*) _tmp11_);
#line 254 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp12_ = self->priv->dialog;
#line 254 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	gtk_dialog_set_default_response (_tmp12_, (gint) GTK_RESPONSE_OK);
#line 255 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp13_ = self->priv->dialog;
#line 255 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_signal_connect_object (_tmp13_, "response", (GCallback) _game_printer_response_cb_gtk_dialog_response, self, 0);
#line 257 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	radio_group = NULL;
#line 259 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp14_ = gtk_builder_get_object (builder, "easyRadioButton");
#line 259 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, GTK_TYPE_RADIO_BUTTON) ? ((GtkRadioButton*) _tmp14_) : NULL);
#line 259 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->easy_button);
#line 259 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	self->priv->easy_button = _tmp15_;
#line 260 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp16_ = self->priv->easy_button;
#line 260 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp17_ = radio_group;
#line 260 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	gtk_radio_button_set_group (_tmp16_, _tmp17_);
#line 262 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp18_ = gtk_builder_get_object (builder, "mediumRadioButton");
#line 262 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, GTK_TYPE_RADIO_BUTTON) ? ((GtkRadioButton*) _tmp18_) : NULL);
#line 262 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->medium_button);
#line 262 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	self->priv->medium_button = _tmp19_;
#line 263 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp20_ = self->priv->medium_button;
#line 263 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp21_ = self->priv->easy_button;
#line 263 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	gtk_radio_button_join_group (_tmp20_, _tmp21_);
#line 265 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp22_ = gtk_builder_get_object (builder, "hardRadioButton");
#line 265 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, GTK_TYPE_RADIO_BUTTON) ? ((GtkRadioButton*) _tmp22_) : NULL);
#line 265 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->hard_button);
#line 265 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	self->priv->hard_button = _tmp23_;
#line 266 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp24_ = self->priv->hard_button;
#line 266 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp25_ = self->priv->easy_button;
#line 266 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	gtk_radio_button_join_group (_tmp24_, _tmp25_);
#line 268 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp26_ = gtk_builder_get_object (builder, "very_hardRadioButton");
#line 268 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp27_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, GTK_TYPE_RADIO_BUTTON) ? ((GtkRadioButton*) _tmp26_) : NULL);
#line 268 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->very_hard_button);
#line 268 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	self->priv->very_hard_button = _tmp27_;
#line 269 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp28_ = self->priv->very_hard_button;
#line 269 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp29_ = self->priv->easy_button;
#line 269 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	gtk_radio_button_join_group (_tmp28_, _tmp29_);
#line 271 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp30_ = self->priv->settings;
#line 271 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp31_ = g_settings_get_enum (_tmp30_, GAME_PRINTER_DIFFICULTY_KEY_NAME);
#line 271 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	saved_difficulty = (DifficultyCategory) _tmp31_;
#line 273 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp32_ = saved_difficulty;
#line 273 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	if (_tmp32_ == DIFFICULTY_CATEGORY_EASY) {
#line 2025 "sudoku-printer.c"
		GtkRadioButton* _tmp33_ = NULL;
#line 274 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp33_ = self->priv->easy_button;
#line 274 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		gtk_toggle_button_set_active ((GtkToggleButton*) _tmp33_, TRUE);
#line 2031 "sudoku-printer.c"
	} else {
		DifficultyCategory _tmp34_ = 0;
#line 275 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp34_ = saved_difficulty;
#line 275 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		if (_tmp34_ == DIFFICULTY_CATEGORY_MEDIUM) {
#line 2038 "sudoku-printer.c"
			GtkRadioButton* _tmp35_ = NULL;
#line 276 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
			_tmp35_ = self->priv->medium_button;
#line 276 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp35_, TRUE);
#line 2044 "sudoku-printer.c"
		} else {
			DifficultyCategory _tmp36_ = 0;
#line 277 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
			_tmp36_ = saved_difficulty;
#line 277 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
			if (_tmp36_ == DIFFICULTY_CATEGORY_HARD) {
#line 2051 "sudoku-printer.c"
				GtkRadioButton* _tmp37_ = NULL;
#line 278 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp37_ = self->priv->hard_button;
#line 278 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				gtk_toggle_button_set_active ((GtkToggleButton*) _tmp37_, TRUE);
#line 2057 "sudoku-printer.c"
			} else {
				DifficultyCategory _tmp38_ = 0;
#line 279 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp38_ = saved_difficulty;
#line 279 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				if (_tmp38_ == DIFFICULTY_CATEGORY_VERY_HARD) {
#line 2064 "sudoku-printer.c"
					GtkRadioButton* _tmp39_ = NULL;
#line 280 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					_tmp39_ = self->priv->very_hard_button;
#line 280 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					gtk_toggle_button_set_active ((GtkToggleButton*) _tmp39_, TRUE);
#line 2070 "sudoku-printer.c"
				}
			}
		}
	}
#line 282 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp40_ = gtk_builder_get_object (builder, "sudokusToPrintSpinButton");
#line 282 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp41_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp40_, GTK_TYPE_SPIN_BUTTON) ? ((GtkSpinButton*) _tmp40_) : NULL);
#line 282 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->nsudokus_button);
#line 282 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	self->priv->nsudokus_button = _tmp41_;
#line 283 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp42_ = self->priv->nsudokus_button;
#line 283 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp43_ = gtk_spin_button_get_adjustment (_tmp42_);
#line 283 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	game_printer_wrap_adjustment (self, "print-multiple-sudokus-to-print", _tmp43_);
#line 285 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp44_ = gtk_builder_get_object (builder, "spinner");
#line 285 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp45_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp44_, GTK_TYPE_SPINNER) ? ((GtkSpinner*) _tmp44_) : NULL);
#line 285 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->spinner);
#line 285 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	self->priv->spinner = _tmp45_;
#line 236 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	__g_slist_free__g_object_unref0_0 (radio_group);
#line 236 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (builder);
#line 236 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	return self;
#line 2103 "sudoku-printer.c"
}


GamePrinter* game_printer_new (SudokuSaver* saver, GtkApplicationWindow** window) {
#line 236 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	return game_printer_construct (TYPE_GAME_PRINTER, saver, window);
#line 2110 "sudoku-printer.c"
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_atomic_int_inc (&_data9_->_ref_count_);
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	return _data9_;
#line 2119 "sudoku-printer.c"
}


static void block9_data_unref (void * _userdata_) {
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
#line 2128 "sudoku-printer.c"
		GamePrinter* self;
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		self = _data9_->self;
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_g_free0 (_data9_->key_name);
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_g_object_unref0 (_data9_->action);
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_g_object_unref0 (self);
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		g_slice_free (Block9Data, _data9_);
#line 2140 "sudoku-printer.c"
	}
}


static void __lambda19_ (Block9Data* _data9_) {
	GamePrinter* self;
	GSettings* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkAdjustment* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
#line 291 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	self = _data9_->self;
#line 291 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp0_ = self->priv->settings;
#line 291 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp1_ = _data9_->key_name;
#line 291 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp2_ = _data9_->action;
#line 291 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp3_ = gtk_adjustment_get_value (_tmp2_);
#line 291 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_settings_set_int (_tmp0_, _tmp1_, (gint) _tmp3_);
#line 2163 "sudoku-printer.c"
}


static void ___lambda19__gtk_adjustment_value_changed (GtkAdjustment* _sender, gpointer self) {
#line 291 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	__lambda19_ (self);
#line 2170 "sudoku-printer.c"
}


static void game_printer_wrap_adjustment (GamePrinter* self, const gchar* key_name, GtkAdjustment* action) {
	Block9Data* _data9_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GtkAdjustment* _tmp2_ = NULL;
	GtkAdjustment* _tmp3_ = NULL;
	GtkAdjustment* _tmp4_ = NULL;
	GSettings* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	GtkAdjustment* _tmp8_ = NULL;
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_return_if_fail (self != NULL);
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_return_if_fail (key_name != NULL);
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_return_if_fail (action != NULL);
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_data9_ = g_slice_new0 (Block9Data);
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_data9_->_ref_count_ = 1;
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_data9_->self = g_object_ref (self);
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp0_ = key_name;
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_free0 (_data9_->key_name);
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_data9_->key_name = _tmp1_;
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp2_ = action;
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (_data9_->action);
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_data9_->action = _tmp3_;
#line 290 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp4_ = _data9_->action;
#line 290 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp5_ = self->priv->settings;
#line 290 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp6_ = _data9_->key_name;
#line 290 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp7_ = g_settings_get_int (_tmp5_, _tmp6_);
#line 290 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	gtk_adjustment_set_value (_tmp4_, (gdouble) _tmp7_);
#line 291 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp8_ = _data9_->action;
#line 291 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_signal_connect_data (_tmp8_, "value-changed", (GCallback) ___lambda19__gtk_adjustment_value_changed, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	block9_data_unref (_data9_);
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_data9_ = NULL;
#line 2231 "sudoku-printer.c"
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_atomic_int_inc (&_data10_->_ref_count_);
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	return _data10_;
#line 2240 "sudoku-printer.c"
}


static void block10_data_unref (void * _userdata_) {
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
#line 2249 "sudoku-printer.c"
		GamePrinter* self;
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		self = _data10_->self;
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_g_object_unref0 (_data10_->dialog);
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_g_object_unref0 (self);
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		g_slice_free (Block10Data, _data10_);
#line 2259 "sudoku-printer.c"
	}
}


static void __lambda18_ (Block10Data* _data10_, GObject* obj, GAsyncResult* res) {
	GamePrinter* self;
	GError * _inner_error_ = NULL;
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	self = _data10_->self;
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_return_if_fail (res != NULL);
#line 2271 "sudoku-printer.c"
	{
		SudokuBoard** boards = NULL;
		GAsyncResult* _tmp0_ = NULL;
		gint _tmp1_ = 0;
		SudokuBoard** _tmp2_ = NULL;
		gint boards_length1 = 0;
		gint _boards_size_ = 0;
		GtkSpinner* _tmp3_ = NULL;
		GtkSpinner* _tmp4_ = NULL;
		GtkDialog* _tmp5_ = NULL;
		SudokuPrinter* printer = NULL;
		SudokuPrinter* _tmp6_ = NULL;
		GtkPrintOperationResult _result_ = 0;
		SudokuPrinter* _tmp7_ = NULL;
		GtkPrintOperationResult _tmp8_ = 0;
		GtkPrintOperationResult _tmp9_ = 0;
#line 326 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp0_ = res;
#line 326 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp2_ = sudoku_generator_generate_boards_finish (_tmp0_, &_tmp1_, &_inner_error_);
#line 326 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		boards = _tmp2_;
#line 326 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		boards_length1 = _tmp1_;
#line 326 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_boards_size_ = boards_length1;
#line 326 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		if (_inner_error_ != NULL) {
#line 326 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
			if (_inner_error_->domain == G_THREAD_ERROR) {
#line 2302 "sudoku-printer.c"
				goto __catch6_g_thread_error;
			}
#line 326 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 326 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
			g_clear_error (&_inner_error_);
#line 326 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
			return;
#line 2311 "sudoku-printer.c"
		}
#line 328 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp3_ = self->priv->spinner;
#line 328 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		gtk_spinner_stop (_tmp3_);
#line 329 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp4_ = self->priv->spinner;
#line 329 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		gtk_widget_hide ((GtkWidget*) _tmp4_);
#line 330 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp5_ = _data10_->dialog;
#line 330 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp5_, TRUE);
#line 332 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp6_ = sudoku_printer_new (boards, boards_length1, &self->priv->window);
#line 332 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		printer = _tmp6_;
#line 333 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp7_ = printer;
#line 333 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp8_ = sudoku_printer_print_sudoku (_tmp7_);
#line 333 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_result_ = _tmp8_;
#line 334 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp9_ = _result_;
#line 334 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		if (_tmp9_ == GTK_PRINT_OPERATION_RESULT_APPLY) {
#line 2339 "sudoku-printer.c"
			GtkDialog* _tmp10_ = NULL;
#line 336 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
			_tmp10_ = _data10_->dialog;
#line 336 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
			gtk_widget_hide ((GtkWidget*) _tmp10_);
#line 2345 "sudoku-printer.c"
			{
				SudokuBoard** board_collection = NULL;
				gint board_collection_length1 = 0;
				gint _board_collection_size_ = 0;
				gint board_it = 0;
#line 337 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				board_collection = boards;
#line 337 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				board_collection_length1 = boards_length1;
#line 337 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				for (board_it = 0; board_it < boards_length1; board_it = board_it + 1) {
#line 2357 "sudoku-printer.c"
					SudokuBoard* _tmp11_ = NULL;
					SudokuBoard* board = NULL;
#line 337 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					_tmp11_ = _g_object_ref0 (board_collection[board_it]);
#line 337 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					board = _tmp11_;
#line 2364 "sudoku-printer.c"
					{
						SudokuSaver* _tmp12_ = NULL;
						SudokuBoard* _tmp13_ = NULL;
						SudokuGame* _tmp14_ = NULL;
						SudokuGame* _tmp15_ = NULL;
#line 338 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
						_tmp12_ = self->priv->saver;
#line 338 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
						_tmp13_ = board;
#line 338 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
						_tmp14_ = sudoku_game_new (_tmp13_);
#line 338 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
						_tmp15_ = _tmp14_;
#line 338 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
						sudoku_saver_add_game_to_finished (_tmp12_, _tmp15_, FALSE);
#line 338 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
						_g_object_unref0 (_tmp15_);
#line 337 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
						_g_object_unref0 (board);
#line 2384 "sudoku-printer.c"
					}
				}
			}
		}
#line 325 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_g_object_unref0 (printer);
#line 325 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		boards = (_vala_array_free (boards, boards_length1, (GDestroyNotify) g_object_unref), NULL);
#line 2393 "sudoku-printer.c"
	}
	goto __finally6;
	__catch6_g_thread_error:
	{
		GError* e = NULL;
		const gchar* _tmp16_ = NULL;
#line 325 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		e = _inner_error_;
#line 325 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_inner_error_ = NULL;
#line 341 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp16_ = e->message;
#line 341 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		g_error ("sudoku-printer.vala:341: Thread error: %s\n", _tmp16_);
#line 325 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_g_error_free0 (e);
#line 2410 "sudoku-printer.c"
	}
	__finally6:
#line 325 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	if (_inner_error_ != NULL) {
#line 325 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 325 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		g_clear_error (&_inner_error_);
#line 325 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		return;
#line 2421 "sudoku-printer.c"
	}
}


static void ___lambda18__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	__lambda18_ (self, source_object, res);
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	block10_data_unref (self);
#line 2431 "sudoku-printer.c"
}


static void game_printer_response_cb (GamePrinter* self, GtkDialog* dialog, gint response) {
	Block10Data* _data10_;
	GtkDialog* _tmp0_ = NULL;
	GtkDialog* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gint _tmp3_ = 0;
	gint nsudokus = 0;
	GtkSpinButton* _tmp6_ = NULL;
	GtkAdjustment* _tmp7_ = NULL;
	gdouble _tmp8_ = 0.0;
	DifficultyCategory level = 0;
	GtkRadioButton* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	GSettings* _tmp17_ = NULL;
	DifficultyCategory _tmp18_ = 0;
	GtkSpinner* _tmp19_ = NULL;
	GtkSpinner* _tmp20_ = NULL;
	GtkSpinner* _tmp21_ = NULL;
	GtkSpinner* _tmp22_ = NULL;
	GtkDialog* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	DifficultyCategory _tmp25_ = 0;
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_return_if_fail (self != NULL);
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_return_if_fail (dialog != NULL);
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_data10_ = g_slice_new0 (Block10Data);
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_data10_->_ref_count_ = 1;
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_data10_->self = g_object_ref (self);
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp0_ = dialog;
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (_data10_->dialog);
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_data10_->dialog = _tmp1_;
#line 296 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp3_ = response;
#line 296 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	if (_tmp3_ != ((gint) GTK_RESPONSE_ACCEPT)) {
#line 2479 "sudoku-printer.c"
		gint _tmp4_ = 0;
#line 296 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp4_ = response;
#line 296 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp2_ = _tmp4_ != ((gint) GTK_RESPONSE_OK);
#line 2485 "sudoku-printer.c"
	} else {
#line 296 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp2_ = FALSE;
#line 2489 "sudoku-printer.c"
	}
#line 296 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	if (_tmp2_) {
#line 2493 "sudoku-printer.c"
		GtkDialog* _tmp5_ = NULL;
#line 298 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp5_ = _data10_->dialog;
#line 298 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		gtk_widget_hide ((GtkWidget*) _tmp5_);
#line 299 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		block10_data_unref (_data10_);
#line 299 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_data10_ = NULL;
#line 299 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		return;
#line 2505 "sudoku-printer.c"
	}
#line 302 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp6_ = self->priv->nsudokus_button;
#line 302 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp7_ = gtk_spin_button_get_adjustment (_tmp6_);
#line 302 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp8_ = gtk_adjustment_get_value (_tmp7_);
#line 302 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	nsudokus = (gint) _tmp8_;
#line 305 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp9_ = self->priv->easy_button;
#line 305 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp10_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp9_);
#line 305 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	if (_tmp10_) {
#line 306 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		level = DIFFICULTY_CATEGORY_EASY;
#line 2523 "sudoku-printer.c"
	} else {
		GtkRadioButton* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
#line 307 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp11_ = self->priv->medium_button;
#line 307 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		_tmp12_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp11_);
#line 307 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
		if (_tmp12_) {
#line 308 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
			level = DIFFICULTY_CATEGORY_MEDIUM;
#line 2535 "sudoku-printer.c"
		} else {
			GtkRadioButton* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
#line 309 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
			_tmp13_ = self->priv->hard_button;
#line 309 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
			_tmp14_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp13_);
#line 309 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
			if (_tmp14_) {
#line 310 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				level = DIFFICULTY_CATEGORY_HARD;
#line 2547 "sudoku-printer.c"
			} else {
				GtkRadioButton* _tmp15_ = NULL;
				gboolean _tmp16_ = FALSE;
#line 311 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp15_ = self->priv->very_hard_button;
#line 311 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				_tmp16_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp15_);
#line 311 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
				if (_tmp16_) {
#line 312 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					level = DIFFICULTY_CATEGORY_VERY_HARD;
#line 2559 "sudoku-printer.c"
				} else {
#line 314 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
					g_assert_not_reached ();
#line 2563 "sudoku-printer.c"
				}
			}
		}
	}
#line 316 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp17_ = self->priv->settings;
#line 316 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp18_ = level;
#line 316 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_settings_set_enum (_tmp17_, GAME_PRINTER_DIFFICULTY_KEY_NAME, (gint) _tmp18_);
#line 318 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp19_ = self->priv->spinner;
#line 318 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp19_, TRUE);
#line 319 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp20_ = self->priv->spinner;
#line 319 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_object_set (_tmp20_, "active", TRUE, NULL);
#line 320 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp21_ = self->priv->spinner;
#line 320 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	gtk_widget_show ((GtkWidget*) _tmp21_);
#line 321 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp22_ = self->priv->spinner;
#line 321 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	gtk_spinner_start (_tmp22_);
#line 322 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp23_ = _data10_->dialog;
#line 322 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp23_, FALSE);
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp24_ = nsudokus;
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp25_ = level;
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	sudoku_generator_generate_boards_async (_tmp24_, _tmp25_, ___lambda18__gasync_ready_callback, block10_data_ref (_data10_));
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	block10_data_unref (_data10_);
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_data10_ = NULL;
#line 2604 "sudoku-printer.c"
}


void game_printer_run_dialog (GamePrinter* self) {
	GtkDialog* _tmp0_ = NULL;
#line 346 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_return_if_fail (self != NULL);
#line 348 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_tmp0_ = self->priv->dialog;
#line 348 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	gtk_widget_show ((GtkWidget*) _tmp0_);
#line 2616 "sudoku-printer.c"
}


static void game_printer_class_init (GamePrinterClass * klass) {
#line 219 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	game_printer_parent_class = g_type_class_peek_parent (klass);
#line 219 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	g_type_class_add_private (klass, sizeof (GamePrinterPrivate));
#line 219 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	G_OBJECT_CLASS (klass)->finalize = game_printer_finalize;
#line 2627 "sudoku-printer.c"
}


static void game_printer_instance_init (GamePrinter * self) {
#line 219 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	self->priv = GAME_PRINTER_GET_PRIVATE (self);
#line 2634 "sudoku-printer.c"
}


static void game_printer_finalize (GObject* obj) {
	GamePrinter * self;
#line 219 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_PRINTER, GamePrinter);
#line 221 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->saver);
#line 222 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->window);
#line 223 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->settings);
#line 224 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->dialog);
#line 225 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->nsudokus_button);
#line 227 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->easy_button);
#line 228 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->medium_button);
#line 229 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->hard_button);
#line 230 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->very_hard_button);
#line 232 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	_g_object_unref0 (self->priv->spinner);
#line 219 "/home/manhattan/checkout/gnome/gnome-sudoku/src/sudoku-printer.vala"
	G_OBJECT_CLASS (game_printer_parent_class)->finalize (obj);
#line 2664 "sudoku-printer.c"
}


GType game_printer_get_type (void) {
	static volatile gsize game_printer_type_id__volatile = 0;
	if (g_once_init_enter (&game_printer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GamePrinterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_printer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamePrinter), 0, (GInstanceInitFunc) game_printer_instance_init, NULL };
		GType game_printer_type_id;
		game_printer_type_id = g_type_register_static (G_TYPE_OBJECT, "GamePrinter", &g_define_type_info, 0);
		g_once_init_leave (&game_printer_type_id__volatile, game_printer_type_id);
	}
	return game_printer_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



