/* sudoku-generator.c generated by valac 0.23.3.24-5b8db, the Vala compiler
 * generated from sudoku-generator.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */

#include <glib.h>
#include <glib-object.h>
#include <stdio.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <string.h>


#define TYPE_SUDOKU_GENERATOR (sudoku_generator_get_type ())
#define SUDOKU_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_GENERATOR, SudokuGenerator))
#define SUDOKU_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_GENERATOR, SudokuGeneratorClass))
#define IS_SUDOKU_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_GENERATOR))
#define IS_SUDOKU_GENERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_GENERATOR))
#define SUDOKU_GENERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_GENERATOR, SudokuGeneratorClass))

typedef struct _SudokuGenerator SudokuGenerator;
typedef struct _SudokuGeneratorClass SudokuGeneratorClass;
typedef struct _SudokuGeneratorPrivate SudokuGeneratorPrivate;

#define TYPE_SUDOKU_BOARD (sudoku_board_get_type ())
#define SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_BOARD, SudokuBoard))
#define SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_BOARD, SudokuBoardClass))
#define IS_SUDOKU_BOARD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_BOARD))
#define IS_SUDOKU_BOARD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_BOARD))
#define SUDOKU_BOARD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_BOARD, SudokuBoardClass))

typedef struct _SudokuBoard SudokuBoard;
typedef struct _SudokuBoardClass SudokuBoardClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define SUDOKU_GENERATOR_TYPE_RATED_SUDOKU (sudoku_generator_rated_sudoku_get_type ())

#define TYPE_DIFFICULTY_RATING (difficulty_rating_get_type ())
#define DIFFICULTY_RATING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DIFFICULTY_RATING, DifficultyRating))
#define DIFFICULTY_RATING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DIFFICULTY_RATING, DifficultyRatingClass))
#define IS_DIFFICULTY_RATING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DIFFICULTY_RATING))
#define IS_DIFFICULTY_RATING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DIFFICULTY_RATING))
#define DIFFICULTY_RATING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DIFFICULTY_RATING, DifficultyRatingClass))

typedef struct _DifficultyRating DifficultyRating;
typedef struct _DifficultyRatingClass DifficultyRatingClass;
typedef struct _SudokuGeneratorRatedSudoku SudokuGeneratorRatedSudoku;
#define _sudoku_generator_rated_sudoku_free0(var) ((var == NULL) ? NULL : (var = (sudoku_generator_rated_sudoku_free (var), NULL)))
typedef struct _DifficultyRatingPrivate DifficultyRatingPrivate;
typedef struct _SudokuBoardPrivate SudokuBoardPrivate;

#define TYPE_COORD (coord_get_type ())
typedef struct _Coord Coord;

#define TYPE_SUDOKU_SOLVER (sudoku_solver_get_type ())
#define SUDOKU_SOLVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_SOLVER, SudokuSolver))
#define SUDOKU_SOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_SOLVER, SudokuSolverClass))
#define IS_SUDOKU_SOLVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_SOLVER))
#define IS_SUDOKU_SOLVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_SOLVER))
#define SUDOKU_SOLVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_SOLVER, SudokuSolverClass))

typedef struct _SudokuSolver SudokuSolver;
typedef struct _SudokuSolverClass SudokuSolverClass;

#define TYPE_SUDOKU_RATER (sudoku_rater_get_type ())
#define SUDOKU_RATER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_RATER, SudokuRater))
#define SUDOKU_RATER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_RATER, SudokuRaterClass))
#define IS_SUDOKU_RATER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_RATER))
#define IS_SUDOKU_RATER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_RATER))
#define SUDOKU_RATER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_RATER, SudokuRaterClass))

typedef struct _SudokuRater SudokuRater;
typedef struct _SudokuRaterClass SudokuRaterClass;
typedef struct _SudokuSolverPrivate SudokuSolverPrivate;

#define TYPE_GUESS_LIST (guess_list_get_type ())
#define GUESS_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GUESS_LIST, GuessList))
#define GUESS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GUESS_LIST, GuessListClass))
#define IS_GUESS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GUESS_LIST))
#define IS_GUESS_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GUESS_LIST))
#define GUESS_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GUESS_LIST, GuessListClass))

typedef struct _GuessList GuessList;
typedef struct _GuessListClass GuessListClass;

#define TYPE_BREADCRUMB_TRAIL (breadcrumb_trail_get_type ())
#define BREADCRUMB_TRAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BREADCRUMB_TRAIL, BreadcrumbTrail))
#define BREADCRUMB_TRAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BREADCRUMB_TRAIL, BreadcrumbTrailClass))
#define IS_BREADCRUMB_TRAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BREADCRUMB_TRAIL))
#define IS_BREADCRUMB_TRAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BREADCRUMB_TRAIL))
#define BREADCRUMB_TRAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BREADCRUMB_TRAIL, BreadcrumbTrailClass))

typedef struct _BreadcrumbTrail BreadcrumbTrail;
typedef struct _BreadcrumbTrailClass BreadcrumbTrailClass;

#define TYPE_GUESS (guess_get_type ())
#define GUESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GUESS, Guess))
#define GUESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GUESS, GuessClass))
#define IS_GUESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GUESS))
#define IS_GUESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GUESS))
#define GUESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GUESS, GuessClass))

typedef struct _Guess Guess;
typedef struct _GuessClass GuessClass;

struct _SudokuGenerator {
	GObject parent_instance;
	SudokuGeneratorPrivate * priv;
	gint clues;
	SudokuBoard* start_board;
};

struct _SudokuGeneratorClass {
	GObjectClass parent_class;
};

struct _SudokuGeneratorPrivate {
	SudokuBoard* temp_start_board;
};

struct _SudokuGeneratorRatedSudoku {
	SudokuBoard* board;
	DifficultyRating* diff;
};

struct _DifficultyRating {
	GObject parent_instance;
	DifficultyRatingPrivate * priv;
	gfloat rating;
};

struct _DifficultyRatingClass {
	GObjectClass parent_class;
};

struct _Coord {
	gint row;
	gint col;
};

struct _SudokuBoard {
	GObject parent_instance;
	SudokuBoardPrivate * priv;
	gint* cells;
	gint cells_length1;
	gint cells_length2;
	gboolean* is_fixed;
	gint is_fixed_length1;
	gint is_fixed_length2;
	gboolean* earmarks;
	gint earmarks_length1;
	gint earmarks_length2;
	gint earmarks_length3;
	gdouble difficulty_rating;
	GeeSet* broken_coords;
	GeeList* coords_for_col;
	GeeList* coords_for_row;
	GeeMap* coords_for_block;
};

struct _SudokuBoardClass {
	GObjectClass parent_class;
};

typedef enum  {
	SUDOKU_ERROR_UNSOLVABLE_PUZZLE,
	SUDOKU_ERROR_CONFLICT_ERROR,
	SUDOKU_ERROR_ALREADY_SET_ERROR
} SudokuError;
#define SUDOKU_ERROR sudoku_error_quark ()
struct _SudokuSolver {
	GObject parent_instance;
	SudokuSolverPrivate * priv;
	SudokuBoard* board;
	GuessList* guesses;
	BreadcrumbTrail* breadcrumbs;
	gint backtraces;
	gboolean solved;
};

struct _SudokuSolverClass {
	GObjectClass parent_class;
	gboolean (*guess_least_open_square) (SudokuSolver* self, GError** error);
	void (*insert) (SudokuSolver* self, gint row, gint col, gint val);
};


static gpointer sudoku_generator_parent_class = NULL;

GType sudoku_generator_get_type (void) G_GNUC_CONST;
GType sudoku_board_get_type (void) G_GNUC_CONST;
#define SUDOKU_GENERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU_GENERATOR, SudokuGeneratorPrivate))
enum  {
	SUDOKU_GENERATOR_DUMMY_PROPERTY
};
SudokuBoard* sudoku_board_new (gint block_rows, gint block_cols);
SudokuBoard* sudoku_board_construct (GType object_type, gint block_rows, gint block_cols);
SudokuGenerator* sudoku_generator_new (void);
SudokuGenerator* sudoku_generator_construct (GType object_type);
static void sudoku_generator_generate_start_board (SudokuGenerator* self, gint row, gint col, gint no, gint filled, gint* solution);
void sudoku_generator_gen_stats (void);
GType sudoku_generator_rated_sudoku_get_type (void) G_GNUC_CONST;
GType difficulty_rating_get_type (void) G_GNUC_CONST;
SudokuGeneratorRatedSudoku* sudoku_generator_rated_sudoku_dup (const SudokuGeneratorRatedSudoku* self);
void sudoku_generator_rated_sudoku_free (SudokuGeneratorRatedSudoku* self);
void sudoku_generator_rated_sudoku_copy (const SudokuGeneratorRatedSudoku* self, SudokuGeneratorRatedSudoku* dest);
void sudoku_generator_rated_sudoku_destroy (SudokuGeneratorRatedSudoku* self);
SudokuGeneratorRatedSudoku* sudoku_generator_make_unique_puzzle (SudokuGenerator* self, gint line, gboolean strict_number_of_clues);
SudokuBoard* sudoku_generator_generate (SudokuGenerator* self, gfloat* difficulty_range, int difficulty_range_length1, gboolean symmetric);
static gint sudoku_generator_get_cells_for (SudokuGenerator* self, gfloat difficulty);
gboolean difficulty_rating_in_range (DifficultyRating* self, gfloat* range, int range_length1);
SudokuBoard* sudoku_generator_make_puzzle_by_boxes (SudokuGenerator* self, gfloat skew_by);
gint sudoku_board_get_filled (SudokuBoard* self);
gint sudoku_board_get_rows (SudokuBoard* self);
gint sudoku_board_get_cols (SudokuBoard* self);
void sudoku_board_insert (SudokuBoard* self, gint row, gint col, gint val, gboolean is_fixed);
gint sudoku_board_get (SudokuBoard* self, gint row, gint col);
gint sudoku_board_get_max_val (SudokuBoard* self);
gboolean sudoku_board_is_possible (SudokuBoard* self, gint row, gint col, gint val);
void sudoku_board_remove (SudokuBoard* self, gint row, gint col, gboolean is_fixed);
SudokuBoard* sudoku_generator_make_symmetric_puzzle (SudokuGenerator* self, gint line);
GType coord_get_type (void) G_GNUC_CONST;
Coord* coord_dup (const Coord* self);
void coord_free (Coord* self);
static void sudoku_generator_reflect (SudokuGenerator* self, gint row, gint col, gint line, Coord* result);
void coord_init (Coord *self, gint row, gint col);
gint sudoku_board_get_block_cols (SudokuBoard* self);
gint sudoku_board_get_block_rows (SudokuBoard* self);
SudokuBoard* sudoku_board_clone (SudokuBoard* self);
GType sudoku_solver_get_type (void) G_GNUC_CONST;
GType sudoku_rater_get_type (void) G_GNUC_CONST;
SudokuRater* sudoku_rater_new (SudokuBoard** board);
SudokuRater* sudoku_rater_construct (GType object_type, SudokuBoard** board);
gboolean sudoku_solver_has_unique_solution (SudokuSolver* self);
DifficultyRating* sudoku_rater_get_difficulty (SudokuRater* self);
GQuark sudoku_error_quark (void);
GType guess_list_get_type (void) G_GNUC_CONST;
GType breadcrumb_trail_get_type (void) G_GNUC_CONST;
GType guess_get_type (void) G_GNUC_CONST;
gint guess_get_row (Guess* self);
gint guess_get_col (Guess* self);
void sudoku_generator_rated_sudoku_init (SudokuGeneratorRatedSudoku *self, SudokuBoard* board, DifficultyRating* diff);
static void sudoku_generator_finalize (GObject* obj);


SudokuGenerator* sudoku_generator_construct (GType object_type) {
	SudokuGenerator * self = NULL;
	gint solution = 0;
#line 22 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	self = (SudokuGenerator*) g_object_new (object_type, NULL);
#line 23 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	solution = 0;
#line 24 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	sudoku_generator_generate_start_board (self, -1, -1, -1, -1, &solution);
#line 22 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	return self;
#line 259 "sudoku-generator.c"
}


SudokuGenerator* sudoku_generator_new (void) {
#line 22 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	return sudoku_generator_construct (TYPE_SUDOKU_GENERATOR);
#line 266 "sudoku-generator.c"
}


void sudoku_generator_gen_stats (void) {
	{
		gint i = 0;
#line 29 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		i = 22;
#line 275 "sudoku-generator.c"
		{
			gboolean _tmp0_ = FALSE;
#line 29 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp0_ = TRUE;
#line 29 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			while (TRUE) {
#line 282 "sudoku-generator.c"
				gint _tmp2_ = 0;
				FILE* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				FILE* _tmp25_ = NULL;
#line 29 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				if (!_tmp0_) {
#line 289 "sudoku-generator.c"
					gint _tmp1_ = 0;
#line 29 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp1_ = i;
#line 29 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					i = _tmp1_ + 1;
#line 295 "sudoku-generator.c"
				}
#line 29 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp0_ = FALSE;
#line 29 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp2_ = i;
#line 29 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				if (!(_tmp2_ < 77)) {
#line 29 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					break;
#line 305 "sudoku-generator.c"
				}
#line 31 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp3_ = stdout;
#line 31 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp4_ = i;
#line 31 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				fprintf (_tmp3_, "%d, ", _tmp4_);
#line 313 "sudoku-generator.c"
				{
					gint repeat = 0;
#line 32 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					repeat = 0;
#line 318 "sudoku-generator.c"
					{
						gboolean _tmp5_ = FALSE;
#line 32 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp5_ = TRUE;
#line 32 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						while (TRUE) {
#line 325 "sudoku-generator.c"
							gint _tmp7_ = 0;
							FILE* _tmp8_ = NULL;
							gint _tmp9_ = 0;
							SudokuGenerator* gen = NULL;
							SudokuGenerator* _tmp10_ = NULL;
							SudokuGenerator* _tmp11_ = NULL;
							gint _tmp12_ = 0;
							SudokuGeneratorRatedSudoku* rated_sudoku = NULL;
							SudokuGenerator* _tmp13_ = NULL;
							gint32 _tmp14_ = 0;
							SudokuGeneratorRatedSudoku* _tmp15_ = NULL;
							FILE* _tmp21_ = NULL;
							SudokuGeneratorRatedSudoku* _tmp22_ = NULL;
							DifficultyRating* _tmp23_ = NULL;
							gfloat _tmp24_ = 0.0F;
#line 32 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							if (!_tmp5_) {
#line 343 "sudoku-generator.c"
								gint _tmp6_ = 0;
#line 32 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp6_ = repeat;
#line 32 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								repeat = _tmp6_ + 1;
#line 349 "sudoku-generator.c"
							}
#line 32 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp5_ = FALSE;
#line 32 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp7_ = repeat;
#line 32 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							if (!(_tmp7_ < 50)) {
#line 32 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								break;
#line 359 "sudoku-generator.c"
							}
#line 34 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp8_ = stdout;
#line 34 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp9_ = repeat;
#line 34 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							fprintf (_tmp8_, "repeat %d\n", _tmp9_);
#line 35 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp10_ = sudoku_generator_new ();
#line 35 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							gen = _tmp10_;
#line 36 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp11_ = gen;
#line 36 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp12_ = i;
#line 36 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp11_->clues = _tmp12_;
#line 39 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp13_ = gen;
#line 39 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp14_ = g_random_int_range ((gint32) 0, (gint32) 4);
#line 39 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp15_ = sudoku_generator_make_unique_puzzle (_tmp13_, (gint) _tmp14_, TRUE);
#line 39 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							rated_sudoku = _tmp15_;
#line 40 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							while (TRUE) {
#line 387 "sudoku-generator.c"
								SudokuGeneratorRatedSudoku* _tmp16_ = NULL;
#line 41 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp16_ = rated_sudoku;
#line 41 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								if (_tmp16_ == NULL) {
#line 393 "sudoku-generator.c"
									SudokuGenerator* _tmp17_ = NULL;
									gint32 _tmp18_ = 0;
									SudokuGeneratorRatedSudoku* _tmp19_ = NULL;
									SudokuGeneratorRatedSudoku* _tmp20_ = NULL;
#line 42 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
									_tmp17_ = gen;
#line 42 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
									_tmp18_ = g_random_int_range ((gint32) 0, (gint32) 4);
#line 42 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
									_tmp19_ = sudoku_generator_make_unique_puzzle (_tmp17_, (gint) _tmp18_, TRUE);
#line 42 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
									_tmp20_ = _tmp19_;
#line 42 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
									_sudoku_generator_rated_sudoku_free0 (_tmp20_);
#line 408 "sudoku-generator.c"
								} else {
#line 44 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
									break;
#line 412 "sudoku-generator.c"
								}
							}
#line 57 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp21_ = stdout;
#line 57 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp22_ = rated_sudoku;
#line 57 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp23_ = (*_tmp22_).diff;
#line 57 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp24_ = _tmp23_->rating;
#line 57 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							fprintf (_tmp21_, "%f, ", (gdouble) _tmp24_);
#line 32 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_sudoku_generator_rated_sudoku_free0 (rated_sudoku);
#line 32 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_g_object_unref0 (gen);
#line 429 "sudoku-generator.c"
						}
					}
				}
#line 59 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp25_ = stdout;
#line 59 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				fprintf (_tmp25_, "\n");
#line 437 "sudoku-generator.c"
			}
		}
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 92 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	return self ? g_object_ref (self) : NULL;
#line 447 "sudoku-generator.c"
}


SudokuBoard* sudoku_generator_generate (SudokuGenerator* self, gfloat* difficulty_range, int difficulty_range_length1, gboolean symmetric) {
	SudokuBoard* result = NULL;
	gint count = 0;
	FILE* _tmp32_ = NULL;
	SudokuBoard* _tmp33_ = NULL;
#line 63 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 65 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	count = 0;
#line 460 "sudoku-generator.c"
	{
		gboolean _tmp0_ = FALSE;
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp0_ = TRUE;
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		while (TRUE) {
#line 467 "sudoku-generator.c"
			gfloat skew = 0.0F;
			gfloat* _tmp2_ = NULL;
			gint _tmp2__length1 = 0;
			gfloat _tmp3_ = 0.0F;
			gfloat* _tmp4_ = NULL;
			gint _tmp4__length1 = 0;
			gfloat _tmp5_ = 0.0F;
			gdouble _tmp6_ = 0.0;
			gint _tmp7_ = 0;
			gint _tmp8_ = 0;
			gint _tmp9_ = 0;
			gboolean _tmp10_ = FALSE;
			gint _tmp11_ = 0;
			SudokuBoard* puzzle = NULL;
			gboolean _tmp13_ = FALSE;
			gint _tmp31_ = 0;
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			if (!_tmp0_) {
#line 486 "sudoku-generator.c"
				gint _tmp1_ = 0;
#line 98 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp1_ = count;
#line 98 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				if (!(_tmp1_ < 100)) {
#line 98 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					break;
#line 494 "sudoku-generator.c"
				}
			}
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp0_ = FALSE;
#line 68 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			skew = 0.0f;
#line 70 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp2_ = difficulty_range;
#line 70 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp2__length1 = difficulty_range_length1;
#line 70 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp3_ = _tmp2_[0];
#line 70 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp4_ = difficulty_range;
#line 70 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp4__length1 = difficulty_range_length1;
#line 70 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp5_ = _tmp4_[1];
#line 70 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp6_ = g_random_double_range ((gdouble) _tmp3_, (gdouble) _tmp5_);
#line 70 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp7_ = sudoku_generator_get_cells_for (self, (gfloat) _tmp6_);
#line 70 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			self->clues = _tmp7_;
#line 72 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp8_ = self->clues;
#line 72 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			if (_tmp8_ < 17) {
#line 73 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				self->clues = 17;
#line 525 "sudoku-generator.c"
			}
#line 75 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp9_ = self->clues;
#line 75 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			if (_tmp9_ > 60) {
#line 76 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				self->clues = 60;
#line 533 "sudoku-generator.c"
			}
#line 78 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp11_ = count;
#line 78 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			if (_tmp11_ >= 10) {
#line 539 "sudoku-generator.c"
				gint _tmp12_ = 0;
#line 78 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp12_ = count;
#line 78 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp10_ = (_tmp12_ % 10) == 0;
#line 545 "sudoku-generator.c"
			} else {
#line 78 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp10_ = FALSE;
#line 549 "sudoku-generator.c"
			}
#line 78 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			if (_tmp10_) {
#line 553 "sudoku-generator.c"
				gint solution = 0;
#line 80 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				solution = 0;
#line 81 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				sudoku_generator_generate_start_board (self, -1, -1, -1, -1, &solution);
#line 559 "sudoku-generator.c"
			}
#line 88 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp13_ = symmetric;
#line 88 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			if (_tmp13_) {
#line 565 "sudoku-generator.c"
				SudokuGeneratorRatedSudoku rated_sudoku = {0};
				gint32 _tmp14_ = 0;
				SudokuGeneratorRatedSudoku* _tmp15_ = NULL;
				SudokuGeneratorRatedSudoku* _tmp16_ = NULL;
				SudokuGeneratorRatedSudoku _tmp17_ = {0};
				SudokuGeneratorRatedSudoku _tmp18_ = {0};
				gboolean _tmp19_ = FALSE;
				SudokuGeneratorRatedSudoku _tmp20_ = {0};
				SudokuBoard* _tmp21_ = NULL;
#line 89 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp14_ = g_random_int_range ((gint32) 0, (gint32) 3);
#line 89 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp15_ = sudoku_generator_make_unique_puzzle (self, (gint) _tmp14_, FALSE);
#line 89 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp16_ = _tmp15_;
#line 89 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				sudoku_generator_rated_sudoku_copy (_tmp16_, &_tmp17_);
#line 89 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp18_ = _tmp17_;
#line 89 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_sudoku_generator_rated_sudoku_free0 (_tmp16_);
#line 89 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				rated_sudoku = _tmp18_;
#line 91 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp20_ = rated_sudoku;
#line 91 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp21_ = _tmp20_.board;
#line 91 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				if (_tmp21_ != NULL) {
#line 595 "sudoku-generator.c"
					SudokuGeneratorRatedSudoku _tmp22_ = {0};
					DifficultyRating* _tmp23_ = NULL;
					gfloat* _tmp24_ = NULL;
					gint _tmp24__length1 = 0;
					gboolean _tmp25_ = FALSE;
#line 91 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp22_ = rated_sudoku;
#line 91 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp23_ = _tmp22_.diff;
#line 91 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp24_ = difficulty_range;
#line 91 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp24__length1 = difficulty_range_length1;
#line 91 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp25_ = difficulty_rating_in_range (_tmp23_, _tmp24_, _tmp24__length1);
#line 91 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp19_ = _tmp25_;
#line 613 "sudoku-generator.c"
				} else {
#line 91 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp19_ = FALSE;
#line 617 "sudoku-generator.c"
				}
#line 91 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				if (_tmp19_) {
#line 621 "sudoku-generator.c"
					SudokuGeneratorRatedSudoku _tmp26_ = {0};
					SudokuBoard* _tmp27_ = NULL;
					SudokuBoard* _tmp28_ = NULL;
#line 92 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp26_ = rated_sudoku;
#line 92 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp27_ = _tmp26_.board;
#line 92 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp28_ = _g_object_ref0 (_tmp27_);
#line 92 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					result = _tmp28_;
#line 92 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					sudoku_generator_rated_sudoku_destroy (&rated_sudoku);
#line 92 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_g_object_unref0 (puzzle);
#line 92 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					return result;
#line 639 "sudoku-generator.c"
				}
#line 88 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				sudoku_generator_rated_sudoku_destroy (&rated_sudoku);
#line 643 "sudoku-generator.c"
			} else {
				gfloat _tmp29_ = 0.0F;
				SudokuBoard* _tmp30_ = NULL;
#line 94 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp29_ = skew;
#line 94 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp30_ = sudoku_generator_make_puzzle_by_boxes (self, _tmp29_);
#line 94 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_g_object_unref0 (puzzle);
#line 94 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				puzzle = _tmp30_;
#line 655 "sudoku-generator.c"
			}
#line 97 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp31_ = count;
#line 97 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			count = _tmp31_ + 1;
#line 67 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_g_object_unref0 (puzzle);
#line 663 "sudoku-generator.c"
		}
	}
#line 100 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp32_ = stdout;
#line 100 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	fprintf (_tmp32_, "Puzzle not found..\n");
#line 102 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp33_ = sudoku_board_new (3, 3);
#line 102 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	result = _tmp33_;
#line 102 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 676 "sudoku-generator.c"
}


static gint sudoku_generator_get_cells_for (SudokuGenerator* self, gfloat difficulty) {
	gint result = 0;
	gfloat _tmp0_ = 0.0F;
#line 105 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 107 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = difficulty;
#line 107 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	result = (gint) (((-22.3275863216) * _tmp0_) + 44.9652207631);
#line 107 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 691 "sudoku-generator.c"
}


static void sudoku_generator_generate_start_board (SudokuGenerator* self, gint row, gint col, gint no, gint filled, gint* solution) {
	gint _tmp0_ = 0;
	gint _tmp4_ = 0;
	SudokuBoard* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	SudokuBoard* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gboolean _tmp25_ = FALSE;
	gint _tmp26_ = 0;
	gint _tmp48_ = 0;
	SudokuBoard* _tmp76_ = NULL;
	gint _tmp77_ = 0;
	gint _tmp78_ = 0;
	gint _tmp79_ = 0;
	gint _tmp80_ = 0;
	SudokuBoard* _tmp81_ = NULL;
	gint _tmp82_ = 0;
	gint _tmp83_ = 0;
#line 110 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	g_return_if_fail (self != NULL);
#line 112 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = filled;
#line 112 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	if (_tmp0_ == (-1)) {
#line 721 "sudoku-generator.c"
		SudokuBoard* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
#line 113 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp1_ = self->priv->temp_start_board;
#line 113 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp2_ = sudoku_board_get_filled (_tmp1_);
#line 113 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp3_ = _tmp2_;
#line 113 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		filled = _tmp3_;
#line 733 "sudoku-generator.c"
	}
#line 115 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp4_ = filled;
#line 115 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp5_ = self->priv->temp_start_board;
#line 115 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp6_ = sudoku_board_get_rows (_tmp5_);
#line 115 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp7_ = _tmp6_;
#line 115 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp8_ = self->priv->temp_start_board;
#line 115 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp9_ = sudoku_board_get_cols (_tmp8_);
#line 115 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp10_ = _tmp9_;
#line 115 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	if (_tmp4_ == (_tmp7_ * _tmp10_)) {
#line 751 "sudoku-generator.c"
		gint _tmp11_ = 0;
#line 117 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp11_ = *solution;
#line 117 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		*solution = _tmp11_ + 1;
#line 757 "sudoku-generator.c"
		{
			gint y = 0;
#line 118 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			y = 0;
#line 762 "sudoku-generator.c"
			{
				gboolean _tmp12_ = FALSE;
#line 118 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp12_ = TRUE;
#line 118 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				while (TRUE) {
#line 769 "sudoku-generator.c"
					gint _tmp14_ = 0;
#line 118 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					if (!_tmp12_) {
#line 773 "sudoku-generator.c"
						gint _tmp13_ = 0;
#line 118 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp13_ = y;
#line 118 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						y = _tmp13_ + 1;
#line 779 "sudoku-generator.c"
					}
#line 118 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp12_ = FALSE;
#line 118 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp14_ = y;
#line 118 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					if (!(_tmp14_ < 9)) {
#line 118 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						break;
#line 789 "sudoku-generator.c"
					}
					{
						gint x = 0;
#line 120 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						x = 0;
#line 795 "sudoku-generator.c"
						{
							gboolean _tmp15_ = FALSE;
#line 120 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp15_ = TRUE;
#line 120 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							while (TRUE) {
#line 802 "sudoku-generator.c"
								gint _tmp17_ = 0;
								SudokuBoard* _tmp18_ = NULL;
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								SudokuBoard* _tmp21_ = NULL;
								gint _tmp22_ = 0;
								gint _tmp23_ = 0;
								gint _tmp24_ = 0;
#line 120 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								if (!_tmp15_) {
#line 813 "sudoku-generator.c"
									gint _tmp16_ = 0;
#line 120 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
									_tmp16_ = x;
#line 120 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
									x = _tmp16_ + 1;
#line 819 "sudoku-generator.c"
								}
#line 120 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp15_ = FALSE;
#line 120 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp17_ = x;
#line 120 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								if (!(_tmp17_ < 9)) {
#line 120 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
									break;
#line 829 "sudoku-generator.c"
								}
#line 122 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp18_ = self->start_board;
#line 122 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp19_ = x;
#line 122 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp20_ = y;
#line 122 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp21_ = self->priv->temp_start_board;
#line 122 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp22_ = x;
#line 122 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp23_ = y;
#line 122 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp24_ = sudoku_board_get (_tmp21_, _tmp22_, _tmp23_);
#line 122 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								sudoku_board_insert (_tmp18_, _tmp19_, _tmp20_, _tmp24_, FALSE);
#line 847 "sudoku-generator.c"
							}
						}
					}
				}
			}
		}
#line 125 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		return;
#line 856 "sudoku-generator.c"
	}
#line 128 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp26_ = row;
#line 128 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	if (_tmp26_ == (-1)) {
#line 128 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp25_ = TRUE;
#line 864 "sudoku-generator.c"
	} else {
		gint _tmp27_ = 0;
#line 128 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp27_ = col;
#line 128 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp25_ = _tmp27_ == (-1);
#line 871 "sudoku-generator.c"
	}
#line 128 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	if (_tmp25_) {
#line 875 "sudoku-generator.c"
		{
			gint l1 = 0;
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			l1 = 0;
#line 880 "sudoku-generator.c"
			{
				gboolean _tmp28_ = FALSE;
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp28_ = TRUE;
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				while (TRUE) {
#line 887 "sudoku-generator.c"
					gint _tmp30_ = 0;
					SudokuBoard* _tmp31_ = NULL;
					gint _tmp32_ = 0;
					gint _tmp33_ = 0;
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					if (!_tmp28_) {
#line 894 "sudoku-generator.c"
						gint _tmp29_ = 0;
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp29_ = l1;
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						l1 = _tmp29_ + 1;
#line 900 "sudoku-generator.c"
					}
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp28_ = FALSE;
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp30_ = l1;
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp31_ = self->priv->temp_start_board;
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp32_ = sudoku_board_get_rows (_tmp31_);
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp33_ = _tmp32_;
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					if (!(_tmp30_ < _tmp33_)) {
#line 130 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						break;
#line 916 "sudoku-generator.c"
					}
					{
						gint l2 = 0;
#line 132 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						l2 = 0;
#line 922 "sudoku-generator.c"
						{
							gboolean _tmp34_ = FALSE;
#line 132 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							_tmp34_ = TRUE;
#line 132 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							while (TRUE) {
#line 929 "sudoku-generator.c"
								gint _tmp36_ = 0;
								SudokuBoard* _tmp37_ = NULL;
								gint _tmp38_ = 0;
								gint _tmp39_ = 0;
								SudokuBoard* _tmp40_ = NULL;
								gint _tmp41_ = 0;
								gint _tmp42_ = 0;
								gint _tmp43_ = 0;
#line 132 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								if (!_tmp34_) {
#line 940 "sudoku-generator.c"
									gint _tmp35_ = 0;
#line 132 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
									_tmp35_ = l2;
#line 132 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
									l2 = _tmp35_ + 1;
#line 946 "sudoku-generator.c"
								}
#line 132 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp34_ = FALSE;
#line 132 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp36_ = l2;
#line 132 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp37_ = self->priv->temp_start_board;
#line 132 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp38_ = sudoku_board_get_cols (_tmp37_);
#line 132 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp39_ = _tmp38_;
#line 132 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								if (!(_tmp36_ < _tmp39_)) {
#line 132 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
									break;
#line 962 "sudoku-generator.c"
								}
#line 134 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp40_ = self->priv->temp_start_board;
#line 134 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp41_ = l1;
#line 134 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp42_ = l2;
#line 134 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								_tmp43_ = sudoku_board_get (_tmp40_, _tmp41_, _tmp42_);
#line 134 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
								if (_tmp43_ == 0) {
#line 974 "sudoku-generator.c"
									gint _tmp44_ = 0;
									gint _tmp45_ = 0;
									gint _tmp46_ = 0;
									gint _tmp47_ = 0;
#line 136 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
									_tmp44_ = l1;
#line 136 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
									_tmp45_ = l2;
#line 136 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
									_tmp46_ = no;
#line 136 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
									_tmp47_ = filled;
#line 136 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
									sudoku_generator_generate_start_board (self, _tmp44_, _tmp45_, _tmp46_, _tmp47_, solution);
#line 137 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
									return;
#line 991 "sudoku-generator.c"
								}
							}
						}
					}
				}
			}
		}
	}
#line 143 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp48_ = no;
#line 143 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	if (_tmp48_ == (-1)) {
#line 1004 "sudoku-generator.c"
		gboolean* values_tried = NULL;
		SudokuBoard* _tmp49_ = NULL;
		gint _tmp50_ = 0;
		gint _tmp51_ = 0;
		gboolean* _tmp52_ = NULL;
		gint values_tried_length1 = 0;
		gint _values_tried_size_ = 0;
		gint values_tried_count = 0;
#line 145 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp49_ = self->priv->temp_start_board;
#line 145 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp50_ = sudoku_board_get_max_val (_tmp49_);
#line 145 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp51_ = _tmp50_;
#line 145 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp52_ = g_new0 (gboolean, _tmp51_);
#line 145 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		values_tried = _tmp52_;
#line 145 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		values_tried_length1 = _tmp51_;
#line 145 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_values_tried_size_ = values_tried_length1;
#line 146 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		values_tried_count = 0;
#line 147 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		while (TRUE) {
#line 1031 "sudoku-generator.c"
			gint _tmp53_ = 0;
			SudokuBoard* _tmp54_ = NULL;
			gint _tmp55_ = 0;
			gint _tmp56_ = 0;
			gint l1 = 0;
			gint _tmp65_ = 0;
			SudokuBoard* _tmp66_ = NULL;
			gint _tmp67_ = 0;
			gint _tmp68_ = 0;
			gint _tmp69_ = 0;
			gboolean _tmp70_ = FALSE;
#line 147 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp53_ = values_tried_count;
#line 147 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp54_ = self->priv->temp_start_board;
#line 147 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp55_ = sudoku_board_get_max_val (_tmp54_);
#line 147 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp56_ = _tmp55_;
#line 147 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			if (!(_tmp53_ < _tmp56_)) {
#line 147 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				break;
#line 1055 "sudoku-generator.c"
			}
#line 150 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			l1 = -1;
#line 1059 "sudoku-generator.c"
			{
				gboolean _tmp57_ = FALSE;
#line 151 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp57_ = TRUE;
#line 151 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				while (TRUE) {
#line 1066 "sudoku-generator.c"
					SudokuBoard* _tmp61_ = NULL;
					gint _tmp62_ = 0;
					gint _tmp63_ = 0;
					gint32 _tmp64_ = 0;
#line 151 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					if (!_tmp57_) {
#line 1073 "sudoku-generator.c"
						gboolean* _tmp58_ = NULL;
						gint _tmp58__length1 = 0;
						gint _tmp59_ = 0;
						gboolean _tmp60_ = FALSE;
#line 153 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp58_ = values_tried;
#line 153 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp58__length1 = values_tried_length1;
#line 153 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp59_ = l1;
#line 153 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp60_ = _tmp58_[_tmp59_];
#line 153 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						if (!_tmp60_) {
#line 153 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							break;
#line 1090 "sudoku-generator.c"
						}
					}
#line 151 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp57_ = FALSE;
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp61_ = self->priv->temp_start_board;
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp62_ = sudoku_board_get_max_val (_tmp61_);
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp63_ = _tmp62_;
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp64_ = g_random_int_range ((gint32) 0, (gint32) _tmp63_);
#line 152 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					l1 = (gint) (_tmp64_ + 1);
#line 1105 "sudoku-generator.c"
				}
			}
#line 155 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp65_ = values_tried_count;
#line 155 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			values_tried_count = _tmp65_ + 1;
#line 157 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp66_ = self->priv->temp_start_board;
#line 157 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp67_ = row;
#line 157 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp68_ = col;
#line 157 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp69_ = l1;
#line 157 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp70_ = sudoku_board_is_possible (_tmp66_, _tmp67_, _tmp68_, _tmp69_);
#line 157 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			if (_tmp70_) {
#line 1124 "sudoku-generator.c"
				gint _tmp71_ = 0;
				gint _tmp72_ = 0;
				gint _tmp73_ = 0;
				gint _tmp74_ = 0;
				gint _tmp75_ = 0;
#line 159 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp71_ = row;
#line 159 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp72_ = col;
#line 159 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp73_ = l1;
#line 159 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp74_ = filled;
#line 159 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				sudoku_generator_generate_start_board (self, _tmp71_, _tmp72_, _tmp73_, _tmp74_, solution);
#line 161 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp75_ = *solution;
#line 161 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				if (_tmp75_ > 0) {
#line 162 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					values_tried = (g_free (values_tried), NULL);
#line 162 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					return;
#line 1148 "sudoku-generator.c"
				}
			}
		}
#line 165 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		values_tried = (g_free (values_tried), NULL);
#line 165 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		return;
#line 1156 "sudoku-generator.c"
	}
#line 168 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp76_ = self->priv->temp_start_board;
#line 168 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp77_ = row;
#line 168 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp78_ = col;
#line 168 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp79_ = no;
#line 168 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	sudoku_board_insert (_tmp76_, _tmp77_, _tmp78_, _tmp79_, FALSE);
#line 169 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp80_ = filled;
#line 169 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	sudoku_generator_generate_start_board (self, -1, -1, -1, _tmp80_ + 1, solution);
#line 170 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp81_ = self->priv->temp_start_board;
#line 170 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp82_ = row;
#line 170 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp83_ = col;
#line 170 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	sudoku_board_remove (_tmp81_, _tmp82_, _tmp83_, FALSE);
#line 1180 "sudoku-generator.c"
}


SudokuBoard* sudoku_generator_make_symmetric_puzzle (SudokuGenerator* self, gint line) {
	SudokuBoard* result = NULL;
	SudokuBoard* new_puzzle = NULL;
	SudokuBoard* _tmp0_ = NULL;
#line 173 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 175 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = sudoku_board_new (3, 3);
#line 175 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	new_puzzle = _tmp0_;
#line 177 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	while (TRUE) {
#line 1196 "sudoku-generator.c"
		SudokuBoard* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint row = 0;
		gint32 _tmp5_ = 0;
		gint col = 0;
		gint32 _tmp6_ = 0;
		SudokuBoard* _tmp7_ = NULL;
		gboolean* _tmp8_ = NULL;
		gint _tmp8__length1 = 0;
		gint _tmp8__length2 = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gboolean _tmp11_ = FALSE;
#line 177 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp1_ = new_puzzle;
#line 177 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp2_ = sudoku_board_get_filled (_tmp1_);
#line 177 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp3_ = _tmp2_;
#line 177 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp4_ = self->clues;
#line 177 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		if (!(_tmp3_ < _tmp4_)) {
#line 177 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			break;
#line 1224 "sudoku-generator.c"
		}
#line 178 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp5_ = g_random_int_range ((gint32) 0, (gint32) 9);
#line 178 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		row = (gint) _tmp5_;
#line 179 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp6_ = g_random_int_range ((gint32) 0, (gint32) 9);
#line 179 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		col = (gint) _tmp6_;
#line 181 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp7_ = new_puzzle;
#line 181 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp8_ = _tmp7_->is_fixed;
#line 181 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp8__length1 = _tmp7_->is_fixed_length1;
#line 181 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp8__length2 = _tmp7_->is_fixed_length2;
#line 181 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp9_ = row;
#line 181 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp10_ = col;
#line 181 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp11_ = _tmp8_[(_tmp9_ * _tmp8__length2) + _tmp10_];
#line 181 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		if (!_tmp11_) {
#line 1250 "sudoku-generator.c"
			Coord reflection = {0};
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			Coord _tmp15_ = {0};
			SudokuBoard* _tmp16_ = NULL;
			gint _tmp17_ = 0;
			gint _tmp18_ = 0;
			SudokuBoard* _tmp19_ = NULL;
			gint _tmp20_ = 0;
			gint _tmp21_ = 0;
			gint _tmp22_ = 0;
			gboolean _tmp23_ = FALSE;
			Coord _tmp24_ = {0};
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			SudokuBoard* _tmp30_ = NULL;
			Coord _tmp31_ = {0};
			gint _tmp32_ = 0;
			Coord _tmp33_ = {0};
			gint _tmp34_ = 0;
			SudokuBoard* _tmp35_ = NULL;
			Coord _tmp36_ = {0};
			gint _tmp37_ = 0;
			Coord _tmp38_ = {0};
			gint _tmp39_ = 0;
			gint _tmp40_ = 0;
#line 183 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp12_ = row;
#line 183 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp13_ = col;
#line 183 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp14_ = line;
#line 183 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			sudoku_generator_reflect (self, _tmp12_, _tmp13_, _tmp14_, &_tmp15_);
#line 183 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			reflection = _tmp15_;
#line 185 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp16_ = new_puzzle;
#line 185 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp17_ = row;
#line 185 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp18_ = col;
#line 185 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp19_ = self->start_board;
#line 185 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp20_ = row;
#line 185 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp21_ = col;
#line 185 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp22_ = sudoku_board_get (_tmp19_, _tmp20_, _tmp21_);
#line 185 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			sudoku_board_insert (_tmp16_, _tmp17_, _tmp18_, _tmp22_, TRUE);
#line 187 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp24_ = reflection;
#line 187 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp25_ = _tmp24_.row;
#line 187 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp26_ = row;
#line 187 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			if (_tmp25_ == _tmp26_) {
#line 1312 "sudoku-generator.c"
				Coord _tmp27_ = {0};
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
#line 187 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp27_ = reflection;
#line 187 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp28_ = _tmp27_.col;
#line 187 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp29_ = col;
#line 187 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp23_ = _tmp28_ == _tmp29_;
#line 1324 "sudoku-generator.c"
			} else {
#line 187 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp23_ = FALSE;
#line 1328 "sudoku-generator.c"
			}
#line 187 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			if (_tmp23_) {
#line 188 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				continue;
#line 1334 "sudoku-generator.c"
			}
#line 190 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp30_ = new_puzzle;
#line 190 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp31_ = reflection;
#line 190 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp32_ = _tmp31_.row;
#line 190 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp33_ = reflection;
#line 190 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp34_ = _tmp33_.col;
#line 190 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp35_ = self->start_board;
#line 190 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp36_ = reflection;
#line 190 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp37_ = _tmp36_.row;
#line 190 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp38_ = reflection;
#line 190 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp39_ = _tmp38_.col;
#line 190 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp40_ = sudoku_board_get (_tmp35_, _tmp37_, _tmp39_);
#line 190 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			sudoku_board_insert (_tmp30_, _tmp32_, _tmp34_, _tmp40_, TRUE);
#line 1360 "sudoku-generator.c"
		}
	}
#line 194 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	result = new_puzzle;
#line 194 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 1367 "sudoku-generator.c"
}


static void sudoku_generator_reflect (SudokuGenerator* self, gint row, gint col, gint line, Coord* result) {
	gint _tmp0_ = 0;
#line 197 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	g_return_if_fail (self != NULL);
#line 199 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = line;
#line 199 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	if (_tmp0_ == 0) {
#line 1379 "sudoku-generator.c"
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		Coord _tmp3_ = {0};
#line 201 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp1_ = row;
#line 201 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp2_ = col;
#line 201 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		coord_init (&_tmp3_, _tmp1_, 8 - _tmp2_);
#line 201 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		*result = _tmp3_;
#line 201 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		return;
#line 1393 "sudoku-generator.c"
	} else {
		gint _tmp4_ = 0;
#line 203 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp4_ = line;
#line 203 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		if (_tmp4_ == 1) {
#line 1400 "sudoku-generator.c"
			gint _tmp5_ = 0;
			gint _tmp6_ = 0;
			Coord _tmp7_ = {0};
#line 205 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp5_ = col;
#line 205 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp6_ = row;
#line 205 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			coord_init (&_tmp7_, 8 - _tmp5_, 8 - _tmp6_);
#line 205 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			*result = _tmp7_;
#line 205 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			return;
#line 1414 "sudoku-generator.c"
		} else {
			gint _tmp8_ = 0;
#line 207 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp8_ = line;
#line 207 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			if (_tmp8_ == 2) {
#line 1421 "sudoku-generator.c"
				gint _tmp9_ = 0;
				gint _tmp10_ = 0;
				Coord _tmp11_ = {0};
#line 209 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp9_ = row;
#line 209 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp10_ = col;
#line 209 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				coord_init (&_tmp11_, 8 - _tmp9_, _tmp10_);
#line 209 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				*result = _tmp11_;
#line 209 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				return;
#line 1435 "sudoku-generator.c"
			} else {
				gint _tmp12_ = 0;
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp12_ = line;
#line 211 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				if (_tmp12_ == 3) {
#line 1442 "sudoku-generator.c"
					gint _tmp13_ = 0;
					gint _tmp14_ = 0;
					Coord _tmp15_ = {0};
#line 213 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp13_ = row;
#line 213 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp14_ = col;
#line 213 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					coord_init (&_tmp15_, 8 - _tmp13_, 8 - _tmp14_);
#line 213 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					*result = _tmp15_;
#line 213 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					return;
#line 1456 "sudoku-generator.c"
				} else {
					gint _tmp16_ = 0;
					gint _tmp17_ = 0;
					Coord _tmp18_ = {0};
#line 217 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp16_ = row;
#line 217 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp17_ = col;
#line 217 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					coord_init (&_tmp18_, _tmp16_, _tmp17_);
#line 217 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					*result = _tmp18_;
#line 217 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					return;
#line 1471 "sudoku-generator.c"
				}
			}
		}
	}
}


SudokuBoard* sudoku_generator_make_puzzle_by_boxes (SudokuGenerator* self, gfloat skew_by) {
	SudokuBoard* result = NULL;
	SudokuBoard* new_puzzle = NULL;
	SudokuBoard* _tmp0_ = NULL;
	gint nboxes = 0;
	gint max_squares = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gfloat _tmp6_ = 0.0F;
	gint clued = 0;
	gint* nclues = NULL;
	gint _tmp7_ = 0;
	gint* _tmp8_ = NULL;
	gint nclues_length1 = 0;
	gint _nclues_size_ = 0;
#line 236 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 237 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = sudoku_board_new (3, 3);
#line 237 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	new_puzzle = _tmp0_;
#line 240 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	nboxes = 9;
#line 245 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp1_ = self->clues;
#line 245 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp2_ = nboxes;
#line 245 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	max_squares = _tmp1_ / _tmp2_;
#line 246 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp3_ = max_squares;
#line 246 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp4_ = nboxes;
#line 246 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp5_ = max_squares;
#line 246 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp6_ = skew_by;
#line 246 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	max_squares = _tmp3_ + ((gint) ((_tmp4_ - _tmp5_) * _tmp6_));
#line 247 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	clued = 0;
#line 256 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp7_ = nboxes;
#line 256 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp8_ = g_new0 (gint, _tmp7_);
#line 256 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	nclues = _tmp8_;
#line 256 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	nclues_length1 = _tmp7_;
#line 256 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_nclues_size_ = nclues_length1;
#line 1533 "sudoku-generator.c"
	{
		gint n = 0;
#line 257 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		n = 0;
#line 1538 "sudoku-generator.c"
		{
			gboolean _tmp9_ = FALSE;
#line 257 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp9_ = TRUE;
#line 257 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			while (TRUE) {
#line 1545 "sudoku-generator.c"
				gint _tmp11_ = 0;
				gint _tmp12_ = 0;
				gint clues = 0;
				gint _tmp13_ = 0;
				gint _tmp14_ = 0;
				gint _tmp15_ = 0;
				gint _tmp16_ = 0;
				gint* _tmp19_ = NULL;
				gint _tmp19__length1 = 0;
				gint _tmp20_ = 0;
				gint _tmp21_ = 0;
				gint _tmp22_ = 0;
				gint _tmp23_ = 0;
				gint _tmp24_ = 0;
				gfloat _tmp25_ = 0.0F;
#line 257 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				if (!_tmp9_) {
#line 1563 "sudoku-generator.c"
					gint _tmp10_ = 0;
#line 257 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp10_ = n;
#line 257 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					n = _tmp10_ + 1;
#line 1569 "sudoku-generator.c"
				}
#line 257 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp9_ = FALSE;
#line 257 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp11_ = n;
#line 257 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp12_ = nboxes;
#line 257 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				if (!(_tmp11_ < _tmp12_)) {
#line 257 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					break;
#line 1581 "sudoku-generator.c"
				}
#line 268 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp13_ = max_squares;
#line 268 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				clues = _tmp13_;
#line 269 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp14_ = clues;
#line 269 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp15_ = self->clues;
#line 269 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp16_ = clued;
#line 269 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				if (_tmp14_ > (_tmp15_ - _tmp16_)) {
#line 1595 "sudoku-generator.c"
					gint _tmp17_ = 0;
					gint _tmp18_ = 0;
#line 270 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp17_ = self->clues;
#line 270 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp18_ = clued;
#line 270 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					clues = _tmp17_ - _tmp18_;
#line 1604 "sudoku-generator.c"
				}
#line 272 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp19_ = nclues;
#line 272 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp19__length1 = nclues_length1;
#line 272 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp20_ = n;
#line 272 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp21_ = clues;
#line 272 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp19_[_tmp20_] = _tmp21_;
#line 272 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp22_ = _tmp19_[_tmp20_];
#line 274 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp23_ = clued;
#line 274 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp24_ = clues;
#line 274 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				clued = _tmp23_ + _tmp24_;
#line 275 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp25_ = skew_by;
#line 275 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				if (_tmp25_ != ((gfloat) 0)) {
#line 1628 "sudoku-generator.c"
					gint _tmp26_ = 0;
					gfloat _tmp27_ = 0.0F;
					gdouble _tmp28_ = 0.0;
#line 278 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp26_ = max_squares;
#line 278 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp27_ = skew_by;
#line 278 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp28_ = round ((gdouble) (_tmp26_ * _tmp27_));
#line 278 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					max_squares = (gint) _tmp28_;
#line 1640 "sudoku-generator.c"
				}
			}
		}
	}
	{
		gint i = 0;
#line 283 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		i = 0;
#line 1649 "sudoku-generator.c"
		{
			gboolean _tmp29_ = FALSE;
#line 283 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp29_ = TRUE;
#line 283 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			while (TRUE) {
#line 1656 "sudoku-generator.c"
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
				gint from = 0;
				gint _tmp33_ = 0;
				gint32 _tmp34_ = 0;
				gint to = 0;
				gint _tmp35_ = 0;
				gint32 _tmp36_ = 0;
				gint temp = 0;
				gint* _tmp37_ = NULL;
				gint _tmp37__length1 = 0;
				gint _tmp38_ = 0;
				gint _tmp39_ = 0;
				gint* _tmp40_ = NULL;
				gint _tmp40__length1 = 0;
				gint _tmp41_ = 0;
				gint* _tmp42_ = NULL;
				gint _tmp42__length1 = 0;
				gint _tmp43_ = 0;
				gint _tmp44_ = 0;
				gint _tmp45_ = 0;
				gint* _tmp46_ = NULL;
				gint _tmp46__length1 = 0;
				gint _tmp47_ = 0;
				gint _tmp48_ = 0;
				gint _tmp49_ = 0;
#line 283 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				if (!_tmp29_) {
#line 1685 "sudoku-generator.c"
					gint _tmp30_ = 0;
#line 283 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp30_ = i;
#line 283 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					i = _tmp30_ + 1;
#line 1691 "sudoku-generator.c"
				}
#line 283 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp29_ = FALSE;
#line 283 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp31_ = i;
#line 283 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp32_ = nboxes;
#line 283 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				if (!(_tmp31_ < _tmp32_)) {
#line 283 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					break;
#line 1703 "sudoku-generator.c"
				}
#line 284 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp33_ = nboxes;
#line 284 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp34_ = g_random_int_range ((gint32) 0, (gint32) _tmp33_);
#line 284 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				from = (gint) _tmp34_;
#line 285 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp35_ = nboxes;
#line 285 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp36_ = g_random_int_range ((gint32) 0, (gint32) _tmp35_);
#line 285 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				to = (gint) _tmp36_;
#line 287 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp37_ = nclues;
#line 287 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp37__length1 = nclues_length1;
#line 287 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp38_ = to;
#line 287 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp39_ = _tmp37_[_tmp38_];
#line 287 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				temp = _tmp39_;
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp40_ = nclues;
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp40__length1 = nclues_length1;
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp41_ = to;
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp42_ = nclues;
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp42__length1 = nclues_length1;
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp43_ = from;
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp44_ = _tmp42_[_tmp43_];
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp40_[_tmp41_] = _tmp44_;
#line 288 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp45_ = _tmp40_[_tmp41_];
#line 289 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp46_ = nclues;
#line 289 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp46__length1 = nclues_length1;
#line 289 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp47_ = from;
#line 289 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp48_ = temp;
#line 289 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp46_[_tmp47_] = _tmp48_;
#line 289 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp49_ = _tmp46_[_tmp47_];
#line 1757 "sudoku-generator.c"
			}
		}
	}
	{
		gint i = 0;
#line 292 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		i = 0;
#line 1765 "sudoku-generator.c"
		{
			gboolean _tmp50_ = FALSE;
#line 292 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp50_ = TRUE;
#line 292 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			while (TRUE) {
#line 1772 "sudoku-generator.c"
				gint _tmp52_ = 0;
				gint _tmp53_ = 0;
#line 292 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				if (!_tmp50_) {
#line 1777 "sudoku-generator.c"
					gint _tmp51_ = 0;
#line 292 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp51_ = i;
#line 292 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					i = _tmp51_ + 1;
#line 1783 "sudoku-generator.c"
				}
#line 292 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp50_ = FALSE;
#line 292 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp52_ = i;
#line 292 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp53_ = nboxes;
#line 292 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				if (!(_tmp52_ < _tmp53_)) {
#line 292 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					break;
#line 1795 "sudoku-generator.c"
				}
#line 293 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				while (TRUE) {
#line 1799 "sudoku-generator.c"
					gint* _tmp54_ = NULL;
					gint _tmp54__length1 = 0;
					gint _tmp55_ = 0;
					gint _tmp56_ = 0;
					gint base_x = 0;
					gint _tmp57_ = 0;
					SudokuBoard* _tmp58_ = NULL;
					gint _tmp59_ = 0;
					gint _tmp60_ = 0;
					SudokuBoard* _tmp61_ = NULL;
					gint _tmp62_ = 0;
					gint _tmp63_ = 0;
					gint base_y = 0;
					gint _tmp64_ = 0;
					SudokuBoard* _tmp65_ = NULL;
					gint _tmp66_ = 0;
					gint _tmp67_ = 0;
					SudokuBoard* _tmp68_ = NULL;
					gint _tmp69_ = 0;
					gint _tmp70_ = 0;
					gint x = 0;
					gint _tmp71_ = 0;
					gint _tmp72_ = 0;
					SudokuBoard* _tmp73_ = NULL;
					gint _tmp74_ = 0;
					gint _tmp75_ = 0;
					gint32 _tmp76_ = 0;
					gint y = 0;
					gint _tmp77_ = 0;
					gint _tmp78_ = 0;
					SudokuBoard* _tmp79_ = NULL;
					gint _tmp80_ = 0;
					gint _tmp81_ = 0;
					gint32 _tmp82_ = 0;
					SudokuBoard* _tmp83_ = NULL;
					gboolean* _tmp84_ = NULL;
					gint _tmp84__length1 = 0;
					gint _tmp84__length2 = 0;
					gint _tmp85_ = 0;
					gint _tmp86_ = 0;
					gboolean _tmp87_ = FALSE;
#line 293 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp54_ = nclues;
#line 293 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp54__length1 = nclues_length1;
#line 293 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp55_ = i;
#line 293 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp56_ = _tmp54_[_tmp55_];
#line 293 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					if (!(_tmp56_ > 0)) {
#line 293 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						break;
#line 1853 "sudoku-generator.c"
					}
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp57_ = i;
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp58_ = new_puzzle;
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp59_ = sudoku_board_get_block_cols (_tmp58_);
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp60_ = _tmp59_;
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp61_ = new_puzzle;
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp62_ = sudoku_board_get_block_cols (_tmp61_);
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp63_ = _tmp62_;
#line 294 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					base_x = (_tmp57_ % _tmp60_) * _tmp63_;
#line 295 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp64_ = i;
#line 295 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp65_ = new_puzzle;
#line 295 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp66_ = sudoku_board_get_block_rows (_tmp65_);
#line 295 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp67_ = _tmp66_;
#line 295 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp68_ = new_puzzle;
#line 295 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp69_ = sudoku_board_get_block_rows (_tmp68_);
#line 295 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp70_ = _tmp69_;
#line 295 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					base_y = (_tmp64_ / _tmp67_) * _tmp70_;
#line 297 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp71_ = base_x;
#line 297 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp72_ = base_x;
#line 297 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp73_ = new_puzzle;
#line 297 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp74_ = sudoku_board_get_block_rows (_tmp73_);
#line 297 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp75_ = _tmp74_;
#line 297 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp76_ = g_random_int_range ((gint32) _tmp71_, (gint32) (_tmp72_ + _tmp75_));
#line 297 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					x = (gint) _tmp76_;
#line 298 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp77_ = base_y;
#line 298 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp78_ = base_y;
#line 298 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp79_ = new_puzzle;
#line 298 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp80_ = sudoku_board_get_block_cols (_tmp79_);
#line 298 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp81_ = _tmp80_;
#line 298 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp82_ = g_random_int_range ((gint32) _tmp77_, (gint32) (_tmp78_ + _tmp81_));
#line 298 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					y = (gint) _tmp82_;
#line 300 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp83_ = new_puzzle;
#line 300 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp84_ = _tmp83_->is_fixed;
#line 300 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp84__length1 = _tmp83_->is_fixed_length1;
#line 300 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp84__length2 = _tmp83_->is_fixed_length2;
#line 300 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp85_ = x;
#line 300 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp86_ = y;
#line 300 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp87_ = _tmp84_[(_tmp85_ * _tmp84__length2) + _tmp86_];
#line 300 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					if (!_tmp87_) {
#line 1931 "sudoku-generator.c"
						SudokuBoard* _tmp88_ = NULL;
						gint _tmp89_ = 0;
						gint _tmp90_ = 0;
						SudokuBoard* _tmp91_ = NULL;
						gint _tmp92_ = 0;
						gint _tmp93_ = 0;
						gint _tmp94_ = 0;
						gint* _tmp95_ = NULL;
						gint _tmp95__length1 = 0;
						gint _tmp96_ = 0;
						gint _tmp97_ = 0;
#line 301 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp88_ = new_puzzle;
#line 301 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp89_ = x;
#line 301 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp90_ = y;
#line 301 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp91_ = self->start_board;
#line 301 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp92_ = x;
#line 301 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp93_ = y;
#line 301 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp94_ = sudoku_board_get (_tmp91_, _tmp92_, _tmp93_);
#line 301 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						sudoku_board_insert (_tmp88_, _tmp89_, _tmp90_, _tmp94_, TRUE);
#line 302 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp95_ = nclues;
#line 302 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp95__length1 = nclues_length1;
#line 302 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp96_ = i;
#line 302 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp97_ = _tmp95_[_tmp96_];
#line 302 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp95_[_tmp96_] = _tmp97_ - 1;
#line 1969 "sudoku-generator.c"
					}
				}
			}
		}
	}
#line 306 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	result = new_puzzle;
#line 306 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	nclues = (g_free (nclues), NULL);
#line 306 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 1981 "sudoku-generator.c"
}


static gpointer _sudoku_generator_rated_sudoku_dup0 (gpointer self) {
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	return self ? sudoku_generator_rated_sudoku_dup (self) : NULL;
#line 1988 "sudoku-generator.c"
}


SudokuGeneratorRatedSudoku* sudoku_generator_make_unique_puzzle (SudokuGenerator* self, gint line, gboolean strict_number_of_clues) {
	SudokuGeneratorRatedSudoku* result = NULL;
	SudokuBoard* board = NULL;
	DifficultyRating* diff = NULL;
	gint _tmp0_ = 0;
	gboolean _tmp67_ = FALSE;
	SudokuBoard* _tmp105_ = NULL;
	DifficultyRating* _tmp106_ = NULL;
	SudokuGeneratorRatedSudoku _tmp107_ = {0};
	SudokuGeneratorRatedSudoku _tmp108_ = {0};
	SudokuGeneratorRatedSudoku* _tmp109_ = NULL;
	SudokuGeneratorRatedSudoku* _tmp110_ = NULL;
#line 309 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 314 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = line;
#line 314 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	if (_tmp0_ != (-1)) {
#line 2010 "sudoku-generator.c"
		gint old_clues = 0;
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		SudokuBoard* _tmp3_ = NULL;
		gint _tmp4_ = 0;
#line 316 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp1_ = self->clues;
#line 316 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		old_clues = _tmp1_;
#line 317 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		self->clues = 4;
#line 318 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp2_ = line;
#line 318 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp3_ = sudoku_generator_make_symmetric_puzzle (self, _tmp2_);
#line 318 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_g_object_unref0 (board);
#line 318 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		board = _tmp3_;
#line 319 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp4_ = old_clues;
#line 319 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		self->clues = _tmp4_;
#line 2034 "sudoku-generator.c"
	} else {
		SudokuBoard* _tmp5_ = NULL;
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp5_ = sudoku_generator_make_puzzle_by_boxes (self, 0.0f);
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_g_object_unref0 (board);
#line 324 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		board = _tmp5_;
#line 2043 "sudoku-generator.c"
	}
#line 327 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	while (TRUE) {
#line 2047 "sudoku-generator.c"
		SudokuBoard* solved_board = NULL;
		SudokuBoard* _tmp6_ = NULL;
		SudokuBoard* _tmp7_ = NULL;
		SudokuRater* solver = NULL;
		SudokuRater* _tmp8_ = NULL;
		SudokuRater* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		Guess* crumb = NULL;
		SudokuRater* _tmp20_ = NULL;
		BreadcrumbTrail* _tmp21_ = NULL;
		SudokuRater* _tmp22_ = NULL;
		BreadcrumbTrail* _tmp23_ = NULL;
		gint _tmp24_ = 0;
		gint _tmp25_ = 0;
		gpointer _tmp26_ = NULL;
		SudokuBoard* _tmp27_ = NULL;
		Guess* _tmp28_ = NULL;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		Guess* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		SudokuBoard* _tmp34_ = NULL;
		Guess* _tmp35_ = NULL;
		gint _tmp36_ = 0;
		gint _tmp37_ = 0;
		Guess* _tmp38_ = NULL;
		gint _tmp39_ = 0;
		gint _tmp40_ = 0;
		gint _tmp41_ = 0;
		Coord reflection = {0};
		Guess* _tmp42_ = NULL;
		gint _tmp43_ = 0;
		gint _tmp44_ = 0;
		Guess* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
		Coord _tmp49_ = {0};
		SudokuBoard* _tmp50_ = NULL;
		Coord _tmp51_ = {0};
		gint _tmp52_ = 0;
		Coord _tmp53_ = {0};
		gint _tmp54_ = 0;
		SudokuBoard* _tmp55_ = NULL;
		Coord _tmp56_ = {0};
		gint _tmp57_ = 0;
		Coord _tmp58_ = {0};
		gint _tmp59_ = 0;
		gint _tmp60_ = 0;
		gboolean _tmp61_ = FALSE;
		gboolean _tmp62_ = FALSE;
#line 329 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp6_ = board;
#line 329 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp7_ = sudoku_board_clone (_tmp6_);
#line 329 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		solved_board = _tmp7_;
#line 330 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp8_ = sudoku_rater_new (&solved_board);
#line 330 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		solver = _tmp8_;
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp9_ = solver;
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp10_ = sudoku_solver_has_unique_solution ((SudokuSolver*) _tmp9_);
#line 331 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		if (_tmp10_) {
#line 2116 "sudoku-generator.c"
			SudokuRater* _tmp11_ = NULL;
			DifficultyRating* _tmp12_ = NULL;
#line 334 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp11_ = solver;
#line 334 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp12_ = sudoku_rater_get_difficulty (_tmp11_);
#line 334 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_g_object_unref0 (diff);
#line 334 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			diff = _tmp12_;
#line 335 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_g_object_unref0 (solver);
#line 335 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_g_object_unref0 (solved_board);
#line 335 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			break;
#line 2133 "sudoku-generator.c"
		}
		{
			gint i = 0;
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			i = 0;
#line 2139 "sudoku-generator.c"
			{
				gboolean _tmp13_ = FALSE;
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp13_ = TRUE;
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				while (TRUE) {
#line 2146 "sudoku-generator.c"
					gint _tmp15_ = 0;
					SudokuRater* _tmp16_ = NULL;
					BreadcrumbTrail* _tmp17_ = NULL;
					gint _tmp18_ = 0;
					gint _tmp19_ = 0;
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					if (!_tmp13_) {
#line 2154 "sudoku-generator.c"
						gint _tmp14_ = 0;
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp14_ = i;
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						i = _tmp14_ + 1;
#line 2160 "sudoku-generator.c"
					}
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp13_ = FALSE;
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp15_ = i;
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp16_ = solver;
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp17_ = ((SudokuSolver*) _tmp16_)->breadcrumbs;
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp18_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp17_);
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp19_ = _tmp18_;
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					if (!(_tmp15_ < _tmp19_)) {
#line 360 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						break;
#line 2178 "sudoku-generator.c"
					}
				}
			}
		}
#line 367 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp20_ = solver;
#line 367 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp21_ = ((SudokuSolver*) _tmp20_)->breadcrumbs;
#line 367 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp22_ = solver;
#line 367 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp23_ = ((SudokuSolver*) _tmp22_)->breadcrumbs;
#line 367 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp24_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp23_);
#line 367 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp25_ = _tmp24_;
#line 367 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp21_, _tmp25_ - 1);
#line 367 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		crumb = (Guess*) _tmp26_;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp27_ = board;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp28_ = crumb;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp29_ = guess_get_row (_tmp28_);
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp30_ = _tmp29_;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp31_ = crumb;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp32_ = guess_get_col (_tmp31_);
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp33_ = _tmp32_;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp34_ = self->start_board;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp35_ = crumb;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp36_ = guess_get_row (_tmp35_);
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp37_ = _tmp36_;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp38_ = crumb;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp39_ = guess_get_col (_tmp38_);
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp40_ = _tmp39_;
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp41_ = sudoku_board_get (_tmp34_, _tmp37_, _tmp40_);
#line 370 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		sudoku_board_insert (_tmp27_, _tmp30_, _tmp33_, _tmp41_, TRUE);
#line 372 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp42_ = crumb;
#line 372 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp43_ = guess_get_row (_tmp42_);
#line 372 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp44_ = _tmp43_;
#line 372 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp45_ = crumb;
#line 372 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp46_ = guess_get_col (_tmp45_);
#line 372 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp47_ = _tmp46_;
#line 372 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp48_ = line;
#line 372 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		sudoku_generator_reflect (self, _tmp44_, _tmp47_, _tmp48_, &_tmp49_);
#line 372 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		reflection = _tmp49_;
#line 374 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp50_ = board;
#line 374 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp51_ = reflection;
#line 374 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp52_ = _tmp51_.row;
#line 374 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp53_ = reflection;
#line 374 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp54_ = _tmp53_.col;
#line 374 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp55_ = self->start_board;
#line 374 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp56_ = reflection;
#line 374 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp57_ = _tmp56_.row;
#line 374 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp58_ = reflection;
#line 374 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp59_ = _tmp58_.col;
#line 374 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp60_ = sudoku_board_get (_tmp55_, _tmp57_, _tmp59_);
#line 374 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		sudoku_board_insert (_tmp50_, _tmp52_, _tmp54_, _tmp60_, TRUE);
#line 378 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp62_ = strict_number_of_clues;
#line 378 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		if (_tmp62_) {
#line 2277 "sudoku-generator.c"
			SudokuBoard* _tmp63_ = NULL;
			gint _tmp64_ = 0;
			gint _tmp65_ = 0;
			gint _tmp66_ = 0;
#line 378 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp63_ = board;
#line 378 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp64_ = sudoku_board_get_filled (_tmp63_);
#line 378 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp65_ = _tmp64_;
#line 378 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp66_ = self->clues;
#line 378 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp61_ = _tmp65_ > _tmp66_;
#line 2292 "sudoku-generator.c"
		} else {
#line 378 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp61_ = FALSE;
#line 2296 "sudoku-generator.c"
		}
#line 378 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		if (_tmp61_) {
#line 381 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			result = NULL;
#line 381 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_g_object_unref0 (crumb);
#line 381 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_g_object_unref0 (solver);
#line 381 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_g_object_unref0 (solved_board);
#line 381 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_g_object_unref0 (diff);
#line 381 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_g_object_unref0 (board);
#line 381 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			return result;
#line 2314 "sudoku-generator.c"
		}
#line 327 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_g_object_unref0 (crumb);
#line 327 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_g_object_unref0 (solver);
#line 327 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_g_object_unref0 (solved_board);
#line 2322 "sudoku-generator.c"
	}
#line 387 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp67_ = strict_number_of_clues;
#line 387 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	if (_tmp67_) {
#line 2328 "sudoku-generator.c"
		gboolean changed = FALSE;
		gboolean _tmp101_ = FALSE;
#line 390 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		changed = FALSE;
#line 391 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		while (TRUE) {
#line 2335 "sudoku-generator.c"
			SudokuBoard* _tmp68_ = NULL;
			gint _tmp69_ = 0;
			gint _tmp70_ = 0;
			gint _tmp71_ = 0;
			gint row = 0;
			gint col = 0;
			SudokuBoard* _tmp79_ = NULL;
			gint _tmp80_ = 0;
			gint _tmp81_ = 0;
			SudokuBoard* _tmp82_ = NULL;
			gint _tmp83_ = 0;
			gint _tmp84_ = 0;
			gint _tmp85_ = 0;
			Coord reflection = {0};
			gint _tmp86_ = 0;
			gint _tmp87_ = 0;
			gint _tmp88_ = 0;
			Coord _tmp89_ = {0};
			SudokuBoard* _tmp90_ = NULL;
			Coord _tmp91_ = {0};
			gint _tmp92_ = 0;
			Coord _tmp93_ = {0};
			gint _tmp94_ = 0;
			SudokuBoard* _tmp95_ = NULL;
			Coord _tmp96_ = {0};
			gint _tmp97_ = 0;
			Coord _tmp98_ = {0};
			gint _tmp99_ = 0;
			gint _tmp100_ = 0;
#line 391 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp68_ = board;
#line 391 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp69_ = sudoku_board_get_filled (_tmp68_);
#line 391 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp70_ = _tmp69_;
#line 391 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp71_ = self->clues;
#line 391 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			if (!(_tmp70_ < _tmp71_)) {
#line 391 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				break;
#line 2377 "sudoku-generator.c"
			}
#line 393 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			row = -1;
#line 394 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			col = -1;
#line 2383 "sudoku-generator.c"
			{
				gboolean _tmp72_ = FALSE;
#line 395 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				_tmp72_ = TRUE;
#line 395 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
				while (TRUE) {
#line 2390 "sudoku-generator.c"
					gint32 _tmp77_ = 0;
					gint32 _tmp78_ = 0;
#line 395 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					if (!_tmp72_) {
#line 2395 "sudoku-generator.c"
						SudokuBoard* _tmp73_ = NULL;
						gint _tmp74_ = 0;
						gint _tmp75_ = 0;
						gint _tmp76_ = 0;
#line 400 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp73_ = board;
#line 400 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp74_ = row;
#line 400 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp75_ = col;
#line 400 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						_tmp76_ = sudoku_board_get (_tmp73_, _tmp74_, _tmp75_);
#line 400 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
						if (!(_tmp76_ == 0)) {
#line 400 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
							break;
#line 2412 "sudoku-generator.c"
						}
					}
#line 395 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp72_ = FALSE;
#line 397 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp77_ = g_random_int_range ((gint32) 0, (gint32) 9);
#line 397 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					row = (gint) _tmp77_;
#line 398 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					_tmp78_ = g_random_int_range ((gint32) 0, (gint32) 9);
#line 398 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
					col = (gint) _tmp78_;
#line 2425 "sudoku-generator.c"
				}
			}
#line 402 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp79_ = board;
#line 402 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp80_ = row;
#line 402 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp81_ = col;
#line 402 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp82_ = self->start_board;
#line 402 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp83_ = row;
#line 402 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp84_ = col;
#line 402 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp85_ = sudoku_board_get (_tmp82_, _tmp83_, _tmp84_);
#line 402 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			sudoku_board_insert (_tmp79_, _tmp80_, _tmp81_, _tmp85_, TRUE);
#line 404 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp86_ = row;
#line 404 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp87_ = col;
#line 404 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp88_ = line;
#line 404 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			sudoku_generator_reflect (self, _tmp86_, _tmp87_, _tmp88_, &_tmp89_);
#line 404 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			reflection = _tmp89_;
#line 405 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp90_ = board;
#line 405 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp91_ = reflection;
#line 405 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp92_ = _tmp91_.row;
#line 405 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp93_ = reflection;
#line 405 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp94_ = _tmp93_.col;
#line 405 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp95_ = self->start_board;
#line 405 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp96_ = reflection;
#line 405 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp97_ = _tmp96_.row;
#line 405 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp98_ = reflection;
#line 405 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp99_ = _tmp98_.col;
#line 405 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp100_ = sudoku_board_get (_tmp95_, _tmp97_, _tmp99_);
#line 405 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			sudoku_board_insert (_tmp90_, _tmp92_, _tmp94_, _tmp100_, TRUE);
#line 407 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			changed = TRUE;
#line 2480 "sudoku-generator.c"
		}
#line 409 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		_tmp101_ = changed;
#line 409 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
		if (_tmp101_) {
#line 2486 "sudoku-generator.c"
			SudokuRater* _tmp102_ = NULL;
			SudokuRater* _tmp103_ = NULL;
			DifficultyRating* _tmp104_ = NULL;
#line 410 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp102_ = sudoku_rater_new (&board);
#line 410 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp103_ = _tmp102_;
#line 410 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_tmp104_ = sudoku_rater_get_difficulty (_tmp103_);
#line 410 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_g_object_unref0 (diff);
#line 410 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			diff = _tmp104_;
#line 410 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
			_g_object_unref0 (_tmp103_);
#line 2502 "sudoku-generator.c"
		}
	}
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp105_ = board;
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp106_ = diff;
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	sudoku_generator_rated_sudoku_init (&_tmp107_, _tmp105_, _tmp106_);
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp108_ = _tmp107_;
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp109_ = _sudoku_generator_rated_sudoku_dup0 (&_tmp108_);
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp110_ = _tmp109_;
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	sudoku_generator_rated_sudoku_destroy (&_tmp108_);
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	result = _tmp110_;
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 (diff);
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 (board);
#line 413 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	return result;
#line 2527 "sudoku-generator.c"
}


void sudoku_generator_rated_sudoku_init (SudokuGeneratorRatedSudoku *self, SudokuBoard* board, DifficultyRating* diff) {
	SudokuBoard* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	DifficultyRating* _tmp2_ = NULL;
	DifficultyRating* _tmp3_ = NULL;
#line 15 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	g_return_if_fail (board != NULL);
#line 15 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	g_return_if_fail (diff != NULL);
#line 15 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	memset (self, 0, sizeof (SudokuGeneratorRatedSudoku));
#line 17 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = board;
#line 17 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 17 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 ((*self).board);
#line 17 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	(*self).board = _tmp1_;
#line 18 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp2_ = diff;
#line 18 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 18 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 ((*self).diff);
#line 18 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	(*self).diff = _tmp3_;
#line 2558 "sudoku-generator.c"
}


void sudoku_generator_rated_sudoku_copy (const SudokuGeneratorRatedSudoku* self, SudokuGeneratorRatedSudoku* dest) {
	SudokuBoard* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	DifficultyRating* _tmp2_ = NULL;
	DifficultyRating* _tmp3_ = NULL;
#line 10 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = (*self).board;
#line 10 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 10 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 ((*dest).board);
#line 10 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	(*dest).board = _tmp1_;
#line 10 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp2_ = (*self).diff;
#line 10 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 10 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 ((*dest).diff);
#line 10 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	(*dest).diff = _tmp3_;
#line 2583 "sudoku-generator.c"
}


void sudoku_generator_rated_sudoku_destroy (SudokuGeneratorRatedSudoku* self) {
#line 12 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 ((*self).board);
#line 13 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 ((*self).diff);
#line 2592 "sudoku-generator.c"
}


SudokuGeneratorRatedSudoku* sudoku_generator_rated_sudoku_dup (const SudokuGeneratorRatedSudoku* self) {
	SudokuGeneratorRatedSudoku* dup;
#line 10 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	dup = g_new0 (SudokuGeneratorRatedSudoku, 1);
#line 10 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	sudoku_generator_rated_sudoku_copy (self, dup);
#line 10 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	return dup;
#line 2604 "sudoku-generator.c"
}


void sudoku_generator_rated_sudoku_free (SudokuGeneratorRatedSudoku* self) {
#line 10 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	sudoku_generator_rated_sudoku_destroy (self);
#line 10 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	g_free (self);
#line 2613 "sudoku-generator.c"
}


GType sudoku_generator_rated_sudoku_get_type (void) {
	static volatile gsize sudoku_generator_rated_sudoku_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_generator_rated_sudoku_type_id__volatile)) {
		GType sudoku_generator_rated_sudoku_type_id;
		sudoku_generator_rated_sudoku_type_id = g_boxed_type_register_static ("SudokuGeneratorRatedSudoku", (GBoxedCopyFunc) sudoku_generator_rated_sudoku_dup, (GBoxedFreeFunc) sudoku_generator_rated_sudoku_free);
		g_once_init_leave (&sudoku_generator_rated_sudoku_type_id__volatile, sudoku_generator_rated_sudoku_type_id);
	}
	return sudoku_generator_rated_sudoku_type_id__volatile;
}


static void sudoku_generator_class_init (SudokuGeneratorClass * klass) {
#line 3 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	sudoku_generator_parent_class = g_type_class_peek_parent (klass);
#line 3 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	g_type_class_add_private (klass, sizeof (SudokuGeneratorPrivate));
#line 3 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_generator_finalize;
#line 2635 "sudoku-generator.c"
}


static void sudoku_generator_instance_init (SudokuGenerator * self) {
	SudokuBoard* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
#line 3 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv = SUDOKU_GENERATOR_GET_PRIVATE (self);
#line 5 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	self->clues = 40;
#line 7 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp0_ = sudoku_board_new (3, 3);
#line 7 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	self->start_board = _tmp0_;
#line 8 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_tmp1_ = sudoku_board_new (3, 3);
#line 8 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	self->priv->temp_start_board = _tmp1_;
#line 2654 "sudoku-generator.c"
}


static void sudoku_generator_finalize (GObject* obj) {
	SudokuGenerator * self;
#line 3 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU_GENERATOR, SudokuGenerator);
#line 7 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 (self->start_board);
#line 8 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	_g_object_unref0 (self->priv->temp_start_board);
#line 3 "/home/manhattan/checkout/gnome/gnome-sudoku/lib/sudoku-generator.vala"
	G_OBJECT_CLASS (sudoku_generator_parent_class)->finalize (obj);
#line 2668 "sudoku-generator.c"
}


GType sudoku_generator_get_type (void) {
	static volatile gsize sudoku_generator_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_generator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuGeneratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_generator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SudokuGenerator), 0, (GInstanceInitFunc) sudoku_generator_instance_init, NULL };
		GType sudoku_generator_type_id;
		sudoku_generator_type_id = g_type_register_static (G_TYPE_OBJECT, "SudokuGenerator", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_generator_type_id__volatile, sudoku_generator_type_id);
	}
	return sudoku_generator_type_id__volatile;
}



