/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#ifndef __GNOME_SCAN_OPTION_BOX_H__
#define __GNOME_SCAN_OPTION_BOX_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gnome-scan-option.h>

G_BEGIN_DECLS


#define GNOME_SCAN_TYPE_OPTION_BOX (gnome_scan_option_box_get_type ())
#define GNOME_SCAN_OPTION_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_BOX, GnomeScanOptionBox))
#define GNOME_SCAN_OPTION_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_BOX, GnomeScanOptionBoxClass))
#define GNOME_SCAN_IS_OPTION_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_BOX))
#define GNOME_SCAN_IS_OPTION_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_BOX))
#define GNOME_SCAN_OPTION_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_BOX, GnomeScanOptionBoxClass))

typedef struct _GnomeScanOptionBox GnomeScanOptionBox;
typedef struct _GnomeScanOptionBoxClass GnomeScanOptionBoxClass;
typedef struct _GnomeScanOptionBoxPrivate GnomeScanOptionBoxPrivate;

struct _GnomeScanOptionBox {
	GtkVBox parent_instance;
	GnomeScanOptionBoxPrivate * priv;
};

struct _GnomeScanOptionBoxClass {
	GtkVBoxClass parent_class;
};


GnomeScanOptionBox* gnome_scan_option_box_construct (GType object_type, const char* label);
GnomeScanOptionBox* gnome_scan_option_box_new (const char* label);
void gnome_scan_option_box_pack_option (GnomeScanOptionBox* self, GnomeScanOption* option);
gboolean gnome_scan_option_box_unpack_option (GnomeScanOptionBox* self, GnomeScanOption* option);
const char* gnome_scan_option_box_get_label (GnomeScanOptionBox* self);
void gnome_scan_option_box_set_label (GnomeScanOptionBox* self, const char* value);
gboolean gnome_scan_option_box_get_expand (GnomeScanOptionBox* self);
void gnome_scan_option_box_set_expand (GnomeScanOptionBox* self, gboolean value);
GType gnome_scan_option_box_get_type (void);


G_END_DECLS

#endif
