/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <gnome-scan-entry-widget.h>
#include <gtk/gtk.h>
#include <gnome-scan-option.h>




struct _GnomeScanEntryWidgetPrivate {
	GtkEntry* entry;
};

#define GNOME_SCAN_ENTRY_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_ENTRY_WIDGET, GnomeScanEntryWidgetPrivate))
enum  {
	GNOME_SCAN_ENTRY_WIDGET_DUMMY_PROPERTY
};
static void gnome_scan_entry_widget_on_entry_changed (GnomeScanEntryWidget* self);
static void gnome_scan_entry_widget_on_option_changed (GnomeScanEntryWidget* self);
static void _gnome_scan_entry_widget_on_entry_changed_g_object_notify (GtkEntry* _sender, GParamSpec* pspec, gpointer self);
static void _gnome_scan_entry_widget_on_option_changed_g_object_notify (GnomeScanOptionString* _sender, GParamSpec* pspec, gpointer self);
static GObject * gnome_scan_entry_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer gnome_scan_entry_widget_parent_class = NULL;
static void gnome_scan_entry_widget_finalize (GObject* obj);



static void gnome_scan_entry_widget_on_entry_changed (GnomeScanEntryWidget* self) {
	g_return_if_fail (self != NULL);
	g_object_freeze_notify ((GObject*) gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self));
	gnome_scan_option_string_set_value ((GNOME_SCAN_OPTION_STRING (gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self))), gtk_entry_get_text (self->priv->entry));
	g_object_thaw_notify ((GObject*) gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self));
}


static void gnome_scan_entry_widget_on_option_changed (GnomeScanEntryWidget* self) {
	g_return_if_fail (self != NULL);
	g_object_freeze_notify ((GObject*) self->priv->entry);
	gtk_entry_set_text (self->priv->entry, gnome_scan_option_string_get_value ((GNOME_SCAN_OPTION_STRING (gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self)))));
	g_object_thaw_notify ((GObject*) self->priv->entry);
}


GnomeScanEntryWidget* gnome_scan_entry_widget_construct (GType object_type) {
	GnomeScanEntryWidget * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GnomeScanEntryWidget* gnome_scan_entry_widget_new (void) {
	return gnome_scan_entry_widget_construct (GNOME_SCAN_TYPE_ENTRY_WIDGET);
}


static void _gnome_scan_entry_widget_on_entry_changed_g_object_notify (GtkEntry* _sender, GParamSpec* pspec, gpointer self) {
	gnome_scan_entry_widget_on_entry_changed (self);
}


static void _gnome_scan_entry_widget_on_option_changed_g_object_notify (GnomeScanOptionString* _sender, GParamSpec* pspec, gpointer self) {
	gnome_scan_entry_widget_on_option_changed (self);
}


static GObject * gnome_scan_entry_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GnomeScanEntryWidgetClass * klass;
	GObjectClass * parent_class;
	GnomeScanEntryWidget * self;
	klass = GNOME_SCAN_ENTRY_WIDGET_CLASS (g_type_class_peek (GNOME_SCAN_TYPE_ENTRY_WIDGET));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GNOME_SCAN_ENTRY_WIDGET (obj);
	{
		GnomeScanOptionString* _tmp1;
		GnomeScanOption* _tmp0;
		GnomeScanOptionString* option;
		GtkEntry* _tmp2;
		_tmp1 = NULL;
		_tmp0 = NULL;
		option = (_tmp1 = (_tmp0 = gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), GNOME_SCAN_IS_OPTION_STRING (_tmp0) ? ((GnomeScanOptionString*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1));
		_tmp2 = NULL;
		self->priv->entry = (_tmp2 = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), (self->priv->entry == NULL) ? NULL : (self->priv->entry = (g_object_unref (self->priv->entry), NULL)), _tmp2);
		gtk_entry_set_text (self->priv->entry, gnome_scan_option_string_get_value (option));
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) self->priv->entry, TRUE, TRUE, (guint) 0);
		g_signal_connect_object ((GObject*) self->priv->entry, "notify::text", (GCallback) _gnome_scan_entry_widget_on_entry_changed_g_object_notify, self, 0);
		g_signal_connect_object ((GObject*) option, "notify::value", (GCallback) _gnome_scan_entry_widget_on_option_changed_g_object_notify, self, 0);
		(option == NULL) ? NULL : (option = (g_object_unref (option), NULL));
	}
	return obj;
}


static void gnome_scan_entry_widget_class_init (GnomeScanEntryWidgetClass * klass) {
	gnome_scan_entry_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanEntryWidgetPrivate));
	G_OBJECT_CLASS (klass)->constructor = gnome_scan_entry_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_entry_widget_finalize;
}


static void gnome_scan_entry_widget_instance_init (GnomeScanEntryWidget * self) {
	self->priv = GNOME_SCAN_ENTRY_WIDGET_GET_PRIVATE (self);
}


static void gnome_scan_entry_widget_finalize (GObject* obj) {
	GnomeScanEntryWidget * self;
	self = GNOME_SCAN_ENTRY_WIDGET (obj);
	(self->priv->entry == NULL) ? NULL : (self->priv->entry = (g_object_unref (self->priv->entry), NULL));
	G_OBJECT_CLASS (gnome_scan_entry_widget_parent_class)->finalize (obj);
}


GType gnome_scan_entry_widget_get_type (void) {
	static GType gnome_scan_entry_widget_type_id = 0;
	if (gnome_scan_entry_widget_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanEntryWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_entry_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanEntryWidget), 0, (GInstanceInitFunc) gnome_scan_entry_widget_instance_init, NULL };
		gnome_scan_entry_widget_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION_WIDGET, "GnomeScanEntryWidget", &g_define_type_info, 0);
	}
	return gnome_scan_entry_widget_type_id;
}




