/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#ifndef __GNOME_SCAN_COMMON_H__
#define __GNOME_SCAN_COMMON_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

G_BEGIN_DECLS


#define GNOME_SCAN_TYPE_UNIT (gnome_scan_unit_get_type ())

#define GNOME_SCAN_TYPE_STATUS (gnome_scan_status_get_type ())
typedef struct _GnomeScanPoint GnomeScanPoint;

#define GNOME_SCAN_TYPE_POINT (gnome_scan_point_get_type ())
typedef struct _GnomeScanRange GnomeScanRange;

#define GNOME_SCAN_TYPE_RANGE (gnome_scan_range_get_type ())

#define GNOME_SCAN_TYPE_FORMAT (gnome_scan_format_get_type ())
#define GNOME_SCAN_FORMAT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_FORMAT, GnomeScanFormat))
#define GNOME_SCAN_FORMAT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_FORMAT, GnomeScanFormatClass))
#define GNOME_SCAN_IS_FORMAT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_FORMAT))
#define GNOME_SCAN_IS_FORMAT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_FORMAT))
#define GNOME_SCAN_FORMAT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_FORMAT, GnomeScanFormatClass))

typedef struct _GnomeScanFormat GnomeScanFormat;
typedef struct _GnomeScanFormatClass GnomeScanFormatClass;
typedef struct _GnomeScanFormatPrivate GnomeScanFormatPrivate;
typedef struct _GnomeScanEnumValue GnomeScanEnumValue;

#define GNOME_SCAN_TYPE_ENUM_VALUE (gnome_scan_enum_value_get_type ())
typedef struct _GnomeScanRectangle GnomeScanRectangle;

typedef enum  {
	GNOME_SCAN_UNIT_NONE = -1,
	GNOME_SCAN_UNIT_PIXEL,
	GNOME_SCAN_UNIT_POINTS,
	GNOME_SCAN_UNIT_INCH,
	GNOME_SCAN_UNIT_MM,
	GNOME_SCAN_UNIT_BIT,
	GNOME_SCAN_UNIT_DPI,
	GNOME_SCAN_UNIT_PERCENT,
	GNOME_SCAN_UNIT_MICROSECOND
} GnomeScanUnit;

/* Status in reverse order of priority*/
typedef enum  {
	GNOME_SCAN_STATUS_UNKNOWN = 0,
	GNOME_SCAN_STATUS_FAILED = 10,
	GNOME_SCAN_STATUS_INITIALIZING = 20,
	GNOME_SCAN_STATUS_UNCONFIGURED = 30,
	GNOME_SCAN_STATUS_READY = 40,
	GNOME_SCAN_STATUS_PROCESSING = 50,
	GNOME_SCAN_STATUS_DONE = 60
} GnomeScanStatus;

/* needs option to be set by user
 ready to start a process
 acquiring/processing/outputting
 processing done;*/
struct _GnomeScanPoint {
	double x;
	double y;
};

struct _GnomeScanRange {
	double min;
	double step;
	double max;
};

struct _GnomeScanFormat {
	GObject parent_instance;
	GnomeScanFormatPrivate * priv;
	const char* name;
	const char* desc;
	const char* domain;
	const char* icon_name;
	char** mime_types;
	gint mime_types_length1;
	char** suffixes;
	gint suffixes_length1;
};

struct _GnomeScanFormatClass {
	GObjectClass parent_class;
};

struct _GnomeScanEnumValue {
	GValue value;
	char* label;
	char* domain;
};

struct _GnomeScanRectangle {
	double x;
	double y;
	double width;
	double height;
};


GType gnome_scan_unit_get_type (void);
char* gnome_scan_unit_to_string (GnomeScanUnit unit);
GType gnome_scan_status_get_type (void);
GnomeScanPoint* gnome_scan_point_dup (const GnomeScanPoint* self);
void gnome_scan_point_free (GnomeScanPoint* self);
GType gnome_scan_point_get_type (void);
GnomeScanRange* gnome_scan_range_dup (const GnomeScanRange* self);
void gnome_scan_range_free (GnomeScanRange* self);
GType gnome_scan_range_get_type (void);
GnomeScanFormat* gnome_scan_format_construct (GType object_type, const char* name, const char* desc, const char* domain, const char* icon_name, char** mime_types, int mime_types_length1, char** suffixes, int suffixes_length1);
GnomeScanFormat* gnome_scan_format_new (const char* name, const char* desc, const char* domain, const char* icon_name, char** mime_types, int mime_types_length1, char** suffixes, int suffixes_length1);
GType gnome_scan_format_get_type (void);
void gnome_scan_enum_value_init (GnomeScanEnumValue *self, const GValue* value, const char* label, const char* domain);
void gnome_scan_enum_value_copy (const GnomeScanEnumValue* self, GnomeScanEnumValue* dest);
void gnome_scan_enum_value_destroy (GnomeScanEnumValue* self);
GnomeScanEnumValue* gnome_scan_enum_value_dup (const GnomeScanEnumValue* self);
void gnome_scan_enum_value_free (GnomeScanEnumValue* self);
GType gnome_scan_enum_value_get_type (void);
char* gnome_scan_enum_get_nick (GType enum_type, gint value);
char* gnome_scan_flags_get_nicks (GType flags_type, gint value);
double gnome_scan_convert (double val, GnomeScanUnit from, GnomeScanUnit to, double res);
double gnome_scan_convert_from_mm (double val, GnomeScanUnit to, double res);
double gnome_scan_convert_to_mm (double val, GnomeScanUnit from, double res);
void gnome_scan_rectangle_rotate (GnomeScanRectangle* self, GnomeScanRectangle* area, gint angle);
void gnome_scan_rectangle_convert (GnomeScanRectangle* self, GnomeScanUnit from, GnomeScanUnit to, double res);
void gnome_scan_rectangle_convert_to_mm (GnomeScanRectangle* self, GnomeScanUnit from, double res);
void gnome_scan_rectangle_convert_from_mm (GnomeScanRectangle* self, GnomeScanUnit to, double res);
GnomeScanRectangle* gnome_scan_rectangle_new (void);
void gnome_scan_rectangle_free (GnomeScanRectangle* self);


G_END_DECLS

#endif
