/* Flegita - Scanner utility
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * Flegita is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Flegita is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Flegita. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include "flegita.h"
#include <gnome-scan-job.h>
#include <gnome-scan-dialog.h>
#include <glib/gi18n-lib.h>
#include <gnome-scan-init.h>
#include <gtk/gtk.h>
#include <gnome-scan-option-manager.h>
#include <gnome-scan-sink.h>
#include "flegita-sink.h"
#include "flegita-options.h"
#include "flegita-option-widgets.h"







gint _main (char** args, int args_length1) {
	GnomeScanJob* job;
	GnomeScanDialog* dialog;
	FlegitaSink* sink;
	FlegitaSink* _tmp0;
	GnomeScanJob* _tmp1;
	GnomeScanDialog* _tmp2;
	gint _tmp3;
	job = NULL;
	dialog = NULL;
	sink = NULL;
	g_set_prgname ("flegita");
	g_set_application_name (_ ("Scanner Utility"));
	gnome_scan_init (&args_length1, &args);
	gtk_init (&args_length1, &args);
	gnome_scan_option_manager_register_rule_by_type (gnome_scan_option_manager, FLEGITA_TYPE_OPTION_OUTPUT_FILENAME, FLEGITA_TYPE_OUTPUT_FILENAME_WIDGET);
	_tmp0 = NULL;
	sink = (_tmp0 = flegita_sink_new (), (sink == NULL) ? NULL : (sink = (g_object_unref (sink), NULL)), _tmp0);
	_tmp1 = NULL;
	job = (_tmp1 = gnome_scan_job_new ((GnomeScanSink*) sink), (job == NULL) ? NULL : (job = (g_object_unref (job), NULL)), _tmp1);
	_tmp2 = NULL;
	dialog = (_tmp2 = g_object_ref_sink (gnome_scan_dialog_new (NULL, job)), (dialog == NULL) ? NULL : (dialog = (g_object_unref (dialog), NULL)), _tmp2);
	gnome_scan_dialog_run (dialog);
	return (_tmp3 = 0, (job == NULL) ? NULL : (job = (g_object_unref (job), NULL)), (dialog == NULL) ? NULL : (dialog = (g_object_unref (dialog), NULL)), (sink == NULL) ? NULL : (sink = (g_object_unref (sink), NULL)), _tmp3);
}


int main (int argc, char ** argv) {
	g_thread_init (NULL);
	g_type_init ();
	return _main (argv, argc);
}




