/* Flegita - Scanner utility
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * Flegita is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Flegita is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Flegita. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#ifndef __FLEGITA_OPTIONS_H__
#define __FLEGITA_OPTIONS_H__

#include <glib.h>
#include <glib-object.h>
#include <gnome-scan-option.h>
#include <stdlib.h>
#include <string.h>
#include <gnome-scan-common.h>

G_BEGIN_DECLS


#define FLEGITA_TYPE_OPTION_OUTPUT_FILENAME (flegita_option_output_filename_get_type ())
#define FLEGITA_OPTION_OUTPUT_FILENAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FLEGITA_TYPE_OPTION_OUTPUT_FILENAME, FlegitaOptionOutputFilename))
#define FLEGITA_OPTION_OUTPUT_FILENAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FLEGITA_TYPE_OPTION_OUTPUT_FILENAME, FlegitaOptionOutputFilenameClass))
#define FLEGITA_IS_OPTION_OUTPUT_FILENAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FLEGITA_TYPE_OPTION_OUTPUT_FILENAME))
#define FLEGITA_IS_OPTION_OUTPUT_FILENAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FLEGITA_TYPE_OPTION_OUTPUT_FILENAME))
#define FLEGITA_OPTION_OUTPUT_FILENAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FLEGITA_TYPE_OPTION_OUTPUT_FILENAME, FlegitaOptionOutputFilenameClass))

typedef struct _FlegitaOptionOutputFilename FlegitaOptionOutputFilename;
typedef struct _FlegitaOptionOutputFilenameClass FlegitaOptionOutputFilenameClass;
typedef struct _FlegitaOptionOutputFilenamePrivate FlegitaOptionOutputFilenamePrivate;

struct _FlegitaOptionOutputFilename {
	GnomeScanOption parent_instance;
	FlegitaOptionOutputFilenamePrivate * priv;
};

struct _FlegitaOptionOutputFilenameClass {
	GnomeScanOptionClass parent_class;
};


FlegitaOptionOutputFilename* flegita_option_output_filename_construct (GType object_type, const char* name, const char* title, const char* desc, const char* domain, const char* group, GnomeScanOptionHint hint);
FlegitaOptionOutputFilename* flegita_option_output_filename_new (const char* name, const char* title, const char* desc, const char* domain, const char* group, GnomeScanOptionHint hint);
void flegita_option_output_filename_install_format (FlegitaOptionOutputFilename* self, GnomeScanFormat* format);
GSList* flegita_option_output_filename_list_formats (FlegitaOptionOutputFilename* self);
const char* flegita_option_output_filename_get_value (FlegitaOptionOutputFilename* self);
void flegita_option_output_filename_set_value (FlegitaOptionOutputFilename* self, const char* value);
GType flegita_option_output_filename_get_type (void);


G_END_DECLS

#endif
