/* Flegita - Scanner utility
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * Flegita is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * Flegita is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with Flegita. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include "flegita-option-widgets.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <gnome-scan-common.h>
#include "flegita-options.h"


#define FLEGITA_TYPE_FORMAT_COLUMNS (flegita_format_columns_get_type ())

typedef enum  {
	FLEGITA_FORMAT_COLUMNS_ICON,
	FLEGITA_FORMAT_COLUMNS_SUFFIX,
	FLEGITA_FORMAT_COLUMNS_N
} FlegitaFormatColumns;



GType flegita_format_columns_get_type (void);
struct _FlegitaOutputFilenameWidgetPrivate {
	GtkEntry* entry;
	GtkFileChooser* filechooser;
	GtkListStore* formats;
	GtkComboBox* combobox;
	GHashTable* format_paths;
	gboolean inhibit;
};

#define FLEGITA_OUTPUT_FILENAME_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), FLEGITA_TYPE_OUTPUT_FILENAME_WIDGET, FlegitaOutputFilenameWidgetPrivate))
enum  {
	FLEGITA_OUTPUT_FILENAME_WIDGET_DUMMY_PROPERTY
};
static void flegita_output_filename_widget_update_filename (FlegitaOutputFilenameWidget* self);
static void flegita_output_filename_widget_parse_filename (FlegitaOutputFilenameWidget* self);
static void _flegita_output_filename_widget_parse_filename_g_object_notify (GnomeScanOption* _sender, GParamSpec* pspec, gpointer self);
static void _flegita_output_filename_widget_update_filename_gtk_file_chooser_selection_changed (GtkFileChooser* _sender, gpointer self);
static void _flegita_output_filename_widget_update_filename_gtk_editable_changed (GtkEntry* _sender, gpointer self);
static void _flegita_output_filename_widget_update_filename_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static GObject * flegita_output_filename_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer flegita_output_filename_widget_parent_class = NULL;
static void flegita_output_filename_widget_finalize (GObject* obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);




GType flegita_format_columns_get_type (void) {
	static GType flegita_format_columns_type_id = 0;
	if (G_UNLIKELY (flegita_format_columns_type_id == 0)) {
		static const GEnumValue values[] = {{FLEGITA_FORMAT_COLUMNS_ICON, "FLEGITA_FORMAT_COLUMNS_ICON", "icon"}, {FLEGITA_FORMAT_COLUMNS_SUFFIX, "FLEGITA_FORMAT_COLUMNS_SUFFIX", "suffix"}, {FLEGITA_FORMAT_COLUMNS_N, "FLEGITA_FORMAT_COLUMNS_N", "n"}, {0, NULL, NULL}};
		flegita_format_columns_type_id = g_enum_register_static ("FlegitaFormatColumns", values);
	}
	return flegita_format_columns_type_id;
}


static void flegita_output_filename_widget_update_filename (FlegitaOutputFilenameWidget* self) {
	FlegitaOptionOutputFilename* _tmp1;
	GnomeScanOption* _tmp0;
	FlegitaOptionOutputFilename* option;
	char* suffix;
	GtkTreeIter iter = {0};
	gboolean format_selected;
	char* _tmp2;
	g_return_if_fail (self != NULL);
	if (self->priv->inhibit) {
		return;
	}
	_tmp1 = NULL;
	_tmp0 = NULL;
	option = (_tmp1 = (_tmp0 = gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), FLEGITA_IS_OPTION_OUTPUT_FILENAME (_tmp0) ? ((FlegitaOptionOutputFilename*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1));
	suffix = NULL;
	format_selected = gtk_combo_box_get_active_iter (self->priv->combobox, &iter);
	g_return_if_fail (format_selected);
	gtk_tree_model_get ((GtkTreeModel*) self->priv->formats, &iter, FLEGITA_FORMAT_COLUMNS_SUFFIX, &suffix, -1);
	self->priv->inhibit = TRUE;
	_tmp2 = NULL;
	flegita_option_output_filename_set_value (option, _tmp2 = g_strdup_printf ("%s%c%s.%s", gtk_file_chooser_get_filename (self->priv->filechooser), (gint) G_DIR_SEPARATOR, gtk_entry_get_text (self->priv->entry), suffix));
	_tmp2 = (g_free (_tmp2), NULL);
	self->priv->inhibit = FALSE;
	(option == NULL) ? NULL : (option = (g_object_unref (option), NULL));
	suffix = (g_free (suffix), NULL);
}


static void flegita_output_filename_widget_parse_filename (FlegitaOutputFilenameWidget* self) {
	GtkTreeIter iter = {0};
	FlegitaOptionOutputFilename* _tmp1;
	GnomeScanOption* _tmp0;
	FlegitaOptionOutputFilename* option;
	const char* _tmp2;
	char* filename;
	gboolean _tmp3;
	char* _tmp4;
	char* basename;
	const char* _tmp5;
	char* suffix;
	const char* _tmp6;
	char* path_string;
	char** _tmp7;
	gint parts_length1;
	char** parts;
	g_return_if_fail (self != NULL);
	if (self->priv->inhibit) {
		return;
	}
	self->priv->inhibit = TRUE;
	_tmp1 = NULL;
	_tmp0 = NULL;
	option = (_tmp1 = (_tmp0 = gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), FLEGITA_IS_OPTION_OUTPUT_FILENAME (_tmp0) ? ((FlegitaOptionOutputFilename*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1));
	_tmp2 = NULL;
	filename = (_tmp2 = flegita_option_output_filename_get_value (option), (_tmp2 == NULL) ? NULL : g_strdup (_tmp2));
	_tmp3 = FALSE;
	if (filename == NULL) {
		_tmp3 = TRUE;
	} else {
		_tmp3 = g_utf8_strlen (filename, -1) == 0;
	}
	if (_tmp3) {
		(option == NULL) ? NULL : (option = (g_object_unref (option), NULL));
		filename = (g_free (filename), NULL);
		return;
	}
	_tmp4 = NULL;
	gtk_file_chooser_set_current_folder (self->priv->filechooser, _tmp4 = g_path_get_dirname (filename));
	_tmp4 = (g_free (_tmp4), NULL);
	basename = g_path_get_basename (filename);
	_tmp5 = NULL;
	suffix = (_tmp5 = g_utf8_strrchr (basename, (glong) (-1), (gunichar) '.'), (_tmp5 == NULL) ? NULL : g_strdup (_tmp5));
	if (suffix == NULL) {
		g_warning ("flegita-option-widgets.vala:129: unable to parse suffix in %s", basename);
		(option == NULL) ? NULL : (option = (g_object_unref (option), NULL));
		filename = (g_free (filename), NULL);
		basename = (g_free (basename), NULL);
		suffix = (g_free (suffix), NULL);
		return;
	}
	_tmp6 = NULL;
	path_string = (_tmp6 = (const char*) g_hash_table_lookup (self->priv->format_paths, suffix), (_tmp6 == NULL) ? NULL : g_strdup (_tmp6));
	if (!gtk_tree_model_get_iter_from_string ((GtkTreeModel*) self->priv->formats, &iter, path_string)) {
		g_warning ("flegita-option-widgets.vala:135: Invalid %s suffix", suffix);
		(option == NULL) ? NULL : (option = (g_object_unref (option), NULL));
		filename = (g_free (filename), NULL);
		basename = (g_free (basename), NULL);
		suffix = (g_free (suffix), NULL);
		path_string = (g_free (path_string), NULL);
		return;
	}
	gtk_combo_box_set_active_iter (self->priv->combobox, &iter);
	_tmp7 = NULL;
	parts = (_tmp7 = g_strsplit (basename, suffix, -1), parts_length1 = -1, _tmp7);
	gtk_entry_set_text (self->priv->entry, parts[0]);
	while (gdk_events_pending ()) {
		gtk_main_iteration ();
	}
	self->priv->inhibit = FALSE;
	(option == NULL) ? NULL : (option = (g_object_unref (option), NULL));
	filename = (g_free (filename), NULL);
	basename = (g_free (basename), NULL);
	suffix = (g_free (suffix), NULL);
	path_string = (g_free (path_string), NULL);
	parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
}


FlegitaOutputFilenameWidget* flegita_output_filename_widget_construct (GType object_type) {
	FlegitaOutputFilenameWidget * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


FlegitaOutputFilenameWidget* flegita_output_filename_widget_new (void) {
	return flegita_output_filename_widget_construct (FLEGITA_TYPE_OUTPUT_FILENAME_WIDGET);
}


static void _flegita_output_filename_widget_parse_filename_g_object_notify (GnomeScanOption* _sender, GParamSpec* pspec, gpointer self) {
	flegita_output_filename_widget_parse_filename (self);
}


static void _flegita_output_filename_widget_update_filename_gtk_file_chooser_selection_changed (GtkFileChooser* _sender, gpointer self) {
	flegita_output_filename_widget_update_filename (self);
}


static void _flegita_output_filename_widget_update_filename_gtk_editable_changed (GtkEntry* _sender, gpointer self) {
	flegita_output_filename_widget_update_filename (self);
}


static void _flegita_output_filename_widget_update_filename_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	flegita_output_filename_widget_update_filename (self);
}


static GObject * flegita_output_filename_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	FlegitaOutputFilenameWidgetClass * klass;
	GObjectClass * parent_class;
	FlegitaOutputFilenameWidget * self;
	klass = FLEGITA_OUTPUT_FILENAME_WIDGET_CLASS (g_type_class_peek (FLEGITA_TYPE_OUTPUT_FILENAME_WIDGET));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = FLEGITA_OUTPUT_FILENAME_WIDGET (obj);
	{
		GtkCellRenderer* renderer;
		FlegitaOptionOutputFilename* _tmp0;
		FlegitaOptionOutputFilename* option;
		GtkTreeIter iter = {0};
		GtkBox* box;
		GtkFileChooser* _tmp1;
		GtkEntry* _tmp2;
		GtkListStore* _tmp3;
		GHashTable* _tmp4;
		GtkComboBox* _tmp7;
		GtkCellRenderer* _tmp8;
		GtkCellRenderer* _tmp9;
		renderer = NULL;
		_tmp0 = NULL;
		option = (_tmp0 = FLEGITA_OPTION_OUTPUT_FILENAME (gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self)), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
		gnome_scan_option_widget_set_no_label ((GnomeScanOptionWidget*) self, TRUE);
		gnome_scan_option_widget_set_expand ((GnomeScanOptionWidget*) self, FALSE);
		g_signal_connect_object ((GObject*) gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), "notify::value", (GCallback) _flegita_output_filename_widget_parse_filename_g_object_notify, self, 0);
		box = (GtkBox*) g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6));
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) box, TRUE, TRUE, (guint) 0);
		/* directory selector*/
		_tmp1 = NULL;
		self->priv->filechooser = (_tmp1 = (GtkFileChooser*) g_object_ref_sink ((GtkFileChooserButton*) gtk_file_chooser_button_new (_ ("Select output directory"), GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER)), (self->priv->filechooser == NULL) ? NULL : (self->priv->filechooser = (g_object_unref (self->priv->filechooser), NULL)), _tmp1);
		gtk_box_pack_start (box, (GtkWidget*) self->priv->filechooser, TRUE, TRUE, (guint) 0);
		/* filename entry*/
		_tmp2 = NULL;
		self->priv->entry = (_tmp2 = g_object_ref_sink ((GtkEntry*) gtk_entry_new ()), (self->priv->entry == NULL) ? NULL : (self->priv->entry = (g_object_unref (self->priv->entry), NULL)), _tmp2);
		gtk_box_pack_start (box, (GtkWidget*) self->priv->entry, TRUE, TRUE, (guint) 0);
		/* format store*/
		_tmp3 = NULL;
		self->priv->formats = (_tmp3 = gtk_list_store_new ((gint) FLEGITA_FORMAT_COLUMNS_N, G_TYPE_STRING, G_TYPE_STRING, NULL), (self->priv->formats == NULL) ? NULL : (self->priv->formats = (g_object_unref (self->priv->formats), NULL)), _tmp3);
		_tmp4 = NULL;
		self->priv->format_paths = (_tmp4 = g_hash_table_new (g_str_hash, g_str_equal), (self->priv->format_paths == NULL) ? NULL : (self->priv->format_paths = (g_hash_table_unref (self->priv->format_paths), NULL)), _tmp4);
		{
			GSList* format_collection;
			GSList* format_it;
			format_collection = flegita_option_output_filename_list_formats (option);
			for (format_it = format_collection; format_it != NULL; format_it = format_it->next) {
				GnomeScanFormat* _tmp6;
				GnomeScanFormat* format;
				_tmp6 = NULL;
				format = (_tmp6 = (GnomeScanFormat*) format_it->data, (_tmp6 == NULL) ? NULL : g_object_ref (_tmp6));
				{
					GtkTreePath* path;
					const char* _tmp5;
					gtk_list_store_append (self->priv->formats, &iter);
					gtk_list_store_set (self->priv->formats, &iter, FLEGITA_FORMAT_COLUMNS_ICON, format->icon_name, FLEGITA_FORMAT_COLUMNS_SUFFIX, format->suffixes[0], -1);
					path = gtk_tree_model_get_path ((GtkTreeModel*) self->priv->formats, &iter);
					_tmp5 = NULL;
					g_hash_table_insert (self->priv->format_paths, g_strdup_printf (".%s", format->suffixes[0]), (_tmp5 = gtk_tree_path_to_string (path), (_tmp5 == NULL) ? NULL : g_strdup (_tmp5)));
					(format == NULL) ? NULL : (format = (g_object_unref (format), NULL));
					(path == NULL) ? NULL : (path = (gtk_tree_path_free (path), NULL));
				}
			}
		}
		/* format selector*/
		_tmp7 = NULL;
		self->priv->combobox = (_tmp7 = g_object_ref_sink ((GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) self->priv->formats)), (self->priv->combobox == NULL) ? NULL : (self->priv->combobox = (g_object_unref (self->priv->combobox), NULL)), _tmp7);
		gtk_box_pack_start (box, (GtkWidget*) self->priv->combobox, FALSE, FALSE, (guint) 0);
		_tmp8 = NULL;
		renderer = (_tmp8 = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ()), (renderer == NULL) ? NULL : (renderer = (g_object_unref (renderer), NULL)), _tmp8);
		gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->combobox, renderer, FALSE);
		gtk_cell_layout_set_attributes ((GtkCellLayout*) self->priv->combobox, renderer, "icon-name", FLEGITA_FORMAT_COLUMNS_ICON, NULL);
		_tmp9 = NULL;
		renderer = (_tmp9 = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ()), (renderer == NULL) ? NULL : (renderer = (g_object_unref (renderer), NULL)), _tmp9);
		gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->combobox, renderer, TRUE);
		gtk_cell_layout_set_attributes ((GtkCellLayout*) self->priv->combobox, renderer, "text", FLEGITA_FORMAT_COLUMNS_SUFFIX, NULL);
		g_signal_connect_object (self->priv->filechooser, "selection-changed", (GCallback) _flegita_output_filename_widget_update_filename_gtk_file_chooser_selection_changed, self, 0);
		g_signal_connect_object ((GtkEditable*) self->priv->entry, "changed", (GCallback) _flegita_output_filename_widget_update_filename_gtk_editable_changed, self, 0);
		g_signal_connect_object (self->priv->combobox, "changed", (GCallback) _flegita_output_filename_widget_update_filename_gtk_combo_box_changed, self, 0);
		flegita_output_filename_widget_parse_filename (self);
		(renderer == NULL) ? NULL : (renderer = (g_object_unref (renderer), NULL));
		(option == NULL) ? NULL : (option = (g_object_unref (option), NULL));
		(box == NULL) ? NULL : (box = (g_object_unref (box), NULL));
	}
	return obj;
}


static void flegita_output_filename_widget_class_init (FlegitaOutputFilenameWidgetClass * klass) {
	flegita_output_filename_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (FlegitaOutputFilenameWidgetPrivate));
	G_OBJECT_CLASS (klass)->constructor = flegita_output_filename_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = flegita_output_filename_widget_finalize;
}


static void flegita_output_filename_widget_instance_init (FlegitaOutputFilenameWidget * self) {
	self->priv = FLEGITA_OUTPUT_FILENAME_WIDGET_GET_PRIVATE (self);
	self->priv->inhibit = FALSE;
}


static void flegita_output_filename_widget_finalize (GObject* obj) {
	FlegitaOutputFilenameWidget * self;
	self = FLEGITA_OUTPUT_FILENAME_WIDGET (obj);
	(self->priv->entry == NULL) ? NULL : (self->priv->entry = (g_object_unref (self->priv->entry), NULL));
	(self->priv->filechooser == NULL) ? NULL : (self->priv->filechooser = (g_object_unref (self->priv->filechooser), NULL));
	(self->priv->formats == NULL) ? NULL : (self->priv->formats = (g_object_unref (self->priv->formats), NULL));
	(self->priv->combobox == NULL) ? NULL : (self->priv->combobox = (g_object_unref (self->priv->combobox), NULL));
	(self->priv->format_paths == NULL) ? NULL : (self->priv->format_paths = (g_hash_table_unref (self->priv->format_paths), NULL));
	G_OBJECT_CLASS (flegita_output_filename_widget_parent_class)->finalize (obj);
}


GType flegita_output_filename_widget_get_type (void) {
	static GType flegita_output_filename_widget_type_id = 0;
	if (flegita_output_filename_widget_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (FlegitaOutputFilenameWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) flegita_output_filename_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FlegitaOutputFilenameWidget), 0, (GInstanceInitFunc) flegita_output_filename_widget_instance_init, NULL };
		flegita_output_filename_widget_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION_WIDGET, "FlegitaOutputFilenameWidget", &g_define_type_info, 0);
	}
	return flegita_output_filename_widget_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		if (array_length >= 0)
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL)
			destroy_func (((gpointer*) array)[i]);
		}
		else
		for (i = 0; ((gpointer*) array)[i] != NULL; i = i + 1) {
			destroy_func (((gpointer*) array)[i]);
		}
	}
	g_free (array);
}




