/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <gnome-scan-sink.h>
#include <stdlib.h>
#include <string.h>




enum  {
	GNOME_SCAN_SINK_DUMMY_PROPERTY
};
static void gnome_scan_sink_real_finalize_process (GnomeScanSink* self);
static gpointer gnome_scan_sink_parent_class = NULL;



static void gnome_scan_sink_real_finalize_process (GnomeScanSink* self) {
	g_return_if_fail (self != NULL);
	g_debug ("gnome-scan-sink.vala:28: Finalizing process");
}


void gnome_scan_sink_finalize_process (GnomeScanSink* self) {
	GNOME_SCAN_SINK_GET_CLASS (self)->finalize_process (self);
}


GnomeScanSink* gnome_scan_sink_construct (GType object_type) {
	GnomeScanSink * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GnomeScanSink* gnome_scan_sink_new (void) {
	return gnome_scan_sink_construct (GNOME_SCAN_TYPE_SINK);
}


static void gnome_scan_sink_class_init (GnomeScanSinkClass * klass) {
	gnome_scan_sink_parent_class = g_type_class_peek_parent (klass);
	GNOME_SCAN_SINK_CLASS (klass)->finalize_process = gnome_scan_sink_real_finalize_process;
}


static void gnome_scan_sink_instance_init (GnomeScanSink * self) {
}


GType gnome_scan_sink_get_type (void) {
	static GType gnome_scan_sink_type_id = 0;
	if (gnome_scan_sink_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanSinkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_sink_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanSink), 0, (GInstanceInitFunc) gnome_scan_sink_instance_init, NULL };
		gnome_scan_sink_type_id = g_type_register_static (GNOME_SCAN_TYPE_NODE, "GnomeScanSink", &g_define_type_info, 0);
	}
	return gnome_scan_sink_type_id;
}




