/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <gnome-scan-scale-widget.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <gnome-scan-option.h>




struct _GnomeScanScaleWidgetPrivate {
	GtkAdjustment* adj;
};

#define GNOME_SCAN_SCALE_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_SCALE_WIDGET, GnomeScanScaleWidgetPrivate))
enum  {
	GNOME_SCAN_SCALE_WIDGET_DUMMY_PROPERTY
};
static void gnome_scan_scale_widget_on_int_option_value_changed (GnomeScanScaleWidget* self);
static void gnome_scan_scale_widget_on_int_adj_value_changed (GnomeScanScaleWidget* self);
static void gnome_scan_scale_widget_on_double_option_value_changed (GnomeScanScaleWidget* self);
static void gnome_scan_scale_widget_on_double_adj_value_changed (GnomeScanScaleWidget* self);
static void _gnome_scan_scale_widget_on_int_adj_value_changed_g_object_notify (GtkAdjustment* _sender, GParamSpec* pspec, gpointer self);
static void _gnome_scan_scale_widget_on_int_option_value_changed_g_object_notify (GnomeScanOptionInt* _sender, GParamSpec* pspec, gpointer self);
static void _gnome_scan_scale_widget_on_double_adj_value_changed_g_object_notify (GtkAdjustment* _sender, GParamSpec* pspec, gpointer self);
static void _gnome_scan_scale_widget_on_double_option_value_changed_g_object_notify (GnomeScanOptionDouble* _sender, GParamSpec* pspec, gpointer self);
static GObject * gnome_scan_scale_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer gnome_scan_scale_widget_parent_class = NULL;
static void gnome_scan_scale_widget_finalize (GObject* obj);



static void gnome_scan_scale_widget_on_int_option_value_changed (GnomeScanScaleWidget* self) {
	GnomeScanOptionInt* _tmp1;
	GnomeScanOption* _tmp0;
	GnomeScanOptionInt* option;
	g_return_if_fail (self != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	option = (_tmp1 = (_tmp0 = gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), GNOME_SCAN_IS_OPTION_INT (_tmp0) ? ((GnomeScanOptionInt*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1));
	gtk_adjustment_set_value (self->priv->adj, (double) gnome_scan_option_int_get_value (option));
	(option == NULL) ? NULL : (option = (g_object_unref (option), NULL));
}


static void gnome_scan_scale_widget_on_int_adj_value_changed (GnomeScanScaleWidget* self) {
	GnomeScanOptionInt* _tmp1;
	GnomeScanOption* _tmp0;
	GnomeScanOptionInt* option;
	g_return_if_fail (self != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	option = (_tmp1 = (_tmp0 = gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), GNOME_SCAN_IS_OPTION_INT (_tmp0) ? ((GnomeScanOptionInt*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1));
	gnome_scan_option_int_set_value (option, (gint) gtk_adjustment_get_value (self->priv->adj));
	(option == NULL) ? NULL : (option = (g_object_unref (option), NULL));
}


static void gnome_scan_scale_widget_on_double_option_value_changed (GnomeScanScaleWidget* self) {
	GnomeScanOptionDouble* _tmp1;
	GnomeScanOption* _tmp0;
	GnomeScanOptionDouble* option;
	g_return_if_fail (self != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	option = (_tmp1 = (_tmp0 = gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), GNOME_SCAN_IS_OPTION_DOUBLE (_tmp0) ? ((GnomeScanOptionDouble*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1));
	gtk_adjustment_set_value (self->priv->adj, gnome_scan_option_double_get_value (option));
	(option == NULL) ? NULL : (option = (g_object_unref (option), NULL));
}


static void gnome_scan_scale_widget_on_double_adj_value_changed (GnomeScanScaleWidget* self) {
	GnomeScanOptionDouble* _tmp1;
	GnomeScanOption* _tmp0;
	GnomeScanOptionDouble* option;
	g_return_if_fail (self != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	option = (_tmp1 = (_tmp0 = gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), GNOME_SCAN_IS_OPTION_DOUBLE (_tmp0) ? ((GnomeScanOptionDouble*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1));
	gnome_scan_option_double_set_value (option, gtk_adjustment_get_value (self->priv->adj));
	(option == NULL) ? NULL : (option = (g_object_unref (option), NULL));
}


GnomeScanScaleWidget* gnome_scan_scale_widget_construct (GType object_type) {
	GnomeScanScaleWidget * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GnomeScanScaleWidget* gnome_scan_scale_widget_new (void) {
	return gnome_scan_scale_widget_construct (GNOME_SCAN_TYPE_SCALE_WIDGET);
}


static void _gnome_scan_scale_widget_on_int_adj_value_changed_g_object_notify (GtkAdjustment* _sender, GParamSpec* pspec, gpointer self) {
	gnome_scan_scale_widget_on_int_adj_value_changed (self);
}


static void _gnome_scan_scale_widget_on_int_option_value_changed_g_object_notify (GnomeScanOptionInt* _sender, GParamSpec* pspec, gpointer self) {
	gnome_scan_scale_widget_on_int_option_value_changed (self);
}


static void _gnome_scan_scale_widget_on_double_adj_value_changed_g_object_notify (GtkAdjustment* _sender, GParamSpec* pspec, gpointer self) {
	gnome_scan_scale_widget_on_double_adj_value_changed (self);
}


static void _gnome_scan_scale_widget_on_double_option_value_changed_g_object_notify (GnomeScanOptionDouble* _sender, GParamSpec* pspec, gpointer self) {
	gnome_scan_scale_widget_on_double_option_value_changed (self);
}


static GObject * gnome_scan_scale_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GnomeScanScaleWidgetClass * klass;
	GObjectClass * parent_class;
	GnomeScanScaleWidget * self;
	klass = GNOME_SCAN_SCALE_WIDGET_CLASS (g_type_class_peek (GNOME_SCAN_TYPE_SCALE_WIDGET));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GNOME_SCAN_SCALE_WIDGET (obj);
	{
		GtkSpinButton* spin;
		GtkScale* scale;
		gint digits;
		gnome_scan_option_widget_set_expand ((GnomeScanOptionWidget*) self, FALSE);
		gnome_scan_option_widget_set_no_label ((GnomeScanOptionWidget*) self, FALSE);
		spin = NULL;
		scale = NULL;
		digits = 0;
		if (GNOME_SCAN_IS_OPTION_INT (gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self))) {
			GnomeScanOptionInt* _tmp1;
			GnomeScanOption* _tmp0;
			GnomeScanOptionInt* option;
			GtkAdjustment* _tmp2;
			GtkScale* _tmp3;
			GtkSpinButton* _tmp4;
			_tmp1 = NULL;
			_tmp0 = NULL;
			option = (_tmp1 = (_tmp0 = gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), GNOME_SCAN_IS_OPTION_INT (_tmp0) ? ((GnomeScanOptionInt*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1));
			_tmp2 = NULL;
			self->priv->adj = (_tmp2 = g_object_ref_sink ((GtkAdjustment*) gtk_adjustment_new ((double) gnome_scan_option_int_get_value (option), (double) gnome_scan_option_int_get_min (option), (double) gnome_scan_option_int_get_max (option), (double) gnome_scan_option_int_get_step (option), (double) gnome_scan_option_int_get_step (option), (double) 0)), (self->priv->adj == NULL) ? NULL : (self->priv->adj = (g_object_unref (self->priv->adj), NULL)), _tmp2);
			_tmp3 = NULL;
			scale = (_tmp3 = (GtkScale*) g_object_ref_sink ((GtkHScale*) gtk_hscale_new (self->priv->adj)), (scale == NULL) ? NULL : (scale = (g_object_unref (scale), NULL)), _tmp3);
			gtk_scale_set_draw_value (scale, FALSE);
			gtk_scale_set_digits (scale, digits);
			_tmp4 = NULL;
			spin = (_tmp4 = g_object_ref_sink ((GtkSpinButton*) gtk_spin_button_new (self->priv->adj, (double) gnome_scan_option_int_get_step (option), (guint) digits)), (spin == NULL) ? NULL : (spin = (g_object_unref (spin), NULL)), _tmp4);
			g_signal_connect_object ((GObject*) self->priv->adj, "notify::value", (GCallback) _gnome_scan_scale_widget_on_int_adj_value_changed_g_object_notify, self, 0);
			g_signal_connect_object ((GObject*) option, "notify::value", (GCallback) _gnome_scan_scale_widget_on_int_option_value_changed_g_object_notify, self, 0);
			(option == NULL) ? NULL : (option = (g_object_unref (option), NULL));
		} else {
			if (GNOME_SCAN_IS_OPTION_DOUBLE (gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self))) {
				GnomeScanOptionDouble* _tmp6;
				GnomeScanOption* _tmp5;
				GnomeScanOptionDouble* option;
				GtkAdjustment* _tmp7;
				GtkScale* _tmp8;
				GtkSpinButton* _tmp9;
				_tmp6 = NULL;
				_tmp5 = NULL;
				option = (_tmp6 = (_tmp5 = gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), GNOME_SCAN_IS_OPTION_DOUBLE (_tmp5) ? ((GnomeScanOptionDouble*) _tmp5) : NULL), (_tmp6 == NULL) ? NULL : g_object_ref (_tmp6));
				if (gnome_scan_option_double_get_step (option) < 1.0) {
					digits = 2;
				}
				_tmp7 = NULL;
				self->priv->adj = (_tmp7 = g_object_ref_sink ((GtkAdjustment*) gtk_adjustment_new (gnome_scan_option_double_get_value (option), gnome_scan_option_double_get_min (option), gnome_scan_option_double_get_max (option), gnome_scan_option_double_get_step (option), gnome_scan_option_double_get_step (option), (double) 0)), (self->priv->adj == NULL) ? NULL : (self->priv->adj = (g_object_unref (self->priv->adj), NULL)), _tmp7);
				_tmp8 = NULL;
				scale = (_tmp8 = (GtkScale*) g_object_ref_sink ((GtkHScale*) gtk_hscale_new (self->priv->adj)), (scale == NULL) ? NULL : (scale = (g_object_unref (scale), NULL)), _tmp8);
				gtk_scale_set_draw_value (scale, FALSE);
				gtk_scale_set_digits (scale, digits);
				_tmp9 = NULL;
				spin = (_tmp9 = g_object_ref_sink ((GtkSpinButton*) gtk_spin_button_new (self->priv->adj, gnome_scan_option_double_get_step (option), (guint) digits)), (spin == NULL) ? NULL : (spin = (g_object_unref (spin), NULL)), _tmp9);
				g_signal_connect_object ((GObject*) self->priv->adj, "notify::value", (GCallback) _gnome_scan_scale_widget_on_double_adj_value_changed_g_object_notify, self, 0);
				g_signal_connect_object ((GObject*) option, "notify::value", (GCallback) _gnome_scan_scale_widget_on_double_option_value_changed_g_object_notify, self, 0);
				(option == NULL) ? NULL : (option = (g_object_unref (option), NULL));
			}
		}
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) scale, TRUE, TRUE, (guint) 0);
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) spin, FALSE, TRUE, (guint) 0);
		(spin == NULL) ? NULL : (spin = (g_object_unref (spin), NULL));
		(scale == NULL) ? NULL : (scale = (g_object_unref (scale), NULL));
	}
	return obj;
}


static void gnome_scan_scale_widget_class_init (GnomeScanScaleWidgetClass * klass) {
	gnome_scan_scale_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanScaleWidgetPrivate));
	G_OBJECT_CLASS (klass)->constructor = gnome_scan_scale_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_scale_widget_finalize;
}


static void gnome_scan_scale_widget_instance_init (GnomeScanScaleWidget * self) {
	self->priv = GNOME_SCAN_SCALE_WIDGET_GET_PRIVATE (self);
}


static void gnome_scan_scale_widget_finalize (GObject* obj) {
	GnomeScanScaleWidget * self;
	self = GNOME_SCAN_SCALE_WIDGET (obj);
	(self->priv->adj == NULL) ? NULL : (self->priv->adj = (g_object_unref (self->priv->adj), NULL));
	G_OBJECT_CLASS (gnome_scan_scale_widget_parent_class)->finalize (obj);
}


GType gnome_scan_scale_widget_get_type (void) {
	static GType gnome_scan_scale_widget_type_id = 0;
	if (gnome_scan_scale_widget_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanScaleWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_scale_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanScaleWidget), 0, (GInstanceInitFunc) gnome_scan_scale_widget_instance_init, NULL };
		gnome_scan_scale_widget_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION_WIDGET, "GnomeScanScaleWidget", &g_define_type_info, 0);
	}
	return gnome_scan_scale_widget_type_id;
}




