/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#ifndef __GNOME_SCAN_OPTION_WIDGET_H__
#define __GNOME_SCAN_OPTION_WIDGET_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gnome-scan-option.h>

G_BEGIN_DECLS


#define GNOME_SCAN_TYPE_OPTION_WIDGET (gnome_scan_option_widget_get_type ())
#define GNOME_SCAN_OPTION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidget))
#define GNOME_SCAN_OPTION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidgetClass))
#define GNOME_SCAN_IS_OPTION_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET))
#define GNOME_SCAN_IS_OPTION_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_SCAN_TYPE_OPTION_WIDGET))
#define GNOME_SCAN_OPTION_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_SCAN_TYPE_OPTION_WIDGET, GnomeScanOptionWidgetClass))

typedef struct _GnomeScanOptionWidget GnomeScanOptionWidget;
typedef struct _GnomeScanOptionWidgetClass GnomeScanOptionWidgetClass;
typedef struct _GnomeScanOptionWidgetPrivate GnomeScanOptionWidgetPrivate;

/** GnomeScanOptionWidget:
 *
 * A #GnomeScanOptionWidget expose a #GnomeScanOption to user
 * and pass user defined value to #GnomeScanSettings.
 
 TODO: with Gtk+ 2.16, herits directly from Box and let children
 decide orientation using GtkOrientable.*/
struct _GnomeScanOptionWidget {
	GtkHBox parent_instance;
	GnomeScanOptionWidgetPrivate * priv;
};

struct _GnomeScanOptionWidgetClass {
	GtkHBoxClass parent_class;
};


GnomeScanOptionWidget* gnome_scan_option_widget_construct (GType object_type, GnomeScanOption* option);
GnomeScanOptionWidget* gnome_scan_option_widget_new (GnomeScanOption* option);
GnomeScanOption* gnome_scan_option_widget_get_option (GnomeScanOptionWidget* self);
void gnome_scan_option_widget_set_option (GnomeScanOptionWidget* self, GnomeScanOption* value);
gboolean gnome_scan_option_widget_get_no_label (GnomeScanOptionWidget* self);
void gnome_scan_option_widget_set_no_label (GnomeScanOptionWidget* self, gboolean value);
gboolean gnome_scan_option_widget_get_expand (GnomeScanOptionWidget* self);
void gnome_scan_option_widget_set_expand (GnomeScanOptionWidget* self, gboolean value);
GType gnome_scan_option_widget_get_type (void);


G_END_DECLS

#endif
