/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <gnome-scan-option-page.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <gnome-scan-option-box.h>




struct _GnomeScanOptionPagePrivate {
	gboolean _scrolled;
	GtkBox* _container;
	GtkScrolledWindow* scrowin;
	GtkViewport* viewport;
	GHashTable* boxes;
	gint scroll_height;
	gint scroll_width;
	gint box_visible_count;
	gint box_expanding_count;
};

#define GNOME_SCAN_OPTION_PAGE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_OPTION_PAGE, GnomeScanOptionPagePrivate))
enum  {
	GNOME_SCAN_OPTION_PAGE_DUMMY_PROPERTY,
	GNOME_SCAN_OPTION_PAGE_SCROLLED,
	GNOME_SCAN_OPTION_PAGE_CONTAINER
};
static void _gnome_scan_option_page_on_box_visibility_changed_gtk_widget_hide (GnomeScanOptionBox* _sender, gpointer self);
static void _gnome_scan_option_page_on_box_visibility_changed_gtk_widget_show (GnomeScanOptionBox* _sender, gpointer self);
static void gnome_scan_option_page_on_box_visibility_changed (GnomeScanOptionPage* self, GnomeScanOptionBox* box);
static void gnome_scan_option_page_update_shadow_type (GnomeScanOptionPage* self);
static void gnome_scan_option_page_on_size_allocate (GnomeScanOptionPage* self, GtkScrolledWindow* scrowin, const GdkRectangle* alloc);
static void gnome_scan_option_page_on_viewport_size_allocate (GnomeScanOptionPage* self, GtkViewport* vp, const GdkRectangle* alloc);
static void _gnome_scan_option_page_on_size_allocate_gtk_widget_size_allocate (GtkScrolledWindow* _sender, const GdkRectangle* allocation, gpointer self);
static void _gnome_scan_option_page_on_viewport_size_allocate_gtk_widget_size_allocate (GtkViewport* _sender, const GdkRectangle* allocation, gpointer self);
static GObject * gnome_scan_option_page_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer gnome_scan_option_page_parent_class = NULL;
static void gnome_scan_option_page_finalize (GObject* obj);
enum  {
	GNOME_SCAN_OPTION_VPAGE_DUMMY_PROPERTY
};
static GObject * gnome_scan_option_vpage_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer gnome_scan_option_vpage_parent_class = NULL;
enum  {
	GNOME_SCAN_OPTION_HPAGE_DUMMY_PROPERTY
};
static GObject * gnome_scan_option_hpage_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer gnome_scan_option_hpage_parent_class = NULL;



static void _gnome_scan_option_page_on_box_visibility_changed_gtk_widget_hide (GnomeScanOptionBox* _sender, gpointer self) {
	gnome_scan_option_page_on_box_visibility_changed (self, _sender);
}


static void _gnome_scan_option_page_on_box_visibility_changed_gtk_widget_show (GnomeScanOptionBox* _sender, gpointer self) {
	gnome_scan_option_page_on_box_visibility_changed (self, _sender);
}


void gnome_scan_option_page_pack_option (GnomeScanOptionPage* self, GnomeScanOption* option) {
	GnomeScanOptionBox* _tmp0;
	GnomeScanOptionBox* box;
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	_tmp0 = NULL;
	box = (_tmp0 = (GnomeScanOptionBox*) g_hash_table_lookup (self->priv->boxes, gnome_scan_option_get_group (option)), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	if (box == NULL) {
		GnomeScanOptionBox* _tmp1;
		GnomeScanOptionBox* _tmp3;
		const char* _tmp2;
		_tmp1 = NULL;
		box = (_tmp1 = g_object_ref_sink (gnome_scan_option_box_new (gnome_scan_option_get_group (option))), (box == NULL) ? NULL : (box = (g_object_unref (box), NULL)), _tmp1);
		g_signal_connect_object ((GtkWidget*) box, "hide", (GCallback) _gnome_scan_option_page_on_box_visibility_changed_gtk_widget_hide, self, 0);
		g_signal_connect_object ((GtkWidget*) box, "show", (GCallback) _gnome_scan_option_page_on_box_visibility_changed_gtk_widget_show, self, 0);
		self->priv->box_visible_count++;
		gtk_box_pack_start (gnome_scan_option_page_get_container (self), (GtkWidget*) box, gnome_scan_option_box_get_expand (box), TRUE, (guint) 0);
		_tmp3 = NULL;
		_tmp2 = NULL;
		g_hash_table_insert (self->priv->boxes, (_tmp2 = gnome_scan_option_get_group (option), (_tmp2 == NULL) ? NULL : g_strdup (_tmp2)), (_tmp3 = box, (_tmp3 == NULL) ? NULL : g_object_ref (_tmp3)));
		gnome_scan_option_page_on_box_visibility_changed (self, box);
	}
	gnome_scan_option_box_pack_option (box, option);
	(box == NULL) ? NULL : (box = (g_object_unref (box), NULL));
}


void gnome_scan_option_page_unpack_option (GnomeScanOptionPage* self, GnomeScanOption* option) {
	GnomeScanOptionBox* box;
	g_return_if_fail (self != NULL);
	g_return_if_fail (option != NULL);
	box = (GnomeScanOptionBox*) g_hash_table_lookup (self->priv->boxes, gnome_scan_option_get_group (option));
	if (gnome_scan_option_box_unpack_option (box, option)) {
		gtk_container_remove ((GtkContainer*) gnome_scan_option_page_get_container (self), (GtkWidget*) box);
		g_hash_table_remove (self->priv->boxes, gnome_scan_option_get_group (option));
	}
}


static void gnome_scan_option_page_on_box_visibility_changed (GnomeScanOptionPage* self, GnomeScanOptionBox* box) {
	gint _tmp3;
	gboolean _tmp4;
	g_return_if_fail (self != NULL);
	g_return_if_fail (box != NULL);
	if (gnome_scan_option_box_get_expand (box)) {
		gint _tmp0;
		gboolean _tmp1;
		GtkContainer* _tmp2;
		GtkContainer* parent;
		_tmp0 = 0;
		if ((g_object_get ((GtkWidget*) box, "visible", &_tmp1, NULL), _tmp1)) {
			_tmp0 = +1;
		} else {
			_tmp0 = -1;
		}
		self->priv->box_expanding_count = self->priv->box_expanding_count + (_tmp0);
		_tmp2 = NULL;
		parent = (_tmp2 = GTK_CONTAINER (gtk_widget_get_parent ((GtkWidget*) self)), (_tmp2 == NULL) ? NULL : g_object_ref (_tmp2));
		gtk_container_child_set (parent, (GtkWidget*) self, "expand", self->priv->box_expanding_count > 0, NULL);
		(parent == NULL) ? NULL : (parent = (g_object_unref (parent), NULL));
	}
	_tmp3 = 0;
	if ((g_object_get ((GtkWidget*) box, "visible", &_tmp4, NULL), _tmp4)) {
		_tmp3 = +1;
	} else {
		_tmp3 = -1;
	}
	self->priv->box_visible_count = self->priv->box_visible_count + (_tmp3);
	if (self->priv->box_visible_count == 0) {
		gtk_widget_set_no_show_all ((GtkWidget*) self, TRUE);
		gtk_widget_hide ((GtkWidget*) self);
	} else {
		gtk_widget_set_no_show_all ((GtkWidget*) self, FALSE);
		gtk_widget_show_all ((GtkWidget*) self);
	}
}


static void gnome_scan_option_page_update_shadow_type (GnomeScanOptionPage* self) {
	GtkRequisition req = {0};
	gboolean _tmp0;
	g_return_if_fail (self != NULL);
	gtk_widget_size_request ((GtkWidget*) self->priv->viewport, &req);
	_tmp0 = FALSE;
	if (self->priv->scroll_height < req.height) {
		_tmp0 = TRUE;
	} else {
		_tmp0 = self->priv->scroll_width < req.width;
	}
	if (_tmp0) {
		gtk_scrolled_window_set_shadow_type (self->priv->scrowin, GTK_SHADOW_IN);
	} else {
		gtk_scrolled_window_set_shadow_type (self->priv->scrowin, GTK_SHADOW_NONE);
	}
}


static void gnome_scan_option_page_on_size_allocate (GnomeScanOptionPage* self, GtkScrolledWindow* scrowin, const GdkRectangle* alloc) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (scrowin != NULL);
	self->priv->scroll_height = (*alloc).height;
	self->priv->scroll_width = (*alloc).width;
	gnome_scan_option_page_update_shadow_type (self);
}


static void gnome_scan_option_page_on_viewport_size_allocate (GnomeScanOptionPage* self, GtkViewport* vp, const GdkRectangle* alloc) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (vp != NULL);
	gnome_scan_option_page_update_shadow_type (self);
}


gboolean gnome_scan_option_page_get_scrolled (GnomeScanOptionPage* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return self->priv->_scrolled;
}


void gnome_scan_option_page_set_scrolled (GnomeScanOptionPage* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_scrolled = value;
	g_object_notify ((GObject *) self, "scrolled");
}


GtkBox* gnome_scan_option_page_get_container (GnomeScanOptionPage* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_container;
}


void gnome_scan_option_page_set_container (GnomeScanOptionPage* self, GtkBox* value) {
	GtkBox* _tmp2;
	GtkBox* _tmp1;
	g_return_if_fail (self != NULL);
	if (self->priv->_scrolled) {
		gtk_container_set_border_width ((GtkContainer*) value, (guint) 6);
		gtk_container_add ((GtkContainer*) self->priv->viewport, (GtkWidget*) value);
	} else {
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) value);
	}
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_container = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_container == NULL) ? NULL : (self->priv->_container = (g_object_unref (self->priv->_container), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "container");
}


static void _gnome_scan_option_page_on_size_allocate_gtk_widget_size_allocate (GtkScrolledWindow* _sender, const GdkRectangle* allocation, gpointer self) {
	gnome_scan_option_page_on_size_allocate (self, _sender, allocation);
}


static void _gnome_scan_option_page_on_viewport_size_allocate_gtk_widget_size_allocate (GtkViewport* _sender, const GdkRectangle* allocation, gpointer self) {
	gnome_scan_option_page_on_viewport_size_allocate (self, _sender, allocation);
}


static GObject * gnome_scan_option_page_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GnomeScanOptionPageClass * klass;
	GObjectClass * parent_class;
	GnomeScanOptionPage * self;
	klass = GNOME_SCAN_OPTION_PAGE_CLASS (g_type_class_peek (GNOME_SCAN_TYPE_OPTION_PAGE));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GNOME_SCAN_OPTION_PAGE (obj);
	{
		GHashTable* _tmp0;
		_tmp0 = NULL;
		self->priv->boxes = (_tmp0 = g_hash_table_new (g_str_hash, g_str_equal), (self->priv->boxes == NULL) ? NULL : (self->priv->boxes = (g_hash_table_unref (self->priv->boxes), NULL)), _tmp0);
		gtk_widget_set_no_show_all ((GtkWidget*) self, TRUE);
		if (self->priv->_scrolled) {
			GtkScrolledWindow* _tmp1;
			GtkViewport* _tmp2;
			gtk_container_set_border_width ((GtkContainer*) self, (guint) 6);
			_tmp1 = NULL;
			self->priv->scrowin = (_tmp1 = g_object_ref_sink ((GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL)), (self->priv->scrowin == NULL) ? NULL : (self->priv->scrowin = (g_object_unref (self->priv->scrowin), NULL)), _tmp1);
			gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->scrowin);
			gtk_scrolled_window_set_shadow_type (self->priv->scrowin, GTK_SHADOW_NONE);
			g_object_set (self->priv->scrowin, "hscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL);
			g_object_set (self->priv->scrowin, "vscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL);
			_tmp2 = NULL;
			self->priv->viewport = (_tmp2 = g_object_ref_sink ((GtkViewport*) gtk_viewport_new (gtk_scrolled_window_get_hadjustment (self->priv->scrowin), gtk_scrolled_window_get_vadjustment (self->priv->scrowin))), (self->priv->viewport == NULL) ? NULL : (self->priv->viewport = (g_object_unref (self->priv->viewport), NULL)), _tmp2);
			gtk_viewport_set_shadow_type (self->priv->viewport, GTK_SHADOW_NONE);
			gtk_container_add ((GtkContainer*) self->priv->scrowin, (GtkWidget*) self->priv->viewport);
			g_signal_connect_object ((GtkWidget*) self->priv->scrowin, "size-allocate", (GCallback) _gnome_scan_option_page_on_size_allocate_gtk_widget_size_allocate, self, 0);
			g_signal_connect_object ((GtkWidget*) self->priv->viewport, "size-allocate", (GCallback) _gnome_scan_option_page_on_viewport_size_allocate_gtk_widget_size_allocate, self, 0);
		}
	}
	return obj;
}


static void gnome_scan_option_page_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GnomeScanOptionPage * self;
	gpointer boxed;
	self = GNOME_SCAN_OPTION_PAGE (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_PAGE_SCROLLED:
		g_value_set_boolean (value, gnome_scan_option_page_get_scrolled (self));
		break;
		case GNOME_SCAN_OPTION_PAGE_CONTAINER:
		g_value_set_object (value, gnome_scan_option_page_get_container (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_page_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GnomeScanOptionPage * self;
	self = GNOME_SCAN_OPTION_PAGE (object);
	switch (property_id) {
		case GNOME_SCAN_OPTION_PAGE_SCROLLED:
		gnome_scan_option_page_set_scrolled (self, g_value_get_boolean (value));
		break;
		case GNOME_SCAN_OPTION_PAGE_CONTAINER:
		gnome_scan_option_page_set_container (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gnome_scan_option_page_class_init (GnomeScanOptionPageClass * klass) {
	gnome_scan_option_page_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanOptionPagePrivate));
	G_OBJECT_CLASS (klass)->get_property = gnome_scan_option_page_get_property;
	G_OBJECT_CLASS (klass)->set_property = gnome_scan_option_page_set_property;
	G_OBJECT_CLASS (klass)->constructor = gnome_scan_option_page_constructor;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_option_page_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_PAGE_SCROLLED, g_param_spec_boolean ("scrolled", "scrolled", "scrolled", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GNOME_SCAN_OPTION_PAGE_CONTAINER, g_param_spec_object ("container", "container", "container", GTK_TYPE_BOX, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void gnome_scan_option_page_instance_init (GnomeScanOptionPage * self) {
	self->priv = GNOME_SCAN_OPTION_PAGE_GET_PRIVATE (self);
	self->priv->_scrolled = FALSE;
	self->priv->box_visible_count = 0;
	self->priv->box_expanding_count = 0;
}


static void gnome_scan_option_page_finalize (GObject* obj) {
	GnomeScanOptionPage * self;
	self = GNOME_SCAN_OPTION_PAGE (obj);
	(self->priv->_container == NULL) ? NULL : (self->priv->_container = (g_object_unref (self->priv->_container), NULL));
	(self->priv->scrowin == NULL) ? NULL : (self->priv->scrowin = (g_object_unref (self->priv->scrowin), NULL));
	(self->priv->viewport == NULL) ? NULL : (self->priv->viewport = (g_object_unref (self->priv->viewport), NULL));
	(self->priv->boxes == NULL) ? NULL : (self->priv->boxes = (g_hash_table_unref (self->priv->boxes), NULL));
	G_OBJECT_CLASS (gnome_scan_option_page_parent_class)->finalize (obj);
}


GType gnome_scan_option_page_get_type (void) {
	static GType gnome_scan_option_page_type_id = 0;
	if (gnome_scan_option_page_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanOptionPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_option_page_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanOptionPage), 0, (GInstanceInitFunc) gnome_scan_option_page_instance_init, NULL };
		gnome_scan_option_page_type_id = g_type_register_static (GTK_TYPE_ALIGNMENT, "GnomeScanOptionPage", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return gnome_scan_option_page_type_id;
}


GnomeScanOptionVPage* gnome_scan_option_vpage_construct (GType object_type, gboolean scrolled) {
	GParameter * __params;
	GParameter * __params_it;
	GnomeScanOptionVPage * self;
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "scrolled";
	g_value_init (&__params_it->value, G_TYPE_BOOLEAN);
	g_value_set_boolean (&__params_it->value, scrolled);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GnomeScanOptionVPage* gnome_scan_option_vpage_new (gboolean scrolled) {
	return gnome_scan_option_vpage_construct (GNOME_SCAN_TYPE_OPTION_VPAGE, scrolled);
}


static GObject * gnome_scan_option_vpage_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GnomeScanOptionVPageClass * klass;
	GObjectClass * parent_class;
	GnomeScanOptionVPage * self;
	klass = GNOME_SCAN_OPTION_VPAGE_CLASS (g_type_class_peek (GNOME_SCAN_TYPE_OPTION_VPAGE));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GNOME_SCAN_OPTION_VPAGE (obj);
	{
		GtkVBox* _tmp3;
		_tmp3 = NULL;
		gnome_scan_option_page_set_container ((GnomeScanOptionPage*) self, (GtkBox*) (_tmp3 = g_object_ref_sink ((GtkVBox*) gtk_vbox_new (FALSE, 6))));
		(_tmp3 == NULL) ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL));
	}
	return obj;
}


static void gnome_scan_option_vpage_class_init (GnomeScanOptionVPageClass * klass) {
	gnome_scan_option_vpage_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = gnome_scan_option_vpage_constructor;
}


static void gnome_scan_option_vpage_instance_init (GnomeScanOptionVPage * self) {
}


GType gnome_scan_option_vpage_get_type (void) {
	static GType gnome_scan_option_vpage_type_id = 0;
	if (gnome_scan_option_vpage_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanOptionVPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_option_vpage_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanOptionVPage), 0, (GInstanceInitFunc) gnome_scan_option_vpage_instance_init, NULL };
		gnome_scan_option_vpage_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION_PAGE, "GnomeScanOptionVPage", &g_define_type_info, 0);
	}
	return gnome_scan_option_vpage_type_id;
}


GnomeScanOptionHPage* gnome_scan_option_hpage_construct (GType object_type) {
	GnomeScanOptionHPage * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GnomeScanOptionHPage* gnome_scan_option_hpage_new (void) {
	return gnome_scan_option_hpage_construct (GNOME_SCAN_TYPE_OPTION_HPAGE);
}


static GObject * gnome_scan_option_hpage_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GnomeScanOptionHPageClass * klass;
	GObjectClass * parent_class;
	GnomeScanOptionHPage * self;
	klass = GNOME_SCAN_OPTION_HPAGE_CLASS (g_type_class_peek (GNOME_SCAN_TYPE_OPTION_HPAGE));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GNOME_SCAN_OPTION_HPAGE (obj);
	{
		GtkHBox* _tmp4;
		_tmp4 = NULL;
		gnome_scan_option_page_set_container ((GnomeScanOptionPage*) self, (GtkBox*) (_tmp4 = g_object_ref_sink ((GtkHBox*) gtk_hbox_new (FALSE, 6))));
		(_tmp4 == NULL) ? NULL : (_tmp4 = (g_object_unref (_tmp4), NULL));
	}
	return obj;
}


static void gnome_scan_option_hpage_class_init (GnomeScanOptionHPageClass * klass) {
	gnome_scan_option_hpage_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = gnome_scan_option_hpage_constructor;
}


static void gnome_scan_option_hpage_instance_init (GnomeScanOptionHPage * self) {
}


GType gnome_scan_option_hpage_get_type (void) {
	static GType gnome_scan_option_hpage_type_id = 0;
	if (gnome_scan_option_hpage_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanOptionHPageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_option_hpage_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanOptionHPage), 0, (GInstanceInitFunc) gnome_scan_option_hpage_instance_init, NULL };
		gnome_scan_option_hpage_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION_PAGE, "GnomeScanOptionHPage", &g_define_type_info, 0);
	}
	return gnome_scan_option_hpage_type_id;
}




