/* GNOME Scan - Scan as easy as you print
 * Copyright © 2006-2008  Étienne Bersac <bersace@gnome.org>
 *
 * GNOME Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * GNOME Scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNOME Scan. If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <gnome-scan-combo-box-widget.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gnome-scan-common.h>
#include <gnome-scan-option.h>


#define GNOME_SCAN_COMBO_BOX_WIDGET_TYPE_COLUMN (gnome_scan_combo_box_widget_column_get_type ())

typedef enum  {
	GNOME_SCAN_COMBO_BOX_WIDGET_COLUMN_LABEL,
	GNOME_SCAN_COMBO_BOX_WIDGET_COLUMN_VALUE,
	GNOME_SCAN_COMBO_BOX_WIDGET_COLUMN_LENGTH
} GnomeScanComboBoxWidgetColumn;



struct _GnomeScanComboBoxWidgetPrivate {
	GtkListStore* store;
	GtkComboBox* combo;
	GHashTable* strings;
};

#define GNOME_SCAN_COMBO_BOX_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_SCAN_TYPE_COMBO_BOX_WIDGET, GnomeScanComboBoxWidgetPrivate))
enum  {
	GNOME_SCAN_COMBO_BOX_WIDGET_DUMMY_PROPERTY
};
GType gnome_scan_combo_box_widget_column_get_type (void);
static void gnome_scan_combo_box_widget_on_combo_changed (GnomeScanComboBoxWidget* self);
static void gnome_scan_combo_box_widget_on_option_changed (GnomeScanComboBoxWidget* self);
static void _gnome_scan_combo_box_widget_on_combo_changed_g_object_notify (GtkComboBox* _sender, GParamSpec* pspec, gpointer self);
static void _gnome_scan_combo_box_widget_on_option_changed_g_object_notify (GnomeScanOptionEnum* _sender, GParamSpec* pspec, gpointer self);
static GObject * gnome_scan_combo_box_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer gnome_scan_combo_box_widget_parent_class = NULL;
static void gnome_scan_combo_box_widget_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);




GType gnome_scan_combo_box_widget_column_get_type (void) {
	static GType gnome_scan_combo_box_widget_column_type_id = 0;
	if (G_UNLIKELY (gnome_scan_combo_box_widget_column_type_id == 0)) {
		static const GEnumValue values[] = {{GNOME_SCAN_COMBO_BOX_WIDGET_COLUMN_LABEL, "GNOME_SCAN_COMBO_BOX_WIDGET_COLUMN_LABEL", "label"}, {GNOME_SCAN_COMBO_BOX_WIDGET_COLUMN_VALUE, "GNOME_SCAN_COMBO_BOX_WIDGET_COLUMN_VALUE", "value"}, {GNOME_SCAN_COMBO_BOX_WIDGET_COLUMN_LENGTH, "GNOME_SCAN_COMBO_BOX_WIDGET_COLUMN_LENGTH", "length"}, {0, NULL, NULL}};
		gnome_scan_combo_box_widget_column_type_id = g_enum_register_static ("GnomeScanComboBoxWidgetColumn", values);
	}
	return gnome_scan_combo_box_widget_column_type_id;
}


static void gnome_scan_combo_box_widget_on_combo_changed (GnomeScanComboBoxWidget* self) {
	GtkTreeIter iter = {0};
	GnomeScanEnumValue* value = {0};
	const char* label;
	GnomeScanOptionEnum* _tmp1;
	GnomeScanOption* _tmp0;
	GnomeScanOptionEnum* option;
	g_return_if_fail (self != NULL);
	label = NULL;
	gtk_combo_box_get_active_iter (self->priv->combo, &iter);
	gtk_tree_model_get ((GtkTreeModel*) self->priv->store, &iter, GNOME_SCAN_COMBO_BOX_WIDGET_COLUMN_VALUE, &value, GNOME_SCAN_COMBO_BOX_WIDGET_COLUMN_LABEL, &label, -1);
	g_object_freeze_notify ((GObject*) gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self));
	_tmp1 = NULL;
	_tmp0 = NULL;
	option = (_tmp1 = (_tmp0 = gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), GNOME_SCAN_IS_OPTION_ENUM (_tmp0) ? ((GnomeScanOptionEnum*) _tmp0) : NULL), (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1));
	gnome_scan_option_enum_set_value (option, &value);
	g_object_thaw_notify ((GObject*) option);
	(option == NULL) ? NULL : (option = (g_object_unref (option), NULL));
}


static void gnome_scan_combo_box_widget_on_option_changed (GnomeScanComboBoxWidget* self) {
	GtkTreeIter iter = {0};
	const char* _tmp1;
	GnomeScanEnumValue* _tmp0 = {0};
	char* str;
	g_return_if_fail (self != NULL);
	_tmp1 = NULL;
	str = (_tmp1 = (const char*) g_hash_table_lookup (self->priv->strings, (*(gnome_scan_option_enum_get_value ((GNOME_SCAN_OPTION_ENUM (gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self))), &_tmp0), _tmp0)).label), (_tmp1 == NULL) ? NULL : g_strdup (_tmp1));
	if (str == NULL) {
		GnomeScanEnumValue* _tmp2 = {0};
		g_debug ("gnome-scan-combo-box-widget.vala:94: No path for %s value", (*(gnome_scan_option_enum_get_value ((GNOME_SCAN_OPTION_ENUM (gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self))), &_tmp2), _tmp2)).label);
		str = (g_free (str), NULL);
		return;
	}
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) self->priv->store, &iter, str);
	g_object_freeze_notify ((GObject*) self->priv->combo);
	gtk_combo_box_set_active_iter (self->priv->combo, &iter);
	g_object_thaw_notify ((GObject*) self->priv->combo);
	str = (g_free (str), NULL);
}


GnomeScanComboBoxWidget* gnome_scan_combo_box_widget_construct (GType object_type) {
	GnomeScanComboBoxWidget * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


GnomeScanComboBoxWidget* gnome_scan_combo_box_widget_new (void) {
	return gnome_scan_combo_box_widget_construct (GNOME_SCAN_TYPE_COMBO_BOX_WIDGET);
}


static void _gnome_scan_combo_box_widget_on_combo_changed_g_object_notify (GtkComboBox* _sender, GParamSpec* pspec, gpointer self) {
	gnome_scan_combo_box_widget_on_combo_changed (self);
}


static void _gnome_scan_combo_box_widget_on_option_changed_g_object_notify (GnomeScanOptionEnum* _sender, GParamSpec* pspec, gpointer self) {
	gnome_scan_combo_box_widget_on_option_changed (self);
}


static GObject * gnome_scan_combo_box_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GnomeScanComboBoxWidgetClass * klass;
	GObjectClass * parent_class;
	GnomeScanComboBoxWidget * self;
	klass = GNOME_SCAN_COMBO_BOX_WIDGET_CLASS (g_type_class_peek (GNOME_SCAN_TYPE_COMBO_BOX_WIDGET));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GNOME_SCAN_COMBO_BOX_WIDGET (obj);
	{
		GtkTreeIter iter = {0};
		GtkCellRenderer* renderer;
		GHashTable* _tmp0;
		GtkListStore* _tmp1;
		GtkComboBox* _tmp2;
		GtkCellRenderer* _tmp3;
		GnomeScanOptionEnum* _tmp5;
		GnomeScanOption* _tmp4;
		GnomeScanOptionEnum* option;
		GnomeScanEnumValue* _tmp7 = {0};
		GnomeScanEnumValue* _tmp6 = {0};
		GnomeScanEnumValue* curval;
		renderer = NULL;
		_tmp0 = NULL;
		self->priv->strings = (_tmp0 = g_hash_table_new (g_str_hash, g_str_equal), (self->priv->strings == NULL) ? NULL : (self->priv->strings = (g_hash_table_unref (self->priv->strings), NULL)), _tmp0);
		_tmp1 = NULL;
		self->priv->store = (_tmp1 = gtk_list_store_new ((gint) GNOME_SCAN_COMBO_BOX_WIDGET_COLUMN_LENGTH, G_TYPE_STRING, GNOME_SCAN_TYPE_ENUM_VALUE, NULL), (self->priv->store == NULL) ? NULL : (self->priv->store = (g_object_unref (self->priv->store), NULL)), _tmp1);
		_tmp2 = NULL;
		self->priv->combo = (_tmp2 = g_object_ref_sink ((GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) self->priv->store)), (self->priv->combo == NULL) ? NULL : (self->priv->combo = (g_object_unref (self->priv->combo), NULL)), _tmp2);
		gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) self->priv->combo, FALSE, TRUE, (guint) 0);
		_tmp3 = NULL;
		renderer = (_tmp3 = (GtkCellRenderer*) g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ()), (renderer == NULL) ? NULL : (renderer = (g_object_unref (renderer), NULL)), _tmp3);
		gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->combo, renderer, TRUE);
		gtk_cell_layout_set_attributes ((GtkCellLayout*) self->priv->combo, renderer, "text", GNOME_SCAN_COMBO_BOX_WIDGET_COLUMN_LABEL, NULL);
		_tmp5 = NULL;
		_tmp4 = NULL;
		option = (_tmp5 = (_tmp4 = gnome_scan_option_widget_get_option ((GnomeScanOptionWidget*) self), GNOME_SCAN_IS_OPTION_ENUM (_tmp4) ? ((GnomeScanOptionEnum*) _tmp4) : NULL), (_tmp5 == NULL) ? NULL : g_object_ref (_tmp5));
		curval = (_tmp7 = (gnome_scan_option_enum_get_value (option, &_tmp6), _tmp6), (_tmp7 == NULL) ? NULL : gnome_scan_enum_value_dup (_tmp7));
		{
			GSList* value_collection;
			GSList* value_it;
			value_collection = gnome_scan_option_enum_get_values (option);
			for (value_it = value_collection; value_it != NULL; value_it = value_it->next) {
				GnomeScanEnumValue* value;
				value = (GnomeScanEnumValue*) value_it->data;
				{
					const char* _tmp8;
					gboolean _tmp9;
					gtk_list_store_append (self->priv->store, &iter);
					gtk_list_store_set (self->priv->store, &iter, GNOME_SCAN_COMBO_BOX_WIDGET_COLUMN_LABEL, (*value).label, GNOME_SCAN_COMBO_BOX_WIDGET_COLUMN_VALUE, value, -1);
					_tmp8 = NULL;
					g_hash_table_insert (self->priv->strings, (_tmp8 = (*value).label, (_tmp8 == NULL) ? NULL : g_strdup (_tmp8)), gtk_tree_model_get_string_from_iter ((GtkTreeModel*) self->priv->store, &iter));
					_tmp9 = FALSE;
					if (curval != NULL) {
						_tmp9 = _vala_strcmp0 ((*value).label, (*curval).label) == 0;
					} else {
						_tmp9 = FALSE;
					}
					if (_tmp9) {
						gtk_combo_box_set_active_iter (self->priv->combo, &iter);
					}
				}
			}
		}
		g_signal_connect_object ((GObject*) self->priv->combo, "notify::active", (GCallback) _gnome_scan_combo_box_widget_on_combo_changed_g_object_notify, self, 0);
		g_signal_connect_object ((GObject*) option, "notify::value", (GCallback) _gnome_scan_combo_box_widget_on_option_changed_g_object_notify, self, 0);
		/* don't show one option selector. Thanks Philipp for
		 pointing that.*/
		if (g_slist_length (gnome_scan_option_enum_get_values (option)) <= 1) {
			gtk_widget_set_no_show_all ((GtkWidget*) self, TRUE);
		}
		(renderer == NULL) ? NULL : (renderer = (g_object_unref (renderer), NULL));
		(option == NULL) ? NULL : (option = (g_object_unref (option), NULL));
		(curval == NULL) ? NULL : (curval = (gnome_scan_enum_value_free (curval), NULL));
	}
	return obj;
}


static void gnome_scan_combo_box_widget_class_init (GnomeScanComboBoxWidgetClass * klass) {
	gnome_scan_combo_box_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GnomeScanComboBoxWidgetPrivate));
	G_OBJECT_CLASS (klass)->constructor = gnome_scan_combo_box_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = gnome_scan_combo_box_widget_finalize;
}


static void gnome_scan_combo_box_widget_instance_init (GnomeScanComboBoxWidget * self) {
	self->priv = GNOME_SCAN_COMBO_BOX_WIDGET_GET_PRIVATE (self);
}


static void gnome_scan_combo_box_widget_finalize (GObject* obj) {
	GnomeScanComboBoxWidget * self;
	self = GNOME_SCAN_COMBO_BOX_WIDGET (obj);
	(self->priv->store == NULL) ? NULL : (self->priv->store = (g_object_unref (self->priv->store), NULL));
	(self->priv->combo == NULL) ? NULL : (self->priv->combo = (g_object_unref (self->priv->combo), NULL));
	(self->priv->strings == NULL) ? NULL : (self->priv->strings = (g_hash_table_unref (self->priv->strings), NULL));
	G_OBJECT_CLASS (gnome_scan_combo_box_widget_parent_class)->finalize (obj);
}


GType gnome_scan_combo_box_widget_get_type (void) {
	static GType gnome_scan_combo_box_widget_type_id = 0;
	if (gnome_scan_combo_box_widget_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GnomeScanComboBoxWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gnome_scan_combo_box_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GnomeScanComboBoxWidget), 0, (GInstanceInitFunc) gnome_scan_combo_box_widget_instance_init, NULL };
		gnome_scan_combo_box_widget_type_id = g_type_register_static (GNOME_SCAN_TYPE_OPTION_WIDGET, "GnomeScanComboBoxWidget", &g_define_type_info, 0);
	}
	return gnome_scan_combo_box_widget_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




