/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * gnome-scan
 * Copyright (C) Étienne Bersac 2007 <bersace03@laposte.net>
 * 
 * gnome-scan is free software.
 * 
 * You may redistribute it and/or modify it under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option)
 * any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with gnome-scan.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

/**
 * SECTION: 
 * @short_description: #FlegitaActionSelector class
 * 
 **/
#include <string.h>
#include <glib/gi18n.h>
#include <gtk/gtkprintunixdialog.h>
#include "flegita-action-selector.h"
#include "flegita.h"
#include "flegita-types.h"

#define GET_PRIVATE(o)  (G_TYPE_INSTANCE_GET_PRIVATE ((o), FLEGITA_TYPE_ACTION_SELECTOR, FlegitaActionSelectorPrivate))

typedef struct _FlegitaActionSelectorPrivate FlegitaActionSelectorPrivate;
struct _FlegitaActionSelectorPrivate
{
	GtkListStore	*store;
	GtkWidget		*combo;
#ifdef	PRINT
	GtkWidget		*print_setup;
	GtkWidget		*print_unix_dialog;
#endif
};

enum {
	COLUMN_ICON,
	COLUMN_LABEL,
	COLUMN_ACTION,
	N_COLUMN
};

GS_DEFINE_PARAM_WIDGET (FlegitaActionSelector, flegita_action_selector)

static void	fas_changed (GtkComboBox *combo, FlegitaActionSelector *fas);
#ifdef	PRINT
static void fas_print_setup_clicked (GtkButton *button, FlegitaActionSelector *fas);
#endif

static void
flegita_action_selector_init (FlegitaActionSelector *object)
{
	/* TODO: Add initialization code here */
}

static void
flegita_action_selector_finalize (GObject *object)
{
	/* TODO: Add deinitalization code here */

	G_OBJECT_CLASS (flegita_action_selector_parent_class)->finalize (object);
}

static void
flegita_action_selector_build (GnomeScanParamWidget *gspw)
{
	FlegitaActionSelectorPrivate *priv = GET_PRIVATE (gspw);
	GtkCellRenderer *renderer;
	GEnumClass *klass = g_type_class_ref (FLEGITA_TYPE_ACTION);
	GtkTreeIter iter;
	GtkStockItem item;
	guint i;
	gchar *stock_id;
	gchar *label, *end;

	gspw->shows_unit = TRUE;

	priv->store = gtk_list_store_new (N_COLUMN,
									  G_TYPE_STRING,
									  G_TYPE_STRING,
									  FLEGITA_TYPE_ACTION);

	priv->combo = gtk_combo_box_new_with_model (GTK_TREE_MODEL (priv->store));
	gtk_box_pack_start (GTK_BOX (gspw), priv->combo, FALSE, TRUE, 0);

	/* icon */
	renderer = gtk_cell_renderer_pixbuf_new ();
	gtk_cell_layout_pack_start (GTK_CELL_LAYOUT (priv->combo), renderer, FALSE);
	g_object_set (renderer,
				  "stock-size", GTK_ICON_SIZE_BUTTON,
				  NULL);
	gtk_cell_layout_add_attribute (GTK_CELL_LAYOUT (priv->combo), renderer,
								   "stock-id", COLUMN_ICON);

	/* label */
	renderer = gtk_cell_renderer_text_new ();
	gtk_cell_layout_pack_start (GTK_CELL_LAYOUT (priv->combo), renderer, TRUE);
	gtk_cell_layout_add_attribute (GTK_CELL_LAYOUT (priv->combo), renderer,
								   "text", COLUMN_LABEL);

	g_debug (G_STRLOC ": %i actions", klass->n_values);
	for (i = 0; i < klass->n_values; i++) {
		stock_id = g_strdup(klass->values[i].value_nick);

		if (gtk_stock_lookup (stock_id, &item)) {
			/* strip _ */
			label = g_strdup(dgettext (item.translation_domain, item.label));
			end = g_utf8_strchr (label, -1, '_');
			memcpy(end, end+1, strlen(end));
		}
		else {
			label = stock_id;
		}

		gtk_list_store_append (priv->store, &iter);
		gtk_list_store_set (priv->store, &iter,
							COLUMN_ICON, stock_id,
							COLUMN_LABEL, label,
							COLUMN_ACTION, i,
							-1);
	}

	g_signal_connect (priv->combo, "changed",
					  G_CALLBACK (fas_changed),
					  FLEGITA_ACTION_SELECTOR (gspw));

#ifdef	PRINT
	priv->print_setup = gtk_button_new_from_stock (GTK_STOCK_PROPERTIES);
	gtk_box_pack_start (GTK_BOX (gspw), priv->print_setup, FALSE, TRUE, 0);
	g_signal_connect (priv->print_setup, "clicked",
					  G_CALLBACK (fas_print_setup_clicked),
					  FLEGITA_ACTION_SELECTOR (gspw));
/* 	GtkWidget *toplevel = gtk_widget_get_toplevel (GTK_WIDGET (gspw)); */
	priv->print_unix_dialog = gtk_print_unix_dialog_new(_("Configure printing"),
														NULL/* GTK_WINDOW (toplevel) */);
	GtkDialog *dialog = GTK_DIALOG (priv->print_unix_dialog);
	gtk_container_foreach (GTK_CONTAINER (dialog->action_area),
						   (GtkCallback) gtk_widget_destroy,
						   NULL);
	gtk_dialog_add_buttons (GTK_DIALOG (priv->print_unix_dialog),
							GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
							GTK_STOCK_OK, GTK_RESPONSE_OK,
							NULL);	
#endif
}

static void
flegita_action_selector_set (GnomeScanParamWidget *gspw,
							 GValue *value)
{
	FlegitaActionSelectorPrivate *priv = GET_PRIVATE (gspw);
	gtk_combo_box_set_active (GTK_COMBO_BOX (priv->combo),
							  (gint) g_value_get_enum (value));
}



static void
fas_changed (GtkComboBox *combo, FlegitaActionSelector *fas)
{
	GnomeScanParamWidget *gspw = GNOME_SCAN_PARAM_WIDGET (fas);
	FlegitaActionSelectorPrivate *priv = GET_PRIVATE (fas);
	GtkTreeIter iter;
	FlegitaAction action;
	
	gtk_combo_box_get_active_iter (GTK_COMBO_BOX (priv->combo), &iter);
	gtk_tree_model_get (GTK_TREE_MODEL (priv->store), &iter,
						COLUMN_ACTION, &action,
						-1);

#ifdef	PRINT
	switch (action) {
	case FLEGITA_PRINT:
		gtk_widget_set_no_show_all (priv->print_setup, FALSE);
		gtk_widget_show (priv->print_setup);
		break;
	default:
		gtk_widget_set_no_show_all (priv->print_setup, TRUE);
		gtk_widget_hide (priv->print_setup);
		break;
	}
#endif
	
	g_value_set_enum (gspw->value, action);
	gnome_scan_param_widget_changed (gspw);
}

#ifdef	PRINT
static void
fas_print_setup_clicked (GtkButton *button, FlegitaActionSelector *fas)
{
	FlegitaActionSelectorPrivate *priv = GET_PRIVATE (fas);
	GnomeScanParamWidget *gspw = GNOME_SCAN_PARAM_WIDGET (fas);
	gint res = gtk_dialog_run (GTK_DIALOG (priv->print_unix_dialog));
	gtk_widget_hide (priv->print_unix_dialog);
	GEnumClass *klass = g_type_class_ref (GTK_TYPE_RESPONSE_TYPE);
	GEnumValue *val = g_enum_get_value (klass, res);
	g_debug (G_STRLOC ": %s", val->value_nick);

	gnome_scan_settings_set_object (gspw->settings, "printer",
									gtk_print_unix_dialog_get_selected_printer (GTK_PRINT_UNIX_DIALOG (priv->print_unix_dialog)));

	g_type_class_unref (klass);
	gnome_scan_param_widget_changed (gspw);
}
#endif
