/* Gnome Scan - Scan as easy as you print
 * Copyright © 2007  Étienne Bersac <bersace03@laposte.net>
 *
 * Gnome Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */
 
#ifndef _GSFILE_PSPEC_H
#define _GSFILE_PSPEC_H

#include <glib.h>
#include <glib-object.h>
#include <gegl.h>
#include <gnome-scan-param-specs.h>

G_BEGIN_DECLS


/* FILENAMES */
#define GSFILE_TYPE_PARAM_FILENAMES			(gsfile_param_filenames_get_type ())
#define GSFILE_PARAM_SPEC_FILENAMES(p)			(G_TYPE_CHECK_INSTANCE_CAST ((p), GSFILE_TYPE_PARAM_FILENAMES, GSFileParamSpecFilenames))
#define GSFILE_IS_PARAM_SPEC_FILENAMES(p)	(G_TYPE_CHECK_INSTANCE_TYPE ((p), GSFILE_TYPE_PARAM_FILENAMES))


typedef struct _GSFileParamSpecFilenames GSFileParamSpecFilenames;
/**
 * GSFileParamSpecFilenames:
 *
 * This spec is used to select existing files.
 */
struct _GSFileParamSpecFilenames
{
  /*< private >*/
	GParamSpec	parent_instance;
};

GType		gsfile_param_filenames_get_type	(void)	G_GNUC_CONST;
GParamSpec*	gsfile_param_spec_filenames		(const gchar *name,
											   const gchar *nick,
											   const gchar *blurb,
											   GQuark group,
											   GSList *formats,
											   GParamFlags flags);

GSList* gsfile_param_spec_filenames_get_formats	(GParamSpec *pspec);

G_END_DECLS

#endif /* _GSFILE_PSPEC_H */
