/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * gnome-scan
 * Copyright (C) Étienne Bersac 2007 <bersace03@laposte.net>
 * 
 * gnome-scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

#ifndef _GSANE_COMMON_H_
#define _GSANE_COMMON_H_

#if	HAVE_CONFIG_H
#include <config.h>
#endif

#include <glib.h>
#include <glib/gi18n.h>

#undef _
#define _(string)   dgettext(GETTEXT_PACKAGE, string)

G_BEGIN_DECLS

#if	DEBUG
#define	gs_debug(...)	g_debug (__VA_ARGS__)
#else
#define gs_debug(...)
#endif

#define	GSANE_META_PARAM_QUARK	(gsane_meta_param_quark ())

GQuark gsane_meta_param_quark () G_GNUC_CONST;

gboolean	gsane_str_matches_strv (const gchar *name, const gchar **names);

G_END_DECLS

#endif /* _GSANE_COMMON_H_ */
