/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * gnome-scan
 * Copyright (C) Étienne Bersac 2007 <bersace03@laposte.net>
 * 
 * gnome-scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

#ifndef _GNOME_SCAN_PREVIEW_PLUGIN_AREA_H_
#define _GNOME_SCAN_PREVIEW_PLUGIN_AREA_H_

#include "gnome-scan-preview-plugin.h"

G_BEGIN_DECLS

#define	GNOME_TYPE_SCAN_PREVIEW_PLUGIN_AREA	(gnome_scan_preview_plugin_area_get_type())
#define GNOME_SCAN_PREVIEW_PLUGIN_AREA(obj)	(G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_TYPE_SCAN_PREVIEW_PLUGIN_AREA, GnomeScanPreviewPluginArea))

typedef struct _GnomeScanPreviewPluginArea GnomeScanPreviewPluginArea;

struct _GnomeScanPreviewPluginArea
{
	GnomeScanPreviewPlugin	parent;
	
	gulong					draw_buffer_handler;
	gulong					button_press_event_handler;
	gulong					motion_notify_event_handler;
	gulong					button_release_event_handler;

#ifndef	NO_BUTTON
	GtkWidget				*button;
#endif

	gboolean				manual;
	GdkCursorType			ct;
	GdkCursor				*cursor;
	guint					cf;	/* cursor flag */
	GdkPoint				opposite_point;
	GtkAnchorType			anchor_type;
	GdkRectangle			window;
	GdkRectangle			saved_roi;
	GdkRectangle			selection;
};

GType	gnome_scan_preview_plugin_area_get_type (void) G_GNUC_CONST;

G_END_DECLS

#endif /* _GNOME_SCAN_PREVIEW_PLUGIN_AREA_H_ */
