/* Gnome Scan - Scan as easy as you print
 * Copyright © 2007  Étienne Bersac <bersace@gnome.org>
 *
 * Gnome Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */

#include <sane/sane.h>
#include <gnome-scan-module.h>
#include "gsane-backend.h"
#include "gsane-scanner.h"

void	gsb_probe_scanners (GnomeScanBackend *backend);

static GnomeScanBackendClass* parent_class = NULL;

GS_DEFINE_MODULE_TYPE (GSaneBackend, gsane_backend, GNOME_TYPE_SCAN_BACKEND);

static void
gsane_backend_init (GSaneBackend *object)
{
	/* TODO: Add initialization code here */
}

static void
gsane_backend_finalize (GObject *object)
{
	/* TODO: Add deinitalization code here */

	G_OBJECT_CLASS (parent_class)->finalize (object);
}

static void
gsane_backend_class_init (GSaneBackendClass *klass)
{
	GObjectClass* object_class = G_OBJECT_CLASS (klass);
	GnomeScanBackendClass *backend_class = GNOME_SCAN_BACKEND_CLASS (klass);
	parent_class = GNOME_SCAN_BACKEND_CLASS (g_type_class_peek_parent (klass));
	
	backend_class->probe_scanners = gsb_probe_scanners;
	
	object_class->finalize = gsane_backend_finalize;
}

void gsb_probe_scanners(GnomeScanBackend *backend)
{
	const SANE_Device **devices;
	SANE_Status status;
	GnomeScanner *scanner;
	gint i;
	
	status = sane_get_devices(&devices, SANE_FALSE);
	
	for (i = 0; devices[i]; i++) {
		scanner = gsane_scanner_new(devices[i]);
		if (scanner) {
			gnome_scan_backend_add_scanner(backend, scanner);
			g_object_unref (scanner);
		}
	}
}

