/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * gnome-scan
 * Copyright (C) Étienne Bersac 2007 <bersace03@laposte.net>
 * 
 * gnome-scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

#include <gtk/gtk.h>
#include <glib/gi18n.h>
#include "gnome-scan-preview-plugin-rotation.h"

GS_DEFINE_PREVIEW_PLUGIN (GnomeScanPreviewPluginRotation, gnome_scan_preview_plugin_rotation, "");

static void
gnome_scan_preview_plugin_rotation_init (GnomeScanPreviewPlugin *object)
{
	/* TODO: Add initialization code here */
}

static void
gnome_scan_preview_plugin_rotation_finalize (GnomeScanPreviewPlugin *object)
{
	/* TODO: Add deinitalization code here */

}

static void
gsppr_button_clicked(GtkWidget *button, GnomeScanPreviewPluginRotation *gsppr)
{	
	GnomeScanPreviewPlugin *gspp = GNOME_SCAN_PREVIEW_PLUGIN(gsppr);
	gdouble degrees;
	degrees = gnome_scan_settings_get_double(gspp->settings, "rotation");
	degrees += button == gsppr->rotate_left ? -90. : 90.;
	degrees = (gdouble) ((360 + (gint) degrees) % 360);
	g_debug("Rotation = %f", degrees);
	gnome_scan_preview_plugin_freeze(gspp);
	gnome_scan_settings_set_double(gspp->settings, "rotation", degrees);
	gnome_scan_preview_plugin_thaw(gspp);
}

static void
gnome_scan_preview_plugin_rotation_build_ui	(GnomeScanPreviewPlugin *gspp, GtkBox *box)
{
    GnomeScanPreviewPluginRotation *gsppr = GNOME_SCAN_PREVIEW_PLUGIN_ROTATION(gspp);
	GtkWidget *image;
	
    gsppr->rotate_left = gtk_button_new();
	image = gtk_image_new_from_icon_name ("object-rotate-left", GTK_ICON_SIZE_BUTTON);
	gtk_button_set_image(GTK_BUTTON(gsppr->rotate_left), image);
	gtk_button_set_label(GTK_BUTTON(gsppr->rotate_left), _("Rotate left"));
    gtk_container_add (GTK_CONTAINER (box), gsppr->rotate_left);
	g_signal_connect(gsppr->rotate_left, "clicked",
					 G_CALLBACK(gsppr_button_clicked),
					 gsppr);
	
    gsppr->rotate_right = gtk_button_new();
	image = gtk_image_new_from_icon_name ("object-rotate-right", GTK_ICON_SIZE_BUTTON);
	gtk_button_set_image(GTK_BUTTON(gsppr->rotate_right), image);
	gtk_button_set_label(GTK_BUTTON(gsppr->rotate_right), _("Rotate right"));
    gtk_container_add (GTK_CONTAINER (box), gsppr->rotate_right);
	g_signal_connect(gsppr->rotate_right, "clicked",
					 G_CALLBACK(gsppr_button_clicked),
					 gsppr);
}

static void
gnome_scan_preview_plugin_rotation_draw_buffer (GnomeScanPreviewPlugin *gspp,
												GtkWidget *gspa,
												cairo_t *cr)
{
}

static void
gnome_scan_preview_plugin_rotation_changed (GnomeScanPreviewPlugin *gspp)
{
	g_debug(__FUNCTION__);
}
