/***************************************************************************
 *            main.c
 *
 *  Tue Mar 13 13:40:25 2007
 *  Copyright  2007  Étienne Bersac <bersace03@laposte.net>
 ****************************************************************************/

/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <glib/gprintf.h>
#include <gnome.h>
#include <gnome-scan-init.h>
#include <gnome-scan-dialog.h>
#include <gnome-scan-job.h>
#include <gnome-scan-sink.h>
#include "flegita-sink.h"

gint
main (gint argc, gchar **argv)
{
  GnomeProgram *program;
  GnomeScanSettings *settings;
  GtkPrintSettings *psettings;
  GnomeScanJob *job;
  GtkWidget *dialog;
  GnomeScanSink *sink;
	
  program = gnome_program_init ("flegita", VERSION,
				LIBGNOMEUI_MODULE,
				argc, argv,
				GNOME_PARAM_NONE);

  textdomain (GETTEXT_PACKAGE);

  g_set_application_name (_("Scanner Utility"));
  g_set_prgname ("flegita");

  gtk_window_set_default_icon_name ("flegita");
  gnome_scan_init (&argc, &argv);
	
  settings = gnome_scan_settings_new ();
  job = gnome_scan_job_new ();
  gnome_scan_job_set_settings (job, settings);

  psettings = gtk_print_settings_new ();
  gnome_scan_settings_set_object (settings,
				  "print-settings",
				  G_OBJECT (psettings));
  sink = flegita_sink_new ();
  gnome_scan_job_set_sink (job, sink);
  dialog = gnome_scan_dialog_new (NULL, job);
  gnome_scan_dialog_run (GNOME_SCAN_DIALOG (dialog));
	
  gtk_widget_destroy (dialog);
  gnome_scan_exit ();
	
  return (0);
}
