/* Gnome Scan - Scan as easy as you print
 * Copyright © 2007  Étienne Bersac <bersace03@laposte.net>
 *
 * Gnome Scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 *
 *	the Free Software Foundation, Inc.
 *	51 Franklin Street, Fifth Floor
 *	Boston, MA 02110-1301, USA
 */


#ifndef _GNOME_SCAN_PLUGIN_H_
#define _GNOME_SCAN_PLUGIN_H_

#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gegl.h>
#include <gegl/buffer/gegl-buffer.h>
#include "gnome-scan-plugin.h"
#include "gnome-scan-settings.h"

G_BEGIN_DECLS

#define GNOME_TYPE_SCAN_PLUGIN             (gnome_scan_plugin_get_type ())
#define GNOME_SCAN_PLUGIN(obj)             (G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_TYPE_SCAN_PLUGIN, GnomeScanPlugin))
#define GNOME_SCAN_PLUGIN_CLASS(klass)     (G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_TYPE_SCAN_PLUGIN, GnomeScanPluginClass))
#define GNOME_IS_SCAN_PLUGIN(obj)          (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_TYPE_SCAN_PLUGIN))
#define GNOME_IS_SCAN_PLUGIN_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_SCAN_PLUGIN))
#define GNOME_SCAN_PLUGIN_GET_CLASS(obj)   (G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_TYPE_SCAN_PLUGIN, GnomeScanPluginClass))

typedef struct _GnomeScanPluginClass GnomeScanPluginClass;
typedef struct _GnomeScanPlugin GnomeScanPlugin;

struct _GnomeScanPluginClass
{
  GObjectClass parent_class;
	
	
	
  /* Plugin API */
  void		(* configure)		(GnomeScanPlugin *plugin,
					 GnomeScanSettings *settings);
  GList*	(* get_child_nodes)	(GnomeScanPlugin *plugin,
					 GeglNode *root);
  void		(* configure_frame)	(GnomeScanPlugin *plugin);
  gboolean	(* start_frame)		(GnomeScanPlugin *plugin);
  gboolean	(* work)		(GnomeScanPlugin *plugin,
					 gdouble *progress);
  void		(* end_frame)		(GnomeScanPlugin *plugin);
  void		(* end_scan)		(GnomeScanPlugin *plugin);
	

  /* Signals */
  void		(* changed)		(GnomeScanPlugin *plugin,
					 GParamSpec *spec,
					 gpointer data);
};

/**
 * GnomeScanPlugin:
 * @buffer:	the in/out #GdkPixbuf
 * @params: the pool of params
 *
 * #GnomeScanPlugin is the base class for #GnomeScanner and
 * #GnomeScanSink. The @buffer property is considered as the output of
 * #a #GnomeScanner, and the input of a #GnomeScanSink.
 **/
struct _GnomeScanPlugin
{
  /*< private >*/
  GObject parent_instance;
	
  /*< public >*/
  GList			*nodes;
  GParamSpecPool	*params;
};

GType		gnome_scan_plugin_get_type			(void) G_GNUC_CONST;
gchar*		gnome_scan_plugin_get_name			(GnomeScanPlugin *plugin);
GList*		gnome_scan_plugin_get_params			(GnomeScanPlugin *plugin);
GSList*		gnome_scan_plugin_params_get_groups		(GnomeScanPlugin *plugin);
GSList*		gnome_scan_plugin_params_get_other_groups	(GnomeScanPlugin *plugin,
								 GQuark known_group0,
								 ...);
GSList*		gnome_scan_plugin_get_param_group		(GnomeScanPlugin *plugin,
								 GQuark group);
GSList*		gnome_scan_plugin_get_param_groups		(GnomeScanPlugin *plugin,
								 GQuark group0,
								 ...);
void		gnome_scan_plugin_params_add			(GnomeScanPlugin *plugin,
								 GParamSpec *param);
void		gnome_scan_plugin_params_remove			(GnomeScanPlugin *plugin,
								 GParamSpec *param);
void		gnome_scan_plugin_params_clear			(GnomeScanPlugin *plugin);
GParamSpec*	gnome_scan_plugin_params_lookup			(GnomeScanPlugin *plugin,
								 const gchar *name);
void		gnome_scan_plugin_params_foreach 		(GnomeScanPlugin *plugin,
								 GFunc func,
								 gpointer user_data);
void		gnome_scan_plugin_params_changed		(GnomeScanPlugin *plugin,
								 GParamSpec *spec);



void		gnome_scan_plugin_configure			(GnomeScanPlugin *plugin,
								 GnomeScanSettings *settings);

void		gnome_scan_plugin_configure_frame		(GnomeScanPlugin *plugin);
gboolean	gnome_scan_plugin_start_frame			(GnomeScanPlugin *plugin);
gboolean 	gnome_scan_plugin_work				(GnomeScanPlugin *plugin,
								 gdouble *progress);

void		gnome_scan_plugin_end_frame			(GnomeScanPlugin *plugin);

void		gnome_scan_plugin_end_scan			(GnomeScanPlugin *plugin);

GList*		gnome_scan_plugin_get_child_nodes		(GnomeScanPlugin *plugin,
								 GeglNode *root);

G_END_DECLS

#endif /* _GNOME_SCAN_PLUGIN_H_ */
