/* GnomeScanUI - Widgets for scan dialogs
 *
 * gnomescannerselector.h
 *
 * Copyright © 2006 Étienne Bersac
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

/**
 * SECTION:gnomescannerselector
 * @title: GnomeScannerSelector
 * @short_description: An auto filled Combo-Box
 *
 * The #GnomeScannerSelector is a composed widget that is connected to
 * the #GnomeScanContext::"probe-done" signal to fill itself the
 * ComboBox store. When a device is selected, the choice is directly
 * transmitted to the #GnomeScanContext which then emit the
 * #GnomeScanContext::"scanner-seleted" signal. The
 * #GnomeScannerSelector shows a pretty ComboBox containing a device
 * per row. Each row contain an icon, the name of the product, the
 * vendor and the type of the device. The icon reflects the type of
 * the device.
 */

#ifndef GNOME_SCANNER_SELECTOR_H
#define GNOME_SCANNER_SELECTOR_H

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "gnomescan.h"
#include "gnomescanoptionwidget.h"

#define	GNOME_TYPE_SCANNER_SELECTOR		(gnome_scanner_selector_get_type ())
#define GNOME_SCANNER_SELECTOR(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), GNOME_TYPE_SCANNER_SELECTOR, GnomeScannerSelector))
#define GNOME_SCANNER_SELECTOR_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), GNOME_TYPE_SCANNER_SELECTOR, GnomeScannerSelectorClass))
#define GNOME_IS_SCANNER_SELECTOR(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), GNOME_TYPE_SCANNER_SELECTOR))
#define GNOME_IS_SCANNER_SELECTOR_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_TYPE_SCANNER_SELECTOR))
#define GNOME_SCANNER_SELECTOR_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), GNOME_TYPE_SCANNER_SELECTOR, GnomeScannerSelectorClass))

typedef struct _GnomeScannerSelector			GnomeScannerSelector;
typedef struct _GnomeScannerSelectorClass		GnomeScannerSelectorClass;

struct _GnomeScannerSelector {
  GnomeScanOptionWidget		parent;

  /*< public >*/
};

struct _GnomeScannerSelectorClass {
  GnomeScanOptionWidgetClass	parent;

  /* SIGNALS */
};

enum {
  GNOME_SCANNER_SELECTOR_ERROR_FAILED
};

/* GObject functions */
GType			gnome_scanner_selector_get_type			(void);

/* Methods */

GtkWidget*		gnome_scanner_selector_new 			(GnomeScanContext *context);

#endif
