/* GnomeScanUI - Widgets for scan dialogs
 *
 * gnomescanui.c
 *
 * Copyright © 2006 Étienne Bersac
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <gtk/gtk.h>
#include <gnomescan.h>
#include "gnomescanui.h"
#include "gnomescanui-intl.h"

/**
 * gnome_scan_ui_init:
 * 
 * Init GnomeScan UI translation and icons.
 **/
void
gnome_scan_ui_init ()
{
  GtkIconFactory *factory;
  GtkIconSet *set;
  GtkIconSource *source;
  gchar *filename;
  gint i, n_stocks;

  bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);  
  
  /* GLOBAL GNOMESCANUI INIT */
  /* something that my not reside here, but where else ? */
  gtk_icon_theme_append_search_path (gtk_icon_theme_get_default (),
				     ICONDIR);

  gtk_icon_theme_append_search_path (gtk_icon_theme_get_default (),
				     LOGOSDIR);

  static const GtkStockItem stocks[] = {
    { "rotate-90",
      N_("Rotate Counter Clockwise"),
      0,
      0,
      GETTEXT_PACKAGE },
    { "rotate-270",
      N_("Rotate Clockwise"),
      0,
      0,
      GETTEXT_PACKAGE },
    { "scan",
      N_("_Scan"),
      0,
      0,
      GETTEXT_PACKAGE }
  };

  n_stocks = G_N_ELEMENTS (stocks);

  gtk_stock_add_static (stocks, n_stocks);

  factory = gtk_icon_factory_new ();

  for (i = 0; i < n_stocks; i++) {
    set = gtk_icon_set_new ();
    source = gtk_icon_source_new ();
    filename = g_strconcat (ICONDIR, "/stock_", stocks[i].stock_id, ".svg", NULL);
    gtk_icon_source_set_filename (source, filename);
    gtk_icon_source_set_direction_wildcarded (source, TRUE);
    gtk_icon_source_set_size_wildcarded (source, TRUE);
    gtk_icon_source_set_state_wildcarded (source, TRUE);

    gtk_icon_set_add_source (set, source);

    gtk_icon_factory_add (factory,
			  stocks[i].stock_id,
			  set);
  }

  gtk_icon_factory_add_default (factory);
}
