/* Flegita - Gnome Sane Frontend
 *
 * main.c
 *
 * Copyright © 2006 Étienne Bersac
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include <gnome.h>
#include <gnomescan.h>
#include <gnomescanui.h>
#include "flegitaactionwidget.h"

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

gint
main (int argc, gchar **argv)
{
  GnomeScanContext *context;
  GtkWidget *dialog, *widget, *vbox, *hbox;
  GtkListStore *store;
  GtkCellRenderer *renderer;
  GtkTreeIter iter;
  gint res;
  GdkScreen *screen;
  GnomeProgram *program;

  bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);  
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);

  /* INIT */
  program = gnome_program_init (PACKAGE, VERSION, LIBGNOMEUI_MODULE, argc, argv, NULL);
  gnome_scan_ui_init ();

  context = gnome_scan_context_new ();

  /* UI */
  vbox = gtk_vbox_new (FALSE, 6);
  gtk_box_pack_start (GTK_BOX (vbox), gnome_scanner_selector_new (context), FALSE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), gnome_scan_source_selector_new (context), FALSE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), gnome_scan_preview_new (context), TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX (vbox), flegita_action_widget_new (context), FALSE, TRUE, 0);

  dialog = gnome_scan_dialog_new (context, NULL, vbox);

  /* run */
  gnome_scan_dialog_run (GNOME_SCAN_DIALOG (dialog));

  gtk_widget_destroy (dialog);

  return (0);
}
