/* utils.c generated by valac 0.48.9, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2020 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <tepl/tepl.h>
#include <gtk/gtk.h>

#define _g_bytes_unref0(var) ((var == NULL) ? NULL : (var = (g_bytes_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))

gboolean utils_char_is_escaped (const gchar* text,
                                glong char_index);
const gchar* utils_get_string_from_resource (const gchar* resource_path);
void utils_delete_file (GFile* file);
gboolean utils_save_file (GFile* file,
                          const gchar* contents,
                          gboolean make_backup);
gchar* utils_load_file (GFile* file);
gchar* utils_get_relative_path (GFile* origin,
                                GFile* target,
                                GFile* common_dir);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
gboolean utils_tree_model_iter_prev (GtkTreeModel* model,
                                     GtkTreeIter* iter);
static void _vala_GtkTreePath_free (GtkTreePath* self);
gint utils_get_selected_row (GtkTreeView* view,
                             GtkTreeIter* iter);
GtkWindow* utils_get_toplevel_window (GtkWidget* widget);
void utils_flush_queue (void);

/*************************************************************************/
static gboolean
string_get_prev_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
#line 1290 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1291 "glib-2.0.vapi"
	if (0 < (*index)) {
#line 71 "utils.c"
		gchar* _tmp0_;
#line 1292 "glib-2.0.vapi"
		_tmp0_ = g_utf8_prev_char (((gchar*) self) + (*index));
#line 1292 "glib-2.0.vapi"
		*index = (gint) (_tmp0_ - ((gchar*) self));
#line 1293 "glib-2.0.vapi"
		_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
#line 1294 "glib-2.0.vapi"
		result = TRUE;
#line 1294 "glib-2.0.vapi"
		if (c) {
#line 1294 "glib-2.0.vapi"
			*c = _vala_c;
#line 85 "utils.c"
		}
#line 1294 "glib-2.0.vapi"
		return result;
#line 89 "utils.c"
	} else {
#line 1296 "glib-2.0.vapi"
		_vala_c = (gunichar) 0;
#line 1297 "glib-2.0.vapi"
		result = FALSE;
#line 1297 "glib-2.0.vapi"
		if (c) {
#line 1297 "glib-2.0.vapi"
			*c = _vala_c;
#line 99 "utils.c"
		}
#line 1297 "glib-2.0.vapi"
		return result;
#line 103 "utils.c"
	}
#line 1290 "glib-2.0.vapi"
	if (c) {
#line 1290 "glib-2.0.vapi"
		*c = _vala_c;
#line 109 "utils.c"
	}
}

gboolean
utils_char_is_escaped (const gchar* text,
                       glong char_index)
{
	gint _tmp0_;
	gint _tmp1_;
	gboolean escaped = FALSE;
	gint index = 0;
	gunichar cur_char = 0U;
	gboolean result = FALSE;
#line 27 "utils.vala"
	g_return_val_if_fail (text != NULL, FALSE);
#line 29 "utils.vala"
	_tmp0_ = strlen (text);
#line 29 "utils.vala"
	_tmp1_ = _tmp0_;
#line 29 "utils.vala"
	g_return_val_if_fail (char_index < ((glong) _tmp1_), FALSE);
#line 31 "utils.vala"
	escaped = FALSE;
#line 32 "utils.vala"
	index = (gint) char_index;
#line 34 "utils.vala"
	while (TRUE) {
#line 137 "utils.c"
		gunichar _tmp2_ = 0U;
		gboolean _tmp3_;
#line 34 "utils.vala"
		_tmp3_ = string_get_prev_char (text, &index, &_tmp2_);
#line 34 "utils.vala"
		cur_char = _tmp2_;
#line 34 "utils.vala"
		if (!_tmp3_) {
#line 34 "utils.vala"
			break;
#line 148 "utils.c"
		}
#line 36 "utils.vala"
		if (cur_char != ((gunichar) '\\')) {
#line 37 "utils.vala"
			break;
#line 154 "utils.c"
		}
#line 39 "utils.vala"
		escaped = !escaped;
#line 158 "utils.c"
	}
#line 42 "utils.vala"
	result = escaped;
#line 42 "utils.vala"
	return result;
#line 164 "utils.c"
}

const gchar*
utils_get_string_from_resource (const gchar* resource_path)
{
	GError* _inner_error0_ = NULL;
	const gchar* result = NULL;
#line 45 "utils.vala"
	g_return_val_if_fail (resource_path != NULL, NULL);
#line 174 "utils.c"
	{
		GBytes* bytes = NULL;
		GBytes* _tmp0_;
		gsize _tmp1_ = 0;
		guint8* _tmp2_;
#line 49 "utils.vala"
		_tmp0_ = g_resources_lookup_data (resource_path, 0, &_inner_error0_);
#line 49 "utils.vala"
		bytes = _tmp0_;
#line 49 "utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 186 "utils.c"
			goto __catch0_g_error;
		}
#line 50 "utils.vala"
		_tmp2_ = g_bytes_get_data (bytes, &_tmp1_);
#line 50 "utils.vala"
		result = (const gchar*) _tmp2_;
#line 50 "utils.vala"
		_g_bytes_unref0 (bytes);
#line 50 "utils.vala"
		return result;
#line 197 "utils.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
#line 47 "utils.vala"
		e = _inner_error0_;
#line 47 "utils.vala"
		_inner_error0_ = NULL;
#line 54 "utils.vala"
		_tmp3_ = e;
#line 54 "utils.vala"
		_tmp4_ = _tmp3_->message;
#line 54 "utils.vala"
		g_warning ("utils.vala:54: Failed to load data from resource '%s': %s", resource_path, _tmp4_);
#line 56 "utils.vala"
		result = NULL;
#line 56 "utils.vala"
		_g_error_free0 (e);
#line 56 "utils.vala"
		return result;
#line 221 "utils.c"
	}
	__finally0:
#line 47 "utils.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 47 "utils.vala"
	g_clear_error (&_inner_error0_);
#line 47 "utils.vala"
	return NULL;
#line 230 "utils.c"
}

/*************************************************************************/
void
utils_delete_file (GFile* file)
{
	GError* _inner_error0_ = NULL;
#line 64 "utils.vala"
	g_return_if_fail (file != NULL);
#line 66 "utils.vala"
	if (!g_file_query_exists (file, NULL)) {
#line 67 "utils.vala"
		return;
#line 244 "utils.c"
	}
	{
#line 71 "utils.vala"
		g_file_delete (file, NULL, &_inner_error0_);
#line 71 "utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 251 "utils.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 69 "utils.vala"
		e = _inner_error0_;
#line 69 "utils.vala"
		_inner_error0_ = NULL;
#line 75 "utils.vala"
		_tmp0_ = g_file_get_parse_name (file);
#line 75 "utils.vala"
		_tmp1_ = _tmp0_;
#line 75 "utils.vala"
		_tmp2_ = e;
#line 75 "utils.vala"
		_tmp3_ = _tmp2_->message;
#line 75 "utils.vala"
		g_warning ("utils.vala:75: Delete file '%s' failed: %s", _tmp1_, _tmp3_);
#line 75 "utils.vala"
		_g_free0 (_tmp1_);
#line 69 "utils.vala"
		_g_error_free0 (e);
#line 281 "utils.c"
	}
	__finally0:
#line 69 "utils.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 69 "utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 69 "utils.vala"
		g_clear_error (&_inner_error0_);
#line 69 "utils.vala"
		return;
#line 292 "utils.c"
	}
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
#line 1555 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1556 "glib-2.0.vapi"
	res = (guint8*) self;
#line 1556 "glib-2.0.vapi"
	res_length1 = -1;
#line 1556 "glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1557 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1557 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1557 "glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1558 "glib-2.0.vapi"
	_tmp2_ = res;
#line 1558 "glib-2.0.vapi"
	_tmp2__length1 = res_length1;
#line 1558 "glib-2.0.vapi"
	if (result_length1) {
#line 1558 "glib-2.0.vapi"
		*result_length1 = _tmp2__length1;
#line 330 "utils.c"
	}
#line 1558 "glib-2.0.vapi"
	result = _tmp2_;
#line 1558 "glib-2.0.vapi"
	return result;
#line 336 "utils.c"
}

gboolean
utils_save_file (GFile* file,
                 const gchar* contents,
                 gboolean make_backup)
{
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
#line 79 "utils.vala"
	g_return_val_if_fail (file != NULL, FALSE);
#line 79 "utils.vala"
	g_return_val_if_fail (contents != NULL, FALSE);
#line 350 "utils.c"
	{
		guint8* _tmp0_;
		gint _tmp0__length1;
		gint _tmp1_ = 0;
		guint8* _tmp2_;
		gint _tmp2__length1;
#line 83 "utils.vala"
		tepl_utils_create_parent_directories (file, NULL, &_inner_error0_);
#line 83 "utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 361 "utils.c"
			goto __catch0_g_error;
		}
#line 85 "utils.vala"
		_tmp0_ = string_get_data (contents, &_tmp1_);
#line 85 "utils.vala"
		_tmp0__length1 = _tmp1_;
#line 85 "utils.vala"
		_tmp2_ = _tmp0_;
#line 85 "utils.vala"
		_tmp2__length1 = _tmp0__length1;
#line 85 "utils.vala"
		g_file_replace_contents (file, _tmp2_, (gsize) _tmp2__length1, NULL, make_backup, G_FILE_CREATE_NONE, NULL, NULL, &_inner_error0_);
#line 85 "utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 376 "utils.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
#line 81 "utils.vala"
		e = _inner_error0_;
#line 81 "utils.vala"
		_inner_error0_ = NULL;
#line 90 "utils.vala"
		_tmp3_ = g_file_get_parse_name (file);
#line 90 "utils.vala"
		_tmp4_ = _tmp3_;
#line 90 "utils.vala"
		_tmp5_ = e;
#line 90 "utils.vala"
		_tmp6_ = _tmp5_->message;
#line 90 "utils.vala"
		g_warning ("utils.vala:90: Failed to save the file '%s': %s", _tmp4_, _tmp6_);
#line 90 "utils.vala"
		_g_free0 (_tmp4_);
#line 92 "utils.vala"
		result = FALSE;
#line 92 "utils.vala"
		_g_error_free0 (e);
#line 92 "utils.vala"
		return result;
#line 410 "utils.c"
	}
	__finally0:
#line 81 "utils.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 415 "utils.c"
		gboolean _tmp7_ = FALSE;
#line 81 "utils.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 81 "utils.vala"
		g_clear_error (&_inner_error0_);
#line 81 "utils.vala"
		return _tmp7_;
#line 423 "utils.c"
	}
#line 95 "utils.vala"
	result = TRUE;
#line 95 "utils.vala"
	return result;
#line 429 "utils.c"
}

gchar*
utils_load_file (GFile* file)
{
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
#line 99 "utils.vala"
	g_return_val_if_fail (file != NULL, NULL);
#line 439 "utils.c"
	{
		guint8* chars = NULL;
		gint chars_length1 = 0;
		gint _chars_size_ = 0;
		guint8* _tmp0_ = NULL;
		gsize _tmp1_ = 0;
		guint8* _tmp2_;
		gint _tmp2__length1;
#line 104 "utils.vala"
		g_file_load_contents (file, NULL, &_tmp0_, &_tmp1_, NULL, &_inner_error0_);
#line 104 "utils.vala"
		chars = (g_free (chars), NULL);
#line 104 "utils.vala"
		chars = _tmp0_;
#line 104 "utils.vala"
		chars_length1 = _tmp1_;
#line 104 "utils.vala"
		_chars_size_ = chars_length1;
#line 104 "utils.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 104 "utils.vala"
			chars = (g_free (chars), NULL);
#line 462 "utils.c"
			goto __catch0_g_error;
		}
#line 105 "utils.vala"
		_tmp2_ = chars;
#line 105 "utils.vala"
		_tmp2__length1 = chars_length1;
#line 105 "utils.vala"
		chars = NULL;
#line 105 "utils.vala"
		chars_length1 = 0;
#line 105 "utils.vala"
		result = (gchar*) _tmp2_;
#line 105 "utils.vala"
		chars = (g_free (chars), NULL);
#line 105 "utils.vala"
		return result;
#line 479 "utils.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
#line 101 "utils.vala"
		e = _inner_error0_;
#line 101 "utils.vala"
		_inner_error0_ = NULL;
#line 109 "utils.vala"
		_tmp3_ = g_file_get_parse_name (file);
#line 109 "utils.vala"
		_tmp4_ = _tmp3_;
#line 109 "utils.vala"
		_tmp5_ = e;
#line 109 "utils.vala"
		_tmp6_ = _tmp5_->message;
#line 109 "utils.vala"
		g_warning ("utils.vala:109: Failed to load the file '%s': %s", _tmp4_, _tmp6_);
#line 109 "utils.vala"
		_g_free0 (_tmp4_);
#line 111 "utils.vala"
		result = NULL;
#line 111 "utils.vala"
		_g_error_free0 (e);
#line 111 "utils.vala"
		return result;
#line 511 "utils.c"
	}
	__finally0:
#line 101 "utils.vala"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 101 "utils.vala"
	g_clear_error (&_inner_error0_);
#line 101 "utils.vala"
	return NULL;
#line 520 "utils.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 120 "utils.vala"
	return self ? g_object_ref (self) : NULL;
#line 528 "utils.c"
}

static void
_g_object_unref0_ (gpointer var)
{
#line 180 "utils.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 536 "utils.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 180 "utils.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 544 "utils.c"
}

gchar*
utils_get_relative_path (GFile* origin,
                         GFile* target,
                         GFile* common_dir)
{
	GFile* origin_dir = NULL;
	GFile* target_parent = NULL;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	GFile* _tmp6_;
	GList* target_dirs = NULL;
	GList* origin_dirs = NULL;
	guint dir_index = 0U;
	guint nb_common_dirs = 0U;
	gchar* relative_path = NULL;
	gchar* _tmp34_;
	guint nb_remaining_origin_dirs = 0U;
	GList* _tmp35_;
	const gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* result = NULL;
#line 116 "utils.vala"
	g_return_val_if_fail (origin != NULL, NULL);
#line 116 "utils.vala"
	g_return_val_if_fail (target != NULL, NULL);
#line 116 "utils.vala"
	g_return_val_if_fail (common_dir != NULL, NULL);
#line 119 "utils.vala"
	if (g_file_equal (origin, common_dir)) {
#line 580 "utils.c"
		GFile* _tmp0_;
#line 120 "utils.vala"
		_tmp0_ = _g_object_ref0 (origin);
#line 120 "utils.vala"
		_g_object_unref0 (origin_dir);
#line 120 "utils.vala"
		origin_dir = _tmp0_;
#line 588 "utils.c"
	} else {
		GFile* _tmp1_;
#line 122 "utils.vala"
		_tmp1_ = g_file_get_parent (origin);
#line 122 "utils.vala"
		_g_object_unref0 (origin_dir);
#line 122 "utils.vala"
		origin_dir = _tmp1_;
#line 597 "utils.c"
	}
#line 124 "utils.vala"
	_tmp2_ = g_file_get_parent (target);
#line 124 "utils.vala"
	target_parent = _tmp2_;
#line 126 "utils.vala"
	_tmp3_ = origin_dir;
#line 126 "utils.vala"
	g_return_val_if_fail (_tmp3_ != NULL, NULL);
#line 127 "utils.vala"
	_tmp4_ = target_parent;
#line 127 "utils.vala"
	g_return_val_if_fail (_tmp4_ != NULL, NULL);
#line 130 "utils.vala"
	_tmp5_ = target_parent;
#line 130 "utils.vala"
	_tmp6_ = origin_dir;
#line 130 "utils.vala"
	if (g_file_equal (_tmp5_, _tmp6_)) {
#line 617 "utils.c"
		gchar* _tmp7_;
#line 131 "utils.vala"
		_tmp7_ = g_file_get_basename (target);
#line 131 "utils.vala"
		result = _tmp7_;
#line 131 "utils.vala"
		_g_object_unref0 (target_parent);
#line 131 "utils.vala"
		_g_object_unref0 (origin_dir);
#line 131 "utils.vala"
		return result;
#line 629 "utils.c"
	}
#line 134 "utils.vala"
	target_dirs = NULL;
#line 135 "utils.vala"
	origin_dirs = NULL;
#line 137 "utils.vala"
	while (TRUE) {
#line 637 "utils.c"
		gboolean _tmp8_ = FALSE;
		GFile* _tmp9_;
		GFile* _tmp11_;
		GFile* _tmp12_;
		GFile* _tmp13_;
		GFile* _tmp14_;
#line 137 "utils.vala"
		_tmp9_ = target_parent;
#line 137 "utils.vala"
		if (_tmp9_ != NULL) {
#line 648 "utils.c"
			GFile* _tmp10_;
#line 137 "utils.vala"
			_tmp10_ = target_parent;
#line 137 "utils.vala"
			_tmp8_ = !g_file_equal (_tmp10_, common_dir);
#line 654 "utils.c"
		} else {
#line 137 "utils.vala"
			_tmp8_ = FALSE;
#line 658 "utils.c"
		}
#line 137 "utils.vala"
		if (!_tmp8_) {
#line 137 "utils.vala"
			break;
#line 664 "utils.c"
		}
#line 139 "utils.vala"
		_tmp11_ = target_parent;
#line 139 "utils.vala"
		_tmp12_ = _g_object_ref0 (_tmp11_);
#line 139 "utils.vala"
		target_dirs = g_list_prepend (target_dirs, _tmp12_);
#line 140 "utils.vala"
		_tmp13_ = target_parent;
#line 140 "utils.vala"
		_tmp14_ = g_file_get_parent (_tmp13_);
#line 140 "utils.vala"
		_g_object_unref0 (target_parent);
#line 140 "utils.vala"
		target_parent = _tmp14_;
#line 680 "utils.c"
	}
#line 143 "utils.vala"
	while (TRUE) {
#line 684 "utils.c"
		gboolean _tmp15_ = FALSE;
		GFile* _tmp16_;
		GFile* _tmp18_;
		GFile* _tmp19_;
		GFile* _tmp20_;
		GFile* _tmp21_;
#line 143 "utils.vala"
		_tmp16_ = origin_dir;
#line 143 "utils.vala"
		if (_tmp16_ != NULL) {
#line 695 "utils.c"
			GFile* _tmp17_;
#line 143 "utils.vala"
			_tmp17_ = origin_dir;
#line 143 "utils.vala"
			_tmp15_ = !g_file_equal (_tmp17_, common_dir);
#line 701 "utils.c"
		} else {
#line 143 "utils.vala"
			_tmp15_ = FALSE;
#line 705 "utils.c"
		}
#line 143 "utils.vala"
		if (!_tmp15_) {
#line 143 "utils.vala"
			break;
#line 711 "utils.c"
		}
#line 145 "utils.vala"
		_tmp18_ = origin_dir;
#line 145 "utils.vala"
		_tmp19_ = _g_object_ref0 (_tmp18_);
#line 145 "utils.vala"
		origin_dirs = g_list_prepend (origin_dirs, _tmp19_);
#line 146 "utils.vala"
		_tmp20_ = origin_dir;
#line 146 "utils.vala"
		_tmp21_ = g_file_get_parent (_tmp20_);
#line 146 "utils.vala"
		_g_object_unref0 (origin_dir);
#line 146 "utils.vala"
		origin_dir = _tmp21_;
#line 727 "utils.c"
	}
#line 150 "utils.vala"
	dir_index = (guint) 0;
#line 151 "utils.vala"
	while (TRUE) {
#line 733 "utils.c"
		gboolean _tmp22_ = FALSE;
		GList* _tmp23_;
		GFile* cur_target_dir = NULL;
		GList* _tmp25_;
		gconstpointer _tmp26_;
		GFile* _tmp27_;
		GFile* cur_origin_dir = NULL;
		GList* _tmp28_;
		gconstpointer _tmp29_;
		GFile* _tmp30_;
		GFile* _tmp31_;
		GFile* _tmp32_;
		guint _tmp33_;
#line 151 "utils.vala"
		_tmp23_ = target_dirs;
#line 151 "utils.vala"
		if (dir_index < g_list_length (_tmp23_)) {
#line 751 "utils.c"
			GList* _tmp24_;
#line 151 "utils.vala"
			_tmp24_ = origin_dirs;
#line 151 "utils.vala"
			_tmp22_ = dir_index < g_list_length (_tmp24_);
#line 757 "utils.c"
		} else {
#line 151 "utils.vala"
			_tmp22_ = FALSE;
#line 761 "utils.c"
		}
#line 151 "utils.vala"
		if (!_tmp22_) {
#line 151 "utils.vala"
			break;
#line 767 "utils.c"
		}
#line 153 "utils.vala"
		_tmp25_ = target_dirs;
#line 153 "utils.vala"
		_tmp26_ = g_list_nth_data (_tmp25_, dir_index);
#line 153 "utils.vala"
		_tmp27_ = _g_object_ref0 ((GFile*) _tmp26_);
#line 153 "utils.vala"
		cur_target_dir = _tmp27_;
#line 154 "utils.vala"
		_tmp28_ = origin_dirs;
#line 154 "utils.vala"
		_tmp29_ = g_list_nth_data (_tmp28_, dir_index);
#line 154 "utils.vala"
		_tmp30_ = _g_object_ref0 ((GFile*) _tmp29_);
#line 154 "utils.vala"
		cur_origin_dir = _tmp30_;
#line 155 "utils.vala"
		_tmp31_ = cur_target_dir;
#line 155 "utils.vala"
		_tmp32_ = cur_origin_dir;
#line 155 "utils.vala"
		if (!g_file_equal (_tmp31_, _tmp32_)) {
#line 156 "utils.vala"
			_g_object_unref0 (cur_origin_dir);
#line 156 "utils.vala"
			_g_object_unref0 (cur_target_dir);
#line 156 "utils.vala"
			break;
#line 797 "utils.c"
		}
#line 158 "utils.vala"
		_tmp33_ = dir_index;
#line 158 "utils.vala"
		dir_index = _tmp33_ + 1;
#line 151 "utils.vala"
		_g_object_unref0 (cur_origin_dir);
#line 151 "utils.vala"
		_g_object_unref0 (cur_target_dir);
#line 807 "utils.c"
	}
#line 161 "utils.vala"
	nb_common_dirs = dir_index;
#line 164 "utils.vala"
	_tmp34_ = g_strdup ("");
#line 164 "utils.vala"
	relative_path = _tmp34_;
#line 167 "utils.vala"
	_tmp35_ = origin_dirs;
#line 167 "utils.vala"
	nb_remaining_origin_dirs = g_list_length (_tmp35_) - nb_common_dirs;
#line 819 "utils.c"
	{
		guint i = 0U;
#line 168 "utils.vala"
		i = (guint) 0;
#line 824 "utils.c"
		{
			gboolean _tmp36_ = FALSE;
#line 168 "utils.vala"
			_tmp36_ = TRUE;
#line 168 "utils.vala"
			while (TRUE) {
#line 831 "utils.c"
				const gchar* _tmp38_;
				gchar* _tmp39_;
#line 168 "utils.vala"
				if (!_tmp36_) {
#line 836 "utils.c"
					guint _tmp37_;
#line 168 "utils.vala"
					_tmp37_ = i;
#line 168 "utils.vala"
					i = _tmp37_ + 1;
#line 842 "utils.c"
				}
#line 168 "utils.vala"
				_tmp36_ = FALSE;
#line 168 "utils.vala"
				if (!(i < nb_remaining_origin_dirs)) {
#line 168 "utils.vala"
					break;
#line 850 "utils.c"
				}
#line 169 "utils.vala"
				_tmp38_ = relative_path;
#line 169 "utils.vala"
				_tmp39_ = g_strconcat (_tmp38_, "../", NULL);
#line 169 "utils.vala"
				_g_free0 (relative_path);
#line 169 "utils.vala"
				relative_path = _tmp39_;
#line 860 "utils.c"
			}
		}
	}
	{
		guint i = 0U;
#line 172 "utils.vala"
		i = nb_common_dirs;
#line 868 "utils.c"
		{
			gboolean _tmp40_ = FALSE;
#line 172 "utils.vala"
			_tmp40_ = TRUE;
#line 172 "utils.vala"
			while (TRUE) {
#line 875 "utils.c"
				GList* _tmp42_;
				GFile* cur_target_dir = NULL;
				GList* _tmp43_;
				gconstpointer _tmp44_;
				GFile* _tmp45_;
				const gchar* _tmp46_;
				GFile* _tmp47_;
				gchar* _tmp48_;
				gchar* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
#line 172 "utils.vala"
				if (!_tmp40_) {
#line 890 "utils.c"
					guint _tmp41_;
#line 172 "utils.vala"
					_tmp41_ = i;
#line 172 "utils.vala"
					i = _tmp41_ + 1;
#line 896 "utils.c"
				}
#line 172 "utils.vala"
				_tmp40_ = FALSE;
#line 172 "utils.vala"
				_tmp42_ = target_dirs;
#line 172 "utils.vala"
				if (!(i < g_list_length (_tmp42_))) {
#line 172 "utils.vala"
					break;
#line 906 "utils.c"
				}
#line 174 "utils.vala"
				_tmp43_ = target_dirs;
#line 174 "utils.vala"
				_tmp44_ = g_list_nth_data (_tmp43_, i);
#line 174 "utils.vala"
				_tmp45_ = _g_object_ref0 ((GFile*) _tmp44_);
#line 174 "utils.vala"
				cur_target_dir = _tmp45_;
#line 175 "utils.vala"
				_tmp46_ = relative_path;
#line 175 "utils.vala"
				_tmp47_ = cur_target_dir;
#line 175 "utils.vala"
				_tmp48_ = g_file_get_basename (_tmp47_);
#line 175 "utils.vala"
				_tmp49_ = _tmp48_;
#line 175 "utils.vala"
				_tmp50_ = g_strconcat (_tmp49_, "/", NULL);
#line 175 "utils.vala"
				_tmp51_ = _tmp50_;
#line 175 "utils.vala"
				_tmp52_ = g_strconcat (_tmp46_, _tmp51_, NULL);
#line 175 "utils.vala"
				_g_free0 (relative_path);
#line 175 "utils.vala"
				relative_path = _tmp52_;
#line 175 "utils.vala"
				_g_free0 (_tmp51_);
#line 175 "utils.vala"
				_g_free0 (_tmp49_);
#line 172 "utils.vala"
				_g_object_unref0 (cur_target_dir);
#line 940 "utils.c"
			}
		}
	}
#line 179 "utils.vala"
	_tmp53_ = relative_path;
#line 179 "utils.vala"
	_tmp54_ = g_file_get_basename (target);
#line 179 "utils.vala"
	_tmp55_ = _tmp54_;
#line 179 "utils.vala"
	_tmp56_ = g_strconcat (_tmp53_, _tmp55_, NULL);
#line 179 "utils.vala"
	_g_free0 (relative_path);
#line 179 "utils.vala"
	relative_path = _tmp56_;
#line 179 "utils.vala"
	_g_free0 (_tmp55_);
#line 180 "utils.vala"
	result = relative_path;
#line 180 "utils.vala"
	(origin_dirs == NULL) ? NULL : (origin_dirs = (_g_list_free__g_object_unref0_ (origin_dirs), NULL));
#line 180 "utils.vala"
	(target_dirs == NULL) ? NULL : (target_dirs = (_g_list_free__g_object_unref0_ (target_dirs), NULL));
#line 180 "utils.vala"
	_g_object_unref0 (target_parent);
#line 180 "utils.vala"
	_g_object_unref0 (origin_dir);
#line 180 "utils.vala"
	return result;
#line 970 "utils.c"
}

/*************************************************************************/
GtkScrolledWindow*
utils_add_scrollbar (GtkWidget* child)
{
	GtkScrolledWindow* sw = NULL;
	GtkScrolledWindow* _tmp0_;
	GtkScrolledWindow* result = NULL;
#line 187 "utils.vala"
	g_return_val_if_fail (child != NULL, NULL);
#line 189 "utils.vala"
	_tmp0_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
#line 189 "utils.vala"
	g_object_ref_sink (_tmp0_);
#line 189 "utils.vala"
	sw = _tmp0_;
#line 190 "utils.vala"
	gtk_container_add ((GtkContainer*) sw, child);
#line 191 "utils.vala"
	result = sw;
#line 191 "utils.vala"
	return result;
#line 994 "utils.c"
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
#line 200 "utils.vala"
	g_boxed_free (gtk_tree_path_get_type (), self);
#line 1002 "utils.c"
}

gboolean
utils_tree_model_iter_prev (GtkTreeModel* model,
                            GtkTreeIter* iter)
{
	GtkTreePath* path = NULL;
	GtkTreeIter _tmp0_;
	GtkTreePath* _tmp1_;
	GtkTreePath* _tmp2_;
	gboolean result = FALSE;
#line 194 "utils.vala"
	g_return_val_if_fail (model != NULL, FALSE);
#line 194 "utils.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 196 "utils.vala"
	_tmp0_ = *iter;
#line 196 "utils.vala"
	_tmp1_ = gtk_tree_model_get_path (model, &_tmp0_);
#line 196 "utils.vala"
	path = _tmp1_;
#line 197 "utils.vala"
	_tmp2_ = path;
#line 197 "utils.vala"
	if (gtk_tree_path_prev (_tmp2_)) {
#line 1028 "utils.c"
		gboolean ret = FALSE;
		GtkTreePath* _tmp3_;
		GtkTreeIter _tmp4_ = {0};
		gboolean _tmp5_;
#line 199 "utils.vala"
		_tmp3_ = path;
#line 199 "utils.vala"
		_tmp5_ = gtk_tree_model_get_iter (model, &_tmp4_, _tmp3_);
#line 199 "utils.vala"
		*iter = _tmp4_;
#line 199 "utils.vala"
		ret = _tmp5_;
#line 200 "utils.vala"
		result = ret;
#line 200 "utils.vala"
		__vala_GtkTreePath_free0 (path);
#line 200 "utils.vala"
		return result;
#line 1047 "utils.c"
	}
#line 202 "utils.vala"
	result = FALSE;
#line 202 "utils.vala"
	__vala_GtkTreePath_free0 (path);
#line 202 "utils.vala"
	return result;
#line 1055 "utils.c"
}

gint
utils_get_selected_row (GtkTreeView* view,
                        GtkTreeIter* iter)
{
	GtkTreeIter _vala_iter = {0};
	GtkTreeSelection* select = NULL;
	GtkTreeSelection* _tmp0_;
	GtkTreeSelection* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_;
	gint result = 0;
#line 207 "utils.vala"
	g_return_val_if_fail (view != NULL, 0);
#line 209 "utils.vala"
	_tmp0_ = gtk_tree_view_get_selection (view);
#line 209 "utils.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 209 "utils.vala"
	select = _tmp1_;
#line 210 "utils.vala"
	_tmp2_ = select;
#line 210 "utils.vala"
	_tmp4_ = gtk_tree_selection_get_selected (_tmp2_, NULL, &_tmp3_);
#line 210 "utils.vala"
	_vala_iter = _tmp3_;
#line 210 "utils.vala"
	if (_tmp4_) {
#line 1086 "utils.c"
		GtkTreeModel* model = NULL;
		GtkTreeModel* _tmp5_;
		GtkTreeModel* _tmp6_;
		GtkTreePath* path = NULL;
		GtkTreeModel* _tmp7_;
		GtkTreeIter _tmp8_;
		GtkTreePath* _tmp9_;
		GtkTreePath* _tmp10_;
		gint _tmp11_ = 0;
		gint* _tmp12_;
		gint _tmp13_;
#line 212 "utils.vala"
		_tmp5_ = gtk_tree_view_get_model (view);
#line 212 "utils.vala"
		_tmp6_ = _g_object_ref0 (_tmp5_);
#line 212 "utils.vala"
		model = _tmp6_;
#line 213 "utils.vala"
		_tmp7_ = model;
#line 213 "utils.vala"
		_tmp8_ = _vala_iter;
#line 213 "utils.vala"
		_tmp9_ = gtk_tree_model_get_path (_tmp7_, &_tmp8_);
#line 213 "utils.vala"
		path = _tmp9_;
#line 214 "utils.vala"
		_tmp10_ = path;
#line 214 "utils.vala"
		_tmp12_ = gtk_tree_path_get_indices_with_depth (_tmp10_, &_tmp11_);
#line 214 "utils.vala"
		_tmp13_ = _tmp12_[0];
#line 214 "utils.vala"
		result = _tmp13_;
#line 214 "utils.vala"
		__vala_GtkTreePath_free0 (path);
#line 214 "utils.vala"
		_g_object_unref0 (model);
#line 214 "utils.vala"
		_g_object_unref0 (select);
#line 214 "utils.vala"
		if (iter) {
#line 214 "utils.vala"
			*iter = _vala_iter;
#line 1130 "utils.c"
		}
#line 214 "utils.vala"
		return result;
#line 1134 "utils.c"
	}
#line 216 "utils.vala"
	result = -1;
#line 216 "utils.vala"
	_g_object_unref0 (select);
#line 216 "utils.vala"
	if (iter) {
#line 216 "utils.vala"
		*iter = _vala_iter;
#line 1144 "utils.c"
	}
#line 216 "utils.vala"
	return result;
#line 1148 "utils.c"
}

GtkWindow*
utils_get_toplevel_window (GtkWidget* widget)
{
	GtkWidget* toplevel = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	GtkWindow* result = NULL;
#line 219 "utils.vala"
	g_return_val_if_fail (widget != NULL, NULL);
#line 221 "utils.vala"
	_tmp0_ = gtk_widget_get_toplevel (widget);
#line 221 "utils.vala"
	toplevel = _tmp0_;
#line 223 "utils.vala"
	_tmp1_ = toplevel;
#line 223 "utils.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_window_get_type ())) {
#line 1168 "utils.c"
		GtkWidget* _tmp2_;
#line 224 "utils.vala"
		_tmp2_ = toplevel;
#line 224 "utils.vala"
		result = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp2_) : NULL;
#line 224 "utils.vala"
		return result;
#line 1176 "utils.c"
	}
#line 226 "utils.vala"
	result = NULL;
#line 226 "utils.vala"
	return result;
#line 1182 "utils.c"
}

/*************************************************************************/
void
utils_flush_queue (void)
{
#line 235 "utils.vala"
	while (TRUE) {
#line 235 "utils.vala"
		if (!gtk_events_pending ()) {
#line 235 "utils.vala"
			break;
#line 1195 "utils.c"
		}
#line 236 "utils.vala"
		gtk_main_iteration ();
#line 1199 "utils.c"
	}
}

