/* symbols_view.c generated by valac 0.48.9, the Vala compiler
 * generated from symbols_view.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2012 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <pango/pango.h>
#include <tepl/tepl.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#define TYPE_SYMBOLS_VIEW (symbols_view_get_type ())
#define SYMBOLS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYMBOLS_VIEW, SymbolsView))
#define SYMBOLS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYMBOLS_VIEW, SymbolsViewClass))
#define IS_SYMBOLS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYMBOLS_VIEW))
#define IS_SYMBOLS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYMBOLS_VIEW))
#define SYMBOLS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYMBOLS_VIEW, SymbolsViewClass))

typedef struct _SymbolsView SymbolsView;
typedef struct _SymbolsViewClass SymbolsViewClass;
typedef struct _SymbolsViewPrivate SymbolsViewPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
enum  {
	SYMBOLS_VIEW_0_PROPERTY,
	SYMBOLS_VIEW_NUM_PROPERTIES
};
static GParamSpec* symbols_view_properties[SYMBOLS_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block31Data Block31Data;

#define TYPE_SYMBOLS (symbols_get_type ())
#define SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYMBOLS, Symbols))
#define SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYMBOLS, SymbolsClass))
#define IS_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYMBOLS))
#define IS_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYMBOLS))
#define SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYMBOLS, SymbolsClass))

typedef struct _Symbols Symbols;
typedef struct _SymbolsClass SymbolsClass;
typedef enum  {
	SYMBOLS_CATEGORY_COLUMN_TYPE,
	SYMBOLS_CATEGORY_COLUMN_ICON,
	SYMBOLS_CATEGORY_COLUMN_NAME,
	SYMBOLS_CATEGORY_COLUMN_SYMBOLS_STORE,
	SYMBOLS_CATEGORY_COLUMN_N_COLUMNS
} SymbolsCategoryColumn;

#define TYPE_SYMBOLS_CATEGORY_COLUMN (symbols_category_column_get_type ())
typedef enum  {
	SYMBOLS_CATEGORY_TYPE_NORMAL,
	SYMBOLS_CATEGORY_TYPE_MOST_USED
} SymbolsCategoryType;

#define TYPE_SYMBOLS_CATEGORY_TYPE (symbols_category_type_get_type ())
typedef enum  {
	SYMBOL_COLUMN_PIXBUF,
	SYMBOL_COLUMN_COMMAND,
	SYMBOL_COLUMN_TOOLTIP,
	SYMBOL_COLUMN_ID,
	SYMBOL_COLUMN_N_COLUMNS
} SymbolColumn;

#define TYPE_SYMBOL_COLUMN (symbol_column_get_type ())

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_MOST_USED_SYMBOLS (most_used_symbols_get_type ())
#define MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbols))
#define MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))
#define IS_MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOST_USED_SYMBOLS))
#define IS_MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOST_USED_SYMBOLS))
#define MOST_USED_SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))

typedef struct _MostUsedSymbols MostUsedSymbols;
typedef struct _MostUsedSymbolsClass MostUsedSymbolsClass;
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))

struct _SymbolsView {
	GtkGrid parent_instance;
	SymbolsViewPrivate * priv;
};

struct _SymbolsViewClass {
	GtkGridClass parent_class;
};

struct _SymbolsViewPrivate {
	MainWindow* _main_window;
	GtkComboBox* _combo_box;
	GtkIconView* _symbol_view;
	GtkButton* _clear_button;
};

struct _Block31Data {
	int _ref_count_;
	SymbolsView* self;
	GtkTreeModel* categories_model;
};

static gint SymbolsView_private_offset;
static gpointer symbols_view_parent_class = NULL;

GType symbols_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SymbolsView, g_object_unref)
GType main_window_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
SymbolsView* symbols_view_new (MainWindow* main_window);
SymbolsView* symbols_view_construct (GType object_type,
                                     MainWindow* main_window);
static void symbols_view_create_combo_box (SymbolsView* self);
static void symbols_view_create_icon_view (SymbolsView* self);
static void symbols_view_create_clear_button (SymbolsView* self);
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
static Block31Data* block31_data_ref (Block31Data* _data31_);
static void block31_data_unref (void * _userdata_);
GType symbols_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Symbols, g_object_unref)
Symbols* symbols_get_default (void);
GtkTreeModel* symbols_get_categories_model (Symbols* self);
GType symbols_category_column_get_type (void) G_GNUC_CONST;
static void __lambda65_ (Block31Data* _data31_);
GType symbols_category_type_get_type (void) G_GNUC_CONST;
static void ___lambda65__gtk_combo_box_changed (GtkComboBox* _sender,
                                         gpointer self);
GType symbol_column_get_type (void) G_GNUC_CONST;
static void __lambda66_ (SymbolsView* self);
GType document_tab_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
DocumentTab* main_window_get_active_tab (MainWindow* self);
static GtkTreePath* _vala_GtkTreePath_copy (GtkTreePath* self);
GType document_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
Document* main_window_get_active_document (MainWindow* self);
GType document_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentView, g_object_unref)
DocumentView* main_window_get_active_view (MainWindow* self);
GType most_used_symbols_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MostUsedSymbols, g_object_unref)
MostUsedSymbols* most_used_symbols_get_default (void);
void most_used_symbols_increment_symbol (MostUsedSymbols* self,
                                         const gchar* id);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static void __vala_GtkTreePath_free0_ (gpointer var);
static inline void _g_list_free___vala_GtkTreePath_free0_ (GList* self);
static void ___lambda66__gtk_icon_view_selection_changed (GtkIconView* _sender,
                                                   gpointer self);
static void __lambda67_ (SymbolsView* self);
void most_used_symbols_clear (MostUsedSymbols* self);
static void ___lambda67__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void symbols_view_finalize (GObject * obj);
static GType symbols_view_get_type_once (void);

static inline gpointer
symbols_view_get_instance_private (SymbolsView* self)
{
	return G_STRUCT_MEMBER_P (self, SymbolsView_private_offset);
}

SymbolsView*
symbols_view_construct (GType object_type,
                        MainWindow* main_window)
{
	SymbolsView * self = NULL;
	GtkComboBox* _tmp0_;
	GtkScrolledWindow* sw = NULL;
	GtkIconView* _tmp1_;
	GtkScrolledWindow* _tmp2_;
	GtkButton* _tmp3_;
	GtkComboBox* _tmp4_;
#line 34 "symbols_view.vala"
	g_return_val_if_fail (main_window != NULL, NULL);
#line 34 "symbols_view.vala"
	self = (SymbolsView*) g_object_new (object_type, NULL);
#line 36 "symbols_view.vala"
	self->priv->_main_window = main_window;
#line 38 "symbols_view.vala"
	symbols_view_create_combo_box (self);
#line 39 "symbols_view.vala"
	symbols_view_create_icon_view (self);
#line 40 "symbols_view.vala"
	symbols_view_create_clear_button (self);
#line 43 "symbols_view.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
#line 44 "symbols_view.vala"
	gtk_grid_set_row_spacing ((GtkGrid*) self, (guint) 3);
#line 46 "symbols_view.vala"
	_tmp0_ = self->priv->_combo_box;
#line 46 "symbols_view.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp0_);
#line 48 "symbols_view.vala"
	_tmp1_ = self->priv->_symbol_view;
#line 48 "symbols_view.vala"
	_tmp2_ = utils_add_scrollbar ((GtkWidget*) _tmp1_);
#line 48 "symbols_view.vala"
	sw = _tmp2_;
#line 49 "symbols_view.vala"
	gtk_scrolled_window_set_shadow_type (sw, GTK_SHADOW_IN);
#line 50 "symbols_view.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) sw);
#line 52 "symbols_view.vala"
	_tmp3_ = self->priv->_clear_button;
#line 52 "symbols_view.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp3_);
#line 54 "symbols_view.vala"
	gtk_widget_show_all ((GtkWidget*) self);
#line 56 "symbols_view.vala"
	_tmp4_ = self->priv->_combo_box;
#line 56 "symbols_view.vala"
	gtk_combo_box_set_active (_tmp4_, 0);
#line 34 "symbols_view.vala"
	_g_object_unref0 (sw);
#line 34 "symbols_view.vala"
	return self;
#line 276 "symbols_view.c"
}

SymbolsView*
symbols_view_new (MainWindow* main_window)
{
#line 34 "symbols_view.vala"
	return symbols_view_construct (TYPE_SYMBOLS_VIEW, main_window);
#line 284 "symbols_view.c"
}

static Block31Data*
block31_data_ref (Block31Data* _data31_)
{
#line 59 "symbols_view.vala"
	g_atomic_int_inc (&_data31_->_ref_count_);
#line 59 "symbols_view.vala"
	return _data31_;
#line 294 "symbols_view.c"
}

static void
block31_data_unref (void * _userdata_)
{
	Block31Data* _data31_;
	_data31_ = (Block31Data*) _userdata_;
#line 59 "symbols_view.vala"
	if (g_atomic_int_dec_and_test (&_data31_->_ref_count_)) {
#line 304 "symbols_view.c"
		SymbolsView* self;
#line 59 "symbols_view.vala"
		self = _data31_->self;
#line 59 "symbols_view.vala"
		_g_object_unref0 (_data31_->categories_model);
#line 59 "symbols_view.vala"
		_g_object_unref0 (self);
#line 59 "symbols_view.vala"
		g_slice_free (Block31Data, _data31_);
#line 314 "symbols_view.c"
	}
}

static void
__lambda65_ (Block31Data* _data31_)
{
	SymbolsView* self;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	GtkComboBox* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	GtkListStore* store = NULL;
	SymbolsCategoryType type = 0;
	GtkTreeIter _tmp4_;
	GtkListStore* _tmp5_ = NULL;
	SymbolsCategoryType _tmp6_ = 0;
	GtkIconView* _tmp7_;
	SymbolsCategoryType _tmp10_;
#line 79 "symbols_view.vala"
	self = _data31_->self;
#line 81 "symbols_view.vala"
	iter = _tmp0_;
#line 83 "symbols_view.vala"
	_tmp1_ = self->priv->_combo_box;
#line 83 "symbols_view.vala"
	_tmp3_ = gtk_combo_box_get_active_iter (_tmp1_, &_tmp2_);
#line 83 "symbols_view.vala"
	iter = _tmp2_;
#line 83 "symbols_view.vala"
	if (!_tmp3_) {
#line 84 "symbols_view.vala"
		return;
#line 348 "symbols_view.c"
	}
#line 89 "symbols_view.vala"
	_tmp4_ = iter;
#line 89 "symbols_view.vala"
	gtk_tree_model_get (_data31_->categories_model, &_tmp4_, SYMBOLS_CATEGORY_COLUMN_SYMBOLS_STORE, &_tmp5_, SYMBOLS_CATEGORY_COLUMN_TYPE, &_tmp6_, -1);
#line 89 "symbols_view.vala"
	_g_object_unref0 (store);
#line 89 "symbols_view.vala"
	store = _tmp5_;
#line 89 "symbols_view.vala"
	type = _tmp6_;
#line 94 "symbols_view.vala"
	_tmp7_ = self->priv->_symbol_view;
#line 94 "symbols_view.vala"
	if (_tmp7_ != NULL) {
#line 364 "symbols_view.c"
		GtkIconView* _tmp8_;
		GtkListStore* _tmp9_;
#line 95 "symbols_view.vala"
		_tmp8_ = self->priv->_symbol_view;
#line 95 "symbols_view.vala"
		_tmp9_ = store;
#line 95 "symbols_view.vala"
		gtk_icon_view_set_model (_tmp8_, (GtkTreeModel*) _tmp9_);
#line 373 "symbols_view.c"
	}
#line 97 "symbols_view.vala"
	_tmp10_ = type;
#line 97 "symbols_view.vala"
	if (_tmp10_ == SYMBOLS_CATEGORY_TYPE_MOST_USED) {
#line 379 "symbols_view.c"
		GtkButton* _tmp11_;
#line 98 "symbols_view.vala"
		_tmp11_ = self->priv->_clear_button;
#line 98 "symbols_view.vala"
		gtk_widget_show ((GtkWidget*) _tmp11_);
#line 385 "symbols_view.c"
	} else {
		GtkButton* _tmp12_;
#line 100 "symbols_view.vala"
		_tmp12_ = self->priv->_clear_button;
#line 100 "symbols_view.vala"
		gtk_widget_hide ((GtkWidget*) _tmp12_);
#line 392 "symbols_view.c"
	}
#line 79 "symbols_view.vala"
	_g_object_unref0 (store);
#line 396 "symbols_view.c"
}

static void
___lambda65__gtk_combo_box_changed (GtkComboBox* _sender,
                                    gpointer self)
{
#line 79 "symbols_view.vala"
	__lambda65_ (self);
#line 405 "symbols_view.c"
}

static void
symbols_view_create_combo_box (SymbolsView* self)
{
	Block31Data* _data31_;
	Symbols* _tmp0_;
	Symbols* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkComboBox* _tmp4_;
	GtkComboBox* _tmp5_;
	GtkComboBox* _tmp6_;
	GtkCellRendererPixbuf* pixbuf_renderer = NULL;
	GtkCellRendererPixbuf* _tmp7_;
	GtkComboBox* _tmp8_;
	GtkComboBox* _tmp9_;
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp10_;
	GtkComboBox* _tmp11_;
	GtkComboBox* _tmp12_;
	GtkComboBox* _tmp13_;
#line 59 "symbols_view.vala"
	g_return_if_fail (self != NULL);
#line 59 "symbols_view.vala"
	_data31_ = g_slice_new0 (Block31Data);
#line 59 "symbols_view.vala"
	_data31_->_ref_count_ = 1;
#line 59 "symbols_view.vala"
	_data31_->self = g_object_ref (self);
#line 61 "symbols_view.vala"
	_tmp0_ = symbols_get_default ();
#line 61 "symbols_view.vala"
	_tmp1_ = _tmp0_;
#line 61 "symbols_view.vala"
	_tmp2_ = symbols_get_categories_model (_tmp1_);
#line 61 "symbols_view.vala"
	_tmp3_ = _tmp2_;
#line 61 "symbols_view.vala"
	_g_object_unref0 (_tmp1_);
#line 61 "symbols_view.vala"
	_data31_->categories_model = _tmp3_;
#line 63 "symbols_view.vala"
	_tmp4_ = (GtkComboBox*) gtk_combo_box_new_with_model (_data31_->categories_model);
#line 63 "symbols_view.vala"
	g_object_ref_sink (_tmp4_);
#line 63 "symbols_view.vala"
	_g_object_unref0 (self->priv->_combo_box);
#line 63 "symbols_view.vala"
	self->priv->_combo_box = _tmp4_;
#line 64 "symbols_view.vala"
	_tmp5_ = self->priv->_combo_box;
#line 64 "symbols_view.vala"
	gtk_widget_set_hexpand ((GtkWidget*) _tmp5_, TRUE);
#line 65 "symbols_view.vala"
	_tmp6_ = self->priv->_combo_box;
#line 65 "symbols_view.vala"
	gtk_widget_set_margin_end ((GtkWidget*) _tmp6_, 3);
#line 67 "symbols_view.vala"
	_tmp7_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
#line 67 "symbols_view.vala"
	g_object_ref_sink (_tmp7_);
#line 67 "symbols_view.vala"
	pixbuf_renderer = _tmp7_;
#line 68 "symbols_view.vala"
	_tmp8_ = self->priv->_combo_box;
#line 68 "symbols_view.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp8_, (GtkCellRenderer*) pixbuf_renderer, FALSE);
#line 69 "symbols_view.vala"
	_tmp9_ = self->priv->_combo_box;
#line 69 "symbols_view.vala"
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp9_, (GtkCellRenderer*) pixbuf_renderer, "icon-name", SYMBOLS_CATEGORY_COLUMN_ICON, NULL, NULL);
#line 72 "symbols_view.vala"
	_tmp10_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 72 "symbols_view.vala"
	g_object_ref_sink (_tmp10_);
#line 72 "symbols_view.vala"
	text_renderer = _tmp10_;
#line 73 "symbols_view.vala"
	g_object_set (text_renderer, "ellipsize-set", TRUE, NULL);
#line 74 "symbols_view.vala"
	g_object_set (text_renderer, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
#line 75 "symbols_view.vala"
	_tmp11_ = self->priv->_combo_box;
#line 75 "symbols_view.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp11_, (GtkCellRenderer*) text_renderer, TRUE);
#line 76 "symbols_view.vala"
	_tmp12_ = self->priv->_combo_box;
#line 76 "symbols_view.vala"
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp12_, (GtkCellRenderer*) text_renderer, "text", SYMBOLS_CATEGORY_COLUMN_NAME, NULL, NULL);
#line 79 "symbols_view.vala"
	_tmp13_ = self->priv->_combo_box;
#line 79 "symbols_view.vala"
	g_signal_connect_data (_tmp13_, "changed", (GCallback) ___lambda65__gtk_combo_box_changed, block31_data_ref (_data31_), (GClosureNotify) block31_data_unref, 0);
#line 59 "symbols_view.vala"
	_g_object_unref0 (text_renderer);
#line 59 "symbols_view.vala"
	_g_object_unref0 (pixbuf_renderer);
#line 59 "symbols_view.vala"
	block31_data_unref (_data31_);
#line 59 "symbols_view.vala"
	_data31_ = NULL;
#line 508 "symbols_view.c"
}

static GtkTreePath*
_vala_GtkTreePath_copy (GtkTreePath* self)
{
#line 129 "symbols_view.vala"
	return g_boxed_copy (gtk_tree_path_get_type (), self);
#line 516 "symbols_view.c"
}

static gpointer
__vala_GtkTreePath_copy0 (gpointer self)
{
#line 129 "symbols_view.vala"
	return self ? _vala_GtkTreePath_copy (self) : NULL;
#line 524 "symbols_view.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 130 "symbols_view.vala"
	return self ? g_object_ref (self) : NULL;
#line 532 "symbols_view.c"
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
#line 1570 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1571 "glib-2.0.vapi"
	result = self;
#line 1571 "glib-2.0.vapi"
	return result;
#line 545 "symbols_view.c"
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
#line 116 "symbols_view.vala"
	g_boxed_free (gtk_tree_path_get_type (), self);
#line 553 "symbols_view.c"
}

static void
__vala_GtkTreePath_free0_ (gpointer var)
{
#line 116 "symbols_view.vala"
	(var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL));
#line 561 "symbols_view.c"
}

static inline void
_g_list_free___vala_GtkTreePath_free0_ (GList* self)
{
#line 116 "symbols_view.vala"
	g_list_free_full (self, (GDestroyNotify) __vala_GtkTreePath_free0_);
#line 569 "symbols_view.c"
}

static void
__lambda66_ (SymbolsView* self)
{
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	GList* selected_items = NULL;
	GtkIconView* _tmp4_;
	GList* _tmp5_;
	GtkIconView* _tmp6_;
	GtkTreePath* path = NULL;
	GList* _tmp7_;
	gconstpointer _tmp8_;
	GtkTreePath* _tmp9_;
	GtkTreeModel* model = NULL;
	GtkIconView* _tmp10_;
	GtkTreeModel* _tmp11_;
	GtkTreeModel* _tmp12_;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp13_ = {0};
	gboolean _tmp14_ = FALSE;
	GtkTreePath* _tmp15_;
#line 118 "symbols_view.vala"
	_tmp0_ = self->priv->_main_window;
#line 118 "symbols_view.vala"
	_tmp1_ = main_window_get_active_tab (_tmp0_);
#line 118 "symbols_view.vala"
	_tmp2_ = _tmp1_;
#line 118 "symbols_view.vala"
	if (_tmp2_ == NULL) {
#line 602 "symbols_view.c"
		GtkIconView* _tmp3_;
#line 120 "symbols_view.vala"
		_tmp3_ = self->priv->_symbol_view;
#line 120 "symbols_view.vala"
		gtk_icon_view_unselect_all (_tmp3_);
#line 121 "symbols_view.vala"
		return;
#line 610 "symbols_view.c"
	}
#line 124 "symbols_view.vala"
	_tmp4_ = self->priv->_symbol_view;
#line 124 "symbols_view.vala"
	_tmp5_ = gtk_icon_view_get_selected_items (_tmp4_);
#line 124 "symbols_view.vala"
	selected_items = _tmp5_;
#line 127 "symbols_view.vala"
	_tmp6_ = self->priv->_symbol_view;
#line 127 "symbols_view.vala"
	gtk_icon_view_unselect_all (_tmp6_);
#line 129 "symbols_view.vala"
	_tmp7_ = selected_items;
#line 129 "symbols_view.vala"
	_tmp8_ = g_list_nth_data (_tmp7_, (guint) 0);
#line 129 "symbols_view.vala"
	_tmp9_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) _tmp8_);
#line 129 "symbols_view.vala"
	path = _tmp9_;
#line 130 "symbols_view.vala"
	_tmp10_ = self->priv->_symbol_view;
#line 130 "symbols_view.vala"
	_tmp11_ = gtk_icon_view_get_model (_tmp10_);
#line 130 "symbols_view.vala"
	_tmp12_ = _g_object_ref0 (_tmp11_);
#line 130 "symbols_view.vala"
	model = _tmp12_;
#line 131 "symbols_view.vala"
	iter = _tmp13_;
#line 133 "symbols_view.vala"
	_tmp15_ = path;
#line 133 "symbols_view.vala"
	if (_tmp15_ != NULL) {
#line 644 "symbols_view.c"
		GtkTreeModel* _tmp16_;
		GtkTreePath* _tmp17_;
		GtkTreeIter _tmp18_ = {0};
		gboolean _tmp19_;
#line 133 "symbols_view.vala"
		_tmp16_ = model;
#line 133 "symbols_view.vala"
		_tmp17_ = path;
#line 133 "symbols_view.vala"
		_tmp19_ = gtk_tree_model_get_iter (_tmp16_, &_tmp18_, _tmp17_);
#line 133 "symbols_view.vala"
		iter = _tmp18_;
#line 133 "symbols_view.vala"
		_tmp14_ = _tmp19_;
#line 659 "symbols_view.c"
	} else {
#line 133 "symbols_view.vala"
		_tmp14_ = FALSE;
#line 663 "symbols_view.c"
	}
#line 133 "symbols_view.vala"
	if (_tmp14_) {
#line 667 "symbols_view.c"
		gchar* latex_command = NULL;
		gchar* id = NULL;
		GtkTreeModel* _tmp20_;
		GtkTreeIter _tmp21_;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		MainWindow* _tmp24_;
		Document* _tmp25_;
		Document* _tmp26_;
		MainWindow* _tmp27_;
		Document* _tmp28_;
		Document* _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		MainWindow* _tmp34_;
		Document* _tmp35_;
		Document* _tmp36_;
		MainWindow* _tmp37_;
		DocumentView* _tmp38_;
		DocumentView* _tmp39_;
		MostUsedSymbols* _tmp40_;
		MostUsedSymbols* _tmp41_;
		const gchar* _tmp42_;
#line 138 "symbols_view.vala"
		_tmp20_ = model;
#line 138 "symbols_view.vala"
		_tmp21_ = iter;
#line 138 "symbols_view.vala"
		gtk_tree_model_get (_tmp20_, &_tmp21_, SYMBOL_COLUMN_COMMAND, &_tmp22_, SYMBOL_COLUMN_ID, &_tmp23_, -1);
#line 138 "symbols_view.vala"
		_g_free0 (latex_command);
#line 138 "symbols_view.vala"
		latex_command = _tmp22_;
#line 138 "symbols_view.vala"
		_g_free0 (id);
#line 138 "symbols_view.vala"
		id = _tmp23_;
#line 144 "symbols_view.vala"
		_tmp24_ = self->priv->_main_window;
#line 144 "symbols_view.vala"
		_tmp25_ = main_window_get_active_document (_tmp24_);
#line 144 "symbols_view.vala"
		_tmp26_ = _tmp25_;
#line 144 "symbols_view.vala"
		gtk_text_buffer_begin_user_action ((GtkTextBuffer*) _tmp26_);
#line 145 "symbols_view.vala"
		_tmp27_ = self->priv->_main_window;
#line 145 "symbols_view.vala"
		_tmp28_ = main_window_get_active_document (_tmp27_);
#line 145 "symbols_view.vala"
		_tmp29_ = _tmp28_;
#line 145 "symbols_view.vala"
		_tmp30_ = latex_command;
#line 145 "symbols_view.vala"
		_tmp31_ = string_to_string (_tmp30_);
#line 145 "symbols_view.vala"
		_tmp32_ = g_strconcat (_tmp31_, " ", NULL);
#line 145 "symbols_view.vala"
		_tmp33_ = _tmp32_;
#line 145 "symbols_view.vala"
		gtk_text_buffer_insert_at_cursor ((GtkTextBuffer*) _tmp29_, _tmp33_, -1);
#line 145 "symbols_view.vala"
		_g_free0 (_tmp33_);
#line 146 "symbols_view.vala"
		_tmp34_ = self->priv->_main_window;
#line 146 "symbols_view.vala"
		_tmp35_ = main_window_get_active_document (_tmp34_);
#line 146 "symbols_view.vala"
		_tmp36_ = _tmp35_;
#line 146 "symbols_view.vala"
		gtk_text_buffer_end_user_action ((GtkTextBuffer*) _tmp36_);
#line 147 "symbols_view.vala"
		_tmp37_ = self->priv->_main_window;
#line 147 "symbols_view.vala"
		_tmp38_ = main_window_get_active_view (_tmp37_);
#line 147 "symbols_view.vala"
		_tmp39_ = _tmp38_;
#line 147 "symbols_view.vala"
		gtk_widget_grab_focus ((GtkWidget*) _tmp39_);
#line 150 "symbols_view.vala"
		_tmp40_ = most_used_symbols_get_default ();
#line 150 "symbols_view.vala"
		_tmp41_ = _tmp40_;
#line 150 "symbols_view.vala"
		_tmp42_ = id;
#line 150 "symbols_view.vala"
		most_used_symbols_increment_symbol (_tmp41_, _tmp42_);
#line 150 "symbols_view.vala"
		_g_object_unref0 (_tmp41_);
#line 133 "symbols_view.vala"
		_g_free0 (id);
#line 133 "symbols_view.vala"
		_g_free0 (latex_command);
#line 763 "symbols_view.c"
	}
#line 116 "symbols_view.vala"
	_g_object_unref0 (model);
#line 116 "symbols_view.vala"
	__vala_GtkTreePath_free0 (path);
#line 116 "symbols_view.vala"
	(selected_items == NULL) ? NULL : (selected_items = (_g_list_free___vala_GtkTreePath_free0_ (selected_items), NULL));
#line 771 "symbols_view.c"
}

static void
___lambda66__gtk_icon_view_selection_changed (GtkIconView* _sender,
                                              gpointer self)
{
#line 116 "symbols_view.vala"
	__lambda66_ ((SymbolsView*) self);
#line 780 "symbols_view.c"
}

static void
symbols_view_create_icon_view (SymbolsView* self)
{
	GtkIconView* _tmp0_;
	GtkIconView* _tmp1_;
	GtkIconView* _tmp2_;
	GtkIconView* _tmp3_;
	GtkIconView* _tmp4_;
	GtkIconView* _tmp5_;
	GtkIconView* _tmp6_;
	GtkIconView* _tmp7_;
	GtkIconView* _tmp8_;
#line 104 "symbols_view.vala"
	g_return_if_fail (self != NULL);
#line 107 "symbols_view.vala"
	_tmp0_ = (GtkIconView*) gtk_icon_view_new ();
#line 107 "symbols_view.vala"
	g_object_ref_sink (_tmp0_);
#line 107 "symbols_view.vala"
	_g_object_unref0 (self->priv->_symbol_view);
#line 107 "symbols_view.vala"
	self->priv->_symbol_view = _tmp0_;
#line 108 "symbols_view.vala"
	_tmp1_ = self->priv->_symbol_view;
#line 108 "symbols_view.vala"
	gtk_icon_view_set_pixbuf_column (_tmp1_, (gint) SYMBOL_COLUMN_PIXBUF);
#line 109 "symbols_view.vala"
	_tmp2_ = self->priv->_symbol_view;
#line 109 "symbols_view.vala"
	gtk_icon_view_set_tooltip_column (_tmp2_, (gint) SYMBOL_COLUMN_TOOLTIP);
#line 110 "symbols_view.vala"
	_tmp3_ = self->priv->_symbol_view;
#line 110 "symbols_view.vala"
	gtk_icon_view_set_selection_mode (_tmp3_, GTK_SELECTION_SINGLE);
#line 111 "symbols_view.vala"
	_tmp4_ = self->priv->_symbol_view;
#line 111 "symbols_view.vala"
	gtk_icon_view_set_spacing (_tmp4_, 0);
#line 112 "symbols_view.vala"
	_tmp5_ = self->priv->_symbol_view;
#line 112 "symbols_view.vala"
	gtk_icon_view_set_row_spacing (_tmp5_, 0);
#line 113 "symbols_view.vala"
	_tmp6_ = self->priv->_symbol_view;
#line 113 "symbols_view.vala"
	gtk_icon_view_set_column_spacing (_tmp6_, 0);
#line 114 "symbols_view.vala"
	_tmp7_ = self->priv->_symbol_view;
#line 114 "symbols_view.vala"
	g_object_set ((GtkWidget*) _tmp7_, "expand", TRUE, NULL);
#line 116 "symbols_view.vala"
	_tmp8_ = self->priv->_symbol_view;
#line 116 "symbols_view.vala"
	g_signal_connect_object (_tmp8_, "selection-changed", (GCallback) ___lambda66__gtk_icon_view_selection_changed, self, 0);
#line 837 "symbols_view.c"
}

static void
__lambda67_ (SymbolsView* self)
{
	MostUsedSymbols* _tmp0_;
	MostUsedSymbols* _tmp1_;
#line 163 "symbols_view.vala"
	_tmp0_ = most_used_symbols_get_default ();
#line 163 "symbols_view.vala"
	_tmp1_ = _tmp0_;
#line 163 "symbols_view.vala"
	most_used_symbols_clear (_tmp1_);
#line 163 "symbols_view.vala"
	_g_object_unref0 (_tmp1_);
#line 853 "symbols_view.c"
}

static void
___lambda67__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 161 "symbols_view.vala"
	__lambda67_ ((SymbolsView*) self);
#line 862 "symbols_view.c"
}

static void
symbols_view_create_clear_button (SymbolsView* self)
{
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
#line 155 "symbols_view.vala"
	g_return_if_fail (self != NULL);
#line 157 "symbols_view.vala"
	_tmp0_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Clear"));
#line 157 "symbols_view.vala"
	g_object_ref_sink (_tmp0_);
#line 157 "symbols_view.vala"
	_g_object_unref0 (self->priv->_clear_button);
#line 157 "symbols_view.vala"
	self->priv->_clear_button = _tmp0_;
#line 158 "symbols_view.vala"
	_tmp1_ = self->priv->_clear_button;
#line 158 "symbols_view.vala"
	gtk_widget_set_margin_end ((GtkWidget*) _tmp1_, 3);
#line 159 "symbols_view.vala"
	_tmp2_ = self->priv->_clear_button;
#line 159 "symbols_view.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp2_, _ ("Clear most used symbols"));
#line 161 "symbols_view.vala"
	_tmp3_ = self->priv->_clear_button;
#line 161 "symbols_view.vala"
	g_signal_connect_object (_tmp3_, "clicked", (GCallback) ___lambda67__gtk_button_clicked, self, 0);
#line 894 "symbols_view.c"
}

static void
symbols_view_class_init (SymbolsViewClass * klass,
                         gpointer klass_data)
{
#line 27 "symbols_view.vala"
	symbols_view_parent_class = g_type_class_peek_parent (klass);
#line 27 "symbols_view.vala"
	g_type_class_adjust_private_offset (klass, &SymbolsView_private_offset);
#line 27 "symbols_view.vala"
	G_OBJECT_CLASS (klass)->finalize = symbols_view_finalize;
#line 907 "symbols_view.c"
}

static void
symbols_view_instance_init (SymbolsView * self,
                            gpointer klass)
{
#line 27 "symbols_view.vala"
	self->priv = symbols_view_get_instance_private (self);
#line 916 "symbols_view.c"
}

static void
symbols_view_finalize (GObject * obj)
{
	SymbolsView * self;
#line 27 "symbols_view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SYMBOLS_VIEW, SymbolsView);
#line 30 "symbols_view.vala"
	_g_object_unref0 (self->priv->_combo_box);
#line 31 "symbols_view.vala"
	_g_object_unref0 (self->priv->_symbol_view);
#line 32 "symbols_view.vala"
	_g_object_unref0 (self->priv->_clear_button);
#line 27 "symbols_view.vala"
	G_OBJECT_CLASS (symbols_view_parent_class)->finalize (obj);
#line 933 "symbols_view.c"
}

static GType
symbols_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SymbolsViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) symbols_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SymbolsView), 0, (GInstanceInitFunc) symbols_view_instance_init, NULL };
	GType symbols_view_type_id;
	symbols_view_type_id = g_type_register_static (gtk_grid_get_type (), "SymbolsView", &g_define_type_info, 0);
	SymbolsView_private_offset = g_type_add_instance_private (symbols_view_type_id, sizeof (SymbolsViewPrivate));
	return symbols_view_type_id;
}

GType
symbols_view_get_type (void)
{
	static volatile gsize symbols_view_type_id__volatile = 0;
	if (g_once_init_enter (&symbols_view_type_id__volatile)) {
		GType symbols_view_type_id;
		symbols_view_type_id = symbols_view_get_type_once ();
		g_once_init_leave (&symbols_view_type_id__volatile, symbols_view_type_id);
	}
	return symbols_view_type_id__volatile;
}

