/* preferences_dialog.c generated by valac 0.48.9, the Vala compiler
 * generated from preferences_dialog.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include "config.h"
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <latexila.h>
#include <tepl/tepl.h>
#include <gspell/gspell.h>
#include <float.h>
#include <math.h>

#define TYPE_PREFERENCES_DIALOG (preferences_dialog_get_type ())
#define PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialog))
#define PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))
#define IS_PREFERENCES_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREFERENCES_DIALOG))
#define IS_PREFERENCES_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREFERENCES_DIALOG))
#define PREFERENCES_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREFERENCES_DIALOG, PreferencesDialogClass))

typedef struct _PreferencesDialog PreferencesDialog;
typedef struct _PreferencesDialogClass PreferencesDialogClass;
typedef struct _PreferencesDialogPrivate PreferencesDialogPrivate;
enum  {
	PREFERENCES_DIALOG_0_PROPERTY,
	PREFERENCES_DIALOG_NUM_PROPERTIES
};
static GParamSpec* preferences_dialog_properties[PREFERENCES_DIALOG_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef const gchar* (*PreferencesDialogPlural) (gulong n, gpointer user_data);
typedef struct _Block24Data Block24Data;

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;
typedef struct _Block25Data Block25Data;
#define _g_settings_schema_key_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_key_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_settings_schema_unref0(var) ((var == NULL) ? NULL : (var = (g_settings_schema_unref (var), NULL)))

struct _PreferencesDialog {
	GtkDialog parent_instance;
	PreferencesDialogPrivate * priv;
};

struct _PreferencesDialogClass {
	GtkDialogClass parent_class;
};

struct _Block24Data {
	int _ref_count_;
	PreferencesDialog* self;
	GtkButton* default_font_checkbutton;
};

struct _Block25Data {
	int _ref_count_;
	PreferencesDialog* self;
	GtkLabel* label;
	PreferencesDialogPlural plural;
	gpointer plural_target;
};

static gpointer preferences_dialog_parent_class = NULL;
static PreferencesDialog* preferences_dialog__instance;
static PreferencesDialog* preferences_dialog__instance = NULL;

GType preferences_dialog_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PreferencesDialog, g_object_unref)
static PreferencesDialog* preferences_dialog_new (void);
static PreferencesDialog* preferences_dialog_construct (GType object_type);
static void __lambda84_ (PreferencesDialog* self);
static void preferences_dialog_reset_all (PreferencesDialog* self);
static void ___lambda84__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void preferences_dialog_init_editor_tab (PreferencesDialog* self,
                                         GtkBuilder* builder);
static void preferences_dialog_init_font_and_colors_tab (PreferencesDialog* self,
                                                  GtkBuilder* builder);
static void preferences_dialog_init_interactive_completion_setting (PreferencesDialog* self,
                                                             GtkBuilder* builder);
static void preferences_dialog_init_spell_checking_settings (PreferencesDialog* self,
                                                      GtkBuilder* builder);
static void preferences_dialog_init_other_tab (PreferencesDialog* self,
                                        GtkBuilder* builder);
void preferences_dialog_show_me (GtkWindow* parent);
static gboolean ___lambda89_ (void);
static gboolean ____lambda89__gtk_widget_delete_event (GtkWidget* _sender,
                                                GdkEventAny* event,
                                                gpointer self);
static void ___lambda90_ (void);
static void ____lambda90__gtk_widget_destroy (GtkWidget* _sender,
                                       gpointer self);
static void preferences_dialog_set_spin_button_range (PreferencesDialog* self,
                                               GtkSpinButton* spin_button,
                                               GSettings* settings,
                                               const gchar* key);
static void preferences_dialog_set_plural (PreferencesDialog* self,
                                    GtkLabel* label,
                                    GSettings* settings,
                                    const gchar* key,
                                    PreferencesDialogPlural plural,
                                    gpointer plural_target);
static const gchar* __lambda86_ (PreferencesDialog* self,
                          gulong n);
static const gchar* ___lambda86__preferences_dialog_plural (gulong n,
                                                     gpointer self);
static Block24Data* block24_data_ref (Block24Data* _data24_);
static void block24_data_unref (void * _userdata_);
static void preferences_dialog_set_system_font_label (PreferencesDialog* self,
                                               GtkButton* button);
GType app_settings_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppSettings, g_object_unref)
AppSettings* app_settings_get_default (void);
static void __lambda87_ (Block24Data* _data24_);
static void ___lambda87__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static const gchar* __lambda88_ (PreferencesDialog* self,
                          gulong n);
static const gchar* ___lambda88__preferences_dialog_plural (gulong n,
                                                     gpointer self);
const gchar* app_settings_get_system_font (AppSettings* self);
static Block25Data* block25_data_ref (Block25Data* _data25_);
static void block25_data_unref (void * _userdata_);
static void __lambda85_ (Block25Data* _data25_,
                  GSettings* setting,
                  const gchar* k);
static void ___lambda85__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void preferences_dialog_finalize (GObject * obj);
static GType preferences_dialog_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static gpointer
_g_object_ref0 (gpointer self)
{
#line 37 "preferences_dialog.vala"
	return self ? g_object_ref (self) : NULL;
#line 180 "preferences_dialog.c"
}

static void
__lambda84_ (PreferencesDialog* self)
{
#line 45 "preferences_dialog.vala"
	preferences_dialog_reset_all (self);
#line 188 "preferences_dialog.c"
}

static void
___lambda84__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 45 "preferences_dialog.vala"
	__lambda84_ ((PreferencesDialog*) self);
#line 197 "preferences_dialog.c"
}

static PreferencesDialog*
preferences_dialog_construct (GType object_type)
{
	PreferencesDialog * self = NULL;
	GtkHeaderBar* headerbar = NULL;
	GtkHeaderBar* _tmp0_;
	GtkHeaderBar* _tmp1_;
	GtkHeaderBar* _tmp2_;
	GtkButton* reset_button = NULL;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkButton* _tmp6_;
	GtkHeaderBar* _tmp7_;
	GtkButton* _tmp8_;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp9_;
	GtkBuilder* _tmp25_;
	GtkBuilder* _tmp26_;
	GtkBuilder* _tmp27_;
	GtkBuilder* _tmp28_;
	GtkBuilder* _tmp29_;
	GtkNotebook* notebook = NULL;
	GtkBuilder* _tmp30_;
	GObject* _tmp31_;
	GtkNotebook* _tmp32_;
	GtkNotebook* _tmp33_;
	GtkBox* content_area = NULL;
	GtkBox* _tmp34_;
	GtkBox* _tmp35_;
	GtkBox* _tmp36_;
	GtkNotebook* _tmp37_;
	GError* _inner_error0_ = NULL;
#line 31 "preferences_dialog.vala"
	self = (PreferencesDialog*) g_object_new (object_type, "use-header-bar", 1, NULL);
#line 33 "preferences_dialog.vala"
	gtk_window_set_title ((GtkWindow*) self, _ ("Preferences"));
#line 34 "preferences_dialog.vala"
	gtk_window_set_destroy_with_parent ((GtkWindow*) self, TRUE);
#line 35 "preferences_dialog.vala"
	gtk_container_set_border_width ((GtkContainer*) self, (guint) 5);
#line 37 "preferences_dialog.vala"
	_tmp0_ = gtk_dialog_get_header_bar ((GtkDialog*) self);
#line 37 "preferences_dialog.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_header_bar_get_type ()) ? ((GtkHeaderBar*) _tmp0_) : NULL);
#line 37 "preferences_dialog.vala"
	headerbar = _tmp1_;
#line 39 "preferences_dialog.vala"
	_tmp2_ = headerbar;
#line 39 "preferences_dialog.vala"
	gtk_header_bar_set_show_close_button (_tmp2_, TRUE);
#line 42 "preferences_dialog.vala"
	_tmp3_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Reset All"));
#line 42 "preferences_dialog.vala"
	g_object_ref_sink (_tmp3_);
#line 42 "preferences_dialog.vala"
	reset_button = _tmp3_;
#line 43 "preferences_dialog.vala"
	_tmp4_ = reset_button;
#line 43 "preferences_dialog.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp4_, _ ("Reset all preferences"));
#line 44 "preferences_dialog.vala"
	_tmp5_ = reset_button;
#line 44 "preferences_dialog.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp5_);
#line 45 "preferences_dialog.vala"
	_tmp6_ = reset_button;
#line 45 "preferences_dialog.vala"
	g_signal_connect_object (_tmp6_, "clicked", (GCallback) ___lambda84__gtk_button_clicked, self, 0);
#line 46 "preferences_dialog.vala"
	_tmp7_ = headerbar;
#line 46 "preferences_dialog.vala"
	_tmp8_ = reset_button;
#line 46 "preferences_dialog.vala"
	gtk_header_bar_pack_start (_tmp7_, (GtkWidget*) _tmp8_);
#line 50 "preferences_dialog.vala"
	_tmp9_ = gtk_builder_new ();
#line 50 "preferences_dialog.vala"
	builder = _tmp9_;
#line 279 "preferences_dialog.c"
	{
		gchar* ui_path = NULL;
		gchar* _tmp10_;
		GtkBuilder* _tmp11_;
		const gchar* _tmp12_;
#line 54 "preferences_dialog.vala"
		_tmp10_ = g_build_filename (DATA_DIR, "ui", "preferences_dialog.ui", NULL);
#line 54 "preferences_dialog.vala"
		ui_path = _tmp10_;
#line 56 "preferences_dialog.vala"
		_tmp11_ = builder;
#line 56 "preferences_dialog.vala"
		_tmp12_ = ui_path;
#line 56 "preferences_dialog.vala"
		gtk_builder_add_from_file (_tmp11_, _tmp12_, &_inner_error0_);
#line 56 "preferences_dialog.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 56 "preferences_dialog.vala"
			_g_free0 (ui_path);
#line 299 "preferences_dialog.c"
			goto __catch0_g_error;
		}
#line 52 "preferences_dialog.vala"
		_g_free0 (ui_path);
#line 304 "preferences_dialog.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* message = NULL;
		GError* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		GtkLabel* label_error = NULL;
		const gchar* _tmp17_;
		GtkLabel* _tmp18_;
		GtkLabel* _tmp19_;
		GtkBox* content_area = NULL;
		GtkBox* _tmp20_;
		GtkBox* _tmp21_;
		GtkBox* _tmp22_;
		GtkLabel* _tmp23_;
		GtkBox* _tmp24_;
#line 52 "preferences_dialog.vala"
		e = _inner_error0_;
#line 52 "preferences_dialog.vala"
		_inner_error0_ = NULL;
#line 60 "preferences_dialog.vala"
		_tmp13_ = e;
#line 60 "preferences_dialog.vala"
		_tmp14_ = _tmp13_->message;
#line 60 "preferences_dialog.vala"
		_tmp15_ = g_strdup_printf ("Error: %s", _tmp14_);
#line 60 "preferences_dialog.vala"
		message = _tmp15_;
#line 61 "preferences_dialog.vala"
		_tmp16_ = message;
#line 61 "preferences_dialog.vala"
		g_warning ("preferences_dialog.vala:61: %s", _tmp16_);
#line 63 "preferences_dialog.vala"
		_tmp17_ = message;
#line 63 "preferences_dialog.vala"
		_tmp18_ = (GtkLabel*) gtk_label_new (_tmp17_);
#line 63 "preferences_dialog.vala"
		g_object_ref_sink (_tmp18_);
#line 63 "preferences_dialog.vala"
		label_error = _tmp18_;
#line 64 "preferences_dialog.vala"
		_tmp19_ = label_error;
#line 64 "preferences_dialog.vala"
		gtk_label_set_line_wrap (_tmp19_, TRUE);
#line 65 "preferences_dialog.vala"
		_tmp20_ = gtk_dialog_get_content_area ((GtkDialog*) self);
#line 65 "preferences_dialog.vala"
		_tmp21_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_box_get_type (), GtkBox));
#line 65 "preferences_dialog.vala"
		content_area = _tmp21_;
#line 66 "preferences_dialog.vala"
		_tmp22_ = content_area;
#line 66 "preferences_dialog.vala"
		_tmp23_ = label_error;
#line 66 "preferences_dialog.vala"
		gtk_box_pack_start (_tmp22_, (GtkWidget*) _tmp23_, TRUE, TRUE, (guint) 0);
#line 67 "preferences_dialog.vala"
		_tmp24_ = content_area;
#line 67 "preferences_dialog.vala"
		gtk_widget_show_all ((GtkWidget*) _tmp24_);
#line 68 "preferences_dialog.vala"
		_g_object_unref0 (content_area);
#line 68 "preferences_dialog.vala"
		_g_object_unref0 (label_error);
#line 68 "preferences_dialog.vala"
		_g_free0 (message);
#line 68 "preferences_dialog.vala"
		_g_error_free0 (e);
#line 68 "preferences_dialog.vala"
		_g_object_unref0 (builder);
#line 68 "preferences_dialog.vala"
		_g_object_unref0 (reset_button);
#line 68 "preferences_dialog.vala"
		_g_object_unref0 (headerbar);
#line 68 "preferences_dialog.vala"
		return self;
#line 385 "preferences_dialog.c"
	}
	__finally0:
#line 52 "preferences_dialog.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 52 "preferences_dialog.vala"
		_g_object_unref0 (builder);
#line 52 "preferences_dialog.vala"
		_g_object_unref0 (reset_button);
#line 52 "preferences_dialog.vala"
		_g_object_unref0 (headerbar);
#line 52 "preferences_dialog.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 52 "preferences_dialog.vala"
		g_clear_error (&_inner_error0_);
#line 52 "preferences_dialog.vala"
		return NULL;
#line 402 "preferences_dialog.c"
	}
#line 71 "preferences_dialog.vala"
	_tmp25_ = builder;
#line 71 "preferences_dialog.vala"
	preferences_dialog_init_editor_tab (self, _tmp25_);
#line 72 "preferences_dialog.vala"
	_tmp26_ = builder;
#line 72 "preferences_dialog.vala"
	preferences_dialog_init_font_and_colors_tab (self, _tmp26_);
#line 73 "preferences_dialog.vala"
	_tmp27_ = builder;
#line 73 "preferences_dialog.vala"
	preferences_dialog_init_interactive_completion_setting (self, _tmp27_);
#line 74 "preferences_dialog.vala"
	_tmp28_ = builder;
#line 74 "preferences_dialog.vala"
	preferences_dialog_init_spell_checking_settings (self, _tmp28_);
#line 75 "preferences_dialog.vala"
	_tmp29_ = builder;
#line 75 "preferences_dialog.vala"
	preferences_dialog_init_other_tab (self, _tmp29_);
#line 78 "preferences_dialog.vala"
	_tmp30_ = builder;
#line 78 "preferences_dialog.vala"
	_tmp31_ = gtk_builder_get_object (_tmp30_, "notebook");
#line 78 "preferences_dialog.vala"
	_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, gtk_notebook_get_type ()) ? ((GtkNotebook*) _tmp31_) : NULL);
#line 78 "preferences_dialog.vala"
	notebook = _tmp32_;
#line 79 "preferences_dialog.vala"
	_tmp33_ = notebook;
#line 79 "preferences_dialog.vala"
	gtk_widget_unparent ((GtkWidget*) _tmp33_);
#line 80 "preferences_dialog.vala"
	_tmp34_ = gtk_dialog_get_content_area ((GtkDialog*) self);
#line 80 "preferences_dialog.vala"
	_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_box_get_type (), GtkBox));
#line 80 "preferences_dialog.vala"
	content_area = _tmp35_;
#line 81 "preferences_dialog.vala"
	_tmp36_ = content_area;
#line 81 "preferences_dialog.vala"
	_tmp37_ = notebook;
#line 81 "preferences_dialog.vala"
	gtk_box_pack_start (_tmp36_, (GtkWidget*) _tmp37_, TRUE, TRUE, (guint) 0);
#line 29 "preferences_dialog.vala"
	_g_object_unref0 (content_area);
#line 29 "preferences_dialog.vala"
	_g_object_unref0 (notebook);
#line 29 "preferences_dialog.vala"
	_g_object_unref0 (builder);
#line 29 "preferences_dialog.vala"
	_g_object_unref0 (reset_button);
#line 29 "preferences_dialog.vala"
	_g_object_unref0 (headerbar);
#line 29 "preferences_dialog.vala"
	return self;
#line 460 "preferences_dialog.c"
}

static PreferencesDialog*
preferences_dialog_new (void)
{
#line 29 "preferences_dialog.vala"
	return preferences_dialog_construct (TYPE_PREFERENCES_DIALOG);
#line 468 "preferences_dialog.c"
}

static gboolean
___lambda89_ (void)
{
	PreferencesDialog* _tmp0_;
	gboolean result = FALSE;
#line 92 "preferences_dialog.vala"
	_tmp0_ = preferences_dialog__instance;
#line 92 "preferences_dialog.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 93 "preferences_dialog.vala"
	result = TRUE;
#line 93 "preferences_dialog.vala"
	return result;
#line 484 "preferences_dialog.c"
}

static gboolean
____lambda89__gtk_widget_delete_event (GtkWidget* _sender,
                                       GdkEventAny* event,
                                       gpointer self)
{
	gboolean result;
	result = ___lambda89_ ();
#line 90 "preferences_dialog.vala"
	return result;
#line 496 "preferences_dialog.c"
}

static void
___lambda90_ (void)
{
#line 98 "preferences_dialog.vala"
	_g_object_unref0 (preferences_dialog__instance);
#line 98 "preferences_dialog.vala"
	preferences_dialog__instance = NULL;
#line 506 "preferences_dialog.c"
}

static void
____lambda90__gtk_widget_destroy (GtkWidget* _sender,
                                  gpointer self)
{
#line 96 "preferences_dialog.vala"
	___lambda90_ ();
#line 515 "preferences_dialog.c"
}

void
preferences_dialog_show_me (GtkWindow* parent)
{
	PreferencesDialog* _tmp0_;
	PreferencesDialog* _tmp4_;
	GtkWindow* _tmp5_;
	PreferencesDialog* _tmp7_;
#line 84 "preferences_dialog.vala"
	g_return_if_fail (parent != NULL);
#line 86 "preferences_dialog.vala"
	_tmp0_ = preferences_dialog__instance;
#line 86 "preferences_dialog.vala"
	if (_tmp0_ == NULL) {
#line 531 "preferences_dialog.c"
		PreferencesDialog* _tmp1_;
		PreferencesDialog* _tmp2_;
		PreferencesDialog* _tmp3_;
#line 88 "preferences_dialog.vala"
		_tmp1_ = preferences_dialog_new ();
#line 88 "preferences_dialog.vala"
		g_object_ref_sink (_tmp1_);
#line 88 "preferences_dialog.vala"
		_g_object_unref0 (preferences_dialog__instance);
#line 88 "preferences_dialog.vala"
		preferences_dialog__instance = _tmp1_;
#line 90 "preferences_dialog.vala"
		_tmp2_ = preferences_dialog__instance;
#line 90 "preferences_dialog.vala"
		g_signal_connect ((GtkWidget*) _tmp2_, "delete-event", (GCallback) ____lambda89__gtk_widget_delete_event, NULL);
#line 96 "preferences_dialog.vala"
		_tmp3_ = preferences_dialog__instance;
#line 96 "preferences_dialog.vala"
		g_signal_connect ((GtkWidget*) _tmp3_, "destroy", (GCallback) ____lambda90__gtk_widget_destroy, NULL);
#line 551 "preferences_dialog.c"
	}
#line 102 "preferences_dialog.vala"
	_tmp4_ = preferences_dialog__instance;
#line 102 "preferences_dialog.vala"
	_tmp5_ = gtk_window_get_transient_for ((GtkWindow*) _tmp4_);
#line 102 "preferences_dialog.vala"
	if (parent != _tmp5_) {
#line 559 "preferences_dialog.c"
		PreferencesDialog* _tmp6_;
#line 103 "preferences_dialog.vala"
		_tmp6_ = preferences_dialog__instance;
#line 103 "preferences_dialog.vala"
		gtk_window_set_transient_for ((GtkWindow*) _tmp6_, parent);
#line 565 "preferences_dialog.c"
	}
#line 105 "preferences_dialog.vala"
	_tmp7_ = preferences_dialog__instance;
#line 105 "preferences_dialog.vala"
	gtk_window_present ((GtkWindow*) _tmp7_);
#line 571 "preferences_dialog.c"
}

static void
preferences_dialog_reset_all (PreferencesDialog* self)
{
	GtkDialog* dialog = NULL;
	GtkMessageDialog* _tmp0_;
	GtkDialog* _tmp1_;
	GtkDialog* _tmp2_;
	gint resp = 0;
	GtkDialog* _tmp3_;
	GtkDialog* _tmp4_;
	gchar** settings_str = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint settings_str_length1;
	gint _settings_str_size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
#line 108 "preferences_dialog.vala"
	g_return_if_fail (self != NULL);
#line 110 "preferences_dialog.vala"
	_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _ ("Do you really want to reset all preferences?"));
#line 110 "preferences_dialog.vala"
	g_object_ref_sink (_tmp0_);
#line 110 "preferences_dialog.vala"
	dialog = (GtkDialog*) _tmp0_;
#line 114 "preferences_dialog.vala"
	_tmp1_ = dialog;
#line 114 "preferences_dialog.vala"
	gtk_dialog_add_button (_tmp1_, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
#line 115 "preferences_dialog.vala"
	_tmp2_ = dialog;
#line 115 "preferences_dialog.vala"
	gtk_dialog_add_button (_tmp2_, _ ("_Reset All"), (gint) GTK_RESPONSE_YES);
#line 117 "preferences_dialog.vala"
	_tmp3_ = dialog;
#line 117 "preferences_dialog.vala"
	resp = gtk_dialog_run (_tmp3_);
#line 118 "preferences_dialog.vala"
	_tmp4_ = dialog;
#line 118 "preferences_dialog.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
#line 119 "preferences_dialog.vala"
	if (resp != ((gint) GTK_RESPONSE_YES)) {
#line 120 "preferences_dialog.vala"
		_g_object_unref0 (dialog);
#line 120 "preferences_dialog.vala"
		return;
#line 622 "preferences_dialog.c"
	}
#line 122 "preferences_dialog.vala"
	_tmp5_ = g_strdup ("org.gnome.gnome-latex.preferences.editor");
#line 122 "preferences_dialog.vala"
	_tmp6_ = g_strdup ("org.gnome.gnome-latex.preferences.latex");
#line 122 "preferences_dialog.vala"
	_tmp7_ = g_new0 (gchar*, 2 + 1);
#line 122 "preferences_dialog.vala"
	_tmp7_[0] = _tmp5_;
#line 122 "preferences_dialog.vala"
	_tmp7_[1] = _tmp6_;
#line 122 "preferences_dialog.vala"
	settings_str = _tmp7_;
#line 122 "preferences_dialog.vala"
	settings_str_length1 = 2;
#line 122 "preferences_dialog.vala"
	_settings_str_size_ = settings_str_length1;
#line 128 "preferences_dialog.vala"
	_tmp8_ = settings_str;
#line 128 "preferences_dialog.vala"
	_tmp8__length1 = settings_str_length1;
#line 644 "preferences_dialog.c"
	{
		gchar** setting_str_collection = NULL;
		gint setting_str_collection_length1 = 0;
		gint _setting_str_collection_size_ = 0;
		gint setting_str_it = 0;
#line 128 "preferences_dialog.vala"
		setting_str_collection = _tmp8_;
#line 128 "preferences_dialog.vala"
		setting_str_collection_length1 = _tmp8__length1;
#line 128 "preferences_dialog.vala"
		for (setting_str_it = 0; setting_str_it < setting_str_collection_length1; setting_str_it = setting_str_it + 1) {
#line 656 "preferences_dialog.c"
			gchar* _tmp9_;
			gchar* setting_str = NULL;
#line 128 "preferences_dialog.vala"
			_tmp9_ = g_strdup (setting_str_collection[setting_str_it]);
#line 128 "preferences_dialog.vala"
			setting_str = _tmp9_;
#line 663 "preferences_dialog.c"
			{
				GSettings* settings = NULL;
				const gchar* _tmp10_;
				GSettings* _tmp11_;
				gchar** keys = NULL;
				GSettings* _tmp12_;
				gchar** _tmp13_;
				gchar** _tmp14_;
				gint keys_length1;
				gint _keys_size_;
				gchar** _tmp15_;
				gint _tmp15__length1;
#line 130 "preferences_dialog.vala"
				_tmp10_ = setting_str;
#line 130 "preferences_dialog.vala"
				_tmp11_ = g_settings_new (_tmp10_);
#line 130 "preferences_dialog.vala"
				settings = _tmp11_;
#line 131 "preferences_dialog.vala"
				_tmp12_ = settings;
#line 131 "preferences_dialog.vala"
				_tmp14_ = _tmp13_ = g_settings_list_keys (_tmp12_);
#line 131 "preferences_dialog.vala"
				keys = _tmp14_;
#line 131 "preferences_dialog.vala"
				keys_length1 = _vala_array_length (_tmp13_);
#line 131 "preferences_dialog.vala"
				_keys_size_ = keys_length1;
#line 132 "preferences_dialog.vala"
				_tmp15_ = keys;
#line 132 "preferences_dialog.vala"
				_tmp15__length1 = keys_length1;
#line 696 "preferences_dialog.c"
				{
					gchar** key_collection = NULL;
					gint key_collection_length1 = 0;
					gint _key_collection_size_ = 0;
					gint key_it = 0;
#line 132 "preferences_dialog.vala"
					key_collection = _tmp15_;
#line 132 "preferences_dialog.vala"
					key_collection_length1 = _tmp15__length1;
#line 132 "preferences_dialog.vala"
					for (key_it = 0; key_it < key_collection_length1; key_it = key_it + 1) {
#line 708 "preferences_dialog.c"
						gchar* _tmp16_;
						gchar* key = NULL;
#line 132 "preferences_dialog.vala"
						_tmp16_ = g_strdup (key_collection[key_it]);
#line 132 "preferences_dialog.vala"
						key = _tmp16_;
#line 715 "preferences_dialog.c"
						{
							GSettings* _tmp17_;
							const gchar* _tmp18_;
#line 133 "preferences_dialog.vala"
							_tmp17_ = settings;
#line 133 "preferences_dialog.vala"
							_tmp18_ = key;
#line 133 "preferences_dialog.vala"
							g_settings_reset (_tmp17_, _tmp18_);
#line 132 "preferences_dialog.vala"
							_g_free0 (key);
#line 727 "preferences_dialog.c"
						}
					}
				}
#line 128 "preferences_dialog.vala"
				keys = (_vala_array_free (keys, keys_length1, (GDestroyNotify) g_free), NULL);
#line 128 "preferences_dialog.vala"
				_g_object_unref0 (settings);
#line 128 "preferences_dialog.vala"
				_g_free0 (setting_str);
#line 737 "preferences_dialog.c"
			}
		}
	}
#line 108 "preferences_dialog.vala"
	settings_str = (_vala_array_free (settings_str, settings_str_length1, (GDestroyNotify) g_free), NULL);
#line 108 "preferences_dialog.vala"
	_g_object_unref0 (dialog);
#line 745 "preferences_dialog.c"
}

static const gchar*
__lambda86_ (PreferencesDialog* self,
             gulong n)
{
	const gchar* result = NULL;
#line 191 "preferences_dialog.vala"
	result = ngettext ("minute", "minutes", n);
#line 191 "preferences_dialog.vala"
	return result;
#line 757 "preferences_dialog.c"
}

static const gchar*
___lambda86__preferences_dialog_plural (gulong n,
                                        gpointer self)
{
	const gchar* result;
	result = __lambda86_ ((PreferencesDialog*) self, n);
#line 190 "preferences_dialog.vala"
	return result;
#line 768 "preferences_dialog.c"
}

static void
preferences_dialog_init_editor_tab (PreferencesDialog* self,
                                    GtkBuilder* builder)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	GObject* display_line_nb_checkbutton = NULL;
	GObject* _tmp1_;
	GObject* _tmp2_;
	GtkSpinButton* tab_width_spinbutton = NULL;
	GObject* _tmp3_;
	GtkSpinButton* _tmp4_;
	GObject* insert_spaces_checkbutton = NULL;
	GObject* _tmp5_;
	GObject* _tmp6_;
	GtkWidget* forget_no_tabs = NULL;
	GObject* _tmp7_;
	GtkWidget* _tmp8_;
	GObject* hl_current_line_checkbutton = NULL;
	GObject* _tmp9_;
	GObject* _tmp10_;
	GObject* bracket_matching_checkbutton = NULL;
	GObject* _tmp11_;
	GObject* _tmp12_;
	GObject* backup_checkbutton = NULL;
	GObject* _tmp13_;
	GObject* _tmp14_;
	GObject* autosave_checkbutton = NULL;
	GObject* _tmp15_;
	GObject* _tmp16_;
	GtkSpinButton* autosave_spinbutton = NULL;
	GObject* _tmp17_;
	GtkSpinButton* _tmp18_;
	GtkLabel* autosave_label = NULL;
	GObject* _tmp19_;
	GtkLabel* _tmp20_;
	GObject* reopen_checkbutton = NULL;
	GObject* _tmp21_;
	GObject* _tmp22_;
#line 137 "preferences_dialog.vala"
	g_return_if_fail (self != NULL);
#line 137 "preferences_dialog.vala"
	g_return_if_fail (builder != NULL);
#line 139 "preferences_dialog.vala"
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.preferences.editor");
#line 139 "preferences_dialog.vala"
	settings = _tmp0_;
#line 142 "preferences_dialog.vala"
	_tmp1_ = gtk_builder_get_object (builder, "display_line_nb_checkbutton");
#line 142 "preferences_dialog.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 142 "preferences_dialog.vala"
	display_line_nb_checkbutton = _tmp2_;
#line 144 "preferences_dialog.vala"
	g_settings_bind (settings, "display-line-numbers", display_line_nb_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
#line 147 "preferences_dialog.vala"
	_tmp3_ = gtk_builder_get_object (builder, "tab_width_spinbutton");
#line 147 "preferences_dialog.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_spin_button_get_type ()) ? ((GtkSpinButton*) _tmp3_) : NULL);
#line 147 "preferences_dialog.vala"
	tab_width_spinbutton = _tmp4_;
#line 149 "preferences_dialog.vala"
	preferences_dialog_set_spin_button_range (self, tab_width_spinbutton, settings, "tabs-size");
#line 150 "preferences_dialog.vala"
	g_settings_bind (settings, "tabs-size", (GObject*) tab_width_spinbutton, "value", G_SETTINGS_BIND_DEFAULT);
#line 153 "preferences_dialog.vala"
	_tmp5_ = gtk_builder_get_object (builder, "insert_spaces_checkbutton");
#line 153 "preferences_dialog.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 153 "preferences_dialog.vala"
	insert_spaces_checkbutton = _tmp6_;
#line 154 "preferences_dialog.vala"
	g_settings_bind (settings, "insert-spaces", insert_spaces_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
#line 157 "preferences_dialog.vala"
	_tmp7_ = gtk_builder_get_object (builder, "forget_no_tabs");
#line 157 "preferences_dialog.vala"
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp7_) : NULL);
#line 157 "preferences_dialog.vala"
	forget_no_tabs = _tmp8_;
#line 158 "preferences_dialog.vala"
	g_settings_bind (settings, "forget-no-tabs", (GObject*) forget_no_tabs, "active", G_SETTINGS_BIND_DEFAULT);
#line 160 "preferences_dialog.vala"
	g_object_bind_property_with_closures (insert_spaces_checkbutton, "active", (GObject*) forget_no_tabs, "sensitive", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 163 "preferences_dialog.vala"
	_tmp9_ = gtk_builder_get_object (builder, "hl_current_line_checkbutton");
#line 163 "preferences_dialog.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 163 "preferences_dialog.vala"
	hl_current_line_checkbutton = _tmp10_;
#line 165 "preferences_dialog.vala"
	g_settings_bind (settings, "highlight-current-line", hl_current_line_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
#line 168 "preferences_dialog.vala"
	_tmp11_ = gtk_builder_get_object (builder, "bracket_matching_checkbutton");
#line 168 "preferences_dialog.vala"
	_tmp12_ = _g_object_ref0 (_tmp11_);
#line 168 "preferences_dialog.vala"
	bracket_matching_checkbutton = _tmp12_;
#line 170 "preferences_dialog.vala"
	g_settings_bind (settings, "bracket-matching", bracket_matching_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
#line 173 "preferences_dialog.vala"
	_tmp13_ = gtk_builder_get_object (builder, "backup_checkbutton");
#line 173 "preferences_dialog.vala"
	_tmp14_ = _g_object_ref0 (_tmp13_);
#line 173 "preferences_dialog.vala"
	backup_checkbutton = _tmp14_;
#line 174 "preferences_dialog.vala"
	g_settings_bind (settings, "create-backup-copy", backup_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
#line 177 "preferences_dialog.vala"
	_tmp15_ = gtk_builder_get_object (builder, "autosave_checkbutton");
#line 177 "preferences_dialog.vala"
	_tmp16_ = _g_object_ref0 (_tmp15_);
#line 177 "preferences_dialog.vala"
	autosave_checkbutton = _tmp16_;
#line 178 "preferences_dialog.vala"
	g_settings_bind (settings, "auto-save", autosave_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
#line 181 "preferences_dialog.vala"
	_tmp17_ = gtk_builder_get_object (builder, "autosave_spinbutton");
#line 181 "preferences_dialog.vala"
	_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, gtk_spin_button_get_type ()) ? ((GtkSpinButton*) _tmp17_) : NULL);
#line 181 "preferences_dialog.vala"
	autosave_spinbutton = _tmp18_;
#line 183 "preferences_dialog.vala"
	preferences_dialog_set_spin_button_range (self, autosave_spinbutton, settings, "auto-save-interval");
#line 184 "preferences_dialog.vala"
	g_settings_bind (settings, "auto-save-interval", (GObject*) autosave_spinbutton, "value", G_SETTINGS_BIND_DEFAULT);
#line 186 "preferences_dialog.vala"
	g_object_bind_property_with_closures (autosave_checkbutton, "active", (GObject*) autosave_spinbutton, "sensitive", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 189 "preferences_dialog.vala"
	_tmp19_ = gtk_builder_get_object (builder, "autosave_label");
#line 189 "preferences_dialog.vala"
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp19_) : NULL);
#line 189 "preferences_dialog.vala"
	autosave_label = _tmp20_;
#line 190 "preferences_dialog.vala"
	preferences_dialog_set_plural (self, autosave_label, settings, "auto-save-interval", ___lambda86__preferences_dialog_plural, self);
#line 193 "preferences_dialog.vala"
	_tmp21_ = gtk_builder_get_object (builder, "reopen_checkbutton");
#line 193 "preferences_dialog.vala"
	_tmp22_ = _g_object_ref0 (_tmp21_);
#line 193 "preferences_dialog.vala"
	reopen_checkbutton = _tmp22_;
#line 194 "preferences_dialog.vala"
	g_settings_bind (settings, "reopen-files", reopen_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
#line 137 "preferences_dialog.vala"
	_g_object_unref0 (reopen_checkbutton);
#line 137 "preferences_dialog.vala"
	_g_object_unref0 (autosave_label);
#line 137 "preferences_dialog.vala"
	_g_object_unref0 (autosave_spinbutton);
#line 137 "preferences_dialog.vala"
	_g_object_unref0 (autosave_checkbutton);
#line 137 "preferences_dialog.vala"
	_g_object_unref0 (backup_checkbutton);
#line 137 "preferences_dialog.vala"
	_g_object_unref0 (bracket_matching_checkbutton);
#line 137 "preferences_dialog.vala"
	_g_object_unref0 (hl_current_line_checkbutton);
#line 137 "preferences_dialog.vala"
	_g_object_unref0 (forget_no_tabs);
#line 137 "preferences_dialog.vala"
	_g_object_unref0 (insert_spaces_checkbutton);
#line 137 "preferences_dialog.vala"
	_g_object_unref0 (tab_width_spinbutton);
#line 137 "preferences_dialog.vala"
	_g_object_unref0 (display_line_nb_checkbutton);
#line 137 "preferences_dialog.vala"
	_g_object_unref0 (settings);
#line 938 "preferences_dialog.c"
}

static Block24Data*
block24_data_ref (Block24Data* _data24_)
{
#line 198 "preferences_dialog.vala"
	g_atomic_int_inc (&_data24_->_ref_count_);
#line 198 "preferences_dialog.vala"
	return _data24_;
#line 948 "preferences_dialog.c"
}

static void
block24_data_unref (void * _userdata_)
{
	Block24Data* _data24_;
	_data24_ = (Block24Data*) _userdata_;
#line 198 "preferences_dialog.vala"
	if (g_atomic_int_dec_and_test (&_data24_->_ref_count_)) {
#line 958 "preferences_dialog.c"
		PreferencesDialog* self;
#line 198 "preferences_dialog.vala"
		self = _data24_->self;
#line 198 "preferences_dialog.vala"
		_g_object_unref0 (_data24_->default_font_checkbutton);
#line 198 "preferences_dialog.vala"
		_g_object_unref0 (self);
#line 198 "preferences_dialog.vala"
		g_slice_free (Block24Data, _data24_);
#line 968 "preferences_dialog.c"
	}
}

static void
__lambda87_ (Block24Data* _data24_)
{
	PreferencesDialog* self;
#line 210 "preferences_dialog.vala"
	self = _data24_->self;
#line 212 "preferences_dialog.vala"
	preferences_dialog_set_system_font_label (self, _data24_->default_font_checkbutton);
#line 980 "preferences_dialog.c"
}

static void
___lambda87__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 210 "preferences_dialog.vala"
	__lambda87_ (self);
#line 990 "preferences_dialog.c"
}

static void
preferences_dialog_init_font_and_colors_tab (PreferencesDialog* self,
                                             GtkBuilder* builder)
{
	Block24Data* _data24_;
	LatexilaSettings* settings = NULL;
	LatexilaSettings* _tmp0_;
	LatexilaSettings* _tmp1_;
	GSettings* editor_settings = NULL;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GObject* _tmp4_;
	GtkButton* _tmp5_;
	AppSettings* app_settings = NULL;
	AppSettings* _tmp6_;
	GObject* font_button = NULL;
	GObject* _tmp7_;
	GObject* _tmp8_;
	GtkWidget* font_hbox = NULL;
	GObject* _tmp9_;
	GtkWidget* _tmp10_;
	TeplStyleSchemeChooserWidget* style_scheme_chooser = NULL;
	GObject* _tmp11_;
	TeplStyleSchemeChooserWidget* _tmp12_;
#line 198 "preferences_dialog.vala"
	g_return_if_fail (self != NULL);
#line 198 "preferences_dialog.vala"
	g_return_if_fail (builder != NULL);
#line 198 "preferences_dialog.vala"
	_data24_ = g_slice_new0 (Block24Data);
#line 198 "preferences_dialog.vala"
	_data24_->_ref_count_ = 1;
#line 198 "preferences_dialog.vala"
	_data24_->self = g_object_ref (self);
#line 200 "preferences_dialog.vala"
	_tmp0_ = latexila_settings_get_singleton ();
#line 200 "preferences_dialog.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 200 "preferences_dialog.vala"
	settings = _tmp1_;
#line 201 "preferences_dialog.vala"
	_tmp2_ = latexila_settings_peek_editor_settings (settings);
#line 201 "preferences_dialog.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 201 "preferences_dialog.vala"
	editor_settings = _tmp3_;
#line 203 "preferences_dialog.vala"
	_tmp4_ = gtk_builder_get_object (builder, "default_font_checkbutton");
#line 203 "preferences_dialog.vala"
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, gtk_button_get_type ()) ? ((GtkButton*) _tmp4_) : NULL);
#line 203 "preferences_dialog.vala"
	_data24_->default_font_checkbutton = _tmp5_;
#line 205 "preferences_dialog.vala"
	g_settings_bind (editor_settings, "use-default-font", (GObject*) _data24_->default_font_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
#line 207 "preferences_dialog.vala"
	preferences_dialog_set_system_font_label (self, _data24_->default_font_checkbutton);
#line 209 "preferences_dialog.vala"
	_tmp6_ = app_settings_get_default ();
#line 209 "preferences_dialog.vala"
	app_settings = _tmp6_;
#line 210 "preferences_dialog.vala"
	g_signal_connect_data ((GObject*) app_settings, "notify::system-font", (GCallback) ___lambda87__g_object_notify, block24_data_ref (_data24_), (GClosureNotify) block24_data_unref, 0);
#line 215 "preferences_dialog.vala"
	_tmp7_ = gtk_builder_get_object (builder, "font_button");
#line 215 "preferences_dialog.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 215 "preferences_dialog.vala"
	font_button = _tmp8_;
#line 216 "preferences_dialog.vala"
	g_settings_bind (editor_settings, "editor-font", font_button, "font-name", G_SETTINGS_BIND_DEFAULT);
#line 219 "preferences_dialog.vala"
	_tmp9_ = gtk_builder_get_object (builder, "font_hbox");
#line 219 "preferences_dialog.vala"
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp9_) : NULL);
#line 219 "preferences_dialog.vala"
	font_hbox = _tmp10_;
#line 220 "preferences_dialog.vala"
	g_object_bind_property_with_closures ((GObject*) _data24_->default_font_checkbutton, "active", (GObject*) font_hbox, "sensitive", (G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE) | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 224 "preferences_dialog.vala"
	_tmp11_ = gtk_builder_get_object (builder, "style_scheme_chooser");
#line 224 "preferences_dialog.vala"
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, tepl_style_scheme_chooser_widget_get_type ()) ? ((TeplStyleSchemeChooserWidget*) _tmp11_) : NULL);
#line 224 "preferences_dialog.vala"
	style_scheme_chooser = _tmp12_;
#line 226 "preferences_dialog.vala"
	g_settings_bind (editor_settings, "scheme", (GObject*) style_scheme_chooser, "tepl-style-scheme-id", G_SETTINGS_BIND_DEFAULT);
#line 198 "preferences_dialog.vala"
	_g_object_unref0 (style_scheme_chooser);
#line 198 "preferences_dialog.vala"
	_g_object_unref0 (font_hbox);
#line 198 "preferences_dialog.vala"
	_g_object_unref0 (font_button);
#line 198 "preferences_dialog.vala"
	_g_object_unref0 (app_settings);
#line 198 "preferences_dialog.vala"
	_g_object_unref0 (editor_settings);
#line 198 "preferences_dialog.vala"
	_g_object_unref0 (settings);
#line 198 "preferences_dialog.vala"
	block24_data_unref (_data24_);
#line 198 "preferences_dialog.vala"
	_data24_ = NULL;
#line 1095 "preferences_dialog.c"
}

static const gchar*
__lambda88_ (PreferencesDialog* self,
             gulong n)
{
	const gchar* result = NULL;
#line 253 "preferences_dialog.vala"
	result = ngettext ("character", "characters", n);
#line 253 "preferences_dialog.vala"
	return result;
#line 1107 "preferences_dialog.c"
}

static const gchar*
___lambda88__preferences_dialog_plural (gulong n,
                                        gpointer self)
{
	const gchar* result;
	result = __lambda88_ ((PreferencesDialog*) self, n);
#line 252 "preferences_dialog.vala"
	return result;
#line 1118 "preferences_dialog.c"
}

static void
preferences_dialog_init_interactive_completion_setting (PreferencesDialog* self,
                                                        GtkBuilder* builder)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	GObject* interactive_comp_checkbutton = NULL;
	GObject* _tmp1_;
	GObject* _tmp2_;
	GtkSpinButton* interactive_comp_spinbutton = NULL;
	GObject* _tmp3_;
	GtkSpinButton* _tmp4_;
	GtkLabel* interactive_comp_label = NULL;
	GObject* _tmp5_;
	GtkLabel* _tmp6_;
#line 230 "preferences_dialog.vala"
	g_return_if_fail (self != NULL);
#line 230 "preferences_dialog.vala"
	g_return_if_fail (builder != NULL);
#line 232 "preferences_dialog.vala"
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.preferences.latex");
#line 232 "preferences_dialog.vala"
	settings = _tmp0_;
#line 235 "preferences_dialog.vala"
	_tmp1_ = gtk_builder_get_object (builder, "interactive_comp_checkbutton");
#line 235 "preferences_dialog.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 235 "preferences_dialog.vala"
	interactive_comp_checkbutton = _tmp2_;
#line 237 "preferences_dialog.vala"
	g_settings_bind (settings, "interactive-completion", interactive_comp_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
#line 240 "preferences_dialog.vala"
	_tmp3_ = gtk_builder_get_object (builder, "interactive_comp_spinbutton");
#line 240 "preferences_dialog.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_spin_button_get_type ()) ? ((GtkSpinButton*) _tmp3_) : NULL);
#line 240 "preferences_dialog.vala"
	interactive_comp_spinbutton = _tmp4_;
#line 242 "preferences_dialog.vala"
	preferences_dialog_set_spin_button_range (self, interactive_comp_spinbutton, settings, "interactive-completion-num");
#line 244 "preferences_dialog.vala"
	g_settings_bind (settings, "interactive-completion-num", (GObject*) interactive_comp_spinbutton, "value", G_SETTINGS_BIND_DEFAULT);
#line 246 "preferences_dialog.vala"
	g_object_bind_property_with_closures (interactive_comp_checkbutton, "active", (GObject*) interactive_comp_spinbutton, "sensitive", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 250 "preferences_dialog.vala"
	_tmp5_ = gtk_builder_get_object (builder, "interactive_comp_label");
#line 250 "preferences_dialog.vala"
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, gtk_label_get_type ()) ? ((GtkLabel*) _tmp5_) : NULL);
#line 250 "preferences_dialog.vala"
	interactive_comp_label = _tmp6_;
#line 252 "preferences_dialog.vala"
	preferences_dialog_set_plural (self, interactive_comp_label, settings, "interactive-completion-num", ___lambda88__preferences_dialog_plural, self);
#line 230 "preferences_dialog.vala"
	_g_object_unref0 (interactive_comp_label);
#line 230 "preferences_dialog.vala"
	_g_object_unref0 (interactive_comp_spinbutton);
#line 230 "preferences_dialog.vala"
	_g_object_unref0 (interactive_comp_checkbutton);
#line 230 "preferences_dialog.vala"
	_g_object_unref0 (settings);
#line 1180 "preferences_dialog.c"
}

static void
preferences_dialog_init_spell_checking_settings (PreferencesDialog* self,
                                                 GtkBuilder* builder)
{
	GSettings* editor_settings = NULL;
	GSettings* _tmp0_;
	GspellLanguageChooserButton* spell_language_button = NULL;
	GObject* _tmp1_;
	GspellLanguageChooserButton* _tmp2_;
	GObject* inline_spell_checkbutton = NULL;
	GObject* _tmp3_;
	GObject* _tmp4_;
#line 256 "preferences_dialog.vala"
	g_return_if_fail (self != NULL);
#line 256 "preferences_dialog.vala"
	g_return_if_fail (builder != NULL);
#line 258 "preferences_dialog.vala"
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.preferences.editor");
#line 258 "preferences_dialog.vala"
	editor_settings = _tmp0_;
#line 261 "preferences_dialog.vala"
	_tmp1_ = gtk_builder_get_object (builder, "spell_language_button");
#line 261 "preferences_dialog.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gspell_language_chooser_button_get_type ()) ? ((GspellLanguageChooserButton*) _tmp1_) : NULL);
#line 261 "preferences_dialog.vala"
	spell_language_button = _tmp2_;
#line 263 "preferences_dialog.vala"
	g_settings_bind (editor_settings, "spell-checking-language", (GObject*) spell_language_button, "language-code", G_SETTINGS_BIND_DEFAULT);
#line 266 "preferences_dialog.vala"
	_tmp3_ = gtk_builder_get_object (builder, "inline_spell_checkbutton");
#line 266 "preferences_dialog.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 266 "preferences_dialog.vala"
	inline_spell_checkbutton = _tmp4_;
#line 267 "preferences_dialog.vala"
	g_settings_bind (editor_settings, "highlight-misspelled-words", inline_spell_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
#line 256 "preferences_dialog.vala"
	_g_object_unref0 (inline_spell_checkbutton);
#line 256 "preferences_dialog.vala"
	_g_object_unref0 (spell_language_button);
#line 256 "preferences_dialog.vala"
	_g_object_unref0 (editor_settings);
#line 1225 "preferences_dialog.c"
}

static void
preferences_dialog_init_other_tab (PreferencesDialog* self,
                                   GtkBuilder* builder)
{
	GSettings* latex_settings = NULL;
	GSettings* _tmp0_;
	GObject* confirm_clean_up_checkbutton = NULL;
	GObject* _tmp1_;
	GObject* _tmp2_;
	GtkWidget* auto_clean_up_checkbutton = NULL;
	GObject* _tmp3_;
	GtkWidget* _tmp4_;
	GObject* clean_up_entry = NULL;
	GObject* _tmp5_;
	GObject* _tmp6_;
#line 271 "preferences_dialog.vala"
	g_return_if_fail (self != NULL);
#line 271 "preferences_dialog.vala"
	g_return_if_fail (builder != NULL);
#line 273 "preferences_dialog.vala"
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.preferences.latex");
#line 273 "preferences_dialog.vala"
	latex_settings = _tmp0_;
#line 276 "preferences_dialog.vala"
	_tmp1_ = gtk_builder_get_object (builder, "confirm_clean_up_checkbutton");
#line 276 "preferences_dialog.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 276 "preferences_dialog.vala"
	confirm_clean_up_checkbutton = _tmp2_;
#line 278 "preferences_dialog.vala"
	g_settings_bind (latex_settings, "no-confirm-clean", confirm_clean_up_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
#line 281 "preferences_dialog.vala"
	_tmp3_ = gtk_builder_get_object (builder, "auto_clean_up_checkbutton");
#line 281 "preferences_dialog.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_widget_get_type ()) ? ((GtkWidget*) _tmp3_) : NULL);
#line 281 "preferences_dialog.vala"
	auto_clean_up_checkbutton = _tmp4_;
#line 283 "preferences_dialog.vala"
	g_settings_bind (latex_settings, "automatic-clean", (GObject*) auto_clean_up_checkbutton, "active", G_SETTINGS_BIND_DEFAULT);
#line 285 "preferences_dialog.vala"
	g_object_bind_property_with_closures (confirm_clean_up_checkbutton, "active", (GObject*) auto_clean_up_checkbutton, "sensitive", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 288 "preferences_dialog.vala"
	_tmp5_ = gtk_builder_get_object (builder, "clean_up_entry");
#line 288 "preferences_dialog.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 288 "preferences_dialog.vala"
	clean_up_entry = _tmp6_;
#line 289 "preferences_dialog.vala"
	g_settings_bind (latex_settings, "clean-extensions", clean_up_entry, "text", G_SETTINGS_BIND_DEFAULT);
#line 271 "preferences_dialog.vala"
	_g_object_unref0 (clean_up_entry);
#line 271 "preferences_dialog.vala"
	_g_object_unref0 (auto_clean_up_checkbutton);
#line 271 "preferences_dialog.vala"
	_g_object_unref0 (confirm_clean_up_checkbutton);
#line 271 "preferences_dialog.vala"
	_g_object_unref0 (latex_settings);
#line 1285 "preferences_dialog.c"
}

static void
preferences_dialog_set_system_font_label (PreferencesDialog* self,
                                          GtkButton* button)
{
	AppSettings* app_settings = NULL;
	AppSettings* _tmp0_;
	gchar* label = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
#line 293 "preferences_dialog.vala"
	g_return_if_fail (self != NULL);
#line 293 "preferences_dialog.vala"
	g_return_if_fail (button != NULL);
#line 295 "preferences_dialog.vala"
	_tmp0_ = app_settings_get_default ();
#line 295 "preferences_dialog.vala"
	app_settings = _tmp0_;
#line 296 "preferences_dialog.vala"
	_tmp1_ = app_settings_get_system_font (app_settings);
#line 296 "preferences_dialog.vala"
	_tmp2_ = _tmp1_;
#line 296 "preferences_dialog.vala"
	_tmp3_ = g_strdup_printf (_ ("Use the system fixed width font (%s)"), _tmp2_);
#line 296 "preferences_dialog.vala"
	label = _tmp3_;
#line 298 "preferences_dialog.vala"
	gtk_button_set_label (button, label);
#line 293 "preferences_dialog.vala"
	_g_free0 (label);
#line 293 "preferences_dialog.vala"
	_g_object_unref0 (app_settings);
#line 1320 "preferences_dialog.c"
}

static Block25Data*
block25_data_ref (Block25Data* _data25_)
{
#line 301 "preferences_dialog.vala"
	g_atomic_int_inc (&_data25_->_ref_count_);
#line 301 "preferences_dialog.vala"
	return _data25_;
#line 1330 "preferences_dialog.c"
}

static void
block25_data_unref (void * _userdata_)
{
	Block25Data* _data25_;
	_data25_ = (Block25Data*) _userdata_;
#line 301 "preferences_dialog.vala"
	if (g_atomic_int_dec_and_test (&_data25_->_ref_count_)) {
#line 1340 "preferences_dialog.c"
		PreferencesDialog* self;
#line 301 "preferences_dialog.vala"
		self = _data25_->self;
#line 301 "preferences_dialog.vala"
		_g_object_unref0 (_data25_->label);
#line 301 "preferences_dialog.vala"
		_g_object_unref0 (self);
#line 301 "preferences_dialog.vala"
		g_slice_free (Block25Data, _data25_);
#line 1350 "preferences_dialog.c"
	}
}

static void
__lambda85_ (Block25Data* _data25_,
             GSettings* setting,
             const gchar* k)
{
	PreferencesDialog* self;
	guint v = 0U;
	guint _tmp0_ = 0U;
	const gchar* _tmp1_;
#line 308 "preferences_dialog.vala"
	self = _data25_->self;
#line 308 "preferences_dialog.vala"
	g_return_if_fail (setting != NULL);
#line 308 "preferences_dialog.vala"
	g_return_if_fail (k != NULL);
#line 311 "preferences_dialog.vala"
	g_settings_get (setting, k, "u", &_tmp0_);
#line 311 "preferences_dialog.vala"
	v = _tmp0_;
#line 312 "preferences_dialog.vala"
	_tmp1_ = _data25_->plural ((gulong) v, _data25_->plural_target);
#line 312 "preferences_dialog.vala"
	gtk_label_set_label (_data25_->label, _tmp1_);
#line 1377 "preferences_dialog.c"
}

static void
___lambda85__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
#line 308 "preferences_dialog.vala"
	__lambda85_ (self, _sender, key);
#line 1387 "preferences_dialog.c"
}

static void
preferences_dialog_set_plural (PreferencesDialog* self,
                               GtkLabel* label,
                               GSettings* settings,
                               const gchar* key,
                               PreferencesDialogPlural plural,
                               gpointer plural_target)
{
	Block25Data* _data25_;
	GtkLabel* _tmp0_;
	guint val = 0U;
	guint _tmp1_ = 0U;
	const gchar* _tmp2_;
	gchar* _tmp3_;
#line 301 "preferences_dialog.vala"
	g_return_if_fail (self != NULL);
#line 301 "preferences_dialog.vala"
	g_return_if_fail (label != NULL);
#line 301 "preferences_dialog.vala"
	g_return_if_fail (settings != NULL);
#line 301 "preferences_dialog.vala"
	g_return_if_fail (key != NULL);
#line 301 "preferences_dialog.vala"
	_data25_ = g_slice_new0 (Block25Data);
#line 301 "preferences_dialog.vala"
	_data25_->_ref_count_ = 1;
#line 301 "preferences_dialog.vala"
	_data25_->self = g_object_ref (self);
#line 301 "preferences_dialog.vala"
	_tmp0_ = _g_object_ref0 (label);
#line 301 "preferences_dialog.vala"
	_g_object_unref0 (_data25_->label);
#line 301 "preferences_dialog.vala"
	_data25_->label = _tmp0_;
#line 301 "preferences_dialog.vala"
	_data25_->plural = plural;
#line 301 "preferences_dialog.vala"
	_data25_->plural_target = plural_target;
#line 305 "preferences_dialog.vala"
	g_settings_get (settings, key, "u", &_tmp1_);
#line 305 "preferences_dialog.vala"
	val = _tmp1_;
#line 306 "preferences_dialog.vala"
	_tmp2_ = _data25_->plural ((gulong) val, _data25_->plural_target);
#line 306 "preferences_dialog.vala"
	gtk_label_set_label (_data25_->label, _tmp2_);
#line 308 "preferences_dialog.vala"
	_tmp3_ = g_strconcat ("changed::", key, NULL);
#line 308 "preferences_dialog.vala"
	g_signal_connect_data (settings, _tmp3_, (GCallback) ___lambda85__g_settings_changed, block25_data_ref (_data25_), (GClosureNotify) block25_data_unref, 0);
#line 308 "preferences_dialog.vala"
	_g_free0 (_tmp3_);
#line 301 "preferences_dialog.vala"
	block25_data_unref (_data25_);
#line 301 "preferences_dialog.vala"
	_data25_ = NULL;
#line 1446 "preferences_dialog.c"
}

static void
preferences_dialog_set_spin_button_range (PreferencesDialog* self,
                                          GtkSpinButton* spin_button,
                                          GSettings* settings,
                                          const gchar* key)
{
	GSettingsSchema* schema = NULL;
	GSettingsSchema* _tmp0_;
	GSettingsSchema* _tmp1_;
	GVariant* range = NULL;
	GSettingsSchemaKey* _tmp2_;
	GSettingsSchemaKey* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	gchar* range_type = NULL;
	GVariant* range_contents = NULL;
	gchar* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	guint min = 0U;
	guint max = 0U;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	guint cur_value = 0U;
	guint _tmp10_ = 0U;
	GtkAdjustment* adjustment = NULL;
	GtkAdjustment* _tmp11_;
#line 316 "preferences_dialog.vala"
	g_return_if_fail (self != NULL);
#line 316 "preferences_dialog.vala"
	g_return_if_fail (spin_button != NULL);
#line 316 "preferences_dialog.vala"
	g_return_if_fail (settings != NULL);
#line 316 "preferences_dialog.vala"
	g_return_if_fail (key != NULL);
#line 319 "preferences_dialog.vala"
	g_object_get (settings, "settings-schema", &_tmp0_, NULL);
#line 319 "preferences_dialog.vala"
	_tmp1_ = _tmp0_;
#line 319 "preferences_dialog.vala"
	schema = _tmp1_;
#line 320 "preferences_dialog.vala"
	_tmp2_ = g_settings_schema_get_key (schema, key);
#line 320 "preferences_dialog.vala"
	_tmp3_ = _tmp2_;
#line 320 "preferences_dialog.vala"
	_tmp4_ = g_settings_schema_key_get_range (_tmp3_);
#line 320 "preferences_dialog.vala"
	_tmp5_ = _tmp4_;
#line 320 "preferences_dialog.vala"
	_g_settings_schema_key_unref0 (_tmp3_);
#line 320 "preferences_dialog.vala"
	range = _tmp5_;
#line 324 "preferences_dialog.vala"
	g_variant_get (range, "(sv)", &_tmp6_, &_tmp7_, NULL);
#line 324 "preferences_dialog.vala"
	_g_free0 (range_type);
#line 324 "preferences_dialog.vala"
	range_type = _tmp6_;
#line 324 "preferences_dialog.vala"
	_g_variant_unref0 (range_contents);
#line 324 "preferences_dialog.vala"
	range_contents = _tmp7_;
#line 326 "preferences_dialog.vala"
	g_return_if_fail (g_strcmp0 (range_type, "range") == 0);
#line 330 "preferences_dialog.vala"
	g_variant_get (range_contents, "(uu)", &_tmp8_, &_tmp9_, NULL);
#line 330 "preferences_dialog.vala"
	min = _tmp8_;
#line 330 "preferences_dialog.vala"
	max = _tmp9_;
#line 333 "preferences_dialog.vala"
	g_settings_get (settings, key, "u", &_tmp10_);
#line 333 "preferences_dialog.vala"
	cur_value = _tmp10_;
#line 335 "preferences_dialog.vala"
	_tmp11_ = gtk_adjustment_new ((gdouble) cur_value, (gdouble) min, (gdouble) max, 1.0, (gdouble) 0, (gdouble) 0);
#line 335 "preferences_dialog.vala"
	g_object_ref_sink (_tmp11_);
#line 335 "preferences_dialog.vala"
	adjustment = _tmp11_;
#line 337 "preferences_dialog.vala"
	gtk_spin_button_set_adjustment (spin_button, adjustment);
#line 316 "preferences_dialog.vala"
	_g_object_unref0 (adjustment);
#line 316 "preferences_dialog.vala"
	_g_variant_unref0 (range_contents);
#line 316 "preferences_dialog.vala"
	_g_free0 (range_type);
#line 316 "preferences_dialog.vala"
	_g_variant_unref0 (range);
#line 316 "preferences_dialog.vala"
	_g_settings_schema_unref0 (schema);
#line 1541 "preferences_dialog.c"
}

static void
preferences_dialog_class_init (PreferencesDialogClass * klass,
                               gpointer klass_data)
{
#line 23 "preferences_dialog.vala"
	preferences_dialog_parent_class = g_type_class_peek_parent (klass);
#line 23 "preferences_dialog.vala"
	G_OBJECT_CLASS (klass)->finalize = preferences_dialog_finalize;
#line 1552 "preferences_dialog.c"
}

static void
preferences_dialog_instance_init (PreferencesDialog * self,
                                  gpointer klass)
{
}

static void
preferences_dialog_finalize (GObject * obj)
{
	PreferencesDialog * self;
#line 23 "preferences_dialog.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PREFERENCES_DIALOG, PreferencesDialog);
#line 23 "preferences_dialog.vala"
	G_OBJECT_CLASS (preferences_dialog_parent_class)->finalize (obj);
#line 1569 "preferences_dialog.c"
}

static GType
preferences_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PreferencesDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) preferences_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreferencesDialog), 0, (GInstanceInitFunc) preferences_dialog_instance_init, NULL };
	GType preferences_dialog_type_id;
	preferences_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "PreferencesDialog", &g_define_type_info, 0);
	return preferences_dialog_type_id;
}

GType
preferences_dialog_get_type (void)
{
	static volatile gsize preferences_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&preferences_dialog_type_id__volatile)) {
		GType preferences_dialog_type_id;
		preferences_dialog_type_id = preferences_dialog_get_type_once ();
		g_once_init_leave (&preferences_dialog_type_id__volatile, preferences_dialog_type_id);
	}
	return preferences_dialog_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
#line 27 "build_tools_preferences.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 1600 "preferences_dialog.c"
		gint i;
#line 27 "build_tools_preferences.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 27 "build_tools_preferences.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 27 "build_tools_preferences.vala"
				destroy_func (((gpointer*) array)[i]);
#line 1608 "preferences_dialog.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
#line 27 "build_tools_preferences.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 27 "build_tools_preferences.vala"
	g_free (array);
#line 1623 "preferences_dialog.c"
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
#line 27 "build_tools_preferences.vala"
	if (array) {
#line 27 "build_tools_preferences.vala"
		while (((gpointer*) array)[length]) {
#line 27 "build_tools_preferences.vala"
			length++;
#line 1637 "preferences_dialog.c"
		}
	}
#line 27 "build_tools_preferences.vala"
	return length;
#line 1642 "preferences_dialog.c"
}

