/* main_window.c generated by valac 0.48.9, the Vala compiler
 * generated from main_window.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2020 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <tepl/tepl.h>
#include <glib/gi18n-lib.h>
#include <latexila.h>
#include <gdk/gdk.h>
#include <amtk/amtk.h>
#include "config.h"
#include <gio/gio.h>
#include <gee.h>

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_DOCUMENTS_PANEL (documents_panel_get_type ())
#define DOCUMENTS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENTS_PANEL, DocumentsPanel))
#define DOCUMENTS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENTS_PANEL, DocumentsPanelClass))
#define IS_DOCUMENTS_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENTS_PANEL))
#define IS_DOCUMENTS_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENTS_PANEL))
#define DOCUMENTS_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENTS_PANEL, DocumentsPanelClass))

typedef struct _DocumentsPanel DocumentsPanel;
typedef struct _DocumentsPanelClass DocumentsPanelClass;

#define TYPE_SEARCH_AND_REPLACE (search_and_replace_get_type ())
#define SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplace))
#define SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))
#define IS_SEARCH_AND_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SEARCH_AND_REPLACE))
#define IS_SEARCH_AND_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SEARCH_AND_REPLACE))
#define SEARCH_AND_REPLACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SEARCH_AND_REPLACE, SearchAndReplaceClass))

typedef struct _SearchAndReplace SearchAndReplace;
typedef struct _SearchAndReplaceClass SearchAndReplaceClass;

#define TYPE_MAIN_WINDOW_FILE (main_window_file_get_type ())
#define MAIN_WINDOW_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_FILE, MainWindowFile))
#define MAIN_WINDOW_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_FILE, MainWindowFileClass))
#define IS_MAIN_WINDOW_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_FILE))
#define IS_MAIN_WINDOW_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_FILE))
#define MAIN_WINDOW_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_FILE, MainWindowFileClass))

typedef struct _MainWindowFile MainWindowFile;
typedef struct _MainWindowFileClass MainWindowFileClass;

#define TYPE_MAIN_WINDOW_EDIT (main_window_edit_get_type ())
#define MAIN_WINDOW_EDIT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_EDIT, MainWindowEdit))
#define MAIN_WINDOW_EDIT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_EDIT, MainWindowEditClass))
#define IS_MAIN_WINDOW_EDIT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_EDIT))
#define IS_MAIN_WINDOW_EDIT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_EDIT))
#define MAIN_WINDOW_EDIT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_EDIT, MainWindowEditClass))

typedef struct _MainWindowEdit MainWindowEdit;
typedef struct _MainWindowEditClass MainWindowEditClass;

#define TYPE_MAIN_WINDOW_BUILD_TOOLS (main_window_build_tools_get_type ())
#define MAIN_WINDOW_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildTools))
#define MAIN_WINDOW_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildToolsClass))
#define IS_MAIN_WINDOW_BUILD_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS))
#define IS_MAIN_WINDOW_BUILD_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_BUILD_TOOLS))
#define MAIN_WINDOW_BUILD_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_BUILD_TOOLS, MainWindowBuildToolsClass))

typedef struct _MainWindowBuildTools MainWindowBuildTools;
typedef struct _MainWindowBuildToolsClass MainWindowBuildToolsClass;

#define TYPE_MAIN_WINDOW_STRUCTURE (main_window_structure_get_type ())
#define MAIN_WINDOW_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructure))
#define MAIN_WINDOW_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructureClass))
#define IS_MAIN_WINDOW_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_STRUCTURE))
#define IS_MAIN_WINDOW_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_STRUCTURE))
#define MAIN_WINDOW_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_STRUCTURE, MainWindowStructureClass))

typedef struct _MainWindowStructure MainWindowStructure;
typedef struct _MainWindowStructureClass MainWindowStructureClass;

#define TYPE_MAIN_WINDOW_DOCUMENTS (main_window_documents_get_type ())
#define MAIN_WINDOW_DOCUMENTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_DOCUMENTS, MainWindowDocuments))
#define MAIN_WINDOW_DOCUMENTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_DOCUMENTS, MainWindowDocumentsClass))
#define IS_MAIN_WINDOW_DOCUMENTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_DOCUMENTS))
#define IS_MAIN_WINDOW_DOCUMENTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_DOCUMENTS))
#define MAIN_WINDOW_DOCUMENTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_DOCUMENTS, MainWindowDocumentsClass))

typedef struct _MainWindowDocuments MainWindowDocuments;
typedef struct _MainWindowDocumentsClass MainWindowDocumentsClass;

#define TYPE_MAIN_WINDOW_TOOLS (main_window_tools_get_type ())
#define MAIN_WINDOW_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW_TOOLS, MainWindowTools))
#define MAIN_WINDOW_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW_TOOLS, MainWindowToolsClass))
#define IS_MAIN_WINDOW_TOOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW_TOOLS))
#define IS_MAIN_WINDOW_TOOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW_TOOLS))
#define MAIN_WINDOW_TOOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW_TOOLS, MainWindowToolsClass))

typedef struct _MainWindowTools MainWindowTools;
typedef struct _MainWindowToolsClass MainWindowToolsClass;
enum  {
	MAIN_WINDOW_0_PROPERTY,
	MAIN_WINDOW_ACTIVE_TAB_PROPERTY,
	MAIN_WINDOW_ACTIVE_VIEW_PROPERTY,
	MAIN_WINDOW_ACTIVE_DOCUMENT_PROPERTY,
	MAIN_WINDOW_NUM_PROPERTIES
};
static GParamSpec* main_window_properties[MAIN_WINDOW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _main_window_file_unref0(var) ((var == NULL) ? NULL : (var = (main_window_file_unref (var), NULL)))
#define _main_window_edit_unref0(var) ((var == NULL) ? NULL : (var = (main_window_edit_unref (var), NULL)))
#define _main_window_build_tools_unref0(var) ((var == NULL) ? NULL : (var = (main_window_build_tools_unref (var), NULL)))
#define _main_window_structure_unref0(var) ((var == NULL) ? NULL : (var = (main_window_structure_unref (var), NULL)))
#define _main_window_documents_unref0(var) ((var == NULL) ? NULL : (var = (main_window_documents_unref (var), NULL)))
#define _main_window_tools_unref0(var) ((var == NULL) ? NULL : (var = (main_window_tools_unref (var), NULL)))

#define TYPE_GLATEX_APP (glatex_app_get_type ())
#define GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GLATEX_APP, GlatexApp))
#define GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GLATEX_APP, GlatexAppClass))
#define IS_GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GLATEX_APP))
#define IS_GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GLATEX_APP))
#define GLATEX_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GLATEX_APP, GlatexAppClass))

typedef struct _GlatexApp GlatexApp;
typedef struct _GlatexAppClass GlatexAppClass;

#define TYPE_BOTTOM_PANEL (bottom_panel_get_type ())
#define BOTTOM_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOTTOM_PANEL, BottomPanel))
#define BOTTOM_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOTTOM_PANEL, BottomPanelClass))
#define IS_BOTTOM_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOTTOM_PANEL))
#define IS_BOTTOM_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOTTOM_PANEL))
#define BOTTOM_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOTTOM_PANEL, BottomPanelClass))

typedef struct _BottomPanel BottomPanel;
typedef struct _BottomPanelClass BottomPanelClass;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_SYMBOLS_VIEW (symbols_view_get_type ())
#define SYMBOLS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYMBOLS_VIEW, SymbolsView))
#define SYMBOLS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYMBOLS_VIEW, SymbolsViewClass))
#define IS_SYMBOLS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYMBOLS_VIEW))
#define IS_SYMBOLS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYMBOLS_VIEW))
#define SYMBOLS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYMBOLS_VIEW, SymbolsViewClass))

typedef struct _SymbolsView SymbolsView;
typedef struct _SymbolsViewClass SymbolsViewClass;

#define TYPE_FILE_BROWSER (file_browser_get_type ())
#define FILE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_BROWSER, FileBrowser))
#define FILE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_BROWSER, FileBrowserClass))
#define IS_FILE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_BROWSER))
#define IS_FILE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_BROWSER))
#define FILE_BROWSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_BROWSER, FileBrowserClass))

typedef struct _FileBrowser FileBrowser;
typedef struct _FileBrowserClass FileBrowserClass;

#define TYPE_STRUCTURE (structure_get_type ())
#define STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRUCTURE, Structure))
#define STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRUCTURE, StructureClass))
#define IS_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRUCTURE))
#define IS_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRUCTURE))
#define STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRUCTURE, StructureClass))

typedef struct _Structure Structure;
typedef struct _StructureClass StructureClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
typedef struct _Block22Data Block22Data;
typedef struct _DocumentPrivate DocumentPrivate;
typedef struct _Block23Data Block23Data;

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	gchar* default_location;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _MainWindowPrivate {
	DocumentsPanel* _documents_panel;
	TeplStatusbar* _statusbar;
	SearchAndReplace* _search_and_replace;
	TeplPanel* _side_panel;
	GtkPaned* _main_hpaned;
	GtkPaned* _vpaned;
	GtkUIManager* _ui_manager;
	GtkActionGroup* _action_group;
	MainWindowFile* _main_window_file;
	MainWindowEdit* _main_window_edit;
	MainWindowBuildTools* _main_window_build_tools;
	MainWindowStructure* _main_window_structure;
	MainWindowDocuments* _main_window_documents;
	MainWindowTools* _main_window_tools;
	guint _tip_message_cid;
};

struct _Block22Data {
	int _ref_count_;
	MainWindow* self;
	DocumentTab* tab;
	TeplInfoBar* infobar;
};

struct _Document {
	TeplBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
};

struct _DocumentClass {
	TeplBufferClass parent_class;
};

struct _Block23Data {
	int _ref_count_;
	MainWindow* self;
	DocumentTab* tab;
};

static gint MainWindow_private_offset;
static gpointer main_window_parent_class = NULL;

GType main_window_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
GType documents_panel_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentsPanel, g_object_unref)
GType search_and_replace_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SearchAndReplace, g_object_unref)
gpointer main_window_file_ref (gpointer instance);
void main_window_file_unref (gpointer instance);
GParamSpec* param_spec_main_window_file (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
void value_set_main_window_file (GValue* value,
                                 gpointer v_object);
void value_take_main_window_file (GValue* value,
                                  gpointer v_object);
gpointer value_get_main_window_file (const GValue* value);
GType main_window_file_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindowFile, main_window_file_unref)
gpointer main_window_edit_ref (gpointer instance);
void main_window_edit_unref (gpointer instance);
GParamSpec* param_spec_main_window_edit (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
void value_set_main_window_edit (GValue* value,
                                 gpointer v_object);
void value_take_main_window_edit (GValue* value,
                                  gpointer v_object);
gpointer value_get_main_window_edit (const GValue* value);
GType main_window_edit_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindowEdit, main_window_edit_unref)
gpointer main_window_build_tools_ref (gpointer instance);
void main_window_build_tools_unref (gpointer instance);
GParamSpec* param_spec_main_window_build_tools (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
void value_set_main_window_build_tools (GValue* value,
                                        gpointer v_object);
void value_take_main_window_build_tools (GValue* value,
                                         gpointer v_object);
gpointer value_get_main_window_build_tools (const GValue* value);
GType main_window_build_tools_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindowBuildTools, main_window_build_tools_unref)
gpointer main_window_structure_ref (gpointer instance);
void main_window_structure_unref (gpointer instance);
GParamSpec* param_spec_main_window_structure (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
void value_set_main_window_structure (GValue* value,
                                      gpointer v_object);
void value_take_main_window_structure (GValue* value,
                                       gpointer v_object);
gpointer value_get_main_window_structure (const GValue* value);
GType main_window_structure_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindowStructure, main_window_structure_unref)
gpointer main_window_documents_ref (gpointer instance);
void main_window_documents_unref (gpointer instance);
GParamSpec* param_spec_main_window_documents (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
void value_set_main_window_documents (GValue* value,
                                      gpointer v_object);
void value_take_main_window_documents (GValue* value,
                                       gpointer v_object);
gpointer value_get_main_window_documents (const GValue* value);
GType main_window_documents_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindowDocuments, main_window_documents_unref)
gpointer main_window_tools_ref (gpointer instance);
void main_window_tools_unref (gpointer instance);
GParamSpec* param_spec_main_window_tools (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
void value_set_main_window_tools (GValue* value,
                                  gpointer v_object);
void value_take_main_window_tools (GValue* value,
                                   gpointer v_object);
gpointer value_get_main_window_tools (const GValue* value);
GType main_window_tools_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindowTools, main_window_tools_unref)
void main_window_on_view_zoom_in (MainWindow* self);
static void _main_window_on_view_zoom_in_gtk_action_callback (GtkAction* action,
                                                       gpointer self);
void main_window_on_view_zoom_out (MainWindow* self);
static void _main_window_on_view_zoom_out_gtk_action_callback (GtkAction* action,
                                                        gpointer self);
void main_window_on_view_zoom_reset (MainWindow* self);
static void _main_window_on_view_zoom_reset_gtk_action_callback (GtkAction* action,
                                                          gpointer self);
void main_window_on_search_find (MainWindow* self);
static void _main_window_on_search_find_gtk_action_callback (GtkAction* action,
                                                      gpointer self);
void main_window_on_search_replace (MainWindow* self);
static void _main_window_on_search_replace_gtk_action_callback (GtkAction* action,
                                                         gpointer self);
void main_window_on_search_forward (MainWindow* self);
static void _main_window_on_search_forward_gtk_action_callback (GtkAction* action,
                                                         gpointer self);
void main_window_on_projects_new (MainWindow* self);
static void _main_window_on_projects_new_gtk_action_callback (GtkAction* action,
                                                       gpointer self);
void main_window_on_projects_config_current (MainWindow* self);
static void _main_window_on_projects_config_current_gtk_action_callback (GtkAction* action,
                                                                  gpointer self);
void main_window_on_projects_manage (MainWindow* self);
static void _main_window_on_projects_manage_gtk_action_callback (GtkAction* action,
                                                          gpointer self);
void main_window_on_help_latex_reference (MainWindow* self);
static void _main_window_on_help_latex_reference_gtk_action_callback (GtkAction* action,
                                                               gpointer self);
GType glatex_app_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GlatexApp, g_object_unref)
MainWindow* main_window_new (GlatexApp* app);
MainWindow* main_window_construct (GType object_type,
                                   GlatexApp* app);
static void main_window_initialize_ui_manager (MainWindow* self);
MainWindowFile* main_window_file_new (MainWindow* main_window,
                                      GtkUIManager* ui_manager);
MainWindowFile* main_window_file_construct (GType object_type,
                                            MainWindow* main_window,
                                            GtkUIManager* ui_manager);
MainWindowEdit* main_window_edit_new (MainWindow* main_window,
                                      GtkUIManager* ui_manager);
MainWindowEdit* main_window_edit_construct (GType object_type,
                                            MainWindow* main_window,
                                            GtkUIManager* ui_manager);
MainWindowBuildTools* main_window_build_tools_new (MainWindow* main_window,
                                                   GtkUIManager* ui_manager);
MainWindowBuildTools* main_window_build_tools_construct (GType object_type,
                                                         MainWindow* main_window,
                                                         GtkUIManager* ui_manager);
MainWindowDocuments* main_window_documents_new (MainWindow* main_window,
                                                GtkUIManager* ui_manager);
MainWindowDocuments* main_window_documents_construct (GType object_type,
                                                      MainWindow* main_window,
                                                      GtkUIManager* ui_manager);
MainWindowStructure* main_window_structure_new (GtkUIManager* ui_manager);
MainWindowStructure* main_window_structure_construct (GType object_type,
                                                      GtkUIManager* ui_manager);
MainWindowTools* main_window_tools_new (MainWindow* main_window,
                                        GtkUIManager* ui_manager);
MainWindowTools* main_window_tools_construct (GType object_type,
                                              MainWindow* main_window,
                                              GtkUIManager* ui_manager);
static void main_window_show_images_in_menu (MainWindow* self);
static void main_window_update_file_actions_sensitivity (MainWindow* self);
static GtkToolbar* main_window_get_main_toolbar (MainWindow* self);
static GtkToolbar* main_window_get_edit_toolbar (MainWindow* self);
static TeplPanel* main_window_get_side_panel (MainWindow* self);
static void main_window_init_documents_panel (MainWindow* self);
SearchAndReplace* search_and_replace_new (MainWindow* main_window);
SearchAndReplace* search_and_replace_construct (GType object_type,
                                                MainWindow* main_window);
GtkWidget* search_and_replace_get_widget (SearchAndReplace* self);
GType bottom_panel_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BottomPanel, g_object_unref)
static BottomPanel* main_window_get_bottom_panel (MainWindow* self);
void main_window_build_tools_set_bottom_panel (MainWindowBuildTools* self,
                                               BottomPanel* bottom_panel);
static void __lambda79_ (MainWindow* self);
void main_window_update_config_project_sensitivity (MainWindow* self);
GType document_tab_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
DocumentTab* main_window_get_active_tab (MainWindow* self);
void search_and_replace_hide (SearchAndReplace* self);
static void ___lambda79__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda80_ (MainWindow* self);
static void ___lambda80__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda81_ (MainWindow* self);
static void ___lambda81__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void main_window_support_drag_and_drop (MainWindow* self);
static gboolean __lambda83_ (MainWindow* self);
gboolean main_window_quit (MainWindow* self);
static gboolean ___lambda83__gtk_widget_delete_event (GtkWidget* _sender,
                                               GdkEventAny* event,
                                               gpointer self);
static void main_window_restore_state (MainWindow* self);
static void main_window_show_or_hide_widgets (MainWindow* self);
GlatexApp* glatex_app_get_instance (void);
static void __lambda63_ (MainWindow* self,
                  GtkAction* action,
                  GtkWidget* p);
static void main_window_on_menu_item_select (MainWindow* self,
                                      GtkMenuItem* proxy);
static void _main_window_on_menu_item_select_gtk_menu_item_select (GtkMenuItem* _sender,
                                                            gpointer self);
static void main_window_on_menu_item_deselect (MainWindow* self,
                                        GtkMenuItem* proxy);
static void _main_window_on_menu_item_deselect_gtk_menu_item_deselect (GtkMenuItem* _sender,
                                                                gpointer self);
static void ___lambda63__gtk_ui_manager_connect_proxy (GtkUIManager* _sender,
                                                GtkAction* action,
                                                GtkWidget* proxy,
                                                gpointer self);
static void __lambda64_ (MainWindow* self,
                  GtkAction* action,
                  GtkWidget* p);
static void ___lambda64__gtk_ui_manager_disconnect_proxy (GtkUIManager* _sender,
                                                   GtkAction* action,
                                                   GtkWidget* proxy,
                                                   gpointer self);
GtkToolItem* main_window_file_get_toolbar_open_button (MainWindowFile* self);
GType symbols_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SymbolsView, g_object_unref)
SymbolsView* symbols_view_new (MainWindow* main_window);
SymbolsView* symbols_view_construct (GType object_type,
                                     MainWindow* main_window);
GType file_browser_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FileBrowser, g_object_unref)
FileBrowser* file_browser_new (MainWindow* main_window);
FileBrowser* file_browser_construct (GType object_type,
                                     MainWindow* main_window);
GType structure_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Structure, g_object_unref)
Structure* structure_new (MainWindow* main_window);
Structure* structure_construct (GType object_type,
                                MainWindow* main_window);
void main_window_structure_set_structure (MainWindowStructure* self,
                                          Structure* structure);
DocumentsPanel* documents_panel_new (MainWindow* main_window);
DocumentsPanel* documents_panel_construct (GType object_type,
                                           MainWindow* main_window);
void main_window_documents_set_documents_panel (MainWindowDocuments* self,
                                                DocumentsPanel* documents_panel);
static void __lambda78_ (MainWindow* self,
                  GdkEventButton* event);
static void ___lambda78__documents_panel_right_click (DocumentsPanel* _sender,
                                               GdkEventButton* event,
                                               gpointer self);
void main_window_build_tools_set_build_view (MainWindowBuildTools* self,
                                             LatexilaBuildView* build_view);
BottomPanel* bottom_panel_new (LatexilaBuildView* build_view,
                               GtkToolbar* toolbar);
BottomPanel* bottom_panel_construct (GType object_type,
                                     LatexilaBuildView* build_view,
                                     GtkToolbar* toolbar);
static void __lambda82_ (MainWindow* self,
                  GdkDragContext* dc,
                  gint x,
                  gint y,
                  GtkSelectionData* selection_data,
                  guint info,
                  guint time);
static void _vala_array_add5 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
void glatex_app_open_documents (GlatexApp* self,
                                GFile** files,
                                gint files_length1);
static void ___lambda82__gtk_widget_drag_data_received (GtkWidget* _sender,
                                                 GdkDragContext* context,
                                                 gint x,
                                                 gint y,
                                                 GtkSelectionData* selection_data,
                                                 guint info,
                                                 guint time_,
                                                 gpointer self);
MainWindowStructure* main_window_get_main_window_structure (MainWindow* self);
GType document_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
GeeList* main_window_get_documents (MainWindow* self);
Document* document_tab_get_document (DocumentTab* self);
GeeList* main_window_get_unsaved_documents (MainWindow* self);
GType document_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentView, g_object_unref)
GeeList* main_window_get_views (MainWindow* self);
DocumentView* document_tab_get_document_view (DocumentTab* self);
DocumentTab* main_window_open_document (MainWindow* self,
                                        GFile* location,
                                        gboolean jump_to);
static Block22Data* block22_data_ref (Block22Data* _data22_);
static void block22_data_unref (void * _userdata_);
GFile* document_get_location (Document* self);
void main_window_set_active_tab (MainWindow* self,
                                 DocumentTab* value);
static DocumentTab* main_window_create_tab_from_location (MainWindow* self,
                                                   GFile* location,
                                                   gboolean jump_to);
void document_set_readonly (Document* self,
                            gboolean value);
static void ______lambda41_ (Block22Data* _data22_,
                      gint response_id);
TeplView* tepl_tab_get_view (TeplTab* self);
static void _______lambda41__gtk_info_bar_response (GtkInfoBar* _sender,
                                             gint response_id,
                                             gpointer self);
DocumentTab* main_window_create_tab (MainWindow* self,
                                     gboolean jump_to);
DocumentTab* document_tab_new (void);
DocumentTab* document_tab_construct (GType object_type);
static DocumentTab* main_window_process_create_tab (MainWindow* self,
                                             DocumentTab* tab,
                                             gboolean jump_to);
DocumentTab* document_tab_new_from_location (GFile* location);
DocumentTab* document_tab_construct_from_location (GType object_type,
                                                   GFile* location);
void main_window_create_tab_with_view (MainWindow* self,
                                       DocumentView* view);
DocumentTab* document_tab_new_with_view (DocumentView* document_view);
DocumentTab* document_tab_construct_with_view (GType object_type,
                                               DocumentView* document_view);
static Block23Data* block23_data_ref (Block23Data* _data23_);
static void block23_data_unref (void * _userdata_);
static void __lambda15_ (Block23Data* _data23_);
gboolean main_window_close_tab (MainWindow* self,
                                DocumentTab* tab,
                                gboolean force_close);
static void ___lambda15__tepl_tab_close_request (TeplTab* _sender,
                                          gpointer self);
static void __lambda18_ (Block23Data* _data23_);
static void main_window_sync_name (MainWindow* self,
                            DocumentTab* tab);
void main_window_build_tools_update_sensitivity (MainWindowBuildTools* self);
static void ___lambda18__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda34_ (Block23Data* _data23_);
static void ___lambda34__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda35_ (MainWindow* self);
static void ___lambda35__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda36_ (Block23Data* _data23_);
static void ___lambda36__gtk_text_buffer_modified_changed (GtkTextBuffer* _sender,
                                                    gpointer self);
static void __lambda37_ (Block23Data* _data23_);
static void ___lambda37__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
void documents_panel_add_tab (DocumentsPanel* self,
                              DocumentTab* tab,
                              gint position,
                              gboolean jump_to);
void main_window_edit_update_sensitivity (MainWindowEdit* self);
void main_window_tools_update_sensitivity (MainWindowTools* self);
gboolean main_window_save_document (MainWindow* self,
                                    Document* doc,
                                    gboolean force_save_as);
void documents_panel_remove_tab (DocumentsPanel* self,
                                 DocumentTab* tab);
void main_window_documents_update_document_name (MainWindowDocuments* self,
                                                 DocumentTab* tab);
void document_save (Document* self,
                    gboolean check_file_changed_on_disk,
                    gboolean force);
Document* main_window_get_active_document (MainWindow* self);
void main_window_structure_refresh (MainWindowStructure* self);
void document_set_location (Document* self,
                            GFile* value);
gboolean main_window_close_all_documents (MainWindow* self);
void documents_panel_remove_all_tabs (DocumentsPanel* self);
void dialogs_close_several_unsaved_documents (MainWindow* window,
                                              GeeList* unsaved_docs);
void main_window_remove_all_tabs (MainWindow* self);
void main_window_save_state (MainWindow* self);
void main_window_structure_save_state (MainWindowStructure* self);
void main_window_build_tools_save_state (MainWindowBuildTools* self);
void main_window_jump_to_file_position (MainWindow* self,
                                        GFile* file,
                                        gint start_line,
                                        gint end_line);
void utils_flush_queue (void);
TeplTab* tepl_tab_group_get_active_tab (TeplTabGroup* self);
void main_window_file_update_sensitivity (MainWindowFile* self);
gint document_get_project_id (Document* self);
static void _vala_array_add6 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
DocumentView* main_window_get_active_view (MainWindow* self);
void document_view_enlarge_font (DocumentView* self);
void document_view_shrink_font (DocumentView* self);
void document_view_set_font_from_settings (DocumentView* self);
void search_and_replace_show_search (SearchAndReplace* self);
void search_and_replace_show_search_and_replace (SearchAndReplace* self);
GFile* document_get_main_file (Document* self);
void project_dialogs_new_project (MainWindow* main_window);
gboolean project_dialogs_configure_project (GtkWindow* main_window,
                                            gint project_id);
void project_dialogs_manage_projects (MainWindow* main_window);
static void main_window_finalize (GObject * obj);
static GType main_window_get_type_once (void);
static void _vala_main_window_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_main_window_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GtkActionEntry MAIN_WINDOW__action_entries[19] = {{"FileQuit", "application-exit", N_ ("_Quit"), "<Control>Q", N_ ("Quit the program")}, {"View", NULL, N_ ("_View")}, {"ViewZoomIn", "zoom-in", N_ ("Zoom _In"), "<Control>plus", N_ ("Enlarge the font"), (GCallback) _main_window_on_view_zoom_in_gtk_action_callback}, {"ViewZoomOut", "zoom-out", N_ ("Zoom _Out"), "<Control>minus", N_ ("Shrink the font"), (GCallback) _main_window_on_view_zoom_out_gtk_action_callback}, {"ViewZoomReset", "zoom-original", N_ ("_Reset Zoom"), "<Control>0", N_ ("Reset the size of the font"), (GCallback) _main_window_on_view_zoom_reset_gtk_action_callback}, {"Search", NULL, N_ ("_Search")}, {"SearchFind", "edit-find", N_ ("_Find"), "<Control>F", N_ ("Search for text"), (GCallback) _main_window_on_search_find_gtk_action_callback}, {"SearchReplace", "edit-find-replace", N_ ("Find and _Replace"), "<Control>H", N_ ("Search for and replace text"), (GCallback) _main_window_on_search_replace_gtk_action_callback}, {"SearchForward", NULL, N_ ("_Jump to PDF"), "<Control><Alt>F", N_ ("Jump to the associated position in the PDF file. Another shortcut: Ctr" \
"l+click, which works in both directions."), (GCallback) _main_window_on_search_forward_gtk_action_callback}, {"Latex", NULL, "_LaTeX"}, {"Math", NULL, N_ ("_Math")}, {"Projects", NULL, N_ ("_Projects")}, {"ProjectsNew", "document-new", N_ ("_New Project"), "", N_ ("Create a new project"), (GCallback) _main_window_on_projects_new_gtk_action_callback}, {"ProjectsConfigCurrent", "document-properties", N_ ("_Configure Current Project"), NULL, N_ ("Change the main file of the current project"), (GCallback) _main_window_on_projects_config_current_gtk_action_callback}, {"ProjectsManage", "preferences-system", N_ ("_Manage Projects"), NULL, N_ ("Manage Projects"), (GCallback) _main_window_on_projects_manage_gtk_action_callback}, {"Help", NULL, N_ ("_Help")}, {"HelpContents", "help-browser", N_ ("_Contents"), "<Release>F1", N_ ("Open the GNOME LaTeX documentation")}, {"HelpLatexReference", NULL, N_ ("_LaTeX Reference"), NULL, N_ ("The Kile LaTeX Reference"), (GCallback) _main_window_on_help_latex_reference_gtk_action_callback}, {"HelpAbout", "help-about", N_ ("_About"), NULL, N_ ("About GNOME LaTeX")}};
static const GtkToggleActionEntry MAIN_WINDOW__toggle_action_entries[4] = {{"ViewMainToolbar", NULL, N_ ("_Main Toolbar"), NULL, N_ ("Show or hide the main toolbar"), (GCallback) NULL}, {"ViewEditToolbar", NULL, N_ ("_Edit Toolbar"), NULL, N_ ("Show or hide the edit toolbar"), (GCallback) NULL}, {"ViewSidePanel", NULL, N_ ("_Side panel"), "<Release>F12", N_ ("Show or hide the side panel"), (GCallback) NULL}, {"ViewBottomPanel", NULL, N_ ("_Bottom panel"), NULL, N_ ("Show or hide the bottom panel"), (GCallback) NULL}};

static inline gpointer
main_window_get_instance_private (MainWindow* self)
{
	return G_STRUCT_MEMBER_P (self, MainWindow_private_offset);
}

static void
_main_window_on_view_zoom_in_gtk_action_callback (GtkAction* action,
                                                  gpointer self)
{
#line 26 "main_window.vala"
	main_window_on_view_zoom_in ((MainWindow*) self);
#line 715 "main_window.c"
}

static void
_main_window_on_view_zoom_out_gtk_action_callback (GtkAction* action,
                                                   gpointer self)
{
#line 26 "main_window.vala"
	main_window_on_view_zoom_out ((MainWindow*) self);
#line 724 "main_window.c"
}

static void
_main_window_on_view_zoom_reset_gtk_action_callback (GtkAction* action,
                                                     gpointer self)
{
#line 26 "main_window.vala"
	main_window_on_view_zoom_reset ((MainWindow*) self);
#line 733 "main_window.c"
}

static void
_main_window_on_search_find_gtk_action_callback (GtkAction* action,
                                                 gpointer self)
{
#line 26 "main_window.vala"
	main_window_on_search_find ((MainWindow*) self);
#line 742 "main_window.c"
}

static void
_main_window_on_search_replace_gtk_action_callback (GtkAction* action,
                                                    gpointer self)
{
#line 26 "main_window.vala"
	main_window_on_search_replace ((MainWindow*) self);
#line 751 "main_window.c"
}

static void
_main_window_on_search_forward_gtk_action_callback (GtkAction* action,
                                                    gpointer self)
{
#line 26 "main_window.vala"
	main_window_on_search_forward ((MainWindow*) self);
#line 760 "main_window.c"
}

static void
_main_window_on_projects_new_gtk_action_callback (GtkAction* action,
                                                  gpointer self)
{
#line 26 "main_window.vala"
	main_window_on_projects_new ((MainWindow*) self);
#line 769 "main_window.c"
}

static void
_main_window_on_projects_config_current_gtk_action_callback (GtkAction* action,
                                                             gpointer self)
{
#line 26 "main_window.vala"
	main_window_on_projects_config_current ((MainWindow*) self);
#line 778 "main_window.c"
}

static void
_main_window_on_projects_manage_gtk_action_callback (GtkAction* action,
                                                     gpointer self)
{
#line 26 "main_window.vala"
	main_window_on_projects_manage ((MainWindow*) self);
#line 787 "main_window.c"
}

static void
_main_window_on_help_latex_reference_gtk_action_callback (GtkAction* action,
                                                          gpointer self)
{
#line 26 "main_window.vala"
	main_window_on_help_latex_reference ((MainWindow*) self);
#line 796 "main_window.c"
}

/*************************************************************************/
static gpointer
_g_object_ref0 (gpointer self)
{
#line 156 "main_window.vala"
	return self ? g_object_ref (self) : NULL;
#line 805 "main_window.c"
}

static void
__lambda79_ (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
#line 275 "main_window.vala"
	main_window_update_file_actions_sensitivity (self);
#line 276 "main_window.vala"
	main_window_update_config_project_sensitivity (self);
#line 278 "main_window.vala"
	_tmp0_ = main_window_get_active_tab (self);
#line 278 "main_window.vala"
	_tmp1_ = _tmp0_;
#line 278 "main_window.vala"
	if (_tmp1_ == NULL) {
#line 823 "main_window.c"
		SearchAndReplace* _tmp2_;
#line 280 "main_window.vala"
		_tmp2_ = self->priv->_search_and_replace;
#line 280 "main_window.vala"
		search_and_replace_hide (_tmp2_);
#line 829 "main_window.c"
	}
#line 283 "main_window.vala"
	g_object_notify ((GObject*) self, "active-tab");
#line 833 "main_window.c"
}

static void
___lambda79__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 273 "main_window.vala"
	__lambda79_ ((MainWindow*) self);
#line 843 "main_window.c"
}

static void
__lambda80_ (MainWindow* self)
{
#line 288 "main_window.vala"
	g_object_notify ((GObject*) self, "active-view");
#line 851 "main_window.c"
}

static void
___lambda80__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 286 "main_window.vala"
	__lambda80_ ((MainWindow*) self);
#line 861 "main_window.c"
}

static void
__lambda81_ (MainWindow* self)
{
#line 293 "main_window.vala"
	g_object_notify ((GObject*) self, "active-document");
#line 869 "main_window.c"
}

static void
___lambda81__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 291 "main_window.vala"
	__lambda81_ ((MainWindow*) self);
#line 879 "main_window.c"
}

static gboolean
__lambda83_ (MainWindow* self)
{
	gboolean result = FALSE;
#line 305 "main_window.vala"
	main_window_quit (self);
#line 308 "main_window.vala"
	result = TRUE;
#line 308 "main_window.vala"
	return result;
#line 892 "main_window.c"
}

static gboolean
___lambda83__gtk_widget_delete_event (GtkWidget* _sender,
                                      GdkEventAny* event,
                                      gpointer self)
{
	gboolean result;
	result = __lambda83_ ((MainWindow*) self);
#line 303 "main_window.vala"
	return result;
#line 904 "main_window.c"
}

MainWindow*
main_window_construct (GType object_type,
                       GlatexApp* app)
{
	MainWindow * self = NULL;
	TeplApplicationWindow* tepl_window = NULL;
	TeplApplicationWindow* _tmp0_;
	TeplApplicationWindow* _tmp1_;
	GtkUIManager* _tmp2_;
	MainWindowFile* _tmp3_;
	GtkUIManager* _tmp4_;
	MainWindowEdit* _tmp5_;
	GtkUIManager* _tmp6_;
	MainWindowBuildTools* _tmp7_;
	GtkUIManager* _tmp8_;
	MainWindowDocuments* _tmp9_;
	GtkUIManager* _tmp10_;
	MainWindowStructure* _tmp11_;
	GtkUIManager* _tmp12_;
	MainWindowTools* _tmp13_;
	GtkGrid* main_vgrid = NULL;
	GtkGrid* _tmp14_;
	GtkWidget* menu = NULL;
	GtkUIManager* _tmp15_;
	GtkWidget* _tmp16_;
	GtkWidget* _tmp17_;
	GtkMenuItem* latex_menu_item = NULL;
	GtkUIManager* _tmp18_;
	GtkWidget* _tmp19_;
	GtkMenuItem* _tmp20_;
	GtkMenu* _tmp21_;
	GtkMenuItem* math_menu_item = NULL;
	GtkUIManager* _tmp22_;
	GtkWidget* _tmp23_;
	GtkMenuItem* _tmp24_;
	GtkMenu* _tmp25_;
	GtkPaned* menu_paned = NULL;
	GtkPaned* _tmp26_;
	GtkViewport* viewport = NULL;
	GtkViewport* _tmp27_;
	GdkRGBA transparent = {0};
	GdkRGBA _tmp28_;
	GtkToolbar* main_toolbar = NULL;
	GtkToolbar* _tmp29_;
	GtkToolbar* edit_toolbar = NULL;
	GtkToolbar* _tmp30_;
	GtkPaned* _tmp31_;
	GtkPaned* _tmp32_;
	GtkPaned* _tmp33_;
	TeplPanel* _tmp34_;
	GtkPaned* _tmp35_;
	TeplPanel* _tmp36_;
	GtkPaned* _tmp37_;
	GtkPaned* _tmp38_;
	GtkPaned* _tmp39_;
	GtkPaned* _tmp40_;
	GtkGrid* docs_vgrid = NULL;
	GtkGrid* _tmp41_;
	DocumentsPanel* _tmp42_;
	SearchAndReplace* _tmp43_;
	SearchAndReplace* _tmp44_;
	GtkWidget* _tmp45_;
	GtkWidget* _tmp46_;
	BottomPanel* bottom_panel = NULL;
	BottomPanel* _tmp47_;
	MainWindowBuildTools* _tmp48_;
	GtkPaned* _tmp49_;
	GtkPaned* _tmp50_;
	TeplStatusbar* _tmp51_;
	TeplStatusbar* _tmp52_;
	DocumentsPanel* _tmp53_;
	TeplStatusbar* _tmp54_;
	TeplStatusbar* _tmp55_;
	AmtkApplicationWindow* amtk_window = NULL;
	AmtkApplicationWindow* _tmp56_;
	AmtkApplicationWindow* _tmp57_;
	TeplStatusbar* _tmp58_;
	TeplStatusbar* _tmp59_;
	DocumentsPanel* _tmp60_;
#line 151 "main_window.vala"
	g_return_val_if_fail (app != NULL, NULL);
#line 153 "main_window.vala"
	self = (MainWindow*) g_object_new (object_type, "application", app, NULL);
#line 156 "main_window.vala"
	_tmp0_ = tepl_application_window_get_from_gtk_application_window ((GtkApplicationWindow*) self);
#line 156 "main_window.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 156 "main_window.vala"
	tepl_window = _tmp1_;
#line 159 "main_window.vala"
	latexila_latex_commands_add_actions ((GtkApplicationWindow*) self);
#line 163 "main_window.vala"
	main_window_initialize_ui_manager (self);
#line 165 "main_window.vala"
	_tmp2_ = self->priv->_ui_manager;
#line 165 "main_window.vala"
	_tmp3_ = main_window_file_new (self, _tmp2_);
#line 165 "main_window.vala"
	_main_window_file_unref0 (self->priv->_main_window_file);
#line 165 "main_window.vala"
	self->priv->_main_window_file = _tmp3_;
#line 166 "main_window.vala"
	_tmp4_ = self->priv->_ui_manager;
#line 166 "main_window.vala"
	_tmp5_ = main_window_edit_new (self, _tmp4_);
#line 166 "main_window.vala"
	_main_window_edit_unref0 (self->priv->_main_window_edit);
#line 166 "main_window.vala"
	self->priv->_main_window_edit = _tmp5_;
#line 167 "main_window.vala"
	_tmp6_ = self->priv->_ui_manager;
#line 167 "main_window.vala"
	_tmp7_ = main_window_build_tools_new (self, _tmp6_);
#line 167 "main_window.vala"
	_main_window_build_tools_unref0 (self->priv->_main_window_build_tools);
#line 167 "main_window.vala"
	self->priv->_main_window_build_tools = _tmp7_;
#line 168 "main_window.vala"
	_tmp8_ = self->priv->_ui_manager;
#line 168 "main_window.vala"
	_tmp9_ = main_window_documents_new (self, _tmp8_);
#line 168 "main_window.vala"
	_main_window_documents_unref0 (self->priv->_main_window_documents);
#line 168 "main_window.vala"
	self->priv->_main_window_documents = _tmp9_;
#line 169 "main_window.vala"
	_tmp10_ = self->priv->_ui_manager;
#line 169 "main_window.vala"
	_tmp11_ = main_window_structure_new (_tmp10_);
#line 169 "main_window.vala"
	_main_window_structure_unref0 (self->priv->_main_window_structure);
#line 169 "main_window.vala"
	self->priv->_main_window_structure = _tmp11_;
#line 170 "main_window.vala"
	_tmp12_ = self->priv->_ui_manager;
#line 170 "main_window.vala"
	_tmp13_ = main_window_tools_new (self, _tmp12_);
#line 170 "main_window.vala"
	_main_window_tools_unref0 (self->priv->_main_window_tools);
#line 170 "main_window.vala"
	self->priv->_main_window_tools = _tmp13_;
#line 172 "main_window.vala"
	main_window_show_images_in_menu (self);
#line 173 "main_window.vala"
	main_window_update_file_actions_sensitivity (self);
#line 177 "main_window.vala"
	_tmp14_ = (GtkGrid*) gtk_grid_new ();
#line 177 "main_window.vala"
	g_object_ref_sink (_tmp14_);
#line 177 "main_window.vala"
	main_vgrid = _tmp14_;
#line 178 "main_window.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) main_vgrid, GTK_ORIENTATION_VERTICAL);
#line 179 "main_window.vala"
	gtk_widget_show ((GtkWidget*) main_vgrid);
#line 180 "main_window.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) main_vgrid);
#line 184 "main_window.vala"
	_tmp15_ = self->priv->_ui_manager;
#line 184 "main_window.vala"
	_tmp16_ = gtk_ui_manager_get_widget (_tmp15_, "/MainMenu");
#line 184 "main_window.vala"
	_tmp17_ = _g_object_ref0 (_tmp16_);
#line 184 "main_window.vala"
	menu = _tmp17_;
#line 185 "main_window.vala"
	_tmp18_ = self->priv->_ui_manager;
#line 185 "main_window.vala"
	_tmp19_ = gtk_ui_manager_get_widget (_tmp18_, "/MainMenu/Latex");
#line 185 "main_window.vala"
	_tmp20_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, gtk_menu_item_get_type ()) ? ((GtkMenuItem*) _tmp19_) : NULL);
#line 185 "main_window.vala"
	latex_menu_item = _tmp20_;
#line 187 "main_window.vala"
	_tmp21_ = latexila_latex_commands_create_latex_menu ((GtkApplicationWindow*) self);
#line 187 "main_window.vala"
	gtk_menu_item_set_submenu (latex_menu_item, _tmp21_);
#line 188 "main_window.vala"
	_tmp22_ = self->priv->_ui_manager;
#line 188 "main_window.vala"
	_tmp23_ = gtk_ui_manager_get_widget (_tmp22_, "/MainMenu/Math");
#line 188 "main_window.vala"
	_tmp24_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp23_, gtk_menu_item_get_type ()) ? ((GtkMenuItem*) _tmp23_) : NULL);
#line 188 "main_window.vala"
	math_menu_item = _tmp24_;
#line 190 "main_window.vala"
	_tmp25_ = latexila_latex_commands_create_math_menu ((GtkApplicationWindow*) self);
#line 190 "main_window.vala"
	gtk_menu_item_set_submenu (math_menu_item, _tmp25_);
#line 193 "main_window.vala"
	_tmp26_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
#line 193 "main_window.vala"
	g_object_ref_sink (_tmp26_);
#line 193 "main_window.vala"
	menu_paned = _tmp26_;
#line 194 "main_window.vala"
	_tmp27_ = (GtkViewport*) gtk_viewport_new (NULL, NULL);
#line 194 "main_window.vala"
	g_object_ref_sink (_tmp27_);
#line 194 "main_window.vala"
	viewport = _tmp27_;
#line 195 "main_window.vala"
	gtk_viewport_set_shadow_type (viewport, GTK_SHADOW_NONE);
#line 196 "main_window.vala"
	memset (&transparent, 0, sizeof (GdkRGBA));
#line 197 "main_window.vala"
	transparent.alpha = 0.0;
#line 198 "main_window.vala"
	_tmp28_ = transparent;
#line 198 "main_window.vala"
	gtk_widget_override_background_color ((GtkWidget*) viewport, GTK_STATE_FLAG_NORMAL, &_tmp28_);
#line 199 "main_window.vala"
	gtk_container_add ((GtkContainer*) viewport, menu);
#line 200 "main_window.vala"
	gtk_paned_add1 (menu_paned, (GtkWidget*) viewport);
#line 201 "main_window.vala"
	gtk_widget_show_all ((GtkWidget*) menu_paned);
#line 202 "main_window.vala"
	gtk_container_add ((GtkContainer*) main_vgrid, (GtkWidget*) menu_paned);
#line 206 "main_window.vala"
	_tmp29_ = main_window_get_main_toolbar (self);
#line 206 "main_window.vala"
	main_toolbar = _tmp29_;
#line 207 "main_window.vala"
	_tmp30_ = main_window_get_edit_toolbar (self);
#line 207 "main_window.vala"
	edit_toolbar = _tmp30_;
#line 208 "main_window.vala"
	gtk_container_add ((GtkContainer*) main_vgrid, (GtkWidget*) main_toolbar);
#line 209 "main_window.vala"
	gtk_container_add ((GtkContainer*) main_vgrid, (GtkWidget*) edit_toolbar);
#line 216 "main_window.vala"
	_tmp31_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
#line 216 "main_window.vala"
	g_object_ref_sink (_tmp31_);
#line 216 "main_window.vala"
	_g_object_unref0 (self->priv->_main_hpaned);
#line 216 "main_window.vala"
	self->priv->_main_hpaned = _tmp31_;
#line 217 "main_window.vala"
	_tmp32_ = self->priv->_main_hpaned;
#line 217 "main_window.vala"
	gtk_widget_show ((GtkWidget*) _tmp32_);
#line 218 "main_window.vala"
	_tmp33_ = self->priv->_main_hpaned;
#line 218 "main_window.vala"
	gtk_container_add ((GtkContainer*) main_vgrid, (GtkWidget*) _tmp33_);
#line 222 "main_window.vala"
	_tmp34_ = main_window_get_side_panel (self);
#line 222 "main_window.vala"
	_g_object_unref0 (self->priv->_side_panel);
#line 222 "main_window.vala"
	self->priv->_side_panel = _tmp34_;
#line 223 "main_window.vala"
	_tmp35_ = self->priv->_main_hpaned;
#line 223 "main_window.vala"
	_tmp36_ = self->priv->_side_panel;
#line 223 "main_window.vala"
	gtk_paned_pack1 (_tmp35_, (GtkWidget*) _tmp36_, FALSE, FALSE);
#line 230 "main_window.vala"
	_tmp37_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_VERTICAL);
#line 230 "main_window.vala"
	g_object_ref_sink (_tmp37_);
#line 230 "main_window.vala"
	_g_object_unref0 (self->priv->_vpaned);
#line 230 "main_window.vala"
	self->priv->_vpaned = _tmp37_;
#line 231 "main_window.vala"
	_tmp38_ = self->priv->_vpaned;
#line 231 "main_window.vala"
	gtk_widget_show ((GtkWidget*) _tmp38_);
#line 232 "main_window.vala"
	_tmp39_ = self->priv->_main_hpaned;
#line 232 "main_window.vala"
	_tmp40_ = self->priv->_vpaned;
#line 232 "main_window.vala"
	gtk_paned_add2 (_tmp39_, (GtkWidget*) _tmp40_);
#line 236 "main_window.vala"
	_tmp41_ = (GtkGrid*) gtk_grid_new ();
#line 236 "main_window.vala"
	g_object_ref_sink (_tmp41_);
#line 236 "main_window.vala"
	docs_vgrid = _tmp41_;
#line 237 "main_window.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) docs_vgrid, GTK_ORIENTATION_VERTICAL);
#line 238 "main_window.vala"
	gtk_grid_set_row_spacing (docs_vgrid, (guint) 2);
#line 239 "main_window.vala"
	gtk_widget_show ((GtkWidget*) docs_vgrid);
#line 242 "main_window.vala"
	main_window_init_documents_panel (self);
#line 243 "main_window.vala"
	_tmp42_ = self->priv->_documents_panel;
#line 243 "main_window.vala"
	gtk_container_add ((GtkContainer*) docs_vgrid, (GtkWidget*) _tmp42_);
#line 246 "main_window.vala"
	_tmp43_ = search_and_replace_new (self);
#line 246 "main_window.vala"
	_g_object_unref0 (self->priv->_search_and_replace);
#line 246 "main_window.vala"
	self->priv->_search_and_replace = _tmp43_;
#line 247 "main_window.vala"
	_tmp44_ = self->priv->_search_and_replace;
#line 247 "main_window.vala"
	_tmp45_ = search_and_replace_get_widget (_tmp44_);
#line 247 "main_window.vala"
	_tmp46_ = _tmp45_;
#line 247 "main_window.vala"
	gtk_container_add ((GtkContainer*) docs_vgrid, _tmp46_);
#line 247 "main_window.vala"
	_g_object_unref0 (_tmp46_);
#line 251 "main_window.vala"
	_tmp47_ = main_window_get_bottom_panel (self);
#line 251 "main_window.vala"
	bottom_panel = _tmp47_;
#line 252 "main_window.vala"
	_tmp48_ = self->priv->_main_window_build_tools;
#line 252 "main_window.vala"
	main_window_build_tools_set_bottom_panel (_tmp48_, bottom_panel);
#line 255 "main_window.vala"
	_tmp49_ = self->priv->_vpaned;
#line 255 "main_window.vala"
	gtk_paned_pack1 (_tmp49_, (GtkWidget*) docs_vgrid, TRUE, TRUE);
#line 256 "main_window.vala"
	_tmp50_ = self->priv->_vpaned;
#line 256 "main_window.vala"
	gtk_paned_pack2 (_tmp50_, (GtkWidget*) bottom_panel, FALSE, FALSE);
#line 260 "main_window.vala"
	_tmp51_ = tepl_statusbar_new ();
#line 260 "main_window.vala"
	g_object_ref_sink (_tmp51_);
#line 260 "main_window.vala"
	_g_object_unref0 (self->priv->_statusbar);
#line 260 "main_window.vala"
	self->priv->_statusbar = _tmp51_;
#line 261 "main_window.vala"
	_tmp52_ = self->priv->_statusbar;
#line 261 "main_window.vala"
	_tmp53_ = self->priv->_documents_panel;
#line 261 "main_window.vala"
	tepl_statusbar_set_tab_group (_tmp52_, (TeplTabGroup*) _tmp53_);
#line 262 "main_window.vala"
	_tmp54_ = self->priv->_statusbar;
#line 262 "main_window.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp54_);
#line 263 "main_window.vala"
	_tmp55_ = self->priv->_statusbar;
#line 263 "main_window.vala"
	gtk_container_add ((GtkContainer*) main_vgrid, (GtkWidget*) _tmp55_);
#line 265 "main_window.vala"
	_tmp56_ = amtk_application_window_get_from_gtk_application_window ((GtkApplicationWindow*) self);
#line 265 "main_window.vala"
	_tmp57_ = _g_object_ref0 (_tmp56_);
#line 265 "main_window.vala"
	amtk_window = _tmp57_;
#line 267 "main_window.vala"
	_tmp58_ = self->priv->_statusbar;
#line 267 "main_window.vala"
	amtk_application_window_set_statusbar (amtk_window, (GtkStatusbar*) _tmp58_);
#line 269 "main_window.vala"
	_tmp59_ = self->priv->_statusbar;
#line 269 "main_window.vala"
	self->priv->_tip_message_cid = gtk_statusbar_get_context_id ((GtkStatusbar*) _tmp59_, "tip_message");
#line 273 "main_window.vala"
	g_signal_connect_object ((GObject*) tepl_window, "notify::active-tab", (GCallback) ___lambda79__g_object_notify, self, 0);
#line 286 "main_window.vala"
	g_signal_connect_object ((GObject*) tepl_window, "notify::active-view", (GCallback) ___lambda80__g_object_notify, self, 0);
#line 291 "main_window.vala"
	g_signal_connect_object ((GObject*) tepl_window, "notify::active-buffer", (GCallback) ___lambda81__g_object_notify, self, 0);
#line 296 "main_window.vala"
	_tmp60_ = self->priv->_documents_panel;
#line 296 "main_window.vala"
	tepl_application_window_set_tab_group (tepl_window, (TeplTabGroup*) _tmp60_);
#line 297 "main_window.vala"
	tepl_application_window_set_handle_title (tepl_window, TRUE);
#line 301 "main_window.vala"
	main_window_support_drag_and_drop (self);
#line 303 "main_window.vala"
	g_signal_connect_object ((GtkWidget*) self, "delete-event", (GCallback) ___lambda83__gtk_widget_delete_event, self, 0);
#line 311 "main_window.vala"
	main_window_restore_state (self);
#line 312 "main_window.vala"
	main_window_show_or_hide_widgets (self);
#line 313 "main_window.vala"
	gtk_widget_show ((GtkWidget*) self);
#line 151 "main_window.vala"
	_g_object_unref0 (amtk_window);
#line 151 "main_window.vala"
	_g_object_unref0 (bottom_panel);
#line 151 "main_window.vala"
	_g_object_unref0 (docs_vgrid);
#line 151 "main_window.vala"
	_g_object_unref0 (edit_toolbar);
#line 151 "main_window.vala"
	_g_object_unref0 (main_toolbar);
#line 151 "main_window.vala"
	_g_object_unref0 (viewport);
#line 151 "main_window.vala"
	_g_object_unref0 (menu_paned);
#line 151 "main_window.vala"
	_g_object_unref0 (math_menu_item);
#line 151 "main_window.vala"
	_g_object_unref0 (latex_menu_item);
#line 151 "main_window.vala"
	_g_object_unref0 (menu);
#line 151 "main_window.vala"
	_g_object_unref0 (main_vgrid);
#line 151 "main_window.vala"
	_g_object_unref0 (tepl_window);
#line 151 "main_window.vala"
	return self;
#line 1318 "main_window.c"
}

MainWindow*
main_window_new (GlatexApp* app)
{
#line 151 "main_window.vala"
	return main_window_construct (TYPE_MAIN_WINDOW, app);
#line 1326 "main_window.c"
}

static void
main_window_show_images_in_menu (MainWindow* self)
{
	GtkUIManager* _tmp0_;
	GList* _tmp1_;
#line 318 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 320 "main_window.vala"
	_tmp0_ = self->priv->_ui_manager;
#line 320 "main_window.vala"
	_tmp1_ = gtk_ui_manager_get_action_groups (_tmp0_);
#line 1340 "main_window.c"
	{
		GList* action_group_collection = NULL;
		GList* action_group_it = NULL;
#line 320 "main_window.vala"
		action_group_collection = _tmp1_;
#line 320 "main_window.vala"
		for (action_group_it = action_group_collection; action_group_it != NULL; action_group_it = action_group_it->next) {
#line 1348 "main_window.c"
			GtkActionGroup* _tmp2_;
			GtkActionGroup* action_group = NULL;
#line 320 "main_window.vala"
			_tmp2_ = _g_object_ref0 ((GtkActionGroup*) action_group_it->data);
#line 320 "main_window.vala"
			action_group = _tmp2_;
#line 1355 "main_window.c"
			{
				GtkActionGroup* _tmp3_;
				GList* _tmp4_;
#line 322 "main_window.vala"
				_tmp3_ = action_group;
#line 322 "main_window.vala"
				_tmp4_ = gtk_action_group_list_actions (_tmp3_);
#line 1363 "main_window.c"
				{
					GList* action_collection = NULL;
					GList* action_it = NULL;
#line 322 "main_window.vala"
					action_collection = _tmp4_;
#line 322 "main_window.vala"
					for (action_it = action_collection; action_it != NULL; action_it = action_it->next) {
#line 1371 "main_window.c"
						GtkAction* _tmp5_;
						GtkAction* action = NULL;
#line 322 "main_window.vala"
						_tmp5_ = _g_object_ref0 ((GtkAction*) action_it->data);
#line 322 "main_window.vala"
						action = _tmp5_;
#line 1378 "main_window.c"
						{
							GtkAction* _tmp6_;
#line 324 "main_window.vala"
							_tmp6_ = action;
#line 324 "main_window.vala"
							gtk_action_set_always_show_image (_tmp6_, TRUE);
#line 322 "main_window.vala"
							_g_object_unref0 (action);
#line 1387 "main_window.c"
						}
					}
#line 322 "main_window.vala"
					(action_collection == NULL) ? NULL : (action_collection = (g_list_free (action_collection), NULL));
#line 1392 "main_window.c"
				}
#line 320 "main_window.vala"
				_g_object_unref0 (action_group);
#line 1396 "main_window.c"
			}
		}
	}
}

static void
_main_window_on_menu_item_select_gtk_menu_item_select (GtkMenuItem* _sender,
                                                       gpointer self)
{
#line 369 "main_window.vala"
	main_window_on_menu_item_select ((MainWindow*) self, _sender);
#line 1408 "main_window.c"
}

static void
_main_window_on_menu_item_deselect_gtk_menu_item_deselect (GtkMenuItem* _sender,
                                                           gpointer self)
{
#line 370 "main_window.vala"
	main_window_on_menu_item_deselect ((MainWindow*) self, _sender);
#line 1417 "main_window.c"
}

static void
__lambda63_ (MainWindow* self,
             GtkAction* action,
             GtkWidget* p)
{
#line 364 "main_window.vala"
	g_return_if_fail (action != NULL);
#line 364 "main_window.vala"
	g_return_if_fail (p != NULL);
#line 366 "main_window.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (p, gtk_menu_item_get_type ())) {
#line 1431 "main_window.c"
		GtkMenuItem* proxy = NULL;
		GtkMenuItem* _tmp0_;
		GtkMenuItem* _tmp1_;
		GtkMenuItem* _tmp2_;
#line 368 "main_window.vala"
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (p, gtk_menu_item_get_type ()) ? ((GtkMenuItem*) p) : NULL);
#line 368 "main_window.vala"
		proxy = _tmp0_;
#line 369 "main_window.vala"
		_tmp1_ = proxy;
#line 369 "main_window.vala"
		g_signal_connect_object (_tmp1_, "select", (GCallback) _main_window_on_menu_item_select_gtk_menu_item_select, self, 0);
#line 370 "main_window.vala"
		_tmp2_ = proxy;
#line 370 "main_window.vala"
		g_signal_connect_object (_tmp2_, "deselect", (GCallback) _main_window_on_menu_item_deselect_gtk_menu_item_deselect, self, 0);
#line 366 "main_window.vala"
		_g_object_unref0 (proxy);
#line 1450 "main_window.c"
	}
}

static void
___lambda63__gtk_ui_manager_connect_proxy (GtkUIManager* _sender,
                                           GtkAction* action,
                                           GtkWidget* proxy,
                                           gpointer self)
{
#line 364 "main_window.vala"
	__lambda63_ ((MainWindow*) self, action, proxy);
#line 1462 "main_window.c"
}

static void
__lambda64_ (MainWindow* self,
             GtkAction* action,
             GtkWidget* p)
{
#line 374 "main_window.vala"
	g_return_if_fail (action != NULL);
#line 374 "main_window.vala"
	g_return_if_fail (p != NULL);
#line 376 "main_window.vala"
	if (G_TYPE_CHECK_INSTANCE_TYPE (p, gtk_menu_item_get_type ())) {
#line 1476 "main_window.c"
		GtkMenuItem* proxy = NULL;
		GtkMenuItem* _tmp0_;
		GtkMenuItem* _tmp1_;
		guint _tmp2_;
		GtkMenuItem* _tmp3_;
		guint _tmp4_;
#line 378 "main_window.vala"
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (p, gtk_menu_item_get_type ()) ? ((GtkMenuItem*) p) : NULL);
#line 378 "main_window.vala"
		proxy = _tmp0_;
#line 379 "main_window.vala"
		_tmp1_ = proxy;
#line 379 "main_window.vala"
		g_signal_parse_name ("select", gtk_menu_item_get_type (), &_tmp2_, NULL, FALSE);
#line 379 "main_window.vala"
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _main_window_on_menu_item_select_gtk_menu_item_select, self);
#line 380 "main_window.vala"
		_tmp3_ = proxy;
#line 380 "main_window.vala"
		g_signal_parse_name ("deselect", gtk_menu_item_get_type (), &_tmp4_, NULL, FALSE);
#line 380 "main_window.vala"
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _main_window_on_menu_item_deselect_gtk_menu_item_deselect, self);
#line 376 "main_window.vala"
		_g_object_unref0 (proxy);
#line 1501 "main_window.c"
	}
}

static void
___lambda64__gtk_ui_manager_disconnect_proxy (GtkUIManager* _sender,
                                              GtkAction* action,
                                              GtkWidget* proxy,
                                              gpointer self)
{
#line 374 "main_window.vala"
	__lambda64_ ((MainWindow*) self, action, proxy);
#line 1513 "main_window.c"
}

static void
main_window_initialize_ui_manager (MainWindow* self)
{
	GtkActionGroup* _tmp0_;
	GtkActionGroup* _tmp1_;
	GtkActionGroup* _tmp2_;
	GtkActionGroup* _tmp3_;
	GtkActionGroup* _tmp4_;
	GtkUIManager* _tmp5_;
	GtkUIManager* _tmp6_;
	GtkActionGroup* _tmp7_;
	GtkUIManager* _tmp11_;
	GtkAccelGroup* _tmp12_;
	GlatexApp* app = NULL;
	GlatexApp* _tmp13_;
	GtkActionGroup* _tmp14_;
	GtkActionGroup* _tmp15_;
	GtkActionGroup* _tmp16_;
	GtkUIManager* _tmp17_;
	GtkUIManager* _tmp18_;
	GError* _inner_error0_ = NULL;
#line 329 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 331 "main_window.vala"
	_tmp0_ = gtk_action_group_new ("ActionGroup");
#line 331 "main_window.vala"
	_g_object_unref0 (self->priv->_action_group);
#line 331 "main_window.vala"
	self->priv->_action_group = _tmp0_;
#line 332 "main_window.vala"
	_tmp1_ = self->priv->_action_group;
#line 332 "main_window.vala"
	gtk_action_group_set_translation_domain (_tmp1_, GETTEXT_PACKAGE);
#line 333 "main_window.vala"
	_tmp2_ = self->priv->_action_group;
#line 333 "main_window.vala"
	gtk_action_group_add_actions (_tmp2_, MAIN_WINDOW__action_entries, (guint) G_N_ELEMENTS (MAIN_WINDOW__action_entries), self);
#line 334 "main_window.vala"
	_tmp3_ = self->priv->_action_group;
#line 334 "main_window.vala"
	gtk_action_group_add_toggle_actions (_tmp3_, MAIN_WINDOW__toggle_action_entries, (guint) G_N_ELEMENTS (MAIN_WINDOW__toggle_action_entries), self);
#line 336 "main_window.vala"
	_tmp4_ = self->priv->_action_group;
#line 336 "main_window.vala"
	amtk_utils_create_gtk_action ((GActionMap*) self, "win.tepl-goto-line", _tmp4_, "SearchGoToLine");
#line 339 "main_window.vala"
	_tmp5_ = gtk_ui_manager_new ();
#line 339 "main_window.vala"
	_g_object_unref0 (self->priv->_ui_manager);
#line 339 "main_window.vala"
	self->priv->_ui_manager = _tmp5_;
#line 340 "main_window.vala"
	_tmp6_ = self->priv->_ui_manager;
#line 340 "main_window.vala"
	_tmp7_ = self->priv->_action_group;
#line 340 "main_window.vala"
	gtk_ui_manager_insert_action_group (_tmp6_, _tmp7_, 0);
#line 1573 "main_window.c"
	{
		gchar* path = NULL;
		gchar* _tmp8_;
		GtkUIManager* _tmp9_;
#line 344 "main_window.vala"
		_tmp8_ = g_build_filename (DATA_DIR, "ui", "ui.xml", NULL);
#line 344 "main_window.vala"
		path = _tmp8_;
#line 345 "main_window.vala"
		_tmp9_ = self->priv->_ui_manager;
#line 345 "main_window.vala"
		gtk_ui_manager_add_ui_from_file (_tmp9_, path, &_inner_error0_);
#line 345 "main_window.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 345 "main_window.vala"
			_g_free0 (path);
#line 1590 "main_window.c"
			goto __catch0_g_error;
		}
#line 342 "main_window.vala"
		_g_free0 (path);
#line 1595 "main_window.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		const gchar* _tmp10_;
#line 342 "main_window.vala"
		err = _inner_error0_;
#line 342 "main_window.vala"
		_inner_error0_ = NULL;
#line 349 "main_window.vala"
		_tmp10_ = err->message;
#line 349 "main_window.vala"
		g_error ("main_window.vala:349: %s", _tmp10_);
#line 342 "main_window.vala"
		_g_error_free0 (err);
#line 1612 "main_window.c"
	}
	__finally0:
#line 342 "main_window.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 342 "main_window.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 342 "main_window.vala"
		g_clear_error (&_inner_error0_);
#line 342 "main_window.vala"
		return;
#line 1623 "main_window.c"
	}
#line 352 "main_window.vala"
	_tmp11_ = self->priv->_ui_manager;
#line 352 "main_window.vala"
	_tmp12_ = gtk_ui_manager_get_accel_group (_tmp11_);
#line 352 "main_window.vala"
	gtk_window_add_accel_group ((GtkWindow*) self, _tmp12_);
#line 354 "main_window.vala"
	_tmp13_ = glatex_app_get_instance ();
#line 354 "main_window.vala"
	app = _tmp13_;
#line 355 "main_window.vala"
	_tmp14_ = self->priv->_action_group;
#line 355 "main_window.vala"
	amtk_utils_bind_g_action_to_gtk_action ((GActionMap*) app, "quit", _tmp14_, "FileQuit");
#line 357 "main_window.vala"
	_tmp15_ = self->priv->_action_group;
#line 357 "main_window.vala"
	amtk_utils_bind_g_action_to_gtk_action ((GActionMap*) app, "help", _tmp15_, "HelpContents");
#line 359 "main_window.vala"
	_tmp16_ = self->priv->_action_group;
#line 359 "main_window.vala"
	amtk_utils_bind_g_action_to_gtk_action ((GActionMap*) app, "about", _tmp16_, "HelpAbout");
#line 364 "main_window.vala"
	_tmp17_ = self->priv->_ui_manager;
#line 364 "main_window.vala"
	g_signal_connect_object (_tmp17_, "connect-proxy", (GCallback) ___lambda63__gtk_ui_manager_connect_proxy, self, 0);
#line 374 "main_window.vala"
	_tmp18_ = self->priv->_ui_manager;
#line 374 "main_window.vala"
	g_signal_connect_object (_tmp18_, "disconnect-proxy", (GCallback) ___lambda64__gtk_ui_manager_disconnect_proxy, self, 0);
#line 329 "main_window.vala"
	_g_object_unref0 (app);
#line 1657 "main_window.c"
}

static void
main_window_on_menu_item_select (MainWindow* self,
                                 GtkMenuItem* proxy)
{
	GtkAction* action = NULL;
	GtkAction* _tmp0_;
	GtkAction* _tmp1_;
	GtkAction* _tmp2_;
	GtkAction* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
#line 385 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 385 "main_window.vala"
	g_return_if_fail (proxy != NULL);
#line 387 "main_window.vala"
	_tmp0_ = gtk_activatable_get_related_action ((GtkActivatable*) proxy);
#line 387 "main_window.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 387 "main_window.vala"
	action = _tmp1_;
#line 388 "main_window.vala"
	_tmp2_ = action;
#line 388 "main_window.vala"
	g_return_if_fail (_tmp2_ != NULL);
#line 389 "main_window.vala"
	_tmp3_ = action;
#line 389 "main_window.vala"
	_tmp4_ = gtk_action_get_tooltip (_tmp3_);
#line 389 "main_window.vala"
	_tmp5_ = _tmp4_;
#line 389 "main_window.vala"
	if (_tmp5_ != NULL) {
#line 1693 "main_window.c"
		TeplStatusbar* _tmp6_;
		GtkAction* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
#line 390 "main_window.vala"
		_tmp6_ = self->priv->_statusbar;
#line 390 "main_window.vala"
		_tmp7_ = action;
#line 390 "main_window.vala"
		_tmp8_ = gtk_action_get_tooltip (_tmp7_);
#line 390 "main_window.vala"
		_tmp9_ = _tmp8_;
#line 390 "main_window.vala"
		gtk_statusbar_push ((GtkStatusbar*) _tmp6_, self->priv->_tip_message_cid, _tmp9_);
#line 1708 "main_window.c"
	}
#line 385 "main_window.vala"
	_g_object_unref0 (action);
#line 1712 "main_window.c"
}

static void
main_window_on_menu_item_deselect (MainWindow* self,
                                   GtkMenuItem* proxy)
{
	TeplStatusbar* _tmp0_;
#line 393 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 393 "main_window.vala"
	g_return_if_fail (proxy != NULL);
#line 395 "main_window.vala"
	_tmp0_ = self->priv->_statusbar;
#line 395 "main_window.vala"
	gtk_statusbar_pop ((GtkStatusbar*) _tmp0_, self->priv->_tip_message_cid);
#line 1728 "main_window.c"
}

static GtkToolbar*
main_window_get_main_toolbar (MainWindow* self)
{
	GtkToolbar* main_toolbar = NULL;
	GtkUIManager* _tmp0_;
	GtkWidget* _tmp1_;
	GtkToolbar* _tmp2_;
	GtkToolItem* open_button = NULL;
	MainWindowFile* _tmp3_;
	GtkToolItem* _tmp4_;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp7_;
	GtkAction* _tmp8_;
	GtkToggleAction* _tmp9_;
	GtkToolbar* result = NULL;
#line 398 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 400 "main_window.vala"
	_tmp0_ = self->priv->_ui_manager;
#line 400 "main_window.vala"
	_tmp1_ = gtk_ui_manager_get_widget (_tmp0_, "/MainToolbar");
#line 400 "main_window.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_toolbar_get_type ()) ? ((GtkToolbar*) _tmp1_) : NULL);
#line 400 "main_window.vala"
	main_toolbar = _tmp2_;
#line 401 "main_window.vala"
	_tmp3_ = self->priv->_main_window_file;
#line 401 "main_window.vala"
	_tmp4_ = main_window_file_get_toolbar_open_button (_tmp3_);
#line 401 "main_window.vala"
	open_button = _tmp4_;
#line 402 "main_window.vala"
	gtk_toolbar_insert (main_toolbar, open_button, 1);
#line 404 "main_window.vala"
	gtk_toolbar_set_style (main_toolbar, GTK_TOOLBAR_ICONS);
#line 405 "main_window.vala"
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) main_toolbar);
#line 405 "main_window.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 405 "main_window.vala"
	context = _tmp6_;
#line 406 "main_window.vala"
	gtk_style_context_add_class (context, GTK_STYLE_CLASS_PRIMARY_TOOLBAR);
#line 408 "main_window.vala"
	gtk_widget_show_all ((GtkWidget*) main_toolbar);
#line 410 "main_window.vala"
	_tmp7_ = self->priv->_action_group;
#line 410 "main_window.vala"
	_tmp8_ = gtk_action_group_get_action (_tmp7_, "ViewMainToolbar");
#line 410 "main_window.vala"
	_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp8_) : NULL);
#line 410 "main_window.vala"
	action = _tmp9_;
#line 412 "main_window.vala"
	gtk_toggle_action_set_active (action, TRUE);
#line 414 "main_window.vala"
	g_object_bind_property_with_closures ((GObject*) main_toolbar, "visible", (GObject*) action, "active", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 417 "main_window.vala"
	result = main_toolbar;
#line 417 "main_window.vala"
	_g_object_unref0 (action);
#line 417 "main_window.vala"
	_g_object_unref0 (context);
#line 417 "main_window.vala"
	_g_object_unref0 (open_button);
#line 417 "main_window.vala"
	return result;
#line 1801 "main_window.c"
}

static GtkToolbar*
main_window_get_edit_toolbar (MainWindow* self)
{
	GtkToolbar* edit_toolbar = NULL;
	GtkToolbar* _tmp0_;
	GtkToolbar* _tmp1_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp2_;
	GtkAction* _tmp3_;
	GtkToggleAction* _tmp4_;
	GtkToolbar* result = NULL;
#line 420 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 422 "main_window.vala"
	_tmp0_ = latexila_latex_commands_create_edit_toolbar ((GtkApplicationWindow*) self);
#line 422 "main_window.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 422 "main_window.vala"
	edit_toolbar = _tmp1_;
#line 424 "main_window.vala"
	_tmp2_ = self->priv->_action_group;
#line 424 "main_window.vala"
	_tmp3_ = gtk_action_group_get_action (_tmp2_, "ViewEditToolbar");
#line 424 "main_window.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp3_) : NULL);
#line 424 "main_window.vala"
	action = _tmp4_;
#line 426 "main_window.vala"
	gtk_toggle_action_set_active (action, TRUE);
#line 428 "main_window.vala"
	g_object_bind_property_with_closures ((GObject*) edit_toolbar, "visible", (GObject*) action, "active", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 431 "main_window.vala"
	result = edit_toolbar;
#line 431 "main_window.vala"
	_g_object_unref0 (action);
#line 431 "main_window.vala"
	return result;
#line 1841 "main_window.c"
}

static TeplPanel*
main_window_get_side_panel (MainWindow* self)
{
	TeplPanel* side_panel = NULL;
	TeplPanel* _tmp0_;
	SymbolsView* symbols = NULL;
	SymbolsView* _tmp1_;
	FileBrowser* file_browser = NULL;
	FileBrowser* _tmp2_;
	Structure* structure = NULL;
	Structure* _tmp3_;
	MainWindowStructure* _tmp4_;
	GSettings* settings = NULL;
	GSettings* _tmp5_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp6_;
	GtkAction* _tmp7_;
	GtkToggleAction* _tmp8_;
	TeplPanel* result = NULL;
#line 434 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 436 "main_window.vala"
	_tmp0_ = tepl_panel_new_for_left_side_panel ();
#line 436 "main_window.vala"
	g_object_ref_sink (_tmp0_);
#line 436 "main_window.vala"
	side_panel = _tmp0_;
#line 439 "main_window.vala"
	_tmp1_ = symbols_view_new (self);
#line 439 "main_window.vala"
	g_object_ref_sink (_tmp1_);
#line 439 "main_window.vala"
	symbols = _tmp1_;
#line 440 "main_window.vala"
	tepl_panel_add_component (side_panel, (GtkWidget*) symbols, "symbols", _ ("Symbols"), "symbol_greek");
#line 443 "main_window.vala"
	_tmp2_ = file_browser_new (self);
#line 443 "main_window.vala"
	g_object_ref_sink (_tmp2_);
#line 443 "main_window.vala"
	file_browser = _tmp2_;
#line 444 "main_window.vala"
	tepl_panel_add_component (side_panel, (GtkWidget*) file_browser, "file-browser", _ ("File Browser"), "document-open");
#line 448 "main_window.vala"
	_tmp3_ = structure_new (self);
#line 448 "main_window.vala"
	g_object_ref_sink (_tmp3_);
#line 448 "main_window.vala"
	structure = _tmp3_;
#line 449 "main_window.vala"
	_tmp4_ = self->priv->_main_window_structure;
#line 449 "main_window.vala"
	main_window_structure_set_structure (_tmp4_, structure);
#line 450 "main_window.vala"
	tepl_panel_add_component (side_panel, (GtkWidget*) structure, "structure", _ ("Structure"), GTK_STOCK_INDEX);
#line 453 "main_window.vala"
	_tmp5_ = g_settings_new ("org.gnome.gnome-latex.preferences.ui");
#line 453 "main_window.vala"
	settings = _tmp5_;
#line 454 "main_window.vala"
	tepl_panel_provide_active_component_gsetting (side_panel, settings, "side-panel-component");
#line 455 "main_window.vala"
	tepl_panel_restore_state_from_gsettings (side_panel);
#line 458 "main_window.vala"
	_tmp6_ = self->priv->_action_group;
#line 458 "main_window.vala"
	_tmp7_ = gtk_action_group_get_action (_tmp6_, "ViewSidePanel");
#line 458 "main_window.vala"
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp7_) : NULL);
#line 458 "main_window.vala"
	action = _tmp8_;
#line 459 "main_window.vala"
	gtk_toggle_action_set_active (action, TRUE);
#line 460 "main_window.vala"
	g_object_bind_property_with_closures ((GObject*) side_panel, "visible", (GObject*) action, "active", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 463 "main_window.vala"
	result = side_panel;
#line 463 "main_window.vala"
	_g_object_unref0 (action);
#line 463 "main_window.vala"
	_g_object_unref0 (settings);
#line 463 "main_window.vala"
	_g_object_unref0 (structure);
#line 463 "main_window.vala"
	_g_object_unref0 (file_browser);
#line 463 "main_window.vala"
	_g_object_unref0 (symbols);
#line 463 "main_window.vala"
	return result;
#line 1933 "main_window.c"
}

static void
__lambda78_ (MainWindow* self,
             GdkEventButton* event)
{
	GtkMenu* popup_menu = NULL;
	GtkUIManager* _tmp0_;
	GtkWidget* _tmp1_;
	GtkMenu* _tmp2_;
#line 473 "main_window.vala"
	g_return_if_fail (event != NULL);
#line 475 "main_window.vala"
	_tmp0_ = self->priv->_ui_manager;
#line 475 "main_window.vala"
	_tmp1_ = gtk_ui_manager_get_widget (_tmp0_, "/NotebookPopup");
#line 475 "main_window.vala"
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_menu_get_type ()) ? ((GtkMenu*) _tmp1_) : NULL);
#line 475 "main_window.vala"
	popup_menu = _tmp2_;
#line 476 "main_window.vala"
	gtk_menu_popup_at_pointer (popup_menu, (GdkEvent*) event);
#line 473 "main_window.vala"
	_g_object_unref0 (popup_menu);
#line 1958 "main_window.c"
}

static void
___lambda78__documents_panel_right_click (DocumentsPanel* _sender,
                                          GdkEventButton* event,
                                          gpointer self)
{
#line 473 "main_window.vala"
	__lambda78_ ((MainWindow*) self, event);
#line 1968 "main_window.c"
}

static void
main_window_init_documents_panel (MainWindow* self)
{
	DocumentsPanel* _tmp0_;
	DocumentsPanel* _tmp1_;
	MainWindowDocuments* _tmp2_;
	DocumentsPanel* _tmp3_;
	DocumentsPanel* _tmp4_;
#line 466 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 468 "main_window.vala"
	_tmp0_ = documents_panel_new (self);
#line 468 "main_window.vala"
	g_object_ref_sink (_tmp0_);
#line 468 "main_window.vala"
	_g_object_unref0 (self->priv->_documents_panel);
#line 468 "main_window.vala"
	self->priv->_documents_panel = _tmp0_;
#line 469 "main_window.vala"
	_tmp1_ = self->priv->_documents_panel;
#line 469 "main_window.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp1_);
#line 471 "main_window.vala"
	_tmp2_ = self->priv->_main_window_documents;
#line 471 "main_window.vala"
	_tmp3_ = self->priv->_documents_panel;
#line 471 "main_window.vala"
	main_window_documents_set_documents_panel (_tmp2_, _tmp3_);
#line 473 "main_window.vala"
	_tmp4_ = self->priv->_documents_panel;
#line 473 "main_window.vala"
	g_signal_connect_object (_tmp4_, "right-click", (GCallback) ___lambda78__documents_panel_right_click, self, 0);
#line 2003 "main_window.c"
}

static BottomPanel*
main_window_get_bottom_panel (MainWindow* self)
{
	LatexilaBuildView* build_view = NULL;
	LatexilaBuildView* _tmp0_;
	MainWindowBuildTools* _tmp1_;
	GtkToolbar* build_toolbar = NULL;
	GtkUIManager* _tmp2_;
	GtkWidget* _tmp3_;
	GtkToolbar* _tmp4_;
	BottomPanel* bottom_panel = NULL;
	BottomPanel* _tmp5_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp6_;
	GtkAction* _tmp7_;
	GtkToggleAction* _tmp8_;
	BottomPanel* result = NULL;
#line 480 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 482 "main_window.vala"
	_tmp0_ = latexila_build_view_new ();
#line 482 "main_window.vala"
	g_object_ref_sink (_tmp0_);
#line 482 "main_window.vala"
	build_view = _tmp0_;
#line 483 "main_window.vala"
	_tmp1_ = self->priv->_main_window_build_tools;
#line 483 "main_window.vala"
	main_window_build_tools_set_build_view (_tmp1_, build_view);
#line 485 "main_window.vala"
	_tmp2_ = self->priv->_ui_manager;
#line 485 "main_window.vala"
	_tmp3_ = gtk_ui_manager_get_widget (_tmp2_, "/BuildToolbar");
#line 485 "main_window.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_toolbar_get_type ()) ? ((GtkToolbar*) _tmp3_) : NULL);
#line 485 "main_window.vala"
	build_toolbar = _tmp4_;
#line 486 "main_window.vala"
	gtk_toolbar_set_style (build_toolbar, GTK_TOOLBAR_ICONS);
#line 487 "main_window.vala"
	gtk_toolbar_set_icon_size (build_toolbar, GTK_ICON_SIZE_MENU);
#line 488 "main_window.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) build_toolbar, GTK_ORIENTATION_VERTICAL);
#line 490 "main_window.vala"
	_tmp5_ = bottom_panel_new (build_view, build_toolbar);
#line 490 "main_window.vala"
	g_object_ref_sink (_tmp5_);
#line 490 "main_window.vala"
	bottom_panel = _tmp5_;
#line 493 "main_window.vala"
	_tmp6_ = self->priv->_action_group;
#line 493 "main_window.vala"
	_tmp7_ = gtk_action_group_get_action (_tmp6_, "ViewBottomPanel");
#line 493 "main_window.vala"
	_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp7_) : NULL);
#line 493 "main_window.vala"
	action = _tmp8_;
#line 495 "main_window.vala"
	gtk_toggle_action_set_active (action, FALSE);
#line 497 "main_window.vala"
	g_object_bind_property_with_closures ((GObject*) bottom_panel, "visible", (GObject*) action, "active", G_BINDING_BIDIRECTIONAL, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 500 "main_window.vala"
	result = bottom_panel;
#line 500 "main_window.vala"
	_g_object_unref0 (action);
#line 500 "main_window.vala"
	_g_object_unref0 (build_toolbar);
#line 500 "main_window.vala"
	_g_object_unref0 (build_view);
#line 500 "main_window.vala"
	return result;
#line 2077 "main_window.c"
}

static void
main_window_restore_state (MainWindow* self)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	gint width = 0;
	gint height = 0;
	GSettings* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GdkWindowState state = 0U;
	GSettings* _tmp4_;
	GdkWindowState _tmp5_;
	GdkWindowState _tmp6_;
	GtkPaned* _tmp7_;
	GSettings* _tmp8_;
	GtkPaned* _tmp9_;
	GSettings* _tmp10_;
#line 503 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 505 "main_window.vala"
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.state.window");
#line 505 "main_window.vala"
	settings = _tmp0_;
#line 511 "main_window.vala"
	_tmp1_ = settings;
#line 511 "main_window.vala"
	g_settings_get (_tmp1_, "size", "(ii)", &_tmp2_, &_tmp3_);
#line 511 "main_window.vala"
	width = _tmp2_;
#line 511 "main_window.vala"
	height = _tmp3_;
#line 512 "main_window.vala"
	gtk_window_set_default_size ((GtkWindow*) self, width, height);
#line 514 "main_window.vala"
	_tmp4_ = settings;
#line 514 "main_window.vala"
	state = (GdkWindowState) g_settings_get_int (_tmp4_, "state");
#line 515 "main_window.vala"
	_tmp5_ = state;
#line 515 "main_window.vala"
	if ((_tmp5_ & GDK_WINDOW_STATE_MAXIMIZED) == GDK_WINDOW_STATE_MAXIMIZED) {
#line 516 "main_window.vala"
		gtk_window_maximize ((GtkWindow*) self);
#line 2124 "main_window.c"
	} else {
#line 518 "main_window.vala"
		gtk_window_unmaximize ((GtkWindow*) self);
#line 2128 "main_window.c"
	}
#line 520 "main_window.vala"
	_tmp6_ = state;
#line 520 "main_window.vala"
	if ((_tmp6_ & GDK_WINDOW_STATE_STICKY) == GDK_WINDOW_STATE_STICKY) {
#line 521 "main_window.vala"
		gtk_window_stick ((GtkWindow*) self);
#line 2136 "main_window.c"
	} else {
#line 523 "main_window.vala"
		gtk_window_unstick ((GtkWindow*) self);
#line 2140 "main_window.c"
	}
#line 527 "main_window.vala"
	_tmp7_ = self->priv->_main_hpaned;
#line 527 "main_window.vala"
	_tmp8_ = settings;
#line 527 "main_window.vala"
	gtk_paned_set_position (_tmp7_, g_settings_get_int (_tmp8_, "side-panel-size"));
#line 528 "main_window.vala"
	_tmp9_ = self->priv->_vpaned;
#line 528 "main_window.vala"
	_tmp10_ = settings;
#line 528 "main_window.vala"
	gtk_paned_set_position (_tmp9_, g_settings_get_int (_tmp10_, "vertical-paned-position"));
#line 503 "main_window.vala"
	_g_object_unref0 (settings);
#line 2156 "main_window.c"
}

static void
_vala_array_add5 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
#line 544 "main_window.vala"
	if ((*length) == (*size)) {
#line 544 "main_window.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 544 "main_window.vala"
		*array = g_renew (GFile*, *array, (*size) + 1);
#line 2171 "main_window.c"
	}
#line 544 "main_window.vala"
	(*array)[(*length)++] = value;
#line 544 "main_window.vala"
	(*array)[*length] = NULL;
#line 2177 "main_window.c"
}

static void
__lambda82_ (MainWindow* self,
             GdkDragContext* dc,
             gint x,
             gint y,
             GtkSelectionData* selection_data,
             guint info,
             guint time)
{
	GlatexApp* app = NULL;
	GlatexApp* _tmp0_;
	GFile** files = NULL;
	GFile** _tmp1_;
	gint files_length1;
	gint _files_size_;
	gchar** _tmp2_;
	gchar** _tmp3_;
	GlatexApp* _tmp10_;
	GFile** _tmp11_;
	gint _tmp11__length1;
#line 536 "main_window.vala"
	g_return_if_fail (dc != NULL);
#line 536 "main_window.vala"
	g_return_if_fail (selection_data != NULL);
#line 538 "main_window.vala"
	_tmp0_ = glatex_app_get_instance ();
#line 538 "main_window.vala"
	app = _tmp0_;
#line 540 "main_window.vala"
	_tmp1_ = g_new0 (GFile*, 0 + 1);
#line 540 "main_window.vala"
	files = _tmp1_;
#line 540 "main_window.vala"
	files_length1 = 0;
#line 540 "main_window.vala"
	_files_size_ = files_length1;
#line 541 "main_window.vala"
	_tmp3_ = _tmp2_ = gtk_selection_data_get_uris (selection_data);
#line 2218 "main_window.c"
	{
		gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
#line 541 "main_window.vala"
		uri_collection = _tmp3_;
#line 541 "main_window.vala"
		uri_collection_length1 = _vala_array_length (_tmp2_);
#line 541 "main_window.vala"
		for (uri_it = 0; uri_it < uri_collection_length1; uri_it = uri_it + 1) {
#line 2230 "main_window.c"
			gchar* _tmp4_;
			gchar* uri = NULL;
#line 541 "main_window.vala"
			_tmp4_ = g_strdup (uri_collection[uri_it]);
#line 541 "main_window.vala"
			uri = _tmp4_;
#line 2237 "main_window.c"
			{
				const gchar* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
#line 543 "main_window.vala"
				_tmp5_ = uri;
#line 543 "main_window.vala"
				_tmp6_ = strlen (_tmp5_);
#line 543 "main_window.vala"
				_tmp7_ = _tmp6_;
#line 543 "main_window.vala"
				if (0 < _tmp7_) {
#line 2250 "main_window.c"
					const gchar* _tmp8_;
					GFile* _tmp9_;
#line 544 "main_window.vala"
					_tmp8_ = uri;
#line 544 "main_window.vala"
					_tmp9_ = g_file_new_for_uri (_tmp8_);
#line 544 "main_window.vala"
					_vala_array_add5 (&files, &files_length1, &_files_size_, _tmp9_);
#line 2259 "main_window.c"
				}
#line 541 "main_window.vala"
				_g_free0 (uri);
#line 2263 "main_window.c"
			}
		}
#line 541 "main_window.vala"
		uri_collection = (_vala_array_free (uri_collection, uri_collection_length1, (GDestroyNotify) g_free), NULL);
#line 2268 "main_window.c"
	}
#line 547 "main_window.vala"
	_tmp10_ = app;
#line 547 "main_window.vala"
	_tmp11_ = files;
#line 547 "main_window.vala"
	_tmp11__length1 = files_length1;
#line 547 "main_window.vala"
	glatex_app_open_documents (_tmp10_, _tmp11_, (gint) _tmp11__length1);
#line 548 "main_window.vala"
	gtk_drag_finish (dc, TRUE, TRUE, (guint32) time);
#line 536 "main_window.vala"
	files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
#line 536 "main_window.vala"
	_g_object_unref0 (app);
#line 2284 "main_window.c"
}

static void
___lambda82__gtk_widget_drag_data_received (GtkWidget* _sender,
                                            GdkDragContext* context,
                                            gint x,
                                            gint y,
                                            GtkSelectionData* selection_data,
                                            guint info,
                                            guint time_,
                                            gpointer self)
{
#line 536 "main_window.vala"
	__lambda82_ ((MainWindow*) self, context, x, y, selection_data, info, time_);
#line 2299 "main_window.c"
}

static void
main_window_support_drag_and_drop (MainWindow* self)
{
	GtkTargetEntry* _tmp0_;
	GtkTargetEntry* _tmp1_;
	gint _tmp1__length1;
#line 532 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 534 "main_window.vala"
	_tmp0_ = g_new0 (GtkTargetEntry, 0);
#line 534 "main_window.vala"
	_tmp1_ = _tmp0_;
#line 534 "main_window.vala"
	_tmp1__length1 = 0;
#line 534 "main_window.vala"
	gtk_drag_dest_set ((GtkWidget*) self, GTK_DEST_DEFAULT_ALL, _tmp1_, (gint) 0, GDK_ACTION_COPY);
#line 534 "main_window.vala"
	_tmp1_ = (g_free (_tmp1_), NULL);
#line 535 "main_window.vala"
	gtk_drag_dest_add_uri_targets ((GtkWidget*) self);
#line 536 "main_window.vala"
	g_signal_connect_object ((GtkWidget*) self, "drag-data-received", (GCallback) ___lambda82__gtk_widget_drag_data_received, self, 0);
#line 2324 "main_window.c"
}

static void
main_window_show_or_hide_widgets (MainWindow* self)
{
	GSettings* settings = NULL;
	GSettings* _tmp0_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp1_;
	GtkAction* _tmp2_;
	GtkToggleAction* _tmp3_;
	GtkToggleAction* _tmp4_;
	GtkActionGroup* _tmp5_;
	GtkAction* _tmp6_;
	GtkToggleAction* _tmp7_;
	GtkToggleAction* _tmp8_;
	GtkActionGroup* _tmp9_;
	GtkAction* _tmp10_;
	GtkToggleAction* _tmp11_;
	GtkToggleAction* _tmp12_;
	GtkActionGroup* _tmp13_;
	GtkAction* _tmp14_;
	GtkToggleAction* _tmp15_;
	GtkToggleAction* _tmp16_;
#line 552 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 554 "main_window.vala"
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.preferences.ui");
#line 554 "main_window.vala"
	settings = _tmp0_;
#line 556 "main_window.vala"
	_tmp1_ = self->priv->_action_group;
#line 556 "main_window.vala"
	_tmp2_ = gtk_action_group_get_action (_tmp1_, "ViewMainToolbar");
#line 556 "main_window.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp2_) : NULL);
#line 556 "main_window.vala"
	action = _tmp3_;
#line 558 "main_window.vala"
	_tmp4_ = action;
#line 558 "main_window.vala"
	gtk_toggle_action_set_active (_tmp4_, g_settings_get_boolean (settings, "main-toolbar-visible"));
#line 560 "main_window.vala"
	_tmp5_ = self->priv->_action_group;
#line 560 "main_window.vala"
	_tmp6_ = gtk_action_group_get_action (_tmp5_, "ViewEditToolbar");
#line 560 "main_window.vala"
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp6_) : NULL);
#line 560 "main_window.vala"
	_g_object_unref0 (action);
#line 560 "main_window.vala"
	action = _tmp7_;
#line 561 "main_window.vala"
	_tmp8_ = action;
#line 561 "main_window.vala"
	gtk_toggle_action_set_active (_tmp8_, g_settings_get_boolean (settings, "edit-toolbar-visible"));
#line 563 "main_window.vala"
	_tmp9_ = self->priv->_action_group;
#line 563 "main_window.vala"
	_tmp10_ = gtk_action_group_get_action (_tmp9_, "ViewSidePanel");
#line 563 "main_window.vala"
	_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp10_) : NULL);
#line 563 "main_window.vala"
	_g_object_unref0 (action);
#line 563 "main_window.vala"
	action = _tmp11_;
#line 564 "main_window.vala"
	_tmp12_ = action;
#line 564 "main_window.vala"
	gtk_toggle_action_set_active (_tmp12_, g_settings_get_boolean (settings, "side-panel-visible"));
#line 566 "main_window.vala"
	_tmp13_ = self->priv->_action_group;
#line 566 "main_window.vala"
	_tmp14_ = gtk_action_group_get_action (_tmp13_, "ViewBottomPanel");
#line 566 "main_window.vala"
	_tmp15_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, gtk_toggle_action_get_type ()) ? ((GtkToggleAction*) _tmp14_) : NULL);
#line 566 "main_window.vala"
	_g_object_unref0 (action);
#line 566 "main_window.vala"
	action = _tmp15_;
#line 567 "main_window.vala"
	_tmp16_ = action;
#line 567 "main_window.vala"
	gtk_toggle_action_set_active (_tmp16_, g_settings_get_boolean (settings, "bottom-panel-visible"));
#line 552 "main_window.vala"
	_g_object_unref0 (action);
#line 552 "main_window.vala"
	_g_object_unref0 (settings);
#line 2413 "main_window.c"
}

/*************************************************************************/
static gpointer
_main_window_structure_ref0 (gpointer self)
{
#line 575 "main_window.vala"
	return self ? main_window_structure_ref (self) : NULL;
#line 2422 "main_window.c"
}

MainWindowStructure*
main_window_get_main_window_structure (MainWindow* self)
{
	MainWindowStructure* _tmp0_;
	MainWindowStructure* _tmp1_;
	MainWindowStructure* result = NULL;
#line 573 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 575 "main_window.vala"
	_tmp0_ = self->priv->_main_window_structure;
#line 575 "main_window.vala"
	_tmp1_ = _main_window_structure_ref0 (_tmp0_);
#line 575 "main_window.vala"
	result = _tmp1_;
#line 575 "main_window.vala"
	return result;
#line 2441 "main_window.c"
}

/*************************************************************************/
GeeList*
main_window_get_documents (MainWindow* self)
{
	GeeList* all_documents = NULL;
	GeeLinkedList* _tmp0_;
	gint nb_documents = 0;
	DocumentsPanel* _tmp1_;
	GeeList* result = NULL;
#line 581 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 583 "main_window.vala"
	_tmp0_ = gee_linked_list_new (TYPE_DOCUMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 583 "main_window.vala"
	all_documents = (GeeList*) _tmp0_;
#line 584 "main_window.vala"
	_tmp1_ = self->priv->_documents_panel;
#line 584 "main_window.vala"
	nb_documents = gtk_notebook_get_n_pages ((GtkNotebook*) _tmp1_);
#line 2463 "main_window.c"
	{
		gint i = 0;
#line 585 "main_window.vala"
		i = 0;
#line 2468 "main_window.c"
		{
			gboolean _tmp2_ = FALSE;
#line 585 "main_window.vala"
			_tmp2_ = TRUE;
#line 585 "main_window.vala"
			while (TRUE) {
#line 2475 "main_window.c"
				DocumentTab* tab = NULL;
				DocumentsPanel* _tmp4_;
				GtkWidget* _tmp5_;
				DocumentTab* _tmp6_;
				GeeList* _tmp7_;
				DocumentTab* _tmp8_;
				Document* _tmp9_;
				Document* _tmp10_;
#line 585 "main_window.vala"
				if (!_tmp2_) {
#line 2486 "main_window.c"
					gint _tmp3_;
#line 585 "main_window.vala"
					_tmp3_ = i;
#line 585 "main_window.vala"
					i = _tmp3_ + 1;
#line 2492 "main_window.c"
				}
#line 585 "main_window.vala"
				_tmp2_ = FALSE;
#line 585 "main_window.vala"
				if (!(i < nb_documents)) {
#line 585 "main_window.vala"
					break;
#line 2500 "main_window.c"
				}
#line 587 "main_window.vala"
				_tmp4_ = self->priv->_documents_panel;
#line 587 "main_window.vala"
				_tmp5_ = gtk_notebook_get_nth_page ((GtkNotebook*) _tmp4_, i);
#line 587 "main_window.vala"
				_tmp6_ = _g_object_ref0 (IS_DOCUMENT_TAB (_tmp5_) ? ((DocumentTab*) _tmp5_) : NULL);
#line 587 "main_window.vala"
				tab = _tmp6_;
#line 588 "main_window.vala"
				_tmp7_ = all_documents;
#line 588 "main_window.vala"
				_tmp8_ = tab;
#line 588 "main_window.vala"
				_tmp9_ = document_tab_get_document (_tmp8_);
#line 588 "main_window.vala"
				_tmp10_ = _tmp9_;
#line 588 "main_window.vala"
				gee_collection_add ((GeeCollection*) _tmp7_, _tmp10_);
#line 585 "main_window.vala"
				_g_object_unref0 (tab);
#line 2522 "main_window.c"
			}
		}
	}
#line 591 "main_window.vala"
	result = all_documents;
#line 591 "main_window.vala"
	return result;
#line 2530 "main_window.c"
}

GeeList*
main_window_get_unsaved_documents (MainWindow* self)
{
	GeeList* unsaved_documents = NULL;
	GeeLinkedList* _tmp0_;
	GeeList* result = NULL;
#line 594 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 596 "main_window.vala"
	_tmp0_ = gee_linked_list_new (TYPE_DOCUMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 596 "main_window.vala"
	unsaved_documents = (GeeList*) _tmp0_;
#line 2545 "main_window.c"
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp1_;
		gint _doc_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _doc_index = 0;
#line 597 "main_window.vala"
		_tmp1_ = main_window_get_documents (self);
#line 597 "main_window.vala"
		_doc_list = _tmp1_;
#line 597 "main_window.vala"
		_tmp2_ = _doc_list;
#line 597 "main_window.vala"
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
#line 597 "main_window.vala"
		_tmp4_ = _tmp3_;
#line 597 "main_window.vala"
		_doc_size = _tmp4_;
#line 597 "main_window.vala"
		_doc_index = -1;
#line 597 "main_window.vala"
		while (TRUE) {
#line 2570 "main_window.c"
			Document* doc = NULL;
			GeeList* _tmp5_;
			gpointer _tmp6_;
			Document* _tmp7_;
#line 597 "main_window.vala"
			_doc_index = _doc_index + 1;
#line 597 "main_window.vala"
			if (!(_doc_index < _doc_size)) {
#line 597 "main_window.vala"
				break;
#line 2581 "main_window.c"
			}
#line 597 "main_window.vala"
			_tmp5_ = _doc_list;
#line 597 "main_window.vala"
			_tmp6_ = gee_list_get (_tmp5_, _doc_index);
#line 597 "main_window.vala"
			doc = (Document*) _tmp6_;
#line 599 "main_window.vala"
			_tmp7_ = doc;
#line 599 "main_window.vala"
			if (gtk_text_buffer_get_modified ((GtkTextBuffer*) _tmp7_)) {
#line 2593 "main_window.c"
				GeeList* _tmp8_;
				Document* _tmp9_;
#line 600 "main_window.vala"
				_tmp8_ = unsaved_documents;
#line 600 "main_window.vala"
				_tmp9_ = doc;
#line 600 "main_window.vala"
				gee_collection_add ((GeeCollection*) _tmp8_, _tmp9_);
#line 2602 "main_window.c"
			}
#line 597 "main_window.vala"
			_g_object_unref0 (doc);
#line 2606 "main_window.c"
		}
#line 597 "main_window.vala"
		_g_object_unref0 (_doc_list);
#line 2610 "main_window.c"
	}
#line 603 "main_window.vala"
	result = unsaved_documents;
#line 603 "main_window.vala"
	return result;
#line 2616 "main_window.c"
}

GeeList*
main_window_get_views (MainWindow* self)
{
	GeeList* all_views = NULL;
	GeeLinkedList* _tmp0_;
	DocumentsPanel* _tmp1_;
	gint nb_documents = 0;
	DocumentsPanel* _tmp2_;
	GeeList* result = NULL;
#line 606 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 608 "main_window.vala"
	_tmp0_ = gee_linked_list_new (TYPE_DOCUMENT_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 608 "main_window.vala"
	all_views = (GeeList*) _tmp0_;
#line 610 "main_window.vala"
	_tmp1_ = self->priv->_documents_panel;
#line 610 "main_window.vala"
	if (_tmp1_ == NULL) {
#line 611 "main_window.vala"
		result = all_views;
#line 611 "main_window.vala"
		return result;
#line 2642 "main_window.c"
	}
#line 613 "main_window.vala"
	_tmp2_ = self->priv->_documents_panel;
#line 613 "main_window.vala"
	nb_documents = gtk_notebook_get_n_pages ((GtkNotebook*) _tmp2_);
#line 2648 "main_window.c"
	{
		gint i = 0;
#line 615 "main_window.vala"
		i = 0;
#line 2653 "main_window.c"
		{
			gboolean _tmp3_ = FALSE;
#line 615 "main_window.vala"
			_tmp3_ = TRUE;
#line 615 "main_window.vala"
			while (TRUE) {
#line 2660 "main_window.c"
				DocumentTab* tab = NULL;
				DocumentsPanel* _tmp5_;
				GtkWidget* _tmp6_;
				DocumentTab* _tmp7_;
				GeeList* _tmp8_;
				DocumentTab* _tmp9_;
				DocumentView* _tmp10_;
				DocumentView* _tmp11_;
#line 615 "main_window.vala"
				if (!_tmp3_) {
#line 2671 "main_window.c"
					gint _tmp4_;
#line 615 "main_window.vala"
					_tmp4_ = i;
#line 615 "main_window.vala"
					i = _tmp4_ + 1;
#line 2677 "main_window.c"
				}
#line 615 "main_window.vala"
				_tmp3_ = FALSE;
#line 615 "main_window.vala"
				if (!(i < nb_documents)) {
#line 615 "main_window.vala"
					break;
#line 2685 "main_window.c"
				}
#line 617 "main_window.vala"
				_tmp5_ = self->priv->_documents_panel;
#line 617 "main_window.vala"
				_tmp6_ = gtk_notebook_get_nth_page ((GtkNotebook*) _tmp5_, i);
#line 617 "main_window.vala"
				_tmp7_ = _g_object_ref0 (IS_DOCUMENT_TAB (_tmp6_) ? ((DocumentTab*) _tmp6_) : NULL);
#line 617 "main_window.vala"
				tab = _tmp7_;
#line 618 "main_window.vala"
				_tmp8_ = all_views;
#line 618 "main_window.vala"
				_tmp9_ = tab;
#line 618 "main_window.vala"
				_tmp10_ = document_tab_get_document_view (_tmp9_);
#line 618 "main_window.vala"
				_tmp11_ = _tmp10_;
#line 618 "main_window.vala"
				gee_collection_add ((GeeCollection*) _tmp8_, _tmp11_);
#line 615 "main_window.vala"
				_g_object_unref0 (tab);
#line 2707 "main_window.c"
			}
		}
	}
#line 621 "main_window.vala"
	result = all_views;
#line 621 "main_window.vala"
	return result;
#line 2715 "main_window.c"
}

static Block22Data*
block22_data_ref (Block22Data* _data22_)
{
#line 634 "main_window.vala"
	g_atomic_int_inc (&_data22_->_ref_count_);
#line 634 "main_window.vala"
	return _data22_;
#line 2725 "main_window.c"
}

static void
block22_data_unref (void * _userdata_)
{
	Block22Data* _data22_;
	_data22_ = (Block22Data*) _userdata_;
#line 634 "main_window.vala"
	if (g_atomic_int_dec_and_test (&_data22_->_ref_count_)) {
#line 2735 "main_window.c"
		MainWindow* self;
#line 634 "main_window.vala"
		self = _data22_->self;
#line 634 "main_window.vala"
		_g_object_unref0 (_data22_->infobar);
#line 634 "main_window.vala"
		_g_object_unref0 (_data22_->tab);
#line 634 "main_window.vala"
		_g_object_unref0 (self);
#line 634 "main_window.vala"
		g_slice_free (Block22Data, _data22_);
#line 2747 "main_window.c"
	}
}

static void
______lambda41_ (Block22Data* _data22_,
                 gint response_id)
{
	MainWindow* self;
	TeplInfoBar* _tmp3_;
	DocumentTab* _tmp4_;
	TeplView* _tmp5_;
	TeplView* _tmp6_;
#line 655 "main_window.vala"
	self = _data22_->self;
#line 657 "main_window.vala"
	if (response_id == ((gint) GTK_RESPONSE_YES)) {
#line 2764 "main_window.c"
		DocumentTab* _tmp0_;
		Document* _tmp1_;
		Document* _tmp2_;
#line 658 "main_window.vala"
		_tmp0_ = _data22_->tab;
#line 658 "main_window.vala"
		_tmp1_ = document_tab_get_document (_tmp0_);
#line 658 "main_window.vala"
		_tmp2_ = _tmp1_;
#line 658 "main_window.vala"
		document_set_readonly (_tmp2_, FALSE);
#line 2776 "main_window.c"
	}
#line 659 "main_window.vala"
	_tmp3_ = _data22_->infobar;
#line 659 "main_window.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp3_);
#line 660 "main_window.vala"
	_tmp4_ = _data22_->tab;
#line 660 "main_window.vala"
	_tmp5_ = tepl_tab_get_view ((TeplTab*) _tmp4_);
#line 660 "main_window.vala"
	_tmp6_ = _tmp5_;
#line 660 "main_window.vala"
	gtk_widget_grab_focus ((GtkWidget*) _tmp6_);
#line 2790 "main_window.c"
}

static void
_______lambda41__gtk_info_bar_response (GtkInfoBar* _sender,
                                        gint response_id,
                                        gpointer self)
{
#line 655 "main_window.vala"
	______lambda41_ (self, response_id);
#line 2800 "main_window.c"
}

DocumentTab*
main_window_open_document (MainWindow* self,
                           GFile* location,
                           gboolean jump_to)
{
	GlatexApp* _tmp0_;
	GlatexApp* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	DocumentTab* _tmp40_;
	DocumentTab* result = NULL;
#line 624 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 624 "main_window.vala"
	g_return_val_if_fail (location != NULL, NULL);
#line 627 "main_window.vala"
	_tmp0_ = glatex_app_get_instance ();
#line 627 "main_window.vala"
	_tmp1_ = _tmp0_;
#line 627 "main_window.vala"
	_tmp2_ = gtk_application_get_windows ((GtkApplication*) _tmp1_);
#line 627 "main_window.vala"
	_tmp3_ = _tmp2_;
#line 627 "main_window.vala"
	_g_object_unref0 (_tmp1_);
#line 2828 "main_window.c"
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
#line 627 "main_window.vala"
		window_collection = _tmp3_;
#line 627 "main_window.vala"
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
#line 2836 "main_window.c"
			GtkWindow* _tmp4_;
			GtkWindow* window = NULL;
#line 627 "main_window.vala"
			_tmp4_ = _g_object_ref0 ((GtkWindow*) window_it->data);
#line 627 "main_window.vala"
			window = _tmp4_;
#line 2843 "main_window.c"
			{
				GtkWindow* _tmp5_;
				MainWindow* w = NULL;
				GtkWindow* _tmp6_;
				MainWindow* _tmp7_;
#line 629 "main_window.vala"
				_tmp5_ = window;
#line 629 "main_window.vala"
				if (!IS_MAIN_WINDOW (_tmp5_)) {
#line 630 "main_window.vala"
					_g_object_unref0 (window);
#line 630 "main_window.vala"
					continue;
#line 2857 "main_window.c"
				}
#line 632 "main_window.vala"
				_tmp6_ = window;
#line 632 "main_window.vala"
				_tmp7_ = _g_object_ref0 (IS_MAIN_WINDOW (_tmp6_) ? ((MainWindow*) _tmp6_) : NULL);
#line 632 "main_window.vala"
				w = _tmp7_;
#line 2865 "main_window.c"
				{
					GeeList* _doc_list = NULL;
					MainWindow* _tmp8_;
					GeeList* _tmp9_;
					gint _doc_size = 0;
					GeeList* _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					gint _doc_index = 0;
#line 634 "main_window.vala"
					_tmp8_ = w;
#line 634 "main_window.vala"
					_tmp9_ = main_window_get_documents (_tmp8_);
#line 634 "main_window.vala"
					_doc_list = _tmp9_;
#line 634 "main_window.vala"
					_tmp10_ = _doc_list;
#line 634 "main_window.vala"
					_tmp11_ = gee_collection_get_size ((GeeCollection*) _tmp10_);
#line 634 "main_window.vala"
					_tmp12_ = _tmp11_;
#line 634 "main_window.vala"
					_doc_size = _tmp12_;
#line 634 "main_window.vala"
					_doc_index = -1;
#line 634 "main_window.vala"
					while (TRUE) {
#line 2893 "main_window.c"
						Block22Data* _data22_;
						Document* doc = NULL;
						GeeList* _tmp13_;
						gpointer _tmp14_;
						gboolean _tmp15_ = FALSE;
						Document* _tmp16_;
						GFile* _tmp17_;
						GFile* _tmp18_;
						MainWindow* _tmp22_;
						DocumentTab* _tmp28_;
						DocumentTab* _tmp29_;
						Document* _tmp30_;
						Document* _tmp31_;
						TeplInfoBar* _tmp32_;
						TeplInfoBar* _tmp33_;
						DocumentTab* _tmp34_;
						TeplInfoBar* _tmp35_;
						TeplInfoBar* _tmp36_;
						TeplInfoBar* _tmp37_;
						DocumentTab* _tmp38_;
						DocumentTab* _tmp39_;
#line 634 "main_window.vala"
						_data22_ = g_slice_new0 (Block22Data);
#line 634 "main_window.vala"
						_data22_->_ref_count_ = 1;
#line 634 "main_window.vala"
						_data22_->self = g_object_ref (self);
#line 634 "main_window.vala"
						_doc_index = _doc_index + 1;
#line 634 "main_window.vala"
						if (!(_doc_index < _doc_size)) {
#line 634 "main_window.vala"
							block22_data_unref (_data22_);
#line 634 "main_window.vala"
							_data22_ = NULL;
#line 634 "main_window.vala"
							break;
#line 2931 "main_window.c"
						}
#line 634 "main_window.vala"
						_tmp13_ = _doc_list;
#line 634 "main_window.vala"
						_tmp14_ = gee_list_get (_tmp13_, _doc_index);
#line 634 "main_window.vala"
						doc = (Document*) _tmp14_;
#line 636 "main_window.vala"
						_tmp16_ = doc;
#line 636 "main_window.vala"
						_tmp17_ = document_get_location (_tmp16_);
#line 636 "main_window.vala"
						_tmp18_ = _tmp17_;
#line 636 "main_window.vala"
						if (_tmp18_ == NULL) {
#line 636 "main_window.vala"
							_tmp15_ = TRUE;
#line 2949 "main_window.c"
						} else {
							Document* _tmp19_;
							GFile* _tmp20_;
							GFile* _tmp21_;
#line 636 "main_window.vala"
							_tmp19_ = doc;
#line 636 "main_window.vala"
							_tmp20_ = document_get_location (_tmp19_);
#line 636 "main_window.vala"
							_tmp21_ = _tmp20_;
#line 636 "main_window.vala"
							_tmp15_ = !g_file_equal (location, _tmp21_);
#line 2962 "main_window.c"
						}
#line 636 "main_window.vala"
						if (_tmp15_) {
#line 637 "main_window.vala"
							_g_object_unref0 (doc);
#line 637 "main_window.vala"
							block22_data_unref (_data22_);
#line 637 "main_window.vala"
							_data22_ = NULL;
#line 637 "main_window.vala"
							continue;
#line 2974 "main_window.c"
						}
#line 640 "main_window.vala"
						_tmp22_ = w;
#line 640 "main_window.vala"
						if (self == _tmp22_) {
#line 2980 "main_window.c"
							Document* _tmp25_;
							DocumentTab* _tmp26_;
							DocumentTab* _tmp27_;
#line 642 "main_window.vala"
							if (jump_to) {
#line 2986 "main_window.c"
								Document* _tmp23_;
								DocumentTab* _tmp24_;
#line 643 "main_window.vala"
								_tmp23_ = doc;
#line 643 "main_window.vala"
								_tmp24_ = _tmp23_->tab;
#line 643 "main_window.vala"
								main_window_set_active_tab (self, _tmp24_);
#line 2995 "main_window.c"
							}
#line 644 "main_window.vala"
							_tmp25_ = doc;
#line 644 "main_window.vala"
							_tmp26_ = _tmp25_->tab;
#line 644 "main_window.vala"
							_tmp27_ = _g_object_ref0 (_tmp26_);
#line 644 "main_window.vala"
							result = _tmp27_;
#line 644 "main_window.vala"
							_g_object_unref0 (doc);
#line 644 "main_window.vala"
							block22_data_unref (_data22_);
#line 644 "main_window.vala"
							_data22_ = NULL;
#line 644 "main_window.vala"
							_g_object_unref0 (_doc_list);
#line 644 "main_window.vala"
							_g_object_unref0 (w);
#line 644 "main_window.vala"
							_g_object_unref0 (window);
#line 644 "main_window.vala"
							return result;
#line 3019 "main_window.c"
						}
#line 648 "main_window.vala"
						_tmp28_ = main_window_create_tab_from_location (self, location, jump_to);
#line 648 "main_window.vala"
						_data22_->tab = _tmp28_;
#line 649 "main_window.vala"
						_tmp29_ = _data22_->tab;
#line 649 "main_window.vala"
						_tmp30_ = document_tab_get_document (_tmp29_);
#line 649 "main_window.vala"
						_tmp31_ = _tmp30_;
#line 649 "main_window.vala"
						document_set_readonly (_tmp31_, TRUE);
#line 651 "main_window.vala"
						_tmp32_ = tepl_io_error_info_bar_file_already_open (location);
#line 651 "main_window.vala"
						_tmp33_ = _g_object_ref0 (_tmp32_);
#line 651 "main_window.vala"
						_data22_->infobar = _tmp33_;
#line 652 "main_window.vala"
						_tmp34_ = _data22_->tab;
#line 652 "main_window.vala"
						_tmp35_ = _data22_->infobar;
#line 652 "main_window.vala"
						tepl_tab_add_info_bar ((TeplTab*) _tmp34_, (GtkInfoBar*) _tmp35_);
#line 653 "main_window.vala"
						_tmp36_ = _data22_->infobar;
#line 653 "main_window.vala"
						gtk_widget_show ((GtkWidget*) _tmp36_);
#line 655 "main_window.vala"
						_tmp37_ = _data22_->infobar;
#line 655 "main_window.vala"
						g_signal_connect_data ((GtkInfoBar*) _tmp37_, "response", (GCallback) _______lambda41__gtk_info_bar_response, block22_data_ref (_data22_), (GClosureNotify) block22_data_unref, 0);
#line 663 "main_window.vala"
						_tmp38_ = _data22_->tab;
#line 663 "main_window.vala"
						_tmp39_ = _g_object_ref0 (_tmp38_);
#line 663 "main_window.vala"
						result = _tmp39_;
#line 663 "main_window.vala"
						_g_object_unref0 (doc);
#line 663 "main_window.vala"
						block22_data_unref (_data22_);
#line 663 "main_window.vala"
						_data22_ = NULL;
#line 663 "main_window.vala"
						_g_object_unref0 (_doc_list);
#line 663 "main_window.vala"
						_g_object_unref0 (w);
#line 663 "main_window.vala"
						_g_object_unref0 (window);
#line 663 "main_window.vala"
						return result;
#line 3073 "main_window.c"
					}
#line 634 "main_window.vala"
					_g_object_unref0 (_doc_list);
#line 3077 "main_window.c"
				}
#line 627 "main_window.vala"
				_g_object_unref0 (w);
#line 627 "main_window.vala"
				_g_object_unref0 (window);
#line 3083 "main_window.c"
			}
		}
	}
#line 667 "main_window.vala"
	_tmp40_ = main_window_create_tab_from_location (self, location, jump_to);
#line 667 "main_window.vala"
	result = _tmp40_;
#line 667 "main_window.vala"
	return result;
#line 3093 "main_window.c"
}

DocumentTab*
main_window_create_tab (MainWindow* self,
                        gboolean jump_to)
{
	DocumentTab* tab = NULL;
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* result = NULL;
#line 670 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 672 "main_window.vala"
	_tmp0_ = document_tab_new ();
#line 672 "main_window.vala"
	g_object_ref_sink (_tmp0_);
#line 672 "main_window.vala"
	tab = _tmp0_;
#line 673 "main_window.vala"
	_tmp1_ = main_window_process_create_tab (self, tab, jump_to);
#line 673 "main_window.vala"
	result = _tmp1_;
#line 673 "main_window.vala"
	_g_object_unref0 (tab);
#line 673 "main_window.vala"
	return result;
#line 3120 "main_window.c"
}

static DocumentTab*
main_window_create_tab_from_location (MainWindow* self,
                                      GFile* location,
                                      gboolean jump_to)
{
	DocumentTab* tab = NULL;
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* result = NULL;
#line 676 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 676 "main_window.vala"
	g_return_val_if_fail (location != NULL, NULL);
#line 678 "main_window.vala"
	_tmp0_ = document_tab_new_from_location (location);
#line 678 "main_window.vala"
	g_object_ref_sink (_tmp0_);
#line 678 "main_window.vala"
	tab = _tmp0_;
#line 679 "main_window.vala"
	_tmp1_ = main_window_process_create_tab (self, tab, jump_to);
#line 679 "main_window.vala"
	result = _tmp1_;
#line 679 "main_window.vala"
	_g_object_unref0 (tab);
#line 679 "main_window.vala"
	return result;
#line 3150 "main_window.c"
}

void
main_window_create_tab_with_view (MainWindow* self,
                                  DocumentView* view)
{
	DocumentTab* tab = NULL;
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
#line 682 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 682 "main_window.vala"
	g_return_if_fail (view != NULL);
#line 684 "main_window.vala"
	_tmp0_ = document_tab_new_with_view (view);
#line 684 "main_window.vala"
	g_object_ref_sink (_tmp0_);
#line 684 "main_window.vala"
	tab = _tmp0_;
#line 685 "main_window.vala"
	_tmp1_ = main_window_process_create_tab (self, tab, TRUE);
#line 685 "main_window.vala"
	_tmp2_ = _tmp1_;
#line 685 "main_window.vala"
	_g_object_unref0 (_tmp2_);
#line 682 "main_window.vala"
	_g_object_unref0 (tab);
#line 3179 "main_window.c"
}

static Block23Data*
block23_data_ref (Block23Data* _data23_)
{
#line 688 "main_window.vala"
	g_atomic_int_inc (&_data23_->_ref_count_);
#line 688 "main_window.vala"
	return _data23_;
#line 3189 "main_window.c"
}

static void
block23_data_unref (void * _userdata_)
{
	Block23Data* _data23_;
	_data23_ = (Block23Data*) _userdata_;
#line 688 "main_window.vala"
	if (g_atomic_int_dec_and_test (&_data23_->_ref_count_)) {
#line 3199 "main_window.c"
		MainWindow* self;
#line 688 "main_window.vala"
		self = _data23_->self;
#line 688 "main_window.vala"
		_g_object_unref0 (_data23_->tab);
#line 688 "main_window.vala"
		_g_object_unref0 (self);
#line 688 "main_window.vala"
		g_slice_free (Block23Data, _data23_);
#line 3209 "main_window.c"
	}
}

static void
__lambda15_ (Block23Data* _data23_)
{
	MainWindow* self;
#line 693 "main_window.vala"
	self = _data23_->self;
#line 694 "main_window.vala"
	main_window_close_tab (self, _data23_->tab, FALSE);
#line 695 "main_window.vala"
	g_signal_stop_emission_by_name (_data23_->tab, "close-request");
#line 3223 "main_window.c"
}

static void
___lambda15__tepl_tab_close_request (TeplTab* _sender,
                                     gpointer self)
{
#line 693 "main_window.vala"
	__lambda15_ (self);
#line 3232 "main_window.c"
}

static void
__lambda18_ (Block23Data* _data23_)
{
	MainWindow* self;
	MainWindowBuildTools* _tmp0_;
#line 700 "main_window.vala"
	self = _data23_->self;
#line 702 "main_window.vala"
	main_window_sync_name (self, _data23_->tab);
#line 703 "main_window.vala"
	_tmp0_ = self->priv->_main_window_build_tools;
#line 703 "main_window.vala"
	main_window_build_tools_update_sensitivity (_tmp0_);
#line 3248 "main_window.c"
}

static void
___lambda18__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 700 "main_window.vala"
	__lambda18_ (self);
#line 3258 "main_window.c"
}

static void
__lambda34_ (Block23Data* _data23_)
{
	MainWindow* self;
#line 706 "main_window.vala"
	self = _data23_->self;
#line 708 "main_window.vala"
	main_window_sync_name (self, _data23_->tab);
#line 3269 "main_window.c"
}

static void
___lambda34__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 706 "main_window.vala"
	__lambda34_ (self);
#line 3279 "main_window.c"
}

static void
__lambda35_ (MainWindow* self)
{
	MainWindowBuildTools* _tmp0_;
#line 713 "main_window.vala"
	_tmp0_ = self->priv->_main_window_build_tools;
#line 713 "main_window.vala"
	main_window_build_tools_update_sensitivity (_tmp0_);
#line 3290 "main_window.c"
}

static void
___lambda35__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 711 "main_window.vala"
	__lambda35_ ((MainWindow*) self);
#line 3300 "main_window.c"
}

static void
__lambda36_ (Block23Data* _data23_)
{
	MainWindow* self;
#line 716 "main_window.vala"
	self = _data23_->self;
#line 716 "main_window.vala"
	main_window_sync_name (self, _data23_->tab);
#line 3311 "main_window.c"
}

static void
___lambda36__gtk_text_buffer_modified_changed (GtkTextBuffer* _sender,
                                               gpointer self)
{
#line 716 "main_window.vala"
	__lambda36_ (self);
#line 3320 "main_window.c"
}

static void
__lambda37_ (Block23Data* _data23_)
{
	MainWindow* self;
#line 717 "main_window.vala"
	self = _data23_->self;
#line 717 "main_window.vala"
	main_window_sync_name (self, _data23_->tab);
#line 3331 "main_window.c"
}

static void
___lambda37__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 717 "main_window.vala"
	__lambda37_ (self);
#line 3341 "main_window.c"
}

static DocumentTab*
main_window_process_create_tab (MainWindow* self,
                                DocumentTab* tab,
                                gboolean jump_to)
{
	Block23Data* _data23_;
	DocumentTab* _tmp0_;
	Document* doc = NULL;
	Document* _tmp1_;
	Document* _tmp2_;
	Document* _tmp3_;
	Document* _tmp4_;
	Document* _tmp5_;
	Document* _tmp6_;
	Document* _tmp7_;
	Document* _tmp8_;
	DocumentsPanel* _tmp9_;
	MainWindowEdit* _tmp10_;
	MainWindowTools* _tmp11_;
	DocumentTab* _tmp12_;
	DocumentTab* result = NULL;
#line 688 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 688 "main_window.vala"
	_data23_ = g_slice_new0 (Block23Data);
#line 688 "main_window.vala"
	_data23_->_ref_count_ = 1;
#line 688 "main_window.vala"
	_data23_->self = g_object_ref (self);
#line 688 "main_window.vala"
	_tmp0_ = _g_object_ref0 (tab);
#line 688 "main_window.vala"
	_g_object_unref0 (_data23_->tab);
#line 688 "main_window.vala"
	_data23_->tab = _tmp0_;
#line 690 "main_window.vala"
	if (_data23_->tab == NULL) {
#line 691 "main_window.vala"
		result = NULL;
#line 691 "main_window.vala"
		block23_data_unref (_data23_);
#line 691 "main_window.vala"
		_data23_ = NULL;
#line 691 "main_window.vala"
		return result;
#line 3389 "main_window.c"
	}
#line 693 "main_window.vala"
	g_signal_connect_data ((TeplTab*) _data23_->tab, "close-request", (GCallback) ___lambda15__tepl_tab_close_request, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
#line 698 "main_window.vala"
	_tmp1_ = document_tab_get_document (_data23_->tab);
#line 698 "main_window.vala"
	_tmp2_ = _tmp1_;
#line 698 "main_window.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 698 "main_window.vala"
	doc = _tmp3_;
#line 700 "main_window.vala"
	_tmp4_ = doc;
#line 700 "main_window.vala"
	g_signal_connect_data ((GObject*) _tmp4_, "notify::location", (GCallback) ___lambda18__g_object_notify, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
#line 706 "main_window.vala"
	_tmp5_ = doc;
#line 706 "main_window.vala"
	g_signal_connect_data ((GObject*) _tmp5_, "notify::tepl-short-title", (GCallback) ___lambda34__g_object_notify, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
#line 711 "main_window.vala"
	_tmp6_ = doc;
#line 711 "main_window.vala"
	g_signal_connect_object ((GObject*) _tmp6_, "notify::project-id", (GCallback) ___lambda35__g_object_notify, self, 0);
#line 716 "main_window.vala"
	_tmp7_ = doc;
#line 716 "main_window.vala"
	g_signal_connect_data ((GtkTextBuffer*) _tmp7_, "modified-changed", (GCallback) ___lambda36__gtk_text_buffer_modified_changed, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
#line 717 "main_window.vala"
	_tmp8_ = doc;
#line 717 "main_window.vala"
	g_signal_connect_data ((GObject*) _tmp8_, "notify::readonly", (GCallback) ___lambda37__g_object_notify, block23_data_ref (_data23_), (GClosureNotify) block23_data_unref, 0);
#line 719 "main_window.vala"
	gtk_widget_show ((GtkWidget*) _data23_->tab);
#line 722 "main_window.vala"
	_tmp9_ = self->priv->_documents_panel;
#line 722 "main_window.vala"
	documents_panel_add_tab (_tmp9_, _data23_->tab, -1, jump_to);
#line 724 "main_window.vala"
	_tmp10_ = self->priv->_main_window_edit;
#line 724 "main_window.vala"
	main_window_edit_update_sensitivity (_tmp10_);
#line 725 "main_window.vala"
	_tmp11_ = self->priv->_main_window_tools;
#line 725 "main_window.vala"
	main_window_tools_update_sensitivity (_tmp11_);
#line 727 "main_window.vala"
	if (!gtk_widget_get_visible ((GtkWidget*) self)) {
#line 728 "main_window.vala"
		gtk_window_present ((GtkWindow*) self);
#line 3439 "main_window.c"
	}
#line 730 "main_window.vala"
	_tmp12_ = _g_object_ref0 (_data23_->tab);
#line 730 "main_window.vala"
	result = _tmp12_;
#line 730 "main_window.vala"
	_g_object_unref0 (doc);
#line 730 "main_window.vala"
	block23_data_unref (_data23_);
#line 730 "main_window.vala"
	_data23_ = NULL;
#line 730 "main_window.vala"
	return result;
#line 3453 "main_window.c"
}

gboolean
main_window_close_tab (MainWindow* self,
                       DocumentTab* tab,
                       gboolean force_close)
{
	gboolean _tmp0_ = FALSE;
	DocumentsPanel* _tmp20_;
	gboolean result = FALSE;
#line 734 "main_window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 734 "main_window.vala"
	g_return_val_if_fail (tab != NULL, FALSE);
#line 739 "main_window.vala"
	if (!force_close) {
#line 3470 "main_window.c"
		TeplBuffer* _tmp1_;
#line 739 "main_window.vala"
		_tmp1_ = tepl_tab_get_buffer ((TeplTab*) tab);
#line 739 "main_window.vala"
		_tmp0_ = gtk_text_buffer_get_modified ((GtkTextBuffer*) _tmp1_);
#line 3476 "main_window.c"
	} else {
#line 739 "main_window.vala"
		_tmp0_ = FALSE;
#line 3480 "main_window.c"
	}
#line 739 "main_window.vala"
	if (_tmp0_) {
#line 3484 "main_window.c"
		GtkDialog* dialog = NULL;
		TeplBuffer* _tmp2_;
		TeplFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		GtkMessageDialog* _tmp6_;
		GtkDialog* _tmp7_;
		GtkDialog* _tmp8_;
		Document* _tmp9_;
		Document* _tmp10_;
		GFile* _tmp11_;
		GFile* _tmp12_;
		GtkDialog* _tmp19_;
#line 741 "main_window.vala"
		_tmp2_ = tepl_tab_get_buffer ((TeplTab*) tab);
#line 741 "main_window.vala"
		_tmp3_ = tepl_buffer_get_file (_tmp2_);
#line 741 "main_window.vala"
		_tmp4_ = tepl_file_get_short_name (_tmp3_);
#line 741 "main_window.vala"
		_tmp5_ = _tmp4_;
#line 741 "main_window.vala"
		_tmp6_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) self, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _ ("Save changes to document “%s” before closing?"), _tmp5_);
#line 741 "main_window.vala"
		g_object_ref_sink (_tmp6_);
#line 741 "main_window.vala"
		_tmp7_ = (GtkDialog*) _tmp6_;
#line 741 "main_window.vala"
		_g_free0 (_tmp5_);
#line 741 "main_window.vala"
		dialog = _tmp7_;
#line 748 "main_window.vala"
		_tmp8_ = dialog;
#line 748 "main_window.vala"
		gtk_dialog_add_buttons (_tmp8_, _ ("Close _without Saving"), GTK_RESPONSE_CLOSE, _ ("_Cancel"), GTK_RESPONSE_CANCEL, NULL);
#line 751 "main_window.vala"
		_tmp9_ = document_tab_get_document (tab);
#line 751 "main_window.vala"
		_tmp10_ = _tmp9_;
#line 751 "main_window.vala"
		_tmp11_ = document_get_location (_tmp10_);
#line 751 "main_window.vala"
		_tmp12_ = _tmp11_;
#line 751 "main_window.vala"
		if (_tmp12_ == NULL) {
#line 3530 "main_window.c"
			GtkDialog* _tmp13_;
#line 752 "main_window.vala"
			_tmp13_ = dialog;
#line 752 "main_window.vala"
			gtk_dialog_add_button (_tmp13_, _ ("Save _As"), (gint) GTK_RESPONSE_ACCEPT);
#line 3536 "main_window.c"
		} else {
			GtkDialog* _tmp14_;
#line 754 "main_window.vala"
			_tmp14_ = dialog;
#line 754 "main_window.vala"
			gtk_dialog_add_button (_tmp14_, _ ("_Save"), (gint) GTK_RESPONSE_ACCEPT);
#line 3543 "main_window.c"
		}
#line 756 "main_window.vala"
		while (TRUE) {
#line 3547 "main_window.c"
			gint res = 0;
			GtkDialog* _tmp15_;
#line 758 "main_window.vala"
			_tmp15_ = dialog;
#line 758 "main_window.vala"
			res = gtk_dialog_run (_tmp15_);
#line 760 "main_window.vala"
			if (res == ((gint) GTK_RESPONSE_CLOSE)) {
#line 761 "main_window.vala"
				break;
#line 3558 "main_window.c"
			} else {
#line 764 "main_window.vala"
				if (res == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 3562 "main_window.c"
					Document* _tmp16_;
					Document* _tmp17_;
#line 766 "main_window.vala"
					_tmp16_ = document_tab_get_document (tab);
#line 766 "main_window.vala"
					_tmp17_ = _tmp16_;
#line 766 "main_window.vala"
					if (main_window_save_document (self, _tmp17_, FALSE)) {
#line 767 "main_window.vala"
						break;
#line 3573 "main_window.c"
					}
#line 768 "main_window.vala"
					continue;
#line 3577 "main_window.c"
				} else {
					GtkDialog* _tmp18_;
#line 774 "main_window.vala"
					_tmp18_ = dialog;
#line 774 "main_window.vala"
					gtk_widget_destroy ((GtkWidget*) _tmp18_);
#line 775 "main_window.vala"
					result = FALSE;
#line 775 "main_window.vala"
					_g_object_unref0 (dialog);
#line 775 "main_window.vala"
					return result;
#line 3590 "main_window.c"
				}
			}
		}
#line 779 "main_window.vala"
		_tmp19_ = dialog;
#line 779 "main_window.vala"
		gtk_widget_destroy ((GtkWidget*) _tmp19_);
#line 739 "main_window.vala"
		_g_object_unref0 (dialog);
#line 3600 "main_window.c"
	}
#line 782 "main_window.vala"
	_tmp20_ = self->priv->_documents_panel;
#line 782 "main_window.vala"
	documents_panel_remove_tab (_tmp20_, tab);
#line 783 "main_window.vala"
	result = TRUE;
#line 783 "main_window.vala"
	return result;
#line 3610 "main_window.c"
}

static void
main_window_sync_name (MainWindow* self,
                       DocumentTab* tab)
{
	MainWindowDocuments* _tmp0_;
#line 786 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 786 "main_window.vala"
	g_return_if_fail (tab != NULL);
#line 788 "main_window.vala"
	_tmp0_ = self->priv->_main_window_documents;
#line 788 "main_window.vala"
	main_window_documents_update_document_name (_tmp0_, tab);
#line 3626 "main_window.c"
}

gboolean
main_window_save_document (MainWindow* self,
                           Document* doc,
                           gboolean force_save_as)
{
	gboolean _tmp0_ = FALSE;
	GtkFileChooserDialog* file_chooser = NULL;
	GtkFileChooserDialog* _tmp6_;
	GtkFileChooserDialog* _tmp7_;
	GtkFileChooserDialog* _tmp8_;
	gchar* short_name = NULL;
	TeplFile* _tmp9_;
	gchar* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	const gchar* _tmp19_;
	GFile* _tmp22_;
	GFile* _tmp23_;
	gint response = 0;
	GtkFileChooserDialog* _tmp28_;
	GtkFileChooserDialog* _tmp32_;
	gchar* _tmp33_;
	GtkFileChooserDialog* _tmp34_;
	GFile* _tmp35_;
	GFile* _tmp36_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
#line 792 "main_window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 792 "main_window.vala"
	g_return_val_if_fail (doc != NULL, FALSE);
#line 794 "main_window.vala"
	if (!force_save_as) {
#line 3662 "main_window.c"
		GFile* _tmp1_;
		GFile* _tmp2_;
#line 794 "main_window.vala"
		_tmp1_ = document_get_location (doc);
#line 794 "main_window.vala"
		_tmp2_ = _tmp1_;
#line 794 "main_window.vala"
		_tmp0_ = _tmp2_ != NULL;
#line 3671 "main_window.c"
	} else {
#line 794 "main_window.vala"
		_tmp0_ = FALSE;
#line 3675 "main_window.c"
	}
#line 794 "main_window.vala"
	if (_tmp0_) {
#line 3679 "main_window.c"
		Document* _tmp3_;
		Document* _tmp4_;
#line 796 "main_window.vala"
		document_save (doc, TRUE, FALSE);
#line 798 "main_window.vala"
		_tmp3_ = main_window_get_active_document (self);
#line 798 "main_window.vala"
		_tmp4_ = _tmp3_;
#line 798 "main_window.vala"
		if (doc == _tmp4_) {
#line 3690 "main_window.c"
			MainWindowStructure* _tmp5_;
#line 799 "main_window.vala"
			_tmp5_ = self->priv->_main_window_structure;
#line 799 "main_window.vala"
			main_window_structure_refresh (_tmp5_);
#line 3696 "main_window.c"
		}
#line 801 "main_window.vala"
		result = TRUE;
#line 801 "main_window.vala"
		return result;
#line 3702 "main_window.c"
	}
#line 804 "main_window.vala"
	_tmp6_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Save File"), (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SAVE, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("_Save"), GTK_RESPONSE_ACCEPT, NULL);
#line 804 "main_window.vala"
	g_object_ref_sink (_tmp6_);
#line 804 "main_window.vala"
	file_chooser = _tmp6_;
#line 810 "main_window.vala"
	_tmp7_ = file_chooser;
#line 810 "main_window.vala"
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp7_, TRUE);
#line 811 "main_window.vala"
	_tmp8_ = file_chooser;
#line 811 "main_window.vala"
	gtk_file_chooser_set_local_only ((GtkFileChooser*) _tmp8_, FALSE);
#line 813 "main_window.vala"
	_tmp9_ = tepl_buffer_get_file ((TeplBuffer*) doc);
#line 813 "main_window.vala"
	_tmp10_ = tepl_file_get_short_name (_tmp9_);
#line 813 "main_window.vala"
	short_name = _tmp10_;
#line 814 "main_window.vala"
	_tmp11_ = document_get_location (doc);
#line 814 "main_window.vala"
	_tmp12_ = _tmp11_;
#line 814 "main_window.vala"
	if (_tmp12_ == NULL) {
#line 3730 "main_window.c"
		GtkFileChooserDialog* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
#line 815 "main_window.vala"
		_tmp13_ = file_chooser;
#line 815 "main_window.vala"
		_tmp14_ = short_name;
#line 815 "main_window.vala"
		_tmp15_ = g_strconcat (_tmp14_, ".tex", NULL);
#line 815 "main_window.vala"
		_tmp16_ = _tmp15_;
#line 815 "main_window.vala"
		gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp13_, _tmp16_);
#line 815 "main_window.vala"
		_g_free0 (_tmp16_);
#line 3747 "main_window.c"
	} else {
		GtkFileChooserDialog* _tmp17_;
		const gchar* _tmp18_;
#line 817 "main_window.vala"
		_tmp17_ = file_chooser;
#line 817 "main_window.vala"
		_tmp18_ = short_name;
#line 817 "main_window.vala"
		gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp17_, _tmp18_);
#line 3757 "main_window.c"
	}
#line 819 "main_window.vala"
	_tmp19_ = self->default_location;
#line 819 "main_window.vala"
	if (_tmp19_ != NULL) {
#line 3763 "main_window.c"
		GtkFileChooserDialog* _tmp20_;
		const gchar* _tmp21_;
#line 820 "main_window.vala"
		_tmp20_ = file_chooser;
#line 820 "main_window.vala"
		_tmp21_ = self->default_location;
#line 820 "main_window.vala"
		gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp20_, _tmp21_);
#line 3772 "main_window.c"
	}
#line 822 "main_window.vala"
	_tmp22_ = document_get_location (doc);
#line 822 "main_window.vala"
	_tmp23_ = _tmp22_;
#line 822 "main_window.vala"
	if (_tmp23_ != NULL) {
#line 3780 "main_window.c"
		{
			GtkFileChooserDialog* _tmp24_;
			GFile* _tmp25_;
			GFile* _tmp26_;
#line 827 "main_window.vala"
			_tmp24_ = file_chooser;
#line 827 "main_window.vala"
			_tmp25_ = document_get_location (doc);
#line 827 "main_window.vala"
			_tmp26_ = _tmp25_;
#line 827 "main_window.vala"
			gtk_file_chooser_set_file ((GtkFileChooser*) _tmp24_, _tmp26_, &_inner_error0_);
#line 827 "main_window.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 3795 "main_window.c"
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
#line 824 "main_window.vala"
			g_clear_error (&_inner_error0_);
#line 3804 "main_window.c"
		}
		__finally0:
#line 824 "main_window.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 3809 "main_window.c"
			gboolean _tmp27_ = FALSE;
#line 824 "main_window.vala"
			_g_free0 (short_name);
#line 824 "main_window.vala"
			_g_object_unref0 (file_chooser);
#line 824 "main_window.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 824 "main_window.vala"
			g_clear_error (&_inner_error0_);
#line 824 "main_window.vala"
			return _tmp27_;
#line 3821 "main_window.c"
		}
	}
#line 832 "main_window.vala"
	_tmp28_ = file_chooser;
#line 832 "main_window.vala"
	response = gtk_dialog_run ((GtkDialog*) _tmp28_);
#line 833 "main_window.vala"
	if (response == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 3830 "main_window.c"
		GtkFileChooserDialog* _tmp29_;
		GFile* _tmp30_;
		GFile* _tmp31_;
#line 834 "main_window.vala"
		_tmp29_ = file_chooser;
#line 834 "main_window.vala"
		_tmp30_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp29_);
#line 834 "main_window.vala"
		_tmp31_ = _tmp30_;
#line 834 "main_window.vala"
		document_set_location (doc, _tmp31_);
#line 834 "main_window.vala"
		_g_object_unref0 (_tmp31_);
#line 3844 "main_window.c"
	}
#line 836 "main_window.vala"
	_tmp32_ = file_chooser;
#line 836 "main_window.vala"
	_tmp33_ = gtk_file_chooser_get_current_folder ((GtkFileChooser*) _tmp32_);
#line 836 "main_window.vala"
	_g_free0 (self->default_location);
#line 836 "main_window.vala"
	self->default_location = _tmp33_;
#line 837 "main_window.vala"
	_tmp34_ = file_chooser;
#line 837 "main_window.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp34_);
#line 839 "main_window.vala"
	_tmp35_ = document_get_location (doc);
#line 839 "main_window.vala"
	_tmp36_ = _tmp35_;
#line 839 "main_window.vala"
	if (_tmp36_ != NULL) {
#line 3864 "main_window.c"
		Document* _tmp37_;
		Document* _tmp38_;
#line 842 "main_window.vala"
		document_save (doc, FALSE, TRUE);
#line 844 "main_window.vala"
		_tmp37_ = main_window_get_active_document (self);
#line 844 "main_window.vala"
		_tmp38_ = _tmp37_;
#line 844 "main_window.vala"
		if (doc == _tmp38_) {
#line 3875 "main_window.c"
			MainWindowStructure* _tmp39_;
#line 845 "main_window.vala"
			_tmp39_ = self->priv->_main_window_structure;
#line 845 "main_window.vala"
			main_window_structure_refresh (_tmp39_);
#line 3881 "main_window.c"
		}
#line 847 "main_window.vala"
		result = TRUE;
#line 847 "main_window.vala"
		_g_free0 (short_name);
#line 847 "main_window.vala"
		_g_object_unref0 (file_chooser);
#line 847 "main_window.vala"
		return result;
#line 3891 "main_window.c"
	}
#line 849 "main_window.vala"
	result = FALSE;
#line 849 "main_window.vala"
	_g_free0 (short_name);
#line 849 "main_window.vala"
	_g_object_unref0 (file_chooser);
#line 849 "main_window.vala"
	return result;
#line 3901 "main_window.c"
}

gboolean
main_window_close_all_documents (MainWindow* self)
{
	GeeList* unsaved_documents = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean result = FALSE;
#line 853 "main_window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 855 "main_window.vala"
	_tmp0_ = main_window_get_unsaved_documents (self);
#line 855 "main_window.vala"
	unsaved_documents = _tmp0_;
#line 858 "main_window.vala"
	_tmp1_ = unsaved_documents;
#line 858 "main_window.vala"
	_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
#line 858 "main_window.vala"
	_tmp3_ = _tmp2_;
#line 858 "main_window.vala"
	if (_tmp3_ == 0) {
#line 3927 "main_window.c"
		DocumentsPanel* _tmp4_;
#line 860 "main_window.vala"
		_tmp4_ = self->priv->_documents_panel;
#line 860 "main_window.vala"
		documents_panel_remove_all_tabs (_tmp4_);
#line 861 "main_window.vala"
		result = TRUE;
#line 861 "main_window.vala"
		_g_object_unref0 (unsaved_documents);
#line 861 "main_window.vala"
		return result;
#line 3939 "main_window.c"
	} else {
		GeeList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
#line 865 "main_window.vala"
		_tmp5_ = unsaved_documents;
#line 865 "main_window.vala"
		_tmp6_ = gee_collection_get_size ((GeeCollection*) _tmp5_);
#line 865 "main_window.vala"
		_tmp7_ = _tmp6_;
#line 865 "main_window.vala"
		if (_tmp7_ == 1) {
#line 3952 "main_window.c"
			Document* doc = NULL;
			GeeList* _tmp8_;
			gpointer _tmp9_;
			Document* _tmp10_;
			DocumentTab* _tmp11_;
			Document* _tmp12_;
			DocumentTab* _tmp13_;
#line 867 "main_window.vala"
			_tmp8_ = unsaved_documents;
#line 867 "main_window.vala"
			_tmp9_ = gee_list_first (_tmp8_);
#line 867 "main_window.vala"
			doc = (Document*) _tmp9_;
#line 868 "main_window.vala"
			_tmp10_ = doc;
#line 868 "main_window.vala"
			_tmp11_ = _tmp10_->tab;
#line 868 "main_window.vala"
			main_window_set_active_tab (self, _tmp11_);
#line 869 "main_window.vala"
			_tmp12_ = doc;
#line 869 "main_window.vala"
			_tmp13_ = _tmp12_->tab;
#line 869 "main_window.vala"
			if (main_window_close_tab (self, _tmp13_, FALSE)) {
#line 3978 "main_window.c"
				DocumentsPanel* _tmp14_;
#line 871 "main_window.vala"
				_tmp14_ = self->priv->_documents_panel;
#line 871 "main_window.vala"
				documents_panel_remove_all_tabs (_tmp14_);
#line 872 "main_window.vala"
				result = TRUE;
#line 872 "main_window.vala"
				_g_object_unref0 (doc);
#line 872 "main_window.vala"
				_g_object_unref0 (unsaved_documents);
#line 872 "main_window.vala"
				return result;
#line 3992 "main_window.c"
			}
#line 865 "main_window.vala"
			_g_object_unref0 (doc);
#line 3996 "main_window.c"
		} else {
			GeeList* _tmp15_;
			DocumentsPanel* _tmp16_;
#line 879 "main_window.vala"
			_tmp15_ = unsaved_documents;
#line 879 "main_window.vala"
			dialogs_close_several_unsaved_documents (self, _tmp15_);
#line 880 "main_window.vala"
			_tmp16_ = self->priv->_documents_panel;
#line 880 "main_window.vala"
			if (gtk_notebook_get_n_pages ((GtkNotebook*) _tmp16_) == 0) {
#line 881 "main_window.vala"
				result = TRUE;
#line 881 "main_window.vala"
				_g_object_unref0 (unsaved_documents);
#line 881 "main_window.vala"
				return result;
#line 4014 "main_window.c"
			}
		}
	}
#line 884 "main_window.vala"
	result = FALSE;
#line 884 "main_window.vala"
	_g_object_unref0 (unsaved_documents);
#line 884 "main_window.vala"
	return result;
#line 4024 "main_window.c"
}

void
main_window_remove_all_tabs (MainWindow* self)
{
	DocumentsPanel* _tmp0_;
#line 887 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 889 "main_window.vala"
	_tmp0_ = self->priv->_documents_panel;
#line 889 "main_window.vala"
	documents_panel_remove_all_tabs (_tmp0_);
#line 4037 "main_window.c"
}

void
main_window_save_state (MainWindow* self)
{
	GSettings* settings_window = NULL;
	GSettings* _tmp0_;
	GdkWindowState state = 0U;
	GdkWindow* _tmp1_;
	gint width = 0;
	gint height = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	GtkPaned* _tmp4_;
	GtkPaned* _tmp5_;
	MainWindowStructure* _tmp6_;
	GSettings* settings_ui = NULL;
	GSettings* _tmp7_;
	GtkToggleAction* action = NULL;
	GtkActionGroup* _tmp8_;
	GtkAction* _tmp9_;
	GtkToggleAction* _tmp10_;
	GtkToggleAction* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	GtkActionGroup* _tmp14_;
	GtkAction* _tmp15_;
	GtkToggleAction* _tmp16_;
	GtkToggleAction* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	GtkActionGroup* _tmp20_;
	GtkAction* _tmp21_;
	GtkToggleAction* _tmp22_;
	GtkToggleAction* _tmp23_;
	gboolean _tmp24_;
	gboolean _tmp25_;
	GtkActionGroup* _tmp26_;
	GtkAction* _tmp27_;
	GtkToggleAction* _tmp28_;
	GtkToggleAction* _tmp29_;
	gboolean _tmp30_;
	gboolean _tmp31_;
	MainWindowBuildTools* _tmp32_;
	TeplPanel* _tmp33_;
#line 892 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 895 "main_window.vala"
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.state.window");
#line 895 "main_window.vala"
	settings_window = _tmp0_;
#line 897 "main_window.vala"
	_tmp1_ = gtk_widget_get_window ((GtkWidget*) self);
#line 897 "main_window.vala"
	state = gdk_window_get_state (_tmp1_);
#line 898 "main_window.vala"
	g_settings_set_int (settings_window, "state", (gint) state);
#line 903 "main_window.vala"
	gtk_window_get_size ((GtkWindow*) self, &_tmp2_, &_tmp3_);
#line 903 "main_window.vala"
	width = _tmp2_;
#line 903 "main_window.vala"
	height = _tmp3_;
#line 904 "main_window.vala"
	g_settings_set (settings_window, "size", "(ii)", width, height);
#line 906 "main_window.vala"
	_tmp4_ = self->priv->_main_hpaned;
#line 906 "main_window.vala"
	g_settings_set_int (settings_window, "side-panel-size", gtk_paned_get_position (_tmp4_));
#line 907 "main_window.vala"
	_tmp5_ = self->priv->_vpaned;
#line 907 "main_window.vala"
	g_settings_set_int (settings_window, "vertical-paned-position", gtk_paned_get_position (_tmp5_));
#line 909 "main_window.vala"
	_tmp6_ = self->priv->_main_window_structure;
#line 909 "main_window.vala"
	main_window_structure_save_state (_tmp6_);
#line 912 "main_window.vala"
	_tmp7_ = g_settings_new ("org.gnome.gnome-latex.preferences.ui");
#line 912 "main_window.vala"
	settings_ui = _tmp7_;
#line 918 "main_window.vala"
	_tmp8_ = self->priv->_action_group;
#line 918 "main_window.vala"
	_tmp9_ = gtk_action_group_get_action (_tmp8_, "ViewMainToolbar");
#line 918 "main_window.vala"
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_toggle_action_get_type (), GtkToggleAction));
#line 918 "main_window.vala"
	action = _tmp10_;
#line 919 "main_window.vala"
	_tmp11_ = action;
#line 919 "main_window.vala"
	_tmp12_ = gtk_toggle_action_get_active (_tmp11_);
#line 919 "main_window.vala"
	_tmp13_ = _tmp12_;
#line 919 "main_window.vala"
	g_settings_set_boolean (settings_ui, "main-toolbar-visible", _tmp13_);
#line 921 "main_window.vala"
	_tmp14_ = self->priv->_action_group;
#line 921 "main_window.vala"
	_tmp15_ = gtk_action_group_get_action (_tmp14_, "ViewEditToolbar");
#line 921 "main_window.vala"
	_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_toggle_action_get_type (), GtkToggleAction));
#line 921 "main_window.vala"
	_g_object_unref0 (action);
#line 921 "main_window.vala"
	action = _tmp16_;
#line 922 "main_window.vala"
	_tmp17_ = action;
#line 922 "main_window.vala"
	_tmp18_ = gtk_toggle_action_get_active (_tmp17_);
#line 922 "main_window.vala"
	_tmp19_ = _tmp18_;
#line 922 "main_window.vala"
	g_settings_set_boolean (settings_ui, "edit-toolbar-visible", _tmp19_);
#line 924 "main_window.vala"
	_tmp20_ = self->priv->_action_group;
#line 924 "main_window.vala"
	_tmp21_ = gtk_action_group_get_action (_tmp20_, "ViewSidePanel");
#line 924 "main_window.vala"
	_tmp22_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_toggle_action_get_type (), GtkToggleAction));
#line 924 "main_window.vala"
	_g_object_unref0 (action);
#line 924 "main_window.vala"
	action = _tmp22_;
#line 925 "main_window.vala"
	_tmp23_ = action;
#line 925 "main_window.vala"
	_tmp24_ = gtk_toggle_action_get_active (_tmp23_);
#line 925 "main_window.vala"
	_tmp25_ = _tmp24_;
#line 925 "main_window.vala"
	g_settings_set_boolean (settings_ui, "side-panel-visible", _tmp25_);
#line 927 "main_window.vala"
	_tmp26_ = self->priv->_action_group;
#line 927 "main_window.vala"
	_tmp27_ = gtk_action_group_get_action (_tmp26_, "ViewBottomPanel");
#line 927 "main_window.vala"
	_tmp28_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_toggle_action_get_type (), GtkToggleAction));
#line 927 "main_window.vala"
	_g_object_unref0 (action);
#line 927 "main_window.vala"
	action = _tmp28_;
#line 928 "main_window.vala"
	_tmp29_ = action;
#line 928 "main_window.vala"
	_tmp30_ = gtk_toggle_action_get_active (_tmp29_);
#line 928 "main_window.vala"
	_tmp31_ = _tmp30_;
#line 928 "main_window.vala"
	g_settings_set_boolean (settings_ui, "bottom-panel-visible", _tmp31_);
#line 930 "main_window.vala"
	_tmp32_ = self->priv->_main_window_build_tools;
#line 930 "main_window.vala"
	main_window_build_tools_save_state (_tmp32_);
#line 932 "main_window.vala"
	_tmp33_ = self->priv->_side_panel;
#line 932 "main_window.vala"
	tepl_panel_save_state_to_gsettings (_tmp33_);
#line 892 "main_window.vala"
	_g_object_unref0 (action);
#line 892 "main_window.vala"
	_g_object_unref0 (settings_ui);
#line 892 "main_window.vala"
	_g_object_unref0 (settings_window);
#line 4203 "main_window.c"
}

void
main_window_jump_to_file_position (MainWindow* self,
                                   GFile* file,
                                   gint start_line,
                                   gint end_line)
{
	gboolean _tmp0_ = FALSE;
	DocumentTab* tab = NULL;
	DocumentTab* _tmp1_;
	TeplView* _tmp2_;
	TeplView* _tmp3_;
#line 937 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 937 "main_window.vala"
	g_return_if_fail (file != NULL);
#line 939 "main_window.vala"
	if (start_line >= 0) {
#line 939 "main_window.vala"
		_tmp0_ = end_line >= 0;
#line 4225 "main_window.c"
	} else {
#line 939 "main_window.vala"
		_tmp0_ = FALSE;
#line 4229 "main_window.c"
	}
#line 939 "main_window.vala"
	g_return_if_fail (_tmp0_);
#line 941 "main_window.vala"
	_tmp1_ = main_window_open_document (self, file, TRUE);
#line 941 "main_window.vala"
	tab = _tmp1_;
#line 944 "main_window.vala"
	utils_flush_queue ();
#line 946 "main_window.vala"
	_tmp2_ = tepl_tab_get_view ((TeplTab*) tab);
#line 946 "main_window.vala"
	_tmp3_ = _tmp2_;
#line 946 "main_window.vala"
	tepl_view_select_lines (_tmp3_, start_line, end_line);
#line 937 "main_window.vala"
	_g_object_unref0 (tab);
#line 4247 "main_window.c"
}

/*************************************************************************/
static void
main_window_update_file_actions_sensitivity (MainWindow* self)
{
	TeplApplicationWindow* tepl_window = NULL;
	TeplApplicationWindow* _tmp0_;
	TeplApplicationWindow* _tmp1_;
	gboolean sensitive = FALSE;
	TeplApplicationWindow* _tmp2_;
	TeplTab* _tmp3_;
	TeplTab* _tmp4_;
	gchar** file_actions = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gint file_actions_length1;
	gint _file_actions_size_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	MainWindowFile* _tmp22_;
	MainWindowEdit* _tmp23_;
	MainWindowBuildTools* _tmp24_;
	MainWindowTools* _tmp25_;
#line 952 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 954 "main_window.vala"
	_tmp0_ = tepl_application_window_get_from_gtk_application_window ((GtkApplicationWindow*) self);
#line 954 "main_window.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 954 "main_window.vala"
	tepl_window = _tmp1_;
#line 956 "main_window.vala"
	_tmp2_ = tepl_window;
#line 956 "main_window.vala"
	_tmp3_ = tepl_tab_group_get_active_tab ((TeplTabGroup*) _tmp2_);
#line 956 "main_window.vala"
	_tmp4_ = _tmp3_;
#line 956 "main_window.vala"
	sensitive = _tmp4_ != NULL;
#line 959 "main_window.vala"
	_tmp5_ = g_strdup ("ViewZoomIn");
#line 959 "main_window.vala"
	_tmp6_ = g_strdup ("ViewZoomOut");
#line 959 "main_window.vala"
	_tmp7_ = g_strdup ("ViewZoomReset");
#line 959 "main_window.vala"
	_tmp8_ = g_strdup ("SearchFind");
#line 959 "main_window.vala"
	_tmp9_ = g_strdup ("SearchReplace");
#line 959 "main_window.vala"
	_tmp10_ = g_strdup ("SearchForward");
#line 959 "main_window.vala"
	_tmp11_ = g_strdup ("ProjectsConfigCurrent");
#line 959 "main_window.vala"
	_tmp12_ = g_strdup ("Latex");
#line 959 "main_window.vala"
	_tmp13_ = g_strdup ("Math");
#line 959 "main_window.vala"
	_tmp14_ = g_new0 (gchar*, 9 + 1);
#line 959 "main_window.vala"
	_tmp14_[0] = _tmp5_;
#line 959 "main_window.vala"
	_tmp14_[1] = _tmp6_;
#line 959 "main_window.vala"
	_tmp14_[2] = _tmp7_;
#line 959 "main_window.vala"
	_tmp14_[3] = _tmp8_;
#line 959 "main_window.vala"
	_tmp14_[4] = _tmp9_;
#line 959 "main_window.vala"
	_tmp14_[5] = _tmp10_;
#line 959 "main_window.vala"
	_tmp14_[6] = _tmp11_;
#line 959 "main_window.vala"
	_tmp14_[7] = _tmp12_;
#line 959 "main_window.vala"
	_tmp14_[8] = _tmp13_;
#line 959 "main_window.vala"
	file_actions = _tmp14_;
#line 959 "main_window.vala"
	file_actions_length1 = 9;
#line 959 "main_window.vala"
	_file_actions_size_ = file_actions_length1;
#line 972 "main_window.vala"
	_tmp15_ = file_actions;
#line 972 "main_window.vala"
	_tmp15__length1 = file_actions_length1;
#line 4344 "main_window.c"
	{
		gchar** file_action_collection = NULL;
		gint file_action_collection_length1 = 0;
		gint _file_action_collection_size_ = 0;
		gint file_action_it = 0;
#line 972 "main_window.vala"
		file_action_collection = _tmp15_;
#line 972 "main_window.vala"
		file_action_collection_length1 = _tmp15__length1;
#line 972 "main_window.vala"
		for (file_action_it = 0; file_action_it < file_action_collection_length1; file_action_it = file_action_it + 1) {
#line 4356 "main_window.c"
			gchar* _tmp16_;
			gchar* file_action = NULL;
#line 972 "main_window.vala"
			_tmp16_ = g_strdup (file_action_collection[file_action_it]);
#line 972 "main_window.vala"
			file_action = _tmp16_;
#line 4363 "main_window.c"
			{
				GtkAction* action = NULL;
				GtkActionGroup* _tmp17_;
				const gchar* _tmp18_;
				GtkAction* _tmp19_;
				GtkAction* _tmp20_;
				GtkAction* _tmp21_;
#line 974 "main_window.vala"
				_tmp17_ = self->priv->_action_group;
#line 974 "main_window.vala"
				_tmp18_ = file_action;
#line 974 "main_window.vala"
				_tmp19_ = gtk_action_group_get_action (_tmp17_, _tmp18_);
#line 974 "main_window.vala"
				_tmp20_ = _g_object_ref0 (_tmp19_);
#line 974 "main_window.vala"
				action = _tmp20_;
#line 975 "main_window.vala"
				_tmp21_ = action;
#line 975 "main_window.vala"
				gtk_action_set_sensitive (_tmp21_, sensitive);
#line 972 "main_window.vala"
				_g_object_unref0 (action);
#line 972 "main_window.vala"
				_g_free0 (file_action);
#line 4389 "main_window.c"
			}
		}
	}
#line 978 "main_window.vala"
	_tmp22_ = self->priv->_main_window_file;
#line 978 "main_window.vala"
	main_window_file_update_sensitivity (_tmp22_);
#line 979 "main_window.vala"
	_tmp23_ = self->priv->_main_window_edit;
#line 979 "main_window.vala"
	main_window_edit_update_sensitivity (_tmp23_);
#line 980 "main_window.vala"
	_tmp24_ = self->priv->_main_window_build_tools;
#line 980 "main_window.vala"
	main_window_build_tools_update_sensitivity (_tmp24_);
#line 981 "main_window.vala"
	_tmp25_ = self->priv->_main_window_tools;
#line 981 "main_window.vala"
	main_window_tools_update_sensitivity (_tmp25_);
#line 952 "main_window.vala"
	file_actions = (_vala_array_free (file_actions, file_actions_length1, (GDestroyNotify) g_free), NULL);
#line 952 "main_window.vala"
	_g_object_unref0 (tepl_window);
#line 4413 "main_window.c"
}

void
main_window_update_config_project_sensitivity (MainWindow* self)
{
	GtkAction* action = NULL;
	GtkActionGroup* _tmp0_;
	GtkAction* _tmp1_;
	GtkAction* _tmp2_;
	gboolean _tmp3_ = FALSE;
	DocumentTab* _tmp4_;
	DocumentTab* _tmp5_;
	GtkAction* _tmp10_;
#line 984 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 986 "main_window.vala"
	_tmp0_ = self->priv->_action_group;
#line 986 "main_window.vala"
	_tmp1_ = gtk_action_group_get_action (_tmp0_, "ProjectsConfigCurrent");
#line 986 "main_window.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 986 "main_window.vala"
	action = _tmp2_;
#line 987 "main_window.vala"
	_tmp4_ = main_window_get_active_tab (self);
#line 987 "main_window.vala"
	_tmp5_ = _tmp4_;
#line 987 "main_window.vala"
	if (_tmp5_ != NULL) {
#line 4443 "main_window.c"
		Document* _tmp6_;
		Document* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
#line 987 "main_window.vala"
		_tmp6_ = main_window_get_active_document (self);
#line 987 "main_window.vala"
		_tmp7_ = _tmp6_;
#line 987 "main_window.vala"
		_tmp8_ = document_get_project_id (_tmp7_);
#line 987 "main_window.vala"
		_tmp9_ = _tmp8_;
#line 987 "main_window.vala"
		_tmp3_ = _tmp9_ != -1;
#line 4458 "main_window.c"
	} else {
#line 987 "main_window.vala"
		_tmp3_ = FALSE;
#line 4462 "main_window.c"
	}
#line 987 "main_window.vala"
	_tmp10_ = action;
#line 987 "main_window.vala"
	gtk_action_set_sensitive (_tmp10_, _tmp3_);
#line 984 "main_window.vala"
	_g_object_unref0 (action);
#line 4470 "main_window.c"
}

static void
_vala_array_add6 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
#line 999 "main_window.vala"
	if ((*length) == (*size)) {
#line 999 "main_window.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 999 "main_window.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 4485 "main_window.c"
	}
#line 999 "main_window.vala"
	(*array)[(*length)++] = value;
#line 999 "main_window.vala"
	(*array)[*length] = NULL;
#line 4491 "main_window.c"
}

gboolean
main_window_quit (MainWindow* self)
{
	gchar** list_uris = NULL;
	gchar** _tmp0_;
	gint list_uris_length1;
	gint _list_uris_size_;
	GSettings* settings = NULL;
	GSettings* _tmp14_;
	GSettings* _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gboolean result = FALSE;
#line 992 "main_window.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 995 "main_window.vala"
	_tmp0_ = g_new0 (gchar*, 0 + 1);
#line 995 "main_window.vala"
	list_uris = _tmp0_;
#line 995 "main_window.vala"
	list_uris_length1 = 0;
#line 995 "main_window.vala"
	_list_uris_size_ = list_uris_length1;
#line 4517 "main_window.c"
	{
		GeeList* _doc_list = NULL;
		GeeList* _tmp1_;
		gint _doc_size = 0;
		GeeList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _doc_index = 0;
#line 996 "main_window.vala"
		_tmp1_ = main_window_get_documents (self);
#line 996 "main_window.vala"
		_doc_list = _tmp1_;
#line 996 "main_window.vala"
		_tmp2_ = _doc_list;
#line 996 "main_window.vala"
		_tmp3_ = gee_collection_get_size ((GeeCollection*) _tmp2_);
#line 996 "main_window.vala"
		_tmp4_ = _tmp3_;
#line 996 "main_window.vala"
		_doc_size = _tmp4_;
#line 996 "main_window.vala"
		_doc_index = -1;
#line 996 "main_window.vala"
		while (TRUE) {
#line 4542 "main_window.c"
			Document* doc = NULL;
			GeeList* _tmp5_;
			gpointer _tmp6_;
			Document* _tmp7_;
			GFile* _tmp8_;
			GFile* _tmp9_;
#line 996 "main_window.vala"
			_doc_index = _doc_index + 1;
#line 996 "main_window.vala"
			if (!(_doc_index < _doc_size)) {
#line 996 "main_window.vala"
				break;
#line 4555 "main_window.c"
			}
#line 996 "main_window.vala"
			_tmp5_ = _doc_list;
#line 996 "main_window.vala"
			_tmp6_ = gee_list_get (_tmp5_, _doc_index);
#line 996 "main_window.vala"
			doc = (Document*) _tmp6_;
#line 998 "main_window.vala"
			_tmp7_ = doc;
#line 998 "main_window.vala"
			_tmp8_ = document_get_location (_tmp7_);
#line 998 "main_window.vala"
			_tmp9_ = _tmp8_;
#line 998 "main_window.vala"
			if (_tmp9_ != NULL) {
#line 4571 "main_window.c"
				Document* _tmp10_;
				GFile* _tmp11_;
				GFile* _tmp12_;
				gchar* _tmp13_;
#line 999 "main_window.vala"
				_tmp10_ = doc;
#line 999 "main_window.vala"
				_tmp11_ = document_get_location (_tmp10_);
#line 999 "main_window.vala"
				_tmp12_ = _tmp11_;
#line 999 "main_window.vala"
				_tmp13_ = g_file_get_uri (_tmp12_);
#line 999 "main_window.vala"
				_vala_array_add6 (&list_uris, &list_uris_length1, &_list_uris_size_, _tmp13_);
#line 4586 "main_window.c"
			}
#line 996 "main_window.vala"
			_g_object_unref0 (doc);
#line 4590 "main_window.c"
		}
#line 996 "main_window.vala"
		_g_object_unref0 (_doc_list);
#line 4594 "main_window.c"
	}
#line 1002 "main_window.vala"
	_tmp14_ = g_settings_new ("org.gnome.gnome-latex.state.window");
#line 1002 "main_window.vala"
	settings = _tmp14_;
#line 1003 "main_window.vala"
	_tmp15_ = settings;
#line 1003 "main_window.vala"
	_tmp16_ = list_uris;
#line 1003 "main_window.vala"
	_tmp16__length1 = list_uris_length1;
#line 1003 "main_window.vala"
	g_settings_set_strv (_tmp15_, "documents", _tmp16_);
#line 1005 "main_window.vala"
	if (main_window_close_all_documents (self)) {
#line 1007 "main_window.vala"
		main_window_save_state (self);
#line 1008 "main_window.vala"
		gtk_widget_destroy ((GtkWidget*) self);
#line 1009 "main_window.vala"
		result = TRUE;
#line 1009 "main_window.vala"
		_g_object_unref0 (settings);
#line 1009 "main_window.vala"
		list_uris = (_vala_array_free (list_uris, list_uris_length1, (GDestroyNotify) g_free), NULL);
#line 1009 "main_window.vala"
		return result;
#line 4622 "main_window.c"
	}
#line 1012 "main_window.vala"
	result = FALSE;
#line 1012 "main_window.vala"
	_g_object_unref0 (settings);
#line 1012 "main_window.vala"
	list_uris = (_vala_array_free (list_uris, list_uris_length1, (GDestroyNotify) g_free), NULL);
#line 1012 "main_window.vala"
	return result;
#line 4632 "main_window.c"
}

/*************************************************************************/
void
main_window_on_view_zoom_in (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentView* _tmp2_;
	DocumentView* _tmp3_;
#line 1020 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 1022 "main_window.vala"
	_tmp0_ = main_window_get_active_tab (self);
#line 1022 "main_window.vala"
	_tmp1_ = _tmp0_;
#line 1022 "main_window.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 1023 "main_window.vala"
	_tmp2_ = main_window_get_active_view (self);
#line 1023 "main_window.vala"
	_tmp3_ = _tmp2_;
#line 1023 "main_window.vala"
	document_view_enlarge_font (_tmp3_);
#line 4657 "main_window.c"
}

void
main_window_on_view_zoom_out (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentView* _tmp2_;
	DocumentView* _tmp3_;
#line 1026 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 1028 "main_window.vala"
	_tmp0_ = main_window_get_active_tab (self);
#line 1028 "main_window.vala"
	_tmp1_ = _tmp0_;
#line 1028 "main_window.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 1029 "main_window.vala"
	_tmp2_ = main_window_get_active_view (self);
#line 1029 "main_window.vala"
	_tmp3_ = _tmp2_;
#line 1029 "main_window.vala"
	document_view_shrink_font (_tmp3_);
#line 4681 "main_window.c"
}

void
main_window_on_view_zoom_reset (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentView* _tmp2_;
	DocumentView* _tmp3_;
#line 1032 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 1034 "main_window.vala"
	_tmp0_ = main_window_get_active_tab (self);
#line 1034 "main_window.vala"
	_tmp1_ = _tmp0_;
#line 1034 "main_window.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 1035 "main_window.vala"
	_tmp2_ = main_window_get_active_view (self);
#line 1035 "main_window.vala"
	_tmp3_ = _tmp2_;
#line 1035 "main_window.vala"
	document_view_set_font_from_settings (_tmp3_);
#line 4705 "main_window.c"
}

void
main_window_on_search_find (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	SearchAndReplace* _tmp2_;
#line 1040 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 1042 "main_window.vala"
	_tmp0_ = main_window_get_active_tab (self);
#line 1042 "main_window.vala"
	_tmp1_ = _tmp0_;
#line 1042 "main_window.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 1043 "main_window.vala"
	_tmp2_ = self->priv->_search_and_replace;
#line 1043 "main_window.vala"
	search_and_replace_show_search (_tmp2_);
#line 4726 "main_window.c"
}

void
main_window_on_search_replace (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	SearchAndReplace* _tmp2_;
#line 1046 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 1048 "main_window.vala"
	_tmp0_ = main_window_get_active_tab (self);
#line 1048 "main_window.vala"
	_tmp1_ = _tmp0_;
#line 1048 "main_window.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 1049 "main_window.vala"
	_tmp2_ = self->priv->_search_and_replace;
#line 1049 "main_window.vala"
	search_and_replace_show_search_and_replace (_tmp2_);
#line 4747 "main_window.c"
}

void
main_window_on_search_forward (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	LatexilaSynctex* synctex = NULL;
	LatexilaSynctex* _tmp2_;
	LatexilaSynctex* _tmp3_;
	Document* _tmp4_;
	Document* _tmp5_;
	Document* _tmp6_;
	Document* _tmp7_;
	GFile* _tmp8_;
	GFile* _tmp9_;
	Document* _tmp10_;
	Document* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
#line 1052 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 1054 "main_window.vala"
	_tmp0_ = main_window_get_active_tab (self);
#line 1054 "main_window.vala"
	_tmp1_ = _tmp0_;
#line 1054 "main_window.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 1056 "main_window.vala"
	_tmp2_ = latexila_synctex_get_instance ();
#line 1056 "main_window.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 1056 "main_window.vala"
	synctex = _tmp3_;
#line 1057 "main_window.vala"
	_tmp4_ = main_window_get_active_document (self);
#line 1057 "main_window.vala"
	_tmp5_ = _tmp4_;
#line 1057 "main_window.vala"
	_tmp6_ = main_window_get_active_document (self);
#line 1057 "main_window.vala"
	_tmp7_ = _tmp6_;
#line 1057 "main_window.vala"
	_tmp8_ = document_get_location (_tmp7_);
#line 1057 "main_window.vala"
	_tmp9_ = _tmp8_;
#line 1057 "main_window.vala"
	_tmp10_ = main_window_get_active_document (self);
#line 1057 "main_window.vala"
	_tmp11_ = _tmp10_;
#line 1057 "main_window.vala"
	_tmp12_ = document_get_main_file (_tmp11_);
#line 1057 "main_window.vala"
	_tmp13_ = _tmp12_;
#line 1057 "main_window.vala"
	latexila_synctex_forward_search (synctex, (GtkTextBuffer*) _tmp5_, _tmp9_, _tmp13_, (guint) GDK_CURRENT_TIME);
#line 1057 "main_window.vala"
	_g_object_unref0 (_tmp13_);
#line 1052 "main_window.vala"
	_g_object_unref0 (synctex);
#line 4808 "main_window.c"
}

void
main_window_on_projects_new (MainWindow* self)
{
#line 1063 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 1065 "main_window.vala"
	project_dialogs_new_project (self);
#line 4818 "main_window.c"
}

void
main_window_on_projects_config_current (MainWindow* self)
{
	DocumentTab* _tmp0_;
	DocumentTab* _tmp1_;
	Document* _tmp2_;
	Document* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	Document* _tmp6_;
	Document* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
#line 1068 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 1070 "main_window.vala"
	_tmp0_ = main_window_get_active_tab (self);
#line 1070 "main_window.vala"
	_tmp1_ = _tmp0_;
#line 1070 "main_window.vala"
	g_return_if_fail (_tmp1_ != NULL);
#line 1071 "main_window.vala"
	_tmp2_ = main_window_get_active_document (self);
#line 1071 "main_window.vala"
	_tmp3_ = _tmp2_;
#line 1071 "main_window.vala"
	_tmp4_ = document_get_project_id (_tmp3_);
#line 1071 "main_window.vala"
	_tmp5_ = _tmp4_;
#line 1071 "main_window.vala"
	g_return_if_fail (_tmp5_ != -1);
#line 1072 "main_window.vala"
	_tmp6_ = main_window_get_active_document (self);
#line 1072 "main_window.vala"
	_tmp7_ = _tmp6_;
#line 1072 "main_window.vala"
	_tmp8_ = document_get_project_id (_tmp7_);
#line 1072 "main_window.vala"
	_tmp9_ = _tmp8_;
#line 1072 "main_window.vala"
	project_dialogs_configure_project ((GtkWindow*) self, _tmp9_);
#line 4862 "main_window.c"
}

void
main_window_on_projects_manage (MainWindow* self)
{
#line 1075 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 1077 "main_window.vala"
	project_dialogs_manage_projects (self);
#line 4872 "main_window.c"
}

void
main_window_on_help_latex_reference (MainWindow* self)
{
	GError* _inner_error0_ = NULL;
#line 1082 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 4881 "main_window.c"
	{
		gchar* uri = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
#line 1086 "main_window.vala"
		_tmp0_ = g_build_filename (DATA_DIR, "latexhelp.html", NULL, NULL);
#line 1086 "main_window.vala"
		_tmp1_ = _tmp0_;
#line 1086 "main_window.vala"
		_tmp2_ = g_filename_to_uri (_tmp1_, NULL, &_inner_error0_);
#line 1086 "main_window.vala"
		_tmp3_ = _tmp2_;
#line 1086 "main_window.vala"
		_g_free0 (_tmp1_);
#line 1086 "main_window.vala"
		uri = _tmp3_;
#line 1086 "main_window.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4903 "main_window.c"
			goto __catch0_g_error;
		}
#line 1088 "main_window.vala"
		_tmp4_ = uri;
#line 1088 "main_window.vala"
		latexila_utils_show_uri ((GtkWidget*) self, _tmp4_, (guint32) GDK_CURRENT_TIME, &_inner_error0_);
#line 1088 "main_window.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1088 "main_window.vala"
			_g_free0 (uri);
#line 4914 "main_window.c"
			goto __catch0_g_error;
		}
#line 1084 "main_window.vala"
		_g_free0 (uri);
#line 4919 "main_window.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
#line 1084 "main_window.vala"
		e = _inner_error0_;
#line 1084 "main_window.vala"
		_inner_error0_ = NULL;
#line 1092 "main_window.vala"
		_tmp5_ = e;
#line 1092 "main_window.vala"
		_tmp6_ = _tmp5_->message;
#line 1092 "main_window.vala"
		g_warning ("main_window.vala:1092: Impossible to open the LaTeX reference: %s", _tmp6_);
#line 1084 "main_window.vala"
		_g_error_free0 (e);
#line 4939 "main_window.c"
	}
	__finally0:
#line 1084 "main_window.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1084 "main_window.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1084 "main_window.vala"
		g_clear_error (&_inner_error0_);
#line 1084 "main_window.vala"
		return;
#line 4950 "main_window.c"
	}
}

DocumentTab*
main_window_get_active_tab (MainWindow* self)
{
	DocumentTab* result;
	TeplApplicationWindow* tepl_window = NULL;
	TeplApplicationWindow* _tmp0_;
	TeplApplicationWindow* _tmp1_;
	TeplTab* _tmp2_;
#line 113 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 115 "main_window.vala"
	_tmp0_ = tepl_application_window_get_from_gtk_application_window ((GtkApplicationWindow*) self);
#line 115 "main_window.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 115 "main_window.vala"
	tepl_window = _tmp1_;
#line 117 "main_window.vala"
	_tmp2_ = tepl_tab_group_get_active_tab ((TeplTabGroup*) tepl_window);
#line 117 "main_window.vala"
	result = IS_DOCUMENT_TAB (_tmp2_) ? ((DocumentTab*) _tmp2_) : NULL;
#line 117 "main_window.vala"
	_g_object_unref0 (tepl_window);
#line 117 "main_window.vala"
	return result;
#line 4978 "main_window.c"
}

void
main_window_set_active_tab (MainWindow* self,
                            DocumentTab* value)
{
	TeplApplicationWindow* tepl_window = NULL;
	TeplApplicationWindow* _tmp0_;
	TeplApplicationWindow* _tmp1_;
#line 120 "main_window.vala"
	g_return_if_fail (self != NULL);
#line 122 "main_window.vala"
	_tmp0_ = tepl_application_window_get_from_gtk_application_window ((GtkApplicationWindow*) self);
#line 122 "main_window.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 122 "main_window.vala"
	tepl_window = _tmp1_;
#line 124 "main_window.vala"
	tepl_tab_group_set_active_tab ((TeplTabGroup*) tepl_window, (TeplTab*) value);
#line 120 "main_window.vala"
	_g_object_unref0 (tepl_window);
#line 120 "main_window.vala"
	g_object_notify_by_pspec ((GObject *) self, main_window_properties[MAIN_WINDOW_ACTIVE_TAB_PROPERTY]);
#line 5002 "main_window.c"
}

DocumentView*
main_window_get_active_view (MainWindow* self)
{
	DocumentView* result;
	TeplApplicationWindow* tepl_window = NULL;
	TeplApplicationWindow* _tmp0_;
	TeplApplicationWindow* _tmp1_;
	TeplView* _tmp2_;
#line 130 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 132 "main_window.vala"
	_tmp0_ = tepl_application_window_get_from_gtk_application_window ((GtkApplicationWindow*) self);
#line 132 "main_window.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 132 "main_window.vala"
	tepl_window = _tmp1_;
#line 134 "main_window.vala"
	_tmp2_ = tepl_tab_group_get_active_view ((TeplTabGroup*) tepl_window);
#line 134 "main_window.vala"
	result = IS_DOCUMENT_VIEW (_tmp2_) ? ((DocumentView*) _tmp2_) : NULL;
#line 134 "main_window.vala"
	_g_object_unref0 (tepl_window);
#line 134 "main_window.vala"
	return result;
#line 5029 "main_window.c"
}

Document*
main_window_get_active_document (MainWindow* self)
{
	Document* result;
	TeplApplicationWindow* tepl_window = NULL;
	TeplApplicationWindow* _tmp0_;
	TeplApplicationWindow* _tmp1_;
	TeplBuffer* _tmp2_;
#line 140 "main_window.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 142 "main_window.vala"
	_tmp0_ = tepl_application_window_get_from_gtk_application_window ((GtkApplicationWindow*) self);
#line 142 "main_window.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 142 "main_window.vala"
	tepl_window = _tmp1_;
#line 144 "main_window.vala"
	_tmp2_ = tepl_tab_group_get_active_buffer ((TeplTabGroup*) tepl_window);
#line 144 "main_window.vala"
	result = IS_DOCUMENT (_tmp2_) ? ((Document*) _tmp2_) : NULL;
#line 144 "main_window.vala"
	_g_object_unref0 (tepl_window);
#line 144 "main_window.vala"
	return result;
#line 5056 "main_window.c"
}

static void
main_window_class_init (MainWindowClass * klass,
                        gpointer klass_data)
{
#line 22 "main_window.vala"
	main_window_parent_class = g_type_class_peek_parent (klass);
#line 22 "main_window.vala"
	g_type_class_adjust_private_offset (klass, &MainWindow_private_offset);
#line 22 "main_window.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_main_window_get_property;
#line 22 "main_window.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_main_window_set_property;
#line 22 "main_window.vala"
	G_OBJECT_CLASS (klass)->finalize = main_window_finalize;
#line 5073 "main_window.c"
	/*************************************************************************/
#line 22 "main_window.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_WINDOW_ACTIVE_TAB_PROPERTY, main_window_properties[MAIN_WINDOW_ACTIVE_TAB_PROPERTY] = g_param_spec_object ("active-tab", "active-tab", "active-tab", TYPE_DOCUMENT_TAB, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "main_window.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_WINDOW_ACTIVE_VIEW_PROPERTY, main_window_properties[MAIN_WINDOW_ACTIVE_VIEW_PROPERTY] = g_param_spec_object ("active-view", "active-view", "active-view", TYPE_DOCUMENT_VIEW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 22 "main_window.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_WINDOW_ACTIVE_DOCUMENT_PROPERTY, main_window_properties[MAIN_WINDOW_ACTIVE_DOCUMENT_PROPERTY] = g_param_spec_object ("active-document", "active-document", "active-document", TYPE_DOCUMENT, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 5081 "main_window.c"
}

static void
main_window_instance_init (MainWindow * self,
                           gpointer klass)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 22 "main_window.vala"
	self->priv = main_window_get_instance_private (self);
#line 87 "main_window.vala"
	_tmp0_ = g_get_home_dir ();
#line 87 "main_window.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 87 "main_window.vala"
	self->default_location = _tmp1_;
#line 5098 "main_window.c"
}

static void
main_window_finalize (GObject * obj)
{
	MainWindow * self;
#line 22 "main_window.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN_WINDOW, MainWindow);
#line 87 "main_window.vala"
	_g_free0 (self->default_location);
#line 88 "main_window.vala"
	_g_object_unref0 (self->priv->_documents_panel);
#line 89 "main_window.vala"
	_g_object_unref0 (self->priv->_statusbar);
#line 90 "main_window.vala"
	_g_object_unref0 (self->priv->_search_and_replace);
#line 91 "main_window.vala"
	_g_object_unref0 (self->priv->_side_panel);
#line 92 "main_window.vala"
	_g_object_unref0 (self->priv->_main_hpaned);
#line 93 "main_window.vala"
	_g_object_unref0 (self->priv->_vpaned);
#line 95 "main_window.vala"
	_g_object_unref0 (self->priv->_ui_manager);
#line 96 "main_window.vala"
	_g_object_unref0 (self->priv->_action_group);
#line 98 "main_window.vala"
	_main_window_file_unref0 (self->priv->_main_window_file);
#line 99 "main_window.vala"
	_main_window_edit_unref0 (self->priv->_main_window_edit);
#line 100 "main_window.vala"
	_main_window_build_tools_unref0 (self->priv->_main_window_build_tools);
#line 101 "main_window.vala"
	_main_window_structure_unref0 (self->priv->_main_window_structure);
#line 102 "main_window.vala"
	_main_window_documents_unref0 (self->priv->_main_window_documents);
#line 103 "main_window.vala"
	_main_window_tools_unref0 (self->priv->_main_window_tools);
#line 22 "main_window.vala"
	G_OBJECT_CLASS (main_window_parent_class)->finalize (obj);
#line 5139 "main_window.c"
}

static GType
main_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MainWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MainWindow), 0, (GInstanceInitFunc) main_window_instance_init, NULL };
	GType main_window_type_id;
	main_window_type_id = g_type_register_static (gtk_application_window_get_type (), "MainWindow", &g_define_type_info, 0);
	MainWindow_private_offset = g_type_add_instance_private (main_window_type_id, sizeof (MainWindowPrivate));
	return main_window_type_id;
}

GType
main_window_get_type (void)
{
	static volatile gsize main_window_type_id__volatile = 0;
	if (g_once_init_enter (&main_window_type_id__volatile)) {
		GType main_window_type_id;
		main_window_type_id = main_window_get_type_once ();
		g_once_init_leave (&main_window_type_id__volatile, main_window_type_id);
	}
	return main_window_type_id__volatile;
}

static void
_vala_main_window_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	MainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MAIN_WINDOW, MainWindow);
#line 22 "main_window.vala"
	switch (property_id) {
#line 22 "main_window.vala"
		case MAIN_WINDOW_ACTIVE_TAB_PROPERTY:
#line 22 "main_window.vala"
		g_value_set_object (value, main_window_get_active_tab (self));
#line 22 "main_window.vala"
		break;
#line 22 "main_window.vala"
		case MAIN_WINDOW_ACTIVE_VIEW_PROPERTY:
#line 22 "main_window.vala"
		g_value_set_object (value, main_window_get_active_view (self));
#line 22 "main_window.vala"
		break;
#line 22 "main_window.vala"
		case MAIN_WINDOW_ACTIVE_DOCUMENT_PROPERTY:
#line 22 "main_window.vala"
		g_value_set_object (value, main_window_get_active_document (self));
#line 22 "main_window.vala"
		break;
#line 5192 "main_window.c"
		default:
#line 22 "main_window.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "main_window.vala"
		break;
#line 5198 "main_window.c"
	}
}

static void
_vala_main_window_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	MainWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MAIN_WINDOW, MainWindow);
#line 22 "main_window.vala"
	switch (property_id) {
#line 22 "main_window.vala"
		case MAIN_WINDOW_ACTIVE_TAB_PROPERTY:
#line 22 "main_window.vala"
		main_window_set_active_tab (self, g_value_get_object (value));
#line 22 "main_window.vala"
		break;
#line 5218 "main_window.c"
		default:
#line 22 "main_window.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "main_window.vala"
		break;
#line 5224 "main_window.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
#line 27 "build_tools_preferences.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 5235 "main_window.c"
		gint i;
#line 27 "build_tools_preferences.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 27 "build_tools_preferences.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 27 "build_tools_preferences.vala"
				destroy_func (((gpointer*) array)[i]);
#line 5243 "main_window.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
#line 27 "build_tools_preferences.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 27 "build_tools_preferences.vala"
	g_free (array);
#line 5258 "main_window.c"
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
#line 27 "build_tools_preferences.vala"
	if (array) {
#line 27 "build_tools_preferences.vala"
		while (((gpointer*) array)[length]) {
#line 27 "build_tools_preferences.vala"
			length++;
#line 5272 "main_window.c"
		}
	}
#line 27 "build_tools_preferences.vala"
	return length;
#line 5277 "main_window.c"
}

