/* file_browser.c generated by valac 0.48.9, the Vala compiler
 * generated from file_browser.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2012, 2017 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <tepl/tepl.h>
#include <latexila.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <gee.h>

#define TYPE_FILE_BROWSER (file_browser_get_type ())
#define FILE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_BROWSER, FileBrowser))
#define FILE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_BROWSER, FileBrowserClass))
#define IS_FILE_BROWSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_BROWSER))
#define IS_FILE_BROWSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_BROWSER))
#define FILE_BROWSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_BROWSER, FileBrowserClass))

typedef struct _FileBrowser FileBrowser;
typedef struct _FileBrowserClass FileBrowserClass;
typedef struct _FileBrowserPrivate FileBrowserPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
enum  {
	FILE_BROWSER_0_PROPERTY,
	FILE_BROWSER_NUM_PROPERTIES
};
static GParamSpec* file_browser_properties[FILE_BROWSER_NUM_PROPERTIES];
typedef enum  {
	FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF,
	FILE_BROWSER_PARENT_DIR_COLUMN_NAME,
	FILE_BROWSER_PARENT_DIR_COLUMN_FILE,
	FILE_BROWSER_PARENT_DIR_COLUMN_N_COLUMNS
} FileBrowserParentDirColumn;

#define FILE_BROWSER_TYPE_PARENT_DIR_COLUMN (file_browser_parent_dir_column_get_type ())
typedef enum  {
	FILE_BROWSER_FILE_COLUMN_PIXBUF,
	FILE_BROWSER_FILE_COLUMN_NAME,
	FILE_BROWSER_FILE_COLUMN_IS_DIR,
	FILE_BROWSER_FILE_COLUMN_N_COLUMNS
} FileBrowserFileColumn;

#define FILE_BROWSER_TYPE_FILE_COLUMN (file_browser_file_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _Block19Data Block19Data;
typedef struct _Block20Data Block20Data;

struct _FileBrowser {
	GtkGrid parent_instance;
	FileBrowserPrivate * priv;
};

struct _FileBrowserClass {
	GtkGridClass parent_class;
};

struct _FileBrowserPrivate {
	MainWindow* _main_window;
	GtkListStore* _parent_dir_store;
	GtkComboBox* _combo_box;
	GtkListStore* _list_store;
	GtkTreeView* _list_view;
	GFile* _current_directory;
	GFileMonitor* _monitor;
	GtkToolButton* _parent_button;
	GSettings* _settings;
	GSettings* _latex_settings;
	guint _timeout_id;
};

struct _Block19Data {
	int _ref_count_;
	FileBrowser* self;
	GtkMenu* menu;
	GtkToolButton* button;
};

struct _Block20Data {
	int _ref_count_;
	FileBrowser* self;
	GtkMenu* menu;
	GtkToolButton* button;
};

static gint FileBrowser_private_offset;
static gpointer file_browser_parent_class = NULL;

GType file_browser_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FileBrowser, g_object_unref)
GType main_window_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
static GType file_browser_parent_dir_column_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType file_browser_file_column_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
FileBrowser* file_browser_new (MainWindow* main_window);
FileBrowser* file_browser_construct (GType object_type,
                                     MainWindow* main_window);
static void file_browser_init_settings (FileBrowser* self);
static void file_browser_init_combo_box (FileBrowser* self);
static void file_browser_init_toolbar (FileBrowser* self);
static void file_browser_init_list (FileBrowser* self);
static void file_browser_set_directory (FileBrowser* self,
                                 GFile* directory,
                                 gboolean force);
static GFile* file_browser_get_default_directory (FileBrowser* self);
static void file_browser_refresh (FileBrowser* self);
static void _file_browser_refresh_g_settings_changed (GSettings* _sender,
                                               const gchar* key,
                                               gpointer self);
static void file_browser_delayed_refresh (FileBrowser* self);
static void _file_browser_delayed_refresh_g_settings_changed (GSettings* _sender,
                                                       const gchar* key,
                                                       gpointer self);
static void __lambda69_ (FileBrowser* self);
static void ___lambda69__gtk_combo_box_changed (GtkComboBox* _sender,
                                         gpointer self);
static gint file_browser_on_sort (FileBrowser* self,
                           GtkTreeModel* model,
                           GtkTreeIter* a,
                           GtkTreeIter* b);
static gint _file_browser_on_sort_gtk_tree_iter_compare_func (GtkTreeModel* model,
                                                       GtkTreeIter* a,
                                                       GtkTreeIter* b,
                                                       gpointer self);
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
static void __lambda77_ (FileBrowser* self,
                  GtkTreePath* path);
GType document_tab_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
DocumentTab* main_window_open_document (MainWindow* self,
                                        GFile* location,
                                        gboolean jump_to);
static void ___lambda77__gtk_tree_view_row_activated (GtkTreeView* _sender,
                                               GtkTreePath* path,
                                               GtkTreeViewColumn* column,
                                               gpointer self);
static GtkToolButton* file_browser_get_home_button (FileBrowser* self);
static GtkToolButton* file_browser_get_parent_button (FileBrowser* self);
static GtkToolButton* file_browser_get_jump_button (FileBrowser* self);
static GtkToolButton* file_browser_get_open_directory_button (FileBrowser* self);
static GtkToolButton* file_browser_get_properties_button (FileBrowser* self);
static void __lambda70_ (FileBrowser* self);
static void ___lambda70__gtk_tool_button_clicked (GtkToolButton* _sender,
                                           gpointer self);
static void __lambda71_ (FileBrowser* self);
static void ___lambda71__gtk_tool_button_clicked (GtkToolButton* _sender,
                                           gpointer self);
static void __lambda72_ (FileBrowser* self);
GType document_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
Document* main_window_get_active_document (MainWindow* self);
GFile* document_get_location (Document* self);
static void ___lambda72__gtk_tool_button_clicked (GtkToolButton* _sender,
                                           gpointer self);
static Block19Data* block19_data_ref (Block19Data* _data19_);
static void block19_data_unref (void * _userdata_);
static GtkMenuItem* file_browser_get_open_directory_menu (FileBrowser* self);
static GtkMenuItem* file_browser_get_open_terminal_menu (FileBrowser* self);
static void __lambda75_ (Block19Data* _data19_);
static void ___lambda75__gtk_tool_button_clicked (GtkToolButton* _sender,
                                           gpointer self);
static void __lambda73_ (FileBrowser* self);
static void file_browser_handle_error (FileBrowser* self,
                                GError* _error_);
static void ___lambda73__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static void __lambda74_ (FileBrowser* self);
static void ___lambda74__gtk_menu_item_activate (GtkMenuItem* _sender,
                                          gpointer self);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
static void __lambda76_ (Block20Data* _data20_);
static void ___lambda76__gtk_tool_button_clicked (GtkToolButton* _sender,
                                           gpointer self);
static void file_browser_update_parent_directories (FileBrowser* self);
static void file_browser_update_list (FileBrowser* self);
static void file_browser_insert_file (FileBrowser* self,
                               gboolean is_dir,
                               const gchar* icon_name,
                               const gchar* basename);
static gchar* file_browser_get_extension_icon_name (FileBrowser* self,
                                             const gchar* file_extension);
static void file_browser_monitor_directory (FileBrowser* self);
static void _file_browser_refresh_g_file_monitor_changed (GFileMonitor* _sender,
                                                   GFile* file,
                                                   GFile* other_file,
                                                   GFileMonitorEvent event_type,
                                                   gpointer self);
static gboolean __lambda68_ (FileBrowser* self);
static gboolean ___lambda68__gsource_func (gpointer self);
static void file_browser_finalize (GObject * obj);
static GType file_browser_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
file_browser_get_instance_private (FileBrowser* self)
{
	return G_STRUCT_MEMBER_P (self, FileBrowser_private_offset);
}

static GType
file_browser_parent_dir_column_get_type_once (void)
{
	static const GEnumValue values[] = {{FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF, "FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF", "pixbuf"}, {FILE_BROWSER_PARENT_DIR_COLUMN_NAME, "FILE_BROWSER_PARENT_DIR_COLUMN_NAME", "name"}, {FILE_BROWSER_PARENT_DIR_COLUMN_FILE, "FILE_BROWSER_PARENT_DIR_COLUMN_FILE", "file"}, {FILE_BROWSER_PARENT_DIR_COLUMN_N_COLUMNS, "FILE_BROWSER_PARENT_DIR_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
	GType file_browser_parent_dir_column_type_id;
	file_browser_parent_dir_column_type_id = g_enum_register_static ("FileBrowserParentDirColumn", values);
	return file_browser_parent_dir_column_type_id;
}

static GType
file_browser_parent_dir_column_get_type (void)
{
	static volatile gsize file_browser_parent_dir_column_type_id__volatile = 0;
	if (g_once_init_enter (&file_browser_parent_dir_column_type_id__volatile)) {
		GType file_browser_parent_dir_column_type_id;
		file_browser_parent_dir_column_type_id = file_browser_parent_dir_column_get_type_once ();
		g_once_init_leave (&file_browser_parent_dir_column_type_id__volatile, file_browser_parent_dir_column_type_id);
	}
	return file_browser_parent_dir_column_type_id__volatile;
}

static GType
file_browser_file_column_get_type_once (void)
{
	static const GEnumValue values[] = {{FILE_BROWSER_FILE_COLUMN_PIXBUF, "FILE_BROWSER_FILE_COLUMN_PIXBUF", "pixbuf"}, {FILE_BROWSER_FILE_COLUMN_NAME, "FILE_BROWSER_FILE_COLUMN_NAME", "name"}, {FILE_BROWSER_FILE_COLUMN_IS_DIR, "FILE_BROWSER_FILE_COLUMN_IS_DIR", "is-dir"}, {FILE_BROWSER_FILE_COLUMN_N_COLUMNS, "FILE_BROWSER_FILE_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
	GType file_browser_file_column_type_id;
	file_browser_file_column_type_id = g_enum_register_static ("FileBrowserFileColumn", values);
	return file_browser_file_column_type_id;
}

static GType
file_browser_file_column_get_type (void)
{
	static volatile gsize file_browser_file_column_type_id__volatile = 0;
	if (g_once_init_enter (&file_browser_file_column_type_id__volatile)) {
		GType file_browser_file_column_type_id;
		file_browser_file_column_type_id = file_browser_file_column_get_type_once ();
		g_once_init_leave (&file_browser_file_column_type_id__volatile, file_browser_file_column_type_id);
	}
	return file_browser_file_column_type_id__volatile;
}

FileBrowser*
file_browser_construct (GType object_type,
                        MainWindow* main_window)
{
	FileBrowser * self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
#line 56 "file_browser.vala"
	g_return_val_if_fail (main_window != NULL, NULL);
#line 56 "file_browser.vala"
	self = (FileBrowser*) g_object_new (object_type, NULL);
#line 58 "file_browser.vala"
	self->priv->_main_window = main_window;
#line 60 "file_browser.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
#line 62 "file_browser.vala"
	file_browser_init_settings (self);
#line 63 "file_browser.vala"
	file_browser_init_combo_box (self);
#line 64 "file_browser.vala"
	file_browser_init_toolbar (self);
#line 65 "file_browser.vala"
	file_browser_init_list (self);
#line 67 "file_browser.vala"
	gtk_widget_show_all ((GtkWidget*) self);
#line 68 "file_browser.vala"
	_tmp0_ = file_browser_get_default_directory (self);
#line 68 "file_browser.vala"
	_tmp1_ = _tmp0_;
#line 68 "file_browser.vala"
	file_browser_set_directory (self, _tmp1_, FALSE);
#line 68 "file_browser.vala"
	_g_object_unref0 (_tmp1_);
#line 56 "file_browser.vala"
	return self;
#line 339 "file_browser.c"
}

FileBrowser*
file_browser_new (MainWindow* main_window)
{
#line 56 "file_browser.vala"
	return file_browser_construct (TYPE_FILE_BROWSER, main_window);
#line 347 "file_browser.c"
}

/*************************************************************************/
static void
_file_browser_refresh_g_settings_changed (GSettings* _sender,
                                          const gchar* key,
                                          gpointer self)
{
#line 77 "file_browser.vala"
	file_browser_refresh ((FileBrowser*) self);
#line 358 "file_browser.c"
}

static void
_file_browser_delayed_refresh_g_settings_changed (GSettings* _sender,
                                                  const gchar* key,
                                                  gpointer self)
{
#line 81 "file_browser.vala"
	file_browser_delayed_refresh ((FileBrowser*) self);
#line 368 "file_browser.c"
}

static void
file_browser_init_settings (FileBrowser* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSettings* _tmp3_;
	GSettings* _tmp4_;
#line 74 "file_browser.vala"
	g_return_if_fail (self != NULL);
#line 76 "file_browser.vala"
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.preferences.file-browser");
#line 76 "file_browser.vala"
	_g_object_unref0 (self->priv->_settings);
#line 76 "file_browser.vala"
	self->priv->_settings = _tmp0_;
#line 77 "file_browser.vala"
	_tmp1_ = self->priv->_settings;
#line 77 "file_browser.vala"
	g_signal_connect_object (_tmp1_, "changed::show-build-files", (GCallback) _file_browser_refresh_g_settings_changed, self, 0);
#line 78 "file_browser.vala"
	_tmp2_ = self->priv->_settings;
#line 78 "file_browser.vala"
	g_signal_connect_object (_tmp2_, "changed::show-hidden-files", (GCallback) _file_browser_refresh_g_settings_changed, self, 0);
#line 80 "file_browser.vala"
	_tmp3_ = g_settings_new ("org.gnome.gnome-latex.preferences.latex");
#line 80 "file_browser.vala"
	_g_object_unref0 (self->priv->_latex_settings);
#line 80 "file_browser.vala"
	self->priv->_latex_settings = _tmp3_;
#line 81 "file_browser.vala"
	_tmp4_ = self->priv->_latex_settings;
#line 81 "file_browser.vala"
	g_signal_connect_object (_tmp4_, "changed::clean-extensions", (GCallback) _file_browser_delayed_refresh_g_settings_changed, self, 0);
#line 405 "file_browser.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 115 "file_browser.vala"
	return self ? g_object_ref (self) : NULL;
#line 413 "file_browser.c"
}

static void
__lambda69_ (FileBrowser* self)
{
	GtkTreeIter iter = {0};
	GtkComboBox* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_;
#line 113 "file_browser.vala"
	_tmp0_ = self->priv->_combo_box;
#line 113 "file_browser.vala"
	_tmp2_ = gtk_combo_box_get_active_iter (_tmp0_, &_tmp1_);
#line 113 "file_browser.vala"
	iter = _tmp1_;
#line 113 "file_browser.vala"
	if (_tmp2_) {
#line 431 "file_browser.c"
		GtkTreeModel* model = NULL;
		GtkComboBox* _tmp3_;
		GtkTreeModel* _tmp4_;
		GtkTreeModel* _tmp5_;
		GFile* file = NULL;
		GtkTreeModel* _tmp6_;
		GtkTreeIter _tmp7_;
		GFile* _tmp8_ = NULL;
		GFile* _tmp9_;
#line 115 "file_browser.vala"
		_tmp3_ = self->priv->_combo_box;
#line 115 "file_browser.vala"
		_tmp4_ = gtk_combo_box_get_model (_tmp3_);
#line 115 "file_browser.vala"
		_tmp5_ = _g_object_ref0 (_tmp4_);
#line 115 "file_browser.vala"
		model = _tmp5_;
#line 117 "file_browser.vala"
		_tmp6_ = model;
#line 117 "file_browser.vala"
		_tmp7_ = iter;
#line 117 "file_browser.vala"
		gtk_tree_model_get (_tmp6_, &_tmp7_, FILE_BROWSER_PARENT_DIR_COLUMN_FILE, &_tmp8_, -1);
#line 117 "file_browser.vala"
		_g_object_unref0 (file);
#line 117 "file_browser.vala"
		file = _tmp8_;
#line 119 "file_browser.vala"
		_tmp9_ = file;
#line 119 "file_browser.vala"
		file_browser_set_directory (self, _tmp9_, FALSE);
#line 113 "file_browser.vala"
		_g_object_unref0 (file);
#line 113 "file_browser.vala"
		_g_object_unref0 (model);
#line 467 "file_browser.c"
	}
}

static void
___lambda69__gtk_combo_box_changed (GtkComboBox* _sender,
                                    gpointer self)
{
#line 110 "file_browser.vala"
	__lambda69_ ((FileBrowser*) self);
#line 477 "file_browser.c"
}

static void
file_browser_init_combo_box (FileBrowser* self)
{
	GtkListStore* _tmp0_;
	GtkListStore* _tmp1_;
	GtkComboBox* _tmp2_;
	GtkComboBox* _tmp3_;
	GtkComboBox* _tmp4_;
	GtkCellRendererPixbuf* pixbuf_renderer = NULL;
	GtkCellRendererPixbuf* _tmp5_;
	GtkComboBox* _tmp6_;
	GtkComboBox* _tmp7_;
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp8_;
	GtkComboBox* _tmp9_;
	GtkComboBox* _tmp10_;
	GtkComboBox* _tmp11_;
#line 85 "file_browser.vala"
	g_return_if_fail (self != NULL);
#line 87 "file_browser.vala"
	_tmp0_ = gtk_list_store_new ((gint) FILE_BROWSER_PARENT_DIR_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, g_file_get_type (), -1);
#line 87 "file_browser.vala"
	_g_object_unref0 (self->priv->_parent_dir_store);
#line 87 "file_browser.vala"
	self->priv->_parent_dir_store = _tmp0_;
#line 93 "file_browser.vala"
	_tmp1_ = self->priv->_parent_dir_store;
#line 93 "file_browser.vala"
	_tmp2_ = (GtkComboBox*) gtk_combo_box_new_with_model ((GtkTreeModel*) _tmp1_);
#line 93 "file_browser.vala"
	g_object_ref_sink (_tmp2_);
#line 93 "file_browser.vala"
	_g_object_unref0 (self->priv->_combo_box);
#line 93 "file_browser.vala"
	self->priv->_combo_box = _tmp2_;
#line 94 "file_browser.vala"
	_tmp3_ = self->priv->_combo_box;
#line 94 "file_browser.vala"
	gtk_widget_set_margin_end ((GtkWidget*) _tmp3_, 3);
#line 95 "file_browser.vala"
	_tmp4_ = self->priv->_combo_box;
#line 95 "file_browser.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp4_);
#line 98 "file_browser.vala"
	_tmp5_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
#line 98 "file_browser.vala"
	g_object_ref_sink (_tmp5_);
#line 98 "file_browser.vala"
	pixbuf_renderer = _tmp5_;
#line 99 "file_browser.vala"
	_tmp6_ = self->priv->_combo_box;
#line 99 "file_browser.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp6_, (GtkCellRenderer*) pixbuf_renderer, FALSE);
#line 100 "file_browser.vala"
	_tmp7_ = self->priv->_combo_box;
#line 100 "file_browser.vala"
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp7_, (GtkCellRenderer*) pixbuf_renderer, "icon-name", FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF, NULL);
#line 104 "file_browser.vala"
	_tmp8_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 104 "file_browser.vala"
	g_object_ref_sink (_tmp8_);
#line 104 "file_browser.vala"
	text_renderer = _tmp8_;
#line 105 "file_browser.vala"
	_tmp9_ = self->priv->_combo_box;
#line 105 "file_browser.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp9_, (GtkCellRenderer*) text_renderer, TRUE);
#line 106 "file_browser.vala"
	_tmp10_ = self->priv->_combo_box;
#line 106 "file_browser.vala"
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp10_, (GtkCellRenderer*) text_renderer, "text", FILE_BROWSER_PARENT_DIR_COLUMN_NAME, NULL);
#line 107 "file_browser.vala"
	g_object_set (text_renderer, "ellipsize-set", TRUE, NULL);
#line 108 "file_browser.vala"
	g_object_set (text_renderer, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
#line 110 "file_browser.vala"
	_tmp11_ = self->priv->_combo_box;
#line 110 "file_browser.vala"
	g_signal_connect_object (_tmp11_, "changed", (GCallback) ___lambda69__gtk_combo_box_changed, self, 0);
#line 85 "file_browser.vala"
	_g_object_unref0 (text_renderer);
#line 85 "file_browser.vala"
	_g_object_unref0 (pixbuf_renderer);
#line 563 "file_browser.c"
}

static gint
_file_browser_on_sort_gtk_tree_iter_compare_func (GtkTreeModel* model,
                                                  GtkTreeIter* a,
                                                  GtkTreeIter* b,
                                                  gpointer self)
{
	gint result;
	result = file_browser_on_sort ((FileBrowser*) self, model, a, b);
#line 133 "file_browser.vala"
	return result;
#line 576 "file_browser.c"
}

static void
__lambda77_ (FileBrowser* self,
             GtkTreePath* path)
{
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp2_;
	GtkTreeIter _tmp3_ = {0};
	gboolean _tmp4_;
	gchar* basename = NULL;
	gboolean is_dir = FALSE;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	gchar* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	GFile* file = NULL;
	GFile* _tmp9_;
	const gchar* _tmp10_;
	GFile* _tmp11_;
	gchar* extension = NULL;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	const gchar* _tmp17_;
	GError* _inner_error0_ = NULL;
#line 157 "file_browser.vala"
	g_return_if_fail (path != NULL);
#line 159 "file_browser.vala"
	_tmp0_ = self->priv->_list_store;
#line 159 "file_browser.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, gtk_tree_model_get_type ()) ? ((GtkTreeModel*) _tmp0_) : NULL);
#line 159 "file_browser.vala"
	model = _tmp1_;
#line 161 "file_browser.vala"
	_tmp2_ = model;
#line 161 "file_browser.vala"
	_tmp4_ = gtk_tree_model_get_iter (_tmp2_, &_tmp3_, path);
#line 161 "file_browser.vala"
	iter = _tmp3_;
#line 161 "file_browser.vala"
	if (!_tmp4_) {
#line 162 "file_browser.vala"
		_g_object_unref0 (model);
#line 162 "file_browser.vala"
		return;
#line 627 "file_browser.c"
	}
#line 166 "file_browser.vala"
	_tmp5_ = model;
#line 166 "file_browser.vala"
	_tmp6_ = iter;
#line 166 "file_browser.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, FILE_BROWSER_FILE_COLUMN_NAME, &_tmp7_, FILE_BROWSER_FILE_COLUMN_IS_DIR, &_tmp8_, -1);
#line 166 "file_browser.vala"
	_g_free0 (basename);
#line 166 "file_browser.vala"
	basename = _tmp7_;
#line 166 "file_browser.vala"
	is_dir = _tmp8_;
#line 171 "file_browser.vala"
	_tmp9_ = self->priv->_current_directory;
#line 171 "file_browser.vala"
	_tmp10_ = basename;
#line 171 "file_browser.vala"
	_tmp11_ = g_file_get_child (_tmp9_, _tmp10_);
#line 171 "file_browser.vala"
	file = _tmp11_;
#line 173 "file_browser.vala"
	if (is_dir) {
#line 651 "file_browser.c"
		GFile* _tmp12_;
#line 175 "file_browser.vala"
		_tmp12_ = file;
#line 175 "file_browser.vala"
		file_browser_set_directory (self, _tmp12_, FALSE);
#line 176 "file_browser.vala"
		_g_object_unref0 (file);
#line 176 "file_browser.vala"
		_g_free0 (basename);
#line 176 "file_browser.vala"
		_g_object_unref0 (model);
#line 176 "file_browser.vala"
		return;
#line 665 "file_browser.c"
	}
#line 179 "file_browser.vala"
	_tmp13_ = basename;
#line 179 "file_browser.vala"
	_tmp14_ = tepl_utils_get_file_extension (_tmp13_);
#line 179 "file_browser.vala"
	extension = _tmp14_;
#line 180 "file_browser.vala"
	_tmp17_ = extension;
#line 180 "file_browser.vala"
	if (g_strcmp0 (_tmp17_, ".dvi") != 0) {
#line 677 "file_browser.c"
		const gchar* _tmp18_;
#line 181 "file_browser.vala"
		_tmp18_ = extension;
#line 181 "file_browser.vala"
		_tmp16_ = g_strcmp0 (_tmp18_, ".pdf") != 0;
#line 683 "file_browser.c"
	} else {
#line 180 "file_browser.vala"
		_tmp16_ = FALSE;
#line 687 "file_browser.c"
	}
#line 180 "file_browser.vala"
	if (_tmp16_) {
#line 691 "file_browser.c"
		const gchar* _tmp19_;
#line 182 "file_browser.vala"
		_tmp19_ = extension;
#line 182 "file_browser.vala"
		_tmp15_ = g_strcmp0 (_tmp19_, ".ps") != 0;
#line 697 "file_browser.c"
	} else {
#line 180 "file_browser.vala"
		_tmp15_ = FALSE;
#line 701 "file_browser.c"
	}
#line 180 "file_browser.vala"
	if (_tmp15_) {
#line 705 "file_browser.c"
		MainWindow* _tmp20_;
		GFile* _tmp21_;
		DocumentTab* _tmp22_;
		DocumentTab* _tmp23_;
#line 184 "file_browser.vala"
		_tmp20_ = self->priv->_main_window;
#line 184 "file_browser.vala"
		_tmp21_ = file;
#line 184 "file_browser.vala"
		_tmp22_ = main_window_open_document (_tmp20_, _tmp21_, TRUE);
#line 184 "file_browser.vala"
		_tmp23_ = _tmp22_;
#line 184 "file_browser.vala"
		_g_object_unref0 (_tmp23_);
#line 185 "file_browser.vala"
		_g_free0 (extension);
#line 185 "file_browser.vala"
		_g_object_unref0 (file);
#line 185 "file_browser.vala"
		_g_free0 (basename);
#line 185 "file_browser.vala"
		_g_object_unref0 (model);
#line 185 "file_browser.vala"
		return;
#line 730 "file_browser.c"
	}
	{
		GFile* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
#line 190 "file_browser.vala"
		_tmp24_ = file;
#line 190 "file_browser.vala"
		_tmp25_ = g_file_get_uri (_tmp24_);
#line 190 "file_browser.vala"
		_tmp26_ = _tmp25_;
#line 190 "file_browser.vala"
		latexila_utils_show_uri ((GtkWidget*) self, _tmp26_, (guint32) GDK_CURRENT_TIME, &_inner_error0_);
#line 190 "file_browser.vala"
		_g_free0 (_tmp26_);
#line 190 "file_browser.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 748 "file_browser.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GFile* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		GError* _tmp30_;
		const gchar* _tmp31_;
#line 188 "file_browser.vala"
		e = _inner_error0_;
#line 188 "file_browser.vala"
		_inner_error0_ = NULL;
#line 194 "file_browser.vala"
		_tmp27_ = file;
#line 194 "file_browser.vala"
		_tmp28_ = g_file_get_uri (_tmp27_);
#line 194 "file_browser.vala"
		_tmp29_ = _tmp28_;
#line 194 "file_browser.vala"
		_tmp30_ = e;
#line 194 "file_browser.vala"
		_tmp31_ = _tmp30_->message;
#line 194 "file_browser.vala"
		g_warning ("file_browser.vala:194: Impossible to open the file '%s': %s", _tmp29_, _tmp31_);
#line 194 "file_browser.vala"
		_g_free0 (_tmp29_);
#line 188 "file_browser.vala"
		_g_error_free0 (e);
#line 781 "file_browser.c"
	}
	__finally0:
#line 188 "file_browser.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 188 "file_browser.vala"
		_g_free0 (extension);
#line 188 "file_browser.vala"
		_g_object_unref0 (file);
#line 188 "file_browser.vala"
		_g_free0 (basename);
#line 188 "file_browser.vala"
		_g_object_unref0 (model);
#line 188 "file_browser.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 188 "file_browser.vala"
		g_clear_error (&_inner_error0_);
#line 188 "file_browser.vala"
		return;
#line 800 "file_browser.c"
	}
#line 157 "file_browser.vala"
	_g_free0 (extension);
#line 157 "file_browser.vala"
	_g_object_unref0 (file);
#line 157 "file_browser.vala"
	_g_free0 (basename);
#line 157 "file_browser.vala"
	_g_object_unref0 (model);
#line 810 "file_browser.c"
}

static void
___lambda77__gtk_tree_view_row_activated (GtkTreeView* _sender,
                                          GtkTreePath* path,
                                          GtkTreeViewColumn* column,
                                          gpointer self)
{
#line 157 "file_browser.vala"
	__lambda77_ ((FileBrowser*) self, path);
#line 821 "file_browser.c"
}

static void
file_browser_init_list (FileBrowser* self)
{
	GtkListStore* _tmp0_;
	GtkListStore* _tmp1_;
	GtkListStore* _tmp2_;
	GtkListStore* _tmp3_;
	GtkTreeView* _tmp4_;
	GtkTreeView* _tmp5_;
	GtkTreeView* _tmp6_;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkTreeView* _tmp7_;
	GtkScrolledWindow* _tmp8_;
	GtkTreeViewColumn* column = NULL;
	GtkTreeViewColumn* _tmp9_;
	GtkTreeView* _tmp10_;
	GtkCellRendererPixbuf* pixbuf_renderer = NULL;
	GtkCellRendererPixbuf* _tmp11_;
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp12_;
	GtkTreeView* _tmp13_;
#line 125 "file_browser.vala"
	g_return_if_fail (self != NULL);
#line 127 "file_browser.vala"
	_tmp0_ = gtk_list_store_new ((gint) FILE_BROWSER_FILE_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_BOOLEAN, -1);
#line 127 "file_browser.vala"
	_g_object_unref0 (self->priv->_list_store);
#line 127 "file_browser.vala"
	self->priv->_list_store = _tmp0_;
#line 133 "file_browser.vala"
	_tmp1_ = self->priv->_list_store;
#line 133 "file_browser.vala"
	gtk_tree_sortable_set_sort_func ((GtkTreeSortable*) _tmp1_, 0, _file_browser_on_sort_gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
#line 134 "file_browser.vala"
	_tmp2_ = self->priv->_list_store;
#line 134 "file_browser.vala"
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp2_, 0, GTK_SORT_ASCENDING);
#line 136 "file_browser.vala"
	_tmp3_ = self->priv->_list_store;
#line 136 "file_browser.vala"
	_tmp4_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _tmp3_);
#line 136 "file_browser.vala"
	g_object_ref_sink (_tmp4_);
#line 136 "file_browser.vala"
	_g_object_unref0 (self->priv->_list_view);
#line 136 "file_browser.vala"
	self->priv->_list_view = _tmp4_;
#line 137 "file_browser.vala"
	_tmp5_ = self->priv->_list_view;
#line 137 "file_browser.vala"
	gtk_tree_view_set_headers_visible (_tmp5_, FALSE);
#line 138 "file_browser.vala"
	_tmp6_ = self->priv->_list_view;
#line 138 "file_browser.vala"
	g_object_set ((GtkWidget*) _tmp6_, "expand", TRUE, NULL);
#line 140 "file_browser.vala"
	_tmp7_ = self->priv->_list_view;
#line 140 "file_browser.vala"
	_tmp8_ = utils_add_scrollbar ((GtkWidget*) _tmp7_);
#line 140 "file_browser.vala"
	scrolled_window = _tmp8_;
#line 141 "file_browser.vala"
	gtk_scrolled_window_set_shadow_type (scrolled_window, GTK_SHADOW_IN);
#line 142 "file_browser.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) scrolled_window);
#line 144 "file_browser.vala"
	_tmp9_ = gtk_tree_view_column_new ();
#line 144 "file_browser.vala"
	g_object_ref_sink (_tmp9_);
#line 144 "file_browser.vala"
	column = _tmp9_;
#line 145 "file_browser.vala"
	_tmp10_ = self->priv->_list_view;
#line 145 "file_browser.vala"
	gtk_tree_view_append_column (_tmp10_, column);
#line 148 "file_browser.vala"
	_tmp11_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
#line 148 "file_browser.vala"
	g_object_ref_sink (_tmp11_);
#line 148 "file_browser.vala"
	pixbuf_renderer = _tmp11_;
#line 149 "file_browser.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) pixbuf_renderer, FALSE);
#line 150 "file_browser.vala"
	gtk_tree_view_column_set_attributes (column, (GtkCellRenderer*) pixbuf_renderer, "icon-name", FILE_BROWSER_FILE_COLUMN_PIXBUF, NULL);
#line 153 "file_browser.vala"
	_tmp12_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 153 "file_browser.vala"
	g_object_ref_sink (_tmp12_);
#line 153 "file_browser.vala"
	text_renderer = _tmp12_;
#line 154 "file_browser.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) column, (GtkCellRenderer*) text_renderer, TRUE);
#line 155 "file_browser.vala"
	gtk_tree_view_column_set_attributes (column, (GtkCellRenderer*) text_renderer, "text", FILE_BROWSER_FILE_COLUMN_NAME, NULL);
#line 157 "file_browser.vala"
	_tmp13_ = self->priv->_list_view;
#line 157 "file_browser.vala"
	g_signal_connect_object (_tmp13_, "row-activated", (GCallback) ___lambda77__gtk_tree_view_row_activated, self, 0);
#line 125 "file_browser.vala"
	_g_object_unref0 (text_renderer);
#line 125 "file_browser.vala"
	_g_object_unref0 (pixbuf_renderer);
#line 125 "file_browser.vala"
	_g_object_unref0 (column);
#line 125 "file_browser.vala"
	_g_object_unref0 (scrolled_window);
#line 931 "file_browser.c"
}

static void
file_browser_init_toolbar (FileBrowser* self)
{
	GtkToolbar* toolbar = NULL;
	GtkToolbar* _tmp0_;
	GtkToolButton* _tmp1_;
	GtkToolButton* _tmp2_;
	GtkToolButton* _tmp3_;
	GtkToolButton* _tmp4_;
	GtkToolButton* _tmp5_;
	GtkToolButton* _tmp6_;
	GtkToolButton* _tmp7_;
	GtkToolButton* _tmp8_;
	GtkToolButton* _tmp9_;
	GtkToolButton* _tmp10_;
#line 200 "file_browser.vala"
	g_return_if_fail (self != NULL);
#line 202 "file_browser.vala"
	_tmp0_ = (GtkToolbar*) gtk_toolbar_new ();
#line 202 "file_browser.vala"
	g_object_ref_sink (_tmp0_);
#line 202 "file_browser.vala"
	toolbar = _tmp0_;
#line 203 "file_browser.vala"
	gtk_toolbar_set_icon_size (toolbar, GTK_ICON_SIZE_MENU);
#line 204 "file_browser.vala"
	gtk_toolbar_set_style (toolbar, GTK_TOOLBAR_ICONS);
#line 206 "file_browser.vala"
	_tmp1_ = file_browser_get_home_button (self);
#line 206 "file_browser.vala"
	_tmp2_ = _tmp1_;
#line 206 "file_browser.vala"
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp2_, -1);
#line 206 "file_browser.vala"
	_g_object_unref0 (_tmp2_);
#line 207 "file_browser.vala"
	_tmp3_ = file_browser_get_parent_button (self);
#line 207 "file_browser.vala"
	_tmp4_ = _tmp3_;
#line 207 "file_browser.vala"
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp4_, -1);
#line 207 "file_browser.vala"
	_g_object_unref0 (_tmp4_);
#line 208 "file_browser.vala"
	_tmp5_ = file_browser_get_jump_button (self);
#line 208 "file_browser.vala"
	_tmp6_ = _tmp5_;
#line 208 "file_browser.vala"
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp6_, -1);
#line 208 "file_browser.vala"
	_g_object_unref0 (_tmp6_);
#line 209 "file_browser.vala"
	_tmp7_ = file_browser_get_open_directory_button (self);
#line 209 "file_browser.vala"
	_tmp8_ = _tmp7_;
#line 209 "file_browser.vala"
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp8_, -1);
#line 209 "file_browser.vala"
	_g_object_unref0 (_tmp8_);
#line 210 "file_browser.vala"
	_tmp9_ = file_browser_get_properties_button (self);
#line 210 "file_browser.vala"
	_tmp10_ = _tmp9_;
#line 210 "file_browser.vala"
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp10_, -1);
#line 210 "file_browser.vala"
	_g_object_unref0 (_tmp10_);
#line 212 "file_browser.vala"
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) toolbar);
#line 200 "file_browser.vala"
	_g_object_unref0 (toolbar);
#line 1005 "file_browser.c"
}

static void
__lambda70_ (FileBrowser* self)
{
	GFile* home_dir = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
#line 223 "file_browser.vala"
	_tmp0_ = g_get_home_dir ();
#line 223 "file_browser.vala"
	_tmp1_ = g_file_new_for_path (_tmp0_);
#line 223 "file_browser.vala"
	home_dir = _tmp1_;
#line 224 "file_browser.vala"
	file_browser_set_directory (self, home_dir, FALSE);
#line 221 "file_browser.vala"
	_g_object_unref0 (home_dir);
#line 1024 "file_browser.c"
}

static void
___lambda70__gtk_tool_button_clicked (GtkToolButton* _sender,
                                      gpointer self)
{
#line 221 "file_browser.vala"
	__lambda70_ ((FileBrowser*) self);
#line 1033 "file_browser.c"
}

static GtkToolButton*
file_browser_get_home_button (FileBrowser* self)
{
	GtkToolButton* home_button = NULL;
	GtkToolButton* _tmp0_;
	GtkToolButton* result = NULL;
#line 215 "file_browser.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 217 "file_browser.vala"
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
#line 217 "file_browser.vala"
	g_object_ref_sink (_tmp0_);
#line 217 "file_browser.vala"
	home_button = _tmp0_;
#line 218 "file_browser.vala"
	gtk_tool_button_set_icon_name (home_button, "go-home");
#line 219 "file_browser.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) home_button, _ ("Go to the home directory"));
#line 221 "file_browser.vala"
	g_signal_connect_object (home_button, "clicked", (GCallback) ___lambda70__gtk_tool_button_clicked, self, 0);
#line 227 "file_browser.vala"
	result = home_button;
#line 227 "file_browser.vala"
	return result;
#line 1060 "file_browser.c"
}

static void
__lambda71_ (FileBrowser* self)
{
	GFile* parent = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
#line 238 "file_browser.vala"
	_tmp0_ = self->priv->_current_directory;
#line 238 "file_browser.vala"
	_tmp1_ = g_file_get_parent (_tmp0_);
#line 238 "file_browser.vala"
	parent = _tmp1_;
#line 239 "file_browser.vala"
	g_return_if_fail (parent != NULL);
#line 240 "file_browser.vala"
	file_browser_set_directory (self, parent, FALSE);
#line 236 "file_browser.vala"
	_g_object_unref0 (parent);
#line 1081 "file_browser.c"
}

static void
___lambda71__gtk_tool_button_clicked (GtkToolButton* _sender,
                                      gpointer self)
{
#line 236 "file_browser.vala"
	__lambda71_ ((FileBrowser*) self);
#line 1090 "file_browser.c"
}

static GtkToolButton*
file_browser_get_parent_button (FileBrowser* self)
{
	GtkToolButton* _tmp0_;
	GtkToolButton* _tmp1_;
	GtkToolButton* _tmp2_;
	GtkToolButton* _tmp3_;
	GtkToolButton* _tmp4_;
	GtkToolButton* _tmp5_;
	GtkToolButton* result = NULL;
#line 230 "file_browser.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 232 "file_browser.vala"
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
#line 232 "file_browser.vala"
	g_object_ref_sink (_tmp0_);
#line 232 "file_browser.vala"
	_g_object_unref0 (self->priv->_parent_button);
#line 232 "file_browser.vala"
	self->priv->_parent_button = _tmp0_;
#line 233 "file_browser.vala"
	_tmp1_ = self->priv->_parent_button;
#line 233 "file_browser.vala"
	gtk_tool_button_set_icon_name (_tmp1_, "go-up");
#line 234 "file_browser.vala"
	_tmp2_ = self->priv->_parent_button;
#line 234 "file_browser.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp2_, _ ("Go to the parent directory"));
#line 236 "file_browser.vala"
	_tmp3_ = self->priv->_parent_button;
#line 236 "file_browser.vala"
	g_signal_connect_object (_tmp3_, "clicked", (GCallback) ___lambda71__gtk_tool_button_clicked, self, 0);
#line 243 "file_browser.vala"
	_tmp4_ = self->priv->_parent_button;
#line 243 "file_browser.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 243 "file_browser.vala"
	result = _tmp5_;
#line 243 "file_browser.vala"
	return result;
#line 1133 "file_browser.c"
}

static void
__lambda72_ (FileBrowser* self)
{
	gboolean _tmp0_ = FALSE;
	MainWindow* _tmp1_;
	Document* _tmp2_;
	Document* _tmp3_;
#line 254 "file_browser.vala"
	_tmp1_ = self->priv->_main_window;
#line 254 "file_browser.vala"
	_tmp2_ = main_window_get_active_document (_tmp1_);
#line 254 "file_browser.vala"
	_tmp3_ = _tmp2_;
#line 254 "file_browser.vala"
	if (_tmp3_ != NULL) {
#line 1151 "file_browser.c"
		MainWindow* _tmp4_;
		Document* _tmp5_;
		Document* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
#line 255 "file_browser.vala"
		_tmp4_ = self->priv->_main_window;
#line 255 "file_browser.vala"
		_tmp5_ = main_window_get_active_document (_tmp4_);
#line 255 "file_browser.vala"
		_tmp6_ = _tmp5_;
#line 255 "file_browser.vala"
		_tmp7_ = document_get_location (_tmp6_);
#line 255 "file_browser.vala"
		_tmp8_ = _tmp7_;
#line 255 "file_browser.vala"
		_tmp0_ = _tmp8_ != NULL;
#line 1169 "file_browser.c"
	} else {
#line 254 "file_browser.vala"
		_tmp0_ = FALSE;
#line 1173 "file_browser.c"
	}
#line 254 "file_browser.vala"
	if (_tmp0_) {
#line 1177 "file_browser.c"
		MainWindow* _tmp9_;
		Document* _tmp10_;
		Document* _tmp11_;
		GFile* _tmp12_;
		GFile* _tmp13_;
		GFile* _tmp14_;
		GFile* _tmp15_;
#line 257 "file_browser.vala"
		_tmp9_ = self->priv->_main_window;
#line 257 "file_browser.vala"
		_tmp10_ = main_window_get_active_document (_tmp9_);
#line 257 "file_browser.vala"
		_tmp11_ = _tmp10_;
#line 257 "file_browser.vala"
		_tmp12_ = document_get_location (_tmp11_);
#line 257 "file_browser.vala"
		_tmp13_ = _tmp12_;
#line 257 "file_browser.vala"
		_tmp14_ = g_file_get_parent (_tmp13_);
#line 257 "file_browser.vala"
		_tmp15_ = _tmp14_;
#line 257 "file_browser.vala"
		file_browser_set_directory (self, _tmp15_, FALSE);
#line 257 "file_browser.vala"
		_g_object_unref0 (_tmp15_);
#line 1203 "file_browser.c"
	}
}

static void
___lambda72__gtk_tool_button_clicked (GtkToolButton* _sender,
                                      gpointer self)
{
#line 252 "file_browser.vala"
	__lambda72_ ((FileBrowser*) self);
#line 1213 "file_browser.c"
}

static GtkToolButton*
file_browser_get_jump_button (FileBrowser* self)
{
	GtkToolButton* jump_button = NULL;
	GtkToolButton* _tmp0_;
	GtkToolButton* result = NULL;
#line 246 "file_browser.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 248 "file_browser.vala"
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
#line 248 "file_browser.vala"
	g_object_ref_sink (_tmp0_);
#line 248 "file_browser.vala"
	jump_button = _tmp0_;
#line 249 "file_browser.vala"
	gtk_tool_button_set_icon_name (jump_button, "go-jump");
#line 250 "file_browser.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) jump_button, _ ("Go to the active document directory"));
#line 252 "file_browser.vala"
	g_signal_connect_object (jump_button, "clicked", (GCallback) ___lambda72__gtk_tool_button_clicked, self, 0);
#line 261 "file_browser.vala"
	result = jump_button;
#line 261 "file_browser.vala"
	return result;
#line 1240 "file_browser.c"
}

static Block19Data*
block19_data_ref (Block19Data* _data19_)
{
#line 264 "file_browser.vala"
	g_atomic_int_inc (&_data19_->_ref_count_);
#line 264 "file_browser.vala"
	return _data19_;
#line 1250 "file_browser.c"
}

static void
block19_data_unref (void * _userdata_)
{
	Block19Data* _data19_;
	_data19_ = (Block19Data*) _userdata_;
#line 264 "file_browser.vala"
	if (g_atomic_int_dec_and_test (&_data19_->_ref_count_)) {
#line 1260 "file_browser.c"
		FileBrowser* self;
#line 264 "file_browser.vala"
		self = _data19_->self;
#line 264 "file_browser.vala"
		_g_object_unref0 (_data19_->button);
#line 264 "file_browser.vala"
		_g_object_unref0 (_data19_->menu);
#line 264 "file_browser.vala"
		_g_object_unref0 (self);
#line 264 "file_browser.vala"
		g_slice_free (Block19Data, _data19_);
#line 1272 "file_browser.c"
	}
}

static void
__lambda75_ (Block19Data* _data19_)
{
	FileBrowser* self;
#line 278 "file_browser.vala"
	self = _data19_->self;
#line 280 "file_browser.vala"
	gtk_menu_popup_at_widget (_data19_->menu, (GtkWidget*) _data19_->button, GDK_GRAVITY_SOUTH_WEST, GDK_GRAVITY_NORTH_WEST, NULL);
#line 1284 "file_browser.c"
}

static void
___lambda75__gtk_tool_button_clicked (GtkToolButton* _sender,
                                      gpointer self)
{
#line 278 "file_browser.vala"
	__lambda75_ (self);
#line 1293 "file_browser.c"
}

static GtkToolButton*
file_browser_get_open_directory_button (FileBrowser* self)
{
	Block19Data* _data19_;
	GtkMenu* _tmp0_;
	GtkMenuItem* _tmp1_;
	GtkMenuItem* _tmp2_;
	GtkMenuItem* _tmp3_;
	GtkMenuItem* _tmp4_;
	GtkToolButton* _tmp5_;
	GtkToolButton* _tmp6_;
	GtkToolButton* result = NULL;
#line 264 "file_browser.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 264 "file_browser.vala"
	_data19_ = g_slice_new0 (Block19Data);
#line 264 "file_browser.vala"
	_data19_->_ref_count_ = 1;
#line 264 "file_browser.vala"
	_data19_->self = g_object_ref (self);
#line 268 "file_browser.vala"
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
#line 268 "file_browser.vala"
	g_object_ref_sink (_tmp0_);
#line 268 "file_browser.vala"
	_data19_->menu = _tmp0_;
#line 269 "file_browser.vala"
	_tmp1_ = file_browser_get_open_directory_menu (self);
#line 269 "file_browser.vala"
	_tmp2_ = _tmp1_;
#line 269 "file_browser.vala"
	gtk_menu_shell_append ((GtkMenuShell*) _data19_->menu, _tmp2_);
#line 269 "file_browser.vala"
	_g_object_unref0 (_tmp2_);
#line 270 "file_browser.vala"
	_tmp3_ = file_browser_get_open_terminal_menu (self);
#line 270 "file_browser.vala"
	_tmp4_ = _tmp3_;
#line 270 "file_browser.vala"
	gtk_menu_shell_append ((GtkMenuShell*) _data19_->menu, _tmp4_);
#line 270 "file_browser.vala"
	_g_object_unref0 (_tmp4_);
#line 271 "file_browser.vala"
	gtk_widget_show_all ((GtkWidget*) _data19_->menu);
#line 275 "file_browser.vala"
	_tmp5_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
#line 275 "file_browser.vala"
	g_object_ref_sink (_tmp5_);
#line 275 "file_browser.vala"
	_data19_->button = _tmp5_;
#line 276 "file_browser.vala"
	gtk_tool_button_set_icon_name (_data19_->button, "document-open");
#line 278 "file_browser.vala"
	g_signal_connect_data (_data19_->button, "clicked", (GCallback) ___lambda75__gtk_tool_button_clicked, block19_data_ref (_data19_), (GClosureNotify) block19_data_unref, 0);
#line 284 "file_browser.vala"
	_tmp6_ = _g_object_ref0 (_data19_->button);
#line 284 "file_browser.vala"
	result = _tmp6_;
#line 284 "file_browser.vala"
	block19_data_unref (_data19_);
#line 284 "file_browser.vala"
	_data19_ = NULL;
#line 284 "file_browser.vala"
	return result;
#line 1360 "file_browser.c"
}

static void
__lambda73_ (FileBrowser* self)
{
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
#line 296 "file_browser.vala"
	_tmp0_ = self->priv->_current_directory;
#line 296 "file_browser.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 1372 "file_browser.c"
	{
		GFile* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
#line 300 "file_browser.vala"
		_tmp1_ = self->priv->_current_directory;
#line 300 "file_browser.vala"
		_tmp2_ = g_file_get_uri (_tmp1_);
#line 300 "file_browser.vala"
		_tmp3_ = _tmp2_;
#line 300 "file_browser.vala"
		latexila_utils_show_uri ((GtkWidget*) self, _tmp3_, (guint32) GDK_CURRENT_TIME, &_inner_error0_);
#line 300 "file_browser.vala"
		_g_free0 (_tmp3_);
#line 300 "file_browser.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1389 "file_browser.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp4_;
#line 298 "file_browser.vala"
		_error_ = _inner_error0_;
#line 298 "file_browser.vala"
		_inner_error0_ = NULL;
#line 305 "file_browser.vala"
		_tmp4_ = _error_;
#line 305 "file_browser.vala"
		file_browser_handle_error (self, _tmp4_);
#line 298 "file_browser.vala"
		_g_error_free0 (_error_);
#line 1408 "file_browser.c"
	}
	__finally0:
#line 298 "file_browser.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 298 "file_browser.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 298 "file_browser.vala"
		g_clear_error (&_inner_error0_);
#line 298 "file_browser.vala"
		return;
#line 1419 "file_browser.c"
	}
}

static void
___lambda73__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
#line 294 "file_browser.vala"
	__lambda73_ ((FileBrowser*) self);
#line 1429 "file_browser.c"
}

static GtkMenuItem*
file_browser_get_open_directory_menu (FileBrowser* self)
{
	GtkMenuItem* open_directory = NULL;
	GtkMenuItem* _tmp0_;
	GtkMenuItem* result = NULL;
#line 287 "file_browser.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 289 "file_browser.vala"
	_tmp0_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Open in a file manager"));
#line 289 "file_browser.vala"
	g_object_ref_sink (_tmp0_);
#line 289 "file_browser.vala"
	open_directory = _tmp0_;
#line 291 "file_browser.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) open_directory, _ ("Open the current directory in a file manager"));
#line 294 "file_browser.vala"
	g_signal_connect_object (open_directory, "activate", (GCallback) ___lambda73__gtk_menu_item_activate, self, 0);
#line 309 "file_browser.vala"
	result = open_directory;
#line 309 "file_browser.vala"
	return result;
#line 1454 "file_browser.c"
}

static void
__lambda74_ (FileBrowser* self)
{
	GFile* _tmp0_;
	GSettings* terminal_settings = NULL;
	GSettings* _tmp1_;
	gchar* name_term = NULL;
	GSettings* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
#line 319 "file_browser.vala"
	_tmp0_ = self->priv->_current_directory;
#line 319 "file_browser.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 321 "file_browser.vala"
	_tmp1_ = g_settings_new ("org.gnome.desktop.default-applications.terminal");
#line 321 "file_browser.vala"
	terminal_settings = _tmp1_;
#line 323 "file_browser.vala"
	_tmp2_ = terminal_settings;
#line 323 "file_browser.vala"
	_tmp3_ = g_settings_get_string (_tmp2_, "exec");
#line 323 "file_browser.vala"
	name_term = _tmp3_;
#line 325 "file_browser.vala"
	_tmp4_ = name_term;
#line 325 "file_browser.vala"
	g_return_if_fail (_tmp4_ != NULL);
#line 1486 "file_browser.c"
	{
		gchar* exec_cmd = NULL;
		const gchar* _tmp5_;
		GFile* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		GAppInfo* app_info = NULL;
		const gchar* _tmp11_;
		GAppInfo* _tmp12_;
		GAppInfo* _tmp13_;
#line 329 "file_browser.vala"
		_tmp5_ = name_term;
#line 329 "file_browser.vala"
		_tmp6_ = self->priv->_current_directory;
#line 329 "file_browser.vala"
		_tmp7_ = g_file_get_path (_tmp6_);
#line 329 "file_browser.vala"
		_tmp8_ = _tmp7_;
#line 329 "file_browser.vala"
		_tmp9_ = g_strdup_printf ("%s --working-directory=\"%s\"", _tmp5_, _tmp8_);
#line 329 "file_browser.vala"
		_tmp10_ = _tmp9_;
#line 329 "file_browser.vala"
		_g_free0 (_tmp8_);
#line 329 "file_browser.vala"
		exec_cmd = _tmp10_;
#line 331 "file_browser.vala"
		_tmp11_ = exec_cmd;
#line 331 "file_browser.vala"
		_tmp12_ = g_app_info_create_from_commandline (_tmp11_, "", 0, &_inner_error0_);
#line 331 "file_browser.vala"
		app_info = _tmp12_;
#line 331 "file_browser.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 331 "file_browser.vala"
			_g_free0 (exec_cmd);
#line 1525 "file_browser.c"
			goto __catch0_g_error;
		}
#line 332 "file_browser.vala"
		_tmp13_ = app_info;
#line 332 "file_browser.vala"
		g_app_info_launch (_tmp13_, NULL, NULL, &_inner_error0_);
#line 332 "file_browser.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 332 "file_browser.vala"
			_g_object_unref0 (app_info);
#line 332 "file_browser.vala"
			_g_free0 (exec_cmd);
#line 1538 "file_browser.c"
			goto __catch0_g_error;
		}
#line 327 "file_browser.vala"
		_g_object_unref0 (app_info);
#line 327 "file_browser.vala"
		_g_free0 (exec_cmd);
#line 1545 "file_browser.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp14_;
#line 327 "file_browser.vala"
		_error_ = _inner_error0_;
#line 327 "file_browser.vala"
		_inner_error0_ = NULL;
#line 336 "file_browser.vala"
		_tmp14_ = _error_;
#line 336 "file_browser.vala"
		file_browser_handle_error (self, _tmp14_);
#line 327 "file_browser.vala"
		_g_error_free0 (_error_);
#line 1562 "file_browser.c"
	}
	__finally0:
#line 327 "file_browser.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 327 "file_browser.vala"
		_g_free0 (name_term);
#line 327 "file_browser.vala"
		_g_object_unref0 (terminal_settings);
#line 327 "file_browser.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 327 "file_browser.vala"
		g_clear_error (&_inner_error0_);
#line 327 "file_browser.vala"
		return;
#line 1577 "file_browser.c"
	}
#line 317 "file_browser.vala"
	_g_free0 (name_term);
#line 317 "file_browser.vala"
	_g_object_unref0 (terminal_settings);
#line 1583 "file_browser.c"
}

static void
___lambda74__gtk_menu_item_activate (GtkMenuItem* _sender,
                                     gpointer self)
{
#line 317 "file_browser.vala"
	__lambda74_ ((FileBrowser*) self);
#line 1592 "file_browser.c"
}

static GtkMenuItem*
file_browser_get_open_terminal_menu (FileBrowser* self)
{
	GtkMenuItem* open_terminal = NULL;
	GtkMenuItem* _tmp0_;
	GtkMenuItem* result = NULL;
#line 312 "file_browser.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 314 "file_browser.vala"
	_tmp0_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Open in a terminal"));
#line 314 "file_browser.vala"
	g_object_ref_sink (_tmp0_);
#line 314 "file_browser.vala"
	open_terminal = _tmp0_;
#line 315 "file_browser.vala"
	gtk_widget_set_tooltip_text ((GtkWidget*) open_terminal, _ ("Open the current directory in a terminal"));
#line 317 "file_browser.vala"
	g_signal_connect_object (open_terminal, "activate", (GCallback) ___lambda74__gtk_menu_item_activate, self, 0);
#line 340 "file_browser.vala"
	result = open_terminal;
#line 340 "file_browser.vala"
	return result;
#line 1617 "file_browser.c"
}

static Block20Data*
block20_data_ref (Block20Data* _data20_)
{
#line 343 "file_browser.vala"
	g_atomic_int_inc (&_data20_->_ref_count_);
#line 343 "file_browser.vala"
	return _data20_;
#line 1627 "file_browser.c"
}

static void
block20_data_unref (void * _userdata_)
{
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
#line 343 "file_browser.vala"
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
#line 1637 "file_browser.c"
		FileBrowser* self;
#line 343 "file_browser.vala"
		self = _data20_->self;
#line 343 "file_browser.vala"
		_g_object_unref0 (_data20_->button);
#line 343 "file_browser.vala"
		_g_object_unref0 (_data20_->menu);
#line 343 "file_browser.vala"
		_g_object_unref0 (self);
#line 343 "file_browser.vala"
		g_slice_free (Block20Data, _data20_);
#line 1649 "file_browser.c"
	}
}

static void
__lambda76_ (Block20Data* _data20_)
{
	FileBrowser* self;
#line 373 "file_browser.vala"
	self = _data20_->self;
#line 375 "file_browser.vala"
	gtk_menu_popup_at_widget (_data20_->menu, (GtkWidget*) _data20_->button, GDK_GRAVITY_SOUTH_WEST, GDK_GRAVITY_NORTH_WEST, NULL);
#line 1661 "file_browser.c"
}

static void
___lambda76__gtk_tool_button_clicked (GtkToolButton* _sender,
                                      gpointer self)
{
#line 373 "file_browser.vala"
	__lambda76_ (self);
#line 1670 "file_browser.c"
}

static GtkToolButton*
file_browser_get_properties_button (FileBrowser* self)
{
	Block20Data* _data20_;
	GtkCheckMenuItem* show_build_files = NULL;
	GtkCheckMenuItem* _tmp0_;
	GSettings* _tmp1_;
	GtkCheckMenuItem* show_hidden_files = NULL;
	GtkCheckMenuItem* _tmp2_;
	GSettings* _tmp3_;
	GtkMenu* _tmp4_;
	GtkToolButton* _tmp5_;
	GtkToolButton* _tmp6_;
	GtkToolButton* result = NULL;
#line 343 "file_browser.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 343 "file_browser.vala"
	_data20_ = g_slice_new0 (Block20Data);
#line 343 "file_browser.vala"
	_data20_->_ref_count_ = 1;
#line 343 "file_browser.vala"
	_data20_->self = g_object_ref (self);
#line 347 "file_browser.vala"
	_tmp0_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_ ("Show build files"));
#line 347 "file_browser.vala"
	g_object_ref_sink (_tmp0_);
#line 347 "file_browser.vala"
	show_build_files = _tmp0_;
#line 350 "file_browser.vala"
	_tmp1_ = self->priv->_settings;
#line 350 "file_browser.vala"
	g_settings_bind (_tmp1_, "show-build-files", (GObject*) show_build_files, "active", G_SETTINGS_BIND_DEFAULT);
#line 355 "file_browser.vala"
	_tmp2_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_ ("Show hidden files"));
#line 355 "file_browser.vala"
	g_object_ref_sink (_tmp2_);
#line 355 "file_browser.vala"
	show_hidden_files = _tmp2_;
#line 358 "file_browser.vala"
	_tmp3_ = self->priv->_settings;
#line 358 "file_browser.vala"
	g_settings_bind (_tmp3_, "show-hidden-files", (GObject*) show_hidden_files, "active", G_SETTINGS_BIND_DEFAULT);
#line 363 "file_browser.vala"
	_tmp4_ = (GtkMenu*) gtk_menu_new ();
#line 363 "file_browser.vala"
	g_object_ref_sink (_tmp4_);
#line 363 "file_browser.vala"
	_data20_->menu = _tmp4_;
#line 364 "file_browser.vala"
	gtk_menu_shell_append ((GtkMenuShell*) _data20_->menu, (GtkMenuItem*) show_build_files);
#line 365 "file_browser.vala"
	gtk_menu_shell_append ((GtkMenuShell*) _data20_->menu, (GtkMenuItem*) show_hidden_files);
#line 366 "file_browser.vala"
	gtk_widget_show_all ((GtkWidget*) _data20_->menu);
#line 370 "file_browser.vala"
	_tmp5_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
#line 370 "file_browser.vala"
	g_object_ref_sink (_tmp5_);
#line 370 "file_browser.vala"
	_data20_->button = _tmp5_;
#line 371 "file_browser.vala"
	gtk_tool_button_set_icon_name (_data20_->button, "document-properties");
#line 373 "file_browser.vala"
	g_signal_connect_data (_data20_->button, "clicked", (GCallback) ___lambda76__gtk_tool_button_clicked, block20_data_ref (_data20_), (GClosureNotify) block20_data_unref, 0);
#line 379 "file_browser.vala"
	_tmp6_ = _g_object_ref0 (_data20_->button);
#line 379 "file_browser.vala"
	result = _tmp6_;
#line 379 "file_browser.vala"
	_g_object_unref0 (show_hidden_files);
#line 379 "file_browser.vala"
	_g_object_unref0 (show_build_files);
#line 379 "file_browser.vala"
	block20_data_unref (_data20_);
#line 379 "file_browser.vala"
	_data20_ = NULL;
#line 379 "file_browser.vala"
	return result;
#line 1751 "file_browser.c"
}

/*************************************************************************/
static void
file_browser_update_parent_directories (FileBrowser* self)
{
	GtkListStore* _tmp0_;
	GeeList* parent_dirs = NULL;
	GeeLinkedList* _tmp1_;
	GeeList* _tmp2_;
	GFile* _tmp3_;
	GFile* parent = NULL;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gint depth = 0;
	GtkComboBox* _tmp37_;
#line 385 "file_browser.vala"
	g_return_if_fail (self != NULL);
#line 387 "file_browser.vala"
	_tmp0_ = self->priv->_parent_dir_store;
#line 387 "file_browser.vala"
	gtk_list_store_clear (_tmp0_);
#line 389 "file_browser.vala"
	_tmp1_ = gee_linked_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 389 "file_browser.vala"
	parent_dirs = (GeeList*) _tmp1_;
#line 390 "file_browser.vala"
	_tmp2_ = parent_dirs;
#line 390 "file_browser.vala"
	_tmp3_ = self->priv->_current_directory;
#line 390 "file_browser.vala"
	gee_collection_add ((GeeCollection*) _tmp2_, _tmp3_);
#line 391 "file_browser.vala"
	_tmp4_ = self->priv->_current_directory;
#line 391 "file_browser.vala"
	_tmp5_ = g_file_get_parent (_tmp4_);
#line 391 "file_browser.vala"
	parent = _tmp5_;
#line 393 "file_browser.vala"
	while (TRUE) {
#line 1792 "file_browser.c"
		GFile* _tmp6_;
		GeeList* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		GFile* _tmp10_;
#line 393 "file_browser.vala"
		_tmp6_ = parent;
#line 393 "file_browser.vala"
		if (!(_tmp6_ != NULL)) {
#line 393 "file_browser.vala"
			break;
#line 1804 "file_browser.c"
		}
#line 395 "file_browser.vala"
		_tmp7_ = parent_dirs;
#line 395 "file_browser.vala"
		_tmp8_ = parent;
#line 395 "file_browser.vala"
		gee_list_insert (_tmp7_, 0, _tmp8_);
#line 396 "file_browser.vala"
		_tmp9_ = parent;
#line 396 "file_browser.vala"
		_tmp10_ = g_file_get_parent (_tmp9_);
#line 396 "file_browser.vala"
		_g_object_unref0 (parent);
#line 396 "file_browser.vala"
		parent = _tmp10_;
#line 1820 "file_browser.c"
	}
#line 399 "file_browser.vala"
	depth = 0;
#line 1824 "file_browser.c"
	{
		GeeList* _parent_dir_list = NULL;
		GeeList* _tmp11_;
		GeeList* _tmp12_;
		gint _parent_dir_size = 0;
		GeeList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _parent_dir_index = 0;
#line 400 "file_browser.vala"
		_tmp11_ = parent_dirs;
#line 400 "file_browser.vala"
		_tmp12_ = _g_object_ref0 (_tmp11_);
#line 400 "file_browser.vala"
		_parent_dir_list = _tmp12_;
#line 400 "file_browser.vala"
		_tmp13_ = _parent_dir_list;
#line 400 "file_browser.vala"
		_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
#line 400 "file_browser.vala"
		_tmp15_ = _tmp14_;
#line 400 "file_browser.vala"
		_parent_dir_size = _tmp15_;
#line 400 "file_browser.vala"
		_parent_dir_index = -1;
#line 400 "file_browser.vala"
		while (TRUE) {
#line 1852 "file_browser.c"
			GFile* parent_dir = NULL;
			GeeList* _tmp16_;
			gpointer _tmp17_;
			gchar* basename = NULL;
			gchar* pixbuf = NULL;
			GtkTreeIter iter = {0};
			GtkListStore* _tmp29_;
			GtkTreeIter _tmp30_ = {0};
			GtkListStore* _tmp31_;
			GtkTreeIter _tmp32_;
			GFile* _tmp33_;
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			gint _tmp36_;
#line 400 "file_browser.vala"
			_parent_dir_index = _parent_dir_index + 1;
#line 400 "file_browser.vala"
			if (!(_parent_dir_index < _parent_dir_size)) {
#line 400 "file_browser.vala"
				break;
#line 1873 "file_browser.c"
			}
#line 400 "file_browser.vala"
			_tmp16_ = _parent_dir_list;
#line 400 "file_browser.vala"
			_tmp17_ = gee_list_get (_tmp16_, _parent_dir_index);
#line 400 "file_browser.vala"
			parent_dir = (GFile*) _tmp17_;
#line 404 "file_browser.vala"
			if (depth == 0) {
#line 1883 "file_browser.c"
				gchar* _tmp18_;
#line 405 "file_browser.vala"
				_tmp18_ = g_strdup (_ ("File System"));
#line 405 "file_browser.vala"
				_g_free0 (basename);
#line 405 "file_browser.vala"
				basename = _tmp18_;
#line 1891 "file_browser.c"
			} else {
				GFile* _tmp19_;
				gchar* _tmp20_;
#line 407 "file_browser.vala"
				_tmp19_ = parent_dir;
#line 407 "file_browser.vala"
				_tmp20_ = g_file_get_basename (_tmp19_);
#line 407 "file_browser.vala"
				_g_free0 (basename);
#line 407 "file_browser.vala"
				basename = _tmp20_;
#line 1903 "file_browser.c"
			}
#line 411 "file_browser.vala"
			if (depth == 0) {
#line 1907 "file_browser.c"
				gchar* _tmp21_;
#line 412 "file_browser.vala"
				_tmp21_ = g_strdup ("drive-harddisk");
#line 412 "file_browser.vala"
				_g_free0 (pixbuf);
#line 412 "file_browser.vala"
				pixbuf = _tmp21_;
#line 1915 "file_browser.c"
			} else {
				const gchar* _tmp22_;
				GFile* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gboolean _tmp26_;
#line 413 "file_browser.vala"
				_tmp22_ = g_get_home_dir ();
#line 413 "file_browser.vala"
				_tmp23_ = parent_dir;
#line 413 "file_browser.vala"
				_tmp24_ = g_file_get_path (_tmp23_);
#line 413 "file_browser.vala"
				_tmp25_ = _tmp24_;
#line 413 "file_browser.vala"
				_tmp26_ = g_strcmp0 (_tmp22_, _tmp25_) == 0;
#line 413 "file_browser.vala"
				_g_free0 (_tmp25_);
#line 413 "file_browser.vala"
				if (_tmp26_) {
#line 1936 "file_browser.c"
					gchar* _tmp27_;
#line 414 "file_browser.vala"
					_tmp27_ = g_strdup ("go-home");
#line 414 "file_browser.vala"
					_g_free0 (pixbuf);
#line 414 "file_browser.vala"
					pixbuf = _tmp27_;
#line 1944 "file_browser.c"
				} else {
					gchar* _tmp28_;
#line 416 "file_browser.vala"
					_tmp28_ = g_strdup ("folder");
#line 416 "file_browser.vala"
					_g_free0 (pixbuf);
#line 416 "file_browser.vala"
					pixbuf = _tmp28_;
#line 1953 "file_browser.c"
				}
			}
#line 420 "file_browser.vala"
			_tmp29_ = self->priv->_parent_dir_store;
#line 420 "file_browser.vala"
			gtk_list_store_append (_tmp29_, &_tmp30_);
#line 420 "file_browser.vala"
			iter = _tmp30_;
#line 421 "file_browser.vala"
			_tmp31_ = self->priv->_parent_dir_store;
#line 421 "file_browser.vala"
			_tmp32_ = iter;
#line 421 "file_browser.vala"
			_tmp33_ = parent_dir;
#line 421 "file_browser.vala"
			_tmp34_ = basename;
#line 421 "file_browser.vala"
			_tmp35_ = pixbuf;
#line 421 "file_browser.vala"
			gtk_list_store_set (_tmp31_, &_tmp32_, FILE_BROWSER_PARENT_DIR_COLUMN_FILE, _tmp33_, FILE_BROWSER_PARENT_DIR_COLUMN_NAME, _tmp34_, FILE_BROWSER_PARENT_DIR_COLUMN_PIXBUF, _tmp35_, -1);
#line 427 "file_browser.vala"
			_tmp36_ = depth;
#line 427 "file_browser.vala"
			depth = _tmp36_ + 1;
#line 400 "file_browser.vala"
			_g_free0 (pixbuf);
#line 400 "file_browser.vala"
			_g_free0 (basename);
#line 400 "file_browser.vala"
			_g_object_unref0 (parent_dir);
#line 1984 "file_browser.c"
		}
#line 400 "file_browser.vala"
		_g_object_unref0 (_parent_dir_list);
#line 1988 "file_browser.c"
	}
#line 431 "file_browser.vala"
	_tmp37_ = self->priv->_combo_box;
#line 431 "file_browser.vala"
	gtk_combo_box_set_active (_tmp37_, depth - 1);
#line 385 "file_browser.vala"
	_g_object_unref0 (parent);
#line 385 "file_browser.vala"
	_g_object_unref0 (parent_dirs);
#line 1998 "file_browser.c"
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
#line 1232 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1233 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1233 "glib-2.0.vapi"
	result = _tmp0_;
#line 1233 "glib-2.0.vapi"
	return result;
#line 2015 "file_browser.c"
}

static void
file_browser_update_list (FileBrowser* self)
{
	GtkListStore* _tmp0_;
	GtkTreeView* _tmp1_;
	gboolean show_build_files = FALSE;
	GSettings* _tmp2_;
	gboolean show_hidden_files = FALSE;
	GSettings* _tmp3_;
	gchar* exts = NULL;
	GSettings* _tmp4_;
	gchar* _tmp5_;
	gchar** clean_extensions = NULL;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint clean_extensions_length1;
	gint _clean_extensions_size_;
	GFileEnumerator* enumerator = NULL;
	GtkListStore* _tmp38_;
	GError* _inner_error0_ = NULL;
#line 434 "file_browser.vala"
	g_return_if_fail (self != NULL);
#line 436 "file_browser.vala"
	_tmp0_ = self->priv->_list_store;
#line 436 "file_browser.vala"
	gtk_list_store_clear (_tmp0_);
#line 437 "file_browser.vala"
	_tmp1_ = self->priv->_list_view;
#line 437 "file_browser.vala"
	gtk_tree_view_columns_autosize (_tmp1_);
#line 441 "file_browser.vala"
	_tmp2_ = self->priv->_settings;
#line 441 "file_browser.vala"
	show_build_files = g_settings_get_boolean (_tmp2_, "show-build-files");
#line 442 "file_browser.vala"
	_tmp3_ = self->priv->_settings;
#line 442 "file_browser.vala"
	show_hidden_files = g_settings_get_boolean (_tmp3_, "show-hidden-files");
#line 444 "file_browser.vala"
	_tmp4_ = self->priv->_latex_settings;
#line 444 "file_browser.vala"
	_tmp5_ = g_settings_get_string (_tmp4_, "clean-extensions");
#line 444 "file_browser.vala"
	exts = _tmp5_;
#line 445 "file_browser.vala"
	_tmp6_ = exts;
#line 445 "file_browser.vala"
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, " ", 0);
#line 445 "file_browser.vala"
	clean_extensions = _tmp8_;
#line 445 "file_browser.vala"
	clean_extensions_length1 = _vala_array_length (_tmp7_);
#line 445 "file_browser.vala"
	_clean_extensions_size_ = clean_extensions_length1;
#line 2073 "file_browser.c"
	{
		GFileEnumerator* _tmp9_ = NULL;
		GFile* _tmp10_;
		GFileEnumerator* _tmp11_;
		GFileEnumerator* _tmp12_;
#line 452 "file_browser.vala"
		_tmp10_ = self->priv->_current_directory;
#line 452 "file_browser.vala"
		_tmp11_ = g_file_enumerate_children (_tmp10_, "standard::type,standard::display-name", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
#line 452 "file_browser.vala"
		_tmp9_ = _tmp11_;
#line 452 "file_browser.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2087 "file_browser.c"
			goto __catch0_g_error;
		}
#line 452 "file_browser.vala"
		_tmp12_ = _tmp9_;
#line 452 "file_browser.vala"
		_tmp9_ = NULL;
#line 452 "file_browser.vala"
		_g_object_unref0 (enumerator);
#line 452 "file_browser.vala"
		enumerator = _tmp12_;
#line 450 "file_browser.vala"
		_g_object_unref0 (_tmp9_);
#line 2100 "file_browser.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp13_;
#line 450 "file_browser.vala"
		_error_ = _inner_error0_;
#line 450 "file_browser.vala"
		_inner_error0_ = NULL;
#line 457 "file_browser.vala"
		_tmp13_ = _error_;
#line 457 "file_browser.vala"
		file_browser_handle_error (self, _tmp13_);
#line 458 "file_browser.vala"
		_g_error_free0 (_error_);
#line 458 "file_browser.vala"
		_g_object_unref0 (enumerator);
#line 458 "file_browser.vala"
		clean_extensions = (_vala_array_free (clean_extensions, clean_extensions_length1, (GDestroyNotify) g_free), NULL);
#line 458 "file_browser.vala"
		_g_free0 (exts);
#line 458 "file_browser.vala"
		return;
#line 2125 "file_browser.c"
	}
	__finally0:
#line 450 "file_browser.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 450 "file_browser.vala"
		_g_object_unref0 (enumerator);
#line 450 "file_browser.vala"
		clean_extensions = (_vala_array_free (clean_extensions, clean_extensions_length1, (GDestroyNotify) g_free), NULL);
#line 450 "file_browser.vala"
		_g_free0 (exts);
#line 450 "file_browser.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 450 "file_browser.vala"
		g_clear_error (&_inner_error0_);
#line 450 "file_browser.vala"
		return;
#line 2142 "file_browser.c"
	}
#line 463 "file_browser.vala"
	while (TRUE) {
#line 2146 "file_browser.c"
		GFileInfo* info = NULL;
		GFileInfo* _tmp19_;
		gchar* basename = NULL;
		GFileInfo* _tmp20_;
		const gchar* _tmp21_;
		gchar* _tmp22_;
		gboolean _tmp23_ = FALSE;
		const gchar* _tmp24_;
		GFileType type = 0;
		GFileInfo* _tmp25_;
		GFileType _tmp26_;
		gchar* extension = NULL;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* icon_name = NULL;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		{
			GFileInfo* _tmp14_ = NULL;
			GFileEnumerator* _tmp15_;
			GFileInfo* _tmp16_;
			GFileInfo* _tmp17_;
#line 468 "file_browser.vala"
			_tmp15_ = enumerator;
#line 468 "file_browser.vala"
			_tmp16_ = g_file_enumerator_next_file (_tmp15_, NULL, &_inner_error0_);
#line 468 "file_browser.vala"
			_tmp14_ = _tmp16_;
#line 468 "file_browser.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2179 "file_browser.c"
				goto __catch1_g_error;
			}
#line 468 "file_browser.vala"
			_tmp17_ = _tmp14_;
#line 468 "file_browser.vala"
			_tmp14_ = NULL;
#line 468 "file_browser.vala"
			_g_object_unref0 (info);
#line 468 "file_browser.vala"
			info = _tmp17_;
#line 466 "file_browser.vala"
			_g_object_unref0 (_tmp14_);
#line 2192 "file_browser.c"
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* _error_ = NULL;
			GError* _tmp18_;
#line 466 "file_browser.vala"
			_error_ = _inner_error0_;
#line 466 "file_browser.vala"
			_inner_error0_ = NULL;
#line 472 "file_browser.vala"
			_tmp18_ = _error_;
#line 472 "file_browser.vala"
			file_browser_handle_error (self, _tmp18_);
#line 473 "file_browser.vala"
			_g_error_free0 (_error_);
#line 473 "file_browser.vala"
			_g_object_unref0 (info);
#line 473 "file_browser.vala"
			_g_object_unref0 (enumerator);
#line 473 "file_browser.vala"
			clean_extensions = (_vala_array_free (clean_extensions, clean_extensions_length1, (GDestroyNotify) g_free), NULL);
#line 473 "file_browser.vala"
			_g_free0 (exts);
#line 473 "file_browser.vala"
			return;
#line 2219 "file_browser.c"
		}
		__finally1:
#line 466 "file_browser.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 466 "file_browser.vala"
			_g_object_unref0 (info);
#line 466 "file_browser.vala"
			_g_object_unref0 (enumerator);
#line 466 "file_browser.vala"
			clean_extensions = (_vala_array_free (clean_extensions, clean_extensions_length1, (GDestroyNotify) g_free), NULL);
#line 466 "file_browser.vala"
			_g_free0 (exts);
#line 466 "file_browser.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 466 "file_browser.vala"
			g_clear_error (&_inner_error0_);
#line 466 "file_browser.vala"
			return;
#line 2238 "file_browser.c"
		}
#line 476 "file_browser.vala"
		_tmp19_ = info;
#line 476 "file_browser.vala"
		if (_tmp19_ == NULL) {
#line 477 "file_browser.vala"
			_g_object_unref0 (info);
#line 477 "file_browser.vala"
			break;
#line 2248 "file_browser.c"
		}
#line 479 "file_browser.vala"
		_tmp20_ = info;
#line 479 "file_browser.vala"
		_tmp21_ = g_file_info_get_display_name (_tmp20_);
#line 479 "file_browser.vala"
		_tmp22_ = g_strdup (_tmp21_);
#line 479 "file_browser.vala"
		basename = _tmp22_;
#line 480 "file_browser.vala"
		_tmp24_ = basename;
#line 480 "file_browser.vala"
		if (string_get (_tmp24_, (glong) 0) == '.') {
#line 480 "file_browser.vala"
			_tmp23_ = !show_hidden_files;
#line 2264 "file_browser.c"
		} else {
#line 480 "file_browser.vala"
			_tmp23_ = FALSE;
#line 2268 "file_browser.c"
		}
#line 480 "file_browser.vala"
		if (_tmp23_) {
#line 481 "file_browser.vala"
			_g_free0 (basename);
#line 481 "file_browser.vala"
			_g_object_unref0 (info);
#line 481 "file_browser.vala"
			continue;
#line 2278 "file_browser.c"
		}
#line 483 "file_browser.vala"
		_tmp25_ = info;
#line 483 "file_browser.vala"
		type = g_file_info_get_file_type (_tmp25_);
#line 484 "file_browser.vala"
		_tmp26_ = type;
#line 484 "file_browser.vala"
		if (_tmp26_ == G_FILE_TYPE_DIRECTORY) {
#line 2288 "file_browser.c"
			const gchar* _tmp27_;
#line 486 "file_browser.vala"
			_tmp27_ = basename;
#line 486 "file_browser.vala"
			file_browser_insert_file (self, TRUE, "folder", _tmp27_);
#line 487 "file_browser.vala"
			_g_free0 (basename);
#line 487 "file_browser.vala"
			_g_object_unref0 (info);
#line 487 "file_browser.vala"
			continue;
#line 2300 "file_browser.c"
		}
#line 490 "file_browser.vala"
		if (!show_build_files) {
#line 2304 "file_browser.c"
			gboolean is_build_file = FALSE;
			gchar** _tmp28_;
			gint _tmp28__length1;
#line 492 "file_browser.vala"
			is_build_file = FALSE;
#line 494 "file_browser.vala"
			_tmp28_ = clean_extensions;
#line 494 "file_browser.vala"
			_tmp28__length1 = clean_extensions_length1;
#line 2314 "file_browser.c"
			{
				gchar** ext_collection = NULL;
				gint ext_collection_length1 = 0;
				gint _ext_collection_size_ = 0;
				gint ext_it = 0;
#line 494 "file_browser.vala"
				ext_collection = _tmp28_;
#line 494 "file_browser.vala"
				ext_collection_length1 = _tmp28__length1;
#line 494 "file_browser.vala"
				for (ext_it = 0; ext_it < ext_collection_length1; ext_it = ext_it + 1) {
#line 2326 "file_browser.c"
					gchar* _tmp29_;
					gchar* ext = NULL;
#line 494 "file_browser.vala"
					_tmp29_ = g_strdup (ext_collection[ext_it]);
#line 494 "file_browser.vala"
					ext = _tmp29_;
#line 2333 "file_browser.c"
					{
						const gchar* _tmp30_;
						const gchar* _tmp31_;
#line 496 "file_browser.vala"
						_tmp30_ = basename;
#line 496 "file_browser.vala"
						_tmp31_ = ext;
#line 496 "file_browser.vala"
						if (g_str_has_suffix (_tmp30_, _tmp31_)) {
#line 498 "file_browser.vala"
							is_build_file = TRUE;
#line 499 "file_browser.vala"
							_g_free0 (ext);
#line 499 "file_browser.vala"
							break;
#line 2349 "file_browser.c"
						}
#line 494 "file_browser.vala"
						_g_free0 (ext);
#line 2353 "file_browser.c"
					}
				}
			}
#line 503 "file_browser.vala"
			if (is_build_file) {
#line 504 "file_browser.vala"
				_g_free0 (basename);
#line 504 "file_browser.vala"
				_g_object_unref0 (info);
#line 504 "file_browser.vala"
				continue;
#line 2365 "file_browser.c"
			}
		}
#line 507 "file_browser.vala"
		_tmp32_ = basename;
#line 507 "file_browser.vala"
		_tmp33_ = tepl_utils_get_file_extension (_tmp32_);
#line 507 "file_browser.vala"
		extension = _tmp33_;
#line 508 "file_browser.vala"
		_tmp34_ = extension;
#line 508 "file_browser.vala"
		_tmp35_ = file_browser_get_extension_icon_name (self, _tmp34_);
#line 508 "file_browser.vala"
		icon_name = _tmp35_;
#line 509 "file_browser.vala"
		_tmp36_ = icon_name;
#line 509 "file_browser.vala"
		_tmp37_ = basename;
#line 509 "file_browser.vala"
		file_browser_insert_file (self, FALSE, _tmp36_, _tmp37_);
#line 463 "file_browser.vala"
		_g_free0 (icon_name);
#line 463 "file_browser.vala"
		_g_free0 (extension);
#line 463 "file_browser.vala"
		_g_free0 (basename);
#line 463 "file_browser.vala"
		_g_object_unref0 (info);
#line 2394 "file_browser.c"
	}
#line 512 "file_browser.vala"
	_tmp38_ = self->priv->_list_store;
#line 512 "file_browser.vala"
	gtk_tree_sortable_sort_column_changed ((GtkTreeSortable*) _tmp38_);
#line 434 "file_browser.vala"
	_g_object_unref0 (enumerator);
#line 434 "file_browser.vala"
	clean_extensions = (_vala_array_free (clean_extensions, clean_extensions_length1, (GDestroyNotify) g_free), NULL);
#line 434 "file_browser.vala"
	_g_free0 (exts);
#line 2406 "file_browser.c"
}

static void
file_browser_handle_error (FileBrowser* self,
                           GError* _error_)
{
	const gchar* _tmp0_;
	GtkMessageDialog* dialog = NULL;
	MainWindow* _tmp1_;
	GtkMessageDialog* _tmp2_;
	const gchar* _tmp3_;
#line 515 "file_browser.vala"
	g_return_if_fail (self != NULL);
#line 515 "file_browser.vala"
	g_return_if_fail (_error_ != NULL);
#line 517 "file_browser.vala"
	_tmp0_ = _error_->message;
#line 517 "file_browser.vala"
	g_warning ("file_browser.vala:517: File browser: %s", _tmp0_);
#line 520 "file_browser.vala"
	_tmp1_ = self->priv->_main_window;
#line 520 "file_browser.vala"
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp1_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_WARNING, GTK_BUTTONS_CLOSE, "%s", _ ("File Browser"));
#line 520 "file_browser.vala"
	g_object_ref_sink (_tmp2_);
#line 520 "file_browser.vala"
	dialog = _tmp2_;
#line 526 "file_browser.vala"
	_tmp3_ = _error_->message;
#line 526 "file_browser.vala"
	gtk_message_dialog_format_secondary_text (dialog, "%s", _tmp3_);
#line 527 "file_browser.vala"
	gtk_dialog_run ((GtkDialog*) dialog);
#line 528 "file_browser.vala"
	gtk_widget_destroy ((GtkWidget*) dialog);
#line 515 "file_browser.vala"
	_g_object_unref0 (dialog);
#line 2444 "file_browser.c"
}

static void
file_browser_insert_file (FileBrowser* self,
                          gboolean is_dir,
                          const gchar* icon_name,
                          const gchar* basename)
{
	GtkTreeIter iter = {0};
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_;
#line 531 "file_browser.vala"
	g_return_if_fail (self != NULL);
#line 531 "file_browser.vala"
	g_return_if_fail (icon_name != NULL);
#line 531 "file_browser.vala"
	g_return_if_fail (basename != NULL);
#line 534 "file_browser.vala"
	_tmp0_ = self->priv->_list_store;
#line 534 "file_browser.vala"
	gtk_list_store_append (_tmp0_, &_tmp1_);
#line 534 "file_browser.vala"
	iter = _tmp1_;
#line 535 "file_browser.vala"
	_tmp2_ = self->priv->_list_store;
#line 535 "file_browser.vala"
	_tmp3_ = iter;
#line 535 "file_browser.vala"
	gtk_list_store_set (_tmp2_, &_tmp3_, FILE_BROWSER_FILE_COLUMN_IS_DIR, is_dir, FILE_BROWSER_FILE_COLUMN_PIXBUF, icon_name, FILE_BROWSER_FILE_COLUMN_NAME, basename, -1);
#line 2476 "file_browser.c"
}

static void
_file_browser_refresh_g_file_monitor_changed (GFileMonitor* _sender,
                                              GFile* file,
                                              GFile* other_file,
                                              GFileMonitorEvent event_type,
                                              gpointer self)
{
#line 560 "file_browser.vala"
	file_browser_refresh ((FileBrowser*) self);
#line 2488 "file_browser.c"
}

static void
file_browser_monitor_directory (FileBrowser* self)
{
	GFile* _tmp0_;
	GFileMonitor* _tmp7_;
	GError* _inner_error0_ = NULL;
#line 542 "file_browser.vala"
	g_return_if_fail (self != NULL);
#line 544 "file_browser.vala"
	_tmp0_ = self->priv->_current_directory;
#line 544 "file_browser.vala"
	if (_tmp0_ == NULL) {
#line 546 "file_browser.vala"
		_g_object_unref0 (self->priv->_monitor);
#line 546 "file_browser.vala"
		self->priv->_monitor = NULL;
#line 547 "file_browser.vala"
		return;
#line 2509 "file_browser.c"
	}
	{
		GFileMonitor* _tmp1_ = NULL;
		GFile* _tmp2_;
		GFileMonitor* _tmp3_;
		GFileMonitor* _tmp4_;
#line 552 "file_browser.vala"
		_tmp2_ = self->priv->_current_directory;
#line 552 "file_browser.vala"
		_tmp3_ = g_file_monitor_directory (_tmp2_, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
#line 552 "file_browser.vala"
		_tmp1_ = _tmp3_;
#line 552 "file_browser.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 552 "file_browser.vala"
			if (_inner_error0_->domain == G_IO_ERROR) {
#line 2526 "file_browser.c"
				goto __catch0_g_io_error;
			}
#line 552 "file_browser.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 552 "file_browser.vala"
			g_clear_error (&_inner_error0_);
#line 552 "file_browser.vala"
			return;
#line 2535 "file_browser.c"
		}
#line 552 "file_browser.vala"
		_tmp4_ = _tmp1_;
#line 552 "file_browser.vala"
		_tmp1_ = NULL;
#line 552 "file_browser.vala"
		_g_object_unref0 (self->priv->_monitor);
#line 552 "file_browser.vala"
		self->priv->_monitor = _tmp4_;
#line 550 "file_browser.vala"
		_g_object_unref0 (_tmp1_);
#line 2547 "file_browser.c"
	}
	goto __finally0;
	__catch0_g_io_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
#line 550 "file_browser.vala"
		e = _inner_error0_;
#line 550 "file_browser.vala"
		_inner_error0_ = NULL;
#line 556 "file_browser.vala"
		_tmp5_ = e;
#line 556 "file_browser.vala"
		_tmp6_ = _tmp5_->message;
#line 556 "file_browser.vala"
		g_warning ("file_browser.vala:556: Can not refresh automatically the file browser:" \
" %s", _tmp6_);
#line 557 "file_browser.vala"
		_g_error_free0 (e);
#line 557 "file_browser.vala"
		return;
#line 2569 "file_browser.c"
	}
	__finally0:
#line 550 "file_browser.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 550 "file_browser.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 550 "file_browser.vala"
		g_clear_error (&_inner_error0_);
#line 550 "file_browser.vala"
		return;
#line 2580 "file_browser.c"
	}
#line 560 "file_browser.vala"
	_tmp7_ = self->priv->_monitor;
#line 560 "file_browser.vala"
	g_signal_connect_object (_tmp7_, "changed", (GCallback) _file_browser_refresh_g_file_monitor_changed, self, 0);
#line 2586 "file_browser.c"
}

/*************************************************************************/
static void
file_browser_refresh (FileBrowser* self)
{
	GFile* _tmp0_;
#line 566 "file_browser.vala"
	g_return_if_fail (self != NULL);
#line 568 "file_browser.vala"
	_tmp0_ = self->priv->_current_directory;
#line 568 "file_browser.vala"
	file_browser_set_directory (self, _tmp0_, TRUE);
#line 2600 "file_browser.c"
}

static gboolean
__lambda68_ (FileBrowser* self)
{
	gboolean result = FALSE;
#line 581 "file_browser.vala"
	self->priv->_timeout_id = (guint) 0;
#line 582 "file_browser.vala"
	file_browser_refresh (self);
#line 583 "file_browser.vala"
	result = FALSE;
#line 583 "file_browser.vala"
	return result;
#line 2615 "file_browser.c"
}

static gboolean
___lambda68__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda68_ ((FileBrowser*) self);
#line 579 "file_browser.vala"
	return result;
#line 2625 "file_browser.c"
}

static void
file_browser_delayed_refresh (FileBrowser* self)
{
#line 571 "file_browser.vala"
	g_return_if_fail (self != NULL);
#line 576 "file_browser.vala"
	if (self->priv->_timeout_id != ((guint) 0)) {
#line 577 "file_browser.vala"
		g_source_remove (self->priv->_timeout_id);
#line 2637 "file_browser.c"
	}
#line 579 "file_browser.vala"
	self->priv->_timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ___lambda68__gsource_func, g_object_ref (self), g_object_unref);
#line 2641 "file_browser.c"
}

static GFile*
file_browser_get_default_directory (FileBrowser* self)
{
	gchar* uri = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	const gchar* _tmp8_;
	GFile* _tmp9_;
	GFile* result = NULL;
#line 589 "file_browser.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 591 "file_browser.vala"
	_tmp0_ = self->priv->_settings;
#line 591 "file_browser.vala"
	_tmp1_ = g_settings_get_string (_tmp0_, "current-directory");
#line 591 "file_browser.vala"
	uri = _tmp1_;
#line 593 "file_browser.vala"
	_tmp3_ = uri;
#line 593 "file_browser.vala"
	if (_tmp3_ != NULL) {
#line 2667 "file_browser.c"
		const gchar* _tmp4_;
#line 593 "file_browser.vala"
		_tmp4_ = uri;
#line 593 "file_browser.vala"
		_tmp2_ = g_strcmp0 (_tmp4_, "") != 0;
#line 2673 "file_browser.c"
	} else {
#line 593 "file_browser.vala"
		_tmp2_ = FALSE;
#line 2677 "file_browser.c"
	}
#line 593 "file_browser.vala"
	if (_tmp2_) {
#line 2681 "file_browser.c"
		GFile* directory = NULL;
		const gchar* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
#line 595 "file_browser.vala"
		_tmp5_ = uri;
#line 595 "file_browser.vala"
		_tmp6_ = g_file_new_for_uri (_tmp5_);
#line 595 "file_browser.vala"
		directory = _tmp6_;
#line 597 "file_browser.vala"
		_tmp7_ = directory;
#line 597 "file_browser.vala"
		if (g_file_query_exists (_tmp7_, NULL)) {
#line 598 "file_browser.vala"
			result = directory;
#line 598 "file_browser.vala"
			_g_free0 (uri);
#line 598 "file_browser.vala"
			return result;
#line 2702 "file_browser.c"
		}
#line 593 "file_browser.vala"
		_g_object_unref0 (directory);
#line 2706 "file_browser.c"
	}
#line 601 "file_browser.vala"
	_tmp8_ = g_get_home_dir ();
#line 601 "file_browser.vala"
	_tmp9_ = g_file_new_for_path (_tmp8_);
#line 601 "file_browser.vala"
	result = _tmp9_;
#line 601 "file_browser.vala"
	_g_free0 (uri);
#line 601 "file_browser.vala"
	return result;
#line 2718 "file_browser.c"
}

static void
file_browser_set_directory (FileBrowser* self,
                            GFile* directory,
                            gboolean force)
{
	gboolean _tmp0_ = FALSE;
	GFile* _tmp2_;
	GSettings* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkToolButton* _tmp6_;
	GFile* _tmp7_;
	GFile* _tmp8_;
#line 604 "file_browser.vala"
	g_return_if_fail (self != NULL);
#line 604 "file_browser.vala"
	g_return_if_fail (directory != NULL);
#line 606 "file_browser.vala"
	if (!force) {
#line 2740 "file_browser.c"
		GFile* _tmp1_;
#line 606 "file_browser.vala"
		_tmp1_ = self->priv->_current_directory;
#line 606 "file_browser.vala"
		_tmp0_ = _tmp1_ == directory;
#line 2746 "file_browser.c"
	} else {
#line 606 "file_browser.vala"
		_tmp0_ = FALSE;
#line 2750 "file_browser.c"
	}
#line 606 "file_browser.vala"
	if (_tmp0_) {
#line 607 "file_browser.vala"
		return;
#line 2756 "file_browser.c"
	}
#line 609 "file_browser.vala"
	_tmp2_ = _g_object_ref0 (directory);
#line 609 "file_browser.vala"
	_g_object_unref0 (self->priv->_current_directory);
#line 609 "file_browser.vala"
	self->priv->_current_directory = _tmp2_;
#line 610 "file_browser.vala"
	_tmp3_ = self->priv->_settings;
#line 610 "file_browser.vala"
	_tmp4_ = g_file_get_uri (directory);
#line 610 "file_browser.vala"
	_tmp5_ = _tmp4_;
#line 610 "file_browser.vala"
	g_settings_set_string (_tmp3_, "current-directory", _tmp5_);
#line 610 "file_browser.vala"
	_g_free0 (_tmp5_);
#line 611 "file_browser.vala"
	_tmp6_ = self->priv->_parent_button;
#line 611 "file_browser.vala"
	_tmp7_ = g_file_get_parent (directory);
#line 611 "file_browser.vala"
	_tmp8_ = _tmp7_;
#line 611 "file_browser.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp6_, _tmp8_ != NULL);
#line 611 "file_browser.vala"
	_g_object_unref0 (_tmp8_);
#line 613 "file_browser.vala"
	file_browser_update_parent_directories (self);
#line 614 "file_browser.vala"
	file_browser_update_list (self);
#line 615 "file_browser.vala"
	file_browser_monitor_directory (self);
#line 2790 "file_browser.c"
}

static gint
file_browser_on_sort (FileBrowser* self,
                      GtkTreeModel* model,
                      GtkTreeIter* a,
                      GtkTreeIter* b)
{
	gboolean a_is_dir = FALSE;
	gboolean b_is_dir = FALSE;
	GtkTreeIter _tmp0_;
	gboolean _tmp1_ = FALSE;
	GtkTreeIter _tmp2_;
	gboolean _tmp3_ = FALSE;
	gint _tmp10_ = 0;
	gint result = 0;
#line 618 "file_browser.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 618 "file_browser.vala"
	g_return_val_if_fail (model != NULL, 0);
#line 618 "file_browser.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 618 "file_browser.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 621 "file_browser.vala"
	_tmp0_ = *a;
#line 621 "file_browser.vala"
	gtk_tree_model_get (model, &_tmp0_, FILE_BROWSER_FILE_COLUMN_IS_DIR, &_tmp1_, -1);
#line 621 "file_browser.vala"
	a_is_dir = _tmp1_;
#line 622 "file_browser.vala"
	_tmp2_ = *b;
#line 622 "file_browser.vala"
	gtk_tree_model_get (model, &_tmp2_, FILE_BROWSER_FILE_COLUMN_IS_DIR, &_tmp3_, -1);
#line 622 "file_browser.vala"
	b_is_dir = _tmp3_;
#line 624 "file_browser.vala"
	if (a_is_dir == b_is_dir) {
#line 2829 "file_browser.c"
		gchar* a_name = NULL;
		gchar* b_name = NULL;
		GtkTreeIter _tmp4_;
		gchar* _tmp5_ = NULL;
		GtkTreeIter _tmp6_;
		gchar* _tmp7_ = NULL;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
#line 627 "file_browser.vala"
		_tmp4_ = *a;
#line 627 "file_browser.vala"
		gtk_tree_model_get (model, &_tmp4_, FILE_BROWSER_FILE_COLUMN_NAME, &_tmp5_, -1);
#line 627 "file_browser.vala"
		_g_free0 (a_name);
#line 627 "file_browser.vala"
		a_name = _tmp5_;
#line 628 "file_browser.vala"
		_tmp6_ = *b;
#line 628 "file_browser.vala"
		gtk_tree_model_get (model, &_tmp6_, FILE_BROWSER_FILE_COLUMN_NAME, &_tmp7_, -1);
#line 628 "file_browser.vala"
		_g_free0 (b_name);
#line 628 "file_browser.vala"
		b_name = _tmp7_;
#line 629 "file_browser.vala"
		_tmp8_ = a_name;
#line 629 "file_browser.vala"
		_tmp9_ = b_name;
#line 629 "file_browser.vala"
		result = g_utf8_collate (_tmp8_, _tmp9_);
#line 629 "file_browser.vala"
		_g_free0 (b_name);
#line 629 "file_browser.vala"
		_g_free0 (a_name);
#line 629 "file_browser.vala"
		return result;
#line 2866 "file_browser.c"
	}
#line 632 "file_browser.vala"
	if (a_is_dir) {
#line 632 "file_browser.vala"
		_tmp10_ = -1;
#line 2872 "file_browser.c"
	} else {
#line 632 "file_browser.vala"
		_tmp10_ = 1;
#line 2876 "file_browser.c"
	}
#line 632 "file_browser.vala"
	result = _tmp10_;
#line 632 "file_browser.vala"
	return result;
#line 2882 "file_browser.c"
}

static gchar*
file_browser_get_extension_icon_name (FileBrowser* self,
                                      const gchar* file_extension)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
#line 637 "file_browser.vala"
	static GQuark _tmp1_label0 = 0;
#line 637 "file_browser.vala"
	static GQuark _tmp1_label1 = 0;
#line 637 "file_browser.vala"
	static GQuark _tmp1_label2 = 0;
#line 637 "file_browser.vala"
	static GQuark _tmp1_label3 = 0;
#line 637 "file_browser.vala"
	static GQuark _tmp1_label4 = 0;
#line 637 "file_browser.vala"
	static GQuark _tmp1_label5 = 0;
#line 637 "file_browser.vala"
	static GQuark _tmp1_label6 = 0;
#line 637 "file_browser.vala"
	static GQuark _tmp1_label7 = 0;
#line 637 "file_browser.vala"
	static GQuark _tmp1_label8 = 0;
#line 637 "file_browser.vala"
	static GQuark _tmp1_label9 = 0;
#line 637 "file_browser.vala"
	static GQuark _tmp1_label10 = 0;
#line 637 "file_browser.vala"
	static GQuark _tmp1_label11 = 0;
#line 2915 "file_browser.c"
	gchar* result = NULL;
#line 635 "file_browser.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 635 "file_browser.vala"
	g_return_val_if_fail (file_extension != NULL, NULL);
#line 637 "file_browser.vala"
	_tmp0_ = file_extension;
#line 637 "file_browser.vala"
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
#line 637 "file_browser.vala"
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string (".tex")))) {
#line 637 "file_browser.vala"
		switch (0) {
#line 2929 "file_browser.c"
			default:
			{
				gchar* _tmp3_;
#line 640 "file_browser.vala"
				_tmp3_ = g_strdup (GTK_STOCK_EDIT);
#line 640 "file_browser.vala"
				result = _tmp3_;
#line 640 "file_browser.vala"
				return result;
#line 2939 "file_browser.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string (".pdf")))) {
#line 637 "file_browser.vala"
		switch (0) {
#line 2945 "file_browser.c"
			default:
			{
				gchar* _tmp4_;
#line 643 "file_browser.vala"
				_tmp4_ = g_strdup ("latexila-pdf");
#line 643 "file_browser.vala"
				result = _tmp4_;
#line 643 "file_browser.vala"
				return result;
#line 2955 "file_browser.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string (".dvi")))) {
#line 637 "file_browser.vala"
		switch (0) {
#line 2961 "file_browser.c"
			default:
			{
				gchar* _tmp5_;
#line 646 "file_browser.vala"
				_tmp5_ = g_strdup ("latexila-dvi");
#line 646 "file_browser.vala"
				result = _tmp5_;
#line 646 "file_browser.vala"
				return result;
#line 2971 "file_browser.c"
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string (".ps")))) || (_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string (".eps"))))) {
#line 637 "file_browser.vala"
		switch (0) {
#line 2977 "file_browser.c"
			default:
			{
				gchar* _tmp6_;
#line 650 "file_browser.vala"
				_tmp6_ = g_strdup ("latexila-ps");
#line 650 "file_browser.vala"
				result = _tmp6_;
#line 650 "file_browser.vala"
				return result;
#line 2987 "file_browser.c"
			}
		}
	} else if (((((((_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string (".png")))) || (_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string (".jpg"))))) || (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string (".jpeg"))))) || (_tmp2_ == ((0 != _tmp1_label8) ? _tmp1_label8 : (_tmp1_label8 = g_quark_from_static_string (".gif"))))) || (_tmp2_ == ((0 != _tmp1_label9) ? _tmp1_label9 : (_tmp1_label9 = g_quark_from_static_string (".bmp"))))) || (_tmp2_ == ((0 != _tmp1_label10) ? _tmp1_label10 : (_tmp1_label10 = g_quark_from_static_string (".tif"))))) || (_tmp2_ == ((0 != _tmp1_label11) ? _tmp1_label11 : (_tmp1_label11 = g_quark_from_static_string (".tiff"))))) {
#line 637 "file_browser.vala"
		switch (0) {
#line 2993 "file_browser.c"
			default:
			{
				gchar* _tmp7_;
#line 659 "file_browser.vala"
				_tmp7_ = g_strdup ("image-x-generic");
#line 659 "file_browser.vala"
				result = _tmp7_;
#line 659 "file_browser.vala"
				return result;
#line 3003 "file_browser.c"
			}
		}
	} else {
#line 637 "file_browser.vala"
		switch (0) {
#line 3009 "file_browser.c"
			default:
			{
				gchar* _tmp8_;
#line 662 "file_browser.vala"
				_tmp8_ = g_strdup ("text-x-generic");
#line 662 "file_browser.vala"
				result = _tmp8_;
#line 662 "file_browser.vala"
				return result;
#line 3019 "file_browser.c"
			}
		}
	}
}

static void
file_browser_class_init (FileBrowserClass * klass,
                         gpointer klass_data)
{
#line 22 "file_browser.vala"
	file_browser_parent_class = g_type_class_peek_parent (klass);
#line 22 "file_browser.vala"
	g_type_class_adjust_private_offset (klass, &FileBrowser_private_offset);
#line 22 "file_browser.vala"
	G_OBJECT_CLASS (klass)->finalize = file_browser_finalize;
#line 3035 "file_browser.c"
}

static void
file_browser_instance_init (FileBrowser * self,
                            gpointer klass)
{
#line 22 "file_browser.vala"
	self->priv = file_browser_get_instance_private (self);
#line 54 "file_browser.vala"
	self->priv->_timeout_id = (guint) 0;
#line 3046 "file_browser.c"
}

static void
file_browser_finalize (GObject * obj)
{
	FileBrowser * self;
#line 22 "file_browser.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FILE_BROWSER, FileBrowser);
#line 42 "file_browser.vala"
	_g_object_unref0 (self->priv->_parent_dir_store);
#line 43 "file_browser.vala"
	_g_object_unref0 (self->priv->_combo_box);
#line 45 "file_browser.vala"
	_g_object_unref0 (self->priv->_list_store);
#line 46 "file_browser.vala"
	_g_object_unref0 (self->priv->_list_view);
#line 48 "file_browser.vala"
	_g_object_unref0 (self->priv->_current_directory);
#line 49 "file_browser.vala"
	_g_object_unref0 (self->priv->_monitor);
#line 51 "file_browser.vala"
	_g_object_unref0 (self->priv->_parent_button);
#line 52 "file_browser.vala"
	_g_object_unref0 (self->priv->_settings);
#line 53 "file_browser.vala"
	_g_object_unref0 (self->priv->_latex_settings);
#line 22 "file_browser.vala"
	G_OBJECT_CLASS (file_browser_parent_class)->finalize (obj);
#line 3075 "file_browser.c"
}

static GType
file_browser_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FileBrowserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) file_browser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FileBrowser), 0, (GInstanceInitFunc) file_browser_instance_init, NULL };
	GType file_browser_type_id;
	file_browser_type_id = g_type_register_static (gtk_grid_get_type (), "FileBrowser", &g_define_type_info, 0);
	FileBrowser_private_offset = g_type_add_instance_private (file_browser_type_id, sizeof (FileBrowserPrivate));
	return file_browser_type_id;
}

GType
file_browser_get_type (void)
{
	static volatile gsize file_browser_type_id__volatile = 0;
	if (g_once_init_enter (&file_browser_type_id__volatile)) {
		GType file_browser_type_id;
		file_browser_type_id = file_browser_get_type_once ();
		g_once_init_leave (&file_browser_type_id__volatile, file_browser_type_id);
	}
	return file_browser_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
#line 27 "build_tools_preferences.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 3107 "file_browser.c"
		gint i;
#line 27 "build_tools_preferences.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 27 "build_tools_preferences.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 27 "build_tools_preferences.vala"
				destroy_func (((gpointer*) array)[i]);
#line 3115 "file_browser.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
#line 27 "build_tools_preferences.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 27 "build_tools_preferences.vala"
	g_free (array);
#line 3130 "file_browser.c"
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
#line 27 "build_tools_preferences.vala"
	if (array) {
#line 27 "build_tools_preferences.vala"
		while (((gpointer*) array)[length]) {
#line 27 "build_tools_preferences.vala"
			length++;
#line 3144 "file_browser.c"
		}
	}
#line 27 "build_tools_preferences.vala"
	return length;
#line 3149 "file_browser.c"
}

