/* document_view.c generated by valac 0.48.9, the Vala compiler
 * generated from document_view.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2020 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <tepl/tepl.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <pango/pango.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <latexila.h>
#include <gtksourceview/gtksource.h>
#include <gdk/gdk.h>
#include <gspell/gspell.h>
#include <glib/gi18n-lib.h>

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
typedef struct _DocumentViewPrivate DocumentViewPrivate;
enum  {
	DOCUMENT_VIEW_0_PROPERTY,
	DOCUMENT_VIEW_NUM_PROPERTIES
};
static GParamSpec* document_view_properties[DOCUMENT_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_COMPLETION_PROVIDER (completion_provider_get_type ())
#define COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_PROVIDER, CompletionProvider))
#define COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))
#define IS_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_PROVIDER))
#define IS_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_PROVIDER))
#define COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))

typedef struct _CompletionProvider CompletionProvider;
typedef struct _CompletionProviderClass CompletionProviderClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block18Data Block18Data;

struct _DocumentView {
	TeplView parent_instance;
	DocumentViewPrivate * priv;
};

struct _DocumentViewClass {
	TeplViewClass parent_class;
};

struct _DocumentViewPrivate {
	GSettings* _editor_settings;
	PangoFontDescription* _font_desc;
};

struct _Block18Data {
	int _ref_count_;
	DocumentView* self;
	GspellChecker* spell_checker;
};

static gint DocumentView_private_offset;
static gpointer document_view_parent_class = NULL;
static gboolean document_view__no_spell_language_dialog_shown;
static gboolean document_view__no_spell_language_dialog_shown = FALSE;

GType document_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentView, g_object_unref)
#define DOCUMENT_VIEW_METADATA_KEY_SPELL_LANGUAGE "gnome-latex-spell-language"
#define DOCUMENT_VIEW_METADATA_KEY_INLINE_SPELL "gnome-latex-inline-spell"
#define DOCUMENT_VIEW_INLINE_SPELL_ENABLED_STR "1"
#define DOCUMENT_VIEW_INLINE_SPELL_DISABLED_STR "0"
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
GType document_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
DocumentView* document_view_new (Document* doc);
DocumentView* document_view_construct (GType object_type,
                                       Document* doc);
static void __lambda46_ (DocumentView* self,
                  GObject* d,
                  GParamSpec* p);
gboolean document_get_readonly (Document* self);
static void ___lambda46__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
void document_view_set_font_from_settings (DocumentView* self);
GType completion_provider_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CompletionProvider, g_object_unref)
CompletionProvider* completion_provider_get_default (void);
static void document_view_hide_completion_calltip_when_needed (DocumentView* self);
static void document_view_init_spell_checking (DocumentView* self);
static gboolean document_view_on_button_release_event (DocumentView* self,
                                                GdkEventButton* event);
static gboolean _document_view_on_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                                 GdkEventButton* event,
                                                                                 gpointer self);
GType app_settings_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppSettings, g_object_unref)
AppSettings* app_settings_get_default (void);
const gchar* app_settings_get_system_font (AppSettings* self);
void document_view_set_font_from_string (DocumentView* self,
                                         const gchar* font);
void document_view_enlarge_font (DocumentView* self);
void document_view_shrink_font (DocumentView* self);
GFile* document_get_location (Document* self);
GFile* document_get_main_file (Document* self);
static void __lambda47_ (DocumentView* self);
void completion_provider_hide_calltip_window (CompletionProvider* self);
static void ___lambda47__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
static GspellLanguage* document_view_get_spell_language (DocumentView* self);
void document_view_setup_inline_spell_checker (DocumentView* self);
static void document_view_inline_checker_enabled_notify_cb (DocumentView* self);
static void _document_view_inline_checker_enabled_notify_cb_g_object_notify (GObject* _sender,
                                                                      GParamSpec* pspec,
                                                                      gpointer self);
static void __lambda48_ (Block18Data* _data18_);
static void ___lambda48__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda49_ (Block18Data* _data18_);
static void ___lambda49__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static void __lambda50_ (DocumentView* self);
static void ___lambda50__g_settings_changed (GSettings* _sender,
                                      const gchar* key,
                                      gpointer self);
static GspellChecker* document_view_get_spell_checker (DocumentView* self);
void document_view_launch_spell_checker_dialog (DocumentView* self);
void document_view_launch_spell_language_chooser_dialog (DocumentView* self);
void document_view_save_spell_language_metadata (DocumentView* self);
void document_set_metadata (Document* self,
                            const gchar* key,
                            const gchar* val);
void document_view_save_inline_spell_metadata (DocumentView* self);
static void document_view_finalize (GObject * obj);
static GType document_view_get_type_once (void);

static inline gpointer
document_view_get_instance_private (DocumentView* self)
{
	return G_STRUCT_MEMBER_P (self, DocumentView_private_offset);
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
#line 30 "document_view.vala"
	g_boxed_free (pango_font_description_get_type (), self);
#line 201 "document_view.c"
}

static void
__lambda46_ (DocumentView* self,
             GObject* d,
             GParamSpec* p)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
#line 38 "document_view.vala"
	g_return_if_fail (d != NULL);
#line 38 "document_view.vala"
	g_return_if_fail (p != NULL);
#line 40 "document_view.vala"
	_tmp0_ = document_get_readonly (G_TYPE_CHECK_INSTANCE_CAST (d, TYPE_DOCUMENT, Document));
#line 40 "document_view.vala"
	_tmp1_ = _tmp0_;
#line 40 "document_view.vala"
	gtk_text_view_set_editable ((GtkTextView*) self, !_tmp1_);
#line 221 "document_view.c"
}

static void
___lambda46__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 38 "document_view.vala"
	__lambda46_ ((DocumentView*) self, _sender, pspec);
#line 231 "document_view.c"
}

static gboolean
_document_view_on_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                        GdkEventButton* event,
                                                                        gpointer self)
{
	gboolean result;
	result = document_view_on_button_release_event ((DocumentView*) self, event);
#line 71 "document_view.vala"
	return result;
#line 243 "document_view.c"
}

DocumentView*
document_view_construct (GType object_type,
                         Document* doc)
{
	DocumentView * self = NULL;
	GSettings* _tmp0_;
	GError* _inner_error0_ = NULL;
#line 34 "document_view.vala"
	g_return_val_if_fail (doc != NULL, NULL);
#line 34 "document_view.vala"
	self = (DocumentView*) g_object_new (object_type, NULL);
#line 36 "document_view.vala"
	gtk_text_view_set_buffer ((GtkTextView*) self, (GtkTextBuffer*) doc);
#line 38 "document_view.vala"
	g_signal_connect_object ((GObject*) doc, "notify::readonly", (GCallback) ___lambda46__g_object_notify, self, 0);
#line 43 "document_view.vala"
	latexila_view_setup ((GtkSourceView*) self);
#line 46 "document_view.vala"
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.preferences.editor");
#line 46 "document_view.vala"
	_g_object_unref0 (self->priv->_editor_settings);
#line 46 "document_view.vala"
	self->priv->_editor_settings = _tmp0_;
#line 48 "document_view.vala"
	document_view_set_font_from_settings (self);
#line 271 "document_view.c"
	{
		CompletionProvider* provider = NULL;
		CompletionProvider* _tmp1_;
		GtkSourceCompletion* _tmp2_;
		GtkSourceCompletion* _tmp3_;
		GtkSourceCompletion* _tmp4_;
		GtkSourceCompletion* _tmp5_;
		GtkSourceCompletion* _tmp6_;
		GtkSourceCompletion* _tmp7_;
		GtkSourceCompletion* _tmp8_;
		GtkSourceCompletion* _tmp9_;
		GtkSourceCompletion* _tmp10_;
		GtkSourceCompletion* _tmp11_;
#line 53 "document_view.vala"
		_tmp1_ = completion_provider_get_default ();
#line 53 "document_view.vala"
		provider = _tmp1_;
#line 54 "document_view.vala"
		_tmp2_ = gtk_source_view_get_completion ((GtkSourceView*) self);
#line 54 "document_view.vala"
		_tmp3_ = _tmp2_;
#line 54 "document_view.vala"
		gtk_source_completion_add_provider (_tmp3_, (GtkSourceCompletionProvider*) provider, &_inner_error0_);
#line 54 "document_view.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 54 "document_view.vala"
			_g_object_unref0 (provider);
#line 299 "document_view.c"
			goto __catch0_g_error;
		}
#line 55 "document_view.vala"
		_tmp4_ = gtk_source_view_get_completion ((GtkSourceView*) self);
#line 55 "document_view.vala"
		_tmp5_ = _tmp4_;
#line 55 "document_view.vala"
		g_object_set (_tmp5_, "remember-info-visibility", TRUE, NULL);
#line 56 "document_view.vala"
		_tmp6_ = gtk_source_view_get_completion ((GtkSourceView*) self);
#line 56 "document_view.vala"
		_tmp7_ = _tmp6_;
#line 56 "document_view.vala"
		g_object_set (_tmp7_, "show-headers", FALSE, NULL);
#line 57 "document_view.vala"
		_tmp8_ = gtk_source_view_get_completion ((GtkSourceView*) self);
#line 57 "document_view.vala"
		_tmp9_ = _tmp8_;
#line 57 "document_view.vala"
		g_object_set (_tmp9_, "auto-complete-delay", (guint) 0, NULL);
#line 58 "document_view.vala"
		_tmp10_ = gtk_source_view_get_completion ((GtkSourceView*) self);
#line 58 "document_view.vala"
		_tmp11_ = _tmp10_;
#line 58 "document_view.vala"
		g_object_set (_tmp11_, "accelerators", (guint) 0, NULL);
#line 60 "document_view.vala"
		document_view_hide_completion_calltip_when_needed (self);
#line 51 "document_view.vala"
		_g_object_unref0 (provider);
#line 330 "document_view.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
#line 51 "document_view.vala"
		e = _inner_error0_;
#line 51 "document_view.vala"
		_inner_error0_ = NULL;
#line 64 "document_view.vala"
		_tmp12_ = e;
#line 64 "document_view.vala"
		_tmp13_ = _tmp12_->message;
#line 64 "document_view.vala"
		g_warning ("document_view.vala:64: Completion: %s", _tmp13_);
#line 51 "document_view.vala"
		_g_error_free0 (e);
#line 350 "document_view.c"
	}
	__finally0:
#line 51 "document_view.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 51 "document_view.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 51 "document_view.vala"
		g_clear_error (&_inner_error0_);
#line 51 "document_view.vala"
		return NULL;
#line 361 "document_view.c"
	}
#line 68 "document_view.vala"
	document_view_init_spell_checking (self);
#line 71 "document_view.vala"
	g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) _document_view_on_button_release_event_gtk_widget_button_release_event, self, 0);
#line 34 "document_view.vala"
	return self;
#line 369 "document_view.c"
}

DocumentView*
document_view_new (Document* doc)
{
#line 34 "document_view.vala"
	return document_view_construct (TYPE_DOCUMENT_VIEW, doc);
#line 377 "document_view.c"
}

void
document_view_set_font_from_settings (DocumentView* self)
{
	gchar* font = NULL;
	GSettings* _tmp0_;
	const gchar* _tmp8_;
#line 74 "document_view.vala"
	g_return_if_fail (self != NULL);
#line 77 "document_view.vala"
	_tmp0_ = self->priv->_editor_settings;
#line 77 "document_view.vala"
	if (g_settings_get_boolean (_tmp0_, "use-default-font")) {
#line 392 "document_view.c"
		AppSettings* _tmp1_;
		AppSettings* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 78 "document_view.vala"
		_tmp1_ = app_settings_get_default ();
#line 78 "document_view.vala"
		_tmp2_ = _tmp1_;
#line 78 "document_view.vala"
		_tmp3_ = app_settings_get_system_font (_tmp2_);
#line 78 "document_view.vala"
		_tmp4_ = _tmp3_;
#line 78 "document_view.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 78 "document_view.vala"
		_g_free0 (font);
#line 78 "document_view.vala"
		font = _tmp5_;
#line 78 "document_view.vala"
		_g_object_unref0 (_tmp2_);
#line 414 "document_view.c"
	} else {
		GSettings* _tmp6_;
		gchar* _tmp7_;
#line 80 "document_view.vala"
		_tmp6_ = self->priv->_editor_settings;
#line 80 "document_view.vala"
		_tmp7_ = g_settings_get_string (_tmp6_, "editor-font");
#line 80 "document_view.vala"
		_g_free0 (font);
#line 80 "document_view.vala"
		font = _tmp7_;
#line 426 "document_view.c"
	}
#line 82 "document_view.vala"
	_tmp8_ = font;
#line 82 "document_view.vala"
	document_view_set_font_from_string (self, _tmp8_);
#line 74 "document_view.vala"
	_g_free0 (font);
#line 434 "document_view.c"
}

void
document_view_set_font_from_string (DocumentView* self,
                                    const gchar* font)
{
	PangoFontDescription* _tmp0_;
	PangoFontDescription* _tmp1_;
#line 85 "document_view.vala"
	g_return_if_fail (self != NULL);
#line 85 "document_view.vala"
	g_return_if_fail (font != NULL);
#line 87 "document_view.vala"
	_tmp0_ = pango_font_description_from_string (font);
#line 87 "document_view.vala"
	__vala_PangoFontDescription_free0 (self->priv->_font_desc);
#line 87 "document_view.vala"
	self->priv->_font_desc = _tmp0_;
#line 88 "document_view.vala"
	_tmp1_ = self->priv->_font_desc;
#line 88 "document_view.vala"
	gtk_widget_override_font ((GtkWidget*) self, _tmp1_);
#line 457 "document_view.c"
}

void
document_view_enlarge_font (DocumentView* self)
{
	PangoFontDescription* _tmp0_;
	PangoFontDescription* _tmp1_;
	PangoFontDescription* _tmp2_;
#line 91 "document_view.vala"
	g_return_if_fail (self != NULL);
#line 94 "document_view.vala"
	_tmp0_ = self->priv->_font_desc;
#line 94 "document_view.vala"
	_tmp1_ = self->priv->_font_desc;
#line 94 "document_view.vala"
	pango_font_description_set_size (_tmp0_, pango_font_description_get_size (_tmp1_) + PANGO_SCALE);
#line 95 "document_view.vala"
	_tmp2_ = self->priv->_font_desc;
#line 95 "document_view.vala"
	gtk_widget_override_font ((GtkWidget*) self, _tmp2_);
#line 478 "document_view.c"
}

void
document_view_shrink_font (DocumentView* self)
{
	PangoFontDescription* _tmp0_;
	PangoFontDescription* _tmp1_;
	PangoFontDescription* _tmp2_;
#line 98 "document_view.vala"
	g_return_if_fail (self != NULL);
#line 101 "document_view.vala"
	_tmp0_ = self->priv->_font_desc;
#line 101 "document_view.vala"
	_tmp1_ = self->priv->_font_desc;
#line 101 "document_view.vala"
	pango_font_description_set_size (_tmp0_, pango_font_description_get_size (_tmp1_) - PANGO_SCALE);
#line 102 "document_view.vala"
	_tmp2_ = self->priv->_font_desc;
#line 102 "document_view.vala"
	gtk_widget_override_font ((GtkWidget*) self, _tmp2_);
#line 499 "document_view.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 111 "document_view.vala"
	return self ? g_object_ref (self) : NULL;
#line 507 "document_view.c"
}

static gboolean
document_view_on_button_release_event (DocumentView* self,
                                       GdkEventButton* event)
{
	gboolean _tmp0_ = FALSE;
	gboolean result = FALSE;
#line 105 "document_view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 105 "document_view.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 108 "document_view.vala"
	if (event->button == ((guint) 1)) {
#line 522 "document_view.c"
		GdkModifierType _tmp1_;
#line 109 "document_view.vala"
		_tmp1_ = event->state;
#line 109 "document_view.vala"
		_tmp0_ = (_tmp1_ & GDK_CONTROL_MASK) == GDK_CONTROL_MASK;
#line 528 "document_view.c"
	} else {
#line 108 "document_view.vala"
		_tmp0_ = FALSE;
#line 532 "document_view.c"
	}
#line 108 "document_view.vala"
	if (_tmp0_) {
#line 536 "document_view.c"
		LatexilaSynctex* synctex = NULL;
		LatexilaSynctex* _tmp2_;
		LatexilaSynctex* _tmp3_;
		Document* doc = NULL;
		GtkTextBuffer* _tmp4_;
		GtkTextBuffer* _tmp5_;
		Document* _tmp6_;
		LatexilaSynctex* _tmp7_;
		GtkTextBuffer* _tmp8_;
		GtkTextBuffer* _tmp9_;
		Document* _tmp10_;
		GFile* _tmp11_;
		GFile* _tmp12_;
		Document* _tmp13_;
		GFile* _tmp14_;
		GFile* _tmp15_;
#line 111 "document_view.vala"
		_tmp2_ = latexila_synctex_get_instance ();
#line 111 "document_view.vala"
		_tmp3_ = _g_object_ref0 (_tmp2_);
#line 111 "document_view.vala"
		synctex = _tmp3_;
#line 112 "document_view.vala"
		_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) self);
#line 112 "document_view.vala"
		_tmp5_ = _tmp4_;
#line 112 "document_view.vala"
		_tmp6_ = _g_object_ref0 (IS_DOCUMENT (_tmp5_) ? ((Document*) _tmp5_) : NULL);
#line 112 "document_view.vala"
		doc = _tmp6_;
#line 113 "document_view.vala"
		_tmp7_ = synctex;
#line 113 "document_view.vala"
		_tmp8_ = gtk_text_view_get_buffer ((GtkTextView*) self);
#line 113 "document_view.vala"
		_tmp9_ = _tmp8_;
#line 113 "document_view.vala"
		_tmp10_ = doc;
#line 113 "document_view.vala"
		_tmp11_ = document_get_location (_tmp10_);
#line 113 "document_view.vala"
		_tmp12_ = _tmp11_;
#line 113 "document_view.vala"
		_tmp13_ = doc;
#line 113 "document_view.vala"
		_tmp14_ = document_get_main_file (_tmp13_);
#line 113 "document_view.vala"
		_tmp15_ = _tmp14_;
#line 113 "document_view.vala"
		latexila_synctex_forward_search (_tmp7_, _tmp9_, _tmp12_, _tmp15_, (guint) event->time);
#line 113 "document_view.vala"
		_g_object_unref0 (_tmp15_);
#line 108 "document_view.vala"
		_g_object_unref0 (doc);
#line 108 "document_view.vala"
		_g_object_unref0 (synctex);
#line 593 "document_view.c"
	}
#line 118 "document_view.vala"
	result = FALSE;
#line 118 "document_view.vala"
	return result;
#line 599 "document_view.c"
}

static void
__lambda47_ (DocumentView* self)
{
	CompletionProvider* provider = NULL;
	CompletionProvider* _tmp0_;
#line 125 "document_view.vala"
	_tmp0_ = completion_provider_get_default ();
#line 125 "document_view.vala"
	provider = _tmp0_;
#line 126 "document_view.vala"
	completion_provider_hide_calltip_window (provider);
#line 123 "document_view.vala"
	_g_object_unref0 (provider);
#line 615 "document_view.c"
}

static void
___lambda47__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 123 "document_view.vala"
	__lambda47_ ((DocumentView*) self);
#line 625 "document_view.c"
}

static void
document_view_hide_completion_calltip_when_needed (DocumentView* self)
{
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
#line 121 "document_view.vala"
	g_return_if_fail (self != NULL);
#line 123 "document_view.vala"
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
#line 123 "document_view.vala"
	_tmp1_ = _tmp0_;
#line 123 "document_view.vala"
	g_signal_connect_object ((GObject*) _tmp1_, "notify::cursor-position", (GCallback) ___lambda47__g_object_notify, self, 0);
#line 641 "document_view.c"
}

static Block18Data*
block18_data_ref (Block18Data* _data18_)
{
#line 132 "document_view.vala"
	g_atomic_int_inc (&_data18_->_ref_count_);
#line 132 "document_view.vala"
	return _data18_;
#line 651 "document_view.c"
}

static void
block18_data_unref (void * _userdata_)
{
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
#line 132 "document_view.vala"
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
#line 661 "document_view.c"
		DocumentView* self;
#line 132 "document_view.vala"
		self = _data18_->self;
#line 132 "document_view.vala"
		_g_object_unref0 (_data18_->spell_checker);
#line 132 "document_view.vala"
		_g_object_unref0 (self);
#line 132 "document_view.vala"
		g_slice_free (Block18Data, _data18_);
#line 671 "document_view.c"
	}
}

static void
_document_view_inline_checker_enabled_notify_cb_g_object_notify (GObject* _sender,
                                                                 GParamSpec* pspec,
                                                                 gpointer self)
{
#line 144 "document_view.vala"
	document_view_inline_checker_enabled_notify_cb ((DocumentView*) self);
#line 682 "document_view.c"
}

static void
__lambda48_ (Block18Data* _data18_)
{
	DocumentView* self;
	GspellLanguage* _tmp0_;
#line 148 "document_view.vala"
	self = _data18_->self;
#line 150 "document_view.vala"
	_tmp0_ = document_view_get_spell_language (self);
#line 150 "document_view.vala"
	gspell_checker_set_language (_data18_->spell_checker, _tmp0_);
#line 151 "document_view.vala"
	document_view_setup_inline_spell_checker (self);
#line 698 "document_view.c"
}

static void
___lambda48__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 148 "document_view.vala"
	__lambda48_ (self);
#line 708 "document_view.c"
}

static void
__lambda49_ (Block18Data* _data18_)
{
	DocumentView* self;
	GspellLanguage* _tmp0_;
#line 154 "document_view.vala"
	self = _data18_->self;
#line 156 "document_view.vala"
	_tmp0_ = document_view_get_spell_language (self);
#line 156 "document_view.vala"
	gspell_checker_set_language (_data18_->spell_checker, _tmp0_);
#line 722 "document_view.c"
}

static void
___lambda49__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
#line 154 "document_view.vala"
	__lambda49_ (self);
#line 732 "document_view.c"
}

static void
__lambda50_ (DocumentView* self)
{
#line 161 "document_view.vala"
	document_view_setup_inline_spell_checker (self);
#line 740 "document_view.c"
}

static void
___lambda50__g_settings_changed (GSettings* _sender,
                                 const gchar* key,
                                 gpointer self)
{
#line 159 "document_view.vala"
	__lambda50_ ((DocumentView*) self);
#line 750 "document_view.c"
}

static void
document_view_init_spell_checking (DocumentView* self)
{
	Block18Data* _data18_;
	GspellLanguage* _tmp0_;
	GspellChecker* _tmp1_;
	GspellTextBuffer* gspell_buffer = NULL;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GspellTextBuffer* _tmp4_;
	GspellTextView* gspell_view = NULL;
	GspellTextView* _tmp5_;
	GspellTextView* _tmp6_;
	Document* doc = NULL;
	GtkTextBuffer* _tmp7_;
	Document* _tmp8_;
	GSettings* _tmp9_;
	GSettings* _tmp10_;
#line 132 "document_view.vala"
	g_return_if_fail (self != NULL);
#line 132 "document_view.vala"
	_data18_ = g_slice_new0 (Block18Data);
#line 132 "document_view.vala"
	_data18_->_ref_count_ = 1;
#line 132 "document_view.vala"
	_data18_->self = g_object_ref (self);
#line 134 "document_view.vala"
	_tmp0_ = document_view_get_spell_language (self);
#line 134 "document_view.vala"
	_tmp1_ = gspell_checker_new (_tmp0_);
#line 134 "document_view.vala"
	_data18_->spell_checker = _tmp1_;
#line 136 "document_view.vala"
	_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) self);
#line 136 "document_view.vala"
	_tmp3_ = _tmp2_;
#line 136 "document_view.vala"
	_tmp4_ = gspell_text_buffer_get_from_gtk_text_buffer (_tmp3_);
#line 136 "document_view.vala"
	gspell_buffer = _tmp4_;
#line 138 "document_view.vala"
	gspell_text_buffer_set_spell_checker (gspell_buffer, _data18_->spell_checker);
#line 140 "document_view.vala"
	document_view_setup_inline_spell_checker (self);
#line 142 "document_view.vala"
	_tmp5_ = gspell_text_view_get_from_gtk_text_view (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_text_view_get_type ()) ? ((GtkTextView*) self) : NULL);
#line 142 "document_view.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 142 "document_view.vala"
	gspell_view = _tmp6_;
#line 144 "document_view.vala"
	g_signal_connect_object ((GObject*) gspell_view, "notify::inline-spell-checking", (GCallback) _document_view_inline_checker_enabled_notify_cb_g_object_notify, self, 0);
#line 146 "document_view.vala"
	_tmp7_ = gtk_text_view_get_buffer ((GtkTextView*) self);
#line 146 "document_view.vala"
	_tmp8_ = _g_object_ref0 (IS_DOCUMENT (_tmp7_) ? ((Document*) _tmp7_) : NULL);
#line 146 "document_view.vala"
	doc = _tmp8_;
#line 148 "document_view.vala"
	g_signal_connect_data ((GObject*) doc, "notify::location", (GCallback) ___lambda48__g_object_notify, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
#line 154 "document_view.vala"
	_tmp9_ = self->priv->_editor_settings;
#line 154 "document_view.vala"
	g_signal_connect_data (_tmp9_, "changed::spell-checking-language", (GCallback) ___lambda49__g_settings_changed, block18_data_ref (_data18_), (GClosureNotify) block18_data_unref, 0);
#line 159 "document_view.vala"
	_tmp10_ = self->priv->_editor_settings;
#line 159 "document_view.vala"
	g_signal_connect_object (_tmp10_, "changed::highlight-misspelled-words", (GCallback) ___lambda50__g_settings_changed, self, 0);
#line 132 "document_view.vala"
	_g_object_unref0 (doc);
#line 132 "document_view.vala"
	_g_object_unref0 (gspell_view);
#line 132 "document_view.vala"
	block18_data_unref (_data18_);
#line 132 "document_view.vala"
	_data18_ = NULL;
#line 829 "document_view.c"
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
#line 1232 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1233 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1233 "glib-2.0.vapi"
	result = _tmp0_;
#line 1233 "glib-2.0.vapi"
	return result;
#line 846 "document_view.c"
}

static GspellLanguage*
document_view_get_spell_language (DocumentView* self)
{
	Document* doc = NULL;
	GtkTextBuffer* _tmp0_;
	Document* _tmp1_;
	gchar* lang_code = NULL;
	Document* _tmp2_;
	TeplMetadata* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GspellLanguage* _tmp10_;
	GspellLanguage* result = NULL;
#line 165 "document_view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 167 "document_view.vala"
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
#line 167 "document_view.vala"
	_tmp1_ = _g_object_ref0 (IS_DOCUMENT (_tmp0_) ? ((Document*) _tmp0_) : NULL);
#line 167 "document_view.vala"
	doc = _tmp1_;
#line 169 "document_view.vala"
	_tmp2_ = doc;
#line 169 "document_view.vala"
	_tmp3_ = tepl_buffer_get_metadata ((TeplBuffer*) _tmp2_);
#line 169 "document_view.vala"
	_tmp4_ = tepl_metadata_get (_tmp3_, DOCUMENT_VIEW_METADATA_KEY_SPELL_LANGUAGE);
#line 169 "document_view.vala"
	lang_code = _tmp4_;
#line 170 "document_view.vala"
	_tmp5_ = lang_code;
#line 170 "document_view.vala"
	if (_tmp5_ == NULL) {
#line 884 "document_view.c"
		GSettings* _tmp6_;
		gchar* _tmp7_;
#line 171 "document_view.vala"
		_tmp6_ = self->priv->_editor_settings;
#line 171 "document_view.vala"
		_tmp7_ = g_settings_get_string (_tmp6_, "spell-checking-language");
#line 171 "document_view.vala"
		_g_free0 (lang_code);
#line 171 "document_view.vala"
		lang_code = _tmp7_;
#line 895 "document_view.c"
	}
#line 173 "document_view.vala"
	_tmp8_ = lang_code;
#line 173 "document_view.vala"
	if (string_get (_tmp8_, (glong) 0) == '\0') {
#line 174 "document_view.vala"
		result = NULL;
#line 174 "document_view.vala"
		_g_free0 (lang_code);
#line 174 "document_view.vala"
		_g_object_unref0 (doc);
#line 174 "document_view.vala"
		return result;
#line 909 "document_view.c"
	}
#line 176 "document_view.vala"
	_tmp9_ = lang_code;
#line 176 "document_view.vala"
	_tmp10_ = gspell_language_lookup (_tmp9_);
#line 176 "document_view.vala"
	result = _tmp10_;
#line 176 "document_view.vala"
	_g_free0 (lang_code);
#line 176 "document_view.vala"
	_g_object_unref0 (doc);
#line 176 "document_view.vala"
	return result;
#line 923 "document_view.c"
}

static GspellChecker*
document_view_get_spell_checker (DocumentView* self)
{
	GspellTextBuffer* gspell_buffer = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GspellTextBuffer* _tmp2_;
	GspellChecker* _tmp3_;
	GspellChecker* result = NULL;
#line 179 "document_view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 181 "document_view.vala"
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
#line 181 "document_view.vala"
	_tmp1_ = _tmp0_;
#line 181 "document_view.vala"
	_tmp2_ = gspell_text_buffer_get_from_gtk_text_buffer (_tmp1_);
#line 181 "document_view.vala"
	gspell_buffer = _tmp2_;
#line 184 "document_view.vala"
	_tmp3_ = gspell_text_buffer_get_spell_checker (gspell_buffer);
#line 184 "document_view.vala"
	result = _tmp3_;
#line 184 "document_view.vala"
	return result;
#line 951 "document_view.c"
}

void
document_view_setup_inline_spell_checker (DocumentView* self)
{
	Document* doc = NULL;
	GtkTextBuffer* _tmp0_;
	Document* _tmp1_;
	gboolean enabled = FALSE;
	gchar* metadata = NULL;
	Document* _tmp2_;
	TeplMetadata* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	GspellTextView* gspell_view = NULL;
	GspellTextView* _tmp8_;
	GspellTextView* _tmp9_;
#line 187 "document_view.vala"
	g_return_if_fail (self != NULL);
#line 189 "document_view.vala"
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
#line 189 "document_view.vala"
	_tmp1_ = _g_object_ref0 (IS_DOCUMENT (_tmp0_) ? ((Document*) _tmp0_) : NULL);
#line 189 "document_view.vala"
	doc = _tmp1_;
#line 193 "document_view.vala"
	_tmp2_ = doc;
#line 193 "document_view.vala"
	_tmp3_ = tepl_buffer_get_metadata ((TeplBuffer*) _tmp2_);
#line 193 "document_view.vala"
	_tmp4_ = tepl_metadata_get (_tmp3_, DOCUMENT_VIEW_METADATA_KEY_INLINE_SPELL);
#line 193 "document_view.vala"
	metadata = _tmp4_;
#line 194 "document_view.vala"
	_tmp5_ = metadata;
#line 194 "document_view.vala"
	if (_tmp5_ != NULL) {
#line 989 "document_view.c"
		const gchar* _tmp6_;
#line 195 "document_view.vala"
		_tmp6_ = metadata;
#line 195 "document_view.vala"
		enabled = g_strcmp0 (_tmp6_, DOCUMENT_VIEW_INLINE_SPELL_ENABLED_STR) == 0;
#line 995 "document_view.c"
	} else {
		GSettings* _tmp7_;
#line 197 "document_view.vala"
		_tmp7_ = self->priv->_editor_settings;
#line 197 "document_view.vala"
		enabled = g_settings_get_boolean (_tmp7_, "highlight-misspelled-words");
#line 1002 "document_view.c"
	}
#line 199 "document_view.vala"
	_tmp8_ = gspell_text_view_get_from_gtk_text_view (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_text_view_get_type ()) ? ((GtkTextView*) self) : NULL);
#line 199 "document_view.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 199 "document_view.vala"
	gspell_view = _tmp9_;
#line 201 "document_view.vala"
	gspell_text_view_set_inline_spell_checking (gspell_view, enabled);
#line 187 "document_view.vala"
	_g_object_unref0 (gspell_view);
#line 187 "document_view.vala"
	_g_free0 (metadata);
#line 187 "document_view.vala"
	_g_object_unref0 (doc);
#line 1018 "document_view.c"
}

void
document_view_launch_spell_checker_dialog (DocumentView* self)
{
	GspellNavigator* navigator = NULL;
	GspellNavigator* _tmp0_;
	GspellNavigator* _tmp1_;
	GspellCheckerDialog* dialog = NULL;
	GtkWidget* _tmp2_;
	GspellCheckerDialog* _tmp3_;
#line 204 "document_view.vala"
	g_return_if_fail (self != NULL);
#line 206 "document_view.vala"
	_tmp0_ = gspell_navigator_text_view_new (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_text_view_get_type ()) ? ((GtkTextView*) self) : NULL);
#line 206 "document_view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 206 "document_view.vala"
	navigator = _tmp1_;
#line 208 "document_view.vala"
	_tmp2_ = gtk_widget_get_toplevel ((GtkWidget*) self);
#line 208 "document_view.vala"
	_tmp3_ = (GspellCheckerDialog*) gspell_checker_dialog_new (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp2_) : NULL, navigator);
#line 208 "document_view.vala"
	g_object_ref_sink (_tmp3_);
#line 208 "document_view.vala"
	dialog = _tmp3_;
#line 211 "document_view.vala"
	gtk_widget_show ((GtkWidget*) dialog);
#line 204 "document_view.vala"
	_g_object_unref0 (dialog);
#line 204 "document_view.vala"
	_g_object_unref0 (navigator);
#line 1052 "document_view.c"
}

void
document_view_launch_spell_language_chooser_dialog (DocumentView* self)
{
	GspellChecker* spell_checker = NULL;
	GspellChecker* _tmp0_;
	GspellChecker* _tmp1_;
	GspellLanguageChooserDialog* dialog = NULL;
	GtkWidget* _tmp2_;
	GspellLanguage* _tmp3_;
	GspellLanguageChooserDialog* _tmp4_;
	GspellLanguage* lang = NULL;
	GspellLanguage* _tmp5_;
#line 214 "document_view.vala"
	g_return_if_fail (self != NULL);
#line 216 "document_view.vala"
	_tmp0_ = document_view_get_spell_checker (self);
#line 216 "document_view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 216 "document_view.vala"
	spell_checker = _tmp1_;
#line 217 "document_view.vala"
	g_return_if_fail (spell_checker != NULL);
#line 219 "document_view.vala"
	_tmp2_ = gtk_widget_get_toplevel ((GtkWidget*) self);
#line 219 "document_view.vala"
	_tmp3_ = gspell_checker_get_language (spell_checker);
#line 219 "document_view.vala"
	_tmp4_ = (GspellLanguageChooserDialog*) gspell_language_chooser_dialog_new (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp2_) : NULL, _tmp3_, (GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL) | GTK_DIALOG_USE_HEADER_BAR);
#line 219 "document_view.vala"
	g_object_ref_sink (_tmp4_);
#line 219 "document_view.vala"
	dialog = _tmp4_;
#line 226 "document_view.vala"
	gtk_dialog_run ((GtkDialog*) dialog);
#line 228 "document_view.vala"
	_tmp5_ = gspell_language_chooser_get_language ((GspellLanguageChooser*) dialog);
#line 228 "document_view.vala"
	lang = _tmp5_;
#line 229 "document_view.vala"
	gspell_checker_set_language (spell_checker, lang);
#line 231 "document_view.vala"
	gtk_widget_destroy ((GtkWidget*) dialog);
#line 214 "document_view.vala"
	_g_object_unref0 (dialog);
#line 214 "document_view.vala"
	_g_object_unref0 (spell_checker);
#line 1101 "document_view.c"
}

void
document_view_save_spell_language_metadata (DocumentView* self)
{
	GspellChecker* spell_checker = NULL;
	GspellChecker* _tmp0_;
	GspellChecker* _tmp1_;
	GspellChecker* _tmp2_;
	Document* doc = NULL;
	GtkTextBuffer* _tmp3_;
	Document* _tmp4_;
	GspellLanguage* lang = NULL;
	GspellChecker* _tmp5_;
	GspellLanguage* _tmp6_;
	GspellLanguage* _tmp7_;
#line 234 "document_view.vala"
	g_return_if_fail (self != NULL);
#line 236 "document_view.vala"
	_tmp0_ = document_view_get_spell_checker (self);
#line 236 "document_view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 236 "document_view.vala"
	spell_checker = _tmp1_;
#line 237 "document_view.vala"
	_tmp2_ = spell_checker;
#line 237 "document_view.vala"
	g_return_if_fail (_tmp2_ != NULL);
#line 239 "document_view.vala"
	_tmp3_ = gtk_text_view_get_buffer ((GtkTextView*) self);
#line 239 "document_view.vala"
	_tmp4_ = _g_object_ref0 (IS_DOCUMENT (_tmp3_) ? ((Document*) _tmp3_) : NULL);
#line 239 "document_view.vala"
	doc = _tmp4_;
#line 241 "document_view.vala"
	_tmp5_ = spell_checker;
#line 241 "document_view.vala"
	_tmp6_ = gspell_checker_get_language (_tmp5_);
#line 241 "document_view.vala"
	lang = _tmp6_;
#line 242 "document_view.vala"
	_tmp7_ = lang;
#line 242 "document_view.vala"
	if (_tmp7_ != NULL) {
#line 1146 "document_view.c"
		Document* _tmp8_;
		GspellLanguage* _tmp9_;
		const gchar* _tmp10_;
#line 243 "document_view.vala"
		_tmp8_ = doc;
#line 243 "document_view.vala"
		_tmp9_ = lang;
#line 243 "document_view.vala"
		_tmp10_ = gspell_language_get_code (_tmp9_);
#line 243 "document_view.vala"
		document_set_metadata (_tmp8_, DOCUMENT_VIEW_METADATA_KEY_SPELL_LANGUAGE, _tmp10_);
#line 1158 "document_view.c"
	} else {
		Document* _tmp11_;
#line 245 "document_view.vala"
		_tmp11_ = doc;
#line 245 "document_view.vala"
		document_set_metadata (_tmp11_, DOCUMENT_VIEW_METADATA_KEY_SPELL_LANGUAGE, NULL);
#line 1165 "document_view.c"
	}
#line 234 "document_view.vala"
	_g_object_unref0 (doc);
#line 234 "document_view.vala"
	_g_object_unref0 (spell_checker);
#line 1171 "document_view.c"
}

void
document_view_save_inline_spell_metadata (DocumentView* self)
{
	Document* doc = NULL;
	GtkTextBuffer* _tmp0_;
	Document* _tmp1_;
	GspellTextView* gspell_view = NULL;
	GspellTextView* _tmp2_;
	GspellTextView* _tmp3_;
	GspellTextView* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
#line 248 "document_view.vala"
	g_return_if_fail (self != NULL);
#line 250 "document_view.vala"
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
#line 250 "document_view.vala"
	_tmp1_ = _g_object_ref0 (IS_DOCUMENT (_tmp0_) ? ((Document*) _tmp0_) : NULL);
#line 250 "document_view.vala"
	doc = _tmp1_;
#line 252 "document_view.vala"
	_tmp2_ = gspell_text_view_get_from_gtk_text_view (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_text_view_get_type ()) ? ((GtkTextView*) self) : NULL);
#line 252 "document_view.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 252 "document_view.vala"
	gspell_view = _tmp3_;
#line 255 "document_view.vala"
	_tmp4_ = gspell_view;
#line 255 "document_view.vala"
	_tmp5_ = gspell_text_view_get_inline_spell_checking (_tmp4_);
#line 255 "document_view.vala"
	_tmp6_ = _tmp5_;
#line 255 "document_view.vala"
	if (_tmp6_) {
#line 1208 "document_view.c"
		Document* _tmp7_;
#line 257 "document_view.vala"
		_tmp7_ = doc;
#line 257 "document_view.vala"
		document_set_metadata (_tmp7_, DOCUMENT_VIEW_METADATA_KEY_INLINE_SPELL, DOCUMENT_VIEW_INLINE_SPELL_ENABLED_STR);
#line 1214 "document_view.c"
	} else {
		Document* _tmp8_;
#line 261 "document_view.vala"
		_tmp8_ = doc;
#line 261 "document_view.vala"
		document_set_metadata (_tmp8_, DOCUMENT_VIEW_METADATA_KEY_INLINE_SPELL, DOCUMENT_VIEW_INLINE_SPELL_DISABLED_STR);
#line 1221 "document_view.c"
	}
#line 248 "document_view.vala"
	_g_object_unref0 (gspell_view);
#line 248 "document_view.vala"
	_g_object_unref0 (doc);
#line 1227 "document_view.c"
}

static void
document_view_inline_checker_enabled_notify_cb (DocumentView* self)
{
	GspellTextView* gspell_view = NULL;
	GspellTextView* _tmp0_;
	GspellTextView* _tmp1_;
	GspellTextView* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	GspellChecker* spell_checker = NULL;
	GspellChecker* _tmp5_;
	GspellChecker* _tmp6_;
	GspellChecker* _tmp7_;
	GspellChecker* _tmp8_;
	GspellLanguage* _tmp9_;
	GspellTextView* _tmp10_;
	GtkMessageDialog* dialog = NULL;
	GtkWidget* _tmp11_;
	GtkMessageDialog* _tmp12_;
	GtkMessageDialog* _tmp13_;
	gint response = 0;
	GtkMessageDialog* _tmp14_;
	GtkMessageDialog* _tmp17_;
	GError* _inner_error0_ = NULL;
#line 265 "document_view.vala"
	g_return_if_fail (self != NULL);
#line 267 "document_view.vala"
	_tmp0_ = gspell_text_view_get_from_gtk_text_view (G_TYPE_CHECK_INSTANCE_TYPE (self, gtk_text_view_get_type ()) ? ((GtkTextView*) self) : NULL);
#line 267 "document_view.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 267 "document_view.vala"
	gspell_view = _tmp1_;
#line 269 "document_view.vala"
	_tmp2_ = gspell_view;
#line 269 "document_view.vala"
	_tmp3_ = gspell_text_view_get_inline_spell_checking (_tmp2_);
#line 269 "document_view.vala"
	_tmp4_ = _tmp3_;
#line 269 "document_view.vala"
	if (!_tmp4_) {
#line 270 "document_view.vala"
		_g_object_unref0 (gspell_view);
#line 270 "document_view.vala"
		return;
#line 1274 "document_view.c"
	}
#line 272 "document_view.vala"
	_tmp5_ = document_view_get_spell_checker (self);
#line 272 "document_view.vala"
	_tmp6_ = _g_object_ref0 (_tmp5_);
#line 272 "document_view.vala"
	spell_checker = _tmp6_;
#line 273 "document_view.vala"
	_tmp7_ = spell_checker;
#line 273 "document_view.vala"
	g_return_if_fail (_tmp7_ != NULL);
#line 275 "document_view.vala"
	_tmp8_ = spell_checker;
#line 275 "document_view.vala"
	_tmp9_ = gspell_checker_get_language (_tmp8_);
#line 275 "document_view.vala"
	if (_tmp9_ != NULL) {
#line 276 "document_view.vala"
		_g_object_unref0 (spell_checker);
#line 276 "document_view.vala"
		_g_object_unref0 (gspell_view);
#line 276 "document_view.vala"
		return;
#line 1298 "document_view.c"
	}
#line 278 "document_view.vala"
	_tmp10_ = gspell_view;
#line 278 "document_view.vala"
	gspell_text_view_set_inline_spell_checking (_tmp10_, FALSE);
#line 280 "document_view.vala"
	if (document_view__no_spell_language_dialog_shown) {
#line 281 "document_view.vala"
		_g_object_unref0 (spell_checker);
#line 281 "document_view.vala"
		_g_object_unref0 (gspell_view);
#line 281 "document_view.vala"
		return;
#line 1312 "document_view.c"
	}
#line 283 "document_view.vala"
	document_view__no_spell_language_dialog_shown = TRUE;
#line 285 "document_view.vala"
	_tmp11_ = gtk_widget_get_toplevel ((GtkWidget*) self);
#line 285 "document_view.vala"
	_tmp12_ = (GtkMessageDialog*) gtk_message_dialog_new (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp11_) : NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, "%s", _ ("No dictionaries available for the spell-checking."));
#line 285 "document_view.vala"
	g_object_ref_sink (_tmp12_);
#line 285 "document_view.vala"
	dialog = _tmp12_;
#line 291 "document_view.vala"
	_tmp13_ = dialog;
#line 291 "document_view.vala"
	gtk_dialog_add_buttons ((GtkDialog*) _tmp13_, _ ("_Help"), GTK_RESPONSE_HELP, _ ("_OK"), GTK_RESPONSE_OK, NULL, NULL);
#line 295 "document_view.vala"
	_tmp14_ = dialog;
#line 295 "document_view.vala"
	response = gtk_dialog_run ((GtkDialog*) _tmp14_);
#line 297 "document_view.vala"
	if (response == ((gint) GTK_RESPONSE_HELP)) {
#line 1334 "document_view.c"
		{
#line 301 "document_view.vala"
			latexila_utils_show_uri ((GtkWidget*) self, "help:latexila/spell_checking", (guint32) GDK_CURRENT_TIME, &_inner_error0_);
#line 301 "document_view.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1340 "document_view.c"
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp15_;
			const gchar* _tmp16_;
#line 299 "document_view.vala"
			e = _inner_error0_;
#line 299 "document_view.vala"
			_inner_error0_ = NULL;
#line 306 "document_view.vala"
			_tmp15_ = e;
#line 306 "document_view.vala"
			_tmp16_ = _tmp15_->message;
#line 306 "document_view.vala"
			g_warning ("document_view.vala:306: Impossible to open the documentation: %s", _tmp16_);
#line 299 "document_view.vala"
			_g_error_free0 (e);
#line 1362 "document_view.c"
		}
		__finally0:
#line 299 "document_view.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 299 "document_view.vala"
			_g_object_unref0 (dialog);
#line 299 "document_view.vala"
			_g_object_unref0 (spell_checker);
#line 299 "document_view.vala"
			_g_object_unref0 (gspell_view);
#line 299 "document_view.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 299 "document_view.vala"
			g_clear_error (&_inner_error0_);
#line 299 "document_view.vala"
			return;
#line 1379 "document_view.c"
		}
	}
#line 310 "document_view.vala"
	_tmp17_ = dialog;
#line 310 "document_view.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp17_);
#line 265 "document_view.vala"
	_g_object_unref0 (dialog);
#line 265 "document_view.vala"
	_g_object_unref0 (spell_checker);
#line 265 "document_view.vala"
	_g_object_unref0 (gspell_view);
#line 1392 "document_view.c"
}

static void
document_view_class_init (DocumentViewClass * klass,
                          gpointer klass_data)
{
#line 22 "document_view.vala"
	document_view_parent_class = g_type_class_peek_parent (klass);
#line 22 "document_view.vala"
	g_type_class_adjust_private_offset (klass, &DocumentView_private_offset);
#line 22 "document_view.vala"
	G_OBJECT_CLASS (klass)->finalize = document_view_finalize;
#line 1405 "document_view.c"
}

static void
document_view_instance_init (DocumentView * self,
                             gpointer klass)
{
#line 22 "document_view.vala"
	self->priv = document_view_get_instance_private (self);
#line 1414 "document_view.c"
}

static void
document_view_finalize (GObject * obj)
{
	DocumentView * self;
#line 22 "document_view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DOCUMENT_VIEW, DocumentView);
#line 29 "document_view.vala"
	_g_object_unref0 (self->priv->_editor_settings);
#line 30 "document_view.vala"
	__vala_PangoFontDescription_free0 (self->priv->_font_desc);
#line 22 "document_view.vala"
	G_OBJECT_CLASS (document_view_parent_class)->finalize (obj);
#line 1429 "document_view.c"
}

static GType
document_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DocumentViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DocumentView), 0, (GInstanceInitFunc) document_view_instance_init, NULL };
	GType document_view_type_id;
	document_view_type_id = g_type_register_static (tepl_view_get_type (), "DocumentView", &g_define_type_info, 0);
	DocumentView_private_offset = g_type_add_instance_private (document_view_type_id, sizeof (DocumentViewPrivate));
	return document_view_type_id;
}

GType
document_view_get_type (void)
{
	static volatile gsize document_view_type_id__volatile = 0;
	if (g_once_init_enter (&document_view_type_id__volatile)) {
		GType document_view_type_id;
		document_view_type_id = document_view_get_type_once ();
		g_once_init_leave (&document_view_type_id__volatile, document_view_type_id);
	}
	return document_view_type_id__volatile;
}

