/* document_structure.c generated by valac 0.48.9, the Vala compiler
 * generated from document_structure.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2011-2012 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <tepl/tepl.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gtksourceview/gtksource.h>
#include <gdk/gdk.h>

#define TYPE_DOCUMENT_STRUCTURE (document_structure_get_type ())
#define DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructure))
#define DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))
#define IS_DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_STRUCTURE))
#define IS_DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_STRUCTURE))
#define DOCUMENT_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))

typedef struct _DocumentStructure DocumentStructure;
typedef struct _DocumentStructureClass DocumentStructureClass;
typedef struct _DocumentStructurePrivate DocumentStructurePrivate;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_STRUCTURE_MODEL (structure_model_get_type ())
#define STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STRUCTURE_MODEL, StructureModel))
#define STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STRUCTURE_MODEL, StructureModelClass))
#define IS_STRUCTURE_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STRUCTURE_MODEL))
#define IS_STRUCTURE_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STRUCTURE_MODEL))
#define STRUCTURE_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STRUCTURE_MODEL, StructureModelClass))

typedef struct _StructureModel StructureModel;
typedef struct _StructureModelClass StructureModelClass;

#define DOCUMENT_STRUCTURE_TYPE_ENV_DATA (document_structure_env_data_get_type ())
typedef struct _DocumentStructureEnvData DocumentStructureEnvData;
typedef enum  {
	STRUCT_TYPE_BEGIN_COMMON_TYPES,
	STRUCT_TYPE_PART,
	STRUCT_TYPE_CHAPTER,
	STRUCT_TYPE_SECTION,
	STRUCT_TYPE_SUBSECTION,
	STRUCT_TYPE_SUBSUBSECTION,
	STRUCT_TYPE_PARAGRAPH,
	STRUCT_TYPE_SUBPARAGRAPH,
	STRUCT_TYPE_LABEL,
	STRUCT_TYPE_INCLUDE,
	STRUCT_TYPE_IMAGE,
	STRUCT_TYPE_TODO,
	STRUCT_TYPE_FIXME,
	STRUCT_TYPE_END_COMMON_TYPES,
	STRUCT_TYPE_BEGIN_LOW_LEVEL_TYPES,
	STRUCT_TYPE_BEGIN_FIGURE,
	STRUCT_TYPE_END_FIGURE,
	STRUCT_TYPE_BEGIN_TABLE,
	STRUCT_TYPE_END_TABLE,
	STRUCT_TYPE_BEGIN_VERBATIM,
	STRUCT_TYPE_END_VERBATIM,
	STRUCT_TYPE_END_DOCUMENT,
	STRUCT_TYPE_CAPTION,
	STRUCT_TYPE_END_LOW_LEVEL_TYPES,
	STRUCT_TYPE_BEGIN_HIGH_LEVEL_TYPES,
	STRUCT_TYPE_TABLE,
	STRUCT_TYPE_FIGURE,
	STRUCT_TYPE_END_HIGH_LEVEL_TYPES,
	STRUCT_TYPE_NB_TYPES
} StructType;

#define TYPE_STRUCT_TYPE (struct_type_get_type ())
enum  {
	DOCUMENT_STRUCTURE_0_PROPERTY,
	DOCUMENT_STRUCTURE_PARSING_DONE_PROPERTY,
	DOCUMENT_STRUCTURE_NUM_PROPERTIES
};
static GParamSpec* document_structure_properties[DOCUMENT_STRUCTURE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _document_structure_env_data_free0(var) ((var == NULL) ? NULL : (var = (document_structure_env_data_free (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define __vala_GtkTreeIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreeIter_free (var), NULL)))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))

#define TYPE_STRUCT_DATA (struct_data_get_type ())
typedef struct _StructData StructData;
typedef enum  {
	STRUCT_ACTION_CUT,
	STRUCT_ACTION_COPY,
	STRUCT_ACTION_DELETE,
	STRUCT_ACTION_SELECT,
	STRUCT_ACTION_COMMENT,
	STRUCT_ACTION_SHIFT_LEFT,
	STRUCT_ACTION_SHIFT_RIGHT,
	STRUCT_ACTION_OPEN_FILE,
	STRUCT_ACTION_NB_ACTIONS
} StructAction;

#define TYPE_STRUCT_ACTION (struct_action_get_type ())
typedef enum  {
	STRUCT_COLUMN_PIXBUF,
	STRUCT_COLUMN_TEXT,
	STRUCT_COLUMN_TOOLTIP,
	STRUCT_COLUMN_START_MARK,
	STRUCT_COLUMN_END_MARK,
	STRUCT_COLUMN_TYPE,
	STRUCT_COLUMN_N_COLUMNS
} StructColumn;

#define TYPE_STRUCT_COLUMN (struct_column_get_type ())

struct _DocumentStructure {
	GObject parent_instance;
	DocumentStructurePrivate * priv;
};

struct _DocumentStructureClass {
	GObjectClass parent_class;
};

struct _DocumentStructureEnvData {
	GtkTreePath* path;
	StructType type;
	gchar* first_caption;
};

struct _DocumentStructurePrivate {
	Document* _doc;
	gint _nb_marks;
	GtkTextMark* _end_document_mark;
	StructureModel* _model;
	gboolean _in_verbatim_env;
	DocumentStructureEnvData* _last_env_data;
	gint _start_parsing_line;
	GTimer* _timer;
	guint _idle_id;
	gboolean _parsing_done;
};

struct _StructData {
	StructType type;
	gchar* text;
	GtkTextMark* start_mark;
	GtkTextMark* end_mark;
};

typedef enum  {
	STRUCT_ERROR_GENERAL,
	STRUCT_ERROR_DATA_OUTDATED
} StructError;
#define STRUCT_ERROR struct_error_quark ()

static gint DocumentStructure_private_offset;
static gpointer document_structure_parent_class = NULL;
static GRegex* document_structure__chars_regex;
static GRegex* document_structure__chars_regex = NULL;
static GRegex* document_structure__comment_regex;
static GRegex* document_structure__comment_regex = NULL;
static GRegex* document_structure__command_name_regex;
static GRegex* document_structure__command_name_regex = NULL;
static gchar** document_structure__section_names;
static gint document_structure__section_names_length1;
static gchar** document_structure__section_names = NULL;
static gint document_structure__section_names_length1 = 0;
static gint _document_structure__section_names_size_ = 0;

GType document_structure_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentStructure, g_object_unref)
GType document_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
GType structure_model_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (StructureModel, g_object_unref)
static GType document_structure_env_data_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType struct_type_get_type (void) G_GNUC_CONST;
static DocumentStructureEnvData* document_structure_env_data_dup (const DocumentStructureEnvData* self);
static void document_structure_env_data_free (DocumentStructureEnvData* self);
static void document_structure_env_data_copy (const DocumentStructureEnvData* self,
                                       DocumentStructureEnvData* dest);
static void document_structure_env_data_destroy (DocumentStructureEnvData* self);
#define DOCUMENT_STRUCTURE_MARK_NAME_PREFIX "struct_item_"
#define DOCUMENT_STRUCTURE_ITEM_MAX_LENGTH 60
#define DOCUMENT_STRUCTURE_MAX_NB_LINES_TO_PARSE 2000
#define DOCUMENT_STRUCTURE__measure_parsing_time FALSE
DocumentStructure* document_structure_new (Document* doc);
DocumentStructure* document_structure_construct (GType object_type,
                                                 Document* doc);
void document_structure_parse (DocumentStructure* self);
static void document_structure_set_parsing_done (DocumentStructure* self,
                                          gboolean value);
StructureModel* structure_model_new (void);
StructureModel* structure_model_construct (GType object_type);
static void document_structure_clear_all_structure_marks (DocumentStructure* self);
static gboolean __lambda6_ (DocumentStructure* self);
static gboolean document_structure_parse_impl (DocumentStructure* self);
static gboolean ___lambda6__gsource_func (gpointer self);
StructureModel* document_structure_get_model (DocumentStructure* self);
static gchar* document_structure_get_line_contents_at_iter (DocumentStructure* self,
                                                     GtkTextIter* iter);
static gboolean document_structure_search_low_level_item (DocumentStructure* self,
                                                   const gchar* line,
                                                   gint start_index,
                                                   StructType** type,
                                                   gchar* * contents,
                                                   gint** start_match_index,
                                                   gint** end_match_index);
static void document_structure_handle_item (DocumentStructure* self,
                                     StructType type,
                                     const gchar* contents,
                                     GtkTextIter* iter);
static gint* _int_dup (gint* self);
gboolean utils_char_is_escaped (const gchar* text,
                                glong char_index);
static gboolean document_structure_search_markup (DocumentStructure* self,
                                           const gchar* line,
                                           gint after_backslash_index,
                                           StructType** type,
                                           gchar* * contents,
                                           gint** end_match_index);
static gboolean document_structure_search_comment (DocumentStructure* self,
                                            const gchar* line,
                                            gint after_percent_index,
                                            StructType** type,
                                            gchar* * contents,
                                            gint** end_match_index);
static gchar* document_structure_get_markup_name (DocumentStructure* self,
                                           const gchar* line,
                                           gint after_backslash_index,
                                           gint** begin_contents_index);
static gboolean document_structure_search_env (DocumentStructure* self,
                                        const gchar* line,
                                        gint begin_contents_index,
                                        gboolean is_begin_env,
                                        StructType** type,
                                        gint** end_match_index);
static StructType* document_structure_get_markup_type (DocumentStructure* self,
                                                const gchar* markup_name);
static gchar* document_structure_get_markup_contents (DocumentStructure* self,
                                               const gchar* line,
                                               gint begin_contents_index,
                                               gint** end_match_index);
static StructType* _struct_type_dup (StructType* self);
static gboolean document_structure_search_firt_non_optional_arg (DocumentStructure* self,
                                                          const gchar* line,
                                                          gint start_index,
                                                          gint* begin_contents_index);
static gchar* document_structure_truncate (DocumentStructure* self,
                                    const gchar* text);
static GtkTreeIter* document_structure_add_item (DocumentStructure* self,
                                          StructType type,
                                          const gchar* text,
                                          GtkTextIter* start_iter);
static void _vala_GtkTreeIter_free (GtkTreeIter* self);
gboolean structure_is_common_type (StructType type);
static void document_structure_create_new_environment (DocumentStructure* self,
                                                StructType type,
                                                GtkTextIter* start_iter);
static gboolean document_structure_verify_end_environment_type (DocumentStructure* self,
                                                         StructType type);
static GtkTextMark* document_structure_create_text_mark_from_iter (DocumentStructure* self,
                                                            GtkTextIter* iter);
void structure_model_modify_data (StructureModel* self,
                                  GtkTreePath* path,
                                  const gchar* text,
                                  GtkTextMark* end_mark);
static void _vala_GtkTreePath_free (GtkTreePath* self);
GType struct_data_get_type (void) G_GNUC_CONST;
StructData* struct_data_dup (const StructData* self);
void struct_data_free (StructData* self);
void struct_data_copy (const StructData* self,
                       StructData* dest);
void struct_data_destroy (StructData* self);
static GtkTreeIter* document_structure_add_item_data (DocumentStructure* self,
                                               StructData* data);
GtkTreeIter* structure_model_add_item_at_end (StructureModel* self,
                                              StructData* item);
GType struct_action_get_type (void) G_GNUC_CONST;
GQuark struct_error_quark (void);
void document_structure_do_action (DocumentStructure* self,
                                   StructAction action_type,
                                   GtkTreeIter* tree_iter,
                                   gboolean* refresh_simple_list,
                                   GError** error);
static gboolean document_structure_comment_item (DocumentStructure* self,
                                          GtkTreeIter* tree_iter);
void structure_model_delete (StructureModel* self,
                             GtkTreeIter* iter);
gboolean structure_model_item_contains_subparagraph (StructureModel* self,
                                                     GtkTreeIter* iter);
static gboolean document_structure_shift_item (DocumentStructure* self,
                                        GtkTreeIter* tree_iter,
                                        gboolean shift_right,
                                        gboolean* doc_modified);
void structure_model_shift_right (StructureModel* self,
                                  GtkTreeIter* iter);
void structure_model_shift_left (StructureModel* self,
                                 GtkTreeIter* iter);
static gboolean document_structure_get_exact_item_bounds (DocumentStructure* self,
                                                   GtkTreeIter* tree_iter,
                                                   GtkTextIter* start_iter,
                                                   GtkTextIter* end_iter);
static void document_structure_backward_indentation (DocumentStructure* self,
                                              GtkTextIter* iter);
GType struct_column_get_type (void) G_GNUC_CONST;
gboolean structure_is_section (StructType type);
void document_comment_between (Document* self,
                               GtkTextIter* start_iter,
                               GtkTextIter* end_iter,
                               gboolean end_iter_set);
GtkTreeIter* structure_model_get_next_sibling_or_parent (StructureModel* self,
                                                         GtkTreeIter* section_iter,
                                                         GError** error);
static void document_structure_get_end_document_iter (DocumentStructure* self,
                                               gboolean* end_of_file,
                                               GtkTextIter* result);
static gboolean document_structure_get_low_level_item_bounds (DocumentStructure* self,
                                                       StructType item_type,
                                                       const gchar* item_contents,
                                                       GtkTextIter* start_match_iter,
                                                       gboolean is_start,
                                                       GtkTextIter* end_match_iter);
static gboolean _int_equal (const gint * s1,
                     const gint * s2);
static gboolean document_structure_same_items (DocumentStructure* self,
                                        StructType item_type,
                                        const gchar* item_contents,
                                        StructType item_found_type,
                                        const gchar* item_found_contents,
                                        gboolean start);
static gchar* document_structure_get_section_name_from_type (DocumentStructure* self,
                                                      StructType type);
void document_insert (Document* self,
                      GtkTextIter* iter,
                      const gchar* text,
                      gint len);
gboolean document_structure_get_parsing_done (DocumentStructure* self);
static GtkTreePath* _vala_GtkTreePath_copy (GtkTreePath* self);
static void document_structure_finalize (GObject * obj);
static GType document_structure_get_type_once (void);
static void _vala_document_structure_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_document_structure_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
document_structure_get_instance_private (DocumentStructure* self)
{
	return G_STRUCT_MEMBER_P (self, DocumentStructure_private_offset);
}

DocumentStructure*
document_structure_construct (GType object_type,
                              Document* doc)
{
	DocumentStructure * self = NULL;
	GRegex* _tmp0_;
	GError* _inner_error0_ = NULL;
#line 66 "document_structure.vala"
	g_return_val_if_fail (doc != NULL, NULL);
#line 66 "document_structure.vala"
	self = (DocumentStructure*) g_object_new (object_type, NULL);
#line 68 "document_structure.vala"
	self->priv->_doc = doc;
#line 70 "document_structure.vala"
	_tmp0_ = document_structure__chars_regex;
#line 70 "document_structure.vala"
	if (_tmp0_ != NULL) {
#line 71 "document_structure.vala"
		return self;
#line 410 "document_structure.c"
	}
	{
		GRegex* _tmp1_ = NULL;
		GRegex* _tmp2_;
		GRegex* _tmp3_;
		GRegex* _tmp4_ = NULL;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		GRegex* _tmp7_ = NULL;
		GRegex* _tmp8_;
		GRegex* _tmp9_;
#line 75 "document_structure.vala"
		_tmp2_ = g_regex_new ("\\\\|%", 0, 0, &_inner_error0_);
#line 75 "document_structure.vala"
		_tmp1_ = _tmp2_;
#line 75 "document_structure.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 75 "document_structure.vala"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 430 "document_structure.c"
				goto __catch0_g_regex_error;
			}
#line 75 "document_structure.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 75 "document_structure.vala"
			g_clear_error (&_inner_error0_);
#line 75 "document_structure.vala"
			return NULL;
#line 439 "document_structure.c"
		}
#line 75 "document_structure.vala"
		_tmp3_ = _tmp1_;
#line 75 "document_structure.vala"
		_tmp1_ = NULL;
#line 75 "document_structure.vala"
		_g_regex_unref0 (document_structure__chars_regex);
#line 75 "document_structure.vala"
		document_structure__chars_regex = _tmp3_;
#line 77 "document_structure.vala"
		_tmp5_ = g_regex_new ("^(?P<type>TODO|FIXME)\\s*:?\\s*(?P<text>.*)$", G_REGEX_OPTIMIZE, 0, &_inner_error0_);
#line 77 "document_structure.vala"
		_tmp4_ = _tmp5_;
#line 77 "document_structure.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 77 "document_structure.vala"
			_g_regex_unref0 (_tmp1_);
#line 77 "document_structure.vala"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 459 "document_structure.c"
				goto __catch0_g_regex_error;
			}
#line 77 "document_structure.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 77 "document_structure.vala"
			g_clear_error (&_inner_error0_);
#line 77 "document_structure.vala"
			return NULL;
#line 468 "document_structure.c"
		}
#line 77 "document_structure.vala"
		_tmp6_ = _tmp4_;
#line 77 "document_structure.vala"
		_tmp4_ = NULL;
#line 77 "document_structure.vala"
		_g_regex_unref0 (document_structure__comment_regex);
#line 77 "document_structure.vala"
		document_structure__comment_regex = _tmp6_;
#line 83 "document_structure.vala"
		_tmp8_ = g_regex_new ("^(?P<name>[a-z]+\\*?)\\s*(\\[|{)", G_REGEX_OPTIMIZE, 0, &_inner_error0_);
#line 83 "document_structure.vala"
		_tmp7_ = _tmp8_;
#line 83 "document_structure.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 83 "document_structure.vala"
			_g_regex_unref0 (_tmp4_);
#line 83 "document_structure.vala"
			_g_regex_unref0 (_tmp1_);
#line 83 "document_structure.vala"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 490 "document_structure.c"
				goto __catch0_g_regex_error;
			}
#line 83 "document_structure.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 83 "document_structure.vala"
			g_clear_error (&_inner_error0_);
#line 83 "document_structure.vala"
			return NULL;
#line 499 "document_structure.c"
		}
#line 83 "document_structure.vala"
		_tmp9_ = _tmp7_;
#line 83 "document_structure.vala"
		_tmp7_ = NULL;
#line 83 "document_structure.vala"
		_g_regex_unref0 (document_structure__command_name_regex);
#line 83 "document_structure.vala"
		document_structure__command_name_regex = _tmp9_;
#line 73 "document_structure.vala"
		_g_regex_unref0 (_tmp7_);
#line 73 "document_structure.vala"
		_g_regex_unref0 (_tmp4_);
#line 73 "document_structure.vala"
		_g_regex_unref0 (_tmp1_);
#line 515 "document_structure.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError* e = NULL;
		GError* _tmp10_;
		const gchar* _tmp11_;
#line 73 "document_structure.vala"
		e = _inner_error0_;
#line 73 "document_structure.vala"
		_inner_error0_ = NULL;
#line 88 "document_structure.vala"
		_tmp10_ = e;
#line 88 "document_structure.vala"
		_tmp11_ = _tmp10_->message;
#line 88 "document_structure.vala"
		g_warning ("document_structure.vala:88: Structure: %s", _tmp11_);
#line 73 "document_structure.vala"
		_g_error_free0 (e);
#line 535 "document_structure.c"
	}
	__finally0:
#line 73 "document_structure.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 73 "document_structure.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 73 "document_structure.vala"
		g_clear_error (&_inner_error0_);
#line 73 "document_structure.vala"
		return NULL;
#line 546 "document_structure.c"
	}
#line 66 "document_structure.vala"
	return self;
#line 550 "document_structure.c"
}

DocumentStructure*
document_structure_new (Document* doc)
{
#line 66 "document_structure.vala"
	return document_structure_construct (TYPE_DOCUMENT_STRUCTURE, doc);
#line 558 "document_structure.c"
}

static gboolean
__lambda6_ (DocumentStructure* self)
{
	gboolean ret = FALSE;
	gboolean result = FALSE;
#line 117 "document_structure.vala"
	ret = document_structure_parse_impl (self);
#line 119 "document_structure.vala"
	if (!ret) {
#line 120 "document_structure.vala"
		self->priv->_idle_id = (guint) 0;
#line 572 "document_structure.c"
	}
#line 122 "document_structure.vala"
	result = ret;
#line 122 "document_structure.vala"
	return result;
#line 578 "document_structure.c"
}

static gboolean
___lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda6_ ((DocumentStructure*) self);
#line 115 "document_structure.vala"
	return result;
#line 588 "document_structure.c"
}

void
document_structure_parse (DocumentStructure* self)
{
	StructureModel* _tmp0_;
#line 101 "document_structure.vala"
	g_return_if_fail (self != NULL);
#line 104 "document_structure.vala"
	document_structure_set_parsing_done (self, FALSE);
#line 105 "document_structure.vala"
	_tmp0_ = structure_model_new ();
#line 105 "document_structure.vala"
	_g_object_unref0 (self->priv->_model);
#line 105 "document_structure.vala"
	self->priv->_model = _tmp0_;
#line 106 "document_structure.vala"
	_document_structure_env_data_free0 (self->priv->_last_env_data);
#line 106 "document_structure.vala"
	self->priv->_last_env_data = NULL;
#line 107 "document_structure.vala"
	self->priv->_start_parsing_line = 0;
#line 109 "document_structure.vala"
	_g_object_unref0 (self->priv->_end_document_mark);
#line 109 "document_structure.vala"
	self->priv->_end_document_mark = NULL;
#line 110 "document_structure.vala"
	document_structure_clear_all_structure_marks (self);
#line 112 "document_structure.vala"
	if (self->priv->_idle_id != ((guint) 0)) {
#line 113 "document_structure.vala"
		g_source_remove (self->priv->_idle_id);
#line 621 "document_structure.c"
	}
#line 115 "document_structure.vala"
	self->priv->_idle_id = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda6__gsource_func, g_object_ref (self), g_object_unref);
#line 625 "document_structure.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 128 "document_structure.vala"
	return self ? g_object_ref (self) : NULL;
#line 633 "document_structure.c"
}

StructureModel*
document_structure_get_model (DocumentStructure* self)
{
	StructureModel* _tmp0_;
	StructureModel* _tmp1_;
	StructureModel* result = NULL;
#line 126 "document_structure.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 128 "document_structure.vala"
	_tmp0_ = self->priv->_model;
#line 128 "document_structure.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 128 "document_structure.vala"
	result = _tmp1_;
#line 128 "document_structure.vala"
	return result;
#line 652 "document_structure.c"
}

/*************************************************************************/
static gboolean
document_structure_parse_impl (DocumentStructure* self)
{
	Document* _tmp0_;
	GtkTextIter line_iter = {0};
	Document* _tmp4_;
	GtkTextIter _tmp5_ = {0};
	gint nb_lines_parsed = 0;
	gboolean result = FALSE;
#line 135 "document_structure.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 137 "document_structure.vala"
	_tmp0_ = self->priv->_doc;
#line 137 "document_structure.vala"
	if (_tmp0_ == NULL) {
#line 138 "document_structure.vala"
		result = FALSE;
#line 138 "document_structure.vala"
		return result;
#line 675 "document_structure.c"
	}
#line 140 "document_structure.vala"
	if (DOCUMENT_STRUCTURE__measure_parsing_time) {
#line 679 "document_structure.c"
		GTimer* _tmp1_;
#line 142 "document_structure.vala"
		_tmp1_ = self->priv->_timer;
#line 142 "document_structure.vala"
		if (_tmp1_ == NULL) {
#line 685 "document_structure.c"
			GTimer* _tmp2_;
#line 143 "document_structure.vala"
			_tmp2_ = g_timer_new ();
#line 143 "document_structure.vala"
			_g_timer_destroy0 (self->priv->_timer);
#line 143 "document_structure.vala"
			self->priv->_timer = _tmp2_;
#line 693 "document_structure.c"
		} else {
			GTimer* _tmp3_;
#line 145 "document_structure.vala"
			_tmp3_ = self->priv->_timer;
#line 145 "document_structure.vala"
			g_timer_continue (_tmp3_);
#line 700 "document_structure.c"
		}
	}
#line 150 "document_structure.vala"
	_tmp4_ = self->priv->_doc;
#line 150 "document_structure.vala"
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) _tmp4_, &_tmp5_, self->priv->_start_parsing_line);
#line 150 "document_structure.vala"
	line_iter = _tmp5_;
#line 152 "document_structure.vala"
	nb_lines_parsed = 0;
#line 711 "document_structure.c"
	{
		gboolean _tmp6_ = FALSE;
#line 154 "document_structure.vala"
		_tmp6_ = TRUE;
#line 154 "document_structure.vala"
		while (TRUE) {
#line 718 "document_structure.c"
			gchar* line_text = NULL;
			GtkTextIter _tmp8_;
			gchar* _tmp9_;
			gint start_index = 0;
			gint line_length = 0;
			const gchar* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp25_;
#line 154 "document_structure.vala"
			if (!_tmp6_) {
#line 196 "document_structure.vala"
				if (!gtk_text_iter_forward_line (&line_iter)) {
#line 196 "document_structure.vala"
					break;
#line 734 "document_structure.c"
				}
			}
#line 154 "document_structure.vala"
			_tmp6_ = FALSE;
#line 158 "document_structure.vala"
			if (nb_lines_parsed == DOCUMENT_STRUCTURE_MAX_NB_LINES_TO_PARSE) {
#line 160 "document_structure.vala"
				self->priv->_start_parsing_line = self->priv->_start_parsing_line + DOCUMENT_STRUCTURE_MAX_NB_LINES_TO_PARSE;
#line 162 "document_structure.vala"
				if (DOCUMENT_STRUCTURE__measure_parsing_time) {
#line 745 "document_structure.c"
					GTimer* _tmp7_;
#line 163 "document_structure.vala"
					_tmp7_ = self->priv->_timer;
#line 163 "document_structure.vala"
					g_timer_stop (_tmp7_);
#line 751 "document_structure.c"
				}
#line 165 "document_structure.vala"
				result = TRUE;
#line 165 "document_structure.vala"
				return result;
#line 757 "document_structure.c"
			}
#line 169 "document_structure.vala"
			_tmp8_ = line_iter;
#line 169 "document_structure.vala"
			_tmp9_ = document_structure_get_line_contents_at_iter (self, &_tmp8_);
#line 169 "document_structure.vala"
			line_text = _tmp9_;
#line 172 "document_structure.vala"
			start_index = 0;
#line 173 "document_structure.vala"
			_tmp10_ = line_text;
#line 173 "document_structure.vala"
			_tmp11_ = strlen (_tmp10_);
#line 173 "document_structure.vala"
			_tmp12_ = _tmp11_;
#line 173 "document_structure.vala"
			line_length = _tmp12_;
#line 174 "document_structure.vala"
			while (TRUE) {
#line 777 "document_structure.c"
				StructType* type = NULL;
				gchar* contents = NULL;
				gint* start_match_index = NULL;
				gint* end_match_index = NULL;
				gboolean item_found = FALSE;
				const gchar* _tmp13_;
				StructType* _tmp14_ = NULL;
				gchar* _tmp15_ = NULL;
				gint* _tmp16_ = NULL;
				gint* _tmp17_ = NULL;
				gboolean _tmp18_;
				GtkTextIter iter = {0};
				GtkTextIter _tmp19_;
				gint* _tmp20_;
				StructType* _tmp21_;
				const gchar* _tmp22_;
				GtkTextIter _tmp23_;
				gint* _tmp24_;
#line 174 "document_structure.vala"
				if (!(start_index < line_length)) {
#line 174 "document_structure.vala"
					break;
#line 800 "document_structure.c"
				}
#line 181 "document_structure.vala"
				_tmp13_ = line_text;
#line 181 "document_structure.vala"
				_tmp18_ = document_structure_search_low_level_item (self, _tmp13_, start_index, &_tmp14_, &_tmp15_, &_tmp16_, &_tmp17_);
#line 181 "document_structure.vala"
				_g_free0 (type);
#line 181 "document_structure.vala"
				type = _tmp14_;
#line 181 "document_structure.vala"
				_g_free0 (contents);
#line 181 "document_structure.vala"
				contents = _tmp15_;
#line 181 "document_structure.vala"
				_g_free0 (start_match_index);
#line 181 "document_structure.vala"
				start_match_index = _tmp16_;
#line 181 "document_structure.vala"
				_g_free0 (end_match_index);
#line 181 "document_structure.vala"
				end_match_index = _tmp17_;
#line 181 "document_structure.vala"
				item_found = _tmp18_;
#line 184 "document_structure.vala"
				if (!item_found) {
#line 185 "document_structure.vala"
					_g_free0 (end_match_index);
#line 185 "document_structure.vala"
					_g_free0 (start_match_index);
#line 185 "document_structure.vala"
					_g_free0 (contents);
#line 185 "document_structure.vala"
					_g_free0 (type);
#line 185 "document_structure.vala"
					break;
#line 836 "document_structure.c"
				}
#line 187 "document_structure.vala"
				_tmp19_ = line_iter;
#line 187 "document_structure.vala"
				iter = _tmp19_;
#line 188 "document_structure.vala"
				_tmp20_ = start_match_index;
#line 188 "document_structure.vala"
				gtk_text_iter_set_line_index (&iter, *_tmp20_);
#line 189 "document_structure.vala"
				_tmp21_ = type;
#line 189 "document_structure.vala"
				_tmp22_ = contents;
#line 189 "document_structure.vala"
				_tmp23_ = iter;
#line 189 "document_structure.vala"
				document_structure_handle_item (self, *_tmp21_, _tmp22_, &_tmp23_);
#line 191 "document_structure.vala"
				_tmp24_ = end_match_index;
#line 191 "document_structure.vala"
				start_index = *_tmp24_;
#line 174 "document_structure.vala"
				_g_free0 (end_match_index);
#line 174 "document_structure.vala"
				_g_free0 (start_match_index);
#line 174 "document_structure.vala"
				_g_free0 (contents);
#line 174 "document_structure.vala"
				_g_free0 (type);
#line 866 "document_structure.c"
			}
#line 194 "document_structure.vala"
			_tmp25_ = nb_lines_parsed;
#line 194 "document_structure.vala"
			nb_lines_parsed = _tmp25_ + 1;
#line 154 "document_structure.vala"
			_g_free0 (line_text);
#line 874 "document_structure.c"
		}
	}
#line 198 "document_structure.vala"
	if (DOCUMENT_STRUCTURE__measure_parsing_time) {
#line 879 "document_structure.c"
		GTimer* _tmp26_;
		GTimer* _tmp27_;
		GTimer* _tmp28_;
#line 200 "document_structure.vala"
		_tmp26_ = self->priv->_timer;
#line 200 "document_structure.vala"
		g_timer_stop (_tmp26_);
#line 201 "document_structure.vala"
		_tmp27_ = self->priv->_timer;
#line 201 "document_structure.vala"
		g_message ("document_structure.vala:201: Structure parsing took %f seconds", g_timer_elapsed (_tmp27_, NULL));
#line 202 "document_structure.vala"
		_tmp28_ = self->priv->_timer;
#line 202 "document_structure.vala"
		g_timer_reset (_tmp28_);
#line 895 "document_structure.c"
	}
#line 205 "document_structure.vala"
	document_structure_set_parsing_done (self, TRUE);
#line 206 "document_structure.vala"
	result = FALSE;
#line 206 "document_structure.vala"
	return result;
#line 903 "document_structure.c"
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
#line 240 "document_structure.vala"
	dup = g_new0 (gint, 1);
#line 240 "document_structure.vala"
	memcpy (dup, self, sizeof (gint));
#line 240 "document_structure.vala"
	return dup;
#line 916 "document_structure.c"
}

static gpointer
__int_dup0 (gpointer self)
{
#line 240 "document_structure.vala"
	return self ? _int_dup (self) : NULL;
#line 924 "document_structure.c"
}

static gboolean
document_structure_search_low_level_item (DocumentStructure* self,
                                          const gchar* line,
                                          gint start_index,
                                          StructType** type,
                                          gchar* * contents,
                                          gint** start_match_index,
                                          gint** end_match_index)
{
	StructType* _vala_type = NULL;
	gchar* _vala_contents = NULL;
	gint* _vala_start_match_index = NULL;
	gint* _vala_end_match_index = NULL;
	GMatchInfo* match_info = NULL;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
#line 216 "document_structure.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 216 "document_structure.vala"
	g_return_val_if_fail (line != NULL, FALSE);
#line 220 "document_structure.vala"
	_g_free0 (_vala_type);
#line 220 "document_structure.vala"
	_vala_type = NULL;
#line 221 "document_structure.vala"
	_g_free0 (_vala_contents);
#line 221 "document_structure.vala"
	_vala_contents = NULL;
#line 222 "document_structure.vala"
	_g_free0 (_vala_start_match_index);
#line 222 "document_structure.vala"
	_vala_start_match_index = NULL;
#line 223 "document_structure.vala"
	_g_free0 (_vala_end_match_index);
#line 223 "document_structure.vala"
	_vala_end_match_index = NULL;
#line 963 "document_structure.c"
	{
		GRegex* _tmp0_;
		GMatchInfo* _tmp1_ = NULL;
#line 229 "document_structure.vala"
		_tmp0_ = document_structure__chars_regex;
#line 229 "document_structure.vala"
		g_regex_match_full (_tmp0_, line, (gssize) -1, start_index, 0, &_tmp1_, &_inner_error0_);
#line 229 "document_structure.vala"
		_g_match_info_unref0 (match_info);
#line 229 "document_structure.vala"
		match_info = _tmp1_;
#line 229 "document_structure.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 977 "document_structure.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
#line 227 "document_structure.vala"
		e = _inner_error0_;
#line 227 "document_structure.vala"
		_inner_error0_ = NULL;
#line 233 "document_structure.vala"
		_tmp2_ = e;
#line 233 "document_structure.vala"
		_tmp3_ = _tmp2_->message;
#line 233 "document_structure.vala"
		g_warning ("document_structure.vala:233: Structure parsing: chars regex: %s", _tmp3_);
#line 234 "document_structure.vala"
		result = FALSE;
#line 234 "document_structure.vala"
		_g_error_free0 (e);
#line 234 "document_structure.vala"
		_g_match_info_unref0 (match_info);
#line 234 "document_structure.vala"
		if (type) {
#line 234 "document_structure.vala"
			*type = _vala_type;
#line 1007 "document_structure.c"
		} else {
#line 234 "document_structure.vala"
			_g_free0 (_vala_type);
#line 1011 "document_structure.c"
		}
#line 234 "document_structure.vala"
		if (contents) {
#line 234 "document_structure.vala"
			*contents = _vala_contents;
#line 1017 "document_structure.c"
		} else {
#line 234 "document_structure.vala"
			_g_free0 (_vala_contents);
#line 1021 "document_structure.c"
		}
#line 234 "document_structure.vala"
		if (start_match_index) {
#line 234 "document_structure.vala"
			*start_match_index = _vala_start_match_index;
#line 1027 "document_structure.c"
		} else {
#line 234 "document_structure.vala"
			_g_free0 (_vala_start_match_index);
#line 1031 "document_structure.c"
		}
#line 234 "document_structure.vala"
		if (end_match_index) {
#line 234 "document_structure.vala"
			*end_match_index = _vala_end_match_index;
#line 1037 "document_structure.c"
		} else {
#line 234 "document_structure.vala"
			_g_free0 (_vala_end_match_index);
#line 1041 "document_structure.c"
		}
#line 234 "document_structure.vala"
		return result;
#line 1045 "document_structure.c"
	}
	__finally0:
#line 227 "document_structure.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1050 "document_structure.c"
		gboolean _tmp4_ = FALSE;
#line 227 "document_structure.vala"
		_g_match_info_unref0 (match_info);
#line 227 "document_structure.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 227 "document_structure.vala"
		g_clear_error (&_inner_error0_);
#line 227 "document_structure.vala"
		return _tmp4_;
#line 1060 "document_structure.c"
	}
#line 237 "document_structure.vala"
	while (TRUE) {
#line 1064 "document_structure.c"
		GMatchInfo* _tmp5_;
		gint after_char_index = 0;
		GMatchInfo* _tmp6_;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gboolean _tmp9_;
		gint _tmp10_;
		gint* _tmp11_;
		gint* _tmp12_;
#line 237 "document_structure.vala"
		_tmp5_ = match_info;
#line 237 "document_structure.vala"
		if (!g_match_info_matches (_tmp5_)) {
#line 237 "document_structure.vala"
			break;
#line 1080 "document_structure.c"
		}
#line 240 "document_structure.vala"
		_tmp6_ = match_info;
#line 240 "document_structure.vala"
		_tmp9_ = g_match_info_fetch_pos (_tmp6_, 0, &_tmp7_, &_tmp8_);
#line 240 "document_structure.vala"
		_g_free0 (_vala_start_match_index);
#line 240 "document_structure.vala"
		_tmp10_ = _tmp7_;
#line 240 "document_structure.vala"
		_tmp11_ = __int_dup0 (&_tmp10_);
#line 240 "document_structure.vala"
		_vala_start_match_index = _tmp11_;
#line 240 "document_structure.vala"
		after_char_index = _tmp8_;
#line 240 "document_structure.vala"
		if (!_tmp9_) {
#line 242 "document_structure.vala"
			g_warning ("document_structure.vala:242: Structure parsing: position can not be fe" \
"tched");
#line 243 "document_structure.vala"
			result = FALSE;
#line 243 "document_structure.vala"
			_g_match_info_unref0 (match_info);
#line 243 "document_structure.vala"
			if (type) {
#line 243 "document_structure.vala"
				*type = _vala_type;
#line 1108 "document_structure.c"
			} else {
#line 243 "document_structure.vala"
				_g_free0 (_vala_type);
#line 1112 "document_structure.c"
			}
#line 243 "document_structure.vala"
			if (contents) {
#line 243 "document_structure.vala"
				*contents = _vala_contents;
#line 1118 "document_structure.c"
			} else {
#line 243 "document_structure.vala"
				_g_free0 (_vala_contents);
#line 1122 "document_structure.c"
			}
#line 243 "document_structure.vala"
			if (start_match_index) {
#line 243 "document_structure.vala"
				*start_match_index = _vala_start_match_index;
#line 1128 "document_structure.c"
			} else {
#line 243 "document_structure.vala"
				_g_free0 (_vala_start_match_index);
#line 1132 "document_structure.c"
			}
#line 243 "document_structure.vala"
			if (end_match_index) {
#line 243 "document_structure.vala"
				*end_match_index = _vala_end_match_index;
#line 1138 "document_structure.c"
			} else {
#line 243 "document_structure.vala"
				_g_free0 (_vala_end_match_index);
#line 1142 "document_structure.c"
			}
#line 243 "document_structure.vala"
			return result;
#line 1146 "document_structure.c"
		}
#line 246 "document_structure.vala"
		_tmp12_ = _vala_start_match_index;
#line 246 "document_structure.vala"
		if (!utils_char_is_escaped (line, *_tmp12_)) {
#line 1152 "document_structure.c"
			gchar* char_matched = NULL;
			GMatchInfo* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
#line 248 "document_structure.vala"
			_tmp13_ = match_info;
#line 248 "document_structure.vala"
			_tmp14_ = g_match_info_fetch (_tmp13_, 0);
#line 248 "document_structure.vala"
			char_matched = _tmp14_;
#line 251 "document_structure.vala"
			_tmp15_ = char_matched;
#line 251 "document_structure.vala"
			if (g_strcmp0 (_tmp15_, "\\") == 0) {
#line 1167 "document_structure.c"
				gboolean markup_found = FALSE;
				StructType* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				gint* _tmp18_ = NULL;
				gboolean _tmp19_;
#line 253 "document_structure.vala"
				_tmp19_ = document_structure_search_markup (self, line, after_char_index, &_tmp16_, &_tmp17_, &_tmp18_);
#line 253 "document_structure.vala"
				_g_free0 (_vala_type);
#line 253 "document_structure.vala"
				_vala_type = _tmp16_;
#line 253 "document_structure.vala"
				_g_free0 (_vala_contents);
#line 253 "document_structure.vala"
				_vala_contents = _tmp17_;
#line 253 "document_structure.vala"
				_g_free0 (_vala_end_match_index);
#line 253 "document_structure.vala"
				_vala_end_match_index = _tmp18_;
#line 253 "document_structure.vala"
				markup_found = _tmp19_;
#line 256 "document_structure.vala"
				if (markup_found) {
#line 257 "document_structure.vala"
					result = TRUE;
#line 257 "document_structure.vala"
					_g_free0 (char_matched);
#line 257 "document_structure.vala"
					_g_match_info_unref0 (match_info);
#line 257 "document_structure.vala"
					if (type) {
#line 257 "document_structure.vala"
						*type = _vala_type;
#line 1201 "document_structure.c"
					} else {
#line 257 "document_structure.vala"
						_g_free0 (_vala_type);
#line 1205 "document_structure.c"
					}
#line 257 "document_structure.vala"
					if (contents) {
#line 257 "document_structure.vala"
						*contents = _vala_contents;
#line 1211 "document_structure.c"
					} else {
#line 257 "document_structure.vala"
						_g_free0 (_vala_contents);
#line 1215 "document_structure.c"
					}
#line 257 "document_structure.vala"
					if (start_match_index) {
#line 257 "document_structure.vala"
						*start_match_index = _vala_start_match_index;
#line 1221 "document_structure.c"
					} else {
#line 257 "document_structure.vala"
						_g_free0 (_vala_start_match_index);
#line 1225 "document_structure.c"
					}
#line 257 "document_structure.vala"
					if (end_match_index) {
#line 257 "document_structure.vala"
						*end_match_index = _vala_end_match_index;
#line 1231 "document_structure.c"
					} else {
#line 257 "document_structure.vala"
						_g_free0 (_vala_end_match_index);
#line 1235 "document_structure.c"
					}
#line 257 "document_structure.vala"
					return result;
#line 1239 "document_structure.c"
				}
			} else {
				StructType* _tmp20_ = NULL;
				gchar* _tmp21_ = NULL;
				gint* _tmp22_ = NULL;
				gboolean _tmp23_;
#line 267 "document_structure.vala"
				_tmp23_ = document_structure_search_comment (self, line, after_char_index, &_tmp20_, &_tmp21_, &_tmp22_);
#line 267 "document_structure.vala"
				_g_free0 (_vala_type);
#line 267 "document_structure.vala"
				_vala_type = _tmp20_;
#line 267 "document_structure.vala"
				_g_free0 (_vala_contents);
#line 267 "document_structure.vala"
				_vala_contents = _tmp21_;
#line 267 "document_structure.vala"
				_g_free0 (_vala_end_match_index);
#line 267 "document_structure.vala"
				_vala_end_match_index = _tmp22_;
#line 267 "document_structure.vala"
				result = _tmp23_;
#line 267 "document_structure.vala"
				_g_free0 (char_matched);
#line 267 "document_structure.vala"
				_g_match_info_unref0 (match_info);
#line 267 "document_structure.vala"
				if (type) {
#line 267 "document_structure.vala"
					*type = _vala_type;
#line 1270 "document_structure.c"
				} else {
#line 267 "document_structure.vala"
					_g_free0 (_vala_type);
#line 1274 "document_structure.c"
				}
#line 267 "document_structure.vala"
				if (contents) {
#line 267 "document_structure.vala"
					*contents = _vala_contents;
#line 1280 "document_structure.c"
				} else {
#line 267 "document_structure.vala"
					_g_free0 (_vala_contents);
#line 1284 "document_structure.c"
				}
#line 267 "document_structure.vala"
				if (start_match_index) {
#line 267 "document_structure.vala"
					*start_match_index = _vala_start_match_index;
#line 1290 "document_structure.c"
				} else {
#line 267 "document_structure.vala"
					_g_free0 (_vala_start_match_index);
#line 1294 "document_structure.c"
				}
#line 267 "document_structure.vala"
				if (end_match_index) {
#line 267 "document_structure.vala"
					*end_match_index = _vala_end_match_index;
#line 1300 "document_structure.c"
				} else {
#line 267 "document_structure.vala"
					_g_free0 (_vala_end_match_index);
#line 1304 "document_structure.c"
				}
#line 267 "document_structure.vala"
				return result;
#line 1308 "document_structure.c"
			}
#line 246 "document_structure.vala"
			_g_free0 (char_matched);
#line 1312 "document_structure.c"
		}
		{
			GMatchInfo* _tmp24_;
#line 274 "document_structure.vala"
			_tmp24_ = match_info;
#line 274 "document_structure.vala"
			g_match_info_next (_tmp24_, &_inner_error0_);
#line 274 "document_structure.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1322 "document_structure.c"
				gboolean _tmp25_ = FALSE;
#line 274 "document_structure.vala"
				if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1326 "document_structure.c"
					goto __catch1_g_regex_error;
				}
#line 274 "document_structure.vala"
				_g_match_info_unref0 (match_info);
#line 274 "document_structure.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 274 "document_structure.vala"
				g_clear_error (&_inner_error0_);
#line 274 "document_structure.vala"
				return _tmp25_;
#line 1337 "document_structure.c"
			}
		}
		goto __finally1;
		__catch1_g_regex_error:
		{
			GError* e = NULL;
			GError* _tmp26_;
			const gchar* _tmp27_;
#line 272 "document_structure.vala"
			e = _inner_error0_;
#line 272 "document_structure.vala"
			_inner_error0_ = NULL;
#line 278 "document_structure.vala"
			_tmp26_ = e;
#line 278 "document_structure.vala"
			_tmp27_ = _tmp26_->message;
#line 278 "document_structure.vala"
			g_warning ("document_structure.vala:278: Structure parsing: %s", _tmp27_);
#line 279 "document_structure.vala"
			_g_error_free0 (e);
#line 279 "document_structure.vala"
			break;
#line 1360 "document_structure.c"
		}
		__finally1:
#line 272 "document_structure.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1365 "document_structure.c"
			gboolean _tmp28_ = FALSE;
#line 272 "document_structure.vala"
			_g_match_info_unref0 (match_info);
#line 272 "document_structure.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 272 "document_structure.vala"
			g_clear_error (&_inner_error0_);
#line 272 "document_structure.vala"
			return _tmp28_;
#line 1375 "document_structure.c"
		}
	}
#line 283 "document_structure.vala"
	result = FALSE;
#line 283 "document_structure.vala"
	_g_match_info_unref0 (match_info);
#line 283 "document_structure.vala"
	if (type) {
#line 283 "document_structure.vala"
		*type = _vala_type;
#line 1386 "document_structure.c"
	} else {
#line 283 "document_structure.vala"
		_g_free0 (_vala_type);
#line 1390 "document_structure.c"
	}
#line 283 "document_structure.vala"
	if (contents) {
#line 283 "document_structure.vala"
		*contents = _vala_contents;
#line 1396 "document_structure.c"
	} else {
#line 283 "document_structure.vala"
		_g_free0 (_vala_contents);
#line 1400 "document_structure.c"
	}
#line 283 "document_structure.vala"
	if (start_match_index) {
#line 283 "document_structure.vala"
		*start_match_index = _vala_start_match_index;
#line 1406 "document_structure.c"
	} else {
#line 283 "document_structure.vala"
		_g_free0 (_vala_start_match_index);
#line 1410 "document_structure.c"
	}
#line 283 "document_structure.vala"
	if (end_match_index) {
#line 283 "document_structure.vala"
		*end_match_index = _vala_end_match_index;
#line 1416 "document_structure.c"
	} else {
#line 283 "document_structure.vala"
		_g_free0 (_vala_end_match_index);
#line 1420 "document_structure.c"
	}
#line 283 "document_structure.vala"
	return result;
#line 1424 "document_structure.c"
}

static gboolean
document_structure_search_markup (DocumentStructure* self,
                                  const gchar* line,
                                  gint after_backslash_index,
                                  StructType** type,
                                  gchar* * contents,
                                  gint** end_match_index)
{
	StructType* _vala_type = NULL;
	gchar* _vala_contents = NULL;
	gint* _vala_end_match_index = NULL;
	gint* begin_contents_index = NULL;
	gchar* name = NULL;
	gint* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean is_begin_env = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp10_;
	StructType* _tmp11_;
	StructType* _tmp12_;
	gint* _tmp13_;
	gint* _tmp14_ = NULL;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gboolean result = FALSE;
#line 286 "document_structure.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 286 "document_structure.vala"
	g_return_val_if_fail (line != NULL, FALSE);
#line 289 "document_structure.vala"
	_g_free0 (_vala_type);
#line 289 "document_structure.vala"
	_vala_type = NULL;
#line 290 "document_structure.vala"
	_g_free0 (_vala_contents);
#line 290 "document_structure.vala"
	_vala_contents = NULL;
#line 291 "document_structure.vala"
	_g_free0 (_vala_end_match_index);
#line 291 "document_structure.vala"
	_vala_end_match_index = NULL;
#line 295 "document_structure.vala"
	_tmp1_ = document_structure_get_markup_name (self, line, after_backslash_index, &_tmp0_);
#line 295 "document_structure.vala"
	_g_free0 (begin_contents_index);
#line 295 "document_structure.vala"
	begin_contents_index = _tmp0_;
#line 295 "document_structure.vala"
	name = _tmp1_;
#line 298 "document_structure.vala"
	_tmp2_ = name;
#line 298 "document_structure.vala"
	if (_tmp2_ == NULL) {
#line 299 "document_structure.vala"
		result = FALSE;
#line 299 "document_structure.vala"
		_g_free0 (name);
#line 299 "document_structure.vala"
		_g_free0 (begin_contents_index);
#line 299 "document_structure.vala"
		if (type) {
#line 299 "document_structure.vala"
			*type = _vala_type;
#line 1492 "document_structure.c"
		} else {
#line 299 "document_structure.vala"
			_g_free0 (_vala_type);
#line 1496 "document_structure.c"
		}
#line 299 "document_structure.vala"
		if (contents) {
#line 299 "document_structure.vala"
			*contents = _vala_contents;
#line 1502 "document_structure.c"
		} else {
#line 299 "document_structure.vala"
			_g_free0 (_vala_contents);
#line 1506 "document_structure.c"
		}
#line 299 "document_structure.vala"
		if (end_match_index) {
#line 299 "document_structure.vala"
			*end_match_index = _vala_end_match_index;
#line 1512 "document_structure.c"
		} else {
#line 299 "document_structure.vala"
			_g_free0 (_vala_end_match_index);
#line 1516 "document_structure.c"
		}
#line 299 "document_structure.vala"
		return result;
#line 1520 "document_structure.c"
	}
#line 302 "document_structure.vala"
	_tmp3_ = name;
#line 302 "document_structure.vala"
	is_begin_env = g_strcmp0 (_tmp3_, "begin") == 0;
#line 303 "document_structure.vala"
	if (is_begin_env) {
#line 303 "document_structure.vala"
		_tmp4_ = TRUE;
#line 1530 "document_structure.c"
	} else {
		const gchar* _tmp5_;
#line 303 "document_structure.vala"
		_tmp5_ = name;
#line 303 "document_structure.vala"
		_tmp4_ = g_strcmp0 (_tmp5_, "end") == 0;
#line 1537 "document_structure.c"
	}
#line 303 "document_structure.vala"
	if (_tmp4_) {
#line 1541 "document_structure.c"
		gint* _tmp6_;
		StructType* _tmp7_ = NULL;
		gint* _tmp8_ = NULL;
		gboolean _tmp9_;
#line 305 "document_structure.vala"
		_g_free0 (_vala_contents);
#line 305 "document_structure.vala"
		_vala_contents = NULL;
#line 306 "document_structure.vala"
		_tmp6_ = begin_contents_index;
#line 306 "document_structure.vala"
		_tmp9_ = document_structure_search_env (self, line, *_tmp6_, is_begin_env, &_tmp7_, &_tmp8_);
#line 306 "document_structure.vala"
		_g_free0 (_vala_type);
#line 306 "document_structure.vala"
		_vala_type = _tmp7_;
#line 306 "document_structure.vala"
		_g_free0 (_vala_end_match_index);
#line 306 "document_structure.vala"
		_vala_end_match_index = _tmp8_;
#line 306 "document_structure.vala"
		result = _tmp9_;
#line 306 "document_structure.vala"
		_g_free0 (name);
#line 306 "document_structure.vala"
		_g_free0 (begin_contents_index);
#line 306 "document_structure.vala"
		if (type) {
#line 306 "document_structure.vala"
			*type = _vala_type;
#line 1572 "document_structure.c"
		} else {
#line 306 "document_structure.vala"
			_g_free0 (_vala_type);
#line 1576 "document_structure.c"
		}
#line 306 "document_structure.vala"
		if (contents) {
#line 306 "document_structure.vala"
			*contents = _vala_contents;
#line 1582 "document_structure.c"
		} else {
#line 306 "document_structure.vala"
			_g_free0 (_vala_contents);
#line 1586 "document_structure.c"
		}
#line 306 "document_structure.vala"
		if (end_match_index) {
#line 306 "document_structure.vala"
			*end_match_index = _vala_end_match_index;
#line 1592 "document_structure.c"
		} else {
#line 306 "document_structure.vala"
			_g_free0 (_vala_end_match_index);
#line 1596 "document_structure.c"
		}
#line 306 "document_structure.vala"
		return result;
#line 1600 "document_structure.c"
	}
#line 311 "document_structure.vala"
	_tmp10_ = name;
#line 311 "document_structure.vala"
	_tmp11_ = document_structure_get_markup_type (self, _tmp10_);
#line 311 "document_structure.vala"
	_g_free0 (_vala_type);
#line 311 "document_structure.vala"
	_vala_type = _tmp11_;
#line 312 "document_structure.vala"
	_tmp12_ = _vala_type;
#line 312 "document_structure.vala"
	if (_tmp12_ == NULL) {
#line 313 "document_structure.vala"
		result = FALSE;
#line 313 "document_structure.vala"
		_g_free0 (name);
#line 313 "document_structure.vala"
		_g_free0 (begin_contents_index);
#line 313 "document_structure.vala"
		if (type) {
#line 313 "document_structure.vala"
			*type = _vala_type;
#line 1624 "document_structure.c"
		} else {
#line 313 "document_structure.vala"
			_g_free0 (_vala_type);
#line 1628 "document_structure.c"
		}
#line 313 "document_structure.vala"
		if (contents) {
#line 313 "document_structure.vala"
			*contents = _vala_contents;
#line 1634 "document_structure.c"
		} else {
#line 313 "document_structure.vala"
			_g_free0 (_vala_contents);
#line 1638 "document_structure.c"
		}
#line 313 "document_structure.vala"
		if (end_match_index) {
#line 313 "document_structure.vala"
			*end_match_index = _vala_end_match_index;
#line 1644 "document_structure.c"
		} else {
#line 313 "document_structure.vala"
			_g_free0 (_vala_end_match_index);
#line 1648 "document_structure.c"
		}
#line 313 "document_structure.vala"
		return result;
#line 1652 "document_structure.c"
	}
#line 315 "document_structure.vala"
	_tmp13_ = begin_contents_index;
#line 315 "document_structure.vala"
	_tmp15_ = document_structure_get_markup_contents (self, line, *_tmp13_, &_tmp14_);
#line 315 "document_structure.vala"
	_g_free0 (_vala_end_match_index);
#line 315 "document_structure.vala"
	_vala_end_match_index = _tmp14_;
#line 315 "document_structure.vala"
	_g_free0 (_vala_contents);
#line 315 "document_structure.vala"
	_vala_contents = _tmp15_;
#line 316 "document_structure.vala"
	_tmp16_ = _vala_contents;
#line 316 "document_structure.vala"
	result = _tmp16_ != NULL;
#line 316 "document_structure.vala"
	_g_free0 (name);
#line 316 "document_structure.vala"
	_g_free0 (begin_contents_index);
#line 316 "document_structure.vala"
	if (type) {
#line 316 "document_structure.vala"
		*type = _vala_type;
#line 1678 "document_structure.c"
	} else {
#line 316 "document_structure.vala"
		_g_free0 (_vala_type);
#line 1682 "document_structure.c"
	}
#line 316 "document_structure.vala"
	if (contents) {
#line 316 "document_structure.vala"
		*contents = _vala_contents;
#line 1688 "document_structure.c"
	} else {
#line 316 "document_structure.vala"
		_g_free0 (_vala_contents);
#line 1692 "document_structure.c"
	}
#line 316 "document_structure.vala"
	if (end_match_index) {
#line 316 "document_structure.vala"
		*end_match_index = _vala_end_match_index;
#line 1698 "document_structure.c"
	} else {
#line 316 "document_structure.vala"
		_g_free0 (_vala_end_match_index);
#line 1702 "document_structure.c"
	}
#line 316 "document_structure.vala"
	return result;
#line 1706 "document_structure.c"
}

static StructType*
_struct_type_dup (StructType* self)
{
	StructType* dup;
#line 332 "document_structure.vala"
	dup = g_new0 (StructType, 1);
#line 332 "document_structure.vala"
	memcpy (dup, self, sizeof (StructType));
#line 332 "document_structure.vala"
	return dup;
#line 1719 "document_structure.c"
}

static gpointer
__struct_type_dup0 (gpointer self)
{
#line 332 "document_structure.vala"
	return self ? _struct_type_dup (self) : NULL;
#line 1727 "document_structure.c"
}

static gboolean
document_structure_search_env (DocumentStructure* self,
                               const gchar* line,
                               gint begin_contents_index,
                               gboolean is_begin_env,
                               StructType** type,
                               gint** end_match_index)
{
	StructType* _vala_type = NULL;
	gint* _vala_end_match_index = NULL;
	gchar* contents = NULL;
	gint* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	const gchar* _tmp8_;
	const gchar* _tmp11_;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_;
	gboolean result = FALSE;
#line 319 "document_structure.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 319 "document_structure.vala"
	g_return_val_if_fail (line != NULL, FALSE);
#line 322 "document_structure.vala"
	_g_free0 (_vala_type);
#line 322 "document_structure.vala"
	_vala_type = NULL;
#line 324 "document_structure.vala"
	_tmp1_ = document_structure_get_markup_contents (self, line, begin_contents_index, &_tmp0_);
#line 324 "document_structure.vala"
	_g_free0 (_vala_end_match_index);
#line 324 "document_structure.vala"
	_vala_end_match_index = _tmp0_;
#line 324 "document_structure.vala"
	contents = _tmp1_;
#line 327 "document_structure.vala"
	_tmp2_ = contents;
#line 327 "document_structure.vala"
	if (_tmp2_ == NULL) {
#line 328 "document_structure.vala"
		result = FALSE;
#line 328 "document_structure.vala"
		_g_free0 (contents);
#line 328 "document_structure.vala"
		if (type) {
#line 328 "document_structure.vala"
			*type = _vala_type;
#line 1779 "document_structure.c"
		} else {
#line 328 "document_structure.vala"
			_g_free0 (_vala_type);
#line 1783 "document_structure.c"
		}
#line 328 "document_structure.vala"
		if (end_match_index) {
#line 328 "document_structure.vala"
			*end_match_index = _vala_end_match_index;
#line 1789 "document_structure.c"
		} else {
#line 328 "document_structure.vala"
			_g_free0 (_vala_end_match_index);
#line 1793 "document_structure.c"
		}
#line 328 "document_structure.vala"
		return result;
#line 1797 "document_structure.c"
	}
#line 330 "document_structure.vala"
	_tmp4_ = contents;
#line 330 "document_structure.vala"
	if (g_strcmp0 (_tmp4_, "verbatim") == 0) {
#line 330 "document_structure.vala"
		_tmp3_ = TRUE;
#line 1805 "document_structure.c"
	} else {
		const gchar* _tmp5_;
#line 330 "document_structure.vala"
		_tmp5_ = contents;
#line 330 "document_structure.vala"
		_tmp3_ = g_strcmp0 (_tmp5_, "verbatim*") == 0;
#line 1812 "document_structure.c"
	}
#line 330 "document_structure.vala"
	if (_tmp3_) {
#line 1816 "document_structure.c"
		StructType _tmp6_ = 0;
		StructType* _tmp7_;
#line 332 "document_structure.vala"
		if (is_begin_env) {
#line 332 "document_structure.vala"
			_tmp6_ = STRUCT_TYPE_BEGIN_VERBATIM;
#line 1823 "document_structure.c"
		} else {
#line 332 "document_structure.vala"
			_tmp6_ = STRUCT_TYPE_END_VERBATIM;
#line 1827 "document_structure.c"
		}
#line 332 "document_structure.vala"
		_tmp7_ = __struct_type_dup0 (&_tmp6_);
#line 332 "document_structure.vala"
		_g_free0 (_vala_type);
#line 332 "document_structure.vala"
		_vala_type = _tmp7_;
#line 333 "document_structure.vala"
		result = TRUE;
#line 333 "document_structure.vala"
		_g_free0 (contents);
#line 333 "document_structure.vala"
		if (type) {
#line 333 "document_structure.vala"
			*type = _vala_type;
#line 1843 "document_structure.c"
		} else {
#line 333 "document_structure.vala"
			_g_free0 (_vala_type);
#line 1847 "document_structure.c"
		}
#line 333 "document_structure.vala"
		if (end_match_index) {
#line 333 "document_structure.vala"
			*end_match_index = _vala_end_match_index;
#line 1853 "document_structure.c"
		} else {
#line 333 "document_structure.vala"
			_g_free0 (_vala_end_match_index);
#line 1857 "document_structure.c"
		}
#line 333 "document_structure.vala"
		return result;
#line 1861 "document_structure.c"
	}
#line 336 "document_structure.vala"
	_tmp8_ = contents;
#line 336 "document_structure.vala"
	if (g_strcmp0 (_tmp8_, "figure") == 0) {
#line 1867 "document_structure.c"
		StructType _tmp9_ = 0;
		StructType* _tmp10_;
#line 338 "document_structure.vala"
		if (is_begin_env) {
#line 338 "document_structure.vala"
			_tmp9_ = STRUCT_TYPE_BEGIN_FIGURE;
#line 1874 "document_structure.c"
		} else {
#line 338 "document_structure.vala"
			_tmp9_ = STRUCT_TYPE_END_FIGURE;
#line 1878 "document_structure.c"
		}
#line 338 "document_structure.vala"
		_tmp10_ = __struct_type_dup0 (&_tmp9_);
#line 338 "document_structure.vala"
		_g_free0 (_vala_type);
#line 338 "document_structure.vala"
		_vala_type = _tmp10_;
#line 339 "document_structure.vala"
		result = TRUE;
#line 339 "document_structure.vala"
		_g_free0 (contents);
#line 339 "document_structure.vala"
		if (type) {
#line 339 "document_structure.vala"
			*type = _vala_type;
#line 1894 "document_structure.c"
		} else {
#line 339 "document_structure.vala"
			_g_free0 (_vala_type);
#line 1898 "document_structure.c"
		}
#line 339 "document_structure.vala"
		if (end_match_index) {
#line 339 "document_structure.vala"
			*end_match_index = _vala_end_match_index;
#line 1904 "document_structure.c"
		} else {
#line 339 "document_structure.vala"
			_g_free0 (_vala_end_match_index);
#line 1908 "document_structure.c"
		}
#line 339 "document_structure.vala"
		return result;
#line 1912 "document_structure.c"
	}
#line 342 "document_structure.vala"
	_tmp11_ = contents;
#line 342 "document_structure.vala"
	if (g_strcmp0 (_tmp11_, "table") == 0) {
#line 1918 "document_structure.c"
		StructType _tmp12_ = 0;
		StructType* _tmp13_;
#line 344 "document_structure.vala"
		if (is_begin_env) {
#line 344 "document_structure.vala"
			_tmp12_ = STRUCT_TYPE_BEGIN_TABLE;
#line 1925 "document_structure.c"
		} else {
#line 344 "document_structure.vala"
			_tmp12_ = STRUCT_TYPE_END_TABLE;
#line 1929 "document_structure.c"
		}
#line 344 "document_structure.vala"
		_tmp13_ = __struct_type_dup0 (&_tmp12_);
#line 344 "document_structure.vala"
		_g_free0 (_vala_type);
#line 344 "document_structure.vala"
		_vala_type = _tmp13_;
#line 345 "document_structure.vala"
		result = TRUE;
#line 345 "document_structure.vala"
		_g_free0 (contents);
#line 345 "document_structure.vala"
		if (type) {
#line 345 "document_structure.vala"
			*type = _vala_type;
#line 1945 "document_structure.c"
		} else {
#line 345 "document_structure.vala"
			_g_free0 (_vala_type);
#line 1949 "document_structure.c"
		}
#line 345 "document_structure.vala"
		if (end_match_index) {
#line 345 "document_structure.vala"
			*end_match_index = _vala_end_match_index;
#line 1955 "document_structure.c"
		} else {
#line 345 "document_structure.vala"
			_g_free0 (_vala_end_match_index);
#line 1959 "document_structure.c"
		}
#line 345 "document_structure.vala"
		return result;
#line 1963 "document_structure.c"
	}
#line 348 "document_structure.vala"
	_tmp15_ = contents;
#line 348 "document_structure.vala"
	if (g_strcmp0 (_tmp15_, "document") == 0) {
#line 348 "document_structure.vala"
		_tmp14_ = !is_begin_env;
#line 1971 "document_structure.c"
	} else {
#line 348 "document_structure.vala"
		_tmp14_ = FALSE;
#line 1975 "document_structure.c"
	}
#line 348 "document_structure.vala"
	if (_tmp14_) {
#line 1979 "document_structure.c"
		StructType _tmp16_;
		StructType* _tmp17_;
#line 350 "document_structure.vala"
		_tmp16_ = STRUCT_TYPE_END_DOCUMENT;
#line 350 "document_structure.vala"
		_tmp17_ = __struct_type_dup0 (&_tmp16_);
#line 350 "document_structure.vala"
		_g_free0 (_vala_type);
#line 350 "document_structure.vala"
		_vala_type = _tmp17_;
#line 351 "document_structure.vala"
		result = TRUE;
#line 351 "document_structure.vala"
		_g_free0 (contents);
#line 351 "document_structure.vala"
		if (type) {
#line 351 "document_structure.vala"
			*type = _vala_type;
#line 1998 "document_structure.c"
		} else {
#line 351 "document_structure.vala"
			_g_free0 (_vala_type);
#line 2002 "document_structure.c"
		}
#line 351 "document_structure.vala"
		if (end_match_index) {
#line 351 "document_structure.vala"
			*end_match_index = _vala_end_match_index;
#line 2008 "document_structure.c"
		} else {
#line 351 "document_structure.vala"
			_g_free0 (_vala_end_match_index);
#line 2012 "document_structure.c"
		}
#line 351 "document_structure.vala"
		return result;
#line 2016 "document_structure.c"
	}
#line 354 "document_structure.vala"
	result = FALSE;
#line 354 "document_structure.vala"
	_g_free0 (contents);
#line 354 "document_structure.vala"
	if (type) {
#line 354 "document_structure.vala"
		*type = _vala_type;
#line 2026 "document_structure.c"
	} else {
#line 354 "document_structure.vala"
		_g_free0 (_vala_type);
#line 2030 "document_structure.c"
	}
#line 354 "document_structure.vala"
	if (end_match_index) {
#line 354 "document_structure.vala"
		*end_match_index = _vala_end_match_index;
#line 2036 "document_structure.c"
	} else {
#line 354 "document_structure.vala"
		_g_free0 (_vala_end_match_index);
#line 2040 "document_structure.c"
	}
#line 354 "document_structure.vala"
	return result;
#line 2044 "document_structure.c"
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result = 0L;
#line 1447 "glib-2.0.vapi"
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
#line 1447 "glib-2.0.vapi"
	end = _tmp0_;
#line 1448 "glib-2.0.vapi"
	_tmp1_ = end;
#line 1448 "glib-2.0.vapi"
	if (_tmp1_ == NULL) {
#line 1449 "glib-2.0.vapi"
		result = maxlen;
#line 1449 "glib-2.0.vapi"
		return result;
#line 2067 "document_structure.c"
	} else {
		gchar* _tmp2_;
#line 1451 "glib-2.0.vapi"
		_tmp2_ = end;
#line 1451 "glib-2.0.vapi"
		result = (glong) (_tmp2_ - str);
#line 1451 "glib-2.0.vapi"
		return result;
#line 2076 "document_structure.c"
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result = NULL;
#line 1458 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1460 "glib-2.0.vapi"
	if (offset >= ((glong) 0)) {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = len >= ((glong) 0);
#line 2095 "document_structure.c"
	} else {
#line 1460 "glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 2099 "document_structure.c"
	}
#line 1460 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1462 "glib-2.0.vapi"
		string_length = string_strnlen ((gchar*) self, offset + len);
#line 2105 "document_structure.c"
	} else {
		gint _tmp1_;
		gint _tmp2_;
#line 1464 "glib-2.0.vapi"
		_tmp1_ = strlen (self);
#line 1464 "glib-2.0.vapi"
		_tmp2_ = _tmp1_;
#line 1464 "glib-2.0.vapi"
		string_length = (glong) _tmp2_;
#line 2115 "document_structure.c"
	}
#line 1467 "glib-2.0.vapi"
	if (offset < ((glong) 0)) {
#line 1468 "glib-2.0.vapi"
		offset = string_length + offset;
#line 1469 "glib-2.0.vapi"
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
#line 2123 "document_structure.c"
	} else {
#line 1471 "glib-2.0.vapi"
		g_return_val_if_fail (offset <= string_length, NULL);
#line 2127 "document_structure.c"
	}
#line 1473 "glib-2.0.vapi"
	if (len < ((glong) 0)) {
#line 1474 "glib-2.0.vapi"
		len = string_length - offset;
#line 2133 "document_structure.c"
	}
#line 1476 "glib-2.0.vapi"
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
#line 1477 "glib-2.0.vapi"
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
#line 1477 "glib-2.0.vapi"
	result = _tmp3_;
#line 1477 "glib-2.0.vapi"
	return result;
#line 2143 "document_structure.c"
}

static gchar*
document_structure_get_markup_name (DocumentStructure* self,
                                    const gchar* line,
                                    gint after_backslash_index,
                                    gint** begin_contents_index)
{
	gint* _vala_begin_contents_index = NULL;
	gchar* after_backslash_text = NULL;
	gchar* _tmp0_;
	GMatchInfo* match_info = NULL;
	GRegex* _tmp1_;
	const gchar* _tmp2_;
	GMatchInfo* _tmp3_ = NULL;
	gboolean _tmp4_;
	gint pos = 0;
	GMatchInfo* _tmp5_;
	gint _tmp6_ = 0;
	gint begin_first_arg_index = 0;
	gchar* markup_name = NULL;
	GMatchInfo* _tmp7_;
	gchar* _tmp8_;
	gint _tmp9_ = 0;
	gboolean _tmp10_;
	gint _tmp11_;
	gint* _tmp12_;
	gchar* result = NULL;
#line 358 "document_structure.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 358 "document_structure.vala"
	g_return_val_if_fail (line != NULL, NULL);
#line 361 "document_structure.vala"
	_g_free0 (_vala_begin_contents_index);
#line 361 "document_structure.vala"
	_vala_begin_contents_index = NULL;
#line 364 "document_structure.vala"
	_tmp0_ = string_substring (line, (glong) after_backslash_index, (glong) -1);
#line 364 "document_structure.vala"
	after_backslash_text = _tmp0_;
#line 367 "document_structure.vala"
	_tmp1_ = document_structure__command_name_regex;
#line 367 "document_structure.vala"
	_tmp2_ = after_backslash_text;
#line 367 "document_structure.vala"
	_tmp4_ = g_regex_match (_tmp1_, _tmp2_, 0, &_tmp3_);
#line 367 "document_structure.vala"
	_g_match_info_unref0 (match_info);
#line 367 "document_structure.vala"
	match_info = _tmp3_;
#line 367 "document_structure.vala"
	if (!_tmp4_) {
#line 368 "document_structure.vala"
		result = NULL;
#line 368 "document_structure.vala"
		_g_match_info_unref0 (match_info);
#line 368 "document_structure.vala"
		_g_free0 (after_backslash_text);
#line 368 "document_structure.vala"
		if (begin_contents_index) {
#line 368 "document_structure.vala"
			*begin_contents_index = _vala_begin_contents_index;
#line 2206 "document_structure.c"
		} else {
#line 368 "document_structure.vala"
			_g_free0 (_vala_begin_contents_index);
#line 2210 "document_structure.c"
		}
#line 368 "document_structure.vala"
		return result;
#line 2214 "document_structure.c"
	}
#line 371 "document_structure.vala"
	_tmp5_ = match_info;
#line 371 "document_structure.vala"
	g_match_info_fetch_pos (_tmp5_, 0, NULL, &_tmp6_);
#line 371 "document_structure.vala"
	pos = _tmp6_;
#line 372 "document_structure.vala"
	begin_first_arg_index = after_backslash_index + pos;
#line 374 "document_structure.vala"
	_tmp7_ = match_info;
#line 374 "document_structure.vala"
	_tmp8_ = g_match_info_fetch_named (_tmp7_, "name");
#line 374 "document_structure.vala"
	markup_name = _tmp8_;
#line 377 "document_structure.vala"
	_tmp10_ = document_structure_search_firt_non_optional_arg (self, line, begin_first_arg_index - 1, &_tmp9_);
#line 377 "document_structure.vala"
	_g_free0 (_vala_begin_contents_index);
#line 377 "document_structure.vala"
	_tmp11_ = _tmp9_;
#line 377 "document_structure.vala"
	_tmp12_ = __int_dup0 (&_tmp11_);
#line 377 "document_structure.vala"
	_vala_begin_contents_index = _tmp12_;
#line 377 "document_structure.vala"
	if (_tmp10_) {
#line 380 "document_structure.vala"
		result = markup_name;
#line 380 "document_structure.vala"
		_g_match_info_unref0 (match_info);
#line 380 "document_structure.vala"
		_g_free0 (after_backslash_text);
#line 380 "document_structure.vala"
		if (begin_contents_index) {
#line 380 "document_structure.vala"
			*begin_contents_index = _vala_begin_contents_index;
#line 2252 "document_structure.c"
		} else {
#line 380 "document_structure.vala"
			_g_free0 (_vala_begin_contents_index);
#line 2256 "document_structure.c"
		}
#line 380 "document_structure.vala"
		return result;
#line 2260 "document_structure.c"
	}
#line 383 "document_structure.vala"
	result = NULL;
#line 383 "document_structure.vala"
	_g_free0 (markup_name);
#line 383 "document_structure.vala"
	_g_match_info_unref0 (match_info);
#line 383 "document_structure.vala"
	_g_free0 (after_backslash_text);
#line 383 "document_structure.vala"
	if (begin_contents_index) {
#line 383 "document_structure.vala"
		*begin_contents_index = _vala_begin_contents_index;
#line 2274 "document_structure.c"
	} else {
#line 383 "document_structure.vala"
		_g_free0 (_vala_begin_contents_index);
#line 2278 "document_structure.c"
	}
#line 383 "document_structure.vala"
	return result;
#line 2282 "document_structure.c"
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
#line 1251 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1252 "glib-2.0.vapi"
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
#line 1253 "glib-2.0.vapi"
	if (_vala_c != ((gunichar) 0)) {
#line 2298 "document_structure.c"
		gchar* _tmp0_;
#line 1254 "glib-2.0.vapi"
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
#line 1254 "glib-2.0.vapi"
		*index = (gint) (_tmp0_ - ((gchar*) self));
#line 1255 "glib-2.0.vapi"
		result = TRUE;
#line 1255 "glib-2.0.vapi"
		if (c) {
#line 1255 "glib-2.0.vapi"
			*c = _vala_c;
#line 2310 "document_structure.c"
		}
#line 1255 "glib-2.0.vapi"
		return result;
#line 2314 "document_structure.c"
	} else {
#line 1257 "glib-2.0.vapi"
		result = FALSE;
#line 1257 "glib-2.0.vapi"
		if (c) {
#line 1257 "glib-2.0.vapi"
			*c = _vala_c;
#line 2322 "document_structure.c"
		}
#line 1257 "glib-2.0.vapi"
		return result;
#line 2326 "document_structure.c"
	}
#line 1251 "glib-2.0.vapi"
	if (c) {
#line 1251 "glib-2.0.vapi"
		*c = _vala_c;
#line 2332 "document_structure.c"
	}
}

static gboolean
document_structure_search_firt_non_optional_arg (DocumentStructure* self,
                                                 const gchar* line,
                                                 gint start_index,
                                                 gint* begin_contents_index)
{
	gint _vala_begin_contents_index = 0;
	gint cur_index = 0;
	gboolean in_optional_arg = FALSE;
	gint additional_bracket_level = 0;
	gboolean result = FALSE;
#line 387 "document_structure.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 387 "document_structure.vala"
	g_return_val_if_fail (line != NULL, FALSE);
#line 390 "document_structure.vala"
	_vala_begin_contents_index = 0;
#line 392 "document_structure.vala"
	cur_index = start_index;
#line 393 "document_structure.vala"
	in_optional_arg = FALSE;
#line 394 "document_structure.vala"
	additional_bracket_level = 0;
#line 396 "document_structure.vala"
	while (TRUE) {
#line 2361 "document_structure.c"
		gint next_index = 0;
		gunichar cur_char = 0U;
		gboolean end = FALSE;
		gunichar _tmp0_ = 0U;
		gboolean _tmp1_;
#line 398 "document_structure.vala"
		next_index = cur_index;
#line 400 "document_structure.vala"
		_tmp1_ = string_get_next_char (line, &next_index, &_tmp0_);
#line 400 "document_structure.vala"
		cur_char = _tmp0_;
#line 400 "document_structure.vala"
		end = !_tmp1_;
#line 402 "document_structure.vala"
		if (in_optional_arg) {
#line 404 "document_structure.vala"
			switch (cur_char) {
#line 404 "document_structure.vala"
				case ']':
#line 2381 "document_structure.c"
				{
#line 407 "document_structure.vala"
					if (!utils_char_is_escaped (line, (glong) cur_index)) {
#line 409 "document_structure.vala"
						if (0 < additional_bracket_level) {
#line 2387 "document_structure.c"
							gint _tmp2_;
#line 410 "document_structure.vala"
							_tmp2_ = additional_bracket_level;
#line 410 "document_structure.vala"
							additional_bracket_level = _tmp2_ - 1;
#line 2393 "document_structure.c"
						} else {
#line 412 "document_structure.vala"
							in_optional_arg = FALSE;
#line 2397 "document_structure.c"
						}
					}
#line 414 "document_structure.vala"
					break;
#line 2402 "document_structure.c"
				}
#line 404 "document_structure.vala"
				case '[':
#line 2406 "document_structure.c"
				{
#line 417 "document_structure.vala"
					if (!utils_char_is_escaped (line, (glong) cur_index)) {
#line 2410 "document_structure.c"
						gint _tmp3_;
#line 418 "document_structure.vala"
						_tmp3_ = additional_bracket_level;
#line 418 "document_structure.vala"
						additional_bracket_level = _tmp3_ + 1;
#line 2416 "document_structure.c"
					}
#line 419 "document_structure.vala"
					break;
#line 2420 "document_structure.c"
				}
				default:
#line 404 "document_structure.vala"
				break;
#line 2425 "document_structure.c"
			}
		} else {
#line 426 "document_structure.vala"
			switch (cur_char) {
#line 426 "document_structure.vala"
				case '{':
#line 2432 "document_structure.c"
				{
#line 429 "document_structure.vala"
					_vala_begin_contents_index = next_index;
#line 430 "document_structure.vala"
					result = TRUE;
#line 430 "document_structure.vala"
					if (begin_contents_index) {
#line 430 "document_structure.vala"
						*begin_contents_index = _vala_begin_contents_index;
#line 2442 "document_structure.c"
					}
#line 430 "document_structure.vala"
					return result;
#line 2446 "document_structure.c"
				}
#line 426 "document_structure.vala"
				case '[':
#line 2450 "document_structure.c"
				{
#line 433 "document_structure.vala"
					in_optional_arg = TRUE;
#line 434 "document_structure.vala"
					break;
#line 2456 "document_structure.c"
				}
#line 426 "document_structure.vala"
				case ' ':
#line 426 "document_structure.vala"
				case '\t':
#line 2462 "document_structure.c"
				{
#line 438 "document_structure.vala"
					break;
#line 2466 "document_structure.c"
				}
				default:
				{
#line 441 "document_structure.vala"
					result = FALSE;
#line 441 "document_structure.vala"
					if (begin_contents_index) {
#line 441 "document_structure.vala"
						*begin_contents_index = _vala_begin_contents_index;
#line 2476 "document_structure.c"
					}
#line 441 "document_structure.vala"
					return result;
#line 2480 "document_structure.c"
				}
			}
		}
#line 445 "document_structure.vala"
		if (end) {
#line 446 "document_structure.vala"
			result = FALSE;
#line 446 "document_structure.vala"
			if (begin_contents_index) {
#line 446 "document_structure.vala"
				*begin_contents_index = _vala_begin_contents_index;
#line 2492 "document_structure.c"
			}
#line 446 "document_structure.vala"
			return result;
#line 2496 "document_structure.c"
		}
#line 448 "document_structure.vala"
		cur_index = next_index;
#line 2500 "document_structure.c"
	}
#line 387 "document_structure.vala"
	if (begin_contents_index) {
#line 387 "document_structure.vala"
		*begin_contents_index = _vala_begin_contents_index;
#line 2506 "document_structure.c"
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result = NULL;
#line 1480 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1481 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1481 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1481 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1482 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1483 "glib-2.0.vapi"
		start = string_length + start;
#line 2534 "document_structure.c"
	}
#line 1485 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1486 "glib-2.0.vapi"
		end = string_length + end;
#line 2540 "document_structure.c"
	}
#line 1488 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1488 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 2546 "document_structure.c"
	} else {
#line 1488 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 2550 "document_structure.c"
	}
#line 1488 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1489 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1489 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 2558 "document_structure.c"
	} else {
#line 1489 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 2562 "document_structure.c"
	}
#line 1489 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1490 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1491 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1491 "glib-2.0.vapi"
	result = _tmp4_;
#line 1491 "glib-2.0.vapi"
	return result;
#line 2574 "document_structure.c"
}

static gchar*
document_structure_get_markup_contents (DocumentStructure* self,
                                        const gchar* line,
                                        gint begin_contents_index,
                                        gint** end_match_index)
{
	gint* _vala_end_match_index = NULL;
	gint brace_level = 0;
	gint cur_index = 0;
	gchar* result = NULL;
#line 453 "document_structure.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 453 "document_structure.vala"
	g_return_val_if_fail (line != NULL, NULL);
#line 456 "document_structure.vala"
	_g_free0 (_vala_end_match_index);
#line 456 "document_structure.vala"
	_vala_end_match_index = NULL;
#line 458 "document_structure.vala"
	brace_level = 0;
#line 459 "document_structure.vala"
	cur_index = begin_contents_index;
#line 461 "document_structure.vala"
	while (TRUE) {
#line 2601 "document_structure.c"
		gint next_index = 0;
		gunichar cur_char = 0U;
		gboolean end = FALSE;
		gunichar _tmp0_ = 0U;
		gboolean _tmp1_;
		gboolean _tmp2_ = FALSE;
#line 463 "document_structure.vala"
		next_index = cur_index;
#line 465 "document_structure.vala"
		_tmp1_ = string_get_next_char (line, &next_index, &_tmp0_);
#line 465 "document_structure.vala"
		cur_char = _tmp0_;
#line 465 "document_structure.vala"
		end = !_tmp1_;
#line 467 "document_structure.vala"
		if (cur_char == ((gunichar) '{')) {
#line 467 "document_structure.vala"
			_tmp2_ = !utils_char_is_escaped (line, (glong) cur_index);
#line 2620 "document_structure.c"
		} else {
#line 467 "document_structure.vala"
			_tmp2_ = FALSE;
#line 2624 "document_structure.c"
		}
#line 467 "document_structure.vala"
		if (_tmp2_) {
#line 2628 "document_structure.c"
			gint _tmp3_;
#line 468 "document_structure.vala"
			_tmp3_ = brace_level;
#line 468 "document_structure.vala"
			brace_level = _tmp3_ + 1;
#line 2634 "document_structure.c"
		} else {
			gboolean _tmp4_ = FALSE;
#line 470 "document_structure.vala"
			if (cur_char == ((gunichar) '}')) {
#line 470 "document_structure.vala"
				_tmp4_ = !utils_char_is_escaped (line, (glong) cur_index);
#line 2641 "document_structure.c"
			} else {
#line 470 "document_structure.vala"
				_tmp4_ = FALSE;
#line 2645 "document_structure.c"
			}
#line 470 "document_structure.vala"
			if (_tmp4_) {
#line 472 "document_structure.vala"
				if (brace_level > 0) {
#line 2651 "document_structure.c"
					gint _tmp5_;
#line 473 "document_structure.vala"
					_tmp5_ = brace_level;
#line 473 "document_structure.vala"
					brace_level = _tmp5_ - 1;
#line 2657 "document_structure.c"
				} else {
					gchar* contents = NULL;
					gchar* _tmp6_;
					const gchar* _tmp7_;
					gint* _tmp8_;
#line 478 "document_structure.vala"
					_tmp6_ = string_slice (line, (glong) begin_contents_index, (glong) cur_index);
#line 478 "document_structure.vala"
					contents = _tmp6_;
#line 481 "document_structure.vala"
					_tmp7_ = contents;
#line 481 "document_structure.vala"
					if (g_strcmp0 (_tmp7_, "") == 0) {
#line 482 "document_structure.vala"
						result = NULL;
#line 482 "document_structure.vala"
						_g_free0 (contents);
#line 482 "document_structure.vala"
						if (end_match_index) {
#line 482 "document_structure.vala"
							*end_match_index = _vala_end_match_index;
#line 2679 "document_structure.c"
						} else {
#line 482 "document_structure.vala"
							_g_free0 (_vala_end_match_index);
#line 2683 "document_structure.c"
						}
#line 482 "document_structure.vala"
						return result;
#line 2687 "document_structure.c"
					}
#line 484 "document_structure.vala"
					_tmp8_ = __int_dup0 (&next_index);
#line 484 "document_structure.vala"
					_g_free0 (_vala_end_match_index);
#line 484 "document_structure.vala"
					_vala_end_match_index = _tmp8_;
#line 486 "document_structure.vala"
					result = contents;
#line 486 "document_structure.vala"
					if (end_match_index) {
#line 486 "document_structure.vala"
						*end_match_index = _vala_end_match_index;
#line 2701 "document_structure.c"
					} else {
#line 486 "document_structure.vala"
						_g_free0 (_vala_end_match_index);
#line 2705 "document_structure.c"
					}
#line 486 "document_structure.vala"
					return result;
#line 2709 "document_structure.c"
				}
			}
		}
#line 490 "document_structure.vala"
		if (end) {
#line 491 "document_structure.vala"
			result = NULL;
#line 491 "document_structure.vala"
			if (end_match_index) {
#line 491 "document_structure.vala"
				*end_match_index = _vala_end_match_index;
#line 2721 "document_structure.c"
			} else {
#line 491 "document_structure.vala"
				_g_free0 (_vala_end_match_index);
#line 2725 "document_structure.c"
			}
#line 491 "document_structure.vala"
			return result;
#line 2729 "document_structure.c"
		}
#line 493 "document_structure.vala"
		cur_index = next_index;
#line 2733 "document_structure.c"
	}
#line 453 "document_structure.vala"
	if (end_match_index) {
#line 453 "document_structure.vala"
		*end_match_index = _vala_end_match_index;
#line 2739 "document_structure.c"
	} else {
#line 453 "document_structure.vala"
		_g_free0 (_vala_end_match_index);
#line 2743 "document_structure.c"
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result = NULL;
#line 1359 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1360 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1360 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1361 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1362 "glib-2.0.vapi"
	result = _result_;
#line 1362 "glib-2.0.vapi"
	return result;
#line 2765 "document_structure.c"
}

static gboolean
document_structure_search_comment (DocumentStructure* self,
                                   const gchar* line,
                                   gint after_percent_index,
                                   StructType** type,
                                   gchar* * contents,
                                   gint** end_match_index)
{
	StructType* _vala_type = NULL;
	gchar* _vala_contents = NULL;
	gint* _vala_end_match_index = NULL;
	gchar* text_after = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GMatchInfo* match_info = NULL;
	GRegex* _tmp4_;
	const gchar* _tmp5_;
	GMatchInfo* _tmp6_ = NULL;
	gboolean _tmp7_;
	gchar* type_str = NULL;
	GMatchInfo* _tmp8_;
	gchar* _tmp9_;
	StructType _tmp10_ = 0;
	const gchar* _tmp11_;
	StructType* _tmp12_;
	GMatchInfo* _tmp13_;
	gchar* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint* _tmp17_;
	gboolean result = FALSE;
#line 497 "document_structure.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 497 "document_structure.vala"
	g_return_val_if_fail (line != NULL, FALSE);
#line 500 "document_structure.vala"
	_g_free0 (_vala_type);
#line 500 "document_structure.vala"
	_vala_type = NULL;
#line 501 "document_structure.vala"
	_g_free0 (_vala_contents);
#line 501 "document_structure.vala"
	_vala_contents = NULL;
#line 502 "document_structure.vala"
	_g_free0 (_vala_end_match_index);
#line 502 "document_structure.vala"
	_vala_end_match_index = NULL;
#line 504 "document_structure.vala"
	_tmp0_ = string_substring (line, (glong) after_percent_index, (glong) -1);
#line 504 "document_structure.vala"
	_tmp1_ = _tmp0_;
#line 504 "document_structure.vala"
	_tmp2_ = string_strip (_tmp1_);
#line 504 "document_structure.vala"
	_tmp3_ = _tmp2_;
#line 504 "document_structure.vala"
	_g_free0 (_tmp1_);
#line 504 "document_structure.vala"
	text_after = _tmp3_;
#line 507 "document_structure.vala"
	_tmp4_ = document_structure__comment_regex;
#line 507 "document_structure.vala"
	_tmp5_ = text_after;
#line 507 "document_structure.vala"
	_tmp7_ = g_regex_match (_tmp4_, _tmp5_, 0, &_tmp6_);
#line 507 "document_structure.vala"
	_g_match_info_unref0 (match_info);
#line 507 "document_structure.vala"
	match_info = _tmp6_;
#line 507 "document_structure.vala"
	if (!_tmp7_) {
#line 508 "document_structure.vala"
		result = FALSE;
#line 508 "document_structure.vala"
		_g_match_info_unref0 (match_info);
#line 508 "document_structure.vala"
		_g_free0 (text_after);
#line 508 "document_structure.vala"
		if (type) {
#line 508 "document_structure.vala"
			*type = _vala_type;
#line 2851 "document_structure.c"
		} else {
#line 508 "document_structure.vala"
			_g_free0 (_vala_type);
#line 2855 "document_structure.c"
		}
#line 508 "document_structure.vala"
		if (contents) {
#line 508 "document_structure.vala"
			*contents = _vala_contents;
#line 2861 "document_structure.c"
		} else {
#line 508 "document_structure.vala"
			_g_free0 (_vala_contents);
#line 2865 "document_structure.c"
		}
#line 508 "document_structure.vala"
		if (end_match_index) {
#line 508 "document_structure.vala"
			*end_match_index = _vala_end_match_index;
#line 2871 "document_structure.c"
		} else {
#line 508 "document_structure.vala"
			_g_free0 (_vala_end_match_index);
#line 2875 "document_structure.c"
		}
#line 508 "document_structure.vala"
		return result;
#line 2879 "document_structure.c"
	}
#line 510 "document_structure.vala"
	_tmp8_ = match_info;
#line 510 "document_structure.vala"
	_tmp9_ = g_match_info_fetch_named (_tmp8_, "type");
#line 510 "document_structure.vala"
	type_str = _tmp9_;
#line 511 "document_structure.vala"
	_tmp11_ = type_str;
#line 511 "document_structure.vala"
	if (g_strcmp0 (_tmp11_, "TODO") == 0) {
#line 511 "document_structure.vala"
		_tmp10_ = STRUCT_TYPE_TODO;
#line 2893 "document_structure.c"
	} else {
#line 511 "document_structure.vala"
		_tmp10_ = STRUCT_TYPE_FIXME;
#line 2897 "document_structure.c"
	}
#line 511 "document_structure.vala"
	_tmp12_ = __struct_type_dup0 (&_tmp10_);
#line 511 "document_structure.vala"
	_g_free0 (_vala_type);
#line 511 "document_structure.vala"
	_vala_type = _tmp12_;
#line 513 "document_structure.vala"
	_tmp13_ = match_info;
#line 513 "document_structure.vala"
	_tmp14_ = g_match_info_fetch_named (_tmp13_, "text");
#line 513 "document_structure.vala"
	_g_free0 (_vala_contents);
#line 513 "document_structure.vala"
	_vala_contents = _tmp14_;
#line 514 "document_structure.vala"
	_tmp15_ = strlen (line);
#line 514 "document_structure.vala"
	_tmp16_ = _tmp15_;
#line 514 "document_structure.vala"
	_tmp17_ = __int_dup0 (&_tmp16_);
#line 514 "document_structure.vala"
	_g_free0 (_vala_end_match_index);
#line 514 "document_structure.vala"
	_vala_end_match_index = _tmp17_;
#line 516 "document_structure.vala"
	result = TRUE;
#line 516 "document_structure.vala"
	_g_free0 (type_str);
#line 516 "document_structure.vala"
	_g_match_info_unref0 (match_info);
#line 516 "document_structure.vala"
	_g_free0 (text_after);
#line 516 "document_structure.vala"
	if (type) {
#line 516 "document_structure.vala"
		*type = _vala_type;
#line 2935 "document_structure.c"
	} else {
#line 516 "document_structure.vala"
		_g_free0 (_vala_type);
#line 2939 "document_structure.c"
	}
#line 516 "document_structure.vala"
	if (contents) {
#line 516 "document_structure.vala"
		*contents = _vala_contents;
#line 2945 "document_structure.c"
	} else {
#line 516 "document_structure.vala"
		_g_free0 (_vala_contents);
#line 2949 "document_structure.c"
	}
#line 516 "document_structure.vala"
	if (end_match_index) {
#line 516 "document_structure.vala"
		*end_match_index = _vala_end_match_index;
#line 2955 "document_structure.c"
	} else {
#line 516 "document_structure.vala"
		_g_free0 (_vala_end_match_index);
#line 2959 "document_structure.c"
	}
#line 516 "document_structure.vala"
	return result;
#line 2963 "document_structure.c"
}

static void
_vala_GtkTreeIter_free (GtkTreeIter* self)
{
#line 531 "document_structure.vala"
	g_boxed_free (gtk_tree_iter_get_type (), self);
#line 2971 "document_structure.c"
}

static void
document_structure_handle_item (DocumentStructure* self,
                                StructType type,
                                const gchar* contents,
                                GtkTextIter* iter)
{
	gboolean _tmp0_ = FALSE;
#line 519 "document_structure.vala"
	g_return_if_fail (self != NULL);
#line 519 "document_structure.vala"
	g_return_if_fail (iter != NULL);
#line 522 "document_structure.vala"
	if (self->priv->_in_verbatim_env) {
#line 524 "document_structure.vala"
		if (type == STRUCT_TYPE_END_VERBATIM) {
#line 525 "document_structure.vala"
			self->priv->_in_verbatim_env = FALSE;
#line 2991 "document_structure.c"
		}
#line 527 "document_structure.vala"
		return;
#line 2995 "document_structure.c"
	}
#line 530 "document_structure.vala"
	if (type == STRUCT_TYPE_TODO) {
#line 530 "document_structure.vala"
		_tmp0_ = TRUE;
#line 3001 "document_structure.c"
	} else {
#line 530 "document_structure.vala"
		_tmp0_ = type == STRUCT_TYPE_FIXME;
#line 3005 "document_structure.c"
	}
#line 530 "document_structure.vala"
	if (_tmp0_) {
#line 3009 "document_structure.c"
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_;
		GtkTextIter _tmp4_;
		GtkTreeIter* _tmp5_;
		GtkTreeIter* _tmp6_;
#line 531 "document_structure.vala"
		_tmp2_ = document_structure_truncate (self, contents);
#line 531 "document_structure.vala"
		_tmp1_ = _tmp2_;
#line 531 "document_structure.vala"
		if (_tmp1_ == NULL) {
#line 3021 "document_structure.c"
			gchar* _tmp3_;
#line 531 "document_structure.vala"
			_tmp3_ = g_strdup (contents);
#line 531 "document_structure.vala"
			_g_free0 (_tmp1_);
#line 531 "document_structure.vala"
			_tmp1_ = _tmp3_;
#line 3029 "document_structure.c"
		}
#line 531 "document_structure.vala"
		_tmp4_ = *iter;
#line 531 "document_structure.vala"
		_tmp5_ = document_structure_add_item (self, type, _tmp1_, &_tmp4_);
#line 531 "document_structure.vala"
		_tmp6_ = _tmp5_;
#line 531 "document_structure.vala"
		__vala_GtkTreeIter_free0 (_tmp6_);
#line 530 "document_structure.vala"
		_g_free0 (_tmp1_);
#line 3041 "document_structure.c"
	} else {
#line 534 "document_structure.vala"
		if (structure_is_common_type (type)) {
#line 3045 "document_structure.c"
			GtkTextIter _tmp7_;
			GtkTreeIter* _tmp8_;
			GtkTreeIter* _tmp9_;
#line 535 "document_structure.vala"
			_tmp7_ = *iter;
#line 535 "document_structure.vala"
			_tmp8_ = document_structure_add_item (self, type, contents, &_tmp7_);
#line 535 "document_structure.vala"
			_tmp9_ = _tmp8_;
#line 535 "document_structure.vala"
			__vala_GtkTreeIter_free0 (_tmp9_);
#line 3057 "document_structure.c"
		} else {
#line 538 "document_structure.vala"
			if (type == STRUCT_TYPE_BEGIN_VERBATIM) {
#line 539 "document_structure.vala"
				self->priv->_in_verbatim_env = TRUE;
#line 3063 "document_structure.c"
			} else {
				gboolean _tmp10_ = FALSE;
#line 542 "document_structure.vala"
				if (type == STRUCT_TYPE_BEGIN_FIGURE) {
#line 542 "document_structure.vala"
					_tmp10_ = TRUE;
#line 3070 "document_structure.c"
				} else {
#line 542 "document_structure.vala"
					_tmp10_ = type == STRUCT_TYPE_BEGIN_TABLE;
#line 3074 "document_structure.c"
				}
#line 542 "document_structure.vala"
				if (_tmp10_) {
#line 3078 "document_structure.c"
					GtkTextIter _tmp11_;
#line 543 "document_structure.vala"
					_tmp11_ = *iter;
#line 543 "document_structure.vala"
					document_structure_create_new_environment (self, type, &_tmp11_);
#line 3084 "document_structure.c"
				} else {
					gboolean _tmp12_ = FALSE;
					gboolean _tmp13_ = FALSE;
#line 546 "document_structure.vala"
					if (type == STRUCT_TYPE_CAPTION) {
#line 3090 "document_structure.c"
						DocumentStructureEnvData* _tmp14_;
#line 546 "document_structure.vala"
						_tmp14_ = self->priv->_last_env_data;
#line 546 "document_structure.vala"
						_tmp13_ = _tmp14_ != NULL;
#line 3096 "document_structure.c"
					} else {
#line 546 "document_structure.vala"
						_tmp13_ = FALSE;
#line 3100 "document_structure.c"
					}
#line 546 "document_structure.vala"
					if (_tmp13_) {
#line 3104 "document_structure.c"
						DocumentStructureEnvData* _tmp15_;
						const gchar* _tmp16_;
#line 547 "document_structure.vala"
						_tmp15_ = self->priv->_last_env_data;
#line 547 "document_structure.vala"
						_tmp16_ = (*_tmp15_).first_caption;
#line 547 "document_structure.vala"
						_tmp12_ = _tmp16_ == NULL;
#line 3113 "document_structure.c"
					} else {
#line 546 "document_structure.vala"
						_tmp12_ = FALSE;
#line 3117 "document_structure.c"
					}
#line 546 "document_structure.vala"
					if (_tmp12_) {
#line 3121 "document_structure.c"
						gchar* _tmp17_ = NULL;
						gchar* _tmp18_;
						DocumentStructureEnvData* _tmp20_;
						gchar* _tmp21_;
#line 549 "document_structure.vala"
						_tmp18_ = document_structure_truncate (self, contents);
#line 549 "document_structure.vala"
						_tmp17_ = _tmp18_;
#line 549 "document_structure.vala"
						if (_tmp17_ == NULL) {
#line 3132 "document_structure.c"
							gchar* _tmp19_;
#line 549 "document_structure.vala"
							_tmp19_ = g_strdup (contents);
#line 549 "document_structure.vala"
							_g_free0 (_tmp17_);
#line 549 "document_structure.vala"
							_tmp17_ = _tmp19_;
#line 3140 "document_structure.c"
						}
#line 549 "document_structure.vala"
						_tmp20_ = self->priv->_last_env_data;
#line 549 "document_structure.vala"
						_tmp21_ = _tmp17_;
#line 549 "document_structure.vala"
						_tmp17_ = NULL;
#line 549 "document_structure.vala"
						_g_free0 ((*_tmp20_).first_caption);
#line 549 "document_structure.vala"
						(*_tmp20_).first_caption = _tmp21_;
#line 546 "document_structure.vala"
						_g_free0 (_tmp17_);
#line 3154 "document_structure.c"
					} else {
#line 553 "document_structure.vala"
						if (document_structure_verify_end_environment_type (self, type)) {
#line 3158 "document_structure.c"
							GtkTextMark* end_mark = NULL;
							GtkTextIter _tmp22_;
							GtkTextMark* _tmp23_;
							StructureModel* _tmp24_;
							DocumentStructureEnvData* _tmp25_;
							GtkTreePath* _tmp26_;
							DocumentStructureEnvData* _tmp27_;
							const gchar* _tmp28_;
							GtkTextMark* _tmp29_;
#line 555 "document_structure.vala"
							_tmp22_ = *iter;
#line 555 "document_structure.vala"
							_tmp23_ = document_structure_create_text_mark_from_iter (self, &_tmp22_);
#line 555 "document_structure.vala"
							end_mark = _tmp23_;
#line 556 "document_structure.vala"
							_tmp24_ = self->priv->_model;
#line 556 "document_structure.vala"
							_tmp25_ = self->priv->_last_env_data;
#line 556 "document_structure.vala"
							_tmp26_ = (*_tmp25_).path;
#line 556 "document_structure.vala"
							_tmp27_ = self->priv->_last_env_data;
#line 556 "document_structure.vala"
							_tmp28_ = (*_tmp27_).first_caption;
#line 556 "document_structure.vala"
							_tmp29_ = end_mark;
#line 556 "document_structure.vala"
							structure_model_modify_data (_tmp24_, _tmp26_, _tmp28_, _tmp29_);
#line 558 "document_structure.vala"
							_document_structure_env_data_free0 (self->priv->_last_env_data);
#line 558 "document_structure.vala"
							self->priv->_last_env_data = NULL;
#line 553 "document_structure.vala"
							_g_object_unref0 (end_mark);
#line 3194 "document_structure.c"
						} else {
#line 562 "document_structure.vala"
							if (type == STRUCT_TYPE_END_DOCUMENT) {
#line 3198 "document_structure.c"
								GtkTextIter _tmp30_;
								GtkTextMark* _tmp31_;
#line 563 "document_structure.vala"
								_tmp30_ = *iter;
#line 563 "document_structure.vala"
								_tmp31_ = document_structure_create_text_mark_from_iter (self, &_tmp30_);
#line 563 "document_structure.vala"
								_g_object_unref0 (self->priv->_end_document_mark);
#line 563 "document_structure.vala"
								self->priv->_end_document_mark = _tmp31_;
#line 3209 "document_structure.c"
							}
						}
					}
				}
			}
		}
	}
}

static gpointer
_document_structure_env_data_dup0 (gpointer self)
{
#line 571 "document_structure.vala"
	return self ? document_structure_env_data_dup (self) : NULL;
#line 3224 "document_structure.c"
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
#line 580 "document_structure.vala"
	g_boxed_free (gtk_tree_path_get_type (), self);
#line 3232 "document_structure.c"
}

static void
document_structure_create_new_environment (DocumentStructure* self,
                                           StructType type,
                                           GtkTextIter* start_iter)
{
	gboolean _tmp0_ = FALSE;
	DocumentStructureEnvData _tmp1_ = {0};
	DocumentStructureEnvData _tmp2_;
	DocumentStructureEnvData* _tmp3_;
	DocumentStructureEnvData* _tmp4_;
	GtkTreeIter tree_iter = {0};
	DocumentStructureEnvData* _tmp7_;
	StructType _tmp8_;
	GtkTextIter _tmp9_;
	GtkTreeIter* _tmp10_;
	GtkTreeIter* _tmp11_;
	GtkTreeIter _tmp12_;
	DocumentStructureEnvData* _tmp13_;
	StructureModel* _tmp14_;
	GtkTreeIter _tmp15_;
	GtkTreePath* _tmp16_;
#line 566 "document_structure.vala"
	g_return_if_fail (self != NULL);
#line 566 "document_structure.vala"
	g_return_if_fail (start_iter != NULL);
#line 568 "document_structure.vala"
	if (type == STRUCT_TYPE_BEGIN_FIGURE) {
#line 568 "document_structure.vala"
		_tmp0_ = TRUE;
#line 3264 "document_structure.c"
	} else {
#line 569 "document_structure.vala"
		_tmp0_ = type == STRUCT_TYPE_BEGIN_TABLE;
#line 3268 "document_structure.c"
	}
#line 568 "document_structure.vala"
	g_return_if_fail (_tmp0_);
#line 571 "document_structure.vala"
	memset (&_tmp1_, 0, sizeof (DocumentStructureEnvData));
#line 571 "document_structure.vala"
	_tmp2_ = _tmp1_;
#line 571 "document_structure.vala"
	_tmp3_ = _document_structure_env_data_dup0 (&_tmp2_);
#line 571 "document_structure.vala"
	_document_structure_env_data_free0 (self->priv->_last_env_data);
#line 571 "document_structure.vala"
	self->priv->_last_env_data = _tmp3_;
#line 571 "document_structure.vala"
	document_structure_env_data_destroy (&_tmp2_);
#line 572 "document_structure.vala"
	_tmp4_ = self->priv->_last_env_data;
#line 572 "document_structure.vala"
	_g_free0 ((*_tmp4_).first_caption);
#line 572 "document_structure.vala"
	(*_tmp4_).first_caption = NULL;
#line 574 "document_structure.vala"
	if (type == STRUCT_TYPE_BEGIN_TABLE) {
#line 3292 "document_structure.c"
		DocumentStructureEnvData* _tmp5_;
#line 575 "document_structure.vala"
		_tmp5_ = self->priv->_last_env_data;
#line 575 "document_structure.vala"
		(*_tmp5_).type = STRUCT_TYPE_TABLE;
#line 3298 "document_structure.c"
	} else {
		DocumentStructureEnvData* _tmp6_;
#line 577 "document_structure.vala"
		_tmp6_ = self->priv->_last_env_data;
#line 577 "document_structure.vala"
		(*_tmp6_).type = STRUCT_TYPE_FIGURE;
#line 3305 "document_structure.c"
	}
#line 579 "document_structure.vala"
	_tmp7_ = self->priv->_last_env_data;
#line 579 "document_structure.vala"
	_tmp8_ = (*_tmp7_).type;
#line 579 "document_structure.vala"
	_tmp9_ = *start_iter;
#line 579 "document_structure.vala"
	_tmp10_ = document_structure_add_item (self, _tmp8_, NULL, &_tmp9_);
#line 579 "document_structure.vala"
	_tmp11_ = _tmp10_;
#line 579 "document_structure.vala"
	_tmp12_ = *_tmp11_;
#line 579 "document_structure.vala"
	__vala_GtkTreeIter_free0 (_tmp11_);
#line 579 "document_structure.vala"
	tree_iter = _tmp12_;
#line 580 "document_structure.vala"
	_tmp13_ = self->priv->_last_env_data;
#line 580 "document_structure.vala"
	_tmp14_ = self->priv->_model;
#line 580 "document_structure.vala"
	_tmp15_ = tree_iter;
#line 580 "document_structure.vala"
	_tmp16_ = gtk_tree_model_get_path ((GtkTreeModel*) _tmp14_, &_tmp15_);
#line 580 "document_structure.vala"
	__vala_GtkTreePath_free0 ((*_tmp13_).path);
#line 580 "document_structure.vala"
	(*_tmp13_).path = _tmp16_;
#line 3335 "document_structure.c"
}

static gboolean
document_structure_verify_end_environment_type (DocumentStructure* self,
                                                StructType type)
{
	DocumentStructureEnvData* _tmp0_;
	gboolean result = FALSE;
#line 583 "document_structure.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 585 "document_structure.vala"
	_tmp0_ = self->priv->_last_env_data;
#line 585 "document_structure.vala"
	if (_tmp0_ == NULL) {
#line 586 "document_structure.vala"
		result = FALSE;
#line 586 "document_structure.vala"
		return result;
#line 3354 "document_structure.c"
	}
#line 588 "document_structure.vala"
	if (type == STRUCT_TYPE_END_TABLE) {
#line 3358 "document_structure.c"
		DocumentStructureEnvData* _tmp1_;
		StructType _tmp2_;
#line 589 "document_structure.vala"
		_tmp1_ = self->priv->_last_env_data;
#line 589 "document_structure.vala"
		_tmp2_ = (*_tmp1_).type;
#line 589 "document_structure.vala"
		result = _tmp2_ == STRUCT_TYPE_TABLE;
#line 589 "document_structure.vala"
		return result;
#line 3369 "document_structure.c"
	}
#line 591 "document_structure.vala"
	if (type == STRUCT_TYPE_END_FIGURE) {
#line 3373 "document_structure.c"
		DocumentStructureEnvData* _tmp3_;
		StructType _tmp4_;
#line 592 "document_structure.vala"
		_tmp3_ = self->priv->_last_env_data;
#line 592 "document_structure.vala"
		_tmp4_ = (*_tmp3_).type;
#line 592 "document_structure.vala"
		result = _tmp4_ == STRUCT_TYPE_FIGURE;
#line 592 "document_structure.vala"
		return result;
#line 3384 "document_structure.c"
	}
#line 594 "document_structure.vala"
	result = FALSE;
#line 594 "document_structure.vala"
	return result;
#line 3390 "document_structure.c"
}

static GtkTreeIter*
document_structure_add_item (DocumentStructure* self,
                             StructType type,
                             const gchar* text,
                             GtkTextIter* start_iter)
{
	StructData data = {0};
	StructData _tmp0_ = {0};
	gchar* _tmp1_;
	GtkTextIter _tmp2_;
	GtkTextMark* _tmp3_;
	StructData _tmp4_;
	GtkTreeIter* _tmp5_;
	GtkTreeIter* result = NULL;
#line 597 "document_structure.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 597 "document_structure.vala"
	g_return_val_if_fail (start_iter != NULL, NULL);
#line 599 "document_structure.vala"
	data = _tmp0_;
#line 600 "document_structure.vala"
	data.type = type;
#line 601 "document_structure.vala"
	_tmp1_ = g_strdup (text);
#line 601 "document_structure.vala"
	_g_free0 (data.text);
#line 601 "document_structure.vala"
	data.text = _tmp1_;
#line 602 "document_structure.vala"
	_tmp2_ = *start_iter;
#line 602 "document_structure.vala"
	_tmp3_ = document_structure_create_text_mark_from_iter (self, &_tmp2_);
#line 602 "document_structure.vala"
	_g_object_unref0 (data.start_mark);
#line 602 "document_structure.vala"
	data.start_mark = _tmp3_;
#line 603 "document_structure.vala"
	_g_object_unref0 (data.end_mark);
#line 603 "document_structure.vala"
	data.end_mark = NULL;
#line 605 "document_structure.vala"
	_tmp4_ = data;
#line 605 "document_structure.vala"
	_tmp5_ = document_structure_add_item_data (self, &_tmp4_);
#line 605 "document_structure.vala"
	result = _tmp5_;
#line 605 "document_structure.vala"
	struct_data_destroy (&data);
#line 605 "document_structure.vala"
	return result;
#line 3443 "document_structure.c"
}

static GtkTreeIter*
document_structure_add_item_data (DocumentStructure* self,
                                  StructData* data)
{
	StructData _tmp0_;
	const gchar* _tmp1_;
	StructureModel* _tmp3_;
	StructData _tmp4_;
	GtkTreeIter* _tmp5_;
	GtkTreeIter* result = NULL;
#line 608 "document_structure.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 608 "document_structure.vala"
	g_return_val_if_fail (data != NULL, NULL);
#line 610 "document_structure.vala"
	_tmp0_ = *data;
#line 610 "document_structure.vala"
	_tmp1_ = _tmp0_.text;
#line 610 "document_structure.vala"
	if (_tmp1_ == NULL) {
#line 3466 "document_structure.c"
		gchar* _tmp2_;
#line 611 "document_structure.vala"
		_tmp2_ = g_strdup ("");
#line 611 "document_structure.vala"
		_g_free0 ((*data).text);
#line 611 "document_structure.vala"
		(*data).text = _tmp2_;
#line 3474 "document_structure.c"
	}
#line 613 "document_structure.vala"
	_tmp3_ = self->priv->_model;
#line 613 "document_structure.vala"
	_tmp4_ = *data;
#line 613 "document_structure.vala"
	_tmp5_ = structure_model_add_item_at_end (_tmp3_, &_tmp4_);
#line 613 "document_structure.vala"
	result = _tmp5_;
#line 613 "document_structure.vala"
	return result;
#line 3486 "document_structure.c"
}

static GtkTextMark*
document_structure_create_text_mark_from_iter (DocumentStructure* self,
                                               GtkTextIter* iter)
{
	GtkTextBuffer* doc = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	gchar* name = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkTextMark* mark = NULL;
	GtkTextIter _tmp6_;
	GtkTextMark* _tmp7_;
	GtkTextMark* _tmp8_;
	gint _tmp9_;
	GtkTextMark* result = NULL;
#line 616 "document_structure.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 616 "document_structure.vala"
	g_return_val_if_fail (iter != NULL, NULL);
#line 618 "document_structure.vala"
	_tmp0_ = gtk_text_iter_get_buffer (iter);
#line 618 "document_structure.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 618 "document_structure.vala"
	doc = _tmp1_;
#line 619 "document_structure.vala"
	_tmp2_ = g_strdup_printf ("%i", self->priv->_nb_marks);
#line 619 "document_structure.vala"
	_tmp3_ = _tmp2_;
#line 619 "document_structure.vala"
	_tmp4_ = g_strconcat (DOCUMENT_STRUCTURE_MARK_NAME_PREFIX, _tmp3_, NULL);
#line 619 "document_structure.vala"
	_tmp5_ = _tmp4_;
#line 619 "document_structure.vala"
	_g_free0 (_tmp3_);
#line 619 "document_structure.vala"
	name = _tmp5_;
#line 620 "document_structure.vala"
	_tmp6_ = *iter;
#line 620 "document_structure.vala"
	_tmp7_ = gtk_text_buffer_create_mark (doc, name, &_tmp6_, FALSE);
#line 620 "document_structure.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 620 "document_structure.vala"
	mark = _tmp8_;
#line 621 "document_structure.vala"
	_tmp9_ = self->priv->_nb_marks;
#line 621 "document_structure.vala"
	self->priv->_nb_marks = _tmp9_ + 1;
#line 623 "document_structure.vala"
	result = mark;
#line 623 "document_structure.vala"
	_g_free0 (name);
#line 623 "document_structure.vala"
	_g_object_unref0 (doc);
#line 623 "document_structure.vala"
	return result;
#line 3549 "document_structure.c"
}

static void
document_structure_clear_all_structure_marks (DocumentStructure* self)
{
#line 626 "document_structure.vala"
	g_return_if_fail (self != NULL);
#line 3557 "document_structure.c"
	{
		gint i = 0;
#line 628 "document_structure.vala"
		i = 0;
#line 3562 "document_structure.c"
		{
			gboolean _tmp0_ = FALSE;
#line 628 "document_structure.vala"
			_tmp0_ = TRUE;
#line 628 "document_structure.vala"
			while (TRUE) {
#line 3569 "document_structure.c"
				gchar* mark_name = NULL;
				gchar* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				GtkTextMark* mark = NULL;
				Document* _tmp6_;
				const gchar* _tmp7_;
				GtkTextMark* _tmp8_;
				GtkTextMark* _tmp9_;
				GtkTextMark* _tmp10_;
#line 628 "document_structure.vala"
				if (!_tmp0_) {
#line 3583 "document_structure.c"
					gint _tmp1_;
#line 628 "document_structure.vala"
					_tmp1_ = i;
#line 628 "document_structure.vala"
					i = _tmp1_ + 1;
#line 3589 "document_structure.c"
				}
#line 628 "document_structure.vala"
				_tmp0_ = FALSE;
#line 628 "document_structure.vala"
				if (!(i < self->priv->_nb_marks)) {
#line 628 "document_structure.vala"
					break;
#line 3597 "document_structure.c"
				}
#line 630 "document_structure.vala"
				_tmp2_ = g_strdup_printf ("%i", i);
#line 630 "document_structure.vala"
				_tmp3_ = _tmp2_;
#line 630 "document_structure.vala"
				_tmp4_ = g_strconcat (DOCUMENT_STRUCTURE_MARK_NAME_PREFIX, _tmp3_, NULL);
#line 630 "document_structure.vala"
				_tmp5_ = _tmp4_;
#line 630 "document_structure.vala"
				_g_free0 (_tmp3_);
#line 630 "document_structure.vala"
				mark_name = _tmp5_;
#line 631 "document_structure.vala"
				_tmp6_ = self->priv->_doc;
#line 631 "document_structure.vala"
				_tmp7_ = mark_name;
#line 631 "document_structure.vala"
				_tmp8_ = gtk_text_buffer_get_mark ((GtkTextBuffer*) _tmp6_, _tmp7_);
#line 631 "document_structure.vala"
				_tmp9_ = _g_object_ref0 (_tmp8_);
#line 631 "document_structure.vala"
				mark = _tmp9_;
#line 632 "document_structure.vala"
				_tmp10_ = mark;
#line 632 "document_structure.vala"
				if (_tmp10_ != NULL) {
#line 3625 "document_structure.c"
					Document* _tmp11_;
					GtkTextMark* _tmp12_;
#line 633 "document_structure.vala"
					_tmp11_ = self->priv->_doc;
#line 633 "document_structure.vala"
					_tmp12_ = mark;
#line 633 "document_structure.vala"
					gtk_text_buffer_delete_mark ((GtkTextBuffer*) _tmp11_, _tmp12_);
#line 3634 "document_structure.c"
				}
#line 628 "document_structure.vala"
				_g_object_unref0 (mark);
#line 628 "document_structure.vala"
				_g_free0 (mark_name);
#line 3640 "document_structure.c"
			}
		}
	}
#line 636 "document_structure.vala"
	self->priv->_nb_marks = 0;
#line 3646 "document_structure.c"
}

static gint
string_index_of_nth_char (const gchar* self,
                          glong c)
{
	gchar* _tmp0_;
	gint result = 0;
#line 1282 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1283 "glib-2.0.vapi"
	_tmp0_ = g_utf8_offset_to_pointer (self, c);
#line 1283 "glib-2.0.vapi"
	result = (gint) (_tmp0_ - ((gchar*) self));
#line 1283 "glib-2.0.vapi"
	return result;
#line 3663 "document_structure.c"
}

static gchar*
document_structure_truncate (DocumentStructure* self,
                             const gchar* text)
{
	gint index = 0;
	gchar* _tmp0_;
	gchar* result = NULL;
#line 640 "document_structure.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 642 "document_structure.vala"
	if (text == NULL) {
#line 643 "document_structure.vala"
		result = NULL;
#line 643 "document_structure.vala"
		return result;
#line 3681 "document_structure.c"
	}
#line 645 "document_structure.vala"
	if (g_utf8_strlen (text, (gssize) -1) <= DOCUMENT_STRUCTURE_ITEM_MAX_LENGTH) {
#line 646 "document_structure.vala"
		result = NULL;
#line 646 "document_structure.vala"
		return result;
#line 3689 "document_structure.c"
	}
#line 648 "document_structure.vala"
	index = string_index_of_nth_char (text, (glong) DOCUMENT_STRUCTURE_ITEM_MAX_LENGTH);
#line 649 "document_structure.vala"
	_tmp0_ = string_substring (text, (glong) 0, (glong) index);
#line 649 "document_structure.vala"
	result = _tmp0_;
#line 649 "document_structure.vala"
	return result;
#line 3699 "document_structure.c"
}

static StructType*
document_structure_get_markup_type (DocumentStructure* self,
                                    const gchar* markup_name)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label0 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label1 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label2 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label3 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label4 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label5 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label6 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label7 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label8 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label9 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label10 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label11 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label12 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label13 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label14 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label15 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label16 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label17 = 0;
#line 654 "document_structure.vala"
	static GQuark _tmp1_label18 = 0;
#line 3746 "document_structure.c"
	StructType* result = NULL;
#line 652 "document_structure.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 652 "document_structure.vala"
	g_return_val_if_fail (markup_name != NULL, NULL);
#line 654 "document_structure.vala"
	_tmp0_ = markup_name;
#line 654 "document_structure.vala"
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
#line 654 "document_structure.vala"
	if ((_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("part")))) || (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("part*"))))) {
#line 654 "document_structure.vala"
		switch (0) {
#line 3760 "document_structure.c"
			default:
			{
				StructType _tmp3_;
				StructType* _tmp4_;
#line 658 "document_structure.vala"
				_tmp3_ = STRUCT_TYPE_PART;
#line 658 "document_structure.vala"
				_tmp4_ = __struct_type_dup0 (&_tmp3_);
#line 658 "document_structure.vala"
				result = _tmp4_;
#line 658 "document_structure.vala"
				return result;
#line 3773 "document_structure.c"
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("chapter")))) || (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("chapter*"))))) {
#line 654 "document_structure.vala"
		switch (0) {
#line 3779 "document_structure.c"
			default:
			{
				StructType _tmp5_;
				StructType* _tmp6_;
#line 662 "document_structure.vala"
				_tmp5_ = STRUCT_TYPE_CHAPTER;
#line 662 "document_structure.vala"
				_tmp6_ = __struct_type_dup0 (&_tmp5_);
#line 662 "document_structure.vala"
				result = _tmp6_;
#line 662 "document_structure.vala"
				return result;
#line 3792 "document_structure.c"
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("section")))) || (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("section*"))))) {
#line 654 "document_structure.vala"
		switch (0) {
#line 3798 "document_structure.c"
			default:
			{
				StructType _tmp7_;
				StructType* _tmp8_;
#line 666 "document_structure.vala"
				_tmp7_ = STRUCT_TYPE_SECTION;
#line 666 "document_structure.vala"
				_tmp8_ = __struct_type_dup0 (&_tmp7_);
#line 666 "document_structure.vala"
				result = _tmp8_;
#line 666 "document_structure.vala"
				return result;
#line 3811 "document_structure.c"
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("subsection")))) || (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("subsection*"))))) {
#line 654 "document_structure.vala"
		switch (0) {
#line 3817 "document_structure.c"
			default:
			{
				StructType _tmp9_;
				StructType* _tmp10_;
#line 670 "document_structure.vala"
				_tmp9_ = STRUCT_TYPE_SUBSECTION;
#line 670 "document_structure.vala"
				_tmp10_ = __struct_type_dup0 (&_tmp9_);
#line 670 "document_structure.vala"
				result = _tmp10_;
#line 670 "document_structure.vala"
				return result;
#line 3830 "document_structure.c"
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label8) ? _tmp1_label8 : (_tmp1_label8 = g_quark_from_static_string ("subsubsection")))) || (_tmp2_ == ((0 != _tmp1_label9) ? _tmp1_label9 : (_tmp1_label9 = g_quark_from_static_string ("subsubsection*"))))) {
#line 654 "document_structure.vala"
		switch (0) {
#line 3836 "document_structure.c"
			default:
			{
				StructType _tmp11_;
				StructType* _tmp12_;
#line 674 "document_structure.vala"
				_tmp11_ = STRUCT_TYPE_SUBSUBSECTION;
#line 674 "document_structure.vala"
				_tmp12_ = __struct_type_dup0 (&_tmp11_);
#line 674 "document_structure.vala"
				result = _tmp12_;
#line 674 "document_structure.vala"
				return result;
#line 3849 "document_structure.c"
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label10) ? _tmp1_label10 : (_tmp1_label10 = g_quark_from_static_string ("paragraph")))) || (_tmp2_ == ((0 != _tmp1_label11) ? _tmp1_label11 : (_tmp1_label11 = g_quark_from_static_string ("paragraph*"))))) {
#line 654 "document_structure.vala"
		switch (0) {
#line 3855 "document_structure.c"
			default:
			{
				StructType _tmp13_;
				StructType* _tmp14_;
#line 678 "document_structure.vala"
				_tmp13_ = STRUCT_TYPE_PARAGRAPH;
#line 678 "document_structure.vala"
				_tmp14_ = __struct_type_dup0 (&_tmp13_);
#line 678 "document_structure.vala"
				result = _tmp14_;
#line 678 "document_structure.vala"
				return result;
#line 3868 "document_structure.c"
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label12) ? _tmp1_label12 : (_tmp1_label12 = g_quark_from_static_string ("subparagraph")))) || (_tmp2_ == ((0 != _tmp1_label13) ? _tmp1_label13 : (_tmp1_label13 = g_quark_from_static_string ("subparagraph*"))))) {
#line 654 "document_structure.vala"
		switch (0) {
#line 3874 "document_structure.c"
			default:
			{
				StructType _tmp15_;
				StructType* _tmp16_;
#line 682 "document_structure.vala"
				_tmp15_ = STRUCT_TYPE_SUBPARAGRAPH;
#line 682 "document_structure.vala"
				_tmp16_ = __struct_type_dup0 (&_tmp15_);
#line 682 "document_structure.vala"
				result = _tmp16_;
#line 682 "document_structure.vala"
				return result;
#line 3887 "document_structure.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label14) ? _tmp1_label14 : (_tmp1_label14 = g_quark_from_static_string ("label")))) {
#line 654 "document_structure.vala"
		switch (0) {
#line 3893 "document_structure.c"
			default:
			{
				StructType _tmp17_;
				StructType* _tmp18_;
#line 685 "document_structure.vala"
				_tmp17_ = STRUCT_TYPE_LABEL;
#line 685 "document_structure.vala"
				_tmp18_ = __struct_type_dup0 (&_tmp17_);
#line 685 "document_structure.vala"
				result = _tmp18_;
#line 685 "document_structure.vala"
				return result;
#line 3906 "document_structure.c"
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label15) ? _tmp1_label15 : (_tmp1_label15 = g_quark_from_static_string ("input")))) || (_tmp2_ == ((0 != _tmp1_label16) ? _tmp1_label16 : (_tmp1_label16 = g_quark_from_static_string ("include"))))) {
#line 654 "document_structure.vala"
		switch (0) {
#line 3912 "document_structure.c"
			default:
			{
				StructType _tmp19_;
				StructType* _tmp20_;
#line 689 "document_structure.vala"
				_tmp19_ = STRUCT_TYPE_INCLUDE;
#line 689 "document_structure.vala"
				_tmp20_ = __struct_type_dup0 (&_tmp19_);
#line 689 "document_structure.vala"
				result = _tmp20_;
#line 689 "document_structure.vala"
				return result;
#line 3925 "document_structure.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label17) ? _tmp1_label17 : (_tmp1_label17 = g_quark_from_static_string ("includegraphics")))) {
#line 654 "document_structure.vala"
		switch (0) {
#line 3931 "document_structure.c"
			default:
			{
				StructType _tmp21_;
				StructType* _tmp22_;
#line 692 "document_structure.vala"
				_tmp21_ = STRUCT_TYPE_IMAGE;
#line 692 "document_structure.vala"
				_tmp22_ = __struct_type_dup0 (&_tmp21_);
#line 692 "document_structure.vala"
				result = _tmp22_;
#line 692 "document_structure.vala"
				return result;
#line 3944 "document_structure.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label18) ? _tmp1_label18 : (_tmp1_label18 = g_quark_from_static_string ("caption")))) {
#line 654 "document_structure.vala"
		switch (0) {
#line 3950 "document_structure.c"
			default:
			{
				StructType _tmp23_;
				StructType* _tmp24_;
#line 695 "document_structure.vala"
				_tmp23_ = STRUCT_TYPE_CAPTION;
#line 695 "document_structure.vala"
				_tmp24_ = __struct_type_dup0 (&_tmp23_);
#line 695 "document_structure.vala"
				result = _tmp24_;
#line 695 "document_structure.vala"
				return result;
#line 3963 "document_structure.c"
			}
		}
	} else {
#line 654 "document_structure.vala"
		switch (0) {
#line 3969 "document_structure.c"
			default:
			{
#line 698 "document_structure.vala"
				result = NULL;
#line 698 "document_structure.vala"
				return result;
#line 3976 "document_structure.c"
			}
		}
	}
}

static gchar*
document_structure_get_line_contents_at_iter (DocumentStructure* self,
                                              GtkTextIter* iter)
{
	GtkTextIter begin_line = {0};
	GtkTextIter _tmp0_;
	GtkTextIter end_line = {0};
	GtkTextIter _tmp1_;
	GtkTextBuffer* buffer = NULL;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextIter _tmp4_;
	GtkTextIter _tmp5_;
	gchar* _tmp6_;
	gchar* result = NULL;
#line 702 "document_structure.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 702 "document_structure.vala"
	g_return_val_if_fail (iter != NULL, NULL);
#line 704 "document_structure.vala"
	_tmp0_ = *iter;
#line 704 "document_structure.vala"
	begin_line = _tmp0_;
#line 705 "document_structure.vala"
	gtk_text_iter_set_line_offset (&begin_line, 0);
#line 707 "document_structure.vala"
	_tmp1_ = *iter;
#line 707 "document_structure.vala"
	end_line = _tmp1_;
#line 708 "document_structure.vala"
	if (!gtk_text_iter_ends_line (iter)) {
#line 709 "document_structure.vala"
		gtk_text_iter_forward_to_line_end (&end_line);
#line 4015 "document_structure.c"
	}
#line 711 "document_structure.vala"
	_tmp2_ = gtk_text_iter_get_buffer (iter);
#line 711 "document_structure.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 711 "document_structure.vala"
	buffer = _tmp3_;
#line 712 "document_structure.vala"
	_tmp4_ = begin_line;
#line 712 "document_structure.vala"
	_tmp5_ = end_line;
#line 712 "document_structure.vala"
	_tmp6_ = gtk_text_buffer_get_text (buffer, &_tmp4_, &_tmp5_, FALSE);
#line 712 "document_structure.vala"
	result = _tmp6_;
#line 712 "document_structure.vala"
	_g_object_unref0 (buffer);
#line 712 "document_structure.vala"
	return result;
#line 4035 "document_structure.c"
}

/*************************************************************************/
void
document_structure_do_action (DocumentStructure* self,
                              StructAction action_type,
                              GtkTreeIter* tree_iter,
                              gboolean* refresh_simple_list,
                              GError** error)
{
	gboolean _vala_refresh_simple_list = FALSE;
	Document* _tmp0_;
	gboolean shift_right = FALSE;
	gboolean _tmp5_ = FALSE;
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	gboolean found = FALSE;
	GtkTreeIter _tmp21_;
	GtkTextIter _tmp22_ = {0};
	GtkTextIter _tmp23_ = {0};
	gboolean _tmp24_;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp38_ = FALSE;
	GError* _inner_error0_ = NULL;
#line 718 "document_structure.vala"
	g_return_if_fail (self != NULL);
#line 718 "document_structure.vala"
	g_return_if_fail (tree_iter != NULL);
#line 721 "document_structure.vala"
	_vala_refresh_simple_list = FALSE;
#line 723 "document_structure.vala"
	_tmp0_ = self->priv->_doc;
#line 723 "document_structure.vala"
	if (_tmp0_ == NULL) {
#line 724 "document_structure.vala"
		if (refresh_simple_list) {
#line 724 "document_structure.vala"
			*refresh_simple_list = _vala_refresh_simple_list;
#line 4074 "document_structure.c"
		}
#line 724 "document_structure.vala"
		return;
#line 4078 "document_structure.c"
	}
#line 728 "document_structure.vala"
	if (action_type == STRUCT_ACTION_COMMENT) {
#line 4082 "document_structure.c"
		GtkTreeIter _tmp1_;
		StructureModel* _tmp3_;
		GtkTreeIter _tmp4_;
#line 730 "document_structure.vala"
		_tmp1_ = *tree_iter;
#line 730 "document_structure.vala"
		if (!document_structure_comment_item (self, &_tmp1_)) {
#line 4090 "document_structure.c"
			GError* _tmp2_;
#line 731 "document_structure.vala"
			_tmp2_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_DATA_OUTDATED, "");
#line 731 "document_structure.vala"
			_inner_error0_ = _tmp2_;
#line 731 "document_structure.vala"
			if (_inner_error0_->domain == STRUCT_ERROR) {
#line 731 "document_structure.vala"
				g_propagate_error (error, _inner_error0_);
#line 731 "document_structure.vala"
				return;
#line 4102 "document_structure.c"
			} else {
#line 731 "document_structure.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 731 "document_structure.vala"
				g_clear_error (&_inner_error0_);
#line 731 "document_structure.vala"
				return;
#line 4110 "document_structure.c"
			}
		}
#line 733 "document_structure.vala"
		_tmp3_ = self->priv->_model;
#line 733 "document_structure.vala"
		_tmp4_ = *tree_iter;
#line 733 "document_structure.vala"
		structure_model_delete (_tmp3_, &_tmp4_);
#line 734 "document_structure.vala"
		_vala_refresh_simple_list = TRUE;
#line 735 "document_structure.vala"
		if (refresh_simple_list) {
#line 735 "document_structure.vala"
			*refresh_simple_list = _vala_refresh_simple_list;
#line 4125 "document_structure.c"
		}
#line 735 "document_structure.vala"
		return;
#line 4129 "document_structure.c"
	}
#line 740 "document_structure.vala"
	shift_right = action_type == STRUCT_ACTION_SHIFT_RIGHT;
#line 741 "document_structure.vala"
	if (shift_right) {
#line 741 "document_structure.vala"
		_tmp5_ = TRUE;
#line 4137 "document_structure.c"
	} else {
#line 741 "document_structure.vala"
		_tmp5_ = action_type == STRUCT_ACTION_SHIFT_LEFT;
#line 4141 "document_structure.c"
	}
#line 741 "document_structure.vala"
	if (_tmp5_) {
#line 4145 "document_structure.c"
		gboolean _tmp6_ = FALSE;
		Document* _tmp10_;
		gboolean doc_modified = FALSE;
		gboolean success = FALSE;
		GtkTreeIter _tmp11_;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_;
		Document* _tmp14_;
#line 743 "document_structure.vala"
		if (shift_right) {
#line 4156 "document_structure.c"
			StructureModel* _tmp7_;
			GtkTreeIter _tmp8_;
#line 743 "document_structure.vala"
			_tmp7_ = self->priv->_model;
#line 743 "document_structure.vala"
			_tmp8_ = *tree_iter;
#line 743 "document_structure.vala"
			_tmp6_ = structure_model_item_contains_subparagraph (_tmp7_, &_tmp8_);
#line 4165 "document_structure.c"
		} else {
#line 743 "document_structure.vala"
			_tmp6_ = FALSE;
#line 4169 "document_structure.c"
		}
#line 743 "document_structure.vala"
		if (_tmp6_) {
#line 4173 "document_structure.c"
			GError* _tmp9_;
#line 744 "document_structure.vala"
			_tmp9_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_GENERAL, _ ("The structure item already contains a sub-paragraph."));
#line 744 "document_structure.vala"
			_inner_error0_ = _tmp9_;
#line 744 "document_structure.vala"
			if (_inner_error0_->domain == STRUCT_ERROR) {
#line 744 "document_structure.vala"
				g_propagate_error (error, _inner_error0_);
#line 744 "document_structure.vala"
				return;
#line 4185 "document_structure.c"
			} else {
#line 744 "document_structure.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 744 "document_structure.vala"
				g_clear_error (&_inner_error0_);
#line 744 "document_structure.vala"
				return;
#line 4193 "document_structure.c"
			}
		}
#line 747 "document_structure.vala"
		_tmp10_ = self->priv->_doc;
#line 747 "document_structure.vala"
		gtk_text_buffer_begin_user_action ((GtkTextBuffer*) _tmp10_);
#line 749 "document_structure.vala"
		_tmp11_ = *tree_iter;
#line 749 "document_structure.vala"
		_tmp13_ = document_structure_shift_item (self, &_tmp11_, shift_right, &_tmp12_);
#line 749 "document_structure.vala"
		doc_modified = _tmp12_;
#line 749 "document_structure.vala"
		success = _tmp13_;
#line 750 "document_structure.vala"
		_tmp14_ = self->priv->_doc;
#line 750 "document_structure.vala"
		gtk_text_buffer_end_user_action ((GtkTextBuffer*) _tmp14_);
#line 752 "document_structure.vala"
		if (!success) {
#line 4214 "document_structure.c"
			GError* _tmp16_;
#line 754 "document_structure.vala"
			if (doc_modified) {
#line 4218 "document_structure.c"
				Document* _tmp15_;
#line 755 "document_structure.vala"
				_tmp15_ = self->priv->_doc;
#line 755 "document_structure.vala"
				gtk_source_buffer_undo ((GtkSourceBuffer*) _tmp15_);
#line 4224 "document_structure.c"
			}
#line 757 "document_structure.vala"
			_tmp16_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_DATA_OUTDATED, "");
#line 757 "document_structure.vala"
			_inner_error0_ = _tmp16_;
#line 757 "document_structure.vala"
			if (_inner_error0_->domain == STRUCT_ERROR) {
#line 757 "document_structure.vala"
				g_propagate_error (error, _inner_error0_);
#line 757 "document_structure.vala"
				return;
#line 4236 "document_structure.c"
			} else {
#line 757 "document_structure.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 757 "document_structure.vala"
				g_clear_error (&_inner_error0_);
#line 757 "document_structure.vala"
				return;
#line 4244 "document_structure.c"
			}
		}
#line 760 "document_structure.vala"
		if (shift_right) {
#line 4249 "document_structure.c"
			StructureModel* _tmp17_;
			GtkTreeIter _tmp18_;
#line 761 "document_structure.vala"
			_tmp17_ = self->priv->_model;
#line 761 "document_structure.vala"
			_tmp18_ = *tree_iter;
#line 761 "document_structure.vala"
			structure_model_shift_right (_tmp17_, &_tmp18_);
#line 4258 "document_structure.c"
		} else {
			StructureModel* _tmp19_;
			GtkTreeIter _tmp20_;
#line 763 "document_structure.vala"
			_tmp19_ = self->priv->_model;
#line 763 "document_structure.vala"
			_tmp20_ = *tree_iter;
#line 763 "document_structure.vala"
			structure_model_shift_left (_tmp19_, &_tmp20_);
#line 4268 "document_structure.c"
		}
#line 764 "document_structure.vala"
		if (refresh_simple_list) {
#line 764 "document_structure.vala"
			*refresh_simple_list = _vala_refresh_simple_list;
#line 4274 "document_structure.c"
		}
#line 764 "document_structure.vala"
		return;
#line 4278 "document_structure.c"
	}
#line 771 "document_structure.vala"
	_tmp21_ = *tree_iter;
#line 771 "document_structure.vala"
	_tmp24_ = document_structure_get_exact_item_bounds (self, &_tmp21_, &_tmp22_, &_tmp23_);
#line 771 "document_structure.vala"
	start_iter = _tmp22_;
#line 771 "document_structure.vala"
	end_iter = _tmp23_;
#line 771 "document_structure.vala"
	found = _tmp24_;
#line 773 "document_structure.vala"
	if (!found) {
#line 4292 "document_structure.c"
		GError* _tmp25_;
#line 774 "document_structure.vala"
		_tmp25_ = g_error_new_literal (STRUCT_ERROR, STRUCT_ERROR_DATA_OUTDATED, "");
#line 774 "document_structure.vala"
		_inner_error0_ = _tmp25_;
#line 774 "document_structure.vala"
		if (_inner_error0_->domain == STRUCT_ERROR) {
#line 774 "document_structure.vala"
			g_propagate_error (error, _inner_error0_);
#line 774 "document_structure.vala"
			return;
#line 4304 "document_structure.c"
		} else {
#line 774 "document_structure.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 774 "document_structure.vala"
			g_clear_error (&_inner_error0_);
#line 774 "document_structure.vala"
			return;
#line 4312 "document_structure.c"
		}
	}
#line 776 "document_structure.vala"
	if (gtk_text_iter_get_line (&start_iter) != gtk_text_iter_get_line (&end_iter)) {
#line 778 "document_structure.vala"
		document_structure_backward_indentation (self, &start_iter);
#line 779 "document_structure.vala"
		document_structure_backward_indentation (self, &end_iter);
#line 4321 "document_structure.c"
	}
#line 782 "document_structure.vala"
	if (action_type == STRUCT_ACTION_SELECT) {
#line 4325 "document_structure.c"
		Document* _tmp26_;
		GtkTextIter _tmp27_;
		GtkTextIter _tmp28_;
#line 784 "document_structure.vala"
		_tmp26_ = self->priv->_doc;
#line 784 "document_structure.vala"
		_tmp27_ = start_iter;
#line 784 "document_structure.vala"
		_tmp28_ = end_iter;
#line 784 "document_structure.vala"
		gtk_text_buffer_select_range ((GtkTextBuffer*) _tmp26_, &_tmp27_, &_tmp28_);
#line 785 "document_structure.vala"
		if (refresh_simple_list) {
#line 785 "document_structure.vala"
			*refresh_simple_list = _vala_refresh_simple_list;
#line 4341 "document_structure.c"
		}
#line 785 "document_structure.vala"
		return;
#line 4345 "document_structure.c"
	}
#line 788 "document_structure.vala"
	if (action_type == STRUCT_ACTION_COPY) {
#line 788 "document_structure.vala"
		_tmp29_ = TRUE;
#line 4351 "document_structure.c"
	} else {
#line 788 "document_structure.vala"
		_tmp29_ = action_type == STRUCT_ACTION_CUT;
#line 4355 "document_structure.c"
	}
#line 788 "document_structure.vala"
	if (_tmp29_) {
#line 4359 "document_structure.c"
		gchar* data = NULL;
		Document* _tmp30_;
		GtkTextIter _tmp31_;
		GtkTextIter _tmp32_;
		gchar* _tmp33_;
		GtkClipboard* clipboard = NULL;
		GtkClipboard* _tmp34_;
		GtkClipboard* _tmp35_;
		GtkClipboard* _tmp36_;
		const gchar* _tmp37_;
#line 790 "document_structure.vala"
		_tmp30_ = self->priv->_doc;
#line 790 "document_structure.vala"
		_tmp31_ = start_iter;
#line 790 "document_structure.vala"
		_tmp32_ = end_iter;
#line 790 "document_structure.vala"
		_tmp33_ = gtk_text_buffer_get_text ((GtkTextBuffer*) _tmp30_, &_tmp31_, &_tmp32_, FALSE);
#line 790 "document_structure.vala"
		data = _tmp33_;
#line 791 "document_structure.vala"
		_tmp34_ = gtk_clipboard_get (GDK_SELECTION_CLIPBOARD);
#line 791 "document_structure.vala"
		_tmp35_ = _g_object_ref0 (_tmp34_);
#line 791 "document_structure.vala"
		clipboard = _tmp35_;
#line 792 "document_structure.vala"
		_tmp36_ = clipboard;
#line 792 "document_structure.vala"
		_tmp37_ = data;
#line 792 "document_structure.vala"
		gtk_clipboard_set_text (_tmp36_, _tmp37_, -1);
#line 788 "document_structure.vala"
		_g_object_unref0 (clipboard);
#line 788 "document_structure.vala"
		_g_free0 (data);
#line 4396 "document_structure.c"
	}
#line 795 "document_structure.vala"
	if (action_type == STRUCT_ACTION_DELETE) {
#line 795 "document_structure.vala"
		_tmp38_ = TRUE;
#line 4402 "document_structure.c"
	} else {
#line 795 "document_structure.vala"
		_tmp38_ = action_type == STRUCT_ACTION_CUT;
#line 4406 "document_structure.c"
	}
#line 795 "document_structure.vala"
	if (_tmp38_) {
#line 4410 "document_structure.c"
		Document* _tmp39_;
		Document* _tmp40_;
		Document* _tmp41_;
		StructureModel* _tmp42_;
		GtkTreeIter _tmp43_;
#line 797 "document_structure.vala"
		_tmp39_ = self->priv->_doc;
#line 797 "document_structure.vala"
		gtk_text_buffer_begin_user_action ((GtkTextBuffer*) _tmp39_);
#line 798 "document_structure.vala"
		_tmp40_ = self->priv->_doc;
#line 798 "document_structure.vala"
		gtk_text_buffer_delete ((GtkTextBuffer*) _tmp40_, &start_iter, &end_iter);
#line 799 "document_structure.vala"
		_tmp41_ = self->priv->_doc;
#line 799 "document_structure.vala"
		gtk_text_buffer_end_user_action ((GtkTextBuffer*) _tmp41_);
#line 801 "document_structure.vala"
		_tmp42_ = self->priv->_model;
#line 801 "document_structure.vala"
		_tmp43_ = *tree_iter;
#line 801 "document_structure.vala"
		structure_model_delete (_tmp42_, &_tmp43_);
#line 802 "document_structure.vala"
		_vala_refresh_simple_list = TRUE;
#line 4436 "document_structure.c"
	}
#line 718 "document_structure.vala"
	if (refresh_simple_list) {
#line 718 "document_structure.vala"
		*refresh_simple_list = _vala_refresh_simple_list;
#line 4442 "document_structure.c"
	}
}

static gboolean
document_structure_comment_item (DocumentStructure* self,
                                 GtkTreeIter* tree_iter)
{
	StructType type = 0;
	GtkTextMark* start_mark = NULL;
	GtkTextMark* end_mark = NULL;
	StructureModel* _tmp0_;
	GtkTreeIter _tmp1_;
	StructType _tmp2_ = 0;
	GtkTextMark* _tmp3_ = NULL;
	GtkTextMark* _tmp4_ = NULL;
	GtkTextIter start_iter = {0};
	GtkTextIter end_iter = {0};
	GtkTextIter _tmp5_ = {0};
	gboolean end_iter_set = FALSE;
	Document* _tmp6_;
	GtkTextMark* _tmp7_;
	GtkTextIter _tmp8_ = {0};
	GtkTextMark* _tmp9_;
	StructType _tmp13_;
	GtkTreeIter* next_section_iter = NULL;
	gboolean go_one_line_backward = FALSE;
	GtkTreeIter* _tmp26_;
	Document* _tmp36_;
	GtkTextIter _tmp37_;
	GtkTextIter _tmp38_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
#line 807 "document_structure.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 807 "document_structure.vala"
	g_return_val_if_fail (tree_iter != NULL, FALSE);
#line 810 "document_structure.vala"
	start_mark = NULL;
#line 811 "document_structure.vala"
	end_mark = NULL;
#line 813 "document_structure.vala"
	_tmp0_ = self->priv->_model;
#line 813 "document_structure.vala"
	_tmp1_ = *tree_iter;
#line 813 "document_structure.vala"
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, STRUCT_COLUMN_TYPE, &_tmp2_, STRUCT_COLUMN_START_MARK, &_tmp3_, STRUCT_COLUMN_END_MARK, &_tmp4_, -1, -1);
#line 813 "document_structure.vala"
	type = _tmp2_;
#line 813 "document_structure.vala"
	_g_object_unref0 (start_mark);
#line 813 "document_structure.vala"
	start_mark = _tmp3_;
#line 813 "document_structure.vala"
	_g_object_unref0 (end_mark);
#line 813 "document_structure.vala"
	end_mark = _tmp4_;
#line 820 "document_structure.vala"
	end_iter = _tmp5_;
#line 821 "document_structure.vala"
	end_iter_set = FALSE;
#line 823 "document_structure.vala"
	_tmp6_ = self->priv->_doc;
#line 823 "document_structure.vala"
	_tmp7_ = start_mark;
#line 823 "document_structure.vala"
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp6_, &_tmp8_, _tmp7_);
#line 823 "document_structure.vala"
	start_iter = _tmp8_;
#line 825 "document_structure.vala"
	_tmp9_ = end_mark;
#line 825 "document_structure.vala"
	if (_tmp9_ != NULL) {
#line 4515 "document_structure.c"
		Document* _tmp10_;
		GtkTextMark* _tmp11_;
		GtkTextIter _tmp12_ = {0};
#line 827 "document_structure.vala"
		_tmp10_ = self->priv->_doc;
#line 827 "document_structure.vala"
		_tmp11_ = end_mark;
#line 827 "document_structure.vala"
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp10_, &_tmp12_, _tmp11_);
#line 827 "document_structure.vala"
		end_iter = _tmp12_;
#line 828 "document_structure.vala"
		end_iter_set = TRUE;
#line 4529 "document_structure.c"
	}
#line 832 "document_structure.vala"
	_tmp13_ = type;
#line 832 "document_structure.vala"
	if (!structure_is_section (_tmp13_)) {
#line 4535 "document_structure.c"
		Document* _tmp14_;
		GtkTextIter _tmp15_;
		GtkTextIter _tmp16_;
#line 834 "document_structure.vala"
		_tmp14_ = self->priv->_doc;
#line 834 "document_structure.vala"
		_tmp15_ = start_iter;
#line 834 "document_structure.vala"
		_tmp16_ = end_iter;
#line 834 "document_structure.vala"
		document_comment_between (_tmp14_, &_tmp15_, &_tmp16_, end_iter_set);
#line 835 "document_structure.vala"
		result = TRUE;
#line 835 "document_structure.vala"
		_g_object_unref0 (end_mark);
#line 835 "document_structure.vala"
		_g_object_unref0 (start_mark);
#line 835 "document_structure.vala"
		return result;
#line 4555 "document_structure.c"
	}
#line 841 "document_structure.vala"
	next_section_iter = NULL;
#line 4559 "document_structure.c"
	{
		GtkTreeIter* _tmp17_ = NULL;
		StructureModel* _tmp18_;
		GtkTreeIter _tmp19_;
		GtkTreeIter* _tmp20_;
		GtkTreeIter* _tmp22_;
#line 844 "document_structure.vala"
		_tmp18_ = self->priv->_model;
#line 844 "document_structure.vala"
		_tmp19_ = *tree_iter;
#line 844 "document_structure.vala"
		_tmp20_ = structure_model_get_next_sibling_or_parent (_tmp18_, &_tmp19_, &_inner_error0_);
#line 844 "document_structure.vala"
		_tmp17_ = _tmp20_;
#line 844 "document_structure.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4576 "document_structure.c"
			gboolean _tmp21_ = FALSE;
#line 844 "document_structure.vala"
			if (_inner_error0_->domain == STRUCT_ERROR) {
#line 4580 "document_structure.c"
				goto __catch0_struct_error;
			}
#line 844 "document_structure.vala"
			__vala_GtkTreeIter_free0 (next_section_iter);
#line 844 "document_structure.vala"
			_g_object_unref0 (end_mark);
#line 844 "document_structure.vala"
			_g_object_unref0 (start_mark);
#line 844 "document_structure.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 844 "document_structure.vala"
			g_clear_error (&_inner_error0_);
#line 844 "document_structure.vala"
			return _tmp21_;
#line 4595 "document_structure.c"
		}
#line 844 "document_structure.vala"
		_tmp22_ = _tmp17_;
#line 844 "document_structure.vala"
		_tmp17_ = NULL;
#line 844 "document_structure.vala"
		__vala_GtkTreeIter_free0 (next_section_iter);
#line 844 "document_structure.vala"
		next_section_iter = _tmp22_;
#line 842 "document_structure.vala"
		__vala_GtkTreeIter_free0 (_tmp17_);
#line 4607 "document_structure.c"
	}
	goto __finally0;
	__catch0_struct_error:
	{
		GError* e = NULL;
		GError* _tmp23_;
		const gchar* _tmp24_;
#line 842 "document_structure.vala"
		e = _inner_error0_;
#line 842 "document_structure.vala"
		_inner_error0_ = NULL;
#line 848 "document_structure.vala"
		_tmp23_ = e;
#line 848 "document_structure.vala"
		_tmp24_ = _tmp23_->message;
#line 848 "document_structure.vala"
		g_warning ("document_structure.vala:848: Structure: get next sibling or parent: %s", _tmp24_);
#line 849 "document_structure.vala"
		result = FALSE;
#line 849 "document_structure.vala"
		_g_error_free0 (e);
#line 849 "document_structure.vala"
		__vala_GtkTreeIter_free0 (next_section_iter);
#line 849 "document_structure.vala"
		_g_object_unref0 (end_mark);
#line 849 "document_structure.vala"
		_g_object_unref0 (start_mark);
#line 849 "document_structure.vala"
		return result;
#line 4637 "document_structure.c"
	}
	__finally0:
#line 842 "document_structure.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4642 "document_structure.c"
		gboolean _tmp25_ = FALSE;
#line 842 "document_structure.vala"
		__vala_GtkTreeIter_free0 (next_section_iter);
#line 842 "document_structure.vala"
		_g_object_unref0 (end_mark);
#line 842 "document_structure.vala"
		_g_object_unref0 (start_mark);
#line 842 "document_structure.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 842 "document_structure.vala"
		g_clear_error (&_inner_error0_);
#line 842 "document_structure.vala"
		return _tmp25_;
#line 4656 "document_structure.c"
	}
#line 852 "document_structure.vala"
	go_one_line_backward = TRUE;
#line 855 "document_structure.vala"
	_tmp26_ = next_section_iter;
#line 855 "document_structure.vala"
	if (_tmp26_ == NULL) {
#line 4664 "document_structure.c"
		gboolean end_of_file = FALSE;
		gboolean _tmp27_ = FALSE;
		GtkTextIter _tmp28_ = {0};
#line 858 "document_structure.vala"
		document_structure_get_end_document_iter (self, &_tmp27_, &_tmp28_);
#line 858 "document_structure.vala"
		end_of_file = _tmp27_;
#line 858 "document_structure.vala"
		end_iter = _tmp28_;
#line 859 "document_structure.vala"
		end_iter_set = TRUE;
#line 860 "document_structure.vala"
		go_one_line_backward = !end_of_file;
#line 4678 "document_structure.c"
	} else {
		StructureModel* _tmp29_;
		GtkTreeIter* _tmp30_;
		GtkTreeIter _tmp31_;
		GtkTextMark* _tmp32_ = NULL;
		Document* _tmp33_;
		GtkTextMark* _tmp34_;
		GtkTextIter _tmp35_ = {0};
#line 865 "document_structure.vala"
		_tmp29_ = self->priv->_model;
#line 865 "document_structure.vala"
		_tmp30_ = next_section_iter;
#line 865 "document_structure.vala"
		_tmp31_ = *_tmp30_;
#line 865 "document_structure.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp29_, &_tmp31_, STRUCT_COLUMN_START_MARK, &_tmp32_, -1, -1);
#line 865 "document_structure.vala"
		_g_object_unref0 (end_mark);
#line 865 "document_structure.vala"
		end_mark = _tmp32_;
#line 869 "document_structure.vala"
		_tmp33_ = self->priv->_doc;
#line 869 "document_structure.vala"
		_tmp34_ = end_mark;
#line 869 "document_structure.vala"
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp33_, &_tmp35_, _tmp34_);
#line 869 "document_structure.vala"
		end_iter = _tmp35_;
#line 870 "document_structure.vala"
		end_iter_set = TRUE;
#line 4709 "document_structure.c"
	}
#line 873 "document_structure.vala"
	if (go_one_line_backward) {
#line 875 "document_structure.vala"
		if (!gtk_text_iter_backward_line (&end_iter)) {
#line 876 "document_structure.vala"
			end_iter_set = FALSE;
#line 4717 "document_structure.c"
		}
	}
#line 879 "document_structure.vala"
	_tmp36_ = self->priv->_doc;
#line 879 "document_structure.vala"
	_tmp37_ = start_iter;
#line 879 "document_structure.vala"
	_tmp38_ = end_iter;
#line 879 "document_structure.vala"
	document_comment_between (_tmp36_, &_tmp37_, &_tmp38_, end_iter_set);
#line 880 "document_structure.vala"
	result = TRUE;
#line 880 "document_structure.vala"
	__vala_GtkTreeIter_free0 (next_section_iter);
#line 880 "document_structure.vala"
	_g_object_unref0 (end_mark);
#line 880 "document_structure.vala"
	_g_object_unref0 (start_mark);
#line 880 "document_structure.vala"
	return result;
#line 4738 "document_structure.c"
}

static gboolean
document_structure_get_exact_item_bounds (DocumentStructure* self,
                                          GtkTreeIter* tree_iter,
                                          GtkTextIter* start_iter,
                                          GtkTextIter* end_iter)
{
	GtkTextIter _vala_start_iter = {0};
	GtkTextIter _vala_end_iter = {0};
	StructType item_type = 0;
	GtkTextMark* start_mark = NULL;
	GtkTextMark* end_mark = NULL;
	gchar* item_contents = NULL;
	StructureModel* _tmp0_;
	GtkTreeIter _tmp1_;
	StructType _tmp2_ = 0;
	GtkTextMark* _tmp3_ = NULL;
	GtkTextMark* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	Document* _tmp6_;
	GtkTextMark* _tmp7_;
	GtkTextIter _tmp8_ = {0};
	gboolean found = FALSE;
	StructType _tmp9_;
	const gchar* _tmp10_;
	GtkTextIter _tmp11_;
	GtkTextIter _tmp12_ = {0};
	gboolean _tmp13_;
	StructType _tmp14_;
	GtkTextMark* _tmp39_;
	GtkTextIter end_env_iter = {0};
	Document* _tmp40_;
	GtkTextMark* _tmp41_;
	GtkTextIter _tmp42_ = {0};
	StructType _tmp43_;
	const gchar* _tmp44_;
	GtkTextIter _tmp45_;
	GtkTextIter _tmp46_ = {0};
	gboolean _tmp47_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
#line 884 "document_structure.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 884 "document_structure.vala"
	g_return_val_if_fail (tree_iter != NULL, FALSE);
#line 889 "document_structure.vala"
	start_mark = NULL;
#line 890 "document_structure.vala"
	end_mark = NULL;
#line 891 "document_structure.vala"
	item_contents = NULL;
#line 893 "document_structure.vala"
	_tmp0_ = self->priv->_model;
#line 893 "document_structure.vala"
	_tmp1_ = *tree_iter;
#line 893 "document_structure.vala"
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, STRUCT_COLUMN_TYPE, &_tmp2_, STRUCT_COLUMN_START_MARK, &_tmp3_, STRUCT_COLUMN_END_MARK, &_tmp4_, STRUCT_COLUMN_TEXT, &_tmp5_, -1, -1);
#line 893 "document_structure.vala"
	item_type = _tmp2_;
#line 893 "document_structure.vala"
	_g_object_unref0 (start_mark);
#line 893 "document_structure.vala"
	start_mark = _tmp3_;
#line 893 "document_structure.vala"
	_g_object_unref0 (end_mark);
#line 893 "document_structure.vala"
	end_mark = _tmp4_;
#line 893 "document_structure.vala"
	_g_free0 (item_contents);
#line 893 "document_structure.vala"
	item_contents = _tmp5_;
#line 901 "document_structure.vala"
	_tmp6_ = self->priv->_doc;
#line 901 "document_structure.vala"
	_tmp7_ = start_mark;
#line 901 "document_structure.vala"
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp6_, &_tmp8_, _tmp7_);
#line 901 "document_structure.vala"
	_vala_start_iter = _tmp8_;
#line 905 "document_structure.vala"
	_tmp9_ = item_type;
#line 905 "document_structure.vala"
	_tmp10_ = item_contents;
#line 905 "document_structure.vala"
	_tmp11_ = _vala_start_iter;
#line 905 "document_structure.vala"
	_tmp13_ = document_structure_get_low_level_item_bounds (self, _tmp9_, _tmp10_, &_tmp11_, TRUE, &_tmp12_);
#line 905 "document_structure.vala"
	_vala_end_iter = _tmp12_;
#line 905 "document_structure.vala"
	found = _tmp13_;
#line 908 "document_structure.vala"
	if (!found) {
#line 909 "document_structure.vala"
		result = FALSE;
#line 909 "document_structure.vala"
		_g_free0 (item_contents);
#line 909 "document_structure.vala"
		_g_object_unref0 (end_mark);
#line 909 "document_structure.vala"
		_g_object_unref0 (start_mark);
#line 909 "document_structure.vala"
		if (start_iter) {
#line 909 "document_structure.vala"
			*start_iter = _vala_start_iter;
#line 4845 "document_structure.c"
		}
#line 909 "document_structure.vala"
		if (end_iter) {
#line 909 "document_structure.vala"
			*end_iter = _vala_end_iter;
#line 4851 "document_structure.c"
		}
#line 909 "document_structure.vala"
		return result;
#line 4855 "document_structure.c"
	}
#line 914 "document_structure.vala"
	_tmp14_ = item_type;
#line 914 "document_structure.vala"
	if (structure_is_section (_tmp14_)) {
#line 4861 "document_structure.c"
		GtkTreeIter* next_section_iter = NULL;
		GtkTreeIter* _tmp24_;
		StructureModel* _tmp26_;
		GtkTreeIter* _tmp27_;
		GtkTreeIter _tmp28_;
		StructType _tmp29_ = 0;
		GtkTextMark* _tmp30_ = NULL;
		gchar* _tmp31_ = NULL;
		Document* _tmp32_;
		GtkTextMark* _tmp33_;
		GtkTextIter _tmp34_ = {0};
		StructType _tmp35_;
		const gchar* _tmp36_;
		GtkTextIter _tmp37_;
#line 916 "document_structure.vala"
		next_section_iter = NULL;
#line 4878 "document_structure.c"
		{
			GtkTreeIter* _tmp15_ = NULL;
			StructureModel* _tmp16_;
			GtkTreeIter _tmp17_;
			GtkTreeIter* _tmp18_;
			GtkTreeIter* _tmp20_;
#line 919 "document_structure.vala"
			_tmp16_ = self->priv->_model;
#line 919 "document_structure.vala"
			_tmp17_ = *tree_iter;
#line 919 "document_structure.vala"
			_tmp18_ = structure_model_get_next_sibling_or_parent (_tmp16_, &_tmp17_, &_inner_error0_);
#line 919 "document_structure.vala"
			_tmp15_ = _tmp18_;
#line 919 "document_structure.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4895 "document_structure.c"
				gboolean _tmp19_ = FALSE;
#line 919 "document_structure.vala"
				if (_inner_error0_->domain == STRUCT_ERROR) {
#line 4899 "document_structure.c"
					goto __catch0_struct_error;
				}
#line 919 "document_structure.vala"
				__vala_GtkTreeIter_free0 (next_section_iter);
#line 919 "document_structure.vala"
				_g_free0 (item_contents);
#line 919 "document_structure.vala"
				_g_object_unref0 (end_mark);
#line 919 "document_structure.vala"
				_g_object_unref0 (start_mark);
#line 919 "document_structure.vala"
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 919 "document_structure.vala"
				g_clear_error (&_inner_error0_);
#line 919 "document_structure.vala"
				return _tmp19_;
#line 4916 "document_structure.c"
			}
#line 919 "document_structure.vala"
			_tmp20_ = _tmp15_;
#line 919 "document_structure.vala"
			_tmp15_ = NULL;
#line 919 "document_structure.vala"
			__vala_GtkTreeIter_free0 (next_section_iter);
#line 919 "document_structure.vala"
			next_section_iter = _tmp20_;
#line 917 "document_structure.vala"
			__vala_GtkTreeIter_free0 (_tmp15_);
#line 4928 "document_structure.c"
		}
		goto __finally0;
		__catch0_struct_error:
		{
			GError* e = NULL;
			GError* _tmp21_;
			const gchar* _tmp22_;
#line 917 "document_structure.vala"
			e = _inner_error0_;
#line 917 "document_structure.vala"
			_inner_error0_ = NULL;
#line 923 "document_structure.vala"
			_tmp21_ = e;
#line 923 "document_structure.vala"
			_tmp22_ = _tmp21_->message;
#line 923 "document_structure.vala"
			g_warning ("document_structure.vala:923: Structure: get next sibling or parent: %s", _tmp22_);
#line 924 "document_structure.vala"
			result = FALSE;
#line 924 "document_structure.vala"
			_g_error_free0 (e);
#line 924 "document_structure.vala"
			__vala_GtkTreeIter_free0 (next_section_iter);
#line 924 "document_structure.vala"
			_g_free0 (item_contents);
#line 924 "document_structure.vala"
			_g_object_unref0 (end_mark);
#line 924 "document_structure.vala"
			_g_object_unref0 (start_mark);
#line 924 "document_structure.vala"
			if (start_iter) {
#line 924 "document_structure.vala"
				*start_iter = _vala_start_iter;
#line 4962 "document_structure.c"
			}
#line 924 "document_structure.vala"
			if (end_iter) {
#line 924 "document_structure.vala"
				*end_iter = _vala_end_iter;
#line 4968 "document_structure.c"
			}
#line 924 "document_structure.vala"
			return result;
#line 4972 "document_structure.c"
		}
		__finally0:
#line 917 "document_structure.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 4977 "document_structure.c"
			gboolean _tmp23_ = FALSE;
#line 917 "document_structure.vala"
			__vala_GtkTreeIter_free0 (next_section_iter);
#line 917 "document_structure.vala"
			_g_free0 (item_contents);
#line 917 "document_structure.vala"
			_g_object_unref0 (end_mark);
#line 917 "document_structure.vala"
			_g_object_unref0 (start_mark);
#line 917 "document_structure.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 917 "document_structure.vala"
			g_clear_error (&_inner_error0_);
#line 917 "document_structure.vala"
			return _tmp23_;
#line 4993 "document_structure.c"
		}
#line 928 "document_structure.vala"
		_tmp24_ = next_section_iter;
#line 928 "document_structure.vala"
		if (_tmp24_ == NULL) {
#line 4999 "document_structure.c"
			GtkTextIter _tmp25_ = {0};
#line 930 "document_structure.vala"
			document_structure_get_end_document_iter (self, NULL, &_tmp25_);
#line 930 "document_structure.vala"
			_vala_end_iter = _tmp25_;
#line 931 "document_structure.vala"
			result = TRUE;
#line 931 "document_structure.vala"
			__vala_GtkTreeIter_free0 (next_section_iter);
#line 931 "document_structure.vala"
			_g_free0 (item_contents);
#line 931 "document_structure.vala"
			_g_object_unref0 (end_mark);
#line 931 "document_structure.vala"
			_g_object_unref0 (start_mark);
#line 931 "document_structure.vala"
			if (start_iter) {
#line 931 "document_structure.vala"
				*start_iter = _vala_start_iter;
#line 5019 "document_structure.c"
			}
#line 931 "document_structure.vala"
			if (end_iter) {
#line 931 "document_structure.vala"
				*end_iter = _vala_end_iter;
#line 5025 "document_structure.c"
			}
#line 931 "document_structure.vala"
			return result;
#line 5029 "document_structure.c"
		}
#line 934 "document_structure.vala"
		_tmp26_ = self->priv->_model;
#line 934 "document_structure.vala"
		_tmp27_ = next_section_iter;
#line 934 "document_structure.vala"
		_tmp28_ = *_tmp27_;
#line 934 "document_structure.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp26_, &_tmp28_, STRUCT_COLUMN_TYPE, &_tmp29_, STRUCT_COLUMN_START_MARK, &_tmp30_, STRUCT_COLUMN_TEXT, &_tmp31_, -1, -1);
#line 934 "document_structure.vala"
		item_type = _tmp29_;
#line 934 "document_structure.vala"
		_g_object_unref0 (start_mark);
#line 934 "document_structure.vala"
		start_mark = _tmp30_;
#line 934 "document_structure.vala"
		_g_free0 (item_contents);
#line 934 "document_structure.vala"
		item_contents = _tmp31_;
#line 940 "document_structure.vala"
		_tmp32_ = self->priv->_doc;
#line 940 "document_structure.vala"
		_tmp33_ = start_mark;
#line 940 "document_structure.vala"
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp32_, &_tmp34_, _tmp33_);
#line 940 "document_structure.vala"
		_vala_end_iter = _tmp34_;
#line 942 "document_structure.vala"
		_tmp35_ = item_type;
#line 942 "document_structure.vala"
		_tmp36_ = item_contents;
#line 942 "document_structure.vala"
		_tmp37_ = _vala_end_iter;
#line 942 "document_structure.vala"
		result = document_structure_get_low_level_item_bounds (self, _tmp35_, _tmp36_, &_tmp37_, TRUE, NULL);
#line 942 "document_structure.vala"
		__vala_GtkTreeIter_free0 (next_section_iter);
#line 942 "document_structure.vala"
		_g_free0 (item_contents);
#line 942 "document_structure.vala"
		_g_object_unref0 (end_mark);
#line 942 "document_structure.vala"
		_g_object_unref0 (start_mark);
#line 942 "document_structure.vala"
		if (start_iter) {
#line 942 "document_structure.vala"
			*start_iter = _vala_start_iter;
#line 5077 "document_structure.c"
		}
#line 942 "document_structure.vala"
		if (end_iter) {
#line 942 "document_structure.vala"
			*end_iter = _vala_end_iter;
#line 5083 "document_structure.c"
		}
#line 942 "document_structure.vala"
		return result;
#line 5087 "document_structure.c"
	} else {
		StructType _tmp38_;
#line 947 "document_structure.vala"
		_tmp38_ = item_type;
#line 947 "document_structure.vala"
		if (structure_is_common_type (_tmp38_)) {
#line 948 "document_structure.vala"
			result = TRUE;
#line 948 "document_structure.vala"
			_g_free0 (item_contents);
#line 948 "document_structure.vala"
			_g_object_unref0 (end_mark);
#line 948 "document_structure.vala"
			_g_object_unref0 (start_mark);
#line 948 "document_structure.vala"
			if (start_iter) {
#line 948 "document_structure.vala"
				*start_iter = _vala_start_iter;
#line 5106 "document_structure.c"
			}
#line 948 "document_structure.vala"
			if (end_iter) {
#line 948 "document_structure.vala"
				*end_iter = _vala_end_iter;
#line 5112 "document_structure.c"
			}
#line 948 "document_structure.vala"
			return result;
#line 5116 "document_structure.c"
		}
	}
#line 951 "document_structure.vala"
	_tmp39_ = end_mark;
#line 951 "document_structure.vala"
	if (_tmp39_ == NULL) {
#line 952 "document_structure.vala"
		result = FALSE;
#line 952 "document_structure.vala"
		_g_free0 (item_contents);
#line 952 "document_structure.vala"
		_g_object_unref0 (end_mark);
#line 952 "document_structure.vala"
		_g_object_unref0 (start_mark);
#line 952 "document_structure.vala"
		if (start_iter) {
#line 952 "document_structure.vala"
			*start_iter = _vala_start_iter;
#line 5135 "document_structure.c"
		}
#line 952 "document_structure.vala"
		if (end_iter) {
#line 952 "document_structure.vala"
			*end_iter = _vala_end_iter;
#line 5141 "document_structure.c"
		}
#line 952 "document_structure.vala"
		return result;
#line 5145 "document_structure.c"
	}
#line 955 "document_structure.vala"
	_tmp40_ = self->priv->_doc;
#line 955 "document_structure.vala"
	_tmp41_ = end_mark;
#line 955 "document_structure.vala"
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp40_, &_tmp42_, _tmp41_);
#line 955 "document_structure.vala"
	end_env_iter = _tmp42_;
#line 957 "document_structure.vala"
	_tmp43_ = item_type;
#line 957 "document_structure.vala"
	_tmp44_ = item_contents;
#line 957 "document_structure.vala"
	_tmp45_ = end_env_iter;
#line 957 "document_structure.vala"
	_tmp47_ = document_structure_get_low_level_item_bounds (self, _tmp43_, _tmp44_, &_tmp45_, FALSE, &_tmp46_);
#line 957 "document_structure.vala"
	_vala_end_iter = _tmp46_;
#line 957 "document_structure.vala"
	result = _tmp47_;
#line 957 "document_structure.vala"
	_g_free0 (item_contents);
#line 957 "document_structure.vala"
	_g_object_unref0 (end_mark);
#line 957 "document_structure.vala"
	_g_object_unref0 (start_mark);
#line 957 "document_structure.vala"
	if (start_iter) {
#line 957 "document_structure.vala"
		*start_iter = _vala_start_iter;
#line 5177 "document_structure.c"
	}
#line 957 "document_structure.vala"
	if (end_iter) {
#line 957 "document_structure.vala"
		*end_iter = _vala_end_iter;
#line 5183 "document_structure.c"
	}
#line 957 "document_structure.vala"
	return result;
#line 5187 "document_structure.c"
}

static gboolean
_int_equal (const gint * s1,
            const gint * s2)
{
#line 979 "document_structure.vala"
	if (s1 == s2) {
#line 979 "document_structure.vala"
		return TRUE;
#line 5198 "document_structure.c"
	}
#line 979 "document_structure.vala"
	if (s1 == NULL) {
#line 979 "document_structure.vala"
		return FALSE;
#line 5204 "document_structure.c"
	}
#line 979 "document_structure.vala"
	if (s2 == NULL) {
#line 979 "document_structure.vala"
		return FALSE;
#line 5210 "document_structure.c"
	}
#line 979 "document_structure.vala"
	return (*s1) == (*s2);
#line 5214 "document_structure.c"
}

static gboolean
document_structure_get_low_level_item_bounds (DocumentStructure* self,
                                              StructType item_type,
                                              const gchar* item_contents,
                                              GtkTextIter* start_match_iter,
                                              gboolean is_start,
                                              GtkTextIter* end_match_iter)
{
	GtkTextIter _vala_end_match_iter = {0};
	GtkTextIter _tmp0_ = {0};
	gchar* line = NULL;
	GtkTextIter _tmp1_;
	gchar* _tmp2_;
	gint start_index = 0;
	StructType* low_level_type = NULL;
	gchar* contents = NULL;
	gint* start_match_index = NULL;
	gint* end_match_index = NULL;
	gboolean found = FALSE;
	const gchar* _tmp3_;
	StructType* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gint* _tmp6_ = NULL;
	gint* _tmp7_ = NULL;
	gboolean _tmp8_;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp11_;
	StructType* _tmp13_;
	const gchar* _tmp14_;
	gboolean result = FALSE;
#line 961 "document_structure.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 961 "document_structure.vala"
	g_return_val_if_fail (item_contents != NULL, FALSE);
#line 961 "document_structure.vala"
	g_return_val_if_fail (start_match_iter != NULL, FALSE);
#line 964 "document_structure.vala"
	_vala_end_match_iter = _tmp0_;
#line 966 "document_structure.vala"
	_tmp1_ = *start_match_iter;
#line 966 "document_structure.vala"
	_tmp2_ = document_structure_get_line_contents_at_iter (self, &_tmp1_);
#line 966 "document_structure.vala"
	line = _tmp2_;
#line 969 "document_structure.vala"
	start_index = gtk_text_iter_get_line_index (start_match_iter);
#line 975 "document_structure.vala"
	_tmp3_ = line;
#line 975 "document_structure.vala"
	_tmp8_ = document_structure_search_low_level_item (self, _tmp3_, start_index, &_tmp4_, &_tmp5_, &_tmp6_, &_tmp7_);
#line 975 "document_structure.vala"
	_g_free0 (low_level_type);
#line 975 "document_structure.vala"
	low_level_type = _tmp4_;
#line 975 "document_structure.vala"
	_g_free0 (contents);
#line 975 "document_structure.vala"
	contents = _tmp5_;
#line 975 "document_structure.vala"
	_g_free0 (start_match_index);
#line 975 "document_structure.vala"
	start_match_index = _tmp6_;
#line 975 "document_structure.vala"
	_g_free0 (end_match_index);
#line 975 "document_structure.vala"
	end_match_index = _tmp7_;
#line 975 "document_structure.vala"
	found = _tmp8_;
#line 979 "document_structure.vala"
	if (!found) {
#line 979 "document_structure.vala"
		_tmp9_ = TRUE;
#line 5289 "document_structure.c"
	} else {
		gint* _tmp10_;
#line 979 "document_structure.vala"
		_tmp10_ = start_match_index;
#line 979 "document_structure.vala"
		_tmp9_ = _int_equal (&start_index, _tmp10_) != TRUE;
#line 5296 "document_structure.c"
	}
#line 979 "document_structure.vala"
	if (_tmp9_) {
#line 980 "document_structure.vala"
		result = FALSE;
#line 980 "document_structure.vala"
		_g_free0 (end_match_index);
#line 980 "document_structure.vala"
		_g_free0 (start_match_index);
#line 980 "document_structure.vala"
		_g_free0 (contents);
#line 980 "document_structure.vala"
		_g_free0 (low_level_type);
#line 980 "document_structure.vala"
		_g_free0 (line);
#line 980 "document_structure.vala"
		if (end_match_iter) {
#line 980 "document_structure.vala"
			*end_match_iter = _vala_end_match_iter;
#line 5316 "document_structure.c"
		}
#line 980 "document_structure.vala"
		return result;
#line 5320 "document_structure.c"
	}
#line 982 "document_structure.vala"
	_tmp11_ = contents;
#line 982 "document_structure.vala"
	if (_tmp11_ == NULL) {
#line 5326 "document_structure.c"
		gchar* _tmp12_;
#line 983 "document_structure.vala"
		_tmp12_ = g_strdup ("");
#line 983 "document_structure.vala"
		_g_free0 (contents);
#line 983 "document_structure.vala"
		contents = _tmp12_;
#line 5334 "document_structure.c"
	}
#line 986 "document_structure.vala"
	_tmp13_ = low_level_type;
#line 986 "document_structure.vala"
	_tmp14_ = contents;
#line 986 "document_structure.vala"
	if (document_structure_same_items (self, item_type, item_contents, *_tmp13_, _tmp14_, is_start)) {
#line 5342 "document_structure.c"
		GtkTextIter _tmp15_;
		gint* _tmp16_;
#line 988 "document_structure.vala"
		_tmp15_ = *start_match_iter;
#line 988 "document_structure.vala"
		_vala_end_match_iter = _tmp15_;
#line 989 "document_structure.vala"
		_tmp16_ = end_match_index;
#line 989 "document_structure.vala"
		gtk_text_iter_set_line_index (&_vala_end_match_iter, *_tmp16_);
#line 990 "document_structure.vala"
		result = TRUE;
#line 990 "document_structure.vala"
		_g_free0 (end_match_index);
#line 990 "document_structure.vala"
		_g_free0 (start_match_index);
#line 990 "document_structure.vala"
		_g_free0 (contents);
#line 990 "document_structure.vala"
		_g_free0 (low_level_type);
#line 990 "document_structure.vala"
		_g_free0 (line);
#line 990 "document_structure.vala"
		if (end_match_iter) {
#line 990 "document_structure.vala"
			*end_match_iter = _vala_end_match_iter;
#line 5369 "document_structure.c"
		}
#line 990 "document_structure.vala"
		return result;
#line 5373 "document_structure.c"
	}
#line 993 "document_structure.vala"
	result = FALSE;
#line 993 "document_structure.vala"
	_g_free0 (end_match_index);
#line 993 "document_structure.vala"
	_g_free0 (start_match_index);
#line 993 "document_structure.vala"
	_g_free0 (contents);
#line 993 "document_structure.vala"
	_g_free0 (low_level_type);
#line 993 "document_structure.vala"
	_g_free0 (line);
#line 993 "document_structure.vala"
	if (end_match_iter) {
#line 993 "document_structure.vala"
		*end_match_iter = _vala_end_match_iter;
#line 5391 "document_structure.c"
	}
#line 993 "document_structure.vala"
	return result;
#line 5395 "document_structure.c"
}

static gboolean
document_structure_same_items (DocumentStructure* self,
                               StructType item_type,
                               const gchar* item_contents,
                               StructType item_found_type,
                               const gchar* item_found_contents,
                               gboolean start)
{
	gboolean result = FALSE;
#line 999 "document_structure.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 999 "document_structure.vala"
	g_return_val_if_fail (item_contents != NULL, FALSE);
#line 999 "document_structure.vala"
	g_return_val_if_fail (item_found_contents != NULL, FALSE);
#line 1002 "document_structure.vala"
	if (structure_is_common_type (item_found_type)) {
#line 5415 "document_structure.c"
		gboolean same_type = FALSE;
		gboolean same_contents = FALSE;
		gboolean _tmp0_ = FALSE;
#line 1004 "document_structure.vala"
		same_type = item_type == item_found_type;
#line 1005 "document_structure.vala"
		same_contents = g_strcmp0 (item_contents, item_found_contents) == 0;
#line 1006 "document_structure.vala"
		if (same_type) {
#line 1006 "document_structure.vala"
			_tmp0_ = same_contents;
#line 5427 "document_structure.c"
		} else {
#line 1006 "document_structure.vala"
			_tmp0_ = FALSE;
#line 5431 "document_structure.c"
		}
#line 1006 "document_structure.vala"
		result = _tmp0_;
#line 1006 "document_structure.vala"
		return result;
#line 5437 "document_structure.c"
	}
#line 1009 "document_structure.vala"
	if (item_type == STRUCT_TYPE_FIGURE) {
#line 1011 "document_structure.vala"
		if (start) {
#line 1012 "document_structure.vala"
			result = item_found_type == STRUCT_TYPE_BEGIN_FIGURE;
#line 1012 "document_structure.vala"
			return result;
#line 5447 "document_structure.c"
		} else {
#line 1014 "document_structure.vala"
			result = item_found_type == STRUCT_TYPE_END_FIGURE;
#line 1014 "document_structure.vala"
			return result;
#line 5453 "document_structure.c"
		}
	}
#line 1017 "document_structure.vala"
	if (item_type == STRUCT_TYPE_TABLE) {
#line 1019 "document_structure.vala"
		if (start) {
#line 1020 "document_structure.vala"
			result = item_found_type == STRUCT_TYPE_BEGIN_TABLE;
#line 1020 "document_structure.vala"
			return result;
#line 5464 "document_structure.c"
		} else {
#line 1022 "document_structure.vala"
			result = item_found_type == STRUCT_TYPE_END_TABLE;
#line 1022 "document_structure.vala"
			return result;
#line 5470 "document_structure.c"
		}
	}
#line 1025 "document_structure.vala"
	result = FALSE;
#line 1025 "document_structure.vala"
	return result;
#line 5477 "document_structure.c"
}

static void
document_structure_get_end_document_iter (DocumentStructure* self,
                                          gboolean* end_of_file,
                                          GtkTextIter* result)
{
	gboolean _vala_end_of_file = FALSE;
	GtkTextMark* _tmp0_;
	GtkTextIter eof_iter = {0};
	Document* _tmp4_;
	GtkTextIter _tmp5_ = {0};
#line 1029 "document_structure.vala"
	g_return_if_fail (self != NULL);
#line 1031 "document_structure.vala"
	_tmp0_ = self->priv->_end_document_mark;
#line 1031 "document_structure.vala"
	if (_tmp0_ != NULL) {
#line 5496 "document_structure.c"
		GtkTextIter end_document_iter = {0};
		Document* _tmp1_;
		GtkTextMark* _tmp2_;
		GtkTextIter _tmp3_ = {0};
#line 1033 "document_structure.vala"
		_vala_end_of_file = FALSE;
#line 1035 "document_structure.vala"
		_tmp1_ = self->priv->_doc;
#line 1035 "document_structure.vala"
		_tmp2_ = self->priv->_end_document_mark;
#line 1035 "document_structure.vala"
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp1_, &_tmp3_, _tmp2_);
#line 1035 "document_structure.vala"
		end_document_iter = _tmp3_;
#line 1036 "document_structure.vala"
		*result = end_document_iter;
#line 1036 "document_structure.vala"
		if (end_of_file) {
#line 1036 "document_structure.vala"
			*end_of_file = _vala_end_of_file;
#line 5517 "document_structure.c"
		}
#line 1036 "document_structure.vala"
		return;
#line 5521 "document_structure.c"
	}
#line 1039 "document_structure.vala"
	_vala_end_of_file = TRUE;
#line 1041 "document_structure.vala"
	_tmp4_ = self->priv->_doc;
#line 1041 "document_structure.vala"
	gtk_text_buffer_get_end_iter ((GtkTextBuffer*) _tmp4_, &_tmp5_);
#line 1041 "document_structure.vala"
	eof_iter = _tmp5_;
#line 1042 "document_structure.vala"
	*result = eof_iter;
#line 1042 "document_structure.vala"
	if (end_of_file) {
#line 1042 "document_structure.vala"
		*end_of_file = _vala_end_of_file;
#line 5537 "document_structure.c"
	}
#line 1042 "document_structure.vala"
	return;
#line 5541 "document_structure.c"
}

static void
document_structure_backward_indentation (DocumentStructure* self,
                                         GtkTextIter* iter)
{
	gint line_num = 0;
	GtkTextIter begin_line_iter = {0};
	Document* _tmp0_;
	GtkTextIter _tmp1_ = {0};
	gchar* text_between = NULL;
	Document* _tmp2_;
	GtkTextIter _tmp3_;
	GtkTextIter _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
#line 1047 "document_structure.vala"
	g_return_if_fail (self != NULL);
#line 1047 "document_structure.vala"
	g_return_if_fail (iter != NULL);
#line 1049 "document_structure.vala"
	if (gtk_text_iter_starts_line (iter)) {
#line 1050 "document_structure.vala"
		return;
#line 5569 "document_structure.c"
	}
#line 1052 "document_structure.vala"
	line_num = gtk_text_iter_get_line (iter);
#line 1054 "document_structure.vala"
	_tmp0_ = self->priv->_doc;
#line 1054 "document_structure.vala"
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) _tmp0_, &_tmp1_, line_num);
#line 1054 "document_structure.vala"
	begin_line_iter = _tmp1_;
#line 1056 "document_structure.vala"
	_tmp2_ = self->priv->_doc;
#line 1056 "document_structure.vala"
	_tmp3_ = begin_line_iter;
#line 1056 "document_structure.vala"
	_tmp4_ = *iter;
#line 1056 "document_structure.vala"
	_tmp5_ = gtk_text_buffer_get_text ((GtkTextBuffer*) _tmp2_, &_tmp3_, &_tmp4_, FALSE);
#line 1056 "document_structure.vala"
	text_between = _tmp5_;
#line 1057 "document_structure.vala"
	_tmp6_ = text_between;
#line 1057 "document_structure.vala"
	_tmp7_ = string_strip (_tmp6_);
#line 1057 "document_structure.vala"
	_tmp8_ = _tmp7_;
#line 1057 "document_structure.vala"
	_tmp9_ = g_strcmp0 (_tmp8_, "") == 0;
#line 1057 "document_structure.vala"
	_g_free0 (_tmp8_);
#line 1057 "document_structure.vala"
	if (_tmp9_) {
#line 5601 "document_structure.c"
		GtkTextIter _tmp10_;
#line 1058 "document_structure.vala"
		_tmp10_ = begin_line_iter;
#line 1058 "document_structure.vala"
		*iter = _tmp10_;
#line 5607 "document_structure.c"
	}
#line 1047 "document_structure.vala"
	_g_free0 (text_between);
#line 5611 "document_structure.c"
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
#line 1232 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1233 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1233 "glib-2.0.vapi"
	result = _tmp0_;
#line 1233 "glib-2.0.vapi"
	return result;
#line 5628 "document_structure.c"
}

static gboolean
document_structure_shift_item (DocumentStructure* self,
                               GtkTreeIter* tree_iter,
                               gboolean shift_right,
                               gboolean* doc_modified)
{
	gboolean _vala_doc_modified = FALSE;
	StructType type = 0;
	GtkTextMark* mark = NULL;
	StructureModel* _tmp0_;
	GtkTreeIter _tmp1_;
	StructType _tmp2_ = 0;
	GtkTextMark* _tmp3_ = NULL;
	StructType _tmp6_;
	GtkTextIter text_iter = {0};
	Document* _tmp7_;
	GtkTextMark* _tmp8_;
	GtkTextIter _tmp9_ = {0};
	gchar* line = NULL;
	GtkTextIter _tmp10_;
	gchar* _tmp11_;
	gint backslash_index = 0;
	const gchar* _tmp12_;
	gint after_backslash_index = 0;
	gchar* markup_name = NULL;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	StructType* markup_type = NULL;
	const gchar* _tmp16_;
	StructType* _tmp17_;
	StructType* _tmp18_;
	StructType markup_type_hack = 0;
	StructType* _tmp19_;
	StructType _tmp20_;
	StructType _tmp21_;
	gboolean with_star = FALSE;
	const gchar* _tmp22_;
	StructType new_type = 0;
	gchar* new_markup_name = NULL;
	StructType _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	GtkTextIter begin_markup_name_iter = {0};
	GtkTextIter _tmp30_;
	GtkTextIter end_markup_name_iter = {0};
	GtkTextIter _tmp31_;
	const gchar* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	Document* _tmp35_;
	Document* _tmp36_;
	const gchar* _tmp37_;
	gint nb_children = 0;
	StructureModel* _tmp38_;
	GtkTreeIter _tmp39_;
	gboolean result = FALSE;
#line 1061 "document_structure.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1061 "document_structure.vala"
	g_return_val_if_fail (tree_iter != NULL, FALSE);
#line 1064 "document_structure.vala"
	_vala_doc_modified = FALSE;
#line 1069 "document_structure.vala"
	_tmp0_ = self->priv->_model;
#line 1069 "document_structure.vala"
	_tmp1_ = *tree_iter;
#line 1069 "document_structure.vala"
	gtk_tree_model_get ((GtkTreeModel*) _tmp0_, &_tmp1_, STRUCT_COLUMN_TYPE, &_tmp2_, STRUCT_COLUMN_START_MARK, &_tmp3_, -1);
#line 1069 "document_structure.vala"
	type = _tmp2_;
#line 1069 "document_structure.vala"
	_g_object_unref0 (mark);
#line 1069 "document_structure.vala"
	mark = _tmp3_;
#line 1073 "document_structure.vala"
	if (shift_right) {
#line 5708 "document_structure.c"
		StructType _tmp4_;
#line 1074 "document_structure.vala"
		_tmp4_ = type;
#line 1074 "document_structure.vala"
		g_return_val_if_fail (_tmp4_ != STRUCT_TYPE_SUBPARAGRAPH, FALSE);
#line 5714 "document_structure.c"
	} else {
		StructType _tmp5_;
#line 1076 "document_structure.vala"
		_tmp5_ = type;
#line 1076 "document_structure.vala"
		g_return_val_if_fail (_tmp5_ != STRUCT_TYPE_PART, FALSE);
#line 5721 "document_structure.c"
	}
#line 1078 "document_structure.vala"
	_tmp6_ = type;
#line 1078 "document_structure.vala"
	if (!structure_is_section (_tmp6_)) {
#line 1079 "document_structure.vala"
		result = TRUE;
#line 1079 "document_structure.vala"
		_g_object_unref0 (mark);
#line 1079 "document_structure.vala"
		if (doc_modified) {
#line 1079 "document_structure.vala"
			*doc_modified = _vala_doc_modified;
#line 5735 "document_structure.c"
		}
#line 1079 "document_structure.vala"
		return result;
#line 5739 "document_structure.c"
	}
#line 1083 "document_structure.vala"
	_tmp7_ = self->priv->_doc;
#line 1083 "document_structure.vala"
	_tmp8_ = mark;
#line 1083 "document_structure.vala"
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp7_, &_tmp9_, _tmp8_);
#line 1083 "document_structure.vala"
	text_iter = _tmp9_;
#line 1085 "document_structure.vala"
	_tmp10_ = text_iter;
#line 1085 "document_structure.vala"
	_tmp11_ = document_structure_get_line_contents_at_iter (self, &_tmp10_);
#line 1085 "document_structure.vala"
	line = _tmp11_;
#line 1087 "document_structure.vala"
	backslash_index = gtk_text_iter_get_line_index (&text_iter);
#line 1088 "document_structure.vala"
	_tmp12_ = line;
#line 1088 "document_structure.vala"
	if (string_get (_tmp12_, (glong) backslash_index) != '\\') {
#line 1089 "document_structure.vala"
		result = FALSE;
#line 1089 "document_structure.vala"
		_g_free0 (line);
#line 1089 "document_structure.vala"
		_g_object_unref0 (mark);
#line 1089 "document_structure.vala"
		if (doc_modified) {
#line 1089 "document_structure.vala"
			*doc_modified = _vala_doc_modified;
#line 5771 "document_structure.c"
		}
#line 1089 "document_structure.vala"
		return result;
#line 5775 "document_structure.c"
	}
#line 1091 "document_structure.vala"
	after_backslash_index = backslash_index + 1;
#line 1092 "document_structure.vala"
	_tmp13_ = line;
#line 1092 "document_structure.vala"
	_tmp14_ = document_structure_get_markup_name (self, _tmp13_, after_backslash_index, NULL);
#line 1092 "document_structure.vala"
	markup_name = _tmp14_;
#line 1093 "document_structure.vala"
	_tmp15_ = markup_name;
#line 1093 "document_structure.vala"
	if (_tmp15_ == NULL) {
#line 1094 "document_structure.vala"
		result = FALSE;
#line 1094 "document_structure.vala"
		_g_free0 (markup_name);
#line 1094 "document_structure.vala"
		_g_free0 (line);
#line 1094 "document_structure.vala"
		_g_object_unref0 (mark);
#line 1094 "document_structure.vala"
		if (doc_modified) {
#line 1094 "document_structure.vala"
			*doc_modified = _vala_doc_modified;
#line 5801 "document_structure.c"
		}
#line 1094 "document_structure.vala"
		return result;
#line 5805 "document_structure.c"
	}
#line 1096 "document_structure.vala"
	_tmp16_ = markup_name;
#line 1096 "document_structure.vala"
	_tmp17_ = document_structure_get_markup_type (self, _tmp16_);
#line 1096 "document_structure.vala"
	markup_type = _tmp17_;
#line 1097 "document_structure.vala"
	_tmp18_ = markup_type;
#line 1097 "document_structure.vala"
	if (_tmp18_ == NULL) {
#line 1098 "document_structure.vala"
		result = FALSE;
#line 1098 "document_structure.vala"
		_g_free0 (markup_type);
#line 1098 "document_structure.vala"
		_g_free0 (markup_name);
#line 1098 "document_structure.vala"
		_g_free0 (line);
#line 1098 "document_structure.vala"
		_g_object_unref0 (mark);
#line 1098 "document_structure.vala"
		if (doc_modified) {
#line 1098 "document_structure.vala"
			*doc_modified = _vala_doc_modified;
#line 5831 "document_structure.c"
		}
#line 1098 "document_structure.vala"
		return result;
#line 5835 "document_structure.c"
	}
#line 1102 "document_structure.vala"
	_tmp19_ = markup_type;
#line 1102 "document_structure.vala"
	markup_type_hack = *_tmp19_;
#line 1103 "document_structure.vala"
	_tmp20_ = type;
#line 1103 "document_structure.vala"
	_tmp21_ = markup_type_hack;
#line 1103 "document_structure.vala"
	if (((gint) _tmp20_) != ((gint) _tmp21_)) {
#line 1104 "document_structure.vala"
		result = FALSE;
#line 1104 "document_structure.vala"
		_g_free0 (markup_type);
#line 1104 "document_structure.vala"
		_g_free0 (markup_name);
#line 1104 "document_structure.vala"
		_g_free0 (line);
#line 1104 "document_structure.vala"
		_g_object_unref0 (mark);
#line 1104 "document_structure.vala"
		if (doc_modified) {
#line 1104 "document_structure.vala"
			*doc_modified = _vala_doc_modified;
#line 5861 "document_structure.c"
		}
#line 1104 "document_structure.vala"
		return result;
#line 5865 "document_structure.c"
	}
#line 1107 "document_structure.vala"
	_tmp22_ = markup_name;
#line 1107 "document_structure.vala"
	with_star = g_str_has_suffix (_tmp22_, "*");
#line 1110 "document_structure.vala"
	if (shift_right) {
#line 5873 "document_structure.c"
		StructType _tmp23_;
#line 1111 "document_structure.vala"
		_tmp23_ = type;
#line 1111 "document_structure.vala"
		new_type = _tmp23_ + 1;
#line 5879 "document_structure.c"
	} else {
		StructType _tmp24_;
#line 1113 "document_structure.vala"
		_tmp24_ = type;
#line 1113 "document_structure.vala"
		new_type = _tmp24_ - 1;
#line 5886 "document_structure.c"
	}
#line 1115 "document_structure.vala"
	_tmp25_ = new_type;
#line 1115 "document_structure.vala"
	_tmp26_ = document_structure_get_section_name_from_type (self, _tmp25_);
#line 1115 "document_structure.vala"
	new_markup_name = _tmp26_;
#line 1116 "document_structure.vala"
	_tmp27_ = new_markup_name;
#line 1116 "document_structure.vala"
	g_return_val_if_fail (_tmp27_ != NULL, FALSE);
#line 1118 "document_structure.vala"
	if (with_star) {
#line 5900 "document_structure.c"
		const gchar* _tmp28_;
		gchar* _tmp29_;
#line 1119 "document_structure.vala"
		_tmp28_ = new_markup_name;
#line 1119 "document_structure.vala"
		_tmp29_ = g_strconcat (_tmp28_, "*", NULL);
#line 1119 "document_structure.vala"
		_g_free0 (new_markup_name);
#line 1119 "document_structure.vala"
		new_markup_name = _tmp29_;
#line 5911 "document_structure.c"
	}
#line 1122 "document_structure.vala"
	_tmp30_ = text_iter;
#line 1122 "document_structure.vala"
	begin_markup_name_iter = _tmp30_;
#line 1123 "document_structure.vala"
	gtk_text_iter_set_line_index (&begin_markup_name_iter, after_backslash_index);
#line 1125 "document_structure.vala"
	_tmp31_ = text_iter;
#line 1125 "document_structure.vala"
	end_markup_name_iter = _tmp31_;
#line 1126 "document_structure.vala"
	_tmp32_ = markup_name;
#line 1126 "document_structure.vala"
	_tmp33_ = strlen (_tmp32_);
#line 1126 "document_structure.vala"
	_tmp34_ = _tmp33_;
#line 1126 "document_structure.vala"
	gtk_text_iter_set_line_index (&end_markup_name_iter, after_backslash_index + _tmp34_);
#line 1128 "document_structure.vala"
	_tmp35_ = self->priv->_doc;
#line 1128 "document_structure.vala"
	gtk_text_buffer_delete ((GtkTextBuffer*) _tmp35_, &begin_markup_name_iter, &end_markup_name_iter);
#line 1129 "document_structure.vala"
	_tmp36_ = self->priv->_doc;
#line 1129 "document_structure.vala"
	_tmp37_ = new_markup_name;
#line 1129 "document_structure.vala"
	document_insert (_tmp36_, &begin_markup_name_iter, _tmp37_, -1);
#line 1130 "document_structure.vala"
	_vala_doc_modified = TRUE;
#line 1133 "document_structure.vala"
	_tmp38_ = self->priv->_model;
#line 1133 "document_structure.vala"
	_tmp39_ = *tree_iter;
#line 1133 "document_structure.vala"
	nb_children = gtk_tree_model_iter_n_children ((GtkTreeModel*) _tmp38_, &_tmp39_);
#line 5949 "document_structure.c"
	{
		gint child_num = 0;
#line 1134 "document_structure.vala"
		child_num = 0;
#line 5954 "document_structure.c"
		{
			gboolean _tmp40_ = FALSE;
#line 1134 "document_structure.vala"
			_tmp40_ = TRUE;
#line 1134 "document_structure.vala"
			while (TRUE) {
#line 5961 "document_structure.c"
				GtkTreeIter child_iter = {0};
				gboolean child_iter_set = FALSE;
				StructureModel* _tmp42_;
				GtkTreeIter _tmp43_;
				GtkTreeIter _tmp44_ = {0};
				gboolean _tmp45_;
				GtkTreeIter _tmp46_;
#line 1134 "document_structure.vala"
				if (!_tmp40_) {
#line 5971 "document_structure.c"
					gint _tmp41_;
#line 1134 "document_structure.vala"
					_tmp41_ = child_num;
#line 1134 "document_structure.vala"
					child_num = _tmp41_ + 1;
#line 5977 "document_structure.c"
				}
#line 1134 "document_structure.vala"
				_tmp40_ = FALSE;
#line 1134 "document_structure.vala"
				if (!(child_num < nb_children)) {
#line 1134 "document_structure.vala"
					break;
#line 5985 "document_structure.c"
				}
#line 1137 "document_structure.vala"
				_tmp42_ = self->priv->_model;
#line 1137 "document_structure.vala"
				_tmp43_ = *tree_iter;
#line 1137 "document_structure.vala"
				_tmp45_ = gtk_tree_model_iter_nth_child ((GtkTreeModel*) _tmp42_, &_tmp44_, &_tmp43_, child_num);
#line 1137 "document_structure.vala"
				child_iter = _tmp44_;
#line 1137 "document_structure.vala"
				child_iter_set = _tmp45_;
#line 1139 "document_structure.vala"
				g_return_val_if_fail (child_iter_set, FALSE);
#line 1141 "document_structure.vala"
				_tmp46_ = child_iter;
#line 1141 "document_structure.vala"
				if (!document_structure_shift_item (self, &_tmp46_, shift_right, NULL)) {
#line 1142 "document_structure.vala"
					result = FALSE;
#line 1142 "document_structure.vala"
					_g_free0 (new_markup_name);
#line 1142 "document_structure.vala"
					_g_free0 (markup_type);
#line 1142 "document_structure.vala"
					_g_free0 (markup_name);
#line 1142 "document_structure.vala"
					_g_free0 (line);
#line 1142 "document_structure.vala"
					_g_object_unref0 (mark);
#line 1142 "document_structure.vala"
					if (doc_modified) {
#line 1142 "document_structure.vala"
						*doc_modified = _vala_doc_modified;
#line 6019 "document_structure.c"
					}
#line 1142 "document_structure.vala"
					return result;
#line 6023 "document_structure.c"
				}
			}
		}
	}
#line 1145 "document_structure.vala"
	result = TRUE;
#line 1145 "document_structure.vala"
	_g_free0 (new_markup_name);
#line 1145 "document_structure.vala"
	_g_free0 (markup_type);
#line 1145 "document_structure.vala"
	_g_free0 (markup_name);
#line 1145 "document_structure.vala"
	_g_free0 (line);
#line 1145 "document_structure.vala"
	_g_object_unref0 (mark);
#line 1145 "document_structure.vala"
	if (doc_modified) {
#line 1145 "document_structure.vala"
		*doc_modified = _vala_doc_modified;
#line 6044 "document_structure.c"
	}
#line 1145 "document_structure.vala"
	return result;
#line 6048 "document_structure.c"
}

static gchar*
document_structure_get_section_name_from_type (DocumentStructure* self,
                                               StructType type)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* result = NULL;
#line 1148 "document_structure.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 1150 "document_structure.vala"
	_tmp0_ = document_structure__section_names;
#line 1150 "document_structure.vala"
	_tmp0__length1 = document_structure__section_names_length1;
#line 1150 "document_structure.vala"
	if (_tmp0_ == NULL) {
#line 6070 "document_structure.c"
		gchar** _tmp1_;
		gchar** _tmp2_;
		gint _tmp2__length1;
		gchar* _tmp3_;
		gchar** _tmp4_;
		gint _tmp4__length1;
		gchar* _tmp5_;
		gchar** _tmp6_;
		gint _tmp6__length1;
		gchar* _tmp7_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		gchar* _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		gchar* _tmp11_;
		gchar** _tmp12_;
		gint _tmp12__length1;
		gchar* _tmp13_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		gchar* _tmp15_;
#line 1152 "document_structure.vala"
		_tmp1_ = g_new0 (gchar*, 7 + 1);
#line 1152 "document_structure.vala"
		document_structure__section_names = (_vala_array_free (document_structure__section_names, document_structure__section_names_length1, (GDestroyNotify) g_free), NULL);
#line 1152 "document_structure.vala"
		document_structure__section_names = _tmp1_;
#line 1152 "document_structure.vala"
		document_structure__section_names_length1 = 7;
#line 1152 "document_structure.vala"
		_document_structure__section_names_size_ = document_structure__section_names_length1;
#line 1153 "document_structure.vala"
		_tmp2_ = document_structure__section_names;
#line 1153 "document_structure.vala"
		_tmp2__length1 = document_structure__section_names_length1;
#line 1153 "document_structure.vala"
		_tmp3_ = g_strdup ("part");
#line 1153 "document_structure.vala"
		_g_free0 (_tmp2_[STRUCT_TYPE_PART]);
#line 1153 "document_structure.vala"
		_tmp2_[STRUCT_TYPE_PART] = _tmp3_;
#line 1154 "document_structure.vala"
		_tmp4_ = document_structure__section_names;
#line 1154 "document_structure.vala"
		_tmp4__length1 = document_structure__section_names_length1;
#line 1154 "document_structure.vala"
		_tmp5_ = g_strdup ("chapter");
#line 1154 "document_structure.vala"
		_g_free0 (_tmp4_[STRUCT_TYPE_CHAPTER]);
#line 1154 "document_structure.vala"
		_tmp4_[STRUCT_TYPE_CHAPTER] = _tmp5_;
#line 1155 "document_structure.vala"
		_tmp6_ = document_structure__section_names;
#line 1155 "document_structure.vala"
		_tmp6__length1 = document_structure__section_names_length1;
#line 1155 "document_structure.vala"
		_tmp7_ = g_strdup ("section");
#line 1155 "document_structure.vala"
		_g_free0 (_tmp6_[STRUCT_TYPE_SECTION]);
#line 1155 "document_structure.vala"
		_tmp6_[STRUCT_TYPE_SECTION] = _tmp7_;
#line 1156 "document_structure.vala"
		_tmp8_ = document_structure__section_names;
#line 1156 "document_structure.vala"
		_tmp8__length1 = document_structure__section_names_length1;
#line 1156 "document_structure.vala"
		_tmp9_ = g_strdup ("subsection");
#line 1156 "document_structure.vala"
		_g_free0 (_tmp8_[STRUCT_TYPE_SUBSECTION]);
#line 1156 "document_structure.vala"
		_tmp8_[STRUCT_TYPE_SUBSECTION] = _tmp9_;
#line 1157 "document_structure.vala"
		_tmp10_ = document_structure__section_names;
#line 1157 "document_structure.vala"
		_tmp10__length1 = document_structure__section_names_length1;
#line 1157 "document_structure.vala"
		_tmp11_ = g_strdup ("subsubsection");
#line 1157 "document_structure.vala"
		_g_free0 (_tmp10_[STRUCT_TYPE_SUBSUBSECTION]);
#line 1157 "document_structure.vala"
		_tmp10_[STRUCT_TYPE_SUBSUBSECTION] = _tmp11_;
#line 1158 "document_structure.vala"
		_tmp12_ = document_structure__section_names;
#line 1158 "document_structure.vala"
		_tmp12__length1 = document_structure__section_names_length1;
#line 1158 "document_structure.vala"
		_tmp13_ = g_strdup ("paragraph");
#line 1158 "document_structure.vala"
		_g_free0 (_tmp12_[STRUCT_TYPE_PARAGRAPH]);
#line 1158 "document_structure.vala"
		_tmp12_[STRUCT_TYPE_PARAGRAPH] = _tmp13_;
#line 1159 "document_structure.vala"
		_tmp14_ = document_structure__section_names;
#line 1159 "document_structure.vala"
		_tmp14__length1 = document_structure__section_names_length1;
#line 1159 "document_structure.vala"
		_tmp15_ = g_strdup ("subparagraph");
#line 1159 "document_structure.vala"
		_g_free0 (_tmp14_[STRUCT_TYPE_SUBPARAGRAPH]);
#line 1159 "document_structure.vala"
		_tmp14_[STRUCT_TYPE_SUBPARAGRAPH] = _tmp15_;
#line 6173 "document_structure.c"
	}
#line 1162 "document_structure.vala"
	g_return_val_if_fail (structure_is_section (type), NULL);
#line 1164 "document_structure.vala"
	_tmp16_ = document_structure__section_names;
#line 1164 "document_structure.vala"
	_tmp16__length1 = document_structure__section_names_length1;
#line 1164 "document_structure.vala"
	_tmp17_ = _tmp16_[type];
#line 1164 "document_structure.vala"
	_tmp18_ = g_strdup (_tmp17_);
#line 1164 "document_structure.vala"
	result = _tmp18_;
#line 1164 "document_structure.vala"
	return result;
#line 6189 "document_structure.c"
}

gboolean
document_structure_get_parsing_done (DocumentStructure* self)
{
	gboolean result;
#line 64 "document_structure.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 64 "document_structure.vala"
	result = self->priv->_parsing_done;
#line 64 "document_structure.vala"
	return result;
#line 6202 "document_structure.c"
}

static void
document_structure_set_parsing_done (DocumentStructure* self,
                                     gboolean value)
{
#line 64 "document_structure.vala"
	g_return_if_fail (self != NULL);
#line 64 "document_structure.vala"
	if (document_structure_get_parsing_done (self) != value) {
#line 64 "document_structure.vala"
		self->priv->_parsing_done = value;
#line 64 "document_structure.vala"
		g_object_notify_by_pspec ((GObject *) self, document_structure_properties[DOCUMENT_STRUCTURE_PARSING_DONE_PROPERTY]);
#line 6217 "document_structure.c"
	}
}

static GtkTreePath*
_vala_GtkTreePath_copy (GtkTreePath* self)
{
#line 29 "document_structure.vala"
	return g_boxed_copy (gtk_tree_path_get_type (), self);
#line 6226 "document_structure.c"
}

static gpointer
__vala_GtkTreePath_copy0 (gpointer self)
{
#line 29 "document_structure.vala"
	return self ? _vala_GtkTreePath_copy (self) : NULL;
#line 6234 "document_structure.c"
}

static void
document_structure_env_data_copy (const DocumentStructureEnvData* self,
                                  DocumentStructureEnvData* dest)
{
	GtkTreePath* _tmp0_;
	GtkTreePath* _tmp1_;
	StructType _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
#line 29 "document_structure.vala"
	_tmp0_ = (*self).path;
#line 29 "document_structure.vala"
	_tmp1_ = __vala_GtkTreePath_copy0 (_tmp0_);
#line 29 "document_structure.vala"
	__vala_GtkTreePath_free0 ((*dest).path);
#line 29 "document_structure.vala"
	(*dest).path = _tmp1_;
#line 29 "document_structure.vala"
	_tmp2_ = (*self).type;
#line 29 "document_structure.vala"
	(*dest).type = _tmp2_;
#line 29 "document_structure.vala"
	_tmp3_ = (*self).first_caption;
#line 29 "document_structure.vala"
	_tmp4_ = g_strdup (_tmp3_);
#line 29 "document_structure.vala"
	_g_free0 ((*dest).first_caption);
#line 29 "document_structure.vala"
	(*dest).first_caption = _tmp4_;
#line 6266 "document_structure.c"
}

static void
document_structure_env_data_destroy (DocumentStructureEnvData* self)
{
#line 31 "document_structure.vala"
	__vala_GtkTreePath_free0 ((*self).path);
#line 33 "document_structure.vala"
	_g_free0 ((*self).first_caption);
#line 6276 "document_structure.c"
}

static DocumentStructureEnvData*
document_structure_env_data_dup (const DocumentStructureEnvData* self)
{
	DocumentStructureEnvData* dup;
#line 29 "document_structure.vala"
	dup = g_new0 (DocumentStructureEnvData, 1);
#line 29 "document_structure.vala"
	document_structure_env_data_copy (self, dup);
#line 29 "document_structure.vala"
	return dup;
#line 6289 "document_structure.c"
}

static void
document_structure_env_data_free (DocumentStructureEnvData* self)
{
#line 29 "document_structure.vala"
	document_structure_env_data_destroy (self);
#line 29 "document_structure.vala"
	g_free (self);
#line 6299 "document_structure.c"
}

static GType
document_structure_env_data_get_type_once (void)
{
	GType document_structure_env_data_type_id;
	document_structure_env_data_type_id = g_boxed_type_register_static ("DocumentStructureEnvData", (GBoxedCopyFunc) document_structure_env_data_dup, (GBoxedFreeFunc) document_structure_env_data_free);
	return document_structure_env_data_type_id;
}

static GType
document_structure_env_data_get_type (void)
{
	static volatile gsize document_structure_env_data_type_id__volatile = 0;
	if (g_once_init_enter (&document_structure_env_data_type_id__volatile)) {
		GType document_structure_env_data_type_id;
		document_structure_env_data_type_id = document_structure_env_data_get_type_once ();
		g_once_init_leave (&document_structure_env_data_type_id__volatile, document_structure_env_data_type_id);
	}
	return document_structure_env_data_type_id__volatile;
}

static void
document_structure_class_init (DocumentStructureClass * klass,
                               gpointer klass_data)
{
#line 26 "document_structure.vala"
	document_structure_parent_class = g_type_class_peek_parent (klass);
#line 26 "document_structure.vala"
	g_type_class_adjust_private_offset (klass, &DocumentStructure_private_offset);
#line 26 "document_structure.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_document_structure_get_property;
#line 26 "document_structure.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_document_structure_set_property;
#line 26 "document_structure.vala"
	G_OBJECT_CLASS (klass)->finalize = document_structure_finalize;
#line 26 "document_structure.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_STRUCTURE_PARSING_DONE_PROPERTY, document_structure_properties[DOCUMENT_STRUCTURE_PARSING_DONE_PROPERTY] = g_param_spec_boolean ("parsing-done", "parsing-done", "parsing-done", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
#line 6338 "document_structure.c"
}

static void
document_structure_instance_init (DocumentStructure * self,
                                  gpointer klass)
{
#line 26 "document_structure.vala"
	self->priv = document_structure_get_instance_private (self);
#line 36 "document_structure.vala"
	self->priv->_doc = NULL;
#line 37 "document_structure.vala"
	self->priv->_nb_marks = 0;
#line 39 "document_structure.vala"
	self->priv->_end_document_mark = NULL;
#line 41 "document_structure.vala"
	self->priv->_model = NULL;
#line 47 "document_structure.vala"
	self->priv->_in_verbatim_env = FALSE;
#line 49 "document_structure.vala"
	self->priv->_last_env_data = NULL;
#line 56 "document_structure.vala"
	self->priv->_start_parsing_line = 0;
#line 58 "document_structure.vala"
	self->priv->_timer = NULL;
#line 62 "document_structure.vala"
	self->priv->_idle_id = (guint) 0;
#line 64 "document_structure.vala"
	self->priv->_parsing_done = FALSE;
#line 6367 "document_structure.c"
}

static void
document_structure_finalize (GObject * obj)
{
	DocumentStructure * self;
#line 26 "document_structure.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DOCUMENT_STRUCTURE, DocumentStructure);
#line 94 "document_structure.vala"
	if (self->priv->_idle_id != ((guint) 0)) {
#line 96 "document_structure.vala"
		g_source_remove (self->priv->_idle_id);
#line 97 "document_structure.vala"
		self->priv->_idle_id = (guint) 0;
#line 6382 "document_structure.c"
	}
#line 39 "document_structure.vala"
	_g_object_unref0 (self->priv->_end_document_mark);
#line 41 "document_structure.vala"
	_g_object_unref0 (self->priv->_model);
#line 49 "document_structure.vala"
	_document_structure_env_data_free0 (self->priv->_last_env_data);
#line 58 "document_structure.vala"
	_g_timer_destroy0 (self->priv->_timer);
#line 26 "document_structure.vala"
	G_OBJECT_CLASS (document_structure_parent_class)->finalize (obj);
#line 6394 "document_structure.c"
}

static GType
document_structure_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DocumentStructureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_structure_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DocumentStructure), 0, (GInstanceInitFunc) document_structure_instance_init, NULL };
	GType document_structure_type_id;
	document_structure_type_id = g_type_register_static (G_TYPE_OBJECT, "DocumentStructure", &g_define_type_info, 0);
	DocumentStructure_private_offset = g_type_add_instance_private (document_structure_type_id, sizeof (DocumentStructurePrivate));
	return document_structure_type_id;
}

GType
document_structure_get_type (void)
{
	static volatile gsize document_structure_type_id__volatile = 0;
	if (g_once_init_enter (&document_structure_type_id__volatile)) {
		GType document_structure_type_id;
		document_structure_type_id = document_structure_get_type_once ();
		g_once_init_leave (&document_structure_type_id__volatile, document_structure_type_id);
	}
	return document_structure_type_id__volatile;
}

static void
_vala_document_structure_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	DocumentStructure * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT_STRUCTURE, DocumentStructure);
#line 26 "document_structure.vala"
	switch (property_id) {
#line 26 "document_structure.vala"
		case DOCUMENT_STRUCTURE_PARSING_DONE_PROPERTY:
#line 26 "document_structure.vala"
		g_value_set_boolean (value, document_structure_get_parsing_done (self));
#line 26 "document_structure.vala"
		break;
#line 6435 "document_structure.c"
		default:
#line 26 "document_structure.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 26 "document_structure.vala"
		break;
#line 6441 "document_structure.c"
	}
}

static void
_vala_document_structure_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	DocumentStructure * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT_STRUCTURE, DocumentStructure);
#line 26 "document_structure.vala"
	switch (property_id) {
#line 26 "document_structure.vala"
		case DOCUMENT_STRUCTURE_PARSING_DONE_PROPERTY:
#line 26 "document_structure.vala"
		document_structure_set_parsing_done (self, g_value_get_boolean (value));
#line 26 "document_structure.vala"
		break;
#line 6461 "document_structure.c"
		default:
#line 26 "document_structure.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 26 "document_structure.vala"
		break;
#line 6467 "document_structure.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
#line 27 "build_tools_preferences.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 6478 "document_structure.c"
		gint i;
#line 27 "build_tools_preferences.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 27 "build_tools_preferences.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 27 "build_tools_preferences.vala"
				destroy_func (((gpointer*) array)[i]);
#line 6486 "document_structure.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
#line 27 "build_tools_preferences.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 27 "build_tools_preferences.vala"
	g_free (array);
#line 6501 "document_structure.c"
}

