/* document.c generated by valac 0.48.9, the Vala compiler
 * generated from document.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2020 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <tepl/tepl.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gtksourceview/gtksource.h>
#include <gtk/gtk.h>
#include <latexila.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <glib/gstdio.h>

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_DOCUMENT_STRUCTURE (document_structure_get_type ())
#define DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructure))
#define DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))
#define IS_DOCUMENT_STRUCTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_STRUCTURE))
#define IS_DOCUMENT_STRUCTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_STRUCTURE))
#define DOCUMENT_STRUCTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_STRUCTURE, DocumentStructureClass))

typedef struct _DocumentStructure DocumentStructure;
typedef struct _DocumentStructureClass DocumentStructureClass;
enum  {
	DOCUMENT_0_PROPERTY,
	DOCUMENT_LOCATION_PROPERTY,
	DOCUMENT_READONLY_PROPERTY,
	DOCUMENT_PROJECT_ID_PROPERTY,
	DOCUMENT_NUM_PROPERTIES
};
static GParamSpec* document_properties[DOCUMENT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block15Data Block15Data;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block16Data Block16Data;

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))
typedef struct _Block17Data Block17Data;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

struct _Document {
	TeplBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
};

struct _DocumentClass {
	TeplBufferClass parent_class;
};

struct _DocumentPrivate {
	GFile* _location;
	gboolean _readonly;
	gint _project_id;
	gboolean backup_made;
	gchar* _etag;
	gchar* encoding;
	gboolean new_file;
	DocumentStructure* _structure;
};

struct _Block15Data {
	int _ref_count_;
	Document* self;
	GtkSourceCompletion* completion;
};

struct _Block16Data {
	int _ref_count_;
	Document* self;
	TeplInfoBar* infobar;
};

struct _Project {
	GFile* directory;
	GFile* main_file;
};

struct _Block17Data {
	int _ref_count_;
	Document* self;
	TeplInfoBar* infobar;
};

static gint Document_private_offset;
static gpointer document_parent_class = NULL;

GType document_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
GType document_tab_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
GType document_structure_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentStructure, g_object_unref)
Document* document_new (void);
Document* document_construct (GType object_type);
static void __lambda43_ (Document* self);
static void document_update_syntax_highlighting (Document* self);
static void document_update_project_id (Document* self);
static void ___lambda43__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void __lambda44_ (Document* self);
static void ___lambda44__gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                           gpointer self);
static void __lambda45_ (Document* self);
static void ___lambda45__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
void document_insert (Document* self,
                      GtkTextIter* iter,
                      const gchar* text,
                      gint len);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
GType document_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentView, g_object_unref)
DocumentView* document_tab_get_document_view (DocumentTab* self);
static gboolean __lambda38_ (Block15Data* _data15_);
static gboolean ___lambda38__gsource_func (gpointer self);
void document_load (Document* self,
                    GFile* location);
void document_set_location (Document* self,
                            GFile* value);
void document_set_contents (Document* self,
                            const gchar* contents);
static gchar* document_to_utf8 (Document* self,
                         const gchar* text,
                         GError** error);
void document_save (Document* self,
                    gboolean check_file_changed_on_disk,
                    gboolean force);
GFile* document_get_location (Document* self);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static void ____lambda16_ (Block16Data* _data16_,
                    gint response_id);
static void _____lambda16__gtk_info_bar_response (GtkInfoBar* _sender,
                                           gint response_id,
                                           gpointer self);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self,
                   Project* dest);
void project_destroy (Project* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
void value_set_projects (GValue* value,
                         gpointer v_object);
void value_take_projects (GValue* value,
                          gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Projects, projects_unref)
Projects* projects_get_default (void);
GeeIterator* projects_iterator (Projects* self);
void document_set_project_id (Document* self,
                              gint value);
gchar* document_get_uri_for_display (Document* self);
gchar* document_get_short_name_for_display (Document* self);
gboolean document_is_externally_modified (Document* self);
void document_comment_selected_lines (Document* self);
void document_comment_between (Document* self,
                               GtkTextIter* start_iter,
                               GtkTextIter* end_iter,
                               gboolean end_iter_set);
void document_uncomment_selected_lines (Document* self);
Project* document_get_project (Document* self);
gint document_get_project_id (Document* self);
Project* projects_get (Projects* self,
                       gint id);
GFile* document_get_main_file (Document* self);
gboolean document_is_main_file_a_tex_file (Document* self);
DocumentStructure* document_get_structure (Document* self);
DocumentStructure* document_structure_new (Document* doc);
DocumentStructure* document_structure_construct (GType object_type,
                                                 Document* doc);
void document_structure_parse (DocumentStructure* self);
gboolean document_set_tmp_location (Document* self);
static Block17Data* block17_data_ref (Block17Data* _data17_);
static void block17_data_unref (void * _userdata_);
static void __lambda27_ (Block17Data* _data17_,
                  gint response_id);
GType main_window_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
GtkWindow* utils_get_toplevel_window (GtkWidget* widget);
gboolean main_window_save_document (MainWindow* self,
                                    Document* doc,
                                    gboolean force_save_as);
static void ___lambda27__gtk_info_bar_response (GtkInfoBar* _sender,
                                         gint response_id,
                                         gpointer self);
void document_set_metadata (Document* self,
                            const gchar* key,
                            const gchar* val);
gboolean document_get_readonly (Document* self);
void document_set_readonly (Document* self,
                            gboolean value);
static void document_finalize (GObject * obj);
static GType document_get_type_once (void);
static void _vala_document_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec);
static void _vala_document_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec);

extern const gchar* ENCODINGS_CHARSETS[60];

static inline gpointer
document_get_instance_private (Document* self)
{
	return G_STRUCT_MEMBER_P (self, Document_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 37 "document.vala"
	return self ? g_object_ref (self) : NULL;
#line 304 "document.c"
}

static void
__lambda43_ (Document* self)
{
#line 42 "document.vala"
	document_update_syntax_highlighting (self);
#line 43 "document.vala"
	document_update_project_id (self);
#line 314 "document.c"
}

static void
___lambda43__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 40 "document.vala"
	__lambda43_ ((Document*) self);
#line 324 "document.c"
}

static void
__lambda44_ (Document* self)
{
#line 48 "document.vala"
	self->priv->new_file = FALSE;
#line 332 "document.c"
}

static void
___lambda44__gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                      gpointer self)
{
#line 46 "document.vala"
	__lambda44_ ((Document*) self);
#line 341 "document.c"
}

static void
__lambda45_ (Document* self)
{
#line 60 "document.vala"
	tepl_buffer_load_metadata_from_metadata_manager ((TeplBuffer*) self);
#line 349 "document.c"
}

static void
___lambda45__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
#line 58 "document.vala"
	__lambda45_ ((Document*) self);
#line 359 "document.c"
}

Document*
document_construct (GType object_type)
{
	Document * self = NULL;
	GtkSourceLanguageManager* lm = NULL;
	GtkSourceLanguageManager* _tmp0_;
	GtkSourceLanguageManager* _tmp1_;
	GtkSourceLanguage* _tmp2_;
	TeplFile* _tmp3_;
	TeplFile* _tmp4_;
#line 34 "document.vala"
	self = (Document*) g_object_new (object_type, NULL);
#line 37 "document.vala"
	_tmp0_ = gtk_source_language_manager_get_default ();
#line 37 "document.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 37 "document.vala"
	lm = _tmp1_;
#line 38 "document.vala"
	_tmp2_ = gtk_source_language_manager_get_language (lm, "latex");
#line 38 "document.vala"
	gtk_source_buffer_set_language ((GtkSourceBuffer*) self, _tmp2_);
#line 40 "document.vala"
	g_signal_connect_object ((GObject*) self, "notify::location", (GCallback) ___lambda43__g_object_notify, self, 0);
#line 46 "document.vala"
	g_signal_connect_object ((GtkTextBuffer*) self, "changed", (GCallback) ___lambda44__gtk_text_buffer_changed, self, 0);
#line 51 "document.vala"
	latexila_buffer_setup ((TeplBuffer*) self);
#line 55 "document.vala"
	_tmp3_ = tepl_buffer_get_file ((TeplBuffer*) self);
#line 55 "document.vala"
	g_object_bind_property_with_closures ((GObject*) self, "location", (GObject*) _tmp3_, "location", G_BINDING_DEFAULT | G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 58 "document.vala"
	_tmp4_ = tepl_buffer_get_file ((TeplBuffer*) self);
#line 58 "document.vala"
	g_signal_connect_object ((GObject*) _tmp4_, "notify::location", (GCallback) ___lambda45__g_object_notify, self, 0);
#line 34 "document.vala"
	_g_object_unref0 (lm);
#line 34 "document.vala"
	return self;
#line 402 "document.c"
}

Document*
document_new (void)
{
#line 34 "document.vala"
	return document_construct (TYPE_DOCUMENT);
#line 410 "document.c"
}

static Block15Data*
block15_data_ref (Block15Data* _data15_)
{
#line 64 "document.vala"
	g_atomic_int_inc (&_data15_->_ref_count_);
#line 64 "document.vala"
	return _data15_;
#line 420 "document.c"
}

static void
block15_data_unref (void * _userdata_)
{
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
#line 64 "document.vala"
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
#line 430 "document.c"
		Document* self;
#line 64 "document.vala"
		self = _data15_->self;
#line 64 "document.vala"
		_g_object_unref0 (_data15_->completion);
#line 64 "document.vala"
		_g_object_unref0 (self);
#line 64 "document.vala"
		g_slice_free (Block15Data, _data15_);
#line 440 "document.c"
	}
}

static gboolean
__lambda38_ (Block15Data* _data15_)
{
	Document* self;
	GtkSourceCompletion* _tmp0_;
	gboolean result = FALSE;
#line 78 "document.vala"
	self = _data15_->self;
#line 80 "document.vala"
	_tmp0_ = _data15_->completion;
#line 80 "document.vala"
	if (_tmp0_ != NULL) {
#line 456 "document.c"
		GtkSourceCompletion* _tmp1_;
#line 81 "document.vala"
		_tmp1_ = _data15_->completion;
#line 81 "document.vala"
		gtk_source_completion_unblock_interactive (_tmp1_);
#line 462 "document.c"
	}
#line 83 "document.vala"
	result = FALSE;
#line 83 "document.vala"
	return result;
#line 468 "document.c"
}

static gboolean
___lambda38__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda38_ (self);
#line 78 "document.vala"
	return result;
#line 478 "document.c"
}

void
document_insert (Document* self,
                 GtkTextIter* iter,
                 const gchar* text,
                 gint len)
{
	Block15Data* _data15_;
	DocumentTab* _tmp0_;
#line 64 "document.vala"
	g_return_if_fail (self != NULL);
#line 64 "document.vala"
	g_return_if_fail (iter != NULL);
#line 64 "document.vala"
	g_return_if_fail (text != NULL);
#line 64 "document.vala"
	_data15_ = g_slice_new0 (Block15Data);
#line 64 "document.vala"
	_data15_->_ref_count_ = 1;
#line 64 "document.vala"
	_data15_->self = g_object_ref (self);
#line 66 "document.vala"
	_data15_->completion = NULL;
#line 68 "document.vala"
	_tmp0_ = self->tab;
#line 68 "document.vala"
	if (_tmp0_ != NULL) {
#line 507 "document.c"
		DocumentTab* _tmp1_;
		DocumentView* _tmp2_;
		DocumentView* _tmp3_;
		GtkSourceCompletion* _tmp4_;
		GtkSourceCompletion* _tmp5_;
		GtkSourceCompletion* _tmp6_;
		GtkSourceCompletion* _tmp7_;
#line 70 "document.vala"
		_tmp1_ = self->tab;
#line 70 "document.vala"
		_tmp2_ = document_tab_get_document_view (_tmp1_);
#line 70 "document.vala"
		_tmp3_ = _tmp2_;
#line 70 "document.vala"
		_tmp4_ = gtk_source_view_get_completion ((GtkSourceView*) _tmp3_);
#line 70 "document.vala"
		_tmp5_ = _tmp4_;
#line 70 "document.vala"
		_tmp6_ = _g_object_ref0 (_tmp5_);
#line 70 "document.vala"
		_g_object_unref0 (_data15_->completion);
#line 70 "document.vala"
		_data15_->completion = _tmp6_;
#line 71 "document.vala"
		_tmp7_ = _data15_->completion;
#line 71 "document.vala"
		gtk_source_completion_block_interactive (_tmp7_);
#line 535 "document.c"
	}
#line 74 "document.vala"
	gtk_text_buffer_insert ((GtkTextBuffer*) G_TYPE_CHECK_INSTANCE_CAST (self, tepl_buffer_get_type (), TeplBuffer), iter, text, len);
#line 78 "document.vala"
	g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ___lambda38__gsource_func, block15_data_ref (_data15_), block15_data_unref);
#line 64 "document.vala"
	block15_data_unref (_data15_);
#line 64 "document.vala"
	_data15_ = NULL;
#line 545 "document.c"
}

void
document_load (Document* self,
               GFile* location)
{
	GError* _inner_error0_ = NULL;
#line 87 "document.vala"
	g_return_if_fail (self != NULL);
#line 87 "document.vala"
	g_return_if_fail (location != NULL);
#line 89 "document.vala"
	document_set_location (self, location);
#line 559 "document.c"
	{
		guint8* chars = NULL;
		gint chars_length1 = 0;
		gint _chars_size_ = 0;
		guint8* _tmp0_ = NULL;
		gsize _tmp1_ = 0;
		gchar* _tmp2_ = NULL;
		gchar* text = NULL;
		guint8* _tmp3_;
		gint _tmp3__length1;
		const gchar* _tmp4_;
		GtkRecentManager* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
#line 94 "document.vala"
		g_file_load_contents (location, NULL, &_tmp0_, &_tmp1_, &_tmp2_, &_inner_error0_);
#line 94 "document.vala"
		chars = (g_free (chars), NULL);
#line 94 "document.vala"
		chars = _tmp0_;
#line 94 "document.vala"
		chars_length1 = _tmp1_;
#line 94 "document.vala"
		_chars_size_ = chars_length1;
#line 94 "document.vala"
		_g_free0 (self->priv->_etag);
#line 94 "document.vala"
		self->priv->_etag = _tmp2_;
#line 94 "document.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 94 "document.vala"
			chars = (g_free (chars), NULL);
#line 592 "document.c"
			goto __catch0_g_error;
		}
#line 95 "document.vala"
		_tmp3_ = chars;
#line 95 "document.vala"
		_tmp3__length1 = chars_length1;
#line 95 "document.vala"
		chars = NULL;
#line 95 "document.vala"
		chars_length1 = 0;
#line 95 "document.vala"
		text = (gchar*) _tmp3_;
#line 97 "document.vala"
		_tmp4_ = text;
#line 97 "document.vala"
		if (g_utf8_validate (_tmp4_, (gssize) -1, NULL)) {
#line 609 "document.c"
			const gchar* _tmp5_;
#line 98 "document.vala"
			_tmp5_ = text;
#line 98 "document.vala"
			document_set_contents (self, _tmp5_);
#line 615 "document.c"
		} else {
			gchar* utf8_text = NULL;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			const gchar* _tmp8_;
#line 103 "document.vala"
			_tmp6_ = text;
#line 103 "document.vala"
			_tmp7_ = document_to_utf8 (self, _tmp6_, &_inner_error0_);
#line 103 "document.vala"
			utf8_text = _tmp7_;
#line 103 "document.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 103 "document.vala"
				_g_free0 (text);
#line 103 "document.vala"
				chars = (g_free (chars), NULL);
#line 633 "document.c"
				goto __catch0_g_error;
			}
#line 104 "document.vala"
			_tmp8_ = utf8_text;
#line 104 "document.vala"
			document_set_contents (self, _tmp8_);
#line 97 "document.vala"
			_g_free0 (utf8_text);
#line 642 "document.c"
		}
#line 107 "document.vala"
		document_update_syntax_highlighting (self);
#line 109 "document.vala"
		_tmp9_ = gtk_recent_manager_get_default ();
#line 109 "document.vala"
		_tmp10_ = g_file_get_uri (location);
#line 109 "document.vala"
		_tmp11_ = _tmp10_;
#line 109 "document.vala"
		gtk_recent_manager_add_item (_tmp9_, _tmp11_);
#line 109 "document.vala"
		_g_free0 (_tmp11_);
#line 91 "document.vala"
		_g_free0 (text);
#line 91 "document.vala"
		chars = (g_free (chars), NULL);
#line 660 "document.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		DocumentTab* _tmp14_;
#line 91 "document.vala"
		e = _inner_error0_;
#line 91 "document.vala"
		_inner_error0_ = NULL;
#line 113 "document.vala"
		_tmp12_ = e;
#line 113 "document.vala"
		_tmp13_ = _tmp12_->message;
#line 113 "document.vala"
		g_warning ("document.vala:113: %s", _tmp13_);
#line 115 "document.vala"
		_tmp14_ = self->tab;
#line 115 "document.vala"
		if (_tmp14_ != NULL) {
#line 683 "document.c"
			gchar* primary_msg = NULL;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			TeplInfoBar* infobar = NULL;
			const gchar* _tmp19_;
			GError* _tmp20_;
			const gchar* _tmp21_;
			TeplInfoBar* _tmp22_;
			DocumentTab* _tmp23_;
			TeplInfoBar* _tmp24_;
			TeplInfoBar* _tmp25_;
#line 117 "document.vala"
			_tmp15_ = g_file_get_parse_name (location);
#line 117 "document.vala"
			_tmp16_ = _tmp15_;
#line 117 "document.vala"
			_tmp17_ = g_strdup_printf (_ ("Impossible to load the file “%s”."), _tmp16_);
#line 117 "document.vala"
			_tmp18_ = _tmp17_;
#line 117 "document.vala"
			_g_free0 (_tmp16_);
#line 117 "document.vala"
			primary_msg = _tmp18_;
#line 119 "document.vala"
			_tmp19_ = primary_msg;
#line 119 "document.vala"
			_tmp20_ = e;
#line 119 "document.vala"
			_tmp21_ = _tmp20_->message;
#line 119 "document.vala"
			_tmp22_ = tepl_info_bar_new_simple (GTK_MESSAGE_ERROR, _tmp19_, _tmp21_);
#line 119 "document.vala"
			g_object_ref_sink (_tmp22_);
#line 119 "document.vala"
			infobar = _tmp22_;
#line 121 "document.vala"
			_tmp23_ = self->tab;
#line 121 "document.vala"
			_tmp24_ = infobar;
#line 121 "document.vala"
			tepl_tab_add_info_bar ((TeplTab*) _tmp23_, (GtkInfoBar*) _tmp24_);
#line 122 "document.vala"
			_tmp25_ = infobar;
#line 122 "document.vala"
			gtk_widget_show ((GtkWidget*) _tmp25_);
#line 115 "document.vala"
			_g_object_unref0 (infobar);
#line 115 "document.vala"
			_g_free0 (primary_msg);
#line 735 "document.c"
		}
#line 91 "document.vala"
		_g_error_free0 (e);
#line 739 "document.c"
	}
	__finally0:
#line 91 "document.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 91 "document.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 91 "document.vala"
		g_clear_error (&_inner_error0_);
#line 91 "document.vala"
		return;
#line 750 "document.c"
	}
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
#line 1232 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1233 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1233 "glib-2.0.vapi"
	result = _tmp0_;
#line 1233 "glib-2.0.vapi"
	return result;
#line 768 "document.c"
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result = NULL;
#line 1480 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1481 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1481 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1481 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1482 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1483 "glib-2.0.vapi"
		start = string_length + start;
#line 795 "document.c"
	}
#line 1485 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1486 "glib-2.0.vapi"
		end = string_length + end;
#line 801 "document.c"
	}
#line 1488 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1488 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 807 "document.c"
	} else {
#line 1488 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 811 "document.c"
	}
#line 1488 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1489 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1489 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 819 "document.c"
	} else {
#line 1489 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 823 "document.c"
	}
#line 1489 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1490 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1491 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1491 "glib-2.0.vapi"
	result = _tmp4_;
#line 1491 "glib-2.0.vapi"
	return result;
#line 835 "document.c"
}

void
document_set_contents (Document* self,
                       const gchar* contents)
{
	gchar* contents2 = NULL;
	gint _tmp0_;
	gint _tmp1_;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_;
	GtkTextIter iter = {0};
	GtkTextIter _tmp5_ = {0};
	GtkTextIter _tmp6_;
#line 127 "document.vala"
	g_return_if_fail (self != NULL);
#line 127 "document.vala"
	g_return_if_fail (contents != NULL);
#line 130 "document.vala"
	contents2 = NULL;
#line 131 "document.vala"
	_tmp0_ = strlen (contents);
#line 131 "document.vala"
	_tmp1_ = _tmp0_;
#line 131 "document.vala"
	if (string_get (contents, (glong) (_tmp1_ - 1)) == '\n') {
#line 862 "document.c"
		gchar* _tmp2_;
#line 132 "document.vala"
		_tmp2_ = string_slice (contents, (glong) 0, (glong) -1);
#line 132 "document.vala"
		_g_free0 (contents2);
#line 132 "document.vala"
		contents2 = _tmp2_;
#line 870 "document.c"
	}
#line 134 "document.vala"
	gtk_source_buffer_begin_not_undoable_action ((GtkSourceBuffer*) self);
#line 135 "document.vala"
	_tmp4_ = contents2;
#line 135 "document.vala"
	_tmp3_ = _tmp4_;
#line 135 "document.vala"
	if (_tmp3_ == NULL) {
#line 135 "document.vala"
		_tmp3_ = contents;
#line 882 "document.c"
	}
#line 135 "document.vala"
	gtk_text_buffer_set_text ((GtkTextBuffer*) self, _tmp3_, -1);
#line 136 "document.vala"
	self->priv->new_file = TRUE;
#line 137 "document.vala"
	gtk_text_buffer_set_modified ((GtkTextBuffer*) self, FALSE);
#line 138 "document.vala"
	gtk_source_buffer_end_not_undoable_action ((GtkSourceBuffer*) self);
#line 142 "document.vala"
	gtk_text_buffer_get_start_iter ((GtkTextBuffer*) self, &_tmp5_);
#line 142 "document.vala"
	iter = _tmp5_;
#line 143 "document.vala"
	_tmp6_ = iter;
#line 143 "document.vala"
	gtk_text_buffer_place_cursor ((GtkTextBuffer*) self, &_tmp6_);
#line 127 "document.vala"
	_g_free0 (contents2);
#line 902 "document.c"
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
#line 1570 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1571 "glib-2.0.vapi"
	result = self;
#line 1571 "glib-2.0.vapi"
	return result;
#line 915 "document.c"
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
#line 1555 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1556 "glib-2.0.vapi"
	res = (guint8*) self;
#line 1556 "glib-2.0.vapi"
	res_length1 = -1;
#line 1556 "glib-2.0.vapi"
	_res_size_ = res_length1;
#line 1557 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1557 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1557 "glib-2.0.vapi"
	res_length1 = (gint) _tmp1_;
#line 1558 "glib-2.0.vapi"
	_tmp2_ = res;
#line 1558 "glib-2.0.vapi"
	_tmp2__length1 = res_length1;
#line 1558 "glib-2.0.vapi"
	if (result_length1) {
#line 1558 "glib-2.0.vapi"
		*result_length1 = _tmp2__length1;
#line 952 "document.c"
	}
#line 1558 "glib-2.0.vapi"
	result = _tmp2_;
#line 1558 "glib-2.0.vapi"
	return result;
#line 958 "document.c"
}

static Block16Data*
block16_data_ref (Block16Data* _data16_)
{
#line 197 "document.vala"
	g_atomic_int_inc (&_data16_->_ref_count_);
#line 197 "document.vala"
	return _data16_;
#line 968 "document.c"
}

static void
block16_data_unref (void * _userdata_)
{
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
#line 197 "document.vala"
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
#line 978 "document.c"
		Document* self;
#line 197 "document.vala"
		self = _data16_->self;
#line 197 "document.vala"
		_g_object_unref0 (_data16_->infobar);
#line 197 "document.vala"
		_g_object_unref0 (self);
#line 197 "document.vala"
		g_slice_free (Block16Data, _data16_);
#line 988 "document.c"
	}
}

static void
____lambda16_ (Block16Data* _data16_,
               gint response_id)
{
	Document* self;
	TeplInfoBar* _tmp0_;
#line 211 "document.vala"
	self = _data16_->self;
#line 213 "document.vala"
	if (response_id == ((gint) GTK_RESPONSE_YES)) {
#line 214 "document.vala"
		document_save (self, FALSE, FALSE);
#line 1004 "document.c"
	}
#line 215 "document.vala"
	_tmp0_ = _data16_->infobar;
#line 215 "document.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
#line 1010 "document.c"
}

static void
_____lambda16__gtk_info_bar_response (GtkInfoBar* _sender,
                                      gint response_id,
                                      gpointer self)
{
#line 211 "document.vala"
	____lambda16_ (self, response_id);
#line 1020 "document.c"
}

void
document_save (Document* self,
               gboolean check_file_changed_on_disk,
               gboolean force)
{
	GFile* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_ = {0};
	gchar* text = NULL;
	GtkTextIter _tmp5_;
	GtkTextIter _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GError* _inner_error0_ = NULL;
#line 146 "document.vala"
	g_return_if_fail (self != NULL);
#line 148 "document.vala"
	_tmp0_ = self->priv->_location;
#line 148 "document.vala"
	g_return_if_fail (_tmp0_ != NULL);
#line 151 "document.vala"
	if (!force) {
#line 151 "document.vala"
		_tmp2_ = !self->priv->new_file;
#line 1054 "document.c"
	} else {
#line 151 "document.vala"
		_tmp2_ = FALSE;
#line 1058 "document.c"
	}
#line 151 "document.vala"
	if (_tmp2_) {
#line 151 "document.vala"
		_tmp1_ = !gtk_text_buffer_get_modified ((GtkTextBuffer*) self);
#line 1064 "document.c"
	} else {
#line 151 "document.vala"
		_tmp1_ = FALSE;
#line 1068 "document.c"
	}
#line 151 "document.vala"
	if (_tmp1_) {
#line 152 "document.vala"
		return;
#line 1074 "document.c"
	}
#line 156 "document.vala"
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) self, &_tmp3_, &_tmp4_);
#line 156 "document.vala"
	start = _tmp3_;
#line 156 "document.vala"
	end = _tmp4_;
#line 157 "document.vala"
	_tmp5_ = start;
#line 157 "document.vala"
	_tmp6_ = end;
#line 157 "document.vala"
	_tmp7_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp5_, &_tmp6_, FALSE);
#line 157 "document.vala"
	text = _tmp7_;
#line 160 "document.vala"
	_tmp8_ = text;
#line 160 "document.vala"
	_tmp9_ = text;
#line 160 "document.vala"
	_tmp10_ = strlen (_tmp9_);
#line 160 "document.vala"
	_tmp11_ = _tmp10_;
#line 160 "document.vala"
	if (string_get (_tmp8_, (glong) (_tmp11_ - 1)) != '\n') {
#line 1100 "document.c"
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
#line 161 "document.vala"
		_tmp12_ = text;
#line 161 "document.vala"
		_tmp13_ = string_to_string (_tmp12_);
#line 161 "document.vala"
		_tmp14_ = g_strconcat (_tmp13_, "\n", NULL);
#line 161 "document.vala"
		_g_free0 (text);
#line 161 "document.vala"
		text = _tmp14_;
#line 1114 "document.c"
	}
	{
		GSettings* settings = NULL;
		GSettings* _tmp15_;
		gboolean _tmp16_ = FALSE;
		gboolean make_backup = FALSE;
		const gchar* _tmp18_ = NULL;
		gchar* etag = NULL;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		GFile* parent = NULL;
		GFile* _tmp37_;
		GFile* _tmp38_;
		gboolean _tmp39_ = FALSE;
		GFile* _tmp40_;
		GFile* _tmp43_;
		const gchar* _tmp44_;
		guint8* _tmp45_;
		gint _tmp45__length1;
		gint _tmp46_ = 0;
		guint8* _tmp47_;
		gint _tmp47__length1;
		const gchar* _tmp48_;
		gchar* _tmp49_ = NULL;
		GtkRecentManager* _tmp50_;
		GFile* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
#line 165 "document.vala"
		_tmp15_ = g_settings_new ("org.gnome.gnome-latex.preferences.editor");
#line 165 "document.vala"
		settings = _tmp15_;
#line 167 "document.vala"
		if (!self->priv->backup_made) {
#line 1149 "document.c"
			GSettings* _tmp17_;
#line 168 "document.vala"
			_tmp17_ = settings;
#line 168 "document.vala"
			_tmp16_ = g_settings_get_boolean (_tmp17_, "create-backup-copy");
#line 1155 "document.c"
		} else {
#line 167 "document.vala"
			_tmp16_ = FALSE;
#line 1159 "document.c"
		}
#line 167 "document.vala"
		make_backup = _tmp16_;
#line 170 "document.vala"
		if (check_file_changed_on_disk) {
#line 1165 "document.c"
			const gchar* _tmp19_;
#line 170 "document.vala"
			_tmp19_ = self->priv->_etag;
#line 170 "document.vala"
			_tmp18_ = _tmp19_;
#line 1171 "document.c"
		} else {
#line 170 "document.vala"
			_tmp18_ = NULL;
#line 1175 "document.c"
		}
#line 170 "document.vala"
		_tmp20_ = g_strdup (_tmp18_);
#line 170 "document.vala"
		etag = _tmp20_;
#line 173 "document.vala"
		_tmp21_ = self->priv->encoding;
#line 173 "document.vala"
		if (_tmp21_ != NULL) {
#line 1185 "document.c"
			gchar* _tmp22_ = NULL;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			const gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
#line 174 "document.vala"
			_tmp23_ = text;
#line 174 "document.vala"
			_tmp24_ = text;
#line 174 "document.vala"
			_tmp25_ = strlen (_tmp24_);
#line 174 "document.vala"
			_tmp26_ = _tmp25_;
#line 174 "document.vala"
			_tmp27_ = self->priv->encoding;
#line 174 "document.vala"
			_tmp28_ = g_convert (_tmp23_, (gssize) _tmp26_, _tmp27_, "UTF-8", NULL, NULL, &_inner_error0_);
#line 174 "document.vala"
			_tmp22_ = _tmp28_;
#line 174 "document.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 174 "document.vala"
				_g_free0 (etag);
#line 174 "document.vala"
				_g_object_unref0 (settings);
#line 1214 "document.c"
				goto __catch0_g_error;
			}
#line 174 "document.vala"
			_tmp29_ = _tmp22_;
#line 174 "document.vala"
			_tmp22_ = NULL;
#line 174 "document.vala"
			_g_free0 (text);
#line 174 "document.vala"
			text = _tmp29_;
#line 173 "document.vala"
			_g_free0 (_tmp22_);
#line 1227 "document.c"
		} else {
			gchar* _tmp30_ = NULL;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			gint _tmp33_;
			gint _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
#line 178 "document.vala"
			_tmp31_ = text;
#line 178 "document.vala"
			_tmp32_ = text;
#line 178 "document.vala"
			_tmp33_ = strlen (_tmp32_);
#line 178 "document.vala"
			_tmp34_ = _tmp33_;
#line 178 "document.vala"
			_tmp35_ = g_filename_from_utf8 (_tmp31_, (gssize) _tmp34_, NULL, NULL, &_inner_error0_);
#line 178 "document.vala"
			_tmp30_ = _tmp35_;
#line 178 "document.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 178 "document.vala"
				_g_free0 (etag);
#line 178 "document.vala"
				_g_object_unref0 (settings);
#line 1254 "document.c"
				goto __catch0_g_error;
			}
#line 178 "document.vala"
			_tmp36_ = _tmp30_;
#line 178 "document.vala"
			_tmp30_ = NULL;
#line 178 "document.vala"
			_g_free0 (text);
#line 178 "document.vala"
			text = _tmp36_;
#line 173 "document.vala"
			_g_free0 (_tmp30_);
#line 1267 "document.c"
		}
#line 181 "document.vala"
		_tmp37_ = self->priv->_location;
#line 181 "document.vala"
		_tmp38_ = g_file_get_parent (_tmp37_);
#line 181 "document.vala"
		parent = _tmp38_;
#line 182 "document.vala"
		_tmp40_ = parent;
#line 182 "document.vala"
		if (_tmp40_ != NULL) {
#line 1279 "document.c"
			GFile* _tmp41_;
#line 182 "document.vala"
			_tmp41_ = parent;
#line 182 "document.vala"
			_tmp39_ = !g_file_query_exists (_tmp41_, NULL);
#line 1285 "document.c"
		} else {
#line 182 "document.vala"
			_tmp39_ = FALSE;
#line 1289 "document.c"
		}
#line 182 "document.vala"
		if (_tmp39_) {
#line 1293 "document.c"
			GFile* _tmp42_;
#line 183 "document.vala"
			_tmp42_ = parent;
#line 183 "document.vala"
			g_file_make_directory_with_parents (_tmp42_, NULL, &_inner_error0_);
#line 183 "document.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 183 "document.vala"
				_g_object_unref0 (parent);
#line 183 "document.vala"
				_g_free0 (etag);
#line 183 "document.vala"
				_g_object_unref0 (settings);
#line 1307 "document.c"
				goto __catch0_g_error;
			}
		}
#line 185 "document.vala"
		_tmp43_ = self->priv->_location;
#line 185 "document.vala"
		_tmp44_ = text;
#line 185 "document.vala"
		_tmp45_ = string_get_data (_tmp44_, &_tmp46_);
#line 185 "document.vala"
		_tmp45__length1 = _tmp46_;
#line 185 "document.vala"
		_tmp47_ = _tmp45_;
#line 185 "document.vala"
		_tmp47__length1 = _tmp45__length1;
#line 185 "document.vala"
		_tmp48_ = etag;
#line 185 "document.vala"
		g_file_replace_contents (_tmp43_, _tmp47_, (gsize) _tmp47__length1, _tmp48_, make_backup, G_FILE_CREATE_NONE, &_tmp49_, NULL, &_inner_error0_);
#line 185 "document.vala"
		_g_free0 (self->priv->_etag);
#line 185 "document.vala"
		self->priv->_etag = _tmp49_;
#line 185 "document.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 185 "document.vala"
			_g_object_unref0 (parent);
#line 185 "document.vala"
			_g_free0 (etag);
#line 185 "document.vala"
			_g_object_unref0 (settings);
#line 1339 "document.c"
			goto __catch0_g_error;
		}
#line 188 "document.vala"
		gtk_text_buffer_set_modified ((GtkTextBuffer*) self, FALSE);
#line 190 "document.vala"
		_tmp50_ = gtk_recent_manager_get_default ();
#line 190 "document.vala"
		_tmp51_ = self->priv->_location;
#line 190 "document.vala"
		_tmp52_ = g_file_get_uri (_tmp51_);
#line 190 "document.vala"
		_tmp53_ = _tmp52_;
#line 190 "document.vala"
		gtk_recent_manager_add_item (_tmp50_, _tmp53_);
#line 190 "document.vala"
		_g_free0 (_tmp53_);
#line 191 "document.vala"
		self->priv->backup_made = TRUE;
#line 193 "document.vala"
		tepl_buffer_save_metadata_into_metadata_manager ((TeplBuffer*) self);
#line 163 "document.vala"
		_g_object_unref0 (parent);
#line 163 "document.vala"
		_g_free0 (etag);
#line 163 "document.vala"
		_g_object_unref0 (settings);
#line 1366 "document.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gboolean _tmp54_ = FALSE;
		GError* _tmp55_;
#line 163 "document.vala"
		e = _inner_error0_;
#line 163 "document.vala"
		_inner_error0_ = NULL;
#line 197 "document.vala"
		_tmp55_ = e;
#line 197 "document.vala"
		if (g_error_matches (_tmp55_, G_IO_ERROR, G_IO_ERROR_WRONG_ETAG)) {
#line 1382 "document.c"
			DocumentTab* _tmp56_;
#line 197 "document.vala"
			_tmp56_ = self->tab;
#line 197 "document.vala"
			_tmp54_ = _tmp56_ != NULL;
#line 1388 "document.c"
		} else {
#line 197 "document.vala"
			_tmp54_ = FALSE;
#line 1392 "document.c"
		}
#line 197 "document.vala"
		if (_tmp54_) {
#line 1396 "document.c"
			Block16Data* _data16_;
			gchar* primary_msg = NULL;
			GFile* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			gchar* secondary_msg = NULL;
			gchar* _tmp62_;
			const gchar* _tmp63_;
			const gchar* _tmp64_;
			TeplInfoBar* _tmp65_;
			TeplInfoBar* _tmp66_;
			TeplInfoBar* _tmp67_;
			DocumentTab* _tmp68_;
			TeplInfoBar* _tmp69_;
			TeplInfoBar* _tmp70_;
			TeplInfoBar* _tmp71_;
#line 197 "document.vala"
			_data16_ = g_slice_new0 (Block16Data);
#line 197 "document.vala"
			_data16_->_ref_count_ = 1;
#line 197 "document.vala"
			_data16_->self = g_object_ref (self);
#line 199 "document.vala"
			_tmp57_ = self->priv->_location;
#line 199 "document.vala"
			_tmp58_ = g_file_get_parse_name (_tmp57_);
#line 199 "document.vala"
			_tmp59_ = _tmp58_;
#line 199 "document.vala"
			_tmp60_ = g_strdup_printf (_ ("The file %s has been modified since reading it."), _tmp59_);
#line 199 "document.vala"
			_tmp61_ = _tmp60_;
#line 199 "document.vala"
			_g_free0 (_tmp59_);
#line 199 "document.vala"
			primary_msg = _tmp61_;
#line 201 "document.vala"
			_tmp62_ = g_strdup (_ ("If you save it, all the external changes could be lost. Save it anyway" \
"?"));
#line 201 "document.vala"
			secondary_msg = _tmp62_;
#line 204 "document.vala"
			_tmp63_ = primary_msg;
#line 204 "document.vala"
			_tmp64_ = secondary_msg;
#line 204 "document.vala"
			_tmp65_ = tepl_info_bar_new_simple (GTK_MESSAGE_WARNING, _tmp63_, _tmp64_);
#line 204 "document.vala"
			g_object_ref_sink (_tmp65_);
#line 204 "document.vala"
			_data16_->infobar = _tmp65_;
#line 206 "document.vala"
			_tmp66_ = _data16_->infobar;
#line 206 "document.vala"
			gtk_info_bar_add_button ((GtkInfoBar*) _tmp66_, _ ("_Save Anyway"), (gint) GTK_RESPONSE_YES);
#line 207 "document.vala"
			_tmp67_ = _data16_->infobar;
#line 207 "document.vala"
			gtk_info_bar_add_button ((GtkInfoBar*) _tmp67_, _ ("_Don’t Save"), (gint) GTK_RESPONSE_CANCEL);
#line 208 "document.vala"
			_tmp68_ = self->tab;
#line 208 "document.vala"
			_tmp69_ = _data16_->infobar;
#line 208 "document.vala"
			tepl_tab_add_info_bar ((TeplTab*) _tmp68_, (GtkInfoBar*) _tmp69_);
#line 209 "document.vala"
			_tmp70_ = _data16_->infobar;
#line 209 "document.vala"
			gtk_widget_show ((GtkWidget*) _tmp70_);
#line 211 "document.vala"
			_tmp71_ = _data16_->infobar;
#line 211 "document.vala"
			g_signal_connect_data ((GtkInfoBar*) _tmp71_, "response", (GCallback) _____lambda16__gtk_info_bar_response, block16_data_ref (_data16_), (GClosureNotify) block16_data_unref, 0);
#line 197 "document.vala"
			_g_free0 (secondary_msg);
#line 197 "document.vala"
			_g_free0 (primary_msg);
#line 197 "document.vala"
			block16_data_unref (_data16_);
#line 197 "document.vala"
			_data16_ = NULL;
#line 1479 "document.c"
		} else {
			GError* _tmp72_;
			const gchar* _tmp73_;
			DocumentTab* _tmp74_;
#line 220 "document.vala"
			_tmp72_ = e;
#line 220 "document.vala"
			_tmp73_ = _tmp72_->message;
#line 220 "document.vala"
			g_warning ("document.vala:220: %s", _tmp73_);
#line 222 "document.vala"
			_tmp74_ = self->tab;
#line 222 "document.vala"
			if (_tmp74_ != NULL) {
#line 1494 "document.c"
				gchar* primary_msg = NULL;
				gchar* _tmp75_;
				TeplInfoBar* infobar = NULL;
				const gchar* _tmp76_;
				GError* _tmp77_;
				const gchar* _tmp78_;
				TeplInfoBar* _tmp79_;
				TeplInfoBar* _tmp80_;
				DocumentTab* _tmp81_;
				TeplInfoBar* _tmp82_;
				TeplInfoBar* _tmp83_;
#line 224 "document.vala"
				_tmp75_ = g_strdup (_ ("Impossible to save the file."));
#line 224 "document.vala"
				primary_msg = _tmp75_;
#line 225 "document.vala"
				_tmp76_ = primary_msg;
#line 225 "document.vala"
				_tmp77_ = e;
#line 225 "document.vala"
				_tmp78_ = _tmp77_->message;
#line 225 "document.vala"
				_tmp79_ = tepl_info_bar_new_simple (GTK_MESSAGE_ERROR, _tmp76_, _tmp78_);
#line 225 "document.vala"
				g_object_ref_sink (_tmp79_);
#line 225 "document.vala"
				infobar = _tmp79_;
#line 227 "document.vala"
				_tmp80_ = infobar;
#line 227 "document.vala"
				tepl_info_bar_add_close_button (_tmp80_);
#line 228 "document.vala"
				_tmp81_ = self->tab;
#line 228 "document.vala"
				_tmp82_ = infobar;
#line 228 "document.vala"
				tepl_tab_add_info_bar ((TeplTab*) _tmp81_, (GtkInfoBar*) _tmp82_);
#line 229 "document.vala"
				_tmp83_ = infobar;
#line 229 "document.vala"
				gtk_widget_show ((GtkWidget*) _tmp83_);
#line 222 "document.vala"
				_g_object_unref0 (infobar);
#line 222 "document.vala"
				_g_free0 (primary_msg);
#line 1540 "document.c"
			}
		}
#line 163 "document.vala"
		_g_error_free0 (e);
#line 1545 "document.c"
	}
	__finally0:
#line 163 "document.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 163 "document.vala"
		_g_free0 (text);
#line 163 "document.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 163 "document.vala"
		g_clear_error (&_inner_error0_);
#line 163 "document.vala"
		return;
#line 1558 "document.c"
	}
#line 146 "document.vala"
	_g_free0 (text);
#line 1562 "document.c"
}

static gchar*
document_to_utf8 (Document* self,
                  const gchar* text,
                  GError** error)
{
	GError* _tmp7_;
	GError* _inner_error0_ = NULL;
	gchar* result = NULL;
#line 235 "document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 235 "document.vala"
	g_return_val_if_fail (text != NULL, NULL);
#line 1577 "document.c"
	{
		const gchar** charset_collection = NULL;
		gint charset_collection_length1 = 0;
		gint _charset_collection_size_ = 0;
		gint charset_it = 0;
#line 237 "document.vala"
		charset_collection = ENCODINGS_CHARSETS;
#line 237 "document.vala"
		charset_collection_length1 = G_N_ELEMENTS (ENCODINGS_CHARSETS);
#line 237 "document.vala"
		for (charset_it = 0; charset_it < charset_collection_length1; charset_it = charset_it + 1) {
#line 1589 "document.c"
			gchar* _tmp0_;
			gchar* charset = NULL;
#line 237 "document.vala"
			_tmp0_ = g_strdup (charset_collection[charset_it]);
#line 237 "document.vala"
			charset = _tmp0_;
#line 1596 "document.c"
			{
				{
					gchar* utf8_text = NULL;
					gint _tmp1_;
					gint _tmp2_;
					const gchar* _tmp3_;
					gchar* _tmp4_;
					const gchar* _tmp5_;
					gchar* _tmp6_;
#line 241 "document.vala"
					_tmp1_ = strlen (text);
#line 241 "document.vala"
					_tmp2_ = _tmp1_;
#line 241 "document.vala"
					_tmp3_ = charset;
#line 241 "document.vala"
					_tmp4_ = g_convert (text, (gssize) _tmp2_, "UTF-8", _tmp3_, NULL, NULL, &_inner_error0_);
#line 241 "document.vala"
					utf8_text = _tmp4_;
#line 241 "document.vala"
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 241 "document.vala"
						if (_inner_error0_->domain == G_CONVERT_ERROR) {
#line 1620 "document.c"
							goto __catch0_g_convert_error;
						}
#line 241 "document.vala"
						_g_free0 (charset);
#line 241 "document.vala"
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 241 "document.vala"
						g_clear_error (&_inner_error0_);
#line 241 "document.vala"
						return NULL;
#line 1631 "document.c"
					}
#line 243 "document.vala"
					_tmp5_ = charset;
#line 243 "document.vala"
					_tmp6_ = g_strdup (_tmp5_);
#line 243 "document.vala"
					_g_free0 (self->priv->encoding);
#line 243 "document.vala"
					self->priv->encoding = _tmp6_;
#line 244 "document.vala"
					result = utf8_text;
#line 244 "document.vala"
					_g_free0 (charset);
#line 244 "document.vala"
					return result;
#line 1647 "document.c"
				}
				goto __finally0;
				__catch0_g_convert_error:
				{
#line 239 "document.vala"
					g_clear_error (&_inner_error0_);
#line 248 "document.vala"
					_g_free0 (charset);
#line 248 "document.vala"
					continue;
#line 1658 "document.c"
				}
				__finally0:
#line 239 "document.vala"
				if (_inner_error0_->domain == G_CONVERT_ERROR) {
#line 239 "document.vala"
					g_propagate_error (error, _inner_error0_);
#line 239 "document.vala"
					_g_free0 (charset);
#line 239 "document.vala"
					return NULL;
#line 1669 "document.c"
				} else {
#line 239 "document.vala"
					_g_free0 (charset);
#line 239 "document.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 239 "document.vala"
					g_clear_error (&_inner_error0_);
#line 239 "document.vala"
					return NULL;
#line 1679 "document.c"
				}
#line 237 "document.vala"
				_g_free0 (charset);
#line 1683 "document.c"
			}
		}
	}
#line 251 "document.vala"
	_tmp7_ = g_error_new_literal (G_CONVERT_ERROR, G_CONVERT_ERROR_FAILED, _ ("Error trying to convert the document to UTF-8"));
#line 251 "document.vala"
	_inner_error0_ = _tmp7_;
#line 251 "document.vala"
	if (_inner_error0_->domain == G_CONVERT_ERROR) {
#line 251 "document.vala"
		g_propagate_error (error, _inner_error0_);
#line 251 "document.vala"
		return NULL;
#line 1697 "document.c"
	} else {
#line 251 "document.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 251 "document.vala"
		g_clear_error (&_inner_error0_);
#line 251 "document.vala"
		return NULL;
#line 1705 "document.c"
	}
}

static void
document_update_syntax_highlighting (Document* self)
{
	GtkSourceLanguageManager* lm = NULL;
	GtkSourceLanguageManager* _tmp0_;
	GtkSourceLanguageManager* _tmp1_;
	gchar* content_type = NULL;
	GtkSourceLanguage* lang = NULL;
	GFile* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	GtkSourceLanguage* _tmp10_;
	GtkSourceLanguage* _tmp11_;
	GtkSourceLanguage* _tmp12_;
	GError* _inner_error0_ = NULL;
#line 255 "document.vala"
	g_return_if_fail (self != NULL);
#line 257 "document.vala"
	_tmp0_ = gtk_source_language_manager_get_default ();
#line 257 "document.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 257 "document.vala"
	lm = _tmp1_;
#line 258 "document.vala"
	content_type = NULL;
#line 1735 "document.c"
	{
		GFileInfo* info = NULL;
		GFile* _tmp2_;
		GFileInfo* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 261 "document.vala"
		_tmp2_ = self->priv->_location;
#line 261 "document.vala"
		_tmp3_ = g_file_query_info (_tmp2_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
#line 261 "document.vala"
		info = _tmp3_;
#line 261 "document.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1750 "document.c"
			goto __catch0_g_error;
		}
#line 263 "document.vala"
		_tmp4_ = g_file_info_get_content_type (info);
#line 263 "document.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 263 "document.vala"
		_g_free0 (content_type);
#line 263 "document.vala"
		content_type = _tmp5_;
#line 259 "document.vala"
		_g_object_unref0 (info);
#line 1763 "document.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 259 "document.vala"
		g_clear_error (&_inner_error0_);
#line 1770 "document.c"
	}
	__finally0:
#line 259 "document.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 259 "document.vala"
		_g_free0 (content_type);
#line 259 "document.vala"
		_g_object_unref0 (lm);
#line 259 "document.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 259 "document.vala"
		g_clear_error (&_inner_error0_);
#line 259 "document.vala"
		return;
#line 1785 "document.c"
	}
#line 267 "document.vala"
	_tmp6_ = self->priv->_location;
#line 267 "document.vala"
	_tmp7_ = g_file_get_parse_name (_tmp6_);
#line 267 "document.vala"
	_tmp8_ = _tmp7_;
#line 267 "document.vala"
	_tmp9_ = content_type;
#line 267 "document.vala"
	_tmp10_ = gtk_source_language_manager_guess_language (lm, _tmp8_, _tmp9_);
#line 267 "document.vala"
	_tmp11_ = _g_object_ref0 (_tmp10_);
#line 267 "document.vala"
	_tmp12_ = _tmp11_;
#line 267 "document.vala"
	_g_free0 (_tmp8_);
#line 267 "document.vala"
	lang = _tmp12_;
#line 268 "document.vala"
	gtk_source_buffer_set_language ((GtkSourceBuffer*) self, lang);
#line 255 "document.vala"
	_g_object_unref0 (lang);
#line 255 "document.vala"
	_g_free0 (content_type);
#line 255 "document.vala"
	_g_object_unref0 (lm);
#line 1813 "document.c"
}

static void
document_update_project_id (Document* self)
{
	gint i = 0;
#line 271 "document.vala"
	g_return_if_fail (self != NULL);
#line 273 "document.vala"
	i = 0;
#line 1824 "document.c"
	{
		GeeIterator* _project_it = NULL;
		Projects* _tmp0_;
		Projects* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
#line 274 "document.vala"
		_tmp0_ = projects_get_default ();
#line 274 "document.vala"
		_tmp1_ = _tmp0_;
#line 274 "document.vala"
		_tmp2_ = projects_iterator (_tmp1_);
#line 274 "document.vala"
		_tmp3_ = _tmp2_;
#line 274 "document.vala"
		_projects_unref0 (_tmp1_);
#line 274 "document.vala"
		_project_it = _tmp3_;
#line 274 "document.vala"
		while (TRUE) {
#line 1845 "document.c"
			GeeIterator* _tmp4_;
			Project project = {0};
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			Project* _tmp7_;
			Project _tmp8_;
			Project _tmp9_ = {0};
			Project _tmp10_;
			GFile* _tmp11_;
			Project _tmp12_;
			GFile* _tmp13_;
			gint _tmp14_;
#line 274 "document.vala"
			_tmp4_ = _project_it;
#line 274 "document.vala"
			if (!gee_iterator_next (_tmp4_)) {
#line 274 "document.vala"
				break;
#line 1864 "document.c"
			}
#line 274 "document.vala"
			_tmp5_ = _project_it;
#line 274 "document.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 274 "document.vala"
			_tmp7_ = (Project*) _tmp6_;
#line 274 "document.vala"
			_tmp8_ = *_tmp7_;
#line 274 "document.vala"
			project_copy (&_tmp8_, &_tmp9_);
#line 274 "document.vala"
			_tmp10_ = _tmp9_;
#line 274 "document.vala"
			_project_free0 (_tmp7_);
#line 274 "document.vala"
			project = _tmp10_;
#line 276 "document.vala"
			_tmp11_ = self->priv->_location;
#line 276 "document.vala"
			_tmp12_ = project;
#line 276 "document.vala"
			_tmp13_ = _tmp12_.directory;
#line 276 "document.vala"
			if (g_file_has_prefix (_tmp11_, _tmp13_)) {
#line 278 "document.vala"
				document_set_project_id (self, i);
#line 279 "document.vala"
				project_destroy (&project);
#line 279 "document.vala"
				_g_object_unref0 (_project_it);
#line 279 "document.vala"
				return;
#line 1898 "document.c"
			}
#line 281 "document.vala"
			_tmp14_ = i;
#line 281 "document.vala"
			i = _tmp14_ + 1;
#line 274 "document.vala"
			project_destroy (&project);
#line 1906 "document.c"
		}
#line 274 "document.vala"
		_g_object_unref0 (_project_it);
#line 1910 "document.c"
	}
#line 284 "document.vala"
	document_set_project_id (self, -1);
#line 1914 "document.c"
}

gchar*
document_get_uri_for_display (Document* self)
{
	GFile* _tmp0_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* result = NULL;
#line 287 "document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 289 "document.vala"
	_tmp0_ = self->priv->_location;
#line 289 "document.vala"
	if (_tmp0_ == NULL) {
#line 1933 "document.c"
		TeplFile* _tmp1_;
		gchar* _tmp2_;
#line 290 "document.vala"
		_tmp1_ = tepl_buffer_get_file ((TeplBuffer*) self);
#line 290 "document.vala"
		_tmp2_ = tepl_file_get_short_name (_tmp1_);
#line 290 "document.vala"
		result = _tmp2_;
#line 290 "document.vala"
		return result;
#line 1944 "document.c"
	}
#line 292 "document.vala"
	_tmp3_ = self->priv->_location;
#line 292 "document.vala"
	_tmp4_ = g_file_get_parse_name (_tmp3_);
#line 292 "document.vala"
	_tmp5_ = _tmp4_;
#line 292 "document.vala"
	_tmp6_ = tepl_utils_replace_home_dir_with_tilde (_tmp5_);
#line 292 "document.vala"
	_tmp7_ = _tmp6_;
#line 292 "document.vala"
	_g_free0 (_tmp5_);
#line 292 "document.vala"
	result = _tmp7_;
#line 292 "document.vala"
	return result;
#line 1962 "document.c"
}

gchar*
document_get_short_name_for_display (Document* self)
{
	GFile* _tmp0_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* result = NULL;
#line 295 "document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 297 "document.vala"
	_tmp0_ = self->priv->_location;
#line 297 "document.vala"
	if (_tmp0_ == NULL) {
#line 1978 "document.c"
		TeplFile* _tmp1_;
		gchar* _tmp2_;
#line 298 "document.vala"
		_tmp1_ = tepl_buffer_get_file ((TeplBuffer*) self);
#line 298 "document.vala"
		_tmp2_ = tepl_file_get_short_name (_tmp1_);
#line 298 "document.vala"
		result = _tmp2_;
#line 298 "document.vala"
		return result;
#line 1989 "document.c"
	}
#line 300 "document.vala"
	_tmp3_ = self->priv->_location;
#line 300 "document.vala"
	_tmp4_ = g_file_get_basename (_tmp3_);
#line 300 "document.vala"
	result = _tmp4_;
#line 300 "document.vala"
	return result;
#line 1999 "document.c"
}

gboolean
document_is_externally_modified (Document* self)
{
	GFile* _tmp0_;
	gchar* current_etag = NULL;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
#line 303 "document.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 305 "document.vala"
	_tmp0_ = self->priv->_location;
#line 305 "document.vala"
	if (_tmp0_ == NULL) {
#line 306 "document.vala"
		result = FALSE;
#line 306 "document.vala"
		return result;
#line 2021 "document.c"
	}
#line 308 "document.vala"
	current_etag = NULL;
#line 2025 "document.c"
	{
		GFileInfo* file_info = NULL;
		GFile* _tmp1_;
		GFileInfo* _tmp2_;
		GFileInfo* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
#line 311 "document.vala"
		_tmp1_ = self->priv->_location;
#line 311 "document.vala"
		_tmp2_ = g_file_query_info (_tmp1_, G_FILE_ATTRIBUTE_ETAG_VALUE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
#line 311 "document.vala"
		file_info = _tmp2_;
#line 311 "document.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2041 "document.c"
			goto __catch0_g_error;
		}
#line 313 "document.vala"
		_tmp3_ = file_info;
#line 313 "document.vala"
		_tmp4_ = g_file_info_get_etag (_tmp3_);
#line 313 "document.vala"
		_tmp5_ = g_strdup (_tmp4_);
#line 313 "document.vala"
		_g_free0 (current_etag);
#line 313 "document.vala"
		current_etag = _tmp5_;
#line 309 "document.vala"
		_g_object_unref0 (file_info);
#line 2056 "document.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
#line 309 "document.vala"
		g_clear_error (&_inner_error0_);
#line 317 "document.vala"
		result = FALSE;
#line 317 "document.vala"
		_g_free0 (current_etag);
#line 317 "document.vala"
		return result;
#line 2069 "document.c"
	}
	__finally0:
#line 309 "document.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2074 "document.c"
		gboolean _tmp6_ = FALSE;
#line 309 "document.vala"
		_g_free0 (current_etag);
#line 309 "document.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 309 "document.vala"
		g_clear_error (&_inner_error0_);
#line 309 "document.vala"
		return _tmp6_;
#line 2084 "document.c"
	}
#line 320 "document.vala"
	_tmp8_ = current_etag;
#line 320 "document.vala"
	if (_tmp8_ != NULL) {
#line 2090 "document.c"
		const gchar* _tmp9_;
		const gchar* _tmp10_;
#line 320 "document.vala"
		_tmp9_ = current_etag;
#line 320 "document.vala"
		_tmp10_ = self->priv->_etag;
#line 320 "document.vala"
		_tmp7_ = g_strcmp0 (_tmp9_, _tmp10_) != 0;
#line 2099 "document.c"
	} else {
#line 320 "document.vala"
		_tmp7_ = FALSE;
#line 2103 "document.c"
	}
#line 320 "document.vala"
	result = _tmp7_;
#line 320 "document.vala"
	_g_free0 (current_etag);
#line 320 "document.vala"
	return result;
#line 2111 "document.c"
}

void
document_comment_selected_lines (Document* self)
{
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	GtkTextIter _tmp2_;
	GtkTextIter _tmp3_;
#line 323 "document.vala"
	g_return_if_fail (self != NULL);
#line 327 "document.vala"
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &_tmp0_, &_tmp1_);
#line 327 "document.vala"
	start = _tmp0_;
#line 327 "document.vala"
	end = _tmp1_;
#line 329 "document.vala"
	_tmp2_ = start;
#line 329 "document.vala"
	_tmp3_ = end;
#line 329 "document.vala"
	document_comment_between (self, &_tmp2_, &_tmp3_, TRUE);
#line 2137 "document.c"
}

void
document_comment_between (Document* self,
                          GtkTextIter* start_iter,
                          GtkTextIter* end_iter,
                          gboolean end_iter_set)
{
	gint start_line = 0;
	gint end_line = 0;
	GtkTextIter cur_iter = {0};
	GtkTextIter _tmp0_ = {0};
#line 333 "document.vala"
	g_return_if_fail (self != NULL);
#line 333 "document.vala"
	g_return_if_fail (start_iter != NULL);
#line 333 "document.vala"
	g_return_if_fail (end_iter != NULL);
#line 336 "document.vala"
	start_line = gtk_text_iter_get_line (start_iter);
#line 337 "document.vala"
	end_line = start_line;
#line 339 "document.vala"
	if (end_iter_set) {
#line 340 "document.vala"
		end_line = gtk_text_iter_get_line (end_iter);
#line 2164 "document.c"
	}
#line 343 "document.vala"
	gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp0_, start_line);
#line 343 "document.vala"
	cur_iter = _tmp0_;
#line 345 "document.vala"
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) self);
#line 2172 "document.c"
	{
		gint line_num = 0;
#line 347 "document.vala"
		line_num = start_line;
#line 2177 "document.c"
		{
			gboolean _tmp1_ = FALSE;
#line 347 "document.vala"
			_tmp1_ = TRUE;
#line 347 "document.vala"
			while (TRUE) {
#line 347 "document.vala"
				if (!_tmp1_) {
#line 2186 "document.c"
					gint _tmp2_;
#line 347 "document.vala"
					_tmp2_ = line_num;
#line 347 "document.vala"
					line_num = _tmp2_ + 1;
#line 2192 "document.c"
				}
#line 347 "document.vala"
				_tmp1_ = FALSE;
#line 347 "document.vala"
				if (!(line_num <= end_line)) {
#line 347 "document.vala"
					break;
#line 2200 "document.c"
				}
#line 349 "document.vala"
				if (gtk_text_iter_ends_line (&cur_iter)) {
#line 351 "document.vala"
					document_insert (self, &cur_iter, "%", -1);
#line 2206 "document.c"
				} else {
#line 353 "document.vala"
					document_insert (self, &cur_iter, "% ", -1);
#line 2210 "document.c"
				}
#line 355 "document.vala"
				gtk_text_iter_forward_line (&cur_iter);
#line 2214 "document.c"
			}
		}
	}
#line 358 "document.vala"
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) self);
#line 2220 "document.c"
}

void
document_uncomment_selected_lines (Document* self)
{
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextIter _tmp0_ = {0};
	GtkTextIter _tmp1_ = {0};
	gint start_line = 0;
	gint end_line = 0;
	gint line_count = 0;
#line 361 "document.vala"
	g_return_if_fail (self != NULL);
#line 364 "document.vala"
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self, &_tmp0_, &_tmp1_);
#line 364 "document.vala"
	start = _tmp0_;
#line 364 "document.vala"
	end = _tmp1_;
#line 366 "document.vala"
	start_line = gtk_text_iter_get_line (&start);
#line 367 "document.vala"
	end_line = gtk_text_iter_get_line (&end);
#line 368 "document.vala"
	line_count = gtk_text_buffer_get_line_count ((GtkTextBuffer*) self);
#line 370 "document.vala"
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) self);
#line 2249 "document.c"
	{
		gint i = 0;
#line 372 "document.vala"
		i = start_line;
#line 2254 "document.c"
		{
			gboolean _tmp2_ = FALSE;
#line 372 "document.vala"
			_tmp2_ = TRUE;
#line 372 "document.vala"
			while (TRUE) {
#line 2261 "document.c"
				GtkTextIter _tmp4_ = {0};
				gchar* line = NULL;
				GtkTextIter _tmp7_;
				GtkTextIter _tmp8_;
				gchar* _tmp9_;
				gint j = 0;
				gint start_delete = 0;
				gint stop_delete = 0;
				GtkTextIter _tmp18_ = {0};
				GtkTextIter _tmp19_ = {0};
#line 372 "document.vala"
				if (!_tmp2_) {
#line 2274 "document.c"
					gint _tmp3_;
#line 372 "document.vala"
					_tmp3_ = i;
#line 372 "document.vala"
					i = _tmp3_ + 1;
#line 2280 "document.c"
				}
#line 372 "document.vala"
				_tmp2_ = FALSE;
#line 372 "document.vala"
				if (!(i <= end_line)) {
#line 372 "document.vala"
					break;
#line 2288 "document.c"
				}
#line 374 "document.vala"
				gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp4_, i);
#line 374 "document.vala"
				start = _tmp4_;
#line 377 "document.vala"
				if (i == (line_count - 1)) {
#line 2296 "document.c"
					GtkTextIter _tmp5_ = {0};
#line 378 "document.vala"
					gtk_text_buffer_get_end_iter ((GtkTextBuffer*) self, &_tmp5_);
#line 378 "document.vala"
					end = _tmp5_;
#line 2302 "document.c"
				} else {
					GtkTextIter _tmp6_ = {0};
#line 380 "document.vala"
					gtk_text_buffer_get_iter_at_line ((GtkTextBuffer*) self, &_tmp6_, i + 1);
#line 380 "document.vala"
					end = _tmp6_;
#line 2309 "document.c"
				}
#line 382 "document.vala"
				_tmp7_ = start;
#line 382 "document.vala"
				_tmp8_ = end;
#line 382 "document.vala"
				_tmp9_ = gtk_text_buffer_get_text ((GtkTextBuffer*) self, &_tmp7_, &_tmp8_, FALSE);
#line 382 "document.vala"
				line = _tmp9_;
#line 385 "document.vala"
				j = 0;
#line 386 "document.vala"
				start_delete = -1;
#line 387 "document.vala"
				stop_delete = -1;
#line 388 "document.vala"
				while (TRUE) {
#line 2327 "document.c"
					const gchar* _tmp10_;
					const gchar* _tmp11_;
					gint _tmp17_;
#line 388 "document.vala"
					_tmp10_ = line;
#line 388 "document.vala"
					if (!(string_get (_tmp10_, (glong) j) != '\0')) {
#line 388 "document.vala"
						break;
#line 2337 "document.c"
					}
#line 390 "document.vala"
					_tmp11_ = line;
#line 390 "document.vala"
					if (string_get (_tmp11_, (glong) j) == '%') {
#line 2343 "document.c"
						const gchar* _tmp12_;
#line 392 "document.vala"
						start_delete = j;
#line 393 "document.vala"
						stop_delete = j + 1;
#line 394 "document.vala"
						_tmp12_ = line;
#line 394 "document.vala"
						if (string_get (_tmp12_, (glong) (j + 1)) == ' ') {
#line 2353 "document.c"
							gint _tmp13_;
#line 395 "document.vala"
							_tmp13_ = stop_delete;
#line 395 "document.vala"
							stop_delete = _tmp13_ + 1;
#line 2359 "document.c"
						}
#line 396 "document.vala"
						break;
#line 2363 "document.c"
					} else {
						gboolean _tmp14_ = FALSE;
						const gchar* _tmp15_;
#line 399 "document.vala"
						_tmp15_ = line;
#line 399 "document.vala"
						if (string_get (_tmp15_, (glong) j) != ' ') {
#line 2371 "document.c"
							const gchar* _tmp16_;
#line 399 "document.vala"
							_tmp16_ = line;
#line 399 "document.vala"
							_tmp14_ = string_get (_tmp16_, (glong) j) != '\t';
#line 2377 "document.c"
						} else {
#line 399 "document.vala"
							_tmp14_ = FALSE;
#line 2381 "document.c"
						}
#line 399 "document.vala"
						if (_tmp14_) {
#line 400 "document.vala"
							break;
#line 2387 "document.c"
						}
					}
#line 402 "document.vala"
					_tmp17_ = j;
#line 402 "document.vala"
					j = _tmp17_ + 1;
#line 2394 "document.c"
				}
#line 405 "document.vala"
				if (start_delete == -1) {
#line 406 "document.vala"
					_g_free0 (line);
#line 406 "document.vala"
					continue;
#line 2402 "document.c"
				}
#line 408 "document.vala"
				gtk_text_buffer_get_iter_at_line_offset ((GtkTextBuffer*) self, &_tmp18_, i, start_delete);
#line 408 "document.vala"
				start = _tmp18_;
#line 409 "document.vala"
				gtk_text_buffer_get_iter_at_line_offset ((GtkTextBuffer*) self, &_tmp19_, i, stop_delete);
#line 409 "document.vala"
				end = _tmp19_;
#line 410 "document.vala"
				gtk_text_buffer_delete ((GtkTextBuffer*) self, &start, &end);
#line 372 "document.vala"
				_g_free0 (line);
#line 2416 "document.c"
			}
		}
	}
#line 413 "document.vala"
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) self);
#line 2422 "document.c"
}

Project*
document_get_project (Document* self)
{
	gint _tmp0_;
	Projects* _tmp1_;
	Projects* _tmp2_;
	gint _tmp3_;
	Project* _tmp4_;
	Project* _tmp5_;
	Project* result = NULL;
#line 416 "document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 418 "document.vala"
	_tmp0_ = self->priv->_project_id;
#line 418 "document.vala"
	if (_tmp0_ == -1) {
#line 419 "document.vala"
		result = NULL;
#line 419 "document.vala"
		return result;
#line 2445 "document.c"
	}
#line 421 "document.vala"
	_tmp1_ = projects_get_default ();
#line 421 "document.vala"
	_tmp2_ = _tmp1_;
#line 421 "document.vala"
	_tmp3_ = self->priv->_project_id;
#line 421 "document.vala"
	_tmp4_ = projects_get (_tmp2_, _tmp3_);
#line 421 "document.vala"
	_tmp5_ = _tmp4_;
#line 421 "document.vala"
	_projects_unref0 (_tmp2_);
#line 421 "document.vala"
	result = _tmp5_;
#line 421 "document.vala"
	return result;
#line 2463 "document.c"
}

GFile*
document_get_main_file (Document* self)
{
	GFile* _tmp0_;
	Project* project = NULL;
	Project* _tmp1_;
	Project* _tmp2_;
	Project* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	GFile* result = NULL;
#line 424 "document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 426 "document.vala"
	_tmp0_ = self->priv->_location;
#line 426 "document.vala"
	if (_tmp0_ == NULL) {
#line 427 "document.vala"
		result = NULL;
#line 427 "document.vala"
		return result;
#line 2487 "document.c"
	}
#line 429 "document.vala"
	_tmp1_ = document_get_project (self);
#line 429 "document.vala"
	project = _tmp1_;
#line 430 "document.vala"
	_tmp2_ = project;
#line 430 "document.vala"
	if (_tmp2_ == NULL) {
#line 2497 "document.c"
		GFile* _tmp3_;
		GFile* _tmp4_;
#line 431 "document.vala"
		_tmp3_ = self->priv->_location;
#line 431 "document.vala"
		_tmp4_ = _g_object_ref0 (_tmp3_);
#line 431 "document.vala"
		result = _tmp4_;
#line 431 "document.vala"
		_project_free0 (project);
#line 431 "document.vala"
		return result;
#line 2510 "document.c"
	}
#line 433 "document.vala"
	_tmp5_ = project;
#line 433 "document.vala"
	_tmp6_ = (*_tmp5_).main_file;
#line 433 "document.vala"
	_tmp7_ = _g_object_ref0 (_tmp6_);
#line 433 "document.vala"
	result = _tmp7_;
#line 433 "document.vala"
	_project_free0 (project);
#line 433 "document.vala"
	return result;
#line 2524 "document.c"
}

gboolean
document_is_main_file_a_tex_file (Document* self)
{
	GFile* main_file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* path = NULL;
	GFile* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean result = FALSE;
#line 436 "document.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 438 "document.vala"
	_tmp0_ = document_get_main_file (self);
#line 438 "document.vala"
	main_file = _tmp0_;
#line 439 "document.vala"
	_tmp1_ = main_file;
#line 439 "document.vala"
	if (_tmp1_ == NULL) {
#line 440 "document.vala"
		result = FALSE;
#line 440 "document.vala"
		_g_object_unref0 (main_file);
#line 440 "document.vala"
		return result;
#line 2554 "document.c"
	}
#line 442 "document.vala"
	_tmp2_ = main_file;
#line 442 "document.vala"
	_tmp3_ = g_file_get_parse_name (_tmp2_);
#line 442 "document.vala"
	path = _tmp3_;
#line 443 "document.vala"
	_tmp4_ = path;
#line 443 "document.vala"
	result = g_str_has_suffix (_tmp4_, ".tex");
#line 443 "document.vala"
	_g_free0 (path);
#line 443 "document.vala"
	_g_object_unref0 (main_file);
#line 443 "document.vala"
	return result;
#line 2572 "document.c"
}

DocumentStructure*
document_get_structure (Document* self)
{
	DocumentStructure* _tmp0_;
	DocumentStructure* _tmp3_;
	DocumentStructure* _tmp4_;
	DocumentStructure* result = NULL;
#line 446 "document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 448 "document.vala"
	_tmp0_ = self->priv->_structure;
#line 448 "document.vala"
	if (_tmp0_ == NULL) {
#line 2588 "document.c"
		DocumentStructure* _tmp1_;
		DocumentStructure* _tmp2_;
#line 450 "document.vala"
		_tmp1_ = document_structure_new (self);
#line 450 "document.vala"
		_g_object_unref0 (self->priv->_structure);
#line 450 "document.vala"
		self->priv->_structure = _tmp1_;
#line 451 "document.vala"
		_tmp2_ = self->priv->_structure;
#line 451 "document.vala"
		document_structure_parse (_tmp2_);
#line 2601 "document.c"
	}
#line 453 "document.vala"
	_tmp3_ = self->priv->_structure;
#line 453 "document.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 453 "document.vala"
	result = _tmp4_;
#line 453 "document.vala"
	return result;
#line 2611 "document.c"
}

static Block17Data*
block17_data_ref (Block17Data* _data17_)
{
#line 456 "document.vala"
	g_atomic_int_inc (&_data17_->_ref_count_);
#line 456 "document.vala"
	return _data17_;
#line 2621 "document.c"
}

static void
block17_data_unref (void * _userdata_)
{
	Block17Data* _data17_;
	_data17_ = (Block17Data*) _userdata_;
#line 456 "document.vala"
	if (g_atomic_int_dec_and_test (&_data17_->_ref_count_)) {
#line 2631 "document.c"
		Document* self;
#line 456 "document.vala"
		self = _data17_->self;
#line 456 "document.vala"
		_g_object_unref0 (_data17_->infobar);
#line 456 "document.vala"
		_g_object_unref0 (self);
#line 456 "document.vala"
		g_slice_free (Block17Data, _data17_);
#line 2641 "document.c"
	}
}

static void
__lambda27_ (Block17Data* _data17_,
             gint response_id)
{
	Document* self;
	TeplInfoBar* _tmp4_;
#line 488 "document.vala"
	self = _data17_->self;
#line 490 "document.vala"
	if (response_id == ((gint) GTK_RESPONSE_YES)) {
#line 2655 "document.c"
		MainWindow* main_window = NULL;
		DocumentTab* _tmp0_;
		GtkWindow* _tmp1_;
		MainWindow* _tmp2_;
#line 492 "document.vala"
		_tmp0_ = self->tab;
#line 492 "document.vala"
		_tmp1_ = utils_get_toplevel_window ((GtkWidget*) _tmp0_);
#line 492 "document.vala"
		main_window = IS_MAIN_WINDOW (_tmp1_) ? ((MainWindow*) _tmp1_) : NULL;
#line 495 "document.vala"
		_tmp2_ = main_window;
#line 495 "document.vala"
		if (_tmp2_ != NULL) {
#line 2670 "document.c"
			MainWindow* _tmp3_;
#line 496 "document.vala"
			_tmp3_ = main_window;
#line 496 "document.vala"
			main_window_save_document (_tmp3_, self, TRUE);
#line 2676 "document.c"
		}
	}
#line 499 "document.vala"
	_tmp4_ = _data17_->infobar;
#line 499 "document.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp4_);
#line 2683 "document.c"
}

static void
___lambda27__gtk_info_bar_response (GtkInfoBar* _sender,
                                    gint response_id,
                                    gpointer self)
{
#line 488 "document.vala"
	__lambda27_ (self, response_id);
#line 2693 "document.c"
}

gboolean
document_set_tmp_location (Document* self)
{
	Block17Data* _data17_;
	gchar* template = NULL;
	gchar* _tmp0_;
	gchar* tmp_dir = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GFile* _tmp12_;
	GFile* _tmp13_;
	DocumentTab* _tmp14_;
	TeplInfoBar* _tmp15_;
	TeplInfoBar* _tmp16_;
	TeplInfoBar* _tmp17_;
	DocumentTab* _tmp18_;
	TeplInfoBar* _tmp19_;
	TeplInfoBar* _tmp20_;
	TeplInfoBar* _tmp21_;
	GError* _inner_error0_ = NULL;
	gboolean result = FALSE;
#line 456 "document.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 456 "document.vala"
	_data17_ = g_slice_new0 (Block17Data);
#line 456 "document.vala"
	_data17_->_ref_count_ = 1;
#line 456 "document.vala"
	_data17_->self = g_object_ref (self);
#line 459 "document.vala"
	_tmp0_ = g_strdup ("latexila-XXXXXX");
#line 459 "document.vala"
	template = _tmp0_;
#line 2730 "document.c"
	{
		gchar* _tmp1_ = NULL;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp5_;
#line 464 "document.vala"
		_tmp2_ = template;
#line 464 "document.vala"
		_tmp3_ = g_dir_make_tmp (_tmp2_, &_inner_error0_);
#line 464 "document.vala"
		_tmp1_ = _tmp3_;
#line 464 "document.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2744 "document.c"
			gboolean _tmp4_ = FALSE;
#line 464 "document.vala"
			if (_inner_error0_->domain == G_FILE_ERROR) {
#line 2748 "document.c"
				goto __catch0_g_file_error;
			}
#line 464 "document.vala"
			_g_free0 (tmp_dir);
#line 464 "document.vala"
			_g_free0 (template);
#line 464 "document.vala"
			block17_data_unref (_data17_);
#line 464 "document.vala"
			_data17_ = NULL;
#line 464 "document.vala"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 464 "document.vala"
			g_clear_error (&_inner_error0_);
#line 464 "document.vala"
			return _tmp4_;
#line 2765 "document.c"
		}
#line 464 "document.vala"
		_tmp5_ = _tmp1_;
#line 464 "document.vala"
		_tmp1_ = NULL;
#line 464 "document.vala"
		_g_free0 (tmp_dir);
#line 464 "document.vala"
		tmp_dir = _tmp5_;
#line 462 "document.vala"
		_g_free0 (_tmp1_);
#line 2777 "document.c"
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 462 "document.vala"
		e = _inner_error0_;
#line 462 "document.vala"
		_inner_error0_ = NULL;
#line 468 "document.vala"
		_tmp6_ = e;
#line 468 "document.vala"
		_tmp7_ = _tmp6_->message;
#line 468 "document.vala"
		g_warning ("document.vala:468: Impossible to create temporary directory: %s", _tmp7_);
#line 469 "document.vala"
		result = FALSE;
#line 469 "document.vala"
		_g_error_free0 (e);
#line 469 "document.vala"
		_g_free0 (tmp_dir);
#line 469 "document.vala"
		_g_free0 (template);
#line 469 "document.vala"
		block17_data_unref (_data17_);
#line 469 "document.vala"
		_data17_ = NULL;
#line 469 "document.vala"
		return result;
#line 2809 "document.c"
	}
	__finally0:
#line 462 "document.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 2814 "document.c"
		gboolean _tmp8_ = FALSE;
#line 462 "document.vala"
		_g_free0 (tmp_dir);
#line 462 "document.vala"
		_g_free0 (template);
#line 462 "document.vala"
		block17_data_unref (_data17_);
#line 462 "document.vala"
		_data17_ = NULL;
#line 462 "document.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 462 "document.vala"
		g_clear_error (&_inner_error0_);
#line 462 "document.vala"
		return _tmp8_;
#line 2830 "document.c"
	}
#line 473 "document.vala"
	_tmp9_ = tmp_dir;
#line 473 "document.vala"
	_tmp10_ = g_build_filename (_tmp9_, "tmp.tex", NULL);
#line 473 "document.vala"
	_tmp11_ = _tmp10_;
#line 473 "document.vala"
	_tmp12_ = g_file_new_for_path (_tmp11_);
#line 473 "document.vala"
	_tmp13_ = _tmp12_;
#line 473 "document.vala"
	document_set_location (self, _tmp13_);
#line 473 "document.vala"
	_g_object_unref0 (_tmp13_);
#line 473 "document.vala"
	_g_free0 (_tmp11_);
#line 477 "document.vala"
	_tmp14_ = self->tab;
#line 477 "document.vala"
	if (_tmp14_ == NULL) {
#line 478 "document.vala"
		result = TRUE;
#line 478 "document.vala"
		_g_free0 (tmp_dir);
#line 478 "document.vala"
		_g_free0 (template);
#line 478 "document.vala"
		block17_data_unref (_data17_);
#line 478 "document.vala"
		_data17_ = NULL;
#line 478 "document.vala"
		return result;
#line 2864 "document.c"
	}
#line 480 "document.vala"
	_tmp15_ = tepl_info_bar_new_simple (GTK_MESSAGE_WARNING, _ ("The file has a temporary location. The data can be lost after rebootin" \
"g your computer."), _ ("Do you want to save the file in a safer place?"));
#line 480 "document.vala"
	g_object_ref_sink (_tmp15_);
#line 480 "document.vala"
	_data17_->infobar = _tmp15_;
#line 483 "document.vala"
	_tmp16_ = _data17_->infobar;
#line 483 "document.vala"
	gtk_info_bar_add_button ((GtkInfoBar*) _tmp16_, _ ("Save _As"), (gint) GTK_RESPONSE_YES);
#line 484 "document.vala"
	_tmp17_ = _data17_->infobar;
#line 484 "document.vala"
	gtk_info_bar_add_button ((GtkInfoBar*) _tmp17_, _ ("Cancel"), (gint) GTK_RESPONSE_NO);
#line 485 "document.vala"
	_tmp18_ = self->tab;
#line 485 "document.vala"
	_tmp19_ = _data17_->infobar;
#line 485 "document.vala"
	tepl_tab_add_info_bar ((TeplTab*) _tmp18_, (GtkInfoBar*) _tmp19_);
#line 486 "document.vala"
	_tmp20_ = _data17_->infobar;
#line 486 "document.vala"
	gtk_widget_show ((GtkWidget*) _tmp20_);
#line 488 "document.vala"
	_tmp21_ = _data17_->infobar;
#line 488 "document.vala"
	g_signal_connect_data ((GtkInfoBar*) _tmp21_, "response", (GCallback) ___lambda27__gtk_info_bar_response, block17_data_ref (_data17_), (GClosureNotify) block17_data_unref, 0);
#line 502 "document.vala"
	result = TRUE;
#line 502 "document.vala"
	_g_free0 (tmp_dir);
#line 502 "document.vala"
	_g_free0 (template);
#line 502 "document.vala"
	block17_data_unref (_data17_);
#line 502 "document.vala"
	_data17_ = NULL;
#line 502 "document.vala"
	return result;
#line 2906 "document.c"
}

void
document_set_metadata (Document* self,
                       const gchar* key,
                       const gchar* val)
{
	TeplMetadata* _tmp0_;
#line 505 "document.vala"
	g_return_if_fail (self != NULL);
#line 505 "document.vala"
	g_return_if_fail (key != NULL);
#line 507 "document.vala"
	_tmp0_ = tepl_buffer_get_metadata ((TeplBuffer*) self);
#line 507 "document.vala"
	tepl_metadata_set (_tmp0_, key, val);
#line 508 "document.vala"
	tepl_buffer_save_metadata_into_metadata_manager ((TeplBuffer*) self);
#line 2925 "document.c"
}

GFile*
document_get_location (Document* self)
{
	GFile* result;
	GFile* _tmp0_;
#line 24 "document.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 24 "document.vala"
	_tmp0_ = self->priv->_location;
#line 24 "document.vala"
	result = _tmp0_;
#line 24 "document.vala"
	return result;
#line 2941 "document.c"
}

void
document_set_location (Document* self,
                       GFile* value)
{
#line 24 "document.vala"
	g_return_if_fail (self != NULL);
#line 24 "document.vala"
	if (document_get_location (self) != value) {
#line 2952 "document.c"
		GFile* _tmp0_;
#line 24 "document.vala"
		_tmp0_ = _g_object_ref0 (value);
#line 24 "document.vala"
		_g_object_unref0 (self->priv->_location);
#line 24 "document.vala"
		self->priv->_location = _tmp0_;
#line 24 "document.vala"
		g_object_notify_by_pspec ((GObject *) self, document_properties[DOCUMENT_LOCATION_PROPERTY]);
#line 2962 "document.c"
	}
}

gboolean
document_get_readonly (Document* self)
{
	gboolean result;
#line 25 "document.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 25 "document.vala"
	result = self->priv->_readonly;
#line 25 "document.vala"
	return result;
#line 2976 "document.c"
}

void
document_set_readonly (Document* self,
                       gboolean value)
{
#line 25 "document.vala"
	g_return_if_fail (self != NULL);
#line 25 "document.vala"
	if (document_get_readonly (self) != value) {
#line 25 "document.vala"
		self->priv->_readonly = value;
#line 25 "document.vala"
		g_object_notify_by_pspec ((GObject *) self, document_properties[DOCUMENT_READONLY_PROPERTY]);
#line 2991 "document.c"
	}
}

gint
document_get_project_id (Document* self)
{
	gint result;
#line 27 "document.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 27 "document.vala"
	result = self->priv->_project_id;
#line 27 "document.vala"
	return result;
#line 3005 "document.c"
}

void
document_set_project_id (Document* self,
                         gint value)
{
#line 27 "document.vala"
	g_return_if_fail (self != NULL);
#line 27 "document.vala"
	if (document_get_project_id (self) != value) {
#line 27 "document.vala"
		self->priv->_project_id = value;
#line 27 "document.vala"
		g_object_notify_by_pspec ((GObject *) self, document_properties[DOCUMENT_PROJECT_ID_PROPERTY]);
#line 3020 "document.c"
	}
}

static void
document_class_init (DocumentClass * klass,
                     gpointer klass_data)
{
#line 22 "document.vala"
	document_parent_class = g_type_class_peek_parent (klass);
#line 22 "document.vala"
	g_type_class_adjust_private_offset (klass, &Document_private_offset);
#line 22 "document.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_document_get_property;
#line 22 "document.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_document_set_property;
#line 22 "document.vala"
	G_OBJECT_CLASS (klass)->finalize = document_finalize;
#line 22 "document.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_LOCATION_PROPERTY, document_properties[DOCUMENT_LOCATION_PROPERTY] = g_param_spec_object ("location", "location", "location", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "document.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_READONLY_PROPERTY, document_properties[DOCUMENT_READONLY_PROPERTY] = g_param_spec_boolean ("readonly", "readonly", "readonly", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 22 "document.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), DOCUMENT_PROJECT_ID_PROPERTY, document_properties[DOCUMENT_PROJECT_ID_PROPERTY] = g_param_spec_int ("project-id", "project-id", "project-id", G_MININT, G_MAXINT, -1, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 3044 "document.c"
}

static void
document_instance_init (Document * self,
                        gpointer klass)
{
#line 22 "document.vala"
	self->priv = document_get_instance_private (self);
#line 25 "document.vala"
	self->priv->_readonly = FALSE;
#line 27 "document.vala"
	self->priv->_project_id = -1;
#line 28 "document.vala"
	self->priv->backup_made = FALSE;
#line 30 "document.vala"
	self->priv->encoding = NULL;
#line 31 "document.vala"
	self->priv->new_file = TRUE;
#line 32 "document.vala"
	self->priv->_structure = NULL;
#line 3065 "document.c"
}

static void
document_finalize (GObject * obj)
{
	Document * self;
#line 22 "document.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DOCUMENT, Document);
#line 24 "document.vala"
	_g_object_unref0 (self->priv->_location);
#line 29 "document.vala"
	_g_free0 (self->priv->_etag);
#line 30 "document.vala"
	_g_free0 (self->priv->encoding);
#line 32 "document.vala"
	_g_object_unref0 (self->priv->_structure);
#line 22 "document.vala"
	G_OBJECT_CLASS (document_parent_class)->finalize (obj);
#line 3084 "document.c"
}

static GType
document_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DocumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Document), 0, (GInstanceInitFunc) document_instance_init, NULL };
	GType document_type_id;
	document_type_id = g_type_register_static (tepl_buffer_get_type (), "Document", &g_define_type_info, 0);
	Document_private_offset = g_type_add_instance_private (document_type_id, sizeof (DocumentPrivate));
	return document_type_id;
}

GType
document_get_type (void)
{
	static volatile gsize document_type_id__volatile = 0;
	if (g_once_init_enter (&document_type_id__volatile)) {
		GType document_type_id;
		document_type_id = document_get_type_once ();
		g_once_init_leave (&document_type_id__volatile, document_type_id);
	}
	return document_type_id__volatile;
}

static void
_vala_document_get_property (GObject * object,
                             guint property_id,
                             GValue * value,
                             GParamSpec * pspec)
{
	Document * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT, Document);
#line 22 "document.vala"
	switch (property_id) {
#line 22 "document.vala"
		case DOCUMENT_LOCATION_PROPERTY:
#line 22 "document.vala"
		g_value_set_object (value, document_get_location (self));
#line 22 "document.vala"
		break;
#line 22 "document.vala"
		case DOCUMENT_READONLY_PROPERTY:
#line 22 "document.vala"
		g_value_set_boolean (value, document_get_readonly (self));
#line 22 "document.vala"
		break;
#line 22 "document.vala"
		case DOCUMENT_PROJECT_ID_PROPERTY:
#line 22 "document.vala"
		g_value_set_int (value, document_get_project_id (self));
#line 22 "document.vala"
		break;
#line 3137 "document.c"
		default:
#line 22 "document.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "document.vala"
		break;
#line 3143 "document.c"
	}
}

static void
_vala_document_set_property (GObject * object,
                             guint property_id,
                             const GValue * value,
                             GParamSpec * pspec)
{
	Document * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_DOCUMENT, Document);
#line 22 "document.vala"
	switch (property_id) {
#line 22 "document.vala"
		case DOCUMENT_LOCATION_PROPERTY:
#line 22 "document.vala"
		document_set_location (self, g_value_get_object (value));
#line 22 "document.vala"
		break;
#line 22 "document.vala"
		case DOCUMENT_READONLY_PROPERTY:
#line 22 "document.vala"
		document_set_readonly (self, g_value_get_boolean (value));
#line 22 "document.vala"
		break;
#line 22 "document.vala"
		case DOCUMENT_PROJECT_ID_PROPERTY:
#line 22 "document.vala"
		document_set_project_id (self, g_value_get_int (value));
#line 22 "document.vala"
		break;
#line 3175 "document.c"
		default:
#line 22 "document.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 22 "document.vala"
		break;
#line 3181 "document.c"
	}
}

