/* completion.c generated by valac 0.48.9, the Vala compiler
 * generated from completion.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Sébastien Wilmet
 *          Pieter Pareit
 */

#include <glib-object.h>
#include <gtksourceview/gtksource.h>
#include <gio/gio.h>
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtk.h>
#include <latexila.h>
#include <glib/gi18n-lib.h>
#include <tepl/tepl.h>
#include "config.h"

#define TYPE_COMPLETION_PROVIDER (completion_provider_get_type ())
#define COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_PROVIDER, CompletionProvider))
#define COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))
#define IS_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_PROVIDER))
#define IS_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_PROVIDER))
#define COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))

typedef struct _CompletionProvider CompletionProvider;
typedef struct _CompletionProviderClass CompletionProviderClass;
typedef struct _CompletionProviderPrivate CompletionProviderPrivate;

#define COMPLETION_PROVIDER_TYPE_COMPLETION_COMMAND (completion_provider_completion_command_get_type ())
typedef struct _CompletionProviderCompletionCommand CompletionProviderCompletionCommand;

#define COMPLETION_PROVIDER_TYPE_COMPLETION_ARGUMENT (completion_provider_completion_argument_get_type ())
typedef struct _CompletionProviderCompletionArgument CompletionProviderCompletionArgument;

#define COMPLETION_PROVIDER_TYPE_COMPLETION_CHOICE (completion_provider_completion_choice_get_type ())
typedef struct _CompletionProviderCompletionChoice CompletionProviderCompletionChoice;
enum  {
	COMPLETION_PROVIDER_0_PROPERTY,
	COMPLETION_PROVIDER_NUM_PROPERTIES
};
static GParamSpec* completion_provider_properties[COMPLETION_PROVIDER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GtkTextIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTextIter_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define COMPLETION_PROVIDER_TYPE_ARGUMENT_CONTEXT (completion_provider_argument_context_get_type ())
typedef struct _CompletionProviderArgumentContext CompletionProviderArgumentContext;
#define _completion_provider_completion_command_free0(var) ((var == NULL) ? NULL : (var = (completion_provider_completion_command_free (var), NULL)))

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_GLATEX_APP (glatex_app_get_type ())
#define GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GLATEX_APP, GlatexApp))
#define GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GLATEX_APP, GlatexAppClass))
#define IS_GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GLATEX_APP))
#define IS_GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GLATEX_APP))
#define GLATEX_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GLATEX_APP, GlatexAppClass))

typedef struct _GlatexApp GlatexApp;
typedef struct _GlatexAppClass GlatexAppClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _completion_provider_completion_choice_free0(var) ((var == NULL) ? NULL : (var = (completion_provider_completion_choice_free (var), NULL)))
#define _g_markup_parse_context_unref0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _CompletionProvider {
	GObject parent_instance;
	CompletionProviderPrivate * priv;
};

struct _CompletionProviderClass {
	GObjectClass parent_class;
};

struct _CompletionProviderCompletionChoice {
	gchar* name;
	gchar* package;
	gchar* insert;
	gchar* insert_after;
};

struct _CompletionProviderCompletionArgument {
	gchar* label;
	gboolean optional;
	CompletionProviderCompletionChoice* choices;
	gint choices_length1;
	gint _choices_size_;
};

struct _CompletionProviderCompletionCommand {
	gchar* name;
	gchar* package;
	CompletionProviderCompletionArgument* args;
	gint args_length1;
	gint _args_size_;
};

struct _CompletionProviderPrivate {
	GSettings* _settings;
	GList* _proposals;
	GeeHashMap* _commands;
	GeeHashMap* _environments;
	CompletionProviderCompletionCommand _current_command;
	CompletionProviderCompletionArgument _current_arg;
	CompletionProviderCompletionChoice _current_choice;
	GdkPixbuf* _icon_cmd;
	GdkPixbuf* _icon_choice;
	GdkPixbuf* _icon_package_required;
	GtkSourceCompletionInfo* _calltip_window;
	GtkLabel* _calltip_window_label;
};

struct _CompletionProviderArgumentContext {
	gchar* cmd_name;
	gchar* arg_contents;
	GeeArrayList* args_types;
};

struct _Document {
	TeplBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
};

struct _DocumentClass {
	TeplBufferClass parent_class;
};

static gint CompletionProvider_private_offset;
static gpointer completion_provider_parent_class = NULL;
static CompletionProvider* completion_provider__instance;
static CompletionProvider* completion_provider__instance = NULL;
static GtkSourceCompletionProviderIface * completion_provider_gtk_source_completion_provider_parent_iface = NULL;

GType completion_provider_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CompletionProvider, g_object_unref)
static GType completion_provider_completion_command_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType completion_provider_completion_argument_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType completion_provider_completion_choice_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static CompletionProviderCompletionChoice* completion_provider_completion_choice_dup (const CompletionProviderCompletionChoice* self);
static void completion_provider_completion_choice_free (CompletionProviderCompletionChoice* self);
static void completion_provider_completion_choice_copy (const CompletionProviderCompletionChoice* self,
                                                 CompletionProviderCompletionChoice* dest);
static void completion_provider_completion_choice_destroy (CompletionProviderCompletionChoice* self);
static CompletionProviderCompletionArgument* completion_provider_completion_argument_dup (const CompletionProviderCompletionArgument* self);
static void completion_provider_completion_argument_free (CompletionProviderCompletionArgument* self);
static void completion_provider_completion_argument_copy (const CompletionProviderCompletionArgument* self,
                                                   CompletionProviderCompletionArgument* dest);
static void completion_provider_completion_argument_destroy (CompletionProviderCompletionArgument* self);
static CompletionProviderCompletionCommand* completion_provider_completion_command_dup (const CompletionProviderCompletionCommand* self);
static void completion_provider_completion_command_free (CompletionProviderCompletionCommand* self);
static void completion_provider_completion_command_copy (const CompletionProviderCompletionCommand* self,
                                                  CompletionProviderCompletionCommand* dest);
static void completion_provider_completion_command_destroy (CompletionProviderCompletionCommand* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static CompletionProvider* completion_provider_new (void);
static CompletionProvider* completion_provider_construct (GType object_type);
static void completion_provider_load_data (CompletionProvider* self);
CompletionProvider* completion_provider_get_default (void);
static gchar* completion_provider_real_get_name (GtkSourceCompletionProvider* base);
static GtkSourceCompletionActivation completion_provider_real_get_activation (GtkSourceCompletionProvider* base);
static gboolean completion_provider_real_match (GtkSourceCompletionProvider* base,
                                         GtkSourceCompletionContext* context);
static gboolean completion_provider_real_get_start_iter (GtkSourceCompletionProvider* base,
                                                  GtkSourceCompletionContext* context,
                                                  GtkSourceCompletionProposal* proposal,
                                                  GtkTextIter* iter);
static gchar* completion_provider_get_latex_command_at_iter (CompletionProvider* self,
                                                      GtkTextIter* iter);
static void _vala_GtkTextIter_free (GtkTextIter* self);
static void completion_provider_real_populate (GtkSourceCompletionProvider* base,
                                        GtkSourceCompletionContext* context);
static void completion_provider_show_no_proposals (CompletionProvider* self,
                                            GtkSourceCompletionContext* context);
static void completion_provider_populate_command (CompletionProvider* self,
                                           GtkSourceCompletionContext* context,
                                           const gchar* cmd);
static GType completion_provider_argument_context_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static CompletionProviderArgumentContext* completion_provider_argument_context_dup (const CompletionProviderArgumentContext* self);
static void completion_provider_argument_context_free (CompletionProviderArgumentContext* self);
static void completion_provider_argument_context_copy (const CompletionProviderArgumentContext* self,
                                                CompletionProviderArgumentContext* dest);
static void completion_provider_argument_context_destroy (CompletionProviderArgumentContext* self);
static gboolean completion_provider_in_latex_command_argument (CompletionProvider* self,
                                                        GtkTextIter* iter,
                                                        CompletionProviderArgumentContext* info);
static void completion_provider_populate_argument (CompletionProvider* self,
                                            GtkSourceCompletionContext* context,
                                            CompletionProviderArgumentContext* info);
static gboolean completion_provider_is_user_request (CompletionProvider* self,
                                              GtkSourceCompletionContext* context);
static void completion_provider_show_all_proposals (CompletionProvider* self,
                                             GtkSourceCompletionContext* context);
static void completion_provider_show_filtered_proposals (CompletionProvider* self,
                                                  GtkSourceCompletionContext* context,
                                                  GList* proposals_to_filter,
                                                  const gchar* prefix);
static GList* completion_provider_get_argument_proposals (CompletionProvider* self,
                                                   CompletionProviderArgumentContext* arg_context);
static void completion_provider_show_calltip_cmd_prototype (CompletionProvider* self,
                                                     const gchar* arg_cmd,
                                                     GeeArrayList* arguments);
static gchar* completion_provider_get_command_info (CompletionProvider* self,
                                             CompletionProviderCompletionCommand* cmd,
                                             gint cur_arg);
static gint completion_provider_get_argument_num (CompletionProvider* self,
                                           CompletionProviderCompletionArgument* all_args,
                                           gint all_args_length1,
                                           GeeArrayList* args);
static gint completion_provider_compare_proposals (GtkSourceCompletionItem* a,
                                            GtkSourceCompletionItem* b);
static void completion_provider_init_calltip_window (CompletionProvider* self);
static void completion_provider_show_calltip_info (CompletionProvider* self,
                                            const gchar* markup);
GType main_window_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
GType glatex_app_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GlatexApp, g_object_unref)
GlatexApp* glatex_app_get_instance (void);
MainWindow* glatex_app_get_active_main_window (GlatexApp* self);
GType document_view_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentView, g_object_unref)
DocumentView* main_window_get_active_view (MainWindow* self);
static void completion_provider_get_begin_arg_pos (CompletionProvider* self,
                                            GtkTextIter* in_arg_pos,
                                            GtkTextIter* result);
void completion_provider_hide_calltip_window (CompletionProvider* self);
static gboolean completion_provider_real_activate_proposal (GtkSourceCompletionProvider* base,
                                                     GtkSourceCompletionProposal* proposal,
                                                     GtkTextIter* iter);
static void completion_provider_activate_proposal_command_name (CompletionProvider* self,
                                                         GtkSourceCompletionProposal* proposal,
                                                         GtkTextIter* iter,
                                                         const gchar* cmd);
static void completion_provider_activate_proposal_argument_choice (CompletionProvider* self,
                                                            GtkSourceCompletionProposal* proposal,
                                                            GtkTextIter* iter,
                                                            const gchar* arg_cmd,
                                                            const gchar* arg_contents);
static void completion_provider_close_environment (CompletionProvider* self,
                                            const gchar* env_name,
                                            GtkTextIter* iter);
GType document_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
GType document_tab_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
DocumentView* document_tab_get_document_view (DocumentTab* self);
void document_insert (Document* self,
                      GtkTextIter* iter,
                      const gchar* text,
                      gint len);
static gchar* completion_provider_get_text_line_to_iter (CompletionProvider* self,
                                                  GtkTextIter* iter);
gboolean utils_char_is_escaped (const gchar* text,
                                glong char_index);
static gchar* completion_provider_get_latex_command_at_index (CompletionProvider* self,
                                                       const gchar* text,
                                                       gint index);
static gchar* completion_provider_get_command_text_to_insert (CompletionProvider* self,
                                                       CompletionProviderCompletionCommand* cmd);
gchar* utils_load_file (GFile* file);
static void completion_provider_parser_start (CompletionProvider* self,
                                       GMarkupParseContext* context,
                                       const gchar* name,
                                       gchar** attr_names,
                                       gint attr_names_length1,
                                       gchar** attr_values,
                                       gint attr_values_length1,
                                       GError** error);
static void _completion_provider_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context,
                                                                          const gchar* element_name,
                                                                          gchar** attribute_names,
                                                                          gchar** attribute_values,
                                                                          gpointer self,
                                                                          GError** error);
static void completion_provider_parser_end (CompletionProvider* self,
                                     GMarkupParseContext* context,
                                     const gchar* name,
                                     GError** error);
static void _completion_provider_parser_end_gmarkup_parser_end_element_func (GMarkupParseContext* context,
                                                                      const gchar* element_name,
                                                                      gpointer self,
                                                                      GError** error);
static void completion_provider_parser_text (CompletionProvider* self,
                                      GMarkupParseContext* context,
                                      const gchar* text,
                                      gsize text_len,
                                      GError** error);
static void _completion_provider_parser_text_gmarkup_parser_text_func (GMarkupParseContext* context,
                                                                const gchar* text,
                                                                gsize text_len,
                                                                gpointer self,
                                                                GError** error);
static void completion_provider_parser_add_command (CompletionProvider* self,
                                             gchar** attr_names,
                                             gint attr_names_length1,
                                             gchar** attr_values,
                                             gint attr_values_length1,
                                             GError** error);
static void completion_provider_parser_add_argument (CompletionProvider* self,
                                              gchar** attr_names,
                                              gint attr_names_length1,
                                              gchar** attr_values,
                                              gint attr_values_length1,
                                              GError** error);
static void completion_provider_parser_add_choice (CompletionProvider* self,
                                            gchar** attr_names,
                                            gint attr_names_length1,
                                            gchar** attr_values,
                                            gint attr_values_length1,
                                            GError** error);
static void _vala_array_add2 (CompletionProviderCompletionArgument* * array,
                       gint* length,
                       gint* size,
                       const CompletionProviderCompletionArgument* value);
static void _vala_array_add3 (CompletionProviderCompletionChoice* * array,
                       gint* length,
                       gint* size,
                       const CompletionProviderCompletionChoice* value);
static void _vala_CompletionProviderCompletionArgument_array_free (CompletionProviderCompletionArgument * array,
                                                            gint array_length);
static CompletionProviderCompletionArgument* _vala_array_dup1 (CompletionProviderCompletionArgument* self,
                                                        gint length);
static void _vala_CompletionProviderCompletionChoice_array_free (CompletionProviderCompletionChoice * array,
                                                          gint array_length);
static CompletionProviderCompletionChoice* _vala_array_dup2 (CompletionProviderCompletionChoice* self,
                                                      gint length);
static void completion_provider_finalize (GObject * obj);
static GType completion_provider_get_type_once (void);
static gint _vala_array_length (gpointer array);

static inline gpointer
completion_provider_get_instance_private (CompletionProvider* self)
{
	return G_STRUCT_MEMBER_P (self, CompletionProvider_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
#line 64 "completion.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 405 "completion.c"
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
#line 64 "completion.vala"
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
#line 413 "completion.c"
}

static CompletionProvider*
completion_provider_construct (GType object_type)
{
	CompletionProvider * self = NULL;
	GSettings* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
#line 82 "completion.vala"
	self = (CompletionProvider*) g_object_new (object_type, NULL);
#line 84 "completion.vala"
	_tmp0_ = g_settings_new ("org.gnome.gnome-latex.preferences.latex");
#line 84 "completion.vala"
	_g_object_unref0 (self->priv->_settings);
#line 84 "completion.vala"
	self->priv->_settings = _tmp0_;
#line 87 "completion.vala"
	_tmp1_ = latexila_utils_get_pixbuf_from_icon_name ("completion_cmd", GTK_ICON_SIZE_MENU);
#line 87 "completion.vala"
	_g_object_unref0 (self->priv->_icon_cmd);
#line 87 "completion.vala"
	self->priv->_icon_cmd = _tmp1_;
#line 89 "completion.vala"
	_tmp2_ = latexila_utils_get_pixbuf_from_icon_name ("gray-square", GTK_ICON_SIZE_MENU);
#line 89 "completion.vala"
	_g_object_unref0 (self->priv->_icon_choice);
#line 89 "completion.vala"
	self->priv->_icon_choice = _tmp2_;
#line 91 "completion.vala"
	_tmp3_ = latexila_utils_get_pixbuf_from_icon_name ("dialog-warning", GTK_ICON_SIZE_MENU);
#line 91 "completion.vala"
	_g_object_unref0 (self->priv->_icon_package_required);
#line 91 "completion.vala"
	self->priv->_icon_package_required = _tmp3_;
#line 94 "completion.vala"
	completion_provider_load_data (self);
#line 82 "completion.vala"
	return self;
#line 454 "completion.c"
}

static CompletionProvider*
completion_provider_new (void)
{
#line 82 "completion.vala"
	return completion_provider_construct (TYPE_COMPLETION_PROVIDER);
#line 462 "completion.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 102 "completion.vala"
	return self ? g_object_ref (self) : NULL;
#line 470 "completion.c"
}

CompletionProvider*
completion_provider_get_default (void)
{
	CompletionProvider* _tmp0_;
	CompletionProvider* _tmp2_;
	CompletionProvider* _tmp3_;
	CompletionProvider* result = NULL;
#line 99 "completion.vala"
	_tmp0_ = completion_provider__instance;
#line 99 "completion.vala"
	if (_tmp0_ == NULL) {
#line 484 "completion.c"
		CompletionProvider* _tmp1_;
#line 100 "completion.vala"
		_tmp1_ = completion_provider_new ();
#line 100 "completion.vala"
		_g_object_unref0 (completion_provider__instance);
#line 100 "completion.vala"
		completion_provider__instance = _tmp1_;
#line 492 "completion.c"
	}
#line 102 "completion.vala"
	_tmp2_ = completion_provider__instance;
#line 102 "completion.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 102 "completion.vala"
	result = _tmp3_;
#line 102 "completion.vala"
	return result;
#line 502 "completion.c"
}

static gchar*
completion_provider_real_get_name (GtkSourceCompletionProvider* base)
{
	CompletionProvider * self;
	gchar* _tmp0_;
	gchar* result = NULL;
#line 105 "completion.vala"
	self = (CompletionProvider*) base;
#line 107 "completion.vala"
	_tmp0_ = g_strdup ("LaTeX");
#line 107 "completion.vala"
	result = _tmp0_;
#line 107 "completion.vala"
	return result;
#line 519 "completion.c"
}

static GtkSourceCompletionActivation
completion_provider_real_get_activation (GtkSourceCompletionProvider* base)
{
	CompletionProvider * self;
	GtkSourceCompletionActivation activation = 0U;
	GSettings* _tmp0_;
	GtkSourceCompletionActivation result = 0U;
#line 110 "completion.vala"
	self = (CompletionProvider*) base;
#line 112 "completion.vala"
	activation = GTK_SOURCE_COMPLETION_ACTIVATION_USER_REQUESTED;
#line 114 "completion.vala"
	_tmp0_ = self->priv->_settings;
#line 114 "completion.vala"
	if (g_settings_get_boolean (_tmp0_, "interactive-completion")) {
#line 537 "completion.c"
		GtkSourceCompletionActivation _tmp1_;
#line 115 "completion.vala"
		_tmp1_ = activation;
#line 115 "completion.vala"
		activation = _tmp1_ | GTK_SOURCE_COMPLETION_ACTIVATION_INTERACTIVE;
#line 543 "completion.c"
	}
#line 117 "completion.vala"
	result = activation;
#line 117 "completion.vala"
	return result;
#line 549 "completion.c"
}

static gboolean
completion_provider_real_match (GtkSourceCompletionProvider* base,
                                GtkSourceCompletionContext* context)
{
	CompletionProvider * self;
	GtkTextIter iter = {0};
	GtkTextIter _tmp0_ = {0};
	gboolean _tmp1_;
	GtkTextBuffer* buf = NULL;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	gboolean result = FALSE;
#line 120 "completion.vala"
	self = (CompletionProvider*) base;
#line 120 "completion.vala"
	g_return_val_if_fail (context != NULL, FALSE);
#line 124 "completion.vala"
	_tmp1_ = gtk_source_completion_context_get_iter (context, &_tmp0_);
#line 124 "completion.vala"
	iter = _tmp0_;
#line 124 "completion.vala"
	if (!_tmp1_) {
#line 125 "completion.vala"
		result = FALSE;
#line 125 "completion.vala"
		return result;
#line 581 "completion.c"
	}
#line 128 "completion.vala"
	_tmp2_ = gtk_text_iter_get_buffer (&iter);
#line 128 "completion.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 128 "completion.vala"
	buf = _tmp3_;
#line 129 "completion.vala"
	_tmp4_ = buf;
#line 129 "completion.vala"
	_tmp5_ = gtk_text_buffer_get_has_selection (_tmp4_);
#line 129 "completion.vala"
	_tmp6_ = _tmp5_;
#line 129 "completion.vala"
	if (_tmp6_) {
#line 130 "completion.vala"
		result = FALSE;
#line 130 "completion.vala"
		_g_object_unref0 (buf);
#line 130 "completion.vala"
		return result;
#line 603 "completion.c"
	}
#line 132 "completion.vala"
	result = TRUE;
#line 132 "completion.vala"
	_g_object_unref0 (buf);
#line 132 "completion.vala"
	return result;
#line 611 "completion.c"
}

static void
_vala_GtkTextIter_free (GtkTextIter* self)
{
#line 139 "completion.vala"
	g_boxed_free (gtk_text_iter_get_type (), self);
#line 619 "completion.c"
}

static gboolean
completion_provider_real_get_start_iter (GtkSourceCompletionProvider* base,
                                         GtkSourceCompletionContext* context,
                                         GtkSourceCompletionProposal* proposal,
                                         GtkTextIter* iter)
{
	CompletionProvider * self;
	GtkTextIter _vala_iter = {0};
	GtkTextIter _tmp0_ = {0};
	gchar* cmd = NULL;
	GtkTextIter* _tmp1_;
	GtkTextIter* _tmp2_;
	GtkTextIter* _tmp3_;
	GtkTextIter _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	GtkTextIter* _tmp8_;
	GtkTextIter* _tmp9_;
	GtkTextIter* _tmp10_;
	GtkTextIter prev = {0};
	GtkTextIter _tmp11_;
	gboolean _tmp12_ = FALSE;
	GtkTextIter _tmp14_;
	gboolean _tmp15_ = FALSE;
	gboolean result = FALSE;
#line 135 "completion.vala"
	self = (CompletionProvider*) base;
#line 135 "completion.vala"
	g_return_val_if_fail (context != NULL, FALSE);
#line 135 "completion.vala"
	g_return_val_if_fail (proposal != NULL, FALSE);
#line 138 "completion.vala"
	_vala_iter = _tmp0_;
#line 139 "completion.vala"
	g_object_get (context, "iter", &_tmp1_, NULL);
#line 139 "completion.vala"
	_tmp2_ = _tmp1_;
#line 139 "completion.vala"
	_tmp3_ = _tmp2_;
#line 139 "completion.vala"
	_tmp4_ = *_tmp3_;
#line 139 "completion.vala"
	_tmp5_ = completion_provider_get_latex_command_at_iter (self, &_tmp4_);
#line 139 "completion.vala"
	_tmp6_ = _tmp5_;
#line 139 "completion.vala"
	__vala_GtkTextIter_free0 (_tmp3_);
#line 139 "completion.vala"
	cmd = _tmp6_;
#line 142 "completion.vala"
	_tmp7_ = cmd;
#line 142 "completion.vala"
	if (_tmp7_ == NULL) {
#line 143 "completion.vala"
		result = FALSE;
#line 143 "completion.vala"
		_g_free0 (cmd);
#line 143 "completion.vala"
		if (iter) {
#line 143 "completion.vala"
			*iter = _vala_iter;
#line 684 "completion.c"
		}
#line 143 "completion.vala"
		return result;
#line 688 "completion.c"
	}
#line 146 "completion.vala"
	g_object_get (context, "iter", &_tmp8_, NULL);
#line 146 "completion.vala"
	_tmp9_ = _tmp8_;
#line 146 "completion.vala"
	_tmp10_ = _tmp9_;
#line 146 "completion.vala"
	_vala_iter = *_tmp10_;
#line 146 "completion.vala"
	__vala_GtkTextIter_free0 (_tmp10_);
#line 148 "completion.vala"
	_tmp11_ = _vala_iter;
#line 148 "completion.vala"
	prev = _tmp11_;
#line 149 "completion.vala"
	if (gtk_text_iter_backward_char (&prev)) {
#line 149 "completion.vala"
		_tmp12_ = gtk_text_iter_get_char (&prev) == ((gunichar) '\\');
#line 708 "completion.c"
	} else {
#line 149 "completion.vala"
		_tmp12_ = FALSE;
#line 712 "completion.c"
	}
#line 149 "completion.vala"
	if (_tmp12_) {
#line 716 "completion.c"
		GtkTextIter _tmp13_;
#line 151 "completion.vala"
		_tmp13_ = prev;
#line 151 "completion.vala"
		_vala_iter = _tmp13_;
#line 152 "completion.vala"
		result = TRUE;
#line 152 "completion.vala"
		_g_free0 (cmd);
#line 152 "completion.vala"
		if (iter) {
#line 152 "completion.vala"
			*iter = _vala_iter;
#line 730 "completion.c"
		}
#line 152 "completion.vala"
		return result;
#line 734 "completion.c"
	}
#line 155 "completion.vala"
	if (!gtk_text_iter_starts_word (&_vala_iter)) {
#line 156 "completion.vala"
		gtk_text_iter_backward_visible_word_start (&_vala_iter);
#line 740 "completion.c"
	}
#line 158 "completion.vala"
	_tmp14_ = _vala_iter;
#line 158 "completion.vala"
	prev = _tmp14_;
#line 159 "completion.vala"
	if (gtk_text_iter_backward_char (&prev)) {
#line 159 "completion.vala"
		_tmp15_ = gtk_text_iter_get_char (&prev) == ((gunichar) '\\');
#line 750 "completion.c"
	} else {
#line 159 "completion.vala"
		_tmp15_ = FALSE;
#line 754 "completion.c"
	}
#line 159 "completion.vala"
	if (_tmp15_) {
#line 758 "completion.c"
		GtkTextIter _tmp16_;
#line 160 "completion.vala"
		_tmp16_ = prev;
#line 160 "completion.vala"
		_vala_iter = _tmp16_;
#line 764 "completion.c"
	}
#line 162 "completion.vala"
	result = TRUE;
#line 162 "completion.vala"
	_g_free0 (cmd);
#line 162 "completion.vala"
	if (iter) {
#line 162 "completion.vala"
		*iter = _vala_iter;
#line 774 "completion.c"
	}
#line 162 "completion.vala"
	return result;
#line 778 "completion.c"
}

/*************************************************************************/
static void
completion_provider_real_populate (GtkSourceCompletionProvider* base,
                                   GtkSourceCompletionContext* context)
{
	CompletionProvider * self;
	GtkTextIter iter = {0};
	GtkTextIter _tmp0_ = {0};
	gboolean _tmp1_;
	gchar* cmd = NULL;
	GtkTextIter _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	CompletionProviderArgumentContext info = {0};
	gboolean in_arg = FALSE;
	GtkTextIter _tmp6_;
	CompletionProviderArgumentContext _tmp7_ = {0};
	gboolean _tmp8_;
#line 168 "completion.vala"
	self = (CompletionProvider*) base;
#line 168 "completion.vala"
	g_return_if_fail (context != NULL);
#line 172 "completion.vala"
	_tmp1_ = gtk_source_completion_context_get_iter (context, &_tmp0_);
#line 172 "completion.vala"
	iter = _tmp0_;
#line 172 "completion.vala"
	if (!_tmp1_) {
#line 174 "completion.vala"
		completion_provider_show_no_proposals (self, context);
#line 175 "completion.vala"
		return;
#line 813 "completion.c"
	}
#line 179 "completion.vala"
	_tmp2_ = iter;
#line 179 "completion.vala"
	_tmp3_ = completion_provider_get_latex_command_at_iter (self, &_tmp2_);
#line 179 "completion.vala"
	cmd = _tmp3_;
#line 181 "completion.vala"
	_tmp4_ = cmd;
#line 181 "completion.vala"
	if (_tmp4_ != NULL) {
#line 825 "completion.c"
		const gchar* _tmp5_;
#line 183 "completion.vala"
		_tmp5_ = cmd;
#line 183 "completion.vala"
		completion_provider_populate_command (self, context, _tmp5_);
#line 184 "completion.vala"
		_g_free0 (cmd);
#line 184 "completion.vala"
		return;
#line 835 "completion.c"
	}
#line 189 "completion.vala"
	_tmp6_ = iter;
#line 189 "completion.vala"
	_tmp8_ = completion_provider_in_latex_command_argument (self, &_tmp6_, &_tmp7_);
#line 189 "completion.vala"
	completion_provider_argument_context_destroy (&info);
#line 189 "completion.vala"
	info = _tmp7_;
#line 189 "completion.vala"
	in_arg = _tmp8_;
#line 191 "completion.vala"
	if (in_arg) {
#line 849 "completion.c"
		CompletionProviderArgumentContext _tmp9_;
#line 193 "completion.vala"
		_tmp9_ = info;
#line 193 "completion.vala"
		completion_provider_populate_argument (self, context, &_tmp9_);
#line 194 "completion.vala"
		completion_provider_argument_context_destroy (&info);
#line 194 "completion.vala"
		_g_free0 (cmd);
#line 194 "completion.vala"
		return;
#line 861 "completion.c"
	}
#line 198 "completion.vala"
	if (completion_provider_is_user_request (self, context)) {
#line 199 "completion.vala"
		completion_provider_show_all_proposals (self, context);
#line 867 "completion.c"
	} else {
#line 201 "completion.vala"
		completion_provider_show_no_proposals (self, context);
#line 871 "completion.c"
	}
#line 168 "completion.vala"
	completion_provider_argument_context_destroy (&info);
#line 168 "completion.vala"
	_g_free0 (cmd);
#line 877 "completion.c"
}

static void
completion_provider_populate_command (CompletionProvider* self,
                                      GtkSourceCompletionContext* context,
                                      const gchar* cmd)
{
	GList* _tmp4_;
#line 204 "completion.vala"
	g_return_if_fail (self != NULL);
#line 204 "completion.vala"
	g_return_if_fail (context != NULL);
#line 204 "completion.vala"
	g_return_if_fail (cmd != NULL);
#line 206 "completion.vala"
	if (!completion_provider_is_user_request (self, context)) {
#line 894 "completion.c"
		guint min_nb_chars = 0U;
		GSettings* _tmp0_;
		guint _tmp1_ = 0U;
		gint _tmp2_;
		gint _tmp3_;
#line 209 "completion.vala"
		_tmp0_ = self->priv->_settings;
#line 209 "completion.vala"
		g_settings_get (_tmp0_, "interactive-completion-num", "u", &_tmp1_);
#line 209 "completion.vala"
		min_nb_chars = _tmp1_;
#line 211 "completion.vala"
		_tmp2_ = strlen (cmd);
#line 211 "completion.vala"
		_tmp3_ = _tmp2_;
#line 211 "completion.vala"
		if (((guint) _tmp3_) <= min_nb_chars) {
#line 213 "completion.vala"
			completion_provider_show_no_proposals (self, context);
#line 214 "completion.vala"
			return;
#line 916 "completion.c"
		}
	}
#line 218 "completion.vala"
	if (g_strcmp0 (cmd, "\\") == 0) {
#line 220 "completion.vala"
		completion_provider_show_all_proposals (self, context);
#line 221 "completion.vala"
		return;
#line 925 "completion.c"
	}
#line 224 "completion.vala"
	_tmp4_ = self->priv->_proposals;
#line 224 "completion.vala"
	completion_provider_show_filtered_proposals (self, context, _tmp4_, cmd);
#line 931 "completion.c"
}

static void
completion_provider_populate_argument (CompletionProvider* self,
                                       GtkSourceCompletionContext* context,
                                       CompletionProviderArgumentContext* info)
{
	GeeHashMap* _tmp0_;
	CompletionProviderArgumentContext _tmp1_;
	const gchar* _tmp2_;
	GList* proposals_to_filter = NULL;
	CompletionProviderArgumentContext _tmp3_;
	GList* _tmp4_;
	GList* _tmp5_;
	GList* _tmp10_;
	CompletionProviderArgumentContext _tmp11_;
	const gchar* _tmp12_;
#line 227 "completion.vala"
	g_return_if_fail (self != NULL);
#line 227 "completion.vala"
	g_return_if_fail (context != NULL);
#line 227 "completion.vala"
	g_return_if_fail (info != NULL);
#line 230 "completion.vala"
	_tmp0_ = self->priv->_commands;
#line 230 "completion.vala"
	_tmp1_ = *info;
#line 230 "completion.vala"
	_tmp2_ = _tmp1_.cmd_name;
#line 230 "completion.vala"
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp2_)) {
#line 232 "completion.vala"
		completion_provider_show_no_proposals (self, context);
#line 233 "completion.vala"
		return;
#line 967 "completion.c"
	}
#line 236 "completion.vala"
	_tmp3_ = *info;
#line 236 "completion.vala"
	_tmp4_ = completion_provider_get_argument_proposals (self, &_tmp3_);
#line 236 "completion.vala"
	proposals_to_filter = _tmp4_;
#line 239 "completion.vala"
	_tmp5_ = proposals_to_filter;
#line 239 "completion.vala"
	if (_tmp5_ == NULL) {
#line 241 "completion.vala"
		if (completion_provider_is_user_request (self, context)) {
#line 981 "completion.c"
			CompletionProviderArgumentContext _tmp6_;
			const gchar* _tmp7_;
			CompletionProviderArgumentContext _tmp8_;
			GeeArrayList* _tmp9_;
#line 242 "completion.vala"
			_tmp6_ = *info;
#line 242 "completion.vala"
			_tmp7_ = _tmp6_.cmd_name;
#line 242 "completion.vala"
			_tmp8_ = *info;
#line 242 "completion.vala"
			_tmp9_ = _tmp8_.args_types;
#line 242 "completion.vala"
			completion_provider_show_calltip_cmd_prototype (self, _tmp7_, _tmp9_);
#line 996 "completion.c"
		} else {
#line 244 "completion.vala"
			completion_provider_show_no_proposals (self, context);
#line 1000 "completion.c"
		}
#line 245 "completion.vala"
		return;
#line 1004 "completion.c"
	}
#line 248 "completion.vala"
	_tmp10_ = proposals_to_filter;
#line 248 "completion.vala"
	_tmp11_ = *info;
#line 248 "completion.vala"
	_tmp12_ = _tmp11_.arg_contents;
#line 248 "completion.vala"
	completion_provider_show_filtered_proposals (self, context, _tmp10_, _tmp12_);
#line 1014 "completion.c"
}

static GList*
completion_provider_get_argument_proposals (CompletionProvider* self,
                                            CompletionProviderArgumentContext* arg_context)
{
	GeeHashMap* _tmp0_;
	CompletionProviderArgumentContext _tmp1_;
	const gchar* _tmp2_;
	CompletionProviderCompletionCommand cmd = {0};
	GeeHashMap* _tmp3_;
	CompletionProviderArgumentContext _tmp4_;
	const gchar* _tmp5_;
	gpointer _tmp6_;
	CompletionProviderCompletionCommand* _tmp7_;
	CompletionProviderCompletionCommand _tmp8_;
	CompletionProviderCompletionCommand _tmp9_ = {0};
	CompletionProviderCompletionCommand _tmp10_;
	gchar* cmd_info = NULL;
	CompletionProviderCompletionCommand _tmp11_;
	gchar* _tmp12_;
	gint arg_num = 0;
	CompletionProviderCompletionCommand _tmp13_;
	CompletionProviderCompletionArgument* _tmp14_;
	gint _tmp14__length1;
	CompletionProviderArgumentContext _tmp15_;
	GeeArrayList* _tmp16_;
	CompletionProviderCompletionArgument arg = {0};
	CompletionProviderCompletionCommand _tmp17_;
	CompletionProviderCompletionArgument* _tmp18_;
	gint _tmp18__length1;
	CompletionProviderCompletionArgument _tmp19_;
	CompletionProviderCompletionArgument _tmp20_;
	CompletionProviderCompletionArgument _tmp21_ = {0};
	GList* items = NULL;
	CompletionProviderCompletionArgument _tmp22_;
	CompletionProviderCompletionChoice* _tmp23_;
	gint _tmp23__length1;
	GList* _tmp53_;
	GList* _tmp54_;
	GList* result = NULL;
#line 251 "completion.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 251 "completion.vala"
	g_return_val_if_fail (arg_context != NULL, NULL);
#line 254 "completion.vala"
	_tmp0_ = self->priv->_commands;
#line 254 "completion.vala"
	_tmp1_ = *arg_context;
#line 254 "completion.vala"
	_tmp2_ = _tmp1_.cmd_name;
#line 254 "completion.vala"
	g_return_val_if_fail (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp2_), NULL);
#line 256 "completion.vala"
	_tmp3_ = self->priv->_commands;
#line 256 "completion.vala"
	_tmp4_ = *arg_context;
#line 256 "completion.vala"
	_tmp5_ = _tmp4_.cmd_name;
#line 256 "completion.vala"
	_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp5_);
#line 256 "completion.vala"
	_tmp7_ = (CompletionProviderCompletionCommand*) _tmp6_;
#line 256 "completion.vala"
	_tmp8_ = *_tmp7_;
#line 256 "completion.vala"
	completion_provider_completion_command_copy (&_tmp8_, &_tmp9_);
#line 256 "completion.vala"
	_tmp10_ = _tmp9_;
#line 256 "completion.vala"
	_completion_provider_completion_command_free0 (_tmp7_);
#line 256 "completion.vala"
	cmd = _tmp10_;
#line 257 "completion.vala"
	_tmp11_ = cmd;
#line 257 "completion.vala"
	_tmp12_ = completion_provider_get_command_info (self, &_tmp11_, -1);
#line 257 "completion.vala"
	cmd_info = _tmp12_;
#line 259 "completion.vala"
	_tmp13_ = cmd;
#line 259 "completion.vala"
	_tmp14_ = _tmp13_.args;
#line 259 "completion.vala"
	_tmp14__length1 = _tmp13_.args_length1;
#line 259 "completion.vala"
	_tmp15_ = *arg_context;
#line 259 "completion.vala"
	_tmp16_ = _tmp15_.args_types;
#line 259 "completion.vala"
	arg_num = completion_provider_get_argument_num (self, _tmp14_, (gint) _tmp14__length1, _tmp16_);
#line 260 "completion.vala"
	if (arg_num == -1) {
#line 261 "completion.vala"
		result = NULL;
#line 261 "completion.vala"
		_g_free0 (cmd_info);
#line 261 "completion.vala"
		completion_provider_completion_command_destroy (&cmd);
#line 261 "completion.vala"
		return result;
#line 1116 "completion.c"
	}
#line 263 "completion.vala"
	_tmp17_ = cmd;
#line 263 "completion.vala"
	_tmp18_ = _tmp17_.args;
#line 263 "completion.vala"
	_tmp18__length1 = _tmp17_.args_length1;
#line 263 "completion.vala"
	_tmp19_ = _tmp18_[arg_num - 1];
#line 263 "completion.vala"
	_tmp20_ = _tmp19_;
#line 263 "completion.vala"
	completion_provider_completion_argument_copy (&_tmp20_, &_tmp21_);
#line 263 "completion.vala"
	arg = _tmp21_;
#line 264 "completion.vala"
	items = NULL;
#line 266 "completion.vala"
	_tmp22_ = arg;
#line 266 "completion.vala"
	_tmp23_ = _tmp22_.choices;
#line 266 "completion.vala"
	_tmp23__length1 = _tmp22_.choices_length1;
#line 1140 "completion.c"
	{
		CompletionProviderCompletionChoice* choice_collection = NULL;
		gint choice_collection_length1 = 0;
		gint _choice_collection_size_ = 0;
		gint choice_it = 0;
#line 266 "completion.vala"
		choice_collection = _tmp23_;
#line 266 "completion.vala"
		choice_collection_length1 = _tmp23__length1;
#line 266 "completion.vala"
		for (choice_it = 0; choice_it < choice_collection_length1; choice_it = choice_it + 1) {
#line 1152 "completion.c"
			CompletionProviderCompletionChoice _tmp24_;
			CompletionProviderCompletionChoice _tmp25_ = {0};
			CompletionProviderCompletionChoice choice = {0};
#line 266 "completion.vala"
			_tmp24_ = choice_collection[choice_it];
#line 266 "completion.vala"
			completion_provider_completion_choice_copy (&_tmp24_, &_tmp25_);
#line 266 "completion.vala"
			choice = _tmp25_;
#line 1162 "completion.c"
			{
				GdkPixbuf* pixbuf = NULL;
				gchar* arg_info = NULL;
				CompletionProviderCompletionChoice _tmp26_;
				const gchar* _tmp27_;
				GtkSourceCompletionItem* item = NULL;
				GtkSourceCompletionItem* _tmp38_;
				GtkSourceCompletionItem* _tmp39_;
				CompletionProviderCompletionChoice _tmp40_;
				const gchar* _tmp41_;
				GtkSourceCompletionItem* _tmp42_;
				CompletionProviderCompletionChoice _tmp43_;
				const gchar* _tmp44_;
				GtkSourceCompletionItem* _tmp45_;
				GdkPixbuf* _tmp46_;
				const gchar* _tmp47_ = NULL;
				const gchar* _tmp48_;
				GtkSourceCompletionItem* _tmp50_;
				GtkSourceCompletionItem* _tmp51_;
				GtkSourceCompletionItem* _tmp52_;
#line 269 "completion.vala"
				arg_info = NULL;
#line 270 "completion.vala"
				_tmp26_ = choice;
#line 270 "completion.vala"
				_tmp27_ = _tmp26_.package;
#line 270 "completion.vala"
				if (_tmp27_ != NULL) {
#line 1191 "completion.c"
					GdkPixbuf* _tmp28_;
					GdkPixbuf* _tmp29_;
					const gchar* _tmp30_;
					gchar* _tmp31_;
					gchar* _tmp32_;
					CompletionProviderCompletionChoice _tmp33_;
					const gchar* _tmp34_;
					gchar* _tmp35_;
#line 272 "completion.vala"
					_tmp28_ = self->priv->_icon_package_required;
#line 272 "completion.vala"
					_tmp29_ = _g_object_ref0 (_tmp28_);
#line 272 "completion.vala"
					_g_object_unref0 (pixbuf);
#line 272 "completion.vala"
					pixbuf = _tmp29_;
#line 273 "completion.vala"
					_tmp30_ = cmd_info;
#line 273 "completion.vala"
					_tmp31_ = g_strconcat (_tmp30_, "\nPackage: ", NULL);
#line 273 "completion.vala"
					_tmp32_ = _tmp31_;
#line 273 "completion.vala"
					_tmp33_ = choice;
#line 273 "completion.vala"
					_tmp34_ = _tmp33_.package;
#line 273 "completion.vala"
					_tmp35_ = g_strconcat (_tmp32_, _tmp34_, NULL);
#line 273 "completion.vala"
					_g_free0 (arg_info);
#line 273 "completion.vala"
					arg_info = _tmp35_;
#line 273 "completion.vala"
					_g_free0 (_tmp32_);
#line 1226 "completion.c"
				} else {
					GdkPixbuf* _tmp36_;
					GdkPixbuf* _tmp37_;
#line 276 "completion.vala"
					_tmp36_ = self->priv->_icon_choice;
#line 276 "completion.vala"
					_tmp37_ = _g_object_ref0 (_tmp36_);
#line 276 "completion.vala"
					_g_object_unref0 (pixbuf);
#line 276 "completion.vala"
					pixbuf = _tmp37_;
#line 1238 "completion.c"
				}
#line 278 "completion.vala"
				_tmp38_ = gtk_source_completion_item_new ();
#line 278 "completion.vala"
				item = _tmp38_;
#line 279 "completion.vala"
				_tmp39_ = item;
#line 279 "completion.vala"
				_tmp40_ = choice;
#line 279 "completion.vala"
				_tmp41_ = _tmp40_.name;
#line 279 "completion.vala"
				gtk_source_completion_item_set_label (_tmp39_, _tmp41_);
#line 280 "completion.vala"
				_tmp42_ = item;
#line 280 "completion.vala"
				_tmp43_ = choice;
#line 280 "completion.vala"
				_tmp44_ = _tmp43_.name;
#line 280 "completion.vala"
				gtk_source_completion_item_set_text (_tmp42_, _tmp44_);
#line 281 "completion.vala"
				_tmp45_ = item;
#line 281 "completion.vala"
				_tmp46_ = pixbuf;
#line 281 "completion.vala"
				gtk_source_completion_item_set_icon (_tmp45_, _tmp46_);
#line 282 "completion.vala"
				_tmp48_ = arg_info;
#line 282 "completion.vala"
				_tmp47_ = _tmp48_;
#line 282 "completion.vala"
				if (_tmp47_ == NULL) {
#line 1272 "completion.c"
					const gchar* _tmp49_;
#line 282 "completion.vala"
					_tmp49_ = cmd_info;
#line 282 "completion.vala"
					_tmp47_ = _tmp49_;
#line 1278 "completion.c"
				}
#line 282 "completion.vala"
				_tmp50_ = item;
#line 282 "completion.vala"
				gtk_source_completion_item_set_info (_tmp50_, _tmp47_);
#line 283 "completion.vala"
				_tmp51_ = item;
#line 283 "completion.vala"
				_tmp52_ = _g_object_ref0 (_tmp51_);
#line 283 "completion.vala"
				items = g_list_prepend (items, _tmp52_);
#line 266 "completion.vala"
				_g_object_unref0 (item);
#line 266 "completion.vala"
				_g_free0 (arg_info);
#line 266 "completion.vala"
				_g_object_unref0 (pixbuf);
#line 266 "completion.vala"
				completion_provider_completion_choice_destroy (&choice);
#line 1298 "completion.c"
			}
		}
	}
#line 286 "completion.vala"
	_tmp53_ = items;
#line 286 "completion.vala"
	if (_tmp53_ == NULL) {
#line 287 "completion.vala"
		result = NULL;
#line 287 "completion.vala"
		completion_provider_completion_argument_destroy (&arg);
#line 287 "completion.vala"
		_g_free0 (cmd_info);
#line 287 "completion.vala"
		completion_provider_completion_command_destroy (&cmd);
#line 287 "completion.vala"
		return result;
#line 1316 "completion.c"
	}
#line 289 "completion.vala"
	items = g_list_sort (items, (GCompareFunc) completion_provider_compare_proposals);
#line 290 "completion.vala"
	_tmp54_ = items;
#line 290 "completion.vala"
	result = _tmp54_;
#line 290 "completion.vala"
	completion_provider_completion_argument_destroy (&arg);
#line 290 "completion.vala"
	_g_free0 (cmd_info);
#line 290 "completion.vala"
	completion_provider_completion_command_destroy (&cmd);
#line 290 "completion.vala"
	return result;
#line 1332 "completion.c"
}

static void
completion_provider_show_no_proposals (CompletionProvider* self,
                                       GtkSourceCompletionContext* context)
{
#line 294 "completion.vala"
	g_return_if_fail (self != NULL);
#line 294 "completion.vala"
	g_return_if_fail (context != NULL);
#line 296 "completion.vala"
	gtk_source_completion_context_add_proposals (context, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_completion_provider_get_type (), GtkSourceCompletionProvider), NULL, TRUE);
#line 1345 "completion.c"
}

static void
completion_provider_show_all_proposals (CompletionProvider* self,
                                        GtkSourceCompletionContext* context)
{
	GList* _tmp0_;
#line 299 "completion.vala"
	g_return_if_fail (self != NULL);
#line 299 "completion.vala"
	g_return_if_fail (context != NULL);
#line 301 "completion.vala"
	_tmp0_ = self->priv->_proposals;
#line 301 "completion.vala"
	gtk_source_completion_context_add_proposals (context, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_completion_provider_get_type (), GtkSourceCompletionProvider), _tmp0_, TRUE);
#line 1361 "completion.c"
}

static void
completion_provider_show_filtered_proposals (CompletionProvider* self,
                                             GtkSourceCompletionContext* context,
                                             GList* proposals_to_filter,
                                             const gchar* prefix)
{
	gboolean _tmp0_ = FALSE;
	GList* filtered_proposals = NULL;
	GList* _tmp9_;
	GList* _tmp15_;
#line 304 "completion.vala"
	g_return_if_fail (self != NULL);
#line 304 "completion.vala"
	g_return_if_fail (context != NULL);
#line 308 "completion.vala"
	if (prefix == NULL) {
#line 308 "completion.vala"
		_tmp0_ = TRUE;
#line 1382 "completion.c"
	} else {
#line 308 "completion.vala"
		_tmp0_ = g_strcmp0 (prefix, "") == 0;
#line 1386 "completion.c"
	}
#line 308 "completion.vala"
	if (_tmp0_) {
#line 310 "completion.vala"
		gtk_source_completion_context_add_proposals (context, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_completion_provider_get_type (), GtkSourceCompletionProvider), proposals_to_filter, TRUE);
#line 312 "completion.vala"
		return;
#line 1394 "completion.c"
	}
#line 318 "completion.vala"
	filtered_proposals = NULL;
#line 1398 "completion.c"
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
#line 319 "completion.vala"
		item_collection = proposals_to_filter;
#line 319 "completion.vala"
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
#line 1406 "completion.c"
			GtkSourceCompletionItem* _tmp1_;
			GtkSourceCompletionItem* item = NULL;
#line 319 "completion.vala"
			_tmp1_ = _g_object_ref0 ((GtkSourceCompletionItem*) item_it->data);
#line 319 "completion.vala"
			item = _tmp1_;
#line 1413 "completion.c"
			{
				GtkSourceCompletionItem* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gboolean _tmp6_;
#line 321 "completion.vala"
				_tmp2_ = item;
#line 321 "completion.vala"
				g_object_get (_tmp2_, "text", &_tmp3_, NULL);
#line 321 "completion.vala"
				_tmp4_ = _tmp3_;
#line 321 "completion.vala"
				_tmp5_ = _tmp4_;
#line 321 "completion.vala"
				_tmp6_ = g_str_has_prefix (_tmp5_, prefix);
#line 321 "completion.vala"
				_g_free0 (_tmp5_);
#line 321 "completion.vala"
				if (_tmp6_) {
#line 1434 "completion.c"
					GtkSourceCompletionItem* _tmp7_;
					GtkSourceCompletionItem* _tmp8_;
#line 322 "completion.vala"
					_tmp7_ = item;
#line 322 "completion.vala"
					_tmp8_ = _g_object_ref0 (_tmp7_);
#line 322 "completion.vala"
					filtered_proposals = g_list_prepend (filtered_proposals, _tmp8_);
#line 1443 "completion.c"
				}
#line 319 "completion.vala"
				_g_object_unref0 (item);
#line 1447 "completion.c"
			}
		}
	}
#line 327 "completion.vala"
	_tmp9_ = filtered_proposals;
#line 327 "completion.vala"
	if (_tmp9_ != NULL) {
#line 328 "completion.vala"
		filtered_proposals = g_list_reverse (filtered_proposals);
#line 1457 "completion.c"
	} else {
		GtkSourceCompletionItem* dummy_proposal = NULL;
		GtkSourceCompletionItem* _tmp10_;
		GtkSourceCompletionItem* _tmp11_;
		GtkSourceCompletionItem* _tmp12_;
		GtkSourceCompletionItem* _tmp13_;
		GtkSourceCompletionItem* _tmp14_;
#line 333 "completion.vala"
		_tmp10_ = gtk_source_completion_item_new ();
#line 333 "completion.vala"
		dummy_proposal = _tmp10_;
#line 334 "completion.vala"
		_tmp11_ = dummy_proposal;
#line 334 "completion.vala"
		gtk_source_completion_item_set_label (_tmp11_, _ ("No matching proposal"));
#line 335 "completion.vala"
		_tmp12_ = dummy_proposal;
#line 335 "completion.vala"
		gtk_source_completion_item_set_text (_tmp12_, "");
#line 336 "completion.vala"
		_tmp13_ = dummy_proposal;
#line 336 "completion.vala"
		_tmp14_ = _g_object_ref0 (_tmp13_);
#line 336 "completion.vala"
		filtered_proposals = g_list_prepend (filtered_proposals, _tmp14_);
#line 327 "completion.vala"
		_g_object_unref0 (dummy_proposal);
#line 1485 "completion.c"
	}
#line 339 "completion.vala"
	_tmp15_ = filtered_proposals;
#line 339 "completion.vala"
	gtk_source_completion_context_add_proposals (context, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_completion_provider_get_type (), GtkSourceCompletionProvider), _tmp15_, TRUE);
#line 304 "completion.vala"
	(filtered_proposals == NULL) ? NULL : (filtered_proposals = (_g_list_free__g_object_unref0_ (filtered_proposals), NULL));
#line 1493 "completion.c"
}

/*************************************************************************/
static void
completion_provider_init_calltip_window (CompletionProvider* self)
{
	GtkSourceCompletionInfo* _tmp0_;
	GtkLabel* _tmp1_;
	GtkSourceCompletionInfo* _tmp2_;
	GtkLabel* _tmp3_;
#line 345 "completion.vala"
	g_return_if_fail (self != NULL);
#line 347 "completion.vala"
	_tmp0_ = gtk_source_completion_info_new ();
#line 347 "completion.vala"
	g_object_ref_sink (_tmp0_);
#line 347 "completion.vala"
	_g_object_unref0 (self->priv->_calltip_window);
#line 347 "completion.vala"
	self->priv->_calltip_window = _tmp0_;
#line 348 "completion.vala"
	_tmp1_ = (GtkLabel*) gtk_label_new (NULL);
#line 348 "completion.vala"
	g_object_ref_sink (_tmp1_);
#line 348 "completion.vala"
	_g_object_unref0 (self->priv->_calltip_window_label);
#line 348 "completion.vala"
	self->priv->_calltip_window_label = _tmp1_;
#line 349 "completion.vala"
	_tmp2_ = self->priv->_calltip_window;
#line 349 "completion.vala"
	_tmp3_ = self->priv->_calltip_window_label;
#line 349 "completion.vala"
	gtk_container_add ((GtkContainer*) _tmp2_, (GtkWidget*) _tmp3_);
#line 1528 "completion.c"
}

static void
completion_provider_show_calltip_cmd_prototype (CompletionProvider* self,
                                                const gchar* arg_cmd,
                                                GeeArrayList* arguments)
{
	GeeHashMap* _tmp0_;
	CompletionProviderCompletionCommand command = {0};
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	CompletionProviderCompletionCommand* _tmp3_;
	CompletionProviderCompletionCommand _tmp4_;
	CompletionProviderCompletionCommand _tmp5_ = {0};
	CompletionProviderCompletionCommand _tmp6_;
	gint arg_num = 0;
	CompletionProviderCompletionCommand _tmp7_;
	CompletionProviderCompletionArgument* _tmp8_;
	gint _tmp8__length1;
#line 353 "completion.vala"
	g_return_if_fail (self != NULL);
#line 353 "completion.vala"
	g_return_if_fail (arg_cmd != NULL);
#line 353 "completion.vala"
	g_return_if_fail (arguments != NULL);
#line 356 "completion.vala"
	_tmp0_ = self->priv->_commands;
#line 356 "completion.vala"
	g_return_if_fail (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, arg_cmd));
#line 358 "completion.vala"
	_tmp1_ = self->priv->_commands;
#line 358 "completion.vala"
	_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, arg_cmd);
#line 358 "completion.vala"
	_tmp3_ = (CompletionProviderCompletionCommand*) _tmp2_;
#line 358 "completion.vala"
	_tmp4_ = *_tmp3_;
#line 358 "completion.vala"
	completion_provider_completion_command_copy (&_tmp4_, &_tmp5_);
#line 358 "completion.vala"
	_tmp6_ = _tmp5_;
#line 358 "completion.vala"
	_completion_provider_completion_command_free0 (_tmp3_);
#line 358 "completion.vala"
	command = _tmp6_;
#line 359 "completion.vala"
	_tmp7_ = command;
#line 359 "completion.vala"
	_tmp8_ = _tmp7_.args;
#line 359 "completion.vala"
	_tmp8__length1 = _tmp7_.args_length1;
#line 359 "completion.vala"
	arg_num = completion_provider_get_argument_num (self, _tmp8_, (gint) _tmp8__length1, arguments);
#line 360 "completion.vala"
	if (arg_num != -1) {
#line 1584 "completion.c"
		gchar* info = NULL;
		CompletionProviderCompletionCommand _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
#line 362 "completion.vala"
		_tmp9_ = command;
#line 362 "completion.vala"
		_tmp10_ = completion_provider_get_command_info (self, &_tmp9_, arg_num);
#line 362 "completion.vala"
		info = _tmp10_;
#line 363 "completion.vala"
		_tmp11_ = info;
#line 363 "completion.vala"
		completion_provider_show_calltip_info (self, _tmp11_);
#line 360 "completion.vala"
		_g_free0 (info);
#line 1601 "completion.c"
	}
#line 353 "completion.vala"
	completion_provider_completion_command_destroy (&command);
#line 1605 "completion.c"
}

static void
completion_provider_show_calltip_info (CompletionProvider* self,
                                       const gchar* markup)
{
	GtkSourceCompletionInfo* _tmp0_;
	GtkLabel* _tmp1_;
	MainWindow* window = NULL;
	GlatexApp* _tmp2_;
	GlatexApp* _tmp3_;
	MainWindow* _tmp4_;
	MainWindow* _tmp5_;
	GtkSourceCompletionInfo* _tmp6_;
	GtkSourceCompletionInfo* _tmp7_;
	DocumentView* _tmp8_;
	DocumentView* _tmp9_;
	GtkTextIter cursor_pos = {0};
	GtkTextBuffer* buffer = NULL;
	DocumentView* _tmp10_;
	DocumentView* _tmp11_;
	GtkTextBuffer* _tmp12_;
	GtkTextBuffer* _tmp13_;
	GtkTextBuffer* _tmp14_;
	GtkTextMark* _tmp15_;
	GtkTextIter _tmp16_ = {0};
	GtkTextIter begin_arg_pos = {0};
	GtkTextIter _tmp17_;
	GtkTextIter _tmp18_ = {0};
	GtkSourceCompletionInfo* _tmp19_;
	DocumentView* _tmp20_;
	DocumentView* _tmp21_;
	GtkTextIter _tmp22_;
	GtkSourceCompletionInfo* _tmp23_;
#line 367 "completion.vala"
	g_return_if_fail (self != NULL);
#line 367 "completion.vala"
	g_return_if_fail (markup != NULL);
#line 369 "completion.vala"
	_tmp0_ = self->priv->_calltip_window;
#line 369 "completion.vala"
	if (_tmp0_ == NULL) {
#line 370 "completion.vala"
		completion_provider_init_calltip_window (self);
#line 1650 "completion.c"
	}
#line 372 "completion.vala"
	_tmp1_ = self->priv->_calltip_window_label;
#line 372 "completion.vala"
	gtk_label_set_markup (_tmp1_, markup);
#line 374 "completion.vala"
	_tmp2_ = glatex_app_get_instance ();
#line 374 "completion.vala"
	_tmp3_ = _tmp2_;
#line 374 "completion.vala"
	_tmp4_ = glatex_app_get_active_main_window (_tmp3_);
#line 374 "completion.vala"
	_tmp5_ = _tmp4_;
#line 374 "completion.vala"
	_g_object_unref0 (_tmp3_);
#line 374 "completion.vala"
	window = _tmp5_;
#line 375 "completion.vala"
	g_return_if_fail (window != NULL);
#line 377 "completion.vala"
	_tmp6_ = self->priv->_calltip_window;
#line 377 "completion.vala"
	gtk_window_set_transient_for ((GtkWindow*) _tmp6_, (GtkWindow*) window);
#line 378 "completion.vala"
	_tmp7_ = self->priv->_calltip_window;
#line 378 "completion.vala"
	_tmp8_ = main_window_get_active_view (window);
#line 378 "completion.vala"
	_tmp9_ = _tmp8_;
#line 378 "completion.vala"
	gtk_window_set_attached_to ((GtkWindow*) _tmp7_, (GtkWidget*) _tmp9_);
#line 382 "completion.vala"
	_tmp10_ = main_window_get_active_view (window);
#line 382 "completion.vala"
	_tmp11_ = _tmp10_;
#line 382 "completion.vala"
	_tmp12_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp11_);
#line 382 "completion.vala"
	_tmp13_ = _tmp12_;
#line 382 "completion.vala"
	_tmp14_ = _g_object_ref0 (_tmp13_);
#line 382 "completion.vala"
	buffer = _tmp14_;
#line 383 "completion.vala"
	_tmp15_ = gtk_text_buffer_get_insert (buffer);
#line 383 "completion.vala"
	gtk_text_buffer_get_iter_at_mark (buffer, &_tmp16_, _tmp15_);
#line 383 "completion.vala"
	cursor_pos = _tmp16_;
#line 384 "completion.vala"
	_tmp17_ = cursor_pos;
#line 384 "completion.vala"
	completion_provider_get_begin_arg_pos (self, &_tmp17_, &_tmp18_);
#line 384 "completion.vala"
	begin_arg_pos = _tmp18_;
#line 385 "completion.vala"
	_tmp19_ = self->priv->_calltip_window;
#line 385 "completion.vala"
	_tmp20_ = main_window_get_active_view (window);
#line 385 "completion.vala"
	_tmp21_ = _tmp20_;
#line 385 "completion.vala"
	_tmp22_ = begin_arg_pos;
#line 385 "completion.vala"
	gtk_source_completion_info_move_to_iter (_tmp19_, (GtkTextView*) _tmp21_, &_tmp22_);
#line 387 "completion.vala"
	_tmp23_ = self->priv->_calltip_window;
#line 387 "completion.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp23_);
#line 367 "completion.vala"
	_g_object_unref0 (buffer);
#line 367 "completion.vala"
	_g_object_unref0 (window);
#line 1724 "completion.c"
}

void
completion_provider_hide_calltip_window (CompletionProvider* self)
{
	GtkSourceCompletionInfo* _tmp0_;
#line 390 "completion.vala"
	g_return_if_fail (self != NULL);
#line 392 "completion.vala"
	_tmp0_ = self->priv->_calltip_window;
#line 392 "completion.vala"
	if (_tmp0_ != NULL) {
#line 1737 "completion.c"
		GtkSourceCompletionInfo* _tmp1_;
#line 393 "completion.vala"
		_tmp1_ = self->priv->_calltip_window;
#line 393 "completion.vala"
		gtk_widget_hide ((GtkWidget*) _tmp1_);
#line 1743 "completion.c"
	}
}

/*************************************************************************/
static gboolean
completion_provider_real_activate_proposal (GtkSourceCompletionProvider* base,
                                            GtkSourceCompletionProposal* proposal,
                                            GtkTextIter* iter)
{
	CompletionProvider * self;
	gchar* text = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	gchar* cmd = NULL;
	GtkTextIter _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	const gchar* _tmp7_;
	gboolean result = FALSE;
#line 399 "completion.vala"
	self = (CompletionProvider*) base;
#line 399 "completion.vala"
	g_return_val_if_fail (proposal != NULL, FALSE);
#line 399 "completion.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 401 "completion.vala"
	_tmp0_ = gtk_source_completion_proposal_get_text (proposal);
#line 401 "completion.vala"
	text = _tmp0_;
#line 402 "completion.vala"
	_tmp2_ = text;
#line 402 "completion.vala"
	if (_tmp2_ == NULL) {
#line 402 "completion.vala"
		_tmp1_ = TRUE;
#line 1780 "completion.c"
	} else {
		const gchar* _tmp3_;
#line 402 "completion.vala"
		_tmp3_ = text;
#line 402 "completion.vala"
		_tmp1_ = g_strcmp0 (_tmp3_, "") == 0;
#line 1787 "completion.c"
	}
#line 402 "completion.vala"
	if (_tmp1_) {
#line 403 "completion.vala"
		result = TRUE;
#line 403 "completion.vala"
		_g_free0 (text);
#line 403 "completion.vala"
		return result;
#line 1797 "completion.c"
	}
#line 405 "completion.vala"
	_tmp4_ = *iter;
#line 405 "completion.vala"
	_tmp5_ = completion_provider_get_latex_command_at_iter (self, &_tmp4_);
#line 405 "completion.vala"
	cmd = _tmp5_;
#line 408 "completion.vala"
	_tmp7_ = cmd;
#line 408 "completion.vala"
	if (_tmp7_ != NULL) {
#line 408 "completion.vala"
		_tmp6_ = TRUE;
#line 1811 "completion.c"
	} else {
		const gchar* _tmp8_;
#line 408 "completion.vala"
		_tmp8_ = text;
#line 408 "completion.vala"
		_tmp6_ = g_str_has_prefix (_tmp8_, "\\");
#line 1818 "completion.c"
	}
#line 408 "completion.vala"
	if (_tmp6_) {
#line 1822 "completion.c"
		GtkTextIter _tmp9_;
		const gchar* _tmp10_;
#line 409 "completion.vala"
		_tmp9_ = *iter;
#line 409 "completion.vala"
		_tmp10_ = cmd;
#line 409 "completion.vala"
		completion_provider_activate_proposal_command_name (self, proposal, &_tmp9_, _tmp10_);
#line 1831 "completion.c"
	} else {
		CompletionProviderArgumentContext info = {0};
		GtkTextIter _tmp11_;
		CompletionProviderArgumentContext _tmp12_ = {0};
		gboolean _tmp13_;
#line 415 "completion.vala"
		_tmp11_ = *iter;
#line 415 "completion.vala"
		_tmp13_ = completion_provider_in_latex_command_argument (self, &_tmp11_, &_tmp12_);
#line 415 "completion.vala"
		completion_provider_argument_context_destroy (&info);
#line 415 "completion.vala"
		info = _tmp12_;
#line 415 "completion.vala"
		if (_tmp13_) {
#line 1847 "completion.c"
			GtkTextIter _tmp14_;
			CompletionProviderArgumentContext _tmp15_;
			const gchar* _tmp16_;
			CompletionProviderArgumentContext _tmp17_;
			const gchar* _tmp18_;
#line 417 "completion.vala"
			_tmp14_ = *iter;
#line 417 "completion.vala"
			_tmp15_ = info;
#line 417 "completion.vala"
			_tmp16_ = _tmp15_.cmd_name;
#line 417 "completion.vala"
			_tmp17_ = info;
#line 417 "completion.vala"
			_tmp18_ = _tmp17_.arg_contents;
#line 417 "completion.vala"
			completion_provider_activate_proposal_argument_choice (self, proposal, &_tmp14_, _tmp16_, _tmp18_);
#line 1865 "completion.c"
		} else {
#line 421 "completion.vala"
			g_warning ("completion.vala:421: Not in a LaTeX command argument.");
#line 1869 "completion.c"
		}
#line 408 "completion.vala"
		completion_provider_argument_context_destroy (&info);
#line 1873 "completion.c"
	}
#line 424 "completion.vala"
	result = TRUE;
#line 424 "completion.vala"
	_g_free0 (cmd);
#line 424 "completion.vala"
	_g_free0 (text);
#line 424 "completion.vala"
	return result;
#line 1883 "completion.c"
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result = NULL;
#line 1480 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1481 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1481 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1481 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1482 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1483 "glib-2.0.vapi"
		start = string_length + start;
#line 1910 "completion.c"
	}
#line 1485 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1486 "glib-2.0.vapi"
		end = string_length + end;
#line 1916 "completion.c"
	}
#line 1488 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1488 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 1922 "completion.c"
	} else {
#line 1488 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 1926 "completion.c"
	}
#line 1488 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1489 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1489 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 1934 "completion.c"
	} else {
#line 1489 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 1938 "completion.c"
	}
#line 1489 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1490 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1491 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1491 "glib-2.0.vapi"
	result = _tmp4_;
#line 1491 "glib-2.0.vapi"
	return result;
#line 1950 "completion.c"
}

static void
completion_provider_activate_proposal_command_name (CompletionProvider* self,
                                                    GtkSourceCompletionProposal* proposal,
                                                    GtkTextIter* iter,
                                                    const gchar* cmd)
{
	gchar* text = NULL;
	gchar* _tmp0_;
	gint _tmp1_ = 0;
	glong index_start = 0L;
	gchar* text_to_insert = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_;
	GtkTextBuffer* doc = NULL;
	GtkTextBuffer* _tmp9_;
	GtkTextBuffer* _tmp10_;
	GtkTextMark* old_pos_mark = NULL;
	GtkTextBuffer* _tmp11_;
	GtkTextIter _tmp12_;
	GtkTextMark* _tmp13_;
	GtkTextMark* _tmp14_;
	GtkTextBuffer* _tmp15_;
	GtkTextBuffer* _tmp16_;
	const gchar* _tmp17_;
	GtkTextBuffer* _tmp18_;
	GtkTextIter old_pos_iter = {0};
	GtkTextBuffer* _tmp19_;
	GtkTextMark* _tmp20_;
	GtkTextIter _tmp21_ = {0};
	GtkTextBuffer* _tmp22_;
	GtkTextMark* _tmp23_;
	GtkTextIter match_end = {0};
	GtkTextIter _tmp24_;
	GtkTextIter _tmp25_ = {0};
	gboolean _tmp26_;
#line 427 "completion.vala"
	g_return_if_fail (self != NULL);
#line 427 "completion.vala"
	g_return_if_fail (proposal != NULL);
#line 427 "completion.vala"
	g_return_if_fail (iter != NULL);
#line 430 "completion.vala"
	_tmp0_ = gtk_source_completion_proposal_get_text (proposal);
#line 430 "completion.vala"
	text = _tmp0_;
#line 432 "completion.vala"
	if (cmd != NULL) {
#line 2003 "completion.c"
		gint _tmp2_;
		gint _tmp3_;
#line 432 "completion.vala"
		_tmp2_ = strlen (cmd);
#line 432 "completion.vala"
		_tmp3_ = _tmp2_;
#line 432 "completion.vala"
		_tmp1_ = _tmp3_;
#line 2012 "completion.c"
	} else {
#line 432 "completion.vala"
		_tmp1_ = 0;
#line 2016 "completion.c"
	}
#line 432 "completion.vala"
	index_start = (glong) _tmp1_;
#line 433 "completion.vala"
	_tmp4_ = text;
#line 433 "completion.vala"
	_tmp5_ = text;
#line 433 "completion.vala"
	_tmp6_ = strlen (_tmp5_);
#line 433 "completion.vala"
	_tmp7_ = _tmp6_;
#line 433 "completion.vala"
	_tmp8_ = string_slice (_tmp4_, index_start, (glong) _tmp7_);
#line 433 "completion.vala"
	text_to_insert = _tmp8_;
#line 436 "completion.vala"
	_tmp9_ = gtk_text_iter_get_buffer (iter);
#line 436 "completion.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 436 "completion.vala"
	doc = _tmp10_;
#line 437 "completion.vala"
	_tmp11_ = doc;
#line 437 "completion.vala"
	_tmp12_ = *iter;
#line 437 "completion.vala"
	_tmp13_ = gtk_text_buffer_create_mark (_tmp11_, NULL, &_tmp12_, TRUE);
#line 437 "completion.vala"
	_tmp14_ = _g_object_ref0 (_tmp13_);
#line 437 "completion.vala"
	old_pos_mark = _tmp14_;
#line 439 "completion.vala"
	_tmp15_ = doc;
#line 439 "completion.vala"
	gtk_text_buffer_begin_user_action (_tmp15_);
#line 440 "completion.vala"
	_tmp16_ = doc;
#line 440 "completion.vala"
	_tmp17_ = text_to_insert;
#line 440 "completion.vala"
	gtk_text_buffer_insert (_tmp16_, iter, _tmp17_, -1);
#line 441 "completion.vala"
	_tmp18_ = doc;
#line 441 "completion.vala"
	gtk_text_buffer_end_user_action (_tmp18_);
#line 445 "completion.vala"
	_tmp19_ = doc;
#line 445 "completion.vala"
	_tmp20_ = old_pos_mark;
#line 445 "completion.vala"
	gtk_text_buffer_get_iter_at_mark (_tmp19_, &_tmp21_, _tmp20_);
#line 445 "completion.vala"
	old_pos_iter = _tmp21_;
#line 446 "completion.vala"
	_tmp22_ = doc;
#line 446 "completion.vala"
	_tmp23_ = old_pos_mark;
#line 446 "completion.vala"
	gtk_text_buffer_delete_mark (_tmp22_, _tmp23_);
#line 449 "completion.vala"
	_tmp24_ = *iter;
#line 449 "completion.vala"
	_tmp26_ = gtk_text_iter_forward_search (&old_pos_iter, "{", GTK_TEXT_SEARCH_TEXT_ONLY | GTK_TEXT_SEARCH_VISIBLE_ONLY, NULL, &_tmp25_, &_tmp24_);
#line 449 "completion.vala"
	match_end = _tmp25_;
#line 449 "completion.vala"
	if (_tmp26_) {
#line 2084 "completion.c"
		GtkTextBuffer* _tmp27_;
		GtkTextIter _tmp28_;
#line 453 "completion.vala"
		_tmp27_ = doc;
#line 453 "completion.vala"
		_tmp28_ = match_end;
#line 453 "completion.vala"
		gtk_text_buffer_place_cursor (_tmp27_, &_tmp28_);
#line 2093 "completion.c"
	}
#line 427 "completion.vala"
	_g_object_unref0 (old_pos_mark);
#line 427 "completion.vala"
	_g_object_unref0 (doc);
#line 427 "completion.vala"
	_g_free0 (text_to_insert);
#line 427 "completion.vala"
	_g_free0 (text);
#line 2103 "completion.c"
}

static void
completion_provider_activate_proposal_argument_choice (CompletionProvider* self,
                                                       GtkSourceCompletionProposal* proposal,
                                                       GtkTextIter* iter,
                                                       const gchar* arg_cmd,
                                                       const gchar* arg_contents)
{
	gchar* text = NULL;
	gchar* _tmp0_;
	gint _tmp1_ = 0;
	glong index_start = 0L;
	gchar* text_to_insert = NULL;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	gchar* _tmp8_;
	GtkTextBuffer* doc = NULL;
	GtkTextBuffer* _tmp9_;
	GtkTextBuffer* _tmp10_;
	GtkTextBuffer* _tmp11_;
	GtkTextBuffer* _tmp12_;
	const gchar* _tmp13_;
	GtkTextBuffer* _tmp19_;
#line 457 "completion.vala"
	g_return_if_fail (self != NULL);
#line 457 "completion.vala"
	g_return_if_fail (proposal != NULL);
#line 457 "completion.vala"
	g_return_if_fail (iter != NULL);
#line 457 "completion.vala"
	g_return_if_fail (arg_cmd != NULL);
#line 460 "completion.vala"
	_tmp0_ = gtk_source_completion_proposal_get_text (proposal);
#line 460 "completion.vala"
	text = _tmp0_;
#line 462 "completion.vala"
	if (arg_contents != NULL) {
#line 2144 "completion.c"
		gint _tmp2_;
		gint _tmp3_;
#line 462 "completion.vala"
		_tmp2_ = strlen (arg_contents);
#line 462 "completion.vala"
		_tmp3_ = _tmp2_;
#line 462 "completion.vala"
		_tmp1_ = _tmp3_;
#line 2153 "completion.c"
	} else {
#line 462 "completion.vala"
		_tmp1_ = 0;
#line 2157 "completion.c"
	}
#line 462 "completion.vala"
	index_start = (glong) _tmp1_;
#line 463 "completion.vala"
	_tmp4_ = text;
#line 463 "completion.vala"
	_tmp5_ = text;
#line 463 "completion.vala"
	_tmp6_ = strlen (_tmp5_);
#line 463 "completion.vala"
	_tmp7_ = _tmp6_;
#line 463 "completion.vala"
	_tmp8_ = string_slice (_tmp4_, index_start, (glong) _tmp7_);
#line 463 "completion.vala"
	text_to_insert = _tmp8_;
#line 465 "completion.vala"
	_tmp9_ = gtk_text_iter_get_buffer (iter);
#line 465 "completion.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 465 "completion.vala"
	doc = _tmp10_;
#line 466 "completion.vala"
	_tmp11_ = doc;
#line 466 "completion.vala"
	gtk_text_buffer_begin_user_action (_tmp11_);
#line 467 "completion.vala"
	_tmp12_ = doc;
#line 467 "completion.vala"
	_tmp13_ = text_to_insert;
#line 467 "completion.vala"
	gtk_text_buffer_insert (_tmp12_, iter, _tmp13_, -1);
#line 470 "completion.vala"
	if (g_strcmp0 (arg_cmd, "\\begin") == 0) {
#line 2191 "completion.c"
		GtkTextBuffer* _tmp15_;
		GtkTextBuffer* _tmp16_;
		const gchar* _tmp17_;
		GtkTextIter _tmp18_;
#line 473 "completion.vala"
		if (gtk_text_iter_get_char (iter) == ((gunichar) '}')) {
#line 474 "completion.vala"
			gtk_text_iter_forward_char (iter);
#line 2200 "completion.c"
		} else {
			GtkTextBuffer* _tmp14_;
#line 476 "completion.vala"
			_tmp14_ = doc;
#line 476 "completion.vala"
			gtk_text_buffer_insert (_tmp14_, iter, "}", -1);
#line 2207 "completion.c"
		}
#line 481 "completion.vala"
		_tmp15_ = doc;
#line 481 "completion.vala"
		gtk_text_buffer_end_user_action (_tmp15_);
#line 482 "completion.vala"
		_tmp16_ = doc;
#line 482 "completion.vala"
		gtk_text_buffer_begin_user_action (_tmp16_);
#line 483 "completion.vala"
		_tmp17_ = text;
#line 483 "completion.vala"
		_tmp18_ = *iter;
#line 483 "completion.vala"
		completion_provider_close_environment (self, _tmp17_, &_tmp18_);
#line 2223 "completion.c"
	} else {
	}
#line 491 "completion.vala"
	_tmp19_ = doc;
#line 491 "completion.vala"
	gtk_text_buffer_end_user_action (_tmp19_);
#line 457 "completion.vala"
	_g_object_unref0 (doc);
#line 457 "completion.vala"
	_g_free0 (text_to_insert);
#line 457 "completion.vala"
	_g_free0 (text);
#line 2236 "completion.c"
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
#line 1570 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1571 "glib-2.0.vapi"
	result = self;
#line 1571 "glib-2.0.vapi"
	return result;
#line 2249 "completion.c"
}

static void
completion_provider_close_environment (CompletionProvider* self,
                                       const gchar* env_name,
                                       GtkTextIter* iter)
{
	Document* doc = NULL;
	GtkTextBuffer* _tmp0_;
	Document* _tmp1_;
	gchar* cur_indent = NULL;
	GtkTextIter _tmp2_;
	gchar* _tmp3_;
	gchar* indent = NULL;
	Document* _tmp4_;
	DocumentTab* _tmp5_;
	DocumentView* _tmp6_;
	DocumentView* _tmp7_;
	gchar* _tmp8_;
	CompletionProviderCompletionChoice* env = NULL;
	GeeHashMap* _tmp9_;
	gpointer _tmp10_;
	Document* _tmp11_;
	Document* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gboolean _tmp19_ = FALSE;
	CompletionProviderCompletionChoice* _tmp20_;
	GtkTextMark* cursor_pos = NULL;
	Document* _tmp26_;
	GtkTextIter _tmp27_;
	GtkTextMark* _tmp28_;
	GtkTextMark* _tmp29_;
	gboolean _tmp30_ = FALSE;
	CompletionProviderCompletionChoice* _tmp31_;
	Document* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	Document* _tmp43_;
	GtkTextMark* _tmp44_;
	GtkTextIter _tmp45_ = {0};
	Document* _tmp46_;
	GtkTextMark* _tmp47_;
	Document* _tmp48_;
	GtkTextIter _tmp49_;
	Document* _tmp50_;
#line 494 "completion.vala"
	g_return_if_fail (self != NULL);
#line 494 "completion.vala"
	g_return_if_fail (env_name != NULL);
#line 494 "completion.vala"
	g_return_if_fail (iter != NULL);
#line 496 "completion.vala"
	_tmp0_ = gtk_text_iter_get_buffer (iter);
#line 496 "completion.vala"
	_tmp1_ = _g_object_ref0 (IS_DOCUMENT (_tmp0_) ? ((Document*) _tmp0_) : NULL);
#line 496 "completion.vala"
	doc = _tmp1_;
#line 498 "completion.vala"
	_tmp2_ = *iter;
#line 498 "completion.vala"
	_tmp3_ = tepl_iter_get_line_indentation (&_tmp2_);
#line 498 "completion.vala"
	cur_indent = _tmp3_;
#line 499 "completion.vala"
	_tmp4_ = doc;
#line 499 "completion.vala"
	_tmp5_ = _tmp4_->tab;
#line 499 "completion.vala"
	_tmp6_ = document_tab_get_document_view (_tmp5_);
#line 499 "completion.vala"
	_tmp7_ = _tmp6_;
#line 499 "completion.vala"
	_tmp8_ = latexila_view_get_indentation_style ((GtkSourceView*) _tmp7_);
#line 499 "completion.vala"
	indent = _tmp8_;
#line 501 "completion.vala"
	_tmp9_ = self->priv->_environments;
#line 501 "completion.vala"
	_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, env_name);
#line 501 "completion.vala"
	env = (CompletionProviderCompletionChoice*) _tmp10_;
#line 503 "completion.vala"
	_tmp11_ = doc;
#line 503 "completion.vala"
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) _tmp11_);
#line 505 "completion.vala"
	_tmp12_ = doc;
#line 505 "completion.vala"
	_tmp13_ = cur_indent;
#line 505 "completion.vala"
	_tmp14_ = string_to_string (_tmp13_);
#line 505 "completion.vala"
	_tmp15_ = indent;
#line 505 "completion.vala"
	_tmp16_ = string_to_string (_tmp15_);
#line 505 "completion.vala"
	_tmp17_ = g_strconcat ("\n", _tmp14_, _tmp16_, NULL);
#line 505 "completion.vala"
	_tmp18_ = _tmp17_;
#line 505 "completion.vala"
	document_insert (_tmp12_, iter, _tmp18_, -1);
#line 505 "completion.vala"
	_g_free0 (_tmp18_);
#line 507 "completion.vala"
	_tmp20_ = env;
#line 507 "completion.vala"
	if (_tmp20_ != NULL) {
#line 2365 "completion.c"
		CompletionProviderCompletionChoice* _tmp21_;
		const gchar* _tmp22_;
#line 507 "completion.vala"
		_tmp21_ = env;
#line 507 "completion.vala"
		_tmp22_ = (*_tmp21_).insert;
#line 507 "completion.vala"
		_tmp19_ = _tmp22_ != NULL;
#line 2374 "completion.c"
	} else {
#line 507 "completion.vala"
		_tmp19_ = FALSE;
#line 2378 "completion.c"
	}
#line 507 "completion.vala"
	if (_tmp19_) {
#line 2382 "completion.c"
		Document* _tmp23_;
		CompletionProviderCompletionChoice* _tmp24_;
		const gchar* _tmp25_;
#line 508 "completion.vala"
		_tmp23_ = doc;
#line 508 "completion.vala"
		_tmp24_ = env;
#line 508 "completion.vala"
		_tmp25_ = (*_tmp24_).insert;
#line 508 "completion.vala"
		document_insert (_tmp23_, iter, _tmp25_, -1);
#line 2394 "completion.c"
	}
#line 510 "completion.vala"
	_tmp26_ = doc;
#line 510 "completion.vala"
	_tmp27_ = *iter;
#line 510 "completion.vala"
	_tmp28_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) _tmp26_, NULL, &_tmp27_, TRUE);
#line 510 "completion.vala"
	_tmp29_ = _g_object_ref0 (_tmp28_);
#line 510 "completion.vala"
	cursor_pos = _tmp29_;
#line 512 "completion.vala"
	_tmp31_ = env;
#line 512 "completion.vala"
	if (_tmp31_ != NULL) {
#line 2410 "completion.c"
		CompletionProviderCompletionChoice* _tmp32_;
		const gchar* _tmp33_;
#line 512 "completion.vala"
		_tmp32_ = env;
#line 512 "completion.vala"
		_tmp33_ = (*_tmp32_).insert_after;
#line 512 "completion.vala"
		_tmp30_ = _tmp33_ != NULL;
#line 2419 "completion.c"
	} else {
#line 512 "completion.vala"
		_tmp30_ = FALSE;
#line 2423 "completion.c"
	}
#line 512 "completion.vala"
	if (_tmp30_) {
#line 2427 "completion.c"
		Document* _tmp34_;
		CompletionProviderCompletionChoice* _tmp35_;
		const gchar* _tmp36_;
#line 513 "completion.vala"
		_tmp34_ = doc;
#line 513 "completion.vala"
		_tmp35_ = env;
#line 513 "completion.vala"
		_tmp36_ = (*_tmp35_).insert_after;
#line 513 "completion.vala"
		document_insert (_tmp34_, iter, _tmp36_, -1);
#line 2439 "completion.c"
	}
#line 515 "completion.vala"
	_tmp37_ = doc;
#line 515 "completion.vala"
	_tmp38_ = cur_indent;
#line 515 "completion.vala"
	_tmp39_ = string_to_string (_tmp38_);
#line 515 "completion.vala"
	_tmp40_ = string_to_string (env_name);
#line 515 "completion.vala"
	_tmp41_ = g_strconcat ("\n", _tmp39_, "\\end{", _tmp40_, "}", NULL);
#line 515 "completion.vala"
	_tmp42_ = _tmp41_;
#line 515 "completion.vala"
	document_insert (_tmp37_, iter, _tmp42_, -1);
#line 515 "completion.vala"
	_g_free0 (_tmp42_);
#line 518 "completion.vala"
	_tmp43_ = doc;
#line 518 "completion.vala"
	_tmp44_ = cursor_pos;
#line 518 "completion.vala"
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp43_, &_tmp45_, _tmp44_);
#line 518 "completion.vala"
	*iter = _tmp45_;
#line 519 "completion.vala"
	_tmp46_ = doc;
#line 519 "completion.vala"
	_tmp47_ = cursor_pos;
#line 519 "completion.vala"
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) _tmp46_, _tmp47_);
#line 520 "completion.vala"
	_tmp48_ = doc;
#line 520 "completion.vala"
	_tmp49_ = *iter;
#line 520 "completion.vala"
	gtk_text_buffer_place_cursor ((GtkTextBuffer*) _tmp48_, &_tmp49_);
#line 522 "completion.vala"
	_tmp50_ = doc;
#line 522 "completion.vala"
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) _tmp50_);
#line 494 "completion.vala"
	_g_object_unref0 (cursor_pos);
#line 494 "completion.vala"
	_completion_provider_completion_choice_free0 (env);
#line 494 "completion.vala"
	_g_free0 (indent);
#line 494 "completion.vala"
	_g_free0 (cur_indent);
#line 494 "completion.vala"
	_g_object_unref0 (doc);
#line 2491 "completion.c"
}

/*************************************************************************/
static gboolean
string_get_prev_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
#line 1290 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1291 "glib-2.0.vapi"
	if (0 < (*index)) {
#line 2506 "completion.c"
		gchar* _tmp0_;
#line 1292 "glib-2.0.vapi"
		_tmp0_ = g_utf8_prev_char (((gchar*) self) + (*index));
#line 1292 "glib-2.0.vapi"
		*index = (gint) (_tmp0_ - ((gchar*) self));
#line 1293 "glib-2.0.vapi"
		_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
#line 1294 "glib-2.0.vapi"
		result = TRUE;
#line 1294 "glib-2.0.vapi"
		if (c) {
#line 1294 "glib-2.0.vapi"
			*c = _vala_c;
#line 2520 "completion.c"
		}
#line 1294 "glib-2.0.vapi"
		return result;
#line 2524 "completion.c"
	} else {
#line 1296 "glib-2.0.vapi"
		_vala_c = (gunichar) 0;
#line 1297 "glib-2.0.vapi"
		result = FALSE;
#line 1297 "glib-2.0.vapi"
		if (c) {
#line 1297 "glib-2.0.vapi"
			*c = _vala_c;
#line 2534 "completion.c"
		}
#line 1297 "glib-2.0.vapi"
		return result;
#line 2538 "completion.c"
	}
#line 1290 "glib-2.0.vapi"
	if (c) {
#line 1290 "glib-2.0.vapi"
		*c = _vala_c;
#line 2544 "completion.c"
	}
}

static void
completion_provider_get_begin_arg_pos (CompletionProvider* self,
                                       GtkTextIter* in_arg_pos,
                                       GtkTextIter* result)
{
	gchar* text = NULL;
	GtkTextIter _tmp0_;
	gchar* _tmp1_;
	gint index = 0;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gunichar cur_char = 0U;
	GtkTextIter begin_arg_pos = {0};
	GtkTextIter _tmp11_;
#line 531 "completion.vala"
	g_return_if_fail (self != NULL);
#line 531 "completion.vala"
	g_return_if_fail (in_arg_pos != NULL);
#line 533 "completion.vala"
	_tmp0_ = *in_arg_pos;
#line 533 "completion.vala"
	_tmp1_ = completion_provider_get_text_line_to_iter (self, &_tmp0_);
#line 533 "completion.vala"
	text = _tmp1_;
#line 534 "completion.vala"
	_tmp2_ = text;
#line 534 "completion.vala"
	_tmp3_ = strlen (_tmp2_);
#line 534 "completion.vala"
	_tmp4_ = _tmp3_;
#line 534 "completion.vala"
	index = _tmp4_;
#line 537 "completion.vala"
	while (TRUE) {
#line 2583 "completion.c"
		const gchar* _tmp5_;
		gunichar _tmp6_ = 0U;
		gboolean _tmp7_;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
#line 537 "completion.vala"
		_tmp5_ = text;
#line 537 "completion.vala"
		_tmp7_ = string_get_prev_char (_tmp5_, &index, &_tmp6_);
#line 537 "completion.vala"
		cur_char = _tmp6_;
#line 537 "completion.vala"
		if (!_tmp7_) {
#line 537 "completion.vala"
			break;
#line 2599 "completion.c"
		}
#line 539 "completion.vala"
		if (cur_char == ((gunichar) '[')) {
#line 539 "completion.vala"
			_tmp9_ = TRUE;
#line 2605 "completion.c"
		} else {
#line 539 "completion.vala"
			_tmp9_ = cur_char == ((gunichar) '{');
#line 2609 "completion.c"
		}
#line 539 "completion.vala"
		if (_tmp9_) {
#line 2613 "completion.c"
			const gchar* _tmp10_;
#line 540 "completion.vala"
			_tmp10_ = text;
#line 540 "completion.vala"
			_tmp8_ = !utils_char_is_escaped (_tmp10_, (glong) index);
#line 2619 "completion.c"
		} else {
#line 539 "completion.vala"
			_tmp8_ = FALSE;
#line 2623 "completion.c"
		}
#line 539 "completion.vala"
		if (_tmp8_) {
#line 542 "completion.vala"
			break;
#line 2629 "completion.c"
		}
	}
#line 546 "completion.vala"
	_tmp11_ = *in_arg_pos;
#line 546 "completion.vala"
	begin_arg_pos = _tmp11_;
#line 547 "completion.vala"
	gtk_text_iter_set_visible_line_index (&begin_arg_pos, index);
#line 548 "completion.vala"
	gtk_text_iter_forward_char (&begin_arg_pos);
#line 550 "completion.vala"
	*result = begin_arg_pos;
#line 550 "completion.vala"
	_g_free0 (text);
#line 550 "completion.vala"
	return;
#line 2646 "completion.c"
}

static gchar*
completion_provider_get_latex_command_at_iter (CompletionProvider* self,
                                               GtkTextIter* iter)
{
	gchar* text = NULL;
	GtkTextIter _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	gchar* result = NULL;
#line 553 "completion.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 553 "completion.vala"
	g_return_val_if_fail (iter != NULL, NULL);
#line 555 "completion.vala"
	_tmp0_ = *iter;
#line 555 "completion.vala"
	_tmp1_ = completion_provider_get_text_line_to_iter (self, &_tmp0_);
#line 555 "completion.vala"
	text = _tmp1_;
#line 556 "completion.vala"
	_tmp2_ = strlen (text);
#line 556 "completion.vala"
	_tmp3_ = _tmp2_;
#line 556 "completion.vala"
	_tmp4_ = completion_provider_get_latex_command_at_index (self, text, _tmp3_);
#line 556 "completion.vala"
	result = _tmp4_;
#line 556 "completion.vala"
	_g_free0 (text);
#line 556 "completion.vala"
	return result;
#line 2682 "completion.c"
}

static gchar*
completion_provider_get_latex_command_at_index (CompletionProvider* self,
                                                const gchar* text,
                                                gint index)
{
	gint _tmp0_;
	gint _tmp1_;
	gint cur_index = 0;
	gunichar cur_char = 0U;
	gchar* result = NULL;
#line 563 "completion.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 563 "completion.vala"
	g_return_val_if_fail (text != NULL, NULL);
#line 565 "completion.vala"
	_tmp0_ = strlen (text);
#line 565 "completion.vala"
	_tmp1_ = _tmp0_;
#line 565 "completion.vala"
	g_return_val_if_fail (index <= _tmp1_, NULL);
#line 567 "completion.vala"
	cur_index = index;
#line 569 "completion.vala"
	while (TRUE) {
#line 2709 "completion.c"
		gunichar _tmp2_ = 0U;
		gboolean _tmp3_;
		gboolean _tmp5_ = FALSE;
#line 569 "completion.vala"
		_tmp3_ = string_get_prev_char (text, &cur_index, &_tmp2_);
#line 569 "completion.vala"
		cur_char = _tmp2_;
#line 569 "completion.vala"
		if (!_tmp3_) {
#line 569 "completion.vala"
			break;
#line 2721 "completion.c"
		}
#line 571 "completion.vala"
		if (cur_char == ((gunichar) '\\')) {
#line 2725 "completion.c"
			gchar* _tmp4_;
#line 574 "completion.vala"
			if (utils_char_is_escaped (text, (glong) cur_index)) {
#line 575 "completion.vala"
				break;
#line 2731 "completion.c"
			}
#line 577 "completion.vala"
			_tmp4_ = string_slice (text, (glong) cur_index, (glong) index);
#line 577 "completion.vala"
			result = _tmp4_;
#line 577 "completion.vala"
			return result;
#line 2739 "completion.c"
		}
#line 581 "completion.vala"
		if (!g_unichar_isalpha (cur_char)) {
#line 581 "completion.vala"
			_tmp5_ = cur_char != ((gunichar) '*');
#line 2745 "completion.c"
		} else {
#line 581 "completion.vala"
			_tmp5_ = FALSE;
#line 2749 "completion.c"
		}
#line 581 "completion.vala"
		if (_tmp5_) {
#line 582 "completion.vala"
			break;
#line 2755 "completion.c"
		}
	}
#line 585 "completion.vala"
	result = NULL;
#line 585 "completion.vala"
	return result;
#line 2762 "completion.c"
}

static gboolean
completion_provider_in_latex_command_argument (CompletionProvider* self,
                                               GtkTextIter* iter,
                                               CompletionProviderArgumentContext* info)
{
	CompletionProviderArgumentContext _vala_info = {0};
	GeeArrayList* _tmp0_;
	gchar* text = NULL;
	GtkTextIter _tmp1_;
	gchar* _tmp2_;
	gint last_index = 0;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gint cur_index = 0;
	gboolean in_prev_arg = FALSE;
	gunichar prev_arg_opening_bracket = 0U;
	gboolean result = FALSE;
#line 588 "completion.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 588 "completion.vala"
	g_return_val_if_fail (iter != NULL, FALSE);
#line 590 "completion.vala"
	completion_provider_argument_context_destroy (&_vala_info);
#line 590 "completion.vala"
	memset (&_vala_info, 0, sizeof (CompletionProviderArgumentContext));
#line 591 "completion.vala"
	_g_free0 (_vala_info.cmd_name);
#line 591 "completion.vala"
	_vala_info.cmd_name = NULL;
#line 592 "completion.vala"
	_g_free0 (_vala_info.arg_contents);
#line 592 "completion.vala"
	_vala_info.arg_contents = NULL;
#line 593 "completion.vala"
	_tmp0_ = gee_array_list_new (G_TYPE_BOOLEAN, NULL, NULL, NULL, NULL, NULL);
#line 593 "completion.vala"
	_g_object_unref0 (_vala_info.args_types);
#line 593 "completion.vala"
	_vala_info.args_types = _tmp0_;
#line 595 "completion.vala"
	_tmp1_ = *iter;
#line 595 "completion.vala"
	_tmp2_ = completion_provider_get_text_line_to_iter (self, &_tmp1_);
#line 595 "completion.vala"
	text = _tmp2_;
#line 596 "completion.vala"
	_tmp3_ = text;
#line 596 "completion.vala"
	_tmp4_ = strlen (_tmp3_);
#line 596 "completion.vala"
	_tmp5_ = _tmp4_;
#line 596 "completion.vala"
	last_index = _tmp5_;
#line 597 "completion.vala"
	cur_index = last_index;
#line 600 "completion.vala"
	while (TRUE) {
#line 2823 "completion.c"
		gunichar cur_char = 0U;
		const gchar* _tmp6_;
		gunichar _tmp7_ = 0U;
		gboolean _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean opening_bracket = FALSE;
		gboolean _tmp10_ = FALSE;
#line 603 "completion.vala"
		_tmp6_ = text;
#line 603 "completion.vala"
		_tmp8_ = string_get_prev_char (_tmp6_, &cur_index, &_tmp7_);
#line 603 "completion.vala"
		cur_char = _tmp7_;
#line 603 "completion.vala"
		if (!_tmp8_) {
#line 604 "completion.vala"
			result = FALSE;
#line 604 "completion.vala"
			_g_free0 (text);
#line 604 "completion.vala"
			if (info) {
#line 604 "completion.vala"
				*info = _vala_info;
#line 2847 "completion.c"
			} else {
#line 604 "completion.vala"
				completion_provider_argument_context_destroy (&_vala_info);
#line 2851 "completion.c"
			}
#line 604 "completion.vala"
			return result;
#line 2855 "completion.c"
		}
#line 607 "completion.vala"
		if (cur_char == ((gunichar) '{')) {
#line 607 "completion.vala"
			_tmp9_ = TRUE;
#line 2861 "completion.c"
		} else {
#line 607 "completion.vala"
			_tmp9_ = cur_char == ((gunichar) '[');
#line 2865 "completion.c"
		}
#line 607 "completion.vala"
		opening_bracket = _tmp9_;
#line 608 "completion.vala"
		if (opening_bracket) {
#line 2871 "completion.c"
			const gchar* _tmp11_;
#line 608 "completion.vala"
			_tmp11_ = text;
#line 608 "completion.vala"
			_tmp10_ = !utils_char_is_escaped (_tmp11_, (glong) cur_index);
#line 2877 "completion.c"
		} else {
#line 608 "completion.vala"
			_tmp10_ = FALSE;
#line 2881 "completion.c"
		}
#line 608 "completion.vala"
		if (_tmp10_) {
#line 2885 "completion.c"
			CompletionProviderArgumentContext _tmp12_;
			GeeArrayList* _tmp13_;
			const gchar* _tmp14_;
			gchar* _tmp15_;
#line 610 "completion.vala"
			_tmp12_ = _vala_info;
#line 610 "completion.vala"
			_tmp13_ = _tmp12_.args_types;
#line 610 "completion.vala"
			gee_abstract_list_insert ((GeeAbstractList*) _tmp13_, 0, (gpointer) ((gintptr) (cur_char == ((gunichar) '['))));
#line 611 "completion.vala"
			_tmp14_ = text;
#line 611 "completion.vala"
			_tmp15_ = string_slice (_tmp14_, (glong) (cur_index + 1), (glong) last_index);
#line 611 "completion.vala"
			_g_free0 (_vala_info.arg_contents);
#line 611 "completion.vala"
			_vala_info.arg_contents = _tmp15_;
#line 612 "completion.vala"
			break;
#line 2906 "completion.c"
		}
	}
#line 617 "completion.vala"
	in_prev_arg = FALSE;
#line 618 "completion.vala"
	prev_arg_opening_bracket = (gunichar) '{';
#line 620 "completion.vala"
	while (TRUE) {
#line 2915 "completion.c"
		gunichar cur_char = 0U;
		const gchar* _tmp16_;
		gunichar _tmp17_ = 0U;
		gboolean _tmp18_;
#line 623 "completion.vala"
		_tmp16_ = text;
#line 623 "completion.vala"
		_tmp18_ = string_get_prev_char (_tmp16_, &cur_index, &_tmp17_);
#line 623 "completion.vala"
		cur_char = _tmp17_;
#line 623 "completion.vala"
		if (!_tmp18_) {
#line 624 "completion.vala"
			result = FALSE;
#line 624 "completion.vala"
			_g_free0 (text);
#line 624 "completion.vala"
			if (info) {
#line 624 "completion.vala"
				*info = _vala_info;
#line 2936 "completion.c"
			} else {
#line 624 "completion.vala"
				completion_provider_argument_context_destroy (&_vala_info);
#line 2940 "completion.c"
			}
#line 624 "completion.vala"
			return result;
#line 2944 "completion.c"
		}
#line 627 "completion.vala"
		if (in_prev_arg) {
#line 629 "completion.vala"
			if (cur_char == prev_arg_opening_bracket) {
#line 2950 "completion.c"
				const gchar* _tmp19_;
#line 630 "completion.vala"
				_tmp19_ = text;
#line 630 "completion.vala"
				in_prev_arg = utils_char_is_escaped (_tmp19_, (glong) cur_index);
#line 2956 "completion.c"
			}
		} else {
			gboolean _tmp20_ = FALSE;
#line 634 "completion.vala"
			if (cur_char == ((gunichar) '}')) {
#line 634 "completion.vala"
				_tmp20_ = TRUE;
#line 2964 "completion.c"
			} else {
#line 634 "completion.vala"
				_tmp20_ = cur_char == ((gunichar) ']');
#line 2968 "completion.c"
			}
#line 634 "completion.vala"
			if (_tmp20_) {
#line 2972 "completion.c"
				const gchar* _tmp21_;
				gchar _tmp22_ = '\0';
				CompletionProviderArgumentContext _tmp23_;
				GeeArrayList* _tmp24_;
#line 636 "completion.vala"
				_tmp21_ = text;
#line 636 "completion.vala"
				if (utils_char_is_escaped (_tmp21_, (glong) cur_index)) {
#line 637 "completion.vala"
					result = FALSE;
#line 637 "completion.vala"
					_g_free0 (text);
#line 637 "completion.vala"
					if (info) {
#line 637 "completion.vala"
						*info = _vala_info;
#line 2989 "completion.c"
					} else {
#line 637 "completion.vala"
						completion_provider_argument_context_destroy (&_vala_info);
#line 2993 "completion.c"
					}
#line 637 "completion.vala"
					return result;
#line 2997 "completion.c"
				}
#line 639 "completion.vala"
				in_prev_arg = TRUE;
#line 640 "completion.vala"
				if (cur_char == ((gunichar) '}')) {
#line 640 "completion.vala"
					_tmp22_ = '{';
#line 3005 "completion.c"
				} else {
#line 640 "completion.vala"
					_tmp22_ = '[';
#line 3009 "completion.c"
				}
#line 640 "completion.vala"
				prev_arg_opening_bracket = (gunichar) _tmp22_;
#line 642 "completion.vala"
				_tmp23_ = _vala_info;
#line 642 "completion.vala"
				_tmp24_ = _tmp23_.args_types;
#line 642 "completion.vala"
				gee_abstract_list_insert ((GeeAbstractList*) _tmp24_, 0, (gpointer) ((gintptr) (cur_char == ((gunichar) ']'))));
#line 3019 "completion.c"
			} else {
				gboolean _tmp25_ = FALSE;
#line 646 "completion.vala"
				if (g_unichar_isalpha (cur_char)) {
#line 646 "completion.vala"
					_tmp25_ = TRUE;
#line 3026 "completion.c"
				} else {
#line 646 "completion.vala"
					_tmp25_ = cur_char == ((gunichar) '*');
#line 3030 "completion.c"
				}
#line 646 "completion.vala"
				if (_tmp25_) {
#line 3034 "completion.c"
					const gchar* _tmp26_;
					gchar* _tmp27_;
					CompletionProviderArgumentContext _tmp28_;
					const gchar* _tmp29_;
#line 648 "completion.vala"
					_tmp26_ = text;
#line 648 "completion.vala"
					_tmp27_ = completion_provider_get_latex_command_at_index (self, _tmp26_, cur_index + 1);
#line 648 "completion.vala"
					_g_free0 (_vala_info.cmd_name);
#line 648 "completion.vala"
					_vala_info.cmd_name = _tmp27_;
#line 649 "completion.vala"
					_tmp28_ = _vala_info;
#line 649 "completion.vala"
					_tmp29_ = _tmp28_.cmd_name;
#line 649 "completion.vala"
					result = _tmp29_ != NULL;
#line 649 "completion.vala"
					_g_free0 (text);
#line 649 "completion.vala"
					if (info) {
#line 649 "completion.vala"
						*info = _vala_info;
#line 3059 "completion.c"
					} else {
#line 649 "completion.vala"
						completion_provider_argument_context_destroy (&_vala_info);
#line 3063 "completion.c"
					}
#line 649 "completion.vala"
					return result;
#line 3067 "completion.c"
				} else {
#line 653 "completion.vala"
					if (!g_unichar_isspace (cur_char)) {
#line 654 "completion.vala"
						result = FALSE;
#line 654 "completion.vala"
						_g_free0 (text);
#line 654 "completion.vala"
						if (info) {
#line 654 "completion.vala"
							*info = _vala_info;
#line 3079 "completion.c"
						} else {
#line 654 "completion.vala"
							completion_provider_argument_context_destroy (&_vala_info);
#line 3083 "completion.c"
						}
#line 654 "completion.vala"
						return result;
#line 3087 "completion.c"
					}
				}
			}
		}
	}
#line 588 "completion.vala"
	_g_free0 (text);
#line 588 "completion.vala"
	if (info) {
#line 588 "completion.vala"
		*info = _vala_info;
#line 3099 "completion.c"
	} else {
#line 588 "completion.vala"
		completion_provider_argument_context_destroy (&_vala_info);
#line 3103 "completion.c"
	}
}

/*************************************************************************/
static gboolean
completion_provider_is_user_request (CompletionProvider* self,
                                     GtkSourceCompletionContext* context)
{
	GtkSourceCompletionActivation _tmp0_;
	GtkSourceCompletionActivation _tmp1_;
	gboolean result = FALSE;
#line 661 "completion.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 661 "completion.vala"
	g_return_val_if_fail (context != NULL, FALSE);
#line 663 "completion.vala"
	g_object_get (context, "activation", &_tmp0_, NULL);
#line 663 "completion.vala"
	_tmp1_ = _tmp0_;
#line 663 "completion.vala"
	result = _tmp1_ == GTK_SOURCE_COMPLETION_ACTIVATION_USER_REQUESTED;
#line 663 "completion.vala"
	return result;
#line 3127 "completion.c"
}

static gint
completion_provider_compare_proposals (GtkSourceCompletionItem* a,
                                       GtkSourceCompletionItem* b)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gint _tmp6_;
	gint result = 0;
#line 668 "completion.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 668 "completion.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 670 "completion.vala"
	g_object_get (a, "text", &_tmp0_, NULL);
#line 670 "completion.vala"
	_tmp1_ = _tmp0_;
#line 670 "completion.vala"
	_tmp2_ = _tmp1_;
#line 670 "completion.vala"
	g_object_get (b, "text", &_tmp3_, NULL);
#line 670 "completion.vala"
	_tmp4_ = _tmp3_;
#line 670 "completion.vala"
	_tmp5_ = _tmp4_;
#line 670 "completion.vala"
	_tmp6_ = g_utf8_collate (_tmp2_, _tmp5_);
#line 670 "completion.vala"
	_g_free0 (_tmp5_);
#line 670 "completion.vala"
	_g_free0 (_tmp2_);
#line 670 "completion.vala"
	result = _tmp6_;
#line 670 "completion.vala"
	return result;
#line 3168 "completion.c"
}

static gchar*
completion_provider_get_text_line_to_iter (CompletionProvider* self,
                                           GtkTextIter* iter)
{
	gint line = 0;
	GtkTextBuffer* doc = NULL;
	GtkTextBuffer* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextIter iter_start = {0};
	GtkTextIter _tmp2_ = {0};
	GtkTextIter _tmp3_;
	GtkTextIter _tmp4_;
	gchar* _tmp5_;
	gchar* result = NULL;
#line 674 "completion.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 674 "completion.vala"
	g_return_val_if_fail (iter != NULL, NULL);
#line 676 "completion.vala"
	line = gtk_text_iter_get_line (iter);
#line 677 "completion.vala"
	_tmp0_ = gtk_text_iter_get_buffer (iter);
#line 677 "completion.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 677 "completion.vala"
	doc = _tmp1_;
#line 680 "completion.vala"
	gtk_text_buffer_get_iter_at_line (doc, &_tmp2_, line);
#line 680 "completion.vala"
	iter_start = _tmp2_;
#line 682 "completion.vala"
	_tmp3_ = iter_start;
#line 682 "completion.vala"
	_tmp4_ = *iter;
#line 682 "completion.vala"
	_tmp5_ = gtk_text_buffer_get_text (doc, &_tmp3_, &_tmp4_, FALSE);
#line 682 "completion.vala"
	result = _tmp5_;
#line 682 "completion.vala"
	_g_object_unref0 (doc);
#line 682 "completion.vala"
	return result;
#line 3213 "completion.c"
}

static gchar*
completion_provider_get_command_info (CompletionProvider* self,
                                      CompletionProviderCompletionCommand* cmd,
                                      gint cur_arg)
{
	gchar* info = NULL;
	CompletionProviderCompletionCommand _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gint arg_num = 0;
	CompletionProviderCompletionCommand _tmp3_;
	CompletionProviderCompletionArgument* _tmp4_;
	gint _tmp4__length1;
	CompletionProviderCompletionCommand _tmp29_;
	const gchar* _tmp30_;
	gchar* result = NULL;
#line 688 "completion.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 688 "completion.vala"
	g_return_val_if_fail (cmd != NULL, NULL);
#line 690 "completion.vala"
	_tmp0_ = *cmd;
#line 690 "completion.vala"
	_tmp1_ = _tmp0_.name;
#line 690 "completion.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 690 "completion.vala"
	info = _tmp2_;
#line 691 "completion.vala"
	arg_num = 1;
#line 692 "completion.vala"
	_tmp3_ = *cmd;
#line 692 "completion.vala"
	_tmp4_ = _tmp3_.args;
#line 692 "completion.vala"
	_tmp4__length1 = _tmp3_.args_length1;
#line 3252 "completion.c"
	{
		CompletionProviderCompletionArgument* arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
#line 692 "completion.vala"
		arg_collection = _tmp4_;
#line 692 "completion.vala"
		arg_collection_length1 = _tmp4__length1;
#line 692 "completion.vala"
		for (arg_it = 0; arg_it < arg_collection_length1; arg_it = arg_it + 1) {
#line 3264 "completion.c"
			CompletionProviderCompletionArgument _tmp5_;
			CompletionProviderCompletionArgument _tmp6_ = {0};
			CompletionProviderCompletionArgument arg = {0};
#line 692 "completion.vala"
			_tmp5_ = arg_collection[arg_it];
#line 692 "completion.vala"
			completion_provider_completion_argument_copy (&_tmp5_, &_tmp6_);
#line 692 "completion.vala"
			arg = _tmp6_;
#line 3274 "completion.c"
			{
				CompletionProviderCompletionArgument _tmp9_;
				gint _tmp28_;
#line 694 "completion.vala"
				if (arg_num == cur_arg) {
#line 3280 "completion.c"
					const gchar* _tmp7_;
					gchar* _tmp8_;
#line 695 "completion.vala"
					_tmp7_ = info;
#line 695 "completion.vala"
					_tmp8_ = g_strconcat (_tmp7_, "<b>", NULL);
#line 695 "completion.vala"
					_g_free0 (info);
#line 695 "completion.vala"
					info = _tmp8_;
#line 3291 "completion.c"
				}
#line 697 "completion.vala"
				_tmp9_ = arg;
#line 697 "completion.vala"
				if (_tmp9_.optional) {
#line 3297 "completion.c"
					const gchar* _tmp10_;
					CompletionProviderCompletionArgument _tmp11_;
					const gchar* _tmp12_;
					gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					gchar* _tmp17_;
#line 698 "completion.vala"
					_tmp10_ = info;
#line 698 "completion.vala"
					_tmp11_ = arg;
#line 698 "completion.vala"
					_tmp12_ = _tmp11_.label;
#line 698 "completion.vala"
					_tmp13_ = g_strconcat ("[", _tmp12_, NULL);
#line 698 "completion.vala"
					_tmp14_ = _tmp13_;
#line 698 "completion.vala"
					_tmp15_ = g_strconcat (_tmp14_, "]", NULL);
#line 698 "completion.vala"
					_tmp16_ = _tmp15_;
#line 698 "completion.vala"
					_tmp17_ = g_strconcat (_tmp10_, _tmp16_, NULL);
#line 698 "completion.vala"
					_g_free0 (info);
#line 698 "completion.vala"
					info = _tmp17_;
#line 698 "completion.vala"
					_g_free0 (_tmp16_);
#line 698 "completion.vala"
					_g_free0 (_tmp14_);
#line 3330 "completion.c"
				} else {
					const gchar* _tmp18_;
					CompletionProviderCompletionArgument _tmp19_;
					const gchar* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
#line 700 "completion.vala"
					_tmp18_ = info;
#line 700 "completion.vala"
					_tmp19_ = arg;
#line 700 "completion.vala"
					_tmp20_ = _tmp19_.label;
#line 700 "completion.vala"
					_tmp21_ = g_strconcat ("{", _tmp20_, NULL);
#line 700 "completion.vala"
					_tmp22_ = _tmp21_;
#line 700 "completion.vala"
					_tmp23_ = g_strconcat (_tmp22_, "}", NULL);
#line 700 "completion.vala"
					_tmp24_ = _tmp23_;
#line 700 "completion.vala"
					_tmp25_ = g_strconcat (_tmp18_, _tmp24_, NULL);
#line 700 "completion.vala"
					_g_free0 (info);
#line 700 "completion.vala"
					info = _tmp25_;
#line 700 "completion.vala"
					_g_free0 (_tmp24_);
#line 700 "completion.vala"
					_g_free0 (_tmp22_);
#line 3364 "completion.c"
				}
#line 702 "completion.vala"
				if (arg_num == cur_arg) {
#line 3368 "completion.c"
					const gchar* _tmp26_;
					gchar* _tmp27_;
#line 703 "completion.vala"
					_tmp26_ = info;
#line 703 "completion.vala"
					_tmp27_ = g_strconcat (_tmp26_, "</b>", NULL);
#line 703 "completion.vala"
					_g_free0 (info);
#line 703 "completion.vala"
					info = _tmp27_;
#line 3379 "completion.c"
				}
#line 705 "completion.vala"
				_tmp28_ = arg_num;
#line 705 "completion.vala"
				arg_num = _tmp28_ + 1;
#line 692 "completion.vala"
				completion_provider_completion_argument_destroy (&arg);
#line 3387 "completion.c"
			}
		}
	}
#line 708 "completion.vala"
	_tmp29_ = *cmd;
#line 708 "completion.vala"
	_tmp30_ = _tmp29_.package;
#line 708 "completion.vala"
	if (_tmp30_ != NULL) {
#line 3397 "completion.c"
		const gchar* _tmp31_;
		CompletionProviderCompletionCommand _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
#line 709 "completion.vala"
		_tmp31_ = info;
#line 709 "completion.vala"
		_tmp32_ = *cmd;
#line 709 "completion.vala"
		_tmp33_ = _tmp32_.package;
#line 709 "completion.vala"
		_tmp34_ = g_strconcat ("\nPackage: ", _tmp33_, NULL);
#line 709 "completion.vala"
		_tmp35_ = _tmp34_;
#line 709 "completion.vala"
		_tmp36_ = g_strconcat (_tmp31_, _tmp35_, NULL);
#line 709 "completion.vala"
		_g_free0 (info);
#line 709 "completion.vala"
		info = _tmp36_;
#line 709 "completion.vala"
		_g_free0 (_tmp35_);
#line 3422 "completion.c"
	}
#line 711 "completion.vala"
	result = info;
#line 711 "completion.vala"
	return result;
#line 3428 "completion.c"
}

static gint
completion_provider_get_argument_num (CompletionProvider* self,
                                      CompletionProviderCompletionArgument* all_args,
                                      gint all_args_length1,
                                      GeeArrayList* args)
{
	gint _tmp0_;
	gint _tmp1_;
	gint num = 0;
	gint result = 0;
#line 719 "completion.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 719 "completion.vala"
	g_return_val_if_fail (args != NULL, 0);
#line 722 "completion.vala"
	_tmp0_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) args);
#line 722 "completion.vala"
	_tmp1_ = _tmp0_;
#line 722 "completion.vala"
	if (all_args_length1 < _tmp1_) {
#line 723 "completion.vala"
		result = -1;
#line 723 "completion.vala"
		return result;
#line 3455 "completion.c"
	}
#line 725 "completion.vala"
	num = 0;
#line 3459 "completion.c"
	{
		GeeArrayList* _arg_list = NULL;
		GeeArrayList* _tmp2_;
		gint _arg_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _arg_index = 0;
#line 726 "completion.vala"
		_tmp2_ = _g_object_ref0 (args);
#line 726 "completion.vala"
		_arg_list = _tmp2_;
#line 726 "completion.vala"
		_tmp3_ = _arg_list;
#line 726 "completion.vala"
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
#line 726 "completion.vala"
		_tmp5_ = _tmp4_;
#line 726 "completion.vala"
		_arg_size = _tmp5_;
#line 726 "completion.vala"
		_arg_index = -1;
#line 726 "completion.vala"
		while (TRUE) {
#line 3484 "completion.c"
			gboolean arg = FALSE;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			gint _tmp11_;
#line 726 "completion.vala"
			_arg_index = _arg_index + 1;
#line 726 "completion.vala"
			if (!(_arg_index < _arg_size)) {
#line 726 "completion.vala"
				break;
#line 3495 "completion.c"
			}
#line 726 "completion.vala"
			_tmp6_ = _arg_list;
#line 726 "completion.vala"
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _arg_index);
#line 726 "completion.vala"
			arg = (gboolean) ((gintptr) _tmp7_);
#line 728 "completion.vala"
			while (TRUE) {
#line 3505 "completion.c"
				CompletionProviderCompletionArgument _tmp8_;
				gint _tmp10_;
#line 730 "completion.vala"
				if (all_args_length1 <= num) {
#line 731 "completion.vala"
					result = -1;
#line 731 "completion.vala"
					_g_object_unref0 (_arg_list);
#line 731 "completion.vala"
					return result;
#line 3516 "completion.c"
				}
#line 733 "completion.vala"
				_tmp8_ = all_args[num];
#line 733 "completion.vala"
				if (_tmp8_.optional == arg) {
#line 734 "completion.vala"
					break;
#line 3524 "completion.c"
				} else {
					CompletionProviderCompletionArgument _tmp9_;
#line 737 "completion.vala"
					_tmp9_ = all_args[num];
#line 737 "completion.vala"
					if (!_tmp9_.optional) {
#line 738 "completion.vala"
						result = -1;
#line 738 "completion.vala"
						_g_object_unref0 (_arg_list);
#line 738 "completion.vala"
						return result;
#line 3537 "completion.c"
					}
				}
#line 740 "completion.vala"
				_tmp10_ = num;
#line 740 "completion.vala"
				num = _tmp10_ + 1;
#line 3544 "completion.c"
			}
#line 742 "completion.vala"
			_tmp11_ = num;
#line 742 "completion.vala"
			num = _tmp11_ + 1;
#line 3550 "completion.c"
		}
#line 726 "completion.vala"
		_g_object_unref0 (_arg_list);
#line 3554 "completion.c"
	}
#line 746 "completion.vala"
	result = num;
#line 746 "completion.vala"
	return result;
#line 3560 "completion.c"
}

static gchar*
completion_provider_get_command_text_to_insert (CompletionProvider* self,
                                                CompletionProviderCompletionCommand* cmd)
{
	gchar* text_to_insert = NULL;
	CompletionProviderCompletionCommand _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	CompletionProviderCompletionCommand _tmp3_;
	CompletionProviderCompletionArgument* _tmp4_;
	gint _tmp4__length1;
	gchar* result = NULL;
#line 749 "completion.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 749 "completion.vala"
	g_return_val_if_fail (cmd != NULL, NULL);
#line 751 "completion.vala"
	_tmp0_ = *cmd;
#line 751 "completion.vala"
	_tmp1_ = _tmp0_.name;
#line 751 "completion.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 751 "completion.vala"
	text_to_insert = _tmp2_;
#line 752 "completion.vala"
	_tmp3_ = *cmd;
#line 752 "completion.vala"
	_tmp4_ = _tmp3_.args;
#line 752 "completion.vala"
	_tmp4__length1 = _tmp3_.args_length1;
#line 3593 "completion.c"
	{
		CompletionProviderCompletionArgument* arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
#line 752 "completion.vala"
		arg_collection = _tmp4_;
#line 752 "completion.vala"
		arg_collection_length1 = _tmp4__length1;
#line 752 "completion.vala"
		for (arg_it = 0; arg_it < arg_collection_length1; arg_it = arg_it + 1) {
#line 3605 "completion.c"
			CompletionProviderCompletionArgument _tmp5_;
			CompletionProviderCompletionArgument _tmp6_ = {0};
			CompletionProviderCompletionArgument arg = {0};
#line 752 "completion.vala"
			_tmp5_ = arg_collection[arg_it];
#line 752 "completion.vala"
			completion_provider_completion_argument_copy (&_tmp5_, &_tmp6_);
#line 752 "completion.vala"
			arg = _tmp6_;
#line 3615 "completion.c"
			{
				CompletionProviderCompletionArgument _tmp7_;
#line 754 "completion.vala"
				_tmp7_ = arg;
#line 754 "completion.vala"
				if (!_tmp7_.optional) {
#line 3622 "completion.c"
					const gchar* _tmp8_;
					gchar* _tmp9_;
#line 755 "completion.vala"
					_tmp8_ = text_to_insert;
#line 755 "completion.vala"
					_tmp9_ = g_strconcat (_tmp8_, "{}", NULL);
#line 755 "completion.vala"
					_g_free0 (text_to_insert);
#line 755 "completion.vala"
					text_to_insert = _tmp9_;
#line 3633 "completion.c"
				}
#line 752 "completion.vala"
				completion_provider_completion_argument_destroy (&arg);
#line 3637 "completion.c"
			}
		}
	}
#line 757 "completion.vala"
	result = text_to_insert;
#line 757 "completion.vala"
	return result;
#line 3645 "completion.c"
}

/*************************************************************************/
static void
_completion_provider_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context,
                                                                     const gchar* element_name,
                                                                     gchar** attribute_names,
                                                                     gchar** attribute_values,
                                                                     gpointer self,
                                                                     GError** error)
{
#line 797 "completion.vala"
	completion_provider_parser_start ((CompletionProvider*) self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
#line 3659 "completion.c"
}

static void
_completion_provider_parser_end_gmarkup_parser_end_element_func (GMarkupParseContext* context,
                                                                 const gchar* element_name,
                                                                 gpointer self,
                                                                 GError** error)
{
#line 797 "completion.vala"
	completion_provider_parser_end ((CompletionProvider*) self, context, element_name, error);
#line 3670 "completion.c"
}

static void
_completion_provider_parser_text_gmarkup_parser_text_func (GMarkupParseContext* context,
                                                           const gchar* text,
                                                           gsize text_len,
                                                           gpointer self,
                                                           GError** error)
{
#line 797 "completion.vala"
	completion_provider_parser_text ((CompletionProvider*) self, context, text, text_len, error);
#line 3682 "completion.c"
}

static void
completion_provider_load_data (CompletionProvider* self)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GFile* file = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gchar* contents = NULL;
	GFile* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	GError* _inner_error0_ = NULL;
#line 783 "completion.vala"
	g_return_if_fail (self != NULL);
#line 785 "completion.vala"
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, COMPLETION_PROVIDER_TYPE_COMPLETION_COMMAND, (GBoxedCopyFunc) completion_provider_completion_command_dup, (GDestroyNotify) completion_provider_completion_command_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 785 "completion.vala"
	_g_object_unref0 (self->priv->_commands);
#line 785 "completion.vala"
	self->priv->_commands = _tmp0_;
#line 786 "completion.vala"
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, COMPLETION_PROVIDER_TYPE_COMPLETION_CHOICE, (GBoxedCopyFunc) completion_provider_completion_choice_dup, (GDestroyNotify) completion_provider_completion_choice_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 786 "completion.vala"
	_g_object_unref0 (self->priv->_environments);
#line 786 "completion.vala"
	self->priv->_environments = _tmp1_;
#line 788 "completion.vala"
	_tmp2_ = g_build_filename (DATA_DIR, "completion.xml", NULL);
#line 788 "completion.vala"
	_tmp3_ = _tmp2_;
#line 788 "completion.vala"
	_tmp4_ = g_file_new_for_path (_tmp3_);
#line 788 "completion.vala"
	_tmp5_ = _tmp4_;
#line 788 "completion.vala"
	_g_free0 (_tmp3_);
#line 788 "completion.vala"
	file = _tmp5_;
#line 791 "completion.vala"
	_tmp6_ = file;
#line 791 "completion.vala"
	_tmp7_ = utils_load_file (_tmp6_);
#line 791 "completion.vala"
	contents = _tmp7_;
#line 792 "completion.vala"
	_tmp8_ = contents;
#line 792 "completion.vala"
	if (_tmp8_ == NULL) {
#line 793 "completion.vala"
		_g_free0 (contents);
#line 793 "completion.vala"
		_g_object_unref0 (file);
#line 793 "completion.vala"
		return;
#line 3742 "completion.c"
	}
	{
		GMarkupParser parser = {0};
		GMarkupParser _tmp9_ = {0};
		GMarkupParseContext* context = NULL;
		GMarkupParser _tmp10_;
		GMarkupParseContext* _tmp11_;
		GMarkupParseContext* _tmp12_;
		const gchar* _tmp13_;
#line 797 "completion.vala"
		_tmp9_.start_element = _completion_provider_parser_start_gmarkup_parser_start_element_func;
#line 797 "completion.vala"
		_tmp9_.end_element = _completion_provider_parser_end_gmarkup_parser_end_element_func;
#line 797 "completion.vala"
		_tmp9_.text = _completion_provider_parser_text_gmarkup_parser_text_func;
#line 797 "completion.vala"
		_tmp9_.passthrough = NULL;
#line 797 "completion.vala"
		_tmp9_.error = NULL;
#line 797 "completion.vala"
		parser = _tmp9_;
#line 798 "completion.vala"
		_tmp10_ = parser;
#line 798 "completion.vala"
		_tmp11_ = g_markup_parse_context_new (&_tmp10_, 0, self, NULL);
#line 798 "completion.vala"
		context = _tmp11_;
#line 799 "completion.vala"
		_tmp12_ = context;
#line 799 "completion.vala"
		_tmp13_ = contents;
#line 799 "completion.vala"
		g_markup_parse_context_parse (_tmp12_, _tmp13_, (gssize) -1, &_inner_error0_);
#line 799 "completion.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 799 "completion.vala"
			_g_markup_parse_context_unref0 (context);
#line 3780 "completion.c"
			goto __catch0_g_error;
		}
#line 800 "completion.vala"
		self->priv->_proposals = g_list_sort (self->priv->_proposals, (GCompareFunc) completion_provider_compare_proposals);
#line 795 "completion.vala"
		_g_markup_parse_context_unref0 (context);
#line 3787 "completion.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_;
		const gchar* _tmp15_;
#line 795 "completion.vala"
		e = _inner_error0_;
#line 795 "completion.vala"
		_inner_error0_ = NULL;
#line 804 "completion.vala"
		_tmp14_ = e;
#line 804 "completion.vala"
		_tmp15_ = _tmp14_->message;
#line 804 "completion.vala"
		g_warning ("completion.vala:804: Impossible to load completion data: %s", _tmp15_);
#line 795 "completion.vala"
		_g_error_free0 (e);
#line 3807 "completion.c"
	}
	__finally0:
#line 795 "completion.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 795 "completion.vala"
		_g_free0 (contents);
#line 795 "completion.vala"
		_g_object_unref0 (file);
#line 795 "completion.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 795 "completion.vala"
		g_clear_error (&_inner_error0_);
#line 795 "completion.vala"
		return;
#line 3822 "completion.c"
	}
#line 783 "completion.vala"
	_g_free0 (contents);
#line 783 "completion.vala"
	_g_object_unref0 (file);
#line 3828 "completion.c"
}

static void
completion_provider_parser_start (CompletionProvider* self,
                                  GMarkupParseContext* context,
                                  const gchar* name,
                                  gchar** attr_names,
                                  gint attr_names_length1,
                                  gchar** attr_values,
                                  gint attr_values_length1,
                                  GError** error)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
#line 811 "completion.vala"
	static GQuark _tmp1_label0 = 0;
#line 811 "completion.vala"
	static GQuark _tmp1_label1 = 0;
#line 811 "completion.vala"
	static GQuark _tmp1_label2 = 0;
#line 811 "completion.vala"
	static GQuark _tmp1_label3 = 0;
#line 811 "completion.vala"
	static GQuark _tmp1_label4 = 0;
#line 811 "completion.vala"
	static GQuark _tmp1_label5 = 0;
#line 811 "completion.vala"
	static GQuark _tmp1_label6 = 0;
#line 811 "completion.vala"
	static GQuark _tmp1_label7 = 0;
#line 3859 "completion.c"
	GError* _inner_error0_ = NULL;
#line 808 "completion.vala"
	g_return_if_fail (self != NULL);
#line 808 "completion.vala"
	g_return_if_fail (context != NULL);
#line 808 "completion.vala"
	g_return_if_fail (name != NULL);
#line 811 "completion.vala"
	_tmp0_ = name;
#line 811 "completion.vala"
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
#line 811 "completion.vala"
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("commands")))) {
#line 811 "completion.vala"
		switch (0) {
#line 3875 "completion.c"
			default:
			{
#line 814 "completion.vala"
				break;
#line 3880 "completion.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("command")))) {
#line 811 "completion.vala"
		switch (0) {
#line 3886 "completion.c"
			default:
			{
#line 817 "completion.vala"
				completion_provider_parser_add_command (self, attr_names, (gint) attr_names_length1, attr_values, (gint) attr_values_length1, &_inner_error0_);
#line 817 "completion.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 817 "completion.vala"
					if (_inner_error0_->domain == G_MARKUP_ERROR) {
#line 817 "completion.vala"
						g_propagate_error (error, _inner_error0_);
#line 817 "completion.vala"
						return;
#line 3899 "completion.c"
					} else {
#line 817 "completion.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 817 "completion.vala"
						g_clear_error (&_inner_error0_);
#line 817 "completion.vala"
						return;
#line 3907 "completion.c"
					}
				}
#line 818 "completion.vala"
				break;
#line 3912 "completion.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("argument")))) {
#line 811 "completion.vala"
		switch (0) {
#line 3918 "completion.c"
			default:
			{
#line 821 "completion.vala"
				completion_provider_parser_add_argument (self, attr_names, (gint) attr_names_length1, attr_values, (gint) attr_values_length1, &_inner_error0_);
#line 821 "completion.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 821 "completion.vala"
					if (_inner_error0_->domain == G_MARKUP_ERROR) {
#line 821 "completion.vala"
						g_propagate_error (error, _inner_error0_);
#line 821 "completion.vala"
						return;
#line 3931 "completion.c"
					} else {
#line 821 "completion.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 821 "completion.vala"
						g_clear_error (&_inner_error0_);
#line 821 "completion.vala"
						return;
#line 3939 "completion.c"
					}
				}
#line 822 "completion.vala"
				break;
#line 3944 "completion.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label3) ? _tmp1_label3 : (_tmp1_label3 = g_quark_from_static_string ("choice")))) {
#line 811 "completion.vala"
		switch (0) {
#line 3950 "completion.c"
			default:
			{
#line 825 "completion.vala"
				completion_provider_parser_add_choice (self, attr_names, (gint) attr_names_length1, attr_values, (gint) attr_values_length1, &_inner_error0_);
#line 825 "completion.vala"
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 825 "completion.vala"
					if (_inner_error0_->domain == G_MARKUP_ERROR) {
#line 825 "completion.vala"
						g_propagate_error (error, _inner_error0_);
#line 825 "completion.vala"
						return;
#line 3963 "completion.c"
					} else {
#line 825 "completion.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 825 "completion.vala"
						g_clear_error (&_inner_error0_);
#line 825 "completion.vala"
						return;
#line 3971 "completion.c"
					}
				}
#line 826 "completion.vala"
				break;
#line 3976 "completion.c"
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label4) ? _tmp1_label4 : (_tmp1_label4 = g_quark_from_static_string ("insert")))) || (_tmp2_ == ((0 != _tmp1_label5) ? _tmp1_label5 : (_tmp1_label5 = g_quark_from_static_string ("insert_after"))))) {
#line 811 "completion.vala"
		switch (0) {
#line 3982 "completion.c"
			default:
			{
#line 832 "completion.vala"
				break;
#line 3987 "completion.c"
			}
		}
	} else if ((_tmp2_ == ((0 != _tmp1_label6) ? _tmp1_label6 : (_tmp1_label6 = g_quark_from_static_string ("placeholder")))) || (_tmp2_ == ((0 != _tmp1_label7) ? _tmp1_label7 : (_tmp1_label7 = g_quark_from_static_string ("component"))))) {
#line 811 "completion.vala"
		switch (0) {
#line 3993 "completion.c"
			default:
			{
#line 837 "completion.vala"
				break;
#line 3998 "completion.c"
			}
		}
	} else {
#line 811 "completion.vala"
		switch (0) {
#line 4004 "completion.c"
			default:
			{
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				GError* _tmp7_;
				GError* _tmp8_;
#line 840 "completion.vala"
				_tmp3_ = g_strconcat ("unknown element \"", name, NULL);
#line 840 "completion.vala"
				_tmp4_ = _tmp3_;
#line 840 "completion.vala"
				_tmp5_ = g_strconcat (_tmp4_, "\"", NULL);
#line 840 "completion.vala"
				_tmp6_ = _tmp5_;
#line 840 "completion.vala"
				_tmp7_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp6_);
#line 840 "completion.vala"
				_tmp8_ = _tmp7_;
#line 840 "completion.vala"
				_g_free0 (_tmp6_);
#line 840 "completion.vala"
				_g_free0 (_tmp4_);
#line 840 "completion.vala"
				_inner_error0_ = _tmp8_;
#line 840 "completion.vala"
				if (_inner_error0_->domain == G_MARKUP_ERROR) {
#line 840 "completion.vala"
					g_propagate_error (error, _inner_error0_);
#line 840 "completion.vala"
					return;
#line 4037 "completion.c"
				} else {
#line 840 "completion.vala"
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 840 "completion.vala"
					g_clear_error (&_inner_error0_);
#line 840 "completion.vala"
					return;
#line 4045 "completion.c"
				}
			}
		}
	}
}

static void
completion_provider_parser_add_command (CompletionProvider* self,
                                        gchar** attr_names,
                                        gint attr_names_length1,
                                        gchar** attr_values,
                                        gint attr_values_length1,
                                        GError** error)
{
	GError* _inner_error0_ = NULL;
#line 845 "completion.vala"
	g_return_if_fail (self != NULL);
#line 848 "completion.vala"
	completion_provider_completion_command_destroy (&self->priv->_current_command);
#line 848 "completion.vala"
	memset (&self->priv->_current_command, 0, sizeof (CompletionProviderCompletionCommand));
#line 4067 "completion.c"
	{
		gint attr_num = 0;
#line 849 "completion.vala"
		attr_num = 0;
#line 4072 "completion.c"
		{
			gboolean _tmp0_ = FALSE;
#line 849 "completion.vala"
			_tmp0_ = TRUE;
#line 849 "completion.vala"
			while (TRUE) {
#line 4079 "completion.c"
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				GQuark _tmp5_ = 0U;
#line 851 "completion.vala"
				static GQuark _tmp4_label0 = 0;
#line 851 "completion.vala"
				static GQuark _tmp4_label1 = 0;
#line 851 "completion.vala"
				static GQuark _tmp4_label2 = 0;
#line 849 "completion.vala"
				if (!_tmp0_) {
#line 4091 "completion.c"
					gint _tmp1_;
#line 849 "completion.vala"
					_tmp1_ = attr_num;
#line 849 "completion.vala"
					attr_num = _tmp1_ + 1;
#line 4097 "completion.c"
				}
#line 849 "completion.vala"
				_tmp0_ = FALSE;
#line 849 "completion.vala"
				if (!(attr_num < attr_names_length1)) {
#line 849 "completion.vala"
					break;
#line 4105 "completion.c"
				}
#line 851 "completion.vala"
				_tmp2_ = attr_names[attr_num];
#line 851 "completion.vala"
				_tmp3_ = _tmp2_;
#line 851 "completion.vala"
				_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
#line 851 "completion.vala"
				if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("name")))) {
#line 851 "completion.vala"
					switch (0) {
#line 4117 "completion.c"
						default:
						{
							const gchar* _tmp6_;
							gchar* _tmp7_;
#line 854 "completion.vala"
							_tmp6_ = attr_values[attr_num];
#line 854 "completion.vala"
							_tmp7_ = g_strconcat ("\\", _tmp6_, NULL);
#line 854 "completion.vala"
							_g_free0 (self->priv->_current_command.name);
#line 854 "completion.vala"
							self->priv->_current_command.name = _tmp7_;
#line 855 "completion.vala"
							break;
#line 4132 "completion.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("package")))) {
#line 851 "completion.vala"
					switch (0) {
#line 4138 "completion.c"
						default:
						{
							const gchar* _tmp8_;
							gchar* _tmp9_;
#line 858 "completion.vala"
							_tmp8_ = attr_values[attr_num];
#line 858 "completion.vala"
							_tmp9_ = g_strdup (_tmp8_);
#line 858 "completion.vala"
							_g_free0 (self->priv->_current_command.package);
#line 858 "completion.vala"
							self->priv->_current_command.package = _tmp9_;
#line 859 "completion.vala"
							break;
#line 4153 "completion.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label2) ? _tmp4_label2 : (_tmp4_label2 = g_quark_from_static_string ("environment")))) {
#line 851 "completion.vala"
					switch (0) {
#line 4159 "completion.c"
						default:
						{
#line 863 "completion.vala"
							break;
#line 4164 "completion.c"
						}
					}
				} else {
#line 851 "completion.vala"
					switch (0) {
#line 4170 "completion.c"
						default:
						{
							const gchar* _tmp10_;
							gchar* _tmp11_;
							gchar* _tmp12_;
							gchar* _tmp13_;
							gchar* _tmp14_;
							GError* _tmp15_;
							GError* _tmp16_;
#line 866 "completion.vala"
							_tmp10_ = attr_names[attr_num];
#line 866 "completion.vala"
							_tmp11_ = g_strconcat ("unknown command attribute \"", _tmp10_, NULL);
#line 866 "completion.vala"
							_tmp12_ = _tmp11_;
#line 866 "completion.vala"
							_tmp13_ = g_strconcat (_tmp12_, "\"", NULL);
#line 866 "completion.vala"
							_tmp14_ = _tmp13_;
#line 866 "completion.vala"
							_tmp15_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp14_);
#line 866 "completion.vala"
							_tmp16_ = _tmp15_;
#line 866 "completion.vala"
							_g_free0 (_tmp14_);
#line 866 "completion.vala"
							_g_free0 (_tmp12_);
#line 866 "completion.vala"
							_inner_error0_ = _tmp16_;
#line 866 "completion.vala"
							if (_inner_error0_->domain == G_MARKUP_ERROR) {
#line 866 "completion.vala"
								g_propagate_error (error, _inner_error0_);
#line 866 "completion.vala"
								return;
#line 4206 "completion.c"
							} else {
#line 866 "completion.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 866 "completion.vala"
								g_clear_error (&_inner_error0_);
#line 866 "completion.vala"
								return;
#line 4214 "completion.c"
							}
						}
					}
				}
			}
		}
	}
}

static void
completion_provider_parser_add_argument (CompletionProvider* self,
                                         gchar** attr_names,
                                         gint attr_names_length1,
                                         gchar** attr_values,
                                         gint attr_values_length1,
                                         GError** error)
{
	GError* _inner_error0_ = NULL;
#line 872 "completion.vala"
	g_return_if_fail (self != NULL);
#line 875 "completion.vala"
	completion_provider_completion_argument_destroy (&self->priv->_current_arg);
#line 875 "completion.vala"
	memset (&self->priv->_current_arg, 0, sizeof (CompletionProviderCompletionArgument));
#line 876 "completion.vala"
	self->priv->_current_arg.optional = FALSE;
#line 4241 "completion.c"
	{
		gint attr_num = 0;
#line 878 "completion.vala"
		attr_num = 0;
#line 4246 "completion.c"
		{
			gboolean _tmp0_ = FALSE;
#line 878 "completion.vala"
			_tmp0_ = TRUE;
#line 878 "completion.vala"
			while (TRUE) {
#line 4253 "completion.c"
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				GQuark _tmp5_ = 0U;
#line 880 "completion.vala"
				static GQuark _tmp4_label0 = 0;
#line 880 "completion.vala"
				static GQuark _tmp4_label1 = 0;
#line 878 "completion.vala"
				if (!_tmp0_) {
#line 4263 "completion.c"
					gint _tmp1_;
#line 878 "completion.vala"
					_tmp1_ = attr_num;
#line 878 "completion.vala"
					attr_num = _tmp1_ + 1;
#line 4269 "completion.c"
				}
#line 878 "completion.vala"
				_tmp0_ = FALSE;
#line 878 "completion.vala"
				if (!(attr_num < attr_names_length1)) {
#line 878 "completion.vala"
					break;
#line 4277 "completion.c"
				}
#line 880 "completion.vala"
				_tmp2_ = attr_names[attr_num];
#line 880 "completion.vala"
				_tmp3_ = _tmp2_;
#line 880 "completion.vala"
				_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
#line 880 "completion.vala"
				if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("label")))) {
#line 880 "completion.vala"
					switch (0) {
#line 4289 "completion.c"
						default:
						{
							const gchar* _tmp6_;
							gchar* _tmp7_;
#line 883 "completion.vala"
							_tmp6_ = attr_values[attr_num];
#line 883 "completion.vala"
							_tmp7_ = g_strdup (_tmp6_);
#line 883 "completion.vala"
							_g_free0 (self->priv->_current_arg.label);
#line 883 "completion.vala"
							self->priv->_current_arg.label = _tmp7_;
#line 884 "completion.vala"
							break;
#line 4304 "completion.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("type")))) {
#line 880 "completion.vala"
					switch (0) {
#line 4310 "completion.c"
						default:
						{
							const gchar* _tmp8_;
#line 887 "completion.vala"
							_tmp8_ = attr_values[attr_num];
#line 887 "completion.vala"
							self->priv->_current_arg.optional = g_strcmp0 (_tmp8_, "optional") == 0;
#line 888 "completion.vala"
							break;
#line 4320 "completion.c"
						}
					}
				} else {
#line 880 "completion.vala"
					switch (0) {
#line 4326 "completion.c"
						default:
						{
							const gchar* _tmp9_;
							gchar* _tmp10_;
							gchar* _tmp11_;
							gchar* _tmp12_;
							gchar* _tmp13_;
							GError* _tmp14_;
							GError* _tmp15_;
#line 891 "completion.vala"
							_tmp9_ = attr_names[attr_num];
#line 891 "completion.vala"
							_tmp10_ = g_strconcat ("unknown argument attribute \"", _tmp9_, NULL);
#line 891 "completion.vala"
							_tmp11_ = _tmp10_;
#line 891 "completion.vala"
							_tmp12_ = g_strconcat (_tmp11_, "\"", NULL);
#line 891 "completion.vala"
							_tmp13_ = _tmp12_;
#line 891 "completion.vala"
							_tmp14_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp13_);
#line 891 "completion.vala"
							_tmp15_ = _tmp14_;
#line 891 "completion.vala"
							_g_free0 (_tmp13_);
#line 891 "completion.vala"
							_g_free0 (_tmp11_);
#line 891 "completion.vala"
							_inner_error0_ = _tmp15_;
#line 891 "completion.vala"
							if (_inner_error0_->domain == G_MARKUP_ERROR) {
#line 891 "completion.vala"
								g_propagate_error (error, _inner_error0_);
#line 891 "completion.vala"
								return;
#line 4362 "completion.c"
							} else {
#line 891 "completion.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 891 "completion.vala"
								g_clear_error (&_inner_error0_);
#line 891 "completion.vala"
								return;
#line 4370 "completion.c"
							}
						}
					}
				}
			}
		}
	}
}

static void
completion_provider_parser_add_choice (CompletionProvider* self,
                                       gchar** attr_names,
                                       gint attr_names_length1,
                                       gchar** attr_values,
                                       gint attr_values_length1,
                                       GError** error)
{
	GError* _inner_error0_ = NULL;
#line 897 "completion.vala"
	g_return_if_fail (self != NULL);
#line 900 "completion.vala"
	completion_provider_completion_choice_destroy (&self->priv->_current_choice);
#line 900 "completion.vala"
	memset (&self->priv->_current_choice, 0, sizeof (CompletionProviderCompletionChoice));
#line 4395 "completion.c"
	{
		gint attr_num = 0;
#line 902 "completion.vala"
		attr_num = 0;
#line 4400 "completion.c"
		{
			gboolean _tmp0_ = FALSE;
#line 902 "completion.vala"
			_tmp0_ = TRUE;
#line 902 "completion.vala"
			while (TRUE) {
#line 4407 "completion.c"
				const gchar* _tmp2_;
				const gchar* _tmp3_;
				GQuark _tmp5_ = 0U;
#line 904 "completion.vala"
				static GQuark _tmp4_label0 = 0;
#line 904 "completion.vala"
				static GQuark _tmp4_label1 = 0;
#line 902 "completion.vala"
				if (!_tmp0_) {
#line 4417 "completion.c"
					gint _tmp1_;
#line 902 "completion.vala"
					_tmp1_ = attr_num;
#line 902 "completion.vala"
					attr_num = _tmp1_ + 1;
#line 4423 "completion.c"
				}
#line 902 "completion.vala"
				_tmp0_ = FALSE;
#line 902 "completion.vala"
				if (!(attr_num < attr_names_length1)) {
#line 902 "completion.vala"
					break;
#line 4431 "completion.c"
				}
#line 904 "completion.vala"
				_tmp2_ = attr_names[attr_num];
#line 904 "completion.vala"
				_tmp3_ = _tmp2_;
#line 904 "completion.vala"
				_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
#line 904 "completion.vala"
				if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("name")))) {
#line 904 "completion.vala"
					switch (0) {
#line 4443 "completion.c"
						default:
						{
							const gchar* _tmp6_;
							gchar* _tmp7_;
#line 907 "completion.vala"
							_tmp6_ = attr_values[attr_num];
#line 907 "completion.vala"
							_tmp7_ = g_strdup (_tmp6_);
#line 907 "completion.vala"
							_g_free0 (self->priv->_current_choice.name);
#line 907 "completion.vala"
							self->priv->_current_choice.name = _tmp7_;
#line 908 "completion.vala"
							break;
#line 4458 "completion.c"
						}
					}
				} else if (_tmp5_ == ((0 != _tmp4_label1) ? _tmp4_label1 : (_tmp4_label1 = g_quark_from_static_string ("package")))) {
#line 904 "completion.vala"
					switch (0) {
#line 4464 "completion.c"
						default:
						{
							const gchar* _tmp8_;
							gchar* _tmp9_;
#line 911 "completion.vala"
							_tmp8_ = attr_values[attr_num];
#line 911 "completion.vala"
							_tmp9_ = g_strdup (_tmp8_);
#line 911 "completion.vala"
							_g_free0 (self->priv->_current_choice.package);
#line 911 "completion.vala"
							self->priv->_current_choice.package = _tmp9_;
#line 912 "completion.vala"
							break;
#line 4479 "completion.c"
						}
					}
				} else {
#line 904 "completion.vala"
					switch (0) {
#line 4485 "completion.c"
						default:
						{
							const gchar* _tmp10_;
							gchar* _tmp11_;
							gchar* _tmp12_;
							gchar* _tmp13_;
							gchar* _tmp14_;
							GError* _tmp15_;
							GError* _tmp16_;
#line 915 "completion.vala"
							_tmp10_ = attr_names[attr_num];
#line 915 "completion.vala"
							_tmp11_ = g_strconcat ("unknown choice attribute \"", _tmp10_, NULL);
#line 915 "completion.vala"
							_tmp12_ = _tmp11_;
#line 915 "completion.vala"
							_tmp13_ = g_strconcat (_tmp12_, "\"", NULL);
#line 915 "completion.vala"
							_tmp14_ = _tmp13_;
#line 915 "completion.vala"
							_tmp15_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp14_);
#line 915 "completion.vala"
							_tmp16_ = _tmp15_;
#line 915 "completion.vala"
							_g_free0 (_tmp14_);
#line 915 "completion.vala"
							_g_free0 (_tmp12_);
#line 915 "completion.vala"
							_inner_error0_ = _tmp16_;
#line 915 "completion.vala"
							if (_inner_error0_->domain == G_MARKUP_ERROR) {
#line 915 "completion.vala"
								g_propagate_error (error, _inner_error0_);
#line 915 "completion.vala"
								return;
#line 4521 "completion.c"
							} else {
#line 915 "completion.vala"
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 915 "completion.vala"
								g_clear_error (&_inner_error0_);
#line 915 "completion.vala"
								return;
#line 4529 "completion.c"
							}
						}
					}
				}
			}
		}
	}
}

static void
_vala_array_add2 (CompletionProviderCompletionArgument* * array,
                  gint* length,
                  gint* size,
                  const CompletionProviderCompletionArgument* value)
{
#line 943 "completion.vala"
	if ((*length) == (*size)) {
#line 943 "completion.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 943 "completion.vala"
		*array = g_renew (CompletionProviderCompletionArgument, *array, *size);
#line 4551 "completion.c"
	}
#line 943 "completion.vala"
	(*array)[(*length)++] = *value;
#line 4555 "completion.c"
}

static void
_vala_array_add3 (CompletionProviderCompletionChoice* * array,
                  gint* length,
                  gint* size,
                  const CompletionProviderCompletionChoice* value)
{
#line 947 "completion.vala"
	if ((*length) == (*size)) {
#line 947 "completion.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 947 "completion.vala"
		*array = g_renew (CompletionProviderCompletionChoice, *array, *size);
#line 4570 "completion.c"
	}
#line 947 "completion.vala"
	(*array)[(*length)++] = *value;
#line 4574 "completion.c"
}

static void
completion_provider_parser_end (CompletionProvider* self,
                                GMarkupParseContext* context,
                                const gchar* name,
                                GError** error)
{
	const gchar* _tmp0_;
	GQuark _tmp2_ = 0U;
#line 923 "completion.vala"
	static GQuark _tmp1_label0 = 0;
#line 923 "completion.vala"
	static GQuark _tmp1_label1 = 0;
#line 923 "completion.vala"
	static GQuark _tmp1_label2 = 0;
#line 921 "completion.vala"
	g_return_if_fail (self != NULL);
#line 921 "completion.vala"
	g_return_if_fail (context != NULL);
#line 921 "completion.vala"
	g_return_if_fail (name != NULL);
#line 923 "completion.vala"
	_tmp0_ = name;
#line 923 "completion.vala"
	_tmp2_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
#line 923 "completion.vala"
	if (_tmp2_ == ((0 != _tmp1_label0) ? _tmp1_label0 : (_tmp1_label0 = g_quark_from_static_string ("command")))) {
#line 923 "completion.vala"
		switch (0) {
#line 4605 "completion.c"
			default:
			{
				GdkPixbuf* _tmp3_ = NULL;
				CompletionProviderCompletionCommand _tmp4_;
				const gchar* _tmp5_;
				GdkPixbuf* pixbuf = NULL;
				GdkPixbuf* _tmp8_;
				GtkSourceCompletionItem* item = NULL;
				GtkSourceCompletionItem* _tmp9_;
				GtkSourceCompletionItem* _tmp10_;
				CompletionProviderCompletionCommand _tmp11_;
				const gchar* _tmp12_;
				GtkSourceCompletionItem* _tmp13_;
				CompletionProviderCompletionCommand _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				GtkSourceCompletionItem* _tmp17_;
				GdkPixbuf* _tmp18_;
				GtkSourceCompletionItem* _tmp19_;
				CompletionProviderCompletionCommand _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				GtkSourceCompletionItem* _tmp23_;
				GtkSourceCompletionItem* _tmp24_;
				CompletionProviderCompletionCommand _tmp25_;
				CompletionProviderCompletionArgument* _tmp26_;
				gint _tmp26__length1;
#line 926 "completion.vala"
				_tmp4_ = self->priv->_current_command;
#line 926 "completion.vala"
				_tmp5_ = _tmp4_.package;
#line 926 "completion.vala"
				if (_tmp5_ != NULL) {
#line 4639 "completion.c"
					GdkPixbuf* _tmp6_;
#line 927 "completion.vala"
					_tmp6_ = self->priv->_icon_package_required;
#line 927 "completion.vala"
					_tmp3_ = _tmp6_;
#line 4645 "completion.c"
				} else {
					GdkPixbuf* _tmp7_;
#line 927 "completion.vala"
					_tmp7_ = self->priv->_icon_cmd;
#line 927 "completion.vala"
					_tmp3_ = _tmp7_;
#line 4652 "completion.c"
				}
#line 926 "completion.vala"
				_tmp8_ = _g_object_ref0 (_tmp3_);
#line 926 "completion.vala"
				pixbuf = _tmp8_;
#line 929 "completion.vala"
				_tmp9_ = gtk_source_completion_item_new ();
#line 929 "completion.vala"
				item = _tmp9_;
#line 930 "completion.vala"
				_tmp10_ = item;
#line 930 "completion.vala"
				_tmp11_ = self->priv->_current_command;
#line 930 "completion.vala"
				_tmp12_ = _tmp11_.name;
#line 930 "completion.vala"
				gtk_source_completion_item_set_label (_tmp10_, _tmp12_);
#line 931 "completion.vala"
				_tmp13_ = item;
#line 931 "completion.vala"
				_tmp14_ = self->priv->_current_command;
#line 931 "completion.vala"
				_tmp15_ = completion_provider_get_command_text_to_insert (self, &_tmp14_);
#line 931 "completion.vala"
				_tmp16_ = _tmp15_;
#line 931 "completion.vala"
				gtk_source_completion_item_set_text (_tmp13_, _tmp16_);
#line 931 "completion.vala"
				_g_free0 (_tmp16_);
#line 932 "completion.vala"
				_tmp17_ = item;
#line 932 "completion.vala"
				_tmp18_ = pixbuf;
#line 932 "completion.vala"
				gtk_source_completion_item_set_icon (_tmp17_, _tmp18_);
#line 933 "completion.vala"
				_tmp19_ = item;
#line 933 "completion.vala"
				_tmp20_ = self->priv->_current_command;
#line 933 "completion.vala"
				_tmp21_ = completion_provider_get_command_info (self, &_tmp20_, -1);
#line 933 "completion.vala"
				_tmp22_ = _tmp21_;
#line 933 "completion.vala"
				gtk_source_completion_item_set_info (_tmp19_, _tmp22_);
#line 933 "completion.vala"
				_g_free0 (_tmp22_);
#line 934 "completion.vala"
				_tmp23_ = item;
#line 934 "completion.vala"
				_tmp24_ = _g_object_ref0 (_tmp23_);
#line 934 "completion.vala"
				self->priv->_proposals = g_list_prepend (self->priv->_proposals, _tmp24_);
#line 938 "completion.vala"
				_tmp25_ = self->priv->_current_command;
#line 938 "completion.vala"
				_tmp26_ = _tmp25_.args;
#line 938 "completion.vala"
				_tmp26__length1 = _tmp25_.args_length1;
#line 938 "completion.vala"
				if (0 < _tmp26__length1) {
#line 4714 "completion.c"
					GeeHashMap* _tmp27_;
					CompletionProviderCompletionCommand _tmp28_;
					const gchar* _tmp29_;
					CompletionProviderCompletionCommand _tmp30_;
#line 939 "completion.vala"
					_tmp27_ = self->priv->_commands;
#line 939 "completion.vala"
					_tmp28_ = self->priv->_current_command;
#line 939 "completion.vala"
					_tmp29_ = _tmp28_.name;
#line 939 "completion.vala"
					_tmp30_ = self->priv->_current_command;
#line 939 "completion.vala"
					gee_abstract_map_set ((GeeAbstractMap*) _tmp27_, _tmp29_, &_tmp30_);
#line 4729 "completion.c"
				}
#line 940 "completion.vala"
				_g_object_unref0 (item);
#line 940 "completion.vala"
				_g_object_unref0 (pixbuf);
#line 940 "completion.vala"
				break;
#line 4737 "completion.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label1) ? _tmp1_label1 : (_tmp1_label1 = g_quark_from_static_string ("argument")))) {
#line 923 "completion.vala"
		switch (0) {
#line 4743 "completion.c"
			default:
			{
				CompletionProviderCompletionArgument _tmp31_;
				CompletionProviderCompletionArgument _tmp32_;
				CompletionProviderCompletionArgument _tmp33_ = {0};
#line 943 "completion.vala"
				_tmp31_ = self->priv->_current_arg;
#line 943 "completion.vala"
				_tmp32_ = _tmp31_;
#line 943 "completion.vala"
				completion_provider_completion_argument_copy (&_tmp32_, &_tmp33_);
#line 943 "completion.vala"
				_vala_array_add2 (&self->priv->_current_command.args, &self->priv->_current_command.args_length1, &self->priv->_current_command._args_size_, &_tmp33_);
#line 944 "completion.vala"
				break;
#line 4759 "completion.c"
			}
		}
	} else if (_tmp2_ == ((0 != _tmp1_label2) ? _tmp1_label2 : (_tmp1_label2 = g_quark_from_static_string ("choice")))) {
#line 923 "completion.vala"
		switch (0) {
#line 4765 "completion.c"
			default:
			{
				CompletionProviderCompletionChoice _tmp34_;
				CompletionProviderCompletionChoice _tmp35_;
				CompletionProviderCompletionChoice _tmp36_ = {0};
				gboolean _tmp37_ = FALSE;
				CompletionProviderCompletionChoice _tmp38_;
				const gchar* _tmp39_;
#line 947 "completion.vala"
				_tmp34_ = self->priv->_current_choice;
#line 947 "completion.vala"
				_tmp35_ = _tmp34_;
#line 947 "completion.vala"
				completion_provider_completion_choice_copy (&_tmp35_, &_tmp36_);
#line 947 "completion.vala"
				_vala_array_add3 (&self->priv->_current_arg.choices, &self->priv->_current_arg.choices_length1, &self->priv->_current_arg._choices_size_, &_tmp36_);
#line 948 "completion.vala"
				_tmp38_ = self->priv->_current_choice;
#line 948 "completion.vala"
				_tmp39_ = _tmp38_.insert;
#line 948 "completion.vala"
				if (_tmp39_ != NULL) {
#line 948 "completion.vala"
					_tmp37_ = TRUE;
#line 4790 "completion.c"
				} else {
					CompletionProviderCompletionChoice _tmp40_;
					const gchar* _tmp41_;
#line 949 "completion.vala"
					_tmp40_ = self->priv->_current_choice;
#line 949 "completion.vala"
					_tmp41_ = _tmp40_.insert_after;
#line 949 "completion.vala"
					_tmp37_ = _tmp41_ != NULL;
#line 4800 "completion.c"
				}
#line 948 "completion.vala"
				if (_tmp37_) {
#line 4804 "completion.c"
					GeeHashMap* _tmp42_;
					CompletionProviderCompletionChoice _tmp43_;
					const gchar* _tmp44_;
					CompletionProviderCompletionChoice _tmp45_;
#line 950 "completion.vala"
					_tmp42_ = self->priv->_environments;
#line 950 "completion.vala"
					_tmp43_ = self->priv->_current_choice;
#line 950 "completion.vala"
					_tmp44_ = _tmp43_.name;
#line 950 "completion.vala"
					_tmp45_ = self->priv->_current_choice;
#line 950 "completion.vala"
					gee_abstract_map_set ((GeeAbstractMap*) _tmp42_, _tmp44_, &_tmp45_);
#line 4819 "completion.c"
				}
#line 951 "completion.vala"
				break;
#line 4823 "completion.c"
			}
		}
	}
}

static void
completion_provider_parser_text (CompletionProvider* self,
                                 GMarkupParseContext* context,
                                 const gchar* text,
                                 gsize text_len,
                                 GError** error)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
#line 958 "completion.vala"
	static GQuark _tmp2_label0 = 0;
#line 958 "completion.vala"
	static GQuark _tmp2_label1 = 0;
#line 955 "completion.vala"
	g_return_if_fail (self != NULL);
#line 955 "completion.vala"
	g_return_if_fail (context != NULL);
#line 955 "completion.vala"
	g_return_if_fail (text != NULL);
#line 958 "completion.vala"
	_tmp0_ = g_markup_parse_context_get_element (context);
#line 958 "completion.vala"
	_tmp1_ = _tmp0_;
#line 958 "completion.vala"
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
#line 958 "completion.vala"
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("insert")))) {
#line 958 "completion.vala"
		switch (0) {
#line 4859 "completion.c"
			default:
			{
				gchar* _tmp4_;
#line 961 "completion.vala"
				_tmp4_ = g_strdup (text);
#line 961 "completion.vala"
				_g_free0 (self->priv->_current_choice.insert);
#line 961 "completion.vala"
				self->priv->_current_choice.insert = _tmp4_;
#line 962 "completion.vala"
				break;
#line 4871 "completion.c"
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("insert_after")))) {
#line 958 "completion.vala"
		switch (0) {
#line 4877 "completion.c"
			default:
			{
				gchar* _tmp5_;
#line 965 "completion.vala"
				_tmp5_ = g_strdup (text);
#line 965 "completion.vala"
				_g_free0 (self->priv->_current_choice.insert_after);
#line 965 "completion.vala"
				self->priv->_current_choice.insert_after = _tmp5_;
#line 966 "completion.vala"
				break;
#line 4889 "completion.c"
			}
		}
	}
}

static void
_vala_CompletionProviderCompletionArgument_array_free (CompletionProviderCompletionArgument * array,
                                                       gint array_length)
{
#line 31 "completion.vala"
	if (array != NULL) {
#line 4901 "completion.c"
		gint i;
#line 31 "completion.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 31 "completion.vala"
			completion_provider_completion_argument_destroy (&array[i]);
#line 4907 "completion.c"
		}
	}
#line 31 "completion.vala"
	g_free (array);
#line 4912 "completion.c"
}

static CompletionProviderCompletionArgument*
_vala_array_dup1 (CompletionProviderCompletionArgument* self,
                  gint length)
{
#line 27 "completion.vala"
	if (length > 0) {
#line 4921 "completion.c"
		CompletionProviderCompletionArgument* result;
		gint i;
#line 27 "completion.vala"
		result = g_new0 (CompletionProviderCompletionArgument, length);
#line 27 "completion.vala"
		for (i = 0; i < length; i++) {
#line 4928 "completion.c"
			CompletionProviderCompletionArgument _tmp0_;
			CompletionProviderCompletionArgument _tmp1_ = {0};
#line 27 "completion.vala"
			_tmp0_ = self[i];
#line 27 "completion.vala"
			completion_provider_completion_argument_copy (&_tmp0_, &_tmp1_);
#line 27 "completion.vala"
			result[i] = _tmp1_;
#line 4937 "completion.c"
		}
#line 27 "completion.vala"
		return result;
#line 4941 "completion.c"
	}
#line 27 "completion.vala"
	return NULL;
#line 4945 "completion.c"
}

static void
completion_provider_completion_command_copy (const CompletionProviderCompletionCommand* self,
                                             CompletionProviderCompletionCommand* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	CompletionProviderCompletionArgument* _tmp4_;
	gint _tmp4__length1;
	CompletionProviderCompletionArgument* _tmp5_;
	gint _tmp5__length1;
#line 27 "completion.vala"
	_tmp0_ = (*self).name;
#line 27 "completion.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 27 "completion.vala"
	_g_free0 ((*dest).name);
#line 27 "completion.vala"
	(*dest).name = _tmp1_;
#line 27 "completion.vala"
	_tmp2_ = (*self).package;
#line 27 "completion.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 27 "completion.vala"
	_g_free0 ((*dest).package);
#line 27 "completion.vala"
	(*dest).package = _tmp3_;
#line 27 "completion.vala"
	_tmp4_ = (*self).args;
#line 27 "completion.vala"
	_tmp4__length1 = (*self).args_length1;
#line 27 "completion.vala"
	_tmp5_ = (_tmp4_ != NULL) ? _vala_array_dup1 (_tmp4_, _tmp4__length1) : ((gpointer) _tmp4_);
#line 27 "completion.vala"
	_tmp5__length1 = _tmp4__length1;
#line 27 "completion.vala"
	(*dest).args = (_vala_CompletionProviderCompletionArgument_array_free ((*dest).args, (*dest).args_length1), NULL);
#line 27 "completion.vala"
	(*dest).args = _tmp5_;
#line 27 "completion.vala"
	(*dest).args_length1 = _tmp5__length1;
#line 27 "completion.vala"
	(*dest)._args_size_ = (*dest).args_length1;
#line 4992 "completion.c"
}

static void
completion_provider_completion_command_destroy (CompletionProviderCompletionCommand* self)
{
#line 29 "completion.vala"
	_g_free0 ((*self).name);
#line 30 "completion.vala"
	_g_free0 ((*self).package);
#line 31 "completion.vala"
	(*self).args = (_vala_CompletionProviderCompletionArgument_array_free ((*self).args, (*self).args_length1), NULL);
#line 5004 "completion.c"
}

static CompletionProviderCompletionCommand*
completion_provider_completion_command_dup (const CompletionProviderCompletionCommand* self)
{
	CompletionProviderCompletionCommand* dup;
#line 27 "completion.vala"
	dup = g_new0 (CompletionProviderCompletionCommand, 1);
#line 27 "completion.vala"
	completion_provider_completion_command_copy (self, dup);
#line 27 "completion.vala"
	return dup;
#line 5017 "completion.c"
}

static void
completion_provider_completion_command_free (CompletionProviderCompletionCommand* self)
{
#line 27 "completion.vala"
	completion_provider_completion_command_destroy (self);
#line 27 "completion.vala"
	g_free (self);
#line 5027 "completion.c"
}

static GType
completion_provider_completion_command_get_type_once (void)
{
	GType completion_provider_completion_command_type_id;
	completion_provider_completion_command_type_id = g_boxed_type_register_static ("CompletionProviderCompletionCommand", (GBoxedCopyFunc) completion_provider_completion_command_dup, (GBoxedFreeFunc) completion_provider_completion_command_free);
	return completion_provider_completion_command_type_id;
}

static GType
completion_provider_completion_command_get_type (void)
{
	static volatile gsize completion_provider_completion_command_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_completion_command_type_id__volatile)) {
		GType completion_provider_completion_command_type_id;
		completion_provider_completion_command_type_id = completion_provider_completion_command_get_type_once ();
		g_once_init_leave (&completion_provider_completion_command_type_id__volatile, completion_provider_completion_command_type_id);
	}
	return completion_provider_completion_command_type_id__volatile;
}

static void
_vala_CompletionProviderCompletionChoice_array_free (CompletionProviderCompletionChoice * array,
                                                     gint array_length)
{
#line 38 "completion.vala"
	if (array != NULL) {
#line 5056 "completion.c"
		gint i;
#line 38 "completion.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 38 "completion.vala"
			completion_provider_completion_choice_destroy (&array[i]);
#line 5062 "completion.c"
		}
	}
#line 38 "completion.vala"
	g_free (array);
#line 5067 "completion.c"
}

static CompletionProviderCompletionChoice*
_vala_array_dup2 (CompletionProviderCompletionChoice* self,
                  gint length)
{
#line 34 "completion.vala"
	if (length > 0) {
#line 5076 "completion.c"
		CompletionProviderCompletionChoice* result;
		gint i;
#line 34 "completion.vala"
		result = g_new0 (CompletionProviderCompletionChoice, length);
#line 34 "completion.vala"
		for (i = 0; i < length; i++) {
#line 5083 "completion.c"
			CompletionProviderCompletionChoice _tmp0_;
			CompletionProviderCompletionChoice _tmp1_ = {0};
#line 34 "completion.vala"
			_tmp0_ = self[i];
#line 34 "completion.vala"
			completion_provider_completion_choice_copy (&_tmp0_, &_tmp1_);
#line 34 "completion.vala"
			result[i] = _tmp1_;
#line 5092 "completion.c"
		}
#line 34 "completion.vala"
		return result;
#line 5096 "completion.c"
	}
#line 34 "completion.vala"
	return NULL;
#line 5100 "completion.c"
}

static void
completion_provider_completion_argument_copy (const CompletionProviderCompletionArgument* self,
                                              CompletionProviderCompletionArgument* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	CompletionProviderCompletionChoice* _tmp2_;
	gint _tmp2__length1;
	CompletionProviderCompletionChoice* _tmp3_;
	gint _tmp3__length1;
#line 34 "completion.vala"
	_tmp0_ = (*self).label;
#line 34 "completion.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 34 "completion.vala"
	_g_free0 ((*dest).label);
#line 34 "completion.vala"
	(*dest).label = _tmp1_;
#line 34 "completion.vala"
	(*dest).optional = (*self).optional;
#line 34 "completion.vala"
	_tmp2_ = (*self).choices;
#line 34 "completion.vala"
	_tmp2__length1 = (*self).choices_length1;
#line 34 "completion.vala"
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup2 (_tmp2_, _tmp2__length1) : ((gpointer) _tmp2_);
#line 34 "completion.vala"
	_tmp3__length1 = _tmp2__length1;
#line 34 "completion.vala"
	(*dest).choices = (_vala_CompletionProviderCompletionChoice_array_free ((*dest).choices, (*dest).choices_length1), NULL);
#line 34 "completion.vala"
	(*dest).choices = _tmp3_;
#line 34 "completion.vala"
	(*dest).choices_length1 = _tmp3__length1;
#line 34 "completion.vala"
	(*dest)._choices_size_ = (*dest).choices_length1;
#line 5139 "completion.c"
}

static void
completion_provider_completion_argument_destroy (CompletionProviderCompletionArgument* self)
{
#line 36 "completion.vala"
	_g_free0 ((*self).label);
#line 38 "completion.vala"
	(*self).choices = (_vala_CompletionProviderCompletionChoice_array_free ((*self).choices, (*self).choices_length1), NULL);
#line 5149 "completion.c"
}

static CompletionProviderCompletionArgument*
completion_provider_completion_argument_dup (const CompletionProviderCompletionArgument* self)
{
	CompletionProviderCompletionArgument* dup;
#line 34 "completion.vala"
	dup = g_new0 (CompletionProviderCompletionArgument, 1);
#line 34 "completion.vala"
	completion_provider_completion_argument_copy (self, dup);
#line 34 "completion.vala"
	return dup;
#line 5162 "completion.c"
}

static void
completion_provider_completion_argument_free (CompletionProviderCompletionArgument* self)
{
#line 34 "completion.vala"
	completion_provider_completion_argument_destroy (self);
#line 34 "completion.vala"
	g_free (self);
#line 5172 "completion.c"
}

static GType
completion_provider_completion_argument_get_type_once (void)
{
	GType completion_provider_completion_argument_type_id;
	completion_provider_completion_argument_type_id = g_boxed_type_register_static ("CompletionProviderCompletionArgument", (GBoxedCopyFunc) completion_provider_completion_argument_dup, (GBoxedFreeFunc) completion_provider_completion_argument_free);
	return completion_provider_completion_argument_type_id;
}

static GType
completion_provider_completion_argument_get_type (void)
{
	static volatile gsize completion_provider_completion_argument_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_completion_argument_type_id__volatile)) {
		GType completion_provider_completion_argument_type_id;
		completion_provider_completion_argument_type_id = completion_provider_completion_argument_get_type_once ();
		g_once_init_leave (&completion_provider_completion_argument_type_id__volatile, completion_provider_completion_argument_type_id);
	}
	return completion_provider_completion_argument_type_id__volatile;
}

static void
completion_provider_completion_choice_copy (const CompletionProviderCompletionChoice* self,
                                            CompletionProviderCompletionChoice* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
#line 41 "completion.vala"
	_tmp0_ = (*self).name;
#line 41 "completion.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 41 "completion.vala"
	_g_free0 ((*dest).name);
#line 41 "completion.vala"
	(*dest).name = _tmp1_;
#line 41 "completion.vala"
	_tmp2_ = (*self).package;
#line 41 "completion.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 41 "completion.vala"
	_g_free0 ((*dest).package);
#line 41 "completion.vala"
	(*dest).package = _tmp3_;
#line 41 "completion.vala"
	_tmp4_ = (*self).insert;
#line 41 "completion.vala"
	_tmp5_ = g_strdup (_tmp4_);
#line 41 "completion.vala"
	_g_free0 ((*dest).insert);
#line 41 "completion.vala"
	(*dest).insert = _tmp5_;
#line 41 "completion.vala"
	_tmp6_ = (*self).insert_after;
#line 41 "completion.vala"
	_tmp7_ = g_strdup (_tmp6_);
#line 41 "completion.vala"
	_g_free0 ((*dest).insert_after);
#line 41 "completion.vala"
	(*dest).insert_after = _tmp7_;
#line 5239 "completion.c"
}

static void
completion_provider_completion_choice_destroy (CompletionProviderCompletionChoice* self)
{
#line 43 "completion.vala"
	_g_free0 ((*self).name);
#line 44 "completion.vala"
	_g_free0 ((*self).package);
#line 45 "completion.vala"
	_g_free0 ((*self).insert);
#line 46 "completion.vala"
	_g_free0 ((*self).insert_after);
#line 5253 "completion.c"
}

static CompletionProviderCompletionChoice*
completion_provider_completion_choice_dup (const CompletionProviderCompletionChoice* self)
{
	CompletionProviderCompletionChoice* dup;
#line 41 "completion.vala"
	dup = g_new0 (CompletionProviderCompletionChoice, 1);
#line 41 "completion.vala"
	completion_provider_completion_choice_copy (self, dup);
#line 41 "completion.vala"
	return dup;
#line 5266 "completion.c"
}

static void
completion_provider_completion_choice_free (CompletionProviderCompletionChoice* self)
{
#line 41 "completion.vala"
	completion_provider_completion_choice_destroy (self);
#line 41 "completion.vala"
	g_free (self);
#line 5276 "completion.c"
}

static GType
completion_provider_completion_choice_get_type_once (void)
{
	GType completion_provider_completion_choice_type_id;
	completion_provider_completion_choice_type_id = g_boxed_type_register_static ("CompletionProviderCompletionChoice", (GBoxedCopyFunc) completion_provider_completion_choice_dup, (GBoxedFreeFunc) completion_provider_completion_choice_free);
	return completion_provider_completion_choice_type_id;
}

static GType
completion_provider_completion_choice_get_type (void)
{
	static volatile gsize completion_provider_completion_choice_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_completion_choice_type_id__volatile)) {
		GType completion_provider_completion_choice_type_id;
		completion_provider_completion_choice_type_id = completion_provider_completion_choice_get_type_once ();
		g_once_init_leave (&completion_provider_completion_choice_type_id__volatile, completion_provider_completion_choice_type_id);
	}
	return completion_provider_completion_choice_type_id__volatile;
}

static void
completion_provider_argument_context_copy (const CompletionProviderArgumentContext* self,
                                           CompletionProviderArgumentContext* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
#line 49 "completion.vala"
	_tmp0_ = (*self).cmd_name;
#line 49 "completion.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 49 "completion.vala"
	_g_free0 ((*dest).cmd_name);
#line 49 "completion.vala"
	(*dest).cmd_name = _tmp1_;
#line 49 "completion.vala"
	_tmp2_ = (*self).arg_contents;
#line 49 "completion.vala"
	_tmp3_ = g_strdup (_tmp2_);
#line 49 "completion.vala"
	_g_free0 ((*dest).arg_contents);
#line 49 "completion.vala"
	(*dest).arg_contents = _tmp3_;
#line 49 "completion.vala"
	_tmp4_ = (*self).args_types;
#line 49 "completion.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 49 "completion.vala"
	_g_object_unref0 ((*dest).args_types);
#line 49 "completion.vala"
	(*dest).args_types = _tmp5_;
#line 5333 "completion.c"
}

static void
completion_provider_argument_context_destroy (CompletionProviderArgumentContext* self)
{
#line 51 "completion.vala"
	_g_free0 ((*self).cmd_name);
#line 52 "completion.vala"
	_g_free0 ((*self).arg_contents);
#line 57 "completion.vala"
	_g_object_unref0 ((*self).args_types);
#line 5345 "completion.c"
}

static CompletionProviderArgumentContext*
completion_provider_argument_context_dup (const CompletionProviderArgumentContext* self)
{
	CompletionProviderArgumentContext* dup;
#line 49 "completion.vala"
	dup = g_new0 (CompletionProviderArgumentContext, 1);
#line 49 "completion.vala"
	completion_provider_argument_context_copy (self, dup);
#line 49 "completion.vala"
	return dup;
#line 5358 "completion.c"
}

static void
completion_provider_argument_context_free (CompletionProviderArgumentContext* self)
{
#line 49 "completion.vala"
	completion_provider_argument_context_destroy (self);
#line 49 "completion.vala"
	g_free (self);
#line 5368 "completion.c"
}

static GType
completion_provider_argument_context_get_type_once (void)
{
	GType completion_provider_argument_context_type_id;
	completion_provider_argument_context_type_id = g_boxed_type_register_static ("CompletionProviderArgumentContext", (GBoxedCopyFunc) completion_provider_argument_context_dup, (GBoxedFreeFunc) completion_provider_argument_context_free);
	return completion_provider_argument_context_type_id;
}

static GType
completion_provider_argument_context_get_type (void)
{
	static volatile gsize completion_provider_argument_context_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_argument_context_type_id__volatile)) {
		GType completion_provider_argument_context_type_id;
		completion_provider_argument_context_type_id = completion_provider_argument_context_get_type_once ();
		g_once_init_leave (&completion_provider_argument_context_type_id__volatile, completion_provider_argument_context_type_id);
	}
	return completion_provider_argument_context_type_id__volatile;
}

static void
completion_provider_class_init (CompletionProviderClass * klass,
                                gpointer klass_data)
{
#line 25 "completion.vala"
	completion_provider_parent_class = g_type_class_peek_parent (klass);
#line 25 "completion.vala"
	g_type_class_adjust_private_offset (klass, &CompletionProvider_private_offset);
#line 25 "completion.vala"
	G_OBJECT_CLASS (klass)->finalize = completion_provider_finalize;
#line 5401 "completion.c"
}

static void
completion_provider_gtk_source_completion_provider_interface_init (GtkSourceCompletionProviderIface * iface,
                                                                   gpointer iface_data)
{
#line 25 "completion.vala"
	completion_provider_gtk_source_completion_provider_parent_iface = g_type_interface_peek_parent (iface);
#line 25 "completion.vala"
	iface->get_name = (gchar* (*) (GtkSourceCompletionProvider*)) completion_provider_real_get_name;
#line 25 "completion.vala"
	iface->get_activation = (GtkSourceCompletionActivation (*) (GtkSourceCompletionProvider*)) completion_provider_real_get_activation;
#line 25 "completion.vala"
	iface->match = (gboolean (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*)) completion_provider_real_match;
#line 25 "completion.vala"
	iface->get_start_iter = (gboolean (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GtkSourceCompletionProposal*, GtkTextIter*)) completion_provider_real_get_start_iter;
#line 25 "completion.vala"
	iface->populate = (void (*) (GtkSourceCompletionProvider*, GtkSourceCompletionContext*)) completion_provider_real_populate;
#line 25 "completion.vala"
	iface->activate_proposal = (gboolean (*) (GtkSourceCompletionProvider*, GtkSourceCompletionProposal*, GtkTextIter*)) completion_provider_real_activate_proposal;
#line 5422 "completion.c"
}

static void
completion_provider_instance_init (CompletionProvider * self,
                                   gpointer klass)
{
#line 25 "completion.vala"
	self->priv = completion_provider_get_instance_private (self);
#line 78 "completion.vala"
	self->priv->_calltip_window = NULL;
#line 79 "completion.vala"
	self->priv->_calltip_window_label = NULL;
#line 5435 "completion.c"
}

static void
completion_provider_finalize (GObject * obj)
{
	CompletionProvider * self;
#line 25 "completion.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPLETION_PROVIDER, CompletionProvider);
#line 62 "completion.vala"
	_g_object_unref0 (self->priv->_settings);
#line 64 "completion.vala"
	(self->priv->_proposals == NULL) ? NULL : (self->priv->_proposals = (_g_list_free__g_object_unref0_ (self->priv->_proposals), NULL));
#line 65 "completion.vala"
	_g_object_unref0 (self->priv->_commands);
#line 67 "completion.vala"
	_g_object_unref0 (self->priv->_environments);
#line 70 "completion.vala"
	completion_provider_completion_command_destroy (&self->priv->_current_command);
#line 71 "completion.vala"
	completion_provider_completion_argument_destroy (&self->priv->_current_arg);
#line 72 "completion.vala"
	completion_provider_completion_choice_destroy (&self->priv->_current_choice);
#line 74 "completion.vala"
	_g_object_unref0 (self->priv->_icon_cmd);
#line 75 "completion.vala"
	_g_object_unref0 (self->priv->_icon_choice);
#line 76 "completion.vala"
	_g_object_unref0 (self->priv->_icon_package_required);
#line 78 "completion.vala"
	_g_object_unref0 (self->priv->_calltip_window);
#line 79 "completion.vala"
	_g_object_unref0 (self->priv->_calltip_window_label);
#line 25 "completion.vala"
	G_OBJECT_CLASS (completion_provider_parent_class)->finalize (obj);
#line 5470 "completion.c"
}

static GType
completion_provider_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CompletionProvider), 0, (GInstanceInitFunc) completion_provider_instance_init, NULL };
	static const GInterfaceInfo gtk_source_completion_provider_info = { (GInterfaceInitFunc) completion_provider_gtk_source_completion_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType completion_provider_type_id;
	completion_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "CompletionProvider", &g_define_type_info, 0);
	g_type_add_interface_static (completion_provider_type_id, gtk_source_completion_provider_get_type (), &gtk_source_completion_provider_info);
	CompletionProvider_private_offset = g_type_add_instance_private (completion_provider_type_id, sizeof (CompletionProviderPrivate));
	return completion_provider_type_id;
}

GType
completion_provider_get_type (void)
{
	static volatile gsize completion_provider_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_type_id__volatile)) {
		GType completion_provider_type_id;
		completion_provider_type_id = completion_provider_get_type_once ();
		g_once_init_leave (&completion_provider_type_id__volatile, completion_provider_type_id);
	}
	return completion_provider_type_id__volatile;
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
#line 27 "build_tools_preferences.vala"
	if (array) {
#line 27 "build_tools_preferences.vala"
		while (((gpointer*) array)[length]) {
#line 27 "build_tools_preferences.vala"
			length++;
#line 5508 "completion.c"
		}
	}
#line 27 "build_tools_preferences.vala"
	return length;
#line 5513 "completion.c"
}

