/* clean_build_files.c generated by valac 0.48.9, the Vala compiler
 * generated from clean_build_files.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2011, 2012 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <tepl/tepl.h>
#include <gio/gio.h>
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#define TYPE_CLEAN_BUILD_FILES (clean_build_files_get_type ())
#define CLEAN_BUILD_FILES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CLEAN_BUILD_FILES, CleanBuildFiles))
#define CLEAN_BUILD_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CLEAN_BUILD_FILES, CleanBuildFilesClass))
#define IS_CLEAN_BUILD_FILES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CLEAN_BUILD_FILES))
#define IS_CLEAN_BUILD_FILES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CLEAN_BUILD_FILES))
#define CLEAN_BUILD_FILES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CLEAN_BUILD_FILES, CleanBuildFilesClass))

typedef struct _CleanBuildFiles CleanBuildFiles;
typedef struct _CleanBuildFilesClass CleanBuildFilesClass;
typedef struct _CleanBuildFilesPrivate CleanBuildFilesPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
enum  {
	CLEAN_BUILD_FILES_0_PROPERTY,
	CLEAN_BUILD_FILES_NUM_PROPERTIES
};
static GParamSpec* clean_build_files_properties[CLEAN_BUILD_FILES_NUM_PROPERTIES];
typedef enum  {
	CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE,
	CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_NAME,
	CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_FILE,
	CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_N_COLUMNS
} CleanBuildFilesCleanFileColumn;

#define CLEAN_BUILD_FILES_TYPE_CLEAN_FILE_COLUMN (clean_build_files_clean_file_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block11Data Block11Data;
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))

struct _CleanBuildFiles {
	GObject parent_instance;
	CleanBuildFilesPrivate * priv;
};

struct _CleanBuildFilesClass {
	GObjectClass parent_class;
};

struct _CleanBuildFilesPrivate {
	MainWindow* _main_window;
	Document* _doc;
	GSettings* _settings;
};

struct _Project {
	GFile* directory;
	GFile* main_file;
};

struct _Block11Data {
	int _ref_count_;
	CleanBuildFiles* self;
	GtkListStore* store;
};

static gint CleanBuildFiles_private_offset;
static gpointer clean_build_files_parent_class = NULL;

GType clean_build_files_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CleanBuildFiles, g_object_unref)
GType main_window_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
GType document_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
static GType clean_build_files_clean_file_column_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
CleanBuildFiles* clean_build_files_new (MainWindow* main_window,
                                        Document* doc);
CleanBuildFiles* clean_build_files_construct (GType object_type,
                                              MainWindow* main_window,
                                              Document* doc);
void clean_build_files_clean (CleanBuildFiles* self);
gboolean document_is_main_file_a_tex_file (Document* self);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self,
                   Project* dest);
void project_destroy (Project* self);
Project* document_get_project (Document* self);
static GeeArrayList* clean_build_files_get_build_files_in_directory (CleanBuildFiles* self,
                                                              GFile* directory);
GFile* document_get_location (Document* self);
static GeeArrayList* clean_build_files_get_build_files_simple (CleanBuildFiles* self);
static void clean_build_files_show_info_no_file (CleanBuildFiles* self);
void utils_delete_file (GFile* file);
static void clean_build_files_confirm_cleanup (CleanBuildFiles* self,
                                        GeeArrayList* files_to_delete,
                                        GFile* directory);
static GtkTreeView* clean_build_files_get_list_files (CleanBuildFiles* self,
                                               GeeArrayList* files_to_delete,
                                               GFile* directory);
static GtkDialog* clean_build_files_get_dialog (CleanBuildFiles* self,
                                         GtkTreeView* list_files);
static void clean_build_files_run_dialog (CleanBuildFiles* self,
                                   GtkDialog* dialog,
                                   GtkTreeModel* list_store);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static gint clean_build_files_on_sort_list_files (CleanBuildFiles* self,
                                           GtkTreeModel* model,
                                           GtkTreeIter* a,
                                           GtkTreeIter* b);
static gint _clean_build_files_on_sort_list_files_gtk_tree_iter_compare_func (GtkTreeModel* model,
                                                                       GtkTreeIter* a,
                                                                       GtkTreeIter* b,
                                                                       gpointer self);
gchar* utils_get_relative_path (GFile* origin,
                                GFile* target,
                                GFile* common_dir);
static void __lambda17_ (Block11Data* _data11_,
                  const gchar* path_str);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static void ___lambda17__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender,
                                                    const gchar* path,
                                                    gpointer self);
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
static void _vala_array_add1 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
static void clean_build_files_finalize (GObject * obj);
static GType clean_build_files_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static inline gpointer
clean_build_files_get_instance_private (CleanBuildFiles* self)
{
	return G_STRUCT_MEMBER_P (self, CleanBuildFiles_private_offset);
}

static GType
clean_build_files_clean_file_column_get_type_once (void)
{
	static const GEnumValue values[] = {{CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE, "CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE", "delete"}, {CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_NAME, "CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_NAME", "name"}, {CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_FILE, "CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_FILE", "file"}, {CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_N_COLUMNS, "CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
	GType clean_build_files_clean_file_column_type_id;
	clean_build_files_clean_file_column_type_id = g_enum_register_static ("CleanBuildFilesCleanFileColumn", values);
	return clean_build_files_clean_file_column_type_id;
}

static GType
clean_build_files_clean_file_column_get_type (void)
{
	static volatile gsize clean_build_files_clean_file_column_type_id__volatile = 0;
	if (g_once_init_enter (&clean_build_files_clean_file_column_type_id__volatile)) {
		GType clean_build_files_clean_file_column_type_id;
		clean_build_files_clean_file_column_type_id = clean_build_files_clean_file_column_get_type_once ();
		g_once_init_leave (&clean_build_files_clean_file_column_type_id__volatile, clean_build_files_clean_file_column_type_id);
	}
	return clean_build_files_clean_file_column_type_id__volatile;
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 39 "clean_build_files.vala"
	return self ? g_object_ref (self) : NULL;
#line 220 "clean_build_files.c"
}

CleanBuildFiles*
clean_build_files_construct (GType object_type,
                             MainWindow* main_window,
                             Document* doc)
{
	CleanBuildFiles * self = NULL;
	Document* _tmp0_;
	GSettings* _tmp1_;
#line 36 "clean_build_files.vala"
	g_return_val_if_fail (main_window != NULL, NULL);
#line 36 "clean_build_files.vala"
	g_return_val_if_fail (doc != NULL, NULL);
#line 36 "clean_build_files.vala"
	self = (CleanBuildFiles*) g_object_new (object_type, NULL);
#line 38 "clean_build_files.vala"
	self->priv->_main_window = main_window;
#line 39 "clean_build_files.vala"
	_tmp0_ = _g_object_ref0 (doc);
#line 39 "clean_build_files.vala"
	_g_object_unref0 (self->priv->_doc);
#line 39 "clean_build_files.vala"
	self->priv->_doc = _tmp0_;
#line 40 "clean_build_files.vala"
	_tmp1_ = g_settings_new ("org.gnome.gnome-latex.preferences.latex");
#line 40 "clean_build_files.vala"
	_g_object_unref0 (self->priv->_settings);
#line 40 "clean_build_files.vala"
	self->priv->_settings = _tmp1_;
#line 36 "clean_build_files.vala"
	return self;
#line 253 "clean_build_files.c"
}

CleanBuildFiles*
clean_build_files_new (MainWindow* main_window,
                       Document* doc)
{
#line 36 "clean_build_files.vala"
	return clean_build_files_construct (TYPE_CLEAN_BUILD_FILES, main_window, doc);
#line 262 "clean_build_files.c"
}

void
clean_build_files_clean (CleanBuildFiles* self)
{
	Document* _tmp0_;
	GeeArrayList* files_to_delete = NULL;
	GFile* directory = NULL;
	Project* project = NULL;
	Document* _tmp1_;
	Project* _tmp2_;
	Project* _tmp3_;
	gboolean no_confirm = FALSE;
	GSettings* _tmp14_;
	GeeArrayList* _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
#line 43 "clean_build_files.vala"
	g_return_if_fail (self != NULL);
#line 45 "clean_build_files.vala"
	_tmp0_ = self->priv->_doc;
#line 45 "clean_build_files.vala"
	if (!document_is_main_file_a_tex_file (_tmp0_)) {
#line 46 "clean_build_files.vala"
		return;
#line 288 "clean_build_files.c"
	}
#line 51 "clean_build_files.vala"
	_tmp1_ = self->priv->_doc;
#line 51 "clean_build_files.vala"
	_tmp2_ = document_get_project (_tmp1_);
#line 51 "clean_build_files.vala"
	project = _tmp2_;
#line 54 "clean_build_files.vala"
	_tmp3_ = project;
#line 54 "clean_build_files.vala"
	if (_tmp3_ != NULL) {
#line 300 "clean_build_files.c"
		Project* _tmp4_;
		GFile* _tmp5_;
		GFile* _tmp6_;
		GFile* _tmp7_;
		GeeArrayList* _tmp8_;
#line 56 "clean_build_files.vala"
		_tmp4_ = project;
#line 56 "clean_build_files.vala"
		_tmp5_ = (*_tmp4_).directory;
#line 56 "clean_build_files.vala"
		_tmp6_ = _g_object_ref0 (_tmp5_);
#line 56 "clean_build_files.vala"
		_g_object_unref0 (directory);
#line 56 "clean_build_files.vala"
		directory = _tmp6_;
#line 57 "clean_build_files.vala"
		_tmp7_ = directory;
#line 57 "clean_build_files.vala"
		_tmp8_ = clean_build_files_get_build_files_in_directory (self, _tmp7_);
#line 57 "clean_build_files.vala"
		_g_object_unref0 (files_to_delete);
#line 57 "clean_build_files.vala"
		files_to_delete = _tmp8_;
#line 324 "clean_build_files.c"
	} else {
		Document* _tmp9_;
		GFile* _tmp10_;
		GFile* _tmp11_;
		GFile* _tmp12_;
		GeeArrayList* _tmp13_;
#line 61 "clean_build_files.vala"
		_tmp9_ = self->priv->_doc;
#line 61 "clean_build_files.vala"
		_tmp10_ = document_get_location (_tmp9_);
#line 61 "clean_build_files.vala"
		_tmp11_ = _tmp10_;
#line 61 "clean_build_files.vala"
		_tmp12_ = g_file_get_parent (_tmp11_);
#line 61 "clean_build_files.vala"
		_g_object_unref0 (directory);
#line 61 "clean_build_files.vala"
		directory = _tmp12_;
#line 62 "clean_build_files.vala"
		_tmp13_ = clean_build_files_get_build_files_simple (self);
#line 62 "clean_build_files.vala"
		_g_object_unref0 (files_to_delete);
#line 62 "clean_build_files.vala"
		files_to_delete = _tmp13_;
#line 349 "clean_build_files.c"
	}
#line 65 "clean_build_files.vala"
	_tmp14_ = self->priv->_settings;
#line 65 "clean_build_files.vala"
	no_confirm = g_settings_get_boolean (_tmp14_, "no-confirm-clean");
#line 67 "clean_build_files.vala"
	_tmp15_ = files_to_delete;
#line 67 "clean_build_files.vala"
	_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
#line 67 "clean_build_files.vala"
	_tmp17_ = _tmp16_;
#line 67 "clean_build_files.vala"
	if (_tmp17_ == 0) {
#line 69 "clean_build_files.vala"
		if (!no_confirm) {
#line 70 "clean_build_files.vala"
			clean_build_files_show_info_no_file (self);
#line 367 "clean_build_files.c"
		}
#line 71 "clean_build_files.vala"
		_project_free0 (project);
#line 71 "clean_build_files.vala"
		_g_object_unref0 (directory);
#line 71 "clean_build_files.vala"
		_g_object_unref0 (files_to_delete);
#line 71 "clean_build_files.vala"
		return;
#line 377 "clean_build_files.c"
	}
#line 74 "clean_build_files.vala"
	if (no_confirm) {
#line 381 "clean_build_files.c"
		{
			GeeArrayList* _file_to_delete_list = NULL;
			GeeArrayList* _tmp18_;
			GeeArrayList* _tmp19_;
			gint _file_to_delete_size = 0;
			GeeArrayList* _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			gint _file_to_delete_index = 0;
#line 76 "clean_build_files.vala"
			_tmp18_ = files_to_delete;
#line 76 "clean_build_files.vala"
			_tmp19_ = _g_object_ref0 (_tmp18_);
#line 76 "clean_build_files.vala"
			_file_to_delete_list = _tmp19_;
#line 76 "clean_build_files.vala"
			_tmp20_ = _file_to_delete_list;
#line 76 "clean_build_files.vala"
			_tmp21_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp20_);
#line 76 "clean_build_files.vala"
			_tmp22_ = _tmp21_;
#line 76 "clean_build_files.vala"
			_file_to_delete_size = _tmp22_;
#line 76 "clean_build_files.vala"
			_file_to_delete_index = -1;
#line 76 "clean_build_files.vala"
			while (TRUE) {
#line 409 "clean_build_files.c"
				GFile* file_to_delete = NULL;
				GeeArrayList* _tmp23_;
				gpointer _tmp24_;
				GFile* _tmp25_;
#line 76 "clean_build_files.vala"
				_file_to_delete_index = _file_to_delete_index + 1;
#line 76 "clean_build_files.vala"
				if (!(_file_to_delete_index < _file_to_delete_size)) {
#line 76 "clean_build_files.vala"
					break;
#line 420 "clean_build_files.c"
				}
#line 76 "clean_build_files.vala"
				_tmp23_ = _file_to_delete_list;
#line 76 "clean_build_files.vala"
				_tmp24_ = gee_abstract_list_get ((GeeAbstractList*) _tmp23_, _file_to_delete_index);
#line 76 "clean_build_files.vala"
				file_to_delete = (GFile*) _tmp24_;
#line 77 "clean_build_files.vala"
				_tmp25_ = file_to_delete;
#line 77 "clean_build_files.vala"
				utils_delete_file (_tmp25_);
#line 76 "clean_build_files.vala"
				_g_object_unref0 (file_to_delete);
#line 434 "clean_build_files.c"
			}
#line 76 "clean_build_files.vala"
			_g_object_unref0 (_file_to_delete_list);
#line 438 "clean_build_files.c"
		}
	} else {
		GeeArrayList* _tmp26_;
		GFile* _tmp27_;
#line 80 "clean_build_files.vala"
		_tmp26_ = files_to_delete;
#line 80 "clean_build_files.vala"
		_tmp27_ = directory;
#line 80 "clean_build_files.vala"
		clean_build_files_confirm_cleanup (self, _tmp26_, _tmp27_);
#line 449 "clean_build_files.c"
	}
#line 43 "clean_build_files.vala"
	_project_free0 (project);
#line 43 "clean_build_files.vala"
	_g_object_unref0 (directory);
#line 43 "clean_build_files.vala"
	_g_object_unref0 (files_to_delete);
#line 457 "clean_build_files.c"
}

static GeeArrayList*
clean_build_files_get_build_files_simple (CleanBuildFiles* self)
{
	GFile* location = NULL;
	Document* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
	GFile* directory = NULL;
	GFile* _tmp4_;
	GFile* _tmp5_;
	gchar* exts = NULL;
	GSettings* _tmp6_;
	gchar* _tmp7_;
	gchar** extensions = NULL;
	const gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint extensions_length1;
	gint _extensions_size_;
	gchar* shortname = NULL;
	GFile* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GeeArrayList* files_to_delete = NULL;
	GeeArrayList* _tmp16_;
	gchar** _tmp17_;
	gint _tmp17__length1;
	GeeArrayList* result = NULL;
#line 84 "clean_build_files.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 86 "clean_build_files.vala"
	_tmp0_ = self->priv->_doc;
#line 86 "clean_build_files.vala"
	_tmp1_ = document_get_location (_tmp0_);
#line 86 "clean_build_files.vala"
	_tmp2_ = _tmp1_;
#line 86 "clean_build_files.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 86 "clean_build_files.vala"
	location = _tmp3_;
#line 87 "clean_build_files.vala"
	_tmp4_ = location;
#line 87 "clean_build_files.vala"
	_tmp5_ = g_file_get_parent (_tmp4_);
#line 87 "clean_build_files.vala"
	directory = _tmp5_;
#line 89 "clean_build_files.vala"
	_tmp6_ = self->priv->_settings;
#line 89 "clean_build_files.vala"
	_tmp7_ = g_settings_get_string (_tmp6_, "clean-extensions");
#line 89 "clean_build_files.vala"
	exts = _tmp7_;
#line 90 "clean_build_files.vala"
	_tmp8_ = exts;
#line 90 "clean_build_files.vala"
	_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, " ", 0);
#line 90 "clean_build_files.vala"
	extensions = _tmp10_;
#line 90 "clean_build_files.vala"
	extensions_length1 = _vala_array_length (_tmp9_);
#line 90 "clean_build_files.vala"
	_extensions_size_ = extensions_length1;
#line 92 "clean_build_files.vala"
	_tmp11_ = location;
#line 92 "clean_build_files.vala"
	_tmp12_ = g_file_get_basename (_tmp11_);
#line 92 "clean_build_files.vala"
	_tmp13_ = _tmp12_;
#line 92 "clean_build_files.vala"
	_tmp14_ = tepl_utils_get_file_shortname (_tmp13_);
#line 92 "clean_build_files.vala"
	_tmp15_ = _tmp14_;
#line 92 "clean_build_files.vala"
	_g_free0 (_tmp13_);
#line 92 "clean_build_files.vala"
	shortname = _tmp15_;
#line 94 "clean_build_files.vala"
	_tmp16_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 94 "clean_build_files.vala"
	files_to_delete = _tmp16_;
#line 96 "clean_build_files.vala"
	_tmp17_ = extensions;
#line 96 "clean_build_files.vala"
	_tmp17__length1 = extensions_length1;
#line 547 "clean_build_files.c"
	{
		gchar** extension_collection = NULL;
		gint extension_collection_length1 = 0;
		gint _extension_collection_size_ = 0;
		gint extension_it = 0;
#line 96 "clean_build_files.vala"
		extension_collection = _tmp17_;
#line 96 "clean_build_files.vala"
		extension_collection_length1 = _tmp17__length1;
#line 96 "clean_build_files.vala"
		for (extension_it = 0; extension_it < extension_collection_length1; extension_it = extension_it + 1) {
#line 559 "clean_build_files.c"
			gchar* _tmp18_;
			gchar* extension = NULL;
#line 96 "clean_build_files.vala"
			_tmp18_ = g_strdup (extension_collection[extension_it]);
#line 96 "clean_build_files.vala"
			extension = _tmp18_;
#line 566 "clean_build_files.c"
			{
				gchar* basename = NULL;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				gchar* _tmp21_;
				GFile* file = NULL;
				GFile* _tmp22_;
				const gchar* _tmp23_;
				GFile* _tmp24_;
				GFile* _tmp25_;
#line 98 "clean_build_files.vala"
				_tmp19_ = shortname;
#line 98 "clean_build_files.vala"
				_tmp20_ = extension;
#line 98 "clean_build_files.vala"
				_tmp21_ = g_strconcat (_tmp19_, _tmp20_, NULL);
#line 98 "clean_build_files.vala"
				basename = _tmp21_;
#line 99 "clean_build_files.vala"
				_tmp22_ = directory;
#line 99 "clean_build_files.vala"
				_tmp23_ = basename;
#line 99 "clean_build_files.vala"
				_tmp24_ = g_file_get_child (_tmp22_, _tmp23_);
#line 99 "clean_build_files.vala"
				file = _tmp24_;
#line 100 "clean_build_files.vala"
				_tmp25_ = file;
#line 100 "clean_build_files.vala"
				if (g_file_query_exists (_tmp25_, NULL)) {
#line 597 "clean_build_files.c"
					GeeArrayList* _tmp26_;
					GFile* _tmp27_;
#line 101 "clean_build_files.vala"
					_tmp26_ = files_to_delete;
#line 101 "clean_build_files.vala"
					_tmp27_ = file;
#line 101 "clean_build_files.vala"
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, _tmp27_);
#line 606 "clean_build_files.c"
				}
#line 96 "clean_build_files.vala"
				_g_object_unref0 (file);
#line 96 "clean_build_files.vala"
				_g_free0 (basename);
#line 96 "clean_build_files.vala"
				_g_free0 (extension);
#line 614 "clean_build_files.c"
			}
		}
	}
#line 104 "clean_build_files.vala"
	result = files_to_delete;
#line 104 "clean_build_files.vala"
	_g_free0 (shortname);
#line 104 "clean_build_files.vala"
	extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
#line 104 "clean_build_files.vala"
	_g_free0 (exts);
#line 104 "clean_build_files.vala"
	_g_object_unref0 (directory);
#line 104 "clean_build_files.vala"
	_g_object_unref0 (location);
#line 104 "clean_build_files.vala"
	return result;
#line 632 "clean_build_files.c"
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result = '\0';
#line 1232 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, '\0');
#line 1233 "glib-2.0.vapi"
	_tmp0_ = ((gchar*) self)[index];
#line 1233 "glib-2.0.vapi"
	result = _tmp0_;
#line 1233 "glib-2.0.vapi"
	return result;
#line 649 "clean_build_files.c"
}

static GeeArrayList*
clean_build_files_get_build_files_in_directory (CleanBuildFiles* self,
                                                GFile* directory)
{
	gchar* exts = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar** extensions = NULL;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint extensions_length1;
	gint _extensions_size_;
	GeeArrayList* files_to_delete = NULL;
	GeeArrayList* _tmp5_;
	GFileEnumerator* enumerator = NULL;
	GError* _inner_error0_ = NULL;
	GeeArrayList* result = NULL;
#line 108 "clean_build_files.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 108 "clean_build_files.vala"
	g_return_val_if_fail (directory != NULL, NULL);
#line 110 "clean_build_files.vala"
	_tmp0_ = self->priv->_settings;
#line 110 "clean_build_files.vala"
	_tmp1_ = g_settings_get_string (_tmp0_, "clean-extensions");
#line 110 "clean_build_files.vala"
	exts = _tmp1_;
#line 111 "clean_build_files.vala"
	_tmp2_ = exts;
#line 111 "clean_build_files.vala"
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, " ", 0);
#line 111 "clean_build_files.vala"
	extensions = _tmp4_;
#line 111 "clean_build_files.vala"
	extensions_length1 = _vala_array_length (_tmp3_);
#line 111 "clean_build_files.vala"
	_extensions_size_ = extensions_length1;
#line 113 "clean_build_files.vala"
	_tmp5_ = gee_array_list_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 113 "clean_build_files.vala"
	files_to_delete = _tmp5_;
#line 694 "clean_build_files.c"
	{
		GFileEnumerator* _tmp6_ = NULL;
		GFileEnumerator* _tmp7_;
		GFileEnumerator* _tmp8_;
#line 118 "clean_build_files.vala"
		_tmp7_ = g_file_enumerate_children (directory, "standard::type,standard::name", G_FILE_QUERY_INFO_NONE, NULL, &_inner_error0_);
#line 118 "clean_build_files.vala"
		_tmp6_ = _tmp7_;
#line 118 "clean_build_files.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 705 "clean_build_files.c"
			goto __catch0_g_error;
		}
#line 118 "clean_build_files.vala"
		_tmp8_ = _tmp6_;
#line 118 "clean_build_files.vala"
		_tmp6_ = NULL;
#line 118 "clean_build_files.vala"
		_g_object_unref0 (enumerator);
#line 118 "clean_build_files.vala"
		enumerator = _tmp8_;
#line 116 "clean_build_files.vala"
		_g_object_unref0 (_tmp6_);
#line 718 "clean_build_files.c"
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		const gchar* _tmp10_;
#line 116 "clean_build_files.vala"
		e = _inner_error0_;
#line 116 "clean_build_files.vala"
		_inner_error0_ = NULL;
#line 123 "clean_build_files.vala"
		_tmp9_ = e;
#line 123 "clean_build_files.vala"
		_tmp10_ = _tmp9_->message;
#line 123 "clean_build_files.vala"
		g_warning ("clean_build_files.vala:123: Clean build files: %s", _tmp10_);
#line 124 "clean_build_files.vala"
		result = files_to_delete;
#line 124 "clean_build_files.vala"
		_g_error_free0 (e);
#line 124 "clean_build_files.vala"
		_g_object_unref0 (enumerator);
#line 124 "clean_build_files.vala"
		extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
#line 124 "clean_build_files.vala"
		_g_free0 (exts);
#line 124 "clean_build_files.vala"
		return result;
#line 748 "clean_build_files.c"
	}
	__finally0:
#line 116 "clean_build_files.vala"
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 116 "clean_build_files.vala"
		_g_object_unref0 (enumerator);
#line 116 "clean_build_files.vala"
		_g_object_unref0 (files_to_delete);
#line 116 "clean_build_files.vala"
		extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
#line 116 "clean_build_files.vala"
		_g_free0 (exts);
#line 116 "clean_build_files.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 116 "clean_build_files.vala"
		g_clear_error (&_inner_error0_);
#line 116 "clean_build_files.vala"
		return NULL;
#line 767 "clean_build_files.c"
	}
#line 127 "clean_build_files.vala"
	while (TRUE) {
#line 771 "clean_build_files.c"
		GFileInfo* info = NULL;
		GFileInfo* _tmp17_;
		gchar* name = NULL;
		GFileInfo* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		GFile* file = NULL;
		const gchar* _tmp22_;
		GFile* _tmp23_;
		GFileType type = 0;
		GFileInfo* _tmp24_;
		GFileType _tmp25_;
		gchar** _tmp30_;
		gint _tmp30__length1;
#line 129 "clean_build_files.vala"
		info = NULL;
#line 789 "clean_build_files.c"
		{
			GFileInfo* _tmp11_ = NULL;
			GFileEnumerator* _tmp12_;
			GFileInfo* _tmp13_;
			GFileInfo* _tmp14_;
#line 133 "clean_build_files.vala"
			_tmp12_ = enumerator;
#line 133 "clean_build_files.vala"
			_tmp13_ = g_file_enumerator_next_file (_tmp12_, NULL, &_inner_error0_);
#line 133 "clean_build_files.vala"
			_tmp11_ = _tmp13_;
#line 133 "clean_build_files.vala"
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 803 "clean_build_files.c"
				goto __catch1_g_error;
			}
#line 133 "clean_build_files.vala"
			_tmp14_ = _tmp11_;
#line 133 "clean_build_files.vala"
			_tmp11_ = NULL;
#line 133 "clean_build_files.vala"
			_g_object_unref0 (info);
#line 133 "clean_build_files.vala"
			info = _tmp14_;
#line 131 "clean_build_files.vala"
			_g_object_unref0 (_tmp11_);
#line 816 "clean_build_files.c"
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* e = NULL;
			GError* _tmp15_;
			const gchar* _tmp16_;
#line 131 "clean_build_files.vala"
			e = _inner_error0_;
#line 131 "clean_build_files.vala"
			_inner_error0_ = NULL;
#line 137 "clean_build_files.vala"
			_tmp15_ = e;
#line 137 "clean_build_files.vala"
			_tmp16_ = _tmp15_->message;
#line 137 "clean_build_files.vala"
			g_warning ("clean_build_files.vala:137: Clean build files: %s", _tmp16_);
#line 138 "clean_build_files.vala"
			_g_error_free0 (e);
#line 138 "clean_build_files.vala"
			_g_object_unref0 (info);
#line 138 "clean_build_files.vala"
			break;
#line 840 "clean_build_files.c"
		}
		__finally1:
#line 131 "clean_build_files.vala"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 131 "clean_build_files.vala"
			_g_object_unref0 (info);
#line 131 "clean_build_files.vala"
			_g_object_unref0 (enumerator);
#line 131 "clean_build_files.vala"
			_g_object_unref0 (files_to_delete);
#line 131 "clean_build_files.vala"
			extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
#line 131 "clean_build_files.vala"
			_g_free0 (exts);
#line 131 "clean_build_files.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 131 "clean_build_files.vala"
			g_clear_error (&_inner_error0_);
#line 131 "clean_build_files.vala"
			return NULL;
#line 861 "clean_build_files.c"
		}
#line 141 "clean_build_files.vala"
		_tmp17_ = info;
#line 141 "clean_build_files.vala"
		if (_tmp17_ == NULL) {
#line 142 "clean_build_files.vala"
			_g_object_unref0 (info);
#line 142 "clean_build_files.vala"
			break;
#line 871 "clean_build_files.c"
		}
#line 144 "clean_build_files.vala"
		_tmp18_ = info;
#line 144 "clean_build_files.vala"
		_tmp19_ = g_file_info_get_name (_tmp18_);
#line 144 "clean_build_files.vala"
		_tmp20_ = g_strdup (_tmp19_);
#line 144 "clean_build_files.vala"
		name = _tmp20_;
#line 148 "clean_build_files.vala"
		_tmp21_ = name;
#line 148 "clean_build_files.vala"
		if (string_get (_tmp21_, (glong) 0) == '.') {
#line 149 "clean_build_files.vala"
			_g_free0 (name);
#line 149 "clean_build_files.vala"
			_g_object_unref0 (info);
#line 149 "clean_build_files.vala"
			continue;
#line 891 "clean_build_files.c"
		}
#line 151 "clean_build_files.vala"
		_tmp22_ = name;
#line 151 "clean_build_files.vala"
		_tmp23_ = g_file_get_child (directory, _tmp22_);
#line 151 "clean_build_files.vala"
		file = _tmp23_;
#line 153 "clean_build_files.vala"
		_tmp24_ = info;
#line 153 "clean_build_files.vala"
		type = g_file_info_get_file_type (_tmp24_);
#line 154 "clean_build_files.vala"
		_tmp25_ = type;
#line 154 "clean_build_files.vala"
		if (_tmp25_ == G_FILE_TYPE_DIRECTORY) {
#line 907 "clean_build_files.c"
			GeeArrayList* files_to_delete_in_dir = NULL;
			GFile* _tmp26_;
			GeeArrayList* _tmp27_;
			GeeArrayList* _tmp28_;
			GeeArrayList* _tmp29_;
#line 156 "clean_build_files.vala"
			_tmp26_ = file;
#line 156 "clean_build_files.vala"
			_tmp27_ = clean_build_files_get_build_files_in_directory (self, _tmp26_);
#line 156 "clean_build_files.vala"
			files_to_delete_in_dir = _tmp27_;
#line 157 "clean_build_files.vala"
			_tmp28_ = files_to_delete;
#line 157 "clean_build_files.vala"
			_tmp29_ = files_to_delete_in_dir;
#line 157 "clean_build_files.vala"
			gee_array_list_add_all (_tmp28_, (GeeCollection*) _tmp29_);
#line 158 "clean_build_files.vala"
			_g_object_unref0 (files_to_delete_in_dir);
#line 158 "clean_build_files.vala"
			_g_object_unref0 (file);
#line 158 "clean_build_files.vala"
			_g_free0 (name);
#line 158 "clean_build_files.vala"
			_g_object_unref0 (info);
#line 158 "clean_build_files.vala"
			continue;
#line 935 "clean_build_files.c"
		}
#line 161 "clean_build_files.vala"
		_tmp30_ = extensions;
#line 161 "clean_build_files.vala"
		_tmp30__length1 = extensions_length1;
#line 941 "clean_build_files.c"
		{
			gchar** ext_collection = NULL;
			gint ext_collection_length1 = 0;
			gint _ext_collection_size_ = 0;
			gint ext_it = 0;
#line 161 "clean_build_files.vala"
			ext_collection = _tmp30_;
#line 161 "clean_build_files.vala"
			ext_collection_length1 = _tmp30__length1;
#line 161 "clean_build_files.vala"
			for (ext_it = 0; ext_it < ext_collection_length1; ext_it = ext_it + 1) {
#line 953 "clean_build_files.c"
				gchar* _tmp31_;
				gchar* ext = NULL;
#line 161 "clean_build_files.vala"
				_tmp31_ = g_strdup (ext_collection[ext_it]);
#line 161 "clean_build_files.vala"
				ext = _tmp31_;
#line 960 "clean_build_files.c"
				{
					const gchar* _tmp32_;
					const gchar* _tmp33_;
#line 163 "clean_build_files.vala"
					_tmp32_ = name;
#line 163 "clean_build_files.vala"
					_tmp33_ = ext;
#line 163 "clean_build_files.vala"
					if (g_str_has_suffix (_tmp32_, _tmp33_)) {
#line 970 "clean_build_files.c"
						GeeArrayList* _tmp34_;
						GFile* _tmp35_;
#line 165 "clean_build_files.vala"
						_tmp34_ = files_to_delete;
#line 165 "clean_build_files.vala"
						_tmp35_ = file;
#line 165 "clean_build_files.vala"
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp34_, _tmp35_);
#line 166 "clean_build_files.vala"
						_g_free0 (ext);
#line 166 "clean_build_files.vala"
						break;
#line 983 "clean_build_files.c"
					}
#line 161 "clean_build_files.vala"
					_g_free0 (ext);
#line 987 "clean_build_files.c"
				}
			}
		}
#line 127 "clean_build_files.vala"
		_g_object_unref0 (file);
#line 127 "clean_build_files.vala"
		_g_free0 (name);
#line 127 "clean_build_files.vala"
		_g_object_unref0 (info);
#line 997 "clean_build_files.c"
	}
#line 171 "clean_build_files.vala"
	result = files_to_delete;
#line 171 "clean_build_files.vala"
	_g_object_unref0 (enumerator);
#line 171 "clean_build_files.vala"
	extensions = (_vala_array_free (extensions, extensions_length1, (GDestroyNotify) g_free), NULL);
#line 171 "clean_build_files.vala"
	_g_free0 (exts);
#line 171 "clean_build_files.vala"
	return result;
#line 1009 "clean_build_files.c"
}

static void
clean_build_files_confirm_cleanup (CleanBuildFiles* self,
                                   GeeArrayList* files_to_delete,
                                   GFile* directory)
{
	gint _tmp0_;
	gint _tmp1_;
	GtkTreeView* list_files = NULL;
	GtkTreeView* _tmp2_;
	GtkDialog* dialog = NULL;
	GtkDialog* _tmp3_;
	GtkTreeModel* _tmp4_;
#line 174 "clean_build_files.vala"
	g_return_if_fail (self != NULL);
#line 174 "clean_build_files.vala"
	g_return_if_fail (files_to_delete != NULL);
#line 174 "clean_build_files.vala"
	g_return_if_fail (directory != NULL);
#line 176 "clean_build_files.vala"
	_tmp0_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) files_to_delete);
#line 176 "clean_build_files.vala"
	_tmp1_ = _tmp0_;
#line 176 "clean_build_files.vala"
	g_return_if_fail (0 < _tmp1_);
#line 178 "clean_build_files.vala"
	_tmp2_ = clean_build_files_get_list_files (self, files_to_delete, directory);
#line 178 "clean_build_files.vala"
	list_files = _tmp2_;
#line 179 "clean_build_files.vala"
	_tmp3_ = clean_build_files_get_dialog (self, list_files);
#line 179 "clean_build_files.vala"
	dialog = _tmp3_;
#line 181 "clean_build_files.vala"
	_tmp4_ = gtk_tree_view_get_model (list_files);
#line 181 "clean_build_files.vala"
	clean_build_files_run_dialog (self, dialog, _tmp4_);
#line 174 "clean_build_files.vala"
	_g_object_unref0 (dialog);
#line 174 "clean_build_files.vala"
	_g_object_unref0 (list_files);
#line 1052 "clean_build_files.c"
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
#line 184 "clean_build_files.vala"
	g_atomic_int_inc (&_data11_->_ref_count_);
#line 184 "clean_build_files.vala"
	return _data11_;
#line 1062 "clean_build_files.c"
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
#line 184 "clean_build_files.vala"
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
#line 1072 "clean_build_files.c"
		CleanBuildFiles* self;
#line 184 "clean_build_files.vala"
		self = _data11_->self;
#line 184 "clean_build_files.vala"
		_g_object_unref0 (_data11_->store);
#line 184 "clean_build_files.vala"
		_g_object_unref0 (self);
#line 184 "clean_build_files.vala"
		g_slice_free (Block11Data, _data11_);
#line 1082 "clean_build_files.c"
	}
}

static gint
_clean_build_files_on_sort_list_files_gtk_tree_iter_compare_func (GtkTreeModel* model,
                                                                  GtkTreeIter* a,
                                                                  GtkTreeIter* b,
                                                                  gpointer self)
{
	gint result;
	result = clean_build_files_on_sort_list_files ((CleanBuildFiles*) self, model, a, b);
#line 194 "clean_build_files.vala"
	return result;
#line 1096 "clean_build_files.c"
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
#line 214 "clean_build_files.vala"
	g_boxed_free (gtk_tree_path_get_type (), self);
#line 1104 "clean_build_files.c"
}

static void
__lambda17_ (Block11Data* _data11_,
             const gchar* path_str)
{
	CleanBuildFiles* self;
	GtkTreePath* path = NULL;
	GtkTreePath* _tmp0_;
	GtkTreeIter iter = {0};
	gboolean active = FALSE;
	GtkListStore* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	GtkListStore* _tmp3_;
	GtkTreeIter _tmp4_;
	gboolean _tmp5_ = FALSE;
	GtkListStore* _tmp6_;
	GtkTreeIter _tmp7_;
#line 214 "clean_build_files.vala"
	self = _data11_->self;
#line 214 "clean_build_files.vala"
	g_return_if_fail (path_str != NULL);
#line 216 "clean_build_files.vala"
	_tmp0_ = gtk_tree_path_new_from_string (path_str);
#line 216 "clean_build_files.vala"
	path = _tmp0_;
#line 219 "clean_build_files.vala"
	_tmp1_ = _data11_->store;
#line 219 "clean_build_files.vala"
	gtk_tree_model_get_iter ((GtkTreeModel*) _tmp1_, &_tmp2_, path);
#line 219 "clean_build_files.vala"
	iter = _tmp2_;
#line 220 "clean_build_files.vala"
	_tmp3_ = _data11_->store;
#line 220 "clean_build_files.vala"
	_tmp4_ = iter;
#line 220 "clean_build_files.vala"
	gtk_tree_model_get ((GtkTreeModel*) _tmp3_, &_tmp4_, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE, &_tmp5_, -1);
#line 220 "clean_build_files.vala"
	active = _tmp5_;
#line 222 "clean_build_files.vala"
	_tmp6_ = _data11_->store;
#line 222 "clean_build_files.vala"
	_tmp7_ = iter;
#line 222 "clean_build_files.vala"
	gtk_list_store_set (_tmp6_, &_tmp7_, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE, !active, -1);
#line 214 "clean_build_files.vala"
	__vala_GtkTreePath_free0 (path);
#line 1153 "clean_build_files.c"
}

static void
___lambda17__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender,
                                               const gchar* path,
                                               gpointer self)
{
#line 214 "clean_build_files.vala"
	__lambda17_ (self, path);
#line 1163 "clean_build_files.c"
}

static GtkTreeView*
clean_build_files_get_list_files (CleanBuildFiles* self,
                                  GeeArrayList* files_to_delete,
                                  GFile* directory)
{
	Block11Data* _data11_;
	GtkTreeView* treeview = NULL;
	GtkTreeView* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeView* _tmp2_;
	GtkTreeView* _tmp3_;
	GtkListStore* _tmp4_;
	GtkListStore* _tmp5_;
	GtkListStore* _tmp6_;
	GtkTreeView* _tmp21_;
	GtkListStore* _tmp22_;
	GtkCellRendererToggle* toggle_renderer = NULL;
	GtkCellRendererToggle* _tmp23_;
	GtkTreeViewColumn* column = NULL;
	GtkTreeViewColumn* _tmp24_;
	GtkTreeView* _tmp25_;
	GtkTreeViewColumn* _tmp26_;
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp27_;
	GtkTreeViewColumn* _tmp28_;
	GtkTreeView* _tmp29_;
	GtkTreeViewColumn* _tmp30_;
	GtkTreeView* result = NULL;
#line 184 "clean_build_files.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 184 "clean_build_files.vala"
	g_return_val_if_fail (files_to_delete != NULL, NULL);
#line 184 "clean_build_files.vala"
	g_return_val_if_fail (directory != NULL, NULL);
#line 184 "clean_build_files.vala"
	_data11_ = g_slice_new0 (Block11Data);
#line 184 "clean_build_files.vala"
	_data11_->_ref_count_ = 1;
#line 184 "clean_build_files.vala"
	_data11_->self = g_object_ref (self);
#line 186 "clean_build_files.vala"
	_tmp0_ = (GtkTreeView*) gtk_tree_view_new ();
#line 186 "clean_build_files.vala"
	g_object_ref_sink (_tmp0_);
#line 186 "clean_build_files.vala"
	treeview = _tmp0_;
#line 187 "clean_build_files.vala"
	_tmp1_ = treeview;
#line 187 "clean_build_files.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp1_, 260, 120);
#line 188 "clean_build_files.vala"
	_tmp2_ = treeview;
#line 188 "clean_build_files.vala"
	gtk_tree_view_set_headers_visible (_tmp2_, FALSE);
#line 189 "clean_build_files.vala"
	_tmp3_ = treeview;
#line 189 "clean_build_files.vala"
	gtk_tree_view_set_enable_search (_tmp3_, FALSE);
#line 191 "clean_build_files.vala"
	_tmp4_ = gtk_list_store_new ((gint) CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_N_COLUMNS, G_TYPE_BOOLEAN, G_TYPE_STRING, g_file_get_type (), -1);
#line 191 "clean_build_files.vala"
	_data11_->store = _tmp4_;
#line 194 "clean_build_files.vala"
	_tmp5_ = _data11_->store;
#line 194 "clean_build_files.vala"
	gtk_tree_sortable_set_sort_func ((GtkTreeSortable*) _tmp5_, 0, _clean_build_files_on_sort_list_files_gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
#line 195 "clean_build_files.vala"
	_tmp6_ = _data11_->store;
#line 195 "clean_build_files.vala"
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) _tmp6_, 0, GTK_SORT_ASCENDING);
#line 1236 "clean_build_files.c"
	{
		GeeArrayList* _file_to_delete_list = NULL;
		GeeArrayList* _tmp7_;
		gint _file_to_delete_size = 0;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _file_to_delete_index = 0;
#line 198 "clean_build_files.vala"
		_tmp7_ = _g_object_ref0 (files_to_delete);
#line 198 "clean_build_files.vala"
		_file_to_delete_list = _tmp7_;
#line 198 "clean_build_files.vala"
		_tmp8_ = _file_to_delete_list;
#line 198 "clean_build_files.vala"
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
#line 198 "clean_build_files.vala"
		_tmp10_ = _tmp9_;
#line 198 "clean_build_files.vala"
		_file_to_delete_size = _tmp10_;
#line 198 "clean_build_files.vala"
		_file_to_delete_index = -1;
#line 198 "clean_build_files.vala"
		while (TRUE) {
#line 1261 "clean_build_files.c"
			GFile* file_to_delete = NULL;
			GeeArrayList* _tmp11_;
			gpointer _tmp12_;
			gchar* relative_path = NULL;
			GFile* _tmp13_;
			gchar* _tmp14_;
			GtkTreeIter iter = {0};
			GtkListStore* _tmp15_;
			GtkTreeIter _tmp16_ = {0};
			GtkListStore* _tmp17_;
			GtkTreeIter _tmp18_;
			const gchar* _tmp19_;
			GFile* _tmp20_;
#line 198 "clean_build_files.vala"
			_file_to_delete_index = _file_to_delete_index + 1;
#line 198 "clean_build_files.vala"
			if (!(_file_to_delete_index < _file_to_delete_size)) {
#line 198 "clean_build_files.vala"
				break;
#line 1281 "clean_build_files.c"
			}
#line 198 "clean_build_files.vala"
			_tmp11_ = _file_to_delete_list;
#line 198 "clean_build_files.vala"
			_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _file_to_delete_index);
#line 198 "clean_build_files.vala"
			file_to_delete = (GFile*) _tmp12_;
#line 200 "clean_build_files.vala"
			_tmp13_ = file_to_delete;
#line 200 "clean_build_files.vala"
			_tmp14_ = utils_get_relative_path (directory, _tmp13_, directory);
#line 200 "clean_build_files.vala"
			relative_path = _tmp14_;
#line 203 "clean_build_files.vala"
			_tmp15_ = _data11_->store;
#line 203 "clean_build_files.vala"
			gtk_list_store_append (_tmp15_, &_tmp16_);
#line 203 "clean_build_files.vala"
			iter = _tmp16_;
#line 204 "clean_build_files.vala"
			_tmp17_ = _data11_->store;
#line 204 "clean_build_files.vala"
			_tmp18_ = iter;
#line 204 "clean_build_files.vala"
			_tmp19_ = relative_path;
#line 204 "clean_build_files.vala"
			_tmp20_ = file_to_delete;
#line 204 "clean_build_files.vala"
			gtk_list_store_set (_tmp17_, &_tmp18_, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE, TRUE, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_NAME, _tmp19_, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_FILE, _tmp20_, -1);
#line 198 "clean_build_files.vala"
			_g_free0 (relative_path);
#line 198 "clean_build_files.vala"
			_g_object_unref0 (file_to_delete);
#line 1315 "clean_build_files.c"
		}
#line 198 "clean_build_files.vala"
		_g_object_unref0 (_file_to_delete_list);
#line 1319 "clean_build_files.c"
	}
#line 211 "clean_build_files.vala"
	_tmp21_ = treeview;
#line 211 "clean_build_files.vala"
	_tmp22_ = _data11_->store;
#line 211 "clean_build_files.vala"
	gtk_tree_view_set_model (_tmp21_, (GtkTreeModel*) _tmp22_);
#line 212 "clean_build_files.vala"
	_tmp23_ = (GtkCellRendererToggle*) gtk_cell_renderer_toggle_new ();
#line 212 "clean_build_files.vala"
	g_object_ref_sink (_tmp23_);
#line 212 "clean_build_files.vala"
	toggle_renderer = _tmp23_;
#line 214 "clean_build_files.vala"
	g_signal_connect_data (toggle_renderer, "toggled", (GCallback) ___lambda17__gtk_cell_renderer_toggle_toggled, block11_data_ref (_data11_), (GClosureNotify) block11_data_unref, 0);
#line 225 "clean_build_files.vala"
	_tmp24_ = gtk_tree_view_column_new_with_attributes ("Delete?", (GtkCellRenderer*) toggle_renderer, "active", CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE, NULL, NULL);
#line 225 "clean_build_files.vala"
	g_object_ref_sink (_tmp24_);
#line 225 "clean_build_files.vala"
	column = _tmp24_;
#line 227 "clean_build_files.vala"
	_tmp25_ = treeview;
#line 227 "clean_build_files.vala"
	_tmp26_ = column;
#line 227 "clean_build_files.vala"
	gtk_tree_view_append_column (_tmp25_, _tmp26_);
#line 229 "clean_build_files.vala"
	_tmp27_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 229 "clean_build_files.vala"
	g_object_ref_sink (_tmp27_);
#line 229 "clean_build_files.vala"
	text_renderer = _tmp27_;
#line 230 "clean_build_files.vala"
	_tmp28_ = gtk_tree_view_column_new_with_attributes ("Name", (GtkCellRenderer*) text_renderer, "text", CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_NAME, NULL);
#line 230 "clean_build_files.vala"
	g_object_ref_sink (_tmp28_);
#line 230 "clean_build_files.vala"
	_g_object_unref0 (column);
#line 230 "clean_build_files.vala"
	column = _tmp28_;
#line 232 "clean_build_files.vala"
	_tmp29_ = treeview;
#line 232 "clean_build_files.vala"
	_tmp30_ = column;
#line 232 "clean_build_files.vala"
	gtk_tree_view_append_column (_tmp29_, _tmp30_);
#line 234 "clean_build_files.vala"
	result = treeview;
#line 234 "clean_build_files.vala"
	_g_object_unref0 (text_renderer);
#line 234 "clean_build_files.vala"
	_g_object_unref0 (column);
#line 234 "clean_build_files.vala"
	_g_object_unref0 (toggle_renderer);
#line 234 "clean_build_files.vala"
	block11_data_unref (_data11_);
#line 234 "clean_build_files.vala"
	_data11_ = NULL;
#line 234 "clean_build_files.vala"
	return result;
#line 1381 "clean_build_files.c"
}

static GtkDialog*
clean_build_files_get_dialog (CleanBuildFiles* self,
                              GtkTreeView* list_files)
{
	GtkDialog* dialog = NULL;
	MainWindow* _tmp0_;
	GtkDialog* _tmp1_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp2_;
	GtkBox* content_area = NULL;
	GtkBox* _tmp3_;
	GtkBox* _tmp4_;
	GtkImage* image = NULL;
	GtkImage* _tmp5_;
	GtkLabel* primary_label = NULL;
	GtkLabel* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GtkLabel* select_label = NULL;
	GtkLabel* _tmp11_;
	GtkScrolledWindow* sw = NULL;
	GtkScrolledWindow* _tmp12_;
	GtkDialog* result = NULL;
#line 237 "clean_build_files.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 237 "clean_build_files.vala"
	g_return_val_if_fail (list_files != NULL, NULL);
#line 239 "clean_build_files.vala"
	_tmp0_ = self->priv->_main_window;
#line 239 "clean_build_files.vala"
	_tmp1_ = (GtkDialog*) gtk_dialog_new_with_buttons (NULL, (GtkWindow*) _tmp0_, GTK_DIALOG_DESTROY_WITH_PARENT, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("_Delete"), GTK_RESPONSE_ACCEPT, NULL);
#line 239 "clean_build_files.vala"
	g_object_ref_sink (_tmp1_);
#line 239 "clean_build_files.vala"
	dialog = _tmp1_;
#line 246 "clean_build_files.vala"
	_tmp2_ = (GtkGrid*) gtk_grid_new ();
#line 246 "clean_build_files.vala"
	g_object_ref_sink (_tmp2_);
#line 246 "clean_build_files.vala"
	grid = _tmp2_;
#line 247 "clean_build_files.vala"
	gtk_grid_set_column_spacing (grid, (guint) 12);
#line 248 "clean_build_files.vala"
	gtk_grid_set_row_spacing (grid, (guint) 8);
#line 249 "clean_build_files.vala"
	gtk_container_set_border_width ((GtkContainer*) grid, (guint) 5);
#line 251 "clean_build_files.vala"
	_tmp3_ = gtk_dialog_get_content_area (dialog);
#line 251 "clean_build_files.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_box_get_type ()) ? ((GtkBox*) _tmp3_) : NULL);
#line 251 "clean_build_files.vala"
	content_area = _tmp4_;
#line 252 "clean_build_files.vala"
	gtk_box_pack_start (content_area, (GtkWidget*) grid, TRUE, TRUE, (guint) 0);
#line 255 "clean_build_files.vala"
	_tmp5_ = (GtkImage*) gtk_image_new_from_icon_name ("dialog-warning", (GtkIconSize) GTK_ICON_SIZE_DIALOG);
#line 255 "clean_build_files.vala"
	g_object_ref_sink (_tmp5_);
#line 255 "clean_build_files.vala"
	image = _tmp5_;
#line 256 "clean_build_files.vala"
	gtk_widget_set_valign ((GtkWidget*) image, GTK_ALIGN_START);
#line 257 "clean_build_files.vala"
	gtk_grid_attach (grid, (GtkWidget*) image, 0, 0, 1, 3);
#line 260 "clean_build_files.vala"
	_tmp6_ = (GtkLabel*) gtk_label_new (NULL);
#line 260 "clean_build_files.vala"
	g_object_ref_sink (_tmp6_);
#line 260 "clean_build_files.vala"
	primary_label = _tmp6_;
#line 261 "clean_build_files.vala"
	gtk_label_set_line_wrap (primary_label, TRUE);
#line 262 "clean_build_files.vala"
	gtk_label_set_use_markup (primary_label, TRUE);
#line 263 "clean_build_files.vala"
	gtk_widget_set_halign ((GtkWidget*) primary_label, GTK_ALIGN_START);
#line 264 "clean_build_files.vala"
	gtk_label_set_selectable (primary_label, TRUE);
#line 265 "clean_build_files.vala"
	gtk_widget_set_margin_bottom ((GtkWidget*) primary_label, 4);
#line 266 "clean_build_files.vala"
	_tmp7_ = g_strconcat ("<span weight=\"bold\" size=\"larger\">", _ ("Do you really want to delete these files?"), NULL);
#line 266 "clean_build_files.vala"
	_tmp8_ = _tmp7_;
#line 266 "clean_build_files.vala"
	_tmp9_ = g_strconcat (_tmp8_, "</span>", NULL);
#line 266 "clean_build_files.vala"
	_tmp10_ = _tmp9_;
#line 266 "clean_build_files.vala"
	gtk_label_set_markup (primary_label, _tmp10_);
#line 266 "clean_build_files.vala"
	_g_free0 (_tmp10_);
#line 266 "clean_build_files.vala"
	_g_free0 (_tmp8_);
#line 269 "clean_build_files.vala"
	gtk_grid_attach (grid, (GtkWidget*) primary_label, 1, 0, 1, 1);
#line 272 "clean_build_files.vala"
	_tmp11_ = (GtkLabel*) gtk_label_new (_ ("Select the files you want to delete:"));
#line 272 "clean_build_files.vala"
	g_object_ref_sink (_tmp11_);
#line 272 "clean_build_files.vala"
	select_label = _tmp11_;
#line 273 "clean_build_files.vala"
	gtk_label_set_line_wrap (select_label, TRUE);
#line 274 "clean_build_files.vala"
	gtk_widget_set_halign ((GtkWidget*) select_label, GTK_ALIGN_START);
#line 275 "clean_build_files.vala"
	gtk_grid_attach (grid, (GtkWidget*) select_label, 1, 1, 1, 1);
#line 278 "clean_build_files.vala"
	_tmp12_ = utils_add_scrollbar ((GtkWidget*) list_files);
#line 278 "clean_build_files.vala"
	sw = _tmp12_;
#line 279 "clean_build_files.vala"
	gtk_scrolled_window_set_shadow_type (sw, GTK_SHADOW_IN);
#line 280 "clean_build_files.vala"
	g_object_set ((GtkWidget*) sw, "expand", TRUE, NULL);
#line 281 "clean_build_files.vala"
	gtk_grid_attach (grid, (GtkWidget*) sw, 1, 2, 1, 1);
#line 283 "clean_build_files.vala"
	gtk_widget_show_all ((GtkWidget*) grid);
#line 285 "clean_build_files.vala"
	result = dialog;
#line 285 "clean_build_files.vala"
	_g_object_unref0 (sw);
#line 285 "clean_build_files.vala"
	_g_object_unref0 (select_label);
#line 285 "clean_build_files.vala"
	_g_object_unref0 (primary_label);
#line 285 "clean_build_files.vala"
	_g_object_unref0 (image);
#line 285 "clean_build_files.vala"
	_g_object_unref0 (content_area);
#line 285 "clean_build_files.vala"
	_g_object_unref0 (grid);
#line 285 "clean_build_files.vala"
	return result;
#line 1523 "clean_build_files.c"
}

static void
_vala_array_add1 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
#line 307 "clean_build_files.vala"
	if ((*length) == (*size)) {
#line 307 "clean_build_files.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 307 "clean_build_files.vala"
		*array = g_renew (GFile*, *array, (*size) + 1);
#line 1538 "clean_build_files.c"
	}
#line 307 "clean_build_files.vala"
	(*array)[(*length)++] = value;
#line 307 "clean_build_files.vala"
	(*array)[*length] = NULL;
#line 1544 "clean_build_files.c"
}

static void
clean_build_files_run_dialog (CleanBuildFiles* self,
                              GtkDialog* dialog,
                              GtkTreeModel* list_store)
{
#line 288 "clean_build_files.vala"
	g_return_if_fail (self != NULL);
#line 288 "clean_build_files.vala"
	g_return_if_fail (dialog != NULL);
#line 288 "clean_build_files.vala"
	g_return_if_fail (list_store != NULL);
#line 290 "clean_build_files.vala"
	if (gtk_dialog_run (dialog) == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 1560 "clean_build_files.c"
		GFile** selected_files = NULL;
		GFile** _tmp0_;
		gint selected_files_length1;
		gint _selected_files_size_;
		GtkTreeIter iter = {0};
		gboolean valid = FALSE;
		GtkTreeIter _tmp1_ = {0};
		gboolean _tmp2_;
		GFile** _tmp9_;
		gint _tmp9__length1;
#line 293 "clean_build_files.vala"
		_tmp0_ = g_new0 (GFile*, 0 + 1);
#line 293 "clean_build_files.vala"
		selected_files = _tmp0_;
#line 293 "clean_build_files.vala"
		selected_files_length1 = 0;
#line 293 "clean_build_files.vala"
		_selected_files_size_ = selected_files_length1;
#line 295 "clean_build_files.vala"
		_tmp2_ = gtk_tree_model_get_iter_first (list_store, &_tmp1_);
#line 295 "clean_build_files.vala"
		iter = _tmp1_;
#line 295 "clean_build_files.vala"
		valid = _tmp2_;
#line 296 "clean_build_files.vala"
		while (TRUE) {
#line 1587 "clean_build_files.c"
			gboolean selected = FALSE;
			GFile* file_to_delete = NULL;
			GtkTreeIter _tmp3_;
			gboolean _tmp4_ = FALSE;
			GFile* _tmp5_ = NULL;
			gboolean _tmp8_;
#line 296 "clean_build_files.vala"
			if (!valid) {
#line 296 "clean_build_files.vala"
				break;
#line 1598 "clean_build_files.c"
			}
#line 301 "clean_build_files.vala"
			_tmp3_ = iter;
#line 301 "clean_build_files.vala"
			gtk_tree_model_get (list_store, &_tmp3_, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_DELETE, &_tmp4_, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_FILE, &_tmp5_, -1);
#line 301 "clean_build_files.vala"
			selected = _tmp4_;
#line 301 "clean_build_files.vala"
			_g_object_unref0 (file_to_delete);
#line 301 "clean_build_files.vala"
			file_to_delete = _tmp5_;
#line 306 "clean_build_files.vala"
			if (selected) {
#line 1612 "clean_build_files.c"
				GFile* _tmp6_;
				GFile* _tmp7_;
#line 307 "clean_build_files.vala"
				_tmp6_ = file_to_delete;
#line 307 "clean_build_files.vala"
				_tmp7_ = _g_object_ref0 (_tmp6_);
#line 307 "clean_build_files.vala"
				_vala_array_add1 (&selected_files, &selected_files_length1, &_selected_files_size_, _tmp7_);
#line 1621 "clean_build_files.c"
			}
#line 309 "clean_build_files.vala"
			_tmp8_ = gtk_tree_model_iter_next (list_store, &iter);
#line 309 "clean_build_files.vala"
			valid = _tmp8_;
#line 296 "clean_build_files.vala"
			_g_object_unref0 (file_to_delete);
#line 1629 "clean_build_files.c"
		}
#line 312 "clean_build_files.vala"
		_tmp9_ = selected_files;
#line 312 "clean_build_files.vala"
		_tmp9__length1 = selected_files_length1;
#line 1635 "clean_build_files.c"
		{
			GFile** file_to_delete_collection = NULL;
			gint file_to_delete_collection_length1 = 0;
			gint _file_to_delete_collection_size_ = 0;
			gint file_to_delete_it = 0;
#line 312 "clean_build_files.vala"
			file_to_delete_collection = _tmp9_;
#line 312 "clean_build_files.vala"
			file_to_delete_collection_length1 = _tmp9__length1;
#line 312 "clean_build_files.vala"
			for (file_to_delete_it = 0; file_to_delete_it < file_to_delete_collection_length1; file_to_delete_it = file_to_delete_it + 1) {
#line 1647 "clean_build_files.c"
				GFile* _tmp10_;
				GFile* file_to_delete = NULL;
#line 312 "clean_build_files.vala"
				_tmp10_ = _g_object_ref0 (file_to_delete_collection[file_to_delete_it]);
#line 312 "clean_build_files.vala"
				file_to_delete = _tmp10_;
#line 1654 "clean_build_files.c"
				{
					GFile* _tmp11_;
#line 313 "clean_build_files.vala"
					_tmp11_ = file_to_delete;
#line 313 "clean_build_files.vala"
					utils_delete_file (_tmp11_);
#line 312 "clean_build_files.vala"
					_g_object_unref0 (file_to_delete);
#line 1663 "clean_build_files.c"
				}
			}
		}
#line 290 "clean_build_files.vala"
		selected_files = (_vala_array_free (selected_files, selected_files_length1, (GDestroyNotify) g_object_unref), NULL);
#line 1669 "clean_build_files.c"
	}
#line 316 "clean_build_files.vala"
	gtk_widget_destroy ((GtkWidget*) dialog);
#line 1673 "clean_build_files.c"
}

static gint
clean_build_files_on_sort_list_files (CleanBuildFiles* self,
                                      GtkTreeModel* model,
                                      GtkTreeIter* a,
                                      GtkTreeIter* b)
{
	gchar* name_a = NULL;
	gchar* name_b = NULL;
	GtkTreeIter _tmp0_;
	gchar* _tmp1_ = NULL;
	GtkTreeIter _tmp2_;
	gchar* _tmp3_ = NULL;
	gint result = 0;
#line 319 "clean_build_files.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 319 "clean_build_files.vala"
	g_return_val_if_fail (model != NULL, 0);
#line 319 "clean_build_files.vala"
	g_return_val_if_fail (a != NULL, 0);
#line 319 "clean_build_files.vala"
	g_return_val_if_fail (b != NULL, 0);
#line 324 "clean_build_files.vala"
	_tmp0_ = *a;
#line 324 "clean_build_files.vala"
	gtk_tree_model_get (model, &_tmp0_, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_NAME, &_tmp1_, -1);
#line 324 "clean_build_files.vala"
	_g_free0 (name_a);
#line 324 "clean_build_files.vala"
	name_a = _tmp1_;
#line 325 "clean_build_files.vala"
	_tmp2_ = *b;
#line 325 "clean_build_files.vala"
	gtk_tree_model_get (model, &_tmp2_, CLEAN_BUILD_FILES_CLEAN_FILE_COLUMN_NAME, &_tmp3_, -1);
#line 325 "clean_build_files.vala"
	_g_free0 (name_b);
#line 325 "clean_build_files.vala"
	name_b = _tmp3_;
#line 327 "clean_build_files.vala"
	result = g_utf8_collate (name_a, name_b);
#line 327 "clean_build_files.vala"
	_g_free0 (name_b);
#line 327 "clean_build_files.vala"
	_g_free0 (name_a);
#line 327 "clean_build_files.vala"
	return result;
#line 1721 "clean_build_files.c"
}

static void
clean_build_files_show_info_no_file (CleanBuildFiles* self)
{
	GtkDialog* dialog = NULL;
	MainWindow* _tmp0_;
	GtkMessageDialog* _tmp1_;
#line 330 "clean_build_files.vala"
	g_return_if_fail (self != NULL);
#line 332 "clean_build_files.vala"
	_tmp0_ = self->priv->_main_window;
#line 332 "clean_build_files.vala"
	_tmp1_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp0_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, "%s", _ ("No build file to clean up."));
#line 332 "clean_build_files.vala"
	g_object_ref_sink (_tmp1_);
#line 332 "clean_build_files.vala"
	dialog = (GtkDialog*) _tmp1_;
#line 338 "clean_build_files.vala"
	gtk_dialog_run (dialog);
#line 339 "clean_build_files.vala"
	gtk_widget_destroy ((GtkWidget*) dialog);
#line 330 "clean_build_files.vala"
	_g_object_unref0 (dialog);
#line 1746 "clean_build_files.c"
}

static void
clean_build_files_class_init (CleanBuildFilesClass * klass,
                              gpointer klass_data)
{
#line 22 "clean_build_files.vala"
	clean_build_files_parent_class = g_type_class_peek_parent (klass);
#line 22 "clean_build_files.vala"
	g_type_class_adjust_private_offset (klass, &CleanBuildFiles_private_offset);
#line 22 "clean_build_files.vala"
	G_OBJECT_CLASS (klass)->finalize = clean_build_files_finalize;
#line 1759 "clean_build_files.c"
}

static void
clean_build_files_instance_init (CleanBuildFiles * self,
                                 gpointer klass)
{
#line 22 "clean_build_files.vala"
	self->priv = clean_build_files_get_instance_private (self);
#line 1768 "clean_build_files.c"
}

static void
clean_build_files_finalize (GObject * obj)
{
	CleanBuildFiles * self;
#line 22 "clean_build_files.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CLEAN_BUILD_FILES, CleanBuildFiles);
#line 33 "clean_build_files.vala"
	_g_object_unref0 (self->priv->_doc);
#line 34 "clean_build_files.vala"
	_g_object_unref0 (self->priv->_settings);
#line 22 "clean_build_files.vala"
	G_OBJECT_CLASS (clean_build_files_parent_class)->finalize (obj);
#line 1783 "clean_build_files.c"
}

static GType
clean_build_files_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (CleanBuildFilesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clean_build_files_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CleanBuildFiles), 0, (GInstanceInitFunc) clean_build_files_instance_init, NULL };
	GType clean_build_files_type_id;
	clean_build_files_type_id = g_type_register_static (G_TYPE_OBJECT, "CleanBuildFiles", &g_define_type_info, 0);
	CleanBuildFiles_private_offset = g_type_add_instance_private (clean_build_files_type_id, sizeof (CleanBuildFilesPrivate));
	return clean_build_files_type_id;
}

GType
clean_build_files_get_type (void)
{
	static volatile gsize clean_build_files_type_id__volatile = 0;
	if (g_once_init_enter (&clean_build_files_type_id__volatile)) {
		GType clean_build_files_type_id;
		clean_build_files_type_id = clean_build_files_get_type_once ();
		g_once_init_leave (&clean_build_files_type_id__volatile, clean_build_files_type_id);
	}
	return clean_build_files_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
#line 27 "build_tools_preferences.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 1815 "clean_build_files.c"
		gint i;
#line 27 "build_tools_preferences.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 27 "build_tools_preferences.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 27 "build_tools_preferences.vala"
				destroy_func (((gpointer*) array)[i]);
#line 1823 "clean_build_files.c"
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
#line 27 "build_tools_preferences.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 27 "build_tools_preferences.vala"
	g_free (array);
#line 1838 "clean_build_files.c"
}

static gint
_vala_array_length (gpointer array)
{
	gint length;
	length = 0;
#line 27 "build_tools_preferences.vala"
	if (array) {
#line 27 "build_tools_preferences.vala"
		while (((gpointer*) array)[length]) {
#line 27 "build_tools_preferences.vala"
			length++;
#line 1852 "clean_build_files.c"
		}
	}
#line 27 "build_tools_preferences.vala"
	return length;
#line 1857 "clean_build_files.c"
}

