/* build_tools_preferences.c generated by valac 0.48.9, the Vala compiler
 * generated from build_tools_preferences.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2012-2015 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */
/* The preferences of the default and personal build tools.*/
/* For the configuration of a single build tool, see build_tool_dialog.vala.*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <latexila.h>
#include <stdlib.h>
#include <string.h>

#define TYPE_BUILD_TOOLS_PREFERENCES (build_tools_preferences_get_type ())
#define BUILD_TOOLS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferences))
#define BUILD_TOOLS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesClass))
#define IS_BUILD_TOOLS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS_PREFERENCES))
#define IS_BUILD_TOOLS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS_PREFERENCES))
#define BUILD_TOOLS_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesClass))

typedef struct _BuildToolsPreferences BuildToolsPreferences;
typedef struct _BuildToolsPreferencesClass BuildToolsPreferencesClass;
typedef struct _BuildToolsPreferencesPrivate BuildToolsPreferencesPrivate;
enum  {
	BUILD_TOOLS_PREFERENCES_0_PROPERTY,
	BUILD_TOOLS_PREFERENCES_NUM_PROPERTIES
};
static GParamSpec* build_tools_preferences_properties[BUILD_TOOLS_PREFERENCES_NUM_PROPERTIES];
typedef enum  {
	BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED,
	BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_PIXBUF,
	BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL,
	BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_DESCRIPTION,
	BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_N_COLUMNS
} BuildToolsPreferencesBuildToolColumn;

#define BUILD_TOOLS_PREFERENCES_TYPE_BUILD_TOOL_COLUMN (build_tools_preferences_build_tool_column_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BUILD_TOOL_DIALOG (build_tool_dialog_get_type ())
#define BUILD_TOOL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOL_DIALOG, BuildToolDialog))
#define BUILD_TOOL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogClass))
#define IS_BUILD_TOOL_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOL_DIALOG))
#define IS_BUILD_TOOL_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOL_DIALOG))
#define BUILD_TOOL_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOL_DIALOG, BuildToolDialogClass))

typedef struct _BuildToolDialog BuildToolDialog;
typedef struct _BuildToolDialogClass BuildToolDialogClass;
typedef struct _Block8Data Block8Data;
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;

struct _BuildToolsPreferences {
	GObject parent_instance;
	BuildToolsPreferencesPrivate * priv;
};

struct _BuildToolsPreferencesClass {
	GObjectClass parent_class;
};

struct _BuildToolsPreferencesPrivate {
	GtkDialog* _dialog;
	GtkListStore* _default_store;
	GtkListStore* _personal_store;
	GtkTreeView* _default_view;
	GtkTreeView* _personal_view;
};

struct _Block4Data {
	int _ref_count_;
	BuildToolsPreferences* self;
	GtkTreeSelection* default_select;
	GtkTreeSelection* personal_select;
};

struct _Block5Data {
	int _ref_count_;
	BuildToolsPreferences* self;
	GtkTreeViewColumn* label_column;
	GtkListStore* store;
	LatexilaBuildTools* build_tools;
};

struct _Block6Data {
	int _ref_count_;
	BuildToolsPreferences* self;
	GtkTreeView* view;
	LatexilaBuildTools* build_tools;
};

struct _Block7Data {
	int _ref_count_;
	BuildToolsPreferences* self;
	GtkTreeView* view;
	LatexilaBuildTools* build_tools;
};

struct _Block8Data {
	int _ref_count_;
	BuildToolsPreferences* self;
	GtkToolButton* up_button;
	GtkTreeSelection* select;
};

struct _Block9Data {
	int _ref_count_;
	BuildToolsPreferences* self;
	GtkToolButton* down_button;
	GtkTreeSelection* select;
};

struct _Block10Data {
	int _ref_count_;
	BuildToolsPreferences* self;
	GtkTreeSelection* select;
	GtkWidget* widget;
};

static gint BuildToolsPreferences_private_offset;
static gpointer build_tools_preferences_parent_class = NULL;

GType build_tools_preferences_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BuildToolsPreferences, g_object_unref)
static GType build_tools_preferences_build_tool_column_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
BuildToolsPreferences* build_tools_preferences_new (GtkWindow* parent_window);
BuildToolsPreferences* build_tools_preferences_construct (GType object_type,
                                                          GtkWindow* parent_window);
static GtkListStore* build_tools_preferences_get_new_store (BuildToolsPreferences* self);
static void build_tools_preferences_update_default_store (BuildToolsPreferences* self);
static void build_tools_preferences_update_personal_store (BuildToolsPreferences* self);
static void build_tools_preferences_init_views (BuildToolsPreferences* self);
static GtkWidget* build_tools_preferences_get_default_grid (BuildToolsPreferences* self);
static GtkWidget* build_tools_preferences_get_personal_grid (BuildToolsPreferences* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static GtkTreeView* build_tools_preferences_get_new_view (BuildToolsPreferences* self,
                                                   GtkListStore* store,
                                                   LatexilaBuildTools* build_tools);
static void __lambda102_ (Block4Data* _data4_);
static void build_tools_preferences_on_view_selection_changed (BuildToolsPreferences* self,
                                                        GtkTreeSelection* select,
                                                        GtkTreeSelection* other_select);
static void ___lambda102__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                               gpointer self);
static void __lambda103_ (Block4Data* _data4_);
static void ___lambda103__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                               gpointer self);
static GtkToolButton* build_tools_preferences_get_properties_button (BuildToolsPreferences* self,
                                                              GtkTreeView* view,
                                                              LatexilaBuildTools* build_tools,
                                                              gboolean read_only);
static GtkToolButton* build_tools_preferences_get_copy_button (BuildToolsPreferences* self,
                                                        GtkTreeView* view,
                                                        LatexilaBuildTools* build_tools);
static GtkWidget* build_tools_preferences_join_view_and_toolbar (BuildToolsPreferences* self,
                                                          GtkTreeView* view,
                                                          GtkToolbar* toolbar);
static GtkToolButton* build_tools_preferences_get_add_button (BuildToolsPreferences* self);
static GtkToolButton* build_tools_preferences_get_remove_button (BuildToolsPreferences* self);
static GtkToolButton* build_tools_preferences_get_up_button (BuildToolsPreferences* self);
static GtkToolButton* build_tools_preferences_get_down_button (BuildToolsPreferences* self);
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void __lambda91_ (Block5Data* _data5_,
                  const gchar* path_string);
static void ___lambda91__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender,
                                                    const gchar* path,
                                                    gpointer self);
static void __lambda92_ (Block5Data* _data5_,
                  GtkTreePath* path,
                  GtkTreeViewColumn* column);
static void build_tools_preferences_open_build_tool (BuildToolsPreferences* self,
                                              LatexilaBuildTools* build_tools,
                                              gint build_tool_num);
static void ___lambda92__gtk_tree_view_row_activated (GtkTreeView* _sender,
                                               GtkTreePath* path,
                                               GtkTreeViewColumn* column,
                                               gpointer self);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static void __vala_GtkTreePath_free0_ (gpointer var);
static inline void _g_list_free___vala_GtkTreePath_free0_ (GList* self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void build_tools_preferences_set_sensitivity_on_selection (BuildToolsPreferences* self,
                                                           GtkTreeView* view,
                                                           GtkWidget* widget);
static void __lambda105_ (Block6Data* _data6_);
gint utils_get_selected_row (GtkTreeView* view,
                             GtkTreeIter* iter);
static void ___lambda105__gtk_tool_button_clicked (GtkToolButton* _sender,
                                            gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda106_ (Block7Data* _data7_);
static void ___lambda106__gtk_tool_button_clicked (GtkToolButton* _sender,
                                            gpointer self);
static void __lambda107_ (BuildToolsPreferences* self);
GType build_tool_dialog_get_type (void) G_GNUC_CONST;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BuildToolDialog, g_object_unref)
BuildToolDialog* build_tool_dialog_new (GtkWindow* parent,
                                        gboolean editable);
BuildToolDialog* build_tool_dialog_construct (GType object_type,
                                              GtkWindow* parent,
                                              gboolean editable);
gboolean build_tool_dialog_create_personal_build_tool (BuildToolDialog* self);
static void ___lambda107__gtk_tool_button_clicked (GtkToolButton* _sender,
                                            gpointer self);
static void __lambda108_ (BuildToolsPreferences* self);
static void ___lambda108__gtk_tool_button_clicked (GtkToolButton* _sender,
                                            gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda109_ (Block8Data* _data8_);
static GtkTreePath* _vala_GtkTreePath_copy (GtkTreePath* self);
static void ___lambda109__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                               gpointer self);
static void __lambda110_ (Block8Data* _data8_);
gboolean utils_tree_model_iter_prev (GtkTreeModel* model,
                                     GtkTreeIter* iter);
static void ___lambda110__gtk_tool_button_clicked (GtkToolButton* _sender,
                                            gpointer self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
static void __lambda111_ (Block9Data* _data9_);
static void ___lambda111__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                               gpointer self);
static void __lambda112_ (Block9Data* _data9_);
static void ___lambda112__gtk_tool_button_clicked (GtkToolButton* _sender,
                                            gpointer self);
static void build_tools_preferences_update_store (BuildToolsPreferences* self,
                                           GtkListStore* store,
                                           LatexilaBuildTools* build_tools);
gboolean build_tool_dialog_open_build_tool (BuildToolDialog* self,
                                            LatexilaBuildTools* build_tools,
                                            gint build_tool_num);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static void __lambda104_ (Block10Data* _data10_);
static void ___lambda104__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                               gpointer self);
static void build_tools_preferences_finalize (GObject * obj);
static GType build_tools_preferences_get_type_once (void);

static inline gpointer
build_tools_preferences_get_instance_private (BuildToolsPreferences* self)
{
	return G_STRUCT_MEMBER_P (self, BuildToolsPreferences_private_offset);
}

static GType
build_tools_preferences_build_tool_column_get_type_once (void)
{
	static const GEnumValue values[] = {{BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED, "BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED", "enabled"}, {BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_PIXBUF, "BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_PIXBUF", "pixbuf"}, {BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL, "BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL", "label"}, {BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_DESCRIPTION, "BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_DESCRIPTION", "description"}, {BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_N_COLUMNS, "BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
	GType build_tools_preferences_build_tool_column_type_id;
	build_tools_preferences_build_tool_column_type_id = g_enum_register_static ("BuildToolsPreferencesBuildToolColumn", values);
	return build_tools_preferences_build_tool_column_type_id;
}

static GType
build_tools_preferences_build_tool_column_get_type (void)
{
	static volatile gsize build_tools_preferences_build_tool_column_type_id__volatile = 0;
	if (g_once_init_enter (&build_tools_preferences_build_tool_column_type_id__volatile)) {
		GType build_tools_preferences_build_tool_column_type_id;
		build_tools_preferences_build_tool_column_type_id = build_tools_preferences_build_tool_column_get_type_once ();
		g_once_init_leave (&build_tools_preferences_build_tool_column_type_id__volatile, build_tools_preferences_build_tool_column_type_id);
	}
	return build_tools_preferences_build_tool_column_type_id__volatile;
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 66 "build_tools_preferences.vala"
	return self ? g_object_ref (self) : NULL;
#line 306 "build_tools_preferences.c"
}

BuildToolsPreferences*
build_tools_preferences_construct (GType object_type,
                                   GtkWindow* parent_window)
{
	BuildToolsPreferences * self = NULL;
	GtkListStore* _tmp0_;
	GtkListStore* _tmp1_;
	GObject* _tmp2_;
	GObject* _tmp3_;
	GtkDialog* _tmp4_;
	GtkDialog* _tmp5_;
	GtkDialog* _tmp6_;
	GtkDialog* _tmp7_;
	GtkGrid* hgrid = NULL;
	GtkGrid* _tmp8_;
	GtkWidget* _tmp9_;
	GtkWidget* _tmp10_;
	GtkWidget* _tmp11_;
	GtkWidget* _tmp12_;
	GtkBox* content_area = NULL;
	GtkDialog* _tmp13_;
	GtkBox* _tmp14_;
	GtkBox* _tmp15_;
	GtkDialog* _tmp16_;
	GtkDialog* _tmp17_;
	LatexilaBuildToolsPersonal* _tmp18_;
#line 44 "build_tools_preferences.vala"
	g_return_val_if_fail (parent_window != NULL, NULL);
#line 44 "build_tools_preferences.vala"
	self = (BuildToolsPreferences*) g_object_new (object_type, NULL);
#line 46 "build_tools_preferences.vala"
	_tmp0_ = build_tools_preferences_get_new_store (self);
#line 46 "build_tools_preferences.vala"
	_g_object_unref0 (self->priv->_default_store);
#line 46 "build_tools_preferences.vala"
	self->priv->_default_store = _tmp0_;
#line 47 "build_tools_preferences.vala"
	_tmp1_ = build_tools_preferences_get_new_store (self);
#line 47 "build_tools_preferences.vala"
	_g_object_unref0 (self->priv->_personal_store);
#line 47 "build_tools_preferences.vala"
	self->priv->_personal_store = _tmp1_;
#line 48 "build_tools_preferences.vala"
	build_tools_preferences_update_default_store (self);
#line 49 "build_tools_preferences.vala"
	build_tools_preferences_update_personal_store (self);
#line 51 "build_tools_preferences.vala"
	build_tools_preferences_init_views (self);
#line 53 "build_tools_preferences.vala"
	_tmp2_ = g_object_new (gtk_dialog_get_type (), "use-header-bar", TRUE, NULL, NULL);
#line 53 "build_tools_preferences.vala"
	_tmp3_ = G_IS_INITIALLY_UNOWNED (_tmp2_) ? g_object_ref_sink (_tmp2_) : _tmp2_;
#line 53 "build_tools_preferences.vala"
	_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp3_) : NULL;
#line 53 "build_tools_preferences.vala"
	if (_tmp4_ == NULL) {
#line 53 "build_tools_preferences.vala"
		_g_object_unref0 (_tmp3_);
#line 367 "build_tools_preferences.c"
	}
#line 53 "build_tools_preferences.vala"
	_g_object_unref0 (self->priv->_dialog);
#line 53 "build_tools_preferences.vala"
	self->priv->_dialog = _tmp4_;
#line 55 "build_tools_preferences.vala"
	_tmp5_ = self->priv->_dialog;
#line 55 "build_tools_preferences.vala"
	gtk_window_set_transient_for ((GtkWindow*) _tmp5_, parent_window);
#line 56 "build_tools_preferences.vala"
	_tmp6_ = self->priv->_dialog;
#line 56 "build_tools_preferences.vala"
	gtk_window_set_destroy_with_parent ((GtkWindow*) _tmp6_, TRUE);
#line 57 "build_tools_preferences.vala"
	_tmp7_ = self->priv->_dialog;
#line 57 "build_tools_preferences.vala"
	gtk_window_set_title ((GtkWindow*) _tmp7_, _ ("Build Tools"));
#line 59 "build_tools_preferences.vala"
	_tmp8_ = (GtkGrid*) gtk_grid_new ();
#line 59 "build_tools_preferences.vala"
	g_object_ref_sink (_tmp8_);
#line 59 "build_tools_preferences.vala"
	hgrid = _tmp8_;
#line 60 "build_tools_preferences.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) hgrid, GTK_ORIENTATION_HORIZONTAL);
#line 61 "build_tools_preferences.vala"
	gtk_grid_set_column_spacing (hgrid, (guint) 10);
#line 63 "build_tools_preferences.vala"
	_tmp9_ = build_tools_preferences_get_default_grid (self);
#line 63 "build_tools_preferences.vala"
	_tmp10_ = _tmp9_;
#line 63 "build_tools_preferences.vala"
	gtk_container_add ((GtkContainer*) hgrid, _tmp10_);
#line 63 "build_tools_preferences.vala"
	_g_object_unref0 (_tmp10_);
#line 64 "build_tools_preferences.vala"
	_tmp11_ = build_tools_preferences_get_personal_grid (self);
#line 64 "build_tools_preferences.vala"
	_tmp12_ = _tmp11_;
#line 64 "build_tools_preferences.vala"
	gtk_container_add ((GtkContainer*) hgrid, _tmp12_);
#line 64 "build_tools_preferences.vala"
	_g_object_unref0 (_tmp12_);
#line 66 "build_tools_preferences.vala"
	_tmp13_ = self->priv->_dialog;
#line 66 "build_tools_preferences.vala"
	_tmp14_ = gtk_dialog_get_content_area (_tmp13_);
#line 66 "build_tools_preferences.vala"
	_tmp15_ = _g_object_ref0 (_tmp14_);
#line 66 "build_tools_preferences.vala"
	content_area = _tmp15_;
#line 67 "build_tools_preferences.vala"
	gtk_box_pack_start (content_area, (GtkWidget*) hgrid, TRUE, TRUE, (guint) 0);
#line 68 "build_tools_preferences.vala"
	gtk_widget_show_all ((GtkWidget*) content_area);
#line 70 "build_tools_preferences.vala"
	_tmp16_ = self->priv->_dialog;
#line 70 "build_tools_preferences.vala"
	gtk_dialog_run (_tmp16_);
#line 71 "build_tools_preferences.vala"
	_tmp17_ = self->priv->_dialog;
#line 71 "build_tools_preferences.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp17_);
#line 72 "build_tools_preferences.vala"
	_tmp18_ = latexila_build_tools_personal_get_instance ();
#line 72 "build_tools_preferences.vala"
	latexila_build_tools_personal_save (_tmp18_);
#line 53 "build_tools_preferences.vala"
	_g_object_unref0 (content_area);
#line 53 "build_tools_preferences.vala"
	_g_object_unref0 (hgrid);
#line 53 "build_tools_preferences.vala"
	return self;
#line 441 "build_tools_preferences.c"
}

BuildToolsPreferences*
build_tools_preferences_new (GtkWindow* parent_window)
{
#line 44 "build_tools_preferences.vala"
	return build_tools_preferences_construct (TYPE_BUILD_TOOLS_PREFERENCES, parent_window);
#line 449 "build_tools_preferences.c"
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
#line 75 "build_tools_preferences.vala"
	g_atomic_int_inc (&_data4_->_ref_count_);
#line 75 "build_tools_preferences.vala"
	return _data4_;
#line 459 "build_tools_preferences.c"
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
#line 75 "build_tools_preferences.vala"
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
#line 469 "build_tools_preferences.c"
		BuildToolsPreferences* self;
#line 75 "build_tools_preferences.vala"
		self = _data4_->self;
#line 75 "build_tools_preferences.vala"
		_g_object_unref0 (_data4_->personal_select);
#line 75 "build_tools_preferences.vala"
		_g_object_unref0 (_data4_->default_select);
#line 75 "build_tools_preferences.vala"
		_g_object_unref0 (self);
#line 75 "build_tools_preferences.vala"
		g_slice_free (Block4Data, _data4_);
#line 481 "build_tools_preferences.c"
	}
}

static void
__lambda102_ (Block4Data* _data4_)
{
	BuildToolsPreferences* self;
#line 88 "build_tools_preferences.vala"
	self = _data4_->self;
#line 90 "build_tools_preferences.vala"
	build_tools_preferences_on_view_selection_changed (self, _data4_->default_select, _data4_->personal_select);
#line 493 "build_tools_preferences.c"
}

static void
___lambda102__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                          gpointer self)
{
#line 88 "build_tools_preferences.vala"
	__lambda102_ (self);
#line 502 "build_tools_preferences.c"
}

static void
__lambda103_ (Block4Data* _data4_)
{
	BuildToolsPreferences* self;
#line 93 "build_tools_preferences.vala"
	self = _data4_->self;
#line 95 "build_tools_preferences.vala"
	build_tools_preferences_on_view_selection_changed (self, _data4_->personal_select, _data4_->default_select);
#line 513 "build_tools_preferences.c"
}

static void
___lambda103__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                          gpointer self)
{
#line 93 "build_tools_preferences.vala"
	__lambda103_ (self);
#line 522 "build_tools_preferences.c"
}

static void
build_tools_preferences_init_views (BuildToolsPreferences* self)
{
	Block4Data* _data4_;
	GtkListStore* _tmp0_;
	LatexilaBuildToolsDefault* _tmp1_;
	GtkTreeView* _tmp2_;
	GtkListStore* _tmp3_;
	LatexilaBuildToolsPersonal* _tmp4_;
	GtkTreeView* _tmp5_;
	GtkTreeView* _tmp6_;
	GtkTreeSelection* _tmp7_;
	GtkTreeSelection* _tmp8_;
	GtkTreeView* _tmp9_;
	GtkTreeSelection* _tmp10_;
	GtkTreeSelection* _tmp11_;
#line 75 "build_tools_preferences.vala"
	g_return_if_fail (self != NULL);
#line 75 "build_tools_preferences.vala"
	_data4_ = g_slice_new0 (Block4Data);
#line 75 "build_tools_preferences.vala"
	_data4_->_ref_count_ = 1;
#line 75 "build_tools_preferences.vala"
	_data4_->self = g_object_ref (self);
#line 77 "build_tools_preferences.vala"
	_tmp0_ = self->priv->_default_store;
#line 77 "build_tools_preferences.vala"
	_tmp1_ = latexila_build_tools_default_get_instance ();
#line 77 "build_tools_preferences.vala"
	_tmp2_ = build_tools_preferences_get_new_view (self, _tmp0_, (LatexilaBuildTools*) _tmp1_);
#line 77 "build_tools_preferences.vala"
	_g_object_unref0 (self->priv->_default_view);
#line 77 "build_tools_preferences.vala"
	self->priv->_default_view = _tmp2_;
#line 80 "build_tools_preferences.vala"
	_tmp3_ = self->priv->_personal_store;
#line 80 "build_tools_preferences.vala"
	_tmp4_ = latexila_build_tools_personal_get_instance ();
#line 80 "build_tools_preferences.vala"
	_tmp5_ = build_tools_preferences_get_new_view (self, _tmp3_, (LatexilaBuildTools*) _tmp4_);
#line 80 "build_tools_preferences.vala"
	_g_object_unref0 (self->priv->_personal_view);
#line 80 "build_tools_preferences.vala"
	self->priv->_personal_view = _tmp5_;
#line 85 "build_tools_preferences.vala"
	_tmp6_ = self->priv->_default_view;
#line 85 "build_tools_preferences.vala"
	_tmp7_ = gtk_tree_view_get_selection (_tmp6_);
#line 85 "build_tools_preferences.vala"
	_tmp8_ = _g_object_ref0 (_tmp7_);
#line 85 "build_tools_preferences.vala"
	_data4_->default_select = _tmp8_;
#line 86 "build_tools_preferences.vala"
	_tmp9_ = self->priv->_personal_view;
#line 86 "build_tools_preferences.vala"
	_tmp10_ = gtk_tree_view_get_selection (_tmp9_);
#line 86 "build_tools_preferences.vala"
	_tmp11_ = _g_object_ref0 (_tmp10_);
#line 86 "build_tools_preferences.vala"
	_data4_->personal_select = _tmp11_;
#line 88 "build_tools_preferences.vala"
	g_signal_connect_data (_data4_->default_select, "changed", (GCallback) ___lambda102__gtk_tree_selection_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
#line 93 "build_tools_preferences.vala"
	g_signal_connect_data (_data4_->personal_select, "changed", (GCallback) ___lambda103__gtk_tree_selection_changed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
#line 75 "build_tools_preferences.vala"
	block4_data_unref (_data4_);
#line 75 "build_tools_preferences.vala"
	_data4_ = NULL;
#line 593 "build_tools_preferences.c"
}

static GtkWidget*
build_tools_preferences_get_default_grid (BuildToolsPreferences* self)
{
	LatexilaBuildTools* default_build_tools = NULL;
	LatexilaBuildToolsDefault* _tmp0_;
	LatexilaBuildTools* _tmp1_;
	GtkToolButton* properties_button = NULL;
	GtkTreeView* _tmp2_;
	GtkToolButton* _tmp3_;
	GtkToolButton* copy_button = NULL;
	GtkTreeView* _tmp4_;
	GtkToolButton* _tmp5_;
	GtkToolbar* toolbar = NULL;
	GtkToolbar* _tmp6_;
	GtkWidget* join = NULL;
	GtkTreeView* _tmp7_;
	GtkWidget* _tmp8_;
	GtkWidget* _tmp9_;
	GtkWidget* _tmp10_;
	GtkWidget* result = NULL;
#line 99 "build_tools_preferences.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 101 "build_tools_preferences.vala"
	_tmp0_ = latexila_build_tools_default_get_instance ();
#line 101 "build_tools_preferences.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp0_) : NULL);
#line 101 "build_tools_preferences.vala"
	default_build_tools = _tmp1_;
#line 103 "build_tools_preferences.vala"
	_tmp2_ = self->priv->_default_view;
#line 103 "build_tools_preferences.vala"
	_tmp3_ = build_tools_preferences_get_properties_button (self, _tmp2_, default_build_tools, TRUE);
#line 103 "build_tools_preferences.vala"
	properties_button = _tmp3_;
#line 105 "build_tools_preferences.vala"
	_tmp4_ = self->priv->_default_view;
#line 105 "build_tools_preferences.vala"
	_tmp5_ = build_tools_preferences_get_copy_button (self, _tmp4_, default_build_tools);
#line 105 "build_tools_preferences.vala"
	copy_button = _tmp5_;
#line 107 "build_tools_preferences.vala"
	_tmp6_ = (GtkToolbar*) gtk_toolbar_new ();
#line 107 "build_tools_preferences.vala"
	g_object_ref_sink (_tmp6_);
#line 107 "build_tools_preferences.vala"
	toolbar = _tmp6_;
#line 108 "build_tools_preferences.vala"
	gtk_toolbar_insert (toolbar, (GtkToolItem*) properties_button, -1);
#line 109 "build_tools_preferences.vala"
	gtk_toolbar_insert (toolbar, (GtkToolItem*) copy_button, -1);
#line 111 "build_tools_preferences.vala"
	_tmp7_ = self->priv->_default_view;
#line 111 "build_tools_preferences.vala"
	_tmp8_ = build_tools_preferences_join_view_and_toolbar (self, _tmp7_, toolbar);
#line 111 "build_tools_preferences.vala"
	join = _tmp8_;
#line 113 "build_tools_preferences.vala"
	_tmp9_ = latexila_utils_get_dialog_component (_ ("Default Build Tools"), join);
#line 113 "build_tools_preferences.vala"
	_tmp10_ = _g_object_ref0 (_tmp9_);
#line 113 "build_tools_preferences.vala"
	result = _tmp10_;
#line 113 "build_tools_preferences.vala"
	_g_object_unref0 (join);
#line 113 "build_tools_preferences.vala"
	_g_object_unref0 (toolbar);
#line 113 "build_tools_preferences.vala"
	_g_object_unref0 (copy_button);
#line 113 "build_tools_preferences.vala"
	_g_object_unref0 (properties_button);
#line 113 "build_tools_preferences.vala"
	_g_object_unref0 (default_build_tools);
#line 113 "build_tools_preferences.vala"
	return result;
#line 670 "build_tools_preferences.c"
}

static GtkWidget*
build_tools_preferences_get_personal_grid (BuildToolsPreferences* self)
{
	LatexilaBuildTools* personal_build_tools = NULL;
	LatexilaBuildToolsPersonal* _tmp0_;
	LatexilaBuildTools* _tmp1_;
	GtkToolButton* properties_button = NULL;
	GtkTreeView* _tmp2_;
	GtkToolButton* _tmp3_;
	GtkToolButton* copy_button = NULL;
	GtkTreeView* _tmp4_;
	GtkToolButton* _tmp5_;
	GtkToolbar* toolbar = NULL;
	GtkToolbar* _tmp6_;
	GtkToolButton* _tmp7_;
	GtkToolButton* _tmp8_;
	GtkToolButton* _tmp9_;
	GtkToolButton* _tmp10_;
	GtkToolButton* _tmp11_;
	GtkToolButton* _tmp12_;
	GtkToolButton* _tmp13_;
	GtkToolButton* _tmp14_;
	GtkWidget* join = NULL;
	GtkTreeView* _tmp15_;
	GtkWidget* _tmp16_;
	GtkWidget* _tmp17_;
	GtkWidget* _tmp18_;
	GtkWidget* result = NULL;
#line 116 "build_tools_preferences.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 118 "build_tools_preferences.vala"
	_tmp0_ = latexila_build_tools_personal_get_instance ();
#line 118 "build_tools_preferences.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, latexila_build_tools_get_type ()) ? ((LatexilaBuildTools*) _tmp0_) : NULL);
#line 118 "build_tools_preferences.vala"
	personal_build_tools = _tmp1_;
#line 120 "build_tools_preferences.vala"
	_tmp2_ = self->priv->_personal_view;
#line 120 "build_tools_preferences.vala"
	_tmp3_ = build_tools_preferences_get_properties_button (self, _tmp2_, personal_build_tools, FALSE);
#line 120 "build_tools_preferences.vala"
	properties_button = _tmp3_;
#line 122 "build_tools_preferences.vala"
	_tmp4_ = self->priv->_personal_view;
#line 122 "build_tools_preferences.vala"
	_tmp5_ = build_tools_preferences_get_copy_button (self, _tmp4_, personal_build_tools);
#line 122 "build_tools_preferences.vala"
	copy_button = _tmp5_;
#line 124 "build_tools_preferences.vala"
	_tmp6_ = (GtkToolbar*) gtk_toolbar_new ();
#line 124 "build_tools_preferences.vala"
	g_object_ref_sink (_tmp6_);
#line 124 "build_tools_preferences.vala"
	toolbar = _tmp6_;
#line 125 "build_tools_preferences.vala"
	gtk_toolbar_insert (toolbar, (GtkToolItem*) properties_button, -1);
#line 126 "build_tools_preferences.vala"
	gtk_toolbar_insert (toolbar, (GtkToolItem*) copy_button, -1);
#line 127 "build_tools_preferences.vala"
	_tmp7_ = build_tools_preferences_get_add_button (self);
#line 127 "build_tools_preferences.vala"
	_tmp8_ = _tmp7_;
#line 127 "build_tools_preferences.vala"
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp8_, -1);
#line 127 "build_tools_preferences.vala"
	_g_object_unref0 (_tmp8_);
#line 128 "build_tools_preferences.vala"
	_tmp9_ = build_tools_preferences_get_remove_button (self);
#line 128 "build_tools_preferences.vala"
	_tmp10_ = _tmp9_;
#line 128 "build_tools_preferences.vala"
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp10_, -1);
#line 128 "build_tools_preferences.vala"
	_g_object_unref0 (_tmp10_);
#line 129 "build_tools_preferences.vala"
	_tmp11_ = build_tools_preferences_get_up_button (self);
#line 129 "build_tools_preferences.vala"
	_tmp12_ = _tmp11_;
#line 129 "build_tools_preferences.vala"
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp12_, -1);
#line 129 "build_tools_preferences.vala"
	_g_object_unref0 (_tmp12_);
#line 130 "build_tools_preferences.vala"
	_tmp13_ = build_tools_preferences_get_down_button (self);
#line 130 "build_tools_preferences.vala"
	_tmp14_ = _tmp13_;
#line 130 "build_tools_preferences.vala"
	gtk_toolbar_insert (toolbar, (GtkToolItem*) _tmp14_, -1);
#line 130 "build_tools_preferences.vala"
	_g_object_unref0 (_tmp14_);
#line 132 "build_tools_preferences.vala"
	_tmp15_ = self->priv->_personal_view;
#line 132 "build_tools_preferences.vala"
	_tmp16_ = build_tools_preferences_join_view_and_toolbar (self, _tmp15_, toolbar);
#line 132 "build_tools_preferences.vala"
	join = _tmp16_;
#line 134 "build_tools_preferences.vala"
	_tmp17_ = latexila_utils_get_dialog_component (_ ("Personal Build Tools"), join);
#line 134 "build_tools_preferences.vala"
	_tmp18_ = _g_object_ref0 (_tmp17_);
#line 134 "build_tools_preferences.vala"
	result = _tmp18_;
#line 134 "build_tools_preferences.vala"
	_g_object_unref0 (join);
#line 134 "build_tools_preferences.vala"
	_g_object_unref0 (toolbar);
#line 134 "build_tools_preferences.vala"
	_g_object_unref0 (copy_button);
#line 134 "build_tools_preferences.vala"
	_g_object_unref0 (properties_button);
#line 134 "build_tools_preferences.vala"
	_g_object_unref0 (personal_build_tools);
#line 134 "build_tools_preferences.vala"
	return result;
#line 787 "build_tools_preferences.c"
}

static GtkWidget*
build_tools_preferences_join_view_and_toolbar (BuildToolsPreferences* self,
                                               GtkTreeView* view,
                                               GtkToolbar* toolbar)
{
	GtkScrolledWindow* scrolled_window = NULL;
	GtkScrolledWindow* _tmp0_;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp1_;
	GtkStyleContext* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	GtkWidget* result = NULL;
#line 137 "build_tools_preferences.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 137 "build_tools_preferences.vala"
	g_return_val_if_fail (view != NULL, NULL);
#line 137 "build_tools_preferences.vala"
	g_return_val_if_fail (toolbar != NULL, NULL);
#line 139 "build_tools_preferences.vala"
	g_object_set ((GtkWidget*) view, "expand", TRUE, NULL);
#line 140 "build_tools_preferences.vala"
	_tmp0_ = utils_add_scrollbar ((GtkWidget*) view);
#line 140 "build_tools_preferences.vala"
	scrolled_window = _tmp0_;
#line 141 "build_tools_preferences.vala"
	gtk_scrolled_window_set_shadow_type (scrolled_window, GTK_SHADOW_IN);
#line 142 "build_tools_preferences.vala"
	gtk_widget_set_size_request ((GtkWidget*) scrolled_window, 350, 200);
#line 144 "build_tools_preferences.vala"
	gtk_toolbar_set_icon_size (toolbar, GTK_ICON_SIZE_MENU);
#line 145 "build_tools_preferences.vala"
	gtk_toolbar_set_style (toolbar, GTK_TOOLBAR_ICONS);
#line 147 "build_tools_preferences.vala"
	_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) toolbar);
#line 147 "build_tools_preferences.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 147 "build_tools_preferences.vala"
	context = _tmp2_;
#line 148 "build_tools_preferences.vala"
	gtk_style_context_add_class (context, GTK_STYLE_CLASS_INLINE_TOOLBAR);
#line 150 "build_tools_preferences.vala"
	_tmp3_ = latexila_utils_join_widgets ((GtkWidget*) scrolled_window, (GtkWidget*) toolbar);
#line 150 "build_tools_preferences.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 150 "build_tools_preferences.vala"
	result = _tmp4_;
#line 150 "build_tools_preferences.vala"
	_g_object_unref0 (context);
#line 150 "build_tools_preferences.vala"
	_g_object_unref0 (scrolled_window);
#line 150 "build_tools_preferences.vala"
	return result;
#line 843 "build_tools_preferences.c"
}

static GtkListStore*
build_tools_preferences_get_new_store (BuildToolsPreferences* self)
{
	GtkListStore* _tmp0_;
	GtkListStore* result = NULL;
#line 153 "build_tools_preferences.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 155 "build_tools_preferences.vala"
	_tmp0_ = gtk_list_store_new ((gint) BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_N_COLUMNS, G_TYPE_BOOLEAN, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, -1);
#line 155 "build_tools_preferences.vala"
	result = _tmp0_;
#line 155 "build_tools_preferences.vala"
	return result;
#line 859 "build_tools_preferences.c"
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
#line 163 "build_tools_preferences.vala"
	g_atomic_int_inc (&_data5_->_ref_count_);
#line 163 "build_tools_preferences.vala"
	return _data5_;
#line 869 "build_tools_preferences.c"
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
#line 163 "build_tools_preferences.vala"
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
#line 879 "build_tools_preferences.c"
		BuildToolsPreferences* self;
#line 163 "build_tools_preferences.vala"
		self = _data5_->self;
#line 163 "build_tools_preferences.vala"
		_g_object_unref0 (_data5_->label_column);
#line 163 "build_tools_preferences.vala"
		_g_object_unref0 (_data5_->store);
#line 163 "build_tools_preferences.vala"
		_g_object_unref0 (_data5_->build_tools);
#line 163 "build_tools_preferences.vala"
		_g_object_unref0 (self);
#line 163 "build_tools_preferences.vala"
		g_slice_free (Block5Data, _data5_);
#line 893 "build_tools_preferences.c"
	}
}

static void
__lambda91_ (Block5Data* _data5_,
             const gchar* path_string)
{
	BuildToolsPreferences* self;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	gboolean enabled = FALSE;
	GtkTreeModel* model = NULL;
	GtkTreeModel* _tmp1_;
	GtkTreeIter _tmp2_;
	gboolean _tmp3_ = FALSE;
	GtkTreeIter _tmp4_;
	gint num = 0;
#line 196 "build_tools_preferences.vala"
	self = _data5_->self;
#line 196 "build_tools_preferences.vala"
	g_return_if_fail (path_string != NULL);
#line 199 "build_tools_preferences.vala"
	gtk_tree_model_get_iter_from_string ((GtkTreeModel*) _data5_->store, &_tmp0_, path_string);
#line 199 "build_tools_preferences.vala"
	iter = _tmp0_;
#line 202 "build_tools_preferences.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_data5_->store, gtk_tree_model_get_type ()) ? ((GtkTreeModel*) _data5_->store) : NULL);
#line 202 "build_tools_preferences.vala"
	model = _tmp1_;
#line 203 "build_tools_preferences.vala"
	_tmp2_ = iter;
#line 203 "build_tools_preferences.vala"
	gtk_tree_model_get (model, &_tmp2_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED, &_tmp3_, -1);
#line 203 "build_tools_preferences.vala"
	enabled = _tmp3_;
#line 205 "build_tools_preferences.vala"
	enabled = !enabled;
#line 206 "build_tools_preferences.vala"
	_tmp4_ = iter;
#line 206 "build_tools_preferences.vala"
	gtk_list_store_set (_data5_->store, &_tmp4_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED, enabled, -1);
#line 208 "build_tools_preferences.vala"
	num = atoi (path_string);
#line 209 "build_tools_preferences.vala"
	latexila_build_tools_set_enabled (_data5_->build_tools, (guint) num, enabled);
#line 196 "build_tools_preferences.vala"
	_g_object_unref0 (model);
#line 941 "build_tools_preferences.c"
}

static void
___lambda91__gtk_cell_renderer_toggle_toggled (GtkCellRendererToggle* _sender,
                                               const gchar* path,
                                               gpointer self)
{
#line 196 "build_tools_preferences.vala"
	__lambda91_ (self, path);
#line 951 "build_tools_preferences.c"
}

static void
__lambda92_ (Block5Data* _data5_,
             GtkTreePath* path,
             GtkTreeViewColumn* column)
{
	BuildToolsPreferences* self;
#line 213 "build_tools_preferences.vala"
	self = _data5_->self;
#line 213 "build_tools_preferences.vala"
	g_return_if_fail (path != NULL);
#line 213 "build_tools_preferences.vala"
	g_return_if_fail (column != NULL);
#line 215 "build_tools_preferences.vala"
	if (column == _data5_->label_column) {
#line 968 "build_tools_preferences.c"
		gint build_tool_num = 0;
		gint _tmp0_ = 0;
		gint* _tmp1_;
		gint _tmp2_;
#line 217 "build_tools_preferences.vala"
		_tmp1_ = gtk_tree_path_get_indices_with_depth (path, &_tmp0_);
#line 217 "build_tools_preferences.vala"
		_tmp2_ = _tmp1_[0];
#line 217 "build_tools_preferences.vala"
		build_tool_num = _tmp2_;
#line 218 "build_tools_preferences.vala"
		build_tools_preferences_open_build_tool (self, _data5_->build_tools, build_tool_num);
#line 981 "build_tools_preferences.c"
	}
}

static void
___lambda92__gtk_tree_view_row_activated (GtkTreeView* _sender,
                                          GtkTreePath* path,
                                          GtkTreeViewColumn* column,
                                          gpointer self)
{
#line 213 "build_tools_preferences.vala"
	__lambda92_ (self, path, column);
#line 993 "build_tools_preferences.c"
}

static GtkTreeView*
build_tools_preferences_get_new_view (BuildToolsPreferences* self,
                                      GtkListStore* store,
                                      LatexilaBuildTools* build_tools)
{
	Block5Data* _data5_;
	GtkListStore* _tmp0_;
	LatexilaBuildTools* _tmp1_;
	GtkTreeView* view = NULL;
	GtkTreeView* _tmp2_;
	GtkTreeViewColumn* enabled_column = NULL;
	GtkTreeViewColumn* _tmp3_;
	GtkCellRendererToggle* toggle_renderer = NULL;
	GtkCellRendererToggle* _tmp4_;
	GtkTreeViewColumn* _tmp5_;
	GtkCellRendererPixbuf* pixbuf_renderer = NULL;
	GtkCellRendererPixbuf* _tmp6_;
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp7_;
	GtkTreeSelection* select = NULL;
	GtkTreeSelection* _tmp8_;
	GtkTreeSelection* _tmp9_;
	GtkTreeView* result = NULL;
#line 163 "build_tools_preferences.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 163 "build_tools_preferences.vala"
	g_return_val_if_fail (store != NULL, NULL);
#line 163 "build_tools_preferences.vala"
	g_return_val_if_fail (build_tools != NULL, NULL);
#line 163 "build_tools_preferences.vala"
	_data5_ = g_slice_new0 (Block5Data);
#line 163 "build_tools_preferences.vala"
	_data5_->_ref_count_ = 1;
#line 163 "build_tools_preferences.vala"
	_data5_->self = g_object_ref (self);
#line 163 "build_tools_preferences.vala"
	_tmp0_ = _g_object_ref0 (store);
#line 163 "build_tools_preferences.vala"
	_g_object_unref0 (_data5_->store);
#line 163 "build_tools_preferences.vala"
	_data5_->store = _tmp0_;
#line 163 "build_tools_preferences.vala"
	_tmp1_ = _g_object_ref0 (build_tools);
#line 163 "build_tools_preferences.vala"
	_g_object_unref0 (_data5_->build_tools);
#line 163 "build_tools_preferences.vala"
	_data5_->build_tools = _tmp1_;
#line 165 "build_tools_preferences.vala"
	_tmp2_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _data5_->store);
#line 165 "build_tools_preferences.vala"
	g_object_ref_sink (_tmp2_);
#line 165 "build_tools_preferences.vala"
	view = _tmp2_;
#line 167 "build_tools_preferences.vala"
	_tmp3_ = gtk_tree_view_column_new ();
#line 167 "build_tools_preferences.vala"
	g_object_ref_sink (_tmp3_);
#line 167 "build_tools_preferences.vala"
	enabled_column = _tmp3_;
#line 168 "build_tools_preferences.vala"
	gtk_tree_view_column_set_title (enabled_column, _ ("Enabled"));
#line 169 "build_tools_preferences.vala"
	gtk_tree_view_append_column (view, enabled_column);
#line 171 "build_tools_preferences.vala"
	_tmp4_ = (GtkCellRendererToggle*) gtk_cell_renderer_toggle_new ();
#line 171 "build_tools_preferences.vala"
	g_object_ref_sink (_tmp4_);
#line 171 "build_tools_preferences.vala"
	toggle_renderer = _tmp4_;
#line 172 "build_tools_preferences.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) enabled_column, (GtkCellRenderer*) toggle_renderer, FALSE);
#line 173 "build_tools_preferences.vala"
	gtk_tree_view_column_set_attributes (enabled_column, (GtkCellRenderer*) toggle_renderer, "active", BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED, NULL);
#line 176 "build_tools_preferences.vala"
	_tmp5_ = gtk_tree_view_column_new ();
#line 176 "build_tools_preferences.vala"
	g_object_ref_sink (_tmp5_);
#line 176 "build_tools_preferences.vala"
	_data5_->label_column = _tmp5_;
#line 177 "build_tools_preferences.vala"
	gtk_tree_view_column_set_title (_data5_->label_column, _ ("Label"));
#line 178 "build_tools_preferences.vala"
	gtk_tree_view_append_column (view, _data5_->label_column);
#line 180 "build_tools_preferences.vala"
	_tmp6_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
#line 180 "build_tools_preferences.vala"
	g_object_ref_sink (_tmp6_);
#line 180 "build_tools_preferences.vala"
	pixbuf_renderer = _tmp6_;
#line 181 "build_tools_preferences.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _data5_->label_column, (GtkCellRenderer*) pixbuf_renderer, FALSE);
#line 182 "build_tools_preferences.vala"
	gtk_tree_view_column_set_attributes (_data5_->label_column, (GtkCellRenderer*) pixbuf_renderer, "icon-name", BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_PIXBUF, NULL);
#line 185 "build_tools_preferences.vala"
	_tmp7_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 185 "build_tools_preferences.vala"
	g_object_ref_sink (_tmp7_);
#line 185 "build_tools_preferences.vala"
	text_renderer = _tmp7_;
#line 186 "build_tools_preferences.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _data5_->label_column, (GtkCellRenderer*) text_renderer, TRUE);
#line 187 "build_tools_preferences.vala"
	gtk_tree_view_column_set_attributes (_data5_->label_column, (GtkCellRenderer*) text_renderer, "text", BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL, NULL);
#line 190 "build_tools_preferences.vala"
	gtk_tree_view_set_tooltip_column (view, (gint) BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_DESCRIPTION);
#line 192 "build_tools_preferences.vala"
	_tmp8_ = gtk_tree_view_get_selection (view);
#line 192 "build_tools_preferences.vala"
	_tmp9_ = _g_object_ref0 (_tmp8_);
#line 192 "build_tools_preferences.vala"
	select = _tmp9_;
#line 193 "build_tools_preferences.vala"
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
#line 196 "build_tools_preferences.vala"
	g_signal_connect_data (toggle_renderer, "toggled", (GCallback) ___lambda91__gtk_cell_renderer_toggle_toggled, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
#line 213 "build_tools_preferences.vala"
	g_signal_connect_data (view, "row-activated", (GCallback) ___lambda92__gtk_tree_view_row_activated, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
#line 222 "build_tools_preferences.vala"
	result = view;
#line 222 "build_tools_preferences.vala"
	_g_object_unref0 (select);
#line 222 "build_tools_preferences.vala"
	_g_object_unref0 (text_renderer);
#line 222 "build_tools_preferences.vala"
	_g_object_unref0 (pixbuf_renderer);
#line 222 "build_tools_preferences.vala"
	_g_object_unref0 (toggle_renderer);
#line 222 "build_tools_preferences.vala"
	_g_object_unref0 (enabled_column);
#line 222 "build_tools_preferences.vala"
	block5_data_unref (_data5_);
#line 222 "build_tools_preferences.vala"
	_data5_ = NULL;
#line 222 "build_tools_preferences.vala"
	return result;
#line 1131 "build_tools_preferences.c"
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
#line 225 "build_tools_preferences.vala"
	g_boxed_free (gtk_tree_path_get_type (), self);
#line 1139 "build_tools_preferences.c"
}

static void
__vala_GtkTreePath_free0_ (gpointer var)
{
#line 225 "build_tools_preferences.vala"
	(var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL));
#line 1147 "build_tools_preferences.c"
}

static inline void
_g_list_free___vala_GtkTreePath_free0_ (GList* self)
{
#line 225 "build_tools_preferences.vala"
	g_list_free_full (self, (GDestroyNotify) __vala_GtkTreePath_free0_);
#line 1155 "build_tools_preferences.c"
}

static void
build_tools_preferences_on_view_selection_changed (BuildToolsPreferences* self,
                                                   GtkTreeSelection* select,
                                                   GtkTreeSelection* other_select)
{
	GList* selected_items = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
#line 225 "build_tools_preferences.vala"
	g_return_if_fail (self != NULL);
#line 225 "build_tools_preferences.vala"
	g_return_if_fail (select != NULL);
#line 225 "build_tools_preferences.vala"
	g_return_if_fail (other_select != NULL);
#line 228 "build_tools_preferences.vala"
	_tmp0_ = gtk_tree_selection_get_selected_rows (select, NULL);
#line 228 "build_tools_preferences.vala"
	selected_items = _tmp0_;
#line 229 "build_tools_preferences.vala"
	_tmp1_ = selected_items;
#line 229 "build_tools_preferences.vala"
	if (g_list_length (_tmp1_) > ((guint) 0)) {
#line 230 "build_tools_preferences.vala"
		gtk_tree_selection_unselect_all (other_select);
#line 1182 "build_tools_preferences.c"
	}
#line 225 "build_tools_preferences.vala"
	(selected_items == NULL) ? NULL : (selected_items = (_g_list_free___vala_GtkTreePath_free0_ (selected_items), NULL));
#line 1186 "build_tools_preferences.c"
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
#line 233 "build_tools_preferences.vala"
	g_atomic_int_inc (&_data6_->_ref_count_);
#line 233 "build_tools_preferences.vala"
	return _data6_;
#line 1196 "build_tools_preferences.c"
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
#line 233 "build_tools_preferences.vala"
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
#line 1206 "build_tools_preferences.c"
		BuildToolsPreferences* self;
#line 233 "build_tools_preferences.vala"
		self = _data6_->self;
#line 233 "build_tools_preferences.vala"
		_g_object_unref0 (_data6_->view);
#line 233 "build_tools_preferences.vala"
		_g_object_unref0 (_data6_->build_tools);
#line 233 "build_tools_preferences.vala"
		_g_object_unref0 (self);
#line 233 "build_tools_preferences.vala"
		g_slice_free (Block6Data, _data6_);
#line 1218 "build_tools_preferences.c"
	}
}

static void
__lambda105_ (Block6Data* _data6_)
{
	BuildToolsPreferences* self;
	gint build_tool_num = 0;
#line 251 "build_tools_preferences.vala"
	self = _data6_->self;
#line 253 "build_tools_preferences.vala"
	build_tool_num = utils_get_selected_row (_data6_->view, NULL);
#line 255 "build_tools_preferences.vala"
	if (0 <= build_tool_num) {
#line 256 "build_tools_preferences.vala"
		build_tools_preferences_open_build_tool (self, _data6_->build_tools, build_tool_num);
#line 1235 "build_tools_preferences.c"
	}
}

static void
___lambda105__gtk_tool_button_clicked (GtkToolButton* _sender,
                                       gpointer self)
{
#line 251 "build_tools_preferences.vala"
	__lambda105_ (self);
#line 1245 "build_tools_preferences.c"
}

static GtkToolButton*
build_tools_preferences_get_properties_button (BuildToolsPreferences* self,
                                               GtkTreeView* view,
                                               LatexilaBuildTools* build_tools,
                                               gboolean read_only)
{
	Block6Data* _data6_;
	GtkTreeView* _tmp0_;
	LatexilaBuildTools* _tmp1_;
	GtkToolButton* properties_button = NULL;
	GtkToolButton* _tmp2_;
	GtkToolButton* _tmp7_;
	GtkToolButton* _tmp8_;
	GtkToolButton* result = NULL;
#line 233 "build_tools_preferences.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 233 "build_tools_preferences.vala"
	g_return_val_if_fail (view != NULL, NULL);
#line 233 "build_tools_preferences.vala"
	g_return_val_if_fail (build_tools != NULL, NULL);
#line 233 "build_tools_preferences.vala"
	_data6_ = g_slice_new0 (Block6Data);
#line 233 "build_tools_preferences.vala"
	_data6_->_ref_count_ = 1;
#line 233 "build_tools_preferences.vala"
	_data6_->self = g_object_ref (self);
#line 233 "build_tools_preferences.vala"
	_tmp0_ = _g_object_ref0 (view);
#line 233 "build_tools_preferences.vala"
	_g_object_unref0 (_data6_->view);
#line 233 "build_tools_preferences.vala"
	_data6_->view = _tmp0_;
#line 233 "build_tools_preferences.vala"
	_tmp1_ = _g_object_ref0 (build_tools);
#line 233 "build_tools_preferences.vala"
	_g_object_unref0 (_data6_->build_tools);
#line 233 "build_tools_preferences.vala"
	_data6_->build_tools = _tmp1_;
#line 236 "build_tools_preferences.vala"
	_tmp2_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
#line 236 "build_tools_preferences.vala"
	g_object_ref_sink (_tmp2_);
#line 236 "build_tools_preferences.vala"
	properties_button = _tmp2_;
#line 238 "build_tools_preferences.vala"
	if (read_only) {
#line 1294 "build_tools_preferences.c"
		GtkToolButton* _tmp3_;
		GtkToolButton* _tmp4_;
#line 240 "build_tools_preferences.vala"
		_tmp3_ = properties_button;
#line 240 "build_tools_preferences.vala"
		gtk_tool_button_set_icon_name (_tmp3_, "edit-find-symbolic");
#line 241 "build_tools_preferences.vala"
		_tmp4_ = properties_button;
#line 241 "build_tools_preferences.vala"
		gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp4_, _ ("View the properties (read-only)"));
#line 1305 "build_tools_preferences.c"
	} else {
		GtkToolButton* _tmp5_;
		GtkToolButton* _tmp6_;
#line 245 "build_tools_preferences.vala"
		_tmp5_ = properties_button;
#line 245 "build_tools_preferences.vala"
		gtk_tool_button_set_icon_name (_tmp5_, "document-properties-symbolic");
#line 246 "build_tools_preferences.vala"
		_tmp6_ = properties_button;
#line 246 "build_tools_preferences.vala"
		gtk_tool_item_set_tooltip_text ((GtkToolItem*) _tmp6_, _ ("Edit the properties"));
#line 1317 "build_tools_preferences.c"
	}
#line 249 "build_tools_preferences.vala"
	_tmp7_ = properties_button;
#line 249 "build_tools_preferences.vala"
	build_tools_preferences_set_sensitivity_on_selection (self, _data6_->view, (GtkWidget*) _tmp7_);
#line 251 "build_tools_preferences.vala"
	_tmp8_ = properties_button;
#line 251 "build_tools_preferences.vala"
	g_signal_connect_data (_tmp8_, "clicked", (GCallback) ___lambda105__gtk_tool_button_clicked, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
#line 259 "build_tools_preferences.vala"
	result = properties_button;
#line 259 "build_tools_preferences.vala"
	block6_data_unref (_data6_);
#line 259 "build_tools_preferences.vala"
	_data6_ = NULL;
#line 259 "build_tools_preferences.vala"
	return result;
#line 1335 "build_tools_preferences.c"
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
#line 262 "build_tools_preferences.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 262 "build_tools_preferences.vala"
	return _data7_;
#line 1345 "build_tools_preferences.c"
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 262 "build_tools_preferences.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 1355 "build_tools_preferences.c"
		BuildToolsPreferences* self;
#line 262 "build_tools_preferences.vala"
		self = _data7_->self;
#line 262 "build_tools_preferences.vala"
		_g_object_unref0 (_data7_->view);
#line 262 "build_tools_preferences.vala"
		_g_object_unref0 (_data7_->build_tools);
#line 262 "build_tools_preferences.vala"
		_g_object_unref0 (self);
#line 262 "build_tools_preferences.vala"
		g_slice_free (Block7Data, _data7_);
#line 1367 "build_tools_preferences.c"
	}
}

static void
__lambda106_ (Block7Data* _data7_)
{
	BuildToolsPreferences* self;
	gint selected_row = 0;
	LatexilaBuildTool* tool = NULL;
	LatexilaBuildTool* _tmp0_;
	LatexilaBuildTool* _tmp1_;
	LatexilaBuildTool* _tmp2_;
	LatexilaBuildTool* _tmp3_;
	LatexilaBuildTool* _tmp4_;
	LatexilaBuildTool* _tmp5_;
	LatexilaBuildTool* _tmp6_;
	LatexilaBuildTool* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	LatexilaBuildToolsPersonal* personal_build_tools = NULL;
	LatexilaBuildToolsPersonal* _tmp13_;
	LatexilaBuildToolsPersonal* _tmp14_;
	LatexilaBuildToolsPersonal* _tmp15_;
	LatexilaBuildTool* _tmp16_;
#line 270 "build_tools_preferences.vala"
	self = _data7_->self;
#line 272 "build_tools_preferences.vala"
	selected_row = utils_get_selected_row (_data7_->view, NULL);
#line 273 "build_tools_preferences.vala"
	if (selected_row < 0) {
#line 274 "build_tools_preferences.vala"
		return;
#line 1403 "build_tools_preferences.c"
	}
#line 276 "build_tools_preferences.vala"
	_tmp0_ = latexila_build_tools_nth (_data7_->build_tools, (guint) selected_row);
#line 276 "build_tools_preferences.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 276 "build_tools_preferences.vala"
	tool = _tmp1_;
#line 277 "build_tools_preferences.vala"
	_tmp2_ = tool;
#line 277 "build_tools_preferences.vala"
	g_return_if_fail (_tmp2_ != NULL);
#line 279 "build_tools_preferences.vala"
	_tmp3_ = tool;
#line 279 "build_tools_preferences.vala"
	_tmp4_ = latexila_build_tool_clone (_tmp3_);
#line 279 "build_tools_preferences.vala"
	_g_object_unref0 (tool);
#line 279 "build_tools_preferences.vala"
	tool = _tmp4_;
#line 280 "build_tools_preferences.vala"
	_tmp5_ = tool;
#line 280 "build_tools_preferences.vala"
	g_object_set (_tmp5_, "enabled", FALSE, NULL);
#line 281 "build_tools_preferences.vala"
	_tmp6_ = tool;
#line 281 "build_tools_preferences.vala"
	_tmp7_ = tool;
#line 281 "build_tools_preferences.vala"
	g_object_get (_tmp7_, "label", &_tmp8_, NULL);
#line 281 "build_tools_preferences.vala"
	_tmp9_ = _tmp8_;
#line 281 "build_tools_preferences.vala"
	_tmp10_ = _tmp9_;
#line 281 "build_tools_preferences.vala"
	_tmp11_ = g_strdup_printf (_ ("%s [copy]"), _tmp10_);
#line 281 "build_tools_preferences.vala"
	_tmp12_ = _tmp11_;
#line 281 "build_tools_preferences.vala"
	g_object_set (_tmp6_, "label", _tmp12_, NULL);
#line 281 "build_tools_preferences.vala"
	_g_free0 (_tmp12_);
#line 281 "build_tools_preferences.vala"
	_g_free0 (_tmp10_);
#line 283 "build_tools_preferences.vala"
	_tmp13_ = latexila_build_tools_personal_get_instance ();
#line 283 "build_tools_preferences.vala"
	_tmp14_ = _g_object_ref0 (_tmp13_);
#line 283 "build_tools_preferences.vala"
	personal_build_tools = _tmp14_;
#line 285 "build_tools_preferences.vala"
	_tmp15_ = personal_build_tools;
#line 285 "build_tools_preferences.vala"
	_tmp16_ = tool;
#line 285 "build_tools_preferences.vala"
	latexila_build_tools_personal_add (_tmp15_, _tmp16_);
#line 287 "build_tools_preferences.vala"
	build_tools_preferences_update_personal_store (self);
#line 270 "build_tools_preferences.vala"
	_g_object_unref0 (personal_build_tools);
#line 270 "build_tools_preferences.vala"
	_g_object_unref0 (tool);
#line 1465 "build_tools_preferences.c"
}

static void
___lambda106__gtk_tool_button_clicked (GtkToolButton* _sender,
                                       gpointer self)
{
#line 270 "build_tools_preferences.vala"
	__lambda106_ (self);
#line 1474 "build_tools_preferences.c"
}

static GtkToolButton*
build_tools_preferences_get_copy_button (BuildToolsPreferences* self,
                                         GtkTreeView* view,
                                         LatexilaBuildTools* build_tools)
{
	Block7Data* _data7_;
	GtkTreeView* _tmp0_;
	LatexilaBuildTools* _tmp1_;
	GtkToolButton* copy_button = NULL;
	GtkToolButton* _tmp2_;
	GtkToolButton* result = NULL;
#line 262 "build_tools_preferences.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 262 "build_tools_preferences.vala"
	g_return_val_if_fail (view != NULL, NULL);
#line 262 "build_tools_preferences.vala"
	g_return_val_if_fail (build_tools != NULL, NULL);
#line 262 "build_tools_preferences.vala"
	_data7_ = g_slice_new0 (Block7Data);
#line 262 "build_tools_preferences.vala"
	_data7_->_ref_count_ = 1;
#line 262 "build_tools_preferences.vala"
	_data7_->self = g_object_ref (self);
#line 262 "build_tools_preferences.vala"
	_tmp0_ = _g_object_ref0 (view);
#line 262 "build_tools_preferences.vala"
	_g_object_unref0 (_data7_->view);
#line 262 "build_tools_preferences.vala"
	_data7_->view = _tmp0_;
#line 262 "build_tools_preferences.vala"
	_tmp1_ = _g_object_ref0 (build_tools);
#line 262 "build_tools_preferences.vala"
	_g_object_unref0 (_data7_->build_tools);
#line 262 "build_tools_preferences.vala"
	_data7_->build_tools = _tmp1_;
#line 264 "build_tools_preferences.vala"
	_tmp2_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
#line 264 "build_tools_preferences.vala"
	g_object_ref_sink (_tmp2_);
#line 264 "build_tools_preferences.vala"
	copy_button = _tmp2_;
#line 265 "build_tools_preferences.vala"
	gtk_tool_button_set_icon_name (copy_button, "edit-copy-symbolic");
#line 266 "build_tools_preferences.vala"
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) copy_button, _ ("Create a copy"));
#line 268 "build_tools_preferences.vala"
	build_tools_preferences_set_sensitivity_on_selection (self, _data7_->view, (GtkWidget*) copy_button);
#line 270 "build_tools_preferences.vala"
	g_signal_connect_data (copy_button, "clicked", (GCallback) ___lambda106__gtk_tool_button_clicked, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
#line 290 "build_tools_preferences.vala"
	result = copy_button;
#line 290 "build_tools_preferences.vala"
	block7_data_unref (_data7_);
#line 290 "build_tools_preferences.vala"
	_data7_ = NULL;
#line 290 "build_tools_preferences.vala"
	return result;
#line 1534 "build_tools_preferences.c"
}

static void
__lambda107_ (BuildToolsPreferences* self)
{
	BuildToolDialog* dialog = NULL;
	GtkDialog* _tmp0_;
	BuildToolDialog* _tmp1_;
	BuildToolDialog* _tmp2_;
#line 301 "build_tools_preferences.vala"
	_tmp0_ = self->priv->_dialog;
#line 301 "build_tools_preferences.vala"
	_tmp1_ = build_tool_dialog_new ((GtkWindow*) _tmp0_, TRUE);
#line 301 "build_tools_preferences.vala"
	dialog = _tmp1_;
#line 303 "build_tools_preferences.vala"
	_tmp2_ = dialog;
#line 303 "build_tools_preferences.vala"
	if (build_tool_dialog_create_personal_build_tool (_tmp2_)) {
#line 304 "build_tools_preferences.vala"
		build_tools_preferences_update_personal_store (self);
#line 1556 "build_tools_preferences.c"
	}
#line 299 "build_tools_preferences.vala"
	_g_object_unref0 (dialog);
#line 1560 "build_tools_preferences.c"
}

static void
___lambda107__gtk_tool_button_clicked (GtkToolButton* _sender,
                                       gpointer self)
{
#line 299 "build_tools_preferences.vala"
	__lambda107_ ((BuildToolsPreferences*) self);
#line 1569 "build_tools_preferences.c"
}

static GtkToolButton*
build_tools_preferences_get_add_button (BuildToolsPreferences* self)
{
	GtkToolButton* add_button = NULL;
	GtkToolButton* _tmp0_;
	GtkToolButton* result = NULL;
#line 293 "build_tools_preferences.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 295 "build_tools_preferences.vala"
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
#line 295 "build_tools_preferences.vala"
	g_object_ref_sink (_tmp0_);
#line 295 "build_tools_preferences.vala"
	add_button = _tmp0_;
#line 296 "build_tools_preferences.vala"
	gtk_tool_button_set_icon_name (add_button, "list-add-symbolic");
#line 297 "build_tools_preferences.vala"
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) add_button, _ ("Add…"));
#line 299 "build_tools_preferences.vala"
	g_signal_connect_object (add_button, "clicked", (GCallback) ___lambda107__gtk_tool_button_clicked, self, 0);
#line 307 "build_tools_preferences.vala"
	result = add_button;
#line 307 "build_tools_preferences.vala"
	return result;
#line 1596 "build_tools_preferences.c"
}

static void
__lambda108_ (BuildToolsPreferences* self)
{
	GtkTreeIter iter = {0};
	gint selected_row = 0;
	GtkTreeView* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_;
	gchar* label = NULL;
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	gchar* _tmp7_ = NULL;
	GtkDialog* dialog = NULL;
	GtkDialog* _tmp8_;
	const gchar* _tmp9_;
	GtkMessageDialog* _tmp10_;
	GtkDialog* _tmp11_;
	GtkDialog* _tmp12_;
	GtkDialog* _tmp15_;
#line 321 "build_tools_preferences.vala"
	_tmp0_ = self->priv->_personal_view;
#line 321 "build_tools_preferences.vala"
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
#line 321 "build_tools_preferences.vala"
	iter = _tmp1_;
#line 321 "build_tools_preferences.vala"
	selected_row = _tmp2_;
#line 322 "build_tools_preferences.vala"
	if (selected_row == -1) {
#line 323 "build_tools_preferences.vala"
		return;
#line 1633 "build_tools_preferences.c"
	}
#line 326 "build_tools_preferences.vala"
	_tmp3_ = self->priv->_personal_store;
#line 326 "build_tools_preferences.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_tree_model_get_type ()) ? ((GtkTreeModel*) _tmp3_) : NULL);
#line 326 "build_tools_preferences.vala"
	model = _tmp4_;
#line 327 "build_tools_preferences.vala"
	_tmp5_ = model;
#line 327 "build_tools_preferences.vala"
	_tmp6_ = iter;
#line 327 "build_tools_preferences.vala"
	gtk_tree_model_get (_tmp5_, &_tmp6_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL, &_tmp7_, -1);
#line 327 "build_tools_preferences.vala"
	_g_free0 (label);
#line 327 "build_tools_preferences.vala"
	label = _tmp7_;
#line 329 "build_tools_preferences.vala"
	_tmp8_ = self->priv->_dialog;
#line 329 "build_tools_preferences.vala"
	_tmp9_ = label;
#line 329 "build_tools_preferences.vala"
	_tmp10_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp8_, GTK_DIALOG_DESTROY_WITH_PARENT | GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _ ("Do you really want to delete the build tool “%s”?"), _tmp9_);
#line 329 "build_tools_preferences.vala"
	g_object_ref_sink (_tmp10_);
#line 329 "build_tools_preferences.vala"
	dialog = (GtkDialog*) _tmp10_;
#line 335 "build_tools_preferences.vala"
	_tmp11_ = dialog;
#line 335 "build_tools_preferences.vala"
	gtk_dialog_add_buttons (_tmp11_, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("_Delete"), GTK_RESPONSE_YES, NULL);
#line 338 "build_tools_preferences.vala"
	_tmp12_ = dialog;
#line 338 "build_tools_preferences.vala"
	if (gtk_dialog_run (_tmp12_) == ((gint) GTK_RESPONSE_YES)) {
#line 1669 "build_tools_preferences.c"
		GtkListStore* _tmp13_;
		LatexilaBuildToolsPersonal* _tmp14_;
#line 340 "build_tools_preferences.vala"
		_tmp13_ = self->priv->_personal_store;
#line 340 "build_tools_preferences.vala"
		gtk_list_store_remove (_tmp13_, &iter);
#line 341 "build_tools_preferences.vala"
		_tmp14_ = latexila_build_tools_personal_get_instance ();
#line 341 "build_tools_preferences.vala"
		latexila_build_tools_personal_delete (_tmp14_, (guint) selected_row);
#line 1680 "build_tools_preferences.c"
	}
#line 344 "build_tools_preferences.vala"
	_tmp15_ = dialog;
#line 344 "build_tools_preferences.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp15_);
#line 318 "build_tools_preferences.vala"
	_g_object_unref0 (dialog);
#line 318 "build_tools_preferences.vala"
	_g_object_unref0 (model);
#line 318 "build_tools_preferences.vala"
	_g_free0 (label);
#line 1692 "build_tools_preferences.c"
}

static void
___lambda108__gtk_tool_button_clicked (GtkToolButton* _sender,
                                       gpointer self)
{
#line 318 "build_tools_preferences.vala"
	__lambda108_ ((BuildToolsPreferences*) self);
#line 1701 "build_tools_preferences.c"
}

static GtkToolButton*
build_tools_preferences_get_remove_button (BuildToolsPreferences* self)
{
	GtkToolButton* remove_button = NULL;
	GtkToolButton* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkToolButton* result = NULL;
#line 310 "build_tools_preferences.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 312 "build_tools_preferences.vala"
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
#line 312 "build_tools_preferences.vala"
	g_object_ref_sink (_tmp0_);
#line 312 "build_tools_preferences.vala"
	remove_button = _tmp0_;
#line 313 "build_tools_preferences.vala"
	gtk_tool_button_set_icon_name (remove_button, "list-remove-symbolic");
#line 314 "build_tools_preferences.vala"
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) remove_button, _ ("Remove"));
#line 316 "build_tools_preferences.vala"
	_tmp1_ = self->priv->_personal_view;
#line 316 "build_tools_preferences.vala"
	build_tools_preferences_set_sensitivity_on_selection (self, _tmp1_, (GtkWidget*) remove_button);
#line 318 "build_tools_preferences.vala"
	g_signal_connect_object (remove_button, "clicked", (GCallback) ___lambda108__gtk_tool_button_clicked, self, 0);
#line 347 "build_tools_preferences.vala"
	result = remove_button;
#line 347 "build_tools_preferences.vala"
	return result;
#line 1733 "build_tools_preferences.c"
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
#line 350 "build_tools_preferences.vala"
	g_atomic_int_inc (&_data8_->_ref_count_);
#line 350 "build_tools_preferences.vala"
	return _data8_;
#line 1743 "build_tools_preferences.c"
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
#line 350 "build_tools_preferences.vala"
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
#line 1753 "build_tools_preferences.c"
		BuildToolsPreferences* self;
#line 350 "build_tools_preferences.vala"
		self = _data8_->self;
#line 350 "build_tools_preferences.vala"
		_g_object_unref0 (_data8_->up_button);
#line 350 "build_tools_preferences.vala"
		_g_object_unref0 (self);
#line 350 "build_tools_preferences.vala"
		g_slice_free (Block8Data, _data8_);
#line 1763 "build_tools_preferences.c"
	}
}

static GtkTreePath*
_vala_GtkTreePath_copy (GtkTreePath* self)
{
#line 371 "build_tools_preferences.vala"
	return g_boxed_copy (gtk_tree_path_get_type (), self);
#line 1772 "build_tools_preferences.c"
}

static gpointer
__vala_GtkTreePath_copy0 (gpointer self)
{
#line 371 "build_tools_preferences.vala"
	return self ? _vala_GtkTreePath_copy (self) : NULL;
#line 1780 "build_tools_preferences.c"
}

static void
__lambda109_ (Block8Data* _data8_)
{
	BuildToolsPreferences* self;
	GList* selected_rows = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	GtkTreePath* path_selected = NULL;
	GList* _tmp2_;
	gconstpointer _tmp3_;
	GtkTreePath* _tmp4_;
	gint row_num = 0;
	GtkTreePath* _tmp5_;
	gint _tmp6_ = 0;
	gint* _tmp7_;
	gint _tmp8_;
#line 361 "build_tools_preferences.vala"
	self = _data8_->self;
#line 363 "build_tools_preferences.vala"
	_tmp0_ = gtk_tree_selection_get_selected_rows (_data8_->select, NULL);
#line 363 "build_tools_preferences.vala"
	selected_rows = _tmp0_;
#line 365 "build_tools_preferences.vala"
	_tmp1_ = selected_rows;
#line 365 "build_tools_preferences.vala"
	if (g_list_length (_tmp1_) == ((guint) 0)) {
#line 367 "build_tools_preferences.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _data8_->up_button, FALSE);
#line 368 "build_tools_preferences.vala"
		(selected_rows == NULL) ? NULL : (selected_rows = (_g_list_free___vala_GtkTreePath_free0_ (selected_rows), NULL));
#line 368 "build_tools_preferences.vala"
		return;
#line 1815 "build_tools_preferences.c"
	}
#line 371 "build_tools_preferences.vala"
	_tmp2_ = selected_rows;
#line 371 "build_tools_preferences.vala"
	_tmp3_ = g_list_nth_data (_tmp2_, (guint) 0);
#line 371 "build_tools_preferences.vala"
	_tmp4_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) _tmp3_);
#line 371 "build_tools_preferences.vala"
	path_selected = _tmp4_;
#line 372 "build_tools_preferences.vala"
	_tmp5_ = path_selected;
#line 372 "build_tools_preferences.vala"
	_tmp7_ = gtk_tree_path_get_indices_with_depth (_tmp5_, &_tmp6_);
#line 372 "build_tools_preferences.vala"
	_tmp8_ = _tmp7_[0];
#line 372 "build_tools_preferences.vala"
	row_num = _tmp8_;
#line 374 "build_tools_preferences.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _data8_->up_button, row_num > 0);
#line 361 "build_tools_preferences.vala"
	__vala_GtkTreePath_free0 (path_selected);
#line 361 "build_tools_preferences.vala"
	(selected_rows == NULL) ? NULL : (selected_rows = (_g_list_free___vala_GtkTreePath_free0_ (selected_rows), NULL));
#line 1839 "build_tools_preferences.c"
}

static void
___lambda109__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                          gpointer self)
{
#line 361 "build_tools_preferences.vala"
	__lambda109_ (self);
#line 1848 "build_tools_preferences.c"
}

static void
__lambda110_ (Block8Data* _data8_)
{
	BuildToolsPreferences* self;
	GtkTreeIter iter_selected = {0};
	gint selected_row = 0;
	GtkTreeView* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_;
#line 379 "build_tools_preferences.vala"
	self = _data8_->self;
#line 383 "build_tools_preferences.vala"
	_tmp0_ = self->priv->_personal_view;
#line 383 "build_tools_preferences.vala"
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
#line 383 "build_tools_preferences.vala"
	iter_selected = _tmp1_;
#line 383 "build_tools_preferences.vala"
	selected_row = _tmp2_;
#line 385 "build_tools_preferences.vala"
	if (selected_row > 0) {
#line 1872 "build_tools_preferences.c"
		GtkTreeIter iter_up = {0};
		GtkTreeIter _tmp3_;
		GtkListStore* _tmp4_;
		gboolean _tmp5_;
#line 387 "build_tools_preferences.vala"
		_tmp3_ = iter_selected;
#line 387 "build_tools_preferences.vala"
		iter_up = _tmp3_;
#line 388 "build_tools_preferences.vala"
		_tmp4_ = self->priv->_personal_store;
#line 388 "build_tools_preferences.vala"
		_tmp5_ = utils_tree_model_iter_prev ((GtkTreeModel*) _tmp4_, &iter_up);
#line 388 "build_tools_preferences.vala"
		if (_tmp5_) {
#line 1887 "build_tools_preferences.c"
			GtkListStore* _tmp6_;
			GtkTreeIter _tmp7_;
			GtkTreeIter _tmp8_;
			LatexilaBuildToolsPersonal* _tmp9_;
#line 390 "build_tools_preferences.vala"
			_tmp6_ = self->priv->_personal_store;
#line 390 "build_tools_preferences.vala"
			_tmp7_ = iter_selected;
#line 390 "build_tools_preferences.vala"
			_tmp8_ = iter_up;
#line 390 "build_tools_preferences.vala"
			gtk_list_store_swap (_tmp6_, &_tmp7_, &_tmp8_);
#line 391 "build_tools_preferences.vala"
			_tmp9_ = latexila_build_tools_personal_get_instance ();
#line 391 "build_tools_preferences.vala"
			latexila_build_tools_personal_move_up (_tmp9_, (guint) selected_row);
#line 394 "build_tools_preferences.vala"
			g_signal_emit_by_name (_data8_->select, "changed");
#line 1906 "build_tools_preferences.c"
		}
	}
}

static void
___lambda110__gtk_tool_button_clicked (GtkToolButton* _sender,
                                       gpointer self)
{
#line 379 "build_tools_preferences.vala"
	__lambda110_ (self);
#line 1917 "build_tools_preferences.c"
}

static GtkToolButton*
build_tools_preferences_get_up_button (BuildToolsPreferences* self)
{
	Block8Data* _data8_;
	GtkToolButton* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkToolButton* _tmp3_;
	GtkToolButton* result = NULL;
#line 350 "build_tools_preferences.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 350 "build_tools_preferences.vala"
	_data8_ = g_slice_new0 (Block8Data);
#line 350 "build_tools_preferences.vala"
	_data8_->_ref_count_ = 1;
#line 350 "build_tools_preferences.vala"
	_data8_->self = g_object_ref (self);
#line 352 "build_tools_preferences.vala"
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
#line 352 "build_tools_preferences.vala"
	g_object_ref_sink (_tmp0_);
#line 352 "build_tools_preferences.vala"
	_data8_->up_button = _tmp0_;
#line 353 "build_tools_preferences.vala"
	gtk_tool_button_set_icon_name (_data8_->up_button, "go-up-symbolic");
#line 354 "build_tools_preferences.vala"
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _data8_->up_button, _ ("Move up"));
#line 358 "build_tools_preferences.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _data8_->up_button, FALSE);
#line 360 "build_tools_preferences.vala"
	_tmp1_ = self->priv->_personal_view;
#line 360 "build_tools_preferences.vala"
	_tmp2_ = gtk_tree_view_get_selection (_tmp1_);
#line 360 "build_tools_preferences.vala"
	_data8_->select = _tmp2_;
#line 361 "build_tools_preferences.vala"
	g_signal_connect_data (_data8_->select, "changed", (GCallback) ___lambda109__gtk_tree_selection_changed, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
#line 379 "build_tools_preferences.vala"
	g_signal_connect_data (_data8_->up_button, "clicked", (GCallback) ___lambda110__gtk_tool_button_clicked, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
#line 399 "build_tools_preferences.vala"
	_tmp3_ = _g_object_ref0 (_data8_->up_button);
#line 399 "build_tools_preferences.vala"
	result = _tmp3_;
#line 399 "build_tools_preferences.vala"
	block8_data_unref (_data8_);
#line 399 "build_tools_preferences.vala"
	_data8_ = NULL;
#line 399 "build_tools_preferences.vala"
	return result;
#line 1969 "build_tools_preferences.c"
}

static Block9Data*
block9_data_ref (Block9Data* _data9_)
{
#line 402 "build_tools_preferences.vala"
	g_atomic_int_inc (&_data9_->_ref_count_);
#line 402 "build_tools_preferences.vala"
	return _data9_;
#line 1979 "build_tools_preferences.c"
}

static void
block9_data_unref (void * _userdata_)
{
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
#line 402 "build_tools_preferences.vala"
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
#line 1989 "build_tools_preferences.c"
		BuildToolsPreferences* self;
#line 402 "build_tools_preferences.vala"
		self = _data9_->self;
#line 402 "build_tools_preferences.vala"
		_g_object_unref0 (_data9_->down_button);
#line 402 "build_tools_preferences.vala"
		_g_object_unref0 (self);
#line 402 "build_tools_preferences.vala"
		g_slice_free (Block9Data, _data9_);
#line 1999 "build_tools_preferences.c"
	}
}

static void
__lambda111_ (Block9Data* _data9_)
{
	BuildToolsPreferences* self;
	GList* selected_rows = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	GtkTreePath* path_selected = NULL;
	GList* _tmp2_;
	gconstpointer _tmp3_;
	GtkTreePath* _tmp4_;
	gint row_num = 0;
	GtkTreePath* _tmp5_;
	gint _tmp6_ = 0;
	gint* _tmp7_;
	gint _tmp8_;
	GtkTreeModel* model = NULL;
	GtkListStore* _tmp9_;
	GtkTreeModel* _tmp10_;
	gint nb_rows = 0;
	GtkTreeModel* _tmp11_;
#line 413 "build_tools_preferences.vala"
	self = _data9_->self;
#line 415 "build_tools_preferences.vala"
	_tmp0_ = gtk_tree_selection_get_selected_rows (_data9_->select, NULL);
#line 415 "build_tools_preferences.vala"
	selected_rows = _tmp0_;
#line 417 "build_tools_preferences.vala"
	_tmp1_ = selected_rows;
#line 417 "build_tools_preferences.vala"
	if (g_list_length (_tmp1_) == ((guint) 0)) {
#line 419 "build_tools_preferences.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _data9_->down_button, FALSE);
#line 420 "build_tools_preferences.vala"
		(selected_rows == NULL) ? NULL : (selected_rows = (_g_list_free___vala_GtkTreePath_free0_ (selected_rows), NULL));
#line 420 "build_tools_preferences.vala"
		return;
#line 2040 "build_tools_preferences.c"
	}
#line 423 "build_tools_preferences.vala"
	_tmp2_ = selected_rows;
#line 423 "build_tools_preferences.vala"
	_tmp3_ = g_list_nth_data (_tmp2_, (guint) 0);
#line 423 "build_tools_preferences.vala"
	_tmp4_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) _tmp3_);
#line 423 "build_tools_preferences.vala"
	path_selected = _tmp4_;
#line 424 "build_tools_preferences.vala"
	_tmp5_ = path_selected;
#line 424 "build_tools_preferences.vala"
	_tmp7_ = gtk_tree_path_get_indices_with_depth (_tmp5_, &_tmp6_);
#line 424 "build_tools_preferences.vala"
	_tmp8_ = _tmp7_[0];
#line 424 "build_tools_preferences.vala"
	row_num = _tmp8_;
#line 426 "build_tools_preferences.vala"
	_tmp9_ = self->priv->_personal_store;
#line 426 "build_tools_preferences.vala"
	_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, gtk_tree_model_get_type ()) ? ((GtkTreeModel*) _tmp9_) : NULL);
#line 426 "build_tools_preferences.vala"
	model = _tmp10_;
#line 427 "build_tools_preferences.vala"
	_tmp11_ = model;
#line 427 "build_tools_preferences.vala"
	nb_rows = gtk_tree_model_iter_n_children (_tmp11_, NULL);
#line 429 "build_tools_preferences.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _data9_->down_button, row_num < (nb_rows - 1));
#line 413 "build_tools_preferences.vala"
	_g_object_unref0 (model);
#line 413 "build_tools_preferences.vala"
	__vala_GtkTreePath_free0 (path_selected);
#line 413 "build_tools_preferences.vala"
	(selected_rows == NULL) ? NULL : (selected_rows = (_g_list_free___vala_GtkTreePath_free0_ (selected_rows), NULL));
#line 2076 "build_tools_preferences.c"
}

static void
___lambda111__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                          gpointer self)
{
#line 413 "build_tools_preferences.vala"
	__lambda111_ (self);
#line 2085 "build_tools_preferences.c"
}

static void
__lambda112_ (Block9Data* _data9_)
{
	BuildToolsPreferences* self;
	GtkTreeIter iter_selected = {0};
	gint selected_row = 0;
	GtkTreeView* _tmp0_;
	GtkTreeIter _tmp1_ = {0};
	gint _tmp2_;
#line 434 "build_tools_preferences.vala"
	self = _data9_->self;
#line 438 "build_tools_preferences.vala"
	_tmp0_ = self->priv->_personal_view;
#line 438 "build_tools_preferences.vala"
	_tmp2_ = utils_get_selected_row (_tmp0_, &_tmp1_);
#line 438 "build_tools_preferences.vala"
	iter_selected = _tmp1_;
#line 438 "build_tools_preferences.vala"
	selected_row = _tmp2_;
#line 440 "build_tools_preferences.vala"
	if (selected_row >= 0) {
#line 2109 "build_tools_preferences.c"
		GtkTreeIter iter_down = {0};
		GtkTreeIter _tmp3_;
		GtkListStore* _tmp4_;
		gboolean _tmp5_;
#line 442 "build_tools_preferences.vala"
		_tmp3_ = iter_selected;
#line 442 "build_tools_preferences.vala"
		iter_down = _tmp3_;
#line 443 "build_tools_preferences.vala"
		_tmp4_ = self->priv->_personal_store;
#line 443 "build_tools_preferences.vala"
		_tmp5_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp4_, &iter_down);
#line 443 "build_tools_preferences.vala"
		if (_tmp5_) {
#line 2124 "build_tools_preferences.c"
			GtkListStore* _tmp6_;
			GtkTreeIter _tmp7_;
			GtkTreeIter _tmp8_;
			LatexilaBuildToolsPersonal* _tmp9_;
#line 445 "build_tools_preferences.vala"
			_tmp6_ = self->priv->_personal_store;
#line 445 "build_tools_preferences.vala"
			_tmp7_ = iter_selected;
#line 445 "build_tools_preferences.vala"
			_tmp8_ = iter_down;
#line 445 "build_tools_preferences.vala"
			gtk_list_store_swap (_tmp6_, &_tmp7_, &_tmp8_);
#line 446 "build_tools_preferences.vala"
			_tmp9_ = latexila_build_tools_personal_get_instance ();
#line 446 "build_tools_preferences.vala"
			latexila_build_tools_personal_move_down (_tmp9_, (guint) selected_row);
#line 449 "build_tools_preferences.vala"
			g_signal_emit_by_name (_data9_->select, "changed");
#line 2143 "build_tools_preferences.c"
		}
	}
}

static void
___lambda112__gtk_tool_button_clicked (GtkToolButton* _sender,
                                       gpointer self)
{
#line 434 "build_tools_preferences.vala"
	__lambda112_ (self);
#line 2154 "build_tools_preferences.c"
}

static GtkToolButton*
build_tools_preferences_get_down_button (BuildToolsPreferences* self)
{
	Block9Data* _data9_;
	GtkToolButton* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeSelection* _tmp2_;
	GtkToolButton* _tmp3_;
	GtkToolButton* result = NULL;
#line 402 "build_tools_preferences.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 402 "build_tools_preferences.vala"
	_data9_ = g_slice_new0 (Block9Data);
#line 402 "build_tools_preferences.vala"
	_data9_->_ref_count_ = 1;
#line 402 "build_tools_preferences.vala"
	_data9_->self = g_object_ref (self);
#line 404 "build_tools_preferences.vala"
	_tmp0_ = (GtkToolButton*) gtk_tool_button_new (NULL, NULL);
#line 404 "build_tools_preferences.vala"
	g_object_ref_sink (_tmp0_);
#line 404 "build_tools_preferences.vala"
	_data9_->down_button = _tmp0_;
#line 405 "build_tools_preferences.vala"
	gtk_tool_button_set_icon_name (_data9_->down_button, "go-down-symbolic");
#line 406 "build_tools_preferences.vala"
	gtk_tool_item_set_tooltip_text ((GtkToolItem*) _data9_->down_button, _ ("Move down"));
#line 410 "build_tools_preferences.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _data9_->down_button, FALSE);
#line 412 "build_tools_preferences.vala"
	_tmp1_ = self->priv->_personal_view;
#line 412 "build_tools_preferences.vala"
	_tmp2_ = gtk_tree_view_get_selection (_tmp1_);
#line 412 "build_tools_preferences.vala"
	_data9_->select = _tmp2_;
#line 413 "build_tools_preferences.vala"
	g_signal_connect_data (_data9_->select, "changed", (GCallback) ___lambda111__gtk_tree_selection_changed, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
#line 434 "build_tools_preferences.vala"
	g_signal_connect_data (_data9_->down_button, "clicked", (GCallback) ___lambda112__gtk_tool_button_clicked, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
#line 454 "build_tools_preferences.vala"
	_tmp3_ = _g_object_ref0 (_data9_->down_button);
#line 454 "build_tools_preferences.vala"
	result = _tmp3_;
#line 454 "build_tools_preferences.vala"
	block9_data_unref (_data9_);
#line 454 "build_tools_preferences.vala"
	_data9_ = NULL;
#line 454 "build_tools_preferences.vala"
	return result;
#line 2206 "build_tools_preferences.c"
}

static void
build_tools_preferences_update_default_store (BuildToolsPreferences* self)
{
	GtkListStore* _tmp0_;
	LatexilaBuildToolsDefault* _tmp1_;
#line 457 "build_tools_preferences.vala"
	g_return_if_fail (self != NULL);
#line 459 "build_tools_preferences.vala"
	_tmp0_ = self->priv->_default_store;
#line 459 "build_tools_preferences.vala"
	_tmp1_ = latexila_build_tools_default_get_instance ();
#line 459 "build_tools_preferences.vala"
	build_tools_preferences_update_store (self, _tmp0_, (LatexilaBuildTools*) _tmp1_);
#line 2222 "build_tools_preferences.c"
}

static void
build_tools_preferences_update_personal_store (BuildToolsPreferences* self)
{
	GtkListStore* _tmp0_;
	LatexilaBuildToolsPersonal* _tmp1_;
#line 462 "build_tools_preferences.vala"
	g_return_if_fail (self != NULL);
#line 464 "build_tools_preferences.vala"
	_tmp0_ = self->priv->_personal_store;
#line 464 "build_tools_preferences.vala"
	_tmp1_ = latexila_build_tools_personal_get_instance ();
#line 464 "build_tools_preferences.vala"
	build_tools_preferences_update_store (self, _tmp0_, (LatexilaBuildTools*) _tmp1_);
#line 2238 "build_tools_preferences.c"
}

static void
build_tools_preferences_update_store (BuildToolsPreferences* self,
                                      GtkListStore* store,
                                      LatexilaBuildTools* build_tools)
{
	GList* _tmp0_;
#line 467 "build_tools_preferences.vala"
	g_return_if_fail (self != NULL);
#line 467 "build_tools_preferences.vala"
	g_return_if_fail (store != NULL);
#line 467 "build_tools_preferences.vala"
	g_return_if_fail (build_tools != NULL);
#line 469 "build_tools_preferences.vala"
	gtk_list_store_clear (store);
#line 471 "build_tools_preferences.vala"
	_tmp0_ = build_tools->build_tools;
#line 2257 "build_tools_preferences.c"
	{
		GList* tool_collection = NULL;
		GList* tool_it = NULL;
#line 471 "build_tools_preferences.vala"
		tool_collection = _tmp0_;
#line 471 "build_tools_preferences.vala"
		for (tool_it = tool_collection; tool_it != NULL; tool_it = tool_it->next) {
#line 2265 "build_tools_preferences.c"
			LatexilaBuildTool* _tmp1_;
			LatexilaBuildTool* tool = NULL;
#line 471 "build_tools_preferences.vala"
			_tmp1_ = _g_object_ref0 ((LatexilaBuildTool*) tool_it->data);
#line 471 "build_tools_preferences.vala"
			tool = _tmp1_;
#line 2272 "build_tools_preferences.c"
			{
				gchar* description = NULL;
				LatexilaBuildTool* _tmp2_;
				const gchar* _tmp3_;
				gchar* _tmp4_;
				GtkTreeIter iter = {0};
				GtkTreeIter _tmp5_ = {0};
				GtkTreeIter _tmp6_;
				LatexilaBuildTool* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				LatexilaBuildTool* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				LatexilaBuildTool* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				const gchar* _tmp18_;
#line 473 "build_tools_preferences.vala"
				_tmp2_ = tool;
#line 473 "build_tools_preferences.vala"
				_tmp3_ = latexila_build_tool_get_description (_tmp2_);
#line 473 "build_tools_preferences.vala"
				_tmp4_ = g_markup_escape_text (_tmp3_, (gssize) -1);
#line 473 "build_tools_preferences.vala"
				description = _tmp4_;
#line 476 "build_tools_preferences.vala"
				gtk_list_store_append (store, &_tmp5_);
#line 476 "build_tools_preferences.vala"
				iter = _tmp5_;
#line 477 "build_tools_preferences.vala"
				_tmp6_ = iter;
#line 477 "build_tools_preferences.vala"
				_tmp7_ = tool;
#line 477 "build_tools_preferences.vala"
				g_object_get (_tmp7_, "enabled", &_tmp8_, NULL);
#line 477 "build_tools_preferences.vala"
				_tmp9_ = _tmp8_;
#line 477 "build_tools_preferences.vala"
				_tmp10_ = tool;
#line 477 "build_tools_preferences.vala"
				g_object_get (_tmp10_, "icon", &_tmp11_, NULL);
#line 477 "build_tools_preferences.vala"
				_tmp12_ = _tmp11_;
#line 477 "build_tools_preferences.vala"
				_tmp13_ = _tmp12_;
#line 477 "build_tools_preferences.vala"
				_tmp14_ = tool;
#line 477 "build_tools_preferences.vala"
				g_object_get (_tmp14_, "label", &_tmp15_, NULL);
#line 477 "build_tools_preferences.vala"
				_tmp16_ = _tmp15_;
#line 477 "build_tools_preferences.vala"
				_tmp17_ = _tmp16_;
#line 477 "build_tools_preferences.vala"
				_tmp18_ = description;
#line 477 "build_tools_preferences.vala"
				gtk_list_store_set (store, &_tmp6_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_ENABLED, _tmp9_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_PIXBUF, _tmp13_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_LABEL, _tmp17_, BUILD_TOOLS_PREFERENCES_BUILD_TOOL_COLUMN_DESCRIPTION, _tmp18_, -1);
#line 477 "build_tools_preferences.vala"
				_g_free0 (_tmp17_);
#line 477 "build_tools_preferences.vala"
				_g_free0 (_tmp13_);
#line 471 "build_tools_preferences.vala"
				_g_free0 (description);
#line 471 "build_tools_preferences.vala"
				_g_object_unref0 (tool);
#line 2341 "build_tools_preferences.c"
			}
		}
	}
}

static void
build_tools_preferences_open_build_tool (BuildToolsPreferences* self,
                                         LatexilaBuildTools* build_tools,
                                         gint build_tool_num)
{
	gboolean editable = FALSE;
	BuildToolDialog* dialog = NULL;
	GtkDialog* _tmp0_;
	BuildToolDialog* _tmp1_;
	gboolean edited = FALSE;
	BuildToolDialog* _tmp2_;
#line 486 "build_tools_preferences.vala"
	g_return_if_fail (self != NULL);
#line 486 "build_tools_preferences.vala"
	g_return_if_fail (build_tools != NULL);
#line 488 "build_tools_preferences.vala"
	editable = G_TYPE_CHECK_INSTANCE_TYPE (build_tools, latexila_build_tools_personal_get_type ());
#line 489 "build_tools_preferences.vala"
	_tmp0_ = self->priv->_dialog;
#line 489 "build_tools_preferences.vala"
	_tmp1_ = build_tool_dialog_new ((GtkWindow*) _tmp0_, editable);
#line 489 "build_tools_preferences.vala"
	dialog = _tmp1_;
#line 491 "build_tools_preferences.vala"
	_tmp2_ = dialog;
#line 491 "build_tools_preferences.vala"
	edited = build_tool_dialog_open_build_tool (_tmp2_, build_tools, build_tool_num);
#line 494 "build_tools_preferences.vala"
	if (edited) {
#line 495 "build_tools_preferences.vala"
		build_tools_preferences_update_personal_store (self);
#line 2378 "build_tools_preferences.c"
	}
#line 486 "build_tools_preferences.vala"
	_g_object_unref0 (dialog);
#line 2382 "build_tools_preferences.c"
}

static Block10Data*
block10_data_ref (Block10Data* _data10_)
{
#line 501 "build_tools_preferences.vala"
	g_atomic_int_inc (&_data10_->_ref_count_);
#line 501 "build_tools_preferences.vala"
	return _data10_;
#line 2392 "build_tools_preferences.c"
}

static void
block10_data_unref (void * _userdata_)
{
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
#line 501 "build_tools_preferences.vala"
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
#line 2402 "build_tools_preferences.c"
		BuildToolsPreferences* self;
#line 501 "build_tools_preferences.vala"
		self = _data10_->self;
#line 501 "build_tools_preferences.vala"
		_g_object_unref0 (_data10_->widget);
#line 501 "build_tools_preferences.vala"
		_g_object_unref0 (self);
#line 501 "build_tools_preferences.vala"
		g_slice_free (Block10Data, _data10_);
#line 2412 "build_tools_preferences.c"
	}
}

static void
__lambda104_ (Block10Data* _data10_)
{
	BuildToolsPreferences* self;
	gboolean row_selected = FALSE;
#line 506 "build_tools_preferences.vala"
	self = _data10_->self;
#line 508 "build_tools_preferences.vala"
	row_selected = gtk_tree_selection_count_selected_rows (_data10_->select) > 0;
#line 509 "build_tools_preferences.vala"
	gtk_widget_set_sensitive (_data10_->widget, row_selected);
#line 2427 "build_tools_preferences.c"
}

static void
___lambda104__gtk_tree_selection_changed (GtkTreeSelection* _sender,
                                          gpointer self)
{
#line 506 "build_tools_preferences.vala"
	__lambda104_ (self);
#line 2436 "build_tools_preferences.c"
}

static void
build_tools_preferences_set_sensitivity_on_selection (BuildToolsPreferences* self,
                                                      GtkTreeView* view,
                                                      GtkWidget* widget)
{
	Block10Data* _data10_;
	GtkWidget* _tmp0_;
	GtkTreeSelection* _tmp1_;
#line 501 "build_tools_preferences.vala"
	g_return_if_fail (self != NULL);
#line 501 "build_tools_preferences.vala"
	g_return_if_fail (view != NULL);
#line 501 "build_tools_preferences.vala"
	g_return_if_fail (widget != NULL);
#line 501 "build_tools_preferences.vala"
	_data10_ = g_slice_new0 (Block10Data);
#line 501 "build_tools_preferences.vala"
	_data10_->_ref_count_ = 1;
#line 501 "build_tools_preferences.vala"
	_data10_->self = g_object_ref (self);
#line 501 "build_tools_preferences.vala"
	_tmp0_ = _g_object_ref0 (widget);
#line 501 "build_tools_preferences.vala"
	_g_object_unref0 (_data10_->widget);
#line 501 "build_tools_preferences.vala"
	_data10_->widget = _tmp0_;
#line 503 "build_tools_preferences.vala"
	gtk_widget_set_sensitive (_data10_->widget, FALSE);
#line 505 "build_tools_preferences.vala"
	_tmp1_ = gtk_tree_view_get_selection (view);
#line 505 "build_tools_preferences.vala"
	_data10_->select = _tmp1_;
#line 506 "build_tools_preferences.vala"
	g_signal_connect_data (_data10_->select, "changed", (GCallback) ___lambda104__gtk_tree_selection_changed, block10_data_ref (_data10_), (GClosureNotify) block10_data_unref, 0);
#line 501 "build_tools_preferences.vala"
	block10_data_unref (_data10_);
#line 501 "build_tools_preferences.vala"
	_data10_ = NULL;
#line 2477 "build_tools_preferences.c"
}

static void
build_tools_preferences_class_init (BuildToolsPreferencesClass * klass,
                                    gpointer klass_data)
{
#line 27 "build_tools_preferences.vala"
	build_tools_preferences_parent_class = g_type_class_peek_parent (klass);
#line 27 "build_tools_preferences.vala"
	g_type_class_adjust_private_offset (klass, &BuildToolsPreferences_private_offset);
#line 27 "build_tools_preferences.vala"
	G_OBJECT_CLASS (klass)->finalize = build_tools_preferences_finalize;
#line 2490 "build_tools_preferences.c"
}

static void
build_tools_preferences_instance_init (BuildToolsPreferences * self,
                                       gpointer klass)
{
#line 27 "build_tools_preferences.vala"
	self->priv = build_tools_preferences_get_instance_private (self);
#line 2499 "build_tools_preferences.c"
}

static void
build_tools_preferences_finalize (GObject * obj)
{
	BuildToolsPreferences * self;
#line 27 "build_tools_preferences.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferences);
#line 38 "build_tools_preferences.vala"
	_g_object_unref0 (self->priv->_dialog);
#line 39 "build_tools_preferences.vala"
	_g_object_unref0 (self->priv->_default_store);
#line 40 "build_tools_preferences.vala"
	_g_object_unref0 (self->priv->_personal_store);
#line 41 "build_tools_preferences.vala"
	_g_object_unref0 (self->priv->_default_view);
#line 42 "build_tools_preferences.vala"
	_g_object_unref0 (self->priv->_personal_view);
#line 44 "build_tools_preferences.vala"
	G_OBJECT_CLASS (build_tools_preferences_parent_class)->finalize (obj);
#line 2520 "build_tools_preferences.c"
}

static GType
build_tools_preferences_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BuildToolsPreferencesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) build_tools_preferences_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BuildToolsPreferences), 0, (GInstanceInitFunc) build_tools_preferences_instance_init, NULL };
	GType build_tools_preferences_type_id;
	build_tools_preferences_type_id = g_type_register_static (G_TYPE_OBJECT, "BuildToolsPreferences", &g_define_type_info, 0);
	BuildToolsPreferences_private_offset = g_type_add_instance_private (build_tools_preferences_type_id, sizeof (BuildToolsPreferencesPrivate));
	return build_tools_preferences_type_id;
}

GType
build_tools_preferences_get_type (void)
{
	static volatile gsize build_tools_preferences_type_id__volatile = 0;
	if (g_once_init_enter (&build_tools_preferences_type_id__volatile)) {
		GType build_tools_preferences_type_id;
		build_tools_preferences_type_id = build_tools_preferences_get_type_once ();
		g_once_init_leave (&build_tools_preferences_type_id__volatile, build_tools_preferences_type_id);
	}
	return build_tools_preferences_type_id__volatile;
}

