/* project_dialogs.c generated by valac 0.40.8, the Vala compiler
 * generated from project_dialogs.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2011, 2015 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib/gi18n-lib.h>
#include <latexila.h>
#include <gio/gio.h>
#include <tepl/tepl.h>
#include <string.h>
#include <stdlib.h>
#include <gee.h>


#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _Block27Data Block27Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_PROJECT (project_get_type ())
typedef struct _Project Project;

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _project_free0(var) ((var == NULL) ? NULL : (var = (project_free (var), NULL)))

#define PROJECT_DIALOGS_TYPE_PROJECT_COLUMN (project_dialogs_project_column_get_type ())
typedef struct _Block28Data Block28Data;

struct _Block27Data {
	int _ref_count_;
	GtkFileChooserButton* directory_chooser;
	GtkFileChooserButton* main_file_chooser;
};

struct _Project {
	GFile* directory;
	GFile* main_file;
};

typedef enum  {
	PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY,
	PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE,
	PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS
} ProjectDialogsProjectColumn;

struct _Block28Data {
	int _ref_count_;
	GtkDialog* dialog;
	GtkListStore* store;
	GtkTreeView* treeview;
};



GType main_window_get_type (void) G_GNUC_CONST;
void project_dialogs_new_project (MainWindow* main_window);
static Block27Data* block27_data_ref (Block27Data* _data27_);
static void block27_data_unref (void * _userdata_);
static void __lambda61_ (Block27Data* _data27_);
static void ___lambda61__gtk_file_chooser_button_file_set (GtkFileChooserButton* _sender,
                                                    gpointer self);
GType document_get_type (void) G_GNUC_CONST;
Document* main_window_get_active_document (MainWindow* self);
GFile* document_get_location (Document* self);
gboolean project_dialogs_main_file_is_in_directory (GtkWindow* window,
                                                    GFile* main_file,
                                                    GFile* directory);
GType project_get_type (void) G_GNUC_CONST;
Project* project_dup (const Project* self);
void project_free (Project* self);
void project_copy (const Project* self,
                   Project* dest);
void project_destroy (Project* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
void value_set_projects (GValue* value,
                         gpointer v_object);
void value_take_projects (GValue* value,
                          gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
Projects* projects_get_default (void);
gboolean projects_add (Projects* self,
                       Project* new_project,
                       GFile* * conflict_file);
gboolean project_dialogs_configure_project (GtkWindow* main_window,
                                            gint project_id);
Project* projects_get (Projects* self,
                       gint id);
gboolean projects_change_main_file (Projects* self,
                                    gint num,
                                    GFile* new_main_file);
GType project_dialogs_project_column_get_type (void) G_GNUC_CONST;
void project_dialogs_manage_projects (MainWindow* main_window);
static Block28Data* block28_data_ref (Block28Data* _data28_);
static void block28_data_unref (void * _userdata_);
void project_dialogs_update_model (GtkListStore* model);
GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
static void __lambda62_ (Block28Data* _data28_);
gint utils_get_selected_row (GtkTreeView* view,
                             GtkTreeIter* iter);
static void ___lambda62__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda63_ (Block28Data* _data28_);
void projects_delete (Projects* self,
                      gint num);
static void ___lambda63__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda64_ (Block28Data* _data28_);
void projects_clear_all (Projects* self);
static void ___lambda64__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
GeeIterator* projects_iterator (Projects* self);


static Block27Data*
block27_data_ref (Block27Data* _data27_)
{
#line 24 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_atomic_int_inc (&_data27_->_ref_count_);
#line 24 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	return _data27_;
#line 178 "project_dialogs.c"
}


static void
block27_data_unref (void * _userdata_)
{
	Block27Data* _data27_;
	_data27_ = (Block27Data*) _userdata_;
#line 24 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	if (g_atomic_int_dec_and_test (&_data27_->_ref_count_)) {
#line 24 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_object_unref0 (_data27_->main_file_chooser);
#line 24 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_object_unref0 (_data27_->directory_chooser);
#line 24 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		g_slice_free (Block27Data, _data27_);
#line 195 "project_dialogs.c"
	}
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 37 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	return self ? g_object_ref (self) : NULL;
#line 205 "project_dialogs.c"
}


static void
__lambda61_ (Block27Data* _data27_)
{
	GFile* dir = NULL;
	GtkFileChooserButton* _tmp0_;
	GFile* _tmp1_;
	GError * _inner_error_ = NULL;
#line 56 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp0_ = _data27_->directory_chooser;
#line 56 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp1_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp0_);
#line 56 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	dir = _tmp1_;
#line 222 "project_dialogs.c"
	{
		GtkFileChooserButton* _tmp2_;
#line 59 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp2_ = _data27_->main_file_chooser;
#line 59 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		gtk_file_chooser_set_current_folder_file ((GtkFileChooser*) _tmp2_, dir, &_inner_error_);
#line 59 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 231 "project_dialogs.c"
			goto __catch35_g_error;
		}
	}
	goto __finally35;
	__catch35_g_error:
	{
		GError* e = NULL;
#line 57 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		e = _inner_error_;
#line 57 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_inner_error_ = NULL;
#line 57 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_error_free0 (e);
#line 245 "project_dialogs.c"
	}
	__finally35:
#line 57 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 57 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_object_unref0 (dir);
#line 57 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 57 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		g_clear_error (&_inner_error_);
#line 57 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		return;
#line 258 "project_dialogs.c"
	}
#line 54 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (dir);
#line 262 "project_dialogs.c"
}


static void
___lambda61__gtk_file_chooser_button_file_set (GtkFileChooserButton* _sender,
                                               gpointer self)
{
#line 54 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	__lambda61_ (self);
#line 272 "project_dialogs.c"
}


void
project_dialogs_new_project (MainWindow* main_window)
{
	Block27Data* _data27_;
	GtkDialog* dialog = NULL;
	GObject* _tmp0_;
	GObject* _tmp1_;
	GtkDialog* _tmp2_;
	GtkDialog* _tmp3_;
	GtkDialog* _tmp4_;
	GtkDialog* _tmp5_;
	GtkDialog* _tmp6_;
	GtkDialog* _tmp7_;
	GtkDialog* _tmp8_;
	GtkDialog* _tmp9_;
	GtkBox* content_area = NULL;
	GtkDialog* _tmp10_;
	GtkBox* _tmp11_;
	GtkBox* _tmp12_;
	GtkFileChooserButton* _tmp13_;
	GtkWidget* component = NULL;
	GtkFileChooserButton* _tmp14_;
	GtkWidget* _tmp15_;
	GtkWidget* _tmp16_;
	GtkBox* _tmp17_;
	GtkWidget* _tmp18_;
	GtkFileChooserButton* _tmp19_;
	GtkFileChooserButton* _tmp20_;
	GtkWidget* _tmp21_;
	GtkWidget* _tmp22_;
	GtkBox* _tmp23_;
	GtkWidget* _tmp24_;
	GtkBox* _tmp25_;
	GtkFileChooserButton* _tmp26_;
	Document* doc = NULL;
	Document* _tmp27_;
	Document* _tmp28_;
	Document* _tmp29_;
	gboolean _tmp30_ = FALSE;
	Document* _tmp31_;
	GtkDialog* _tmp78_;
	GError * _inner_error_ = NULL;
#line 24 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_return_if_fail (main_window != NULL);
#line 24 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_data27_ = g_slice_new0 (Block27Data);
#line 24 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_data27_->_ref_count_ = 1;
#line 26 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp0_ = g_object_new (gtk_dialog_get_type (), "use-header-bar", TRUE, NULL, NULL);
#line 26 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp1_ = G_IS_INITIALLY_UNOWNED (_tmp0_) ? g_object_ref_sink (_tmp0_) : _tmp0_;
#line 26 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp1_) : NULL;
#line 26 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	if (_tmp2_ == NULL) {
#line 26 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_object_unref0 (_tmp1_);
#line 334 "project_dialogs.c"
	}
#line 26 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	dialog = _tmp2_;
#line 28 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp3_ = dialog;
#line 28 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_window_set_title ((GtkWindow*) _tmp3_, _ ("New Project"));
#line 29 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp4_ = dialog;
#line 29 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_window_set_destroy_with_parent ((GtkWindow*) _tmp4_, TRUE);
#line 30 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp5_ = dialog;
#line 30 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_window_set_transient_for ((GtkWindow*) _tmp5_, (GtkWindow*) main_window);
#line 31 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp6_ = dialog;
#line 31 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_dialog_add_button (_tmp6_, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
#line 32 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp7_ = dialog;
#line 32 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_dialog_add_button (_tmp7_, _ ("Crea_te"), (gint) GTK_RESPONSE_OK);
#line 33 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp8_ = dialog;
#line 33 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_dialog_set_default_response (_tmp8_, (gint) GTK_RESPONSE_OK);
#line 34 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp9_ = dialog;
#line 34 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp9_, 450, -1);
#line 37 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp10_ = dialog;
#line 37 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp11_ = gtk_dialog_get_content_area (_tmp10_);
#line 37 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp12_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, gtk_box_get_type ()) ? ((GtkBox*) _tmp11_) : NULL);
#line 37 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	content_area = _tmp12_;
#line 40 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp13_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_ ("Directory"), GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER);
#line 40 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_object_ref_sink (_tmp13_);
#line 40 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_data27_->directory_chooser = _tmp13_;
#line 42 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp14_ = _data27_->directory_chooser;
#line 42 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp15_ = latexila_utils_get_dialog_component (_ ("Directory"), (GtkWidget*) _tmp14_);
#line 42 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp16_ = _g_object_ref0 (_tmp15_);
#line 42 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	component = _tmp16_;
#line 43 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp17_ = content_area;
#line 43 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp18_ = component;
#line 43 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_box_pack_start (_tmp17_, _tmp18_, FALSE, TRUE, (guint) 0);
#line 46 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp19_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_ ("Main File"), GTK_FILE_CHOOSER_ACTION_OPEN);
#line 46 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_object_ref_sink (_tmp19_);
#line 46 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_data27_->main_file_chooser = _tmp19_;
#line 48 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp20_ = _data27_->main_file_chooser;
#line 48 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp21_ = latexila_utils_get_dialog_component (_ ("Main File"), (GtkWidget*) _tmp20_);
#line 48 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp22_ = _g_object_ref0 (_tmp21_);
#line 48 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (component);
#line 48 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	component = _tmp22_;
#line 49 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp23_ = content_area;
#line 49 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp24_ = component;
#line 49 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_box_pack_start (_tmp23_, _tmp24_, FALSE, TRUE, (guint) 0);
#line 51 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp25_ = content_area;
#line 51 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp25_);
#line 54 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp26_ = _data27_->directory_chooser;
#line 54 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_signal_connect_data (_tmp26_, "file-set", (GCallback) ___lambda61__gtk_file_chooser_button_file_set, block27_data_ref (_data27_), (GClosureNotify) block27_data_unref, 0);
#line 65 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp27_ = main_window_get_active_document (main_window);
#line 65 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp28_ = _tmp27_;
#line 65 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp29_ = _g_object_ref0 (_tmp28_);
#line 65 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	doc = _tmp29_;
#line 66 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp31_ = doc;
#line 66 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	if (_tmp31_ != NULL) {
#line 436 "project_dialogs.c"
		Document* _tmp32_;
		GFile* _tmp33_;
		GFile* _tmp34_;
#line 66 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp32_ = doc;
#line 66 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp33_ = document_get_location (_tmp32_);
#line 66 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp34_ = _tmp33_;
#line 66 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp30_ = _tmp34_ != NULL;
#line 448 "project_dialogs.c"
	} else {
#line 66 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp30_ = FALSE;
#line 452 "project_dialogs.c"
	}
#line 66 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	if (_tmp30_) {
#line 456 "project_dialogs.c"
		{
			GtkFileChooserButton* _tmp35_;
			Document* _tmp36_;
			GFile* _tmp37_;
			GFile* _tmp38_;
			GFile* _tmp39_;
			GFile* _tmp40_;
			GtkFileChooserButton* _tmp41_;
			Document* _tmp42_;
			GFile* _tmp43_;
			GFile* _tmp44_;
#line 70 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp35_ = _data27_->directory_chooser;
#line 70 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp36_ = doc;
#line 70 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp37_ = document_get_location (_tmp36_);
#line 70 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp38_ = _tmp37_;
#line 70 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp39_ = g_file_get_parent (_tmp38_);
#line 70 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp40_ = _tmp39_;
#line 70 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			gtk_file_chooser_set_file ((GtkFileChooser*) _tmp35_, _tmp40_, &_inner_error_);
#line 70 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_g_object_unref0 (_tmp40_);
#line 70 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 486 "project_dialogs.c"
				goto __catch36_g_error;
			}
#line 71 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp41_ = _data27_->main_file_chooser;
#line 71 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp42_ = doc;
#line 71 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp43_ = document_get_location (_tmp42_);
#line 71 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp44_ = _tmp43_;
#line 71 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			gtk_file_chooser_set_file ((GtkFileChooser*) _tmp41_, _tmp44_, &_inner_error_);
#line 71 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 501 "project_dialogs.c"
				goto __catch36_g_error;
			}
		}
		goto __finally36;
		__catch36_g_error:
		{
			GError* e = NULL;
#line 68 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			e = _inner_error_;
#line 68 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_inner_error_ = NULL;
#line 68 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_g_error_free0 (e);
#line 515 "project_dialogs.c"
		}
		__finally36:
#line 68 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 68 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_g_object_unref0 (doc);
#line 68 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_g_object_unref0 (component);
#line 68 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_g_object_unref0 (content_area);
#line 68 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_g_object_unref0 (dialog);
#line 68 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			block27_data_unref (_data27_);
#line 68 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_data27_ = NULL;
#line 68 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 68 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			g_clear_error (&_inner_error_);
#line 68 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			return;
#line 538 "project_dialogs.c"
		}
	}
#line 76 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	while (TRUE) {
#line 543 "project_dialogs.c"
		GtkDialog* _tmp45_;
		GFile* directory = NULL;
		GtkFileChooserButton* _tmp46_;
		GFile* _tmp47_;
		GFile* main_file = NULL;
		GtkFileChooserButton* _tmp48_;
		GFile* _tmp49_;
		gboolean _tmp50_ = FALSE;
		GFile* _tmp51_;
		GtkDialog* _tmp53_;
		GFile* _tmp54_;
		GFile* _tmp55_;
		Project project = {0};
		GFile* _tmp56_;
		GFile* _tmp57_;
		GFile* _tmp58_;
		GFile* _tmp59_;
		GFile* conflict = NULL;
		Projects* _tmp60_;
		Projects* _tmp61_;
		Project _tmp62_;
		GFile* _tmp63_ = NULL;
		gboolean _tmp64_;
		gboolean _tmp65_;
		GtkDialog* error_dialog = NULL;
		GtkDialog* _tmp66_;
		GFile* _tmp67_;
		gchar* _tmp68_;
		gchar* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		gchar* _tmp72_;
		gchar* _tmp73_;
		GtkMessageDialog* _tmp74_;
		GtkDialog* _tmp75_;
		GtkDialog* _tmp76_;
		GtkDialog* _tmp77_;
#line 76 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp45_ = dialog;
#line 76 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		if (!(gtk_dialog_run (_tmp45_) == ((gint) GTK_RESPONSE_OK))) {
#line 76 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			break;
#line 587 "project_dialogs.c"
		}
#line 78 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp46_ = _data27_->directory_chooser;
#line 78 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp47_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp46_);
#line 78 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		directory = _tmp47_;
#line 79 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp48_ = _data27_->main_file_chooser;
#line 79 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp49_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp48_);
#line 79 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		main_file = _tmp49_;
#line 81 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp51_ = directory;
#line 81 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		if (_tmp51_ == NULL) {
#line 81 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp50_ = TRUE;
#line 607 "project_dialogs.c"
		} else {
			GFile* _tmp52_;
#line 81 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp52_ = main_file;
#line 81 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp50_ = _tmp52_ == NULL;
#line 614 "project_dialogs.c"
		}
#line 81 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		if (_tmp50_) {
#line 82 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_g_object_unref0 (main_file);
#line 82 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_g_object_unref0 (directory);
#line 82 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			continue;
#line 624 "project_dialogs.c"
		}
#line 85 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp53_ = dialog;
#line 85 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp54_ = main_file;
#line 85 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp55_ = directory;
#line 85 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		if (!project_dialogs_main_file_is_in_directory ((GtkWindow*) _tmp53_, _tmp54_, _tmp55_)) {
#line 86 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_g_object_unref0 (main_file);
#line 86 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_g_object_unref0 (directory);
#line 86 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			continue;
#line 640 "project_dialogs.c"
		}
#line 89 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		memset (&project, 0, sizeof (Project));
#line 90 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp56_ = directory;
#line 90 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp57_ = _g_object_ref0 (_tmp56_);
#line 90 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_object_unref0 (project.directory);
#line 90 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		project.directory = _tmp57_;
#line 91 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp58_ = main_file;
#line 91 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp59_ = _g_object_ref0 (_tmp58_);
#line 91 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_object_unref0 (project.main_file);
#line 91 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		project.main_file = _tmp59_;
#line 94 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp60_ = projects_get_default ();
#line 94 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp61_ = _tmp60_;
#line 94 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp62_ = project;
#line 94 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp64_ = projects_add (_tmp61_, &_tmp62_, &_tmp63_);
#line 94 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_object_unref0 (conflict);
#line 94 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		conflict = _tmp63_;
#line 94 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp65_ = _tmp64_;
#line 94 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_projects_unref0 (_tmp61_);
#line 94 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		if (_tmp65_) {
#line 95 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_g_object_unref0 (conflict);
#line 95 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			project_destroy (&project);
#line 95 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_g_object_unref0 (main_file);
#line 95 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_g_object_unref0 (directory);
#line 95 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			break;
#line 688 "project_dialogs.c"
		}
#line 98 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp66_ = dialog;
#line 98 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp67_ = conflict;
#line 98 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp68_ = g_file_get_parse_name (_tmp67_);
#line 98 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp69_ = _tmp68_;
#line 98 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp70_ = latexila_utils_replace_home_dir_with_tilde (_tmp69_);
#line 98 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp71_ = _tmp70_;
#line 98 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp72_ = g_strconcat (_tmp71_, "/", NULL);
#line 98 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp73_ = _tmp72_;
#line 98 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp74_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp66_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _ ("There is a conflict with the project “%s”."), _tmp73_);
#line 98 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		g_object_ref_sink (_tmp74_);
#line 98 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp75_ = (GtkDialog*) _tmp74_;
#line 98 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_free0 (_tmp73_);
#line 98 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_free0 (_tmp71_);
#line 98 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_free0 (_tmp69_);
#line 98 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		error_dialog = _tmp75_;
#line 104 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp76_ = error_dialog;
#line 104 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		gtk_dialog_run (_tmp76_);
#line 105 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp77_ = error_dialog;
#line 105 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		gtk_widget_destroy ((GtkWidget*) _tmp77_);
#line 76 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_object_unref0 (error_dialog);
#line 76 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_object_unref0 (conflict);
#line 76 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		project_destroy (&project);
#line 76 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_object_unref0 (main_file);
#line 76 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_object_unref0 (directory);
#line 738 "project_dialogs.c"
	}
#line 108 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp78_ = dialog;
#line 108 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp78_);
#line 26 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (doc);
#line 26 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (component);
#line 26 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (content_area);
#line 26 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (dialog);
#line 26 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	block27_data_unref (_data27_);
#line 26 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_data27_ = NULL;
#line 756 "project_dialogs.c"
}


gboolean
project_dialogs_configure_project (GtkWindow* main_window,
                                   gint project_id)
{
	gboolean result = FALSE;
	Project* project = NULL;
	Projects* _tmp0_;
	Projects* _tmp1_;
	Project* _tmp2_;
	Project* _tmp3_;
	Project* _tmp4_;
	GtkDialog* dialog = NULL;
	GObject* _tmp5_;
	GObject* _tmp6_;
	GtkDialog* _tmp7_;
	GtkDialog* _tmp8_;
	GtkDialog* _tmp9_;
	GtkDialog* _tmp10_;
	GtkDialog* _tmp11_;
	GtkDialog* _tmp12_;
	GtkDialog* _tmp13_;
	GtkDialog* _tmp14_;
	GtkBox* content_area = NULL;
	GtkDialog* _tmp15_;
	GtkBox* _tmp16_;
	GtkBox* _tmp17_;
	gchar* project_dir = NULL;
	Project* _tmp18_;
	GFile* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	GtkLabel* location = NULL;
	const gchar* _tmp25_;
	GtkLabel* _tmp26_;
	GtkLabel* _tmp27_;
	GtkLabel* _tmp28_;
	GtkWidget* component = NULL;
	GtkLabel* _tmp29_;
	GtkWidget* _tmp30_;
	GtkWidget* _tmp31_;
	GtkBox* _tmp32_;
	GtkWidget* _tmp33_;
	GtkFileChooserButton* main_file_chooser = NULL;
	GtkFileChooserButton* _tmp34_;
	GtkFileChooserButton* _tmp35_;
	GtkWidget* _tmp36_;
	GtkWidget* _tmp37_;
	GtkBox* _tmp38_;
	GtkWidget* _tmp39_;
	GtkBox* _tmp40_;
	gboolean ret = FALSE;
	GtkDialog* _tmp56_;
	GError * _inner_error_ = NULL;
#line 112 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_return_val_if_fail (main_window != NULL, FALSE);
#line 114 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp0_ = projects_get_default ();
#line 114 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp1_ = _tmp0_;
#line 114 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp2_ = projects_get (_tmp1_, project_id);
#line 114 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp3_ = _tmp2_;
#line 114 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_projects_unref0 (_tmp1_);
#line 114 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	project = _tmp3_;
#line 115 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp4_ = project;
#line 115 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_return_val_if_fail (_tmp4_ != NULL, FALSE);
#line 117 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp5_ = g_object_new (gtk_dialog_get_type (), "use-header-bar", TRUE, NULL, NULL);
#line 117 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp6_ = G_IS_INITIALLY_UNOWNED (_tmp5_) ? g_object_ref_sink (_tmp5_) : _tmp5_;
#line 117 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp7_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp6_) : NULL;
#line 117 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	if (_tmp7_ == NULL) {
#line 117 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_object_unref0 (_tmp6_);
#line 844 "project_dialogs.c"
	}
#line 117 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	dialog = _tmp7_;
#line 119 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp8_ = dialog;
#line 119 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_window_set_title ((GtkWindow*) _tmp8_, _ ("Configure Project"));
#line 120 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp9_ = dialog;
#line 120 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_window_set_destroy_with_parent ((GtkWindow*) _tmp9_, TRUE);
#line 121 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp10_ = dialog;
#line 121 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_window_set_transient_for ((GtkWindow*) _tmp10_, main_window);
#line 122 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp11_ = dialog;
#line 122 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_dialog_add_button (_tmp11_, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
#line 123 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp12_ = dialog;
#line 123 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_dialog_add_button (_tmp12_, _ ("_Apply"), (gint) GTK_RESPONSE_APPLY);
#line 124 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp13_ = dialog;
#line 124 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_dialog_set_default_response (_tmp13_, (gint) GTK_RESPONSE_APPLY);
#line 125 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp14_ = dialog;
#line 125 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp14_, 450, -1);
#line 128 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp15_ = dialog;
#line 128 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp16_ = gtk_dialog_get_content_area (_tmp15_);
#line 128 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, gtk_box_get_type ()) ? ((GtkBox*) _tmp16_) : NULL);
#line 128 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	content_area = _tmp17_;
#line 131 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp18_ = project;
#line 131 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp19_ = (*_tmp18_).directory;
#line 131 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp20_ = g_file_get_parse_name (_tmp19_);
#line 131 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	project_dir = _tmp20_;
#line 132 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp21_ = project_dir;
#line 132 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp22_ = latexila_utils_replace_home_dir_with_tilde (_tmp21_);
#line 132 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp23_ = _tmp22_;
#line 132 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp24_ = g_strconcat (_tmp23_, "/", NULL);
#line 132 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_free0 (project_dir);
#line 132 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	project_dir = _tmp24_;
#line 132 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_free0 (_tmp23_);
#line 133 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp25_ = project_dir;
#line 133 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp26_ = (GtkLabel*) gtk_label_new (_tmp25_);
#line 133 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_object_ref_sink (_tmp26_);
#line 133 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	location = _tmp26_;
#line 134 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp27_ = location;
#line 134 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_label_set_line_wrap (_tmp27_, TRUE);
#line 135 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp28_ = location;
#line 135 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_widget_set_halign ((GtkWidget*) _tmp28_, GTK_ALIGN_START);
#line 137 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp29_ = location;
#line 137 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp30_ = latexila_utils_get_dialog_component (_ ("Location of the project"), (GtkWidget*) _tmp29_);
#line 137 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp31_ = _g_object_ref0 (_tmp30_);
#line 137 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	component = _tmp31_;
#line 139 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp32_ = content_area;
#line 139 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp33_ = component;
#line 139 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_box_pack_start (_tmp32_, _tmp33_, FALSE, TRUE, (guint) 0);
#line 142 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp34_ = (GtkFileChooserButton*) gtk_file_chooser_button_new (_ ("Main File"), GTK_FILE_CHOOSER_ACTION_OPEN);
#line 142 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_object_ref_sink (_tmp34_);
#line 142 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	main_file_chooser = _tmp34_;
#line 144 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp35_ = main_file_chooser;
#line 144 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp36_ = latexila_utils_get_dialog_component (_ ("Main File"), (GtkWidget*) _tmp35_);
#line 144 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp37_ = _g_object_ref0 (_tmp36_);
#line 144 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (component);
#line 144 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	component = _tmp37_;
#line 145 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp38_ = content_area;
#line 145 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp39_ = component;
#line 145 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_box_pack_start (_tmp38_, _tmp39_, FALSE, TRUE, (guint) 0);
#line 147 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp40_ = content_area;
#line 147 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_widget_show_all ((GtkWidget*) _tmp40_);
#line 962 "project_dialogs.c"
	{
		GtkFileChooserButton* _tmp41_;
		Project* _tmp42_;
		GFile* _tmp43_;
#line 151 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp41_ = main_file_chooser;
#line 151 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp42_ = project;
#line 151 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp43_ = (*_tmp42_).main_file;
#line 151 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		gtk_file_chooser_set_file ((GtkFileChooser*) _tmp41_, _tmp43_, &_inner_error_);
#line 151 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 977 "project_dialogs.c"
			goto __catch37_g_error;
		}
	}
	goto __finally37;
	__catch37_g_error:
	{
		GError* e = NULL;
#line 149 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		e = _inner_error_;
#line 149 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_inner_error_ = NULL;
#line 149 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_error_free0 (e);
#line 991 "project_dialogs.c"
	}
	__finally37:
#line 149 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 996 "project_dialogs.c"
		gboolean _tmp44_ = FALSE;
#line 149 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_object_unref0 (main_file_chooser);
#line 149 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_object_unref0 (component);
#line 149 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_object_unref0 (location);
#line 149 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_free0 (project_dir);
#line 149 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_object_unref0 (content_area);
#line 149 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_object_unref0 (dialog);
#line 149 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_project_free0 (project);
#line 149 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 149 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		g_clear_error (&_inner_error_);
#line 149 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		return _tmp44_;
#line 1018 "project_dialogs.c"
	}
#line 156 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	ret = FALSE;
#line 157 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	while (TRUE) {
#line 1024 "project_dialogs.c"
		GtkDialog* _tmp45_;
		GFile* main_file = NULL;
		GtkFileChooserButton* _tmp46_;
		GFile* _tmp47_;
		GFile* _tmp48_;
		GtkDialog* _tmp49_;
		GFile* _tmp50_;
		Project* _tmp51_;
		GFile* _tmp52_;
		Projects* _tmp53_;
		Projects* _tmp54_;
		GFile* _tmp55_;
#line 157 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp45_ = dialog;
#line 157 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		if (!(gtk_dialog_run (_tmp45_) == ((gint) GTK_RESPONSE_APPLY))) {
#line 157 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			break;
#line 1043 "project_dialogs.c"
		}
#line 159 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp46_ = main_file_chooser;
#line 159 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp47_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp46_);
#line 159 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		main_file = _tmp47_;
#line 161 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp48_ = main_file;
#line 161 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		if (_tmp48_ == NULL) {
#line 162 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_g_object_unref0 (main_file);
#line 162 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			continue;
#line 1059 "project_dialogs.c"
		}
#line 165 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp49_ = dialog;
#line 165 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp50_ = main_file;
#line 165 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp51_ = project;
#line 165 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp52_ = (*_tmp51_).directory;
#line 165 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		if (!project_dialogs_main_file_is_in_directory ((GtkWindow*) _tmp49_, _tmp50_, _tmp52_)) {
#line 166 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_g_object_unref0 (main_file);
#line 166 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			continue;
#line 1075 "project_dialogs.c"
		}
#line 168 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp53_ = projects_get_default ();
#line 168 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp54_ = _tmp53_;
#line 168 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp55_ = main_file;
#line 168 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		ret = projects_change_main_file (_tmp54_, project_id, _tmp55_);
#line 168 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_projects_unref0 (_tmp54_);
#line 169 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_object_unref0 (main_file);
#line 169 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		break;
#line 1091 "project_dialogs.c"
	}
#line 172 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp56_ = dialog;
#line 172 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp56_);
#line 173 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	result = ret;
#line 173 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (main_file_chooser);
#line 173 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (component);
#line 173 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (location);
#line 173 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_free0 (project_dir);
#line 173 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (content_area);
#line 173 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (dialog);
#line 173 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_project_free0 (project);
#line 173 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	return result;
#line 1115 "project_dialogs.c"
}


GType
project_dialogs_project_column_get_type (void)
{
	static volatile gsize project_dialogs_project_column_type_id__volatile = 0;
	if (g_once_init_enter (&project_dialogs_project_column_type_id__volatile)) {
		static const GEnumValue values[] = {{PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, "PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY", "directory"}, {PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE, "PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE", "main-file"}, {PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS, "PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS", "n-columns"}, {0, NULL, NULL}};
		GType project_dialogs_project_column_type_id;
		project_dialogs_project_column_type_id = g_enum_register_static ("ProjectDialogsProjectColumn", values);
		g_once_init_leave (&project_dialogs_project_column_type_id__volatile, project_dialogs_project_column_type_id);
	}
	return project_dialogs_project_column_type_id__volatile;
}


static Block28Data*
block28_data_ref (Block28Data* _data28_)
{
#line 183 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_atomic_int_inc (&_data28_->_ref_count_);
#line 183 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	return _data28_;
#line 1140 "project_dialogs.c"
}


static void
block28_data_unref (void * _userdata_)
{
	Block28Data* _data28_;
	_data28_ = (Block28Data*) _userdata_;
#line 183 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	if (g_atomic_int_dec_and_test (&_data28_->_ref_count_)) {
#line 183 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_object_unref0 (_data28_->treeview);
#line 183 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_object_unref0 (_data28_->store);
#line 183 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_object_unref0 (_data28_->dialog);
#line 183 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		g_slice_free (Block28Data, _data28_);
#line 1159 "project_dialogs.c"
	}
}


static void
__lambda62_ (Block28Data* _data28_)
{
	gint i = 0;
	gint _tmp0_;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
#line 254 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp0_ = utils_get_selected_row (_data28_->treeview, NULL);
#line 254 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	i = _tmp0_;
#line 255 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp2_ = i;
#line 255 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	if (_tmp2_ != -1) {
#line 1179 "project_dialogs.c"
		gint _tmp3_;
#line 255 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp3_ = i;
#line 255 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp1_ = project_dialogs_configure_project ((GtkWindow*) _data28_->dialog, _tmp3_);
#line 1185 "project_dialogs.c"
	} else {
#line 255 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp1_ = FALSE;
#line 1189 "project_dialogs.c"
	}
#line 255 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	if (_tmp1_) {
#line 256 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		project_dialogs_update_model (_data28_->store);
#line 1195 "project_dialogs.c"
	}
}


static void
___lambda62__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 252 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	__lambda62_ (self);
#line 1206 "project_dialogs.c"
}


static void
__lambda63_ (Block28Data* _data28_)
{
	GtkTreeIter iter = {0};
	gint i = 0;
	GtkTreeIter _tmp0_ = {0};
	gint _tmp1_;
	gint _tmp2_;
	gchar* directory = NULL;
	GtkTreeModel* model = NULL;
	GtkTreeModel* _tmp3_;
	GtkTreeModel* _tmp4_;
	GtkTreeIter _tmp5_;
	GtkDialog* delete_dialog = NULL;
	const gchar* _tmp6_;
	GtkMessageDialog* _tmp7_;
	GtkDialog* _tmp8_;
	GtkDialog* _tmp9_;
	GtkDialog* _tmp13_;
#line 262 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp1_ = utils_get_selected_row (_data28_->treeview, &_tmp0_);
#line 262 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	iter = _tmp0_;
#line 262 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	i = _tmp1_;
#line 263 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp2_ = i;
#line 263 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	if (_tmp2_ == -1) {
#line 264 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		return;
#line 1241 "project_dialogs.c"
	}
#line 267 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data28_->store, gtk_tree_model_get_type (), GtkTreeModel));
#line 267 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	model = _tmp3_;
#line 268 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp4_ = model;
#line 268 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp5_ = iter;
#line 268 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_tree_model_get (_tmp4_, &_tmp5_, PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, &directory, -1, -1);
#line 270 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp6_ = directory;
#line 270 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp7_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _data28_->dialog, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, _ ("Do you really want to delete the project “%s”?"), _tmp6_);
#line 270 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_object_ref_sink (_tmp7_);
#line 270 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	delete_dialog = (GtkDialog*) _tmp7_;
#line 276 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp8_ = delete_dialog;
#line 276 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_dialog_add_buttons (_tmp8_, _ ("_Cancel"), GTK_RESPONSE_CANCEL, _ ("_Delete"), GTK_RESPONSE_YES, NULL);
#line 279 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp9_ = delete_dialog;
#line 279 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	if (gtk_dialog_run (_tmp9_) == ((gint) GTK_RESPONSE_YES)) {
#line 1269 "project_dialogs.c"
		Projects* _tmp10_;
		Projects* _tmp11_;
		gint _tmp12_;
#line 281 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		gtk_list_store_remove (_data28_->store, &iter);
#line 282 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp10_ = projects_get_default ();
#line 282 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp11_ = _tmp10_;
#line 282 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp12_ = i;
#line 282 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		projects_delete (_tmp11_, _tmp12_);
#line 282 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_projects_unref0 (_tmp11_);
#line 1285 "project_dialogs.c"
	}
#line 285 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp13_ = delete_dialog;
#line 285 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp13_);
#line 259 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (delete_dialog);
#line 259 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (model);
#line 259 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_free0 (directory);
#line 1297 "project_dialogs.c"
}


static void
___lambda63__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 259 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	__lambda63_ (self);
#line 1307 "project_dialogs.c"
}


static void
__lambda64_ (Block28Data* _data28_)
{
	GtkDialog* clear_dialog = NULL;
	GtkMessageDialog* _tmp0_;
	GtkDialog* _tmp1_;
	GtkDialog* _tmp2_;
	GtkDialog* _tmp3_;
	GtkDialog* _tmp6_;
#line 290 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _data28_->dialog, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_QUESTION, GTK_BUTTONS_NONE, "%s", _ ("Do you really want to clear all projects?"));
#line 290 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_object_ref_sink (_tmp0_);
#line 290 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	clear_dialog = (GtkDialog*) _tmp0_;
#line 296 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp1_ = clear_dialog;
#line 296 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_dialog_add_button (_tmp1_, _ ("_Cancel"), (gint) GTK_RESPONSE_CANCEL);
#line 297 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp2_ = clear_dialog;
#line 297 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_dialog_add_button (_tmp2_, _ ("Clear _All"), (gint) GTK_RESPONSE_YES);
#line 299 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp3_ = clear_dialog;
#line 299 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	if (gtk_dialog_run (_tmp3_) == ((gint) GTK_RESPONSE_YES)) {
#line 1338 "project_dialogs.c"
		Projects* _tmp4_;
		Projects* _tmp5_;
#line 301 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp4_ = projects_get_default ();
#line 301 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp5_ = _tmp4_;
#line 301 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		projects_clear_all (_tmp5_);
#line 301 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_projects_unref0 (_tmp5_);
#line 302 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		gtk_list_store_clear (_data28_->store);
#line 1351 "project_dialogs.c"
	}
#line 305 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp6_ = clear_dialog;
#line 305 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp6_);
#line 288 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (clear_dialog);
#line 1359 "project_dialogs.c"
}


static void
___lambda64__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 288 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	__lambda64_ (self);
#line 1369 "project_dialogs.c"
}


void
project_dialogs_manage_projects (MainWindow* main_window)
{
	Block28Data* _data28_;
	GObject* _tmp0_;
	GObject* _tmp1_;
	GtkDialog* _tmp2_;
	GtkBox* content_area = NULL;
	GtkBox* _tmp3_;
	GtkBox* _tmp4_;
	GtkListStore* _tmp5_;
	GtkTreeView* _tmp6_;
	GtkTreeViewColumn* column = NULL;
	GtkTreeViewColumn* _tmp7_;
	GtkTreeViewColumn* _tmp8_;
	GtkTreeViewColumn* _tmp9_;
	GtkCellRendererPixbuf* pixbuf_renderer = NULL;
	GtkCellRendererPixbuf* _tmp10_;
	GtkCellRendererPixbuf* _tmp11_;
	GtkTreeViewColumn* _tmp12_;
	GtkCellRendererPixbuf* _tmp13_;
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp14_;
	GtkTreeViewColumn* _tmp15_;
	GtkCellRendererText* _tmp16_;
	GtkTreeViewColumn* _tmp17_;
	GtkCellRendererText* _tmp18_;
	GtkTreeViewColumn* _tmp19_;
	GtkTreeViewColumn* _tmp20_;
	GtkTreeViewColumn* _tmp21_;
	GtkCellRendererPixbuf* _tmp22_;
	GtkCellRendererPixbuf* _tmp23_;
	GtkTreeViewColumn* _tmp24_;
	GtkCellRendererPixbuf* _tmp25_;
	GtkCellRendererText* _tmp26_;
	GtkTreeViewColumn* _tmp27_;
	GtkCellRendererText* _tmp28_;
	GtkTreeViewColumn* _tmp29_;
	GtkCellRendererText* _tmp30_;
	GtkTreeSelection* select = NULL;
	GtkTreeSelection* _tmp31_;
	GtkTreeSelection* _tmp32_;
	GtkScrolledWindow* sw = NULL;
	GtkScrolledWindow* _tmp33_;
	GtkGrid* grid = NULL;
	GtkGrid* _tmp34_;
	GtkButton* edit_button = NULL;
	GtkButton* _tmp35_;
	GtkButton* delete_button = NULL;
	GtkButton* _tmp36_;
	GtkButton* clear_all_button = NULL;
	GtkButton* _tmp37_;
#line 183 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_return_if_fail (main_window != NULL);
#line 183 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_data28_ = g_slice_new0 (Block28Data);
#line 183 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_data28_->_ref_count_ = 1;
#line 185 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp0_ = g_object_new (gtk_dialog_get_type (), "use-header-bar", TRUE, NULL, NULL);
#line 185 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp1_ = G_IS_INITIALLY_UNOWNED (_tmp0_) ? g_object_ref_sink (_tmp0_) : _tmp0_;
#line 185 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_dialog_get_type ()) ? ((GtkDialog*) _tmp1_) : NULL;
#line 185 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	if (_tmp2_ == NULL) {
#line 185 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_object_unref0 (_tmp1_);
#line 1441 "project_dialogs.c"
	}
#line 185 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_data28_->dialog = _tmp2_;
#line 187 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_window_set_title ((GtkWindow*) _data28_->dialog, _ ("Manage Projects"));
#line 188 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_window_set_destroy_with_parent ((GtkWindow*) _data28_->dialog, TRUE);
#line 189 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_window_set_transient_for ((GtkWindow*) _data28_->dialog, (GtkWindow*) main_window);
#line 191 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp3_ = gtk_dialog_get_content_area (_data28_->dialog);
#line 191 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, gtk_box_get_type ()) ? ((GtkBox*) _tmp3_) : NULL);
#line 191 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	content_area = _tmp4_;
#line 192 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_widget_set_size_request ((GtkWidget*) content_area, 450, 250);
#line 195 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp5_ = gtk_list_store_new ((gint) PROJECT_DIALOGS_PROJECT_COLUMN_N_COLUMNS, G_TYPE_STRING, G_TYPE_STRING, -1);
#line 195 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_data28_->store = _tmp5_;
#line 197 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	project_dialogs_update_model (_data28_->store);
#line 199 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp6_ = (GtkTreeView*) gtk_tree_view_new_with_model ((GtkTreeModel*) _data28_->store);
#line 199 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_object_ref_sink (_tmp6_);
#line 199 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_data28_->treeview = _tmp6_;
#line 202 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp7_ = gtk_tree_view_column_new ();
#line 202 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_object_ref_sink (_tmp7_);
#line 202 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	column = _tmp7_;
#line 203 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp8_ = column;
#line 203 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_tree_view_append_column (_data28_->treeview, _tmp8_);
#line 204 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp9_ = column;
#line 204 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_tree_view_column_set_title (_tmp9_, _ ("Directory"));
#line 206 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp10_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
#line 206 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_object_ref_sink (_tmp10_);
#line 206 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	pixbuf_renderer = _tmp10_;
#line 207 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp11_ = pixbuf_renderer;
#line 207 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_object_set (_tmp11_, "icon-name", "folder", NULL);
#line 208 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp12_ = column;
#line 208 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp13_ = pixbuf_renderer;
#line 208 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp12_, (GtkCellRenderer*) _tmp13_, FALSE);
#line 210 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp14_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 210 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_object_ref_sink (_tmp14_);
#line 210 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	text_renderer = _tmp14_;
#line 211 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp15_ = column;
#line 211 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp16_ = text_renderer;
#line 211 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp15_, (GtkCellRenderer*) _tmp16_, TRUE);
#line 212 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp17_ = column;
#line 212 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp18_ = text_renderer;
#line 212 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_tree_view_column_set_attributes (_tmp17_, (GtkCellRenderer*) _tmp18_, "text", PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, NULL, NULL);
#line 215 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp19_ = gtk_tree_view_column_new ();
#line 215 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_object_ref_sink (_tmp19_);
#line 215 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (column);
#line 215 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	column = _tmp19_;
#line 216 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp20_ = column;
#line 216 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_tree_view_append_column (_data28_->treeview, _tmp20_);
#line 217 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp21_ = column;
#line 217 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_tree_view_column_set_title (_tmp21_, _ ("Main File"));
#line 219 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp22_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
#line 219 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_object_ref_sink (_tmp22_);
#line 219 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (pixbuf_renderer);
#line 219 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	pixbuf_renderer = _tmp22_;
#line 220 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp23_ = pixbuf_renderer;
#line 220 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_object_set (_tmp23_, "icon-name", "text-x-generic", NULL);
#line 221 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp24_ = column;
#line 221 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp25_ = pixbuf_renderer;
#line 221 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp24_, (GtkCellRenderer*) _tmp25_, FALSE);
#line 223 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp26_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 223 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_object_ref_sink (_tmp26_);
#line 223 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (text_renderer);
#line 223 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	text_renderer = _tmp26_;
#line 224 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp27_ = column;
#line 224 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp28_ = text_renderer;
#line 224 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp27_, (GtkCellRenderer*) _tmp28_, TRUE);
#line 225 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp29_ = column;
#line 225 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp30_ = text_renderer;
#line 225 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_tree_view_column_set_attributes (_tmp29_, (GtkCellRenderer*) _tmp30_, "text", PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE, NULL, NULL);
#line 228 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp31_ = gtk_tree_view_get_selection (_data28_->treeview);
#line 228 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp32_ = _g_object_ref0 (_tmp31_);
#line 228 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	select = _tmp32_;
#line 229 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_tree_selection_set_mode (select, GTK_SELECTION_SINGLE);
#line 232 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp33_ = utils_add_scrollbar ((GtkWidget*) _data28_->treeview);
#line 232 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	sw = _tmp33_;
#line 233 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_box_pack_start (content_area, (GtkWidget*) sw, TRUE, TRUE, (guint) 0);
#line 236 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp34_ = (GtkGrid*) gtk_grid_new ();
#line 236 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_object_ref_sink (_tmp34_);
#line 236 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	grid = _tmp34_;
#line 237 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_orientable_set_orientation ((GtkOrientable*) grid, GTK_ORIENTATION_HORIZONTAL);
#line 238 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_grid_set_column_spacing (grid, (guint) 5);
#line 239 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_box_pack_start (content_area, (GtkWidget*) grid, FALSE, FALSE, (guint) 5);
#line 241 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp35_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Properties"));
#line 241 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_object_ref_sink (_tmp35_);
#line 241 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	edit_button = _tmp35_;
#line 242 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp36_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Delete"));
#line 242 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_object_ref_sink (_tmp36_);
#line 242 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	delete_button = _tmp36_;
#line 243 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp37_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Clear All"));
#line 243 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_object_ref_sink (_tmp37_);
#line 243 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	clear_all_button = _tmp37_;
#line 245 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) edit_button);
#line 246 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) delete_button);
#line 247 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_container_add ((GtkContainer*) grid, (GtkWidget*) clear_all_button);
#line 249 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_widget_show_all ((GtkWidget*) content_area);
#line 252 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_signal_connect_data (edit_button, "clicked", (GCallback) ___lambda62__gtk_button_clicked, block28_data_ref (_data28_), (GClosureNotify) block28_data_unref, 0);
#line 259 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_signal_connect_data (delete_button, "clicked", (GCallback) ___lambda63__gtk_button_clicked, block28_data_ref (_data28_), (GClosureNotify) block28_data_unref, 0);
#line 288 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_signal_connect_data (clear_all_button, "clicked", (GCallback) ___lambda64__gtk_button_clicked, block28_data_ref (_data28_), (GClosureNotify) block28_data_unref, 0);
#line 308 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_dialog_run (_data28_->dialog);
#line 309 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_widget_destroy ((GtkWidget*) _data28_->dialog);
#line 185 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (clear_all_button);
#line 185 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (delete_button);
#line 185 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (edit_button);
#line 185 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (grid);
#line 185 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (sw);
#line 185 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (select);
#line 185 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (text_renderer);
#line 185 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (pixbuf_renderer);
#line 185 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (column);
#line 185 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (content_area);
#line 185 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	block28_data_unref (_data28_);
#line 185 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_data28_ = NULL;
#line 1659 "project_dialogs.c"
}


gboolean
project_dialogs_main_file_is_in_directory (GtkWindow* window,
                                           GFile* main_file,
                                           GFile* directory)
{
	gboolean result = FALSE;
	GtkDialog* error_dialog = NULL;
	GtkMessageDialog* _tmp0_;
	GtkDialog* _tmp1_;
	GtkDialog* _tmp2_;
#line 312 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_return_val_if_fail (window != NULL, FALSE);
#line 312 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_return_val_if_fail (main_file != NULL, FALSE);
#line 312 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_return_val_if_fail (directory != NULL, FALSE);
#line 314 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	if (g_file_has_prefix (main_file, directory)) {
#line 315 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		result = TRUE;
#line 315 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		return result;
#line 1685 "project_dialogs.c"
	}
#line 317 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp0_ = (GtkMessageDialog*) gtk_message_dialog_new (window, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, "%s", _ ("The Main File is not in the directory."));
#line 317 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_object_ref_sink (_tmp0_);
#line 317 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	error_dialog = (GtkDialog*) _tmp0_;
#line 323 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp1_ = error_dialog;
#line 323 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_dialog_run (_tmp1_);
#line 324 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_tmp2_ = error_dialog;
#line 324 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp2_);
#line 325 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	result = FALSE;
#line 325 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	_g_object_unref0 (error_dialog);
#line 325 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	return result;
#line 1707 "project_dialogs.c"
}


static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gchar* _tmp8_;
#line 1369 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1370 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1370 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1370 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1371 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1733 "project_dialogs.c"
		glong _tmp2_;
#line 1372 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp2_ = string_length;
#line 1372 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		start = _tmp2_ + start;
#line 1739 "project_dialogs.c"
	}
#line 1374 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1743 "project_dialogs.c"
		glong _tmp3_;
#line 1375 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp3_ = string_length;
#line 1375 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		end = _tmp3_ + end;
#line 1749 "project_dialogs.c"
	}
#line 1377 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1753 "project_dialogs.c"
		glong _tmp5_;
#line 1377 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp5_ = string_length;
#line 1377 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = start <= _tmp5_;
#line 1759 "project_dialogs.c"
	} else {
#line 1377 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp4_ = FALSE;
#line 1763 "project_dialogs.c"
	}
#line 1377 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp4_, NULL);
#line 1378 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1769 "project_dialogs.c"
		glong _tmp7_;
#line 1378 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp7_ = string_length;
#line 1378 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp6_ = end <= _tmp7_;
#line 1775 "project_dialogs.c"
	} else {
#line 1378 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
		_tmp6_ = FALSE;
#line 1779 "project_dialogs.c"
	}
#line 1378 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (_tmp6_, NULL);
#line 1379 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1380 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	_tmp8_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1380 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	result = _tmp8_;
#line 1380 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 1791 "project_dialogs.c"
}


void
project_dialogs_update_model (GtkListStore* model)
{
#line 328 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	g_return_if_fail (model != NULL);
#line 330 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
	gtk_list_store_clear (model);
#line 1802 "project_dialogs.c"
	{
		GeeIterator* _project_it = NULL;
		Projects* _tmp0_;
		Projects* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
#line 332 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp0_ = projects_get_default ();
#line 332 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp1_ = _tmp0_;
#line 332 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp2_ = projects_iterator (_tmp1_);
#line 332 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_tmp3_ = _tmp2_;
#line 332 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_projects_unref0 (_tmp1_);
#line 332 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_project_it = _tmp3_;
#line 332 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		while (TRUE) {
#line 1823 "project_dialogs.c"
			GeeIterator* _tmp4_;
			Project project = {0};
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			Project* _tmp7_;
			Project _tmp8_ = {0};
			Project _tmp9_;
			gchar* uri_directory = NULL;
			Project _tmp10_;
			GFile* _tmp11_;
			gchar* _tmp12_;
			gchar* uri_main_file = NULL;
			Project _tmp13_;
			GFile* _tmp14_;
			gchar* _tmp15_;
			gchar* dir = NULL;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* main_file = NULL;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			const gchar* _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			gchar* _tmp28_;
			GtkTreeIter iter = {0};
			GtkTreeIter _tmp29_ = {0};
			GtkTreeIter _tmp30_;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
#line 332 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp4_ = _project_it;
#line 332 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			if (!gee_iterator_next (_tmp4_)) {
#line 332 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
				break;
#line 1865 "project_dialogs.c"
			}
#line 332 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp5_ = _project_it;
#line 332 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp6_ = gee_iterator_get (_tmp5_);
#line 332 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp7_ = (Project*) _tmp6_;
#line 332 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			project_copy (_tmp7_, &_tmp8_);
#line 332 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp9_ = _tmp8_;
#line 332 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_project_free0 (_tmp7_);
#line 332 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			project = _tmp9_;
#line 334 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp10_ = project;
#line 334 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp11_ = _tmp10_.directory;
#line 334 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp12_ = g_file_get_parse_name (_tmp11_);
#line 334 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			uri_directory = _tmp12_;
#line 335 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp13_ = project;
#line 335 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp14_ = _tmp13_.main_file;
#line 335 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp15_ = g_file_get_parse_name (_tmp14_);
#line 335 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			uri_main_file = _tmp15_;
#line 337 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp16_ = uri_directory;
#line 337 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp17_ = latexila_utils_replace_home_dir_with_tilde (_tmp16_);
#line 337 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp18_ = _tmp17_;
#line 337 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp19_ = g_strconcat (_tmp18_, "/", NULL);
#line 337 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp20_ = _tmp19_;
#line 337 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_g_free0 (_tmp18_);
#line 337 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			dir = _tmp20_;
#line 340 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp21_ = uri_main_file;
#line 340 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp22_ = uri_directory;
#line 340 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp23_ = strlen (_tmp22_);
#line 340 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp24_ = _tmp23_;
#line 340 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp25_ = uri_main_file;
#line 340 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp26_ = strlen (_tmp25_);
#line 340 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp27_ = _tmp26_;
#line 340 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp28_ = string_slice (_tmp21_, (glong) (_tmp24_ + 1), (glong) _tmp27_);
#line 340 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			main_file = _tmp28_;
#line 344 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			gtk_list_store_append (model, &_tmp29_);
#line 344 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			iter = _tmp29_;
#line 345 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp30_ = iter;
#line 345 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp31_ = dir;
#line 345 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_tmp32_ = main_file;
#line 345 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			gtk_list_store_set (model, &_tmp30_, PROJECT_DIALOGS_PROJECT_COLUMN_DIRECTORY, _tmp31_, PROJECT_DIALOGS_PROJECT_COLUMN_MAIN_FILE, _tmp32_, -1, -1);
#line 332 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_g_free0 (main_file);
#line 332 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_g_free0 (dir);
#line 332 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_g_free0 (uri_main_file);
#line 332 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			_g_free0 (uri_directory);
#line 332 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
			project_destroy (&project);
#line 1951 "project_dialogs.c"
		}
#line 332 "/home/seb/gnome/gnome-latex/src/project_dialogs.vala"
		_g_object_unref0 (_project_it);
#line 1955 "project_dialogs.c"
	}
}



