/* glatex_app.c generated by valac 0.40.8, the Vala compiler
 * generated from glatex_app.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2010-2015, 2017, 2018 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */


#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "config.h"
#include <stdlib.h>
#include <string.h>
#include <tepl/tepl.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <latexila.h>
#include <gdk/gdk.h>
#include <gee.h>


#define TYPE_GLATEX_APP (glatex_app_get_type ())
#define GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GLATEX_APP, GlatexApp))
#define GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GLATEX_APP, GlatexAppClass))
#define IS_GLATEX_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GLATEX_APP))
#define IS_GLATEX_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GLATEX_APP))
#define GLATEX_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GLATEX_APP, GlatexAppClass))

typedef struct _GlatexApp GlatexApp;
typedef struct _GlatexAppClass GlatexAppClass;
typedef struct _GlatexAppPrivate GlatexAppPrivate;
enum  {
	GLATEX_APP_0_PROPERTY,
	GLATEX_APP_NUM_PROPERTIES
};
static GParamSpec* glatex_app_properties[GLATEX_APP_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _Block21Data Block21Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PROJECTS (projects_get_type ())
#define PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PROJECTS, Projects))
#define PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PROJECTS, ProjectsClass))
#define IS_PROJECTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PROJECTS))
#define IS_PROJECTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PROJECTS))
#define PROJECTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PROJECTS, ProjectsClass))

typedef struct _Projects Projects;
typedef struct _ProjectsClass ProjectsClass;
#define _projects_unref0(var) ((var == NULL) ? NULL : (var = (projects_unref (var), NULL)))

#define TYPE_MOST_USED_SYMBOLS (most_used_symbols_get_type ())
#define MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbols))
#define MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))
#define IS_MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOST_USED_SYMBOLS))
#define IS_MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOST_USED_SYMBOLS))
#define MOST_USED_SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))

typedef struct _MostUsedSymbols MostUsedSymbols;
typedef struct _MostUsedSymbolsClass MostUsedSymbolsClass;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;

#define TYPE_BUILD_TOOLS_PREFERENCES (build_tools_preferences_get_type ())
#define BUILD_TOOLS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferences))
#define BUILD_TOOLS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesClass))
#define IS_BUILD_TOOLS_PREFERENCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUILD_TOOLS_PREFERENCES))
#define IS_BUILD_TOOLS_PREFERENCES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUILD_TOOLS_PREFERENCES))
#define BUILD_TOOLS_PREFERENCES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUILD_TOOLS_PREFERENCES, BuildToolsPreferencesClass))

typedef struct _BuildToolsPreferences BuildToolsPreferences;
typedef struct _BuildToolsPreferencesClass BuildToolsPreferencesClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

struct _GlatexApp {
	GtkApplication parent_instance;
	GlatexAppPrivate * priv;
};

struct _GlatexAppClass {
	GtkApplicationClass parent_class;
};

struct _Block21Data {
	int _ref_count_;
	GlatexApp* self;
	gboolean show_version;
	gboolean new_document;
	gboolean new_window;
};


static gpointer glatex_app_parent_class = NULL;
static GtkCssProvider* glatex_app__provider;
static GtkCssProvider* glatex_app__provider = NULL;

GType glatex_app_get_type (void) G_GNUC_CONST;
static void glatex_app_new_document_cb (GlatexApp* self);
static void _glatex_app_new_document_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void glatex_app_preferences_cb (GlatexApp* self);
static void _glatex_app_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void glatex_app_manage_build_tools_cb (GlatexApp* self);
static void _glatex_app_manage_build_tools_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self);
static void glatex_app_help_cb (GlatexApp* self);
static void _glatex_app_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
static void glatex_app_about_cb (GlatexApp* self);
static void _glatex_app_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void glatex_app_quit_cb (GlatexApp* self);
static void _glatex_app_quit_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self);
GlatexApp* glatex_app_new (void);
GlatexApp* glatex_app_construct (GType object_type);
static void glatex_app_setup_main_option_entries (GlatexApp* self);
static void glatex_app_startup_cb (GlatexApp* self);
static void _glatex_app_startup_cb_g_application_startup (GApplication* _sender,
                                                   gpointer self);
void glatex_app_open_documents (GlatexApp* self,
                                GFile** files,
                                int files_length1);
static void _glatex_app_open_documents_g_application_open (GApplication* _sender,
                                                    GFile** files,
                                                    int n_files,
                                                    const gchar* hint,
                                                    gpointer self);
static void glatex_app_shutdown_cb (GlatexApp* self);
static void _glatex_app_shutdown_cb_g_application_shutdown (GApplication* _sender,
                                                     gpointer self);
GlatexApp* glatex_app_get_instance (void);
GType main_window_get_type (void) G_GNUC_CONST;
MainWindow* glatex_app_get_active_main_window (GlatexApp* self);
static Block21Data* block21_data_ref (Block21Data* _data21_);
static void block21_data_unref (void * _userdata_);
static gint __lambda118_ (Block21Data* _data21_);
static gint ___lambda118__g_application_handle_local_options (GApplication* _sender,
                                                       GVariantDict* options,
                                                       gpointer self);
void stock_icons_register_stock_icons (void);
static void glatex_app_setup_theme_extensions (GlatexApp* self);
GType app_settings_get_type (void) G_GNUC_CONST;
AppSettings* app_settings_get_default (void);
static void glatex_app_support_backward_search (GlatexApp* self);
static gchar* glatex_app_get_accel_filename (GlatexApp* self);
gpointer projects_ref (gpointer instance);
void projects_unref (gpointer instance);
GParamSpec* param_spec_projects (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
void value_set_projects (GValue* value,
                         gpointer v_object);
void value_take_projects (GValue* value,
                          gpointer v_object);
gpointer value_get_projects (const GValue* value);
GType projects_get_type (void) G_GNUC_CONST;
Projects* projects_get_default (void);
void projects_save (Projects* self);
GType most_used_symbols_get_type (void) G_GNUC_CONST;
MostUsedSymbols* most_used_symbols_get_default (void);
void most_used_symbols_save (MostUsedSymbols* self);
MainWindow* glatex_app_create_window (GlatexApp* self);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentTab* main_window_create_tab (MainWindow* self,
                                     gboolean jump_to);
void preferences_dialog_show_me (GtkWindow* parent);
BuildToolsPreferences* build_tools_preferences_new (GtkWindow* parent_window);
BuildToolsPreferences* build_tools_preferences_construct (GType object_type,
                                                          GtkWindow* parent_window);
GType build_tools_preferences_get_type (void) G_GNUC_CONST;
gboolean main_window_quit (MainWindow* self);
static void glatex_app_update_theme (GlatexApp* self);
static void _glatex_app_update_theme_g_object_notify (GObject* _sender,
                                               GParamSpec* pspec,
                                               gpointer self);
GType document_get_type (void) G_GNUC_CONST;
GeeList* glatex_app_get_documents (GlatexApp* self);
GeeList* main_window_get_documents (MainWindow* self);
GType document_view_get_type (void) G_GNUC_CONST;
GeeList* glatex_app_get_views (GlatexApp* self);
GeeList* main_window_get_views (MainWindow* self);
DocumentTab* main_window_open_document (MainWindow* self,
                                        GFile* location,
                                        gboolean jump_to);
static void __lambda119_ (GlatexApp* self,
                   const gchar* tex_uri,
                   gint line,
                   guint timestamp);
void main_window_jump_to_file_position (MainWindow* self,
                                        GFile* file,
                                        gint start_line,
                                        gint end_line);
static void ___lambda119__latexila_synctex_backward_search (LatexilaSynctex* _sender,
                                                     const gchar* tex_uri,
                                                     gint line,
                                                     guint timestamp,
                                                     gpointer self);
static void glatex_app_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);

static const GActionEntry GLATEX_APP__app_actions[6] = {{"new-document", _glatex_app_new_document_cb_gsimple_action_activate_callback}, {"preferences", _glatex_app_preferences_cb_gsimple_action_activate_callback}, {"manage-build-tools", _glatex_app_manage_build_tools_cb_gsimple_action_activate_callback}, {"help", _glatex_app_help_cb_gsimple_action_activate_callback}, {"about", _glatex_app_about_cb_gsimple_action_activate_callback}, {"quit", _glatex_app_quit_cb_gsimple_action_activate_callback}};

static void
_glatex_app_new_document_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
#line 26 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	glatex_app_new_document_cb ((GlatexApp*) self);
#line 293 "glatex_app.c"
}


static void
_glatex_app_preferences_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
#line 26 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	glatex_app_preferences_cb ((GlatexApp*) self);
#line 304 "glatex_app.c"
}


static void
_glatex_app_manage_build_tools_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self)
{
#line 26 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	glatex_app_manage_build_tools_cb ((GlatexApp*) self);
#line 315 "glatex_app.c"
}


static void
_glatex_app_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
#line 26 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	glatex_app_help_cb ((GlatexApp*) self);
#line 326 "glatex_app.c"
}


static void
_glatex_app_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
#line 26 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	glatex_app_about_cb ((GlatexApp*) self);
#line 337 "glatex_app.c"
}


static void
_glatex_app_quit_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                      GVariant* parameter,
                                                      gpointer self)
{
#line 26 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	glatex_app_quit_cb ((GlatexApp*) self);
#line 348 "glatex_app.c"
}


static void
_glatex_app_startup_cb_g_application_startup (GApplication* _sender,
                                              gpointer self)
{
#line 45 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	glatex_app_startup_cb ((GlatexApp*) self);
#line 358 "glatex_app.c"
}


static void
_glatex_app_open_documents_g_application_open (GApplication* _sender,
                                               GFile** files,
                                               int n_files,
                                               const gchar* hint,
                                               gpointer self)
{
#line 46 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	glatex_app_open_documents ((GlatexApp*) self, files, n_files);
#line 371 "glatex_app.c"
}


static void
_glatex_app_shutdown_cb_g_application_shutdown (GApplication* _sender,
                                                gpointer self)
{
#line 47 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	glatex_app_shutdown_cb ((GlatexApp*) self);
#line 381 "glatex_app.c"
}


static gpointer
_g_object_ref0 (gpointer self)
{
#line 49 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	return self ? g_object_ref (self) : NULL;
#line 390 "glatex_app.c"
}


GlatexApp*
glatex_app_construct (GType object_type)
{
	GlatexApp * self = NULL;
	TeplApplication* tepl_app = NULL;
	TeplApplication* _tmp0_;
	TeplApplication* _tmp1_;
#line 38 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	self = (GlatexApp*) g_object_new (object_type, "application-id", "org.gnome.gnome-latex", NULL);
#line 39 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_application_set_flags ((GApplication*) self, G_APPLICATION_HANDLES_OPEN);
#line 40 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_set_application_name (PACKAGE_NAME);
#line 41 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	gtk_window_set_default_icon_name ("gnome-latex");
#line 43 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	glatex_app_setup_main_option_entries (self);
#line 45 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_signal_connect_object ((GApplication*) self, "startup", (GCallback) _glatex_app_startup_cb_g_application_startup, self, 0);
#line 46 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_signal_connect_object ((GApplication*) self, "open", (GCallback) _glatex_app_open_documents_g_application_open, self, 0);
#line 47 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_signal_connect_object ((GApplication*) self, "shutdown", (GCallback) _glatex_app_shutdown_cb_g_application_shutdown, self, 0);
#line 49 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp0_ = tepl_application_get_from_gtk_application ((GtkApplication*) self);
#line 49 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 49 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	tepl_app = _tmp1_;
#line 50 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	tepl_application_handle_activate (tepl_app);
#line 36 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_g_object_unref0 (tepl_app);
#line 36 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	return self;
#line 429 "glatex_app.c"
}


GlatexApp*
glatex_app_new (void)
{
#line 36 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	return glatex_app_construct (TYPE_GLATEX_APP);
#line 438 "glatex_app.c"
}


GlatexApp*
glatex_app_get_instance (void)
{
	GlatexApp* result = NULL;
	GApplication* _tmp0_;
	GlatexApp* _tmp1_;
#line 55 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp0_ = g_application_get_default ();
#line 55 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_GLATEX_APP) ? ((GlatexApp*) _tmp0_) : NULL);
#line 55 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	result = _tmp1_;
#line 55 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	return result;
#line 456 "glatex_app.c"
}


MainWindow*
glatex_app_get_active_main_window (GlatexApp* self)
{
	MainWindow* result = NULL;
	TeplApplication* tepl_app = NULL;
	TeplApplication* _tmp0_;
	TeplApplication* _tmp1_;
	GtkApplicationWindow* main_window = NULL;
	TeplApplication* _tmp2_;
	GtkApplicationWindow* _tmp3_;
	GtkApplicationWindow* _tmp4_;
	GtkApplicationWindow* _tmp5_;
	GtkApplicationWindow* _tmp6_;
	MainWindow* _tmp7_;
#line 58 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 60 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp0_ = tepl_application_get_from_gtk_application ((GtkApplication*) self);
#line 60 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 60 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	tepl_app = _tmp1_;
#line 61 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp2_ = tepl_app;
#line 61 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp3_ = tepl_application_get_active_main_window (_tmp2_);
#line 61 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 61 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	main_window = _tmp4_;
#line 63 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp5_ = main_window;
#line 63 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	if (_tmp5_ == NULL) {
#line 64 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		result = NULL;
#line 64 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_g_object_unref0 (main_window);
#line 64 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_g_object_unref0 (tepl_app);
#line 64 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		return result;
#line 502 "glatex_app.c"
	}
#line 66 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp6_ = main_window;
#line 66 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, TYPE_MAIN_WINDOW) ? ((MainWindow*) _tmp6_) : NULL);
#line 66 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	result = _tmp7_;
#line 66 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_g_object_unref0 (main_window);
#line 66 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_g_object_unref0 (tepl_app);
#line 66 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	return result;
#line 516 "glatex_app.c"
}


static Block21Data*
block21_data_ref (Block21Data* _data21_)
{
#line 69 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_atomic_int_inc (&_data21_->_ref_count_);
#line 69 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	return _data21_;
#line 527 "glatex_app.c"
}


static void
block21_data_unref (void * _userdata_)
{
	Block21Data* _data21_;
	_data21_ = (Block21Data*) _userdata_;
#line 69 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	if (g_atomic_int_dec_and_test (&_data21_->_ref_count_)) {
#line 538 "glatex_app.c"
		GlatexApp* self;
#line 69 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		self = _data21_->self;
#line 69 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_g_object_unref0 (self);
#line 69 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		g_slice_free (Block21Data, _data21_);
#line 546 "glatex_app.c"
	}
}


static gint
__lambda118_ (Block21Data* _data21_)
{
	GlatexApp* self;
	gint result = 0;
	GError * _inner_error_ = NULL;
#line 90 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	self = _data21_->self;
#line 92 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	if (_data21_->show_version) {
#line 561 "glatex_app.c"
		FILE* _tmp0_;
#line 94 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_tmp0_ = stdout;
#line 94 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		fprintf (_tmp0_, "%s %s\n", PACKAGE_NAME, PACKAGE_VERSION);
#line 95 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		result = 0;
#line 95 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		return result;
#line 571 "glatex_app.c"
	}
	{
#line 100 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		g_application_register ((GApplication*) self, NULL, &_inner_error_);
#line 100 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 578 "glatex_app.c"
			goto __catch25_g_error;
		}
	}
	goto __finally25;
	__catch25_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp1_;
#line 98 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		e = _inner_error_;
#line 98 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_inner_error_ = NULL;
#line 104 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_tmp1_ = e->message;
#line 104 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		g_error ("glatex_app.vala:104: Failed to register the application: %s", _tmp1_);
#line 98 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_g_error_free0 (e);
#line 597 "glatex_app.c"
	}
	__finally25:
#line 98 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 602 "glatex_app.c"
		gint _tmp2_ = -1;
#line 98 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 98 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		g_clear_error (&_inner_error_);
#line 98 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		return _tmp2_;
#line 610 "glatex_app.c"
	}
#line 107 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	if (_data21_->new_window) {
#line 108 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		g_action_group_activate_action ((GActionGroup*) self, "tepl-new-window", NULL);
#line 616 "glatex_app.c"
	}
#line 110 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	if (_data21_->new_document) {
#line 111 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		g_action_group_activate_action ((GActionGroup*) self, "new-document", NULL);
#line 622 "glatex_app.c"
	}
#line 113 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	result = -1;
#line 113 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	return result;
#line 628 "glatex_app.c"
}


static gint
___lambda118__g_application_handle_local_options (GApplication* _sender,
                                                  GVariantDict* options,
                                                  gpointer self)
{
	gint result;
	result = __lambda118_ (self);
#line 90 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	return result;
#line 641 "glatex_app.c"
}


static void
glatex_app_setup_main_option_entries (GlatexApp* self)
{
	Block21Data* _data21_;
	GOptionEntry* options = NULL;
	GOptionEntry* _tmp0_;
	gint options_length1;
	gint _options_size_;
	GOptionEntry _tmp1_ = {0};
	GOptionEntry _tmp2_;
	GOptionEntry _tmp3_ = {0};
	GOptionEntry _tmp4_;
	GOptionEntry _tmp5_ = {0};
	GOptionEntry _tmp6_;
	GOptionEntry _tmp7_ = {0};
	GOptionEntry _tmp8_;
#line 69 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 69 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_data21_ = g_slice_new0 (Block21Data);
#line 69 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_data21_->_ref_count_ = 1;
#line 69 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_data21_->self = g_object_ref (self);
#line 71 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_data21_->show_version = FALSE;
#line 72 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_data21_->new_document = FALSE;
#line 73 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_data21_->new_window = FALSE;
#line 75 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp0_ = g_new0 (GOptionEntry, 4);
#line 75 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	options = _tmp0_;
#line 75 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	options_length1 = 4;
#line 75 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_options_size_ = options_length1;
#line 77 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp1_.long_name = "version";
#line 77 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp1_.short_name = 'V';
#line 77 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp1_.flags = 0;
#line 77 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp1_.arg = G_OPTION_ARG_NONE;
#line 77 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp1_.arg_data = &_data21_->show_version;
#line 77 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp1_.description = N_ ("Show the application’s version");
#line 77 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp1_.arg_description = NULL;
#line 77 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	options[0] = _tmp1_;
#line 77 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp2_ = options[0];
#line 80 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp3_.long_name = "new-document";
#line 80 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp3_.short_name = 'n';
#line 80 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp3_.flags = 0;
#line 80 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp3_.arg = G_OPTION_ARG_NONE;
#line 80 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp3_.arg_data = &_data21_->new_document;
#line 80 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp3_.description = N_ ("Create new document");
#line 80 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp3_.arg_description = NULL;
#line 80 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	options[1] = _tmp3_;
#line 80 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp4_ = options[1];
#line 83 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp5_.long_name = "new-window";
#line 83 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp5_.short_name = (gchar) 0;
#line 83 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp5_.flags = 0;
#line 83 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp5_.arg = G_OPTION_ARG_NONE;
#line 83 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp5_.arg_data = &_data21_->new_window;
#line 83 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp5_.description = N_ ("Create a new top-level window in an existing instance of GNOME LaTeX");
#line 83 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp5_.arg_description = NULL;
#line 83 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	options[2] = _tmp5_;
#line 83 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp6_ = options[2];
#line 86 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp7_.long_name = NULL;
#line 86 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	options[3] = _tmp7_;
#line 86 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp8_ = options[3];
#line 88 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_application_add_main_option_entries ((GApplication*) self, options);
#line 90 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_signal_connect_data ((GApplication*) self, "handle-local-options", (GCallback) ___lambda118__g_application_handle_local_options, block21_data_ref (_data21_), (GClosureNotify) block21_data_unref, 0);
#line 69 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	options = (g_free (options), NULL);
#line 69 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	block21_data_unref (_data21_);
#line 69 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_data21_ = NULL;
#line 753 "glatex_app.c"
}


static void
glatex_app_startup_cb (GlatexApp* self)
{
	GMenuModel* manual_app_menu = NULL;
	GMenu* _tmp0_;
	GMenuModel* _tmp1_;
	GMenuModel* _tmp2_;
	AppSettings* _tmp4_;
	AppSettings* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
#line 117 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 119 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_application_hold ((GApplication*) self);
#line 121 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	latexila_utils_migrate_latexila_to_gnome_latex ();
#line 123 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_action_map_add_action_entries ((GActionMap*) self, GLATEX_APP__app_actions, G_N_ELEMENTS (GLATEX_APP__app_actions), self);
#line 124 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	latexila_latex_commands_add_action_infos ((GtkApplication*) self);
#line 126 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp0_ = gtk_application_get_menu_by_id ((GtkApplication*) self, "manual-app-menu");
#line 126 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp1_ = _g_object_ref0 ((GMenuModel*) _tmp0_);
#line 126 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	manual_app_menu = _tmp1_;
#line 127 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp2_ = manual_app_menu;
#line 127 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	if (_tmp2_ == NULL) {
#line 128 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		g_warning ("glatex_app.vala:128: manual-app-menu not available.");
#line 790 "glatex_app.c"
	}
#line 132 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	if (gtk_application_prefers_app_menu ((GtkApplication*) self)) {
#line 794 "glatex_app.c"
		GMenuModel* _tmp3_;
#line 134 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_tmp3_ = manual_app_menu;
#line 134 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		gtk_application_set_app_menu ((GtkApplication*) self, _tmp3_);
#line 800 "glatex_app.c"
	}
#line 137 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	latexila_utils_register_icons ();
#line 138 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	stock_icons_register_stock_icons ();
#line 139 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	glatex_app_setup_theme_extensions (self);
#line 140 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp4_ = app_settings_get_default ();
#line 140 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp5_ = _tmp4_;
#line 140 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_g_object_unref0 (_tmp5_);
#line 141 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	glatex_app_support_backward_search (self);
#line 142 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp6_ = glatex_app_get_accel_filename (self);
#line 142 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp7_ = _tmp6_;
#line 142 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	gtk_accel_map_load (_tmp7_);
#line 142 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_g_free0 (_tmp7_);
#line 144 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_application_release ((GApplication*) self);
#line 117 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_g_object_unref0 (manual_app_menu);
#line 828 "glatex_app.c"
}


static void
glatex_app_shutdown_cb (GlatexApp* self)
{
	Projects* _tmp0_;
	Projects* _tmp1_;
	MostUsedSymbols* _tmp2_;
	MostUsedSymbols* _tmp3_;
	gchar* accel_filename = NULL;
	gchar* _tmp4_;
	GFile* accel_file = NULL;
	GFile* _tmp5_;
	GError * _inner_error_ = NULL;
#line 147 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 149 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_application_hold ((GApplication*) self);
#line 151 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp0_ = projects_get_default ();
#line 151 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp1_ = _tmp0_;
#line 151 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	projects_save (_tmp1_);
#line 151 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_projects_unref0 (_tmp1_);
#line 152 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp2_ = most_used_symbols_get_default ();
#line 152 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp3_ = _tmp2_;
#line 152 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	most_used_symbols_save (_tmp3_);
#line 152 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_g_object_unref0 (_tmp3_);
#line 155 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp4_ = glatex_app_get_accel_filename (self);
#line 155 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	accel_filename = _tmp4_;
#line 156 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp5_ = g_file_new_for_path (accel_filename);
#line 156 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	accel_file = _tmp5_;
#line 872 "glatex_app.c"
	{
#line 159 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		latexila_utils_create_parent_directories (accel_file, &_inner_error_);
#line 159 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 878 "glatex_app.c"
			goto __catch26_g_error;
		}
#line 160 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		gtk_accel_map_save (accel_filename);
#line 883 "glatex_app.c"
	}
	goto __finally26;
	__catch26_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
#line 157 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_error_ = _inner_error_;
#line 157 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_inner_error_ = NULL;
#line 164 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_tmp6_ = _error_;
#line 164 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_tmp7_ = _tmp6_->message;
#line 164 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		g_warning ("glatex_app.vala:164: Error when saving accel file: %s", _tmp7_);
#line 157 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_g_error_free0 (_error_);
#line 903 "glatex_app.c"
	}
	__finally26:
#line 157 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 157 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_g_object_unref0 (accel_file);
#line 157 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_g_free0 (accel_filename);
#line 157 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 157 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		g_clear_error (&_inner_error_);
#line 157 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		return;
#line 918 "glatex_app.c"
	}
#line 167 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_application_release ((GApplication*) self);
#line 147 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_g_object_unref0 (accel_file);
#line 147 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_g_free0 (accel_filename);
#line 926 "glatex_app.c"
}


static void
glatex_app_new_document_cb (GlatexApp* self)
{
	MainWindow* window = NULL;
	MainWindow* _tmp0_;
	MainWindow* _tmp1_;
	MainWindow* _tmp3_;
	DocumentTab* _tmp4_;
	DocumentTab* _tmp5_;
#line 170 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 172 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp0_ = glatex_app_get_active_main_window (self);
#line 172 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	window = _tmp0_;
#line 173 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp1_ = window;
#line 173 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	if (_tmp1_ == NULL) {
#line 949 "glatex_app.c"
		MainWindow* _tmp2_;
#line 174 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_tmp2_ = glatex_app_create_window (self);
#line 174 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_g_object_unref0 (window);
#line 174 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		window = _tmp2_;
#line 957 "glatex_app.c"
	}
#line 176 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp3_ = window;
#line 176 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp4_ = main_window_create_tab (_tmp3_, TRUE);
#line 176 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp5_ = _tmp4_;
#line 176 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_g_object_unref0 (_tmp5_);
#line 170 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_g_object_unref0 (window);
#line 969 "glatex_app.c"
}


static void
glatex_app_preferences_cb (GlatexApp* self)
{
	MainWindow* _tmp0_;
	MainWindow* _tmp1_;
#line 179 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 181 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp0_ = glatex_app_get_active_main_window (self);
#line 181 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp1_ = _tmp0_;
#line 181 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	preferences_dialog_show_me ((GtkWindow*) _tmp1_);
#line 181 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_g_object_unref0 (_tmp1_);
#line 988 "glatex_app.c"
}


static void
glatex_app_manage_build_tools_cb (GlatexApp* self)
{
	MainWindow* _tmp0_;
	MainWindow* _tmp1_;
	BuildToolsPreferences* _tmp2_;
	BuildToolsPreferences* _tmp3_;
#line 184 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 186 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp0_ = glatex_app_get_active_main_window (self);
#line 186 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp1_ = _tmp0_;
#line 186 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp2_ = build_tools_preferences_new ((GtkWindow*) _tmp1_);
#line 186 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp3_ = _tmp2_;
#line 186 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_g_object_unref0 (_tmp3_);
#line 186 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_g_object_unref0 (_tmp1_);
#line 1013 "glatex_app.c"
}


static void
glatex_app_help_cb (GlatexApp* self)
{
	MainWindow* window = NULL;
	MainWindow* _tmp0_;
	GError * _inner_error_ = NULL;
#line 189 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 191 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp0_ = glatex_app_get_active_main_window (self);
#line 191 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	window = _tmp0_;
#line 1029 "glatex_app.c"
	{
#line 195 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		latexila_utils_show_uri ((GtkWidget*) window, "help:gnome-latex", (guint32) GDK_CURRENT_TIME, &_inner_error_);
#line 195 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1035 "glatex_app.c"
			goto __catch27_g_error;
		}
	}
	goto __finally27;
	__catch27_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
#line 193 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		e = _inner_error_;
#line 193 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_inner_error_ = NULL;
#line 199 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_tmp1_ = e;
#line 199 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_tmp2_ = _tmp1_->message;
#line 199 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		g_warning ("glatex_app.vala:199: Impossible to open the documentation: %s", _tmp2_);
#line 193 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_g_error_free0 (e);
#line 1057 "glatex_app.c"
	}
	__finally27:
#line 193 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 193 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_g_object_unref0 (window);
#line 193 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 193 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		g_clear_error (&_inner_error_);
#line 193 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		return;
#line 1070 "glatex_app.c"
	}
#line 189 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_g_object_unref0 (window);
#line 1074 "glatex_app.c"
}


static void
glatex_app_about_cb (GlatexApp* self)
{
	gchar* comments = NULL;
	gchar* _tmp0_;
	gchar* copyright = NULL;
	gchar* _tmp1_;
	gchar* website = NULL;
	gchar* _tmp2_;
	gchar** authors = NULL;
	gchar* _tmp3_;
	gchar** _tmp4_;
	gint authors_length1;
	gint _authors_size_;
	gchar** artists = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gint artists_length1;
	gint _artists_size_;
	MainWindow* _tmp11_;
	MainWindow* _tmp12_;
#line 203 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 205 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp0_ = g_strdup (_ ("GNOME LaTeX is a LaTeX editor for the GNOME desktop"));
#line 205 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	comments = _tmp0_;
#line 207 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp1_ = g_strdup ("Copyright 2009-2018 – Sébastien Wilmet");
#line 207 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	copyright = _tmp1_;
#line 209 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp2_ = g_strdup ("https://wiki.gnome.org/Apps/GNOME-LaTeX");
#line 209 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	website = _tmp2_;
#line 211 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp3_ = g_strdup ("Sébastien Wilmet <swilmet@gnome.org>");
#line 211 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp4_ = g_new0 (gchar*, 2 + 1);
#line 211 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp4_[0] = _tmp3_;
#line 211 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp4_[1] = NULL;
#line 211 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	authors = _tmp4_;
#line 211 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	authors_length1 = 2;
#line 211 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_authors_size_ = authors_length1;
#line 217 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp5_ = g_strdup ("Eric Forgeot <e.forgeot@laposte.net>");
#line 217 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp6_ = g_strdup ("Sébastien Wilmet <swilmet@gnome.org>");
#line 217 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp7_ = g_strdup ("Alexander Wilms <f.alexander.wilms@gmail.com>");
#line 217 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp8_ = g_strdup ("The Kile Team http://kile.sourceforge.net/");
#line 217 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp9_ = g_strdup ("Gedit LaTeX Plugin https://wiki.gnome.org/Apps/Gedit/LaTeXPlugin");
#line 217 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp10_ = g_new0 (gchar*, 6 + 1);
#line 217 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp10_[0] = _tmp5_;
#line 217 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp10_[1] = _tmp6_;
#line 217 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp10_[2] = _tmp7_;
#line 217 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp10_[3] = _tmp8_;
#line 217 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp10_[4] = _tmp9_;
#line 217 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp10_[5] = NULL;
#line 217 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	artists = _tmp10_;
#line 217 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	artists_length1 = 6;
#line 217 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_artists_size_ = artists_length1;
#line 227 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp11_ = glatex_app_get_active_main_window (self);
#line 227 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp12_ = _tmp11_;
#line 227 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	gtk_show_about_dialog ((GtkWindow*) _tmp12_, "program-name", PACKAGE_NAME, "version", PACKAGE_VERSION, "authors", authors, "artists", artists, "comments", comments, "copyright", copyright, "license-type", GTK_LICENSE_GPL_3_0, "title", _ ("About GNOME LaTeX"), "translator-credits", _ ("translator-credits"), "website", website, "logo-icon-name", "gnome-latex", NULL);
#line 227 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_g_object_unref0 (_tmp12_);
#line 203 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	artists = (_vala_array_free (artists, artists_length1, (GDestroyNotify) g_free), NULL);
#line 203 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
#line 203 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_g_free0 (website);
#line 203 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_g_free0 (copyright);
#line 203 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_g_free0 (comments);
#line 1179 "glatex_app.c"
}


static void
glatex_app_quit_cb (GlatexApp* self)
{
	gboolean cont = FALSE;
	gboolean _tmp5_;
#line 242 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 244 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_application_hold ((GApplication*) self);
#line 246 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	cont = TRUE;
#line 247 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	while (TRUE) {
#line 1196 "glatex_app.c"
		gboolean _tmp0_;
		MainWindow* main_window = NULL;
		MainWindow* _tmp1_;
		MainWindow* _tmp2_;
		MainWindow* _tmp3_;
		MainWindow* _tmp4_;
#line 247 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_tmp0_ = cont;
#line 247 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		if (!_tmp0_) {
#line 247 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
			break;
#line 1209 "glatex_app.c"
		}
#line 249 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_tmp1_ = glatex_app_get_active_main_window (self);
#line 249 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		main_window = _tmp1_;
#line 250 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_tmp2_ = main_window;
#line 250 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		if (_tmp2_ == NULL) {
#line 251 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
			_g_object_unref0 (main_window);
#line 251 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
			break;
#line 1223 "glatex_app.c"
		}
#line 253 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_tmp3_ = main_window;
#line 253 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		gtk_window_present ((GtkWindow*) _tmp3_);
#line 254 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_tmp4_ = main_window;
#line 254 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		cont = main_window_quit (_tmp4_);
#line 247 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_g_object_unref0 (main_window);
#line 1235 "glatex_app.c"
	}
#line 257 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp5_ = cont;
#line 257 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	if (_tmp5_) {
#line 259 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		while (TRUE) {
#line 1243 "glatex_app.c"
			GtkWindow* _tmp6_;
			GtkWindow* _tmp7_;
			GtkWindow* _tmp8_;
			GtkWindow* _tmp9_;
#line 259 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
			_tmp6_ = gtk_application_get_active_window ((GtkApplication*) self);
#line 259 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
			_tmp7_ = _tmp6_;
#line 259 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
			if (!(_tmp7_ != NULL)) {
#line 259 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				break;
#line 1256 "glatex_app.c"
			}
#line 260 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
			_tmp8_ = gtk_application_get_active_window ((GtkApplication*) self);
#line 260 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
			_tmp9_ = _tmp8_;
#line 260 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
			gtk_widget_destroy ((GtkWidget*) _tmp9_);
#line 1264 "glatex_app.c"
		}
	}
#line 263 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_application_release ((GApplication*) self);
#line 1269 "glatex_app.c"
}


static void
_glatex_app_update_theme_g_object_notify (GObject* _sender,
                                          GParamSpec* pspec,
                                          gpointer self)
{
#line 269 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	glatex_app_update_theme ((GlatexApp*) self);
#line 1280 "glatex_app.c"
}


static void
glatex_app_setup_theme_extensions (GlatexApp* self)
{
	GtkSettings* settings = NULL;
	GtkSettings* _tmp0_;
	GtkSettings* _tmp1_;
#line 266 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 268 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp0_ = gtk_settings_get_default ();
#line 268 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 268 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	settings = _tmp1_;
#line 269 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_signal_connect_object ((GObject*) settings, "notify::gtk-theme-name", (GCallback) _glatex_app_update_theme_g_object_notify, self, 0);
#line 270 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	glatex_app_update_theme (self);
#line 266 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_g_object_unref0 (settings);
#line 1304 "glatex_app.c"
}


static void
glatex_app_update_theme (GlatexApp* self)
{
	GtkSettings* settings = NULL;
	GtkSettings* _tmp0_;
	GtkSettings* _tmp1_;
	GdkScreen* screen = NULL;
	GdkScreen* _tmp2_;
	GdkScreen* _tmp3_;
	GtkSettings* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	GError * _inner_error_ = NULL;
#line 273 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 275 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp0_ = gtk_settings_get_default ();
#line 275 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 275 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	settings = _tmp1_;
#line 276 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp2_ = gdk_screen_get_default ();
#line 276 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 276 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	screen = _tmp3_;
#line 278 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp4_ = settings;
#line 278 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_object_get (_tmp4_, "gtk-theme-name", &_tmp5_, NULL);
#line 278 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp6_ = _tmp5_;
#line 278 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp7_ = _tmp6_;
#line 278 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp8_ = g_strcmp0 (_tmp7_, "Adwaita") == 0;
#line 278 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_g_free0 (_tmp7_);
#line 278 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	if (_tmp8_) {
#line 1351 "glatex_app.c"
		GtkCssProvider* _tmp9_;
		GdkScreen* _tmp16_;
		GtkCssProvider* _tmp17_;
#line 280 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_tmp9_ = glatex_app__provider;
#line 280 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		if (_tmp9_ == NULL) {
#line 1359 "glatex_app.c"
			GtkCssProvider* _tmp10_;
			GFile* file = NULL;
			GFile* _tmp11_;
#line 282 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
			_tmp10_ = gtk_css_provider_new ();
#line 282 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
			_g_object_unref0 (glatex_app__provider);
#line 282 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
			glatex_app__provider = _tmp10_;
#line 283 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
			_tmp11_ = g_file_new_for_uri ("resource:///org/gnome/gnome-latex/ui/gnome-latex.adwaita.css");
#line 283 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
			file = _tmp11_;
#line 1373 "glatex_app.c"
			{
				GtkCssProvider* _tmp12_;
				GFile* _tmp13_;
#line 286 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				_tmp12_ = glatex_app__provider;
#line 286 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				_tmp13_ = file;
#line 286 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				gtk_css_provider_load_from_file (_tmp12_, _tmp13_, &_inner_error_);
#line 286 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1385 "glatex_app.c"
					goto __catch28_g_error;
				}
			}
			goto __finally28;
			__catch28_g_error:
			{
				GError* e = NULL;
				GError* _tmp14_;
				const gchar* _tmp15_;
#line 284 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				e = _inner_error_;
#line 284 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				_inner_error_ = NULL;
#line 290 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				_tmp14_ = e;
#line 290 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				_tmp15_ = _tmp14_->message;
#line 290 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				g_warning ("glatex_app.vala:290: Cannot load CSS: %s", _tmp15_);
#line 284 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				_g_error_free0 (e);
#line 1407 "glatex_app.c"
			}
			__finally28:
#line 284 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 284 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				_g_object_unref0 (file);
#line 284 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				_g_object_unref0 (screen);
#line 284 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				_g_object_unref0 (settings);
#line 284 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 284 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				g_clear_error (&_inner_error_);
#line 284 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				return;
#line 1424 "glatex_app.c"
			}
#line 280 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
			_g_object_unref0 (file);
#line 1428 "glatex_app.c"
		}
#line 294 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_tmp16_ = screen;
#line 294 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_tmp17_ = glatex_app__provider;
#line 294 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		gtk_style_context_add_provider_for_screen (_tmp16_, (GtkStyleProvider*) _tmp17_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#line 1436 "glatex_app.c"
	} else {
		GtkCssProvider* _tmp18_;
#line 297 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_tmp18_ = glatex_app__provider;
#line 297 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		if (_tmp18_ != NULL) {
#line 1443 "glatex_app.c"
			GdkScreen* _tmp19_;
			GtkCssProvider* _tmp20_;
#line 299 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
			_tmp19_ = screen;
#line 299 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
			_tmp20_ = glatex_app__provider;
#line 299 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
			gtk_style_context_remove_provider_for_screen (_tmp19_, (GtkStyleProvider*) _tmp20_);
#line 300 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
			_g_object_unref0 (glatex_app__provider);
#line 300 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
			glatex_app__provider = NULL;
#line 1456 "glatex_app.c"
		}
	}
#line 273 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_g_object_unref0 (screen);
#line 273 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_g_object_unref0 (settings);
#line 1463 "glatex_app.c"
}


GeeList*
glatex_app_get_documents (GlatexApp* self)
{
	GeeList* result = NULL;
	GeeList* all_documents = NULL;
	GeeLinkedList* _tmp0_;
	GList* _tmp1_;
#line 305 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 307 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp0_ = gee_linked_list_new (TYPE_DOCUMENT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 307 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	all_documents = (GeeList*) _tmp0_;
#line 308 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp1_ = gtk_application_get_windows ((GtkApplication*) self);
#line 1482 "glatex_app.c"
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
#line 308 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		window_collection = _tmp1_;
#line 308 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
#line 1490 "glatex_app.c"
			GtkWindow* _tmp2_;
			GtkWindow* window = NULL;
#line 308 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
			_tmp2_ = _g_object_ref0 ((GtkWindow*) window_it->data);
#line 308 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
			window = _tmp2_;
#line 1497 "glatex_app.c"
			{
				GtkWindow* _tmp3_;
#line 310 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				_tmp3_ = window;
#line 310 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_MAIN_WINDOW)) {
#line 1504 "glatex_app.c"
					MainWindow* main_window = NULL;
					GtkWindow* _tmp4_;
					MainWindow* _tmp5_;
					GeeList* _tmp6_;
					MainWindow* _tmp7_;
					GeeList* _tmp8_;
					GeeList* _tmp9_;
#line 312 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
					_tmp4_ = window;
#line 312 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
					_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, TYPE_MAIN_WINDOW) ? ((MainWindow*) _tmp4_) : NULL);
#line 312 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
					main_window = _tmp5_;
#line 313 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
					_tmp6_ = all_documents;
#line 313 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
					_tmp7_ = main_window;
#line 313 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
					_tmp8_ = main_window_get_documents (_tmp7_);
#line 313 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
					_tmp9_ = _tmp8_;
#line 313 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
					gee_collection_add_all ((GeeCollection*) _tmp6_, (GeeCollection*) _tmp9_);
#line 313 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
					_g_object_unref0 (_tmp9_);
#line 310 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
					_g_object_unref0 (main_window);
#line 1532 "glatex_app.c"
				}
#line 308 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				_g_object_unref0 (window);
#line 1536 "glatex_app.c"
			}
		}
	}
#line 317 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	result = all_documents;
#line 317 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	return result;
#line 1544 "glatex_app.c"
}


GeeList*
glatex_app_get_views (GlatexApp* self)
{
	GeeList* result = NULL;
	GeeList* all_views = NULL;
	GeeLinkedList* _tmp0_;
	GList* _tmp1_;
#line 321 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 323 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp0_ = gee_linked_list_new (TYPE_DOCUMENT_VIEW, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 323 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	all_views = (GeeList*) _tmp0_;
#line 324 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp1_ = gtk_application_get_windows ((GtkApplication*) self);
#line 1563 "glatex_app.c"
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
#line 324 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		window_collection = _tmp1_;
#line 324 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
#line 1571 "glatex_app.c"
			GtkWindow* _tmp2_;
			GtkWindow* window = NULL;
#line 324 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
			_tmp2_ = _g_object_ref0 ((GtkWindow*) window_it->data);
#line 324 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
			window = _tmp2_;
#line 1578 "glatex_app.c"
			{
				GtkWindow* _tmp3_;
#line 326 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				_tmp3_ = window;
#line 326 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_MAIN_WINDOW)) {
#line 1585 "glatex_app.c"
					MainWindow* main_window = NULL;
					GtkWindow* _tmp4_;
					MainWindow* _tmp5_;
					GeeList* _tmp6_;
					MainWindow* _tmp7_;
					GeeList* _tmp8_;
					GeeList* _tmp9_;
#line 328 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
					_tmp4_ = window;
#line 328 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
					_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, TYPE_MAIN_WINDOW) ? ((MainWindow*) _tmp4_) : NULL);
#line 328 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
					main_window = _tmp5_;
#line 329 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
					_tmp6_ = all_views;
#line 329 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
					_tmp7_ = main_window;
#line 329 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
					_tmp8_ = main_window_get_views (_tmp7_);
#line 329 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
					_tmp9_ = _tmp8_;
#line 329 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
					gee_collection_add_all ((GeeCollection*) _tmp6_, (GeeCollection*) _tmp9_);
#line 329 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
					_g_object_unref0 (_tmp9_);
#line 326 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
					_g_object_unref0 (main_window);
#line 1613 "glatex_app.c"
				}
#line 324 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				_g_object_unref0 (window);
#line 1617 "glatex_app.c"
			}
		}
	}
#line 333 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	result = all_views;
#line 333 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	return result;
#line 1625 "glatex_app.c"
}


MainWindow*
glatex_app_create_window (GlatexApp* self)
{
	MainWindow* result = NULL;
	TeplAbstractFactoryVala* factory = NULL;
	TeplAbstractFactory* _tmp0_;
	TeplAbstractFactoryVala* _tmp1_;
	GtkApplicationWindow* _tmp2_;
	MainWindow* _tmp3_;
#line 336 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 338 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp0_ = tepl_abstract_factory_get_singleton ();
#line 338 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, tepl_abstract_factory_vala_get_type ()) ? ((TeplAbstractFactoryVala*) _tmp0_) : NULL);
#line 338 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	factory = _tmp1_;
#line 341 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp2_ = tepl_abstract_factory_vala_create_main_window_vala (factory, (GtkApplication*) self);
#line 341 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, TYPE_MAIN_WINDOW) ? ((MainWindow*) _tmp2_) : NULL;
#line 341 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	if (_tmp3_ == NULL) {
#line 341 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_g_object_unref0 (_tmp2_);
#line 1654 "glatex_app.c"
	}
#line 341 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	result = _tmp3_;
#line 341 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_g_object_unref0 (factory);
#line 341 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	return result;
#line 1662 "glatex_app.c"
}


void
glatex_app_open_documents (GlatexApp* self,
                           GFile** files,
                           int files_length1)
{
	MainWindow* main_window = NULL;
	MainWindow* _tmp0_;
	MainWindow* _tmp1_;
	gboolean jump_to = FALSE;
	MainWindow* _tmp9_;
#line 344 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 346 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp0_ = glatex_app_get_active_main_window (self);
#line 346 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	main_window = _tmp0_;
#line 347 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp1_ = main_window;
#line 347 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	if (_tmp1_ == NULL) {
#line 1686 "glatex_app.c"
		MainWindow* _tmp2_;
#line 348 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_tmp2_ = glatex_app_create_window (self);
#line 348 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_g_object_unref0 (main_window);
#line 348 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		main_window = _tmp2_;
#line 1694 "glatex_app.c"
	}
#line 350 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	jump_to = TRUE;
#line 1698 "glatex_app.c"
	{
		GFile** file_collection = NULL;
		gint file_collection_length1 = 0;
		gint _file_collection_size_ = 0;
		gint file_it = 0;
#line 351 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		file_collection = files;
#line 351 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		file_collection_length1 = files_length1;
#line 351 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		for (file_it = 0; file_it < files_length1; file_it = file_it + 1) {
#line 1710 "glatex_app.c"
			GFile* _tmp3_;
			GFile* file = NULL;
#line 351 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
			_tmp3_ = _g_object_ref0 (file_collection[file_it]);
#line 351 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
			file = _tmp3_;
#line 1717 "glatex_app.c"
			{
				MainWindow* _tmp4_;
				GFile* _tmp5_;
				gboolean _tmp6_;
				DocumentTab* _tmp7_;
				DocumentTab* _tmp8_;
#line 353 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				_tmp4_ = main_window;
#line 353 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				_tmp5_ = file;
#line 353 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				_tmp6_ = jump_to;
#line 353 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				_tmp7_ = main_window_open_document (_tmp4_, _tmp5_, _tmp6_);
#line 353 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				_tmp8_ = _tmp7_;
#line 353 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				_g_object_unref0 (_tmp8_);
#line 354 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				jump_to = FALSE;
#line 351 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
				_g_object_unref0 (file);
#line 1740 "glatex_app.c"
			}
		}
	}
#line 357 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp9_ = main_window;
#line 357 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	gtk_window_present ((GtkWindow*) _tmp9_);
#line 344 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_g_object_unref0 (main_window);
#line 1750 "glatex_app.c"
}


static gchar*
glatex_app_get_accel_filename (GlatexApp* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
#line 360 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 362 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp0_ = g_get_user_config_dir ();
#line 362 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp1_ = g_build_filename (_tmp0_, "gnome-latex", "accels", NULL);
#line 362 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	result = _tmp1_;
#line 362 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	return result;
#line 1770 "glatex_app.c"
}


static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result = NULL;
#line 1456 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1457 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	result = self;
#line 1457 "/home/seb/jhbuild/share/vala-0.40/vapi/glib-2.0.vapi"
	return result;
#line 1784 "glatex_app.c"
}


static void
__lambda119_ (GlatexApp* self,
              const gchar* tex_uri,
              gint line,
              guint timestamp)
{
	GFile* tex_file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	MainWindow* main_window = NULL;
	MainWindow* _tmp5_;
	MainWindow* _tmp6_;
#line 370 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_return_if_fail (tex_uri != NULL);
#line 372 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp0_ = g_file_new_for_uri (tex_uri);
#line 372 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	tex_file = _tmp0_;
#line 373 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp1_ = tex_file;
#line 373 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	if (!g_file_query_exists (_tmp1_, NULL)) {
#line 1810 "glatex_app.c"
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
#line 375 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_tmp2_ = string_to_string (tex_uri);
#line 375 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_tmp3_ = g_strconcat ("Backward search: the file \"", _tmp2_, "\" doesn't exist.", NULL);
#line 375 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_tmp4_ = _tmp3_;
#line 375 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		g_warning ("glatex_app.vala:375: %s", _tmp4_);
#line 375 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_g_free0 (_tmp4_);
#line 376 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_g_object_unref0 (tex_file);
#line 376 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		return;
#line 1828 "glatex_app.c"
	}
#line 381 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp5_ = glatex_app_get_active_main_window (self);
#line 381 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	main_window = _tmp5_;
#line 382 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp6_ = main_window;
#line 382 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	if (_tmp6_ != NULL) {
#line 1838 "glatex_app.c"
		MainWindow* _tmp7_;
		GFile* _tmp8_;
		MainWindow* _tmp9_;
#line 384 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_tmp7_ = main_window;
#line 384 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_tmp8_ = tex_file;
#line 384 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		main_window_jump_to_file_position (_tmp7_, _tmp8_, line, line);
#line 385 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		_tmp9_ = main_window;
#line 385 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
		gtk_window_present_with_time ((GtkWindow*) _tmp9_, (guint32) timestamp);
#line 1852 "glatex_app.c"
	}
#line 370 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_g_object_unref0 (main_window);
#line 370 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_g_object_unref0 (tex_file);
#line 1858 "glatex_app.c"
}


static void
___lambda119__latexila_synctex_backward_search (LatexilaSynctex* _sender,
                                                const gchar* tex_uri,
                                                gint line,
                                                guint timestamp,
                                                gpointer self)
{
#line 370 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	__lambda119_ ((GlatexApp*) self, tex_uri, line, timestamp);
#line 1871 "glatex_app.c"
}


static void
glatex_app_support_backward_search (GlatexApp* self)
{
	LatexilaSynctex* synctex = NULL;
	LatexilaSynctex* _tmp0_;
	LatexilaSynctex* _tmp1_;
#line 366 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_return_if_fail (self != NULL);
#line 368 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp0_ = latexila_synctex_get_instance ();
#line 368 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 368 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	synctex = _tmp1_;
#line 370 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	g_signal_connect_object (synctex, "backward-search", (GCallback) ___lambda119__latexila_synctex_backward_search, self, 0);
#line 366 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	_g_object_unref0 (synctex);
#line 1893 "glatex_app.c"
}


static void
glatex_app_class_init (GlatexAppClass * klass)
{
#line 22 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	glatex_app_parent_class = g_type_class_peek_parent (klass);
#line 22 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	G_OBJECT_CLASS (klass)->finalize = glatex_app_finalize;
#line 1904 "glatex_app.c"
}


static void
glatex_app_instance_init (GlatexApp * self)
{
}


static void
glatex_app_finalize (GObject * obj)
{
	GlatexApp * self;
#line 22 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GLATEX_APP, GlatexApp);
#line 22 "/home/seb/gnome/gnome-latex/src/glatex_app.vala"
	G_OBJECT_CLASS (glatex_app_parent_class)->finalize (obj);
#line 1922 "glatex_app.c"
}


GType
glatex_app_get_type (void)
{
	static volatile gsize glatex_app_type_id__volatile = 0;
	if (g_once_init_enter (&glatex_app_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GlatexAppClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) glatex_app_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GlatexApp), 0, (GInstanceInitFunc) glatex_app_instance_init, NULL };
		GType glatex_app_type_id;
		glatex_app_type_id = g_type_register_static (gtk_application_get_type (), "GlatexApp", &g_define_type_info, 0);
		g_once_init_leave (&glatex_app_type_id__volatile, glatex_app_type_id);
	}
	return glatex_app_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
#line 27 "/home/seb/gnome/gnome-latex/src/build_tools_preferences.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 1947 "glatex_app.c"
		int i;
#line 27 "/home/seb/gnome/gnome-latex/src/build_tools_preferences.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 27 "/home/seb/gnome/gnome-latex/src/build_tools_preferences.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 27 "/home/seb/gnome/gnome-latex/src/build_tools_preferences.vala"
				destroy_func (((gpointer*) array)[i]);
#line 1955 "glatex_app.c"
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
#line 27 "/home/seb/gnome/gnome-latex/src/build_tools_preferences.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 27 "/home/seb/gnome/gnome-latex/src/build_tools_preferences.vala"
	g_free (array);
#line 1971 "glatex_app.c"
}



